/*
  Copyright (C) 2003  Taiga Yonekura, taiga@col.hi-ho.ne.jp

  For more information about this appliation please look at:
   http://jankeyapp-z.sourceforge.jp/

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/
//#include <unistd.h>
#include <qapplication.h>
#include "Display.h"
#include "config.h"

// Time Interval until appear next Block (msec)
#define NORMAL      4000
#define HARD        2000
#define SUPERHARD   1000

#include "./images/data.c"
#include "./images/numImg.c"

#define BOOT_LOGOSTRING "PRESENTS"

CDisplay::CDisplay()
{

  m_dispON = false;
  m_WaitTime = NORMAL / 100;//TO DO
  m_nextBlkWait = NORMAL / 100;

  /* load image data */
  m_titleBMP[0].loadFromData(TITLE1_IMG_DATA, sizeof (TITLE1_IMG_DATA));
  m_titleBMP[1].loadFromData(TITLE2_IMG_DATA, sizeof (TITLE2_IMG_DATA));
  m_titleBMP[2].loadFromData(LOGO_IMG_DATA, sizeof (LOGO_IMG_DATA));

  m_blockBMP[0].loadFromData(BLK00_IMG_DATA, sizeof (BLK00_IMG_DATA));
  m_blockBMP[1].loadFromData(BLK01_IMG_DATA, sizeof (BLK01_IMG_DATA));
  m_blockBMP[2].loadFromData(BLK02_IMG_DATA, sizeof (BLK02_IMG_DATA));
  m_blockBMP[3].loadFromData(BLK03_IMG_DATA, sizeof (BLK03_IMG_DATA));
  m_blockBMP[4].loadFromData(BLK04_IMG_DATA, sizeof (BLK04_IMG_DATA));
  
  m_bombBMP[0].loadFromData(BOMB00_IMG_DATA, sizeof (BOMB00_IMG_DATA));
  m_bombBMP[1].loadFromData(BOMB01_IMG_DATA, sizeof (BOMB01_IMG_DATA));
  //  m_bombBMP[2].loadFromData(BOMB02_IMG_DATA, sizeof (BOMB02_IMG_DATA));

  // m_msgBMP[0].loadFromData(gameover_data_, sizeof (gameover_data_));

  // NumberImages
  m_numBMP[0].loadFromData(NUM0_IMG_DATA, sizeof (NUM0_IMG_DATA));
  m_numBMP[1].loadFromData(NUM1_IMG_DATA, sizeof (NUM1_IMG_DATA));
  m_numBMP[2].loadFromData(NUM2_IMG_DATA, sizeof (NUM2_IMG_DATA));
  m_numBMP[3].loadFromData(NUM3_IMG_DATA, sizeof (NUM3_IMG_DATA));
  m_numBMP[4].loadFromData(NUM4_IMG_DATA, sizeof (NUM4_IMG_DATA));
  m_numBMP[5].loadFromData(NUM5_IMG_DATA, sizeof (NUM5_IMG_DATA));
  m_numBMP[6].loadFromData(NUM6_IMG_DATA, sizeof (NUM6_IMG_DATA));
  m_numBMP[7].loadFromData(NUM7_IMG_DATA, sizeof (NUM7_IMG_DATA));
  m_numBMP[8].loadFromData(NUM8_IMG_DATA, sizeof (NUM8_IMG_DATA));
  m_numBMP[9].loadFromData(NUM9_IMG_DATA, sizeof (NUM9_IMG_DATA));

  // Boot Logo
  m_BootLogBMP.loadFromData(BOOTLOGO_IMG_DATA, sizeof (BOOTLOGO_IMG_DATA));

  //mm21 image
  m_mmBMP.loadFromData(MM_IMG_DATA, sizeof (MM_IMG_DATA));
  m_backBMP.loadFromData(BACK1_IMG_DATA, sizeof (BACK1_IMG_DATA));

}

void CDisplay::drawNextBlock(QPainter *paint, CField &field)
{
	
  int i;
  int max =field.getNextBlockCount();
  QPixmap *pPixMap;

  for( i = 0; i < max; i++ ){

    CCell &cell = field.getNextBlock(i);
    switch( cell.GetType() ){

    case NONE:
      pPixMap = NULL;
      break;

    case TYPE1:
      pPixMap =  &m_blockBMP[0];
      break;

    case TYPE2:
      pPixMap =  &m_blockBMP[1];
      break;

    case TYPE3:
      pPixMap =  &m_blockBMP[2];
      break;

    case TYPE4:
      pPixMap =  &m_blockBMP[3];
      break;

    default :
      pPixMap =  &m_blockBMP[4];
    }

    if(pPixMap){
      paint->drawPixmap( cell.GetPosX(), cell.GetPosY(), *pPixMap);
    }

  }

}
void CDisplay::drawField(QPainter *paint, CField &field)
{

  int i;
  int max = field.getFiledBlockHeight() * field.getFiledBlockWidth();
  QPixmap *pPixMap = NULL;

  for(i = 0; i < max; i++){

    CCell &cell = field.getFieldBlock(i);

    switch( cell.GetType() ){
    case NONE:
      pPixMap = NULL;
      break;

    case TYPE1:
      pPixMap =  &m_blockBMP[0];
      break;

    case TYPE2:
      pPixMap =  &m_blockBMP[1];
      break;

    case TYPE3:
      pPixMap =  &m_blockBMP[2];
      break;

    case TYPE4:
      pPixMap =  &m_blockBMP[3];
      break;

    case BOMB:
      pPixMap = &m_bombBMP[0];
      break;

      // TO DO
      //    default :
      //pPixMap =  &m_blockBMP[4];

    }

    if( cell.IsSameBlock() ){
      // explosion image
      pPixMap = &m_bombBMP[1];
    }

    if(pPixMap){
      paint->drawPixmap( cell.GetPosX(), cell.GetPosY(), *pPixMap);
    }
    
  }

}
//
// display score
//
void CDisplay::drawScore(QPainter *paint, int score)
{
  QString str = "SCORE";

  StringDisplay.Draw(paint, &str, SCORE_STRPOSX, SCORE_STRPOSY);
  drawNumber( paint, score, SCORE_POSX, SCORE_POSY );

}
void CDisplay::drawPlayField(QPainter *paint, CField *field, CStatus *pStatus,
			     int width, int height)
{

	if( !m_dispON ) return;

	drawBackGround(paint, width, height);
	drawBlockFrame(paint);
	drawField( paint, *field );

	if( pStatus->getStatus() == STSGAMEOVER){
	  drawGemeOver( paint );
	}

	if( m_nextBlkWait == 0 ){
		if(pStatus->getStatus() == STSIDLE){

		  for(int i=0; i < pStatus->getUpcount();i++){
			field->setNextBlock();
			if( field->upBlock() ) {
				//
				pStatus->setStatus(STSGAMEOVER);
				pStatus->setHiScore(pStatus->getScore());
				break;
			}
		  }
		  m_nextBlkWait = m_WaitTime;
		}
	} else {
		m_nextBlkWait--;
	}
	
	switch(pStatus->getStatus()){
		
	case STSDELETEBLK:
		field->DeletSameBlk();
		pStatus->setStatus(STSDOWNBLK);
		break;

	case STSDOWNBLK:
		field->downBlk();
		pStatus->setStatus(STSSLIDEBLK);
		break;
		
	case STSSLIDEBLK:
		field->slideBlk();
		pStatus->setStatus(STSIDLE);
		break;
	}

	//drawBlockFrame(paint);
		
}
//
//
//
void CDisplay::drawHiScore(QPainter *paint, int score)
{
  QString str = "HI-SOCRE";

  StringDisplay.Draw(paint, &str, HISCORE_STRPOSX, HISCORE_STRPOSY);
  drawNumber( paint, score, HISCORE_POSX, HISCORE_POSY );
}
//
//
//
void CDisplay::setNextBlkWaitTime(int time)
{
  m_WaitTime = time;
}
//
//
//
void CDisplay::displayOff()
{
  m_dispON = false;
}
void CDisplay::displayOn()
{
  m_dispON = true;
}
void CDisplay::drawTitle( QPainter *paint ,int width, int height)
{

  QColor white(255, 255, 255);
  QColor black(0,0,0);

  paint->fillRect(0, 0, width, height, black );

  paint->setPen( white );
  paint->drawText( Center_x(&QString(COPYLIGHT1)), COPYLIGHT1_POSY, COPYLIGHT1);
  paint->drawText( Center_x(&QString(COPYLIGHT2)), COPYLIGHT2_POSY, COPYLIGHT2);

  paint->drawPixmap( TITLE1_POSX, TITLE1_POSY, m_titleBMP[0]);
  paint->drawPixmap( TITLE2_POSX, TITLE2_POSY, m_titleBMP[1]);
  paint->drawPixmap( TITLE3_POSX, TITLE3_POSY, m_titleBMP[0]);

  paint->drawPixmap( TITLE0_POSX, TITLE0_POSY, m_titleBMP[2]);

}
//
//
//
void CDisplay::drawGemeOver( QPainter *paint )
{
 
  QString str = "GAMEOVER";
  StringDisplay.Draw( paint, &str, GAMEOVER_POSX, GAMEOVER_POSY );

}
void  CDisplay::drawBackGround(QPainter *paint, int width, int height)
{

  QColor back(0x66,0xCC,0xFF);

  paint->fillRect(0, 0, width, height, back);
  paint->drawPixmap( BUILDING_BACK_X, BUILDING_BACK_Y, m_backBMP );
  DrawBuilding(paint);

}
void CDisplay::drawNumber(QPainter *paint, int num, int startx, int starty)
{
	int i;
	int numtype;
	int pos;
	int imgwidth = 15;

	for(i = 0, pos = startx; ; i++,pos -= imgwidth){
		
	  if((i != 0) && (num == 0)){
	    break;
	  }

	  numtype = num % 10;

	  /* select number image and draw */
	  switch(numtype){
	  case 0:
	    paint->drawPixmap(pos, starty, m_numBMP[0]);
	    break;
	  case 1:
	    paint->drawPixmap(pos, starty, m_numBMP[1]);
	    break;
	  case 2:
	    paint->drawPixmap(pos, starty, m_numBMP[2]);
	    break;
	  case 3:
	    paint->drawPixmap(pos, starty, m_numBMP[3]);
	    break;
	  case 4:
	    paint->drawPixmap(pos, starty, m_numBMP[4]);
	    break;
	  case 5:
	    paint->drawPixmap(pos, starty, m_numBMP[5]);
	    break;
	  case 6:
	    paint->drawPixmap(pos, starty, m_numBMP[6]);
	    break;
	  case 7:
	    paint->drawPixmap(pos, starty, m_numBMP[7]);
	    break;
	  case 8:
	    paint->drawPixmap(pos, starty, m_numBMP[8]);
	    break;
	  case 9:
	    paint->drawPixmap(pos, starty, m_numBMP[9]);
	    break;
	  }
      num = num / 10; /* next */

      }
}
void CDisplay::drawBlockFrame(QPainter *paint)
{
  QColor lineColor(255, 255, 255);

  paint->fillRect( FIELD_OFFSET_X, FIELD_OFFSET_Y, 
  		   FIELD_WIDTH * FIELD_NUM_X,FIELD_HEIGHT * FIELD_NUM_Y,QColor(0,0,0));
  paint->setPen( lineColor  );
  paint->drawRect( FIELD_OFFSET_X-1, FIELD_OFFSET_Y-1, 
		   FIELD_WIDTH * FIELD_NUM_X+2,FIELD_HEIGHT * FIELD_NUM_Y+2);
}
void CDisplay::DrawHiScoreList(QPainter *paint, CScoreMng *scrMng, 
			       int width, int height )
{

  QString str;
  int score;

  drawScoreBackGround( paint, width, height );
  
  str = QString("BEST");
  StringDisplay.Draw( paint, &str, 
		      HISCORE_LISTPOSX + HISCORE_BEST_OFFSET_X, 
		      HISCORE_LISTPOSY - HISCORE_BEST_OFFSET_Y );

  for( int i = 1; i <=  REGIST_MAX; i++ ){
    scrMng->GetHiScore( i, &str, &score );
    StringDisplay.Draw( paint, &str, 
			HISCORE_LISTPOSX, 
			HISCORE_LISTPOSY + HISCORE_OFFSET_Y * i  );
    drawNumber( paint, score, 
		HISCORE_LISTPOSX + HISCORE_OFFSET_X, 
		HISCORE_LISTPOSY + HISCORE_OFFSET_Y * i );
  }

}
//
// Draw Boot Logo
//
void CDisplay::DrawBootLogo( QPainter *paint, int width, int height )
{

 QColor white( 255, 255, 255 );
 QColor black(0,0,0);

 paint->fillRect( 0, 0, width, height, white );
 paint->drawPixmap( Center_x(&m_BootLogBMP), BOOT_LOGO_Y, m_BootLogBMP );

 paint->setPen( black );
 paint->drawText( Center_x(&QString(BOOT_LOGOSTRING)), BOOT_LOGOSTRING_Y, BOOT_LOGOSTRING ); 
}

void CDisplay::DrawBuilding( QPainter *paint)
{
  paint->drawPixmap( BUILDING_X, BUILDING_Y, m_mmBMP );
}

void  CDisplay::drawScoreBackGround(QPainter *paint, int width, int height)
{

  QColor back(249,129,124);
  
  paint->fillRect(0, 0, width, height, back);
  DrawBuilding(paint);

}

int CDisplay::Center_x(QString *pStr )
{
  QFont f = QApplication::font();
  QFontMetrics fm = QFontMetrics(f);
  int length = fm.width(*pStr);
  return (SCREENW/2-length/2);
}

int CDisplay::Center_x(QPixmap* pImg)
{
    int length = pImg->width();
    return (SCREENW/2-length/2);
}



