/*
 * $Id: SpringRPCProvider.java,v 1.2 2004/11/30 06:32:20 mashu Exp $
 */
package cx.ath.kgslab.spring.axis.server;

import org.apache.axis.MessageContext;
import org.apache.axis.providers.java.RPCProvider;
import org.springframework.context.ApplicationContext;


/**
 * Spring RPC Provider .
 * SpringBeanEFuT[rXƂČJB
 * RPCProvider̎x[XɁAS2AxisS2Provider̎Qlɍ쐬B
 * @author NAGASAWA Takahiro
 * @version $Revision: 1.2 $
 */
public class SpringRPCProvider extends RPCProvider {
  /** AvP[VReLXg̃L[ */
  public static final String OPTION_APPLICATION_CONTEXT =
    "applicationContext";
  /** R|[lg̃L[ */
  public static final String OPTION_COMPONENT_NAME =
    "componentName";

  /**
   * 
   * @param msgContext bZ[WReLXg
   * @param className NX
   * @see org.apache.axis.providers.java.JavaProvider#makeNewServiceObject(org.apache.axis.MessageContext,java.lang.String)
   */
  protected Object makeNewServiceObject(
    final MessageContext msgContext, final String className) {
    final ApplicationContext webApplicationContext =
      (ApplicationContext) msgContext.getService().getOption(SpringRPCProvider.OPTION_APPLICATION_CONTEXT);
    final String componentName =
      (String) msgContext.getService().getOption(SpringRPCProvider.OPTION_COMPONENT_NAME);
    
    final Object bean = webApplicationContext.getBean(componentName);
    if (bean instanceof AxisExporter) {
      final AxisExporter exporter = (AxisExporter)bean;

      return exporter.getBean();      
    } else {
      return bean;
    }
    
  }
}
