/*
 * Decompiled with CFR 0.152.
 */
package cx.ath.kgslab.webutil;

import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class EncodedRequestWrapper
extends HttpServletRequestWrapper {
    private String encode = "UTF-8";
    private Map params = null;

    public EncodedRequestWrapper(HttpServletRequest request) {
        super(request);
    }

    public EncodedRequestWrapper(HttpServletRequest request, String encode) {
        this(request);
        this.encode = encode;
    }

    public String getParameter(String name) {
        String[] temp = this.getParameterValues(name);
        if (temp != null) {
            return temp[0];
        }
        return null;
    }

    public Map getParameterMap() {
        if (this.params == null) {
            this.params = super.getParameterMap();
            HashMap<String, String[]> result = new HashMap<String, String[]>();
            Enumeration enumeration = super.getParameterNames();
            try {
                while (enumeration.hasMoreElements()) {
                    String entry = (String)enumeration.nextElement();
                    Object obj = this.params.get(entry);
                    String[] values = this.encode((String[])obj);
                    result.put(entry, values);
                }
                this.params = result;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return this.params;
    }

    public String[] getParameterValues(String name) {
        if (this.params == null) {
            this.params = this.getParameterMap();
        }
        return (String[])this.params.get(name);
    }

    private String[] encode(String[] values) throws UnsupportedEncodingException {
        String[] result = new String[values.length];
        int i = 0;
        while (i < values.length) {
            result[i] = this.encode(values[i]);
            ++i;
        }
        values = result;
        return values;
    }

    private String encode(String param) throws UnsupportedEncodingException {
        if (param != null) {
            param = new String(param.getBytes("8859_1"), this.encode);
        }
        return param;
    }
}

