/*
 * Decompiled with CFR 0.152.
 */
package cx.ath.kgslab.svgeditor.parser;

import cx.ath.kgslab.svgeditor.items.Circle;
import cx.ath.kgslab.svgeditor.items.Ellipse;
import cx.ath.kgslab.svgeditor.items.Line;
import cx.ath.kgslab.svgeditor.items.Rect;
import cx.ath.kgslab.svgeditor.items.Stroke;
import cx.ath.kgslab.svgeditor.items.Text;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SVGParser
extends DefaultHandler {
    public static final String SVG_NS = "http://www.w3.org/2000/svg";
    List result = new ArrayList();
    boolean textElement = false;

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (SVG_NS.equals(uri)) {
            if ("text".equals(localName)) {
                try {
                    this.parseText(attributes);
                    this.textElement = true;
                }
                catch (NumberFormatException e) {
                    throw new SAXException("NumberFormatException in Text", e);
                }
            }
            if ("line".equals(localName)) {
                try {
                    this.parseLine(attributes);
                }
                catch (NumberFormatException e) {
                    throw new SAXException("NumberFormatException in Line", e);
                }
            }
            if ("polyline".equals(localName)) {
                try {
                    this.parseStroke(attributes);
                }
                catch (NumberFormatException e) {
                    throw new SAXException("NumberFormatException in Line", e);
                }
            }
            if ("rect".equals(localName)) {
                try {
                    this.parseRect(attributes);
                }
                catch (NumberFormatException e) {
                    throw new SAXException("NumberFormatException in Rect", e);
                }
            }
            if ("circle".equals(localName)) {
                try {
                    this.parseCircle(attributes);
                }
                catch (NumberFormatException e) {
                    throw new SAXException("NumberFormatException in Circle", e);
                }
            }
            if ("ellipse".equals(localName)) {
                try {
                    this.parseEllipse(attributes);
                }
                catch (NumberFormatException e) {
                    throw new SAXException("NumberFormatException in Ellipse", e);
                }
            }
        }
    }

    private void parseStroke(Attributes attributes) {
        String points = attributes.getValue("", "points");
        String stroke = attributes.getValue("", "stroke");
        String stroke_width = attributes.getValue("", "stroke-width");
        Stroke line = new Stroke();
        StringTokenizer tokens = new StringTokenizer(points, " ,");
        String x = tokens.nextToken();
        String y = tokens.nextToken();
        line.setX(Integer.parseInt(x));
        line.setY(Integer.parseInt(y));
        while (tokens.hasMoreTokens()) {
            x = tokens.nextToken();
            y = tokens.nextToken();
            line.addPath(Integer.parseInt(x), Integer.parseInt(y));
        }
        line.setColor(this.stringToColor(stroke));
        line.setLineWidth(Integer.parseInt(stroke_width));
        this.result.add(line);
    }

    private void parseEllipse(Attributes attributes) {
        String cx = attributes.getValue("", "cx");
        String cy = attributes.getValue("", "cy");
        String rx = attributes.getValue("", "rx");
        String ry = attributes.getValue("", "ry");
        String fill = attributes.getValue("", "fill");
        String stroke = attributes.getValue("", "stroke");
        String stroke_width = attributes.getValue("", "stroke-width");
        Ellipse ellipse = new Ellipse();
        ellipse.setX(Integer.parseInt(cx));
        ellipse.setY(Integer.parseInt(cx));
        ellipse.setRx(Integer.parseInt(rx));
        ellipse.setRy(Integer.parseInt(ry));
        if (stroke != null) {
            ellipse.setColor(this.stringToColor(stroke));
        }
        ellipse.setLineWidth(Integer.parseInt(stroke_width));
        if (fill != null) {
            ellipse.setFill(this.stringToColor(fill));
        }
        this.result.add(ellipse);
    }

    private void parseCircle(Attributes attributes) {
        String cx = attributes.getValue("", "cx");
        String cy = attributes.getValue("", "cy");
        String r = attributes.getValue("", "r");
        String fill = attributes.getValue("", "fill");
        String stroke = attributes.getValue("", "stroke");
        String stroke_width = attributes.getValue("", "stroke-width");
        Circle circle = new Circle();
        circle.setX(Integer.parseInt(cx));
        circle.setY(Integer.parseInt(cx));
        circle.setR(Integer.parseInt(r));
        if (stroke != null) {
            circle.setColor(this.stringToColor(stroke));
        }
        circle.setLineWidth(Integer.parseInt(stroke_width));
        if (fill != null) {
            circle.setFill(this.stringToColor(fill));
        }
        this.result.add(circle);
    }

    private void parseRect(Attributes attributes) {
        String x = attributes.getValue("", "x");
        String y = attributes.getValue("", "y");
        String width = attributes.getValue("", "width");
        String height = attributes.getValue("", "height");
        String fill = attributes.getValue("", "fill");
        String stroke = attributes.getValue("", "stroke");
        String stroke_width = attributes.getValue("", "stroke-width");
        Rect rect = new Rect();
        rect.setX(Integer.parseInt(x));
        rect.setY(Integer.parseInt(y));
        rect.setWidth(Integer.parseInt(width));
        rect.setHeight(Integer.parseInt(height));
        if (stroke != null) {
            rect.setColor(this.stringToColor(stroke));
        }
        rect.setLineWidth(Integer.parseInt(stroke_width));
        if (fill != null) {
            rect.setFill(this.stringToColor(fill));
        }
        this.result.add(rect);
    }

    private void parseLine(Attributes attributes) {
        String x1 = attributes.getValue("", "x1");
        String y1 = attributes.getValue("", "y1");
        String x2 = attributes.getValue("", "x2");
        String y2 = attributes.getValue("", "y2");
        String stroke = attributes.getValue("", "stroke");
        String stroke_width = attributes.getValue("", "stroke-width");
        Line line = new Line();
        line.setX(Integer.parseInt(x1));
        line.setY(Integer.parseInt(y1));
        line.setX2(Integer.parseInt(x2));
        line.setY2(Integer.parseInt(y2));
        line.setColor(this.stringToColor(stroke));
        line.setLineWidth(Integer.parseInt(stroke_width));
        this.result.add(line);
    }

    private void parseText(Attributes attributes) {
        String x = attributes.getValue("", "x");
        String y = attributes.getValue("", "y");
        String stroke = attributes.getValue("", "stroke");
        String font_famiry = attributes.getValue("", "font-famiry");
        String font_size = attributes.getValue("", "font-size");
        Text text = new Text();
        text.setX(Integer.parseInt(x));
        text.setY(Integer.parseInt(y));
        text.setColor(this.stringToColor(stroke));
        text.setFontFamiry(font_famiry);
        if (font_size.endsWith("pt")) {
            text.setFontSize(Integer.parseInt(font_size.substring(0, font_size.length() - 2)));
        }
        this.result.add(text);
    }

    private Color stringToColor(String stroke) throws NumberFormatException {
        if ("none".equalsIgnoreCase(stroke)) {
            return null;
        }
        return new Color(Integer.parseInt(stroke.substring(1, 3)), Integer.parseInt(stroke.substring(3, 5)), Integer.parseInt(stroke.substring(5, 7)));
    }

    public List getResult() {
        return this.result;
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.textElement) {
            Text text = (Text)this.result.get(this.result.size() - 1);
            text.setText(String.valueOf(text.getText()) + new String(ch, start, length));
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (SVG_NS.equals(uri) && "text".equals(localName)) {
            this.textElement = false;
        }
    }
}

