/*
 * Decompiled with CFR 0.152.
 */
package cx.ath.kgslab.svgeditor.items;

import cx.ath.kgslab.svgeditor.CanvasPanel;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;

public abstract class Item {
    protected int x = 0;
    protected int y = 0;
    protected Color color = Color.BLACK;
    protected CanvasPanel canvas = null;
    protected boolean changed = true;

    public Color getColor() {
        return this.color;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public void setColor(Color color) {
        this.color = color;
        this.changed = true;
    }

    public void setX(int i) {
        this.x = i;
        this.changed = true;
    }

    public void setY(int i) {
        this.y = i;
        this.changed = true;
    }

    protected String getColorString() {
        if (this.color != null) {
            return this.colorToString(this.color);
        }
        return "black";
    }

    protected String colorToString(Color color) {
        int r = color.getRed();
        int g = color.getGreen();
        int b = color.getBlue();
        return "#" + this.toHexString(r) + this.toHexString(g) + this.toHexString(b);
    }

    protected String toHexString(int v) {
        return String.valueOf(v < 16 ? "0" : "") + Integer.toHexString(v);
    }

    public abstract Shape getShape();

    public abstract void paint(Graphics2D var1);

    public abstract void selectingPaint(Graphics2D var1);

    public abstract String getSvgElement();

    public abstract void form(int var1, int var2);

    public void move(int x, int y) {
        this.setX(x);
        this.setY(y);
    }

    public CanvasPanel getCanvas() {
        return this.canvas;
    }

    public void setCanvas(CanvasPanel panel) {
        this.canvas = panel;
    }

    public abstract void initSample(int var1, int var2);
}

