/*
 * Decompiled with CFR 0.152.
 */
package cx.ath.kgslab.util;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DateUtils {
    static final SimpleDateFormat ISO8601_DATETIME = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    static final SimpleDateFormat ISO8601_DATE = new SimpleDateFormat("yyyy-MM-dd");
    static final SimpleDateFormat ISO8601_TIME = new SimpleDateFormat("HH:mm:ss");
    private static final Pattern ISO8601_DATETIME_PATTERN = Pattern.compile("(\\d{4})-(\\d{2})-(\\d{2})T(\\d{2}):(\\d{2}):(\\d{2})(?:(Z)|((?:\\-|\\+)\\d{2}:\\d{2}))?");

    public static boolean equalsDates(Calendar c1, Calendar c2) {
        if (c1 == null || c2 == null) {
            return false;
        }
        return c1.get(1) == c2.get(1) && c1.get(6) == c2.get(6);
    }

    public static String formatISODateTime(Date date, Object timeZone) {
        return DateUtils.formatISO(date, timeZone, ISO8601_DATETIME);
    }

    public static String formatISODate(Date date, Object timeZone) {
        return DateUtils.formatISO(date, timeZone, ISO8601_DATE);
    }

    public static String formatISOTime(Date date, Object timeZone) {
        return DateUtils.formatISO(date, timeZone, ISO8601_TIME);
    }

    private static String formatISO(Date date, Object timeZone, SimpleDateFormat pformat) {
        TimeZone tz = TimeZone.getDefault();
        if (timeZone != null) {
            if (timeZone instanceof String && ((String)timeZone).length() > 0) {
                tz = TimeZone.getTimeZone((String)timeZone);
            } else if (timeZone instanceof TimeZone) {
                tz = (TimeZone)timeZone;
            }
        }
        SimpleDateFormat format = (SimpleDateFormat)pformat.clone();
        format.setTimeZone(tz);
        String timezone = DateUtils.makeTimeZoneString(date, tz);
        return String.valueOf(format.format(date)) + timezone;
    }

    public static String makeTimeZoneString(Date date, TimeZone tz) {
        SimpleDateFormat ZONE = new SimpleDateFormat("Z");
        ZONE.setTimeZone(tz);
        String timezone = ZONE.format(date);
        timezone = Integer.parseInt(timezone.substring(1, timezone.length())) == 0 ? "Z" : String.valueOf(timezone.substring(0, 3)) + ":" + timezone.substring(3, 5);
        return timezone;
    }

    public static String formatISODateTime(Date date) {
        return DateUtils.formatISODateTime(date, TimeZone.getDefault());
    }

    public static Calendar parseISODateTime(String date) {
        Matcher matcher = ISO8601_DATETIME_PATTERN.matcher(date);
        if (matcher.matches()) {
            String year = matcher.group(1);
            String month = matcher.group(2);
            String day = matcher.group(3);
            String hour = matcher.group(4);
            String min = matcher.group(5);
            String sec = matcher.group(6);
            String tz1 = matcher.group(7);
            String tz2 = matcher.group(8);
            TimeZone timezone = TimeZone.getTimeZone("UTC");
            if (tz1 == null && tz2 != null) {
                timezone = TimeZone.getTimeZone("GMT" + tz2);
            }
            int y = year != null ? Integer.parseInt(year) : 1;
            int d = day != null ? Integer.parseInt(day) : 1;
            int h = hour != null ? Integer.parseInt(hour) : 0;
            int m = min != null ? Integer.parseInt(min) : 0;
            int s = sec != null ? Integer.parseInt(sec) : 0;
            month = month == null ? "1" : month;
            int mon = Integer.parseInt(month) - 1;
            Calendar result = Calendar.getInstance();
            result.set(y, mon, d, h, m, s);
            result.setTimeZone(timezone);
            result.getTimeInMillis();
            return result;
        }
        return null;
    }
}

