#ifndef IFILE_SYSTEM_FOR_INHERITANCE_H
#define IFILE_SYSTEM_FOR_INHERITANCE_H

#include "IFileSystem.h"

namespace irr
{
namespace io
{

class IFileSystem_ForInheritance : public irr::io::IFileSystem
{
public:

	virtual IReadFile* createAndOpenFile(const c8* filename) = 0;

	virtual IReadFile* createMemoryReadFile(irr::core::array<unsigned char> memory, s32 len, const c8* fileName, bool deleteMemoryWhenDropped=false) = 0;

	IReadFile* createMemoryReadFile(void* memory, s32 len, const c8* fileName, bool deleteMemoryWhenDropped=false)
	{
		irr::core::array<unsigned char> arr;
		arr.set_pointer((unsigned char*)memory, len);
		return createMemoryReadFile(arr.pointer(), len, fileName, deleteMemoryWhenDropped);
	}

	virtual IWriteFile* createAndWriteFile(const c8* filename, bool append=false) = 0;

	virtual bool addZipFileArchive(const c8* filename, bool ignoreCase = true, bool ignorePaths = true) = 0;

	virtual bool addFolderFileArchive(const c8* filename, bool ignoreCase = true, bool ignorePaths = true) = 0;

	virtual bool addPakFileArchive(const c8* filename, bool ignoreCase = true, bool ignorePaths = true) = 0;

	virtual const c8* getWorkingDirectory() = 0;

	virtual bool changeWorkingDirectoryTo(const c8* newDirectory) = 0;

	virtual core::stringc getAbsolutePath(const core::stringc& filename) const = 0;

	virtual core::stringc getFileDir(const core::stringc& filename) const = 0;

	virtual core::stringc getFileBasename(const core::stringc& filename, bool keepExtension=true) const = 0;

	virtual IFileList* createFileList() const = 0;

	virtual bool existFile(const c8* filename) const = 0;

	virtual bool existFile(const core::stringc& filename) const = 0;

	virtual IXMLReader* createXMLReader(const c8* filename) = 0;

	virtual IXMLReader* createXMLReader(IReadFile* file) = 0;

	virtual IXMLReaderUTF8* createXMLReaderUTF8(const c8* filename) = 0;

	virtual IXMLReaderUTF8* createXMLReaderUTF8(IReadFile* file) = 0;

	virtual IXMLWriter* createXMLWriter(const c8* filename) = 0;

	virtual IXMLWriter* createXMLWriter(IWriteFile* file) = 0;

	virtual IAttributes* createEmptyAttributes(video::IVideoDriver* driver=0) = 0;
};

}
}
#endif //IFILE_SYSTEM_FOR_INHERITANCE_H