#ifndef CONST_STRING_ARRAY
#define CONST_STRING_ARRAY

#include<vector>
class ConstStringArray
{
	std::vector<char*> m_list;
public:
	ConstStringArray(const char* const* list)
	{
		for(int i = 0; i < 200; i++)
		{
			if(list[i] == 0)
			{
				Initialize((char**)list, i);
				break;
			}
		}
	}
	ConstStringArray(char** list)
	{
		for(int i = 0; i < 200; i++)
		{
			if(list[i] == 0)
			{
				Initialize(list, i);
				break;
			}
		}
	}
	ConstStringArray(char** list, int size)
	{
		Initialize(list,size);
	}
	ConstStringArray(const char* const* list, int size)
	{
		Initialize((char**)list,size);
	}

	ConstStringArray(int size)
	{
		for(int i = 0; i < size; i++)
		{
			m_list.push_back("");
		}
	}
	char* GetItem(int index)
	{
		if(index < 0 || m_list.size() <= index)
		{
			return "";
		}
		return m_list[index];
	}
	void SetItem(int index, char* str)
	{
		if(index < 0 || m_list.size() <= index)
		{
			return;
		}
		m_list[index] = str;
	}
	
	int GetSize()
	{
		return m_list.size();
	}
	
	char** GetPointer()
	{
		return &m_list[0];
	}

private:
	void Initialize(char** list, int size)
	{
		for(int i = 0; i < size; i++)
		{
			m_list.push_back(list[i]);
		}
	}
};

#endif //CONST_STRING_ARRAY