<?php
/**
 * Admins Management
 *
 */
require_once (dirname(__FILE__) . "/SUPER_Controller.php");

class Admins extends SUPER_Controller {

    function Admins()
    {
        parent::SUPER_Controller();
        $this->load->model('User_model');
        $this->load->library('session');
    }
    
    public function index()
    {
        $this->load->helper(array('form', 'url'));
        redirect('super/admins/page/');
    }
    
    /**
     * ホテル管理者リストを表示する
     */
    public function page($offset = 0)
    {
        $this->load->helper(array('form', 'url'));
        
        $limit = 20;    // 1ページ表示件数
        
        //$this->db->order_by('ordering ASC');
        $this->db->where('status >', 0);
        $this->db->limit($limit, $offset);
        $query = $this->db->get('admins');
        $data['admins'] = $query->result_array();
        
        $this->load->library('pagination');
        
        // 総レコード数の取得
        $this->db->where('status >', 0);
        $query = $this->db->get('admins');
        $total_rows = $query->num_rows();
        
        $pager_config['uri_segment'] = 4;
        $pager_config['base_url'] = base_url() . 'super/admins/page/';
        $pager_config['total_rows'] = $total_rows;
        $pager_config['per_page'] = $limit;
        
        $this->pagination->initialize($pager_config);
        
        $data['links'] = $this->pagination->create_links();
        
        $this->load->vars($data);
        
        $this->load->view('super/admins/page');
    }
    
    public function logout()
    {
        $this->load->helper(array('form', 'url'));
        $this->load->library('phpsession');
        
        $this->phpsession->clear('super');
        redirect('super');
    }
    
    /**
     * システム管理者による管理者登録
     */
    public function add()
    {
        $this->load->helper(array('form', 'url'));
        
        $this->db->where('status >=', 0);
        $dbres = $this->db->get('hotels');
        $ddmenu = array();
        foreach ($dbres->result_array() as $tablerow) {
            $ddmenu[$tablerow['hotelid']] = $tablerow['hotel_name'];
        }
        $data['options'] = $ddmenu;
        $this->load->vars($data);
        
        $this->load->library('form_validation');
        $this->form_validation->set_error_delimiters('<div class="error">', '</div>');
        
        $this->form_validation->set_rules('username', 'ユーザ名', 'required|trim|xss_clean');
        $this->form_validation->set_rules('email', 'メールアドレス', 'required|valid_email|trim|xss_clean');
        $this->form_validation->set_rules('password', 'パスワード', 'required|trim|xss_clean');
        $this->form_validation->set_rules('hotelid', 'ホテル', 'required|trim|xss_clean');
        
        if ($this->form_validation->run() == FALSE)
        {
            $this->load->view('super/admins/add');
            return;
        }
        else
        {
            // 同じユーザ名が登録済みでないことをチェックする
            $this->db->where('username', set_value('username'));
            $this->db->where('status > ', 0);
            $query = $this->db->get('admins', 1);
            if ($query->num_rows() > 0)
            {
                $data['error'] = array();
                $data['error'][] = '同じユーザ名がすでに登録されています。他のユーザ名を設定してください。';
                $this->load->vars($data);
                $this->load->view('super/admins/add');
                return;
            }
                        
            $data = array(
                'username' => set_value('username'),
                'hotelid' => set_value('hotelid'),
                'email' => set_value('email'),
                'password' => sha1(set_value('password')),
                'status' => 1);
            $this->db->insert('admins', $data);
            redirect('super/admins/index');
        }
        
        $this->load->view('super/admins/add');
    }
    
    /**
     * ユーザ情報の編集
     */
    public function edit($adminid)
    {
        $this->load->helper(array('form', 'url'));
        
        $this->db->where('status', 1);
        $dbres = $this->db->get('hotels');
        $ddmenu = array();
        foreach ($dbres->result_array() as $tablerow) {
            $ddmenu[$tablerow['hotelid']] = $tablerow['hotel_name'];
        }
        $data['options'] = $ddmenu;
        $this->load->vars($data);
        
        $data['adminid'] = $adminid;
        $this->load->vars($data);
        
        $this->load->library('form_validation');
        $this->form_validation->set_error_delimiters('<div class="error">', '</div>');
        
        $this->form_validation->set_rules('username', 'ユーザ名', 'required|trim|xss_clean');
        $this->form_validation->set_rules('email', 'メールアドレス', 'required|valid_email|trim|xss_clean');
        $this->form_validation->set_rules('password', 'パスワード', 'trim|xss_clean');
        $this->form_validation->set_rules('hotelid', 'ホテル', 'required|trim|xss_clean');
        
        if (!$this->input->post('submit'))
        {
            $this->db->where('adminid', $adminid);
            $this->db->where('status > ', 0);
            $query = $this->db->get('admins', 1);
            
            if ($query->num_rows() > 0)
            {
                $row = $query->row_array();
                $data['username'] = $row['username'];
                $data['email'] = $row['email'];
                $data['password'] = '';
                $data['hotelid'] = $row['hotelid'];
                $this->load->vars($data);
            }
        }
        
        if ($this->form_validation->run() == false)
        {
            $this->load->view('super/admins/edit');
            return;
        }
        else
        {
            // 同じユーザ名がないことをチェックする
            $this->db->where('username', set_value('username'));
            $this->db->where('adminid <> ', $adminid);    // 自分以外
            $this->db->where('status > ', 0);
            $query = $this->db->get('admins', 1);
            if ($query->num_rows() > 0)
            {
                $data['error'] = array();
                $data['error'][] = '同じユーザ名がすでに登録されています。他のユーザ名を設定してください。';
                $this->load->vars($data);
                $this->load->view('super/admins/edit');
                return;
            }
            
            if (set_value('password') != '')
            {
                $data = array(
                    'username' => set_value('username'),
                    'email' => set_value('email'),
                    'hotelid' => set_value('hotelid'),
                    'password' => sha1(set_value('password')));
            }
            else
            {
                // パスワード入力がないときはパスワードを変更しない。
                $data = array(
                    'username' => set_value('username'),
                    'email' => set_value('email'),
                    'hotelid' => set_value('hotelid'));
            }
            $this->db->where('adminid', $adminid);
            $this->db->update('admins', $data);
            redirect('super/admins/index');
        }
        
        $this->load->view('super/admins/edit');
    }
    
    /**
     * ユーザの削除
     */
    public function delete($adminid)
    {
        $this->load->helper(array('form', 'url'));
        
        // 他に管理ユーザがいることをチェックする。
        $this->db->where('adminid <>', $adminid);
        $this->db->where('hotelid', $hotelid);
        $this->db->where('status >', 0);
        $query = $this->db->get('admins');
        if ($query->num_rows() <= 0)
        {
            // 他に管理者がいない
            $this->session->set_flashdata('msg', '他に管理者がいないため、ユーザを削除できませんでした。');
            redirect('system/admins/page');
        }
        
        $data = array('status' => -1);
        $this->db->where('adminid', $adminid);
        $this->db->update('admins', $data);
        
        redirect('super/admin/index');
    }
}
