<?php
/**
 * Roomtypes
 * @package     ci-hotel
 * @author      Teruki Hosokawa <hosotk@gmail.com>
 * @licence     New BSD Licence
 */
require_once (dirname(__FILE__) . "/FRONT_Controller.php");

class Roomtypes extends FRONT_Controller {

    function Roomtypes()
    {
        parent::FRONT_Controller();
        $this->load->model('Common_model');
    }
    
    /**
     * ^Cvꗗ
     */
    public function index($hotelid)
    {
        $this->load->helper(array('form', 'url'));
        //$this->db->order_by('ordering ASC');
        $this->db->where('hotelid', $hotelid);
        $this->db->where('status', 1);
        $query = $this->db->get('roomtypes');
        $data['roomtypes'] = $query->result_array();
        $this->load->vars($data);
        $this->load->view('roomtypes/index');
    }
    
    /**
     * ^Cvڍ
     */
    function detail($hotelid, $roomtypeid)
    {
        $this->load->helper(array('form', 'url'));
        
        $data['title'] = "Roomtypes";
        $data['headline'] = "";
        
        $this->db->where('roomtypeid', $roomtypeid);
        $this->db->where('status', 1);
        $query = $this->db->get('roomtypes', 1);
        if ($query->num_rows() <= 0)
        {
            die();
        }
        $row = $query->row_array();
        $data = $row;
        $this->load->vars($data);
        $this->load->view('roomtypes/detail');
    }
}

/* End of file roomtypes.php */
