<?php
/**
 * VacantPlans Management
 * @package     ci-hotel
 * @author      Teruki Hosokawa <hosotk@gmail.com>
 * @license     New BSD License
 */
require_once (dirname(__FILE__) . "/ADMIN_Controller.php");

class VacantPlans extends ADMIN_Controller {

    function VacantPlans()
    {
        parent::ADMIN_Controller();
        $this->load->model('User_model');
        $this->load->model('Common_model');
        $this->load->model('Res_model');
    }
    
    public function index($hotelid, $planid)
    {
        $this->load->helper(array('form', 'url'));
        
        // 今月yyyymmの取得
        $today = date('Ym');
        $year = substr($today, 0, 4);
        $month = substr($today, 4, 2);
        redirect('admin/vacantplans/set/' . $hotelid . '/' . $planid . '/' . $year . '/' . $month);
    }
    
    public function set($hotelid, $planid, $year, $month)
    {
        $this->load->helper(array('form', 'url'));
        
        $this->db->where('planid', $planid);
        $query = $this->db->get('plans', 1);
        if ($query->num_rows() <= 0)
        {
            die();
        }
        $plan = $query->row_array();
        
        // submitボタンが押されている場合
        if (isset($_POST['submit']))
        {
            $this->Res_model->lock();
            
            foreach ($_POST['d'] as $key => $value)
            {
                //echo $key . ':' . $value . "<br />\n";
                $ymd = sprintf("%04d-%02d-%02d", $year, $month, $key);
                if ($value == 'default')
                {
                    // 
                }
                else
                {
                    // update or insert
                    $query = $this->db->get_where('vacantplans', array('day' => $ymd, 'planid' => $planid));
                    if ($query->num_rows() > 0)
                    {
                        $this->db->where('day', $ymd);
                        $this->db->where('planid', $planid);
                        $this->db->update('vacantplans', array('vp_num' => $value)); 
                    }
                    else
                    {
                        $data = array(
                                'day' => $ymd,
                                'planid' => $planid,
                                'vp_inuse' => 0,
                                'vp_num' => $value);
                        $this->db->insert('vacantplans', $data);
                    }
                }
            }
            
            $this->Res_model->unlock();
        }
        
        ob_start();
        
        echo '<h2>'. "プラン :" . $plan['plan_name'] . '</h2>' . "\n";
        echo '期間 :' . $plan['start_date'] . '～' . $plan['end_date'] . "<br />\n";
        
        $prefs = array (
                       'show_next_prev'  => TRUE,
                       'next_prev_url'   => site_url('admin/vacantplans/set/' . $hotelid . '/' . $planid)
                     );
        $prefs['template'] = '
           {table_open}<table width="100%" border="1px" cellpadding="0" cellspacing="0">{/table_open}
           {heading_row_start}<tr>{/heading_row_start}
           {heading_previous_cell}<th><a href="{previous_url}">&lt;&lt;</a></th>{/heading_previous_cell}
           {heading_title_cell}<th colspan="{colspan}">{heading}</th>{/heading_title_cell}
           {heading_next_cell}<th><a href="{next_url}">&gt;&gt;</a></th>{/heading_next_cell}
           {heading_row_end}</tr>{/heading_row_end}
           {week_row_start}<tr>{/week_row_start}
           {week_day_cell}<td>{week_day}</td>{/week_day_cell}
           {week_row_end}</tr>{/week_row_end}
           {cal_row_start}<tr>{/cal_row_start}
           {cal_cell_start}<td>{/cal_cell_start}
           {cal_cell_content}{day}<br />{content}{/cal_cell_content}
           {cal_cell_content_today}<div class="highlight">{day}<br />{content}</div>{/cal_cell_content_today}
           {cal_cell_no_content}{day}{/cal_cell_no_content}
           {cal_cell_no_content_today}<div class="highlight">{day}</br /></div>{/cal_cell_no_content_today}
           {cal_cell_blank}&nbsp;{/cal_cell_blank}
           {cal_cell_end}</td>{/cal_cell_end}
           {cal_row_end}</tr>{/cal_row_end}
           {table_close}</table>{/table_close}
        ';
        
        $this->load->library('calendar', $prefs);
        
        $cal_data = array();
        
        // 月の日数
        $days = date('t', mktime(0, 0, 0, $month, 1, $year));
        
        echo form_open('admin/vacantplans/set/' . $hotelid . '/' . $planid . '/' . $year . '/' . $month);
        echo "\n";
        
        $options = array();
        $options['default'] = '-';
        for ($i = 0; $i <= 99; $i++)
        {
            $options[$i] = $i;
        }
        
        for ($i = 1; $i <= $days; $i++)
        {
            $default = 'default';
            // $planid, $year-$month-$iのデータがvacantplansテーブルにあればそれを初期値とする
            $ymd = sprintf("%04d-%02d-%02d", $year, $month, $i);
            $this->db->where('day', $ymd);
            $this->db->where('planid', $planid);
            $query = $this->db->get('vacantplans', 1);
            if ($query->num_rows() > 0)
            {
                $data = $query->row_array();
                $vp_inuse = $data['vp_inuse'];
                $vp_num = $data['vp_num'];
                $default = $data['vp_num'];
                $sss = form_dropdown('d[' . $i . ']', $options, $default);
                $sss .= "<br />";
                $sss .= $vp_inuse . '/' . $vp_num . "<br />";
            }
            else
            {
                $default = 'default';
                $sss = form_dropdown('d[' . $i . ']', $options, $default);
                $sss .= "<br />";
                $sss .= '-/-' . "<br />";
            }
            $cal_data[$i] = $sss;
        }
        
        echo $this->calendar->generate($this->uri->segment(6), $this->uri->segment(7), $cal_data);
        
        echo form_submit('submit', 'プラン空き人数を更新する');
        echo form_close();
        
        $data['contents'] = ob_get_contents();
        ob_end_clean();
        $this->load->vars($data);
        
        $this->load->view('admin/vacantplans/set');
    }
}