<?php
/**
 * Options Management
 * @package     ci-hotel
 * @author      Teruki Hosokawa <hosotk@gmail.com>
 * @license     New BSD License
 */
require_once (dirname(__FILE__) . "/ADMIN_Controller.php");

class Options extends ADMIN_Controller {

    function Options()
    {
        parent::ADMIN_Controller();
        $this->load->model('User_model');
        $this->load->model('Common_model');
    }
    
    /**
     * オプション一覧
     */
    public function index($hotelid)
    {
        $this->load->helper(array('form', 'url'));
        //$this->db->order_by('ordering ASC');
        $this->db->where('status', 1);
        $query = $this->db->get('options');
        $data['options'] = $query->result_array();
        $this->load->vars($data);
        
        $this->load->view('admin/options/index');
    }
    
    /**
     * オプションの新規作成
     */
    public function add($hotelid)
    {
        $this->load->helper(array('form', 'url'));
        $this->load->helper('ck');

        $data['summary'] = '';
        $this->load->vars($data);
        
        $this->db->where('status', 1);
        $this->db->where('hotelid', $hotelid);
        $dbres = $this->db->get('plans');
        $ddmenu = array();
        foreach ($dbres->result_array() as $tablerow) {
            $ddmenu[$tablerow['planid']] = $tablerow['plan_name'];
        }
        $data['plan_options'] = $ddmenu;
        
        $this->load->vars($data);
        
        $this->load->library('form_validation');
        $this->form_validation->set_error_delimiters('<div class="error">', '</div>');
        
        $this->form_validation->set_rules('option_name', 'オプション名', 'required|trim|xss_clean');
        $this->form_validation->set_rules('summary', '概要', 'required');
        $this->form_validation->set_rules('start_date', '開始日付', 'required|trim|xss_clean');
        $this->form_validation->set_rules('end_date', '終了日時', 'required|trim|xss_clean');
        $this->form_validation->set_rules('default_num', 'デフォルト数', 'required|integer|trim|xss_clean');
        $this->form_validation->set_rules('max_num', '最大数', 'required|integer|trim|xss_clean');
        $this->form_validation->set_rules('price', '料金', 'required|integer|trim|xss_clean');
        $this->form_validation->set_rules('unitname', 'ユニット名', 'required|trim|xss_clean');
        $this->form_validation->set_rules('plan_options[]', 'プラン', 'required|trim|xss_clean');
        
        if (!$this->input->post('submit'))
        {
            $data['default_num'] = 1;
            $data['max_num'] = 9;
        }
        
        if (isset($_POST['plan_options']))
        {
            $plan_options_selected = $_POST['plan_options'];
            $data['plan_options_selected'] = $plan_options_selected;
            $this->load->vars($data);
        }
        else
        {
            $plan_options_selected = array();
            $data['plan_options_selected'] = $plan_options_selected;
            $this->load->vars($data);
        }
        
        if ($this->form_validation->run() == FALSE)
        {
            //echo "Form First Or NG";
            $this->load->view('admin/options/add');
            return;
        }
        else
        {
            $start_date = set_value('start_date');
            $end_date = set_value('end_date');
            // 日付のチェック
            if ($this->Common_model->checkDate($start_date) == false)
            {
                $data['error'] = array();
                $data['error'][] = '開始日付の形式が不正です。';
                $this->load->vars($data);
                $this->load->view('admin/options/add');
                return;
            }
            if ($this->Common_model->checkDate($end_date) == false)
            {
                $data['error'] = array();
                $data['error'][] = '終了日付の形式が不正です。';
                $this->load->vars($data);
                $this->load->view('admin/options/add');
                return;
            }
            // 開始日付 < 終了日付
            if ($start_date >= $end_date)
            {
                $data['error'] = array();
                $data['error'][] = '終了日付は開始日付の翌日以降を指定します。';
                $this->load->vars($data);
                $this->load->view('admin/options/add');
                return;
            }
            
            $data = array(
                           'hotelid' => $hotelid,
                           'option_name' => set_value('option_name'),
                           'summary' => $_POST['summary'],
                           'start_date' => set_value('start_date'),
                           'end_date' => set_value('end_date'),
                           'max_num' => set_value('max_num'),
                           'default_num' => set_value('default_num'),
                           'price' => set_value('price'),
                           'unitname' => set_value('unitname'),
                           'status' => 1,
                        );
            $this->db->insert('options', $data);
            $optionid = $this->db->insert_id();
            
            foreach ($plan_options_selected as $value)
            {
                $data = array(
                    'hotelid' => $hotelid,
                    'optionid' => $optionid,
                    'planid' => $value);
                $this->db->insert('plan_options', $data);
            }
            
            redirect('admin/options/index/' . $hotelid);
        }
    }
    
    /**
     * オプションの編集
     */
    public function edit($hotelid, $optionid)
    {
        $this->load->helper(array('form', 'url'));
        $this->load->helper('ck');
        
        $data['optionid'] = $optionid;
        $data['summary'] = '';
        $this->load->vars($data);
        
        $this->load->library('form_validation');
        $this->form_validation->set_error_delimiters('<div class="error">', '</div>');
        
        // ruleがないときも空でset_rules()しておく。
        // そうでないとset_value()で値が取れなくなる。
        $this->form_validation->set_rules('option_name', 'オプション名', 'required|trim|xss_clean');
        $this->form_validation->set_rules('summary', '概要', 'required');
        $this->form_validation->set_rules('start_date', '開始日付', 'required|trim|xss_clean');
        $this->form_validation->set_rules('end_date', '終了日付', 'required|trim|xss_clean');
        $this->form_validation->set_rules('max_num', '最大数', 'required|trim|xss_clean');
        $this->form_validation->set_rules('default_num', 'デフォルト数', 'required|integer|trim|xss_clean');
        $this->form_validation->set_rules('price', '料金', 'required|integer|trim|xss_clean');
        $this->form_validation->set_rules('unitname', 'ユニット名', 'required|trim|xss_clean');
        
        $dbres = $this->db->get('options');
        $ddmenu = array();
        foreach ($dbres->result_array() as $tablerow) {
            $ddmenu[$tablerow['optionid']] = $tablerow['option_name'];
        }
        $data['plan_options'] = $ddmenu;
        $this->load->vars($data);
        
        // フォームの初期値設定
        if (!$this->input->post('submit'))
        {
            $this->db->where('optionid', $optionid);
            $this->db->where('status', 1);
            $query = $this->db->get('options', 1);
            if ($query->num_rows() <= 0)
            {
                die();
            }
            $row = $query->row_array();
            $data['option_name'] = $row['option_name'];
            $data['summary'] = $row['summary'];
            $data['start_date'] = substr($row['start_date'], 0, 10);
            $data['end_date'] = substr($row['end_date'], 0, 10);
            $data['max_num'] = $row['max_num'];
            $data['default_num'] = $row['default_num'];
            $data['price'] = $row['price'];
            $data['unitname'] = $row['unitname'];
            
            $this->db->where('optionid', $optionid);
            $this->db->where('hotelid', $hotelid);
            $this->db->where('status', 1);
            $query = $this->db->get('options', 1);
            if ($query->num_rows() <= 0)
            {
                die();
            }
            $row = $query->row_array();
            
            $data['options'] = $query->result_array();
            
            
            $this->db->select('planid');
            $this->db->where('optionid', $optionid);
            $this->db->where('hotelid', $hotelid);
            $query = $this->db->get('plan_options');
            
            $tmp = array();
            $tmp2 = $query->result_array();
            foreach ($tmp2 as $a)
            {
                $tmp[] = $a['planid'];
            }
            $data['plan_options_selected'] = $tmp;
            
            $this->load->vars($data);
        }
        else
        {
            if (isset($_POST['plan_options']))
            {
                $plan_options_selected = $_POST['plan_options'];
                $data['plan_options_selected'] = $plan_options_selected;
                $this->load->vars($data);
            }
            else
            {
                $plan_options_selected = array();
                $data['plan_options_selected'] = $plan_options_selected;
                $this->load->vars($data);
            }
        }
        
        if ($this->form_validation->run() == FALSE)
        {
            $this->load->view('admin/options/edit');
        }
        else
        {
            $start_date = set_value('start_date');
            $end_date = set_value('end_date');
            // 日付のチェック
            if ($this->Common_model->checkDate($start_date) == false)
            {
                $data['error'] = array();
                $data['error'][] = '開始日付の形式が不正です。';
                $this->load->vars($data);
                $this->load->view('admin/options/edit');
                return;
            }
            if ($this->Common_model->checkDate($end_date) == false)
            {
                $data['error'] = array();
                $data['error'][] = '終了日付の形式が不正です。';
                $this->load->vars($data);
                $this->load->view('admin/options/edit');
                return;
            }
            // 開始日付 < 終了日付
            if ($start_date >= $end_date)
            {
                $data['error'] = array();
                $data['error'][] = '終了日付は開始日付の翌日以降を指定します。';
                $this->load->vars($data);
                $this->load->view('admin/options/edit');
                return;
            }
            
            
            
            $data = array(
                           'hotelid' => $hotelid,
                           'option_name' => set_value('option_name'),
                           'summary' => $_POST['summary'],
                           'start_date' => set_value('start_date'),
                           'end_date' => set_value('end_date'),
                           'default_num' => set_value('default_num'),
                           'max_num' => set_value('max_num'),
                           'price' => set_value('price'),
                           'unitname' => set_value('unitname')
                        );
            $this->db->where('optionid', $optionid);
            $this->db->update('options', $data);
            
            $this->db->where('optionid', $optionid);
            $this->db->where('hotelid', $hotelid);
            $this->db->delete('plan_options');
            
            foreach ($plan_options_selected as $value)
            {
                $data = array(
                    'hotelid' => $hotelid,
                    'optionid' => $optionid,
                    'planid' => $value);
                $this->db->insert('plan_options', $data);
            }
            
            redirect('admin/options/index/' . $hotelid);
        }
    }
    
    /**
     * オプションの削除
     */
    public function delete($hotelid, $optionid)
    {
        // データを削除せずにstatusに-1をセットする。
        $data = array('status' => -1);
        $this->db->where('optionid', $optionid);
        $this->db->update('options', $data);
        
        // plan_optionsはそのまま残す。
    }
}

/* End of file options.php */
