<?php
/**
 * Admins Management
 *
 */
require_once (dirname(__FILE__) . "/ADMIN_Controller.php");

class Admins extends ADMIN_Controller {

    function Admins()
    {
        parent::ADMIN_Controller();
        $this->load->model('User_model');
        $this->load->library('session');
    }
    
    /**
     * ホテル管理者リストの表示
     */
    public function index($hotelid)
    {
        $this->load->helper(array('form', 'url'));
        
        $this->db->where('status >=', 0);
        $this->db->where('hotelid', $hotelid);
        $query = $this->db->get('admins');
        $data['admins'] = $query->result_array();
        
        $this->load->vars($data);
        
        $this->load->view('admin/admins/index');
    }
    
    /**
     * ホテル管理者の編集
     */
    public function edit($hotelid, $adminid)
    {
        $this->load->helper(array('form', 'url'));
        
        $data['adminid'] = $adminid;
        $this->load->vars($data);
        
        $this->load->library('form_validation');
        $this->form_validation->set_error_delimiters('<div class="error">', '</div>');
        
        $this->form_validation->set_rules('password', 'パスワード', 'trim|xss_clean');
        $this->form_validation->set_rules('username', 'ユーザ名', 'required|trim|xss_clean');
        
        if (!$this->input->post('submit'))
        {
            $this->db->where('adminid', $adminid);
            $this->db->where('hotelid', $hotelid);
            $this->db->where('status >=', 0);
            $query = $this->db->get('admins', 1);
            if ($query->num_rows() > 0)
            {
                $row = $query->row_array();
                $data['username'] = $row['username'];
                $data['password'] = '';
                $data['email'] = $row['email'];
                $this->load->vars($data);
            }
        }
        
        if ($this->form_validation->run() == FALSE)
        {
        }
        else
        {
            // 同じユーザ名が登録済みでないことをチェックする
            $this->db->where('username', set_value('username'));
            $this->db->where('adminid <> ', $adminid);    // 自分以外
            $this->db->where('status >= ', 0);
            $query = $this->db->get('admins', 1);
            if ($query->num_rows() > 0)
            {
                $data['error'] = array();
                $data['error'][] = '同じユーザ名がすでに登録されています。';
                $this->load->vars($data);
                $this->load->view('admin/admins/edit');
                return;
            }
            
            if (set_value('password') != '')
            {
                $data = array(
                    'username' => set_value('username'),
                    'password' => sha1(set_value('password')));
            }
            else
            {
                // パスワード入力がないときはパスワードを変更しない。
                $data = array(
                    'username' => set_value('username'));
            }
            $this->db->where('adminid', $adminid);
            $this->db->update('admins', $data);
            redirect('admin/admins/index/' . $hotelid);
        }
        
        $this->load->view('admin/admins/edit');
    }
}
