<?php
/**
 *
 */
class Common_model extends Model {
    
    function Common_model()
    {
        parent::Model();
    }
    
    /**
     * 文字列が日付形式 YYYY-MM-DD であるかをチェックする
     */
    function checkDate($str)
    {
        if (preg_match("/^\d{4}\-\d{2}\-\d{2}$/", $str))
        {
            $arr = explode("-", $str);  // splitting the array
            $yy = $arr[0] ;             // first element of the array is year
            $mm = $arr[1] ;             // second element is month
            $dd = $arr[2] ;             // third element is days
            return (checkdate($mm, $dd, $yy));
        }
        return false;
    }
    
    /**
     * 文字列が時刻形式 HH:MM であるかをチェックする
     */
    function checkTime($str)
    {
        if (preg_match("/^([01]?[0-9]|2[0-3])\:([0-5][0-9])\$/", $str))
        {
            $arr = explode(":", $str);
            $hh = $arr[0];
            $mm = $arr[1];
            return $this->_checktime($hh, $mm);
        }
        return false;
    }
    
    private function _checktime($hour, $min)
    {
        if ($hour < 0 || $hour > 23)
        {
            return false;
        }
        if ($min < 0 || $min > 59)
        {
            return false;
        }
        return true;
    }
    
    /**
     * 数値を通貨文字列に変換する
     */
    function convCurrency($val, $poststr = '円')
    {
        return (number_format($val) . $poststr);
    }
    
    /**
     * 曜日を返す
     * @param $str YYYY-MM-DD
     */
    function week($str)
    {
        $weekjp_array = array('日', '月', '火', '水', '木', '金', '土');
        $arr = explode('-', $str);  // splitting the array
        $yy = $arr[0] ;             // first element of the array is year
        $mm = $arr[1] ;             // second element is month
        $dd = $arr[2] ;             // third element is days
        
        //タイムスタンプを取得
        $ptimestamp = mktime(0, 0, 0, $mm, $dd, $yy);
        
        //曜日番号を取得
        $weekno = date('w', $ptimestamp);
        
        //日本語の曜日を出力
        return $weekjp_array[$weekno];
    }
}
