<?php
/**
 *  ユーザ手続き
 * refs
 * ci-cms member.php
 */

// Qdmailのエラー(E_DEPRECATED)がでるので...
//error_reporting(E_ALL & ~E_DEPRECATED);
//include_once(dirname(__FILE__) . "/../libraries/qdmail.php");

class Users extends MY_Controller {

    function Users()
    {
        parent::MY_Controller();
        //$this->load->model('User_model');
        $this->load->model('Res_model');
        $this->load->model('Hotel_model');
    }
    
    function index()
    {
        die();
    }
    
    public function login()
    {
        // ログイン処理をし、indexページに戻る。
        // URL指定があれば、そのページに移動する。
        $this->load->library('phpsession');
        $this->load->helper(array('form', 'url'));
        
        $this->load->library('form_validation');
        $this->form_validation->set_error_delimiters('<div class="error">', '</div>');
        
        $this->form_validation->set_rules('email', 'メールアドレス', 'required|trim|valid_email|xss_clean');
        $this->form_validation->set_rules('password', 'パスワード', 'required|trim|xss_clean');
        
        if ($this->form_validation->run() == FALSE)
        {
            $this->load->view('users/login');
        }
        else
        {
            $email = set_value('email');
            $password = set_value('password');
            
            // email, passwordをチェックする
            $this->db->where('email', $email);
            $this->db->where('password', sha1($password));
            $this->db->where('status', 2);
            $query = $this->db->get('users', 1);
            if ($query->num_rows() > 0)
            {
                $row = $query->row_array();
                $this->phpsession->save('user',
                        array('userid' => $row['userid'],
                              'name' => $row['name'],
                              'email' => $row['email'],
                              'usertype' => $row['usertype']));
                redirect('my/index');
            }
            else
            {
                $data['error'] = array();
                $data['error'][] = 'メールアドレス、またはパスワードが間違っています。';
                $this->load->vars($data);
                $this->load->view('users/login');
            }
        }
    }
    
    public function logout()
    {
        $this->load->library('phpsession');
        
        $this->phpsession->clear('user');
        redirect('');
    }
    
    /**
     * ユーザ登録
     */
    public function register()
    {
        $this->load->helper(array('form', 'url'));
        
        $this->load->library('form_validation');
        $this->form_validation->set_error_delimiters('<div class="error">', '</div>');
        
        $this->form_validation->set_rules('email', 'メールアドレス', 'required|valid_email|trim|xss_clean');
        $this->form_validation->set_rules('password', 'パスワード', 'required|trim|xss_clean');
        $this->form_validation->set_rules('name', '氏名', 'required|trim|xss_clean');
        $this->form_validation->set_rules('name_kana', '氏名(かな)', 'required|trim|xss_clean|callback_hiragana_check');
        $this->form_validation->set_rules('postcode', '郵便番号', 'required|trim|xss_clean|callback_postcode_check');
        $this->form_validation->set_rules('prefecture', '都道府県', 'required|trim|xss_clean');
        $this->form_validation->set_rules('city', '市区町村', 'required|trim|xss_clean');
        $this->form_validation->set_rules('street', '番地', 'required|trim|xss_clean');
        $this->form_validation->set_rules('phone', '電話番号', 'required|trim|xss_clean|callback_phone_check');
        
        if ($this->form_validation->run() == FALSE)
        {
            $this->load->view('users/register');
        }
        else
        {
            // 同じEメールアドレスが登録済みでないことをチェックする
            $this->db->where('email', set_value('email'));
            $this->db->where('status > ', 0);
            $query = $this->db->get('users', 1);
            if ($query->num_rows() > 0)
            {
                $data['error'] = array();
                $data['error'][] = '同じEメールアドレスがすでに登録されています。';
                $this->load->vars($data);
                $this->load->view('users/register');
                return;
            }
            
            $actkey = uniqid();
            
            $data = array(
                           'email' => set_value('email'),
                           'password' => sha1(set_value('password')),
                           'name' => set_value('name'),
                           'name_kana' => set_value('name_kana'),
                           'postcode' => set_value('postcode'),
                           'prefecture' => set_value('prefecture'),
                           'city' => set_value('city'),
                           'street' => set_value('street'),
                           'phone' => set_value('phone'),
                           'status' => 1,
                           'usertype' => 'user',
                           'actkey' => $actkey
                        );
            $this->db->insert('users', $data);
            
            // Eメール送信
            $mail_subject = $this->Hotel_model->hotel_name . ": 会員登録メール";
            $mail_body = 
                $data['name'] . " 様\n" . 
                "この度は、" . $this->Hotel_model->hotel_name . "の会員登録をお申し込みいただき、\n" .
                "ありがとうございます。\n" . 
                "\n" .
                "下記のホームページアドレスを開くと、会員登録が完了いたします。\n" .
                "本登録アドレス : " . base_url() . 'users/activate/' . $actkey . "\n" .
                "\n" .
                $this->Hotel_model->hotel_name . "で会員登録の申し込みをおこなわれていないのにも\n" . 
                "関わらず、このメールが送られている場合は、他の方が間違って本サービスに\n" .
                "メールアドレスを登録された可能性がありますので、このメールを破棄していただくよう\n" .
                "お願いいたします。お手数をおかけしますがご容赦ください。\n";
            log_message('info', $mail_body);
            
            @qd_send_mail(
                'text', 
                $data['email'],
                $mail_subject,
                $mail_body,
                $this->Hotel_model->email);
            
            $data['password'] = set_value('password');
            $data['actkey'] = $actkey;
            $this->load->vars($data);
            
            $this->load->view('users/register_accept');
        }
    }
    
    /**
     * ユーザ有効化
     */
    public function activate($actkey)
    {
        $this->db->where('actkey', $actkey);
        $this->db->where('status', 1);
        $query = $this->db->get('users', 1);
        if ($query->num_rows() > 0)
        {
            $row = $query->row_array();
            $userid = $row['userid'];
            
            $this->db->where('userid', $userid);
            $a = array('status' => 2);
            $this->db->update('users', $a);
            
            $this->load->view('users/activate');
        }
        else
        {
            $this->load->view('users/activate_error');
        }
    }
    
    /**
     * return keycode
     */
    private function _keygen()
    {
        $size = 3;
        $key = "";
        $consonne = "bcdfghjklmnpqrstvwxz";
        $voyelle = "aeiouy";
        
        srand((double)microtime()*date("YmdGis"));
        
        for($cnt = 0; $cnt < $size; $cnt++)
        {
            $key .= $consonne[rand(0, 19)].$voyelle[rand(0, 5)];
        }
        return $key;
    }
    
    /**
     * ひらがな文字列のチェック
     */
    function hiragana_check($str)
    {
        mb_regex_encoding("UTF-8");
        $regex = "^[ぁ-ん]+$";
        if (mb_ereg($regex, $str))
        {
            return true;
        }
        $this->form_validation->set_message('hiragana_check', 'フィールド %s に、ひらがな以外の文字は使えません');
        return false;
    }
    
    /**
     * 電話番号チェック
     */
    function phone_check($str)
    {
        mb_regex_encoding("UTF-8");
        $regex = '/^\d{1,5}-?\d{1,5}-?\d{1,5}$/';
        $regex2 = '/^\d{10,11}$/';
        if (preg_match($regex, $str, $matches) || preg_match($regex2, $str, $matches))
        {
            return true;
        }
        else 
        {
            $this->form_validation->set_message('phone_check', 'フィールド %s が、電話番号の形式になっていません');
            return false;
        }
    }
    
    /**
     * 郵便番号チェック
     */
    function postcode_check($str)
    {
        mb_regex_encoding("UTF-8");
        $regex = '/^\d{3}-?\d{4}$/';
        $regex2 = '/^\d{7}$/';
        if (preg_match($regex, $str, $matches) || preg_match($regex2, $str, $matches))
        {
            return true;
        }
        else
        {
            $this->form_validation->set_message('postcode_check', 'フィールド %s が、郵便番号の形式になっていません');
            return false;
        }
    }
}

/* End of file users.php */
