<?php
/**
 * Plans
 * @package     ci-hotel
 * @author      Teruki Hosokawa <hosotk@gmail.com>
 * @licence     New BSD Licence
 */
class Plans extends MY_Controller {

    function Plans()
    {
        parent::MY_Controller();
        $this->load->model('Common_model');
    }
    
    function index()
    {
        $this->load->helper(array('form', 'url'));
        
        $this->db->select('*');
        $this->db->from('plans');
        $this->db->join('planprice', 'planprice.planid = plans.planid');
        $this->db->where('plans.status', 1);
        $query = $this->db->get();
        
        $data['plans'] = $query->result_array();
        $this->load->vars($data);
        
        $this->load->view('plans/index');
    }
    
    /**
     * プラン詳細
     */
    function detail($planid)
    {
        $this->load->helper(array('form', 'url'));
        
        $this->db->select('*');
        $this->db->from('plans');
        $this->db->join('planprice', 'planprice.planid = plans.planid');
        $this->db->where('plans.planid', $planid);
        $this->db->where('plans.status', 1);
        $query = $this->db->get();
        if ($query->num_rows() <= 0)
        {
            die();
        }
        $row = $query->row_array();
        $data = $row;
        
        $data['planid'] = $planid;
        $this->load->vars($data);
        
        $this->load->view('plans/detail');
    }
    
    /**
     * プラン空きカレンダー表示
     * @param $planid
     * @param $d        yyyymm
     */
    function vacantplans($planid, $year, $month)
    {
        $this->load->helper('url');
        
        // プラン情報取得
        $this->db->where('planid', $planid);
        $this->db->where('status', 1);
        $query = $this->db->get('plans', 1);
        if ($query->num_rows() <= 0)
        {
            die();
        }
        $plan = $query->row_array();
        $this->load->vars($plan);
        $roomtypeid = $plan['roomtypeid'];
        
        // プラン料金取得
        $this->db->where('planid', $planid);
        $query = $this->db->get('planprice', 1);
        if ($query->num_rows() <= 0)
        {
            die();
        }
        $planprice = $query->row_array();
        
        // 部屋タイプ情報取得
        $this->db->where('roomtypeid', $plan['roomtypeid']);
        $query = $this->db->get('roomtypes', 1);
        if ($query->num_rows() <= 0)
        {
            die();
        }
        $roomtype = $query->row_array();
        
        ob_start();
        
        $cal_data = array();
        
        // 月の日数
        $days = date('t', mktime(0, 0, 0, $month, 1, $year));
        
        $today = date("Ymd");
        
        $date_from = sprintf('%04d%02d%02d', $year, $month, 1);
        $date_to = sprintf('%04d%02d%02d', $year, $month, $days);
        
        // 当月中の空きプラン人数を配列に保存する。
        $vacantplans = array();
        $this->db->where('planid', $planid);
        $this->db->where(array('day >=' => $date_from, 'day <=' => $date_to));
        $query = $this->db->get('vacantplans');
        foreach ($query->result() as $row)
        {
            $vacantplans[$row->day] = array(
                'vp_inuse' => $row->vp_inuse,
                'vp_num' => $row->vp_num);
        }
        //var_dump($vacantplans);
        
        // 当月中の空き部屋数を配列に保存する。
        $vacantrooms = array();
        $this->db->where('roomtypeid', $roomtype['roomtypeid']);
        $this->db->where(array('day >=' => $date_from, 'day <=' => $date_to));
        $query = $this->db->get('vacantrooms');
        foreach ($query->result() as $row)
        {
            $vacantrooms[$row->day] = array(
                'vr_inuse' => $row->vr_inuse,
                'vr_num' => $row->vr_num);
        }
        //var_dump($vacantrooms);
        
        // 当月中の日程を配列に保存する。
        $daytype = array();
        $this->db->where(array('day >=' => $date_from, 'day <=' => $date_to));
        $query = $this->db->get('daytype');
        foreach ($query->result() as $row)
        {
            $daytype[$row->day] = array('value' => $row->value);
        }
        //var_dump($daytype);
        
        $plan_start_date = substr($plan['start_date'], 0, 4) . substr($plan['start_date'], 5, 2) . substr($plan['start_date'], 8, 2);
        $plan_end_date = substr($plan['end_date'], 0, 4) . substr($plan['end_date'], 5, 2) . substr($plan['end_date'], 8, 2);
        
        $roomtype_start_date = substr($roomtype['start_date'], 0, 4) . substr($roomtype['start_date'], 5, 2) . substr($roomtype['start_date'], 8, 2);
        $roomtype_end_date = substr($roomtype['end_date'], 0, 4) . substr($roomtype['end_date'], 5, 2) . substr($roomtype['end_date'], 8, 2);
        
        if ($plan_start_date > $roomtype_start_date)
        {
            $start_date = $plan_start_date;
        }
        else
        {
            $start_date = $roomtype_start_date;
        }
        if ($plan_end_date > $roomtype_end_date)
        {
            $end_date = $roomtype_end_date;
        }
        else
        {
            $end_date = $plan_end_date;
        }
        
        for ($i = 1; $i <= $days; $i++)
        {
            $d = sprintf('%04d%02d%02d', $year, $month, $i);
            
            // 提供期間内であるか？
            if ($d < $start_date || $d > $end_date)
            {
                $cal_data[$i] = "<br /><br /><br />";
                continue;
            }
            
            // 予約受付範囲内であるか？
            if ($today > $d)
            {
                // 今日より前
                $cal_data[$i] = "<br /><br /><br />";
                continue;
            }
            
            $celldata = '';
            $v_plan = 0;
            $v_room = 0;
            $tmp = sprintf("%04d-%02d-%02d", $year, $month, $i);
            
            // 空きプラン人数
            if (array_key_exists($tmp, $vacantplans) != false)
            {
                $v_plan = $vacantplans[$tmp]['vp_num'] - $vacantplans[$tmp]['vp_inuse'];
            }
            else
            {
                $v_plan = $plan['default_num'];
            }
            
            // 空き部屋数
            if (array_key_exists($tmp, $vacantrooms) != false)
            {
                $v_room = $vacantrooms[$tmp]['vr_num'] - $vacantrooms[$tmp]['vr_inuse'];
            }
            else
            {
                $v_room = $roomtype['default_num'];
            }
            
            // 日程
            $daytype_value = 'A';
            if (array_key_exists($tmp, $daytype) != false)
            {
                $daytype_value = $daytype[$tmp]['value'];
            }
            
            if ($daytype_value == 'Z')
            {
                $cal_data[$i] = '休館日<br /><br /><br />';
            }
            else if ($v_plan > 0 && $v_room > 0)
            {
                // 空き有り
                $url = sprintf("%d/%04d%02d%02d", $planid, $year, $month, $i);
                
                // 料金
                switch ($daytype_value)
                {
                    case 'A':
                        $price = $planprice['a_basic_price'];
                        break;
                    case 'B':
                        $price = $planprice['b_basic_price'];
                        break;
                    case 'C':
                        $price = $planprice['c_basic_price'];
                        break;
                    case 'D':
                        $price = $planprice['d_basic_price'];
                        break;
                }
                
                $sss = '<a href="' . site_url('res/index/' . $url) . '">'
                   . $v_plan . '人' . "<br />"
                   . $v_room . '部屋' . "<br />"
                   . number_format($price) . "円～"
                   . '</a>';
                $cal_data[$i] = $sss;
            }
            else
            {
                $cal_data[$i] = "×満室<br /><br /><br />";
            }
        }   // for-loop end
        
        $prefs = array (
                       'show_next_prev'  => TRUE,
                       'next_prev_url'   => site_url('plans/vacantplans/' . $planid)
                     );
        $prefs['template'] = '
           {table_open}<table class="calendar">{/table_open}
           {heading_row_start}<tr>{/heading_row_start}
           {heading_title_cell}<th colspan="{colspan}">{heading}</th>{/heading_title_cell}
           {heading_row_end}</tr>{/heading_row_end}
           {week_row_start}<tr>{/week_row_start}
           {week_day_cell}<td>{week_day}</td>{/week_day_cell}
           {week_row_end}</tr>{/week_row_end}
           {cal_row_start}<tr>{/cal_row_start}
           {cal_cell_start}<td>{/cal_cell_start}
           {cal_cell_content}{day}<br />{content}{/cal_cell_content}
           {cal_cell_content_today}<div class="highlight">{day}<br />{content}</div>{/cal_cell_content_today}
           {cal_cell_no_content}{day}{/cal_cell_no_content}
           {cal_cell_no_content_today}<div class="highlight">{day}</br /></div>{/cal_cell_no_content_today}
           {cal_cell_blank}&nbsp;{/cal_cell_blank}
           {cal_cell_end}</td>{/cal_cell_end}
           {cal_row_end}</tr>{/cal_row_end}
           {table_close}</table>{/table_close}
        ';
        
        // 前月の有無
        $nowYm = date('Ym');
        $Ym = sprintf("%04d%02d", $year, $month);
        
        if ($Ym > $nowYm)
        {
            $prefs['template'] .= 
                '{heading_previous_cell}<th><a href="{previous_url}">&lt;&lt;</a></th>{/heading_previous_cell}
                ';
        }
        else
        {
            $prefs['template'] .= 
                '{heading_previous_cell}<th></th>{/heading_previous_cell}
                ';
        }
        
        // 翌月の有無
        $nowYm = sprintf("%04d%02d", $year, $month);
        $Ym = substr($end_date, 0, 4) . substr($end_date, 4, 2);
        if ($Ym > $nowYm)
        {
            $prefs['template'] .= 
                '{heading_next_cell}<th><a href="{next_url}">&gt;&gt;</a></th>{/heading_next_cell}
                ';
        }
        else
        {
            $prefs['template'] .= 
                '{heading_next_cell}<th></th>{/heading_next_cell}
                ';
        }
        
        $this->load->library('calendar', $prefs);
        
        
        echo $this->calendar->generate($this->uri->segment(4), $this->uri->segment(5), $cal_data);
        
        echo "<br />";
        
        
        $data['contents'] = ob_get_contents();
        ob_end_clean();
        $this->load->vars($data);
        
        $this->load->view('plans/vacantplans');
    }
}
