<?php
class My extends MY_Controller {
    
    private $user = null;
    
    function My()
    {
        parent::MY_Controller();
        $this->load->model('Res_model');
        $this->load->model('Hotel_model');
        
        // ログインチェック
        $this->load->helper('url');
        $this->load->library('phpsession');
        $this->user = $this->phpsession->get('user');
        if (is_null($this->user))
        {
            redirect('');
        }
    }
    
    /**
     * 予約リストを表示する
     */
    function index()
    {
        $this->load->library('phpsession');
        $this->load->helper(array('form', 'url'));
        $data['title'] = "login";
        $data['headline'] = "";
        $this->load->vars($data);
        
        // ユーザの予約リストを得る
        $this->db->where('userid', $this->user['userid']);
        $this->db->where('status >', 0);
        $this->db->order_by('created', 'desc');
        $query = $this->db->get('reservation');
        
        $data['ress'] = $query->result_array();
        $data['title'] = "User Res";
        $data['headline'] = "";
        $this->load->vars($data);
        
        $this->load->view('my/index');
    }
    
    /**
     * 予約詳細
     */
    public function resdetail($resid)
    {
        // 予約詳細をみる
        $this->db->where('resid', $resid);
        $query = $this->db->get('reservation');
        if ($query->num_rows() > 0)
        {
            $row = $query->row_array();
            $data = $row;
        }
        else
        {
            die();
        }
        $this->load->vars($data);
        
        if ($data['userid'] != $this->user['userid'])
        {
            die();
        }
        
        $this->load->view('my/resdetail');
    }
    
    /**
     * 予約キャンセル
     */
    public function rescancel($resid)
    {
        // 予約詳細をみる
        $this->db->where('resid', $resid);
        $query = $this->db->get('reservation');
        if ($query->num_rows() > 0)
        {
            $row = $query->row_array();
            $data = $row;
            if ($data['userid'] == $this->user['userid'])
            {
                $this->Res_model->cancel($resid, 1, $this->Hotel_model);
            }
        }
        else
        {
            die();
        }
    }
    
    /**
     * ユーザ情報の表示
     */
    public function userinfo()
    {
        $this->db->where('userid', $this->user['userid']);
        $query = $this->db->get('users');
        if ($query->num_rows() > 0)
        {
            $row = $query->row_array();
            $data = $row;
            $this->load->vars($data);
        }
        $this->load->view('my/userinfo');
    }
    
    /**
     * ユーザ情報の編集
     */
    public function useredit()
    {
        $this->load->helper(array('form', 'url'));
        
        $this->load->library('form_validation');
        $this->form_validation->set_error_delimiters('<div class="error">', '</div>');
        
        $this->form_validation->set_rules('email', 'メールアドレス', 'required|valid_email|trim|xss_clean');
        $this->form_validation->set_rules('password', 'パスワード', 'trim|xss_clean');
        $this->form_validation->set_rules('name', '氏名', 'required|trim|xss_clean');
        $this->form_validation->set_rules('name_kana', '氏名(かな)', 'required|trim|xss_clean|callback_hiragana_check');
        $this->form_validation->set_rules('postcode', '郵便番号', 'required|trim|xss_clean|callback_postcode_check');
        $this->form_validation->set_rules('prefecture', '都道府県', 'required|trim|xss_clean');
        $this->form_validation->set_rules('city', '市区町村', 'required|trim|xss_clean');
        $this->form_validation->set_rules('street', '番地', 'required|trim|xss_clean');
        $this->form_validation->set_rules('phone', '電話番号', 'required|trim|xss_clean|callback_phone_check');
        
        if (!$this->input->post('submit'))
        {
            $this->db->where('userid', $this->user['userid']);
            $query = $this->db->get('users', 1);
            if ($query->num_rows() > 0)
            {
                $data = $query->row_array();
                $data['password'] = '';
                $this->load->vars($data);
            }
        }
        
        if ($this->form_validation->run() == FALSE)
        {
            //echo "Form First Or NG";
            $this->load->view('my/useredit');
        }
        else
        {
            // 同じEメールアドレスが登録済みでないことをチェックする
            $this->db->where('email', set_value('email'));
            $this->db->where('userid <> ', $this->user['userid']);    // 自分以外
            $this->db->where('status > ', 0);
            $query = $this->db->get('users', 1);
            if ($query->num_rows() > 0)
            {
                $data['error'] = array();
                $data['error'][] = '同じEメールアドレスがすでに登録されています。';
                $this->load->vars($data);
                $this->load->view('my/useredit');
                return;
            }
            
            
            $data = array(
                           'email' => set_value('email'),
                           'password' => sha1(set_value('password')),
                           'name' => set_value('name'),
                           'name_kana' => set_value('name_kana'),
                           'postcode' => set_value('postcode'),
                           'prefecture' => set_value('prefecture'),
                           'city' => set_value('city'),
                           'street' => set_value('street'),
                           'phone' => set_value('phone')
                        );
            $this->db->where('userid', $this->user['userid']);
            $this->db->update('users', $data);
            
            if (set_value('password') != '')
            {
                $data = array('password' => sha1(set_value('password')));
                $this->db->where('userid', $this->user['userid']);
                $this->db->update('users', $data);
            }
        }
        
        $this->load->view('my/useredit');
    }
    
    /**
     * 退会
     */
    public function unregister()
    {
        $data = array('status' => -1);
        $this->db->where('userid', $this->user['userid']);
        $this->db->update('users', $data);
        
        // ログアウト処理
        $this->load->library('phpsession');
        $this->phpsession->clear('user');
        
        $this->load->view('my/unregister');
    }
}
