<?php
/**
 * 未登録ユーザの予約キャンセル
 *
 * 予約コード,Eメールを入力して予約をキャンセルする。
 */
class Cancel extends MY_Controller {
    
    function Cancel()
    {
        parent::MY_Controller();
        $this->load->model('Res_model');
        $this->load->model('Hotel_model');
    }
    
    function index()
    {
        $this->load->helper(array('form', 'url'));
        $this->load->library('form_validation');
        
        $this->form_validation->set_rules('rescode', '予約コード', 'required|trim|xss_clean');
        $this->form_validation->set_rules('email', 'メールアドレス', 'required|trim|xss_clean');
        
        if ($this->form_validation->run() == FALSE)
        {
            $this->load->view('cancel/index');
            return;
        }
        else
        {
            $rescode = set_value('rescode');
            $email = set_value('email');
            
            $this->db->where('rescode', $rescode);
            $query = $this->db->get('reservation', 1);
            if ($query->num_rows() <= 0)
            {
                $this->load->view('cancel/index');
                return;
            }
            $reservation = $query->row_array();
            $resid = $reservation['resid'];
            
            $this->db->where('resid', $resid);
            $this->db->where('email', $email);
            $query = $this->db->get('resuser', 1);
            if ($query->num_rows() <= 0)
            {
                $this->load->view('cancel/index');
                return;
            }
            $row = $query->row_array();
            
            // OK
            $this->Res_model->cancel($resid, 1, $this->Hotel_model);
            redirect('cancel/accept');
        }
        
        
        
        $this->load->view('cancel/index');
    }
    
    /**
     * キャンセル完了
     */
    function accept()
    {
        $this->load->view('cancel/accept');
    }
}

