<?php
/**
 * Reservation Management
 * @package     ci-htel hotel
 * @author      Teruki Hosokawa <hosotk@gmail.com>
 * @license     New BSD Licence
 */
require_once (dirname(__FILE__) . "/ADMIN_Controller.php");

class Res extends ADMIN_Controller {

    function Res()
    {
        parent::ADMIN_Controller();
        $this->load->model('User_model');
        $this->load->model('Res_model');
        $this->load->model('Hotel_model');
        $this->load->model('Common_model');
    }
    
    public function index()
    {
        $this->load->helper(array('form', 'url'));
        redirect('admin/res/page');
    }
    
    /**
     * \ꗗ
     */
    public function page($offset = 0)
    {
        $this->load->helper(array('form', 'url'));
        
        $limit = 20;    // 1y[W\
        
        $this->db->select('reservation.resid, reservation.created, resuser.name, reservation.cin, reservation.cout, reservation.plan_num, reservation.room_num, reservation.total_price, reservation.status, reservation.basic_num, plans.plan_name');
        $this->db->from('reservation');
        $this->db->order_by('reservation.created DESC');
        $this->db->join('resuser', 'resuser.resid = reservation.resid');
        $this->db->join('plans', 'plans.planid = reservation.planid');
        $this->db->limit($limit, $offset);
        $query = $this->db->get();
        
        $data['ress'] = $query->result_array();
        //var_dump($data);
        //$data['title'] = "Plans";
        //$data['headline'] = "";
        //$this->load->vars($data);
        
        $this->load->library('pagination');
        
        // R[h̎擾
        $total_rows = $this->db->count_all('reservation');
        
        $pager_config['uri_segment'] = 4;
        $pager_config['base_url'] = base_url() . 'admin/res/page/';
        $pager_config['total_rows'] = $total_rows;
        $pager_config['per_page'] = $limit;
        
        $this->pagination->initialize($pager_config);
        
        $data['links'] = $this->pagination->create_links();
        $this->load->vars($data);
        
        $this->load->view('admin/res/page');
    }
    
    /**
     * \ڍ
     */
    public function detail($resid)
    {
        $this->load->helper(array('form', 'url'));
        
        $data['title'] = "Res";
        $data['headline'] = "";
        
        $this->db->select('reservation.resid, reservation.rescode, reservation.created, resuser.name, reservation.cin, reservation.cout, reservation.cinhour, reservation.memo, reservation.plan_num, reservation.room_num, reservation.total_price, reservation.status, reservation.basic_num, reservation.child1_num, reservation.child2_num, reservation.child3_num, reservation.child4_num, plans.plan_name, roomtypes.roomtype_name');
        $this->db->from('reservation');
        $this->db->order_by('reservation.created DESC');
        $this->db->join('resuser', 'resuser.resid = reservation.resid');
        $this->db->join('plans', 'plans.planid = reservation.planid');
        $this->db->join('roomtypes', 'roomtypes.roomtypeid = reservation.roomtypeid');
        $this->db->where('reservation.resid', $resid);
        $query = $this->db->get();
        if ($query->num_rows() > 0)
        {
            $row = $query->row_array();
            $data = $row;
        }
        $data['resid'] = $resid;
        $this->load->vars($data);
        
        $this->db->where('resid', $resid);
        $query = $this->db->get('resuser', 1);
        if ($query->num_rows() > 0)
        {
            $row = $query->row_array();
            $data = $row;
        }
        $this->load->vars($data);
        
        $this->load->view('admin/res/detail');
    }
    
    /**
     * \Xe[^XύXB
     * ύXA\ڍ׉ʂɑJڂB
     */
    public function changeStatus($resid, $new_status)
    {
        $this->load->helper(array('form', 'url'));
        
        $this->db->where('resid', $resid);
        $query = $this->db->get('reservation', 1);
        if ($query->num_rows() <= 0)
        {
            return;
        }
        
        $row = $query->row_array();
        $status = $row['status'];
        
        if ($new_status == 2)
        {
            /**
             * \->{\
             */
            $this->Res_model->confirmRes($resid, $this->Hotel_model);
        }
        else if ($new_status == 0)
        {
            if ($status == 1)
            {
                // \ -> LZ
                $this->Res_model->cancel($resid, 2, $this->Hotel_model);
            }
            else if ($status == 2)
            {
                // {\ -> LZ
                $this->Res_model->cancel($resid, 3, $this->Hotel_model);
            }
        }
        
        redirect('admin/res/detail/' . $resid);
    }
}
/* End of file res.php */
