<?php
/**
 * Plans Management
 * @package     ci-hotel
 * @author      Teruki Hosokawa <hosotk@gmail.com>
 * @license     New BSD License
 */
require_once (dirname(__FILE__) . "/ADMIN_Controller.php");

class Plans extends ADMIN_Controller {

    function Plans()
    {
        parent::ADMIN_Controller();
        $this->load->model('User_model');
        $this->load->model('Common_model');
    }
    
    /**
     * プラン一覧
     */
    public function index()
    {
        $this->load->helper(array('form', 'url'));
        //$this->db->order_by('ordering ASC');
        $this->db->where('status', 1);
        $query = $this->db->get('plans');
        $data['plans'] = $query->result_array();
        $this->load->vars($data);
        
        $this->load->view('admin/plans/index');
    }
    
    /**
     * プランの新規作成
     */
    public function add()
    {
        $this->load->helper(array('form', 'url'));
        $this->load->helper('ck');

        $data['summary'] = '';
        $data['description'] = '';
        $this->load->vars($data);
        
        $dbres = $this->db->get('roomtypes');
        $ddmenu = array();
        foreach ($dbres->result_array() as $tablerow) {
            $ddmenu[$tablerow['roomtypeid']] = $tablerow['roomtype_name'];
        }
        $data['options'] = $ddmenu;
        
        $this->load->vars($data);
        
        $this->load->library('form_validation');
        $this->form_validation->set_error_delimiters('<div class="error">', '</div>');
        
        $this->form_validation->set_rules('plan_name', 'プラン名', 'required|trim|xss_clean');
        $this->form_validation->set_rules('summary', '概要', 'required');
        $this->form_validation->set_rules('description', '説明', '');
        $this->form_validation->set_rules('start_date', '開始日付', 'required|trim|xss_clean');
        $this->form_validation->set_rules('end_date', '終了日時', 'required|trim|xss_clean');
        $this->form_validation->set_rules('default_num', 'デフォルト数', 'required|integer|trim|xss_clean');
        $this->form_validation->set_rules('guest_min', '最小人数', 'required|integer|trim|xss_clean');
        $this->form_validation->set_rules('guest_max', '最大人数', 'required|integer|trim|xss_clean');
        $this->form_validation->set_rules('roomtypeid', '部屋タイプ', 'required|integer|trim|xss_clean');
        // プラン料金
        $this->form_validation->set_rules('a_basic_price' , 'A日程 基本料金' , 'required|integer|trim|xss_clean');
        $this->form_validation->set_rules('b_basic_price' , 'B日程 基本料金' , 'required|integer|trim|xss_clean');
        $this->form_validation->set_rules('c_basic_price' , 'C日程 基本料金' , 'required|integer|trim|xss_clean');
        $this->form_validation->set_rules('d_basic_price' , 'D日程 基本料金' , 'required|integer|trim|xss_clean');
        $this->form_validation->set_rules('a_child1_price', 'A日程 子供A料金', 'required|integer|trim|xss_clean');
        $this->form_validation->set_rules('b_child1_price', 'B日程 子供A料金', 'required|integer|trim|xss_clean');
        $this->form_validation->set_rules('c_child1_price', 'C日程 子供A料金', 'required|integer|trim|xss_clean');
        $this->form_validation->set_rules('d_child1_price', 'D日程 子供A料金', 'required|integer|trim|xss_clean');
        $this->form_validation->set_rules('a_child2_price', 'A日程 子供B料金', 'required|integer|trim|xss_clean');
        $this->form_validation->set_rules('b_child2_price', 'B日程 子供B料金', 'required|integer|trim|xss_clean');
        $this->form_validation->set_rules('c_child2_price', 'C日程 子供B料金', 'required|integer|trim|xss_clean');
        $this->form_validation->set_rules('d_child2_price', 'D日程 子供B料金', 'required|integer|trim|xss_clean');
        $this->form_validation->set_rules('a_child3_price', 'A日程 子供C料金', 'required|integer|trim|xss_clean');
        $this->form_validation->set_rules('b_child3_price', 'B日程 子供C料金', 'required|integer|trim|xss_clean');
        $this->form_validation->set_rules('c_child3_price', 'C日程 子供C料金', 'required|integer|trim|xss_clean');
        $this->form_validation->set_rules('d_child3_price', 'D日程 子供C料金', 'required|integer|trim|xss_clean');
        $this->form_validation->set_rules('a_child4_price', 'A日程 子供D料金', 'required|integer|trim|xss_clean');
        $this->form_validation->set_rules('b_child4_price', 'B日程 子供D料金', 'required|integer|trim|xss_clean');
        $this->form_validation->set_rules('c_child4_price', 'C日程 子供D料金', 'required|integer|trim|xss_clean');
        $this->form_validation->set_rules('d_child4_price', 'D日程 子供D料金', 'required|integer|trim|xss_clean');
        
        if (!$this->input->post('submit'))
        {
            $data['default_num'] = 1;
            $data['guest_min'] = 1;
            $data['guest_max'] = 1;
            $this->load->vars($data);
        }
        if ($this->form_validation->run() == FALSE)
        {
            //echo "Form First Or NG";
            $this->load->view('admin/plans/add');
            return;
        }
        else
        {
            $start_date = set_value('start_date');
            $end_date = set_value('end_date');
            // 日付のチェック
            if ($this->Common_model->checkDate($start_date) == false)
            {
                $data['error'] = array();
                $data['error'][] = '開始日付の形式が不正です。';
                $this->load->vars($data);
                $this->load->view('admin/plans/add');
                return;
            }
            if ($this->Common_model->checkDate($end_date) == false)
            {
                $data['error'] = array();
                $data['error'][] = '終了日付の形式が不正です。';
                $this->load->vars($data);
                $this->load->view('admin/plans/add');
                return;
            }
            // 開始日付 < 終了日付
            if ($start_date >= $end_date)
            {
                $data['error'] = array();
                $data['error'][] = '終了日付は開始日付の翌日以降を指定します。';
                $this->load->vars($data);
                $this->load->view('admin/plans/add');
                return;
            }
            // 最小人数 <= 最大人数
            $guest_min = set_value('guest_min');
            $guest_max = set_value('guest_max');
            if ($guest_min > $guest_max)
            {
                $data['error'] = array();
                $data['error'][] = '最大人数は最小人数以上を指定します。';
                $this->load->vars($data);
                $this->load->view('admin/plans/add');
                return;
            }
            
            $data = array(
                           'plan_name' => set_value('plan_name'),
                           'summary' => $_POST['summary'],
                           'description' => $_POST['description'],
                           'start_date' => set_value('start_date'),
                           'end_date' => set_value('end_date'),
                           'default_num' => set_value('default_num'),
                           'guest_min' => set_value('guest_min'),
                           'guest_max' => set_value('guest_max'),
                           'roomtypeid' => set_value('roomtypeid'),
                           'status' => 1
                        );
            $this->db->insert('plans', $data);
            $planid = $this->db->insert_id();
            
            $data = array(
                'planid' => intval($planid),
                'a_basic_price'  => set_value('a_basic_price'),
                'b_basic_price'  => set_value('b_basic_price'),
                'c_basic_price'  => set_value('c_basic_price'),
                'd_basic_price'  => set_value('d_basic_price'),
                'a_child1_price' => set_value('a_child1_price'),
                'b_child1_price' => set_value('b_child1_price'),
                'c_child1_price' => set_value('c_child1_price'),
                'd_child1_price' => set_value('d_child1_price'),
                'a_child2_price' => set_value('a_child2_price'),
                'b_child2_price' => set_value('b_child2_price'),
                'c_child2_price' => set_value('c_child2_price'),
                'd_child2_price' => set_value('d_child2_price'),
                'a_child3_price' => set_value('a_child3_price'),
                'b_child3_price' => set_value('b_child3_price'),
                'c_child3_price' => set_value('c_child3_price'),
                'd_child3_price' => set_value('d_child3_price'),
                'a_child4_price' => set_value('a_child4_price'),
                'b_child4_price' => set_value('b_child4_price'),
                'c_child4_price' => set_value('c_child4_price'),
                'd_child4_price' => set_value('d_child4_price')
                );
            $this->db->insert('planprice', $data); 
            
            redirect('admin/plans');
        }
    }
    
    /**
     * プランの編集
     */
    public function edit($planid)
    {
        $this->load->helper(array('form', 'url'));
        $this->load->helper('ck');
        
        $data['planid'] = $planid;
        $data['summary'] = '';
        $data['description'] = '';
        $this->load->vars($data);
        
        $this->load->library('form_validation');
        $this->form_validation->set_error_delimiters('<div class="error">', '</div>');
        
        // ruleがないときも空でset_rules()しておく。
        // そうでないとset_value()で値が取れなくなる。
        $this->form_validation->set_rules('plan_name', 'プラン名', 'required|trim|xss_clean');
        $this->form_validation->set_rules('summary', '概要', 'required');
        $this->form_validation->set_rules('description', '説明', '');
        $this->form_validation->set_rules('start_date', '開始日付', 'required|trim|xss_clean');
        $this->form_validation->set_rules('end_date', '終了日付', 'required|trim|xss_clean');
        $this->form_validation->set_rules('default_num', 'デフォルト数', 'required|integer|trim|xss_clean');
        $this->form_validation->set_rules('guest_min', '最小人数', 'required|integer|trim|xss_clean');
        $this->form_validation->set_rules('guest_max', '最大人数', 'required|integer|trim|xss_clean');
        $this->form_validation->set_rules('roomtypeid', '部屋タイプ', 'required|integer|trim|xss_clean');
        
        // プラン料金
        $this->form_validation->set_rules('a_basic_price' , 'A日程 基本料金' , 'required|integer|trim|xss_clean');
        $this->form_validation->set_rules('b_basic_price' , 'B日程 基本料金' , 'required|integer|trim|xss_clean');
        $this->form_validation->set_rules('c_basic_price' , 'C日程 基本料金' , 'required|integer|trim|xss_clean');
        $this->form_validation->set_rules('d_basic_price' , 'D日程 基本料金' , 'required|integer|trim|xss_clean');
        $this->form_validation->set_rules('a_child1_price', 'A日程 子供A料金', 'required|integer|trim|xss_clean');
        $this->form_validation->set_rules('b_child1_price', 'B日程 子供A料金', 'required|integer|trim|xss_clean');
        $this->form_validation->set_rules('c_child1_price', 'C日程 子供A料金', 'required|integer|trim|xss_clean');
        $this->form_validation->set_rules('d_child1_price', 'D日程 子供A料金', 'required|integer|trim|xss_clean');
        $this->form_validation->set_rules('a_child2_price', 'A日程 子供B料金', 'required|integer|trim|xss_clean');
        $this->form_validation->set_rules('b_child2_price', 'B日程 子供B料金', 'required|integer|trim|xss_clean');
        $this->form_validation->set_rules('c_child2_price', 'C日程 子供B料金', 'required|integer|trim|xss_clean');
        $this->form_validation->set_rules('d_child2_price', 'D日程 子供B料金', 'required|integer|trim|xss_clean');
        $this->form_validation->set_rules('a_child3_price', 'A日程 子供C料金', 'required|integer|trim|xss_clean');
        $this->form_validation->set_rules('b_child3_price', 'B日程 子供C料金', 'required|integer|trim|xss_clean');
        $this->form_validation->set_rules('c_child3_price', 'C日程 子供C料金', 'required|integer|trim|xss_clean');
        $this->form_validation->set_rules('d_child3_price', 'D日程 子供C料金', 'required|integer|trim|xss_clean');
        $this->form_validation->set_rules('a_child4_price', 'A日程 子供D料金', 'required|integer|trim|xss_clean');
        $this->form_validation->set_rules('b_child4_price', 'B日程 子供D料金', 'required|integer|trim|xss_clean');
        $this->form_validation->set_rules('c_child4_price', 'C日程 子供D料金', 'required|integer|trim|xss_clean');
        $this->form_validation->set_rules('d_child4_price', 'D日程 子供D料金', 'required|integer|trim|xss_clean');
        
        $dbres = $this->db->get('roomtypes');
        $ddmenu = array();
        foreach ($dbres->result_array() as $tablerow) {
          $ddmenu[$tablerow['roomtypeid']] = $tablerow['roomtype_name'];
        }
        
        // フォームの初期値設定
        if (!$this->input->post('submit'))
        {
            $this->db->where('planid', $planid);
            $this->db->where('status', 1);
            $query = $this->db->get('plans', 1);
            if ($query->num_rows() <= 0)
            {
                die();
            }
            $row = $query->row_array();
            $data['plan_name'] = $row['plan_name'];
            $data['summary'] = $row['summary'];
            $data['description'] = $row['description'];
            $data['start_date'] = substr($row['start_date'], 0, 10);
            $data['end_date'] = substr($row['end_date'], 0, 10);
            $data['default_num'] = $row['default_num'];
            $data['guest_min'] = $row['guest_min'];
            $data['guest_max'] = $row['guest_max'];
            $data['roomtypeid'] = $row['roomtypeid'];
            $data['options'] = $ddmenu;
            $this->load->vars($data);
            
            $this->db->where('planid', $planid);
            $query = $this->db->get('planprice');
            if ($query->num_rows() <= 0)
            {
                die();
            }
            $data = $query->row_array();
            $this->load->vars($data);
        }
        
        if ($this->form_validation->run() == FALSE)
        {
            $this->load->view('admin/plans/edit');
        }
        else
        {
            $start_date = set_value('start_date');
            $end_date = set_value('end_date');
            // 日付のチェック
            if ($this->Common_model->checkDate($start_date) == false)
            {
                $data['error'] = array();
                $data['error'][] = '開始日付の形式が不正です。';
                $this->load->vars($data);
                $this->load->view('admin/plans/edit');
                return;
            }
            if ($this->Common_model->checkDate($end_date) == false)
            {
                $data['error'] = array();
                $data['error'][] = '終了日付の形式が不正です。';
                $this->load->vars($data);
                $this->load->view('admin/plans/edit');
                return;
            }
            // 開始日付 < 終了日付
            if ($start_date >= $end_date)
            {
                $data['error'] = array();
                $data['error'][] = '終了日付は開始日付の翌日以降を指定します。';
                $this->load->vars($data);
                $this->load->view('admin/plans/edit');
                return;
            }
            // 最小人数 <= 最大人数
            $guest_min = set_value('guest_min');
            $guest_max = set_value('guest_max');
            if ($guest_min > $guest_max)
            {
                $data['error'] = array();
                $data['error'][] = '最大人数は最小人数以上を指定します。';
                $this->load->vars($data);
                $this->load->view('admin/plans/add');
                return;
            }
            
            $data = array(
                           'plan_name' => set_value('plan_name'),
                           'summary' => $_POST['summary'],
                           'description' => $_POST['description'],
                           'start_date' => set_value('start_date'),
                           'end_date' => set_value('end_date'),
                           'default_num' => set_value('default_num'),
                           'guest_min' => set_value('guest_min'),
                           'guest_max' => set_value('guest_max'),
                           'roomtypeid' => set_value('roomtypeid')
                        );
            $this->db->where('planid', $planid);
            $this->db->update('plans', $data);
            
            $data = array(
                'a_basic_price'  => set_value('a_basic_price'),
                'b_basic_price'  => set_value('b_basic_price'),
                'c_basic_price'  => set_value('c_basic_price'),
                'd_basic_price'  => set_value('d_basic_price'),
                'a_child1_price' => set_value('a_child1_price'),
                'b_child1_price' => set_value('b_child1_price'),
                'c_child1_price' => set_value('c_child1_price'),
                'd_child1_price' => set_value('d_child1_price'),
                'a_child2_price' => set_value('a_child2_price'),
                'b_child2_price' => set_value('b_child2_price'),
                'c_child2_price' => set_value('c_child2_price'),
                'd_child2_price' => set_value('d_child2_price'),
                'a_child3_price' => set_value('a_child3_price'),
                'b_child3_price' => set_value('b_child3_price'),
                'c_child3_price' => set_value('c_child3_price'),
                'd_child3_price' => set_value('d_child3_price'),
                'a_child4_price' => set_value('a_child4_price'),
                'b_child4_price' => set_value('b_child4_price'),
                'c_child4_price' => set_value('c_child4_price'),
                'd_child4_price' => set_value('d_child4_price')
                );
            $this->db->where('planid', $planid);
            $this->db->update('planprice', $data); 
            
            redirect('admin/plans');
        }
    }
    
    /**
     * プランの削除
     */
    public function delete($planid)
    {
        $data = array('status' => -1);
        $this->db->where('planid', $planid);
        $this->db->update('plans', $data);
        
        redirect('admin/plans');
    }
    
    /**
     * プランの割り当て人数編集
     */
    public function vacantplans($planid, $cal)
    {
        // TODO V1.0以降
    }
}

/* End of file plans.php */
