package ipatjava.tips;
import java.util.*;

public class BitSetTips
{
    public static BitSet rShift(BitSet b,int r)
    { 
	BitSet result = new BitSet();
	for(int i=b.nextSetBit(0);i!=-1;i=b.nextSetBit(i+1))
	    result.set(r+i);
	return result;
    }

    public static int cardinality(BitSet b,int index)
    {
	int num = 0;
	for(int i=b.nextSetBit(0);i!=-1 && i <= index;i=b.nextSetBit(i+1))
	    num++;
	return num;
    }

    public static BitSet not(BitSet b,int length)
    { 
	BitSet result = (BitSet)b.clone();
	result.flip(0,length);
	return result;
    }

    public static BitSet and(BitSet b1,BitSet b2)
    { 
	BitSet result = (BitSet)b1.clone();
	result.and(b2);
	return result;
    }

    public static BitSet andNot(BitSet b1,BitSet b2)
    { 
	BitSet result = (BitSet)b1.clone();
	result.andNot(b2);
	return result;
    }

    public static BitSet or(BitSet b1,BitSet b2)
    { 
	BitSet result = (BitSet)b1.clone();
	result.or(b2);
	return result;
    }

    public static BitSet xor(BitSet b1,BitSet b2)
    { 
	BitSet result = (BitSet)b1.clone();
	result.xor(b2);
	return result;
    }


}
