package ipatjava.graph;
import java.util.*;
import ipatjava.data.*;
import ipatjava.data.block.*;

public class FlowGraph extends Graph
{
    private BitSet pred[];
    private BitSet dom[];

    public FlowGraph(Data data)
    {
	super(data);
	calc();
    }

    public void calc()
    {
	calc_successor();
	calc_predecessor();
	calc_dominate(0);
    }

    private void calc_successor()
    {
	super.data.setDataRelation();

	BitSet node = new BitSet();

	for(ListIterator li1 = super.data.getDataList().listIterator();li1.hasNext();)
	    {
		Data d1 = (Data)li1.next();
		if(d1 instanceof StatementDataNode)
		    node.set(d1.getDataIndex());
		else
		    continue;
	    }

	super.setNode(node);

	for(int i= node.nextSetBit(0) ; i!=-1 ; i= node.nextSetBit(i+1))
	    {
		Data d1 = (Data)super.data.getDataList().get(i);
		for(ListIterator li1 = d1.getStatementDataSocket().getNext().listIterator(); li1.hasNext();)
		    {
			Data d2 = (Data)li1.next();
			super.set(super.getNodeIndex(i),super.getNodeIndex(d2.getDataIndex()));
		    }
	    }

	//super.printGraph();
	
    }

    private void calc_predecessor()
    {
        if(super.graph == null)
            return;
        int size = super.graph.length;
        pred = new BitSet[size];
        for(int i = 0 ; i < size ; i++)
            {
                pred[i]=new BitSet();
                for(int j = 0 ; j < size ; j++)
                    if(super.graph[j].get(i))
                        pred[i].set(j);
            }
    }

    private void calc_dominate(int start)
    {
        if(pred == null)
            return;

        int size = super.graph.length;
        dom = new BitSet[size];

        for(int i=0; i < size ; i++)    
            {
                dom[i]=new BitSet();
                if(i!=start)
                    for(int j = 0 ; j < size ;j++)
                        dom[i].set(j);
                else
                    dom[i].set(i);
            }

        boolean change = true;

        while(change)
            {
                change=false;
                for(int i=0; i < size ; i++)
                    {
                        if(i==start)
                            continue;
                        
                        BitSet olddom=(BitSet)dom[i].clone();
                        int j = pred[i].nextSetBit(0);
                            
                        if(j!=-1)
                            dom[i] = (BitSet)dom[j].clone();
                            
                        for(j = pred[i].nextSetBit(j+1); j!=-1 ;j = pred[i].nextSetBit(j+1))
                            dom[i].and(dom[j]);

                        dom[i].set(i);
                        olddom.xor(dom[i]);
                        
                        if(!olddom.isEmpty())
                            change=true;
                    }
            }
    }   
    
    public BitSet[] getPredecessor(){return pred;}
    public BitSet[] getDominate(){return dom;}
}
