package ipatjava.data.term.array;
import ipatjava.data.Data;
import ipatjava.data.expr.ExprData;
import ipatjava.data.term.TermData;
import ipatjava.tips.XMLTips;

import java.util.LinkedList;
import java.util.List;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import exc.object.LineNo;
import exc.object.Xcode;
import exc.object.XobjArgs;
import exc.object.XobjList;
import exc.object.Xobject;

public class ArrayTermData extends TermData
{
	private XobjList id = new XobjList();
    private List elements = new LinkedList();
    
    public ArrayTermData(Xobject term,LineNo lineNo,Data parent)
    {
	super(term,lineNo,parent);
	traverse(term,lineNo);
    }

    public void traverse(Xobject term,LineNo lineNo)
    {
        switch(term.Opcode())
            {
            case Xcode.PLUS_EXPR:
                traverse(term.left(),lineNo);
                ExprData d = ExprData.nextExpr(term.right(),lineNo,this);
                super.mergeDataList(d);
                elements.add(d);
                break;
            case Xcode.ARRAY_AREF:
                switch(term.left().Opcode())
                    {
                    case Xcode.POINTER_REF:
                        id.add(term.left());
                        break;
                    default:
                        break;
                    } 
            case Xcode.POINTER_REF:
                traverse(term.left(),lineNo);
                break;
            case Xcode.PARAM_ADDR:
            case Xcode.LVAR_ADDR:
            case Xcode.VAR_ADDR:
            case Xcode.LARRAY_ADDR:
            case Xcode.ARRAY_ADDR:
                id.add(term);
                break;
            case Xcode.MEMBER_ARRAY_ADDR:
            case Xcode.MEMBER_ADDR:
                traverse(term.left(),lineNo);
                id.add(term.right());
                break;
            default:
                break;
            }   
    }

    public boolean isRead(){return true;}

    public boolean isWrite(){return false;}

    public boolean isReduction(){return false;}

    public Xobject getArrayID(){return (Xobject) id;}

    public String getArrayIdName()
    {
        String str="";
        for(XobjArgs args = id.getArgs() ; args != null ; args = args.nextArgs())
            {
                Xobject arg = args.getArg();
                str=str+arg.getName();
                if(args.nextArgs()!=null)
                    str=str+".";
            }
        return str;
    }

    public int getElementSize(){return elements.size();}
    public ExprData getElement(int i){return (ExprData)elements.get(i);}

    public Element getXMLElement(Document document)
    {
        Element element = XMLTips.createElement(document,"data");
        element.setAttribute("source",super.getLineNo().fileName());
        element.setAttribute("lineno",Integer.toString(super.getLineNo().lineNo()));
        element.setAttribute("type","Array");
        element.setAttribute("name",this.getArrayIdName());
        return element;
    }

    public int[][] getElementMatrix(Xobject id[])
    {
        int row = id.length;
        int col = elements.size();
        int result[][] = new int[row][col];
        for(int i = 0 ; i < row ; i++)
            for(int j = 0 ; j < col ; j++)
                result[i][j] = ((ExprData)elements.get(j)).getIdValueList().getValue(id[i]);
        
        return result;
    }

    public int[] getElementVector()
    {
        int col = elements.size();
        int result[] = new int[col];
        
        for(int i = 0 ; i < col ; i++)
            result[i] = ((ExprData)elements.get(i)).getIdValueList().getValue();
        
        return result;
    }
}
