package ipatjava.data.term;
import exc.object.*;
import ipatjava.data.*;
import ipatjava.data.expr.*;
import ipatjava.data.term.array.*;
import ipatjava.data.term.constant.ConstantTermData;
import ipatjava.data.term.function.FunctionTermData;
import ipatjava.data.term.scalar.*;

public class TermData extends ExprData
{

    public TermData(Xobject term,LineNo lineNo,Data parent)
    {
	super(term,lineNo,parent);
    }
    
    public static TermData nextTermData(Xobject term,LineNo lineNo,Data parent)
    {
	switch(term.Opcode())
	    {
	    case Xcode.FUNCTION_CALL:
		return new FunctionTermData(term,lineNo,parent);
	    case Xcode.INT_CONSTANT:
	    case Xcode.FLOAT_CONSTANT:
		return new ConstantTermData(term,lineNo,parent);
	    case Xcode.POINTER_REF:
		if(term.left().Opcode()==Xcode.PLUS_EXPR || term.left().isArrayAddr())
			return new ArrayTermData(term,lineNo,parent);
		if(term.left().isVarAddr())
			return new ScalarTermData(term,lineNo,parent);
		return nextTermData(term.left(),lineNo,parent);
	    }
	System.out.println(term.toString());
	return null;
    }
}
