package ipatjava.data.expr;
import exc.object.*;
import ipatjava.data.*;
import ipatjava.data.term.*;
import ipatjava.math.*;
import ipatjava.tips.*;

public class ExprData extends Data
{
    protected Xobject current=null;
    protected Data parent;

    public ExprData(Xobject expr,LineNo lineNo,Data parent)
    {
	super(expr,lineNo);
	this.current=expr;
	this.parent = parent;
    }

    public static ExprData nextExpr(Xobject expr,LineNo lineNo,Data parent)
    {
	if(expr.isBinaryOp())
	    return new BinaryExprData(expr,lineNo,parent);
	if(expr.isUnaryOp())
	    return new UnaryExprData(expr,lineNo,parent);
	if(expr.isAsgOp())
	    {
		if(expr.Opcode() != Xcode.ASSIGN_EXPR)
		    return new AsignExprData(expr,lineNo,parent);
		if(expr.right().isBinaryOp())
		    if(XobjectTips.sameXobject(expr.left(),expr.right().left()))
			    expr = Xcons.asgOp(expr.right().Opcode()+1,expr.left(),expr.right().right());
		return new AsignExprData(expr,lineNo,parent);
	    }
	if(expr.Opcode()==Xcode.CAST_EXPR)
	    return new CastExprData(expr,lineNo,parent);
	if(expr!=null)
	    return TermData.nextTermData(expr,lineNo,parent);
	return null;
    }
    
    public IdValueList getIdValueList(){return null;}
    public Data getParent(){return parent;}
}
