package ipatjava.data.expr;
import exc.object.*;
import ipatjava.data.*;
import ipatjava.data.term.*;

public class AsignExprData extends ExprData
{
    private ExprData expr=null;
    private TermData term=null;
    
    public AsignExprData(Xobject expr,LineNo lineNo,Data parent)
    {
	super(expr,lineNo,parent);
	switch(expr.Opcode())
	    {
	    case Xcode.POST_INCR_EXPR:
		this.term = ReductionTermData.nextTermData(expr.left(),lineNo,this);
		this.expr = TermData.nextTermData(Xcons.IntConstant(1),lineNo,this);
		super.mergeDataList(this.term);
		break;
	    case Xcode.POST_DECR_EXPR:
		this.term = ReductionTermData.nextTermData(expr.left(),lineNo,this);
		this.expr = TermData.nextTermData(Xcons.IntConstant(-1),lineNo,this);
		super.mergeDataList(this.term);
		break;	
	    case Xcode.ASSIGN_EXPR:
		this.expr = ExprData.nextExpr(expr.right(),lineNo,this);
		this.term = WriteTermData.nextTermData(expr.left(),lineNo,this);
		super.mergeDataList(this.expr);
		super.mergeDataList(this.term);		
		break;
	    default:	
		this.expr = ExprData.nextExpr(expr.right(),lineNo,this);
		this.term = ReductionTermData.nextTermData(expr.left(),lineNo,this);
		super.mergeDataList(this.expr);
		super.mergeDataList(this.term);
	    }
    }

    public ExprData right(){return expr;}
    public TermData left(){return term;}
}
