package ipatjava.data.block;
import exc.object.*;
import exc.block.*;
import ipatjava.data.*;

public class BlockData extends Data
{
    private Block current=null;
    protected BlockListData parent;

    public BlockData(Block block,LineNo lineNo,BlockListData parent)
    {
	super(block.toXobject(),lineNo);
	this.current=block;
	this.parent=parent;
    }
    public Block getBlock(){return current;}
    public static BlockData nextBlock(Block block,BlockListData parent)
    {
	if(block instanceof SimpleBlock)
	    {
		switch(block.Opcode())
		    {
		    case Xcode.DEFAULT_LABEL:
			return new DefaultLabelData((SimpleBlock)block,parent);
		    case Xcode.RETURN_STATEMENT:
			return new ReturnStatementData((SimpleBlock)block,parent);
		    case Xcode.BREAK_STATEMENT:
			return new BreakStatementData((SimpleBlock)block,parent);
		    case Xcode.CONTINUE_STATEMENT:
			return new ContinueStatementData((SimpleBlock)block,parent);
		    default:
			return new SimpleBlockData((SimpleBlock)block,parent);
		    }
	    }
	if(block instanceof IfBlock)
	    return  new IfBlockData((IfBlock)block,parent);

	if(block instanceof CondBlock)
	    {
		if(block instanceof ForBlock)
		    return new ForBlockData((ForBlock)block,parent);
		return  new CondBlockData((CondBlock)block,parent);
	    }

	if(block instanceof LabelBlock)
	    {
		switch(block.Opcode())
		    {
		    case Xcode.GOTO_STATEMENT:
			return new GotoStatementData((LabelBlock)block,parent);
		    case Xcode.STATEMENT_LABEL:
			return new StatementLabelData((LabelBlock)block,parent);
		    case Xcode.CASE_LABEL:
			return new CaseLabelData((LabelBlock)block,parent);
		    }
	    }

	if(block instanceof CompoundBlock)
	    {
		if(block instanceof PragmaBlock)
		    return new PragmaBlockData((PragmaBlock)block,parent);
		if(block instanceof FunctionBlock)
		    return new FunctionBlockData((FunctionBlock)block,parent);
		return new CompoundBlockData((CompoundBlock)block,parent);
	    }
	return null;
    }
    
}
