package ipatjava.data;
import java.util.*;
import exc.object.*;
import exc.block.*;
import ipatjava.data.block.*;

public class FunctionBlocks implements XobjectDefVisitor
{
    private Hashtable functionDef;
    private Hashtable functionDecls;
    private List nameList;
    private XobjList globalDecls;
    private FunctionBlockData data;

    public FunctionBlocks()
    {
	this.functionDef = new Hashtable();
	this.functionDecls = new Hashtable();
	this.nameList = new LinkedList();
	this.globalDecls = new XobjList();
    }
    
    public void doDef(XobjectDef def)
    { 
  	if(def.isFuncDef())
	    {
		functionDecls.put(Bcons.buildFunctionBlock(def).getName(),this.globalDecls.copy());
		nameList.add(Bcons.buildFunctionBlock(def).getName());
		functionDef.put(Bcons.buildFunctionBlock(def).getName(),def);
	    }	
	else
	    if(def.isVarDecl())
		this.globalDecls.add(def.getDef()); 
    }

    public List getNameList(){ return nameList;}

    public XobjList getFunctionDecls(String funcName)
    {
	if(functionDecls.containsKey(funcName))
	    return (XobjList)functionDecls.get(funcName);
	else
	    return null;
    }    

    public XobjectDef getFunctionDef(String funcName)
    {
	if(functionDef.containsKey(funcName))
	    return (XobjectDef)functionDef.get(funcName);
	else
	    return null;
    }

}
