package ipatjava.analyzer.block;
import ipatjava.analyzer.OpenMPDirectiveCreator;
import ipatjava.analyzer.ProgramAnalyzer;
import ipatjava.analyzer.array.LocalArrayDataAnalyzer;
import ipatjava.analyzer.array.powertest.IndexSpace;
import ipatjava.analyzer.array.powertest.PowerTest;
import ipatjava.analyzer.scalar.LocalScalarDataAnalyzer;
import ipatjava.data.Data;
import ipatjava.data.block.ForBlockData;
import ipatjava.data.term.array.ArrayTermData;
import ipatjava.data.term.function.FunctionTermData;
import ipatjava.data.term.scalar.ScalarTermData;
import ipatjava.tips.BitSetTips;
import ipatjava.tips.LoopBoundTips;
import ipatjava.tips.XMLTips;

import java.util.BitSet;
import java.util.List;
import java.util.ListIterator;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import exc.object.Xobject;



public class ForBlockParallelismAnalyzer extends ProgramAnalyzer
{
	ForBlockData target;
	LocalScalarDataAnalyzer localScalarDataAnalyzer;
	LocalArrayDataAnalyzer localArrayDataAnalyzer;
	
	BitSet forBlockContainingFunctionCallBitSet;

	BitSet scalarLoopCarriedDependenceBitSet;
	BitSet scalarReductionErrBitSet;
	BitSet arrayContainingFunctionCallBitSet;
	BitSet arrayContainingArrayBItSet;
	BitSet arrayContainingNonLinearExpr;
	BitSet[] missMatchArrayElementSizeBitSetArray;
	BitSet missMatchArrayElementSizeBitSet;
	BitSet[] arrayDataOutputDependenceBitSetArray;
	BitSet arrayDataOutputDependenceBitSet;
	BitSet[] arrayDataFlowAntiDependenceBitSetArray;
	BitSet arrayDataFlowAntiDependenceBitSet;
		
	public ForBlockParallelismAnalyzer(ProgramAnalyzer programAnalyzer,ForBlockData forBlockData)
	{
		super(programAnalyzer);
		this.target = forBlockData;
		this.localScalarDataAnalyzer = new LocalScalarDataAnalyzer(super.scalarDataAnalyzer,forBlockData);
		this.localArrayDataAnalyzer = new LocalArrayDataAnalyzer(super.arrayDataAnalyzer,forBlockData);
		analyze();
	}
	
	public boolean isParallelizable()
	{
		return this.forBlockContainingFunctionCallBitSet.isEmpty() &&
		this.scalarLoopCarriedDependenceBitSet.isEmpty()&&
		this.scalarReductionErrBitSet.isEmpty()&&
		this.arrayContainingFunctionCallBitSet.isEmpty()&&
		this.arrayContainingArrayBItSet.isEmpty()&&
		this.arrayContainingNonLinearExpr.isEmpty() &&
		this.missMatchArrayElementSizeBitSet.isEmpty()&&
		this.arrayDataOutputDependenceBitSet.isEmpty()&&
		this.arrayDataFlowAntiDependenceBitSet.isEmpty()
		;
	}
	
	private void analyze()
	{
		this.forBlockContainingFunctionCallBitSet = this.detectforBlockContainingFunctionCall();
		this.scalarLoopCarriedDependenceBitSet = this.detectScalarLoopCarriedDep();
		this.scalarReductionErrBitSet = this.detectScalarReductionErr();
		this.arrayContainingFunctionCallBitSet= this.detectArrayContainingFunctionCall();
		this.arrayContainingArrayBItSet= this.detectArrayContainingArray();
		this.arrayContainingNonLinearExpr= this.detectArrayContainingNonLinearExpr();
		this.detectArrayMissMatchElementSize();
		if(this.arrayContainingFunctionCallBitSet.isEmpty()&&
				this.arrayContainingArrayBItSet.isEmpty()&&
		   this.arrayContainingNonLinearExpr.isEmpty()&&
			this.missMatchArrayElementSizeBitSet.isEmpty())
		{
			detectArrayOutputDependence();
		detectArrayFlowAntiDependence();
	}	
	}
	
	public Element getAnalysisResultElement(Document document)
	{
		Element element = this.target.getXMLElement(document);
		
		if(isParallelizable())
			element.appendChild(OpenMPDirectiveCreator.createXMLElement(document,localScalarDataAnalyzer));
		else
		{
			Element inhibition = XMLTips.createElement(document,"inhibition");
			
			if(!this.forBlockContainingFunctionCallBitSet.isEmpty())
			{
				for(int i = this.forBlockContainingFunctionCallBitSet.nextSetBit(0) ; i!=-1 ; i= this.forBlockContainingFunctionCallBitSet.nextSetBit(i+1))
				{
					FunctionTermData functionTermData = (FunctionTermData)super.data.getData(i);
                    Element factor = document.createElement("factor");
                    factor.setAttribute("reason","Function call exists in this block");
                    factor.setAttribute("datatype","FunctionCall");
                    factor.appendChild(functionTermData.getXMLElement(document));
                    inhibition.appendChild(factor);
				}
			}

			if(!scalarLoopCarriedDependenceBitSet.isEmpty())
			{
				for(int i = scalarLoopCarriedDependenceBitSet.nextSetBit(0) ; i!=-1 ; i=scalarLoopCarriedDependenceBitSet.nextSetBit(i+1))
				{
					ScalarTermData scalarTermData = (ScalarTermData)this.data.getData(this.scalarDataAnalyzer.getTableDataIndex(i));
					
					Element factor = document.createElement("factor");
					factor.setAttribute("reason","Loop carried dependence");
					factor.setAttribute("datatype","Variable");
					factor.appendChild(scalarTermData.getXMLElement(document));
					inhibition.appendChild(factor);
				}
			}
			
			if(!scalarReductionErrBitSet.isEmpty())
			{
				for(int i = scalarReductionErrBitSet.nextSetBit(0) ; i!=-1 ; i=scalarReductionErrBitSet.nextSetBit(i+1))
				{
					ScalarTermData scalarTermData = (ScalarTermData)this.data.getData(this.scalarDataAnalyzer.getTableDataIndex(i));
					Element factor = document.createElement("factor");
					factor.setAttribute("reason","Parallelization is prohibited");
					factor.setAttribute("datatype","Variable");
					factor.setAttribute("detail","reduction error");
					factor.appendChild(scalarTermData.getXMLElement(document));
					inhibition.appendChild(factor);
				}
			}
			
			if(!arrayContainingFunctionCallBitSet.isEmpty())
			{
				for(int i = arrayContainingFunctionCallBitSet.nextSetBit(0) ; i!=-1 ; i= arrayContainingFunctionCallBitSet.nextSetBit(i+1))
				{
					ArrayTermData arrayTermData = (ArrayTermData)this.data.getData(this.arrayDataAnalyzer.getTableDataIndex(i));
                    Element factor = document.createElement("factor");
                    factor.setAttribute("datatype","Array");
                    factor.setAttribute("reason"," Contain Function call.");
                    factor.appendChild(arrayTermData.getXMLElement(document));
                    inhibition.appendChild(factor);
				}
			}
			
			if(!arrayContainingFunctionCallBitSet.isEmpty())
			{
				for(int i = arrayContainingArrayBItSet.nextSetBit(0) ; i!=-1 ; i= arrayContainingArrayBItSet.nextSetBit(i+1))
				{
					ArrayTermData arrayTermData = (ArrayTermData)this.data.getData(this.arrayDataAnalyzer.getTableDataIndex(i));
                    Element factor = document.createElement("factor");
                    factor.setAttribute("datatype","Array");
                    factor.setAttribute("reason"," Contain Array.");
                    factor.appendChild(arrayTermData.getXMLElement(document));
                    inhibition.appendChild(factor);
				}
			}

			if(!arrayContainingNonLinearExpr.isEmpty())
			{
				for(int i = arrayContainingNonLinearExpr.nextSetBit(0) ; i!=-1 ; i= arrayContainingNonLinearExpr.nextSetBit(i+1))
				{
					ArrayTermData arrayTermData = (ArrayTermData)this.data.getData(this.arrayDataAnalyzer.getTableDataIndex(i));
                    Element factor = document.createElement("factor");
                    factor.setAttribute("datatype","Array");
                    factor.setAttribute("reason","Contain non linear Expression.");
                    factor.appendChild(arrayTermData.getXMLElement(document));
                    inhibition.appendChild(factor);
				}
			}

			if(!this.missMatchArrayElementSizeBitSet.isEmpty())
			{
				for(int i = this.missMatchArrayElementSizeBitSet.nextSetBit(0) ; i!=-1 ; i= this.missMatchArrayElementSizeBitSet.nextSetBit(i+1))
				{
					ArrayTermData arrayTermData1 = (ArrayTermData)this.data.getData(this.arrayDataAnalyzer.getTableDataIndex(i));
					for(int j = this.missMatchArrayElementSizeBitSetArray[i].nextSetBit(0) ; j!=-1 ; j= this.missMatchArrayElementSizeBitSetArray[i].nextSetBit(j+1))
					{
						ArrayTermData arrayTermData2 = (ArrayTermData)this.data.getData(this.arrayDataAnalyzer.getTableDataIndex(i));
				        Element factor = document.createElement("factor");
				        factor.setAttribute("datatype","Array");
				        factor.setAttribute("reason"," mismatched Array elements.");
				        factor.appendChild(arrayTermData1.getXMLElement(document));
				        factor.appendChild(arrayTermData2.getXMLElement(document));
				        inhibition.appendChild(factor);
					}
				}
			}
			if(!this.arrayDataOutputDependenceBitSet.isEmpty())
			{
				for(int i = this.arrayDataOutputDependenceBitSet.nextSetBit(0) ; i!=-1 ; i= arrayContainingNonLinearExpr.nextSetBit(i+1))
				{
					ArrayTermData arrayTermData1 = (ArrayTermData)this.data.getData(this.arrayDataAnalyzer.getTableDataIndex(i));
					for(int j = this.arrayDataOutputDependenceBitSetArray[i].nextSetBit(0) ; j!=-1 ; j= this.arrayDataOutputDependenceBitSetArray[i].nextSetBit(j+1))
					{
						ArrayTermData arrayTermData2 = (ArrayTermData)this.data.getData(this.arrayDataAnalyzer.getTableDataIndex(j));
				        Element factor = document.createElement("factor");
				        factor.setAttribute("datatype","Array");
				        factor.setAttribute("reason","output dependence");
				        factor.appendChild(arrayTermData1.getXMLElement(document));
				        factor.appendChild(arrayTermData2.getXMLElement(document));
				        inhibition.appendChild(factor);
					}
				}
			}

			if(!this.arrayDataFlowAntiDependenceBitSet.isEmpty())
			{
				for(int i = this.arrayDataFlowAntiDependenceBitSet.nextSetBit(0) ; i!=-1 ; i= arrayContainingNonLinearExpr.nextSetBit(i+1))
				{
					ArrayTermData arrayTermData1 = (ArrayTermData)this.data.getData(this.arrayDataAnalyzer.getTableDataIndex(i));
					for(int j = this.arrayDataFlowAntiDependenceBitSetArray[i].nextSetBit(0) ; j!=-1 ; j= this.arrayDataFlowAntiDependenceBitSetArray[i].nextSetBit(j+1))
					{
						ArrayTermData arrayTermData2 = (ArrayTermData)this.data.getData(this.arrayDataAnalyzer.getTableDataIndex(j));
				        Element factor = document.createElement("factor");
				        factor.setAttribute("datatype","Array");
				        factor.setAttribute("reason","flow or anti dependence");
				        factor.appendChild(arrayTermData1.getXMLElement(document));
				        factor.appendChild(arrayTermData2.getXMLElement(document));
				        inhibition.appendChild(factor);
					}
				}
			}
			element.appendChild(inhibition);
		}
		return element;
	}
	
	private BitSet detectScalarLoopCarriedDep()
	{
		
		BitSet cond = new BitSet();
		for(int i = this.localScalarDataAnalyzer.tableInner().nextSetBit(0) ; i!=-1 ; i = this.localScalarDataAnalyzer.tableInner().nextSetBit(i+1))
		{
			BitSet cond1 = BitSetTips.and(this.scalarDataAnalyzer.udChain()[i],this.localScalarDataAnalyzer.genInner());
			BitSet cond2 = BitSetTips.and(this.scalarDataAnalyzer.udChain()[i],this.localScalarDataAnalyzer.genOuter());
			
			if(!cond1.isEmpty() && !cond2.isEmpty())
				cond.or(cond1);
		}
		
		for(int i = cond.nextSetBit(0) ; i!=-1 ; i = cond.nextSetBit(i+1))
		{
			if(this.localScalarDataAnalyzer.reductionOnly().get(i))
				cond.clear(i);
			
		}
		return cond;
	}
	
	private BitSet detectScalarReductionErr()
	{
		BitSet cond = new BitSet();
		BitSet reductionTable =  BitSetTips.and(this.localScalarDataAnalyzer.tableInner(),this.scalarDataAnalyzer.reductionTable());
		
		for(int i = reductionTable.nextSetBit(0) ; i!=-1 ; i = reductionTable.nextSetBit(i+1))
		{
			if(this.localScalarDataAnalyzer.reductionOnly().get(i))
			{
				BitSet duChain = BitSetTips.and(this.localScalarDataAnalyzer.tableInner(),this.scalarDataAnalyzer.duChain()[i]);
				duChain.clear(i);
				if(!duChain.isEmpty())
					cond.set(i);
			}
		}
		for(int i = cond.nextSetBit(0) ; i!=-1 ; i = cond.nextSetBit(i+1))
		{
			if(this.localScalarDataAnalyzer.reductionOnly().get(i))
				cond.clear(i);
		}
		return cond;
	}
	
	private BitSet detectforBlockContainingFunctionCall()
	{
		BitSet cond = new BitSet();
		for(ListIterator listIterator = this.target.getDataList().listIterator(); listIterator.hasNext();)
		{
			Data data = (Data)listIterator.next();
			if(data instanceof FunctionTermData)
				cond.set(data.getDataIndex());
		}
		return cond;
	}

	
	private BitSet detectArrayContainingFunctionCall()
	{
		BitSet cond = new BitSet();
		for(int i = localArrayDataAnalyzer.tableInner().nextSetBit(0);i!=-1;i=localArrayDataAnalyzer.tableInner().nextSetBit(i+1))
		{
			if(super.arrayDataAnalyzer.containFunctionCall()[i].isEmpty())
				continue;
			if(this.localArrayDataAnalyzer.outputInner()[i].isEmpty() && this.localArrayDataAnalyzer.flowAntiInner()[i].isEmpty())
				continue;
			cond.set(i);
		}
		return cond;
	}

	private BitSet detectArrayContainingArray()
	{
		BitSet cond = new BitSet();
		for(int i = localArrayDataAnalyzer.tableInner().nextSetBit(0);i!=-1;i=localArrayDataAnalyzer.tableInner().nextSetBit(i+1))
		{
			if(super.arrayDataAnalyzer.containArray()[i].isEmpty())
				continue;
			if(this.localArrayDataAnalyzer.outputInner()[i].isEmpty() && this.localArrayDataAnalyzer.flowAntiInner()[i].isEmpty())
				continue;
			cond.set(i);
		}
				return cond;
	}

	private BitSet detectArrayContainingNonLinearExpr()
	{
		BitSet cond = new BitSet();
		for(int i = localArrayDataAnalyzer.tableInner().nextSetBit(0);i!=-1;i=localArrayDataAnalyzer.tableInner().nextSetBit(i+1))
		{
			if(super.arrayDataAnalyzer.isLinearExpr()[i])
				continue;
			if(this.localArrayDataAnalyzer.outputInner()[i].isEmpty() && this.localArrayDataAnalyzer.flowAntiInner()[i].isEmpty())
				continue;
			cond.set(i);
		}
		return cond;
	}

	private void detectArrayMissMatchElementSize()
	{
		this.missMatchArrayElementSizeBitSet = new BitSet();
		this.missMatchArrayElementSizeBitSetArray = new BitSet[super.arrayDataAnalyzer.getDataTable().cardinality()];
		for(int i = localArrayDataAnalyzer.tableInner().nextSetBit(0);i!=-1;i=localArrayDataAnalyzer.tableInner().nextSetBit(i+1))
		{
			this.missMatchArrayElementSizeBitSetArray[i]=new BitSet();
			ArrayTermData arrayTermData1 = (ArrayTermData)super.data.getData(super.arrayDataAnalyzer.getTableDataIndex(i));
			
			for(int k = this.localArrayDataAnalyzer.outputInner()[i].nextSetBit(i+1) ; k!=-1; k=this.localArrayDataAnalyzer.outputInner()[i].nextSetBit(k+1))
			{
				ArrayTermData arrayTermData2 = (ArrayTermData)super.data.getData(super.arrayDataAnalyzer.getTableDataIndex(k));
				BitSet forBlockList2 = (BitSet)this.target.getChildDataIndex().clone();
				forBlockList2.and(arrayTermData2.getParentDataIndex());
				if(arrayTermData1.getElementSize()!=arrayTermData2.getElementSize())
				{
					this.missMatchArrayElementSizeBitSet.set(i);
					this.missMatchArrayElementSizeBitSetArray[i].set(k);
				}
			}
			for(int k = this.localArrayDataAnalyzer.flowAntiInner()[i].nextSetBit(i+1) ; k!=-1; k=this.localArrayDataAnalyzer.flowAntiInner()[i].nextSetBit(k+1))
			{
				ArrayTermData arrayTermData2 = (ArrayTermData)super.data.getData(super.arrayDataAnalyzer.getTableDataIndex(k));
				BitSet forBlockList2 = (BitSet)this.target.getChildDataIndex().clone();
				forBlockList2.and(arrayTermData2.getParentDataIndex());
				if(arrayTermData1.getElementSize()!=arrayTermData2.getElementSize())
				{
					this.missMatchArrayElementSizeBitSet.set(i);
					this.missMatchArrayElementSizeBitSetArray[i].set(k);
				}
			}
		}
	}

		private void detectArrayOutputDependence()
		{
			arrayDataOutputDependenceBitSet = new BitSet();
			arrayDataOutputDependenceBitSetArray = new BitSet[super.arrayDataAnalyzer.getDataTable().cardinality()];
			for(int i = localArrayDataAnalyzer.tableInner().nextSetBit(0);i!=-1;i=localArrayDataAnalyzer.tableInner().nextSetBit(i+1))
			{
				arrayDataOutputDependenceBitSetArray[i]=new BitSet();
				ArrayTermData arrayTermData1 = (ArrayTermData)super.data.getData(super.arrayDataAnalyzer.getTableDataIndex(i));
				BitSet forBlockList1 = (BitSet)this.target.getChildDataIndex().clone();
				forBlockList1.and(arrayTermData1.getParentDataIndex());
				for(int j = forBlockList1.nextSetBit(0) ; j != -1 ; j=forBlockList1.nextSetBit(j+1))
				{
					Data data = (Data)super.data.getData(j);
					if(!(data instanceof ForBlockData))
						forBlockList1.clear(j);
				}
				
				for(int k = this.localArrayDataAnalyzer.outputInner()[i].nextSetBit(i+1) ; k!=-1; k=this.localArrayDataAnalyzer.outputInner()[i].nextSetBit(k+1))
				{
					ArrayTermData arrayTermData2 = (ArrayTermData)super.data.getData(super.arrayDataAnalyzer.getTableDataIndex(k));
					BitSet forBlockList2 = (BitSet)this.target.getChildDataIndex().clone();
					forBlockList2.and(arrayTermData2.getParentDataIndex());
					for(int l = forBlockList2.nextSetBit(0) ; l != -1 ; l=forBlockList2.nextSetBit(l+1))
					{
						Data data = (Data)super.data.getData(l);
						if(!(data instanceof ForBlockData))
							forBlockList2.clear(l);
					}
					if(isDepend(super.data.getDataList(),arrayTermData1,forBlockList1,arrayTermData2,forBlockList2))
					{
						arrayDataOutputDependenceBitSet.set(i);
						arrayDataOutputDependenceBitSetArray[i].set(k);
					}
				}
			}
		
	}
	private void detectArrayFlowAntiDependence()
	{
		arrayDataFlowAntiDependenceBitSet = new BitSet();
		arrayDataFlowAntiDependenceBitSetArray = new BitSet[super.arrayDataAnalyzer.getDataTable().cardinality()];
		for(int i = localArrayDataAnalyzer.tableInner().nextSetBit(0);i!=-1;i=localArrayDataAnalyzer.tableInner().nextSetBit(i+1))
		{
			arrayDataFlowAntiDependenceBitSetArray[i]=new BitSet();
			ArrayTermData arrayTermData1 = (ArrayTermData)super.data.getData(super.arrayDataAnalyzer.getTableDataIndex(i));
			BitSet forBlockList1 = (BitSet)this.target.getChildDataIndex().clone();
			forBlockList1.and(arrayTermData1.getParentDataIndex());
			for(int j = forBlockList1.nextSetBit(0) ; j != -1 ; j=forBlockList1.nextSetBit(j+1))
			{
				Data data = (Data)super.data.getData(j);
				if(!(data instanceof ForBlockData))
					forBlockList1.clear(j);
			}
			
			for(int k = this.localArrayDataAnalyzer.flowAntiInner()[i].nextSetBit(i+1) ; k!=-1; k=this.localArrayDataAnalyzer.flowAntiInner()[i].nextSetBit(k+1))
			{
				ArrayTermData arrayTermData2 = (ArrayTermData)super.data.getData(super.arrayDataAnalyzer.getTableDataIndex(k));
				BitSet forBlockList2 = (BitSet)this.target.getChildDataIndex().clone();
				forBlockList2.and(arrayTermData2.getParentDataIndex());
				for(int l = forBlockList2.nextSetBit(0) ; l != -1 ; l=forBlockList2.nextSetBit(l+1))
				{
					Data data = (Data)super.data.getData(l);
					if(!(data instanceof ForBlockData))
						forBlockList2.clear(l);
				}
				if(isDepend(super.data.getDataList(),arrayTermData1,forBlockList1,arrayTermData2,forBlockList2))
				{
					arrayDataFlowAntiDependenceBitSet.set(i);
					arrayDataFlowAntiDependenceBitSetArray[i].set(k);
				}
			}
		}
		
	}
	
    private boolean isDepend(List list,
    		ArrayTermData arrayTermData1,BitSet forBlockListBitSet1,
			ArrayTermData arrayTermData2,BitSet forBlockListBitSet2)
    {
        ArrayTermData a1=arrayTermData1.getLineNo().lineNo()>arrayTermData2.getLineNo().lineNo()?arrayTermData1:arrayTermData2;
        ArrayTermData a2=arrayTermData1.getLineNo().lineNo()>arrayTermData2.getLineNo().lineNo()?arrayTermData2:arrayTermData1;
                                                                                                                                              
        BitSet b1=arrayTermData1.getLineNo().lineNo()>arrayTermData2.getLineNo().lineNo()?forBlockListBitSet1:forBlockListBitSet2;
        BitSet b2=arrayTermData1.getLineNo().lineNo()>arrayTermData2.getLineNo().lineNo()?forBlockListBitSet2:forBlockListBitSet1;
                                                                                                                                              
        Xobject e1[] = LoopBoundTips.getLoopIds(list,b1);
        Xobject e2[] = LoopBoundTips.getLoopIds(list,b2);
                                                                                                                                              
        IndexSpace is1 = new IndexSpace(LoopBoundTips.getLowerMatrix(list,b1,e1),
                                        LoopBoundTips.getLowerVector(list,b1),
                                        LoopBoundTips.getUpperMatrix(list,b1,e1),
                                        LoopBoundTips.getUpperVector(list,b1),
                                        LoopBoundTips.getStrideMatrix(list,b1),
                                        a1.getElementMatrix(e1),
                                        a1.getElementVector());
                                                                                                                                              
        IndexSpace is2 = new IndexSpace(LoopBoundTips.getLowerMatrix(list,b2,e2),
                                        LoopBoundTips.getLowerVector(list,b2),
                                        LoopBoundTips.getUpperMatrix(list,b2,e2),
                                        LoopBoundTips.getUpperVector(list,b2),
                                        LoopBoundTips.getStrideMatrix(list,b2),
                                        a2.getElementMatrix(e2),
                                        a2.getElementVector());
        /*
          System.out.println("LineNo:"+a1.getLineNo().lineNo());
          MathTips.printMatrix(a1.getElementMatrix(e1));
          MathTips.printVector(a1.getElementVector());
          MathTips.printMatrix(LoopBoundTips.getLowerMatrix(list,b1,e1));
          MathTips.printVector(LoopBoundTips.getLowerVector(list,b1));
          MathTips.printMatrix(LoopBoundTips.getUpperMatrix(list,b1,e1));
          MathTips.printVector(LoopBoundTips.getUpperVector(list,b1));
          MathTips.printMatrix(LoopBoundTips.getStrideMatrix(list,b1));
          */                                                                                                                                    
        BitSet b = BitSetTips.and(b1,b2);
        PowerTest powerTest = new PowerTest(
                                     is1.getFinalMatrix(),is1.getFinalVector(),
                                     is1.getSubscriptMatrix(),is1.getSubscriptVector(),
                                     is2.getFinalMatrix(),is2.getFinalVector(),
                                     is2.getSubscriptMatrix(),is2.getSubscriptVector(),
									 0,b.cardinality());
        return powerTest.isDepend();
    }
    
    
	public Element getXMLElement(Document document)
	{
		Element element = XMLTips.createElement(document,"depend");
		
		return element;
	}
	
}
