package ipatjava.tips;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

import org.apache.crimson.tree.XmlDocument;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

import exc.object.LineNo;

public class XMLTips {
	
public 	static Document createDocument()
{
	try{
	    DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
	    DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
	    return documentBuilder.newDocument();	
	    }
	catch (Exception e)
	    {
		System.out.print("Error:"+e+"\n");
	    }
	finally
	{
		
	}
	return null;
}
 public static Element createElement(Document document,String tagName)
 {
 	try{
 		return document.createElement(tagName);
	}
	catch (Exception e)
	    {
		System.out.print("Error:"+e+"\n");
	    }
	return null;
 }
 
 public static Element lineNo(Document document,LineNo lineno)
 {
     Element element = document.createElement("line");
     element.setAttribute("source",lineno.fileName());
     element.setAttribute("no",Integer.toString(lineno.lineNo()));
     return element;
 }
 
 public static void writeDocument(Document document,String fileName)
 {
    try {
		XmlDocument xmlDocument = (XmlDocument) document;
		BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(fileName));
		xmlDocument.write(bufferedWriter,"UTF-8");
	} 
    	catch (IOException e) {
		e.printStackTrace();
	}
 }
}
