package ipatjava.math;
import ipatjava.tips.*;

public class Frac
{

    private int nu;
    private int de;

    public Frac()
    {
	this.nu = 0;
	this.nu = 1;
    }

    public Frac(int i)
    {
	this.nu = i;
	this.de = 1;
    }

    public Frac(int i,int j)
    {
	if(j<0)
	    {
		this.nu = -1*i;
		this.de = -1*j;
	    }
	else
	    {
		this.nu = i;
		this.de = j;
	    }
	reduct();
    }

    public int getDenominator()
    {
	return de;
    }
    
    public int getNumerator()
    {
	return nu;
    }
    
    public void print()
    {
	if(nu<0)
	    System.out.print(nu+"/"+de+" ");
	else
	    System.out.print(" "+nu+"/"+de+" ");
     }
    
    public void println()
    {
	if(nu<0)
	    System.out.print(nu+"/"+de+"\n");
	else
	    System.out.print(" "+nu+"/"+de+"\n");
    }
    
    public int signum()
    {
	return MathTips.signum(nu)*MathTips.signum(de);
    }

    public boolean isPositive()
    {
	if(this.signum()==1)
	    return true;
	else
	    return false;
    }

    public boolean isNegative()
    {
	if(this.signum()==-1)
	    return true;
	else
	    return false;
    }
    
    public boolean isZero()
    {
	if(this.signum()==0)
	    return true;
	else
	    return false;
     }

    public Frac min(Frac f)
    {
	this.reduct();
	f.reduct();

	int f1 = this.nu * f.getDenominator();
	int f2 = f.getNumerator() * this.de;
	int d = this.de * f.getDenominator();
	
	return new Frac(Math.min(f1,f2),d);
    }

    public Frac max(Frac f)
    {
	this.reduct();
	f.reduct();

	int f1 = this.nu * f.getDenominator();
	int f2 = f.getNumerator() * this.de;
	int d = this.de * f.getDenominator();
	
	return new Frac(Math.max(f1,f2),d);
    }

    public void reduct()
    {
	int gcd = MathTips.gcd(nu,de);
	
	if(gcd==0)
	    return;
	if(de >0)
	    {
		nu = nu/gcd;
		de = de/gcd;
	    }
	else
	    {
		nu = -1*nu/gcd;
		de = -1*de/gcd;
	    }
    }
 
    public  int floor()
    {
	this.reduct();
	Double f=new Double(Math.floor(nu/de));
	return f.intValue();
    }
 
    public  int ceil()
    {
	this.reduct();
	Double c=new Double(Math.ceil(nu/de));
	return c.intValue();
    }
    
    public Frac copy(){return new Frac(nu,de);}
    
    public void unary_minus()
    {
	if(MathTips.signum(this.de)==-1)
	    this.de = -1*this.de;
	else
	    this.nu = -1*this.nu;
    }

    public Frac add(Frac f) 
    {
	int n = (this.nu*f.getDenominator()+f.getNumerator()*this.de);
	int d = (this.de*f.getDenominator());

	Frac ftmp = new Frac(n,d);

	ftmp.reduct();

	return ftmp;
    }

    public void assign_add(Frac f) 
    {
	this.nu = (this.nu*f.getDenominator()+f.getNumerator()*this.de);
	this.de = (this.de*f.getDenominator());
	this.reduct();
    }

    public Frac subtract(Frac f) 
    {
	int n = (this.nu*f.getDenominator()-f.getNumerator()*this.de);
	int d = (this.de*f.getDenominator());

	Frac ftmp = new Frac(n,d);

	ftmp.reduct();

	return ftmp;
    }

    public void assign_subtract(Frac f) 
    {
	this.nu = (this.nu*f.getDenominator()-f.getNumerator()*this.de);
	this.de = (this.de*f.getDenominator());
	this.reduct();
    }

    public Frac multiply(Frac f) 
    {
	int n = (this.nu*f.getNumerator());
	int d = (this.de*f.getDenominator());

	Frac ftmp = new Frac(n,d);

	ftmp.reduct();

	return ftmp;
     }

    public void assign_multiply(Frac f) 
    {
	this.nu = (this.nu*f.getNumerator());
	this.de = (this.de*f.getDenominator());
	this.reduct();
    }

    public Frac divide(Frac f) 
    {
	int n = (this.nu*f.getDenominator());
	int d = (this.de*f.getNumerator());

	Frac ftmp = new Frac(n,d);

	ftmp.reduct();

	return ftmp;
     }

    public void assign_divide(Frac f) 
    {
	this.nu = (this.nu*f.getDenominator());
	this.de = (this.de*f.getNumerator());
	this.reduct();
    }
     
}
