package ipatjava.graph;
import java.util.*;
import ipatjava.data.*;

public class DataTable extends Graph
{
    protected BitSet table;
 
    public DataTable(Data data,BitSet node){super(data,node);}
    
    public void setTable(BitSet table){this.table=(BitSet)table.clone();}   
    public BitSet getDataTable(){return this.table;}

    public int getTableIndex(int num)
    {
	int i=0;
	for(int j=this.table.nextSetBit(0);j!=-1;j=this.table.nextSetBit(j+1))
	    if(j==num)
		return i;
	    else
		i++;
	return -1;
    }

    public BitSet getTableIndexBitSet(int num)
    {
	BitSet bs = new BitSet();
	int i = getTableIndex(num);
	if(i!=-1)
	    bs.set(i);
	return bs;
    }

    public BitSet getTableIndexBitSet(BitSet numbs)
    {
	BitSet bs = new BitSet();
	for(int i = numbs.nextSetBit(0); i!=-1;i=numbs.nextSetBit(i+1))
	    {
		int j = getTableIndex(i);
		if(j!=-1)
		    bs.set(j);
	    }
	return bs;
    }

    public int getTableDataIndex(int index)
    {
	int i=0;
	for(int j=this.table.nextSetBit(0);j!=-1;j=this.table.nextSetBit(j+1))
	    if(index==i)
		return j;
	    else
		i++;
	return -1;
    }

    public BitSet getTableDataIndexBitSet(int index)
    {
	BitSet bs = new BitSet();
	int i = getTableDataIndex(index);
	if(i!=-1)
	    bs.set(i);
	return bs;
    }

    public BitSet getTableDataIndexBitSet(BitSet indexbs)
    {
	BitSet bs = new BitSet();
	for(int i = indexbs.nextSetBit(0); i!=-1;i=indexbs.nextSetBit(i+1))
	    {
		int j = getTableDataIndex(i);
		if(j!=-1)
		    bs.set(j);
	    }
	return bs;
    }
}
