package ipatjava.data.term.scalar;
import ipatjava.data.Data;
import ipatjava.data.term.TermData;
import ipatjava.math.IdValueList;

import org.w3c.dom.*;

import exc.object.LineNo;
import exc.object.Xobject;
import ipatjava.tips.*;

public class ScalarTermData extends TermData
{
    private Xobject current=null;
    
    public ScalarTermData(Xobject term,LineNo lineNo,Data parent)
    {
	super(term,lineNo,parent);
	this.current=term;
    }
    
    public boolean isRead(){return true;}

    public boolean isWrite(){return false;}

    public boolean isReduction(){return false;}
    
    public IdValueList getIdValueList(){return new IdValueList(this.current,1);}
    
    public Element getXMLElement(Document document)
    {
    	Element element = document.createElement("data");
        element.setAttribute("source",super.getLineNo().fileName());
        element.setAttribute("lineno",Integer.toString(super.getLineNo().lineNo()));
        element.setAttribute("type","Variable");
        element.setAttribute("name",XobjectTips.toString(super.getXobject()));  
        return element;
    }
}
