package ipatjava.data.expr;
import java.util.*;
import exc.object.*;
import ipatjava.data.*;
import ipatjava.math.*;

public class BinaryExprData extends ExprData
{
    private ExprData leftExpr;
    private ExprData rightExpr;

    public BinaryExprData(Xobject expr,LineNo lineNo,Data parent)
    {
	super(expr,lineNo,parent);
	leftExpr = ExprData.nextExpr(expr.left(),lineNo,this);
	super.mergeDataList(leftExpr);
	rightExpr = ExprData.nextExpr(expr.right(),lineNo,this);
	super.mergeDataList(rightExpr);
    }
    
    public ExprData left(){return leftExpr;}
    public ExprData right(){return rightExpr;}
    
    public IdValueList getIdValueList()
    {

	if(leftExpr==null)
	    return null;
	if(rightExpr==null)
	    return null;

	if(leftExpr.getIdValueList()==null)
	    return null;
	if(rightExpr.getIdValueList()==null)
	    return null;

	IdValueList idvlL = leftExpr.getIdValueList().copy();
	IdValueList idvlR = rightExpr.getIdValueList().copy();

	switch(expr.Opcode())
	    {
	    case Xcode.PLUS_EXPR:
		idvlL.setValue(idvlL.getValue()+idvlR.getValue());
		for(ListIterator li = idvlR.getList().listIterator();li.hasNext();)
		    {
			IdValue idv = (IdValue)li.next();
			idvlL.setValue(idv.getId(),idvlL.getValue(idv.getId())+idv.getValue());
		    }
		return idvlL;
	    case Xcode.MINUS_EXPR:
		idvlL.setValue(idvlL.getValue()-idvlR.getValue());
		for(ListIterator li = idvlR.getList().listIterator();li.hasNext();)
		    {
			IdValue idv = (IdValue)li.next();
			idvlL.setValue(idv.getId(),idvlL.getValue(idv.getId())-idv.getValue());
		    }
		return idvlL;
	    case Xcode.MUL_EXPR:
		if(idvlR.getList().isEmpty())
		    {
			idvlL.setValue(idvlL.getValue()*idvlR.getValue());
			for(ListIterator li = idvlL.getList().listIterator();li.hasNext();)
			    {
				IdValue idv = (IdValue)li.next();
				idvlL.setValue(idv.getId(),idv.getValue()*idvlR.getValue());
			    }
			return idvlL;
		    }
		if(idvlL.getList().isEmpty())
		    {
			idvlR.setValue(idvlL.getValue()*idvlR.getValue());
			for(ListIterator li = idvlR.getList().listIterator();li.hasNext();)
			    {
				IdValue idv = (IdValue)li.next();
				idvlR.setValue(idv.getId(),idv.getValue()*idvlL.getValue());
			    }
			return idvlR;
		    }
		return null;
	    case Xcode.DIV_EXPR:
		if(idvlR.getList().isEmpty())
		    {
			if(idvlR.getValue()==0)
			    return null;
			if(idvlL.getValue()%idvlR.getValue()==0)
			    idvlL.setValue(idvlL.getValue()/idvlR.getValue());
			else
			    return null;
			for(ListIterator li = idvlL.getList().listIterator();li.hasNext();)
			    {
				IdValue idv = (IdValue)li.next();
				if(idv.getValue()%idvlR.getValue()==0)
				    idvlL.setValue(idv.getId(),idv.getValue()/idvlR.getValue());
				else
				    return null;
			    }
			return idvlL;
		    }
		return null;
	    default:
		return null;
	    }
    }
}
