package ipatjava.data.block;
import exc.block.*;
import ipatjava.data.*;
import ipatjava.data.expr.*;

public class StatementData extends Data implements StatementDataNode
{
    private Statement current;
    private ExprData exprData;
    private BasicBlockData parent;

    public StatementData(Statement statement,BasicBlockData parent)
    {
	super(statement.getExpr(),statement.getLineNo()==null?statement.getParent().getParent().getLineNo():statement.getLineNo());
	this.current = statement;
	this.parent = parent;
	exprData = ExprData.nextExpr(current.getExpr(),
				     statement.getLineNo()==null?statement.getParent().getParent().getLineNo():statement.getLineNo(),
				     this);
	super.mergeDataList(exprData);
	if(exprData.getIdValueList()!=null)
	    exprData.getIdValueList().printAllValue();
	statementDataSocket = new  StatementDataSocket(this);
    }
    
    public ExprData getExprData(){return exprData;}
    public Statement getStatement(){return current;}
}
