package ipatjava.data.block;
import ipatjava.tips.XMLTips;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import exc.block.*;

public class FunctionBlockData extends CompoundBlockData
{
    protected FunctionBlock current; 
    
    public FunctionBlockData(FunctionBlock functionBlock,BlockListData parent)
	{
	    super((CompoundBlock)functionBlock,parent);
	    this.current = functionBlock;
	}

    public Element getXMLElement(Document document)
    {
        Element element = XMLTips.createElement(document,"block");
        element.setAttribute("source",getSourceFileName());
        //element.setAttribute("lineno",Integer.toString(super.getBlock().getBody().getHead().getLineNo().lineNo()));
        element.setAttribute("type","function");
        element.setAttribute("name",getFunctionName());

        return element;
    }
    
    public String getSourceFileName(){return this.current.getFile().getSourceFileName();}
    public String getFunctionName(){return this.current.getName();}
}
