package ipatjava.analyzer.array.powertest;
import java.util.*;
import ipatjava.tips.*;
import ipatjava.math.*;

public class PowerTest
{
    private boolean depend = false;
    
    public PowerTest(Frac mQs[][],Frac vqs[],int mA[][],int va[],
		     Frac mQt[][],Frac vqt[],int mB[][],int vb[],
		     int unknown,int sameNest)
    {
	int rowmA=mA.length;
	int rowmB=mB.length;
	
	int col=mA[0].length;
	boolean regular=false;

	if(rowmA==rowmB)
	    {
		regular=true;
		for(int i=0;i<rowmA;i++)
		    for(int j=0;j<col;j++)
			if(mA[i][j]!=mB[i][j])
			    regular=false;
	    }

	if(regular)
	    {
		if(sameNest == mA.length -unknown)
		    if(va.length == vb.length)
			{
			    boolean check = true;
			    for(int i=0;i<va.length;i++)
				if(va[i]!=vb[i])
				    check=false;
			    if(check)
				{
				    boolean check1 = false;
				    for(int i=0;i<col;i++)
				    if(mA[rowmA-1][i]!=0)
					check1=true;
				    if(check1)
					{
					    depend = false;
					    return;
					}
				}
			}
	    }

	BitSet lev[]={new BitSet(),new BitSet(),new BitSet()};	

	if(regular)
	    depend = regularTest(mQs,vqs,mA,va,vb,unknown,sameNest,lev);
	else
	    depend = normalTest(mQs,vqs,mA,va,mQt,vqt,mB,vb,unknown,sameNest,lev);
    }
    
    public boolean isDepend(){return depend;}
    
    private static boolean normalTest(Frac mQs[][],Frac vqs[],int mA[][],int va[],
				      Frac mQt[][],Frac vqt[],int mB[][],int vb[],
				      int num_of_unknown,int sameNest,BitSet lev[])
    {
	
	boolean Solution=true;
	
	int unknown=num_of_unknown;
	int row_mA=mA.length-unknown;
	int row_mB=mB.length-unknown;
	int row=unknown+row_mA+row_mB;
	int col=mA[0].length;
	
	BitSet level = new BitSet();
	
	level.or(lev[0]);
	level.or(lev[1]);
	level.or(lev[2]);
	
	int levels = level.length();

	int equal=lev[1].cardinality();
	int lq=lev[0].cardinality();
	int gq=lev[2].cardinality();
	
	//MathTips.printVector("va",va);
	//MathTips.printVector("vb",vb);
	
	int m[][] = new int[row][col+equal];
	int v[] = new int[col+equal];

	for(int i=0;i<col;i++)
	    v[i]=vb[i]-va[i];

	for(int i=0;i<equal;i++)
	    v[i+col]=0;

	for(int i=0;i<unknown;i++)
	    for(int j=0;j<col;j++)
		m[i][j]=mA[i][j]-mB[i][j];

	for(int i=0;i<row_mA;i++)
	    for(int j=0;j<col;j++)
		m[i+unknown][j]=mA[i+unknown][j];
	
	for(int i=0;i<row_mB;i++)
	    for(int j=0;j<col;j++)	
		m[i+unknown+row_mA][j]=-1*mB[i+unknown][j];

	int count=0;
	for(int i=lev[1].nextSetBit(0);i!=-1;i=lev[1].nextSetBit(i+1))
	    {
		m[i+unknown][col+count]=1;
		m[i+unknown+row_mA][col+count]=-1;
		count++;
	    }
	
	//MathTips.printMatrix("m",m);
	//MathTips.printVector("v",v);

	for(int i=0;i<col;i++)
	    {
		boolean res= false; 
		if(v[i]!=0)
		    {
			for(int j=0;j<row;j++)
			    if(m[j][i]!=0)
				res= true;
			if(!res)
			    return false;
		    }
	    }

	int mU[][] = MathTips.getUnimodularMatrix(m);
	int mS[][] = MathTips.getEchelonMatrix(m);

	boolean check = true;

	if(!MathTips.gcdTest(mS,v))
	    check = false;

	if(check)
	    {
		Frac vT[] = MathTips.createVector(MathTips.getParameterVector(mS,v));

		int rank=MathTips.getRank(mS);
	
		Frac mU1[][] = new Frac[row][unknown+row_mA];
		Frac mU2[][] = new Frac[row][unknown+row_mB];

		for(int i=0;i<row;i++)
		    for(int j=0;j<unknown+row_mA;j++)
			mU1[i][j]=new Frac(mU[i][j]);

		for(int i=0;i<row;i++)
		    for(int j=0;j<unknown;j++)
			mU2[i][j]=new Frac(mU[i][j]);
		for(int i=0;i<row;i++)
		    for(int j=0;j<row_mB;j++)
			mU2[i][j+unknown]=new Frac(mU[i][j+unknown+row_mA]);


		Frac mU1_mQs[][] = MathTips.multiplyMatrix(mU1,mQs);
		Frac mU2_mQt[][] = MathTips.multiplyMatrix(mU2,mQt);

		Frac vTmpLow1[] = MathTips.multiplyMatrix(vT,mU1);
		Frac vTmpUp1[] = MathTips.multiplyMatrix(vT,mU1_mQs);
		Frac vTmpLow2[] = MathTips.multiplyMatrix(vT,mU2);
		Frac vTmpUp2[] = MathTips.multiplyMatrix(vT,mU2_mQt);

		Frac vC[] = new Frac[2*(row_mA+row_mB)+lq+gq];
		Frac mC[][] = new Frac[row-rank][2*(row_mA+row_mB)+lq+gq];

		for(int i=0;i<row_mA;i++)
		    {
			vC[i]=vTmpLow1[i+unknown].copy();
			vC[i+row_mA]=vqs[i+unknown].subtract(vTmpUp1[i+unknown]);
		    }
		for(int i=0;i<row_mB;i++)
		    {
			vC[i+2*(row_mA)]=vTmpLow2[i+unknown].copy();
			vC[i+2*(row_mA)+row_mB]=vqt[i+unknown].subtract(vTmpUp2[i+unknown]);
		    }

		for(int i=rank ;i< row;i++)
		    {
			for(int j=0;j<row_mA;j++)
			    {
				mC[i-rank][j]=MathTips.unary_minus(mU1[i][j+unknown]);
				mC[i-rank][j+row_mA]=mU1_mQs[i][j+unknown].copy();
			    }
			for(int j=0;j<row_mB;j++)
			    {
				mC[i-rank][j+2*(row_mA)]=MathTips.unary_minus(mU2[i][j+unknown]);
				mC[i-rank][j+2*(row_mA)+row_mB]=mU2_mQt[i][j+unknown].copy();
			    }
		    }

		count =0;
		for(int i=lev[0].nextSetBit(0);i!=-1;i=lev[0].nextSetBit(i+1))
		    {
			vC[2*(row_mA+row_mB)+count]=vTmpLow1[i+unknown].subtract(vTmpLow2[i+unknown]).subtract(new Frac(1));
			for(int j=rank;j<row;j++)
			    mC[j-rank][count+2*(row_mA+row_mB)]=mU1[j][i+unknown].subtract(mU2[j][i+unknown]);
			count++;
		    }
		for(int i=lev[2].nextSetBit(0);i!=-1;i=lev[2].nextSetBit(i+1))
		    {
			vC[2*(row_mA+row_mB)+count]=vTmpLow2[i+unknown].subtract(vTmpLow1[i+unknown]).subtract(new Frac(1));
			for(int j=rank;j<row;j++)
			    mC[j-rank][count+2*(row_mA+row_mB)]=mU2[j][i+unknown].subtract(mU1[j][i+unknown]);
			count++;
		    }

		check = MathTips.fourierElimination(mC,vC);
	    }

	/*
	  for(int i=0;i<levels;i++)
	    {
		if(lev[0].get(i))
		    System.out.print("<,");
		if(lev[1].get(i))
		    System.out.print("=,");
		if(lev[2].get(i))
		    System.out.print(">,");
	    }	

	System.out.print(check+"\n");
	*/

	if(levels==sameNest)
	    return check;

	if(!check)
	    return check;

	if(check)
	    {
		BitSet lev0[]= new BitSet[3];
		for(int i=0;i<3;i++)
		    lev0[i]=(BitSet)lev[i].clone();
		lev0[0].set(levels);
		normalTest(mQs,vqs,mA,va,
			   mQt,vqt,mB,vb,
			   num_of_unknown,sameNest,lev0);

		BitSet lev1[]= new BitSet[3];
		for(int i=0;i<3;i++)
		    lev1[i]=(BitSet)lev[i].clone();
		lev1[1].set(levels);
		normalTest(mQs,vqs,mA,va,
			   mQt,vqt,mB,vb,
			   num_of_unknown,sameNest,lev1);

		BitSet lev2[]= new BitSet[3];
		for(int i=0;i<3;i++)
		    lev2[i]=(BitSet)lev[i].clone();
		lev2[2].set(levels);
		normalTest(mQs,vqs,mA,va,
			   mQt,vqt,mB,vb,
			   num_of_unknown,sameNest,lev2);
	    }

	//MathTips.printMatrix("mA2",mC);
	//MathTips.printVector("q2",vC);

	    return check;
    }

    private static boolean regularTest(Frac mQs[][],Frac vqs[],
				       int mA[][],int va[],int vb[],
				       int num_of_unknown,int sameNest,BitSet lev[])
    {
	//System.out.println("regular");
	boolean Solution=true;
	int unknown=num_of_unknown;
	int row_mA=mA.length-unknown;
	int row=unknown+row_mA;
	int col=mA[0].length;
	
	
	BitSet level = new BitSet();
	
	level.or(lev[0]);
	level.or(lev[1]);
	level.or(lev[2]);
	
	int levels = level.length();

	int equal=lev[1].cardinality();
	int lq=lev[0].cardinality();
	int gq=lev[2].cardinality();
	
	//MathTips.printVector("a",a);
	//MathTips.printVector("vb",vb);
	
	int m[][] = new int[row][col+equal];
	int v[] = new int[col+equal];

	for(int i=0;i<col;i++)
	    v[i]=va[i]-vb[i];
	
	for(int i=0;i<unknown;i++)
	    for(int j=0;j<col;j++)
		m[i][j]=mA[i][j];

	for(int i=0;i<row_mA;i++)
	    for(int j=0;j<col;j++)
		m[i+unknown][j]=mA[i+unknown][j];

	int count=0;
	for(int i=lev[1].nextSetBit(0);i!=-1;i=lev[1].nextSetBit(i+1))
	    {
		m[i+unknown][col+count]=1;
		count++;
	    }
	
	for(int i=0;i<col;i++)
	    {
		boolean res= false; 
		if(v[i]!=0)
		    {
			for(int j=0;j<row;j++)
			    {
				if(m[j][i]!=0)
				    res= true;
			    }
			if(res == false)
			    return false;
		    }
	    }
	
	/*
	MathTips.printMatrix("M",M);
	MathTips.printVector("v",v);
	*/

	Frac mU[][] = MathTips.createMatrix(MathTips.getUnimodularMatrix(m));
	int mS[][] = MathTips.getEchelonMatrix(m);

	boolean check = true;

	if(!MathTips.gcdTest(mS,v))
	    check = false;

	if(check)
	    {
		Frac vT[] = MathTips.createVector(MathTips.getParameterVector(mS,v));

		int rank=MathTips.getRank(mS);

		Frac vC[] = new Frac[2*(row_mA)+lq+gq];
		Frac mC[][] = new Frac[row-rank][2*(row_mA)+lq+gq];

		for(int i=0;i<row_mA;i++)
		    vC[i]=vqs[i+unknown].add(vT[i+unknown]);
		for(int i=0;i<row_mA;i++)
		    vC[i+(row_mA)]=vqs[i+unknown].subtract(vT[i+unknown]);

		for(int i=rank ;i< row;i++)
		    {
			for(int j=0;j<row_mA;j++)
				mC[i-rank][j]=MathTips.unary_minus(mU[i][j+unknown]);
			for(int j=0;j<row_mA;j++)
				mC[i-rank][j+(row_mA)]=mU[i][j+unknown].copy();
		    }
		Frac tmpInv = new Frac(-1);
		count =0;
		for(int i=lev[0].nextSetBit(0);i!=-1;i=lev[0].nextSetBit(i+1))
		    {
			vC[2*row_mA+count]=tmpInv.add(vT[i+unknown]);
			for(int j=rank;j<row;j++)
			    mC[j-rank][count+2*row_mA]=MathTips.unary_minus(mU[j][i+unknown]);
			count++;
		    }
		for(int i=lev[2].nextSetBit(0);i!=-1;i=lev[2].nextSetBit(i+1))
		    {
			vC[2*row_mA+count]=tmpInv.subtract(vT[i+unknown]);
			for(int j=rank;j<row;j++)
			    mC[j-rank][count+2*row_mA]=mU[j][i+unknown].copy();
			count++;
		    }

		check = MathTips.fourierElimination(mC,vC);
	    }

	/*
	for(int i=0;i<levels;i++)
	    {
		if(lev[0].get(i))
		    System.out.print("<,");
		if(lev[1].get(i))
		    System.out.print("=,");
		if(lev[2].get(i))
		    System.out.print(">,");
	    }	
	System.out.print(check+"\n");
	*/

	if(levels==sameNest)
	    return check;

	if(!check)
	    return check;

	if(check)
	    {
		BitSet lev0[]= new BitSet[3];
		for(int i=0;i<3;i++)
		    lev0[i]=(BitSet)lev[i].clone();
		lev0[0].set(levels);
		regularTest(mQs,vqs,mA,va,vb,unknown,sameNest,lev0);

		BitSet lev1[]= new BitSet[3];
		for(int i=0;i<3;i++)
		    lev1[i]=(BitSet)lev[i].clone();
		lev1[1].set(levels);
		regularTest(mQs,vqs,mA,va,vb,unknown,sameNest,lev1);

		BitSet lev2[]= new BitSet[3];
		for(int i=0;i<3;i++)
		    lev2[i]=(BitSet)lev[i].clone();
		lev2[2].set(levels);
		regularTest(mQs,vqs,mA,va,vb,unknown,sameNest,lev2);
	    }

	//MathTips.printMatrix("mA2",mC);
	//MathTips.printVector("q2",vC);

	    return check;
    }
}
