package ipatjava.analyzer;
import ipatjava.analyzer.array.ArrayDataAnalyzer;
import ipatjava.analyzer.scalar.ScalarDataAnalyzer;
import ipatjava.data.Data;
import ipatjava.graph.FlowGraph;


public class ProgramAnalyzer
{
	protected ProgramAnalyzer programAnalyzer;
	protected Data data = null;
	protected FlowGraph flowGraph = null;
    protected ScalarDataAnalyzer scalarDataAnalyzer = null;
    protected ArrayDataAnalyzer arrayDataAnalyzer= null;

    public ProgramAnalyzer(Data data)
    {
    	this.data = data;
    	this.flowGraph = new FlowGraph(this.data);
    	this.scalarDataAnalyzer = new ScalarDataAnalyzer(flowGraph);
    	this.arrayDataAnalyzer = new ArrayDataAnalyzer(flowGraph);
    }
    
    public ProgramAnalyzer(ProgramAnalyzer programAnalyzer)
    {
    	this.programAnalyzer=programAnalyzer;
    	this.data = this.programAnalyzer.getData();
    	this.flowGraph=this.programAnalyzer.getFlowGraph();
    	this.scalarDataAnalyzer=this.programAnalyzer.getScalarDataAnalyzer();
    	this.arrayDataAnalyzer=this.programAnalyzer.getArrayDataAnalyzer();
    }
    
    public ScalarDataAnalyzer getScalarDataAnalyzer(){return this.scalarDataAnalyzer;}
    public ArrayDataAnalyzer getArrayDataAnalyzer(){return this.arrayDataAnalyzer;}
    public FlowGraph getFlowGraph(){return this.flowGraph;}
    public Data  getData(){return this.data;}
 }
