package ipatjava.analyzer;

import ipatjava.data.Data;
import ipatjava.graph.FlowGraph;
import ipatjava.tips.BitSetTips;

import java.util.BitSet;

public class LocalDataAnalyzer 
{
	protected DataAnalyzer dataAnalyzer;
	protected FlowGraph flowGraph;
	protected Data targetData;

	protected BitSet inner;
    protected BitSet outer;

    protected BitSet nodeInner;
    protected BitSet nodeOuter;

    protected BitSet tableInner;
    protected BitSet tableOuter;

    protected BitSet readTableInner;
    protected BitSet readTableOuter;
    
    protected BitSet writeTableInner;
    protected BitSet writeTableOuter;
    
    protected BitSet reductionTableInner;
    protected BitSet reductionTableOuter;

    public LocalDataAnalyzer(DataAnalyzer dataAnalyzer,Data targetData)
    {
    	this.dataAnalyzer = dataAnalyzer;
    	this.flowGraph = this.dataAnalyzer.getFlowGraph();
    	this.targetData = targetData;
    	
    	calcInner();
    	calcOuter();
     }

    private void calcInner()
    {
    	this.inner = this.targetData.getChildDataIndex();
    	this.nodeInner = this.flowGraph.getNodeIndexBitSet(this.inner);
    	this.tableInner = this.dataAnalyzer.getTableIndexBitSet(this.inner);

    	this.writeTableInner = BitSetTips.and(this.dataAnalyzer.writeTable(),this.tableInner);
    	this.readTableInner = BitSetTips.and(this.dataAnalyzer.readTable(),this.tableInner);
    	this.reductionTableInner = BitSetTips.and(this.dataAnalyzer.reductionTable(),this.tableInner);
    }
    
    private void calcOuter()
    {
    	this.outer = new BitSet();
    	outer.set(0,this.flowGraph.getData().getDataListSize());
    	outer.andNot(inner);
            this.nodeOuter = this.flowGraph.getNodeIndexBitSet(this.outer);
    	this.tableOuter = this.dataAnalyzer.getTableIndexBitSet(this.outer);

	this.writeTableOuter = BitSetTips.and(this.dataAnalyzer.writeTable(),this.tableOuter);
	this.readTableOuter = BitSetTips.and(this.dataAnalyzer.readTable(),this.tableOuter);
	this.reductionTableOuter = BitSetTips.and(this.dataAnalyzer.reductionTable(),this.tableOuter);

    }
    
    public BitSet tableInner(){return tableInner;}
    public BitSet readTableInner(){return readTableInner;}
    public BitSet writeTableInner(){return writeTableInner;}
    public BitSet redacutionTableInner(){return reductionTableInner;}
    public BitSet nodeInner(){return nodeInner;}
    
    public BitSet tableOuter(){return tableOuter;}
    public BitSet readTableOuter(){return readTableOuter;}
    public BitSet writeTableOuter(){return writeTableOuter;}
    public BitSet redacutionTableOuter(){return reductionTableOuter;}
    public BitSet nodeOuter(){return nodeOuter;}public BitSet genInner(){return nodeOuter;}

}
