/******************************************************************************/
/*! @file table_iso8859_unicode.cc
    @brief Header file of ISO-8859/UCS-2 table.
    @author Masashi Astro Tachibana, Apolloron Project.
 ******************************************************************************/

#include "table_iso8859_unicode.h"

namespace apolloron {

/* ISO-8859-1  0x80-0xFF */
const unsigned char iso8859_1_unicode[ISO8859_UNICODE_TABLE_MAX][2] = {
    {0x00, 0x80}, {0x00, 0x81}, {0x00, 0x82}, {0x00, 0x83},
    {0x00, 0x84}, {0x00, 0x85}, {0x00, 0x86}, {0x00, 0x87},
    {0x00, 0x88}, {0x00, 0x89}, {0x00, 0x8A}, {0x00, 0x8B},
    {0x00, 0x8C}, {0x00, 0x8D}, {0x00, 0x8E}, {0x00, 0x8F},
    {0x00, 0x90}, {0x00, 0x91}, {0x00, 0x92}, {0x00, 0x93},
    {0x00, 0x94}, {0x00, 0x95}, {0x00, 0x96}, {0x00, 0x97},
    {0x00, 0x98}, {0x00, 0x99}, {0x00, 0x9A}, {0x00, 0x9B},
    {0x00, 0x9C}, {0x00, 0x9D}, {0x00, 0x9E}, {0x00, 0x9F},
    {0x00, 0xA0}, {0x00, 0xA1}, {0x00, 0xA2}, {0x00, 0xA3},
    {0x00, 0xA4}, {0x00, 0xA5}, {0x00, 0xA6}, {0x00, 0xA7},
    {0x00, 0xA8}, {0x00, 0xA9}, {0x00, 0xAA}, {0x00, 0xAB},
    {0x00, 0xAC}, {0x00, 0xAD}, {0x00, 0xAE}, {0x00, 0xAF},
    {0x00, 0xB0}, {0x00, 0xB1}, {0x00, 0xB2}, {0x00, 0xB3},
    {0x00, 0xB4}, {0x00, 0xB5}, {0x00, 0xB6}, {0x00, 0xB7},
    {0x00, 0xB8}, {0x00, 0xB9}, {0x00, 0xBA}, {0x00, 0xBB},
    {0x00, 0xBC}, {0x00, 0xBD}, {0x00, 0xBE}, {0x00, 0xBF},
    {0x00, 0xC0}, {0x00, 0xC1}, {0x00, 0xC2}, {0x00, 0xC3},
    {0x00, 0xC4}, {0x00, 0xC5}, {0x00, 0xC6}, {0x00, 0xC7},
    {0x00, 0xC8}, {0x00, 0xC9}, {0x00, 0xCA}, {0x00, 0xCB},
    {0x00, 0xCC}, {0x00, 0xCD}, {0x00, 0xCE}, {0x00, 0xCF},
    {0x00, 0xD0}, {0x00, 0xD1}, {0x00, 0xD2}, {0x00, 0xD3},
    {0x00, 0xD4}, {0x00, 0xD5}, {0x00, 0xD6}, {0x00, 0xD7},
    {0x00, 0xD8}, {0x00, 0xD9}, {0x00, 0xDA}, {0x00, 0xDB},
    {0x00, 0xDC}, {0x00, 0xDD}, {0x00, 0xDE}, {0x00, 0xDF},
    {0x00, 0xE0}, {0x00, 0xE1}, {0x00, 0xE2}, {0x00, 0xE3},
    {0x00, 0xE4}, {0x00, 0xE5}, {0x00, 0xE6}, {0x00, 0xE7},
    {0x00, 0xE8}, {0x00, 0xE9}, {0x00, 0xEA}, {0x00, 0xEB},
    {0x00, 0xEC}, {0x00, 0xED}, {0x00, 0xEE}, {0x00, 0xEF},
    {0x00, 0xF0}, {0x00, 0xF1}, {0x00, 0xF2}, {0x00, 0xF3},
    {0x00, 0xF4}, {0x00, 0xF5}, {0x00, 0xF6}, {0x00, 0xF7},
    {0x00, 0xF8}, {0x00, 0xF9}, {0x00, 0xFA}, {0x00, 0xFB},
    {0x00, 0xFC}, {0x00, 0xFD}, {0x00, 0xFE}, {0x00, 0xFF}
};


/* ISO-8859-2  0x80-0xFF */
const unsigned char iso8859_2_unicode[ISO8859_UNICODE_TABLE_MAX][2] = {
    {0x00, 0x80}, {0x00, 0x81}, {0x00, 0x82}, {0x00, 0x83},
    {0x00, 0x84}, {0x00, 0x85}, {0x00, 0x86}, {0x00, 0x87},
    {0x00, 0x88}, {0x00, 0x89}, {0x00, 0x8A}, {0x00, 0x8B},
    {0x00, 0x8C}, {0x00, 0x8D}, {0x00, 0x8E}, {0x00, 0x8F},
    {0x00, 0x90}, {0x00, 0x91}, {0x00, 0x92}, {0x00, 0x93},
    {0x00, 0x94}, {0x00, 0x95}, {0x00, 0x96}, {0x00, 0x97},
    {0x00, 0x98}, {0x00, 0x99}, {0x00, 0x9A}, {0x00, 0x9B},
    {0x00, 0x9C}, {0x00, 0x9D}, {0x00, 0x9E}, {0x00, 0x9F},
    {0x00, 0xA0}, {0x01, 0x04}, {0x02, 0xD8}, {0x01, 0x41},
    {0x00, 0xA4}, {0x01, 0x3D}, {0x01, 0x5A}, {0x00, 0xA7},
    {0x00, 0xA8}, {0x01, 0x60}, {0x01, 0x5E}, {0x01, 0x64},
    {0x01, 0x79}, {0x00, 0xAD}, {0x01, 0x7D}, {0x01, 0x7B},
    {0x00, 0xB0}, {0x01, 0x05}, {0x02, 0xDB}, {0x01, 0x42},
    {0x00, 0xB4}, {0x01, 0x3E}, {0x01, 0x5B}, {0x02, 0xC7},
    {0x00, 0xB8}, {0x01, 0x61}, {0x01, 0x5F}, {0x01, 0x65},
    {0x01, 0x7A}, {0x02, 0xDD}, {0x01, 0x7E}, {0x01, 0x7C},
    {0x01, 0x54}, {0x00, 0xC1}, {0x00, 0xC2}, {0x01, 0x02},
    {0x00, 0xC4}, {0x01, 0x39}, {0x01, 0x06}, {0x00, 0xC7},
    {0x01, 0x0C}, {0x00, 0xC9}, {0x01, 0x18}, {0x00, 0xCB},
    {0x01, 0x1A}, {0x00, 0xCD}, {0x00, 0xCE}, {0x01, 0x0E},
    {0x01, 0x10}, {0x01, 0x43}, {0x01, 0x47}, {0x00, 0xD3},
    {0x00, 0xD4}, {0x01, 0x50}, {0x00, 0xD6}, {0x00, 0xD7},
    {0x01, 0x58}, {0x01, 0x6E}, {0x00, 0xDA}, {0x01, 0x70},
    {0x00, 0xDC}, {0x00, 0xDD}, {0x01, 0x62}, {0x00, 0xDF},
    {0x01, 0x55}, {0x00, 0xE1}, {0x00, 0xE2}, {0x01, 0x03},
    {0x00, 0xE4}, {0x01, 0x3A}, {0x01, 0x07}, {0x00, 0xE7},
    {0x01, 0x0D}, {0x00, 0xE9}, {0x01, 0x19}, {0x00, 0xEB},
    {0x01, 0x1B}, {0x00, 0xED}, {0x00, 0xEE}, {0x01, 0x0F},
    {0x01, 0x11}, {0x01, 0x44}, {0x01, 0x48}, {0x00, 0xF3},
    {0x00, 0xF4}, {0x01, 0x51}, {0x00, 0xF6}, {0x00, 0xF7},
    {0x01, 0x59}, {0x01, 0x6F}, {0x00, 0xFA}, {0x01, 0x71},
    {0x00, 0xFC}, {0x00, 0xFD}, {0x01, 0x63}, {0x02, 0xD9}
};


/* ISO-8859-3  0x80-0xFF */
const unsigned char iso8859_3_unicode[ISO8859_UNICODE_TABLE_MAX][2] = {
    {0x00, 0x80}, {0x00, 0x81}, {0x00, 0x82}, {0x00, 0x83},
    {0x00, 0x84}, {0x00, 0x85}, {0x00, 0x86}, {0x00, 0x87},
    {0x00, 0x88}, {0x00, 0x89}, {0x00, 0x8A}, {0x00, 0x8B},
    {0x00, 0x8C}, {0x00, 0x8D}, {0x00, 0x8E}, {0x00, 0x8F},
    {0x00, 0x90}, {0x00, 0x91}, {0x00, 0x92}, {0x00, 0x93},
    {0x00, 0x94}, {0x00, 0x95}, {0x00, 0x96}, {0x00, 0x97},
    {0x00, 0x98}, {0x00, 0x99}, {0x00, 0x9A}, {0x00, 0x9B},
    {0x00, 0x9C}, {0x00, 0x9D}, {0x00, 0x9E}, {0x00, 0x9F},
    {0x00, 0xA0}, {0x01, 0x26}, {0x02, 0xD8}, {0x00, 0xA3},
    {0x00, 0xA4}, {0x00, 0x00}, {0x01, 0x24}, {0x00, 0xA7},
    {0x00, 0xA8}, {0x01, 0x30}, {0x01, 0x5E}, {0x01, 0x1E},
    {0x01, 0x34}, {0x00, 0xAD}, {0x00, 0x00}, {0x01, 0x7B},
    {0x00, 0xB0}, {0x01, 0x27}, {0x00, 0xB2}, {0x00, 0xB3},
    {0x00, 0xB4}, {0x00, 0xB5}, {0x01, 0x25}, {0x00, 0xB7},
    {0x00, 0xB8}, {0x01, 0x31}, {0x01, 0x5F}, {0x01, 0x1F},
    {0x01, 0x35}, {0x00, 0xBD}, {0x00, 0x00}, {0x01, 0x7C},
    {0x00, 0xC0}, {0x00, 0xC1}, {0x00, 0xC2}, {0x00, 0x00},
    {0x00, 0xC4}, {0x01, 0x0A}, {0x01, 0x08}, {0x00, 0xC7},
    {0x00, 0xC8}, {0x00, 0xC9}, {0x00, 0xCA}, {0x00, 0xCB},
    {0x00, 0xCC}, {0x00, 0xCD}, {0x00, 0xCE}, {0x00, 0xCF},
    {0x00, 0x00}, {0x00, 0xD1}, {0x00, 0xD2}, {0x00, 0xD3},
    {0x00, 0xD4}, {0x01, 0x20}, {0x00, 0xD6}, {0x00, 0xD7},
    {0x01, 0x1C}, {0x00, 0xD9}, {0x00, 0xDA}, {0x00, 0xDB},
    {0x00, 0xDC}, {0x01, 0x6C}, {0x01, 0x5C}, {0x00, 0xDF},
    {0x00, 0xE0}, {0x00, 0xE1}, {0x00, 0xE2}, {0x00, 0x00},
    {0x00, 0xE4}, {0x01, 0x0B}, {0x01, 0x09}, {0x00, 0xE7},
    {0x00, 0xE8}, {0x00, 0xE9}, {0x00, 0xEA}, {0x00, 0xEB},
    {0x00, 0xEC}, {0x00, 0xED}, {0x00, 0xEE}, {0x00, 0xEF},
    {0x00, 0x00}, {0x00, 0xF1}, {0x00, 0xF2}, {0x00, 0xF3},
    {0x00, 0xF4}, {0x01, 0x21}, {0x00, 0xF6}, {0x00, 0xF7},
    {0x01, 0x1D}, {0x00, 0xF9}, {0x00, 0xFA}, {0x00, 0xFB},
    {0x00, 0xFC}, {0x01, 0x6D}, {0x01, 0x5D}, {0x02, 0xD9}
};


/* ISO-8859-4  0x80-0xFF */
const unsigned char iso8859_4_unicode[ISO8859_UNICODE_TABLE_MAX][2] = {
    {0x00, 0x80}, {0x00, 0x81}, {0x00, 0x82}, {0x00, 0x83},
    {0x00, 0x84}, {0x00, 0x85}, {0x00, 0x86}, {0x00, 0x87},
    {0x00, 0x88}, {0x00, 0x89}, {0x00, 0x8A}, {0x00, 0x8B},
    {0x00, 0x8C}, {0x00, 0x8D}, {0x00, 0x8E}, {0x00, 0x8F},
    {0x00, 0x90}, {0x00, 0x91}, {0x00, 0x92}, {0x00, 0x93},
    {0x00, 0x94}, {0x00, 0x95}, {0x00, 0x96}, {0x00, 0x97},
    {0x00, 0x98}, {0x00, 0x99}, {0x00, 0x9A}, {0x00, 0x9B},
    {0x00, 0x9C}, {0x00, 0x9D}, {0x00, 0x9E}, {0x00, 0x9F},
    {0x00, 0xA0}, {0x01, 0x04}, {0x01, 0x38}, {0x01, 0x56},
    {0x00, 0xA4}, {0x01, 0x28}, {0x01, 0x3B}, {0x00, 0xA7},
    {0x00, 0xA8}, {0x01, 0x60}, {0x01, 0x12}, {0x01, 0x22},
    {0x01, 0x66}, {0x00, 0xAD}, {0x01, 0x7D}, {0x00, 0xAF},
    {0x00, 0xB0}, {0x01, 0x05}, {0x02, 0xDB}, {0x01, 0x57},
    {0x00, 0xB4}, {0x01, 0x29}, {0x01, 0x3C}, {0x02, 0xC7},
    {0x00, 0xB8}, {0x01, 0x61}, {0x01, 0x13}, {0x01, 0x23},
    {0x01, 0x67}, {0x01, 0x4A}, {0x01, 0x7E}, {0x01, 0x4B},
    {0x01, 0x00}, {0x00, 0xC1}, {0x00, 0xC2}, {0x00, 0xC3},
    {0x00, 0xC4}, {0x00, 0xC5}, {0x00, 0xC6}, {0x01, 0x2E},
    {0x01, 0x0C}, {0x00, 0xC9}, {0x01, 0x18}, {0x00, 0xCB},
    {0x01, 0x16}, {0x00, 0xCD}, {0x00, 0xCE}, {0x01, 0x2A},
    {0x01, 0x10}, {0x01, 0x45}, {0x01, 0x4C}, {0x01, 0x36},
    {0x00, 0xD4}, {0x00, 0xD5}, {0x00, 0xD6}, {0x00, 0xD7},
    {0x00, 0xD8}, {0x01, 0x72}, {0x00, 0xDA}, {0x00, 0xDB},
    {0x00, 0xDC}, {0x01, 0x68}, {0x01, 0x6A}, {0x00, 0xDF},
    {0x01, 0x01}, {0x00, 0xE1}, {0x00, 0xE2}, {0x00, 0xE3},
    {0x00, 0xE4}, {0x00, 0xE5}, {0x00, 0xE6}, {0x01, 0x2F},
    {0x01, 0x0D}, {0x00, 0xE9}, {0x01, 0x19}, {0x00, 0xEB},
    {0x01, 0x17}, {0x00, 0xED}, {0x00, 0xEE}, {0x01, 0x2B},
    {0x01, 0x11}, {0x01, 0x46}, {0x01, 0x4D}, {0x01, 0x37},
    {0x00, 0xF4}, {0x00, 0xF5}, {0x00, 0xF6}, {0x00, 0xF7},
    {0x00, 0xF8}, {0x01, 0x73}, {0x00, 0xFA}, {0x00, 0xFB},
    {0x00, 0xFC}, {0x01, 0x69}, {0x01, 0x6B}, {0x02, 0xD9}
};


/* ISO-8859-5  0x80-0xFF */
const unsigned char iso8859_5_unicode[ISO8859_UNICODE_TABLE_MAX][2] = {
    {0x00, 0x80}, {0x00, 0x81}, {0x00, 0x82}, {0x00, 0x83},
    {0x00, 0x84}, {0x00, 0x85}, {0x00, 0x86}, {0x00, 0x87},
    {0x00, 0x88}, {0x00, 0x89}, {0x00, 0x8A}, {0x00, 0x8B},
    {0x00, 0x8C}, {0x00, 0x8D}, {0x00, 0x8E}, {0x00, 0x8F},
    {0x00, 0x90}, {0x00, 0x91}, {0x00, 0x92}, {0x00, 0x93},
    {0x00, 0x94}, {0x00, 0x95}, {0x00, 0x96}, {0x00, 0x97},
    {0x00, 0x98}, {0x00, 0x99}, {0x00, 0x9A}, {0x00, 0x9B},
    {0x00, 0x9C}, {0x00, 0x9D}, {0x00, 0x9E}, {0x00, 0x9F},
    {0x00, 0xA0}, {0x04, 0x01}, {0x04, 0x02}, {0x04, 0x03},
    {0x04, 0x04}, {0x04, 0x05}, {0x04, 0x06}, {0x04, 0x07},
    {0x04, 0x08}, {0x04, 0x09}, {0x04, 0x0A}, {0x04, 0x0B},
    {0x04, 0x0C}, {0x00, 0xAD}, {0x04, 0x0E}, {0x04, 0x0F},
    {0x04, 0x10}, {0x04, 0x11}, {0x04, 0x12}, {0x04, 0x13},
    {0x04, 0x14}, {0x04, 0x15}, {0x04, 0x16}, {0x04, 0x17},
    {0x04, 0x18}, {0x04, 0x19}, {0x04, 0x1A}, {0x04, 0x1B},
    {0x04, 0x1C}, {0x04, 0x1D}, {0x04, 0x1E}, {0x04, 0x1F},
    {0x04, 0x20}, {0x04, 0x21}, {0x04, 0x22}, {0x04, 0x23},
    {0x04, 0x24}, {0x04, 0x25}, {0x04, 0x26}, {0x04, 0x27},
    {0x04, 0x28}, {0x04, 0x29}, {0x04, 0x2A}, {0x04, 0x2B},
    {0x04, 0x2C}, {0x04, 0x2D}, {0x04, 0x2E}, {0x04, 0x2F},
    {0x04, 0x30}, {0x04, 0x31}, {0x04, 0x32}, {0x04, 0x33},
    {0x04, 0x34}, {0x04, 0x35}, {0x04, 0x36}, {0x04, 0x37},
    {0x04, 0x38}, {0x04, 0x39}, {0x04, 0x3A}, {0x04, 0x3B},
    {0x04, 0x3C}, {0x04, 0x3D}, {0x04, 0x3E}, {0x04, 0x3F},
    {0x04, 0x40}, {0x04, 0x41}, {0x04, 0x42}, {0x04, 0x43},
    {0x04, 0x44}, {0x04, 0x45}, {0x04, 0x46}, {0x04, 0x47},
    {0x04, 0x48}, {0x04, 0x49}, {0x04, 0x4A}, {0x04, 0x4B},
    {0x04, 0x4C}, {0x04, 0x4D}, {0x04, 0x4E}, {0x04, 0x4F},
    {0x21, 0x16}, {0x04, 0x51}, {0x04, 0x52}, {0x04, 0x53},
    {0x04, 0x54}, {0x04, 0x55}, {0x04, 0x56}, {0x04, 0x57},
    {0x04, 0x58}, {0x04, 0x59}, {0x04, 0x5A}, {0x04, 0x5B},
    {0x04, 0x5C}, {0x00, 0xA7}, {0x04, 0x5E}, {0x04, 0x5F}
};


/* ISO-8859-6  0x80-0xFF */
const unsigned char iso8859_6_unicode[ISO8859_UNICODE_TABLE_MAX][2] = {
    {0x00, 0x80}, {0x00, 0x81}, {0x00, 0x82}, {0x00, 0x83},
    {0x00, 0x84}, {0x00, 0x85}, {0x00, 0x86}, {0x00, 0x87},
    {0x00, 0x88}, {0x00, 0x89}, {0x00, 0x8A}, {0x00, 0x8B},
    {0x00, 0x8C}, {0x00, 0x8D}, {0x00, 0x8E}, {0x00, 0x8F},
    {0x00, 0x90}, {0x00, 0x91}, {0x00, 0x92}, {0x00, 0x93},
    {0x00, 0x94}, {0x00, 0x95}, {0x00, 0x96}, {0x00, 0x97},
    {0x00, 0x98}, {0x00, 0x99}, {0x00, 0x9A}, {0x00, 0x9B},
    {0x00, 0x9C}, {0x00, 0x9D}, {0x00, 0x9E}, {0x00, 0x9F},
    {0x00, 0xA0}, {0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00},
    {0x00, 0xA4}, {0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00},
    {0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00},
    {0x06, 0x0C}, {0x00, 0xAD}, {0x00, 0x00}, {0x00, 0x00},
    {0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00},
    {0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00},
    {0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00}, {0x06, 0x1B},
    {0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00}, {0x06, 0x1F},
    {0x00, 0x00}, {0x06, 0x21}, {0x06, 0x22}, {0x06, 0x23},
    {0x06, 0x24}, {0x06, 0x25}, {0x06, 0x26}, {0x06, 0x27},
    {0x06, 0x28}, {0x06, 0x29}, {0x06, 0x2A}, {0x06, 0x2B},
    {0x06, 0x2C}, {0x06, 0x2D}, {0x06, 0x2E}, {0x06, 0x2F},
    {0x06, 0x30}, {0x06, 0x31}, {0x06, 0x32}, {0x06, 0x33},
    {0x06, 0x34}, {0x06, 0x35}, {0x06, 0x36}, {0x06, 0x37},
    {0x06, 0x38}, {0x06, 0x39}, {0x06, 0x3A}, {0x00, 0x00},
    {0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00},
    {0x06, 0x40}, {0x06, 0x41}, {0x06, 0x42}, {0x06, 0x43},
    {0x06, 0x44}, {0x06, 0x45}, {0x06, 0x46}, {0x06, 0x47},
    {0x06, 0x48}, {0x06, 0x49}, {0x06, 0x4A}, {0x06, 0x4B},
    {0x06, 0x4C}, {0x06, 0x4D}, {0x06, 0x4E}, {0x06, 0x4F},
    {0x06, 0x50}, {0x06, 0x51}, {0x06, 0x52}, {0x00, 0x00},
    {0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00},
    {0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00},
    {0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00}
};


/* ISO-8859-7  0x80-0xFF */
const unsigned char iso8859_7_unicode[ISO8859_UNICODE_TABLE_MAX][2] = {
    {0x00, 0x80}, {0x00, 0x81}, {0x00, 0x82}, {0x00, 0x83},
    {0x00, 0x84}, {0x00, 0x85}, {0x00, 0x86}, {0x00, 0x87},
    {0x00, 0x88}, {0x00, 0x89}, {0x00, 0x8A}, {0x00, 0x8B},
    {0x00, 0x8C}, {0x00, 0x8D}, {0x00, 0x8E}, {0x00, 0x8F},
    {0x00, 0x90}, {0x00, 0x91}, {0x00, 0x92}, {0x00, 0x93},
    {0x00, 0x94}, {0x00, 0x95}, {0x00, 0x96}, {0x00, 0x97},
    {0x00, 0x98}, {0x00, 0x99}, {0x00, 0x9A}, {0x00, 0x9B},
    {0x00, 0x9C}, {0x00, 0x9D}, {0x00, 0x9E}, {0x00, 0x9F},
    {0x00, 0xA0}, {0x20, 0x18}, {0x20, 0x19}, {0x00, 0xA3},
    {0x00, 0x00}, {0x00, 0x00}, {0x00, 0xA6}, {0x00, 0xA7},
    {0x00, 0xA8}, {0x00, 0xA9}, {0x00, 0x00}, {0x00, 0xAB},
    {0x00, 0xAC}, {0x00, 0xAD}, {0x00, 0x00}, {0x20, 0x15},
    {0x00, 0xB0}, {0x00, 0xB1}, {0x00, 0xB2}, {0x00, 0xB3},
    {0x03, 0x84}, {0x03, 0x85}, {0x03, 0x86}, {0x00, 0xB7},
    {0x03, 0x88}, {0x03, 0x89}, {0x03, 0x8A}, {0x00, 0xBB},
    {0x03, 0x8C}, {0x00, 0xBD}, {0x03, 0x8E}, {0x03, 0x8F},
    {0x03, 0x90}, {0x03, 0x91}, {0x03, 0x92}, {0x03, 0x93},
    {0x03, 0x94}, {0x03, 0x95}, {0x03, 0x96}, {0x03, 0x97},
    {0x03, 0x98}, {0x03, 0x99}, {0x03, 0x9A}, {0x03, 0x9B},
    {0x03, 0x9C}, {0x03, 0x9D}, {0x03, 0x9E}, {0x03, 0x9F},
    {0x03, 0xA0}, {0x03, 0xA1}, {0x00, 0x00}, {0x03, 0xA3},
    {0x03, 0xA4}, {0x03, 0xA5}, {0x03, 0xA6}, {0x03, 0xA7},
    {0x03, 0xA8}, {0x03, 0xA9}, {0x03, 0xAA}, {0x03, 0xAB},
    {0x03, 0xAC}, {0x03, 0xAD}, {0x03, 0xAE}, {0x03, 0xAF},
    {0x03, 0xB0}, {0x03, 0xB1}, {0x03, 0xB2}, {0x03, 0xB3},
    {0x03, 0xB4}, {0x03, 0xB5}, {0x03, 0xB6}, {0x03, 0xB7},
    {0x03, 0xB8}, {0x03, 0xB9}, {0x03, 0xBA}, {0x03, 0xBB},
    {0x03, 0xBC}, {0x03, 0xBD}, {0x03, 0xBE}, {0x03, 0xBF},
    {0x03, 0xC0}, {0x03, 0xC1}, {0x03, 0xC2}, {0x03, 0xC3},
    {0x03, 0xC4}, {0x03, 0xC5}, {0x03, 0xC6}, {0x03, 0xC7},
    {0x03, 0xC8}, {0x03, 0xC9}, {0x03, 0xCA}, {0x03, 0xCB},
    {0x03, 0xCC}, {0x03, 0xCD}, {0x03, 0xCE}, {0x00, 0x00}
};


/* ISO-8859-8  0x80-0xFF */
const unsigned char iso8859_8_unicode[ISO8859_UNICODE_TABLE_MAX][2] = {
    {0x00, 0x80}, {0x00, 0x81}, {0x00, 0x82}, {0x00, 0x83},
    {0x00, 0x84}, {0x00, 0x85}, {0x00, 0x86}, {0x00, 0x87},
    {0x00, 0x88}, {0x00, 0x89}, {0x00, 0x8A}, {0x00, 0x8B},
    {0x00, 0x8C}, {0x00, 0x8D}, {0x00, 0x8E}, {0x00, 0x8F},
    {0x00, 0x90}, {0x00, 0x91}, {0x00, 0x92}, {0x00, 0x93},
    {0x00, 0x94}, {0x00, 0x95}, {0x00, 0x96}, {0x00, 0x97},
    {0x00, 0x98}, {0x00, 0x99}, {0x00, 0x9A}, {0x00, 0x9B},
    {0x00, 0x9C}, {0x00, 0x9D}, {0x00, 0x9E}, {0x00, 0x9F},
    {0x00, 0xA0}, {0x00, 0x00}, {0x00, 0xA2}, {0x00, 0xA3},
    {0x00, 0xA4}, {0x00, 0xA5}, {0x00, 0xA6}, {0x00, 0xA7},
    {0x00, 0xA8}, {0x00, 0xA9}, {0x00, 0xD7}, {0x00, 0xAB},
    {0x00, 0xAC}, {0x00, 0xAD}, {0x00, 0xAE}, {0x00, 0xAF},
    {0x00, 0xB0}, {0x00, 0xB1}, {0x00, 0xB2}, {0x00, 0xB3},
    {0x00, 0xB4}, {0x00, 0xB5}, {0x00, 0xB6}, {0x00, 0xB7},
    {0x00, 0xB8}, {0x00, 0xB9}, {0x00, 0xF7}, {0x00, 0xBB},
    {0x00, 0xBC}, {0x00, 0xBD}, {0x00, 0xBE}, {0x00, 0x00},
    {0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00},
    {0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00},
    {0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00},
    {0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00},
    {0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00},
    {0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00},
    {0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00},
    {0x00, 0x00}, {0x00, 0x00}, {0x00, 0x00}, {0x20, 0x17},
    {0x05, 0xD0}, {0x05, 0xD1}, {0x05, 0xD2}, {0x05, 0xD3},
    {0x05, 0xD4}, {0x05, 0xD5}, {0x05, 0xD6}, {0x05, 0xD7},
    {0x05, 0xD8}, {0x05, 0xD9}, {0x05, 0xDA}, {0x05, 0xDB},
    {0x05, 0xDC}, {0x05, 0xDD}, {0x05, 0xDE}, {0x05, 0xDF},
    {0x05, 0xE0}, {0x05, 0xE1}, {0x05, 0xE2}, {0x05, 0xE3},
    {0x05, 0xE4}, {0x05, 0xE5}, {0x05, 0xE6}, {0x05, 0xE7},
    {0x05, 0xE8}, {0x05, 0xE9}, {0x05, 0xEA}, {0x00, 0x00},
    {0x00, 0x00}, {0x20, 0x0E}, {0x20, 0x0F}, {0x00, 0x00}
};


/* ISO-8859-9  0x80-0xFF */
const unsigned char iso8859_9_unicode[ISO8859_UNICODE_TABLE_MAX][2] = {
    {0x00, 0x80}, {0x00, 0x81}, {0x00, 0x82}, {0x00, 0x83},
    {0x00, 0x84}, {0x00, 0x85}, {0x00, 0x86}, {0x00, 0x87},
    {0x00, 0x88}, {0x00, 0x89}, {0x00, 0x8A}, {0x00, 0x8B},
    {0x00, 0x8C}, {0x00, 0x8D}, {0x00, 0x8E}, {0x00, 0x8F},
    {0x00, 0x90}, {0x00, 0x91}, {0x00, 0x92}, {0x00, 0x93},
    {0x00, 0x94}, {0x00, 0x95}, {0x00, 0x96}, {0x00, 0x97},
    {0x00, 0x98}, {0x00, 0x99}, {0x00, 0x9A}, {0x00, 0x9B},
    {0x00, 0x9C}, {0x00, 0x9D}, {0x00, 0x9E}, {0x00, 0x9F},
    {0x00, 0xA0}, {0x00, 0xA1}, {0x00, 0xA2}, {0x00, 0xA3},
    {0x00, 0xA4}, {0x00, 0xA5}, {0x00, 0xA6}, {0x00, 0xA7},
    {0x00, 0xA8}, {0x00, 0xA9}, {0x00, 0xAA}, {0x00, 0xAB},
    {0x00, 0xAC}, {0x00, 0xAD}, {0x00, 0xAE}, {0x00, 0xAF},
    {0x00, 0xB0}, {0x00, 0xB1}, {0x00, 0xB2}, {0x00, 0xB3},
    {0x00, 0xB4}, {0x00, 0xB5}, {0x00, 0xB6}, {0x00, 0xB7},
    {0x00, 0xB8}, {0x00, 0xB9}, {0x00, 0xBA}, {0x00, 0xBB},
    {0x00, 0xBC}, {0x00, 0xBD}, {0x00, 0xBE}, {0x00, 0xBF},
    {0x00, 0xC0}, {0x00, 0xC1}, {0x00, 0xC2}, {0x00, 0xC3},
    {0x00, 0xC4}, {0x00, 0xC5}, {0x00, 0xC6}, {0x00, 0xC7},
    {0x00, 0xC8}, {0x00, 0xC9}, {0x00, 0xCA}, {0x00, 0xCB},
    {0x00, 0xCC}, {0x00, 0xCD}, {0x00, 0xCE}, {0x00, 0xCF},
    {0x01, 0x1E}, {0x00, 0xD1}, {0x00, 0xD2}, {0x00, 0xD3},
    {0x00, 0xD4}, {0x00, 0xD5}, {0x00, 0xD6}, {0x00, 0xD7},
    {0x00, 0xD8}, {0x00, 0xD9}, {0x00, 0xDA}, {0x00, 0xDB},
    {0x00, 0xDC}, {0x01, 0x30}, {0x01, 0x5E}, {0x00, 0xDF},
    {0x00, 0xE0}, {0x00, 0xE1}, {0x00, 0xE2}, {0x00, 0xE3},
    {0x00, 0xE4}, {0x00, 0xE5}, {0x00, 0xE6}, {0x00, 0xE7},
    {0x00, 0xE8}, {0x00, 0xE9}, {0x00, 0xEA}, {0x00, 0xEB},
    {0x00, 0xEC}, {0x00, 0xED}, {0x00, 0xEE}, {0x00, 0xEF},
    {0x01, 0x1F}, {0x00, 0xF1}, {0x00, 0xF2}, {0x00, 0xF3},
    {0x00, 0xF4}, {0x00, 0xF5}, {0x00, 0xF6}, {0x00, 0xF7},
    {0x00, 0xF8}, {0x00, 0xF9}, {0x00, 0xFA}, {0x00, 0xFB},
    {0x00, 0xFC}, {0x01, 0x31}, {0x01, 0x5F}, {0x00, 0xFF}
};


/* ISO-8859-10  0x80-0xFF */
const unsigned char iso8859_10_unicode[ISO8859_UNICODE_TABLE_MAX][2] = {
    {0x00, 0x80}, {0x00, 0x81}, {0x00, 0x82}, {0x00, 0x83},
    {0x00, 0x84}, {0x00, 0x85}, {0x00, 0x86}, {0x00, 0x87},
    {0x00, 0x88}, {0x00, 0x89}, {0x00, 0x8A}, {0x00, 0x8B},
    {0x00, 0x8C}, {0x00, 0x8D}, {0x00, 0x8E}, {0x00, 0x8F},
    {0x00, 0x90}, {0x00, 0x91}, {0x00, 0x92}, {0x00, 0x93},
    {0x00, 0x94}, {0x00, 0x95}, {0x00, 0x96}, {0x00, 0x97},
    {0x00, 0x98}, {0x00, 0x99}, {0x00, 0x9A}, {0x00, 0x9B},
    {0x00, 0x9C}, {0x00, 0x9D}, {0x00, 0x9E}, {0x00, 0x9F},
    {0x00, 0xA0}, {0x01, 0x04}, {0x01, 0x12}, {0x01, 0x22},
    {0x01, 0x2A}, {0x01, 0x28}, {0x01, 0x36}, {0x00, 0xA7},
    {0x01, 0x3B}, {0x01, 0x10}, {0x01, 0x60}, {0x01, 0x66},
    {0x01, 0x7D}, {0x00, 0xAD}, {0x01, 0x6A}, {0x01, 0x4A},
    {0x00, 0xB0}, {0x01, 0x05}, {0x01, 0x13}, {0x01, 0x23},
    {0x01, 0x2B}, {0x01, 0x29}, {0x01, 0x37}, {0x00, 0xB7},
    {0x01, 0x3C}, {0x01, 0x11}, {0x01, 0x61}, {0x01, 0x67},
    {0x01, 0x7E}, {0x20, 0x15}, {0x01, 0x6B}, {0x01, 0x4B},
    {0x01, 0x00}, {0x00, 0xC1}, {0x00, 0xC2}, {0x00, 0xC3},
    {0x00, 0xC4}, {0x00, 0xC5}, {0x00, 0xC6}, {0x01, 0x2E},
    {0x01, 0x0C}, {0x00, 0xC9}, {0x01, 0x18}, {0x00, 0xCB},
    {0x01, 0x16}, {0x00, 0xCD}, {0x00, 0xCE}, {0x00, 0xCF},
    {0x00, 0xD0}, {0x01, 0x45}, {0x01, 0x4C}, {0x00, 0xD3},
    {0x00, 0xD4}, {0x00, 0xD5}, {0x00, 0xD6}, {0x01, 0x68},
    {0x00, 0xD8}, {0x01, 0x72}, {0x00, 0xDA}, {0x00, 0xDB},
    {0x00, 0xDC}, {0x00, 0xDD}, {0x00, 0xDE}, {0x00, 0xDF},
    {0x01, 0x01}, {0x00, 0xE1}, {0x00, 0xE2}, {0x00, 0xE3},
    {0x00, 0xE4}, {0x00, 0xE5}, {0x00, 0xE6}, {0x01, 0x2F},
    {0x01, 0x0D}, {0x00, 0xE9}, {0x01, 0x19}, {0x00, 0xEB},
    {0x01, 0x17}, {0x00, 0xED}, {0x00, 0xEE}, {0x00, 0xEF},
    {0x00, 0xF0}, {0x01, 0x46}, {0x01, 0x4D}, {0x00, 0xF3},
    {0x00, 0xF4}, {0x00, 0xF5}, {0x00, 0xF6}, {0x01, 0x69},
    {0x00, 0xF8}, {0x01, 0x73}, {0x00, 0xFA}, {0x00, 0xFB},
    {0x00, 0xFC}, {0x00, 0xFD}, {0x00, 0xFE}, {0x01, 0x38}
};


/* ISO-8859-11(Windows-874)  0x80-0xFF */
const unsigned char iso8859_11_unicode[ISO8859_UNICODE_TABLE_MAX][2] = {
    {0x20, 0xAC}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F},
    {0x00, 0x3F}, {0x20, 0x26}, {0x00, 0x3F}, {0x00, 0x3F},
    {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F},
    {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F},
    {0x00, 0x3F}, {0x20, 0x18}, {0x20, 0x19}, {0x20, 0x1C},
    {0x20, 0x1D}, {0x20, 0x22}, {0x20, 0x13}, {0x20, 0x14},
    {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F},
    {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F},
    {0x00, 0xA0}, {0x0E, 0x01}, {0x0E, 0x02}, {0x0E, 0x03},
    {0x0E, 0x04}, {0x0E, 0x05}, {0x0E, 0x06}, {0x0E, 0x07},
    {0x0E, 0x08}, {0x0E, 0x09}, {0x0E, 0x0A}, {0x0E, 0x0B},
    {0x0E, 0x0C}, {0x0E, 0x0D}, {0x0E, 0x0E}, {0x0E, 0x0F},
    {0x0E, 0x10}, {0x0E, 0x11}, {0x0E, 0x12}, {0x0E, 0x13},
    {0x0E, 0x14}, {0x0E, 0x15}, {0x0E, 0x16}, {0x0E, 0x17},
    {0x0E, 0x18}, {0x0E, 0x19}, {0x0E, 0x1A}, {0x0E, 0x1B},
    {0x0E, 0x1C}, {0x0E, 0x1D}, {0x0E, 0x1E}, {0x0E, 0x1F},
    {0x0E, 0x20}, {0x0E, 0x21}, {0x0E, 0x22}, {0x0E, 0x23},
    {0x0E, 0x24}, {0x0E, 0x25}, {0x0E, 0x26}, {0x0E, 0x27},
    {0x0E, 0x28}, {0x0E, 0x29}, {0x0E, 0x2A}, {0x0E, 0x2B},
    {0x0E, 0x2C}, {0x0E, 0x2D}, {0x0E, 0x2E}, {0x0E, 0x2F},
    {0x0E, 0x30}, {0x0E, 0x31}, {0x0E, 0x32}, {0x0E, 0x33},
    {0x0E, 0x34}, {0x0E, 0x35}, {0x0E, 0x36}, {0x0E, 0x37},
    {0x0E, 0x38}, {0x0E, 0x39}, {0x0E, 0x3A}, {0x00, 0x3F},
    {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x0E, 0x3F},
    {0x0E, 0x40}, {0x0E, 0x41}, {0x0E, 0x42}, {0x0E, 0x43},
    {0x0E, 0x44}, {0x0E, 0x45}, {0x0E, 0x46}, {0x0E, 0x47},
    {0x0E, 0x48}, {0x0E, 0x49}, {0x0E, 0x4A}, {0x0E, 0x4B},
    {0x0E, 0x4C}, {0x0E, 0x4D}, {0x0E, 0x4E}, {0x0E, 0x4F},
    {0x0E, 0x50}, {0x0E, 0x51}, {0x0E, 0x52}, {0x0E, 0x53},
    {0x0E, 0x54}, {0x0E, 0x55}, {0x0E, 0x56}, {0x0E, 0x57},
    {0x0E, 0x58}, {0x0E, 0x59}, {0x0E, 0x5A}, {0x0E, 0x5B},
    {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}
};


/* ISO-8859-13  0x80-0xFF */
const unsigned char iso8859_13_unicode[ISO8859_UNICODE_TABLE_MAX][2] = {
    {0x00, 0x80}, {0x00, 0x81}, {0x00, 0x82}, {0x00, 0x83},
    {0x00, 0x84}, {0x00, 0x85}, {0x00, 0x86}, {0x00, 0x87},
    {0x00, 0x88}, {0x00, 0x89}, {0x00, 0x8A}, {0x00, 0x8B},
    {0x00, 0x8C}, {0x00, 0x8D}, {0x00, 0x8E}, {0x00, 0x8F},
    {0x00, 0x90}, {0x00, 0x91}, {0x00, 0x92}, {0x00, 0x93},
    {0x00, 0x94}, {0x00, 0x95}, {0x00, 0x96}, {0x00, 0x97},
    {0x00, 0x98}, {0x00, 0x99}, {0x00, 0x9A}, {0x00, 0x9B},
    {0x00, 0x9C}, {0x00, 0x9D}, {0x00, 0x9E}, {0x00, 0x9F},
    {0x00, 0xA0}, {0x20, 0x1D}, {0x00, 0xA2}, {0x00, 0xA3},
    {0x00, 0xA4}, {0x20, 0x1E}, {0x00, 0xA6}, {0x00, 0xA7},
    {0x00, 0xD8}, {0x00, 0xA9}, {0x01, 0x56}, {0x00, 0xAB},
    {0x00, 0xAC}, {0x00, 0xAD}, {0x00, 0xAE}, {0x00, 0xC6},
    {0x00, 0xB0}, {0x00, 0xB1}, {0x00, 0xB2}, {0x00, 0xB3},
    {0x20, 0x1C}, {0x00, 0xB5}, {0x00, 0xB6}, {0x00, 0xB7},
    {0x00, 0xF8}, {0x00, 0xB9}, {0x01, 0x57}, {0x00, 0xBB},
    {0x00, 0xBC}, {0x00, 0xBD}, {0x00, 0xBE}, {0x00, 0xE6},
    {0x01, 0x04}, {0x01, 0x2E}, {0x01, 0x00}, {0x01, 0x06},
    {0x00, 0xC4}, {0x00, 0xC5}, {0x01, 0x18}, {0x01, 0x12},
    {0x01, 0x0C}, {0x00, 0xC9}, {0x01, 0x79}, {0x01, 0x16},
    {0x01, 0x22}, {0x01, 0x36}, {0x01, 0x2A}, {0x01, 0x3B},
    {0x01, 0x60}, {0x01, 0x43}, {0x01, 0x45}, {0x00, 0xD3},
    {0x01, 0x4C}, {0x00, 0xD5}, {0x00, 0xD6}, {0x00, 0xD7},
    {0x01, 0x72}, {0x01, 0x41}, {0x01, 0x5A}, {0x01, 0x6A},
    {0x00, 0xDC}, {0x01, 0x7B}, {0x01, 0x7D}, {0x00, 0xDF},
    {0x01, 0x05}, {0x01, 0x2F}, {0x01, 0x01}, {0x01, 0x07},
    {0x00, 0xE4}, {0x00, 0xE5}, {0x01, 0x19}, {0x01, 0x13},
    {0x01, 0x0D}, {0x00, 0xE9}, {0x01, 0x7A}, {0x01, 0x17},
    {0x01, 0x23}, {0x01, 0x37}, {0x01, 0x2B}, {0x01, 0x3C},
    {0x01, 0x61}, {0x01, 0x44}, {0x01, 0x46}, {0x00, 0xF3},
    {0x01, 0x4D}, {0x00, 0xF5}, {0x00, 0xF6}, {0x00, 0xF7},
    {0x01, 0x73}, {0x01, 0x42}, {0x01, 0x5B}, {0x01, 0x6B},
    {0x00, 0xFC}, {0x01, 0x7C}, {0x01, 0x7E}, {0x20, 0x19}
};


/* ISO-8859-14  0x80-0xFF */
const unsigned char iso8859_14_unicode[ISO8859_UNICODE_TABLE_MAX][2] = {
    {0x00, 0x80}, {0x00, 0x81}, {0x00, 0x82}, {0x00, 0x83},
    {0x00, 0x84}, {0x00, 0x85}, {0x00, 0x86}, {0x00, 0x87},
    {0x00, 0x88}, {0x00, 0x89}, {0x00, 0x8A}, {0x00, 0x8B},
    {0x00, 0x8C}, {0x00, 0x8D}, {0x00, 0x8E}, {0x00, 0x8F},
    {0x00, 0x90}, {0x00, 0x91}, {0x00, 0x92}, {0x00, 0x93},
    {0x00, 0x94}, {0x00, 0x95}, {0x00, 0x96}, {0x00, 0x97},
    {0x00, 0x98}, {0x00, 0x99}, {0x00, 0x9A}, {0x00, 0x9B},
    {0x00, 0x9C}, {0x00, 0x9D}, {0x00, 0x9E}, {0x00, 0x9F},
    {0x00, 0xA0}, {0x1E, 0x02}, {0x1E, 0x03}, {0x00, 0xA3},
    {0x01, 0x0A}, {0x01, 0x0B}, {0x1E, 0x0A}, {0x00, 0xA7},
    {0x1E, 0x80}, {0x00, 0xA9}, {0x1E, 0x82}, {0x1E, 0x0B},
    {0x1E, 0xF2}, {0x00, 0xAD}, {0x00, 0xAE}, {0x01, 0x78},
    {0x1E, 0x1E}, {0x1E, 0x1F}, {0x01, 0x20}, {0x01, 0x21},
    {0x1E, 0x40}, {0x1E, 0x41}, {0x00, 0xB6}, {0x1E, 0x56},
    {0x1E, 0x81}, {0x1E, 0x57}, {0x1E, 0x83}, {0x1E, 0x60},
    {0x1E, 0xF3}, {0x1E, 0x84}, {0x1E, 0x85}, {0x1E, 0x61},
    {0x00, 0xC0}, {0x00, 0xC1}, {0x00, 0xC2}, {0x00, 0xC3},
    {0x00, 0xC4}, {0x00, 0xC5}, {0x00, 0xC6}, {0x00, 0xC7},
    {0x00, 0xC8}, {0x00, 0xC9}, {0x00, 0xCA}, {0x00, 0xCB},
    {0x00, 0xCC}, {0x00, 0xCD}, {0x00, 0xCE}, {0x00, 0xCF},
    {0x01, 0x74}, {0x00, 0xD1}, {0x00, 0xD2}, {0x00, 0xD3},
    {0x00, 0xD4}, {0x00, 0xD5}, {0x00, 0xD6}, {0x1E, 0x6A},
    {0x00, 0xD8}, {0x00, 0xD9}, {0x00, 0xDA}, {0x00, 0xDB},
    {0x00, 0xDC}, {0x00, 0xDD}, {0x01, 0x76}, {0x00, 0xDF},
    {0x00, 0xE0}, {0x00, 0xE1}, {0x00, 0xE2}, {0x00, 0xE3},
    {0x00, 0xE4}, {0x00, 0xE5}, {0x00, 0xE6}, {0x00, 0xE7},
    {0x00, 0xE8}, {0x00, 0xE9}, {0x00, 0xEA}, {0x00, 0xEB},
    {0x00, 0xEC}, {0x00, 0xED}, {0x00, 0xEE}, {0x00, 0xEF},
    {0x01, 0x75}, {0x00, 0xF1}, {0x00, 0xF2}, {0x00, 0xF3},
    {0x00, 0xF4}, {0x00, 0xF5}, {0x00, 0xF6}, {0x1E, 0x6B},
    {0x00, 0xF8}, {0x00, 0xF9}, {0x00, 0xFA}, {0x00, 0xFB},
    {0x00, 0xFC}, {0x00, 0xFD}, {0x01, 0x77}, {0x00, 0xFF}
};


/* ISO-8859-15  0x80-0xFF */
const unsigned char iso8859_15_unicode[ISO8859_UNICODE_TABLE_MAX][2] = {
    {0x00, 0x80}, {0x00, 0x81}, {0x00, 0x82}, {0x00, 0x83},
    {0x00, 0x84}, {0x00, 0x85}, {0x00, 0x86}, {0x00, 0x87},
    {0x00, 0x88}, {0x00, 0x89}, {0x00, 0x8A}, {0x00, 0x8B},
    {0x00, 0x8C}, {0x00, 0x8D}, {0x00, 0x8E}, {0x00, 0x8F},
    {0x00, 0x90}, {0x00, 0x91}, {0x00, 0x92}, {0x00, 0x93},
    {0x00, 0x94}, {0x00, 0x95}, {0x00, 0x96}, {0x00, 0x97},
    {0x00, 0x98}, {0x00, 0x99}, {0x00, 0x9A}, {0x00, 0x9B},
    {0x00, 0x9C}, {0x00, 0x9D}, {0x00, 0x9E}, {0x00, 0x9F},
    {0x00, 0xA0}, {0x00, 0xA1}, {0x00, 0xA2}, {0x00, 0xA3},
    {0x20, 0xAC}, {0x00, 0xA5}, {0x01, 0x60}, {0x00, 0xA7},
    {0x01, 0x61}, {0x00, 0xA9}, {0x00, 0xAA}, {0x00, 0xAB},
    {0x00, 0xAC}, {0x00, 0xAD}, {0x00, 0xAE}, {0x00, 0xAF},
    {0x00, 0xB0}, {0x00, 0xB1}, {0x00, 0xB2}, {0x00, 0xB3},
    {0x01, 0x7D}, {0x00, 0xB5}, {0x00, 0xB6}, {0x00, 0xB7},
    {0x01, 0x7E}, {0x00, 0xB9}, {0x00, 0xBA}, {0x00, 0xBB},
    {0x01, 0x52}, {0x01, 0x53}, {0x01, 0x78}, {0x00, 0xBF},
    {0x00, 0xC0}, {0x00, 0xC1}, {0x00, 0xC2}, {0x00, 0xC3},
    {0x00, 0xC4}, {0x00, 0xC5}, {0x00, 0xC6}, {0x00, 0xC7},
    {0x00, 0xC8}, {0x00, 0xC9}, {0x00, 0xCA}, {0x00, 0xCB},
    {0x00, 0xCC}, {0x00, 0xCD}, {0x00, 0xCE}, {0x00, 0xCF},
    {0x00, 0xD0}, {0x00, 0xD1}, {0x00, 0xD2}, {0x00, 0xD3},
    {0x00, 0xD4}, {0x00, 0xD5}, {0x00, 0xD6}, {0x00, 0xD7},
    {0x00, 0xD8}, {0x00, 0xD9}, {0x00, 0xDA}, {0x00, 0xDB},
    {0x00, 0xDC}, {0x00, 0xDD}, {0x00, 0xDE}, {0x00, 0xDF},
    {0x00, 0xE0}, {0x00, 0xE1}, {0x00, 0xE2}, {0x00, 0xE3},
    {0x00, 0xE4}, {0x00, 0xE5}, {0x00, 0xE6}, {0x00, 0xE7},
    {0x00, 0xE8}, {0x00, 0xE9}, {0x00, 0xEA}, {0x00, 0xEB},
    {0x00, 0xEC}, {0x00, 0xED}, {0x00, 0xEE}, {0x00, 0xEF},
    {0x00, 0xF0}, {0x00, 0xF1}, {0x00, 0xF2}, {0x00, 0xF3},
    {0x00, 0xF4}, {0x00, 0xF5}, {0x00, 0xF6}, {0x00, 0xF7},
    {0x00, 0xF8}, {0x00, 0xF9}, {0x00, 0xFA}, {0x00, 0xFB},
    {0x00, 0xFC}, {0x00, 0xFD}, {0x00, 0xFE}, {0x00, 0xFF}
};


/* ISO-8859-16  0x80-0xFF */
const unsigned char iso8859_16_unicode[ISO8859_UNICODE_TABLE_MAX][2] = {
    {0x00, 0x80}, {0x00, 0x81}, {0x00, 0x82}, {0x00, 0x83},
    {0x00, 0x84}, {0x00, 0x85}, {0x00, 0x86}, {0x00, 0x87},
    {0x00, 0x88}, {0x00, 0x89}, {0x00, 0x8A}, {0x00, 0x8B},
    {0x00, 0x8C}, {0x00, 0x8D}, {0x00, 0x8E}, {0x00, 0x8F},
    {0x00, 0x90}, {0x00, 0x91}, {0x00, 0x92}, {0x00, 0x93},
    {0x00, 0x94}, {0x00, 0x95}, {0x00, 0x96}, {0x00, 0x97},
    {0x00, 0x98}, {0x00, 0x99}, {0x00, 0x9A}, {0x00, 0x9B},
    {0x00, 0x9C}, {0x00, 0x9D}, {0x00, 0x9E}, {0x00, 0x9F},
    {0x00, 0xA0}, {0x01, 0x04}, {0x01, 0x05}, {0x01, 0x41},
    {0x20, 0xAC}, {0x20, 0x1E}, {0x01, 0x60}, {0x00, 0xA7},
    {0x01, 0x61}, {0x00, 0xA9}, {0x02, 0x18}, {0x00, 0xAB},
    {0x01, 0x79}, {0x00, 0xAD}, {0x01, 0x7A}, {0x01, 0x7B},
    {0x00, 0xB0}, {0x00, 0xB1}, {0x01, 0x0C}, {0x01, 0x42},
    {0x01, 0x7D}, {0x20, 0x1D}, {0x00, 0xB6}, {0x00, 0xB7},
    {0x01, 0x7E}, {0x01, 0x0D}, {0x02, 0x19}, {0x00, 0xBB},
    {0x01, 0x52}, {0x01, 0x53}, {0x01, 0x78}, {0x01, 0x7C},
    {0x00, 0xC0}, {0x00, 0xC1}, {0x00, 0xC2}, {0x01, 0x02},
    {0x00, 0xC4}, {0x01, 0x06}, {0x00, 0xC6}, {0x00, 0xC7},
    {0x00, 0xC8}, {0x00, 0xC9}, {0x00, 0xCA}, {0x00, 0xCB},
    {0x00, 0xCC}, {0x00, 0xCD}, {0x00, 0xCE}, {0x00, 0xCF},
    {0x01, 0x10}, {0x01, 0x43}, {0x00, 0xD2}, {0x00, 0xD3},
    {0x00, 0xD4}, {0x01, 0x50}, {0x00, 0xD6}, {0x01, 0x5A},
    {0x01, 0x70}, {0x00, 0xD9}, {0x00, 0xDA}, {0x00, 0xDB},
    {0x00, 0xDC}, {0x01, 0x18}, {0x02, 0x1A}, {0x00, 0xDF},
    {0x00, 0xE0}, {0x00, 0xE1}, {0x00, 0xE2}, {0x01, 0x03},
    {0x00, 0xE4}, {0x01, 0x07}, {0x00, 0xE6}, {0x00, 0xE7},
    {0x00, 0xE8}, {0x00, 0xE9}, {0x00, 0xEA}, {0x00, 0xEB},
    {0x00, 0xEC}, {0x00, 0xED}, {0x00, 0xEE}, {0x00, 0xEF},
    {0x01, 0x11}, {0x01, 0x44}, {0x00, 0xF2}, {0x00, 0xF3},
    {0x00, 0xF4}, {0x01, 0x51}, {0x00, 0xF6}, {0x01, 0x5B},
    {0x01, 0x71}, {0x00, 0xF9}, {0x00, 0xFA}, {0x00, 0xFB},
    {0x00, 0xFC}, {0x01, 0x19}, {0x02, 0x1B}, {0x00, 0xFF}
};


} // namespace apolloron
