/******************************************************************************/
/*! @file table_gb18030_utf8.cc
    @brief GB18030/UTF-8 table.
    @author Masashi Astro Tachibana, Apolloron Project.
 ******************************************************************************/

#include "table_gb18030_utf8.h"

namespace apolloron {

const T_GB18030_UTF8 gb18030_utf8[GB18030_UTF8_TABLE_MAX] ={
    {"\x81\x30\x81\x30", "\xC2\x80", 36},
    {"\x81\x30\x84\x36", "\xC2\xA5", 2},
    {"\x81\x30\x84\x38", "\xC2\xA9", 7},
    {"\x81\x30\x85\x35", "\xC2\xB2", 5},
    {"\x81\x30\x86\x30", "\xC2\xB8", 31},
    {"\x81\x30\x89\x31", "\xC3\x98", 8},
    {"\x81\x30\x89\x39", "\xC3\xA2", 6},
    {"\x81\x30\x8A\x35", "\xC3\xAB", 1},
    {"\x81\x30\x8A\x36", "\xC3\xAE", 4},
    {"\x81\x30\x8B\x30", "\xC3\xB4", 3},
    {"\x81\x30\x8B\x33", "\xC3\xB8", 1},
    {"\x81\x30\x8B\x34", "\xC3\xBB", 1},
    {"\x81\x30\x8B\x35", "\xC3\xBD", 4},
    {"\x81\x30\x8B\x39", "\xC4\x82", 17},
    {"\x81\x30\x8D\x36", "\xC4\x94", 7},
    {"\x81\x30\x8E\x33", "\xC4\x9C", 15},
    {"\x81\x30\x8F\x38", "\xC4\xAC", 24},
    {"\x81\x30\x92\x32", "\xC5\x85", 3},
    {"\x81\x30\x92\x35", "\xC5\x89", 4},
    {"\x81\x30\x92\x39", "\xC5\x8E", 29},
    {"\x81\x30\x95\x38", "\xC5\xAC", 98},
    {"\x81\x30\x9F\x36", "\xC7\x8F", 1},
    {"\x81\x30\x9F\x37", "\xC7\x91", 1},
    {"\x81\x30\x9F\x38", "\xC7\x93", 1},
    {"\x81\x30\x9F\x39", "\xC7\x95", 1},
    {"\x81\x30\xA0\x30", "\xC7\x97", 1},
    {"\x81\x30\xA0\x31", "\xC7\x99", 1},
    {"\x81\x30\xA0\x32", "\xC7\x9B", 1},
    {"\x81\x30\xA0\x33", "\xC7\x9D", 28},
    {"\x81\x30\xA3\x31", "\xC7\xBA", 87},
    {"\x81\x30\xAB\x38", "\xC9\x92", 15},
    {"\x81\x30\xAD\x33", "\xC9\xA2", 101},
    {"\x81\x30\xB7\x34", "\xCB\x88", 1},
    {"\x81\x30\xB7\x35", "\xCB\x8C", 13},
    {"\x81\x30\xB8\x38", "\xCB\x9A", 183},
    {"\x81\x30\xCB\x31", "\xCE\xA2", 1},
    {"\x81\x30\xCB\x32", "\xCE\xAA", 7},
    {"\x81\x30\xCB\x39", "\xCF\x82", 1},
    {"\x81\x30\xCC\x30", "\xCF\x8A", 55},
    {"\x81\x30\xD1\x35", "\xD0\x82", 14},
    {"\x81\x30\xD2\x39", "\xD1\x90", 1},
    {"\x81\x30\xD3\x30", "\xD1\x92", 942},
    {"\x81\x31\xB3\x32", "\xE0\xA0\x80", 2048},
    {"\x81\x33\x84\x30", "\xE1\x80\x80", 3647},
    {"\x81\x35\xF4\x37", "\xEE\x9F\x87", 1},
    {"\x81\x35\xF4\x38", "\xE1\xB9\x80", 448},
    {"\x81\x36\xA3\x36", "\xE2\x80\x80", 16},
    {"\x81\x36\xA5\x32", "\xE2\x80\x91", 2},
    {"\x81\x36\xA5\x34", "\xE2\x80\x97", 1},
    {"\x81\x36\xA5\x35", "\xE2\x80\x9A", 2},
    {"\x81\x36\xA5\x37", "\xE2\x80\x9E", 7},
    {"\x81\x36\xA6\x34", "\xE2\x80\xA7", 9},
    {"\x81\x36\xA7\x33", "\xE2\x80\xB1", 1},
    {"\x81\x36\xA7\x34", "\xE2\x80\xB4", 1},
    {"\x81\x36\xA7\x35", "\xE2\x80\xB6", 5},
    {"\x81\x36\xA8\x30", "\xE2\x80\xBC", 112},
    {"\x81\x36\xB3\x32", "\xE2\x82\xAD", 86},
    {"\x81\x36\xBB\x38", "\xE2\x84\x84", 1},
    {"\x81\x36\xBB\x39", "\xE2\x84\x86", 3},
    {"\x81\x36\xBC\x32", "\xE2\x84\x8A", 12},
    {"\x81\x36\xBD\x34", "\xE2\x84\x97", 10},
    {"\x81\x36\xBE\x34", "\xE2\x84\xA2", 62},
    {"\x81\x36\xC4\x36", "\xE2\x85\xAC", 4},
    {"\x81\x36\xC5\x30", "\xE2\x85\xBA", 22},
    {"\x81\x36\xC7\x32", "\xE2\x86\x94", 2},
    {"\x81\x36\xC7\x34", "\xE2\x86\x9A", 110},
    {"\x81\x36\xD2\x34", "\xE2\x88\x89", 6},
    {"\x81\x36\xD3\x30", "\xE2\x88\x90", 1},
    {"\x81\x36\xD3\x31", "\xE2\x88\x92", 3},
    {"\x81\x36\xD3\x34", "\xE2\x88\x96", 4},
    {"\x81\x36\xD3\x38", "\xE2\x88\x9B", 2},
    {"\x81\x36\xD4\x30", "\xE2\x88\xA1", 2},
    {"\x81\x36\xD4\x32", "\xE2\x88\xA4", 1},
    {"\x81\x36\xD4\x33", "\xE2\x88\xA6", 1},
    {"\x81\x36\xD4\x34", "\xE2\x88\xAC", 2},
    {"\x81\x36\xD4\x36", "\xE2\x88\xAF", 5},
    {"\x81\x36\xD5\x31", "\xE2\x88\xB8", 5},
    {"\x81\x36\xD5\x36", "\xE2\x88\xBE", 10},
    {"\x81\x36\xD6\x36", "\xE2\x89\x89", 3},
    {"\x81\x36\xD6\x39", "\xE2\x89\x8D", 5},
    {"\x81\x36\xD7\x34", "\xE2\x89\x93", 13},
    {"\x81\x36\xD8\x37", "\xE2\x89\xA2", 2},
    {"\x81\x36\xD8\x39", "\xE2\x89\xA8", 6},
    {"\x81\x36\xD9\x35", "\xE2\x89\xB0", 37},
    {"\x81\x36\xDD\x32", "\xE2\x8A\x96", 3},
    {"\x81\x36\xDD\x35", "\xE2\x8A\x9A", 11},
    {"\x81\x36\xDE\x36", "\xE2\x8A\xA6", 25},
    {"\x81\x36\xE1\x31", "\xE2\x8B\x80", 82},
    {"\x81\x36\xE9\x33", "\xE2\x8C\x93", 333},
    {"\x81\x37\x8C\x36", "\xE2\x91\xAA", 10},
    {"\x81\x37\x8D\x36", "\xE2\x92\x9C", 100},
    {"\x81\x37\x97\x36", "\xE2\x95\x8C", 4},
    {"\x81\x37\x98\x30", "\xE2\x95\xB4", 13},
    {"\x81\x37\x99\x33", "\xE2\x96\x90", 3},
    {"\x81\x37\x99\x36", "\xE2\x96\x96", 10},
    {"\x81\x37\x9A\x36", "\xE2\x96\xA2", 16},
    {"\x81\x37\x9C\x32", "\xE2\x96\xB4", 8},
    {"\x81\x37\x9D\x30", "\xE2\x96\xBE", 8},
    {"\x81\x37\x9D\x38", "\xE2\x97\x88", 3},
    {"\x81\x37\x9E\x31", "\xE2\x97\x8C", 2},
    {"\x81\x37\x9E\x33", "\xE2\x97\x90", 18},
    {"\x81\x37\xA0\x31", "\xE2\x97\xA6", 31},
    {"\x81\x37\xA3\x32", "\xE2\x98\x87", 2},
    {"\x81\x37\xA3\x34", "\xE2\x98\x8A", 54},
    {"\x81\x37\xA8\x38", "\xE2\x99\x81", 1},
    {"\x81\x37\xA8\x39", "\xE2\x99\x83", 2110},
    {"\x81\x38\xFD\x39", "\xE2\xBA\x82", 2},
    {"\x81\x38\xFE\x31", "\xE2\xBA\x85", 3},
    {"\x81\x38\xFE\x34", "\xE2\xBA\x89", 2},
    {"\x81\x38\xFE\x36", "\xE2\xBA\x8D", 10},
    {"\x81\x39\x81\x36", "\xE2\xBA\x98", 15},
    {"\x81\x39\x83\x31", "\xE2\xBA\xA8", 2},
    {"\x81\x39\x83\x33", "\xE2\xBA\xAB", 3},
    {"\x81\x39\x83\x36", "\xE2\xBA\xAF", 4},
    {"\x81\x39\x84\x30", "\xE2\xBA\xB4", 2},
    {"\x81\x39\x84\x32", "\xE2\xBA\xB8", 3},
    {"\x81\x39\x84\x35", "\xE2\xBA\xBC", 14},
    {"\x81\x39\x85\x39", "\xE2\xBB\x8B", 293},
    {"\x81\x39\xA3\x32", "\xE2\xBF\xBC", 4},
    {"\x81\x39\xA3\x36", "\xE3\x80\x84", 1},
    {"\x81\x39\xA3\x37", "\xE3\x80\x98", 5},
    {"\x81\x39\xA4\x32", "\xE3\x80\x9F", 2},
    {"\x81\x39\xA4\x34", "\xE3\x80\xAA", 20},
    {"\x81\x39\xA6\x34", "\xE3\x80\xBF", 2},
    {"\x81\x39\xA6\x36", "\xE3\x82\x94", 7},
    {"\x81\x39\xA7\x33", "\xE3\x82\x9F", 2},
    {"\x81\x39\xA7\x35", "\xE3\x83\xB7", 5},
    {"\x81\x39\xA8\x30", "\xE3\x83\xBF", 6},
    {"\x81\x39\xA8\x36", "\xE3\x84\xAA", 246},
    {"\x81\x39\xC1\x32", "\xE3\x88\xAA", 7},
    {"\x81\x39\xC1\x39", "\xE3\x88\xB2", 113},
    {"\x81\x39\xCD\x32", "\xE3\x8A\xA4", 234},
    {"\x81\x39\xE4\x36", "\xE3\x8E\x90", 12},
    {"\x81\x39\xE5\x38", "\xE3\x8E\x9F", 2},
    {"\x81\x39\xE6\x30", "\xE3\x8E\xA2", 34},
    {"\x81\x39\xE9\x34", "\xE3\x8F\x85", 9},
    {"\x81\x39\xEA\x33", "\xE3\x8F\x8F", 2},
    {"\x81\x39\xEA\x35", "\xE3\x8F\x93", 2},
    {"\x81\x39\xEA\x37", "\xE3\x8F\x96", 113},
    {"\x81\x39\xF6\x30", "\xE3\x91\x88", 43},
    {"\x81\x39\xFA\x33", "\xE3\x91\xB4", 298},
    {"\x82\x30\x9A\x31", "\xE3\x96\x9F", 111},
    {"\x82\x30\xA5\x32", "\xE3\x98\x8F", 11},
    {"\x82\x30\xA6\x33", "\xE3\x98\x9B", 765},
    {"\x82\x30\xF2\x38", "\xE3\xA4\x99", 85},
    {"\x82\x30\xFB\x33", "\xE3\xA5\xAF", 96},
    {"\x82\x31\x86\x39", "\xE3\xA7\x91", 14},
    {"\x82\x31\x88\x33", "\xE3\xA7\xA0", 147},
    {"\x82\x31\x97\x30", "\xE3\xA9\xB4", 218},
    {"\x82\x31\xAC\x38", "\xE3\xAD\x8F", 287},
    {"\x82\x31\xC9\x35", "\xE3\xB1\xAF", 113},
    {"\x82\x31\xD4\x38", "\xE3\xB3\xA1", 799},
    {"\x82\x32\xA6\x37", "\xE4\x80\x80", 86},
    {"\x82\x32\xAF\x33", "\xE4\x81\x97", 264},
    {"\x82\x32\xC9\x37", "\xE4\x85\xA0", 471},
    {"\x82\x32\xF8\x38", "\xE4\x8C\xB8", 116},
    {"\x82\x33\x86\x34", "\xE4\x8E\xAD", 4},
    {"\x82\x33\x86\x38", "\xE4\x8E\xB2", 43},
    {"\x82\x33\x8B\x31", "\xE4\x8F\x9E", 248},
    {"\x82\x33\xA3\x39", "\xE4\x93\x97", 373},
    {"\x82\x33\xC9\x32", "\xE4\x99\x8D", 20},
    {"\x82\x33\xCB\x32", "\xE4\x99\xA2", 193},
    {"\x82\x33\xDE\x35", "\xE4\x9C\xA4", 5},
    {"\x82\x33\xDF\x30", "\xE4\x9C\xAA", 82},
    {"\x82\x33\xE7\x32", "\xE4\x9D\xBD", 16},
    {"\x82\x33\xE8\x38", "\xE4\x9E\x8E", 441},
    {"\x82\x34\x96\x39", "\xE4\xA5\x88", 50},
    {"\x82\x34\x9B\x39", "\xE4\xA5\xBB", 2},
    {"\x82\x34\x9C\x31", "\xE4\xA5\xBE", 4},
    {"\x82\x34\x9C\x35", "\xE4\xA6\x84", 1},
    {"\x82\x34\x9C\x36", "\xE4\xA6\x87", 20},
    {"\x82\x34\x9E\x36", "\xE4\xA6\x9C", 3},
    {"\x82\x34\x9E\x39", "\xE4\xA6\xA0", 22},
    {"\x82\x34\xA1\x31", "\xE4\xA6\xB8", 703},
    {"\x82\x34\xE7\x34", "\xE4\xB1\xB8", 39},
    {"\x82\x34\xEB\x33", "\xE4\xB2\xA4", 111},
    {"\x82\x34\xF6\x34", "\xE4\xB4\x9A", 148},
    {"\x82\x35\x87\x32", "\xE4\xB6\xAF", 81},
    {"\x82\x35\x8F\x33", "\xE9\xBE\xA6", 14},
    {"\x82\x35\x91\x35", "\xE9\xBE\xBC", 68},
    {"\x82\x35\x98\x33", "\xEA\x80\x80", 4096},
    {"\x82\x38\xB7\x39", "\xEB\x80\x80", 4096},
    {"\x83\x31\xD7\x35", "\xEC\x80\x80", 4096},
    {"\x83\x34\xF7\x31", "\xED\x80\x80", 2048},
    {"\x83\x36\xC7\x39", "\xEE\x9D\xAC", 1},
    {"\x83\x36\xC8\x30", "\xEE\x9F\x88", 1},
    {"\x83\x36\xC8\x31", "\xEE\x9F\xA7", 13},
    {"\x83\x36\xC9\x34", "\xEE\xA0\x95", 1},
    {"\x83\x36\xC9\x35", "\xEE\xA0\x99", 5},
    {"\x83\x36\xCA\x30", "\xEE\xA0\x9F", 7},
    {"\x83\x36\xCA\x37", "\xEE\xA0\xA7", 4},
    {"\x83\x36\xCB\x31", "\xEE\xA0\xAD", 4},
    {"\x83\x36\xCB\x35", "\xEE\xA0\xB3", 8},
    {"\x83\x36\xCC\x33", "\xEE\xA0\xBC", 7},
    {"\x83\x36\xCD\x30", "\xEE\xA1\x84", 16},
    {"\x83\x36\xCE\x36", "\xEE\xA1\x96", 14},
    {"\x83\x36\xD0\x30", "\xEE\xA1\xA5", 1947},
    {"\x83\x38\x96\x37", "\xEF\x80\x80", 2348},
    {"\x84\x30\x85\x35", "\xEF\xA4\xAD", 76},
    {"\x84\x30\x8D\x31", "\xEF\xA5\xBA", 27},
    {"\x84\x30\x8F\x38", "\xEF\xA6\x96", 81},
    {"\x84\x30\x97\x39", "\xEF\xA7\xA8", 9},
    {"\x84\x30\x98\x38", "\xEF\xA7\xB2", 26},
    {"\x84\x30\x9B\x34", "\xEF\xA8\x90", 1},
    {"\x84\x30\x9B\x35", "\xEF\xA8\x92", 1},
    {"\x84\x30\x9B\x36", "\xEF\xA8\x95", 3},
    {"\x84\x30\x9B\x39", "\xEF\xA8\x99", 6},
    {"\x84\x30\x9C\x35", "\xEF\xA8\xA2", 1},
    {"\x84\x30\x9C\x36", "\xEF\xA8\xA5", 2},
    {"\x84\x30\x9C\x38", "\xEF\xA8\xAA", 998},
    {"\x84\x31\x83\x36", "\xEF\xB8\x9A", 22},
    {"\x84\x31\x85\x38", "\xEF\xB8\xB2", 1},
    {"\x84\x31\x85\x39", "\xEF\xB9\x85", 4},
    {"\x84\x31\x86\x33", "\xEF\xB9\x93", 1},
    {"\x84\x31\x86\x34", "\xEF\xB9\x98", 1},
    {"\x84\x31\x86\x35", "\xEF\xB9\xA7", 1},
    {"\x84\x31\x86\x36", "\xEF\xB9\xAC", 149},
    {"\x84\x31\x95\x35", "\xEF\xBD\x9F", 129},
    {"\x84\x31\xA2\x34", "\xEF\xBF\xA6", 26},
    {"\x90\x30\x81\x30", "\xF0\x90\x80\x80", 65671},
    {"\x95\x32\x90\x32", "\xF0\xA0\x82\x88", 1},
    {"\x95\x32\x90\x34", "\xF0\xA0\x82\x8A", 66},
    {"\x95\x32\x97\x31", "\xF0\xA0\x83\x8D", 5386},
    {"\x95\x36\xB9\x38", "\xF0\xA1\x97\x98", 5047},
    {"\x96\x30\xBA\x36", "\xF0\xA2\xA6\x90", 6254},
    {"\x96\x35\xB6\x31", "\xF0\xA4\x87\xBF", 114177},
    {"\x9F\x36\x85\x38", "\xF1\x80\x80\x80", 262144},
    {"\xB4\x34\x8C\x32", "\xF2\x80\x80\x80", 262144},
    {"\xC9\x32\x92\x36", "\xF3\x80\x80\x80", 262144},
    {"\xDE\x30\x99\x30", "\xF4\x80\x80\x80", 65536},
    {"\xFE\x39\xFE\x39", "\xF7\xBF\xBF\xBF", 1}
};

} // namespace apolloron
