/******************************************************************************/
/*! @file table_sjis_unicode.cc
    @brief SHIFT_JIS/UCS-2 table.
    @author Masashi Astro Tachibana, Apolloron Project.
 ******************************************************************************/

#include "table_sjis_unicode.h"

namespace apolloron {

const short int index_sjis_unicode[256] = {
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, /* 0x00-0x07 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, /* 0x08-0x0F */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, /* 0x10-0x17 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, /* 0x18-0x1F */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, /* 0x20-0x27 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, /* 0x28-0x2F */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, /* 0x30-0x37 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, /* 0x38-0x3F */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, /* 0x40-0x47 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, /* 0x48-0x4F */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, /* 0x50-0x57 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, /* 0x58-0x5F */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, /* 0x60-0x67 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, /* 0x68-0x6F */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, /* 0x70-0x77 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, /* 0x78-0x7F */
    -1,    0,  147,  292,  426,   -1,   -1,  524, /* 0x80-0x87 */
    598, 692,  880, 1068, 1256, 1444, 1632, 1820, /* 0x88-0x8F */
    2008, 2196, 2384, 2572, 2760, 2948, 3136, 3324, /* 0x90-0x97 */
    3512, 3657, 3845, 4033, 4221, 4409, 4597, 4785, /* 0x98-0x9F */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, /* 0xA0-0xA7 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, /* 0xA8-0xAF */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, /* 0xB0-0xB7 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, /* 0xB8-0xBF */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, /* 0xC0-0xC7 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, /* 0xC8-0xCF */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, /* 0xD0-0xD7 */
    -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, /* 0xD8-0xDF */
    4973, 5161, 5349, 5537, 5725, 5913, 6101, 6289, /* 0xE0-0xE7 */
    6477, 6665, 6853, -1,   -1,   -1,   -1,   -1, /* 0xE8-0xEF */
    6953, 7141, 7329, 7517, 7705, 7893, 8081, 8269, /* 0xF0-0xF7 */
    8457, 8645, 8833, 9006, 9194, -1,   -1,   -1 /* 0xF8-0xFF */
};

const unsigned char sjis_unicode[SJIS_UNICODE_TABLE_MAX][3] = {
    /* (SJIS1) SJIS2, UNICODE1, UNICODE2 */
    /* 0x81 */ {0x40, 0x30, 0x00},
    /* 0x81 */ {0x41, 0x30, 0x01},
    /* 0x81 */ {0x42, 0x30, 0x02},
    /* 0x81 */ {0x43, 0xFF, 0x0C},
    /* 0x81 */ {0x44, 0xFF, 0x0E},
    /* 0x81 */ {0x45, 0x30, 0xFB},
    /* 0x81 */ {0x46, 0xFF, 0x1A},
    /* 0x81 */ {0x47, 0xFF, 0x1B},
    /* 0x81 */ {0x48, 0xFF, 0x1F},
    /* 0x81 */ {0x49, 0xFF, 0x01},
    /* 0x81 */ {0x4A, 0x30, 0x9B},
    /* 0x81 */ {0x4B, 0x30, 0x9C},
    /* 0x81 */ {0x4C, 0x00, 0xB4},
    /* 0x81 */ {0x4D, 0xFF, 0x40},
    /* 0x81 */ {0x4E, 0x00, 0xA8},
    /* 0x81 */ {0x4F, 0xFF, 0x3E},
    /* 0x81 */ {0x50, 0xFF, 0xE3},
    /* 0x81 */ {0x51, 0xFF, 0x3F},
    /* 0x81 */ {0x52, 0x30, 0xFD},
    /* 0x81 */ {0x53, 0x30, 0xFE},
    /* 0x81 */ {0x54, 0x30, 0x9D},
    /* 0x81 */ {0x55, 0x30, 0x9E},
    /* 0x81 */ {0x56, 0x30, 0x03},
    /* 0x81 */ {0x57, 0x4E, 0xDD},
    /* 0x81 */ {0x58, 0x30, 0x05},
    /* 0x81 */ {0x59, 0x30, 0x06},
    /* 0x81 */ {0x5A, 0x30, 0x07},
    /* 0x81 */ {0x5B, 0x30, 0xFC},
    /* 0x81 */ {0x5C, 0x20, 0x15},
    /* 0x81 */ {0x5D, 0x20, 0x10},
    /* 0x81 */ {0x5E, 0xFF, 0x0F},
    /* 0x81 */ {0x5F, 0xFF, 0x3C},
    /* 0x81 */ {0x60, 0xFF, 0x5E},
    /* 0x81 */ {0x61, 0x22, 0x25},
    /* 0x81 */ {0x62, 0xFF, 0x5C},
    /* 0x81 */ {0x63, 0x20, 0x26},
    /* 0x81 */ {0x64, 0x20, 0x25},
    /* 0x81 */ {0x65, 0x20, 0x18},
    /* 0x81 */ {0x66, 0x20, 0x19},
    /* 0x81 */ {0x67, 0x20, 0x1C},
    /* 0x81 */ {0x68, 0x20, 0x1D},
    /* 0x81 */ {0x69, 0xFF, 0x08},
    /* 0x81 */ {0x6A, 0xFF, 0x09},
    /* 0x81 */ {0x6B, 0x30, 0x14},
    /* 0x81 */ {0x6C, 0x30, 0x15},
    /* 0x81 */ {0x6D, 0xFF, 0x3B},
    /* 0x81 */ {0x6E, 0xFF, 0x3D},
    /* 0x81 */ {0x6F, 0xFF, 0x5B},
    /* 0x81 */ {0x70, 0xFF, 0x5D},
    /* 0x81 */ {0x71, 0x30, 0x08},
    /* 0x81 */ {0x72, 0x30, 0x09},
    /* 0x81 */ {0x73, 0x30, 0x0A},
    /* 0x81 */ {0x74, 0x30, 0x0B},
    /* 0x81 */ {0x75, 0x30, 0x0C},
    /* 0x81 */ {0x76, 0x30, 0x0D},
    /* 0x81 */ {0x77, 0x30, 0x0E},
    /* 0x81 */ {0x78, 0x30, 0x0F},
    /* 0x81 */ {0x79, 0x30, 0x10},
    /* 0x81 */ {0x7A, 0x30, 0x11},
    /* 0x81 */ {0x7B, 0xFF, 0x0B},
    /* 0x81 */ {0x7C, 0xFF, 0x0D},
    /* 0x81 */ {0x7D, 0x00, 0xB1},
    /* 0x81 */ {0x7E, 0x00, 0xD7},
    /* 0x81 */ {0x80, 0x00, 0xF7},
    /* 0x81 */ {0x81, 0xFF, 0x1D},
    /* 0x81 */ {0x82, 0x22, 0x60},
    /* 0x81 */ {0x83, 0xFF, 0x1C},
    /* 0x81 */ {0x84, 0xFF, 0x1E},
    /* 0x81 */ {0x85, 0x22, 0x66},
    /* 0x81 */ {0x86, 0x22, 0x67},
    /* 0x81 */ {0x87, 0x22, 0x1E},
    /* 0x81 */ {0x88, 0x22, 0x34},
    /* 0x81 */ {0x89, 0x26, 0x42},
    /* 0x81 */ {0x8A, 0x26, 0x40},
    /* 0x81 */ {0x8B, 0x00, 0xB0},
    /* 0x81 */ {0x8C, 0x20, 0x32},
    /* 0x81 */ {0x8D, 0x20, 0x33},
    /* 0x81 */ {0x8E, 0x21, 0x03},
    /* 0x81 */ {0x8F, 0xFF, 0xE5},
    /* 0x81 */ {0x90, 0xFF, 0x04},
    /* 0x81 */ {0x91, 0xFF, 0xE0},
    /* 0x81 */ {0x92, 0xFF, 0xE1},
    /* 0x81 */ {0x93, 0xFF, 0x05},
    /* 0x81 */ {0x94, 0xFF, 0x03},
    /* 0x81 */ {0x95, 0xFF, 0x06},
    /* 0x81 */ {0x96, 0xFF, 0x0A},
    /* 0x81 */ {0x97, 0xFF, 0x20},
    /* 0x81 */ {0x98, 0x00, 0xA7},
    /* 0x81 */ {0x99, 0x26, 0x06},
    /* 0x81 */ {0x9A, 0x26, 0x05},
    /* 0x81 */ {0x9B, 0x25, 0xCB},
    /* 0x81 */ {0x9C, 0x25, 0xCF},
    /* 0x81 */ {0x9D, 0x25, 0xCE},
    /* 0x81 */ {0x9E, 0x25, 0xC7},
    /* 0x81 */ {0x9F, 0x25, 0xC6},
    /* 0x81 */ {0xA0, 0x25, 0xA1},
    /* 0x81 */ {0xA1, 0x25, 0xA0},
    /* 0x81 */ {0xA2, 0x25, 0xB3},
    /* 0x81 */ {0xA3, 0x25, 0xB2},
    /* 0x81 */ {0xA4, 0x25, 0xBD},
    /* 0x81 */ {0xA5, 0x25, 0xBC},
    /* 0x81 */ {0xA6, 0x20, 0x3B},
    /* 0x81 */ {0xA7, 0x30, 0x12},
    /* 0x81 */ {0xA8, 0x21, 0x92},
    /* 0x81 */ {0xA9, 0x21, 0x90},
    /* 0x81 */ {0xAA, 0x21, 0x91},
    /* 0x81 */ {0xAB, 0x21, 0x93},
    /* 0x81 */ {0xAC, 0x30, 0x13},
    /* 0x81 */ {0xB8, 0x22, 0x08},
    /* 0x81 */ {0xB9, 0x22, 0x0B},
    /* 0x81 */ {0xBA, 0x22, 0x86},
    /* 0x81 */ {0xBB, 0x22, 0x87},
    /* 0x81 */ {0xBC, 0x22, 0x82},
    /* 0x81 */ {0xBD, 0x22, 0x83},
    /* 0x81 */ {0xBE, 0x22, 0x2A},
    /* 0x81 */ {0xBF, 0x22, 0x29},
    /* 0x81 */ {0xC8, 0x22, 0x27},
    /* 0x81 */ {0xC9, 0x22, 0x28},
    /* 0x81 */ {0xCA, 0xFF, 0xE2},
    /* 0x81 */ {0xCB, 0x21, 0xD2},
    /* 0x81 */ {0xCC, 0x21, 0xD4},
    /* 0x81 */ {0xCD, 0x22, 0x00},
    /* 0x81 */ {0xCE, 0x22, 0x03},
    /* 0x81 */ {0xDA, 0x22, 0x20},
    /* 0x81 */ {0xDB, 0x22, 0xA5},
    /* 0x81 */ {0xDC, 0x23, 0x12},
    /* 0x81 */ {0xDD, 0x22, 0x02},
    /* 0x81 */ {0xDE, 0x22, 0x07},
    /* 0x81 */ {0xDF, 0x22, 0x61},
    /* 0x81 */ {0xE0, 0x22, 0x52},
    /* 0x81 */ {0xE1, 0x22, 0x6A},
    /* 0x81 */ {0xE2, 0x22, 0x6B},
    /* 0x81 */ {0xE3, 0x22, 0x1A},
    /* 0x81 */ {0xE4, 0x22, 0x3D},
    /* 0x81 */ {0xE5, 0x22, 0x1D},
    /* 0x81 */ {0xE6, 0x22, 0x35},
    /* 0x81 */ {0xE7, 0x22, 0x2B},
    /* 0x81 */ {0xE8, 0x22, 0x2C},
    /* 0x81 */ {0xF0, 0x21, 0x2B},
    /* 0x81 */ {0xF1, 0x20, 0x30},
    /* 0x81 */ {0xF2, 0x26, 0x6F},
    /* 0x81 */ {0xF3, 0x26, 0x6D},
    /* 0x81 */ {0xF4, 0x26, 0x6A},
    /* 0x81 */ {0xF5, 0x20, 0x20},
    /* 0x81 */ {0xF6, 0x20, 0x21},
    /* 0x81 */ {0xF7, 0x00, 0xB6},
    /* 0x81 */ {0xFC, 0x25, 0xEF},
    /* 0x82 */ {0x4F, 0xFF, 0x10},
    /* 0x82 */ {0x50, 0xFF, 0x11},
    /* 0x82 */ {0x51, 0xFF, 0x12},
    /* 0x82 */ {0x52, 0xFF, 0x13},
    /* 0x82 */ {0x53, 0xFF, 0x14},
    /* 0x82 */ {0x54, 0xFF, 0x15},
    /* 0x82 */ {0x55, 0xFF, 0x16},
    /* 0x82 */ {0x56, 0xFF, 0x17},
    /* 0x82 */ {0x57, 0xFF, 0x18},
    /* 0x82 */ {0x58, 0xFF, 0x19},
    /* 0x82 */ {0x60, 0xFF, 0x21},
    /* 0x82 */ {0x61, 0xFF, 0x22},
    /* 0x82 */ {0x62, 0xFF, 0x23},
    /* 0x82 */ {0x63, 0xFF, 0x24},
    /* 0x82 */ {0x64, 0xFF, 0x25},
    /* 0x82 */ {0x65, 0xFF, 0x26},
    /* 0x82 */ {0x66, 0xFF, 0x27},
    /* 0x82 */ {0x67, 0xFF, 0x28},
    /* 0x82 */ {0x68, 0xFF, 0x29},
    /* 0x82 */ {0x69, 0xFF, 0x2A},
    /* 0x82 */ {0x6A, 0xFF, 0x2B},
    /* 0x82 */ {0x6B, 0xFF, 0x2C},
    /* 0x82 */ {0x6C, 0xFF, 0x2D},
    /* 0x82 */ {0x6D, 0xFF, 0x2E},
    /* 0x82 */ {0x6E, 0xFF, 0x2F},
    /* 0x82 */ {0x6F, 0xFF, 0x30},
    /* 0x82 */ {0x70, 0xFF, 0x31},
    /* 0x82 */ {0x71, 0xFF, 0x32},
    /* 0x82 */ {0x72, 0xFF, 0x33},
    /* 0x82 */ {0x73, 0xFF, 0x34},
    /* 0x82 */ {0x74, 0xFF, 0x35},
    /* 0x82 */ {0x75, 0xFF, 0x36},
    /* 0x82 */ {0x76, 0xFF, 0x37},
    /* 0x82 */ {0x77, 0xFF, 0x38},
    /* 0x82 */ {0x78, 0xFF, 0x39},
    /* 0x82 */ {0x79, 0xFF, 0x3A},
    /* 0x82 */ {0x81, 0xFF, 0x41},
    /* 0x82 */ {0x82, 0xFF, 0x42},
    /* 0x82 */ {0x83, 0xFF, 0x43},
    /* 0x82 */ {0x84, 0xFF, 0x44},
    /* 0x82 */ {0x85, 0xFF, 0x45},
    /* 0x82 */ {0x86, 0xFF, 0x46},
    /* 0x82 */ {0x87, 0xFF, 0x47},
    /* 0x82 */ {0x88, 0xFF, 0x48},
    /* 0x82 */ {0x89, 0xFF, 0x49},
    /* 0x82 */ {0x8A, 0xFF, 0x4A},
    /* 0x82 */ {0x8B, 0xFF, 0x4B},
    /* 0x82 */ {0x8C, 0xFF, 0x4C},
    /* 0x82 */ {0x8D, 0xFF, 0x4D},
    /* 0x82 */ {0x8E, 0xFF, 0x4E},
    /* 0x82 */ {0x8F, 0xFF, 0x4F},
    /* 0x82 */ {0x90, 0xFF, 0x50},
    /* 0x82 */ {0x91, 0xFF, 0x51},
    /* 0x82 */ {0x92, 0xFF, 0x52},
    /* 0x82 */ {0x93, 0xFF, 0x53},
    /* 0x82 */ {0x94, 0xFF, 0x54},
    /* 0x82 */ {0x95, 0xFF, 0x55},
    /* 0x82 */ {0x96, 0xFF, 0x56},
    /* 0x82 */ {0x97, 0xFF, 0x57},
    /* 0x82 */ {0x98, 0xFF, 0x58},
    /* 0x82 */ {0x99, 0xFF, 0x59},
    /* 0x82 */ {0x9A, 0xFF, 0x5A},
    /* 0x82 */ {0x9F, 0x30, 0x41},
    /* 0x82 */ {0xA0, 0x30, 0x42},
    /* 0x82 */ {0xA1, 0x30, 0x43},
    /* 0x82 */ {0xA2, 0x30, 0x44},
    /* 0x82 */ {0xA3, 0x30, 0x45},
    /* 0x82 */ {0xA4, 0x30, 0x46},
    /* 0x82 */ {0xA5, 0x30, 0x47},
    /* 0x82 */ {0xA6, 0x30, 0x48},
    /* 0x82 */ {0xA7, 0x30, 0x49},
    /* 0x82 */ {0xA8, 0x30, 0x4A},
    /* 0x82 */ {0xA9, 0x30, 0x4B},
    /* 0x82 */ {0xAA, 0x30, 0x4C},
    /* 0x82 */ {0xAB, 0x30, 0x4D},
    /* 0x82 */ {0xAC, 0x30, 0x4E},
    /* 0x82 */ {0xAD, 0x30, 0x4F},
    /* 0x82 */ {0xAE, 0x30, 0x50},
    /* 0x82 */ {0xAF, 0x30, 0x51},
    /* 0x82 */ {0xB0, 0x30, 0x52},
    /* 0x82 */ {0xB1, 0x30, 0x53},
    /* 0x82 */ {0xB2, 0x30, 0x54},
    /* 0x82 */ {0xB3, 0x30, 0x55},
    /* 0x82 */ {0xB4, 0x30, 0x56},
    /* 0x82 */ {0xB5, 0x30, 0x57},
    /* 0x82 */ {0xB6, 0x30, 0x58},
    /* 0x82 */ {0xB7, 0x30, 0x59},
    /* 0x82 */ {0xB8, 0x30, 0x5A},
    /* 0x82 */ {0xB9, 0x30, 0x5B},
    /* 0x82 */ {0xBA, 0x30, 0x5C},
    /* 0x82 */ {0xBB, 0x30, 0x5D},
    /* 0x82 */ {0xBC, 0x30, 0x5E},
    /* 0x82 */ {0xBD, 0x30, 0x5F},
    /* 0x82 */ {0xBE, 0x30, 0x60},
    /* 0x82 */ {0xBF, 0x30, 0x61},
    /* 0x82 */ {0xC0, 0x30, 0x62},
    /* 0x82 */ {0xC1, 0x30, 0x63},
    /* 0x82 */ {0xC2, 0x30, 0x64},
    /* 0x82 */ {0xC3, 0x30, 0x65},
    /* 0x82 */ {0xC4, 0x30, 0x66},
    /* 0x82 */ {0xC5, 0x30, 0x67},
    /* 0x82 */ {0xC6, 0x30, 0x68},
    /* 0x82 */ {0xC7, 0x30, 0x69},
    /* 0x82 */ {0xC8, 0x30, 0x6A},
    /* 0x82 */ {0xC9, 0x30, 0x6B},
    /* 0x82 */ {0xCA, 0x30, 0x6C},
    /* 0x82 */ {0xCB, 0x30, 0x6D},
    /* 0x82 */ {0xCC, 0x30, 0x6E},
    /* 0x82 */ {0xCD, 0x30, 0x6F},
    /* 0x82 */ {0xCE, 0x30, 0x70},
    /* 0x82 */ {0xCF, 0x30, 0x71},
    /* 0x82 */ {0xD0, 0x30, 0x72},
    /* 0x82 */ {0xD1, 0x30, 0x73},
    /* 0x82 */ {0xD2, 0x30, 0x74},
    /* 0x82 */ {0xD3, 0x30, 0x75},
    /* 0x82 */ {0xD4, 0x30, 0x76},
    /* 0x82 */ {0xD5, 0x30, 0x77},
    /* 0x82 */ {0xD6, 0x30, 0x78},
    /* 0x82 */ {0xD7, 0x30, 0x79},
    /* 0x82 */ {0xD8, 0x30, 0x7A},
    /* 0x82 */ {0xD9, 0x30, 0x7B},
    /* 0x82 */ {0xDA, 0x30, 0x7C},
    /* 0x82 */ {0xDB, 0x30, 0x7D},
    /* 0x82 */ {0xDC, 0x30, 0x7E},
    /* 0x82 */ {0xDD, 0x30, 0x7F},
    /* 0x82 */ {0xDE, 0x30, 0x80},
    /* 0x82 */ {0xDF, 0x30, 0x81},
    /* 0x82 */ {0xE0, 0x30, 0x82},
    /* 0x82 */ {0xE1, 0x30, 0x83},
    /* 0x82 */ {0xE2, 0x30, 0x84},
    /* 0x82 */ {0xE3, 0x30, 0x85},
    /* 0x82 */ {0xE4, 0x30, 0x86},
    /* 0x82 */ {0xE5, 0x30, 0x87},
    /* 0x82 */ {0xE6, 0x30, 0x88},
    /* 0x82 */ {0xE7, 0x30, 0x89},
    /* 0x82 */ {0xE8, 0x30, 0x8A},
    /* 0x82 */ {0xE9, 0x30, 0x8B},
    /* 0x82 */ {0xEA, 0x30, 0x8C},
    /* 0x82 */ {0xEB, 0x30, 0x8D},
    /* 0x82 */ {0xEC, 0x30, 0x8E},
    /* 0x82 */ {0xED, 0x30, 0x8F},
    /* 0x82 */ {0xEE, 0x30, 0x90},
    /* 0x82 */ {0xEF, 0x30, 0x91},
    /* 0x82 */ {0xF0, 0x30, 0x92},
    /* 0x82 */ {0xF1, 0x30, 0x93},
    /* 0x83 */ {0x40, 0x30, 0xA1},
    /* 0x83 */ {0x41, 0x30, 0xA2},
    /* 0x83 */ {0x42, 0x30, 0xA3},
    /* 0x83 */ {0x43, 0x30, 0xA4},
    /* 0x83 */ {0x44, 0x30, 0xA5},
    /* 0x83 */ {0x45, 0x30, 0xA6},
    /* 0x83 */ {0x46, 0x30, 0xA7},
    /* 0x83 */ {0x47, 0x30, 0xA8},
    /* 0x83 */ {0x48, 0x30, 0xA9},
    /* 0x83 */ {0x49, 0x30, 0xAA},
    /* 0x83 */ {0x4A, 0x30, 0xAB},
    /* 0x83 */ {0x4B, 0x30, 0xAC},
    /* 0x83 */ {0x4C, 0x30, 0xAD},
    /* 0x83 */ {0x4D, 0x30, 0xAE},
    /* 0x83 */ {0x4E, 0x30, 0xAF},
    /* 0x83 */ {0x4F, 0x30, 0xB0},
    /* 0x83 */ {0x50, 0x30, 0xB1},
    /* 0x83 */ {0x51, 0x30, 0xB2},
    /* 0x83 */ {0x52, 0x30, 0xB3},
    /* 0x83 */ {0x53, 0x30, 0xB4},
    /* 0x83 */ {0x54, 0x30, 0xB5},
    /* 0x83 */ {0x55, 0x30, 0xB6},
    /* 0x83 */ {0x56, 0x30, 0xB7},
    /* 0x83 */ {0x57, 0x30, 0xB8},
    /* 0x83 */ {0x58, 0x30, 0xB9},
    /* 0x83 */ {0x59, 0x30, 0xBA},
    /* 0x83 */ {0x5A, 0x30, 0xBB},
    /* 0x83 */ {0x5B, 0x30, 0xBC},
    /* 0x83 */ {0x5C, 0x30, 0xBD},
    /* 0x83 */ {0x5D, 0x30, 0xBE},
    /* 0x83 */ {0x5E, 0x30, 0xBF},
    /* 0x83 */ {0x5F, 0x30, 0xC0},
    /* 0x83 */ {0x60, 0x30, 0xC1},
    /* 0x83 */ {0x61, 0x30, 0xC2},
    /* 0x83 */ {0x62, 0x30, 0xC3},
    /* 0x83 */ {0x63, 0x30, 0xC4},
    /* 0x83 */ {0x64, 0x30, 0xC5},
    /* 0x83 */ {0x65, 0x30, 0xC6},
    /* 0x83 */ {0x66, 0x30, 0xC7},
    /* 0x83 */ {0x67, 0x30, 0xC8},
    /* 0x83 */ {0x68, 0x30, 0xC9},
    /* 0x83 */ {0x69, 0x30, 0xCA},
    /* 0x83 */ {0x6A, 0x30, 0xCB},
    /* 0x83 */ {0x6B, 0x30, 0xCC},
    /* 0x83 */ {0x6C, 0x30, 0xCD},
    /* 0x83 */ {0x6D, 0x30, 0xCE},
    /* 0x83 */ {0x6E, 0x30, 0xCF},
    /* 0x83 */ {0x6F, 0x30, 0xD0},
    /* 0x83 */ {0x70, 0x30, 0xD1},
    /* 0x83 */ {0x71, 0x30, 0xD2},
    /* 0x83 */ {0x72, 0x30, 0xD3},
    /* 0x83 */ {0x73, 0x30, 0xD4},
    /* 0x83 */ {0x74, 0x30, 0xD5},
    /* 0x83 */ {0x75, 0x30, 0xD6},
    /* 0x83 */ {0x76, 0x30, 0xD7},
    /* 0x83 */ {0x77, 0x30, 0xD8},
    /* 0x83 */ {0x78, 0x30, 0xD9},
    /* 0x83 */ {0x79, 0x30, 0xDA},
    /* 0x83 */ {0x7A, 0x30, 0xDB},
    /* 0x83 */ {0x7B, 0x30, 0xDC},
    /* 0x83 */ {0x7C, 0x30, 0xDD},
    /* 0x83 */ {0x7D, 0x30, 0xDE},
    /* 0x83 */ {0x7E, 0x30, 0xDF},
    /* 0x83 */ {0x80, 0x30, 0xE0},
    /* 0x83 */ {0x81, 0x30, 0xE1},
    /* 0x83 */ {0x82, 0x30, 0xE2},
    /* 0x83 */ {0x83, 0x30, 0xE3},
    /* 0x83 */ {0x84, 0x30, 0xE4},
    /* 0x83 */ {0x85, 0x30, 0xE5},
    /* 0x83 */ {0x86, 0x30, 0xE6},
    /* 0x83 */ {0x87, 0x30, 0xE7},
    /* 0x83 */ {0x88, 0x30, 0xE8},
    /* 0x83 */ {0x89, 0x30, 0xE9},
    /* 0x83 */ {0x8A, 0x30, 0xEA},
    /* 0x83 */ {0x8B, 0x30, 0xEB},
    /* 0x83 */ {0x8C, 0x30, 0xEC},
    /* 0x83 */ {0x8D, 0x30, 0xED},
    /* 0x83 */ {0x8E, 0x30, 0xEE},
    /* 0x83 */ {0x8F, 0x30, 0xEF},
    /* 0x83 */ {0x90, 0x30, 0xF0},
    /* 0x83 */ {0x91, 0x30, 0xF1},
    /* 0x83 */ {0x92, 0x30, 0xF2},
    /* 0x83 */ {0x93, 0x30, 0xF3},
    /* 0x83 */ {0x94, 0x30, 0xF4},
    /* 0x83 */ {0x95, 0x30, 0xF5},
    /* 0x83 */ {0x96, 0x30, 0xF6},
    /* 0x83 */ {0x9F, 0x03, 0x91},
    /* 0x83 */ {0xA0, 0x03, 0x92},
    /* 0x83 */ {0xA1, 0x03, 0x93},
    /* 0x83 */ {0xA2, 0x03, 0x94},
    /* 0x83 */ {0xA3, 0x03, 0x95},
    /* 0x83 */ {0xA4, 0x03, 0x96},
    /* 0x83 */ {0xA5, 0x03, 0x97},
    /* 0x83 */ {0xA6, 0x03, 0x98},
    /* 0x83 */ {0xA7, 0x03, 0x99},
    /* 0x83 */ {0xA8, 0x03, 0x9A},
    /* 0x83 */ {0xA9, 0x03, 0x9B},
    /* 0x83 */ {0xAA, 0x03, 0x9C},
    /* 0x83 */ {0xAB, 0x03, 0x9D},
    /* 0x83 */ {0xAC, 0x03, 0x9E},
    /* 0x83 */ {0xAD, 0x03, 0x9F},
    /* 0x83 */ {0xAE, 0x03, 0xA0},
    /* 0x83 */ {0xAF, 0x03, 0xA1},
    /* 0x83 */ {0xB0, 0x03, 0xA3},
    /* 0x83 */ {0xB1, 0x03, 0xA4},
    /* 0x83 */ {0xB2, 0x03, 0xA5},
    /* 0x83 */ {0xB3, 0x03, 0xA6},
    /* 0x83 */ {0xB4, 0x03, 0xA7},
    /* 0x83 */ {0xB5, 0x03, 0xA8},
    /* 0x83 */ {0xB6, 0x03, 0xA9},
    /* 0x83 */ {0xBF, 0x03, 0xB1},
    /* 0x83 */ {0xC0, 0x03, 0xB2},
    /* 0x83 */ {0xC1, 0x03, 0xB3},
    /* 0x83 */ {0xC2, 0x03, 0xB4},
    /* 0x83 */ {0xC3, 0x03, 0xB5},
    /* 0x83 */ {0xC4, 0x03, 0xB6},
    /* 0x83 */ {0xC5, 0x03, 0xB7},
    /* 0x83 */ {0xC6, 0x03, 0xB8},
    /* 0x83 */ {0xC7, 0x03, 0xB9},
    /* 0x83 */ {0xC8, 0x03, 0xBA},
    /* 0x83 */ {0xC9, 0x03, 0xBB},
    /* 0x83 */ {0xCA, 0x03, 0xBC},
    /* 0x83 */ {0xCB, 0x03, 0xBD},
    /* 0x83 */ {0xCC, 0x03, 0xBE},
    /* 0x83 */ {0xCD, 0x03, 0xBF},
    /* 0x83 */ {0xCE, 0x03, 0xC0},
    /* 0x83 */ {0xCF, 0x03, 0xC1},
    /* 0x83 */ {0xD0, 0x03, 0xC3},
    /* 0x83 */ {0xD1, 0x03, 0xC4},
    /* 0x83 */ {0xD2, 0x03, 0xC5},
    /* 0x83 */ {0xD3, 0x03, 0xC6},
    /* 0x83 */ {0xD4, 0x03, 0xC7},
    /* 0x83 */ {0xD5, 0x03, 0xC8},
    /* 0x83 */ {0xD6, 0x03, 0xC9},
    /* 0x84 */ {0x40, 0x04, 0x10},
    /* 0x84 */ {0x41, 0x04, 0x11},
    /* 0x84 */ {0x42, 0x04, 0x12},
    /* 0x84 */ {0x43, 0x04, 0x13},
    /* 0x84 */ {0x44, 0x04, 0x14},
    /* 0x84 */ {0x45, 0x04, 0x15},
    /* 0x84 */ {0x46, 0x04, 0x01},
    /* 0x84 */ {0x47, 0x04, 0x16},
    /* 0x84 */ {0x48, 0x04, 0x17},
    /* 0x84 */ {0x49, 0x04, 0x18},
    /* 0x84 */ {0x4A, 0x04, 0x19},
    /* 0x84 */ {0x4B, 0x04, 0x1A},
    /* 0x84 */ {0x4C, 0x04, 0x1B},
    /* 0x84 */ {0x4D, 0x04, 0x1C},
    /* 0x84 */ {0x4E, 0x04, 0x1D},
    /* 0x84 */ {0x4F, 0x04, 0x1E},
    /* 0x84 */ {0x50, 0x04, 0x1F},
    /* 0x84 */ {0x51, 0x04, 0x20},
    /* 0x84 */ {0x52, 0x04, 0x21},
    /* 0x84 */ {0x53, 0x04, 0x22},
    /* 0x84 */ {0x54, 0x04, 0x23},
    /* 0x84 */ {0x55, 0x04, 0x24},
    /* 0x84 */ {0x56, 0x04, 0x25},
    /* 0x84 */ {0x57, 0x04, 0x26},
    /* 0x84 */ {0x58, 0x04, 0x27},
    /* 0x84 */ {0x59, 0x04, 0x28},
    /* 0x84 */ {0x5A, 0x04, 0x29},
    /* 0x84 */ {0x5B, 0x04, 0x2A},
    /* 0x84 */ {0x5C, 0x04, 0x2B},
    /* 0x84 */ {0x5D, 0x04, 0x2C},
    /* 0x84 */ {0x5E, 0x04, 0x2D},
    /* 0x84 */ {0x5F, 0x04, 0x2E},
    /* 0x84 */ {0x60, 0x04, 0x2F},
    /* 0x84 */ {0x70, 0x04, 0x30},
    /* 0x84 */ {0x71, 0x04, 0x31},
    /* 0x84 */ {0x72, 0x04, 0x32},
    /* 0x84 */ {0x73, 0x04, 0x33},
    /* 0x84 */ {0x74, 0x04, 0x34},
    /* 0x84 */ {0x75, 0x04, 0x35},
    /* 0x84 */ {0x76, 0x04, 0x51},
    /* 0x84 */ {0x77, 0x04, 0x36},
    /* 0x84 */ {0x78, 0x04, 0x37},
    /* 0x84 */ {0x79, 0x04, 0x38},
    /* 0x84 */ {0x7A, 0x04, 0x39},
    /* 0x84 */ {0x7B, 0x04, 0x3A},
    /* 0x84 */ {0x7C, 0x04, 0x3B},
    /* 0x84 */ {0x7D, 0x04, 0x3C},
    /* 0x84 */ {0x7E, 0x04, 0x3D},
    /* 0x84 */ {0x80, 0x04, 0x3E},
    /* 0x84 */ {0x81, 0x04, 0x3F},
    /* 0x84 */ {0x82, 0x04, 0x40},
    /* 0x84 */ {0x83, 0x04, 0x41},
    /* 0x84 */ {0x84, 0x04, 0x42},
    /* 0x84 */ {0x85, 0x04, 0x43},
    /* 0x84 */ {0x86, 0x04, 0x44},
    /* 0x84 */ {0x87, 0x04, 0x45},
    /* 0x84 */ {0x88, 0x04, 0x46},
    /* 0x84 */ {0x89, 0x04, 0x47},
    /* 0x84 */ {0x8A, 0x04, 0x48},
    /* 0x84 */ {0x8B, 0x04, 0x49},
    /* 0x84 */ {0x8C, 0x04, 0x4A},
    /* 0x84 */ {0x8D, 0x04, 0x4B},
    /* 0x84 */ {0x8E, 0x04, 0x4C},
    /* 0x84 */ {0x8F, 0x04, 0x4D},
    /* 0x84 */ {0x90, 0x04, 0x4E},
    /* 0x84 */ {0x91, 0x04, 0x4F},
    /* 0x84 */ {0x9F, 0x25, 0x00},
    /* 0x84 */ {0xA0, 0x25, 0x02},
    /* 0x84 */ {0xA1, 0x25, 0x0C},
    /* 0x84 */ {0xA2, 0x25, 0x10},
    /* 0x84 */ {0xA3, 0x25, 0x18},
    /* 0x84 */ {0xA4, 0x25, 0x14},
    /* 0x84 */ {0xA5, 0x25, 0x1C},
    /* 0x84 */ {0xA6, 0x25, 0x2C},
    /* 0x84 */ {0xA7, 0x25, 0x24},
    /* 0x84 */ {0xA8, 0x25, 0x34},
    /* 0x84 */ {0xA9, 0x25, 0x3C},
    /* 0x84 */ {0xAA, 0x25, 0x01},
    /* 0x84 */ {0xAB, 0x25, 0x03},
    /* 0x84 */ {0xAC, 0x25, 0x0F},
    /* 0x84 */ {0xAD, 0x25, 0x13},
    /* 0x84 */ {0xAE, 0x25, 0x1B},
    /* 0x84 */ {0xAF, 0x25, 0x17},
    /* 0x84 */ {0xB0, 0x25, 0x23},
    /* 0x84 */ {0xB1, 0x25, 0x33},
    /* 0x84 */ {0xB2, 0x25, 0x2B},
    /* 0x84 */ {0xB3, 0x25, 0x3B},
    /* 0x84 */ {0xB4, 0x25, 0x4B},
    /* 0x84 */ {0xB5, 0x25, 0x20},
    /* 0x84 */ {0xB6, 0x25, 0x2F},
    /* 0x84 */ {0xB7, 0x25, 0x28},
    /* 0x84 */ {0xB8, 0x25, 0x37},
    /* 0x84 */ {0xB9, 0x25, 0x3F},
    /* 0x84 */ {0xBA, 0x25, 0x1D},
    /* 0x84 */ {0xBB, 0x25, 0x30},
    /* 0x84 */ {0xBC, 0x25, 0x25},
    /* 0x84 */ {0xBD, 0x25, 0x38},
    /* 0x84 */ {0xBE, 0x25, 0x42},
    /* 0x87 */ {0x40, 0x24, 0x60},
    /* 0x87 */ {0x41, 0x24, 0x61},
    /* 0x87 */ {0x42, 0x24, 0x62},
    /* 0x87 */ {0x43, 0x24, 0x63},
    /* 0x87 */ {0x44, 0x24, 0x64},
    /* 0x87 */ {0x45, 0x24, 0x65},
    /* 0x87 */ {0x46, 0x24, 0x66},
    /* 0x87 */ {0x47, 0x24, 0x67},
    /* 0x87 */ {0x48, 0x24, 0x68},
    /* 0x87 */ {0x49, 0x24, 0x69},
    /* 0x87 */ {0x4A, 0x24, 0x6A},
    /* 0x87 */ {0x4B, 0x24, 0x6B},
    /* 0x87 */ {0x4C, 0x24, 0x6C},
    /* 0x87 */ {0x4D, 0x24, 0x6D},
    /* 0x87 */ {0x4E, 0x24, 0x6E},
    /* 0x87 */ {0x4F, 0x24, 0x6F},
    /* 0x87 */ {0x50, 0x24, 0x70},
    /* 0x87 */ {0x51, 0x24, 0x71},
    /* 0x87 */ {0x52, 0x24, 0x72},
    /* 0x87 */ {0x53, 0x24, 0x73},
    /* 0x87 */ {0x54, 0x21, 0x60},
    /* 0x87 */ {0x55, 0x21, 0x61},
    /* 0x87 */ {0x56, 0x21, 0x62},
    /* 0x87 */ {0x57, 0x21, 0x63},
    /* 0x87 */ {0x58, 0x21, 0x64},
    /* 0x87 */ {0x59, 0x21, 0x65},
    /* 0x87 */ {0x5A, 0x21, 0x66},
    /* 0x87 */ {0x5B, 0x21, 0x67},
    /* 0x87 */ {0x5C, 0x21, 0x68},
    /* 0x87 */ {0x5D, 0x21, 0x69},
    /* 0x87 */ {0x5F, 0x33, 0x49},
    /* 0x87 */ {0x60, 0x33, 0x14},
    /* 0x87 */ {0x61, 0x33, 0x22},
    /* 0x87 */ {0x62, 0x33, 0x4D},
    /* 0x87 */ {0x63, 0x33, 0x18},
    /* 0x87 */ {0x64, 0x33, 0x27},
    /* 0x87 */ {0x65, 0x33, 0x03},
    /* 0x87 */ {0x66, 0x33, 0x36},
    /* 0x87 */ {0x67, 0x33, 0x51},
    /* 0x87 */ {0x68, 0x33, 0x57},
    /* 0x87 */ {0x69, 0x33, 0x0D},
    /* 0x87 */ {0x6A, 0x33, 0x26},
    /* 0x87 */ {0x6B, 0x33, 0x23},
    /* 0x87 */ {0x6C, 0x33, 0x2B},
    /* 0x87 */ {0x6D, 0x33, 0x4A},
    /* 0x87 */ {0x6E, 0x33, 0x3B},
    /* 0x87 */ {0x6F, 0x33, 0x9C},
    /* 0x87 */ {0x70, 0x33, 0x9D},
    /* 0x87 */ {0x71, 0x33, 0x9E},
    /* 0x87 */ {0x72, 0x33, 0x8E},
    /* 0x87 */ {0x73, 0x33, 0x8F},
    /* 0x87 */ {0x74, 0x33, 0xC4},
    /* 0x87 */ {0x75, 0x33, 0xA1},
    /* 0x87 */ {0x7E, 0x33, 0x7B},
    /* 0x87 */ {0x80, 0x30, 0x1D},
    /* 0x87 */ {0x81, 0x30, 0x1F},
    /* 0x87 */ {0x82, 0x21, 0x16},
    /* 0x87 */ {0x83, 0x33, 0xCD},
    /* 0x87 */ {0x84, 0x21, 0x21},
    /* 0x87 */ {0x85, 0x32, 0xA4},
    /* 0x87 */ {0x86, 0x32, 0xA5},
    /* 0x87 */ {0x87, 0x32, 0xA6},
    /* 0x87 */ {0x88, 0x32, 0xA7},
    /* 0x87 */ {0x89, 0x32, 0xA8},
    /* 0x87 */ {0x8A, 0x32, 0x31},
    /* 0x87 */ {0x8B, 0x32, 0x32},
    /* 0x87 */ {0x8C, 0x32, 0x39},
    /* 0x87 */ {0x8D, 0x33, 0x7E},
    /* 0x87 */ {0x8E, 0x33, 0x7D},
    /* 0x87 */ {0x8F, 0x33, 0x7C},
    /* 0x87 */ {0x93, 0x22, 0x2E},
    /* 0x87 */ {0x94, 0x22, 0x11},
    /* 0x87 */ {0x98, 0x22, 0x1F},
    /* 0x87 */ {0x99, 0x22, 0xBF},
    /* 0x88 */ {0x9F, 0x4E, 0x9C},
    /* 0x88 */ {0xA0, 0x55, 0x16},
    /* 0x88 */ {0xA1, 0x5A, 0x03},
    /* 0x88 */ {0xA2, 0x96, 0x3F},
    /* 0x88 */ {0xA3, 0x54, 0xC0},
    /* 0x88 */ {0xA4, 0x61, 0x1B},
    /* 0x88 */ {0xA5, 0x63, 0x28},
    /* 0x88 */ {0xA6, 0x59, 0xF6},
    /* 0x88 */ {0xA7, 0x90, 0x22},
    /* 0x88 */ {0xA8, 0x84, 0x75},
    /* 0x88 */ {0xA9, 0x83, 0x1C},
    /* 0x88 */ {0xAA, 0x7A, 0x50},
    /* 0x88 */ {0xAB, 0x60, 0xAA},
    /* 0x88 */ {0xAC, 0x63, 0xE1},
    /* 0x88 */ {0xAD, 0x6E, 0x25},
    /* 0x88 */ {0xAE, 0x65, 0xED},
    /* 0x88 */ {0xAF, 0x84, 0x66},
    /* 0x88 */ {0xB0, 0x82, 0xA6},
    /* 0x88 */ {0xB1, 0x9B, 0xF5},
    /* 0x88 */ {0xB2, 0x68, 0x93},
    /* 0x88 */ {0xB3, 0x57, 0x27},
    /* 0x88 */ {0xB4, 0x65, 0xA1},
    /* 0x88 */ {0xB5, 0x62, 0x71},
    /* 0x88 */ {0xB6, 0x5B, 0x9B},
    /* 0x88 */ {0xB7, 0x59, 0xD0},
    /* 0x88 */ {0xB8, 0x86, 0x7B},
    /* 0x88 */ {0xB9, 0x98, 0xF4},
    /* 0x88 */ {0xBA, 0x7D, 0x62},
    /* 0x88 */ {0xBB, 0x7D, 0xBE},
    /* 0x88 */ {0xBC, 0x9B, 0x8E},
    /* 0x88 */ {0xBD, 0x62, 0x16},
    /* 0x88 */ {0xBE, 0x7C, 0x9F},
    /* 0x88 */ {0xBF, 0x88, 0xB7},
    /* 0x88 */ {0xC0, 0x5B, 0x89},
    /* 0x88 */ {0xC1, 0x5E, 0xB5},
    /* 0x88 */ {0xC2, 0x63, 0x09},
    /* 0x88 */ {0xC3, 0x66, 0x97},
    /* 0x88 */ {0xC4, 0x68, 0x48},
    /* 0x88 */ {0xC5, 0x95, 0xC7},
    /* 0x88 */ {0xC6, 0x97, 0x8D},
    /* 0x88 */ {0xC7, 0x67, 0x4F},
    /* 0x88 */ {0xC8, 0x4E, 0xE5},
    /* 0x88 */ {0xC9, 0x4F, 0x0A},
    /* 0x88 */ {0xCA, 0x4F, 0x4D},
    /* 0x88 */ {0xCB, 0x4F, 0x9D},
    /* 0x88 */ {0xCC, 0x50, 0x49},
    /* 0x88 */ {0xCD, 0x56, 0xF2},
    /* 0x88 */ {0xCE, 0x59, 0x37},
    /* 0x88 */ {0xCF, 0x59, 0xD4},
    /* 0x88 */ {0xD0, 0x5A, 0x01},
    /* 0x88 */ {0xD1, 0x5C, 0x09},
    /* 0x88 */ {0xD2, 0x60, 0xDF},
    /* 0x88 */ {0xD3, 0x61, 0x0F},
    /* 0x88 */ {0xD4, 0x61, 0x70},
    /* 0x88 */ {0xD5, 0x66, 0x13},
    /* 0x88 */ {0xD6, 0x69, 0x05},
    /* 0x88 */ {0xD7, 0x70, 0xBA},
    /* 0x88 */ {0xD8, 0x75, 0x4F},
    /* 0x88 */ {0xD9, 0x75, 0x70},
    /* 0x88 */ {0xDA, 0x79, 0xFB},
    /* 0x88 */ {0xDB, 0x7D, 0xAD},
    /* 0x88 */ {0xDC, 0x7D, 0xEF},
    /* 0x88 */ {0xDD, 0x80, 0xC3},
    /* 0x88 */ {0xDE, 0x84, 0x0E},
    /* 0x88 */ {0xDF, 0x88, 0x63},
    /* 0x88 */ {0xE0, 0x8B, 0x02},
    /* 0x88 */ {0xE1, 0x90, 0x55},
    /* 0x88 */ {0xE2, 0x90, 0x7A},
    /* 0x88 */ {0xE3, 0x53, 0x3B},
    /* 0x88 */ {0xE4, 0x4E, 0x95},
    /* 0x88 */ {0xE5, 0x4E, 0xA5},
    /* 0x88 */ {0xE6, 0x57, 0xDF},
    /* 0x88 */ {0xE7, 0x80, 0xB2},
    /* 0x88 */ {0xE8, 0x90, 0xC1},
    /* 0x88 */ {0xE9, 0x78, 0xEF},
    /* 0x88 */ {0xEA, 0x4E, 0x00},
    /* 0x88 */ {0xEB, 0x58, 0xF1},
    /* 0x88 */ {0xEC, 0x6E, 0xA2},
    /* 0x88 */ {0xED, 0x90, 0x38},
    /* 0x88 */ {0xEE, 0x7A, 0x32},
    /* 0x88 */ {0xEF, 0x83, 0x28},
    /* 0x88 */ {0xF0, 0x82, 0x8B},
    /* 0x88 */ {0xF1, 0x9C, 0x2F},
    /* 0x88 */ {0xF2, 0x51, 0x41},
    /* 0x88 */ {0xF3, 0x53, 0x70},
    /* 0x88 */ {0xF4, 0x54, 0xBD},
    /* 0x88 */ {0xF5, 0x54, 0xE1},
    /* 0x88 */ {0xF6, 0x56, 0xE0},
    /* 0x88 */ {0xF7, 0x59, 0xFB},
    /* 0x88 */ {0xF8, 0x5F, 0x15},
    /* 0x88 */ {0xF9, 0x98, 0xF2},
    /* 0x88 */ {0xFA, 0x6D, 0xEB},
    /* 0x88 */ {0xFB, 0x80, 0xE4},
    /* 0x88 */ {0xFC, 0x85, 0x2D},
    /* 0x89 */ {0x40, 0x96, 0x62},
    /* 0x89 */ {0x41, 0x96, 0x70},
    /* 0x89 */ {0x42, 0x96, 0xA0},
    /* 0x89 */ {0x43, 0x97, 0xFB},
    /* 0x89 */ {0x44, 0x54, 0x0B},
    /* 0x89 */ {0x45, 0x53, 0xF3},
    /* 0x89 */ {0x46, 0x5B, 0x87},
    /* 0x89 */ {0x47, 0x70, 0xCF},
    /* 0x89 */ {0x48, 0x7F, 0xBD},
    /* 0x89 */ {0x49, 0x8F, 0xC2},
    /* 0x89 */ {0x4A, 0x96, 0xE8},
    /* 0x89 */ {0x4B, 0x53, 0x6F},
    /* 0x89 */ {0x4C, 0x9D, 0x5C},
    /* 0x89 */ {0x4D, 0x7A, 0xBA},
    /* 0x89 */ {0x4E, 0x4E, 0x11},
    /* 0x89 */ {0x4F, 0x78, 0x93},
    /* 0x89 */ {0x50, 0x81, 0xFC},
    /* 0x89 */ {0x51, 0x6E, 0x26},
    /* 0x89 */ {0x52, 0x56, 0x18},
    /* 0x89 */ {0x53, 0x55, 0x04},
    /* 0x89 */ {0x54, 0x6B, 0x1D},
    /* 0x89 */ {0x55, 0x85, 0x1A},
    /* 0x89 */ {0x56, 0x9C, 0x3B},
    /* 0x89 */ {0x57, 0x59, 0xE5},
    /* 0x89 */ {0x58, 0x53, 0xA9},
    /* 0x89 */ {0x59, 0x6D, 0x66},
    /* 0x89 */ {0x5A, 0x74, 0xDC},
    /* 0x89 */ {0x5B, 0x95, 0x8F},
    /* 0x89 */ {0x5C, 0x56, 0x42},
    /* 0x89 */ {0x5D, 0x4E, 0x91},
    /* 0x89 */ {0x5E, 0x90, 0x4B},
    /* 0x89 */ {0x5F, 0x96, 0xF2},
    /* 0x89 */ {0x60, 0x83, 0x4F},
    /* 0x89 */ {0x61, 0x99, 0x0C},
    /* 0x89 */ {0x62, 0x53, 0xE1},
    /* 0x89 */ {0x63, 0x55, 0xB6},
    /* 0x89 */ {0x64, 0x5B, 0x30},
    /* 0x89 */ {0x65, 0x5F, 0x71},
    /* 0x89 */ {0x66, 0x66, 0x20},
    /* 0x89 */ {0x67, 0x66, 0xF3},
    /* 0x89 */ {0x68, 0x68, 0x04},
    /* 0x89 */ {0x69, 0x6C, 0x38},
    /* 0x89 */ {0x6A, 0x6C, 0xF3},
    /* 0x89 */ {0x6B, 0x6D, 0x29},
    /* 0x89 */ {0x6C, 0x74, 0x5B},
    /* 0x89 */ {0x6D, 0x76, 0xC8},
    /* 0x89 */ {0x6E, 0x7A, 0x4E},
    /* 0x89 */ {0x6F, 0x98, 0x34},
    /* 0x89 */ {0x70, 0x82, 0xF1},
    /* 0x89 */ {0x71, 0x88, 0x5B},
    /* 0x89 */ {0x72, 0x8A, 0x60},
    /* 0x89 */ {0x73, 0x92, 0xED},
    /* 0x89 */ {0x74, 0x6D, 0xB2},
    /* 0x89 */ {0x75, 0x75, 0xAB},
    /* 0x89 */ {0x76, 0x76, 0xCA},
    /* 0x89 */ {0x77, 0x99, 0xC5},
    /* 0x89 */ {0x78, 0x60, 0xA6},
    /* 0x89 */ {0x79, 0x8B, 0x01},
    /* 0x89 */ {0x7A, 0x8D, 0x8A},
    /* 0x89 */ {0x7B, 0x95, 0xB2},
    /* 0x89 */ {0x7C, 0x69, 0x8E},
    /* 0x89 */ {0x7D, 0x53, 0xAD},
    /* 0x89 */ {0x7E, 0x51, 0x86},
    /* 0x89 */ {0x80, 0x57, 0x12},
    /* 0x89 */ {0x81, 0x58, 0x30},
    /* 0x89 */ {0x82, 0x59, 0x44},
    /* 0x89 */ {0x83, 0x5B, 0xB4},
    /* 0x89 */ {0x84, 0x5E, 0xF6},
    /* 0x89 */ {0x85, 0x60, 0x28},
    /* 0x89 */ {0x86, 0x63, 0xA9},
    /* 0x89 */ {0x87, 0x63, 0xF4},
    /* 0x89 */ {0x88, 0x6C, 0xBF},
    /* 0x89 */ {0x89, 0x6F, 0x14},
    /* 0x89 */ {0x8A, 0x70, 0x8E},
    /* 0x89 */ {0x8B, 0x71, 0x14},
    /* 0x89 */ {0x8C, 0x71, 0x59},
    /* 0x89 */ {0x8D, 0x71, 0xD5},
    /* 0x89 */ {0x8E, 0x73, 0x3F},
    /* 0x89 */ {0x8F, 0x7E, 0x01},
    /* 0x89 */ {0x90, 0x82, 0x76},
    /* 0x89 */ {0x91, 0x82, 0xD1},
    /* 0x89 */ {0x92, 0x85, 0x97},
    /* 0x89 */ {0x93, 0x90, 0x60},
    /* 0x89 */ {0x94, 0x92, 0x5B},
    /* 0x89 */ {0x95, 0x9D, 0x1B},
    /* 0x89 */ {0x96, 0x58, 0x69},
    /* 0x89 */ {0x97, 0x65, 0xBC},
    /* 0x89 */ {0x98, 0x6C, 0x5A},
    /* 0x89 */ {0x99, 0x75, 0x25},
    /* 0x89 */ {0x9A, 0x51, 0xF9},
    /* 0x89 */ {0x9B, 0x59, 0x2E},
    /* 0x89 */ {0x9C, 0x59, 0x65},
    /* 0x89 */ {0x9D, 0x5F, 0x80},
    /* 0x89 */ {0x9E, 0x5F, 0xDC},
    /* 0x89 */ {0x9F, 0x62, 0xBC},
    /* 0x89 */ {0xA0, 0x65, 0xFA},
    /* 0x89 */ {0xA1, 0x6A, 0x2A},
    /* 0x89 */ {0xA2, 0x6B, 0x27},
    /* 0x89 */ {0xA3, 0x6B, 0xB4},
    /* 0x89 */ {0xA4, 0x73, 0x8B},
    /* 0x89 */ {0xA5, 0x7F, 0xC1},
    /* 0x89 */ {0xA6, 0x89, 0x56},
    /* 0x89 */ {0xA7, 0x9D, 0x2C},
    /* 0x89 */ {0xA8, 0x9D, 0x0E},
    /* 0x89 */ {0xA9, 0x9E, 0xC4},
    /* 0x89 */ {0xAA, 0x5C, 0xA1},
    /* 0x89 */ {0xAB, 0x6C, 0x96},
    /* 0x89 */ {0xAC, 0x83, 0x7B},
    /* 0x89 */ {0xAD, 0x51, 0x04},
    /* 0x89 */ {0xAE, 0x5C, 0x4B},
    /* 0x89 */ {0xAF, 0x61, 0xB6},
    /* 0x89 */ {0xB0, 0x81, 0xC6},
    /* 0x89 */ {0xB1, 0x68, 0x76},
    /* 0x89 */ {0xB2, 0x72, 0x61},
    /* 0x89 */ {0xB3, 0x4E, 0x59},
    /* 0x89 */ {0xB4, 0x4F, 0xFA},
    /* 0x89 */ {0xB5, 0x53, 0x78},
    /* 0x89 */ {0xB6, 0x60, 0x69},
    /* 0x89 */ {0xB7, 0x6E, 0x29},
    /* 0x89 */ {0xB8, 0x7A, 0x4F},
    /* 0x89 */ {0xB9, 0x97, 0xF3},
    /* 0x89 */ {0xBA, 0x4E, 0x0B},
    /* 0x89 */ {0xBB, 0x53, 0x16},
    /* 0x89 */ {0xBC, 0x4E, 0xEE},
    /* 0x89 */ {0xBD, 0x4F, 0x55},
    /* 0x89 */ {0xBE, 0x4F, 0x3D},
    /* 0x89 */ {0xBF, 0x4F, 0xA1},
    /* 0x89 */ {0xC0, 0x4F, 0x73},
    /* 0x89 */ {0xC1, 0x52, 0xA0},
    /* 0x89 */ {0xC2, 0x53, 0xEF},
    /* 0x89 */ {0xC3, 0x56, 0x09},
    /* 0x89 */ {0xC4, 0x59, 0x0F},
    /* 0x89 */ {0xC5, 0x5A, 0xC1},
    /* 0x89 */ {0xC6, 0x5B, 0xB6},
    /* 0x89 */ {0xC7, 0x5B, 0xE1},
    /* 0x89 */ {0xC8, 0x79, 0xD1},
    /* 0x89 */ {0xC9, 0x66, 0x87},
    /* 0x89 */ {0xCA, 0x67, 0x9C},
    /* 0x89 */ {0xCB, 0x67, 0xB6},
    /* 0x89 */ {0xCC, 0x6B, 0x4C},
    /* 0x89 */ {0xCD, 0x6C, 0xB3},
    /* 0x89 */ {0xCE, 0x70, 0x6B},
    /* 0x89 */ {0xCF, 0x73, 0xC2},
    /* 0x89 */ {0xD0, 0x79, 0x8D},
    /* 0x89 */ {0xD1, 0x79, 0xBE},
    /* 0x89 */ {0xD2, 0x7A, 0x3C},
    /* 0x89 */ {0xD3, 0x7B, 0x87},
    /* 0x89 */ {0xD4, 0x82, 0xB1},
    /* 0x89 */ {0xD5, 0x82, 0xDB},
    /* 0x89 */ {0xD6, 0x83, 0x04},
    /* 0x89 */ {0xD7, 0x83, 0x77},
    /* 0x89 */ {0xD8, 0x83, 0xEF},
    /* 0x89 */ {0xD9, 0x83, 0xD3},
    /* 0x89 */ {0xDA, 0x87, 0x66},
    /* 0x89 */ {0xDB, 0x8A, 0xB2},
    /* 0x89 */ {0xDC, 0x56, 0x29},
    /* 0x89 */ {0xDD, 0x8C, 0xA8},
    /* 0x89 */ {0xDE, 0x8F, 0xE6},
    /* 0x89 */ {0xDF, 0x90, 0x4E},
    /* 0x89 */ {0xE0, 0x97, 0x1E},
    /* 0x89 */ {0xE1, 0x86, 0x8A},
    /* 0x89 */ {0xE2, 0x4F, 0xC4},
    /* 0x89 */ {0xE3, 0x5C, 0xE8},
    /* 0x89 */ {0xE4, 0x62, 0x11},
    /* 0x89 */ {0xE5, 0x72, 0x59},
    /* 0x89 */ {0xE6, 0x75, 0x3B},
    /* 0x89 */ {0xE7, 0x81, 0xE5},
    /* 0x89 */ {0xE8, 0x82, 0xBD},
    /* 0x89 */ {0xE9, 0x86, 0xFE},
    /* 0x89 */ {0xEA, 0x8C, 0xC0},
    /* 0x89 */ {0xEB, 0x96, 0xC5},
    /* 0x89 */ {0xEC, 0x99, 0x13},
    /* 0x89 */ {0xED, 0x99, 0xD5},
    /* 0x89 */ {0xEE, 0x4E, 0xCB},
    /* 0x89 */ {0xEF, 0x4F, 0x1A},
    /* 0x89 */ {0xF0, 0x89, 0xE3},
    /* 0x89 */ {0xF1, 0x56, 0xDE},
    /* 0x89 */ {0xF2, 0x58, 0x4A},
    /* 0x89 */ {0xF3, 0x58, 0xCA},
    /* 0x89 */ {0xF4, 0x5E, 0xFB},
    /* 0x89 */ {0xF5, 0x5F, 0xEB},
    /* 0x89 */ {0xF6, 0x60, 0x2A},
    /* 0x89 */ {0xF7, 0x60, 0x94},
    /* 0x89 */ {0xF8, 0x60, 0x62},
    /* 0x89 */ {0xF9, 0x61, 0xD0},
    /* 0x89 */ {0xFA, 0x62, 0x12},
    /* 0x89 */ {0xFB, 0x62, 0xD0},
    /* 0x89 */ {0xFC, 0x65, 0x39},
    /* 0x8A */ {0x40, 0x9B, 0x41},
    /* 0x8A */ {0x41, 0x66, 0x66},
    /* 0x8A */ {0x42, 0x68, 0xB0},
    /* 0x8A */ {0x43, 0x6D, 0x77},
    /* 0x8A */ {0x44, 0x70, 0x70},
    /* 0x8A */ {0x45, 0x75, 0x4C},
    /* 0x8A */ {0x46, 0x76, 0x86},
    /* 0x8A */ {0x47, 0x7D, 0x75},
    /* 0x8A */ {0x48, 0x82, 0xA5},
    /* 0x8A */ {0x49, 0x87, 0xF9},
    /* 0x8A */ {0x4A, 0x95, 0x8B},
    /* 0x8A */ {0x4B, 0x96, 0x8E},
    /* 0x8A */ {0x4C, 0x8C, 0x9D},
    /* 0x8A */ {0x4D, 0x51, 0xF1},
    /* 0x8A */ {0x4E, 0x52, 0xBE},
    /* 0x8A */ {0x4F, 0x59, 0x16},
    /* 0x8A */ {0x50, 0x54, 0xB3},
    /* 0x8A */ {0x51, 0x5B, 0xB3},
    /* 0x8A */ {0x52, 0x5D, 0x16},
    /* 0x8A */ {0x53, 0x61, 0x68},
    /* 0x8A */ {0x54, 0x69, 0x82},
    /* 0x8A */ {0x55, 0x6D, 0xAF},
    /* 0x8A */ {0x56, 0x78, 0x8D},
    /* 0x8A */ {0x57, 0x84, 0xCB},
    /* 0x8A */ {0x58, 0x88, 0x57},
    /* 0x8A */ {0x59, 0x8A, 0x72},
    /* 0x8A */ {0x5A, 0x93, 0xA7},
    /* 0x8A */ {0x5B, 0x9A, 0xB8},
    /* 0x8A */ {0x5C, 0x6D, 0x6C},
    /* 0x8A */ {0x5D, 0x99, 0xA8},
    /* 0x8A */ {0x5E, 0x86, 0xD9},
    /* 0x8A */ {0x5F, 0x57, 0xA3},
    /* 0x8A */ {0x60, 0x67, 0xFF},
    /* 0x8A */ {0x61, 0x86, 0xCE},
    /* 0x8A */ {0x62, 0x92, 0x0E},
    /* 0x8A */ {0x63, 0x52, 0x83},
    /* 0x8A */ {0x64, 0x56, 0x87},
    /* 0x8A */ {0x65, 0x54, 0x04},
    /* 0x8A */ {0x66, 0x5E, 0xD3},
    /* 0x8A */ {0x67, 0x62, 0xE1},
    /* 0x8A */ {0x68, 0x64, 0xB9},
    /* 0x8A */ {0x69, 0x68, 0x3C},
    /* 0x8A */ {0x6A, 0x68, 0x38},
    /* 0x8A */ {0x6B, 0x6B, 0xBB},
    /* 0x8A */ {0x6C, 0x73, 0x72},
    /* 0x8A */ {0x6D, 0x78, 0xBA},
    /* 0x8A */ {0x6E, 0x7A, 0x6B},
    /* 0x8A */ {0x6F, 0x89, 0x9A},
    /* 0x8A */ {0x70, 0x89, 0xD2},
    /* 0x8A */ {0x71, 0x8D, 0x6B},
    /* 0x8A */ {0x72, 0x8F, 0x03},
    /* 0x8A */ {0x73, 0x90, 0xED},
    /* 0x8A */ {0x74, 0x95, 0xA3},
    /* 0x8A */ {0x75, 0x96, 0x94},
    /* 0x8A */ {0x76, 0x97, 0x69},
    /* 0x8A */ {0x77, 0x5B, 0x66},
    /* 0x8A */ {0x78, 0x5C, 0xB3},
    /* 0x8A */ {0x79, 0x69, 0x7D},
    /* 0x8A */ {0x7A, 0x98, 0x4D},
    /* 0x8A */ {0x7B, 0x98, 0x4E},
    /* 0x8A */ {0x7C, 0x63, 0x9B},
    /* 0x8A */ {0x7D, 0x7B, 0x20},
    /* 0x8A */ {0x7E, 0x6A, 0x2B},
    /* 0x8A */ {0x80, 0x6A, 0x7F},
    /* 0x8A */ {0x81, 0x68, 0xB6},
    /* 0x8A */ {0x82, 0x9C, 0x0D},
    /* 0x8A */ {0x83, 0x6F, 0x5F},
    /* 0x8A */ {0x84, 0x52, 0x72},
    /* 0x8A */ {0x85, 0x55, 0x9D},
    /* 0x8A */ {0x86, 0x60, 0x70},
    /* 0x8A */ {0x87, 0x62, 0xEC},
    /* 0x8A */ {0x88, 0x6D, 0x3B},
    /* 0x8A */ {0x89, 0x6E, 0x07},
    /* 0x8A */ {0x8A, 0x6E, 0xD1},
    /* 0x8A */ {0x8B, 0x84, 0x5B},
    /* 0x8A */ {0x8C, 0x89, 0x10},
    /* 0x8A */ {0x8D, 0x8F, 0x44},
    /* 0x8A */ {0x8E, 0x4E, 0x14},
    /* 0x8A */ {0x8F, 0x9C, 0x39},
    /* 0x8A */ {0x90, 0x53, 0xF6},
    /* 0x8A */ {0x91, 0x69, 0x1B},
    /* 0x8A */ {0x92, 0x6A, 0x3A},
    /* 0x8A */ {0x93, 0x97, 0x84},
    /* 0x8A */ {0x94, 0x68, 0x2A},
    /* 0x8A */ {0x95, 0x51, 0x5C},
    /* 0x8A */ {0x96, 0x7A, 0xC3},
    /* 0x8A */ {0x97, 0x84, 0xB2},
    /* 0x8A */ {0x98, 0x91, 0xDC},
    /* 0x8A */ {0x99, 0x93, 0x8C},
    /* 0x8A */ {0x9A, 0x56, 0x5B},
    /* 0x8A */ {0x9B, 0x9D, 0x28},
    /* 0x8A */ {0x9C, 0x68, 0x22},
    /* 0x8A */ {0x9D, 0x83, 0x05},
    /* 0x8A */ {0x9E, 0x84, 0x31},
    /* 0x8A */ {0x9F, 0x7C, 0xA5},
    /* 0x8A */ {0xA0, 0x52, 0x08},
    /* 0x8A */ {0xA1, 0x82, 0xC5},
    /* 0x8A */ {0xA2, 0x74, 0xE6},
    /* 0x8A */ {0xA3, 0x4E, 0x7E},
    /* 0x8A */ {0xA4, 0x4F, 0x83},
    /* 0x8A */ {0xA5, 0x51, 0xA0},
    /* 0x8A */ {0xA6, 0x5B, 0xD2},
    /* 0x8A */ {0xA7, 0x52, 0x0A},
    /* 0x8A */ {0xA8, 0x52, 0xD8},
    /* 0x8A */ {0xA9, 0x52, 0xE7},
    /* 0x8A */ {0xAA, 0x5D, 0xFB},
    /* 0x8A */ {0xAB, 0x55, 0x9A},
    /* 0x8A */ {0xAC, 0x58, 0x2A},
    /* 0x8A */ {0xAD, 0x59, 0xE6},
    /* 0x8A */ {0xAE, 0x5B, 0x8C},
    /* 0x8A */ {0xAF, 0x5B, 0x98},
    /* 0x8A */ {0xB0, 0x5B, 0xDB},
    /* 0x8A */ {0xB1, 0x5E, 0x72},
    /* 0x8A */ {0xB2, 0x5E, 0x79},
    /* 0x8A */ {0xB3, 0x60, 0xA3},
    /* 0x8A */ {0xB4, 0x61, 0x1F},
    /* 0x8A */ {0xB5, 0x61, 0x63},
    /* 0x8A */ {0xB6, 0x61, 0xBE},
    /* 0x8A */ {0xB7, 0x63, 0xDB},
    /* 0x8A */ {0xB8, 0x65, 0x62},
    /* 0x8A */ {0xB9, 0x67, 0xD1},
    /* 0x8A */ {0xBA, 0x68, 0x53},
    /* 0x8A */ {0xBB, 0x68, 0xFA},
    /* 0x8A */ {0xBC, 0x6B, 0x3E},
    /* 0x8A */ {0xBD, 0x6B, 0x53},
    /* 0x8A */ {0xBE, 0x6C, 0x57},
    /* 0x8A */ {0xBF, 0x6F, 0x22},
    /* 0x8A */ {0xC0, 0x6F, 0x97},
    /* 0x8A */ {0xC1, 0x6F, 0x45},
    /* 0x8A */ {0xC2, 0x74, 0xB0},
    /* 0x8A */ {0xC3, 0x75, 0x18},
    /* 0x8A */ {0xC4, 0x76, 0xE3},
    /* 0x8A */ {0xC5, 0x77, 0x0B},
    /* 0x8A */ {0xC6, 0x7A, 0xFF},
    /* 0x8A */ {0xC7, 0x7B, 0xA1},
    /* 0x8A */ {0xC8, 0x7C, 0x21},
    /* 0x8A */ {0xC9, 0x7D, 0xE9},
    /* 0x8A */ {0xCA, 0x7F, 0x36},
    /* 0x8A */ {0xCB, 0x7F, 0xF0},
    /* 0x8A */ {0xCC, 0x80, 0x9D},
    /* 0x8A */ {0xCD, 0x82, 0x66},
    /* 0x8A */ {0xCE, 0x83, 0x9E},
    /* 0x8A */ {0xCF, 0x89, 0xB3},
    /* 0x8A */ {0xD0, 0x8A, 0xCC},
    /* 0x8A */ {0xD1, 0x8C, 0xAB},
    /* 0x8A */ {0xD2, 0x90, 0x84},
    /* 0x8A */ {0xD3, 0x94, 0x51},
    /* 0x8A */ {0xD4, 0x95, 0x93},
    /* 0x8A */ {0xD5, 0x95, 0x91},
    /* 0x8A */ {0xD6, 0x95, 0xA2},
    /* 0x8A */ {0xD7, 0x96, 0x65},
    /* 0x8A */ {0xD8, 0x97, 0xD3},
    /* 0x8A */ {0xD9, 0x99, 0x28},
    /* 0x8A */ {0xDA, 0x82, 0x18},
    /* 0x8A */ {0xDB, 0x4E, 0x38},
    /* 0x8A */ {0xDC, 0x54, 0x2B},
    /* 0x8A */ {0xDD, 0x5C, 0xB8},
    /* 0x8A */ {0xDE, 0x5D, 0xCC},
    /* 0x8A */ {0xDF, 0x73, 0xA9},
    /* 0x8A */ {0xE0, 0x76, 0x4C},
    /* 0x8A */ {0xE1, 0x77, 0x3C},
    /* 0x8A */ {0xE2, 0x5C, 0xA9},
    /* 0x8A */ {0xE3, 0x7F, 0xEB},
    /* 0x8A */ {0xE4, 0x8D, 0x0B},
    /* 0x8A */ {0xE5, 0x96, 0xC1},
    /* 0x8A */ {0xE6, 0x98, 0x11},
    /* 0x8A */ {0xE7, 0x98, 0x54},
    /* 0x8A */ {0xE8, 0x98, 0x58},
    /* 0x8A */ {0xE9, 0x4F, 0x01},
    /* 0x8A */ {0xEA, 0x4F, 0x0E},
    /* 0x8A */ {0xEB, 0x53, 0x71},
    /* 0x8A */ {0xEC, 0x55, 0x9C},
    /* 0x8A */ {0xED, 0x56, 0x68},
    /* 0x8A */ {0xEE, 0x57, 0xFA},
    /* 0x8A */ {0xEF, 0x59, 0x47},
    /* 0x8A */ {0xF0, 0x5B, 0x09},
    /* 0x8A */ {0xF1, 0x5B, 0xC4},
    /* 0x8A */ {0xF2, 0x5C, 0x90},
    /* 0x8A */ {0xF3, 0x5E, 0x0C},
    /* 0x8A */ {0xF4, 0x5E, 0x7E},
    /* 0x8A */ {0xF5, 0x5F, 0xCC},
    /* 0x8A */ {0xF6, 0x63, 0xEE},
    /* 0x8A */ {0xF7, 0x67, 0x3A},
    /* 0x8A */ {0xF8, 0x65, 0xD7},
    /* 0x8A */ {0xF9, 0x65, 0xE2},
    /* 0x8A */ {0xFA, 0x67, 0x1F},
    /* 0x8A */ {0xFB, 0x68, 0xCB},
    /* 0x8A */ {0xFC, 0x68, 0xC4},
    /* 0x8B */ {0x40, 0x6A, 0x5F},
    /* 0x8B */ {0x41, 0x5E, 0x30},
    /* 0x8B */ {0x42, 0x6B, 0xC5},
    /* 0x8B */ {0x43, 0x6C, 0x17},
    /* 0x8B */ {0x44, 0x6C, 0x7D},
    /* 0x8B */ {0x45, 0x75, 0x7F},
    /* 0x8B */ {0x46, 0x79, 0x48},
    /* 0x8B */ {0x47, 0x5B, 0x63},
    /* 0x8B */ {0x48, 0x7A, 0x00},
    /* 0x8B */ {0x49, 0x7D, 0x00},
    /* 0x8B */ {0x4A, 0x5F, 0xBD},
    /* 0x8B */ {0x4B, 0x89, 0x8F},
    /* 0x8B */ {0x4C, 0x8A, 0x18},
    /* 0x8B */ {0x4D, 0x8C, 0xB4},
    /* 0x8B */ {0x4E, 0x8D, 0x77},
    /* 0x8B */ {0x4F, 0x8E, 0xCC},
    /* 0x8B */ {0x50, 0x8F, 0x1D},
    /* 0x8B */ {0x51, 0x98, 0xE2},
    /* 0x8B */ {0x52, 0x9A, 0x0E},
    /* 0x8B */ {0x53, 0x9B, 0x3C},
    /* 0x8B */ {0x54, 0x4E, 0x80},
    /* 0x8B */ {0x55, 0x50, 0x7D},
    /* 0x8B */ {0x56, 0x51, 0x00},
    /* 0x8B */ {0x57, 0x59, 0x93},
    /* 0x8B */ {0x58, 0x5B, 0x9C},
    /* 0x8B */ {0x59, 0x62, 0x2F},
    /* 0x8B */ {0x5A, 0x62, 0x80},
    /* 0x8B */ {0x5B, 0x64, 0xEC},
    /* 0x8B */ {0x5C, 0x6B, 0x3A},
    /* 0x8B */ {0x5D, 0x72, 0xA0},
    /* 0x8B */ {0x5E, 0x75, 0x91},
    /* 0x8B */ {0x5F, 0x79, 0x47},
    /* 0x8B */ {0x60, 0x7F, 0xA9},
    /* 0x8B */ {0x61, 0x87, 0xFB},
    /* 0x8B */ {0x62, 0x8A, 0xBC},
    /* 0x8B */ {0x63, 0x8B, 0x70},
    /* 0x8B */ {0x64, 0x63, 0xAC},
    /* 0x8B */ {0x65, 0x83, 0xCA},
    /* 0x8B */ {0x66, 0x97, 0xA0},
    /* 0x8B */ {0x67, 0x54, 0x09},
    /* 0x8B */ {0x68, 0x54, 0x03},
    /* 0x8B */ {0x69, 0x55, 0xAB},
    /* 0x8B */ {0x6A, 0x68, 0x54},
    /* 0x8B */ {0x6B, 0x6A, 0x58},
    /* 0x8B */ {0x6C, 0x8A, 0x70},
    /* 0x8B */ {0x6D, 0x78, 0x27},
    /* 0x8B */ {0x6E, 0x67, 0x75},
    /* 0x8B */ {0x6F, 0x9E, 0xCD},
    /* 0x8B */ {0x70, 0x53, 0x74},
    /* 0x8B */ {0x71, 0x5B, 0xA2},
    /* 0x8B */ {0x72, 0x81, 0x1A},
    /* 0x8B */ {0x73, 0x86, 0x50},
    /* 0x8B */ {0x74, 0x90, 0x06},
    /* 0x8B */ {0x75, 0x4E, 0x18},
    /* 0x8B */ {0x76, 0x4E, 0x45},
    /* 0x8B */ {0x77, 0x4E, 0xC7},
    /* 0x8B */ {0x78, 0x4F, 0x11},
    /* 0x8B */ {0x79, 0x53, 0xCA},
    /* 0x8B */ {0x7A, 0x54, 0x38},
    /* 0x8B */ {0x7B, 0x5B, 0xAE},
    /* 0x8B */ {0x7C, 0x5F, 0x13},
    /* 0x8B */ {0x7D, 0x60, 0x25},
    /* 0x8B */ {0x7E, 0x65, 0x51},
    /* 0x8B */ {0x80, 0x67, 0x3D},
    /* 0x8B */ {0x81, 0x6C, 0x42},
    /* 0x8B */ {0x82, 0x6C, 0x72},
    /* 0x8B */ {0x83, 0x6C, 0xE3},
    /* 0x8B */ {0x84, 0x70, 0x78},
    /* 0x8B */ {0x85, 0x74, 0x03},
    /* 0x8B */ {0x86, 0x7A, 0x76},
    /* 0x8B */ {0x87, 0x7A, 0xAE},
    /* 0x8B */ {0x88, 0x7B, 0x08},
    /* 0x8B */ {0x89, 0x7D, 0x1A},
    /* 0x8B */ {0x8A, 0x7C, 0xFE},
    /* 0x8B */ {0x8B, 0x7D, 0x66},
    /* 0x8B */ {0x8C, 0x65, 0xE7},
    /* 0x8B */ {0x8D, 0x72, 0x5B},
    /* 0x8B */ {0x8E, 0x53, 0xBB},
    /* 0x8B */ {0x8F, 0x5C, 0x45},
    /* 0x8B */ {0x90, 0x5D, 0xE8},
    /* 0x8B */ {0x91, 0x62, 0xD2},
    /* 0x8B */ {0x92, 0x62, 0xE0},
    /* 0x8B */ {0x93, 0x63, 0x19},
    /* 0x8B */ {0x94, 0x6E, 0x20},
    /* 0x8B */ {0x95, 0x86, 0x5A},
    /* 0x8B */ {0x96, 0x8A, 0x31},
    /* 0x8B */ {0x97, 0x8D, 0xDD},
    /* 0x8B */ {0x98, 0x92, 0xF8},
    /* 0x8B */ {0x99, 0x6F, 0x01},
    /* 0x8B */ {0x9A, 0x79, 0xA6},
    /* 0x8B */ {0x9B, 0x9B, 0x5A},
    /* 0x8B */ {0x9C, 0x4E, 0xA8},
    /* 0x8B */ {0x9D, 0x4E, 0xAB},
    /* 0x8B */ {0x9E, 0x4E, 0xAC},
    /* 0x8B */ {0x9F, 0x4F, 0x9B},
    /* 0x8B */ {0xA0, 0x4F, 0xA0},
    /* 0x8B */ {0xA1, 0x50, 0xD1},
    /* 0x8B */ {0xA2, 0x51, 0x47},
    /* 0x8B */ {0xA3, 0x7A, 0xF6},
    /* 0x8B */ {0xA4, 0x51, 0x71},
    /* 0x8B */ {0xA5, 0x51, 0xF6},
    /* 0x8B */ {0xA6, 0x53, 0x54},
    /* 0x8B */ {0xA7, 0x53, 0x21},
    /* 0x8B */ {0xA8, 0x53, 0x7F},
    /* 0x8B */ {0xA9, 0x53, 0xEB},
    /* 0x8B */ {0xAA, 0x55, 0xAC},
    /* 0x8B */ {0xAB, 0x58, 0x83},
    /* 0x8B */ {0xAC, 0x5C, 0xE1},
    /* 0x8B */ {0xAD, 0x5F, 0x37},
    /* 0x8B */ {0xAE, 0x5F, 0x4A},
    /* 0x8B */ {0xAF, 0x60, 0x2F},
    /* 0x8B */ {0xB0, 0x60, 0x50},
    /* 0x8B */ {0xB1, 0x60, 0x6D},
    /* 0x8B */ {0xB2, 0x63, 0x1F},
    /* 0x8B */ {0xB3, 0x65, 0x59},
    /* 0x8B */ {0xB4, 0x6A, 0x4B},
    /* 0x8B */ {0xB5, 0x6C, 0xC1},
    /* 0x8B */ {0xB6, 0x72, 0xC2},
    /* 0x8B */ {0xB7, 0x72, 0xED},
    /* 0x8B */ {0xB8, 0x77, 0xEF},
    /* 0x8B */ {0xB9, 0x80, 0xF8},
    /* 0x8B */ {0xBA, 0x81, 0x05},
    /* 0x8B */ {0xBB, 0x82, 0x08},
    /* 0x8B */ {0xBC, 0x85, 0x4E},
    /* 0x8B */ {0xBD, 0x90, 0xF7},
    /* 0x8B */ {0xBE, 0x93, 0xE1},
    /* 0x8B */ {0xBF, 0x97, 0xFF},
    /* 0x8B */ {0xC0, 0x99, 0x57},
    /* 0x8B */ {0xC1, 0x9A, 0x5A},
    /* 0x8B */ {0xC2, 0x4E, 0xF0},
    /* 0x8B */ {0xC3, 0x51, 0xDD},
    /* 0x8B */ {0xC4, 0x5C, 0x2D},
    /* 0x8B */ {0xC5, 0x66, 0x81},
    /* 0x8B */ {0xC6, 0x69, 0x6D},
    /* 0x8B */ {0xC7, 0x5C, 0x40},
    /* 0x8B */ {0xC8, 0x66, 0xF2},
    /* 0x8B */ {0xC9, 0x69, 0x75},
    /* 0x8B */ {0xCA, 0x73, 0x89},
    /* 0x8B */ {0xCB, 0x68, 0x50},
    /* 0x8B */ {0xCC, 0x7C, 0x81},
    /* 0x8B */ {0xCD, 0x50, 0xC5},
    /* 0x8B */ {0xCE, 0x52, 0xE4},
    /* 0x8B */ {0xCF, 0x57, 0x47},
    /* 0x8B */ {0xD0, 0x5D, 0xFE},
    /* 0x8B */ {0xD1, 0x93, 0x26},
    /* 0x8B */ {0xD2, 0x65, 0xA4},
    /* 0x8B */ {0xD3, 0x6B, 0x23},
    /* 0x8B */ {0xD4, 0x6B, 0x3D},
    /* 0x8B */ {0xD5, 0x74, 0x34},
    /* 0x8B */ {0xD6, 0x79, 0x81},
    /* 0x8B */ {0xD7, 0x79, 0xBD},
    /* 0x8B */ {0xD8, 0x7B, 0x4B},
    /* 0x8B */ {0xD9, 0x7D, 0xCA},
    /* 0x8B */ {0xDA, 0x82, 0xB9},
    /* 0x8B */ {0xDB, 0x83, 0xCC},
    /* 0x8B */ {0xDC, 0x88, 0x7F},
    /* 0x8B */ {0xDD, 0x89, 0x5F},
    /* 0x8B */ {0xDE, 0x8B, 0x39},
    /* 0x8B */ {0xDF, 0x8F, 0xD1},
    /* 0x8B */ {0xE0, 0x91, 0xD1},
    /* 0x8B */ {0xE1, 0x54, 0x1F},
    /* 0x8B */ {0xE2, 0x92, 0x80},
    /* 0x8B */ {0xE3, 0x4E, 0x5D},
    /* 0x8B */ {0xE4, 0x50, 0x36},
    /* 0x8B */ {0xE5, 0x53, 0xE5},
    /* 0x8B */ {0xE6, 0x53, 0x3A},
    /* 0x8B */ {0xE7, 0x72, 0xD7},
    /* 0x8B */ {0xE8, 0x73, 0x96},
    /* 0x8B */ {0xE9, 0x77, 0xE9},
    /* 0x8B */ {0xEA, 0x82, 0xE6},
    /* 0x8B */ {0xEB, 0x8E, 0xAF},
    /* 0x8B */ {0xEC, 0x99, 0xC6},
    /* 0x8B */ {0xED, 0x99, 0xC8},
    /* 0x8B */ {0xEE, 0x99, 0xD2},
    /* 0x8B */ {0xEF, 0x51, 0x77},
    /* 0x8B */ {0xF0, 0x61, 0x1A},
    /* 0x8B */ {0xF1, 0x86, 0x5E},
    /* 0x8B */ {0xF2, 0x55, 0xB0},
    /* 0x8B */ {0xF3, 0x7A, 0x7A},
    /* 0x8B */ {0xF4, 0x50, 0x76},
    /* 0x8B */ {0xF5, 0x5B, 0xD3},
    /* 0x8B */ {0xF6, 0x90, 0x47},
    /* 0x8B */ {0xF7, 0x96, 0x85},
    /* 0x8B */ {0xF8, 0x4E, 0x32},
    /* 0x8B */ {0xF9, 0x6A, 0xDB},
    /* 0x8B */ {0xFA, 0x91, 0xE7},
    /* 0x8B */ {0xFB, 0x5C, 0x51},
    /* 0x8B */ {0xFC, 0x5C, 0x48},
    /* 0x8C */ {0x40, 0x63, 0x98},
    /* 0x8C */ {0x41, 0x7A, 0x9F},
    /* 0x8C */ {0x42, 0x6C, 0x93},
    /* 0x8C */ {0x43, 0x97, 0x74},
    /* 0x8C */ {0x44, 0x8F, 0x61},
    /* 0x8C */ {0x45, 0x7A, 0xAA},
    /* 0x8C */ {0x46, 0x71, 0x8A},
    /* 0x8C */ {0x47, 0x96, 0x88},
    /* 0x8C */ {0x48, 0x7C, 0x82},
    /* 0x8C */ {0x49, 0x68, 0x17},
    /* 0x8C */ {0x4A, 0x7E, 0x70},
    /* 0x8C */ {0x4B, 0x68, 0x51},
    /* 0x8C */ {0x4C, 0x93, 0x6C},
    /* 0x8C */ {0x4D, 0x52, 0xF2},
    /* 0x8C */ {0x4E, 0x54, 0x1B},
    /* 0x8C */ {0x4F, 0x85, 0xAB},
    /* 0x8C */ {0x50, 0x8A, 0x13},
    /* 0x8C */ {0x51, 0x7F, 0xA4},
    /* 0x8C */ {0x52, 0x8E, 0xCD},
    /* 0x8C */ {0x53, 0x90, 0xE1},
    /* 0x8C */ {0x54, 0x53, 0x66},
    /* 0x8C */ {0x55, 0x88, 0x88},
    /* 0x8C */ {0x56, 0x79, 0x41},
    /* 0x8C */ {0x57, 0x4F, 0xC2},
    /* 0x8C */ {0x58, 0x50, 0xBE},
    /* 0x8C */ {0x59, 0x52, 0x11},
    /* 0x8C */ {0x5A, 0x51, 0x44},
    /* 0x8C */ {0x5B, 0x55, 0x53},
    /* 0x8C */ {0x5C, 0x57, 0x2D},
    /* 0x8C */ {0x5D, 0x73, 0xEA},
    /* 0x8C */ {0x5E, 0x57, 0x8B},
    /* 0x8C */ {0x5F, 0x59, 0x51},
    /* 0x8C */ {0x60, 0x5F, 0x62},
    /* 0x8C */ {0x61, 0x5F, 0x84},
    /* 0x8C */ {0x62, 0x60, 0x75},
    /* 0x8C */ {0x63, 0x61, 0x76},
    /* 0x8C */ {0x64, 0x61, 0x67},
    /* 0x8C */ {0x65, 0x61, 0xA9},
    /* 0x8C */ {0x66, 0x63, 0xB2},
    /* 0x8C */ {0x67, 0x64, 0x3A},
    /* 0x8C */ {0x68, 0x65, 0x6C},
    /* 0x8C */ {0x69, 0x66, 0x6F},
    /* 0x8C */ {0x6A, 0x68, 0x42},
    /* 0x8C */ {0x6B, 0x6E, 0x13},
    /* 0x8C */ {0x6C, 0x75, 0x66},
    /* 0x8C */ {0x6D, 0x7A, 0x3D},
    /* 0x8C */ {0x6E, 0x7C, 0xFB},
    /* 0x8C */ {0x6F, 0x7D, 0x4C},
    /* 0x8C */ {0x70, 0x7D, 0x99},
    /* 0x8C */ {0x71, 0x7E, 0x4B},
    /* 0x8C */ {0x72, 0x7F, 0x6B},
    /* 0x8C */ {0x73, 0x83, 0x0E},
    /* 0x8C */ {0x74, 0x83, 0x4A},
    /* 0x8C */ {0x75, 0x86, 0xCD},
    /* 0x8C */ {0x76, 0x8A, 0x08},
    /* 0x8C */ {0x77, 0x8A, 0x63},
    /* 0x8C */ {0x78, 0x8B, 0x66},
    /* 0x8C */ {0x79, 0x8E, 0xFD},
    /* 0x8C */ {0x7A, 0x98, 0x1A},
    /* 0x8C */ {0x7B, 0x9D, 0x8F},
    /* 0x8C */ {0x7C, 0x82, 0xB8},
    /* 0x8C */ {0x7D, 0x8F, 0xCE},
    /* 0x8C */ {0x7E, 0x9B, 0xE8},
    /* 0x8C */ {0x80, 0x52, 0x87},
    /* 0x8C */ {0x81, 0x62, 0x1F},
    /* 0x8C */ {0x82, 0x64, 0x83},
    /* 0x8C */ {0x83, 0x6F, 0xC0},
    /* 0x8C */ {0x84, 0x96, 0x99},
    /* 0x8C */ {0x85, 0x68, 0x41},
    /* 0x8C */ {0x86, 0x50, 0x91},
    /* 0x8C */ {0x87, 0x6B, 0x20},
    /* 0x8C */ {0x88, 0x6C, 0x7A},
    /* 0x8C */ {0x89, 0x6F, 0x54},
    /* 0x8C */ {0x8A, 0x7A, 0x74},
    /* 0x8C */ {0x8B, 0x7D, 0x50},
    /* 0x8C */ {0x8C, 0x88, 0x40},
    /* 0x8C */ {0x8D, 0x8A, 0x23},
    /* 0x8C */ {0x8E, 0x67, 0x08},
    /* 0x8C */ {0x8F, 0x4E, 0xF6},
    /* 0x8C */ {0x90, 0x50, 0x39},
    /* 0x8C */ {0x91, 0x50, 0x26},
    /* 0x8C */ {0x92, 0x50, 0x65},
    /* 0x8C */ {0x93, 0x51, 0x7C},
    /* 0x8C */ {0x94, 0x52, 0x38},
    /* 0x8C */ {0x95, 0x52, 0x63},
    /* 0x8C */ {0x96, 0x55, 0xA7},
    /* 0x8C */ {0x97, 0x57, 0x0F},
    /* 0x8C */ {0x98, 0x58, 0x05},
    /* 0x8C */ {0x99, 0x5A, 0xCC},
    /* 0x8C */ {0x9A, 0x5E, 0xFA},
    /* 0x8C */ {0x9B, 0x61, 0xB2},
    /* 0x8C */ {0x9C, 0x61, 0xF8},
    /* 0x8C */ {0x9D, 0x62, 0xF3},
    /* 0x8C */ {0x9E, 0x63, 0x72},
    /* 0x8C */ {0x9F, 0x69, 0x1C},
    /* 0x8C */ {0xA0, 0x6A, 0x29},
    /* 0x8C */ {0xA1, 0x72, 0x7D},
    /* 0x8C */ {0xA2, 0x72, 0xAC},
    /* 0x8C */ {0xA3, 0x73, 0x2E},
    /* 0x8C */ {0xA4, 0x78, 0x14},
    /* 0x8C */ {0xA5, 0x78, 0x6F},
    /* 0x8C */ {0xA6, 0x7D, 0x79},
    /* 0x8C */ {0xA7, 0x77, 0x0C},
    /* 0x8C */ {0xA8, 0x80, 0xA9},
    /* 0x8C */ {0xA9, 0x89, 0x8B},
    /* 0x8C */ {0xAA, 0x8B, 0x19},
    /* 0x8C */ {0xAB, 0x8C, 0xE2},
    /* 0x8C */ {0xAC, 0x8E, 0xD2},
    /* 0x8C */ {0xAD, 0x90, 0x63},
    /* 0x8C */ {0xAE, 0x93, 0x75},
    /* 0x8C */ {0xAF, 0x96, 0x7A},
    /* 0x8C */ {0xB0, 0x98, 0x55},
    /* 0x8C */ {0xB1, 0x9A, 0x13},
    /* 0x8C */ {0xB2, 0x9E, 0x78},
    /* 0x8C */ {0xB3, 0x51, 0x43},
    /* 0x8C */ {0xB4, 0x53, 0x9F},
    /* 0x8C */ {0xB5, 0x53, 0xB3},
    /* 0x8C */ {0xB6, 0x5E, 0x7B},
    /* 0x8C */ {0xB7, 0x5F, 0x26},
    /* 0x8C */ {0xB8, 0x6E, 0x1B},
    /* 0x8C */ {0xB9, 0x6E, 0x90},
    /* 0x8C */ {0xBA, 0x73, 0x84},
    /* 0x8C */ {0xBB, 0x73, 0xFE},
    /* 0x8C */ {0xBC, 0x7D, 0x43},
    /* 0x8C */ {0xBD, 0x82, 0x37},
    /* 0x8C */ {0xBE, 0x8A, 0x00},
    /* 0x8C */ {0xBF, 0x8A, 0xFA},
    /* 0x8C */ {0xC0, 0x96, 0x50},
    /* 0x8C */ {0xC1, 0x4E, 0x4E},
    /* 0x8C */ {0xC2, 0x50, 0x0B},
    /* 0x8C */ {0xC3, 0x53, 0xE4},
    /* 0x8C */ {0xC4, 0x54, 0x7C},
    /* 0x8C */ {0xC5, 0x56, 0xFA},
    /* 0x8C */ {0xC6, 0x59, 0xD1},
    /* 0x8C */ {0xC7, 0x5B, 0x64},
    /* 0x8C */ {0xC8, 0x5D, 0xF1},
    /* 0x8C */ {0xC9, 0x5E, 0xAB},
    /* 0x8C */ {0xCA, 0x5F, 0x27},
    /* 0x8C */ {0xCB, 0x62, 0x38},
    /* 0x8C */ {0xCC, 0x65, 0x45},
    /* 0x8C */ {0xCD, 0x67, 0xAF},
    /* 0x8C */ {0xCE, 0x6E, 0x56},
    /* 0x8C */ {0xCF, 0x72, 0xD0},
    /* 0x8C */ {0xD0, 0x7C, 0xCA},
    /* 0x8C */ {0xD1, 0x88, 0xB4},
    /* 0x8C */ {0xD2, 0x80, 0xA1},
    /* 0x8C */ {0xD3, 0x80, 0xE1},
    /* 0x8C */ {0xD4, 0x83, 0xF0},
    /* 0x8C */ {0xD5, 0x86, 0x4E},
    /* 0x8C */ {0xD6, 0x8A, 0x87},
    /* 0x8C */ {0xD7, 0x8D, 0xE8},
    /* 0x8C */ {0xD8, 0x92, 0x37},
    /* 0x8C */ {0xD9, 0x96, 0xC7},
    /* 0x8C */ {0xDA, 0x98, 0x67},
    /* 0x8C */ {0xDB, 0x9F, 0x13},
    /* 0x8C */ {0xDC, 0x4E, 0x94},
    /* 0x8C */ {0xDD, 0x4E, 0x92},
    /* 0x8C */ {0xDE, 0x4F, 0x0D},
    /* 0x8C */ {0xDF, 0x53, 0x48},
    /* 0x8C */ {0xE0, 0x54, 0x49},
    /* 0x8C */ {0xE1, 0x54, 0x3E},
    /* 0x8C */ {0xE2, 0x5A, 0x2F},
    /* 0x8C */ {0xE3, 0x5F, 0x8C},
    /* 0x8C */ {0xE4, 0x5F, 0xA1},
    /* 0x8C */ {0xE5, 0x60, 0x9F},
    /* 0x8C */ {0xE6, 0x68, 0xA7},
    /* 0x8C */ {0xE7, 0x6A, 0x8E},
    /* 0x8C */ {0xE8, 0x74, 0x5A},
    /* 0x8C */ {0xE9, 0x78, 0x81},
    /* 0x8C */ {0xEA, 0x8A, 0x9E},
    /* 0x8C */ {0xEB, 0x8A, 0xA4},
    /* 0x8C */ {0xEC, 0x8B, 0x77},
    /* 0x8C */ {0xED, 0x91, 0x90},
    /* 0x8C */ {0xEE, 0x4E, 0x5E},
    /* 0x8C */ {0xEF, 0x9B, 0xC9},
    /* 0x8C */ {0xF0, 0x4E, 0xA4},
    /* 0x8C */ {0xF1, 0x4F, 0x7C},
    /* 0x8C */ {0xF2, 0x4F, 0xAF},
    /* 0x8C */ {0xF3, 0x50, 0x19},
    /* 0x8C */ {0xF4, 0x50, 0x16},
    /* 0x8C */ {0xF5, 0x51, 0x49},
    /* 0x8C */ {0xF6, 0x51, 0x6C},
    /* 0x8C */ {0xF7, 0x52, 0x9F},
    /* 0x8C */ {0xF8, 0x52, 0xB9},
    /* 0x8C */ {0xF9, 0x52, 0xFE},
    /* 0x8C */ {0xFA, 0x53, 0x9A},
    /* 0x8C */ {0xFB, 0x53, 0xE3},
    /* 0x8C */ {0xFC, 0x54, 0x11},
    /* 0x8D */ {0x40, 0x54, 0x0E},
    /* 0x8D */ {0x41, 0x55, 0x89},
    /* 0x8D */ {0x42, 0x57, 0x51},
    /* 0x8D */ {0x43, 0x57, 0xA2},
    /* 0x8D */ {0x44, 0x59, 0x7D},
    /* 0x8D */ {0x45, 0x5B, 0x54},
    /* 0x8D */ {0x46, 0x5B, 0x5D},
    /* 0x8D */ {0x47, 0x5B, 0x8F},
    /* 0x8D */ {0x48, 0x5D, 0xE5},
    /* 0x8D */ {0x49, 0x5D, 0xE7},
    /* 0x8D */ {0x4A, 0x5D, 0xF7},
    /* 0x8D */ {0x4B, 0x5E, 0x78},
    /* 0x8D */ {0x4C, 0x5E, 0x83},
    /* 0x8D */ {0x4D, 0x5E, 0x9A},
    /* 0x8D */ {0x4E, 0x5E, 0xB7},
    /* 0x8D */ {0x4F, 0x5F, 0x18},
    /* 0x8D */ {0x50, 0x60, 0x52},
    /* 0x8D */ {0x51, 0x61, 0x4C},
    /* 0x8D */ {0x52, 0x62, 0x97},
    /* 0x8D */ {0x53, 0x62, 0xD8},
    /* 0x8D */ {0x54, 0x63, 0xA7},
    /* 0x8D */ {0x55, 0x65, 0x3B},
    /* 0x8D */ {0x56, 0x66, 0x02},
    /* 0x8D */ {0x57, 0x66, 0x43},
    /* 0x8D */ {0x58, 0x66, 0xF4},
    /* 0x8D */ {0x59, 0x67, 0x6D},
    /* 0x8D */ {0x5A, 0x68, 0x21},
    /* 0x8D */ {0x5B, 0x68, 0x97},
    /* 0x8D */ {0x5C, 0x69, 0xCB},
    /* 0x8D */ {0x5D, 0x6C, 0x5F},
    /* 0x8D */ {0x5E, 0x6D, 0x2A},
    /* 0x8D */ {0x5F, 0x6D, 0x69},
    /* 0x8D */ {0x60, 0x6E, 0x2F},
    /* 0x8D */ {0x61, 0x6E, 0x9D},
    /* 0x8D */ {0x62, 0x75, 0x32},
    /* 0x8D */ {0x63, 0x76, 0x87},
    /* 0x8D */ {0x64, 0x78, 0x6C},
    /* 0x8D */ {0x65, 0x7A, 0x3F},
    /* 0x8D */ {0x66, 0x7C, 0xE0},
    /* 0x8D */ {0x67, 0x7D, 0x05},
    /* 0x8D */ {0x68, 0x7D, 0x18},
    /* 0x8D */ {0x69, 0x7D, 0x5E},
    /* 0x8D */ {0x6A, 0x7D, 0xB1},
    /* 0x8D */ {0x6B, 0x80, 0x15},
    /* 0x8D */ {0x6C, 0x80, 0x03},
    /* 0x8D */ {0x6D, 0x80, 0xAF},
    /* 0x8D */ {0x6E, 0x80, 0xB1},
    /* 0x8D */ {0x6F, 0x81, 0x54},
    /* 0x8D */ {0x70, 0x81, 0x8F},
    /* 0x8D */ {0x71, 0x82, 0x2A},
    /* 0x8D */ {0x72, 0x83, 0x52},
    /* 0x8D */ {0x73, 0x88, 0x4C},
    /* 0x8D */ {0x74, 0x88, 0x61},
    /* 0x8D */ {0x75, 0x8B, 0x1B},
    /* 0x8D */ {0x76, 0x8C, 0xA2},
    /* 0x8D */ {0x77, 0x8C, 0xFC},
    /* 0x8D */ {0x78, 0x90, 0xCA},
    /* 0x8D */ {0x79, 0x91, 0x75},
    /* 0x8D */ {0x7A, 0x92, 0x71},
    /* 0x8D */ {0x7B, 0x78, 0x3F},
    /* 0x8D */ {0x7C, 0x92, 0xFC},
    /* 0x8D */ {0x7D, 0x95, 0xA4},
    /* 0x8D */ {0x7E, 0x96, 0x4D},
    /* 0x8D */ {0x80, 0x98, 0x05},
    /* 0x8D */ {0x81, 0x99, 0x99},
    /* 0x8D */ {0x82, 0x9A, 0xD8},
    /* 0x8D */ {0x83, 0x9D, 0x3B},
    /* 0x8D */ {0x84, 0x52, 0x5B},
    /* 0x8D */ {0x85, 0x52, 0xAB},
    /* 0x8D */ {0x86, 0x53, 0xF7},
    /* 0x8D */ {0x87, 0x54, 0x08},
    /* 0x8D */ {0x88, 0x58, 0xD5},
    /* 0x8D */ {0x89, 0x62, 0xF7},
    /* 0x8D */ {0x8A, 0x6F, 0xE0},
    /* 0x8D */ {0x8B, 0x8C, 0x6A},
    /* 0x8D */ {0x8C, 0x8F, 0x5F},
    /* 0x8D */ {0x8D, 0x9E, 0xB9},
    /* 0x8D */ {0x8E, 0x51, 0x4B},
    /* 0x8D */ {0x8F, 0x52, 0x3B},
    /* 0x8D */ {0x90, 0x54, 0x4A},
    /* 0x8D */ {0x91, 0x56, 0xFD},
    /* 0x8D */ {0x92, 0x7A, 0x40},
    /* 0x8D */ {0x93, 0x91, 0x77},
    /* 0x8D */ {0x94, 0x9D, 0x60},
    /* 0x8D */ {0x95, 0x9E, 0xD2},
    /* 0x8D */ {0x96, 0x73, 0x44},
    /* 0x8D */ {0x97, 0x6F, 0x09},
    /* 0x8D */ {0x98, 0x81, 0x70},
    /* 0x8D */ {0x99, 0x75, 0x11},
    /* 0x8D */ {0x9A, 0x5F, 0xFD},
    /* 0x8D */ {0x9B, 0x60, 0xDA},
    /* 0x8D */ {0x9C, 0x9A, 0xA8},
    /* 0x8D */ {0x9D, 0x72, 0xDB},
    /* 0x8D */ {0x9E, 0x8F, 0xBC},
    /* 0x8D */ {0x9F, 0x6B, 0x64},
    /* 0x8D */ {0xA0, 0x98, 0x03},
    /* 0x8D */ {0xA1, 0x4E, 0xCA},
    /* 0x8D */ {0xA2, 0x56, 0xF0},
    /* 0x8D */ {0xA3, 0x57, 0x64},
    /* 0x8D */ {0xA4, 0x58, 0xBE},
    /* 0x8D */ {0xA5, 0x5A, 0x5A},
    /* 0x8D */ {0xA6, 0x60, 0x68},
    /* 0x8D */ {0xA7, 0x61, 0xC7},
    /* 0x8D */ {0xA8, 0x66, 0x0F},
    /* 0x8D */ {0xA9, 0x66, 0x06},
    /* 0x8D */ {0xAA, 0x68, 0x39},
    /* 0x8D */ {0xAB, 0x68, 0xB1},
    /* 0x8D */ {0xAC, 0x6D, 0xF7},
    /* 0x8D */ {0xAD, 0x75, 0xD5},
    /* 0x8D */ {0xAE, 0x7D, 0x3A},
    /* 0x8D */ {0xAF, 0x82, 0x6E},
    /* 0x8D */ {0xB0, 0x9B, 0x42},
    /* 0x8D */ {0xB1, 0x4E, 0x9B},
    /* 0x8D */ {0xB2, 0x4F, 0x50},
    /* 0x8D */ {0xB3, 0x53, 0xC9},
    /* 0x8D */ {0xB4, 0x55, 0x06},
    /* 0x8D */ {0xB5, 0x5D, 0x6F},
    /* 0x8D */ {0xB6, 0x5D, 0xE6},
    /* 0x8D */ {0xB7, 0x5D, 0xEE},
    /* 0x8D */ {0xB8, 0x67, 0xFB},
    /* 0x8D */ {0xB9, 0x6C, 0x99},
    /* 0x8D */ {0xBA, 0x74, 0x73},
    /* 0x8D */ {0xBB, 0x78, 0x02},
    /* 0x8D */ {0xBC, 0x8A, 0x50},
    /* 0x8D */ {0xBD, 0x93, 0x96},
    /* 0x8D */ {0xBE, 0x88, 0xDF},
    /* 0x8D */ {0xBF, 0x57, 0x50},
    /* 0x8D */ {0xC0, 0x5E, 0xA7},
    /* 0x8D */ {0xC1, 0x63, 0x2B},
    /* 0x8D */ {0xC2, 0x50, 0xB5},
    /* 0x8D */ {0xC3, 0x50, 0xAC},
    /* 0x8D */ {0xC4, 0x51, 0x8D},
    /* 0x8D */ {0xC5, 0x67, 0x00},
    /* 0x8D */ {0xC6, 0x54, 0xC9},
    /* 0x8D */ {0xC7, 0x58, 0x5E},
    /* 0x8D */ {0xC8, 0x59, 0xBB},
    /* 0x8D */ {0xC9, 0x5B, 0xB0},
    /* 0x8D */ {0xCA, 0x5F, 0x69},
    /* 0x8D */ {0xCB, 0x62, 0x4D},
    /* 0x8D */ {0xCC, 0x63, 0xA1},
    /* 0x8D */ {0xCD, 0x68, 0x3D},
    /* 0x8D */ {0xCE, 0x6B, 0x73},
    /* 0x8D */ {0xCF, 0x6E, 0x08},
    /* 0x8D */ {0xD0, 0x70, 0x7D},
    /* 0x8D */ {0xD1, 0x91, 0xC7},
    /* 0x8D */ {0xD2, 0x72, 0x80},
    /* 0x8D */ {0xD3, 0x78, 0x15},
    /* 0x8D */ {0xD4, 0x78, 0x26},
    /* 0x8D */ {0xD5, 0x79, 0x6D},
    /* 0x8D */ {0xD6, 0x65, 0x8E},
    /* 0x8D */ {0xD7, 0x7D, 0x30},
    /* 0x8D */ {0xD8, 0x83, 0xDC},
    /* 0x8D */ {0xD9, 0x88, 0xC1},
    /* 0x8D */ {0xDA, 0x8F, 0x09},
    /* 0x8D */ {0xDB, 0x96, 0x9B},
    /* 0x8D */ {0xDC, 0x52, 0x64},
    /* 0x8D */ {0xDD, 0x57, 0x28},
    /* 0x8D */ {0xDE, 0x67, 0x50},
    /* 0x8D */ {0xDF, 0x7F, 0x6A},
    /* 0x8D */ {0xE0, 0x8C, 0xA1},
    /* 0x8D */ {0xE1, 0x51, 0xB4},
    /* 0x8D */ {0xE2, 0x57, 0x42},
    /* 0x8D */ {0xE3, 0x96, 0x2A},
    /* 0x8D */ {0xE4, 0x58, 0x3A},
    /* 0x8D */ {0xE5, 0x69, 0x8A},
    /* 0x8D */ {0xE6, 0x80, 0xB4},
    /* 0x8D */ {0xE7, 0x54, 0xB2},
    /* 0x8D */ {0xE8, 0x5D, 0x0E},
    /* 0x8D */ {0xE9, 0x57, 0xFC},
    /* 0x8D */ {0xEA, 0x78, 0x95},
    /* 0x8D */ {0xEB, 0x9D, 0xFA},
    /* 0x8D */ {0xEC, 0x4F, 0x5C},
    /* 0x8D */ {0xED, 0x52, 0x4A},
    /* 0x8D */ {0xEE, 0x54, 0x8B},
    /* 0x8D */ {0xEF, 0x64, 0x3E},
    /* 0x8D */ {0xF0, 0x66, 0x28},
    /* 0x8D */ {0xF1, 0x67, 0x14},
    /* 0x8D */ {0xF2, 0x67, 0xF5},
    /* 0x8D */ {0xF3, 0x7A, 0x84},
    /* 0x8D */ {0xF4, 0x7B, 0x56},
    /* 0x8D */ {0xF5, 0x7D, 0x22},
    /* 0x8D */ {0xF6, 0x93, 0x2F},
    /* 0x8D */ {0xF7, 0x68, 0x5C},
    /* 0x8D */ {0xF8, 0x9B, 0xAD},
    /* 0x8D */ {0xF9, 0x7B, 0x39},
    /* 0x8D */ {0xFA, 0x53, 0x19},
    /* 0x8D */ {0xFB, 0x51, 0x8A},
    /* 0x8D */ {0xFC, 0x52, 0x37},
    /* 0x8E */ {0x40, 0x5B, 0xDF},
    /* 0x8E */ {0x41, 0x62, 0xF6},
    /* 0x8E */ {0x42, 0x64, 0xAE},
    /* 0x8E */ {0x43, 0x64, 0xE6},
    /* 0x8E */ {0x44, 0x67, 0x2D},
    /* 0x8E */ {0x45, 0x6B, 0xBA},
    /* 0x8E */ {0x46, 0x85, 0xA9},
    /* 0x8E */ {0x47, 0x96, 0xD1},
    /* 0x8E */ {0x48, 0x76, 0x90},
    /* 0x8E */ {0x49, 0x9B, 0xD6},
    /* 0x8E */ {0x4A, 0x63, 0x4C},
    /* 0x8E */ {0x4B, 0x93, 0x06},
    /* 0x8E */ {0x4C, 0x9B, 0xAB},
    /* 0x8E */ {0x4D, 0x76, 0xBF},
    /* 0x8E */ {0x4E, 0x66, 0x52},
    /* 0x8E */ {0x4F, 0x4E, 0x09},
    /* 0x8E */ {0x50, 0x50, 0x98},
    /* 0x8E */ {0x51, 0x53, 0xC2},
    /* 0x8E */ {0x52, 0x5C, 0x71},
    /* 0x8E */ {0x53, 0x60, 0xE8},
    /* 0x8E */ {0x54, 0x64, 0x92},
    /* 0x8E */ {0x55, 0x65, 0x63},
    /* 0x8E */ {0x56, 0x68, 0x5F},
    /* 0x8E */ {0x57, 0x71, 0xE6},
    /* 0x8E */ {0x58, 0x73, 0xCA},
    /* 0x8E */ {0x59, 0x75, 0x23},
    /* 0x8E */ {0x5A, 0x7B, 0x97},
    /* 0x8E */ {0x5B, 0x7E, 0x82},
    /* 0x8E */ {0x5C, 0x86, 0x95},
    /* 0x8E */ {0x5D, 0x8B, 0x83},
    /* 0x8E */ {0x5E, 0x8C, 0xDB},
    /* 0x8E */ {0x5F, 0x91, 0x78},
    /* 0x8E */ {0x60, 0x99, 0x10},
    /* 0x8E */ {0x61, 0x65, 0xAC},
    /* 0x8E */ {0x62, 0x66, 0xAB},
    /* 0x8E */ {0x63, 0x6B, 0x8B},
    /* 0x8E */ {0x64, 0x4E, 0xD5},
    /* 0x8E */ {0x65, 0x4E, 0xD4},
    /* 0x8E */ {0x66, 0x4F, 0x3A},
    /* 0x8E */ {0x67, 0x4F, 0x7F},
    /* 0x8E */ {0x68, 0x52, 0x3A},
    /* 0x8E */ {0x69, 0x53, 0xF8},
    /* 0x8E */ {0x6A, 0x53, 0xF2},
    /* 0x8E */ {0x6B, 0x55, 0xE3},
    /* 0x8E */ {0x6C, 0x56, 0xDB},
    /* 0x8E */ {0x6D, 0x58, 0xEB},
    /* 0x8E */ {0x6E, 0x59, 0xCB},
    /* 0x8E */ {0x6F, 0x59, 0xC9},
    /* 0x8E */ {0x70, 0x59, 0xFF},
    /* 0x8E */ {0x71, 0x5B, 0x50},
    /* 0x8E */ {0x72, 0x5C, 0x4D},
    /* 0x8E */ {0x73, 0x5E, 0x02},
    /* 0x8E */ {0x74, 0x5E, 0x2B},
    /* 0x8E */ {0x75, 0x5F, 0xD7},
    /* 0x8E */ {0x76, 0x60, 0x1D},
    /* 0x8E */ {0x77, 0x63, 0x07},
    /* 0x8E */ {0x78, 0x65, 0x2F},
    /* 0x8E */ {0x79, 0x5B, 0x5C},
    /* 0x8E */ {0x7A, 0x65, 0xAF},
    /* 0x8E */ {0x7B, 0x65, 0xBD},
    /* 0x8E */ {0x7C, 0x65, 0xE8},
    /* 0x8E */ {0x7D, 0x67, 0x9D},
    /* 0x8E */ {0x7E, 0x6B, 0x62},
    /* 0x8E */ {0x80, 0x6B, 0x7B},
    /* 0x8E */ {0x81, 0x6C, 0x0F},
    /* 0x8E */ {0x82, 0x73, 0x45},
    /* 0x8E */ {0x83, 0x79, 0x49},
    /* 0x8E */ {0x84, 0x79, 0xC1},
    /* 0x8E */ {0x85, 0x7C, 0xF8},
    /* 0x8E */ {0x86, 0x7D, 0x19},
    /* 0x8E */ {0x87, 0x7D, 0x2B},
    /* 0x8E */ {0x88, 0x80, 0xA2},
    /* 0x8E */ {0x89, 0x81, 0x02},
    /* 0x8E */ {0x8A, 0x81, 0xF3},
    /* 0x8E */ {0x8B, 0x89, 0x96},
    /* 0x8E */ {0x8C, 0x8A, 0x5E},
    /* 0x8E */ {0x8D, 0x8A, 0x69},
    /* 0x8E */ {0x8E, 0x8A, 0x66},
    /* 0x8E */ {0x8F, 0x8A, 0x8C},
    /* 0x8E */ {0x90, 0x8A, 0xEE},
    /* 0x8E */ {0x91, 0x8C, 0xC7},
    /* 0x8E */ {0x92, 0x8C, 0xDC},
    /* 0x8E */ {0x93, 0x96, 0xCC},
    /* 0x8E */ {0x94, 0x98, 0xFC},
    /* 0x8E */ {0x95, 0x6B, 0x6F},
    /* 0x8E */ {0x96, 0x4E, 0x8B},
    /* 0x8E */ {0x97, 0x4F, 0x3C},
    /* 0x8E */ {0x98, 0x4F, 0x8D},
    /* 0x8E */ {0x99, 0x51, 0x50},
    /* 0x8E */ {0x9A, 0x5B, 0x57},
    /* 0x8E */ {0x9B, 0x5B, 0xFA},
    /* 0x8E */ {0x9C, 0x61, 0x48},
    /* 0x8E */ {0x9D, 0x63, 0x01},
    /* 0x8E */ {0x9E, 0x66, 0x42},
    /* 0x8E */ {0x9F, 0x6B, 0x21},
    /* 0x8E */ {0xA0, 0x6E, 0xCB},
    /* 0x8E */ {0xA1, 0x6C, 0xBB},
    /* 0x8E */ {0xA2, 0x72, 0x3E},
    /* 0x8E */ {0xA3, 0x74, 0xBD},
    /* 0x8E */ {0xA4, 0x75, 0xD4},
    /* 0x8E */ {0xA5, 0x78, 0xC1},
    /* 0x8E */ {0xA6, 0x79, 0x3A},
    /* 0x8E */ {0xA7, 0x80, 0x0C},
    /* 0x8E */ {0xA8, 0x80, 0x33},
    /* 0x8E */ {0xA9, 0x81, 0xEA},
    /* 0x8E */ {0xAA, 0x84, 0x94},
    /* 0x8E */ {0xAB, 0x8F, 0x9E},
    /* 0x8E */ {0xAC, 0x6C, 0x50},
    /* 0x8E */ {0xAD, 0x9E, 0x7F},
    /* 0x8E */ {0xAE, 0x5F, 0x0F},
    /* 0x8E */ {0xAF, 0x8B, 0x58},
    /* 0x8E */ {0xB0, 0x9D, 0x2B},
    /* 0x8E */ {0xB1, 0x7A, 0xFA},
    /* 0x8E */ {0xB2, 0x8E, 0xF8},
    /* 0x8E */ {0xB3, 0x5B, 0x8D},
    /* 0x8E */ {0xB4, 0x96, 0xEB},
    /* 0x8E */ {0xB5, 0x4E, 0x03},
    /* 0x8E */ {0xB6, 0x53, 0xF1},
    /* 0x8E */ {0xB7, 0x57, 0xF7},
    /* 0x8E */ {0xB8, 0x59, 0x31},
    /* 0x8E */ {0xB9, 0x5A, 0xC9},
    /* 0x8E */ {0xBA, 0x5B, 0xA4},
    /* 0x8E */ {0xBB, 0x60, 0x89},
    /* 0x8E */ {0xBC, 0x6E, 0x7F},
    /* 0x8E */ {0xBD, 0x6F, 0x06},
    /* 0x8E */ {0xBE, 0x75, 0xBE},
    /* 0x8E */ {0xBF, 0x8C, 0xEA},
    /* 0x8E */ {0xC0, 0x5B, 0x9F},
    /* 0x8E */ {0xC1, 0x85, 0x00},
    /* 0x8E */ {0xC2, 0x7B, 0xE0},
    /* 0x8E */ {0xC3, 0x50, 0x72},
    /* 0x8E */ {0xC4, 0x67, 0xF4},
    /* 0x8E */ {0xC5, 0x82, 0x9D},
    /* 0x8E */ {0xC6, 0x5C, 0x61},
    /* 0x8E */ {0xC7, 0x85, 0x4A},
    /* 0x8E */ {0xC8, 0x7E, 0x1E},
    /* 0x8E */ {0xC9, 0x82, 0x0E},
    /* 0x8E */ {0xCA, 0x51, 0x99},
    /* 0x8E */ {0xCB, 0x5C, 0x04},
    /* 0x8E */ {0xCC, 0x63, 0x68},
    /* 0x8E */ {0xCD, 0x8D, 0x66},
    /* 0x8E */ {0xCE, 0x65, 0x9C},
    /* 0x8E */ {0xCF, 0x71, 0x6E},
    /* 0x8E */ {0xD0, 0x79, 0x3E},
    /* 0x8E */ {0xD1, 0x7D, 0x17},
    /* 0x8E */ {0xD2, 0x80, 0x05},
    /* 0x8E */ {0xD3, 0x8B, 0x1D},
    /* 0x8E */ {0xD4, 0x8E, 0xCA},
    /* 0x8E */ {0xD5, 0x90, 0x6E},
    /* 0x8E */ {0xD6, 0x86, 0xC7},
    /* 0x8E */ {0xD7, 0x90, 0xAA},
    /* 0x8E */ {0xD8, 0x50, 0x1F},
    /* 0x8E */ {0xD9, 0x52, 0xFA},
    /* 0x8E */ {0xDA, 0x5C, 0x3A},
    /* 0x8E */ {0xDB, 0x67, 0x53},
    /* 0x8E */ {0xDC, 0x70, 0x7C},
    /* 0x8E */ {0xDD, 0x72, 0x35},
    /* 0x8E */ {0xDE, 0x91, 0x4C},
    /* 0x8E */ {0xDF, 0x91, 0xC8},
    /* 0x8E */ {0xE0, 0x93, 0x2B},
    /* 0x8E */ {0xE1, 0x82, 0xE5},
    /* 0x8E */ {0xE2, 0x5B, 0xC2},
    /* 0x8E */ {0xE3, 0x5F, 0x31},
    /* 0x8E */ {0xE4, 0x60, 0xF9},
    /* 0x8E */ {0xE5, 0x4E, 0x3B},
    /* 0x8E */ {0xE6, 0x53, 0xD6},
    /* 0x8E */ {0xE7, 0x5B, 0x88},
    /* 0x8E */ {0xE8, 0x62, 0x4B},
    /* 0x8E */ {0xE9, 0x67, 0x31},
    /* 0x8E */ {0xEA, 0x6B, 0x8A},
    /* 0x8E */ {0xEB, 0x72, 0xE9},
    /* 0x8E */ {0xEC, 0x73, 0xE0},
    /* 0x8E */ {0xED, 0x7A, 0x2E},
    /* 0x8E */ {0xEE, 0x81, 0x6B},
    /* 0x8E */ {0xEF, 0x8D, 0xA3},
    /* 0x8E */ {0xF0, 0x91, 0x52},
    /* 0x8E */ {0xF1, 0x99, 0x96},
    /* 0x8E */ {0xF2, 0x51, 0x12},
    /* 0x8E */ {0xF3, 0x53, 0xD7},
    /* 0x8E */ {0xF4, 0x54, 0x6A},
    /* 0x8E */ {0xF5, 0x5B, 0xFF},
    /* 0x8E */ {0xF6, 0x63, 0x88},
    /* 0x8E */ {0xF7, 0x6A, 0x39},
    /* 0x8E */ {0xF8, 0x7D, 0xAC},
    /* 0x8E */ {0xF9, 0x97, 0x00},
    /* 0x8E */ {0xFA, 0x56, 0xDA},
    /* 0x8E */ {0xFB, 0x53, 0xCE},
    /* 0x8E */ {0xFC, 0x54, 0x68},
    /* 0x8F */ {0x40, 0x5B, 0x97},
    /* 0x8F */ {0x41, 0x5C, 0x31},
    /* 0x8F */ {0x42, 0x5D, 0xDE},
    /* 0x8F */ {0x43, 0x4F, 0xEE},
    /* 0x8F */ {0x44, 0x61, 0x01},
    /* 0x8F */ {0x45, 0x62, 0xFE},
    /* 0x8F */ {0x46, 0x6D, 0x32},
    /* 0x8F */ {0x47, 0x79, 0xC0},
    /* 0x8F */ {0x48, 0x79, 0xCB},
    /* 0x8F */ {0x49, 0x7D, 0x42},
    /* 0x8F */ {0x4A, 0x7E, 0x4D},
    /* 0x8F */ {0x4B, 0x7F, 0xD2},
    /* 0x8F */ {0x4C, 0x81, 0xED},
    /* 0x8F */ {0x4D, 0x82, 0x1F},
    /* 0x8F */ {0x4E, 0x84, 0x90},
    /* 0x8F */ {0x4F, 0x88, 0x46},
    /* 0x8F */ {0x50, 0x89, 0x72},
    /* 0x8F */ {0x51, 0x8B, 0x90},
    /* 0x8F */ {0x52, 0x8E, 0x74},
    /* 0x8F */ {0x53, 0x8F, 0x2F},
    /* 0x8F */ {0x54, 0x90, 0x31},
    /* 0x8F */ {0x55, 0x91, 0x4B},
    /* 0x8F */ {0x56, 0x91, 0x6C},
    /* 0x8F */ {0x57, 0x96, 0xC6},
    /* 0x8F */ {0x58, 0x91, 0x9C},
    /* 0x8F */ {0x59, 0x4E, 0xC0},
    /* 0x8F */ {0x5A, 0x4F, 0x4F},
    /* 0x8F */ {0x5B, 0x51, 0x45},
    /* 0x8F */ {0x5C, 0x53, 0x41},
    /* 0x8F */ {0x5D, 0x5F, 0x93},
    /* 0x8F */ {0x5E, 0x62, 0x0E},
    /* 0x8F */ {0x5F, 0x67, 0xD4},
    /* 0x8F */ {0x60, 0x6C, 0x41},
    /* 0x8F */ {0x61, 0x6E, 0x0B},
    /* 0x8F */ {0x62, 0x73, 0x63},
    /* 0x8F */ {0x63, 0x7E, 0x26},
    /* 0x8F */ {0x64, 0x91, 0xCD},
    /* 0x8F */ {0x65, 0x92, 0x83},
    /* 0x8F */ {0x66, 0x53, 0xD4},
    /* 0x8F */ {0x67, 0x59, 0x19},
    /* 0x8F */ {0x68, 0x5B, 0xBF},
    /* 0x8F */ {0x69, 0x6D, 0xD1},
    /* 0x8F */ {0x6A, 0x79, 0x5D},
    /* 0x8F */ {0x6B, 0x7E, 0x2E},
    /* 0x8F */ {0x6C, 0x7C, 0x9B},
    /* 0x8F */ {0x6D, 0x58, 0x7E},
    /* 0x8F */ {0x6E, 0x71, 0x9F},
    /* 0x8F */ {0x6F, 0x51, 0xFA},
    /* 0x8F */ {0x70, 0x88, 0x53},
    /* 0x8F */ {0x71, 0x8F, 0xF0},
    /* 0x8F */ {0x72, 0x4F, 0xCA},
    /* 0x8F */ {0x73, 0x5C, 0xFB},
    /* 0x8F */ {0x74, 0x66, 0x25},
    /* 0x8F */ {0x75, 0x77, 0xAC},
    /* 0x8F */ {0x76, 0x7A, 0xE3},
    /* 0x8F */ {0x77, 0x82, 0x1C},
    /* 0x8F */ {0x78, 0x99, 0xFF},
    /* 0x8F */ {0x79, 0x51, 0xC6},
    /* 0x8F */ {0x7A, 0x5F, 0xAA},
    /* 0x8F */ {0x7B, 0x65, 0xEC},
    /* 0x8F */ {0x7C, 0x69, 0x6F},
    /* 0x8F */ {0x7D, 0x6B, 0x89},
    /* 0x8F */ {0x7E, 0x6D, 0xF3},
    /* 0x8F */ {0x80, 0x6E, 0x96},
    /* 0x8F */ {0x81, 0x6F, 0x64},
    /* 0x8F */ {0x82, 0x76, 0xFE},
    /* 0x8F */ {0x83, 0x7D, 0x14},
    /* 0x8F */ {0x84, 0x5D, 0xE1},
    /* 0x8F */ {0x85, 0x90, 0x75},
    /* 0x8F */ {0x86, 0x91, 0x87},
    /* 0x8F */ {0x87, 0x98, 0x06},
    /* 0x8F */ {0x88, 0x51, 0xE6},
    /* 0x8F */ {0x89, 0x52, 0x1D},
    /* 0x8F */ {0x8A, 0x62, 0x40},
    /* 0x8F */ {0x8B, 0x66, 0x91},
    /* 0x8F */ {0x8C, 0x66, 0xD9},
    /* 0x8F */ {0x8D, 0x6E, 0x1A},
    /* 0x8F */ {0x8E, 0x5E, 0xB6},
    /* 0x8F */ {0x8F, 0x7D, 0xD2},
    /* 0x8F */ {0x90, 0x7F, 0x72},
    /* 0x8F */ {0x91, 0x66, 0xF8},
    /* 0x8F */ {0x92, 0x85, 0xAF},
    /* 0x8F */ {0x93, 0x85, 0xF7},
    /* 0x8F */ {0x94, 0x8A, 0xF8},
    /* 0x8F */ {0x95, 0x52, 0xA9},
    /* 0x8F */ {0x96, 0x53, 0xD9},
    /* 0x8F */ {0x97, 0x59, 0x73},
    /* 0x8F */ {0x98, 0x5E, 0x8F},
    /* 0x8F */ {0x99, 0x5F, 0x90},
    /* 0x8F */ {0x9A, 0x60, 0x55},
    /* 0x8F */ {0x9B, 0x92, 0xE4},
    /* 0x8F */ {0x9C, 0x96, 0x64},
    /* 0x8F */ {0x9D, 0x50, 0xB7},
    /* 0x8F */ {0x9E, 0x51, 0x1F},
    /* 0x8F */ {0x9F, 0x52, 0xDD},
    /* 0x8F */ {0xA0, 0x53, 0x20},
    /* 0x8F */ {0xA1, 0x53, 0x47},
    /* 0x8F */ {0xA2, 0x53, 0xEC},
    /* 0x8F */ {0xA3, 0x54, 0xE8},
    /* 0x8F */ {0xA4, 0x55, 0x46},
    /* 0x8F */ {0xA5, 0x55, 0x31},
    /* 0x8F */ {0xA6, 0x56, 0x17},
    /* 0x8F */ {0xA7, 0x59, 0x68},
    /* 0x8F */ {0xA8, 0x59, 0xBE},
    /* 0x8F */ {0xA9, 0x5A, 0x3C},
    /* 0x8F */ {0xAA, 0x5B, 0xB5},
    /* 0x8F */ {0xAB, 0x5C, 0x06},
    /* 0x8F */ {0xAC, 0x5C, 0x0F},
    /* 0x8F */ {0xAD, 0x5C, 0x11},
    /* 0x8F */ {0xAE, 0x5C, 0x1A},
    /* 0x8F */ {0xAF, 0x5E, 0x84},
    /* 0x8F */ {0xB0, 0x5E, 0x8A},
    /* 0x8F */ {0xB1, 0x5E, 0xE0},
    /* 0x8F */ {0xB2, 0x5F, 0x70},
    /* 0x8F */ {0xB3, 0x62, 0x7F},
    /* 0x8F */ {0xB4, 0x62, 0x84},
    /* 0x8F */ {0xB5, 0x62, 0xDB},
    /* 0x8F */ {0xB6, 0x63, 0x8C},
    /* 0x8F */ {0xB7, 0x63, 0x77},
    /* 0x8F */ {0xB8, 0x66, 0x07},
    /* 0x8F */ {0xB9, 0x66, 0x0C},
    /* 0x8F */ {0xBA, 0x66, 0x2D},
    /* 0x8F */ {0xBB, 0x66, 0x76},
    /* 0x8F */ {0xBC, 0x67, 0x7E},
    /* 0x8F */ {0xBD, 0x68, 0xA2},
    /* 0x8F */ {0xBE, 0x6A, 0x1F},
    /* 0x8F */ {0xBF, 0x6A, 0x35},
    /* 0x8F */ {0xC0, 0x6C, 0xBC},
    /* 0x8F */ {0xC1, 0x6D, 0x88},
    /* 0x8F */ {0xC2, 0x6E, 0x09},
    /* 0x8F */ {0xC3, 0x6E, 0x58},
    /* 0x8F */ {0xC4, 0x71, 0x3C},
    /* 0x8F */ {0xC5, 0x71, 0x26},
    /* 0x8F */ {0xC6, 0x71, 0x67},
    /* 0x8F */ {0xC7, 0x75, 0xC7},
    /* 0x8F */ {0xC8, 0x77, 0x01},
    /* 0x8F */ {0xC9, 0x78, 0x5D},
    /* 0x8F */ {0xCA, 0x79, 0x01},
    /* 0x8F */ {0xCB, 0x79, 0x65},
    /* 0x8F */ {0xCC, 0x79, 0xF0},
    /* 0x8F */ {0xCD, 0x7A, 0xE0},
    /* 0x8F */ {0xCE, 0x7B, 0x11},
    /* 0x8F */ {0xCF, 0x7C, 0xA7},
    /* 0x8F */ {0xD0, 0x7D, 0x39},
    /* 0x8F */ {0xD1, 0x80, 0x96},
    /* 0x8F */ {0xD2, 0x83, 0xD6},
    /* 0x8F */ {0xD3, 0x84, 0x8B},
    /* 0x8F */ {0xD4, 0x85, 0x49},
    /* 0x8F */ {0xD5, 0x88, 0x5D},
    /* 0x8F */ {0xD6, 0x88, 0xF3},
    /* 0x8F */ {0xD7, 0x8A, 0x1F},
    /* 0x8F */ {0xD8, 0x8A, 0x3C},
    /* 0x8F */ {0xD9, 0x8A, 0x54},
    /* 0x8F */ {0xDA, 0x8A, 0x73},
    /* 0x8F */ {0xDB, 0x8C, 0x61},
    /* 0x8F */ {0xDC, 0x8C, 0xDE},
    /* 0x8F */ {0xDD, 0x91, 0xA4},
    /* 0x8F */ {0xDE, 0x92, 0x66},
    /* 0x8F */ {0xDF, 0x93, 0x7E},
    /* 0x8F */ {0xE0, 0x94, 0x18},
    /* 0x8F */ {0xE1, 0x96, 0x9C},
    /* 0x8F */ {0xE2, 0x97, 0x98},
    /* 0x8F */ {0xE3, 0x4E, 0x0A},
    /* 0x8F */ {0xE4, 0x4E, 0x08},
    /* 0x8F */ {0xE5, 0x4E, 0x1E},
    /* 0x8F */ {0xE6, 0x4E, 0x57},
    /* 0x8F */ {0xE7, 0x51, 0x97},
    /* 0x8F */ {0xE8, 0x52, 0x70},
    /* 0x8F */ {0xE9, 0x57, 0xCE},
    /* 0x8F */ {0xEA, 0x58, 0x34},
    /* 0x8F */ {0xEB, 0x58, 0xCC},
    /* 0x8F */ {0xEC, 0x5B, 0x22},
    /* 0x8F */ {0xED, 0x5E, 0x38},
    /* 0x8F */ {0xEE, 0x60, 0xC5},
    /* 0x8F */ {0xEF, 0x64, 0xFE},
    /* 0x8F */ {0xF0, 0x67, 0x61},
    /* 0x8F */ {0xF1, 0x67, 0x56},
    /* 0x8F */ {0xF2, 0x6D, 0x44},
    /* 0x8F */ {0xF3, 0x72, 0xB6},
    /* 0x8F */ {0xF4, 0x75, 0x73},
    /* 0x8F */ {0xF5, 0x7A, 0x63},
    /* 0x8F */ {0xF6, 0x84, 0xB8},
    /* 0x8F */ {0xF7, 0x8B, 0x72},
    /* 0x8F */ {0xF8, 0x91, 0xB8},
    /* 0x8F */ {0xF9, 0x93, 0x20},
    /* 0x8F */ {0xFA, 0x56, 0x31},
    /* 0x8F */ {0xFB, 0x57, 0xF4},
    /* 0x8F */ {0xFC, 0x98, 0xFE},
    /* 0x90 */ {0x40, 0x62, 0xED},
    /* 0x90 */ {0x41, 0x69, 0x0D},
    /* 0x90 */ {0x42, 0x6B, 0x96},
    /* 0x90 */ {0x43, 0x71, 0xED},
    /* 0x90 */ {0x44, 0x7E, 0x54},
    /* 0x90 */ {0x45, 0x80, 0x77},
    /* 0x90 */ {0x46, 0x82, 0x72},
    /* 0x90 */ {0x47, 0x89, 0xE6},
    /* 0x90 */ {0x48, 0x98, 0xDF},
    /* 0x90 */ {0x49, 0x87, 0x55},
    /* 0x90 */ {0x4A, 0x8F, 0xB1},
    /* 0x90 */ {0x4B, 0x5C, 0x3B},
    /* 0x90 */ {0x4C, 0x4F, 0x38},
    /* 0x90 */ {0x4D, 0x4F, 0xE1},
    /* 0x90 */ {0x4E, 0x4F, 0xB5},
    /* 0x90 */ {0x4F, 0x55, 0x07},
    /* 0x90 */ {0x50, 0x5A, 0x20},
    /* 0x90 */ {0x51, 0x5B, 0xDD},
    /* 0x90 */ {0x52, 0x5B, 0xE9},
    /* 0x90 */ {0x53, 0x5F, 0xC3},
    /* 0x90 */ {0x54, 0x61, 0x4E},
    /* 0x90 */ {0x55, 0x63, 0x2F},
    /* 0x90 */ {0x56, 0x65, 0xB0},
    /* 0x90 */ {0x57, 0x66, 0x4B},
    /* 0x90 */ {0x58, 0x68, 0xEE},
    /* 0x90 */ {0x59, 0x69, 0x9B},
    /* 0x90 */ {0x5A, 0x6D, 0x78},
    /* 0x90 */ {0x5B, 0x6D, 0xF1},
    /* 0x90 */ {0x5C, 0x75, 0x33},
    /* 0x90 */ {0x5D, 0x75, 0xB9},
    /* 0x90 */ {0x5E, 0x77, 0x1F},
    /* 0x90 */ {0x5F, 0x79, 0x5E},
    /* 0x90 */ {0x60, 0x79, 0xE6},
    /* 0x90 */ {0x61, 0x7D, 0x33},
    /* 0x90 */ {0x62, 0x81, 0xE3},
    /* 0x90 */ {0x63, 0x82, 0xAF},
    /* 0x90 */ {0x64, 0x85, 0xAA},
    /* 0x90 */ {0x65, 0x89, 0xAA},
    /* 0x90 */ {0x66, 0x8A, 0x3A},
    /* 0x90 */ {0x67, 0x8E, 0xAB},
    /* 0x90 */ {0x68, 0x8F, 0x9B},
    /* 0x90 */ {0x69, 0x90, 0x32},
    /* 0x90 */ {0x6A, 0x91, 0xDD},
    /* 0x90 */ {0x6B, 0x97, 0x07},
    /* 0x90 */ {0x6C, 0x4E, 0xBA},
    /* 0x90 */ {0x6D, 0x4E, 0xC1},
    /* 0x90 */ {0x6E, 0x52, 0x03},
    /* 0x90 */ {0x6F, 0x58, 0x75},
    /* 0x90 */ {0x70, 0x58, 0xEC},
    /* 0x90 */ {0x71, 0x5C, 0x0B},
    /* 0x90 */ {0x72, 0x75, 0x1A},
    /* 0x90 */ {0x73, 0x5C, 0x3D},
    /* 0x90 */ {0x74, 0x81, 0x4E},
    /* 0x90 */ {0x75, 0x8A, 0x0A},
    /* 0x90 */ {0x76, 0x8F, 0xC5},
    /* 0x90 */ {0x77, 0x96, 0x63},
    /* 0x90 */ {0x78, 0x97, 0x6D},
    /* 0x90 */ {0x79, 0x7B, 0x25},
    /* 0x90 */ {0x7A, 0x8A, 0xCF},
    /* 0x90 */ {0x7B, 0x98, 0x08},
    /* 0x90 */ {0x7C, 0x91, 0x62},
    /* 0x90 */ {0x7D, 0x56, 0xF3},
    /* 0x90 */ {0x7E, 0x53, 0xA8},
    /* 0x90 */ {0x80, 0x90, 0x17},
    /* 0x90 */ {0x81, 0x54, 0x39},
    /* 0x90 */ {0x82, 0x57, 0x82},
    /* 0x90 */ {0x83, 0x5E, 0x25},
    /* 0x90 */ {0x84, 0x63, 0xA8},
    /* 0x90 */ {0x85, 0x6C, 0x34},
    /* 0x90 */ {0x86, 0x70, 0x8A},
    /* 0x90 */ {0x87, 0x77, 0x61},
    /* 0x90 */ {0x88, 0x7C, 0x8B},
    /* 0x90 */ {0x89, 0x7F, 0xE0},
    /* 0x90 */ {0x8A, 0x88, 0x70},
    /* 0x90 */ {0x8B, 0x90, 0x42},
    /* 0x90 */ {0x8C, 0x91, 0x54},
    /* 0x90 */ {0x8D, 0x93, 0x10},
    /* 0x90 */ {0x8E, 0x93, 0x18},
    /* 0x90 */ {0x8F, 0x96, 0x8F},
    /* 0x90 */ {0x90, 0x74, 0x5E},
    /* 0x90 */ {0x91, 0x9A, 0xC4},
    /* 0x90 */ {0x92, 0x5D, 0x07},
    /* 0x90 */ {0x93, 0x5D, 0x69},
    /* 0x90 */ {0x94, 0x65, 0x70},
    /* 0x90 */ {0x95, 0x67, 0xA2},
    /* 0x90 */ {0x96, 0x8D, 0xA8},
    /* 0x90 */ {0x97, 0x96, 0xDB},
    /* 0x90 */ {0x98, 0x63, 0x6E},
    /* 0x90 */ {0x99, 0x67, 0x49},
    /* 0x90 */ {0x9A, 0x69, 0x19},
    /* 0x90 */ {0x9B, 0x83, 0xC5},
    /* 0x90 */ {0x9C, 0x98, 0x17},
    /* 0x90 */ {0x9D, 0x96, 0xC0},
    /* 0x90 */ {0x9E, 0x88, 0xFE},
    /* 0x90 */ {0x9F, 0x6F, 0x84},
    /* 0x90 */ {0xA0, 0x64, 0x7A},
    /* 0x90 */ {0xA1, 0x5B, 0xF8},
    /* 0x90 */ {0xA2, 0x4E, 0x16},
    /* 0x90 */ {0xA3, 0x70, 0x2C},
    /* 0x90 */ {0xA4, 0x75, 0x5D},
    /* 0x90 */ {0xA5, 0x66, 0x2F},
    /* 0x90 */ {0xA6, 0x51, 0xC4},
    /* 0x90 */ {0xA7, 0x52, 0x36},
    /* 0x90 */ {0xA8, 0x52, 0xE2},
    /* 0x90 */ {0xA9, 0x59, 0xD3},
    /* 0x90 */ {0xAA, 0x5F, 0x81},
    /* 0x90 */ {0xAB, 0x60, 0x27},
    /* 0x90 */ {0xAC, 0x62, 0x10},
    /* 0x90 */ {0xAD, 0x65, 0x3F},
    /* 0x90 */ {0xAE, 0x65, 0x74},
    /* 0x90 */ {0xAF, 0x66, 0x1F},
    /* 0x90 */ {0xB0, 0x66, 0x74},
    /* 0x90 */ {0xB1, 0x68, 0xF2},
    /* 0x90 */ {0xB2, 0x68, 0x16},
    /* 0x90 */ {0xB3, 0x6B, 0x63},
    /* 0x90 */ {0xB4, 0x6E, 0x05},
    /* 0x90 */ {0xB5, 0x72, 0x72},
    /* 0x90 */ {0xB6, 0x75, 0x1F},
    /* 0x90 */ {0xB7, 0x76, 0xDB},
    /* 0x90 */ {0xB8, 0x7C, 0xBE},
    /* 0x90 */ {0xB9, 0x80, 0x56},
    /* 0x90 */ {0xBA, 0x58, 0xF0},
    /* 0x90 */ {0xBB, 0x88, 0xFD},
    /* 0x90 */ {0xBC, 0x89, 0x7F},
    /* 0x90 */ {0xBD, 0x8A, 0xA0},
    /* 0x90 */ {0xBE, 0x8A, 0x93},
    /* 0x90 */ {0xBF, 0x8A, 0xCB},
    /* 0x90 */ {0xC0, 0x90, 0x1D},
    /* 0x90 */ {0xC1, 0x91, 0x92},
    /* 0x90 */ {0xC2, 0x97, 0x52},
    /* 0x90 */ {0xC3, 0x97, 0x59},
    /* 0x90 */ {0xC4, 0x65, 0x89},
    /* 0x90 */ {0xC5, 0x7A, 0x0E},
    /* 0x90 */ {0xC6, 0x81, 0x06},
    /* 0x90 */ {0xC7, 0x96, 0xBB},
    /* 0x90 */ {0xC8, 0x5E, 0x2D},
    /* 0x90 */ {0xC9, 0x60, 0xDC},
    /* 0x90 */ {0xCA, 0x62, 0x1A},
    /* 0x90 */ {0xCB, 0x65, 0xA5},
    /* 0x90 */ {0xCC, 0x66, 0x14},
    /* 0x90 */ {0xCD, 0x67, 0x90},
    /* 0x90 */ {0xCE, 0x77, 0xF3},
    /* 0x90 */ {0xCF, 0x7A, 0x4D},
    /* 0x90 */ {0xD0, 0x7C, 0x4D},
    /* 0x90 */ {0xD1, 0x7E, 0x3E},
    /* 0x90 */ {0xD2, 0x81, 0x0A},
    /* 0x90 */ {0xD3, 0x8C, 0xAC},
    /* 0x90 */ {0xD4, 0x8D, 0x64},
    /* 0x90 */ {0xD5, 0x8D, 0xE1},
    /* 0x90 */ {0xD6, 0x8E, 0x5F},
    /* 0x90 */ {0xD7, 0x78, 0xA9},
    /* 0x90 */ {0xD8, 0x52, 0x07},
    /* 0x90 */ {0xD9, 0x62, 0xD9},
    /* 0x90 */ {0xDA, 0x63, 0xA5},
    /* 0x90 */ {0xDB, 0x64, 0x42},
    /* 0x90 */ {0xDC, 0x62, 0x98},
    /* 0x90 */ {0xDD, 0x8A, 0x2D},
    /* 0x90 */ {0xDE, 0x7A, 0x83},
    /* 0x90 */ {0xDF, 0x7B, 0xC0},
    /* 0x90 */ {0xE0, 0x8A, 0xAC},
    /* 0x90 */ {0xE1, 0x96, 0xEA},
    /* 0x90 */ {0xE2, 0x7D, 0x76},
    /* 0x90 */ {0xE3, 0x82, 0x0C},
    /* 0x90 */ {0xE4, 0x87, 0x49},
    /* 0x90 */ {0xE5, 0x4E, 0xD9},
    /* 0x90 */ {0xE6, 0x51, 0x48},
    /* 0x90 */ {0xE7, 0x53, 0x43},
    /* 0x90 */ {0xE8, 0x53, 0x60},
    /* 0x90 */ {0xE9, 0x5B, 0xA3},
    /* 0x90 */ {0xEA, 0x5C, 0x02},
    /* 0x90 */ {0xEB, 0x5C, 0x16},
    /* 0x90 */ {0xEC, 0x5D, 0xDD},
    /* 0x90 */ {0xED, 0x62, 0x26},
    /* 0x90 */ {0xEE, 0x62, 0x47},
    /* 0x90 */ {0xEF, 0x64, 0xB0},
    /* 0x90 */ {0xF0, 0x68, 0x13},
    /* 0x90 */ {0xF1, 0x68, 0x34},
    /* 0x90 */ {0xF2, 0x6C, 0xC9},
    /* 0x90 */ {0xF3, 0x6D, 0x45},
    /* 0x90 */ {0xF4, 0x6D, 0x17},
    /* 0x90 */ {0xF5, 0x67, 0xD3},
    /* 0x90 */ {0xF6, 0x6F, 0x5C},
    /* 0x90 */ {0xF7, 0x71, 0x4E},
    /* 0x90 */ {0xF8, 0x71, 0x7D},
    /* 0x90 */ {0xF9, 0x65, 0xCB},
    /* 0x90 */ {0xFA, 0x7A, 0x7F},
    /* 0x90 */ {0xFB, 0x7B, 0xAD},
    /* 0x90 */ {0xFC, 0x7D, 0xDA},
    /* 0x91 */ {0x40, 0x7E, 0x4A},
    /* 0x91 */ {0x41, 0x7F, 0xA8},
    /* 0x91 */ {0x42, 0x81, 0x7A},
    /* 0x91 */ {0x43, 0x82, 0x1B},
    /* 0x91 */ {0x44, 0x82, 0x39},
    /* 0x91 */ {0x45, 0x85, 0xA6},
    /* 0x91 */ {0x46, 0x8A, 0x6E},
    /* 0x91 */ {0x47, 0x8C, 0xCE},
    /* 0x91 */ {0x48, 0x8D, 0xF5},
    /* 0x91 */ {0x49, 0x90, 0x78},
    /* 0x91 */ {0x4A, 0x90, 0x77},
    /* 0x91 */ {0x4B, 0x92, 0xAD},
    /* 0x91 */ {0x4C, 0x92, 0x91},
    /* 0x91 */ {0x4D, 0x95, 0x83},
    /* 0x91 */ {0x4E, 0x9B, 0xAE},
    /* 0x91 */ {0x4F, 0x52, 0x4D},
    /* 0x91 */ {0x50, 0x55, 0x84},
    /* 0x91 */ {0x51, 0x6F, 0x38},
    /* 0x91 */ {0x52, 0x71, 0x36},
    /* 0x91 */ {0x53, 0x51, 0x68},
    /* 0x91 */ {0x54, 0x79, 0x85},
    /* 0x91 */ {0x55, 0x7E, 0x55},
    /* 0x91 */ {0x56, 0x81, 0xB3},
    /* 0x91 */ {0x57, 0x7C, 0xCE},
    /* 0x91 */ {0x58, 0x56, 0x4C},
    /* 0x91 */ {0x59, 0x58, 0x51},
    /* 0x91 */ {0x5A, 0x5C, 0xA8},
    /* 0x91 */ {0x5B, 0x63, 0xAA},
    /* 0x91 */ {0x5C, 0x66, 0xFE},
    /* 0x91 */ {0x5D, 0x66, 0xFD},
    /* 0x91 */ {0x5E, 0x69, 0x5A},
    /* 0x91 */ {0x5F, 0x72, 0xD9},
    /* 0x91 */ {0x60, 0x75, 0x8F},
    /* 0x91 */ {0x61, 0x75, 0x8E},
    /* 0x91 */ {0x62, 0x79, 0x0E},
    /* 0x91 */ {0x63, 0x79, 0x56},
    /* 0x91 */ {0x64, 0x79, 0xDF},
    /* 0x91 */ {0x65, 0x7C, 0x97},
    /* 0x91 */ {0x66, 0x7D, 0x20},
    /* 0x91 */ {0x67, 0x7D, 0x44},
    /* 0x91 */ {0x68, 0x86, 0x07},
    /* 0x91 */ {0x69, 0x8A, 0x34},
    /* 0x91 */ {0x6A, 0x96, 0x3B},
    /* 0x91 */ {0x6B, 0x90, 0x61},
    /* 0x91 */ {0x6C, 0x9F, 0x20},
    /* 0x91 */ {0x6D, 0x50, 0xE7},
    /* 0x91 */ {0x6E, 0x52, 0x75},
    /* 0x91 */ {0x6F, 0x53, 0xCC},
    /* 0x91 */ {0x70, 0x53, 0xE2},
    /* 0x91 */ {0x71, 0x50, 0x09},
    /* 0x91 */ {0x72, 0x55, 0xAA},
    /* 0x91 */ {0x73, 0x58, 0xEE},
    /* 0x91 */ {0x74, 0x59, 0x4F},
    /* 0x91 */ {0x75, 0x72, 0x3D},
    /* 0x91 */ {0x76, 0x5B, 0x8B},
    /* 0x91 */ {0x77, 0x5C, 0x64},
    /* 0x91 */ {0x78, 0x53, 0x1D},
    /* 0x91 */ {0x79, 0x60, 0xE3},
    /* 0x91 */ {0x7A, 0x60, 0xF3},
    /* 0x91 */ {0x7B, 0x63, 0x5C},
    /* 0x91 */ {0x7C, 0x63, 0x83},
    /* 0x91 */ {0x7D, 0x63, 0x3F},
    /* 0x91 */ {0x7E, 0x63, 0xBB},
    /* 0x91 */ {0x80, 0x64, 0xCD},
    /* 0x91 */ {0x81, 0x65, 0xE9},
    /* 0x91 */ {0x82, 0x66, 0xF9},
    /* 0x91 */ {0x83, 0x5D, 0xE3},
    /* 0x91 */ {0x84, 0x69, 0xCD},
    /* 0x91 */ {0x85, 0x69, 0xFD},
    /* 0x91 */ {0x86, 0x6F, 0x15},
    /* 0x91 */ {0x87, 0x71, 0xE5},
    /* 0x91 */ {0x88, 0x4E, 0x89},
    /* 0x91 */ {0x89, 0x75, 0xE9},
    /* 0x91 */ {0x8A, 0x76, 0xF8},
    /* 0x91 */ {0x8B, 0x7A, 0x93},
    /* 0x91 */ {0x8C, 0x7C, 0xDF},
    /* 0x91 */ {0x8D, 0x7D, 0xCF},
    /* 0x91 */ {0x8E, 0x7D, 0x9C},
    /* 0x91 */ {0x8F, 0x80, 0x61},
    /* 0x91 */ {0x90, 0x83, 0x49},
    /* 0x91 */ {0x91, 0x83, 0x58},
    /* 0x91 */ {0x92, 0x84, 0x6C},
    /* 0x91 */ {0x93, 0x84, 0xBC},
    /* 0x91 */ {0x94, 0x85, 0xFB},
    /* 0x91 */ {0x95, 0x88, 0xC5},
    /* 0x91 */ {0x96, 0x8D, 0x70},
    /* 0x91 */ {0x97, 0x90, 0x01},
    /* 0x91 */ {0x98, 0x90, 0x6D},
    /* 0x91 */ {0x99, 0x93, 0x97},
    /* 0x91 */ {0x9A, 0x97, 0x1C},
    /* 0x91 */ {0x9B, 0x9A, 0x12},
    /* 0x91 */ {0x9C, 0x50, 0xCF},
    /* 0x91 */ {0x9D, 0x58, 0x97},
    /* 0x91 */ {0x9E, 0x61, 0x8E},
    /* 0x91 */ {0x9F, 0x81, 0xD3},
    /* 0x91 */ {0xA0, 0x85, 0x35},
    /* 0x91 */ {0xA1, 0x8D, 0x08},
    /* 0x91 */ {0xA2, 0x90, 0x20},
    /* 0x91 */ {0xA3, 0x4F, 0xC3},
    /* 0x91 */ {0xA4, 0x50, 0x74},
    /* 0x91 */ {0xA5, 0x52, 0x47},
    /* 0x91 */ {0xA6, 0x53, 0x73},
    /* 0x91 */ {0xA7, 0x60, 0x6F},
    /* 0x91 */ {0xA8, 0x63, 0x49},
    /* 0x91 */ {0xA9, 0x67, 0x5F},
    /* 0x91 */ {0xAA, 0x6E, 0x2C},
    /* 0x91 */ {0xAB, 0x8D, 0xB3},
    /* 0x91 */ {0xAC, 0x90, 0x1F},
    /* 0x91 */ {0xAD, 0x4F, 0xD7},
    /* 0x91 */ {0xAE, 0x5C, 0x5E},
    /* 0x91 */ {0xAF, 0x8C, 0xCA},
    /* 0x91 */ {0xB0, 0x65, 0xCF},
    /* 0x91 */ {0xB1, 0x7D, 0x9A},
    /* 0x91 */ {0xB2, 0x53, 0x52},
    /* 0x91 */ {0xB3, 0x88, 0x96},
    /* 0x91 */ {0xB4, 0x51, 0x76},
    /* 0x91 */ {0xB5, 0x63, 0xC3},
    /* 0x91 */ {0xB6, 0x5B, 0x58},
    /* 0x91 */ {0xB7, 0x5B, 0x6B},
    /* 0x91 */ {0xB8, 0x5C, 0x0A},
    /* 0x91 */ {0xB9, 0x64, 0x0D},
    /* 0x91 */ {0xBA, 0x67, 0x51},
    /* 0x91 */ {0xBB, 0x90, 0x5C},
    /* 0x91 */ {0xBC, 0x4E, 0xD6},
    /* 0x91 */ {0xBD, 0x59, 0x1A},
    /* 0x91 */ {0xBE, 0x59, 0x2A},
    /* 0x91 */ {0xBF, 0x6C, 0x70},
    /* 0x91 */ {0xC0, 0x8A, 0x51},
    /* 0x91 */ {0xC1, 0x55, 0x3E},
    /* 0x91 */ {0xC2, 0x58, 0x15},
    /* 0x91 */ {0xC3, 0x59, 0xA5},
    /* 0x91 */ {0xC4, 0x60, 0xF0},
    /* 0x91 */ {0xC5, 0x62, 0x53},
    /* 0x91 */ {0xC6, 0x67, 0xC1},
    /* 0x91 */ {0xC7, 0x82, 0x35},
    /* 0x91 */ {0xC8, 0x69, 0x55},
    /* 0x91 */ {0xC9, 0x96, 0x40},
    /* 0x91 */ {0xCA, 0x99, 0xC4},
    /* 0x91 */ {0xCB, 0x9A, 0x28},
    /* 0x91 */ {0xCC, 0x4F, 0x53},
    /* 0x91 */ {0xCD, 0x58, 0x06},
    /* 0x91 */ {0xCE, 0x5B, 0xFE},
    /* 0x91 */ {0xCF, 0x80, 0x10},
    /* 0x91 */ {0xD0, 0x5C, 0xB1},
    /* 0x91 */ {0xD1, 0x5E, 0x2F},
    /* 0x91 */ {0xD2, 0x5F, 0x85},
    /* 0x91 */ {0xD3, 0x60, 0x20},
    /* 0x91 */ {0xD4, 0x61, 0x4B},
    /* 0x91 */ {0xD5, 0x62, 0x34},
    /* 0x91 */ {0xD6, 0x66, 0xFF},
    /* 0x91 */ {0xD7, 0x6C, 0xF0},
    /* 0x91 */ {0xD8, 0x6E, 0xDE},
    /* 0x91 */ {0xD9, 0x80, 0xCE},
    /* 0x91 */ {0xDA, 0x81, 0x7F},
    /* 0x91 */ {0xDB, 0x82, 0xD4},
    /* 0x91 */ {0xDC, 0x88, 0x8B},
    /* 0x91 */ {0xDD, 0x8C, 0xB8},
    /* 0x91 */ {0xDE, 0x90, 0x00},
    /* 0x91 */ {0xDF, 0x90, 0x2E},
    /* 0x91 */ {0xE0, 0x96, 0x8A},
    /* 0x91 */ {0xE1, 0x9E, 0xDB},
    /* 0x91 */ {0xE2, 0x9B, 0xDB},
    /* 0x91 */ {0xE3, 0x4E, 0xE3},
    /* 0x91 */ {0xE4, 0x53, 0xF0},
    /* 0x91 */ {0xE5, 0x59, 0x27},
    /* 0x91 */ {0xE6, 0x7B, 0x2C},
    /* 0x91 */ {0xE7, 0x91, 0x8D},
    /* 0x91 */ {0xE8, 0x98, 0x4C},
    /* 0x91 */ {0xE9, 0x9D, 0xF9},
    /* 0x91 */ {0xEA, 0x6E, 0xDD},
    /* 0x91 */ {0xEB, 0x70, 0x27},
    /* 0x91 */ {0xEC, 0x53, 0x53},
    /* 0x91 */ {0xED, 0x55, 0x44},
    /* 0x91 */ {0xEE, 0x5B, 0x85},
    /* 0x91 */ {0xEF, 0x62, 0x58},
    /* 0x91 */ {0xF0, 0x62, 0x9E},
    /* 0x91 */ {0xF1, 0x62, 0xD3},
    /* 0x91 */ {0xF2, 0x6C, 0xA2},
    /* 0x91 */ {0xF3, 0x6F, 0xEF},
    /* 0x91 */ {0xF4, 0x74, 0x22},
    /* 0x91 */ {0xF5, 0x8A, 0x17},
    /* 0x91 */ {0xF6, 0x94, 0x38},
    /* 0x91 */ {0xF7, 0x6F, 0xC1},
    /* 0x91 */ {0xF8, 0x8A, 0xFE},
    /* 0x91 */ {0xF9, 0x83, 0x38},
    /* 0x91 */ {0xFA, 0x51, 0xE7},
    /* 0x91 */ {0xFB, 0x86, 0xF8},
    /* 0x91 */ {0xFC, 0x53, 0xEA},
    /* 0x92 */ {0x40, 0x53, 0xE9},
    /* 0x92 */ {0x41, 0x4F, 0x46},
    /* 0x92 */ {0x42, 0x90, 0x54},
    /* 0x92 */ {0x43, 0x8F, 0xB0},
    /* 0x92 */ {0x44, 0x59, 0x6A},
    /* 0x92 */ {0x45, 0x81, 0x31},
    /* 0x92 */ {0x46, 0x5D, 0xFD},
    /* 0x92 */ {0x47, 0x7A, 0xEA},
    /* 0x92 */ {0x48, 0x8F, 0xBF},
    /* 0x92 */ {0x49, 0x68, 0xDA},
    /* 0x92 */ {0x4A, 0x8C, 0x37},
    /* 0x92 */ {0x4B, 0x72, 0xF8},
    /* 0x92 */ {0x4C, 0x9C, 0x48},
    /* 0x92 */ {0x4D, 0x6A, 0x3D},
    /* 0x92 */ {0x4E, 0x8A, 0xB0},
    /* 0x92 */ {0x4F, 0x4E, 0x39},
    /* 0x92 */ {0x50, 0x53, 0x58},
    /* 0x92 */ {0x51, 0x56, 0x06},
    /* 0x92 */ {0x52, 0x57, 0x66},
    /* 0x92 */ {0x53, 0x62, 0xC5},
    /* 0x92 */ {0x54, 0x63, 0xA2},
    /* 0x92 */ {0x55, 0x65, 0xE6},
    /* 0x92 */ {0x56, 0x6B, 0x4E},
    /* 0x92 */ {0x57, 0x6D, 0xE1},
    /* 0x92 */ {0x58, 0x6E, 0x5B},
    /* 0x92 */ {0x59, 0x70, 0xAD},
    /* 0x92 */ {0x5A, 0x77, 0xED},
    /* 0x92 */ {0x5B, 0x7A, 0xEF},
    /* 0x92 */ {0x5C, 0x7B, 0xAA},
    /* 0x92 */ {0x5D, 0x7D, 0xBB},
    /* 0x92 */ {0x5E, 0x80, 0x3D},
    /* 0x92 */ {0x5F, 0x80, 0xC6},
    /* 0x92 */ {0x60, 0x86, 0xCB},
    /* 0x92 */ {0x61, 0x8A, 0x95},
    /* 0x92 */ {0x62, 0x93, 0x5B},
    /* 0x92 */ {0x63, 0x56, 0xE3},
    /* 0x92 */ {0x64, 0x58, 0xC7},
    /* 0x92 */ {0x65, 0x5F, 0x3E},
    /* 0x92 */ {0x66, 0x65, 0xAD},
    /* 0x92 */ {0x67, 0x66, 0x96},
    /* 0x92 */ {0x68, 0x6A, 0x80},
    /* 0x92 */ {0x69, 0x6B, 0xB5},
    /* 0x92 */ {0x6A, 0x75, 0x37},
    /* 0x92 */ {0x6B, 0x8A, 0xC7},
    /* 0x92 */ {0x6C, 0x50, 0x24},
    /* 0x92 */ {0x6D, 0x77, 0xE5},
    /* 0x92 */ {0x6E, 0x57, 0x30},
    /* 0x92 */ {0x6F, 0x5F, 0x1B},
    /* 0x92 */ {0x70, 0x60, 0x65},
    /* 0x92 */ {0x71, 0x66, 0x7A},
    /* 0x92 */ {0x72, 0x6C, 0x60},
    /* 0x92 */ {0x73, 0x75, 0xF4},
    /* 0x92 */ {0x74, 0x7A, 0x1A},
    /* 0x92 */ {0x75, 0x7F, 0x6E},
    /* 0x92 */ {0x76, 0x81, 0xF4},
    /* 0x92 */ {0x77, 0x87, 0x18},
    /* 0x92 */ {0x78, 0x90, 0x45},
    /* 0x92 */ {0x79, 0x99, 0xB3},
    /* 0x92 */ {0x7A, 0x7B, 0xC9},
    /* 0x92 */ {0x7B, 0x75, 0x5C},
    /* 0x92 */ {0x7C, 0x7A, 0xF9},
    /* 0x92 */ {0x7D, 0x7B, 0x51},
    /* 0x92 */ {0x7E, 0x84, 0xC4},
    /* 0x92 */ {0x80, 0x90, 0x10},
    /* 0x92 */ {0x81, 0x79, 0xE9},
    /* 0x92 */ {0x82, 0x7A, 0x92},
    /* 0x92 */ {0x83, 0x83, 0x36},
    /* 0x92 */ {0x84, 0x5A, 0xE1},
    /* 0x92 */ {0x85, 0x77, 0x40},
    /* 0x92 */ {0x86, 0x4E, 0x2D},
    /* 0x92 */ {0x87, 0x4E, 0xF2},
    /* 0x92 */ {0x88, 0x5B, 0x99},
    /* 0x92 */ {0x89, 0x5F, 0xE0},
    /* 0x92 */ {0x8A, 0x62, 0xBD},
    /* 0x92 */ {0x8B, 0x66, 0x3C},
    /* 0x92 */ {0x8C, 0x67, 0xF1},
    /* 0x92 */ {0x8D, 0x6C, 0xE8},
    /* 0x92 */ {0x8E, 0x86, 0x6B},
    /* 0x92 */ {0x8F, 0x88, 0x77},
    /* 0x92 */ {0x90, 0x8A, 0x3B},
    /* 0x92 */ {0x91, 0x91, 0x4E},
    /* 0x92 */ {0x92, 0x92, 0xF3},
    /* 0x92 */ {0x93, 0x99, 0xD0},
    /* 0x92 */ {0x94, 0x6A, 0x17},
    /* 0x92 */ {0x95, 0x70, 0x26},
    /* 0x92 */ {0x96, 0x73, 0x2A},
    /* 0x92 */ {0x97, 0x82, 0xE7},
    /* 0x92 */ {0x98, 0x84, 0x57},
    /* 0x92 */ {0x99, 0x8C, 0xAF},
    /* 0x92 */ {0x9A, 0x4E, 0x01},
    /* 0x92 */ {0x9B, 0x51, 0x46},
    /* 0x92 */ {0x9C, 0x51, 0xCB},
    /* 0x92 */ {0x9D, 0x55, 0x8B},
    /* 0x92 */ {0x9E, 0x5B, 0xF5},
    /* 0x92 */ {0x9F, 0x5E, 0x16},
    /* 0x92 */ {0xA0, 0x5E, 0x33},
    /* 0x92 */ {0xA1, 0x5E, 0x81},
    /* 0x92 */ {0xA2, 0x5F, 0x14},
    /* 0x92 */ {0xA3, 0x5F, 0x35},
    /* 0x92 */ {0xA4, 0x5F, 0x6B},
    /* 0x92 */ {0xA5, 0x5F, 0xB4},
    /* 0x92 */ {0xA6, 0x61, 0xF2},
    /* 0x92 */ {0xA7, 0x63, 0x11},
    /* 0x92 */ {0xA8, 0x66, 0xA2},
    /* 0x92 */ {0xA9, 0x67, 0x1D},
    /* 0x92 */ {0xAA, 0x6F, 0x6E},
    /* 0x92 */ {0xAB, 0x72, 0x52},
    /* 0x92 */ {0xAC, 0x75, 0x3A},
    /* 0x92 */ {0xAD, 0x77, 0x3A},
    /* 0x92 */ {0xAE, 0x80, 0x74},
    /* 0x92 */ {0xAF, 0x81, 0x39},
    /* 0x92 */ {0xB0, 0x81, 0x78},
    /* 0x92 */ {0xB1, 0x87, 0x76},
    /* 0x92 */ {0xB2, 0x8A, 0xBF},
    /* 0x92 */ {0xB3, 0x8A, 0xDC},
    /* 0x92 */ {0xB4, 0x8D, 0x85},
    /* 0x92 */ {0xB5, 0x8D, 0xF3},
    /* 0x92 */ {0xB6, 0x92, 0x9A},
    /* 0x92 */ {0xB7, 0x95, 0x77},
    /* 0x92 */ {0xB8, 0x98, 0x02},
    /* 0x92 */ {0xB9, 0x9C, 0xE5},
    /* 0x92 */ {0xBA, 0x52, 0xC5},
    /* 0x92 */ {0xBB, 0x63, 0x57},
    /* 0x92 */ {0xBC, 0x76, 0xF4},
    /* 0x92 */ {0xBD, 0x67, 0x15},
    /* 0x92 */ {0xBE, 0x6C, 0x88},
    /* 0x92 */ {0xBF, 0x73, 0xCD},
    /* 0x92 */ {0xC0, 0x8C, 0xC3},
    /* 0x92 */ {0xC1, 0x93, 0xAE},
    /* 0x92 */ {0xC2, 0x96, 0x73},
    /* 0x92 */ {0xC3, 0x6D, 0x25},
    /* 0x92 */ {0xC4, 0x58, 0x9C},
    /* 0x92 */ {0xC5, 0x69, 0x0E},
    /* 0x92 */ {0xC6, 0x69, 0xCC},
    /* 0x92 */ {0xC7, 0x8F, 0xFD},
    /* 0x92 */ {0xC8, 0x93, 0x9A},
    /* 0x92 */ {0xC9, 0x75, 0xDB},
    /* 0x92 */ {0xCA, 0x90, 0x1A},
    /* 0x92 */ {0xCB, 0x58, 0x5A},
    /* 0x92 */ {0xCC, 0x68, 0x02},
    /* 0x92 */ {0xCD, 0x63, 0xB4},
    /* 0x92 */ {0xCE, 0x69, 0xFB},
    /* 0x92 */ {0xCF, 0x4F, 0x43},
    /* 0x92 */ {0xD0, 0x6F, 0x2C},
    /* 0x92 */ {0xD1, 0x67, 0xD8},
    /* 0x92 */ {0xD2, 0x8F, 0xBB},
    /* 0x92 */ {0xD3, 0x85, 0x26},
    /* 0x92 */ {0xD4, 0x7D, 0xB4},
    /* 0x92 */ {0xD5, 0x93, 0x54},
    /* 0x92 */ {0xD6, 0x69, 0x3F},
    /* 0x92 */ {0xD7, 0x6F, 0x70},
    /* 0x92 */ {0xD8, 0x57, 0x6A},
    /* 0x92 */ {0xD9, 0x58, 0xF7},
    /* 0x92 */ {0xDA, 0x5B, 0x2C},
    /* 0x92 */ {0xDB, 0x7D, 0x2C},
    /* 0x92 */ {0xDC, 0x72, 0x2A},
    /* 0x92 */ {0xDD, 0x54, 0x0A},
    /* 0x92 */ {0xDE, 0x91, 0xE3},
    /* 0x92 */ {0xDF, 0x9D, 0xB4},
    /* 0x92 */ {0xE0, 0x4E, 0xAD},
    /* 0x92 */ {0xE1, 0x4F, 0x4E},
    /* 0x92 */ {0xE2, 0x50, 0x5C},
    /* 0x92 */ {0xE3, 0x50, 0x75},
    /* 0x92 */ {0xE4, 0x52, 0x43},
    /* 0x92 */ {0xE5, 0x8C, 0x9E},
    /* 0x92 */ {0xE6, 0x54, 0x48},
    /* 0x92 */ {0xE7, 0x58, 0x24},
    /* 0x92 */ {0xE8, 0x5B, 0x9A},
    /* 0x92 */ {0xE9, 0x5E, 0x1D},
    /* 0x92 */ {0xEA, 0x5E, 0x95},
    /* 0x92 */ {0xEB, 0x5E, 0xAD},
    /* 0x92 */ {0xEC, 0x5E, 0xF7},
    /* 0x92 */ {0xED, 0x5F, 0x1F},
    /* 0x92 */ {0xEE, 0x60, 0x8C},
    /* 0x92 */ {0xEF, 0x62, 0xB5},
    /* 0x92 */ {0xF0, 0x63, 0x3A},
    /* 0x92 */ {0xF1, 0x63, 0xD0},
    /* 0x92 */ {0xF2, 0x68, 0xAF},
    /* 0x92 */ {0xF3, 0x6C, 0x40},
    /* 0x92 */ {0xF4, 0x78, 0x87},
    /* 0x92 */ {0xF5, 0x79, 0x8E},
    /* 0x92 */ {0xF6, 0x7A, 0x0B},
    /* 0x92 */ {0xF7, 0x7D, 0xE0},
    /* 0x92 */ {0xF8, 0x82, 0x47},
    /* 0x92 */ {0xF9, 0x8A, 0x02},
    /* 0x92 */ {0xFA, 0x8A, 0xE6},
    /* 0x92 */ {0xFB, 0x8E, 0x44},
    /* 0x92 */ {0xFC, 0x90, 0x13},
    /* 0x93 */ {0x40, 0x90, 0xB8},
    /* 0x93 */ {0x41, 0x91, 0x2D},
    /* 0x93 */ {0x42, 0x91, 0xD8},
    /* 0x93 */ {0x43, 0x9F, 0x0E},
    /* 0x93 */ {0x44, 0x6C, 0xE5},
    /* 0x93 */ {0x45, 0x64, 0x58},
    /* 0x93 */ {0x46, 0x64, 0xE2},
    /* 0x93 */ {0x47, 0x65, 0x75},
    /* 0x93 */ {0x48, 0x6E, 0xF4},
    /* 0x93 */ {0x49, 0x76, 0x84},
    /* 0x93 */ {0x4A, 0x7B, 0x1B},
    /* 0x93 */ {0x4B, 0x90, 0x69},
    /* 0x93 */ {0x4C, 0x93, 0xD1},
    /* 0x93 */ {0x4D, 0x6E, 0xBA},
    /* 0x93 */ {0x4E, 0x54, 0xF2},
    /* 0x93 */ {0x4F, 0x5F, 0xB9},
    /* 0x93 */ {0x50, 0x64, 0xA4},
    /* 0x93 */ {0x51, 0x8F, 0x4D},
    /* 0x93 */ {0x52, 0x8F, 0xED},
    /* 0x93 */ {0x53, 0x92, 0x44},
    /* 0x93 */ {0x54, 0x51, 0x78},
    /* 0x93 */ {0x55, 0x58, 0x6B},
    /* 0x93 */ {0x56, 0x59, 0x29},
    /* 0x93 */ {0x57, 0x5C, 0x55},
    /* 0x93 */ {0x58, 0x5E, 0x97},
    /* 0x93 */ {0x59, 0x6D, 0xFB},
    /* 0x93 */ {0x5A, 0x7E, 0x8F},
    /* 0x93 */ {0x5B, 0x75, 0x1C},
    /* 0x93 */ {0x5C, 0x8C, 0xBC},
    /* 0x93 */ {0x5D, 0x8E, 0xE2},
    /* 0x93 */ {0x5E, 0x98, 0x5B},
    /* 0x93 */ {0x5F, 0x70, 0xB9},
    /* 0x93 */ {0x60, 0x4F, 0x1D},
    /* 0x93 */ {0x61, 0x6B, 0xBF},
    /* 0x93 */ {0x62, 0x6F, 0xB1},
    /* 0x93 */ {0x63, 0x75, 0x30},
    /* 0x93 */ {0x64, 0x96, 0xFB},
    /* 0x93 */ {0x65, 0x51, 0x4E},
    /* 0x93 */ {0x66, 0x54, 0x10},
    /* 0x93 */ {0x67, 0x58, 0x35},
    /* 0x93 */ {0x68, 0x58, 0x57},
    /* 0x93 */ {0x69, 0x59, 0xAC},
    /* 0x93 */ {0x6A, 0x5C, 0x60},
    /* 0x93 */ {0x6B, 0x5F, 0x92},
    /* 0x93 */ {0x6C, 0x65, 0x97},
    /* 0x93 */ {0x6D, 0x67, 0x5C},
    /* 0x93 */ {0x6E, 0x6E, 0x21},
    /* 0x93 */ {0x6F, 0x76, 0x7B},
    /* 0x93 */ {0x70, 0x83, 0xDF},
    /* 0x93 */ {0x71, 0x8C, 0xED},
    /* 0x93 */ {0x72, 0x90, 0x14},
    /* 0x93 */ {0x73, 0x90, 0xFD},
    /* 0x93 */ {0x74, 0x93, 0x4D},
    /* 0x93 */ {0x75, 0x78, 0x25},
    /* 0x93 */ {0x76, 0x78, 0x3A},
    /* 0x93 */ {0x77, 0x52, 0xAA},
    /* 0x93 */ {0x78, 0x5E, 0xA6},
    /* 0x93 */ {0x79, 0x57, 0x1F},
    /* 0x93 */ {0x7A, 0x59, 0x74},
    /* 0x93 */ {0x7B, 0x60, 0x12},
    /* 0x93 */ {0x7C, 0x50, 0x12},
    /* 0x93 */ {0x7D, 0x51, 0x5A},
    /* 0x93 */ {0x7E, 0x51, 0xAC},
    /* 0x93 */ {0x80, 0x51, 0xCD},
    /* 0x93 */ {0x81, 0x52, 0x00},
    /* 0x93 */ {0x82, 0x55, 0x10},
    /* 0x93 */ {0x83, 0x58, 0x54},
    /* 0x93 */ {0x84, 0x58, 0x58},
    /* 0x93 */ {0x85, 0x59, 0x57},
    /* 0x93 */ {0x86, 0x5B, 0x95},
    /* 0x93 */ {0x87, 0x5C, 0xF6},
    /* 0x93 */ {0x88, 0x5D, 0x8B},
    /* 0x93 */ {0x89, 0x60, 0xBC},
    /* 0x93 */ {0x8A, 0x62, 0x95},
    /* 0x93 */ {0x8B, 0x64, 0x2D},
    /* 0x93 */ {0x8C, 0x67, 0x71},
    /* 0x93 */ {0x8D, 0x68, 0x43},
    /* 0x93 */ {0x8E, 0x68, 0xBC},
    /* 0x93 */ {0x8F, 0x68, 0xDF},
    /* 0x93 */ {0x90, 0x76, 0xD7},
    /* 0x93 */ {0x91, 0x6D, 0xD8},
    /* 0x93 */ {0x92, 0x6E, 0x6F},
    /* 0x93 */ {0x93, 0x6D, 0x9B},
    /* 0x93 */ {0x94, 0x70, 0x6F},
    /* 0x93 */ {0x95, 0x71, 0xC8},
    /* 0x93 */ {0x96, 0x5F, 0x53},
    /* 0x93 */ {0x97, 0x75, 0xD8},
    /* 0x93 */ {0x98, 0x79, 0x77},
    /* 0x93 */ {0x99, 0x7B, 0x49},
    /* 0x93 */ {0x9A, 0x7B, 0x54},
    /* 0x93 */ {0x9B, 0x7B, 0x52},
    /* 0x93 */ {0x9C, 0x7C, 0xD6},
    /* 0x93 */ {0x9D, 0x7D, 0x71},
    /* 0x93 */ {0x9E, 0x52, 0x30},
    /* 0x93 */ {0x9F, 0x84, 0x63},
    /* 0x93 */ {0xA0, 0x85, 0x69},
    /* 0x93 */ {0xA1, 0x85, 0xE4},
    /* 0x93 */ {0xA2, 0x8A, 0x0E},
    /* 0x93 */ {0xA3, 0x8B, 0x04},
    /* 0x93 */ {0xA4, 0x8C, 0x46},
    /* 0x93 */ {0xA5, 0x8E, 0x0F},
    /* 0x93 */ {0xA6, 0x90, 0x03},
    /* 0x93 */ {0xA7, 0x90, 0x0F},
    /* 0x93 */ {0xA8, 0x94, 0x19},
    /* 0x93 */ {0xA9, 0x96, 0x76},
    /* 0x93 */ {0xAA, 0x98, 0x2D},
    /* 0x93 */ {0xAB, 0x9A, 0x30},
    /* 0x93 */ {0xAC, 0x95, 0xD8},
    /* 0x93 */ {0xAD, 0x50, 0xCD},
    /* 0x93 */ {0xAE, 0x52, 0xD5},
    /* 0x93 */ {0xAF, 0x54, 0x0C},
    /* 0x93 */ {0xB0, 0x58, 0x02},
    /* 0x93 */ {0xB1, 0x5C, 0x0E},
    /* 0x93 */ {0xB2, 0x61, 0xA7},
    /* 0x93 */ {0xB3, 0x64, 0x9E},
    /* 0x93 */ {0xB4, 0x6D, 0x1E},
    /* 0x93 */ {0xB5, 0x77, 0xB3},
    /* 0x93 */ {0xB6, 0x7A, 0xE5},
    /* 0x93 */ {0xB7, 0x80, 0xF4},
    /* 0x93 */ {0xB8, 0x84, 0x04},
    /* 0x93 */ {0xB9, 0x90, 0x53},
    /* 0x93 */ {0xBA, 0x92, 0x85},
    /* 0x93 */ {0xBB, 0x5C, 0xE0},
    /* 0x93 */ {0xBC, 0x9D, 0x07},
    /* 0x93 */ {0xBD, 0x53, 0x3F},
    /* 0x93 */ {0xBE, 0x5F, 0x97},
    /* 0x93 */ {0xBF, 0x5F, 0xB3},
    /* 0x93 */ {0xC0, 0x6D, 0x9C},
    /* 0x93 */ {0xC1, 0x72, 0x79},
    /* 0x93 */ {0xC2, 0x77, 0x63},
    /* 0x93 */ {0xC3, 0x79, 0xBF},
    /* 0x93 */ {0xC4, 0x7B, 0xE4},
    /* 0x93 */ {0xC5, 0x6B, 0xD2},
    /* 0x93 */ {0xC6, 0x72, 0xEC},
    /* 0x93 */ {0xC7, 0x8A, 0xAD},
    /* 0x93 */ {0xC8, 0x68, 0x03},
    /* 0x93 */ {0xC9, 0x6A, 0x61},
    /* 0x93 */ {0xCA, 0x51, 0xF8},
    /* 0x93 */ {0xCB, 0x7A, 0x81},
    /* 0x93 */ {0xCC, 0x69, 0x34},
    /* 0x93 */ {0xCD, 0x5C, 0x4A},
    /* 0x93 */ {0xCE, 0x9C, 0xF6},
    /* 0x93 */ {0xCF, 0x82, 0xEB},
    /* 0x93 */ {0xD0, 0x5B, 0xC5},
    /* 0x93 */ {0xD1, 0x91, 0x49},
    /* 0x93 */ {0xD2, 0x70, 0x1E},
    /* 0x93 */ {0xD3, 0x56, 0x78},
    /* 0x93 */ {0xD4, 0x5C, 0x6F},
    /* 0x93 */ {0xD5, 0x60, 0xC7},
    /* 0x93 */ {0xD6, 0x65, 0x66},
    /* 0x93 */ {0xD7, 0x6C, 0x8C},
    /* 0x93 */ {0xD8, 0x8C, 0x5A},
    /* 0x93 */ {0xD9, 0x90, 0x41},
    /* 0x93 */ {0xDA, 0x98, 0x13},
    /* 0x93 */ {0xDB, 0x54, 0x51},
    /* 0x93 */ {0xDC, 0x66, 0xC7},
    /* 0x93 */ {0xDD, 0x92, 0x0D},
    /* 0x93 */ {0xDE, 0x59, 0x48},
    /* 0x93 */ {0xDF, 0x90, 0xA3},
    /* 0x93 */ {0xE0, 0x51, 0x85},
    /* 0x93 */ {0xE1, 0x4E, 0x4D},
    /* 0x93 */ {0xE2, 0x51, 0xEA},
    /* 0x93 */ {0xE3, 0x85, 0x99},
    /* 0x93 */ {0xE4, 0x8B, 0x0E},
    /* 0x93 */ {0xE5, 0x70, 0x58},
    /* 0x93 */ {0xE6, 0x63, 0x7A},
    /* 0x93 */ {0xE7, 0x93, 0x4B},
    /* 0x93 */ {0xE8, 0x69, 0x62},
    /* 0x93 */ {0xE9, 0x99, 0xB4},
    /* 0x93 */ {0xEA, 0x7E, 0x04},
    /* 0x93 */ {0xEB, 0x75, 0x77},
    /* 0x93 */ {0xEC, 0x53, 0x57},
    /* 0x93 */ {0xED, 0x69, 0x60},
    /* 0x93 */ {0xEE, 0x8E, 0xDF},
    /* 0x93 */ {0xEF, 0x96, 0xE3},
    /* 0x93 */ {0xF0, 0x6C, 0x5D},
    /* 0x93 */ {0xF1, 0x4E, 0x8C},
    /* 0x93 */ {0xF2, 0x5C, 0x3C},
    /* 0x93 */ {0xF3, 0x5F, 0x10},
    /* 0x93 */ {0xF4, 0x8F, 0xE9},
    /* 0x93 */ {0xF5, 0x53, 0x02},
    /* 0x93 */ {0xF6, 0x8C, 0xD1},
    /* 0x93 */ {0xF7, 0x80, 0x89},
    /* 0x93 */ {0xF8, 0x86, 0x79},
    /* 0x93 */ {0xF9, 0x5E, 0xFF},
    /* 0x93 */ {0xFA, 0x65, 0xE5},
    /* 0x93 */ {0xFB, 0x4E, 0x73},
    /* 0x93 */ {0xFC, 0x51, 0x65},
    /* 0x94 */ {0x40, 0x59, 0x82},
    /* 0x94 */ {0x41, 0x5C, 0x3F},
    /* 0x94 */ {0x42, 0x97, 0xEE},
    /* 0x94 */ {0x43, 0x4E, 0xFB},
    /* 0x94 */ {0x44, 0x59, 0x8A},
    /* 0x94 */ {0x45, 0x5F, 0xCD},
    /* 0x94 */ {0x46, 0x8A, 0x8D},
    /* 0x94 */ {0x47, 0x6F, 0xE1},
    /* 0x94 */ {0x48, 0x79, 0xB0},
    /* 0x94 */ {0x49, 0x79, 0x62},
    /* 0x94 */ {0x4A, 0x5B, 0xE7},
    /* 0x94 */ {0x4B, 0x84, 0x71},
    /* 0x94 */ {0x4C, 0x73, 0x2B},
    /* 0x94 */ {0x4D, 0x71, 0xB1},
    /* 0x94 */ {0x4E, 0x5E, 0x74},
    /* 0x94 */ {0x4F, 0x5F, 0xF5},
    /* 0x94 */ {0x50, 0x63, 0x7B},
    /* 0x94 */ {0x51, 0x64, 0x9A},
    /* 0x94 */ {0x52, 0x71, 0xC3},
    /* 0x94 */ {0x53, 0x7C, 0x98},
    /* 0x94 */ {0x54, 0x4E, 0x43},
    /* 0x94 */ {0x55, 0x5E, 0xFC},
    /* 0x94 */ {0x56, 0x4E, 0x4B},
    /* 0x94 */ {0x57, 0x57, 0xDC},
    /* 0x94 */ {0x58, 0x56, 0xA2},
    /* 0x94 */ {0x59, 0x60, 0xA9},
    /* 0x94 */ {0x5A, 0x6F, 0xC3},
    /* 0x94 */ {0x5B, 0x7D, 0x0D},
    /* 0x94 */ {0x5C, 0x80, 0xFD},
    /* 0x94 */ {0x5D, 0x81, 0x33},
    /* 0x94 */ {0x5E, 0x81, 0xBF},
    /* 0x94 */ {0x5F, 0x8F, 0xB2},
    /* 0x94 */ {0x60, 0x89, 0x97},
    /* 0x94 */ {0x61, 0x86, 0xA4},
    /* 0x94 */ {0x62, 0x5D, 0xF4},
    /* 0x94 */ {0x63, 0x62, 0x8A},
    /* 0x94 */ {0x64, 0x64, 0xAD},
    /* 0x94 */ {0x65, 0x89, 0x87},
    /* 0x94 */ {0x66, 0x67, 0x77},
    /* 0x94 */ {0x67, 0x6C, 0xE2},
    /* 0x94 */ {0x68, 0x6D, 0x3E},
    /* 0x94 */ {0x69, 0x74, 0x36},
    /* 0x94 */ {0x6A, 0x78, 0x34},
    /* 0x94 */ {0x6B, 0x5A, 0x46},
    /* 0x94 */ {0x6C, 0x7F, 0x75},
    /* 0x94 */ {0x6D, 0x82, 0xAD},
    /* 0x94 */ {0x6E, 0x99, 0xAC},
    /* 0x94 */ {0x6F, 0x4F, 0xF3},
    /* 0x94 */ {0x70, 0x5E, 0xC3},
    /* 0x94 */ {0x71, 0x62, 0xDD},
    /* 0x94 */ {0x72, 0x63, 0x92},
    /* 0x94 */ {0x73, 0x65, 0x57},
    /* 0x94 */ {0x74, 0x67, 0x6F},
    /* 0x94 */ {0x75, 0x76, 0xC3},
    /* 0x94 */ {0x76, 0x72, 0x4C},
    /* 0x94 */ {0x77, 0x80, 0xCC},
    /* 0x94 */ {0x78, 0x80, 0xBA},
    /* 0x94 */ {0x79, 0x8F, 0x29},
    /* 0x94 */ {0x7A, 0x91, 0x4D},
    /* 0x94 */ {0x7B, 0x50, 0x0D},
    /* 0x94 */ {0x7C, 0x57, 0xF9},
    /* 0x94 */ {0x7D, 0x5A, 0x92},
    /* 0x94 */ {0x7E, 0x68, 0x85},
    /* 0x94 */ {0x80, 0x69, 0x73},
    /* 0x94 */ {0x81, 0x71, 0x64},
    /* 0x94 */ {0x82, 0x72, 0xFD},
    /* 0x94 */ {0x83, 0x8C, 0xB7},
    /* 0x94 */ {0x84, 0x58, 0xF2},
    /* 0x94 */ {0x85, 0x8C, 0xE0},
    /* 0x94 */ {0x86, 0x96, 0x6A},
    /* 0x94 */ {0x87, 0x90, 0x19},
    /* 0x94 */ {0x88, 0x87, 0x7F},
    /* 0x94 */ {0x89, 0x79, 0xE4},
    /* 0x94 */ {0x8A, 0x77, 0xE7},
    /* 0x94 */ {0x8B, 0x84, 0x29},
    /* 0x94 */ {0x8C, 0x4F, 0x2F},
    /* 0x94 */ {0x8D, 0x52, 0x65},
    /* 0x94 */ {0x8E, 0x53, 0x5A},
    /* 0x94 */ {0x8F, 0x62, 0xCD},
    /* 0x94 */ {0x90, 0x67, 0xCF},
    /* 0x94 */ {0x91, 0x6C, 0xCA},
    /* 0x94 */ {0x92, 0x76, 0x7D},
    /* 0x94 */ {0x93, 0x7B, 0x94},
    /* 0x94 */ {0x94, 0x7C, 0x95},
    /* 0x94 */ {0x95, 0x82, 0x36},
    /* 0x94 */ {0x96, 0x85, 0x84},
    /* 0x94 */ {0x97, 0x8F, 0xEB},
    /* 0x94 */ {0x98, 0x66, 0xDD},
    /* 0x94 */ {0x99, 0x6F, 0x20},
    /* 0x94 */ {0x9A, 0x72, 0x06},
    /* 0x94 */ {0x9B, 0x7E, 0x1B},
    /* 0x94 */ {0x9C, 0x83, 0xAB},
    /* 0x94 */ {0x9D, 0x99, 0xC1},
    /* 0x94 */ {0x9E, 0x9E, 0xA6},
    /* 0x94 */ {0x9F, 0x51, 0xFD},
    /* 0x94 */ {0xA0, 0x7B, 0xB1},
    /* 0x94 */ {0xA1, 0x78, 0x72},
    /* 0x94 */ {0xA2, 0x7B, 0xB8},
    /* 0x94 */ {0xA3, 0x80, 0x87},
    /* 0x94 */ {0xA4, 0x7B, 0x48},
    /* 0x94 */ {0xA5, 0x6A, 0xE8},
    /* 0x94 */ {0xA6, 0x5E, 0x61},
    /* 0x94 */ {0xA7, 0x80, 0x8C},
    /* 0x94 */ {0xA8, 0x75, 0x51},
    /* 0x94 */ {0xA9, 0x75, 0x60},
    /* 0x94 */ {0xAA, 0x51, 0x6B},
    /* 0x94 */ {0xAB, 0x92, 0x62},
    /* 0x94 */ {0xAC, 0x6E, 0x8C},
    /* 0x94 */ {0xAD, 0x76, 0x7A},
    /* 0x94 */ {0xAE, 0x91, 0x97},
    /* 0x94 */ {0xAF, 0x9A, 0xEA},
    /* 0x94 */ {0xB0, 0x4F, 0x10},
    /* 0x94 */ {0xB1, 0x7F, 0x70},
    /* 0x94 */ {0xB2, 0x62, 0x9C},
    /* 0x94 */ {0xB3, 0x7B, 0x4F},
    /* 0x94 */ {0xB4, 0x95, 0xA5},
    /* 0x94 */ {0xB5, 0x9C, 0xE9},
    /* 0x94 */ {0xB6, 0x56, 0x7A},
    /* 0x94 */ {0xB7, 0x58, 0x59},
    /* 0x94 */ {0xB8, 0x86, 0xE4},
    /* 0x94 */ {0xB9, 0x96, 0xBC},
    /* 0x94 */ {0xBA, 0x4F, 0x34},
    /* 0x94 */ {0xBB, 0x52, 0x24},
    /* 0x94 */ {0xBC, 0x53, 0x4A},
    /* 0x94 */ {0xBD, 0x53, 0xCD},
    /* 0x94 */ {0xBE, 0x53, 0xDB},
    /* 0x94 */ {0xBF, 0x5E, 0x06},
    /* 0x94 */ {0xC0, 0x64, 0x2C},
    /* 0x94 */ {0xC1, 0x65, 0x91},
    /* 0x94 */ {0xC2, 0x67, 0x7F},
    /* 0x94 */ {0xC3, 0x6C, 0x3E},
    /* 0x94 */ {0xC4, 0x6C, 0x4E},
    /* 0x94 */ {0xC5, 0x72, 0x48},
    /* 0x94 */ {0xC6, 0x72, 0xAF},
    /* 0x94 */ {0xC7, 0x73, 0xED},
    /* 0x94 */ {0xC8, 0x75, 0x54},
    /* 0x94 */ {0xC9, 0x7E, 0x41},
    /* 0x94 */ {0xCA, 0x82, 0x2C},
    /* 0x94 */ {0xCB, 0x85, 0xE9},
    /* 0x94 */ {0xCC, 0x8C, 0xA9},
    /* 0x94 */ {0xCD, 0x7B, 0xC4},
    /* 0x94 */ {0xCE, 0x91, 0xC6},
    /* 0x94 */ {0xCF, 0x71, 0x69},
    /* 0x94 */ {0xD0, 0x98, 0x12},
    /* 0x94 */ {0xD1, 0x98, 0xEF},
    /* 0x94 */ {0xD2, 0x63, 0x3D},
    /* 0x94 */ {0xD3, 0x66, 0x69},
    /* 0x94 */ {0xD4, 0x75, 0x6A},
    /* 0x94 */ {0xD5, 0x76, 0xE4},
    /* 0x94 */ {0xD6, 0x78, 0xD0},
    /* 0x94 */ {0xD7, 0x85, 0x43},
    /* 0x94 */ {0xD8, 0x86, 0xEE},
    /* 0x94 */ {0xD9, 0x53, 0x2A},
    /* 0x94 */ {0xDA, 0x53, 0x51},
    /* 0x94 */ {0xDB, 0x54, 0x26},
    /* 0x94 */ {0xDC, 0x59, 0x83},
    /* 0x94 */ {0xDD, 0x5E, 0x87},
    /* 0x94 */ {0xDE, 0x5F, 0x7C},
    /* 0x94 */ {0xDF, 0x60, 0xB2},
    /* 0x94 */ {0xE0, 0x62, 0x49},
    /* 0x94 */ {0xE1, 0x62, 0x79},
    /* 0x94 */ {0xE2, 0x62, 0xAB},
    /* 0x94 */ {0xE3, 0x65, 0x90},
    /* 0x94 */ {0xE4, 0x6B, 0xD4},
    /* 0x94 */ {0xE5, 0x6C, 0xCC},
    /* 0x94 */ {0xE6, 0x75, 0xB2},
    /* 0x94 */ {0xE7, 0x76, 0xAE},
    /* 0x94 */ {0xE8, 0x78, 0x91},
    /* 0x94 */ {0xE9, 0x79, 0xD8},
    /* 0x94 */ {0xEA, 0x7D, 0xCB},
    /* 0x94 */ {0xEB, 0x7F, 0x77},
    /* 0x94 */ {0xEC, 0x80, 0xA5},
    /* 0x94 */ {0xED, 0x88, 0xAB},
    /* 0x94 */ {0xEE, 0x8A, 0xB9},
    /* 0x94 */ {0xEF, 0x8C, 0xBB},
    /* 0x94 */ {0xF0, 0x90, 0x7F},
    /* 0x94 */ {0xF1, 0x97, 0x5E},
    /* 0x94 */ {0xF2, 0x98, 0xDB},
    /* 0x94 */ {0xF3, 0x6A, 0x0B},
    /* 0x94 */ {0xF4, 0x7C, 0x38},
    /* 0x94 */ {0xF5, 0x50, 0x99},
    /* 0x94 */ {0xF6, 0x5C, 0x3E},
    /* 0x94 */ {0xF7, 0x5F, 0xAE},
    /* 0x94 */ {0xF8, 0x67, 0x87},
    /* 0x94 */ {0xF9, 0x6B, 0xD8},
    /* 0x94 */ {0xFA, 0x74, 0x35},
    /* 0x94 */ {0xFB, 0x77, 0x09},
    /* 0x94 */ {0xFC, 0x7F, 0x8E},
    /* 0x95 */ {0x40, 0x9F, 0x3B},
    /* 0x95 */ {0x41, 0x67, 0xCA},
    /* 0x95 */ {0x42, 0x7A, 0x17},
    /* 0x95 */ {0x43, 0x53, 0x39},
    /* 0x95 */ {0x44, 0x75, 0x8B},
    /* 0x95 */ {0x45, 0x9A, 0xED},
    /* 0x95 */ {0x46, 0x5F, 0x66},
    /* 0x95 */ {0x47, 0x81, 0x9D},
    /* 0x95 */ {0x48, 0x83, 0xF1},
    /* 0x95 */ {0x49, 0x80, 0x98},
    /* 0x95 */ {0x4A, 0x5F, 0x3C},
    /* 0x95 */ {0x4B, 0x5F, 0xC5},
    /* 0x95 */ {0x4C, 0x75, 0x62},
    /* 0x95 */ {0x4D, 0x7B, 0x46},
    /* 0x95 */ {0x4E, 0x90, 0x3C},
    /* 0x95 */ {0x4F, 0x68, 0x67},
    /* 0x95 */ {0x50, 0x59, 0xEB},
    /* 0x95 */ {0x51, 0x5A, 0x9B},
    /* 0x95 */ {0x52, 0x7D, 0x10},
    /* 0x95 */ {0x53, 0x76, 0x7E},
    /* 0x95 */ {0x54, 0x8B, 0x2C},
    /* 0x95 */ {0x55, 0x4F, 0xF5},
    /* 0x95 */ {0x56, 0x5F, 0x6A},
    /* 0x95 */ {0x57, 0x6A, 0x19},
    /* 0x95 */ {0x58, 0x6C, 0x37},
    /* 0x95 */ {0x59, 0x6F, 0x02},
    /* 0x95 */ {0x5A, 0x74, 0xE2},
    /* 0x95 */ {0x5B, 0x79, 0x68},
    /* 0x95 */ {0x5C, 0x88, 0x68},
    /* 0x95 */ {0x5D, 0x8A, 0x55},
    /* 0x95 */ {0x5E, 0x8C, 0x79},
    /* 0x95 */ {0x5F, 0x5E, 0xDF},
    /* 0x95 */ {0x60, 0x63, 0xCF},
    /* 0x95 */ {0x61, 0x75, 0xC5},
    /* 0x95 */ {0x62, 0x79, 0xD2},
    /* 0x95 */ {0x63, 0x82, 0xD7},
    /* 0x95 */ {0x64, 0x93, 0x28},
    /* 0x95 */ {0x65, 0x92, 0xF2},
    /* 0x95 */ {0x66, 0x84, 0x9C},
    /* 0x95 */ {0x67, 0x86, 0xED},
    /* 0x95 */ {0x68, 0x9C, 0x2D},
    /* 0x95 */ {0x69, 0x54, 0xC1},
    /* 0x95 */ {0x6A, 0x5F, 0x6C},
    /* 0x95 */ {0x6B, 0x65, 0x8C},
    /* 0x95 */ {0x6C, 0x6D, 0x5C},
    /* 0x95 */ {0x6D, 0x70, 0x15},
    /* 0x95 */ {0x6E, 0x8C, 0xA7},
    /* 0x95 */ {0x6F, 0x8C, 0xD3},
    /* 0x95 */ {0x70, 0x98, 0x3B},
    /* 0x95 */ {0x71, 0x65, 0x4F},
    /* 0x95 */ {0x72, 0x74, 0xF6},
    /* 0x95 */ {0x73, 0x4E, 0x0D},
    /* 0x95 */ {0x74, 0x4E, 0xD8},
    /* 0x95 */ {0x75, 0x57, 0xE0},
    /* 0x95 */ {0x76, 0x59, 0x2B},
    /* 0x95 */ {0x77, 0x5A, 0x66},
    /* 0x95 */ {0x78, 0x5B, 0xCC},
    /* 0x95 */ {0x79, 0x51, 0xA8},
    /* 0x95 */ {0x7A, 0x5E, 0x03},
    /* 0x95 */ {0x7B, 0x5E, 0x9C},
    /* 0x95 */ {0x7C, 0x60, 0x16},
    /* 0x95 */ {0x7D, 0x62, 0x76},
    /* 0x95 */ {0x7E, 0x65, 0x77},
    /* 0x95 */ {0x80, 0x65, 0xA7},
    /* 0x95 */ {0x81, 0x66, 0x6E},
    /* 0x95 */ {0x82, 0x6D, 0x6E},
    /* 0x95 */ {0x83, 0x72, 0x36},
    /* 0x95 */ {0x84, 0x7B, 0x26},
    /* 0x95 */ {0x85, 0x81, 0x50},
    /* 0x95 */ {0x86, 0x81, 0x9A},
    /* 0x95 */ {0x87, 0x82, 0x99},
    /* 0x95 */ {0x88, 0x8B, 0x5C},
    /* 0x95 */ {0x89, 0x8C, 0xA0},
    /* 0x95 */ {0x8A, 0x8C, 0xE6},
    /* 0x95 */ {0x8B, 0x8D, 0x74},
    /* 0x95 */ {0x8C, 0x96, 0x1C},
    /* 0x95 */ {0x8D, 0x96, 0x44},
    /* 0x95 */ {0x8E, 0x4F, 0xAE},
    /* 0x95 */ {0x8F, 0x64, 0xAB},
    /* 0x95 */ {0x90, 0x6B, 0x66},
    /* 0x95 */ {0x91, 0x82, 0x1E},
    /* 0x95 */ {0x92, 0x84, 0x61},
    /* 0x95 */ {0x93, 0x85, 0x6A},
    /* 0x95 */ {0x94, 0x90, 0xE8},
    /* 0x95 */ {0x95, 0x5C, 0x01},
    /* 0x95 */ {0x96, 0x69, 0x53},
    /* 0x95 */ {0x97, 0x98, 0xA8},
    /* 0x95 */ {0x98, 0x84, 0x7A},
    /* 0x95 */ {0x99, 0x85, 0x57},
    /* 0x95 */ {0x9A, 0x4F, 0x0F},
    /* 0x95 */ {0x9B, 0x52, 0x6F},
    /* 0x95 */ {0x9C, 0x5F, 0xA9},
    /* 0x95 */ {0x9D, 0x5E, 0x45},
    /* 0x95 */ {0x9E, 0x67, 0x0D},
    /* 0x95 */ {0x9F, 0x79, 0x8F},
    /* 0x95 */ {0xA0, 0x81, 0x79},
    /* 0x95 */ {0xA1, 0x89, 0x07},
    /* 0x95 */ {0xA2, 0x89, 0x86},
    /* 0x95 */ {0xA3, 0x6D, 0xF5},
    /* 0x95 */ {0xA4, 0x5F, 0x17},
    /* 0x95 */ {0xA5, 0x62, 0x55},
    /* 0x95 */ {0xA6, 0x6C, 0xB8},
    /* 0x95 */ {0xA7, 0x4E, 0xCF},
    /* 0x95 */ {0xA8, 0x72, 0x69},
    /* 0x95 */ {0xA9, 0x9B, 0x92},
    /* 0x95 */ {0xAA, 0x52, 0x06},
    /* 0x95 */ {0xAB, 0x54, 0x3B},
    /* 0x95 */ {0xAC, 0x56, 0x74},
    /* 0x95 */ {0xAD, 0x58, 0xB3},
    /* 0x95 */ {0xAE, 0x61, 0xA4},
    /* 0x95 */ {0xAF, 0x62, 0x6E},
    /* 0x95 */ {0xB0, 0x71, 0x1A},
    /* 0x95 */ {0xB1, 0x59, 0x6E},
    /* 0x95 */ {0xB2, 0x7C, 0x89},
    /* 0x95 */ {0xB3, 0x7C, 0xDE},
    /* 0x95 */ {0xB4, 0x7D, 0x1B},
    /* 0x95 */ {0xB5, 0x96, 0xF0},
    /* 0x95 */ {0xB6, 0x65, 0x87},
    /* 0x95 */ {0xB7, 0x80, 0x5E},
    /* 0x95 */ {0xB8, 0x4E, 0x19},
    /* 0x95 */ {0xB9, 0x4F, 0x75},
    /* 0x95 */ {0xBA, 0x51, 0x75},
    /* 0x95 */ {0xBB, 0x58, 0x40},
    /* 0x95 */ {0xBC, 0x5E, 0x63},
    /* 0x95 */ {0xBD, 0x5E, 0x73},
    /* 0x95 */ {0xBE, 0x5F, 0x0A},
    /* 0x95 */ {0xBF, 0x67, 0xC4},
    /* 0x95 */ {0xC0, 0x4E, 0x26},
    /* 0x95 */ {0xC1, 0x85, 0x3D},
    /* 0x95 */ {0xC2, 0x95, 0x89},
    /* 0x95 */ {0xC3, 0x96, 0x5B},
    /* 0x95 */ {0xC4, 0x7C, 0x73},
    /* 0x95 */ {0xC5, 0x98, 0x01},
    /* 0x95 */ {0xC6, 0x50, 0xFB},
    /* 0x95 */ {0xC7, 0x58, 0xC1},
    /* 0x95 */ {0xC8, 0x76, 0x56},
    /* 0x95 */ {0xC9, 0x78, 0xA7},
    /* 0x95 */ {0xCA, 0x52, 0x25},
    /* 0x95 */ {0xCB, 0x77, 0xA5},
    /* 0x95 */ {0xCC, 0x85, 0x11},
    /* 0x95 */ {0xCD, 0x7B, 0x86},
    /* 0x95 */ {0xCE, 0x50, 0x4F},
    /* 0x95 */ {0xCF, 0x59, 0x09},
    /* 0x95 */ {0xD0, 0x72, 0x47},
    /* 0x95 */ {0xD1, 0x7B, 0xC7},
    /* 0x95 */ {0xD2, 0x7D, 0xE8},
    /* 0x95 */ {0xD3, 0x8F, 0xBA},
    /* 0x95 */ {0xD4, 0x8F, 0xD4},
    /* 0x95 */ {0xD5, 0x90, 0x4D},
    /* 0x95 */ {0xD6, 0x4F, 0xBF},
    /* 0x95 */ {0xD7, 0x52, 0xC9},
    /* 0x95 */ {0xD8, 0x5A, 0x29},
    /* 0x95 */ {0xD9, 0x5F, 0x01},
    /* 0x95 */ {0xDA, 0x97, 0xAD},
    /* 0x95 */ {0xDB, 0x4F, 0xDD},
    /* 0x95 */ {0xDC, 0x82, 0x17},
    /* 0x95 */ {0xDD, 0x92, 0xEA},
    /* 0x95 */ {0xDE, 0x57, 0x03},
    /* 0x95 */ {0xDF, 0x63, 0x55},
    /* 0x95 */ {0xE0, 0x6B, 0x69},
    /* 0x95 */ {0xE1, 0x75, 0x2B},
    /* 0x95 */ {0xE2, 0x88, 0xDC},
    /* 0x95 */ {0xE3, 0x8F, 0x14},
    /* 0x95 */ {0xE4, 0x7A, 0x42},
    /* 0x95 */ {0xE5, 0x52, 0xDF},
    /* 0x95 */ {0xE6, 0x58, 0x93},
    /* 0x95 */ {0xE7, 0x61, 0x55},
    /* 0x95 */ {0xE8, 0x62, 0x0A},
    /* 0x95 */ {0xE9, 0x66, 0xAE},
    /* 0x95 */ {0xEA, 0x6B, 0xCD},
    /* 0x95 */ {0xEB, 0x7C, 0x3F},
    /* 0x95 */ {0xEC, 0x83, 0xE9},
    /* 0x95 */ {0xED, 0x50, 0x23},
    /* 0x95 */ {0xEE, 0x4F, 0xF8},
    /* 0x95 */ {0xEF, 0x53, 0x05},
    /* 0x95 */ {0xF0, 0x54, 0x46},
    /* 0x95 */ {0xF1, 0x58, 0x31},
    /* 0x95 */ {0xF2, 0x59, 0x49},
    /* 0x95 */ {0xF3, 0x5B, 0x9D},
    /* 0x95 */ {0xF4, 0x5C, 0xF0},
    /* 0x95 */ {0xF5, 0x5C, 0xEF},
    /* 0x95 */ {0xF6, 0x5D, 0x29},
    /* 0x95 */ {0xF7, 0x5E, 0x96},
    /* 0x95 */ {0xF8, 0x62, 0xB1},
    /* 0x95 */ {0xF9, 0x63, 0x67},
    /* 0x95 */ {0xFA, 0x65, 0x3E},
    /* 0x95 */ {0xFB, 0x65, 0xB9},
    /* 0x95 */ {0xFC, 0x67, 0x0B},
    /* 0x96 */ {0x40, 0x6C, 0xD5},
    /* 0x96 */ {0x41, 0x6C, 0xE1},
    /* 0x96 */ {0x42, 0x70, 0xF9},
    /* 0x96 */ {0x43, 0x78, 0x32},
    /* 0x96 */ {0x44, 0x7E, 0x2B},
    /* 0x96 */ {0x45, 0x80, 0xDE},
    /* 0x96 */ {0x46, 0x82, 0xB3},
    /* 0x96 */ {0x47, 0x84, 0x0C},
    /* 0x96 */ {0x48, 0x84, 0xEC},
    /* 0x96 */ {0x49, 0x87, 0x02},
    /* 0x96 */ {0x4A, 0x89, 0x12},
    /* 0x96 */ {0x4B, 0x8A, 0x2A},
    /* 0x96 */ {0x4C, 0x8C, 0x4A},
    /* 0x96 */ {0x4D, 0x90, 0xA6},
    /* 0x96 */ {0x4E, 0x92, 0xD2},
    /* 0x96 */ {0x4F, 0x98, 0xFD},
    /* 0x96 */ {0x50, 0x9C, 0xF3},
    /* 0x96 */ {0x51, 0x9D, 0x6C},
    /* 0x96 */ {0x52, 0x4E, 0x4F},
    /* 0x96 */ {0x53, 0x4E, 0xA1},
    /* 0x96 */ {0x54, 0x50, 0x8D},
    /* 0x96 */ {0x55, 0x52, 0x56},
    /* 0x96 */ {0x56, 0x57, 0x4A},
    /* 0x96 */ {0x57, 0x59, 0xA8},
    /* 0x96 */ {0x58, 0x5E, 0x3D},
    /* 0x96 */ {0x59, 0x5F, 0xD8},
    /* 0x96 */ {0x5A, 0x5F, 0xD9},
    /* 0x96 */ {0x5B, 0x62, 0x3F},
    /* 0x96 */ {0x5C, 0x66, 0xB4},
    /* 0x96 */ {0x5D, 0x67, 0x1B},
    /* 0x96 */ {0x5E, 0x67, 0xD0},
    /* 0x96 */ {0x5F, 0x68, 0xD2},
    /* 0x96 */ {0x60, 0x51, 0x92},
    /* 0x96 */ {0x61, 0x7D, 0x21},
    /* 0x96 */ {0x62, 0x80, 0xAA},
    /* 0x96 */ {0x63, 0x81, 0xA8},
    /* 0x96 */ {0x64, 0x8B, 0x00},
    /* 0x96 */ {0x65, 0x8C, 0x8C},
    /* 0x96 */ {0x66, 0x8C, 0xBF},
    /* 0x96 */ {0x67, 0x92, 0x7E},
    /* 0x96 */ {0x68, 0x96, 0x32},
    /* 0x96 */ {0x69, 0x54, 0x20},
    /* 0x96 */ {0x6A, 0x98, 0x2C},
    /* 0x96 */ {0x6B, 0x53, 0x17},
    /* 0x96 */ {0x6C, 0x50, 0xD5},
    /* 0x96 */ {0x6D, 0x53, 0x5C},
    /* 0x96 */ {0x6E, 0x58, 0xA8},
    /* 0x96 */ {0x6F, 0x64, 0xB2},
    /* 0x96 */ {0x70, 0x67, 0x34},
    /* 0x96 */ {0x71, 0x72, 0x67},
    /* 0x96 */ {0x72, 0x77, 0x66},
    /* 0x96 */ {0x73, 0x7A, 0x46},
    /* 0x96 */ {0x74, 0x91, 0xE6},
    /* 0x96 */ {0x75, 0x52, 0xC3},
    /* 0x96 */ {0x76, 0x6C, 0xA1},
    /* 0x96 */ {0x77, 0x6B, 0x86},
    /* 0x96 */ {0x78, 0x58, 0x00},
    /* 0x96 */ {0x79, 0x5E, 0x4C},
    /* 0x96 */ {0x7A, 0x59, 0x54},
    /* 0x96 */ {0x7B, 0x67, 0x2C},
    /* 0x96 */ {0x7C, 0x7F, 0xFB},
    /* 0x96 */ {0x7D, 0x51, 0xE1},
    /* 0x96 */ {0x7E, 0x76, 0xC6},
    /* 0x96 */ {0x80, 0x64, 0x69},
    /* 0x96 */ {0x81, 0x78, 0xE8},
    /* 0x96 */ {0x82, 0x9B, 0x54},
    /* 0x96 */ {0x83, 0x9E, 0xBB},
    /* 0x96 */ {0x84, 0x57, 0xCB},
    /* 0x96 */ {0x85, 0x59, 0xB9},
    /* 0x96 */ {0x86, 0x66, 0x27},
    /* 0x96 */ {0x87, 0x67, 0x9A},
    /* 0x96 */ {0x88, 0x6B, 0xCE},
    /* 0x96 */ {0x89, 0x54, 0xE9},
    /* 0x96 */ {0x8A, 0x69, 0xD9},
    /* 0x96 */ {0x8B, 0x5E, 0x55},
    /* 0x96 */ {0x8C, 0x81, 0x9C},
    /* 0x96 */ {0x8D, 0x67, 0x95},
    /* 0x96 */ {0x8E, 0x9B, 0xAA},
    /* 0x96 */ {0x8F, 0x67, 0xFE},
    /* 0x96 */ {0x90, 0x9C, 0x52},
    /* 0x96 */ {0x91, 0x68, 0x5D},
    /* 0x96 */ {0x92, 0x4E, 0xA6},
    /* 0x96 */ {0x93, 0x4F, 0xE3},
    /* 0x96 */ {0x94, 0x53, 0xC8},
    /* 0x96 */ {0x95, 0x62, 0xB9},
    /* 0x96 */ {0x96, 0x67, 0x2B},
    /* 0x96 */ {0x97, 0x6C, 0xAB},
    /* 0x96 */ {0x98, 0x8F, 0xC4},
    /* 0x96 */ {0x99, 0x4F, 0xAD},
    /* 0x96 */ {0x9A, 0x7E, 0x6D},
    /* 0x96 */ {0x9B, 0x9E, 0xBF},
    /* 0x96 */ {0x9C, 0x4E, 0x07},
    /* 0x96 */ {0x9D, 0x61, 0x62},
    /* 0x96 */ {0x9E, 0x6E, 0x80},
    /* 0x96 */ {0x9F, 0x6F, 0x2B},
    /* 0x96 */ {0xA0, 0x85, 0x13},
    /* 0x96 */ {0xA1, 0x54, 0x73},
    /* 0x96 */ {0xA2, 0x67, 0x2A},
    /* 0x96 */ {0xA3, 0x9B, 0x45},
    /* 0x96 */ {0xA4, 0x5D, 0xF3},
    /* 0x96 */ {0xA5, 0x7B, 0x95},
    /* 0x96 */ {0xA6, 0x5C, 0xAC},
    /* 0x96 */ {0xA7, 0x5B, 0xC6},
    /* 0x96 */ {0xA8, 0x87, 0x1C},
    /* 0x96 */ {0xA9, 0x6E, 0x4A},
    /* 0x96 */ {0xAA, 0x84, 0xD1},
    /* 0x96 */ {0xAB, 0x7A, 0x14},
    /* 0x96 */ {0xAC, 0x81, 0x08},
    /* 0x96 */ {0xAD, 0x59, 0x99},
    /* 0x96 */ {0xAE, 0x7C, 0x8D},
    /* 0x96 */ {0xAF, 0x6C, 0x11},
    /* 0x96 */ {0xB0, 0x77, 0x20},
    /* 0x96 */ {0xB1, 0x52, 0xD9},
    /* 0x96 */ {0xB2, 0x59, 0x22},
    /* 0x96 */ {0xB3, 0x71, 0x21},
    /* 0x96 */ {0xB4, 0x72, 0x5F},
    /* 0x96 */ {0xB5, 0x77, 0xDB},
    /* 0x96 */ {0xB6, 0x97, 0x27},
    /* 0x96 */ {0xB7, 0x9D, 0x61},
    /* 0x96 */ {0xB8, 0x69, 0x0B},
    /* 0x96 */ {0xB9, 0x5A, 0x7F},
    /* 0x96 */ {0xBA, 0x5A, 0x18},
    /* 0x96 */ {0xBB, 0x51, 0xA5},
    /* 0x96 */ {0xBC, 0x54, 0x0D},
    /* 0x96 */ {0xBD, 0x54, 0x7D},
    /* 0x96 */ {0xBE, 0x66, 0x0E},
    /* 0x96 */ {0xBF, 0x76, 0xDF},
    /* 0x96 */ {0xC0, 0x8F, 0xF7},
    /* 0x96 */ {0xC1, 0x92, 0x98},
    /* 0x96 */ {0xC2, 0x9C, 0xF4},
    /* 0x96 */ {0xC3, 0x59, 0xEA},
    /* 0x96 */ {0xC4, 0x72, 0x5D},
    /* 0x96 */ {0xC5, 0x6E, 0xC5},
    /* 0x96 */ {0xC6, 0x51, 0x4D},
    /* 0x96 */ {0xC7, 0x68, 0xC9},
    /* 0x96 */ {0xC8, 0x7D, 0xBF},
    /* 0x96 */ {0xC9, 0x7D, 0xEC},
    /* 0x96 */ {0xCA, 0x97, 0x62},
    /* 0x96 */ {0xCB, 0x9E, 0xBA},
    /* 0x96 */ {0xCC, 0x64, 0x78},
    /* 0x96 */ {0xCD, 0x6A, 0x21},
    /* 0x96 */ {0xCE, 0x83, 0x02},
    /* 0x96 */ {0xCF, 0x59, 0x84},
    /* 0x96 */ {0xD0, 0x5B, 0x5F},
    /* 0x96 */ {0xD1, 0x6B, 0xDB},
    /* 0x96 */ {0xD2, 0x73, 0x1B},
    /* 0x96 */ {0xD3, 0x76, 0xF2},
    /* 0x96 */ {0xD4, 0x7D, 0xB2},
    /* 0x96 */ {0xD5, 0x80, 0x17},
    /* 0x96 */ {0xD6, 0x84, 0x99},
    /* 0x96 */ {0xD7, 0x51, 0x32},
    /* 0x96 */ {0xD8, 0x67, 0x28},
    /* 0x96 */ {0xD9, 0x9E, 0xD9},
    /* 0x96 */ {0xDA, 0x76, 0xEE},
    /* 0x96 */ {0xDB, 0x67, 0x62},
    /* 0x96 */ {0xDC, 0x52, 0xFF},
    /* 0x96 */ {0xDD, 0x99, 0x05},
    /* 0x96 */ {0xDE, 0x5C, 0x24},
    /* 0x96 */ {0xDF, 0x62, 0x3B},
    /* 0x96 */ {0xE0, 0x7C, 0x7E},
    /* 0x96 */ {0xE1, 0x8C, 0xB0},
    /* 0x96 */ {0xE2, 0x55, 0x4F},
    /* 0x96 */ {0xE3, 0x60, 0xB6},
    /* 0x96 */ {0xE4, 0x7D, 0x0B},
    /* 0x96 */ {0xE5, 0x95, 0x80},
    /* 0x96 */ {0xE6, 0x53, 0x01},
    /* 0x96 */ {0xE7, 0x4E, 0x5F},
    /* 0x96 */ {0xE8, 0x51, 0xB6},
    /* 0x96 */ {0xE9, 0x59, 0x1C},
    /* 0x96 */ {0xEA, 0x72, 0x3A},
    /* 0x96 */ {0xEB, 0x80, 0x36},
    /* 0x96 */ {0xEC, 0x91, 0xCE},
    /* 0x96 */ {0xED, 0x5F, 0x25},
    /* 0x96 */ {0xEE, 0x77, 0xE2},
    /* 0x96 */ {0xEF, 0x53, 0x84},
    /* 0x96 */ {0xF0, 0x5F, 0x79},
    /* 0x96 */ {0xF1, 0x7D, 0x04},
    /* 0x96 */ {0xF2, 0x85, 0xAC},
    /* 0x96 */ {0xF3, 0x8A, 0x33},
    /* 0x96 */ {0xF4, 0x8E, 0x8D},
    /* 0x96 */ {0xF5, 0x97, 0x56},
    /* 0x96 */ {0xF6, 0x67, 0xF3},
    /* 0x96 */ {0xF7, 0x85, 0xAE},
    /* 0x96 */ {0xF8, 0x94, 0x53},
    /* 0x96 */ {0xF9, 0x61, 0x09},
    /* 0x96 */ {0xFA, 0x61, 0x08},
    /* 0x96 */ {0xFB, 0x6C, 0xB9},
    /* 0x96 */ {0xFC, 0x76, 0x52},
    /* 0x97 */ {0x40, 0x8A, 0xED},
    /* 0x97 */ {0x41, 0x8F, 0x38},
    /* 0x97 */ {0x42, 0x55, 0x2F},
    /* 0x97 */ {0x43, 0x4F, 0x51},
    /* 0x97 */ {0x44, 0x51, 0x2A},
    /* 0x97 */ {0x45, 0x52, 0xC7},
    /* 0x97 */ {0x46, 0x53, 0xCB},
    /* 0x97 */ {0x47, 0x5B, 0xA5},
    /* 0x97 */ {0x48, 0x5E, 0x7D},
    /* 0x97 */ {0x49, 0x60, 0xA0},
    /* 0x97 */ {0x4A, 0x61, 0x82},
    /* 0x97 */ {0x4B, 0x63, 0xD6},
    /* 0x97 */ {0x4C, 0x67, 0x09},
    /* 0x97 */ {0x4D, 0x67, 0xDA},
    /* 0x97 */ {0x4E, 0x6E, 0x67},
    /* 0x97 */ {0x4F, 0x6D, 0x8C},
    /* 0x97 */ {0x50, 0x73, 0x36},
    /* 0x97 */ {0x51, 0x73, 0x37},
    /* 0x97 */ {0x52, 0x75, 0x31},
    /* 0x97 */ {0x53, 0x79, 0x50},
    /* 0x97 */ {0x54, 0x88, 0xD5},
    /* 0x97 */ {0x55, 0x8A, 0x98},
    /* 0x97 */ {0x56, 0x90, 0x4A},
    /* 0x97 */ {0x57, 0x90, 0x91},
    /* 0x97 */ {0x58, 0x90, 0xF5},
    /* 0x97 */ {0x59, 0x96, 0xC4},
    /* 0x97 */ {0x5A, 0x87, 0x8D},
    /* 0x97 */ {0x5B, 0x59, 0x15},
    /* 0x97 */ {0x5C, 0x4E, 0x88},
    /* 0x97 */ {0x5D, 0x4F, 0x59},
    /* 0x97 */ {0x5E, 0x4E, 0x0E},
    /* 0x97 */ {0x5F, 0x8A, 0x89},
    /* 0x97 */ {0x60, 0x8F, 0x3F},
    /* 0x97 */ {0x61, 0x98, 0x10},
    /* 0x97 */ {0x62, 0x50, 0xAD},
    /* 0x97 */ {0x63, 0x5E, 0x7C},
    /* 0x97 */ {0x64, 0x59, 0x96},
    /* 0x97 */ {0x65, 0x5B, 0xB9},
    /* 0x97 */ {0x66, 0x5E, 0xB8},
    /* 0x97 */ {0x67, 0x63, 0xDA},
    /* 0x97 */ {0x68, 0x63, 0xFA},
    /* 0x97 */ {0x69, 0x64, 0xC1},
    /* 0x97 */ {0x6A, 0x66, 0xDC},
    /* 0x97 */ {0x6B, 0x69, 0x4A},
    /* 0x97 */ {0x6C, 0x69, 0xD8},
    /* 0x97 */ {0x6D, 0x6D, 0x0B},
    /* 0x97 */ {0x6E, 0x6E, 0xB6},
    /* 0x97 */ {0x6F, 0x71, 0x94},
    /* 0x97 */ {0x70, 0x75, 0x28},
    /* 0x97 */ {0x71, 0x7A, 0xAF},
    /* 0x97 */ {0x72, 0x7F, 0x8A},
    /* 0x97 */ {0x73, 0x80, 0x00},
    /* 0x97 */ {0x74, 0x84, 0x49},
    /* 0x97 */ {0x75, 0x84, 0xC9},
    /* 0x97 */ {0x76, 0x89, 0x81},
    /* 0x97 */ {0x77, 0x8B, 0x21},
    /* 0x97 */ {0x78, 0x8E, 0x0A},
    /* 0x97 */ {0x79, 0x90, 0x65},
    /* 0x97 */ {0x7A, 0x96, 0x7D},
    /* 0x97 */ {0x7B, 0x99, 0x0A},
    /* 0x97 */ {0x7C, 0x61, 0x7E},
    /* 0x97 */ {0x7D, 0x62, 0x91},
    /* 0x97 */ {0x7E, 0x6B, 0x32},
    /* 0x97 */ {0x80, 0x6C, 0x83},
    /* 0x97 */ {0x81, 0x6D, 0x74},
    /* 0x97 */ {0x82, 0x7F, 0xCC},
    /* 0x97 */ {0x83, 0x7F, 0xFC},
    /* 0x97 */ {0x84, 0x6D, 0xC0},
    /* 0x97 */ {0x85, 0x7F, 0x85},
    /* 0x97 */ {0x86, 0x87, 0xBA},
    /* 0x97 */ {0x87, 0x88, 0xF8},
    /* 0x97 */ {0x88, 0x67, 0x65},
    /* 0x97 */ {0x89, 0x83, 0xB1},
    /* 0x97 */ {0x8A, 0x98, 0x3C},
    /* 0x97 */ {0x8B, 0x96, 0xF7},
    /* 0x97 */ {0x8C, 0x6D, 0x1B},
    /* 0x97 */ {0x8D, 0x7D, 0x61},
    /* 0x97 */ {0x8E, 0x84, 0x3D},
    /* 0x97 */ {0x8F, 0x91, 0x6A},
    /* 0x97 */ {0x90, 0x4E, 0x71},
    /* 0x97 */ {0x91, 0x53, 0x75},
    /* 0x97 */ {0x92, 0x5D, 0x50},
    /* 0x97 */ {0x93, 0x6B, 0x04},
    /* 0x97 */ {0x94, 0x6F, 0xEB},
    /* 0x97 */ {0x95, 0x85, 0xCD},
    /* 0x97 */ {0x96, 0x86, 0x2D},
    /* 0x97 */ {0x97, 0x89, 0xA7},
    /* 0x97 */ {0x98, 0x52, 0x29},
    /* 0x97 */ {0x99, 0x54, 0x0F},
    /* 0x97 */ {0x9A, 0x5C, 0x65},
    /* 0x97 */ {0x9B, 0x67, 0x4E},
    /* 0x97 */ {0x9C, 0x68, 0xA8},
    /* 0x97 */ {0x9D, 0x74, 0x06},
    /* 0x97 */ {0x9E, 0x74, 0x83},
    /* 0x97 */ {0x9F, 0x75, 0xE2},
    /* 0x97 */ {0xA0, 0x88, 0xCF},
    /* 0x97 */ {0xA1, 0x88, 0xE1},
    /* 0x97 */ {0xA2, 0x91, 0xCC},
    /* 0x97 */ {0xA3, 0x96, 0xE2},
    /* 0x97 */ {0xA4, 0x96, 0x78},
    /* 0x97 */ {0xA5, 0x5F, 0x8B},
    /* 0x97 */ {0xA6, 0x73, 0x87},
    /* 0x97 */ {0xA7, 0x7A, 0xCB},
    /* 0x97 */ {0xA8, 0x84, 0x4E},
    /* 0x97 */ {0xA9, 0x63, 0xA0},
    /* 0x97 */ {0xAA, 0x75, 0x65},
    /* 0x97 */ {0xAB, 0x52, 0x89},
    /* 0x97 */ {0xAC, 0x6D, 0x41},
    /* 0x97 */ {0xAD, 0x6E, 0x9C},
    /* 0x97 */ {0xAE, 0x74, 0x09},
    /* 0x97 */ {0xAF, 0x75, 0x59},
    /* 0x97 */ {0xB0, 0x78, 0x6B},
    /* 0x97 */ {0xB1, 0x7C, 0x92},
    /* 0x97 */ {0xB2, 0x96, 0x86},
    /* 0x97 */ {0xB3, 0x7A, 0xDC},
    /* 0x97 */ {0xB4, 0x9F, 0x8D},
    /* 0x97 */ {0xB5, 0x4F, 0xB6},
    /* 0x97 */ {0xB6, 0x61, 0x6E},
    /* 0x97 */ {0xB7, 0x65, 0xC5},
    /* 0x97 */ {0xB8, 0x86, 0x5C},
    /* 0x97 */ {0xB9, 0x4E, 0x86},
    /* 0x97 */ {0xBA, 0x4E, 0xAE},
    /* 0x97 */ {0xBB, 0x50, 0xDA},
    /* 0x97 */ {0xBC, 0x4E, 0x21},
    /* 0x97 */ {0xBD, 0x51, 0xCC},
    /* 0x97 */ {0xBE, 0x5B, 0xEE},
    /* 0x97 */ {0xBF, 0x65, 0x99},
    /* 0x97 */ {0xC0, 0x68, 0x81},
    /* 0x97 */ {0xC1, 0x6D, 0xBC},
    /* 0x97 */ {0xC2, 0x73, 0x1F},
    /* 0x97 */ {0xC3, 0x76, 0x42},
    /* 0x97 */ {0xC4, 0x77, 0xAD},
    /* 0x97 */ {0xC5, 0x7A, 0x1C},
    /* 0x97 */ {0xC6, 0x7C, 0xE7},
    /* 0x97 */ {0xC7, 0x82, 0x6F},
    /* 0x97 */ {0xC8, 0x8A, 0xD2},
    /* 0x97 */ {0xC9, 0x90, 0x7C},
    /* 0x97 */ {0xCA, 0x91, 0xCF},
    /* 0x97 */ {0xCB, 0x96, 0x75},
    /* 0x97 */ {0xCC, 0x98, 0x18},
    /* 0x97 */ {0xCD, 0x52, 0x9B},
    /* 0x97 */ {0xCE, 0x7D, 0xD1},
    /* 0x97 */ {0xCF, 0x50, 0x2B},
    /* 0x97 */ {0xD0, 0x53, 0x98},
    /* 0x97 */ {0xD1, 0x67, 0x97},
    /* 0x97 */ {0xD2, 0x6D, 0xCB},
    /* 0x97 */ {0xD3, 0x71, 0xD0},
    /* 0x97 */ {0xD4, 0x74, 0x33},
    /* 0x97 */ {0xD5, 0x81, 0xE8},
    /* 0x97 */ {0xD6, 0x8F, 0x2A},
    /* 0x97 */ {0xD7, 0x96, 0xA3},
    /* 0x97 */ {0xD8, 0x9C, 0x57},
    /* 0x97 */ {0xD9, 0x9E, 0x9F},
    /* 0x97 */ {0xDA, 0x74, 0x60},
    /* 0x97 */ {0xDB, 0x58, 0x41},
    /* 0x97 */ {0xDC, 0x6D, 0x99},
    /* 0x97 */ {0xDD, 0x7D, 0x2F},
    /* 0x97 */ {0xDE, 0x98, 0x5E},
    /* 0x97 */ {0xDF, 0x4E, 0xE4},
    /* 0x97 */ {0xE0, 0x4F, 0x36},
    /* 0x97 */ {0xE1, 0x4F, 0x8B},
    /* 0x97 */ {0xE2, 0x51, 0xB7},
    /* 0x97 */ {0xE3, 0x52, 0xB1},
    /* 0x97 */ {0xE4, 0x5D, 0xBA},
    /* 0x97 */ {0xE5, 0x60, 0x1C},
    /* 0x97 */ {0xE6, 0x73, 0xB2},
    /* 0x97 */ {0xE7, 0x79, 0x3C},
    /* 0x97 */ {0xE8, 0x82, 0xD3},
    /* 0x97 */ {0xE9, 0x92, 0x34},
    /* 0x97 */ {0xEA, 0x96, 0xB7},
    /* 0x97 */ {0xEB, 0x96, 0xF6},
    /* 0x97 */ {0xEC, 0x97, 0x0A},
    /* 0x97 */ {0xED, 0x9E, 0x97},
    /* 0x97 */ {0xEE, 0x9F, 0x62},
    /* 0x97 */ {0xEF, 0x66, 0xA6},
    /* 0x97 */ {0xF0, 0x6B, 0x74},
    /* 0x97 */ {0xF1, 0x52, 0x17},
    /* 0x97 */ {0xF2, 0x52, 0xA3},
    /* 0x97 */ {0xF3, 0x70, 0xC8},
    /* 0x97 */ {0xF4, 0x88, 0xC2},
    /* 0x97 */ {0xF5, 0x5E, 0xC9},
    /* 0x97 */ {0xF6, 0x60, 0x4B},
    /* 0x97 */ {0xF7, 0x61, 0x90},
    /* 0x97 */ {0xF8, 0x6F, 0x23},
    /* 0x97 */ {0xF9, 0x71, 0x49},
    /* 0x97 */ {0xFA, 0x7C, 0x3E},
    /* 0x97 */ {0xFB, 0x7D, 0xF4},
    /* 0x97 */ {0xFC, 0x80, 0x6F},
    /* 0x98 */ {0x40, 0x84, 0xEE},
    /* 0x98 */ {0x41, 0x90, 0x23},
    /* 0x98 */ {0x42, 0x93, 0x2C},
    /* 0x98 */ {0x43, 0x54, 0x42},
    /* 0x98 */ {0x44, 0x9B, 0x6F},
    /* 0x98 */ {0x45, 0x6A, 0xD3},
    /* 0x98 */ {0x46, 0x70, 0x89},
    /* 0x98 */ {0x47, 0x8C, 0xC2},
    /* 0x98 */ {0x48, 0x8D, 0xEF},
    /* 0x98 */ {0x49, 0x97, 0x32},
    /* 0x98 */ {0x4A, 0x52, 0xB4},
    /* 0x98 */ {0x4B, 0x5A, 0x41},
    /* 0x98 */ {0x4C, 0x5E, 0xCA},
    /* 0x98 */ {0x4D, 0x5F, 0x04},
    /* 0x98 */ {0x4E, 0x67, 0x17},
    /* 0x98 */ {0x4F, 0x69, 0x7C},
    /* 0x98 */ {0x50, 0x69, 0x94},
    /* 0x98 */ {0x51, 0x6D, 0x6A},
    /* 0x98 */ {0x52, 0x6F, 0x0F},
    /* 0x98 */ {0x53, 0x72, 0x62},
    /* 0x98 */ {0x54, 0x72, 0xFC},
    /* 0x98 */ {0x55, 0x7B, 0xED},
    /* 0x98 */ {0x56, 0x80, 0x01},
    /* 0x98 */ {0x57, 0x80, 0x7E},
    /* 0x98 */ {0x58, 0x87, 0x4B},
    /* 0x98 */ {0x59, 0x90, 0xCE},
    /* 0x98 */ {0x5A, 0x51, 0x6D},
    /* 0x98 */ {0x5B, 0x9E, 0x93},
    /* 0x98 */ {0x5C, 0x79, 0x84},
    /* 0x98 */ {0x5D, 0x80, 0x8B},
    /* 0x98 */ {0x5E, 0x93, 0x32},
    /* 0x98 */ {0x5F, 0x8A, 0xD6},
    /* 0x98 */ {0x60, 0x50, 0x2D},
    /* 0x98 */ {0x61, 0x54, 0x8C},
    /* 0x98 */ {0x62, 0x8A, 0x71},
    /* 0x98 */ {0x63, 0x6B, 0x6A},
    /* 0x98 */ {0x64, 0x8C, 0xC4},
    /* 0x98 */ {0x65, 0x81, 0x07},
    /* 0x98 */ {0x66, 0x60, 0xD1},
    /* 0x98 */ {0x67, 0x67, 0xA0},
    /* 0x98 */ {0x68, 0x9D, 0xF2},
    /* 0x98 */ {0x69, 0x4E, 0x99},
    /* 0x98 */ {0x6A, 0x4E, 0x98},
    /* 0x98 */ {0x6B, 0x9C, 0x10},
    /* 0x98 */ {0x6C, 0x8A, 0x6B},
    /* 0x98 */ {0x6D, 0x85, 0xC1},
    /* 0x98 */ {0x6E, 0x85, 0x68},
    /* 0x98 */ {0x6F, 0x69, 0x00},
    /* 0x98 */ {0x70, 0x6E, 0x7E},
    /* 0x98 */ {0x71, 0x78, 0x97},
    /* 0x98 */ {0x72, 0x81, 0x55},
    /* 0x98 */ {0x9F, 0x5F, 0x0C},
    /* 0x98 */ {0xA0, 0x4E, 0x10},
    /* 0x98 */ {0xA1, 0x4E, 0x15},
    /* 0x98 */ {0xA2, 0x4E, 0x2A},
    /* 0x98 */ {0xA3, 0x4E, 0x31},
    /* 0x98 */ {0xA4, 0x4E, 0x36},
    /* 0x98 */ {0xA5, 0x4E, 0x3C},
    /* 0x98 */ {0xA6, 0x4E, 0x3F},
    /* 0x98 */ {0xA7, 0x4E, 0x42},
    /* 0x98 */ {0xA8, 0x4E, 0x56},
    /* 0x98 */ {0xA9, 0x4E, 0x58},
    /* 0x98 */ {0xAA, 0x4E, 0x82},
    /* 0x98 */ {0xAB, 0x4E, 0x85},
    /* 0x98 */ {0xAC, 0x8C, 0x6B},
    /* 0x98 */ {0xAD, 0x4E, 0x8A},
    /* 0x98 */ {0xAE, 0x82, 0x12},
    /* 0x98 */ {0xAF, 0x5F, 0x0D},
    /* 0x98 */ {0xB0, 0x4E, 0x8E},
    /* 0x98 */ {0xB1, 0x4E, 0x9E},
    /* 0x98 */ {0xB2, 0x4E, 0x9F},
    /* 0x98 */ {0xB3, 0x4E, 0xA0},
    /* 0x98 */ {0xB4, 0x4E, 0xA2},
    /* 0x98 */ {0xB5, 0x4E, 0xB0},
    /* 0x98 */ {0xB6, 0x4E, 0xB3},
    /* 0x98 */ {0xB7, 0x4E, 0xB6},
    /* 0x98 */ {0xB8, 0x4E, 0xCE},
    /* 0x98 */ {0xB9, 0x4E, 0xCD},
    /* 0x98 */ {0xBA, 0x4E, 0xC4},
    /* 0x98 */ {0xBB, 0x4E, 0xC6},
    /* 0x98 */ {0xBC, 0x4E, 0xC2},
    /* 0x98 */ {0xBD, 0x4E, 0xD7},
    /* 0x98 */ {0xBE, 0x4E, 0xDE},
    /* 0x98 */ {0xBF, 0x4E, 0xED},
    /* 0x98 */ {0xC0, 0x4E, 0xDF},
    /* 0x98 */ {0xC1, 0x4E, 0xF7},
    /* 0x98 */ {0xC2, 0x4F, 0x09},
    /* 0x98 */ {0xC3, 0x4F, 0x5A},
    /* 0x98 */ {0xC4, 0x4F, 0x30},
    /* 0x98 */ {0xC5, 0x4F, 0x5B},
    /* 0x98 */ {0xC6, 0x4F, 0x5D},
    /* 0x98 */ {0xC7, 0x4F, 0x57},
    /* 0x98 */ {0xC8, 0x4F, 0x47},
    /* 0x98 */ {0xC9, 0x4F, 0x76},
    /* 0x98 */ {0xCA, 0x4F, 0x88},
    /* 0x98 */ {0xCB, 0x4F, 0x8F},
    /* 0x98 */ {0xCC, 0x4F, 0x98},
    /* 0x98 */ {0xCD, 0x4F, 0x7B},
    /* 0x98 */ {0xCE, 0x4F, 0x69},
    /* 0x98 */ {0xCF, 0x4F, 0x70},
    /* 0x98 */ {0xD0, 0x4F, 0x91},
    /* 0x98 */ {0xD1, 0x4F, 0x6F},
    /* 0x98 */ {0xD2, 0x4F, 0x86},
    /* 0x98 */ {0xD3, 0x4F, 0x96},
    /* 0x98 */ {0xD4, 0x51, 0x18},
    /* 0x98 */ {0xD5, 0x4F, 0xD4},
    /* 0x98 */ {0xD6, 0x4F, 0xDF},
    /* 0x98 */ {0xD7, 0x4F, 0xCE},
    /* 0x98 */ {0xD8, 0x4F, 0xD8},
    /* 0x98 */ {0xD9, 0x4F, 0xDB},
    /* 0x98 */ {0xDA, 0x4F, 0xD1},
    /* 0x98 */ {0xDB, 0x4F, 0xDA},
    /* 0x98 */ {0xDC, 0x4F, 0xD0},
    /* 0x98 */ {0xDD, 0x4F, 0xE4},
    /* 0x98 */ {0xDE, 0x4F, 0xE5},
    /* 0x98 */ {0xDF, 0x50, 0x1A},
    /* 0x98 */ {0xE0, 0x50, 0x28},
    /* 0x98 */ {0xE1, 0x50, 0x14},
    /* 0x98 */ {0xE2, 0x50, 0x2A},
    /* 0x98 */ {0xE3, 0x50, 0x25},
    /* 0x98 */ {0xE4, 0x50, 0x05},
    /* 0x98 */ {0xE5, 0x4F, 0x1C},
    /* 0x98 */ {0xE6, 0x4F, 0xF6},
    /* 0x98 */ {0xE7, 0x50, 0x21},
    /* 0x98 */ {0xE8, 0x50, 0x29},
    /* 0x98 */ {0xE9, 0x50, 0x2C},
    /* 0x98 */ {0xEA, 0x4F, 0xFE},
    /* 0x98 */ {0xEB, 0x4F, 0xEF},
    /* 0x98 */ {0xEC, 0x50, 0x11},
    /* 0x98 */ {0xED, 0x50, 0x06},
    /* 0x98 */ {0xEE, 0x50, 0x43},
    /* 0x98 */ {0xEF, 0x50, 0x47},
    /* 0x98 */ {0xF0, 0x67, 0x03},
    /* 0x98 */ {0xF1, 0x50, 0x55},
    /* 0x98 */ {0xF2, 0x50, 0x50},
    /* 0x98 */ {0xF3, 0x50, 0x48},
    /* 0x98 */ {0xF4, 0x50, 0x5A},
    /* 0x98 */ {0xF5, 0x50, 0x56},
    /* 0x98 */ {0xF6, 0x50, 0x6C},
    /* 0x98 */ {0xF7, 0x50, 0x78},
    /* 0x98 */ {0xF8, 0x50, 0x80},
    /* 0x98 */ {0xF9, 0x50, 0x9A},
    /* 0x98 */ {0xFA, 0x50, 0x85},
    /* 0x98 */ {0xFB, 0x50, 0xB4},
    /* 0x98 */ {0xFC, 0x50, 0xB2},
    /* 0x99 */ {0x40, 0x50, 0xC9},
    /* 0x99 */ {0x41, 0x50, 0xCA},
    /* 0x99 */ {0x42, 0x50, 0xB3},
    /* 0x99 */ {0x43, 0x50, 0xC2},
    /* 0x99 */ {0x44, 0x50, 0xD6},
    /* 0x99 */ {0x45, 0x50, 0xDE},
    /* 0x99 */ {0x46, 0x50, 0xE5},
    /* 0x99 */ {0x47, 0x50, 0xED},
    /* 0x99 */ {0x48, 0x50, 0xE3},
    /* 0x99 */ {0x49, 0x50, 0xEE},
    /* 0x99 */ {0x4A, 0x50, 0xF9},
    /* 0x99 */ {0x4B, 0x50, 0xF5},
    /* 0x99 */ {0x4C, 0x51, 0x09},
    /* 0x99 */ {0x4D, 0x51, 0x01},
    /* 0x99 */ {0x4E, 0x51, 0x02},
    /* 0x99 */ {0x4F, 0x51, 0x16},
    /* 0x99 */ {0x50, 0x51, 0x15},
    /* 0x99 */ {0x51, 0x51, 0x14},
    /* 0x99 */ {0x52, 0x51, 0x1A},
    /* 0x99 */ {0x53, 0x51, 0x21},
    /* 0x99 */ {0x54, 0x51, 0x3A},
    /* 0x99 */ {0x55, 0x51, 0x37},
    /* 0x99 */ {0x56, 0x51, 0x3C},
    /* 0x99 */ {0x57, 0x51, 0x3B},
    /* 0x99 */ {0x58, 0x51, 0x3F},
    /* 0x99 */ {0x59, 0x51, 0x40},
    /* 0x99 */ {0x5A, 0x51, 0x52},
    /* 0x99 */ {0x5B, 0x51, 0x4C},
    /* 0x99 */ {0x5C, 0x51, 0x54},
    /* 0x99 */ {0x5D, 0x51, 0x62},
    /* 0x99 */ {0x5E, 0x7A, 0xF8},
    /* 0x99 */ {0x5F, 0x51, 0x69},
    /* 0x99 */ {0x60, 0x51, 0x6A},
    /* 0x99 */ {0x61, 0x51, 0x6E},
    /* 0x99 */ {0x62, 0x51, 0x80},
    /* 0x99 */ {0x63, 0x51, 0x82},
    /* 0x99 */ {0x64, 0x56, 0xD8},
    /* 0x99 */ {0x65, 0x51, 0x8C},
    /* 0x99 */ {0x66, 0x51, 0x89},
    /* 0x99 */ {0x67, 0x51, 0x8F},
    /* 0x99 */ {0x68, 0x51, 0x91},
    /* 0x99 */ {0x69, 0x51, 0x93},
    /* 0x99 */ {0x6A, 0x51, 0x95},
    /* 0x99 */ {0x6B, 0x51, 0x96},
    /* 0x99 */ {0x6C, 0x51, 0xA4},
    /* 0x99 */ {0x6D, 0x51, 0xA6},
    /* 0x99 */ {0x6E, 0x51, 0xA2},
    /* 0x99 */ {0x6F, 0x51, 0xA9},
    /* 0x99 */ {0x70, 0x51, 0xAA},
    /* 0x99 */ {0x71, 0x51, 0xAB},
    /* 0x99 */ {0x72, 0x51, 0xB3},
    /* 0x99 */ {0x73, 0x51, 0xB1},
    /* 0x99 */ {0x74, 0x51, 0xB2},
    /* 0x99 */ {0x75, 0x51, 0xB0},
    /* 0x99 */ {0x76, 0x51, 0xB5},
    /* 0x99 */ {0x77, 0x51, 0xBD},
    /* 0x99 */ {0x78, 0x51, 0xC5},
    /* 0x99 */ {0x79, 0x51, 0xC9},
    /* 0x99 */ {0x7A, 0x51, 0xDB},
    /* 0x99 */ {0x7B, 0x51, 0xE0},
    /* 0x99 */ {0x7C, 0x86, 0x55},
    /* 0x99 */ {0x7D, 0x51, 0xE9},
    /* 0x99 */ {0x7E, 0x51, 0xED},
    /* 0x99 */ {0x80, 0x51, 0xF0},
    /* 0x99 */ {0x81, 0x51, 0xF5},
    /* 0x99 */ {0x82, 0x51, 0xFE},
    /* 0x99 */ {0x83, 0x52, 0x04},
    /* 0x99 */ {0x84, 0x52, 0x0B},
    /* 0x99 */ {0x85, 0x52, 0x14},
    /* 0x99 */ {0x86, 0x52, 0x0E},
    /* 0x99 */ {0x87, 0x52, 0x27},
    /* 0x99 */ {0x88, 0x52, 0x2A},
    /* 0x99 */ {0x89, 0x52, 0x2E},
    /* 0x99 */ {0x8A, 0x52, 0x33},
    /* 0x99 */ {0x8B, 0x52, 0x39},
    /* 0x99 */ {0x8C, 0x52, 0x4F},
    /* 0x99 */ {0x8D, 0x52, 0x44},
    /* 0x99 */ {0x8E, 0x52, 0x4B},
    /* 0x99 */ {0x8F, 0x52, 0x4C},
    /* 0x99 */ {0x90, 0x52, 0x5E},
    /* 0x99 */ {0x91, 0x52, 0x54},
    /* 0x99 */ {0x92, 0x52, 0x6A},
    /* 0x99 */ {0x93, 0x52, 0x74},
    /* 0x99 */ {0x94, 0x52, 0x69},
    /* 0x99 */ {0x95, 0x52, 0x73},
    /* 0x99 */ {0x96, 0x52, 0x7F},
    /* 0x99 */ {0x97, 0x52, 0x7D},
    /* 0x99 */ {0x98, 0x52, 0x8D},
    /* 0x99 */ {0x99, 0x52, 0x94},
    /* 0x99 */ {0x9A, 0x52, 0x92},
    /* 0x99 */ {0x9B, 0x52, 0x71},
    /* 0x99 */ {0x9C, 0x52, 0x88},
    /* 0x99 */ {0x9D, 0x52, 0x91},
    /* 0x99 */ {0x9E, 0x8F, 0xA8},
    /* 0x99 */ {0x9F, 0x8F, 0xA7},
    /* 0x99 */ {0xA0, 0x52, 0xAC},
    /* 0x99 */ {0xA1, 0x52, 0xAD},
    /* 0x99 */ {0xA2, 0x52, 0xBC},
    /* 0x99 */ {0xA3, 0x52, 0xB5},
    /* 0x99 */ {0xA4, 0x52, 0xC1},
    /* 0x99 */ {0xA5, 0x52, 0xCD},
    /* 0x99 */ {0xA6, 0x52, 0xD7},
    /* 0x99 */ {0xA7, 0x52, 0xDE},
    /* 0x99 */ {0xA8, 0x52, 0xE3},
    /* 0x99 */ {0xA9, 0x52, 0xE6},
    /* 0x99 */ {0xAA, 0x98, 0xED},
    /* 0x99 */ {0xAB, 0x52, 0xE0},
    /* 0x99 */ {0xAC, 0x52, 0xF3},
    /* 0x99 */ {0xAD, 0x52, 0xF5},
    /* 0x99 */ {0xAE, 0x52, 0xF8},
    /* 0x99 */ {0xAF, 0x52, 0xF9},
    /* 0x99 */ {0xB0, 0x53, 0x06},
    /* 0x99 */ {0xB1, 0x53, 0x08},
    /* 0x99 */ {0xB2, 0x75, 0x38},
    /* 0x99 */ {0xB3, 0x53, 0x0D},
    /* 0x99 */ {0xB4, 0x53, 0x10},
    /* 0x99 */ {0xB5, 0x53, 0x0F},
    /* 0x99 */ {0xB6, 0x53, 0x15},
    /* 0x99 */ {0xB7, 0x53, 0x1A},
    /* 0x99 */ {0xB8, 0x53, 0x23},
    /* 0x99 */ {0xB9, 0x53, 0x2F},
    /* 0x99 */ {0xBA, 0x53, 0x31},
    /* 0x99 */ {0xBB, 0x53, 0x33},
    /* 0x99 */ {0xBC, 0x53, 0x38},
    /* 0x99 */ {0xBD, 0x53, 0x40},
    /* 0x99 */ {0xBE, 0x53, 0x46},
    /* 0x99 */ {0xBF, 0x53, 0x45},
    /* 0x99 */ {0xC0, 0x4E, 0x17},
    /* 0x99 */ {0xC1, 0x53, 0x49},
    /* 0x99 */ {0xC2, 0x53, 0x4D},
    /* 0x99 */ {0xC3, 0x51, 0xD6},
    /* 0x99 */ {0xC4, 0x53, 0x5E},
    /* 0x99 */ {0xC5, 0x53, 0x69},
    /* 0x99 */ {0xC6, 0x53, 0x6E},
    /* 0x99 */ {0xC7, 0x59, 0x18},
    /* 0x99 */ {0xC8, 0x53, 0x7B},
    /* 0x99 */ {0xC9, 0x53, 0x77},
    /* 0x99 */ {0xCA, 0x53, 0x82},
    /* 0x99 */ {0xCB, 0x53, 0x96},
    /* 0x99 */ {0xCC, 0x53, 0xA0},
    /* 0x99 */ {0xCD, 0x53, 0xA6},
    /* 0x99 */ {0xCE, 0x53, 0xA5},
    /* 0x99 */ {0xCF, 0x53, 0xAE},
    /* 0x99 */ {0xD0, 0x53, 0xB0},
    /* 0x99 */ {0xD1, 0x53, 0xB6},
    /* 0x99 */ {0xD2, 0x53, 0xC3},
    /* 0x99 */ {0xD3, 0x7C, 0x12},
    /* 0x99 */ {0xD4, 0x96, 0xD9},
    /* 0x99 */ {0xD5, 0x53, 0xDF},
    /* 0x99 */ {0xD6, 0x66, 0xFC},
    /* 0x99 */ {0xD7, 0x71, 0xEE},
    /* 0x99 */ {0xD8, 0x53, 0xEE},
    /* 0x99 */ {0xD9, 0x53, 0xE8},
    /* 0x99 */ {0xDA, 0x53, 0xED},
    /* 0x99 */ {0xDB, 0x53, 0xFA},
    /* 0x99 */ {0xDC, 0x54, 0x01},
    /* 0x99 */ {0xDD, 0x54, 0x3D},
    /* 0x99 */ {0xDE, 0x54, 0x40},
    /* 0x99 */ {0xDF, 0x54, 0x2C},
    /* 0x99 */ {0xE0, 0x54, 0x2D},
    /* 0x99 */ {0xE1, 0x54, 0x3C},
    /* 0x99 */ {0xE2, 0x54, 0x2E},
    /* 0x99 */ {0xE3, 0x54, 0x36},
    /* 0x99 */ {0xE4, 0x54, 0x29},
    /* 0x99 */ {0xE5, 0x54, 0x1D},
    /* 0x99 */ {0xE6, 0x54, 0x4E},
    /* 0x99 */ {0xE7, 0x54, 0x8F},
    /* 0x99 */ {0xE8, 0x54, 0x75},
    /* 0x99 */ {0xE9, 0x54, 0x8E},
    /* 0x99 */ {0xEA, 0x54, 0x5F},
    /* 0x99 */ {0xEB, 0x54, 0x71},
    /* 0x99 */ {0xEC, 0x54, 0x77},
    /* 0x99 */ {0xED, 0x54, 0x70},
    /* 0x99 */ {0xEE, 0x54, 0x92},
    /* 0x99 */ {0xEF, 0x54, 0x7B},
    /* 0x99 */ {0xF0, 0x54, 0x80},
    /* 0x99 */ {0xF1, 0x54, 0x76},
    /* 0x99 */ {0xF2, 0x54, 0x84},
    /* 0x99 */ {0xF3, 0x54, 0x90},
    /* 0x99 */ {0xF4, 0x54, 0x86},
    /* 0x99 */ {0xF5, 0x54, 0xC7},
    /* 0x99 */ {0xF6, 0x54, 0xA2},
    /* 0x99 */ {0xF7, 0x54, 0xB8},
    /* 0x99 */ {0xF8, 0x54, 0xA5},
    /* 0x99 */ {0xF9, 0x54, 0xAC},
    /* 0x99 */ {0xFA, 0x54, 0xC4},
    /* 0x99 */ {0xFB, 0x54, 0xC8},
    /* 0x99 */ {0xFC, 0x54, 0xA8},
    /* 0x9A */ {0x40, 0x54, 0xAB},
    /* 0x9A */ {0x41, 0x54, 0xC2},
    /* 0x9A */ {0x42, 0x54, 0xA4},
    /* 0x9A */ {0x43, 0x54, 0xBE},
    /* 0x9A */ {0x44, 0x54, 0xBC},
    /* 0x9A */ {0x45, 0x54, 0xD8},
    /* 0x9A */ {0x46, 0x54, 0xE5},
    /* 0x9A */ {0x47, 0x54, 0xE6},
    /* 0x9A */ {0x48, 0x55, 0x0F},
    /* 0x9A */ {0x49, 0x55, 0x14},
    /* 0x9A */ {0x4A, 0x54, 0xFD},
    /* 0x9A */ {0x4B, 0x54, 0xEE},
    /* 0x9A */ {0x4C, 0x54, 0xED},
    /* 0x9A */ {0x4D, 0x54, 0xFA},
    /* 0x9A */ {0x4E, 0x54, 0xE2},
    /* 0x9A */ {0x4F, 0x55, 0x39},
    /* 0x9A */ {0x50, 0x55, 0x40},
    /* 0x9A */ {0x51, 0x55, 0x63},
    /* 0x9A */ {0x52, 0x55, 0x4C},
    /* 0x9A */ {0x53, 0x55, 0x2E},
    /* 0x9A */ {0x54, 0x55, 0x5C},
    /* 0x9A */ {0x55, 0x55, 0x45},
    /* 0x9A */ {0x56, 0x55, 0x56},
    /* 0x9A */ {0x57, 0x55, 0x57},
    /* 0x9A */ {0x58, 0x55, 0x38},
    /* 0x9A */ {0x59, 0x55, 0x33},
    /* 0x9A */ {0x5A, 0x55, 0x5D},
    /* 0x9A */ {0x5B, 0x55, 0x99},
    /* 0x9A */ {0x5C, 0x55, 0x80},
    /* 0x9A */ {0x5D, 0x54, 0xAF},
    /* 0x9A */ {0x5E, 0x55, 0x8A},
    /* 0x9A */ {0x5F, 0x55, 0x9F},
    /* 0x9A */ {0x60, 0x55, 0x7B},
    /* 0x9A */ {0x61, 0x55, 0x7E},
    /* 0x9A */ {0x62, 0x55, 0x98},
    /* 0x9A */ {0x63, 0x55, 0x9E},
    /* 0x9A */ {0x64, 0x55, 0xAE},
    /* 0x9A */ {0x65, 0x55, 0x7C},
    /* 0x9A */ {0x66, 0x55, 0x83},
    /* 0x9A */ {0x67, 0x55, 0xA9},
    /* 0x9A */ {0x68, 0x55, 0x87},
    /* 0x9A */ {0x69, 0x55, 0xA8},
    /* 0x9A */ {0x6A, 0x55, 0xDA},
    /* 0x9A */ {0x6B, 0x55, 0xC5},
    /* 0x9A */ {0x6C, 0x55, 0xDF},
    /* 0x9A */ {0x6D, 0x55, 0xC4},
    /* 0x9A */ {0x6E, 0x55, 0xDC},
    /* 0x9A */ {0x6F, 0x55, 0xE4},
    /* 0x9A */ {0x70, 0x55, 0xD4},
    /* 0x9A */ {0x71, 0x56, 0x14},
    /* 0x9A */ {0x72, 0x55, 0xF7},
    /* 0x9A */ {0x73, 0x56, 0x16},
    /* 0x9A */ {0x74, 0x55, 0xFE},
    /* 0x9A */ {0x75, 0x55, 0xFD},
    /* 0x9A */ {0x76, 0x56, 0x1B},
    /* 0x9A */ {0x77, 0x55, 0xF9},
    /* 0x9A */ {0x78, 0x56, 0x4E},
    /* 0x9A */ {0x79, 0x56, 0x50},
    /* 0x9A */ {0x7A, 0x71, 0xDF},
    /* 0x9A */ {0x7B, 0x56, 0x34},
    /* 0x9A */ {0x7C, 0x56, 0x36},
    /* 0x9A */ {0x7D, 0x56, 0x32},
    /* 0x9A */ {0x7E, 0x56, 0x38},
    /* 0x9A */ {0x80, 0x56, 0x6B},
    /* 0x9A */ {0x81, 0x56, 0x64},
    /* 0x9A */ {0x82, 0x56, 0x2F},
    /* 0x9A */ {0x83, 0x56, 0x6C},
    /* 0x9A */ {0x84, 0x56, 0x6A},
    /* 0x9A */ {0x85, 0x56, 0x86},
    /* 0x9A */ {0x86, 0x56, 0x80},
    /* 0x9A */ {0x87, 0x56, 0x8A},
    /* 0x9A */ {0x88, 0x56, 0xA0},
    /* 0x9A */ {0x89, 0x56, 0x94},
    /* 0x9A */ {0x8A, 0x56, 0x8F},
    /* 0x9A */ {0x8B, 0x56, 0xA5},
    /* 0x9A */ {0x8C, 0x56, 0xAE},
    /* 0x9A */ {0x8D, 0x56, 0xB6},
    /* 0x9A */ {0x8E, 0x56, 0xB4},
    /* 0x9A */ {0x8F, 0x56, 0xC2},
    /* 0x9A */ {0x90, 0x56, 0xBC},
    /* 0x9A */ {0x91, 0x56, 0xC1},
    /* 0x9A */ {0x92, 0x56, 0xC3},
    /* 0x9A */ {0x93, 0x56, 0xC0},
    /* 0x9A */ {0x94, 0x56, 0xC8},
    /* 0x9A */ {0x95, 0x56, 0xCE},
    /* 0x9A */ {0x96, 0x56, 0xD1},
    /* 0x9A */ {0x97, 0x56, 0xD3},
    /* 0x9A */ {0x98, 0x56, 0xD7},
    /* 0x9A */ {0x99, 0x56, 0xEE},
    /* 0x9A */ {0x9A, 0x56, 0xF9},
    /* 0x9A */ {0x9B, 0x57, 0x00},
    /* 0x9A */ {0x9C, 0x56, 0xFF},
    /* 0x9A */ {0x9D, 0x57, 0x04},
    /* 0x9A */ {0x9E, 0x57, 0x09},
    /* 0x9A */ {0x9F, 0x57, 0x08},
    /* 0x9A */ {0xA0, 0x57, 0x0B},
    /* 0x9A */ {0xA1, 0x57, 0x0D},
    /* 0x9A */ {0xA2, 0x57, 0x13},
    /* 0x9A */ {0xA3, 0x57, 0x18},
    /* 0x9A */ {0xA4, 0x57, 0x16},
    /* 0x9A */ {0xA5, 0x55, 0xC7},
    /* 0x9A */ {0xA6, 0x57, 0x1C},
    /* 0x9A */ {0xA7, 0x57, 0x26},
    /* 0x9A */ {0xA8, 0x57, 0x37},
    /* 0x9A */ {0xA9, 0x57, 0x38},
    /* 0x9A */ {0xAA, 0x57, 0x4E},
    /* 0x9A */ {0xAB, 0x57, 0x3B},
    /* 0x9A */ {0xAC, 0x57, 0x40},
    /* 0x9A */ {0xAD, 0x57, 0x4F},
    /* 0x9A */ {0xAE, 0x57, 0x69},
    /* 0x9A */ {0xAF, 0x57, 0xC0},
    /* 0x9A */ {0xB0, 0x57, 0x88},
    /* 0x9A */ {0xB1, 0x57, 0x61},
    /* 0x9A */ {0xB2, 0x57, 0x7F},
    /* 0x9A */ {0xB3, 0x57, 0x89},
    /* 0x9A */ {0xB4, 0x57, 0x93},
    /* 0x9A */ {0xB5, 0x57, 0xA0},
    /* 0x9A */ {0xB6, 0x57, 0xB3},
    /* 0x9A */ {0xB7, 0x57, 0xA4},
    /* 0x9A */ {0xB8, 0x57, 0xAA},
    /* 0x9A */ {0xB9, 0x57, 0xB0},
    /* 0x9A */ {0xBA, 0x57, 0xC3},
    /* 0x9A */ {0xBB, 0x57, 0xC6},
    /* 0x9A */ {0xBC, 0x57, 0xD4},
    /* 0x9A */ {0xBD, 0x57, 0xD2},
    /* 0x9A */ {0xBE, 0x57, 0xD3},
    /* 0x9A */ {0xBF, 0x58, 0x0A},
    /* 0x9A */ {0xC0, 0x57, 0xD6},
    /* 0x9A */ {0xC1, 0x57, 0xE3},
    /* 0x9A */ {0xC2, 0x58, 0x0B},
    /* 0x9A */ {0xC3, 0x58, 0x19},
    /* 0x9A */ {0xC4, 0x58, 0x1D},
    /* 0x9A */ {0xC5, 0x58, 0x72},
    /* 0x9A */ {0xC6, 0x58, 0x21},
    /* 0x9A */ {0xC7, 0x58, 0x62},
    /* 0x9A */ {0xC8, 0x58, 0x4B},
    /* 0x9A */ {0xC9, 0x58, 0x70},
    /* 0x9A */ {0xCA, 0x6B, 0xC0},
    /* 0x9A */ {0xCB, 0x58, 0x52},
    /* 0x9A */ {0xCC, 0x58, 0x3D},
    /* 0x9A */ {0xCD, 0x58, 0x79},
    /* 0x9A */ {0xCE, 0x58, 0x85},
    /* 0x9A */ {0xCF, 0x58, 0xB9},
    /* 0x9A */ {0xD0, 0x58, 0x9F},
    /* 0x9A */ {0xD1, 0x58, 0xAB},
    /* 0x9A */ {0xD2, 0x58, 0xBA},
    /* 0x9A */ {0xD3, 0x58, 0xDE},
    /* 0x9A */ {0xD4, 0x58, 0xBB},
    /* 0x9A */ {0xD5, 0x58, 0xB8},
    /* 0x9A */ {0xD6, 0x58, 0xAE},
    /* 0x9A */ {0xD7, 0x58, 0xC5},
    /* 0x9A */ {0xD8, 0x58, 0xD3},
    /* 0x9A */ {0xD9, 0x58, 0xD1},
    /* 0x9A */ {0xDA, 0x58, 0xD7},
    /* 0x9A */ {0xDB, 0x58, 0xD9},
    /* 0x9A */ {0xDC, 0x58, 0xD8},
    /* 0x9A */ {0xDD, 0x58, 0xE5},
    /* 0x9A */ {0xDE, 0x58, 0xDC},
    /* 0x9A */ {0xDF, 0x58, 0xE4},
    /* 0x9A */ {0xE0, 0x58, 0xDF},
    /* 0x9A */ {0xE1, 0x58, 0xEF},
    /* 0x9A */ {0xE2, 0x58, 0xFA},
    /* 0x9A */ {0xE3, 0x58, 0xF9},
    /* 0x9A */ {0xE4, 0x58, 0xFB},
    /* 0x9A */ {0xE5, 0x58, 0xFC},
    /* 0x9A */ {0xE6, 0x58, 0xFD},
    /* 0x9A */ {0xE7, 0x59, 0x02},
    /* 0x9A */ {0xE8, 0x59, 0x0A},
    /* 0x9A */ {0xE9, 0x59, 0x10},
    /* 0x9A */ {0xEA, 0x59, 0x1B},
    /* 0x9A */ {0xEB, 0x68, 0xA6},
    /* 0x9A */ {0xEC, 0x59, 0x25},
    /* 0x9A */ {0xED, 0x59, 0x2C},
    /* 0x9A */ {0xEE, 0x59, 0x2D},
    /* 0x9A */ {0xEF, 0x59, 0x32},
    /* 0x9A */ {0xF0, 0x59, 0x38},
    /* 0x9A */ {0xF1, 0x59, 0x3E},
    /* 0x9A */ {0xF2, 0x7A, 0xD2},
    /* 0x9A */ {0xF3, 0x59, 0x55},
    /* 0x9A */ {0xF4, 0x59, 0x50},
    /* 0x9A */ {0xF5, 0x59, 0x4E},
    /* 0x9A */ {0xF6, 0x59, 0x5A},
    /* 0x9A */ {0xF7, 0x59, 0x58},
    /* 0x9A */ {0xF8, 0x59, 0x62},
    /* 0x9A */ {0xF9, 0x59, 0x60},
    /* 0x9A */ {0xFA, 0x59, 0x67},
    /* 0x9A */ {0xFB, 0x59, 0x6C},
    /* 0x9A */ {0xFC, 0x59, 0x69},
    /* 0x9B */ {0x40, 0x59, 0x78},
    /* 0x9B */ {0x41, 0x59, 0x81},
    /* 0x9B */ {0x42, 0x59, 0x9D},
    /* 0x9B */ {0x43, 0x4F, 0x5E},
    /* 0x9B */ {0x44, 0x4F, 0xAB},
    /* 0x9B */ {0x45, 0x59, 0xA3},
    /* 0x9B */ {0x46, 0x59, 0xB2},
    /* 0x9B */ {0x47, 0x59, 0xC6},
    /* 0x9B */ {0x48, 0x59, 0xE8},
    /* 0x9B */ {0x49, 0x59, 0xDC},
    /* 0x9B */ {0x4A, 0x59, 0x8D},
    /* 0x9B */ {0x4B, 0x59, 0xD9},
    /* 0x9B */ {0x4C, 0x59, 0xDA},
    /* 0x9B */ {0x4D, 0x5A, 0x25},
    /* 0x9B */ {0x4E, 0x5A, 0x1F},
    /* 0x9B */ {0x4F, 0x5A, 0x11},
    /* 0x9B */ {0x50, 0x5A, 0x1C},
    /* 0x9B */ {0x51, 0x5A, 0x09},
    /* 0x9B */ {0x52, 0x5A, 0x1A},
    /* 0x9B */ {0x53, 0x5A, 0x40},
    /* 0x9B */ {0x54, 0x5A, 0x6C},
    /* 0x9B */ {0x55, 0x5A, 0x49},
    /* 0x9B */ {0x56, 0x5A, 0x35},
    /* 0x9B */ {0x57, 0x5A, 0x36},
    /* 0x9B */ {0x58, 0x5A, 0x62},
    /* 0x9B */ {0x59, 0x5A, 0x6A},
    /* 0x9B */ {0x5A, 0x5A, 0x9A},
    /* 0x9B */ {0x5B, 0x5A, 0xBC},
    /* 0x9B */ {0x5C, 0x5A, 0xBE},
    /* 0x9B */ {0x5D, 0x5A, 0xCB},
    /* 0x9B */ {0x5E, 0x5A, 0xC2},
    /* 0x9B */ {0x5F, 0x5A, 0xBD},
    /* 0x9B */ {0x60, 0x5A, 0xE3},
    /* 0x9B */ {0x61, 0x5A, 0xD7},
    /* 0x9B */ {0x62, 0x5A, 0xE6},
    /* 0x9B */ {0x63, 0x5A, 0xE9},
    /* 0x9B */ {0x64, 0x5A, 0xD6},
    /* 0x9B */ {0x65, 0x5A, 0xFA},
    /* 0x9B */ {0x66, 0x5A, 0xFB},
    /* 0x9B */ {0x67, 0x5B, 0x0C},
    /* 0x9B */ {0x68, 0x5B, 0x0B},
    /* 0x9B */ {0x69, 0x5B, 0x16},
    /* 0x9B */ {0x6A, 0x5B, 0x32},
    /* 0x9B */ {0x6B, 0x5A, 0xD0},
    /* 0x9B */ {0x6C, 0x5B, 0x2A},
    /* 0x9B */ {0x6D, 0x5B, 0x36},
    /* 0x9B */ {0x6E, 0x5B, 0x3E},
    /* 0x9B */ {0x6F, 0x5B, 0x43},
    /* 0x9B */ {0x70, 0x5B, 0x45},
    /* 0x9B */ {0x71, 0x5B, 0x40},
    /* 0x9B */ {0x72, 0x5B, 0x51},
    /* 0x9B */ {0x73, 0x5B, 0x55},
    /* 0x9B */ {0x74, 0x5B, 0x5A},
    /* 0x9B */ {0x75, 0x5B, 0x5B},
    /* 0x9B */ {0x76, 0x5B, 0x65},
    /* 0x9B */ {0x77, 0x5B, 0x69},
    /* 0x9B */ {0x78, 0x5B, 0x70},
    /* 0x9B */ {0x79, 0x5B, 0x73},
    /* 0x9B */ {0x7A, 0x5B, 0x75},
    /* 0x9B */ {0x7B, 0x5B, 0x78},
    /* 0x9B */ {0x7C, 0x65, 0x88},
    /* 0x9B */ {0x7D, 0x5B, 0x7A},
    /* 0x9B */ {0x7E, 0x5B, 0x80},
    /* 0x9B */ {0x80, 0x5B, 0x83},
    /* 0x9B */ {0x81, 0x5B, 0xA6},
    /* 0x9B */ {0x82, 0x5B, 0xB8},
    /* 0x9B */ {0x83, 0x5B, 0xC3},
    /* 0x9B */ {0x84, 0x5B, 0xC7},
    /* 0x9B */ {0x85, 0x5B, 0xC9},
    /* 0x9B */ {0x86, 0x5B, 0xD4},
    /* 0x9B */ {0x87, 0x5B, 0xD0},
    /* 0x9B */ {0x88, 0x5B, 0xE4},
    /* 0x9B */ {0x89, 0x5B, 0xE6},
    /* 0x9B */ {0x8A, 0x5B, 0xE2},
    /* 0x9B */ {0x8B, 0x5B, 0xDE},
    /* 0x9B */ {0x8C, 0x5B, 0xE5},
    /* 0x9B */ {0x8D, 0x5B, 0xEB},
    /* 0x9B */ {0x8E, 0x5B, 0xF0},
    /* 0x9B */ {0x8F, 0x5B, 0xF6},
    /* 0x9B */ {0x90, 0x5B, 0xF3},
    /* 0x9B */ {0x91, 0x5C, 0x05},
    /* 0x9B */ {0x92, 0x5C, 0x07},
    /* 0x9B */ {0x93, 0x5C, 0x08},
    /* 0x9B */ {0x94, 0x5C, 0x0D},
    /* 0x9B */ {0x95, 0x5C, 0x13},
    /* 0x9B */ {0x96, 0x5C, 0x20},
    /* 0x9B */ {0x97, 0x5C, 0x22},
    /* 0x9B */ {0x98, 0x5C, 0x28},
    /* 0x9B */ {0x99, 0x5C, 0x38},
    /* 0x9B */ {0x9A, 0x5C, 0x39},
    /* 0x9B */ {0x9B, 0x5C, 0x41},
    /* 0x9B */ {0x9C, 0x5C, 0x46},
    /* 0x9B */ {0x9D, 0x5C, 0x4E},
    /* 0x9B */ {0x9E, 0x5C, 0x53},
    /* 0x9B */ {0x9F, 0x5C, 0x50},
    /* 0x9B */ {0xA0, 0x5C, 0x4F},
    /* 0x9B */ {0xA1, 0x5B, 0x71},
    /* 0x9B */ {0xA2, 0x5C, 0x6C},
    /* 0x9B */ {0xA3, 0x5C, 0x6E},
    /* 0x9B */ {0xA4, 0x4E, 0x62},
    /* 0x9B */ {0xA5, 0x5C, 0x76},
    /* 0x9B */ {0xA6, 0x5C, 0x79},
    /* 0x9B */ {0xA7, 0x5C, 0x8C},
    /* 0x9B */ {0xA8, 0x5C, 0x91},
    /* 0x9B */ {0xA9, 0x5C, 0x94},
    /* 0x9B */ {0xAA, 0x59, 0x9B},
    /* 0x9B */ {0xAB, 0x5C, 0xAB},
    /* 0x9B */ {0xAC, 0x5C, 0xBB},
    /* 0x9B */ {0xAD, 0x5C, 0xB6},
    /* 0x9B */ {0xAE, 0x5C, 0xBC},
    /* 0x9B */ {0xAF, 0x5C, 0xB7},
    /* 0x9B */ {0xB0, 0x5C, 0xC5},
    /* 0x9B */ {0xB1, 0x5C, 0xBE},
    /* 0x9B */ {0xB2, 0x5C, 0xC7},
    /* 0x9B */ {0xB3, 0x5C, 0xD9},
    /* 0x9B */ {0xB4, 0x5C, 0xE9},
    /* 0x9B */ {0xB5, 0x5C, 0xFD},
    /* 0x9B */ {0xB6, 0x5C, 0xFA},
    /* 0x9B */ {0xB7, 0x5C, 0xED},
    /* 0x9B */ {0xB8, 0x5D, 0x8C},
    /* 0x9B */ {0xB9, 0x5C, 0xEA},
    /* 0x9B */ {0xBA, 0x5D, 0x0B},
    /* 0x9B */ {0xBB, 0x5D, 0x15},
    /* 0x9B */ {0xBC, 0x5D, 0x17},
    /* 0x9B */ {0xBD, 0x5D, 0x5C},
    /* 0x9B */ {0xBE, 0x5D, 0x1F},
    /* 0x9B */ {0xBF, 0x5D, 0x1B},
    /* 0x9B */ {0xC0, 0x5D, 0x11},
    /* 0x9B */ {0xC1, 0x5D, 0x14},
    /* 0x9B */ {0xC2, 0x5D, 0x22},
    /* 0x9B */ {0xC3, 0x5D, 0x1A},
    /* 0x9B */ {0xC4, 0x5D, 0x19},
    /* 0x9B */ {0xC5, 0x5D, 0x18},
    /* 0x9B */ {0xC6, 0x5D, 0x4C},
    /* 0x9B */ {0xC7, 0x5D, 0x52},
    /* 0x9B */ {0xC8, 0x5D, 0x4E},
    /* 0x9B */ {0xC9, 0x5D, 0x4B},
    /* 0x9B */ {0xCA, 0x5D, 0x6C},
    /* 0x9B */ {0xCB, 0x5D, 0x73},
    /* 0x9B */ {0xCC, 0x5D, 0x76},
    /* 0x9B */ {0xCD, 0x5D, 0x87},
    /* 0x9B */ {0xCE, 0x5D, 0x84},
    /* 0x9B */ {0xCF, 0x5D, 0x82},
    /* 0x9B */ {0xD0, 0x5D, 0xA2},
    /* 0x9B */ {0xD1, 0x5D, 0x9D},
    /* 0x9B */ {0xD2, 0x5D, 0xAC},
    /* 0x9B */ {0xD3, 0x5D, 0xAE},
    /* 0x9B */ {0xD4, 0x5D, 0xBD},
    /* 0x9B */ {0xD5, 0x5D, 0x90},
    /* 0x9B */ {0xD6, 0x5D, 0xB7},
    /* 0x9B */ {0xD7, 0x5D, 0xBC},
    /* 0x9B */ {0xD8, 0x5D, 0xC9},
    /* 0x9B */ {0xD9, 0x5D, 0xCD},
    /* 0x9B */ {0xDA, 0x5D, 0xD3},
    /* 0x9B */ {0xDB, 0x5D, 0xD2},
    /* 0x9B */ {0xDC, 0x5D, 0xD6},
    /* 0x9B */ {0xDD, 0x5D, 0xDB},
    /* 0x9B */ {0xDE, 0x5D, 0xEB},
    /* 0x9B */ {0xDF, 0x5D, 0xF2},
    /* 0x9B */ {0xE0, 0x5D, 0xF5},
    /* 0x9B */ {0xE1, 0x5E, 0x0B},
    /* 0x9B */ {0xE2, 0x5E, 0x1A},
    /* 0x9B */ {0xE3, 0x5E, 0x19},
    /* 0x9B */ {0xE4, 0x5E, 0x11},
    /* 0x9B */ {0xE5, 0x5E, 0x1B},
    /* 0x9B */ {0xE6, 0x5E, 0x36},
    /* 0x9B */ {0xE7, 0x5E, 0x37},
    /* 0x9B */ {0xE8, 0x5E, 0x44},
    /* 0x9B */ {0xE9, 0x5E, 0x43},
    /* 0x9B */ {0xEA, 0x5E, 0x40},
    /* 0x9B */ {0xEB, 0x5E, 0x4E},
    /* 0x9B */ {0xEC, 0x5E, 0x57},
    /* 0x9B */ {0xED, 0x5E, 0x54},
    /* 0x9B */ {0xEE, 0x5E, 0x5F},
    /* 0x9B */ {0xEF, 0x5E, 0x62},
    /* 0x9B */ {0xF0, 0x5E, 0x64},
    /* 0x9B */ {0xF1, 0x5E, 0x47},
    /* 0x9B */ {0xF2, 0x5E, 0x75},
    /* 0x9B */ {0xF3, 0x5E, 0x76},
    /* 0x9B */ {0xF4, 0x5E, 0x7A},
    /* 0x9B */ {0xF5, 0x9E, 0xBC},
    /* 0x9B */ {0xF6, 0x5E, 0x7F},
    /* 0x9B */ {0xF7, 0x5E, 0xA0},
    /* 0x9B */ {0xF8, 0x5E, 0xC1},
    /* 0x9B */ {0xF9, 0x5E, 0xC2},
    /* 0x9B */ {0xFA, 0x5E, 0xC8},
    /* 0x9B */ {0xFB, 0x5E, 0xD0},
    /* 0x9B */ {0xFC, 0x5E, 0xCF},
    /* 0x9C */ {0x40, 0x5E, 0xD6},
    /* 0x9C */ {0x41, 0x5E, 0xE3},
    /* 0x9C */ {0x42, 0x5E, 0xDD},
    /* 0x9C */ {0x43, 0x5E, 0xDA},
    /* 0x9C */ {0x44, 0x5E, 0xDB},
    /* 0x9C */ {0x45, 0x5E, 0xE2},
    /* 0x9C */ {0x46, 0x5E, 0xE1},
    /* 0x9C */ {0x47, 0x5E, 0xE8},
    /* 0x9C */ {0x48, 0x5E, 0xE9},
    /* 0x9C */ {0x49, 0x5E, 0xEC},
    /* 0x9C */ {0x4A, 0x5E, 0xF1},
    /* 0x9C */ {0x4B, 0x5E, 0xF3},
    /* 0x9C */ {0x4C, 0x5E, 0xF0},
    /* 0x9C */ {0x4D, 0x5E, 0xF4},
    /* 0x9C */ {0x4E, 0x5E, 0xF8},
    /* 0x9C */ {0x4F, 0x5E, 0xFE},
    /* 0x9C */ {0x50, 0x5F, 0x03},
    /* 0x9C */ {0x51, 0x5F, 0x09},
    /* 0x9C */ {0x52, 0x5F, 0x5D},
    /* 0x9C */ {0x53, 0x5F, 0x5C},
    /* 0x9C */ {0x54, 0x5F, 0x0B},
    /* 0x9C */ {0x55, 0x5F, 0x11},
    /* 0x9C */ {0x56, 0x5F, 0x16},
    /* 0x9C */ {0x57, 0x5F, 0x29},
    /* 0x9C */ {0x58, 0x5F, 0x2D},
    /* 0x9C */ {0x59, 0x5F, 0x38},
    /* 0x9C */ {0x5A, 0x5F, 0x41},
    /* 0x9C */ {0x5B, 0x5F, 0x48},
    /* 0x9C */ {0x5C, 0x5F, 0x4C},
    /* 0x9C */ {0x5D, 0x5F, 0x4E},
    /* 0x9C */ {0x5E, 0x5F, 0x2F},
    /* 0x9C */ {0x5F, 0x5F, 0x51},
    /* 0x9C */ {0x60, 0x5F, 0x56},
    /* 0x9C */ {0x61, 0x5F, 0x57},
    /* 0x9C */ {0x62, 0x5F, 0x59},
    /* 0x9C */ {0x63, 0x5F, 0x61},
    /* 0x9C */ {0x64, 0x5F, 0x6D},
    /* 0x9C */ {0x65, 0x5F, 0x73},
    /* 0x9C */ {0x66, 0x5F, 0x77},
    /* 0x9C */ {0x67, 0x5F, 0x83},
    /* 0x9C */ {0x68, 0x5F, 0x82},
    /* 0x9C */ {0x69, 0x5F, 0x7F},
    /* 0x9C */ {0x6A, 0x5F, 0x8A},
    /* 0x9C */ {0x6B, 0x5F, 0x88},
    /* 0x9C */ {0x6C, 0x5F, 0x91},
    /* 0x9C */ {0x6D, 0x5F, 0x87},
    /* 0x9C */ {0x6E, 0x5F, 0x9E},
    /* 0x9C */ {0x6F, 0x5F, 0x99},
    /* 0x9C */ {0x70, 0x5F, 0x98},
    /* 0x9C */ {0x71, 0x5F, 0xA0},
    /* 0x9C */ {0x72, 0x5F, 0xA8},
    /* 0x9C */ {0x73, 0x5F, 0xAD},
    /* 0x9C */ {0x74, 0x5F, 0xBC},
    /* 0x9C */ {0x75, 0x5F, 0xD6},
    /* 0x9C */ {0x76, 0x5F, 0xFB},
    /* 0x9C */ {0x77, 0x5F, 0xE4},
    /* 0x9C */ {0x78, 0x5F, 0xF8},
    /* 0x9C */ {0x79, 0x5F, 0xF1},
    /* 0x9C */ {0x7A, 0x5F, 0xDD},
    /* 0x9C */ {0x7B, 0x60, 0xB3},
    /* 0x9C */ {0x7C, 0x5F, 0xFF},
    /* 0x9C */ {0x7D, 0x60, 0x21},
    /* 0x9C */ {0x7E, 0x60, 0x60},
    /* 0x9C */ {0x80, 0x60, 0x19},
    /* 0x9C */ {0x81, 0x60, 0x10},
    /* 0x9C */ {0x82, 0x60, 0x29},
    /* 0x9C */ {0x83, 0x60, 0x0E},
    /* 0x9C */ {0x84, 0x60, 0x31},
    /* 0x9C */ {0x85, 0x60, 0x1B},
    /* 0x9C */ {0x86, 0x60, 0x15},
    /* 0x9C */ {0x87, 0x60, 0x2B},
    /* 0x9C */ {0x88, 0x60, 0x26},
    /* 0x9C */ {0x89, 0x60, 0x0F},
    /* 0x9C */ {0x8A, 0x60, 0x3A},
    /* 0x9C */ {0x8B, 0x60, 0x5A},
    /* 0x9C */ {0x8C, 0x60, 0x41},
    /* 0x9C */ {0x8D, 0x60, 0x6A},
    /* 0x9C */ {0x8E, 0x60, 0x77},
    /* 0x9C */ {0x8F, 0x60, 0x5F},
    /* 0x9C */ {0x90, 0x60, 0x4A},
    /* 0x9C */ {0x91, 0x60, 0x46},
    /* 0x9C */ {0x92, 0x60, 0x4D},
    /* 0x9C */ {0x93, 0x60, 0x63},
    /* 0x9C */ {0x94, 0x60, 0x43},
    /* 0x9C */ {0x95, 0x60, 0x64},
    /* 0x9C */ {0x96, 0x60, 0x42},
    /* 0x9C */ {0x97, 0x60, 0x6C},
    /* 0x9C */ {0x98, 0x60, 0x6B},
    /* 0x9C */ {0x99, 0x60, 0x59},
    /* 0x9C */ {0x9A, 0x60, 0x81},
    /* 0x9C */ {0x9B, 0x60, 0x8D},
    /* 0x9C */ {0x9C, 0x60, 0xE7},
    /* 0x9C */ {0x9D, 0x60, 0x83},
    /* 0x9C */ {0x9E, 0x60, 0x9A},
    /* 0x9C */ {0x9F, 0x60, 0x84},
    /* 0x9C */ {0xA0, 0x60, 0x9B},
    /* 0x9C */ {0xA1, 0x60, 0x96},
    /* 0x9C */ {0xA2, 0x60, 0x97},
    /* 0x9C */ {0xA3, 0x60, 0x92},
    /* 0x9C */ {0xA4, 0x60, 0xA7},
    /* 0x9C */ {0xA5, 0x60, 0x8B},
    /* 0x9C */ {0xA6, 0x60, 0xE1},
    /* 0x9C */ {0xA7, 0x60, 0xB8},
    /* 0x9C */ {0xA8, 0x60, 0xE0},
    /* 0x9C */ {0xA9, 0x60, 0xD3},
    /* 0x9C */ {0xAA, 0x60, 0xB4},
    /* 0x9C */ {0xAB, 0x5F, 0xF0},
    /* 0x9C */ {0xAC, 0x60, 0xBD},
    /* 0x9C */ {0xAD, 0x60, 0xC6},
    /* 0x9C */ {0xAE, 0x60, 0xB5},
    /* 0x9C */ {0xAF, 0x60, 0xD8},
    /* 0x9C */ {0xB0, 0x61, 0x4D},
    /* 0x9C */ {0xB1, 0x61, 0x15},
    /* 0x9C */ {0xB2, 0x61, 0x06},
    /* 0x9C */ {0xB3, 0x60, 0xF6},
    /* 0x9C */ {0xB4, 0x60, 0xF7},
    /* 0x9C */ {0xB5, 0x61, 0x00},
    /* 0x9C */ {0xB6, 0x60, 0xF4},
    /* 0x9C */ {0xB7, 0x60, 0xFA},
    /* 0x9C */ {0xB8, 0x61, 0x03},
    /* 0x9C */ {0xB9, 0x61, 0x21},
    /* 0x9C */ {0xBA, 0x60, 0xFB},
    /* 0x9C */ {0xBB, 0x60, 0xF1},
    /* 0x9C */ {0xBC, 0x61, 0x0D},
    /* 0x9C */ {0xBD, 0x61, 0x0E},
    /* 0x9C */ {0xBE, 0x61, 0x47},
    /* 0x9C */ {0xBF, 0x61, 0x3E},
    /* 0x9C */ {0xC0, 0x61, 0x28},
    /* 0x9C */ {0xC1, 0x61, 0x27},
    /* 0x9C */ {0xC2, 0x61, 0x4A},
    /* 0x9C */ {0xC3, 0x61, 0x3F},
    /* 0x9C */ {0xC4, 0x61, 0x3C},
    /* 0x9C */ {0xC5, 0x61, 0x2C},
    /* 0x9C */ {0xC6, 0x61, 0x34},
    /* 0x9C */ {0xC7, 0x61, 0x3D},
    /* 0x9C */ {0xC8, 0x61, 0x42},
    /* 0x9C */ {0xC9, 0x61, 0x44},
    /* 0x9C */ {0xCA, 0x61, 0x73},
    /* 0x9C */ {0xCB, 0x61, 0x77},
    /* 0x9C */ {0xCC, 0x61, 0x58},
    /* 0x9C */ {0xCD, 0x61, 0x59},
    /* 0x9C */ {0xCE, 0x61, 0x5A},
    /* 0x9C */ {0xCF, 0x61, 0x6B},
    /* 0x9C */ {0xD0, 0x61, 0x74},
    /* 0x9C */ {0xD1, 0x61, 0x6F},
    /* 0x9C */ {0xD2, 0x61, 0x65},
    /* 0x9C */ {0xD3, 0x61, 0x71},
    /* 0x9C */ {0xD4, 0x61, 0x5F},
    /* 0x9C */ {0xD5, 0x61, 0x5D},
    /* 0x9C */ {0xD6, 0x61, 0x53},
    /* 0x9C */ {0xD7, 0x61, 0x75},
    /* 0x9C */ {0xD8, 0x61, 0x99},
    /* 0x9C */ {0xD9, 0x61, 0x96},
    /* 0x9C */ {0xDA, 0x61, 0x87},
    /* 0x9C */ {0xDB, 0x61, 0xAC},
    /* 0x9C */ {0xDC, 0x61, 0x94},
    /* 0x9C */ {0xDD, 0x61, 0x9A},
    /* 0x9C */ {0xDE, 0x61, 0x8A},
    /* 0x9C */ {0xDF, 0x61, 0x91},
    /* 0x9C */ {0xE0, 0x61, 0xAB},
    /* 0x9C */ {0xE1, 0x61, 0xAE},
    /* 0x9C */ {0xE2, 0x61, 0xCC},
    /* 0x9C */ {0xE3, 0x61, 0xCA},
    /* 0x9C */ {0xE4, 0x61, 0xC9},
    /* 0x9C */ {0xE5, 0x61, 0xF7},
    /* 0x9C */ {0xE6, 0x61, 0xC8},
    /* 0x9C */ {0xE7, 0x61, 0xC3},
    /* 0x9C */ {0xE8, 0x61, 0xC6},
    /* 0x9C */ {0xE9, 0x61, 0xBA},
    /* 0x9C */ {0xEA, 0x61, 0xCB},
    /* 0x9C */ {0xEB, 0x7F, 0x79},
    /* 0x9C */ {0xEC, 0x61, 0xCD},
    /* 0x9C */ {0xED, 0x61, 0xE6},
    /* 0x9C */ {0xEE, 0x61, 0xE3},
    /* 0x9C */ {0xEF, 0x61, 0xF6},
    /* 0x9C */ {0xF0, 0x61, 0xFA},
    /* 0x9C */ {0xF1, 0x61, 0xF4},
    /* 0x9C */ {0xF2, 0x61, 0xFF},
    /* 0x9C */ {0xF3, 0x61, 0xFD},
    /* 0x9C */ {0xF4, 0x61, 0xFC},
    /* 0x9C */ {0xF5, 0x61, 0xFE},
    /* 0x9C */ {0xF6, 0x62, 0x00},
    /* 0x9C */ {0xF7, 0x62, 0x08},
    /* 0x9C */ {0xF8, 0x62, 0x09},
    /* 0x9C */ {0xF9, 0x62, 0x0D},
    /* 0x9C */ {0xFA, 0x62, 0x0C},
    /* 0x9C */ {0xFB, 0x62, 0x14},
    /* 0x9C */ {0xFC, 0x62, 0x1B},
    /* 0x9D */ {0x40, 0x62, 0x1E},
    /* 0x9D */ {0x41, 0x62, 0x21},
    /* 0x9D */ {0x42, 0x62, 0x2A},
    /* 0x9D */ {0x43, 0x62, 0x2E},
    /* 0x9D */ {0x44, 0x62, 0x30},
    /* 0x9D */ {0x45, 0x62, 0x32},
    /* 0x9D */ {0x46, 0x62, 0x33},
    /* 0x9D */ {0x47, 0x62, 0x41},
    /* 0x9D */ {0x48, 0x62, 0x4E},
    /* 0x9D */ {0x49, 0x62, 0x5E},
    /* 0x9D */ {0x4A, 0x62, 0x63},
    /* 0x9D */ {0x4B, 0x62, 0x5B},
    /* 0x9D */ {0x4C, 0x62, 0x60},
    /* 0x9D */ {0x4D, 0x62, 0x68},
    /* 0x9D */ {0x4E, 0x62, 0x7C},
    /* 0x9D */ {0x4F, 0x62, 0x82},
    /* 0x9D */ {0x50, 0x62, 0x89},
    /* 0x9D */ {0x51, 0x62, 0x7E},
    /* 0x9D */ {0x52, 0x62, 0x92},
    /* 0x9D */ {0x53, 0x62, 0x93},
    /* 0x9D */ {0x54, 0x62, 0x96},
    /* 0x9D */ {0x55, 0x62, 0xD4},
    /* 0x9D */ {0x56, 0x62, 0x83},
    /* 0x9D */ {0x57, 0x62, 0x94},
    /* 0x9D */ {0x58, 0x62, 0xD7},
    /* 0x9D */ {0x59, 0x62, 0xD1},
    /* 0x9D */ {0x5A, 0x62, 0xBB},
    /* 0x9D */ {0x5B, 0x62, 0xCF},
    /* 0x9D */ {0x5C, 0x62, 0xFF},
    /* 0x9D */ {0x5D, 0x62, 0xC6},
    /* 0x9D */ {0x5E, 0x64, 0xD4},
    /* 0x9D */ {0x5F, 0x62, 0xC8},
    /* 0x9D */ {0x60, 0x62, 0xDC},
    /* 0x9D */ {0x61, 0x62, 0xCC},
    /* 0x9D */ {0x62, 0x62, 0xCA},
    /* 0x9D */ {0x63, 0x62, 0xC2},
    /* 0x9D */ {0x64, 0x62, 0xC7},
    /* 0x9D */ {0x65, 0x62, 0x9B},
    /* 0x9D */ {0x66, 0x62, 0xC9},
    /* 0x9D */ {0x67, 0x63, 0x0C},
    /* 0x9D */ {0x68, 0x62, 0xEE},
    /* 0x9D */ {0x69, 0x62, 0xF1},
    /* 0x9D */ {0x6A, 0x63, 0x27},
    /* 0x9D */ {0x6B, 0x63, 0x02},
    /* 0x9D */ {0x6C, 0x63, 0x08},
    /* 0x9D */ {0x6D, 0x62, 0xEF},
    /* 0x9D */ {0x6E, 0x62, 0xF5},
    /* 0x9D */ {0x6F, 0x63, 0x50},
    /* 0x9D */ {0x70, 0x63, 0x3E},
    /* 0x9D */ {0x71, 0x63, 0x4D},
    /* 0x9D */ {0x72, 0x64, 0x1C},
    /* 0x9D */ {0x73, 0x63, 0x4F},
    /* 0x9D */ {0x74, 0x63, 0x96},
    /* 0x9D */ {0x75, 0x63, 0x8E},
    /* 0x9D */ {0x76, 0x63, 0x80},
    /* 0x9D */ {0x77, 0x63, 0xAB},
    /* 0x9D */ {0x78, 0x63, 0x76},
    /* 0x9D */ {0x79, 0x63, 0xA3},
    /* 0x9D */ {0x7A, 0x63, 0x8F},
    /* 0x9D */ {0x7B, 0x63, 0x89},
    /* 0x9D */ {0x7C, 0x63, 0x9F},
    /* 0x9D */ {0x7D, 0x63, 0xB5},
    /* 0x9D */ {0x7E, 0x63, 0x6B},
    /* 0x9D */ {0x80, 0x63, 0x69},
    /* 0x9D */ {0x81, 0x63, 0xBE},
    /* 0x9D */ {0x82, 0x63, 0xE9},
    /* 0x9D */ {0x83, 0x63, 0xC0},
    /* 0x9D */ {0x84, 0x63, 0xC6},
    /* 0x9D */ {0x85, 0x63, 0xE3},
    /* 0x9D */ {0x86, 0x63, 0xC9},
    /* 0x9D */ {0x87, 0x63, 0xD2},
    /* 0x9D */ {0x88, 0x63, 0xF6},
    /* 0x9D */ {0x89, 0x63, 0xC4},
    /* 0x9D */ {0x8A, 0x64, 0x16},
    /* 0x9D */ {0x8B, 0x64, 0x34},
    /* 0x9D */ {0x8C, 0x64, 0x06},
    /* 0x9D */ {0x8D, 0x64, 0x13},
    /* 0x9D */ {0x8E, 0x64, 0x26},
    /* 0x9D */ {0x8F, 0x64, 0x36},
    /* 0x9D */ {0x90, 0x65, 0x1D},
    /* 0x9D */ {0x91, 0x64, 0x17},
    /* 0x9D */ {0x92, 0x64, 0x28},
    /* 0x9D */ {0x93, 0x64, 0x0F},
    /* 0x9D */ {0x94, 0x64, 0x67},
    /* 0x9D */ {0x95, 0x64, 0x6F},
    /* 0x9D */ {0x96, 0x64, 0x76},
    /* 0x9D */ {0x97, 0x64, 0x4E},
    /* 0x9D */ {0x98, 0x65, 0x2A},
    /* 0x9D */ {0x99, 0x64, 0x95},
    /* 0x9D */ {0x9A, 0x64, 0x93},
    /* 0x9D */ {0x9B, 0x64, 0xA5},
    /* 0x9D */ {0x9C, 0x64, 0xA9},
    /* 0x9D */ {0x9D, 0x64, 0x88},
    /* 0x9D */ {0x9E, 0x64, 0xBC},
    /* 0x9D */ {0x9F, 0x64, 0xDA},
    /* 0x9D */ {0xA0, 0x64, 0xD2},
    /* 0x9D */ {0xA1, 0x64, 0xC5},
    /* 0x9D */ {0xA2, 0x64, 0xC7},
    /* 0x9D */ {0xA3, 0x64, 0xBB},
    /* 0x9D */ {0xA4, 0x64, 0xD8},
    /* 0x9D */ {0xA5, 0x64, 0xC2},
    /* 0x9D */ {0xA6, 0x64, 0xF1},
    /* 0x9D */ {0xA7, 0x64, 0xE7},
    /* 0x9D */ {0xA8, 0x82, 0x09},
    /* 0x9D */ {0xA9, 0x64, 0xE0},
    /* 0x9D */ {0xAA, 0x64, 0xE1},
    /* 0x9D */ {0xAB, 0x62, 0xAC},
    /* 0x9D */ {0xAC, 0x64, 0xE3},
    /* 0x9D */ {0xAD, 0x64, 0xEF},
    /* 0x9D */ {0xAE, 0x65, 0x2C},
    /* 0x9D */ {0xAF, 0x64, 0xF6},
    /* 0x9D */ {0xB0, 0x64, 0xF4},
    /* 0x9D */ {0xB1, 0x64, 0xF2},
    /* 0x9D */ {0xB2, 0x64, 0xFA},
    /* 0x9D */ {0xB3, 0x65, 0x00},
    /* 0x9D */ {0xB4, 0x64, 0xFD},
    /* 0x9D */ {0xB5, 0x65, 0x18},
    /* 0x9D */ {0xB6, 0x65, 0x1C},
    /* 0x9D */ {0xB7, 0x65, 0x05},
    /* 0x9D */ {0xB8, 0x65, 0x24},
    /* 0x9D */ {0xB9, 0x65, 0x23},
    /* 0x9D */ {0xBA, 0x65, 0x2B},
    /* 0x9D */ {0xBB, 0x65, 0x34},
    /* 0x9D */ {0xBC, 0x65, 0x35},
    /* 0x9D */ {0xBD, 0x65, 0x37},
    /* 0x9D */ {0xBE, 0x65, 0x36},
    /* 0x9D */ {0xBF, 0x65, 0x38},
    /* 0x9D */ {0xC0, 0x75, 0x4B},
    /* 0x9D */ {0xC1, 0x65, 0x48},
    /* 0x9D */ {0xC2, 0x65, 0x56},
    /* 0x9D */ {0xC3, 0x65, 0x55},
    /* 0x9D */ {0xC4, 0x65, 0x4D},
    /* 0x9D */ {0xC5, 0x65, 0x58},
    /* 0x9D */ {0xC6, 0x65, 0x5E},
    /* 0x9D */ {0xC7, 0x65, 0x5D},
    /* 0x9D */ {0xC8, 0x65, 0x72},
    /* 0x9D */ {0xC9, 0x65, 0x78},
    /* 0x9D */ {0xCA, 0x65, 0x82},
    /* 0x9D */ {0xCB, 0x65, 0x83},
    /* 0x9D */ {0xCC, 0x8B, 0x8A},
    /* 0x9D */ {0xCD, 0x65, 0x9B},
    /* 0x9D */ {0xCE, 0x65, 0x9F},
    /* 0x9D */ {0xCF, 0x65, 0xAB},
    /* 0x9D */ {0xD0, 0x65, 0xB7},
    /* 0x9D */ {0xD1, 0x65, 0xC3},
    /* 0x9D */ {0xD2, 0x65, 0xC6},
    /* 0x9D */ {0xD3, 0x65, 0xC1},
    /* 0x9D */ {0xD4, 0x65, 0xC4},
    /* 0x9D */ {0xD5, 0x65, 0xCC},
    /* 0x9D */ {0xD6, 0x65, 0xD2},
    /* 0x9D */ {0xD7, 0x65, 0xDB},
    /* 0x9D */ {0xD8, 0x65, 0xD9},
    /* 0x9D */ {0xD9, 0x65, 0xE0},
    /* 0x9D */ {0xDA, 0x65, 0xE1},
    /* 0x9D */ {0xDB, 0x65, 0xF1},
    /* 0x9D */ {0xDC, 0x67, 0x72},
    /* 0x9D */ {0xDD, 0x66, 0x0A},
    /* 0x9D */ {0xDE, 0x66, 0x03},
    /* 0x9D */ {0xDF, 0x65, 0xFB},
    /* 0x9D */ {0xE0, 0x67, 0x73},
    /* 0x9D */ {0xE1, 0x66, 0x35},
    /* 0x9D */ {0xE2, 0x66, 0x36},
    /* 0x9D */ {0xE3, 0x66, 0x34},
    /* 0x9D */ {0xE4, 0x66, 0x1C},
    /* 0x9D */ {0xE5, 0x66, 0x4F},
    /* 0x9D */ {0xE6, 0x66, 0x44},
    /* 0x9D */ {0xE7, 0x66, 0x49},
    /* 0x9D */ {0xE8, 0x66, 0x41},
    /* 0x9D */ {0xE9, 0x66, 0x5E},
    /* 0x9D */ {0xEA, 0x66, 0x5D},
    /* 0x9D */ {0xEB, 0x66, 0x64},
    /* 0x9D */ {0xEC, 0x66, 0x67},
    /* 0x9D */ {0xED, 0x66, 0x68},
    /* 0x9D */ {0xEE, 0x66, 0x5F},
    /* 0x9D */ {0xEF, 0x66, 0x62},
    /* 0x9D */ {0xF0, 0x66, 0x70},
    /* 0x9D */ {0xF1, 0x66, 0x83},
    /* 0x9D */ {0xF2, 0x66, 0x88},
    /* 0x9D */ {0xF3, 0x66, 0x8E},
    /* 0x9D */ {0xF4, 0x66, 0x89},
    /* 0x9D */ {0xF5, 0x66, 0x84},
    /* 0x9D */ {0xF6, 0x66, 0x98},
    /* 0x9D */ {0xF7, 0x66, 0x9D},
    /* 0x9D */ {0xF8, 0x66, 0xC1},
    /* 0x9D */ {0xF9, 0x66, 0xB9},
    /* 0x9D */ {0xFA, 0x66, 0xC9},
    /* 0x9D */ {0xFB, 0x66, 0xBE},
    /* 0x9D */ {0xFC, 0x66, 0xBC},
    /* 0x9E */ {0x40, 0x66, 0xC4},
    /* 0x9E */ {0x41, 0x66, 0xB8},
    /* 0x9E */ {0x42, 0x66, 0xD6},
    /* 0x9E */ {0x43, 0x66, 0xDA},
    /* 0x9E */ {0x44, 0x66, 0xE0},
    /* 0x9E */ {0x45, 0x66, 0x3F},
    /* 0x9E */ {0x46, 0x66, 0xE6},
    /* 0x9E */ {0x47, 0x66, 0xE9},
    /* 0x9E */ {0x48, 0x66, 0xF0},
    /* 0x9E */ {0x49, 0x66, 0xF5},
    /* 0x9E */ {0x4A, 0x66, 0xF7},
    /* 0x9E */ {0x4B, 0x67, 0x0F},
    /* 0x9E */ {0x4C, 0x67, 0x16},
    /* 0x9E */ {0x4D, 0x67, 0x1E},
    /* 0x9E */ {0x4E, 0x67, 0x26},
    /* 0x9E */ {0x4F, 0x67, 0x27},
    /* 0x9E */ {0x50, 0x97, 0x38},
    /* 0x9E */ {0x51, 0x67, 0x2E},
    /* 0x9E */ {0x52, 0x67, 0x3F},
    /* 0x9E */ {0x53, 0x67, 0x36},
    /* 0x9E */ {0x54, 0x67, 0x41},
    /* 0x9E */ {0x55, 0x67, 0x38},
    /* 0x9E */ {0x56, 0x67, 0x37},
    /* 0x9E */ {0x57, 0x67, 0x46},
    /* 0x9E */ {0x58, 0x67, 0x5E},
    /* 0x9E */ {0x59, 0x67, 0x60},
    /* 0x9E */ {0x5A, 0x67, 0x59},
    /* 0x9E */ {0x5B, 0x67, 0x63},
    /* 0x9E */ {0x5C, 0x67, 0x64},
    /* 0x9E */ {0x5D, 0x67, 0x89},
    /* 0x9E */ {0x5E, 0x67, 0x70},
    /* 0x9E */ {0x5F, 0x67, 0xA9},
    /* 0x9E */ {0x60, 0x67, 0x7C},
    /* 0x9E */ {0x61, 0x67, 0x6A},
    /* 0x9E */ {0x62, 0x67, 0x8C},
    /* 0x9E */ {0x63, 0x67, 0x8B},
    /* 0x9E */ {0x64, 0x67, 0xA6},
    /* 0x9E */ {0x65, 0x67, 0xA1},
    /* 0x9E */ {0x66, 0x67, 0x85},
    /* 0x9E */ {0x67, 0x67, 0xB7},
    /* 0x9E */ {0x68, 0x67, 0xEF},
    /* 0x9E */ {0x69, 0x67, 0xB4},
    /* 0x9E */ {0x6A, 0x67, 0xEC},
    /* 0x9E */ {0x6B, 0x67, 0xB3},
    /* 0x9E */ {0x6C, 0x67, 0xE9},
    /* 0x9E */ {0x6D, 0x67, 0xB8},
    /* 0x9E */ {0x6E, 0x67, 0xE4},
    /* 0x9E */ {0x6F, 0x67, 0xDE},
    /* 0x9E */ {0x70, 0x67, 0xDD},
    /* 0x9E */ {0x71, 0x67, 0xE2},
    /* 0x9E */ {0x72, 0x67, 0xEE},
    /* 0x9E */ {0x73, 0x67, 0xB9},
    /* 0x9E */ {0x74, 0x67, 0xCE},
    /* 0x9E */ {0x75, 0x67, 0xC6},
    /* 0x9E */ {0x76, 0x67, 0xE7},
    /* 0x9E */ {0x77, 0x6A, 0x9C},
    /* 0x9E */ {0x78, 0x68, 0x1E},
    /* 0x9E */ {0x79, 0x68, 0x46},
    /* 0x9E */ {0x7A, 0x68, 0x29},
    /* 0x9E */ {0x7B, 0x68, 0x40},
    /* 0x9E */ {0x7C, 0x68, 0x4D},
    /* 0x9E */ {0x7D, 0x68, 0x32},
    /* 0x9E */ {0x7E, 0x68, 0x4E},
    /* 0x9E */ {0x80, 0x68, 0xB3},
    /* 0x9E */ {0x81, 0x68, 0x2B},
    /* 0x9E */ {0x82, 0x68, 0x59},
    /* 0x9E */ {0x83, 0x68, 0x63},
    /* 0x9E */ {0x84, 0x68, 0x77},
    /* 0x9E */ {0x85, 0x68, 0x7F},
    /* 0x9E */ {0x86, 0x68, 0x9F},
    /* 0x9E */ {0x87, 0x68, 0x8F},
    /* 0x9E */ {0x88, 0x68, 0xAD},
    /* 0x9E */ {0x89, 0x68, 0x94},
    /* 0x9E */ {0x8A, 0x68, 0x9D},
    /* 0x9E */ {0x8B, 0x68, 0x9B},
    /* 0x9E */ {0x8C, 0x68, 0x83},
    /* 0x9E */ {0x8D, 0x6A, 0xAE},
    /* 0x9E */ {0x8E, 0x68, 0xB9},
    /* 0x9E */ {0x8F, 0x68, 0x74},
    /* 0x9E */ {0x90, 0x68, 0xB5},
    /* 0x9E */ {0x91, 0x68, 0xA0},
    /* 0x9E */ {0x92, 0x68, 0xBA},
    /* 0x9E */ {0x93, 0x69, 0x0F},
    /* 0x9E */ {0x94, 0x68, 0x8D},
    /* 0x9E */ {0x95, 0x68, 0x7E},
    /* 0x9E */ {0x96, 0x69, 0x01},
    /* 0x9E */ {0x97, 0x68, 0xCA},
    /* 0x9E */ {0x98, 0x69, 0x08},
    /* 0x9E */ {0x99, 0x68, 0xD8},
    /* 0x9E */ {0x9A, 0x69, 0x22},
    /* 0x9E */ {0x9B, 0x69, 0x26},
    /* 0x9E */ {0x9C, 0x68, 0xE1},
    /* 0x9E */ {0x9D, 0x69, 0x0C},
    /* 0x9E */ {0x9E, 0x68, 0xCD},
    /* 0x9E */ {0x9F, 0x68, 0xD4},
    /* 0x9E */ {0xA0, 0x68, 0xE7},
    /* 0x9E */ {0xA1, 0x68, 0xD5},
    /* 0x9E */ {0xA2, 0x69, 0x36},
    /* 0x9E */ {0xA3, 0x69, 0x12},
    /* 0x9E */ {0xA4, 0x69, 0x04},
    /* 0x9E */ {0xA5, 0x68, 0xD7},
    /* 0x9E */ {0xA6, 0x68, 0xE3},
    /* 0x9E */ {0xA7, 0x69, 0x25},
    /* 0x9E */ {0xA8, 0x68, 0xF9},
    /* 0x9E */ {0xA9, 0x68, 0xE0},
    /* 0x9E */ {0xAA, 0x68, 0xEF},
    /* 0x9E */ {0xAB, 0x69, 0x28},
    /* 0x9E */ {0xAC, 0x69, 0x2A},
    /* 0x9E */ {0xAD, 0x69, 0x1A},
    /* 0x9E */ {0xAE, 0x69, 0x23},
    /* 0x9E */ {0xAF, 0x69, 0x21},
    /* 0x9E */ {0xB0, 0x68, 0xC6},
    /* 0x9E */ {0xB1, 0x69, 0x79},
    /* 0x9E */ {0xB2, 0x69, 0x77},
    /* 0x9E */ {0xB3, 0x69, 0x5C},
    /* 0x9E */ {0xB4, 0x69, 0x78},
    /* 0x9E */ {0xB5, 0x69, 0x6B},
    /* 0x9E */ {0xB6, 0x69, 0x54},
    /* 0x9E */ {0xB7, 0x69, 0x7E},
    /* 0x9E */ {0xB8, 0x69, 0x6E},
    /* 0x9E */ {0xB9, 0x69, 0x39},
    /* 0x9E */ {0xBA, 0x69, 0x74},
    /* 0x9E */ {0xBB, 0x69, 0x3D},
    /* 0x9E */ {0xBC, 0x69, 0x59},
    /* 0x9E */ {0xBD, 0x69, 0x30},
    /* 0x9E */ {0xBE, 0x69, 0x61},
    /* 0x9E */ {0xBF, 0x69, 0x5E},
    /* 0x9E */ {0xC0, 0x69, 0x5D},
    /* 0x9E */ {0xC1, 0x69, 0x81},
    /* 0x9E */ {0xC2, 0x69, 0x6A},
    /* 0x9E */ {0xC3, 0x69, 0xB2},
    /* 0x9E */ {0xC4, 0x69, 0xAE},
    /* 0x9E */ {0xC5, 0x69, 0xD0},
    /* 0x9E */ {0xC6, 0x69, 0xBF},
    /* 0x9E */ {0xC7, 0x69, 0xC1},
    /* 0x9E */ {0xC8, 0x69, 0xD3},
    /* 0x9E */ {0xC9, 0x69, 0xBE},
    /* 0x9E */ {0xCA, 0x69, 0xCE},
    /* 0x9E */ {0xCB, 0x5B, 0xE8},
    /* 0x9E */ {0xCC, 0x69, 0xCA},
    /* 0x9E */ {0xCD, 0x69, 0xDD},
    /* 0x9E */ {0xCE, 0x69, 0xBB},
    /* 0x9E */ {0xCF, 0x69, 0xC3},
    /* 0x9E */ {0xD0, 0x69, 0xA7},
    /* 0x9E */ {0xD1, 0x6A, 0x2E},
    /* 0x9E */ {0xD2, 0x69, 0x91},
    /* 0x9E */ {0xD3, 0x69, 0xA0},
    /* 0x9E */ {0xD4, 0x69, 0x9C},
    /* 0x9E */ {0xD5, 0x69, 0x95},
    /* 0x9E */ {0xD6, 0x69, 0xB4},
    /* 0x9E */ {0xD7, 0x69, 0xDE},
    /* 0x9E */ {0xD8, 0x69, 0xE8},
    /* 0x9E */ {0xD9, 0x6A, 0x02},
    /* 0x9E */ {0xDA, 0x6A, 0x1B},
    /* 0x9E */ {0xDB, 0x69, 0xFF},
    /* 0x9E */ {0xDC, 0x6B, 0x0A},
    /* 0x9E */ {0xDD, 0x69, 0xF9},
    /* 0x9E */ {0xDE, 0x69, 0xF2},
    /* 0x9E */ {0xDF, 0x69, 0xE7},
    /* 0x9E */ {0xE0, 0x6A, 0x05},
    /* 0x9E */ {0xE1, 0x69, 0xB1},
    /* 0x9E */ {0xE2, 0x6A, 0x1E},
    /* 0x9E */ {0xE3, 0x69, 0xED},
    /* 0x9E */ {0xE4, 0x6A, 0x14},
    /* 0x9E */ {0xE5, 0x69, 0xEB},
    /* 0x9E */ {0xE6, 0x6A, 0x0A},
    /* 0x9E */ {0xE7, 0x6A, 0x12},
    /* 0x9E */ {0xE8, 0x6A, 0xC1},
    /* 0x9E */ {0xE9, 0x6A, 0x23},
    /* 0x9E */ {0xEA, 0x6A, 0x13},
    /* 0x9E */ {0xEB, 0x6A, 0x44},
    /* 0x9E */ {0xEC, 0x6A, 0x0C},
    /* 0x9E */ {0xED, 0x6A, 0x72},
    /* 0x9E */ {0xEE, 0x6A, 0x36},
    /* 0x9E */ {0xEF, 0x6A, 0x78},
    /* 0x9E */ {0xF0, 0x6A, 0x47},
    /* 0x9E */ {0xF1, 0x6A, 0x62},
    /* 0x9E */ {0xF2, 0x6A, 0x59},
    /* 0x9E */ {0xF3, 0x6A, 0x66},
    /* 0x9E */ {0xF4, 0x6A, 0x48},
    /* 0x9E */ {0xF5, 0x6A, 0x38},
    /* 0x9E */ {0xF6, 0x6A, 0x22},
    /* 0x9E */ {0xF7, 0x6A, 0x90},
    /* 0x9E */ {0xF8, 0x6A, 0x8D},
    /* 0x9E */ {0xF9, 0x6A, 0xA0},
    /* 0x9E */ {0xFA, 0x6A, 0x84},
    /* 0x9E */ {0xFB, 0x6A, 0xA2},
    /* 0x9E */ {0xFC, 0x6A, 0xA3},
    /* 0x9F */ {0x40, 0x6A, 0x97},
    /* 0x9F */ {0x41, 0x86, 0x17},
    /* 0x9F */ {0x42, 0x6A, 0xBB},
    /* 0x9F */ {0x43, 0x6A, 0xC3},
    /* 0x9F */ {0x44, 0x6A, 0xC2},
    /* 0x9F */ {0x45, 0x6A, 0xB8},
    /* 0x9F */ {0x46, 0x6A, 0xB3},
    /* 0x9F */ {0x47, 0x6A, 0xAC},
    /* 0x9F */ {0x48, 0x6A, 0xDE},
    /* 0x9F */ {0x49, 0x6A, 0xD1},
    /* 0x9F */ {0x4A, 0x6A, 0xDF},
    /* 0x9F */ {0x4B, 0x6A, 0xAA},
    /* 0x9F */ {0x4C, 0x6A, 0xDA},
    /* 0x9F */ {0x4D, 0x6A, 0xEA},
    /* 0x9F */ {0x4E, 0x6A, 0xFB},
    /* 0x9F */ {0x4F, 0x6B, 0x05},
    /* 0x9F */ {0x50, 0x86, 0x16},
    /* 0x9F */ {0x51, 0x6A, 0xFA},
    /* 0x9F */ {0x52, 0x6B, 0x12},
    /* 0x9F */ {0x53, 0x6B, 0x16},
    /* 0x9F */ {0x54, 0x9B, 0x31},
    /* 0x9F */ {0x55, 0x6B, 0x1F},
    /* 0x9F */ {0x56, 0x6B, 0x38},
    /* 0x9F */ {0x57, 0x6B, 0x37},
    /* 0x9F */ {0x58, 0x76, 0xDC},
    /* 0x9F */ {0x59, 0x6B, 0x39},
    /* 0x9F */ {0x5A, 0x98, 0xEE},
    /* 0x9F */ {0x5B, 0x6B, 0x47},
    /* 0x9F */ {0x5C, 0x6B, 0x43},
    /* 0x9F */ {0x5D, 0x6B, 0x49},
    /* 0x9F */ {0x5E, 0x6B, 0x50},
    /* 0x9F */ {0x5F, 0x6B, 0x59},
    /* 0x9F */ {0x60, 0x6B, 0x54},
    /* 0x9F */ {0x61, 0x6B, 0x5B},
    /* 0x9F */ {0x62, 0x6B, 0x5F},
    /* 0x9F */ {0x63, 0x6B, 0x61},
    /* 0x9F */ {0x64, 0x6B, 0x78},
    /* 0x9F */ {0x65, 0x6B, 0x79},
    /* 0x9F */ {0x66, 0x6B, 0x7F},
    /* 0x9F */ {0x67, 0x6B, 0x80},
    /* 0x9F */ {0x68, 0x6B, 0x84},
    /* 0x9F */ {0x69, 0x6B, 0x83},
    /* 0x9F */ {0x6A, 0x6B, 0x8D},
    /* 0x9F */ {0x6B, 0x6B, 0x98},
    /* 0x9F */ {0x6C, 0x6B, 0x95},
    /* 0x9F */ {0x6D, 0x6B, 0x9E},
    /* 0x9F */ {0x6E, 0x6B, 0xA4},
    /* 0x9F */ {0x6F, 0x6B, 0xAA},
    /* 0x9F */ {0x70, 0x6B, 0xAB},
    /* 0x9F */ {0x71, 0x6B, 0xAF},
    /* 0x9F */ {0x72, 0x6B, 0xB2},
    /* 0x9F */ {0x73, 0x6B, 0xB1},
    /* 0x9F */ {0x74, 0x6B, 0xB3},
    /* 0x9F */ {0x75, 0x6B, 0xB7},
    /* 0x9F */ {0x76, 0x6B, 0xBC},
    /* 0x9F */ {0x77, 0x6B, 0xC6},
    /* 0x9F */ {0x78, 0x6B, 0xCB},
    /* 0x9F */ {0x79, 0x6B, 0xD3},
    /* 0x9F */ {0x7A, 0x6B, 0xDF},
    /* 0x9F */ {0x7B, 0x6B, 0xEC},
    /* 0x9F */ {0x7C, 0x6B, 0xEB},
    /* 0x9F */ {0x7D, 0x6B, 0xF3},
    /* 0x9F */ {0x7E, 0x6B, 0xEF},
    /* 0x9F */ {0x80, 0x9E, 0xBE},
    /* 0x9F */ {0x81, 0x6C, 0x08},
    /* 0x9F */ {0x82, 0x6C, 0x13},
    /* 0x9F */ {0x83, 0x6C, 0x14},
    /* 0x9F */ {0x84, 0x6C, 0x1B},
    /* 0x9F */ {0x85, 0x6C, 0x24},
    /* 0x9F */ {0x86, 0x6C, 0x23},
    /* 0x9F */ {0x87, 0x6C, 0x5E},
    /* 0x9F */ {0x88, 0x6C, 0x55},
    /* 0x9F */ {0x89, 0x6C, 0x62},
    /* 0x9F */ {0x8A, 0x6C, 0x6A},
    /* 0x9F */ {0x8B, 0x6C, 0x82},
    /* 0x9F */ {0x8C, 0x6C, 0x8D},
    /* 0x9F */ {0x8D, 0x6C, 0x9A},
    /* 0x9F */ {0x8E, 0x6C, 0x81},
    /* 0x9F */ {0x8F, 0x6C, 0x9B},
    /* 0x9F */ {0x90, 0x6C, 0x7E},
    /* 0x9F */ {0x91, 0x6C, 0x68},
    /* 0x9F */ {0x92, 0x6C, 0x73},
    /* 0x9F */ {0x93, 0x6C, 0x92},
    /* 0x9F */ {0x94, 0x6C, 0x90},
    /* 0x9F */ {0x95, 0x6C, 0xC4},
    /* 0x9F */ {0x96, 0x6C, 0xF1},
    /* 0x9F */ {0x97, 0x6C, 0xD3},
    /* 0x9F */ {0x98, 0x6C, 0xBD},
    /* 0x9F */ {0x99, 0x6C, 0xD7},
    /* 0x9F */ {0x9A, 0x6C, 0xC5},
    /* 0x9F */ {0x9B, 0x6C, 0xDD},
    /* 0x9F */ {0x9C, 0x6C, 0xAE},
    /* 0x9F */ {0x9D, 0x6C, 0xB1},
    /* 0x9F */ {0x9E, 0x6C, 0xBE},
    /* 0x9F */ {0x9F, 0x6C, 0xBA},
    /* 0x9F */ {0xA0, 0x6C, 0xDB},
    /* 0x9F */ {0xA1, 0x6C, 0xEF},
    /* 0x9F */ {0xA2, 0x6C, 0xD9},
    /* 0x9F */ {0xA3, 0x6C, 0xEA},
    /* 0x9F */ {0xA4, 0x6D, 0x1F},
    /* 0x9F */ {0xA5, 0x88, 0x4D},
    /* 0x9F */ {0xA6, 0x6D, 0x36},
    /* 0x9F */ {0xA7, 0x6D, 0x2B},
    /* 0x9F */ {0xA8, 0x6D, 0x3D},
    /* 0x9F */ {0xA9, 0x6D, 0x38},
    /* 0x9F */ {0xAA, 0x6D, 0x19},
    /* 0x9F */ {0xAB, 0x6D, 0x35},
    /* 0x9F */ {0xAC, 0x6D, 0x33},
    /* 0x9F */ {0xAD, 0x6D, 0x12},
    /* 0x9F */ {0xAE, 0x6D, 0x0C},
    /* 0x9F */ {0xAF, 0x6D, 0x63},
    /* 0x9F */ {0xB0, 0x6D, 0x93},
    /* 0x9F */ {0xB1, 0x6D, 0x64},
    /* 0x9F */ {0xB2, 0x6D, 0x5A},
    /* 0x9F */ {0xB3, 0x6D, 0x79},
    /* 0x9F */ {0xB4, 0x6D, 0x59},
    /* 0x9F */ {0xB5, 0x6D, 0x8E},
    /* 0x9F */ {0xB6, 0x6D, 0x95},
    /* 0x9F */ {0xB7, 0x6F, 0xE4},
    /* 0x9F */ {0xB8, 0x6D, 0x85},
    /* 0x9F */ {0xB9, 0x6D, 0xF9},
    /* 0x9F */ {0xBA, 0x6E, 0x15},
    /* 0x9F */ {0xBB, 0x6E, 0x0A},
    /* 0x9F */ {0xBC, 0x6D, 0xB5},
    /* 0x9F */ {0xBD, 0x6D, 0xC7},
    /* 0x9F */ {0xBE, 0x6D, 0xE6},
    /* 0x9F */ {0xBF, 0x6D, 0xB8},
    /* 0x9F */ {0xC0, 0x6D, 0xC6},
    /* 0x9F */ {0xC1, 0x6D, 0xEC},
    /* 0x9F */ {0xC2, 0x6D, 0xDE},
    /* 0x9F */ {0xC3, 0x6D, 0xCC},
    /* 0x9F */ {0xC4, 0x6D, 0xE8},
    /* 0x9F */ {0xC5, 0x6D, 0xD2},
    /* 0x9F */ {0xC6, 0x6D, 0xC5},
    /* 0x9F */ {0xC7, 0x6D, 0xFA},
    /* 0x9F */ {0xC8, 0x6D, 0xD9},
    /* 0x9F */ {0xC9, 0x6D, 0xE4},
    /* 0x9F */ {0xCA, 0x6D, 0xD5},
    /* 0x9F */ {0xCB, 0x6D, 0xEA},
    /* 0x9F */ {0xCC, 0x6D, 0xEE},
    /* 0x9F */ {0xCD, 0x6E, 0x2D},
    /* 0x9F */ {0xCE, 0x6E, 0x6E},
    /* 0x9F */ {0xCF, 0x6E, 0x2E},
    /* 0x9F */ {0xD0, 0x6E, 0x19},
    /* 0x9F */ {0xD1, 0x6E, 0x72},
    /* 0x9F */ {0xD2, 0x6E, 0x5F},
    /* 0x9F */ {0xD3, 0x6E, 0x3E},
    /* 0x9F */ {0xD4, 0x6E, 0x23},
    /* 0x9F */ {0xD5, 0x6E, 0x6B},
    /* 0x9F */ {0xD6, 0x6E, 0x2B},
    /* 0x9F */ {0xD7, 0x6E, 0x76},
    /* 0x9F */ {0xD8, 0x6E, 0x4D},
    /* 0x9F */ {0xD9, 0x6E, 0x1F},
    /* 0x9F */ {0xDA, 0x6E, 0x43},
    /* 0x9F */ {0xDB, 0x6E, 0x3A},
    /* 0x9F */ {0xDC, 0x6E, 0x4E},
    /* 0x9F */ {0xDD, 0x6E, 0x24},
    /* 0x9F */ {0xDE, 0x6E, 0xFF},
    /* 0x9F */ {0xDF, 0x6E, 0x1D},
    /* 0x9F */ {0xE0, 0x6E, 0x38},
    /* 0x9F */ {0xE1, 0x6E, 0x82},
    /* 0x9F */ {0xE2, 0x6E, 0xAA},
    /* 0x9F */ {0xE3, 0x6E, 0x98},
    /* 0x9F */ {0xE4, 0x6E, 0xC9},
    /* 0x9F */ {0xE5, 0x6E, 0xB7},
    /* 0x9F */ {0xE6, 0x6E, 0xD3},
    /* 0x9F */ {0xE7, 0x6E, 0xBD},
    /* 0x9F */ {0xE8, 0x6E, 0xAF},
    /* 0x9F */ {0xE9, 0x6E, 0xC4},
    /* 0x9F */ {0xEA, 0x6E, 0xB2},
    /* 0x9F */ {0xEB, 0x6E, 0xD4},
    /* 0x9F */ {0xEC, 0x6E, 0xD5},
    /* 0x9F */ {0xED, 0x6E, 0x8F},
    /* 0x9F */ {0xEE, 0x6E, 0xA5},
    /* 0x9F */ {0xEF, 0x6E, 0xC2},
    /* 0x9F */ {0xF0, 0x6E, 0x9F},
    /* 0x9F */ {0xF1, 0x6F, 0x41},
    /* 0x9F */ {0xF2, 0x6F, 0x11},
    /* 0x9F */ {0xF3, 0x70, 0x4C},
    /* 0x9F */ {0xF4, 0x6E, 0xEC},
    /* 0x9F */ {0xF5, 0x6E, 0xF8},
    /* 0x9F */ {0xF6, 0x6E, 0xFE},
    /* 0x9F */ {0xF7, 0x6F, 0x3F},
    /* 0x9F */ {0xF8, 0x6E, 0xF2},
    /* 0x9F */ {0xF9, 0x6F, 0x31},
    /* 0x9F */ {0xFA, 0x6E, 0xEF},
    /* 0x9F */ {0xFB, 0x6F, 0x32},
    /* 0x9F */ {0xFC, 0x6E, 0xCC},
    /* 0xE0 */ {0x40, 0x6F, 0x3E},
    /* 0xE0 */ {0x41, 0x6F, 0x13},
    /* 0xE0 */ {0x42, 0x6E, 0xF7},
    /* 0xE0 */ {0x43, 0x6F, 0x86},
    /* 0xE0 */ {0x44, 0x6F, 0x7A},
    /* 0xE0 */ {0x45, 0x6F, 0x78},
    /* 0xE0 */ {0x46, 0x6F, 0x81},
    /* 0xE0 */ {0x47, 0x6F, 0x80},
    /* 0xE0 */ {0x48, 0x6F, 0x6F},
    /* 0xE0 */ {0x49, 0x6F, 0x5B},
    /* 0xE0 */ {0x4A, 0x6F, 0xF3},
    /* 0xE0 */ {0x4B, 0x6F, 0x6D},
    /* 0xE0 */ {0x4C, 0x6F, 0x82},
    /* 0xE0 */ {0x4D, 0x6F, 0x7C},
    /* 0xE0 */ {0x4E, 0x6F, 0x58},
    /* 0xE0 */ {0x4F, 0x6F, 0x8E},
    /* 0xE0 */ {0x50, 0x6F, 0x91},
    /* 0xE0 */ {0x51, 0x6F, 0xC2},
    /* 0xE0 */ {0x52, 0x6F, 0x66},
    /* 0xE0 */ {0x53, 0x6F, 0xB3},
    /* 0xE0 */ {0x54, 0x6F, 0xA3},
    /* 0xE0 */ {0x55, 0x6F, 0xA1},
    /* 0xE0 */ {0x56, 0x6F, 0xA4},
    /* 0xE0 */ {0x57, 0x6F, 0xB9},
    /* 0xE0 */ {0x58, 0x6F, 0xC6},
    /* 0xE0 */ {0x59, 0x6F, 0xAA},
    /* 0xE0 */ {0x5A, 0x6F, 0xDF},
    /* 0xE0 */ {0x5B, 0x6F, 0xD5},
    /* 0xE0 */ {0x5C, 0x6F, 0xEC},
    /* 0xE0 */ {0x5D, 0x6F, 0xD4},
    /* 0xE0 */ {0x5E, 0x6F, 0xD8},
    /* 0xE0 */ {0x5F, 0x6F, 0xF1},
    /* 0xE0 */ {0x60, 0x6F, 0xEE},
    /* 0xE0 */ {0x61, 0x6F, 0xDB},
    /* 0xE0 */ {0x62, 0x70, 0x09},
    /* 0xE0 */ {0x63, 0x70, 0x0B},
    /* 0xE0 */ {0x64, 0x6F, 0xFA},
    /* 0xE0 */ {0x65, 0x70, 0x11},
    /* 0xE0 */ {0x66, 0x70, 0x01},
    /* 0xE0 */ {0x67, 0x70, 0x0F},
    /* 0xE0 */ {0x68, 0x6F, 0xFE},
    /* 0xE0 */ {0x69, 0x70, 0x1B},
    /* 0xE0 */ {0x6A, 0x70, 0x1A},
    /* 0xE0 */ {0x6B, 0x6F, 0x74},
    /* 0xE0 */ {0x6C, 0x70, 0x1D},
    /* 0xE0 */ {0x6D, 0x70, 0x18},
    /* 0xE0 */ {0x6E, 0x70, 0x1F},
    /* 0xE0 */ {0x6F, 0x70, 0x30},
    /* 0xE0 */ {0x70, 0x70, 0x3E},
    /* 0xE0 */ {0x71, 0x70, 0x32},
    /* 0xE0 */ {0x72, 0x70, 0x51},
    /* 0xE0 */ {0x73, 0x70, 0x63},
    /* 0xE0 */ {0x74, 0x70, 0x99},
    /* 0xE0 */ {0x75, 0x70, 0x92},
    /* 0xE0 */ {0x76, 0x70, 0xAF},
    /* 0xE0 */ {0x77, 0x70, 0xF1},
    /* 0xE0 */ {0x78, 0x70, 0xAC},
    /* 0xE0 */ {0x79, 0x70, 0xB8},
    /* 0xE0 */ {0x7A, 0x70, 0xB3},
    /* 0xE0 */ {0x7B, 0x70, 0xAE},
    /* 0xE0 */ {0x7C, 0x70, 0xDF},
    /* 0xE0 */ {0x7D, 0x70, 0xCB},
    /* 0xE0 */ {0x7E, 0x70, 0xDD},
    /* 0xE0 */ {0x80, 0x70, 0xD9},
    /* 0xE0 */ {0x81, 0x71, 0x09},
    /* 0xE0 */ {0x82, 0x70, 0xFD},
    /* 0xE0 */ {0x83, 0x71, 0x1C},
    /* 0xE0 */ {0x84, 0x71, 0x19},
    /* 0xE0 */ {0x85, 0x71, 0x65},
    /* 0xE0 */ {0x86, 0x71, 0x55},
    /* 0xE0 */ {0x87, 0x71, 0x88},
    /* 0xE0 */ {0x88, 0x71, 0x66},
    /* 0xE0 */ {0x89, 0x71, 0x62},
    /* 0xE0 */ {0x8A, 0x71, 0x4C},
    /* 0xE0 */ {0x8B, 0x71, 0x56},
    /* 0xE0 */ {0x8C, 0x71, 0x6C},
    /* 0xE0 */ {0x8D, 0x71, 0x8F},
    /* 0xE0 */ {0x8E, 0x71, 0xFB},
    /* 0xE0 */ {0x8F, 0x71, 0x84},
    /* 0xE0 */ {0x90, 0x71, 0x95},
    /* 0xE0 */ {0x91, 0x71, 0xA8},
    /* 0xE0 */ {0x92, 0x71, 0xAC},
    /* 0xE0 */ {0x93, 0x71, 0xD7},
    /* 0xE0 */ {0x94, 0x71, 0xB9},
    /* 0xE0 */ {0x95, 0x71, 0xBE},
    /* 0xE0 */ {0x96, 0x71, 0xD2},
    /* 0xE0 */ {0x97, 0x71, 0xC9},
    /* 0xE0 */ {0x98, 0x71, 0xD4},
    /* 0xE0 */ {0x99, 0x71, 0xCE},
    /* 0xE0 */ {0x9A, 0x71, 0xE0},
    /* 0xE0 */ {0x9B, 0x71, 0xEC},
    /* 0xE0 */ {0x9C, 0x71, 0xE7},
    /* 0xE0 */ {0x9D, 0x71, 0xF5},
    /* 0xE0 */ {0x9E, 0x71, 0xFC},
    /* 0xE0 */ {0x9F, 0x71, 0xF9},
    /* 0xE0 */ {0xA0, 0x71, 0xFF},
    /* 0xE0 */ {0xA1, 0x72, 0x0D},
    /* 0xE0 */ {0xA2, 0x72, 0x10},
    /* 0xE0 */ {0xA3, 0x72, 0x1B},
    /* 0xE0 */ {0xA4, 0x72, 0x28},
    /* 0xE0 */ {0xA5, 0x72, 0x2D},
    /* 0xE0 */ {0xA6, 0x72, 0x2C},
    /* 0xE0 */ {0xA7, 0x72, 0x30},
    /* 0xE0 */ {0xA8, 0x72, 0x32},
    /* 0xE0 */ {0xA9, 0x72, 0x3B},
    /* 0xE0 */ {0xAA, 0x72, 0x3C},
    /* 0xE0 */ {0xAB, 0x72, 0x3F},
    /* 0xE0 */ {0xAC, 0x72, 0x40},
    /* 0xE0 */ {0xAD, 0x72, 0x46},
    /* 0xE0 */ {0xAE, 0x72, 0x4B},
    /* 0xE0 */ {0xAF, 0x72, 0x58},
    /* 0xE0 */ {0xB0, 0x72, 0x74},
    /* 0xE0 */ {0xB1, 0x72, 0x7E},
    /* 0xE0 */ {0xB2, 0x72, 0x82},
    /* 0xE0 */ {0xB3, 0x72, 0x81},
    /* 0xE0 */ {0xB4, 0x72, 0x87},
    /* 0xE0 */ {0xB5, 0x72, 0x92},
    /* 0xE0 */ {0xB6, 0x72, 0x96},
    /* 0xE0 */ {0xB7, 0x72, 0xA2},
    /* 0xE0 */ {0xB8, 0x72, 0xA7},
    /* 0xE0 */ {0xB9, 0x72, 0xB9},
    /* 0xE0 */ {0xBA, 0x72, 0xB2},
    /* 0xE0 */ {0xBB, 0x72, 0xC3},
    /* 0xE0 */ {0xBC, 0x72, 0xC6},
    /* 0xE0 */ {0xBD, 0x72, 0xC4},
    /* 0xE0 */ {0xBE, 0x72, 0xCE},
    /* 0xE0 */ {0xBF, 0x72, 0xD2},
    /* 0xE0 */ {0xC0, 0x72, 0xE2},
    /* 0xE0 */ {0xC1, 0x72, 0xE0},
    /* 0xE0 */ {0xC2, 0x72, 0xE1},
    /* 0xE0 */ {0xC3, 0x72, 0xF9},
    /* 0xE0 */ {0xC4, 0x72, 0xF7},
    /* 0xE0 */ {0xC5, 0x50, 0x0F},
    /* 0xE0 */ {0xC6, 0x73, 0x17},
    /* 0xE0 */ {0xC7, 0x73, 0x0A},
    /* 0xE0 */ {0xC8, 0x73, 0x1C},
    /* 0xE0 */ {0xC9, 0x73, 0x16},
    /* 0xE0 */ {0xCA, 0x73, 0x1D},
    /* 0xE0 */ {0xCB, 0x73, 0x34},
    /* 0xE0 */ {0xCC, 0x73, 0x2F},
    /* 0xE0 */ {0xCD, 0x73, 0x29},
    /* 0xE0 */ {0xCE, 0x73, 0x25},
    /* 0xE0 */ {0xCF, 0x73, 0x3E},
    /* 0xE0 */ {0xD0, 0x73, 0x4E},
    /* 0xE0 */ {0xD1, 0x73, 0x4F},
    /* 0xE0 */ {0xD2, 0x9E, 0xD8},
    /* 0xE0 */ {0xD3, 0x73, 0x57},
    /* 0xE0 */ {0xD4, 0x73, 0x6A},
    /* 0xE0 */ {0xD5, 0x73, 0x68},
    /* 0xE0 */ {0xD6, 0x73, 0x70},
    /* 0xE0 */ {0xD7, 0x73, 0x78},
    /* 0xE0 */ {0xD8, 0x73, 0x75},
    /* 0xE0 */ {0xD9, 0x73, 0x7B},
    /* 0xE0 */ {0xDA, 0x73, 0x7A},
    /* 0xE0 */ {0xDB, 0x73, 0xC8},
    /* 0xE0 */ {0xDC, 0x73, 0xB3},
    /* 0xE0 */ {0xDD, 0x73, 0xCE},
    /* 0xE0 */ {0xDE, 0x73, 0xBB},
    /* 0xE0 */ {0xDF, 0x73, 0xC0},
    /* 0xE0 */ {0xE0, 0x73, 0xE5},
    /* 0xE0 */ {0xE1, 0x73, 0xEE},
    /* 0xE0 */ {0xE2, 0x73, 0xDE},
    /* 0xE0 */ {0xE3, 0x74, 0xA2},
    /* 0xE0 */ {0xE4, 0x74, 0x05},
    /* 0xE0 */ {0xE5, 0x74, 0x6F},
    /* 0xE0 */ {0xE6, 0x74, 0x25},
    /* 0xE0 */ {0xE7, 0x73, 0xF8},
    /* 0xE0 */ {0xE8, 0x74, 0x32},
    /* 0xE0 */ {0xE9, 0x74, 0x3A},
    /* 0xE0 */ {0xEA, 0x74, 0x55},
    /* 0xE0 */ {0xEB, 0x74, 0x3F},
    /* 0xE0 */ {0xEC, 0x74, 0x5F},
    /* 0xE0 */ {0xED, 0x74, 0x59},
    /* 0xE0 */ {0xEE, 0x74, 0x41},
    /* 0xE0 */ {0xEF, 0x74, 0x5C},
    /* 0xE0 */ {0xF0, 0x74, 0x69},
    /* 0xE0 */ {0xF1, 0x74, 0x70},
    /* 0xE0 */ {0xF2, 0x74, 0x63},
    /* 0xE0 */ {0xF3, 0x74, 0x6A},
    /* 0xE0 */ {0xF4, 0x74, 0x76},
    /* 0xE0 */ {0xF5, 0x74, 0x7E},
    /* 0xE0 */ {0xF6, 0x74, 0x8B},
    /* 0xE0 */ {0xF7, 0x74, 0x9E},
    /* 0xE0 */ {0xF8, 0x74, 0xA7},
    /* 0xE0 */ {0xF9, 0x74, 0xCA},
    /* 0xE0 */ {0xFA, 0x74, 0xCF},
    /* 0xE0 */ {0xFB, 0x74, 0xD4},
    /* 0xE0 */ {0xFC, 0x73, 0xF1},
    /* 0xE1 */ {0x40, 0x74, 0xE0},
    /* 0xE1 */ {0x41, 0x74, 0xE3},
    /* 0xE1 */ {0x42, 0x74, 0xE7},
    /* 0xE1 */ {0x43, 0x74, 0xE9},
    /* 0xE1 */ {0x44, 0x74, 0xEE},
    /* 0xE1 */ {0x45, 0x74, 0xF2},
    /* 0xE1 */ {0x46, 0x74, 0xF0},
    /* 0xE1 */ {0x47, 0x74, 0xF1},
    /* 0xE1 */ {0x48, 0x74, 0xF8},
    /* 0xE1 */ {0x49, 0x74, 0xF7},
    /* 0xE1 */ {0x4A, 0x75, 0x04},
    /* 0xE1 */ {0x4B, 0x75, 0x03},
    /* 0xE1 */ {0x4C, 0x75, 0x05},
    /* 0xE1 */ {0x4D, 0x75, 0x0C},
    /* 0xE1 */ {0x4E, 0x75, 0x0E},
    /* 0xE1 */ {0x4F, 0x75, 0x0D},
    /* 0xE1 */ {0x50, 0x75, 0x15},
    /* 0xE1 */ {0x51, 0x75, 0x13},
    /* 0xE1 */ {0x52, 0x75, 0x1E},
    /* 0xE1 */ {0x53, 0x75, 0x26},
    /* 0xE1 */ {0x54, 0x75, 0x2C},
    /* 0xE1 */ {0x55, 0x75, 0x3C},
    /* 0xE1 */ {0x56, 0x75, 0x44},
    /* 0xE1 */ {0x57, 0x75, 0x4D},
    /* 0xE1 */ {0x58, 0x75, 0x4A},
    /* 0xE1 */ {0x59, 0x75, 0x49},
    /* 0xE1 */ {0x5A, 0x75, 0x5B},
    /* 0xE1 */ {0x5B, 0x75, 0x46},
    /* 0xE1 */ {0x5C, 0x75, 0x5A},
    /* 0xE1 */ {0x5D, 0x75, 0x69},
    /* 0xE1 */ {0x5E, 0x75, 0x64},
    /* 0xE1 */ {0x5F, 0x75, 0x67},
    /* 0xE1 */ {0x60, 0x75, 0x6B},
    /* 0xE1 */ {0x61, 0x75, 0x6D},
    /* 0xE1 */ {0x62, 0x75, 0x78},
    /* 0xE1 */ {0x63, 0x75, 0x76},
    /* 0xE1 */ {0x64, 0x75, 0x86},
    /* 0xE1 */ {0x65, 0x75, 0x87},
    /* 0xE1 */ {0x66, 0x75, 0x74},
    /* 0xE1 */ {0x67, 0x75, 0x8A},
    /* 0xE1 */ {0x68, 0x75, 0x89},
    /* 0xE1 */ {0x69, 0x75, 0x82},
    /* 0xE1 */ {0x6A, 0x75, 0x94},
    /* 0xE1 */ {0x6B, 0x75, 0x9A},
    /* 0xE1 */ {0x6C, 0x75, 0x9D},
    /* 0xE1 */ {0x6D, 0x75, 0xA5},
    /* 0xE1 */ {0x6E, 0x75, 0xA3},
    /* 0xE1 */ {0x6F, 0x75, 0xC2},
    /* 0xE1 */ {0x70, 0x75, 0xB3},
    /* 0xE1 */ {0x71, 0x75, 0xC3},
    /* 0xE1 */ {0x72, 0x75, 0xB5},
    /* 0xE1 */ {0x73, 0x75, 0xBD},
    /* 0xE1 */ {0x74, 0x75, 0xB8},
    /* 0xE1 */ {0x75, 0x75, 0xBC},
    /* 0xE1 */ {0x76, 0x75, 0xB1},
    /* 0xE1 */ {0x77, 0x75, 0xCD},
    /* 0xE1 */ {0x78, 0x75, 0xCA},
    /* 0xE1 */ {0x79, 0x75, 0xD2},
    /* 0xE1 */ {0x7A, 0x75, 0xD9},
    /* 0xE1 */ {0x7B, 0x75, 0xE3},
    /* 0xE1 */ {0x7C, 0x75, 0xDE},
    /* 0xE1 */ {0x7D, 0x75, 0xFE},
    /* 0xE1 */ {0x7E, 0x75, 0xFF},
    /* 0xE1 */ {0x80, 0x75, 0xFC},
    /* 0xE1 */ {0x81, 0x76, 0x01},
    /* 0xE1 */ {0x82, 0x75, 0xF0},
    /* 0xE1 */ {0x83, 0x75, 0xFA},
    /* 0xE1 */ {0x84, 0x75, 0xF2},
    /* 0xE1 */ {0x85, 0x75, 0xF3},
    /* 0xE1 */ {0x86, 0x76, 0x0B},
    /* 0xE1 */ {0x87, 0x76, 0x0D},
    /* 0xE1 */ {0x88, 0x76, 0x09},
    /* 0xE1 */ {0x89, 0x76, 0x1F},
    /* 0xE1 */ {0x8A, 0x76, 0x27},
    /* 0xE1 */ {0x8B, 0x76, 0x20},
    /* 0xE1 */ {0x8C, 0x76, 0x21},
    /* 0xE1 */ {0x8D, 0x76, 0x22},
    /* 0xE1 */ {0x8E, 0x76, 0x24},
    /* 0xE1 */ {0x8F, 0x76, 0x34},
    /* 0xE1 */ {0x90, 0x76, 0x30},
    /* 0xE1 */ {0x91, 0x76, 0x3B},
    /* 0xE1 */ {0x92, 0x76, 0x47},
    /* 0xE1 */ {0x93, 0x76, 0x48},
    /* 0xE1 */ {0x94, 0x76, 0x46},
    /* 0xE1 */ {0x95, 0x76, 0x5C},
    /* 0xE1 */ {0x96, 0x76, 0x58},
    /* 0xE1 */ {0x97, 0x76, 0x61},
    /* 0xE1 */ {0x98, 0x76, 0x62},
    /* 0xE1 */ {0x99, 0x76, 0x68},
    /* 0xE1 */ {0x9A, 0x76, 0x69},
    /* 0xE1 */ {0x9B, 0x76, 0x6A},
    /* 0xE1 */ {0x9C, 0x76, 0x67},
    /* 0xE1 */ {0x9D, 0x76, 0x6C},
    /* 0xE1 */ {0x9E, 0x76, 0x70},
    /* 0xE1 */ {0x9F, 0x76, 0x72},
    /* 0xE1 */ {0xA0, 0x76, 0x76},
    /* 0xE1 */ {0xA1, 0x76, 0x78},
    /* 0xE1 */ {0xA2, 0x76, 0x7C},
    /* 0xE1 */ {0xA3, 0x76, 0x80},
    /* 0xE1 */ {0xA4, 0x76, 0x83},
    /* 0xE1 */ {0xA5, 0x76, 0x88},
    /* 0xE1 */ {0xA6, 0x76, 0x8B},
    /* 0xE1 */ {0xA7, 0x76, 0x8E},
    /* 0xE1 */ {0xA8, 0x76, 0x96},
    /* 0xE1 */ {0xA9, 0x76, 0x93},
    /* 0xE1 */ {0xAA, 0x76, 0x99},
    /* 0xE1 */ {0xAB, 0x76, 0x9A},
    /* 0xE1 */ {0xAC, 0x76, 0xB0},
    /* 0xE1 */ {0xAD, 0x76, 0xB4},
    /* 0xE1 */ {0xAE, 0x76, 0xB8},
    /* 0xE1 */ {0xAF, 0x76, 0xB9},
    /* 0xE1 */ {0xB0, 0x76, 0xBA},
    /* 0xE1 */ {0xB1, 0x76, 0xC2},
    /* 0xE1 */ {0xB2, 0x76, 0xCD},
    /* 0xE1 */ {0xB3, 0x76, 0xD6},
    /* 0xE1 */ {0xB4, 0x76, 0xD2},
    /* 0xE1 */ {0xB5, 0x76, 0xDE},
    /* 0xE1 */ {0xB6, 0x76, 0xE1},
    /* 0xE1 */ {0xB7, 0x76, 0xE5},
    /* 0xE1 */ {0xB8, 0x76, 0xE7},
    /* 0xE1 */ {0xB9, 0x76, 0xEA},
    /* 0xE1 */ {0xBA, 0x86, 0x2F},
    /* 0xE1 */ {0xBB, 0x76, 0xFB},
    /* 0xE1 */ {0xBC, 0x77, 0x08},
    /* 0xE1 */ {0xBD, 0x77, 0x07},
    /* 0xE1 */ {0xBE, 0x77, 0x04},
    /* 0xE1 */ {0xBF, 0x77, 0x29},
    /* 0xE1 */ {0xC0, 0x77, 0x24},
    /* 0xE1 */ {0xC1, 0x77, 0x1E},
    /* 0xE1 */ {0xC2, 0x77, 0x25},
    /* 0xE1 */ {0xC3, 0x77, 0x26},
    /* 0xE1 */ {0xC4, 0x77, 0x1B},
    /* 0xE1 */ {0xC5, 0x77, 0x37},
    /* 0xE1 */ {0xC6, 0x77, 0x38},
    /* 0xE1 */ {0xC7, 0x77, 0x47},
    /* 0xE1 */ {0xC8, 0x77, 0x5A},
    /* 0xE1 */ {0xC9, 0x77, 0x68},
    /* 0xE1 */ {0xCA, 0x77, 0x6B},
    /* 0xE1 */ {0xCB, 0x77, 0x5B},
    /* 0xE1 */ {0xCC, 0x77, 0x65},
    /* 0xE1 */ {0xCD, 0x77, 0x7F},
    /* 0xE1 */ {0xCE, 0x77, 0x7E},
    /* 0xE1 */ {0xCF, 0x77, 0x79},
    /* 0xE1 */ {0xD0, 0x77, 0x8E},
    /* 0xE1 */ {0xD1, 0x77, 0x8B},
    /* 0xE1 */ {0xD2, 0x77, 0x91},
    /* 0xE1 */ {0xD3, 0x77, 0xA0},
    /* 0xE1 */ {0xD4, 0x77, 0x9E},
    /* 0xE1 */ {0xD5, 0x77, 0xB0},
    /* 0xE1 */ {0xD6, 0x77, 0xB6},
    /* 0xE1 */ {0xD7, 0x77, 0xB9},
    /* 0xE1 */ {0xD8, 0x77, 0xBF},
    /* 0xE1 */ {0xD9, 0x77, 0xBC},
    /* 0xE1 */ {0xDA, 0x77, 0xBD},
    /* 0xE1 */ {0xDB, 0x77, 0xBB},
    /* 0xE1 */ {0xDC, 0x77, 0xC7},
    /* 0xE1 */ {0xDD, 0x77, 0xCD},
    /* 0xE1 */ {0xDE, 0x77, 0xD7},
    /* 0xE1 */ {0xDF, 0x77, 0xDA},
    /* 0xE1 */ {0xE0, 0x77, 0xDC},
    /* 0xE1 */ {0xE1, 0x77, 0xE3},
    /* 0xE1 */ {0xE2, 0x77, 0xEE},
    /* 0xE1 */ {0xE3, 0x77, 0xFC},
    /* 0xE1 */ {0xE4, 0x78, 0x0C},
    /* 0xE1 */ {0xE5, 0x78, 0x12},
    /* 0xE1 */ {0xE6, 0x79, 0x26},
    /* 0xE1 */ {0xE7, 0x78, 0x20},
    /* 0xE1 */ {0xE8, 0x79, 0x2A},
    /* 0xE1 */ {0xE9, 0x78, 0x45},
    /* 0xE1 */ {0xEA, 0x78, 0x8E},
    /* 0xE1 */ {0xEB, 0x78, 0x74},
    /* 0xE1 */ {0xEC, 0x78, 0x86},
    /* 0xE1 */ {0xED, 0x78, 0x7C},
    /* 0xE1 */ {0xEE, 0x78, 0x9A},
    /* 0xE1 */ {0xEF, 0x78, 0x8C},
    /* 0xE1 */ {0xF0, 0x78, 0xA3},
    /* 0xE1 */ {0xF1, 0x78, 0xB5},
    /* 0xE1 */ {0xF2, 0x78, 0xAA},
    /* 0xE1 */ {0xF3, 0x78, 0xAF},
    /* 0xE1 */ {0xF4, 0x78, 0xD1},
    /* 0xE1 */ {0xF5, 0x78, 0xC6},
    /* 0xE1 */ {0xF6, 0x78, 0xCB},
    /* 0xE1 */ {0xF7, 0x78, 0xD4},
    /* 0xE1 */ {0xF8, 0x78, 0xBE},
    /* 0xE1 */ {0xF9, 0x78, 0xBC},
    /* 0xE1 */ {0xFA, 0x78, 0xC5},
    /* 0xE1 */ {0xFB, 0x78, 0xCA},
    /* 0xE1 */ {0xFC, 0x78, 0xEC},
    /* 0xE2 */ {0x40, 0x78, 0xE7},
    /* 0xE2 */ {0x41, 0x78, 0xDA},
    /* 0xE2 */ {0x42, 0x78, 0xFD},
    /* 0xE2 */ {0x43, 0x78, 0xF4},
    /* 0xE2 */ {0x44, 0x79, 0x07},
    /* 0xE2 */ {0x45, 0x79, 0x12},
    /* 0xE2 */ {0x46, 0x79, 0x11},
    /* 0xE2 */ {0x47, 0x79, 0x19},
    /* 0xE2 */ {0x48, 0x79, 0x2C},
    /* 0xE2 */ {0x49, 0x79, 0x2B},
    /* 0xE2 */ {0x4A, 0x79, 0x40},
    /* 0xE2 */ {0x4B, 0x79, 0x60},
    /* 0xE2 */ {0x4C, 0x79, 0x57},
    /* 0xE2 */ {0x4D, 0x79, 0x5F},
    /* 0xE2 */ {0x4E, 0x79, 0x5A},
    /* 0xE2 */ {0x4F, 0x79, 0x55},
    /* 0xE2 */ {0x50, 0x79, 0x53},
    /* 0xE2 */ {0x51, 0x79, 0x7A},
    /* 0xE2 */ {0x52, 0x79, 0x7F},
    /* 0xE2 */ {0x53, 0x79, 0x8A},
    /* 0xE2 */ {0x54, 0x79, 0x9D},
    /* 0xE2 */ {0x55, 0x79, 0xA7},
    /* 0xE2 */ {0x56, 0x9F, 0x4B},
    /* 0xE2 */ {0x57, 0x79, 0xAA},
    /* 0xE2 */ {0x58, 0x79, 0xAE},
    /* 0xE2 */ {0x59, 0x79, 0xB3},
    /* 0xE2 */ {0x5A, 0x79, 0xB9},
    /* 0xE2 */ {0x5B, 0x79, 0xBA},
    /* 0xE2 */ {0x5C, 0x79, 0xC9},
    /* 0xE2 */ {0x5D, 0x79, 0xD5},
    /* 0xE2 */ {0x5E, 0x79, 0xE7},
    /* 0xE2 */ {0x5F, 0x79, 0xEC},
    /* 0xE2 */ {0x60, 0x79, 0xE1},
    /* 0xE2 */ {0x61, 0x79, 0xE3},
    /* 0xE2 */ {0x62, 0x7A, 0x08},
    /* 0xE2 */ {0x63, 0x7A, 0x0D},
    /* 0xE2 */ {0x64, 0x7A, 0x18},
    /* 0xE2 */ {0x65, 0x7A, 0x19},
    /* 0xE2 */ {0x66, 0x7A, 0x20},
    /* 0xE2 */ {0x67, 0x7A, 0x1F},
    /* 0xE2 */ {0x68, 0x79, 0x80},
    /* 0xE2 */ {0x69, 0x7A, 0x31},
    /* 0xE2 */ {0x6A, 0x7A, 0x3B},
    /* 0xE2 */ {0x6B, 0x7A, 0x3E},
    /* 0xE2 */ {0x6C, 0x7A, 0x37},
    /* 0xE2 */ {0x6D, 0x7A, 0x43},
    /* 0xE2 */ {0x6E, 0x7A, 0x57},
    /* 0xE2 */ {0x6F, 0x7A, 0x49},
    /* 0xE2 */ {0x70, 0x7A, 0x61},
    /* 0xE2 */ {0x71, 0x7A, 0x62},
    /* 0xE2 */ {0x72, 0x7A, 0x69},
    /* 0xE2 */ {0x73, 0x9F, 0x9D},
    /* 0xE2 */ {0x74, 0x7A, 0x70},
    /* 0xE2 */ {0x75, 0x7A, 0x79},
    /* 0xE2 */ {0x76, 0x7A, 0x7D},
    /* 0xE2 */ {0x77, 0x7A, 0x88},
    /* 0xE2 */ {0x78, 0x7A, 0x97},
    /* 0xE2 */ {0x79, 0x7A, 0x95},
    /* 0xE2 */ {0x7A, 0x7A, 0x98},
    /* 0xE2 */ {0x7B, 0x7A, 0x96},
    /* 0xE2 */ {0x7C, 0x7A, 0xA9},
    /* 0xE2 */ {0x7D, 0x7A, 0xC8},
    /* 0xE2 */ {0x7E, 0x7A, 0xB0},
    /* 0xE2 */ {0x80, 0x7A, 0xB6},
    /* 0xE2 */ {0x81, 0x7A, 0xC5},
    /* 0xE2 */ {0x82, 0x7A, 0xC4},
    /* 0xE2 */ {0x83, 0x7A, 0xBF},
    /* 0xE2 */ {0x84, 0x90, 0x83},
    /* 0xE2 */ {0x85, 0x7A, 0xC7},
    /* 0xE2 */ {0x86, 0x7A, 0xCA},
    /* 0xE2 */ {0x87, 0x7A, 0xCD},
    /* 0xE2 */ {0x88, 0x7A, 0xCF},
    /* 0xE2 */ {0x89, 0x7A, 0xD5},
    /* 0xE2 */ {0x8A, 0x7A, 0xD3},
    /* 0xE2 */ {0x8B, 0x7A, 0xD9},
    /* 0xE2 */ {0x8C, 0x7A, 0xDA},
    /* 0xE2 */ {0x8D, 0x7A, 0xDD},
    /* 0xE2 */ {0x8E, 0x7A, 0xE1},
    /* 0xE2 */ {0x8F, 0x7A, 0xE2},
    /* 0xE2 */ {0x90, 0x7A, 0xE6},
    /* 0xE2 */ {0x91, 0x7A, 0xED},
    /* 0xE2 */ {0x92, 0x7A, 0xF0},
    /* 0xE2 */ {0x93, 0x7B, 0x02},
    /* 0xE2 */ {0x94, 0x7B, 0x0F},
    /* 0xE2 */ {0x95, 0x7B, 0x0A},
    /* 0xE2 */ {0x96, 0x7B, 0x06},
    /* 0xE2 */ {0x97, 0x7B, 0x33},
    /* 0xE2 */ {0x98, 0x7B, 0x18},
    /* 0xE2 */ {0x99, 0x7B, 0x19},
    /* 0xE2 */ {0x9A, 0x7B, 0x1E},
    /* 0xE2 */ {0x9B, 0x7B, 0x35},
    /* 0xE2 */ {0x9C, 0x7B, 0x28},
    /* 0xE2 */ {0x9D, 0x7B, 0x36},
    /* 0xE2 */ {0x9E, 0x7B, 0x50},
    /* 0xE2 */ {0x9F, 0x7B, 0x7A},
    /* 0xE2 */ {0xA0, 0x7B, 0x04},
    /* 0xE2 */ {0xA1, 0x7B, 0x4D},
    /* 0xE2 */ {0xA2, 0x7B, 0x0B},
    /* 0xE2 */ {0xA3, 0x7B, 0x4C},
    /* 0xE2 */ {0xA4, 0x7B, 0x45},
    /* 0xE2 */ {0xA5, 0x7B, 0x75},
    /* 0xE2 */ {0xA6, 0x7B, 0x65},
    /* 0xE2 */ {0xA7, 0x7B, 0x74},
    /* 0xE2 */ {0xA8, 0x7B, 0x67},
    /* 0xE2 */ {0xA9, 0x7B, 0x70},
    /* 0xE2 */ {0xAA, 0x7B, 0x71},
    /* 0xE2 */ {0xAB, 0x7B, 0x6C},
    /* 0xE2 */ {0xAC, 0x7B, 0x6E},
    /* 0xE2 */ {0xAD, 0x7B, 0x9D},
    /* 0xE2 */ {0xAE, 0x7B, 0x98},
    /* 0xE2 */ {0xAF, 0x7B, 0x9F},
    /* 0xE2 */ {0xB0, 0x7B, 0x8D},
    /* 0xE2 */ {0xB1, 0x7B, 0x9C},
    /* 0xE2 */ {0xB2, 0x7B, 0x9A},
    /* 0xE2 */ {0xB3, 0x7B, 0x8B},
    /* 0xE2 */ {0xB4, 0x7B, 0x92},
    /* 0xE2 */ {0xB5, 0x7B, 0x8F},
    /* 0xE2 */ {0xB6, 0x7B, 0x5D},
    /* 0xE2 */ {0xB7, 0x7B, 0x99},
    /* 0xE2 */ {0xB8, 0x7B, 0xCB},
    /* 0xE2 */ {0xB9, 0x7B, 0xC1},
    /* 0xE2 */ {0xBA, 0x7B, 0xCC},
    /* 0xE2 */ {0xBB, 0x7B, 0xCF},
    /* 0xE2 */ {0xBC, 0x7B, 0xB4},
    /* 0xE2 */ {0xBD, 0x7B, 0xC6},
    /* 0xE2 */ {0xBE, 0x7B, 0xDD},
    /* 0xE2 */ {0xBF, 0x7B, 0xE9},
    /* 0xE2 */ {0xC0, 0x7C, 0x11},
    /* 0xE2 */ {0xC1, 0x7C, 0x14},
    /* 0xE2 */ {0xC2, 0x7B, 0xE6},
    /* 0xE2 */ {0xC3, 0x7B, 0xE5},
    /* 0xE2 */ {0xC4, 0x7C, 0x60},
    /* 0xE2 */ {0xC5, 0x7C, 0x00},
    /* 0xE2 */ {0xC6, 0x7C, 0x07},
    /* 0xE2 */ {0xC7, 0x7C, 0x13},
    /* 0xE2 */ {0xC8, 0x7B, 0xF3},
    /* 0xE2 */ {0xC9, 0x7B, 0xF7},
    /* 0xE2 */ {0xCA, 0x7C, 0x17},
    /* 0xE2 */ {0xCB, 0x7C, 0x0D},
    /* 0xE2 */ {0xCC, 0x7B, 0xF6},
    /* 0xE2 */ {0xCD, 0x7C, 0x23},
    /* 0xE2 */ {0xCE, 0x7C, 0x27},
    /* 0xE2 */ {0xCF, 0x7C, 0x2A},
    /* 0xE2 */ {0xD0, 0x7C, 0x1F},
    /* 0xE2 */ {0xD1, 0x7C, 0x37},
    /* 0xE2 */ {0xD2, 0x7C, 0x2B},
    /* 0xE2 */ {0xD3, 0x7C, 0x3D},
    /* 0xE2 */ {0xD4, 0x7C, 0x4C},
    /* 0xE2 */ {0xD5, 0x7C, 0x43},
    /* 0xE2 */ {0xD6, 0x7C, 0x54},
    /* 0xE2 */ {0xD7, 0x7C, 0x4F},
    /* 0xE2 */ {0xD8, 0x7C, 0x40},
    /* 0xE2 */ {0xD9, 0x7C, 0x50},
    /* 0xE2 */ {0xDA, 0x7C, 0x58},
    /* 0xE2 */ {0xDB, 0x7C, 0x5F},
    /* 0xE2 */ {0xDC, 0x7C, 0x64},
    /* 0xE2 */ {0xDD, 0x7C, 0x56},
    /* 0xE2 */ {0xDE, 0x7C, 0x65},
    /* 0xE2 */ {0xDF, 0x7C, 0x6C},
    /* 0xE2 */ {0xE0, 0x7C, 0x75},
    /* 0xE2 */ {0xE1, 0x7C, 0x83},
    /* 0xE2 */ {0xE2, 0x7C, 0x90},
    /* 0xE2 */ {0xE3, 0x7C, 0xA4},
    /* 0xE2 */ {0xE4, 0x7C, 0xAD},
    /* 0xE2 */ {0xE5, 0x7C, 0xA2},
    /* 0xE2 */ {0xE6, 0x7C, 0xAB},
    /* 0xE2 */ {0xE7, 0x7C, 0xA1},
    /* 0xE2 */ {0xE8, 0x7C, 0xA8},
    /* 0xE2 */ {0xE9, 0x7C, 0xB3},
    /* 0xE2 */ {0xEA, 0x7C, 0xB2},
    /* 0xE2 */ {0xEB, 0x7C, 0xB1},
    /* 0xE2 */ {0xEC, 0x7C, 0xAE},
    /* 0xE2 */ {0xED, 0x7C, 0xB9},
    /* 0xE2 */ {0xEE, 0x7C, 0xBD},
    /* 0xE2 */ {0xEF, 0x7C, 0xC0},
    /* 0xE2 */ {0xF0, 0x7C, 0xC5},
    /* 0xE2 */ {0xF1, 0x7C, 0xC2},
    /* 0xE2 */ {0xF2, 0x7C, 0xD8},
    /* 0xE2 */ {0xF3, 0x7C, 0xD2},
    /* 0xE2 */ {0xF4, 0x7C, 0xDC},
    /* 0xE2 */ {0xF5, 0x7C, 0xE2},
    /* 0xE2 */ {0xF6, 0x9B, 0x3B},
    /* 0xE2 */ {0xF7, 0x7C, 0xEF},
    /* 0xE2 */ {0xF8, 0x7C, 0xF2},
    /* 0xE2 */ {0xF9, 0x7C, 0xF4},
    /* 0xE2 */ {0xFA, 0x7C, 0xF6},
    /* 0xE2 */ {0xFB, 0x7C, 0xFA},
    /* 0xE2 */ {0xFC, 0x7D, 0x06},
    /* 0xE3 */ {0x40, 0x7D, 0x02},
    /* 0xE3 */ {0x41, 0x7D, 0x1C},
    /* 0xE3 */ {0x42, 0x7D, 0x15},
    /* 0xE3 */ {0x43, 0x7D, 0x0A},
    /* 0xE3 */ {0x44, 0x7D, 0x45},
    /* 0xE3 */ {0x45, 0x7D, 0x4B},
    /* 0xE3 */ {0x46, 0x7D, 0x2E},
    /* 0xE3 */ {0x47, 0x7D, 0x32},
    /* 0xE3 */ {0x48, 0x7D, 0x3F},
    /* 0xE3 */ {0x49, 0x7D, 0x35},
    /* 0xE3 */ {0x4A, 0x7D, 0x46},
    /* 0xE3 */ {0x4B, 0x7D, 0x73},
    /* 0xE3 */ {0x4C, 0x7D, 0x56},
    /* 0xE3 */ {0x4D, 0x7D, 0x4E},
    /* 0xE3 */ {0x4E, 0x7D, 0x72},
    /* 0xE3 */ {0x4F, 0x7D, 0x68},
    /* 0xE3 */ {0x50, 0x7D, 0x6E},
    /* 0xE3 */ {0x51, 0x7D, 0x4F},
    /* 0xE3 */ {0x52, 0x7D, 0x63},
    /* 0xE3 */ {0x53, 0x7D, 0x93},
    /* 0xE3 */ {0x54, 0x7D, 0x89},
    /* 0xE3 */ {0x55, 0x7D, 0x5B},
    /* 0xE3 */ {0x56, 0x7D, 0x8F},
    /* 0xE3 */ {0x57, 0x7D, 0x7D},
    /* 0xE3 */ {0x58, 0x7D, 0x9B},
    /* 0xE3 */ {0x59, 0x7D, 0xBA},
    /* 0xE3 */ {0x5A, 0x7D, 0xAE},
    /* 0xE3 */ {0x5B, 0x7D, 0xA3},
    /* 0xE3 */ {0x5C, 0x7D, 0xB5},
    /* 0xE3 */ {0x5D, 0x7D, 0xC7},
    /* 0xE3 */ {0x5E, 0x7D, 0xBD},
    /* 0xE3 */ {0x5F, 0x7D, 0xAB},
    /* 0xE3 */ {0x60, 0x7E, 0x3D},
    /* 0xE3 */ {0x61, 0x7D, 0xA2},
    /* 0xE3 */ {0x62, 0x7D, 0xAF},
    /* 0xE3 */ {0x63, 0x7D, 0xDC},
    /* 0xE3 */ {0x64, 0x7D, 0xB8},
    /* 0xE3 */ {0x65, 0x7D, 0x9F},
    /* 0xE3 */ {0x66, 0x7D, 0xB0},
    /* 0xE3 */ {0x67, 0x7D, 0xD8},
    /* 0xE3 */ {0x68, 0x7D, 0xDD},
    /* 0xE3 */ {0x69, 0x7D, 0xE4},
    /* 0xE3 */ {0x6A, 0x7D, 0xDE},
    /* 0xE3 */ {0x6B, 0x7D, 0xFB},
    /* 0xE3 */ {0x6C, 0x7D, 0xF2},
    /* 0xE3 */ {0x6D, 0x7D, 0xE1},
    /* 0xE3 */ {0x6E, 0x7E, 0x05},
    /* 0xE3 */ {0x6F, 0x7E, 0x0A},
    /* 0xE3 */ {0x70, 0x7E, 0x23},
    /* 0xE3 */ {0x71, 0x7E, 0x21},
    /* 0xE3 */ {0x72, 0x7E, 0x12},
    /* 0xE3 */ {0x73, 0x7E, 0x31},
    /* 0xE3 */ {0x74, 0x7E, 0x1F},
    /* 0xE3 */ {0x75, 0x7E, 0x09},
    /* 0xE3 */ {0x76, 0x7E, 0x0B},
    /* 0xE3 */ {0x77, 0x7E, 0x22},
    /* 0xE3 */ {0x78, 0x7E, 0x46},
    /* 0xE3 */ {0x79, 0x7E, 0x66},
    /* 0xE3 */ {0x7A, 0x7E, 0x3B},
    /* 0xE3 */ {0x7B, 0x7E, 0x35},
    /* 0xE3 */ {0x7C, 0x7E, 0x39},
    /* 0xE3 */ {0x7D, 0x7E, 0x43},
    /* 0xE3 */ {0x7E, 0x7E, 0x37},
    /* 0xE3 */ {0x80, 0x7E, 0x32},
    /* 0xE3 */ {0x81, 0x7E, 0x3A},
    /* 0xE3 */ {0x82, 0x7E, 0x67},
    /* 0xE3 */ {0x83, 0x7E, 0x5D},
    /* 0xE3 */ {0x84, 0x7E, 0x56},
    /* 0xE3 */ {0x85, 0x7E, 0x5E},
    /* 0xE3 */ {0x86, 0x7E, 0x59},
    /* 0xE3 */ {0x87, 0x7E, 0x5A},
    /* 0xE3 */ {0x88, 0x7E, 0x79},
    /* 0xE3 */ {0x89, 0x7E, 0x6A},
    /* 0xE3 */ {0x8A, 0x7E, 0x69},
    /* 0xE3 */ {0x8B, 0x7E, 0x7C},
    /* 0xE3 */ {0x8C, 0x7E, 0x7B},
    /* 0xE3 */ {0x8D, 0x7E, 0x83},
    /* 0xE3 */ {0x8E, 0x7D, 0xD5},
    /* 0xE3 */ {0x8F, 0x7E, 0x7D},
    /* 0xE3 */ {0x90, 0x8F, 0xAE},
    /* 0xE3 */ {0x91, 0x7E, 0x7F},
    /* 0xE3 */ {0x92, 0x7E, 0x88},
    /* 0xE3 */ {0x93, 0x7E, 0x89},
    /* 0xE3 */ {0x94, 0x7E, 0x8C},
    /* 0xE3 */ {0x95, 0x7E, 0x92},
    /* 0xE3 */ {0x96, 0x7E, 0x90},
    /* 0xE3 */ {0x97, 0x7E, 0x93},
    /* 0xE3 */ {0x98, 0x7E, 0x94},
    /* 0xE3 */ {0x99, 0x7E, 0x96},
    /* 0xE3 */ {0x9A, 0x7E, 0x8E},
    /* 0xE3 */ {0x9B, 0x7E, 0x9B},
    /* 0xE3 */ {0x9C, 0x7E, 0x9C},
    /* 0xE3 */ {0x9D, 0x7F, 0x38},
    /* 0xE3 */ {0x9E, 0x7F, 0x3A},
    /* 0xE3 */ {0x9F, 0x7F, 0x45},
    /* 0xE3 */ {0xA0, 0x7F, 0x4C},
    /* 0xE3 */ {0xA1, 0x7F, 0x4D},
    /* 0xE3 */ {0xA2, 0x7F, 0x4E},
    /* 0xE3 */ {0xA3, 0x7F, 0x50},
    /* 0xE3 */ {0xA4, 0x7F, 0x51},
    /* 0xE3 */ {0xA5, 0x7F, 0x55},
    /* 0xE3 */ {0xA6, 0x7F, 0x54},
    /* 0xE3 */ {0xA7, 0x7F, 0x58},
    /* 0xE3 */ {0xA8, 0x7F, 0x5F},
    /* 0xE3 */ {0xA9, 0x7F, 0x60},
    /* 0xE3 */ {0xAA, 0x7F, 0x68},
    /* 0xE3 */ {0xAB, 0x7F, 0x69},
    /* 0xE3 */ {0xAC, 0x7F, 0x67},
    /* 0xE3 */ {0xAD, 0x7F, 0x78},
    /* 0xE3 */ {0xAE, 0x7F, 0x82},
    /* 0xE3 */ {0xAF, 0x7F, 0x86},
    /* 0xE3 */ {0xB0, 0x7F, 0x83},
    /* 0xE3 */ {0xB1, 0x7F, 0x88},
    /* 0xE3 */ {0xB2, 0x7F, 0x87},
    /* 0xE3 */ {0xB3, 0x7F, 0x8C},
    /* 0xE3 */ {0xB4, 0x7F, 0x94},
    /* 0xE3 */ {0xB5, 0x7F, 0x9E},
    /* 0xE3 */ {0xB6, 0x7F, 0x9D},
    /* 0xE3 */ {0xB7, 0x7F, 0x9A},
    /* 0xE3 */ {0xB8, 0x7F, 0xA3},
    /* 0xE3 */ {0xB9, 0x7F, 0xAF},
    /* 0xE3 */ {0xBA, 0x7F, 0xB2},
    /* 0xE3 */ {0xBB, 0x7F, 0xB9},
    /* 0xE3 */ {0xBC, 0x7F, 0xAE},
    /* 0xE3 */ {0xBD, 0x7F, 0xB6},
    /* 0xE3 */ {0xBE, 0x7F, 0xB8},
    /* 0xE3 */ {0xBF, 0x8B, 0x71},
    /* 0xE3 */ {0xC0, 0x7F, 0xC5},
    /* 0xE3 */ {0xC1, 0x7F, 0xC6},
    /* 0xE3 */ {0xC2, 0x7F, 0xCA},
    /* 0xE3 */ {0xC3, 0x7F, 0xD5},
    /* 0xE3 */ {0xC4, 0x7F, 0xD4},
    /* 0xE3 */ {0xC5, 0x7F, 0xE1},
    /* 0xE3 */ {0xC6, 0x7F, 0xE6},
    /* 0xE3 */ {0xC7, 0x7F, 0xE9},
    /* 0xE3 */ {0xC8, 0x7F, 0xF3},
    /* 0xE3 */ {0xC9, 0x7F, 0xF9},
    /* 0xE3 */ {0xCA, 0x98, 0xDC},
    /* 0xE3 */ {0xCB, 0x80, 0x06},
    /* 0xE3 */ {0xCC, 0x80, 0x04},
    /* 0xE3 */ {0xCD, 0x80, 0x0B},
    /* 0xE3 */ {0xCE, 0x80, 0x12},
    /* 0xE3 */ {0xCF, 0x80, 0x18},
    /* 0xE3 */ {0xD0, 0x80, 0x19},
    /* 0xE3 */ {0xD1, 0x80, 0x1C},
    /* 0xE3 */ {0xD2, 0x80, 0x21},
    /* 0xE3 */ {0xD3, 0x80, 0x28},
    /* 0xE3 */ {0xD4, 0x80, 0x3F},
    /* 0xE3 */ {0xD5, 0x80, 0x3B},
    /* 0xE3 */ {0xD6, 0x80, 0x4A},
    /* 0xE3 */ {0xD7, 0x80, 0x46},
    /* 0xE3 */ {0xD8, 0x80, 0x52},
    /* 0xE3 */ {0xD9, 0x80, 0x58},
    /* 0xE3 */ {0xDA, 0x80, 0x5A},
    /* 0xE3 */ {0xDB, 0x80, 0x5F},
    /* 0xE3 */ {0xDC, 0x80, 0x62},
    /* 0xE3 */ {0xDD, 0x80, 0x68},
    /* 0xE3 */ {0xDE, 0x80, 0x73},
    /* 0xE3 */ {0xDF, 0x80, 0x72},
    /* 0xE3 */ {0xE0, 0x80, 0x70},
    /* 0xE3 */ {0xE1, 0x80, 0x76},
    /* 0xE3 */ {0xE2, 0x80, 0x79},
    /* 0xE3 */ {0xE3, 0x80, 0x7D},
    /* 0xE3 */ {0xE4, 0x80, 0x7F},
    /* 0xE3 */ {0xE5, 0x80, 0x84},
    /* 0xE3 */ {0xE6, 0x80, 0x86},
    /* 0xE3 */ {0xE7, 0x80, 0x85},
    /* 0xE3 */ {0xE8, 0x80, 0x9B},
    /* 0xE3 */ {0xE9, 0x80, 0x93},
    /* 0xE3 */ {0xEA, 0x80, 0x9A},
    /* 0xE3 */ {0xEB, 0x80, 0xAD},
    /* 0xE3 */ {0xEC, 0x51, 0x90},
    /* 0xE3 */ {0xED, 0x80, 0xAC},
    /* 0xE3 */ {0xEE, 0x80, 0xDB},
    /* 0xE3 */ {0xEF, 0x80, 0xE5},
    /* 0xE3 */ {0xF0, 0x80, 0xD9},
    /* 0xE3 */ {0xF1, 0x80, 0xDD},
    /* 0xE3 */ {0xF2, 0x80, 0xC4},
    /* 0xE3 */ {0xF3, 0x80, 0xDA},
    /* 0xE3 */ {0xF4, 0x80, 0xD6},
    /* 0xE3 */ {0xF5, 0x81, 0x09},
    /* 0xE3 */ {0xF6, 0x80, 0xEF},
    /* 0xE3 */ {0xF7, 0x80, 0xF1},
    /* 0xE3 */ {0xF8, 0x81, 0x1B},
    /* 0xE3 */ {0xF9, 0x81, 0x29},
    /* 0xE3 */ {0xFA, 0x81, 0x23},
    /* 0xE3 */ {0xFB, 0x81, 0x2F},
    /* 0xE3 */ {0xFC, 0x81, 0x4B},
    /* 0xE4 */ {0x40, 0x96, 0x8B},
    /* 0xE4 */ {0x41, 0x81, 0x46},
    /* 0xE4 */ {0x42, 0x81, 0x3E},
    /* 0xE4 */ {0x43, 0x81, 0x53},
    /* 0xE4 */ {0x44, 0x81, 0x51},
    /* 0xE4 */ {0x45, 0x80, 0xFC},
    /* 0xE4 */ {0x46, 0x81, 0x71},
    /* 0xE4 */ {0x47, 0x81, 0x6E},
    /* 0xE4 */ {0x48, 0x81, 0x65},
    /* 0xE4 */ {0x49, 0x81, 0x66},
    /* 0xE4 */ {0x4A, 0x81, 0x74},
    /* 0xE4 */ {0x4B, 0x81, 0x83},
    /* 0xE4 */ {0x4C, 0x81, 0x88},
    /* 0xE4 */ {0x4D, 0x81, 0x8A},
    /* 0xE4 */ {0x4E, 0x81, 0x80},
    /* 0xE4 */ {0x4F, 0x81, 0x82},
    /* 0xE4 */ {0x50, 0x81, 0xA0},
    /* 0xE4 */ {0x51, 0x81, 0x95},
    /* 0xE4 */ {0x52, 0x81, 0xA4},
    /* 0xE4 */ {0x53, 0x81, 0xA3},
    /* 0xE4 */ {0x54, 0x81, 0x5F},
    /* 0xE4 */ {0x55, 0x81, 0x93},
    /* 0xE4 */ {0x56, 0x81, 0xA9},
    /* 0xE4 */ {0x57, 0x81, 0xB0},
    /* 0xE4 */ {0x58, 0x81, 0xB5},
    /* 0xE4 */ {0x59, 0x81, 0xBE},
    /* 0xE4 */ {0x5A, 0x81, 0xB8},
    /* 0xE4 */ {0x5B, 0x81, 0xBD},
    /* 0xE4 */ {0x5C, 0x81, 0xC0},
    /* 0xE4 */ {0x5D, 0x81, 0xC2},
    /* 0xE4 */ {0x5E, 0x81, 0xBA},
    /* 0xE4 */ {0x5F, 0x81, 0xC9},
    /* 0xE4 */ {0x60, 0x81, 0xCD},
    /* 0xE4 */ {0x61, 0x81, 0xD1},
    /* 0xE4 */ {0x62, 0x81, 0xD9},
    /* 0xE4 */ {0x63, 0x81, 0xD8},
    /* 0xE4 */ {0x64, 0x81, 0xC8},
    /* 0xE4 */ {0x65, 0x81, 0xDA},
    /* 0xE4 */ {0x66, 0x81, 0xDF},
    /* 0xE4 */ {0x67, 0x81, 0xE0},
    /* 0xE4 */ {0x68, 0x81, 0xE7},
    /* 0xE4 */ {0x69, 0x81, 0xFA},
    /* 0xE4 */ {0x6A, 0x81, 0xFB},
    /* 0xE4 */ {0x6B, 0x81, 0xFE},
    /* 0xE4 */ {0x6C, 0x82, 0x01},
    /* 0xE4 */ {0x6D, 0x82, 0x02},
    /* 0xE4 */ {0x6E, 0x82, 0x05},
    /* 0xE4 */ {0x6F, 0x82, 0x07},
    /* 0xE4 */ {0x70, 0x82, 0x0A},
    /* 0xE4 */ {0x71, 0x82, 0x0D},
    /* 0xE4 */ {0x72, 0x82, 0x10},
    /* 0xE4 */ {0x73, 0x82, 0x16},
    /* 0xE4 */ {0x74, 0x82, 0x29},
    /* 0xE4 */ {0x75, 0x82, 0x2B},
    /* 0xE4 */ {0x76, 0x82, 0x38},
    /* 0xE4 */ {0x77, 0x82, 0x33},
    /* 0xE4 */ {0x78, 0x82, 0x40},
    /* 0xE4 */ {0x79, 0x82, 0x59},
    /* 0xE4 */ {0x7A, 0x82, 0x58},
    /* 0xE4 */ {0x7B, 0x82, 0x5D},
    /* 0xE4 */ {0x7C, 0x82, 0x5A},
    /* 0xE4 */ {0x7D, 0x82, 0x5F},
    /* 0xE4 */ {0x7E, 0x82, 0x64},
    /* 0xE4 */ {0x80, 0x82, 0x62},
    /* 0xE4 */ {0x81, 0x82, 0x68},
    /* 0xE4 */ {0x82, 0x82, 0x6A},
    /* 0xE4 */ {0x83, 0x82, 0x6B},
    /* 0xE4 */ {0x84, 0x82, 0x2E},
    /* 0xE4 */ {0x85, 0x82, 0x71},
    /* 0xE4 */ {0x86, 0x82, 0x77},
    /* 0xE4 */ {0x87, 0x82, 0x78},
    /* 0xE4 */ {0x88, 0x82, 0x7E},
    /* 0xE4 */ {0x89, 0x82, 0x8D},
    /* 0xE4 */ {0x8A, 0x82, 0x92},
    /* 0xE4 */ {0x8B, 0x82, 0xAB},
    /* 0xE4 */ {0x8C, 0x82, 0x9F},
    /* 0xE4 */ {0x8D, 0x82, 0xBB},
    /* 0xE4 */ {0x8E, 0x82, 0xAC},
    /* 0xE4 */ {0x8F, 0x82, 0xE1},
    /* 0xE4 */ {0x90, 0x82, 0xE3},
    /* 0xE4 */ {0x91, 0x82, 0xDF},
    /* 0xE4 */ {0x92, 0x82, 0xD2},
    /* 0xE4 */ {0x93, 0x82, 0xF4},
    /* 0xE4 */ {0x94, 0x82, 0xF3},
    /* 0xE4 */ {0x95, 0x82, 0xFA},
    /* 0xE4 */ {0x96, 0x83, 0x93},
    /* 0xE4 */ {0x97, 0x83, 0x03},
    /* 0xE4 */ {0x98, 0x82, 0xFB},
    /* 0xE4 */ {0x99, 0x82, 0xF9},
    /* 0xE4 */ {0x9A, 0x82, 0xDE},
    /* 0xE4 */ {0x9B, 0x83, 0x06},
    /* 0xE4 */ {0x9C, 0x82, 0xDC},
    /* 0xE4 */ {0x9D, 0x83, 0x09},
    /* 0xE4 */ {0x9E, 0x82, 0xD9},
    /* 0xE4 */ {0x9F, 0x83, 0x35},
    /* 0xE4 */ {0xA0, 0x83, 0x34},
    /* 0xE4 */ {0xA1, 0x83, 0x16},
    /* 0xE4 */ {0xA2, 0x83, 0x32},
    /* 0xE4 */ {0xA3, 0x83, 0x31},
    /* 0xE4 */ {0xA4, 0x83, 0x40},
    /* 0xE4 */ {0xA5, 0x83, 0x39},
    /* 0xE4 */ {0xA6, 0x83, 0x50},
    /* 0xE4 */ {0xA7, 0x83, 0x45},
    /* 0xE4 */ {0xA8, 0x83, 0x2F},
    /* 0xE4 */ {0xA9, 0x83, 0x2B},
    /* 0xE4 */ {0xAA, 0x83, 0x17},
    /* 0xE4 */ {0xAB, 0x83, 0x18},
    /* 0xE4 */ {0xAC, 0x83, 0x85},
    /* 0xE4 */ {0xAD, 0x83, 0x9A},
    /* 0xE4 */ {0xAE, 0x83, 0xAA},
    /* 0xE4 */ {0xAF, 0x83, 0x9F},
    /* 0xE4 */ {0xB0, 0x83, 0xA2},
    /* 0xE4 */ {0xB1, 0x83, 0x96},
    /* 0xE4 */ {0xB2, 0x83, 0x23},
    /* 0xE4 */ {0xB3, 0x83, 0x8E},
    /* 0xE4 */ {0xB4, 0x83, 0x87},
    /* 0xE4 */ {0xB5, 0x83, 0x8A},
    /* 0xE4 */ {0xB6, 0x83, 0x7C},
    /* 0xE4 */ {0xB7, 0x83, 0xB5},
    /* 0xE4 */ {0xB8, 0x83, 0x73},
    /* 0xE4 */ {0xB9, 0x83, 0x75},
    /* 0xE4 */ {0xBA, 0x83, 0xA0},
    /* 0xE4 */ {0xBB, 0x83, 0x89},
    /* 0xE4 */ {0xBC, 0x83, 0xA8},
    /* 0xE4 */ {0xBD, 0x83, 0xF4},
    /* 0xE4 */ {0xBE, 0x84, 0x13},
    /* 0xE4 */ {0xBF, 0x83, 0xEB},
    /* 0xE4 */ {0xC0, 0x83, 0xCE},
    /* 0xE4 */ {0xC1, 0x83, 0xFD},
    /* 0xE4 */ {0xC2, 0x84, 0x03},
    /* 0xE4 */ {0xC3, 0x83, 0xD8},
    /* 0xE4 */ {0xC4, 0x84, 0x0B},
    /* 0xE4 */ {0xC5, 0x83, 0xC1},
    /* 0xE4 */ {0xC6, 0x83, 0xF7},
    /* 0xE4 */ {0xC7, 0x84, 0x07},
    /* 0xE4 */ {0xC8, 0x83, 0xE0},
    /* 0xE4 */ {0xC9, 0x83, 0xF2},
    /* 0xE4 */ {0xCA, 0x84, 0x0D},
    /* 0xE4 */ {0xCB, 0x84, 0x22},
    /* 0xE4 */ {0xCC, 0x84, 0x20},
    /* 0xE4 */ {0xCD, 0x83, 0xBD},
    /* 0xE4 */ {0xCE, 0x84, 0x38},
    /* 0xE4 */ {0xCF, 0x85, 0x06},
    /* 0xE4 */ {0xD0, 0x83, 0xFB},
    /* 0xE4 */ {0xD1, 0x84, 0x6D},
    /* 0xE4 */ {0xD2, 0x84, 0x2A},
    /* 0xE4 */ {0xD3, 0x84, 0x3C},
    /* 0xE4 */ {0xD4, 0x85, 0x5A},
    /* 0xE4 */ {0xD5, 0x84, 0x84},
    /* 0xE4 */ {0xD6, 0x84, 0x77},
    /* 0xE4 */ {0xD7, 0x84, 0x6B},
    /* 0xE4 */ {0xD8, 0x84, 0xAD},
    /* 0xE4 */ {0xD9, 0x84, 0x6E},
    /* 0xE4 */ {0xDA, 0x84, 0x82},
    /* 0xE4 */ {0xDB, 0x84, 0x69},
    /* 0xE4 */ {0xDC, 0x84, 0x46},
    /* 0xE4 */ {0xDD, 0x84, 0x2C},
    /* 0xE4 */ {0xDE, 0x84, 0x6F},
    /* 0xE4 */ {0xDF, 0x84, 0x79},
    /* 0xE4 */ {0xE0, 0x84, 0x35},
    /* 0xE4 */ {0xE1, 0x84, 0xCA},
    /* 0xE4 */ {0xE2, 0x84, 0x62},
    /* 0xE4 */ {0xE3, 0x84, 0xB9},
    /* 0xE4 */ {0xE4, 0x84, 0xBF},
    /* 0xE4 */ {0xE5, 0x84, 0x9F},
    /* 0xE4 */ {0xE6, 0x84, 0xD9},
    /* 0xE4 */ {0xE7, 0x84, 0xCD},
    /* 0xE4 */ {0xE8, 0x84, 0xBB},
    /* 0xE4 */ {0xE9, 0x84, 0xDA},
    /* 0xE4 */ {0xEA, 0x84, 0xD0},
    /* 0xE4 */ {0xEB, 0x84, 0xC1},
    /* 0xE4 */ {0xEC, 0x84, 0xC6},
    /* 0xE4 */ {0xED, 0x84, 0xD6},
    /* 0xE4 */ {0xEE, 0x84, 0xA1},
    /* 0xE4 */ {0xEF, 0x85, 0x21},
    /* 0xE4 */ {0xF0, 0x84, 0xFF},
    /* 0xE4 */ {0xF1, 0x84, 0xF4},
    /* 0xE4 */ {0xF2, 0x85, 0x17},
    /* 0xE4 */ {0xF3, 0x85, 0x18},
    /* 0xE4 */ {0xF4, 0x85, 0x2C},
    /* 0xE4 */ {0xF5, 0x85, 0x1F},
    /* 0xE4 */ {0xF6, 0x85, 0x15},
    /* 0xE4 */ {0xF7, 0x85, 0x14},
    /* 0xE4 */ {0xF8, 0x84, 0xFC},
    /* 0xE4 */ {0xF9, 0x85, 0x40},
    /* 0xE4 */ {0xFA, 0x85, 0x63},
    /* 0xE4 */ {0xFB, 0x85, 0x58},
    /* 0xE4 */ {0xFC, 0x85, 0x48},
    /* 0xE5 */ {0x40, 0x85, 0x41},
    /* 0xE5 */ {0x41, 0x86, 0x02},
    /* 0xE5 */ {0x42, 0x85, 0x4B},
    /* 0xE5 */ {0x43, 0x85, 0x55},
    /* 0xE5 */ {0x44, 0x85, 0x80},
    /* 0xE5 */ {0x45, 0x85, 0xA4},
    /* 0xE5 */ {0x46, 0x85, 0x88},
    /* 0xE5 */ {0x47, 0x85, 0x91},
    /* 0xE5 */ {0x48, 0x85, 0x8A},
    /* 0xE5 */ {0x49, 0x85, 0xA8},
    /* 0xE5 */ {0x4A, 0x85, 0x6D},
    /* 0xE5 */ {0x4B, 0x85, 0x94},
    /* 0xE5 */ {0x4C, 0x85, 0x9B},
    /* 0xE5 */ {0x4D, 0x85, 0xEA},
    /* 0xE5 */ {0x4E, 0x85, 0x87},
    /* 0xE5 */ {0x4F, 0x85, 0x9C},
    /* 0xE5 */ {0x50, 0x85, 0x77},
    /* 0xE5 */ {0x51, 0x85, 0x7E},
    /* 0xE5 */ {0x52, 0x85, 0x90},
    /* 0xE5 */ {0x53, 0x85, 0xC9},
    /* 0xE5 */ {0x54, 0x85, 0xBA},
    /* 0xE5 */ {0x55, 0x85, 0xCF},
    /* 0xE5 */ {0x56, 0x85, 0xB9},
    /* 0xE5 */ {0x57, 0x85, 0xD0},
    /* 0xE5 */ {0x58, 0x85, 0xD5},
    /* 0xE5 */ {0x59, 0x85, 0xDD},
    /* 0xE5 */ {0x5A, 0x85, 0xE5},
    /* 0xE5 */ {0x5B, 0x85, 0xDC},
    /* 0xE5 */ {0x5C, 0x85, 0xF9},
    /* 0xE5 */ {0x5D, 0x86, 0x0A},
    /* 0xE5 */ {0x5E, 0x86, 0x13},
    /* 0xE5 */ {0x5F, 0x86, 0x0B},
    /* 0xE5 */ {0x60, 0x85, 0xFE},
    /* 0xE5 */ {0x61, 0x85, 0xFA},
    /* 0xE5 */ {0x62, 0x86, 0x06},
    /* 0xE5 */ {0x63, 0x86, 0x22},
    /* 0xE5 */ {0x64, 0x86, 0x1A},
    /* 0xE5 */ {0x65, 0x86, 0x30},
    /* 0xE5 */ {0x66, 0x86, 0x3F},
    /* 0xE5 */ {0x67, 0x86, 0x4D},
    /* 0xE5 */ {0x68, 0x4E, 0x55},
    /* 0xE5 */ {0x69, 0x86, 0x54},
    /* 0xE5 */ {0x6A, 0x86, 0x5F},
    /* 0xE5 */ {0x6B, 0x86, 0x67},
    /* 0xE5 */ {0x6C, 0x86, 0x71},
    /* 0xE5 */ {0x6D, 0x86, 0x93},
    /* 0xE5 */ {0x6E, 0x86, 0xA3},
    /* 0xE5 */ {0x6F, 0x86, 0xA9},
    /* 0xE5 */ {0x70, 0x86, 0xAA},
    /* 0xE5 */ {0x71, 0x86, 0x8B},
    /* 0xE5 */ {0x72, 0x86, 0x8C},
    /* 0xE5 */ {0x73, 0x86, 0xB6},
    /* 0xE5 */ {0x74, 0x86, 0xAF},
    /* 0xE5 */ {0x75, 0x86, 0xC4},
    /* 0xE5 */ {0x76, 0x86, 0xC6},
    /* 0xE5 */ {0x77, 0x86, 0xB0},
    /* 0xE5 */ {0x78, 0x86, 0xC9},
    /* 0xE5 */ {0x79, 0x88, 0x23},
    /* 0xE5 */ {0x7A, 0x86, 0xAB},
    /* 0xE5 */ {0x7B, 0x86, 0xD4},
    /* 0xE5 */ {0x7C, 0x86, 0xDE},
    /* 0xE5 */ {0x7D, 0x86, 0xE9},
    /* 0xE5 */ {0x7E, 0x86, 0xEC},
    /* 0xE5 */ {0x80, 0x86, 0xDF},
    /* 0xE5 */ {0x81, 0x86, 0xDB},
    /* 0xE5 */ {0x82, 0x86, 0xEF},
    /* 0xE5 */ {0x83, 0x87, 0x12},
    /* 0xE5 */ {0x84, 0x87, 0x06},
    /* 0xE5 */ {0x85, 0x87, 0x08},
    /* 0xE5 */ {0x86, 0x87, 0x00},
    /* 0xE5 */ {0x87, 0x87, 0x03},
    /* 0xE5 */ {0x88, 0x86, 0xFB},
    /* 0xE5 */ {0x89, 0x87, 0x11},
    /* 0xE5 */ {0x8A, 0x87, 0x09},
    /* 0xE5 */ {0x8B, 0x87, 0x0D},
    /* 0xE5 */ {0x8C, 0x86, 0xF9},
    /* 0xE5 */ {0x8D, 0x87, 0x0A},
    /* 0xE5 */ {0x8E, 0x87, 0x34},
    /* 0xE5 */ {0x8F, 0x87, 0x3F},
    /* 0xE5 */ {0x90, 0x87, 0x37},
    /* 0xE5 */ {0x91, 0x87, 0x3B},
    /* 0xE5 */ {0x92, 0x87, 0x25},
    /* 0xE5 */ {0x93, 0x87, 0x29},
    /* 0xE5 */ {0x94, 0x87, 0x1A},
    /* 0xE5 */ {0x95, 0x87, 0x60},
    /* 0xE5 */ {0x96, 0x87, 0x5F},
    /* 0xE5 */ {0x97, 0x87, 0x78},
    /* 0xE5 */ {0x98, 0x87, 0x4C},
    /* 0xE5 */ {0x99, 0x87, 0x4E},
    /* 0xE5 */ {0x9A, 0x87, 0x74},
    /* 0xE5 */ {0x9B, 0x87, 0x57},
    /* 0xE5 */ {0x9C, 0x87, 0x68},
    /* 0xE5 */ {0x9D, 0x87, 0x6E},
    /* 0xE5 */ {0x9E, 0x87, 0x59},
    /* 0xE5 */ {0x9F, 0x87, 0x53},
    /* 0xE5 */ {0xA0, 0x87, 0x63},
    /* 0xE5 */ {0xA1, 0x87, 0x6A},
    /* 0xE5 */ {0xA2, 0x88, 0x05},
    /* 0xE5 */ {0xA3, 0x87, 0xA2},
    /* 0xE5 */ {0xA4, 0x87, 0x9F},
    /* 0xE5 */ {0xA5, 0x87, 0x82},
    /* 0xE5 */ {0xA6, 0x87, 0xAF},
    /* 0xE5 */ {0xA7, 0x87, 0xCB},
    /* 0xE5 */ {0xA8, 0x87, 0xBD},
    /* 0xE5 */ {0xA9, 0x87, 0xC0},
    /* 0xE5 */ {0xAA, 0x87, 0xD0},
    /* 0xE5 */ {0xAB, 0x96, 0xD6},
    /* 0xE5 */ {0xAC, 0x87, 0xAB},
    /* 0xE5 */ {0xAD, 0x87, 0xC4},
    /* 0xE5 */ {0xAE, 0x87, 0xB3},
    /* 0xE5 */ {0xAF, 0x87, 0xC7},
    /* 0xE5 */ {0xB0, 0x87, 0xC6},
    /* 0xE5 */ {0xB1, 0x87, 0xBB},
    /* 0xE5 */ {0xB2, 0x87, 0xEF},
    /* 0xE5 */ {0xB3, 0x87, 0xF2},
    /* 0xE5 */ {0xB4, 0x87, 0xE0},
    /* 0xE5 */ {0xB5, 0x88, 0x0F},
    /* 0xE5 */ {0xB6, 0x88, 0x0D},
    /* 0xE5 */ {0xB7, 0x87, 0xFE},
    /* 0xE5 */ {0xB8, 0x87, 0xF6},
    /* 0xE5 */ {0xB9, 0x87, 0xF7},
    /* 0xE5 */ {0xBA, 0x88, 0x0E},
    /* 0xE5 */ {0xBB, 0x87, 0xD2},
    /* 0xE5 */ {0xBC, 0x88, 0x11},
    /* 0xE5 */ {0xBD, 0x88, 0x16},
    /* 0xE5 */ {0xBE, 0x88, 0x15},
    /* 0xE5 */ {0xBF, 0x88, 0x22},
    /* 0xE5 */ {0xC0, 0x88, 0x21},
    /* 0xE5 */ {0xC1, 0x88, 0x31},
    /* 0xE5 */ {0xC2, 0x88, 0x36},
    /* 0xE5 */ {0xC3, 0x88, 0x39},
    /* 0xE5 */ {0xC4, 0x88, 0x27},
    /* 0xE5 */ {0xC5, 0x88, 0x3B},
    /* 0xE5 */ {0xC6, 0x88, 0x44},
    /* 0xE5 */ {0xC7, 0x88, 0x42},
    /* 0xE5 */ {0xC8, 0x88, 0x52},
    /* 0xE5 */ {0xC9, 0x88, 0x59},
    /* 0xE5 */ {0xCA, 0x88, 0x5E},
    /* 0xE5 */ {0xCB, 0x88, 0x62},
    /* 0xE5 */ {0xCC, 0x88, 0x6B},
    /* 0xE5 */ {0xCD, 0x88, 0x81},
    /* 0xE5 */ {0xCE, 0x88, 0x7E},
    /* 0xE5 */ {0xCF, 0x88, 0x9E},
    /* 0xE5 */ {0xD0, 0x88, 0x75},
    /* 0xE5 */ {0xD1, 0x88, 0x7D},
    /* 0xE5 */ {0xD2, 0x88, 0xB5},
    /* 0xE5 */ {0xD3, 0x88, 0x72},
    /* 0xE5 */ {0xD4, 0x88, 0x82},
    /* 0xE5 */ {0xD5, 0x88, 0x97},
    /* 0xE5 */ {0xD6, 0x88, 0x92},
    /* 0xE5 */ {0xD7, 0x88, 0xAE},
    /* 0xE5 */ {0xD8, 0x88, 0x99},
    /* 0xE5 */ {0xD9, 0x88, 0xA2},
    /* 0xE5 */ {0xDA, 0x88, 0x8D},
    /* 0xE5 */ {0xDB, 0x88, 0xA4},
    /* 0xE5 */ {0xDC, 0x88, 0xB0},
    /* 0xE5 */ {0xDD, 0x88, 0xBF},
    /* 0xE5 */ {0xDE, 0x88, 0xB1},
    /* 0xE5 */ {0xDF, 0x88, 0xC3},
    /* 0xE5 */ {0xE0, 0x88, 0xC4},
    /* 0xE5 */ {0xE1, 0x88, 0xD4},
    /* 0xE5 */ {0xE2, 0x88, 0xD8},
    /* 0xE5 */ {0xE3, 0x88, 0xD9},
    /* 0xE5 */ {0xE4, 0x88, 0xDD},
    /* 0xE5 */ {0xE5, 0x88, 0xF9},
    /* 0xE5 */ {0xE6, 0x89, 0x02},
    /* 0xE5 */ {0xE7, 0x88, 0xFC},
    /* 0xE5 */ {0xE8, 0x88, 0xF4},
    /* 0xE5 */ {0xE9, 0x88, 0xE8},
    /* 0xE5 */ {0xEA, 0x88, 0xF2},
    /* 0xE5 */ {0xEB, 0x89, 0x04},
    /* 0xE5 */ {0xEC, 0x89, 0x0C},
    /* 0xE5 */ {0xED, 0x89, 0x0A},
    /* 0xE5 */ {0xEE, 0x89, 0x13},
    /* 0xE5 */ {0xEF, 0x89, 0x43},
    /* 0xE5 */ {0xF0, 0x89, 0x1E},
    /* 0xE5 */ {0xF1, 0x89, 0x25},
    /* 0xE5 */ {0xF2, 0x89, 0x2A},
    /* 0xE5 */ {0xF3, 0x89, 0x2B},
    /* 0xE5 */ {0xF4, 0x89, 0x41},
    /* 0xE5 */ {0xF5, 0x89, 0x44},
    /* 0xE5 */ {0xF6, 0x89, 0x3B},
    /* 0xE5 */ {0xF7, 0x89, 0x36},
    /* 0xE5 */ {0xF8, 0x89, 0x38},
    /* 0xE5 */ {0xF9, 0x89, 0x4C},
    /* 0xE5 */ {0xFA, 0x89, 0x1D},
    /* 0xE5 */ {0xFB, 0x89, 0x60},
    /* 0xE5 */ {0xFC, 0x89, 0x5E},
    /* 0xE6 */ {0x40, 0x89, 0x66},
    /* 0xE6 */ {0x41, 0x89, 0x64},
    /* 0xE6 */ {0x42, 0x89, 0x6D},
    /* 0xE6 */ {0x43, 0x89, 0x6A},
    /* 0xE6 */ {0x44, 0x89, 0x6F},
    /* 0xE6 */ {0x45, 0x89, 0x74},
    /* 0xE6 */ {0x46, 0x89, 0x77},
    /* 0xE6 */ {0x47, 0x89, 0x7E},
    /* 0xE6 */ {0x48, 0x89, 0x83},
    /* 0xE6 */ {0x49, 0x89, 0x88},
    /* 0xE6 */ {0x4A, 0x89, 0x8A},
    /* 0xE6 */ {0x4B, 0x89, 0x93},
    /* 0xE6 */ {0x4C, 0x89, 0x98},
    /* 0xE6 */ {0x4D, 0x89, 0xA1},
    /* 0xE6 */ {0x4E, 0x89, 0xA9},
    /* 0xE6 */ {0x4F, 0x89, 0xA6},
    /* 0xE6 */ {0x50, 0x89, 0xAC},
    /* 0xE6 */ {0x51, 0x89, 0xAF},
    /* 0xE6 */ {0x52, 0x89, 0xB2},
    /* 0xE6 */ {0x53, 0x89, 0xBA},
    /* 0xE6 */ {0x54, 0x89, 0xBD},
    /* 0xE6 */ {0x55, 0x89, 0xBF},
    /* 0xE6 */ {0x56, 0x89, 0xC0},
    /* 0xE6 */ {0x57, 0x89, 0xDA},
    /* 0xE6 */ {0x58, 0x89, 0xDC},
    /* 0xE6 */ {0x59, 0x89, 0xDD},
    /* 0xE6 */ {0x5A, 0x89, 0xE7},
    /* 0xE6 */ {0x5B, 0x89, 0xF4},
    /* 0xE6 */ {0x5C, 0x89, 0xF8},
    /* 0xE6 */ {0x5D, 0x8A, 0x03},
    /* 0xE6 */ {0x5E, 0x8A, 0x16},
    /* 0xE6 */ {0x5F, 0x8A, 0x10},
    /* 0xE6 */ {0x60, 0x8A, 0x0C},
    /* 0xE6 */ {0x61, 0x8A, 0x1B},
    /* 0xE6 */ {0x62, 0x8A, 0x1D},
    /* 0xE6 */ {0x63, 0x8A, 0x25},
    /* 0xE6 */ {0x64, 0x8A, 0x36},
    /* 0xE6 */ {0x65, 0x8A, 0x41},
    /* 0xE6 */ {0x66, 0x8A, 0x5B},
    /* 0xE6 */ {0x67, 0x8A, 0x52},
    /* 0xE6 */ {0x68, 0x8A, 0x46},
    /* 0xE6 */ {0x69, 0x8A, 0x48},
    /* 0xE6 */ {0x6A, 0x8A, 0x7C},
    /* 0xE6 */ {0x6B, 0x8A, 0x6D},
    /* 0xE6 */ {0x6C, 0x8A, 0x6C},
    /* 0xE6 */ {0x6D, 0x8A, 0x62},
    /* 0xE6 */ {0x6E, 0x8A, 0x85},
    /* 0xE6 */ {0x6F, 0x8A, 0x82},
    /* 0xE6 */ {0x70, 0x8A, 0x84},
    /* 0xE6 */ {0x71, 0x8A, 0xA8},
    /* 0xE6 */ {0x72, 0x8A, 0xA1},
    /* 0xE6 */ {0x73, 0x8A, 0x91},
    /* 0xE6 */ {0x74, 0x8A, 0xA5},
    /* 0xE6 */ {0x75, 0x8A, 0xA6},
    /* 0xE6 */ {0x76, 0x8A, 0x9A},
    /* 0xE6 */ {0x77, 0x8A, 0xA3},
    /* 0xE6 */ {0x78, 0x8A, 0xC4},
    /* 0xE6 */ {0x79, 0x8A, 0xCD},
    /* 0xE6 */ {0x7A, 0x8A, 0xC2},
    /* 0xE6 */ {0x7B, 0x8A, 0xDA},
    /* 0xE6 */ {0x7C, 0x8A, 0xEB},
    /* 0xE6 */ {0x7D, 0x8A, 0xF3},
    /* 0xE6 */ {0x7E, 0x8A, 0xE7},
    /* 0xE6 */ {0x80, 0x8A, 0xE4},
    /* 0xE6 */ {0x81, 0x8A, 0xF1},
    /* 0xE6 */ {0x82, 0x8B, 0x14},
    /* 0xE6 */ {0x83, 0x8A, 0xE0},
    /* 0xE6 */ {0x84, 0x8A, 0xE2},
    /* 0xE6 */ {0x85, 0x8A, 0xF7},
    /* 0xE6 */ {0x86, 0x8A, 0xDE},
    /* 0xE6 */ {0x87, 0x8A, 0xDB},
    /* 0xE6 */ {0x88, 0x8B, 0x0C},
    /* 0xE6 */ {0x89, 0x8B, 0x07},
    /* 0xE6 */ {0x8A, 0x8B, 0x1A},
    /* 0xE6 */ {0x8B, 0x8A, 0xE1},
    /* 0xE6 */ {0x8C, 0x8B, 0x16},
    /* 0xE6 */ {0x8D, 0x8B, 0x10},
    /* 0xE6 */ {0x8E, 0x8B, 0x17},
    /* 0xE6 */ {0x8F, 0x8B, 0x20},
    /* 0xE6 */ {0x90, 0x8B, 0x33},
    /* 0xE6 */ {0x91, 0x97, 0xAB},
    /* 0xE6 */ {0x92, 0x8B, 0x26},
    /* 0xE6 */ {0x93, 0x8B, 0x2B},
    /* 0xE6 */ {0x94, 0x8B, 0x3E},
    /* 0xE6 */ {0x95, 0x8B, 0x28},
    /* 0xE6 */ {0x96, 0x8B, 0x41},
    /* 0xE6 */ {0x97, 0x8B, 0x4C},
    /* 0xE6 */ {0x98, 0x8B, 0x4F},
    /* 0xE6 */ {0x99, 0x8B, 0x4E},
    /* 0xE6 */ {0x9A, 0x8B, 0x49},
    /* 0xE6 */ {0x9B, 0x8B, 0x56},
    /* 0xE6 */ {0x9C, 0x8B, 0x5B},
    /* 0xE6 */ {0x9D, 0x8B, 0x5A},
    /* 0xE6 */ {0x9E, 0x8B, 0x6B},
    /* 0xE6 */ {0x9F, 0x8B, 0x5F},
    /* 0xE6 */ {0xA0, 0x8B, 0x6C},
    /* 0xE6 */ {0xA1, 0x8B, 0x6F},
    /* 0xE6 */ {0xA2, 0x8B, 0x74},
    /* 0xE6 */ {0xA3, 0x8B, 0x7D},
    /* 0xE6 */ {0xA4, 0x8B, 0x80},
    /* 0xE6 */ {0xA5, 0x8B, 0x8C},
    /* 0xE6 */ {0xA6, 0x8B, 0x8E},
    /* 0xE6 */ {0xA7, 0x8B, 0x92},
    /* 0xE6 */ {0xA8, 0x8B, 0x93},
    /* 0xE6 */ {0xA9, 0x8B, 0x96},
    /* 0xE6 */ {0xAA, 0x8B, 0x99},
    /* 0xE6 */ {0xAB, 0x8B, 0x9A},
    /* 0xE6 */ {0xAC, 0x8C, 0x3A},
    /* 0xE6 */ {0xAD, 0x8C, 0x41},
    /* 0xE6 */ {0xAE, 0x8C, 0x3F},
    /* 0xE6 */ {0xAF, 0x8C, 0x48},
    /* 0xE6 */ {0xB0, 0x8C, 0x4C},
    /* 0xE6 */ {0xB1, 0x8C, 0x4E},
    /* 0xE6 */ {0xB2, 0x8C, 0x50},
    /* 0xE6 */ {0xB3, 0x8C, 0x55},
    /* 0xE6 */ {0xB4, 0x8C, 0x62},
    /* 0xE6 */ {0xB5, 0x8C, 0x6C},
    /* 0xE6 */ {0xB6, 0x8C, 0x78},
    /* 0xE6 */ {0xB7, 0x8C, 0x7A},
    /* 0xE6 */ {0xB8, 0x8C, 0x82},
    /* 0xE6 */ {0xB9, 0x8C, 0x89},
    /* 0xE6 */ {0xBA, 0x8C, 0x85},
    /* 0xE6 */ {0xBB, 0x8C, 0x8A},
    /* 0xE6 */ {0xBC, 0x8C, 0x8D},
    /* 0xE6 */ {0xBD, 0x8C, 0x8E},
    /* 0xE6 */ {0xBE, 0x8C, 0x94},
    /* 0xE6 */ {0xBF, 0x8C, 0x7C},
    /* 0xE6 */ {0xC0, 0x8C, 0x98},
    /* 0xE6 */ {0xC1, 0x62, 0x1D},
    /* 0xE6 */ {0xC2, 0x8C, 0xAD},
    /* 0xE6 */ {0xC3, 0x8C, 0xAA},
    /* 0xE6 */ {0xC4, 0x8C, 0xBD},
    /* 0xE6 */ {0xC5, 0x8C, 0xB2},
    /* 0xE6 */ {0xC6, 0x8C, 0xB3},
    /* 0xE6 */ {0xC7, 0x8C, 0xAE},
    /* 0xE6 */ {0xC8, 0x8C, 0xB6},
    /* 0xE6 */ {0xC9, 0x8C, 0xC8},
    /* 0xE6 */ {0xCA, 0x8C, 0xC1},
    /* 0xE6 */ {0xCB, 0x8C, 0xE4},
    /* 0xE6 */ {0xCC, 0x8C, 0xE3},
    /* 0xE6 */ {0xCD, 0x8C, 0xDA},
    /* 0xE6 */ {0xCE, 0x8C, 0xFD},
    /* 0xE6 */ {0xCF, 0x8C, 0xFA},
    /* 0xE6 */ {0xD0, 0x8C, 0xFB},
    /* 0xE6 */ {0xD1, 0x8D, 0x04},
    /* 0xE6 */ {0xD2, 0x8D, 0x05},
    /* 0xE6 */ {0xD3, 0x8D, 0x0A},
    /* 0xE6 */ {0xD4, 0x8D, 0x07},
    /* 0xE6 */ {0xD5, 0x8D, 0x0F},
    /* 0xE6 */ {0xD6, 0x8D, 0x0D},
    /* 0xE6 */ {0xD7, 0x8D, 0x10},
    /* 0xE6 */ {0xD8, 0x9F, 0x4E},
    /* 0xE6 */ {0xD9, 0x8D, 0x13},
    /* 0xE6 */ {0xDA, 0x8C, 0xCD},
    /* 0xE6 */ {0xDB, 0x8D, 0x14},
    /* 0xE6 */ {0xDC, 0x8D, 0x16},
    /* 0xE6 */ {0xDD, 0x8D, 0x67},
    /* 0xE6 */ {0xDE, 0x8D, 0x6D},
    /* 0xE6 */ {0xDF, 0x8D, 0x71},
    /* 0xE6 */ {0xE0, 0x8D, 0x73},
    /* 0xE6 */ {0xE1, 0x8D, 0x81},
    /* 0xE6 */ {0xE2, 0x8D, 0x99},
    /* 0xE6 */ {0xE3, 0x8D, 0xC2},
    /* 0xE6 */ {0xE4, 0x8D, 0xBE},
    /* 0xE6 */ {0xE5, 0x8D, 0xBA},
    /* 0xE6 */ {0xE6, 0x8D, 0xCF},
    /* 0xE6 */ {0xE7, 0x8D, 0xDA},
    /* 0xE6 */ {0xE8, 0x8D, 0xD6},
    /* 0xE6 */ {0xE9, 0x8D, 0xCC},
    /* 0xE6 */ {0xEA, 0x8D, 0xDB},
    /* 0xE6 */ {0xEB, 0x8D, 0xCB},
    /* 0xE6 */ {0xEC, 0x8D, 0xEA},
    /* 0xE6 */ {0xED, 0x8D, 0xEB},
    /* 0xE6 */ {0xEE, 0x8D, 0xDF},
    /* 0xE6 */ {0xEF, 0x8D, 0xE3},
    /* 0xE6 */ {0xF0, 0x8D, 0xFC},
    /* 0xE6 */ {0xF1, 0x8E, 0x08},
    /* 0xE6 */ {0xF2, 0x8E, 0x09},
    /* 0xE6 */ {0xF3, 0x8D, 0xFF},
    /* 0xE6 */ {0xF4, 0x8E, 0x1D},
    /* 0xE6 */ {0xF5, 0x8E, 0x1E},
    /* 0xE6 */ {0xF6, 0x8E, 0x10},
    /* 0xE6 */ {0xF7, 0x8E, 0x1F},
    /* 0xE6 */ {0xF8, 0x8E, 0x42},
    /* 0xE6 */ {0xF9, 0x8E, 0x35},
    /* 0xE6 */ {0xFA, 0x8E, 0x30},
    /* 0xE6 */ {0xFB, 0x8E, 0x34},
    /* 0xE6 */ {0xFC, 0x8E, 0x4A},
    /* 0xE7 */ {0x40, 0x8E, 0x47},
    /* 0xE7 */ {0x41, 0x8E, 0x49},
    /* 0xE7 */ {0x42, 0x8E, 0x4C},
    /* 0xE7 */ {0x43, 0x8E, 0x50},
    /* 0xE7 */ {0x44, 0x8E, 0x48},
    /* 0xE7 */ {0x45, 0x8E, 0x59},
    /* 0xE7 */ {0x46, 0x8E, 0x64},
    /* 0xE7 */ {0x47, 0x8E, 0x60},
    /* 0xE7 */ {0x48, 0x8E, 0x2A},
    /* 0xE7 */ {0x49, 0x8E, 0x63},
    /* 0xE7 */ {0x4A, 0x8E, 0x55},
    /* 0xE7 */ {0x4B, 0x8E, 0x76},
    /* 0xE7 */ {0x4C, 0x8E, 0x72},
    /* 0xE7 */ {0x4D, 0x8E, 0x7C},
    /* 0xE7 */ {0x4E, 0x8E, 0x81},
    /* 0xE7 */ {0x4F, 0x8E, 0x87},
    /* 0xE7 */ {0x50, 0x8E, 0x85},
    /* 0xE7 */ {0x51, 0x8E, 0x84},
    /* 0xE7 */ {0x52, 0x8E, 0x8B},
    /* 0xE7 */ {0x53, 0x8E, 0x8A},
    /* 0xE7 */ {0x54, 0x8E, 0x93},
    /* 0xE7 */ {0x55, 0x8E, 0x91},
    /* 0xE7 */ {0x56, 0x8E, 0x94},
    /* 0xE7 */ {0x57, 0x8E, 0x99},
    /* 0xE7 */ {0x58, 0x8E, 0xAA},
    /* 0xE7 */ {0x59, 0x8E, 0xA1},
    /* 0xE7 */ {0x5A, 0x8E, 0xAC},
    /* 0xE7 */ {0x5B, 0x8E, 0xB0},
    /* 0xE7 */ {0x5C, 0x8E, 0xC6},
    /* 0xE7 */ {0x5D, 0x8E, 0xB1},
    /* 0xE7 */ {0x5E, 0x8E, 0xBE},
    /* 0xE7 */ {0x5F, 0x8E, 0xC5},
    /* 0xE7 */ {0x60, 0x8E, 0xC8},
    /* 0xE7 */ {0x61, 0x8E, 0xCB},
    /* 0xE7 */ {0x62, 0x8E, 0xDB},
    /* 0xE7 */ {0x63, 0x8E, 0xE3},
    /* 0xE7 */ {0x64, 0x8E, 0xFC},
    /* 0xE7 */ {0x65, 0x8E, 0xFB},
    /* 0xE7 */ {0x66, 0x8E, 0xEB},
    /* 0xE7 */ {0x67, 0x8E, 0xFE},
    /* 0xE7 */ {0x68, 0x8F, 0x0A},
    /* 0xE7 */ {0x69, 0x8F, 0x05},
    /* 0xE7 */ {0x6A, 0x8F, 0x15},
    /* 0xE7 */ {0x6B, 0x8F, 0x12},
    /* 0xE7 */ {0x6C, 0x8F, 0x19},
    /* 0xE7 */ {0x6D, 0x8F, 0x13},
    /* 0xE7 */ {0x6E, 0x8F, 0x1C},
    /* 0xE7 */ {0x6F, 0x8F, 0x1F},
    /* 0xE7 */ {0x70, 0x8F, 0x1B},
    /* 0xE7 */ {0x71, 0x8F, 0x0C},
    /* 0xE7 */ {0x72, 0x8F, 0x26},
    /* 0xE7 */ {0x73, 0x8F, 0x33},
    /* 0xE7 */ {0x74, 0x8F, 0x3B},
    /* 0xE7 */ {0x75, 0x8F, 0x39},
    /* 0xE7 */ {0x76, 0x8F, 0x45},
    /* 0xE7 */ {0x77, 0x8F, 0x42},
    /* 0xE7 */ {0x78, 0x8F, 0x3E},
    /* 0xE7 */ {0x79, 0x8F, 0x4C},
    /* 0xE7 */ {0x7A, 0x8F, 0x49},
    /* 0xE7 */ {0x7B, 0x8F, 0x46},
    /* 0xE7 */ {0x7C, 0x8F, 0x4E},
    /* 0xE7 */ {0x7D, 0x8F, 0x57},
    /* 0xE7 */ {0x7E, 0x8F, 0x5C},
    /* 0xE7 */ {0x80, 0x8F, 0x62},
    /* 0xE7 */ {0x81, 0x8F, 0x63},
    /* 0xE7 */ {0x82, 0x8F, 0x64},
    /* 0xE7 */ {0x83, 0x8F, 0x9C},
    /* 0xE7 */ {0x84, 0x8F, 0x9F},
    /* 0xE7 */ {0x85, 0x8F, 0xA3},
    /* 0xE7 */ {0x86, 0x8F, 0xAD},
    /* 0xE7 */ {0x87, 0x8F, 0xAF},
    /* 0xE7 */ {0x88, 0x8F, 0xB7},
    /* 0xE7 */ {0x89, 0x8F, 0xDA},
    /* 0xE7 */ {0x8A, 0x8F, 0xE5},
    /* 0xE7 */ {0x8B, 0x8F, 0xE2},
    /* 0xE7 */ {0x8C, 0x8F, 0xEA},
    /* 0xE7 */ {0x8D, 0x8F, 0xEF},
    /* 0xE7 */ {0x8E, 0x90, 0x87},
    /* 0xE7 */ {0x8F, 0x8F, 0xF4},
    /* 0xE7 */ {0x90, 0x90, 0x05},
    /* 0xE7 */ {0x91, 0x8F, 0xF9},
    /* 0xE7 */ {0x92, 0x8F, 0xFA},
    /* 0xE7 */ {0x93, 0x90, 0x11},
    /* 0xE7 */ {0x94, 0x90, 0x15},
    /* 0xE7 */ {0x95, 0x90, 0x21},
    /* 0xE7 */ {0x96, 0x90, 0x0D},
    /* 0xE7 */ {0x97, 0x90, 0x1E},
    /* 0xE7 */ {0x98, 0x90, 0x16},
    /* 0xE7 */ {0x99, 0x90, 0x0B},
    /* 0xE7 */ {0x9A, 0x90, 0x27},
    /* 0xE7 */ {0x9B, 0x90, 0x36},
    /* 0xE7 */ {0x9C, 0x90, 0x35},
    /* 0xE7 */ {0x9D, 0x90, 0x39},
    /* 0xE7 */ {0x9E, 0x8F, 0xF8},
    /* 0xE7 */ {0x9F, 0x90, 0x4F},
    /* 0xE7 */ {0xA0, 0x90, 0x50},
    /* 0xE7 */ {0xA1, 0x90, 0x51},
    /* 0xE7 */ {0xA2, 0x90, 0x52},
    /* 0xE7 */ {0xA3, 0x90, 0x0E},
    /* 0xE7 */ {0xA4, 0x90, 0x49},
    /* 0xE7 */ {0xA5, 0x90, 0x3E},
    /* 0xE7 */ {0xA6, 0x90, 0x56},
    /* 0xE7 */ {0xA7, 0x90, 0x58},
    /* 0xE7 */ {0xA8, 0x90, 0x5E},
    /* 0xE7 */ {0xA9, 0x90, 0x68},
    /* 0xE7 */ {0xAA, 0x90, 0x6F},
    /* 0xE7 */ {0xAB, 0x90, 0x76},
    /* 0xE7 */ {0xAC, 0x96, 0xA8},
    /* 0xE7 */ {0xAD, 0x90, 0x72},
    /* 0xE7 */ {0xAE, 0x90, 0x82},
    /* 0xE7 */ {0xAF, 0x90, 0x7D},
    /* 0xE7 */ {0xB0, 0x90, 0x81},
    /* 0xE7 */ {0xB1, 0x90, 0x80},
    /* 0xE7 */ {0xB2, 0x90, 0x8A},
    /* 0xE7 */ {0xB3, 0x90, 0x89},
    /* 0xE7 */ {0xB4, 0x90, 0x8F},
    /* 0xE7 */ {0xB5, 0x90, 0xA8},
    /* 0xE7 */ {0xB6, 0x90, 0xAF},
    /* 0xE7 */ {0xB7, 0x90, 0xB1},
    /* 0xE7 */ {0xB8, 0x90, 0xB5},
    /* 0xE7 */ {0xB9, 0x90, 0xE2},
    /* 0xE7 */ {0xBA, 0x90, 0xE4},
    /* 0xE7 */ {0xBB, 0x62, 0x48},
    /* 0xE7 */ {0xBC, 0x90, 0xDB},
    /* 0xE7 */ {0xBD, 0x91, 0x02},
    /* 0xE7 */ {0xBE, 0x91, 0x12},
    /* 0xE7 */ {0xBF, 0x91, 0x19},
    /* 0xE7 */ {0xC0, 0x91, 0x32},
    /* 0xE7 */ {0xC1, 0x91, 0x30},
    /* 0xE7 */ {0xC2, 0x91, 0x4A},
    /* 0xE7 */ {0xC3, 0x91, 0x56},
    /* 0xE7 */ {0xC4, 0x91, 0x58},
    /* 0xE7 */ {0xC5, 0x91, 0x63},
    /* 0xE7 */ {0xC6, 0x91, 0x65},
    /* 0xE7 */ {0xC7, 0x91, 0x69},
    /* 0xE7 */ {0xC8, 0x91, 0x73},
    /* 0xE7 */ {0xC9, 0x91, 0x72},
    /* 0xE7 */ {0xCA, 0x91, 0x8B},
    /* 0xE7 */ {0xCB, 0x91, 0x89},
    /* 0xE7 */ {0xCC, 0x91, 0x82},
    /* 0xE7 */ {0xCD, 0x91, 0xA2},
    /* 0xE7 */ {0xCE, 0x91, 0xAB},
    /* 0xE7 */ {0xCF, 0x91, 0xAF},
    /* 0xE7 */ {0xD0, 0x91, 0xAA},
    /* 0xE7 */ {0xD1, 0x91, 0xB5},
    /* 0xE7 */ {0xD2, 0x91, 0xB4},
    /* 0xE7 */ {0xD3, 0x91, 0xBA},
    /* 0xE7 */ {0xD4, 0x91, 0xC0},
    /* 0xE7 */ {0xD5, 0x91, 0xC1},
    /* 0xE7 */ {0xD6, 0x91, 0xC9},
    /* 0xE7 */ {0xD7, 0x91, 0xCB},
    /* 0xE7 */ {0xD8, 0x91, 0xD0},
    /* 0xE7 */ {0xD9, 0x91, 0xD6},
    /* 0xE7 */ {0xDA, 0x91, 0xDF},
    /* 0xE7 */ {0xDB, 0x91, 0xE1},
    /* 0xE7 */ {0xDC, 0x91, 0xDB},
    /* 0xE7 */ {0xDD, 0x91, 0xFC},
    /* 0xE7 */ {0xDE, 0x91, 0xF5},
    /* 0xE7 */ {0xDF, 0x91, 0xF6},
    /* 0xE7 */ {0xE0, 0x92, 0x1E},
    /* 0xE7 */ {0xE1, 0x91, 0xFF},
    /* 0xE7 */ {0xE2, 0x92, 0x14},
    /* 0xE7 */ {0xE3, 0x92, 0x2C},
    /* 0xE7 */ {0xE4, 0x92, 0x15},
    /* 0xE7 */ {0xE5, 0x92, 0x11},
    /* 0xE7 */ {0xE6, 0x92, 0x5E},
    /* 0xE7 */ {0xE7, 0x92, 0x57},
    /* 0xE7 */ {0xE8, 0x92, 0x45},
    /* 0xE7 */ {0xE9, 0x92, 0x49},
    /* 0xE7 */ {0xEA, 0x92, 0x64},
    /* 0xE7 */ {0xEB, 0x92, 0x48},
    /* 0xE7 */ {0xEC, 0x92, 0x95},
    /* 0xE7 */ {0xED, 0x92, 0x3F},
    /* 0xE7 */ {0xEE, 0x92, 0x4B},
    /* 0xE7 */ {0xEF, 0x92, 0x50},
    /* 0xE7 */ {0xF0, 0x92, 0x9C},
    /* 0xE7 */ {0xF1, 0x92, 0x96},
    /* 0xE7 */ {0xF2, 0x92, 0x93},
    /* 0xE7 */ {0xF3, 0x92, 0x9B},
    /* 0xE7 */ {0xF4, 0x92, 0x5A},
    /* 0xE7 */ {0xF5, 0x92, 0xCF},
    /* 0xE7 */ {0xF6, 0x92, 0xB9},
    /* 0xE7 */ {0xF7, 0x92, 0xB7},
    /* 0xE7 */ {0xF8, 0x92, 0xE9},
    /* 0xE7 */ {0xF9, 0x93, 0x0F},
    /* 0xE7 */ {0xFA, 0x92, 0xFA},
    /* 0xE7 */ {0xFB, 0x93, 0x44},
    /* 0xE7 */ {0xFC, 0x93, 0x2E},
    /* 0xE8 */ {0x40, 0x93, 0x19},
    /* 0xE8 */ {0x41, 0x93, 0x22},
    /* 0xE8 */ {0x42, 0x93, 0x1A},
    /* 0xE8 */ {0x43, 0x93, 0x23},
    /* 0xE8 */ {0x44, 0x93, 0x3A},
    /* 0xE8 */ {0x45, 0x93, 0x35},
    /* 0xE8 */ {0x46, 0x93, 0x3B},
    /* 0xE8 */ {0x47, 0x93, 0x5C},
    /* 0xE8 */ {0x48, 0x93, 0x60},
    /* 0xE8 */ {0x49, 0x93, 0x7C},
    /* 0xE8 */ {0x4A, 0x93, 0x6E},
    /* 0xE8 */ {0x4B, 0x93, 0x56},
    /* 0xE8 */ {0x4C, 0x93, 0xB0},
    /* 0xE8 */ {0x4D, 0x93, 0xAC},
    /* 0xE8 */ {0x4E, 0x93, 0xAD},
    /* 0xE8 */ {0x4F, 0x93, 0x94},
    /* 0xE8 */ {0x50, 0x93, 0xB9},
    /* 0xE8 */ {0x51, 0x93, 0xD6},
    /* 0xE8 */ {0x52, 0x93, 0xD7},
    /* 0xE8 */ {0x53, 0x93, 0xE8},
    /* 0xE8 */ {0x54, 0x93, 0xE5},
    /* 0xE8 */ {0x55, 0x93, 0xD8},
    /* 0xE8 */ {0x56, 0x93, 0xC3},
    /* 0xE8 */ {0x57, 0x93, 0xDD},
    /* 0xE8 */ {0x58, 0x93, 0xD0},
    /* 0xE8 */ {0x59, 0x93, 0xC8},
    /* 0xE8 */ {0x5A, 0x93, 0xE4},
    /* 0xE8 */ {0x5B, 0x94, 0x1A},
    /* 0xE8 */ {0x5C, 0x94, 0x14},
    /* 0xE8 */ {0x5D, 0x94, 0x13},
    /* 0xE8 */ {0x5E, 0x94, 0x03},
    /* 0xE8 */ {0x5F, 0x94, 0x07},
    /* 0xE8 */ {0x60, 0x94, 0x10},
    /* 0xE8 */ {0x61, 0x94, 0x36},
    /* 0xE8 */ {0x62, 0x94, 0x2B},
    /* 0xE8 */ {0x63, 0x94, 0x35},
    /* 0xE8 */ {0x64, 0x94, 0x21},
    /* 0xE8 */ {0x65, 0x94, 0x3A},
    /* 0xE8 */ {0x66, 0x94, 0x41},
    /* 0xE8 */ {0x67, 0x94, 0x52},
    /* 0xE8 */ {0x68, 0x94, 0x44},
    /* 0xE8 */ {0x69, 0x94, 0x5B},
    /* 0xE8 */ {0x6A, 0x94, 0x60},
    /* 0xE8 */ {0x6B, 0x94, 0x62},
    /* 0xE8 */ {0x6C, 0x94, 0x5E},
    /* 0xE8 */ {0x6D, 0x94, 0x6A},
    /* 0xE8 */ {0x6E, 0x92, 0x29},
    /* 0xE8 */ {0x6F, 0x94, 0x70},
    /* 0xE8 */ {0x70, 0x94, 0x75},
    /* 0xE8 */ {0x71, 0x94, 0x77},
    /* 0xE8 */ {0x72, 0x94, 0x7D},
    /* 0xE8 */ {0x73, 0x94, 0x5A},
    /* 0xE8 */ {0x74, 0x94, 0x7C},
    /* 0xE8 */ {0x75, 0x94, 0x7E},
    /* 0xE8 */ {0x76, 0x94, 0x81},
    /* 0xE8 */ {0x77, 0x94, 0x7F},
    /* 0xE8 */ {0x78, 0x95, 0x82},
    /* 0xE8 */ {0x79, 0x95, 0x87},
    /* 0xE8 */ {0x7A, 0x95, 0x8A},
    /* 0xE8 */ {0x7B, 0x95, 0x94},
    /* 0xE8 */ {0x7C, 0x95, 0x96},
    /* 0xE8 */ {0x7D, 0x95, 0x98},
    /* 0xE8 */ {0x7E, 0x95, 0x99},
    /* 0xE8 */ {0x80, 0x95, 0xA0},
    /* 0xE8 */ {0x81, 0x95, 0xA8},
    /* 0xE8 */ {0x82, 0x95, 0xA7},
    /* 0xE8 */ {0x83, 0x95, 0xAD},
    /* 0xE8 */ {0x84, 0x95, 0xBC},
    /* 0xE8 */ {0x85, 0x95, 0xBB},
    /* 0xE8 */ {0x86, 0x95, 0xB9},
    /* 0xE8 */ {0x87, 0x95, 0xBE},
    /* 0xE8 */ {0x88, 0x95, 0xCA},
    /* 0xE8 */ {0x89, 0x6F, 0xF6},
    /* 0xE8 */ {0x8A, 0x95, 0xC3},
    /* 0xE8 */ {0x8B, 0x95, 0xCD},
    /* 0xE8 */ {0x8C, 0x95, 0xCC},
    /* 0xE8 */ {0x8D, 0x95, 0xD5},
    /* 0xE8 */ {0x8E, 0x95, 0xD4},
    /* 0xE8 */ {0x8F, 0x95, 0xD6},
    /* 0xE8 */ {0x90, 0x95, 0xDC},
    /* 0xE8 */ {0x91, 0x95, 0xE1},
    /* 0xE8 */ {0x92, 0x95, 0xE5},
    /* 0xE8 */ {0x93, 0x95, 0xE2},
    /* 0xE8 */ {0x94, 0x96, 0x21},
    /* 0xE8 */ {0x95, 0x96, 0x28},
    /* 0xE8 */ {0x96, 0x96, 0x2E},
    /* 0xE8 */ {0x97, 0x96, 0x2F},
    /* 0xE8 */ {0x98, 0x96, 0x42},
    /* 0xE8 */ {0x99, 0x96, 0x4C},
    /* 0xE8 */ {0x9A, 0x96, 0x4F},
    /* 0xE8 */ {0x9B, 0x96, 0x4B},
    /* 0xE8 */ {0x9C, 0x96, 0x77},
    /* 0xE8 */ {0x9D, 0x96, 0x5C},
    /* 0xE8 */ {0x9E, 0x96, 0x5E},
    /* 0xE8 */ {0x9F, 0x96, 0x5D},
    /* 0xE8 */ {0xA0, 0x96, 0x5F},
    /* 0xE8 */ {0xA1, 0x96, 0x66},
    /* 0xE8 */ {0xA2, 0x96, 0x72},
    /* 0xE8 */ {0xA3, 0x96, 0x6C},
    /* 0xE8 */ {0xA4, 0x96, 0x8D},
    /* 0xE8 */ {0xA5, 0x96, 0x98},
    /* 0xE8 */ {0xA6, 0x96, 0x95},
    /* 0xE8 */ {0xA7, 0x96, 0x97},
    /* 0xE8 */ {0xA8, 0x96, 0xAA},
    /* 0xE8 */ {0xA9, 0x96, 0xA7},
    /* 0xE8 */ {0xAA, 0x96, 0xB1},
    /* 0xE8 */ {0xAB, 0x96, 0xB2},
    /* 0xE8 */ {0xAC, 0x96, 0xB0},
    /* 0xE8 */ {0xAD, 0x96, 0xB4},
    /* 0xE8 */ {0xAE, 0x96, 0xB6},
    /* 0xE8 */ {0xAF, 0x96, 0xB8},
    /* 0xE8 */ {0xB0, 0x96, 0xB9},
    /* 0xE8 */ {0xB1, 0x96, 0xCE},
    /* 0xE8 */ {0xB2, 0x96, 0xCB},
    /* 0xE8 */ {0xB3, 0x96, 0xC9},
    /* 0xE8 */ {0xB4, 0x96, 0xCD},
    /* 0xE8 */ {0xB5, 0x89, 0x4D},
    /* 0xE8 */ {0xB6, 0x96, 0xDC},
    /* 0xE8 */ {0xB7, 0x97, 0x0D},
    /* 0xE8 */ {0xB8, 0x96, 0xD5},
    /* 0xE8 */ {0xB9, 0x96, 0xF9},
    /* 0xE8 */ {0xBA, 0x97, 0x04},
    /* 0xE8 */ {0xBB, 0x97, 0x06},
    /* 0xE8 */ {0xBC, 0x97, 0x08},
    /* 0xE8 */ {0xBD, 0x97, 0x13},
    /* 0xE8 */ {0xBE, 0x97, 0x0E},
    /* 0xE8 */ {0xBF, 0x97, 0x11},
    /* 0xE8 */ {0xC0, 0x97, 0x0F},
    /* 0xE8 */ {0xC1, 0x97, 0x16},
    /* 0xE8 */ {0xC2, 0x97, 0x19},
    /* 0xE8 */ {0xC3, 0x97, 0x24},
    /* 0xE8 */ {0xC4, 0x97, 0x2A},
    /* 0xE8 */ {0xC5, 0x97, 0x30},
    /* 0xE8 */ {0xC6, 0x97, 0x39},
    /* 0xE8 */ {0xC7, 0x97, 0x3D},
    /* 0xE8 */ {0xC8, 0x97, 0x3E},
    /* 0xE8 */ {0xC9, 0x97, 0x44},
    /* 0xE8 */ {0xCA, 0x97, 0x46},
    /* 0xE8 */ {0xCB, 0x97, 0x48},
    /* 0xE8 */ {0xCC, 0x97, 0x42},
    /* 0xE8 */ {0xCD, 0x97, 0x49},
    /* 0xE8 */ {0xCE, 0x97, 0x5C},
    /* 0xE8 */ {0xCF, 0x97, 0x60},
    /* 0xE8 */ {0xD0, 0x97, 0x64},
    /* 0xE8 */ {0xD1, 0x97, 0x66},
    /* 0xE8 */ {0xD2, 0x97, 0x68},
    /* 0xE8 */ {0xD3, 0x52, 0xD2},
    /* 0xE8 */ {0xD4, 0x97, 0x6B},
    /* 0xE8 */ {0xD5, 0x97, 0x71},
    /* 0xE8 */ {0xD6, 0x97, 0x79},
    /* 0xE8 */ {0xD7, 0x97, 0x85},
    /* 0xE8 */ {0xD8, 0x97, 0x7C},
    /* 0xE8 */ {0xD9, 0x97, 0x81},
    /* 0xE8 */ {0xDA, 0x97, 0x7A},
    /* 0xE8 */ {0xDB, 0x97, 0x86},
    /* 0xE8 */ {0xDC, 0x97, 0x8B},
    /* 0xE8 */ {0xDD, 0x97, 0x8F},
    /* 0xE8 */ {0xDE, 0x97, 0x90},
    /* 0xE8 */ {0xDF, 0x97, 0x9C},
    /* 0xE8 */ {0xE0, 0x97, 0xA8},
    /* 0xE8 */ {0xE1, 0x97, 0xA6},
    /* 0xE8 */ {0xE2, 0x97, 0xA3},
    /* 0xE8 */ {0xE3, 0x97, 0xB3},
    /* 0xE8 */ {0xE4, 0x97, 0xB4},
    /* 0xE8 */ {0xE5, 0x97, 0xC3},
    /* 0xE8 */ {0xE6, 0x97, 0xC6},
    /* 0xE8 */ {0xE7, 0x97, 0xC8},
    /* 0xE8 */ {0xE8, 0x97, 0xCB},
    /* 0xE8 */ {0xE9, 0x97, 0xDC},
    /* 0xE8 */ {0xEA, 0x97, 0xED},
    /* 0xE8 */ {0xEB, 0x9F, 0x4F},
    /* 0xE8 */ {0xEC, 0x97, 0xF2},
    /* 0xE8 */ {0xED, 0x7A, 0xDF},
    /* 0xE8 */ {0xEE, 0x97, 0xF6},
    /* 0xE8 */ {0xEF, 0x97, 0xF5},
    /* 0xE8 */ {0xF0, 0x98, 0x0F},
    /* 0xE8 */ {0xF1, 0x98, 0x0C},
    /* 0xE8 */ {0xF2, 0x98, 0x38},
    /* 0xE8 */ {0xF3, 0x98, 0x24},
    /* 0xE8 */ {0xF4, 0x98, 0x21},
    /* 0xE8 */ {0xF5, 0x98, 0x37},
    /* 0xE8 */ {0xF6, 0x98, 0x3D},
    /* 0xE8 */ {0xF7, 0x98, 0x46},
    /* 0xE8 */ {0xF8, 0x98, 0x4F},
    /* 0xE8 */ {0xF9, 0x98, 0x4B},
    /* 0xE8 */ {0xFA, 0x98, 0x6B},
    /* 0xE8 */ {0xFB, 0x98, 0x6F},
    /* 0xE8 */ {0xFC, 0x98, 0x70},
    /* 0xE9 */ {0x40, 0x98, 0x71},
    /* 0xE9 */ {0x41, 0x98, 0x74},
    /* 0xE9 */ {0x42, 0x98, 0x73},
    /* 0xE9 */ {0x43, 0x98, 0xAA},
    /* 0xE9 */ {0x44, 0x98, 0xAF},
    /* 0xE9 */ {0x45, 0x98, 0xB1},
    /* 0xE9 */ {0x46, 0x98, 0xB6},
    /* 0xE9 */ {0x47, 0x98, 0xC4},
    /* 0xE9 */ {0x48, 0x98, 0xC3},
    /* 0xE9 */ {0x49, 0x98, 0xC6},
    /* 0xE9 */ {0x4A, 0x98, 0xE9},
    /* 0xE9 */ {0x4B, 0x98, 0xEB},
    /* 0xE9 */ {0x4C, 0x99, 0x03},
    /* 0xE9 */ {0x4D, 0x99, 0x09},
    /* 0xE9 */ {0x4E, 0x99, 0x12},
    /* 0xE9 */ {0x4F, 0x99, 0x14},
    /* 0xE9 */ {0x50, 0x99, 0x18},
    /* 0xE9 */ {0x51, 0x99, 0x21},
    /* 0xE9 */ {0x52, 0x99, 0x1D},
    /* 0xE9 */ {0x53, 0x99, 0x1E},
    /* 0xE9 */ {0x54, 0x99, 0x24},
    /* 0xE9 */ {0x55, 0x99, 0x20},
    /* 0xE9 */ {0x56, 0x99, 0x2C},
    /* 0xE9 */ {0x57, 0x99, 0x2E},
    /* 0xE9 */ {0x58, 0x99, 0x3D},
    /* 0xE9 */ {0x59, 0x99, 0x3E},
    /* 0xE9 */ {0x5A, 0x99, 0x42},
    /* 0xE9 */ {0x5B, 0x99, 0x49},
    /* 0xE9 */ {0x5C, 0x99, 0x45},
    /* 0xE9 */ {0x5D, 0x99, 0x50},
    /* 0xE9 */ {0x5E, 0x99, 0x4B},
    /* 0xE9 */ {0x5F, 0x99, 0x51},
    /* 0xE9 */ {0x60, 0x99, 0x52},
    /* 0xE9 */ {0x61, 0x99, 0x4C},
    /* 0xE9 */ {0x62, 0x99, 0x55},
    /* 0xE9 */ {0x63, 0x99, 0x97},
    /* 0xE9 */ {0x64, 0x99, 0x98},
    /* 0xE9 */ {0x65, 0x99, 0xA5},
    /* 0xE9 */ {0x66, 0x99, 0xAD},
    /* 0xE9 */ {0x67, 0x99, 0xAE},
    /* 0xE9 */ {0x68, 0x99, 0xBC},
    /* 0xE9 */ {0x69, 0x99, 0xDF},
    /* 0xE9 */ {0x6A, 0x99, 0xDB},
    /* 0xE9 */ {0x6B, 0x99, 0xDD},
    /* 0xE9 */ {0x6C, 0x99, 0xD8},
    /* 0xE9 */ {0x6D, 0x99, 0xD1},
    /* 0xE9 */ {0x6E, 0x99, 0xED},
    /* 0xE9 */ {0x6F, 0x99, 0xEE},
    /* 0xE9 */ {0x70, 0x99, 0xF1},
    /* 0xE9 */ {0x71, 0x99, 0xF2},
    /* 0xE9 */ {0x72, 0x99, 0xFB},
    /* 0xE9 */ {0x73, 0x99, 0xF8},
    /* 0xE9 */ {0x74, 0x9A, 0x01},
    /* 0xE9 */ {0x75, 0x9A, 0x0F},
    /* 0xE9 */ {0x76, 0x9A, 0x05},
    /* 0xE9 */ {0x77, 0x99, 0xE2},
    /* 0xE9 */ {0x78, 0x9A, 0x19},
    /* 0xE9 */ {0x79, 0x9A, 0x2B},
    /* 0xE9 */ {0x7A, 0x9A, 0x37},
    /* 0xE9 */ {0x7B, 0x9A, 0x45},
    /* 0xE9 */ {0x7C, 0x9A, 0x42},
    /* 0xE9 */ {0x7D, 0x9A, 0x40},
    /* 0xE9 */ {0x7E, 0x9A, 0x43},
    /* 0xE9 */ {0x80, 0x9A, 0x3E},
    /* 0xE9 */ {0x81, 0x9A, 0x55},
    /* 0xE9 */ {0x82, 0x9A, 0x4D},
    /* 0xE9 */ {0x83, 0x9A, 0x5B},
    /* 0xE9 */ {0x84, 0x9A, 0x57},
    /* 0xE9 */ {0x85, 0x9A, 0x5F},
    /* 0xE9 */ {0x86, 0x9A, 0x62},
    /* 0xE9 */ {0x87, 0x9A, 0x65},
    /* 0xE9 */ {0x88, 0x9A, 0x64},
    /* 0xE9 */ {0x89, 0x9A, 0x69},
    /* 0xE9 */ {0x8A, 0x9A, 0x6B},
    /* 0xE9 */ {0x8B, 0x9A, 0x6A},
    /* 0xE9 */ {0x8C, 0x9A, 0xAD},
    /* 0xE9 */ {0x8D, 0x9A, 0xB0},
    /* 0xE9 */ {0x8E, 0x9A, 0xBC},
    /* 0xE9 */ {0x8F, 0x9A, 0xC0},
    /* 0xE9 */ {0x90, 0x9A, 0xCF},
    /* 0xE9 */ {0x91, 0x9A, 0xD1},
    /* 0xE9 */ {0x92, 0x9A, 0xD3},
    /* 0xE9 */ {0x93, 0x9A, 0xD4},
    /* 0xE9 */ {0x94, 0x9A, 0xDE},
    /* 0xE9 */ {0x95, 0x9A, 0xDF},
    /* 0xE9 */ {0x96, 0x9A, 0xE2},
    /* 0xE9 */ {0x97, 0x9A, 0xE3},
    /* 0xE9 */ {0x98, 0x9A, 0xE6},
    /* 0xE9 */ {0x99, 0x9A, 0xEF},
    /* 0xE9 */ {0x9A, 0x9A, 0xEB},
    /* 0xE9 */ {0x9B, 0x9A, 0xEE},
    /* 0xE9 */ {0x9C, 0x9A, 0xF4},
    /* 0xE9 */ {0x9D, 0x9A, 0xF1},
    /* 0xE9 */ {0x9E, 0x9A, 0xF7},
    /* 0xE9 */ {0x9F, 0x9A, 0xFB},
    /* 0xE9 */ {0xA0, 0x9B, 0x06},
    /* 0xE9 */ {0xA1, 0x9B, 0x18},
    /* 0xE9 */ {0xA2, 0x9B, 0x1A},
    /* 0xE9 */ {0xA3, 0x9B, 0x1F},
    /* 0xE9 */ {0xA4, 0x9B, 0x22},
    /* 0xE9 */ {0xA5, 0x9B, 0x23},
    /* 0xE9 */ {0xA6, 0x9B, 0x25},
    /* 0xE9 */ {0xA7, 0x9B, 0x27},
    /* 0xE9 */ {0xA8, 0x9B, 0x28},
    /* 0xE9 */ {0xA9, 0x9B, 0x29},
    /* 0xE9 */ {0xAA, 0x9B, 0x2A},
    /* 0xE9 */ {0xAB, 0x9B, 0x2E},
    /* 0xE9 */ {0xAC, 0x9B, 0x2F},
    /* 0xE9 */ {0xAD, 0x9B, 0x32},
    /* 0xE9 */ {0xAE, 0x9B, 0x44},
    /* 0xE9 */ {0xAF, 0x9B, 0x43},
    /* 0xE9 */ {0xB0, 0x9B, 0x4F},
    /* 0xE9 */ {0xB1, 0x9B, 0x4D},
    /* 0xE9 */ {0xB2, 0x9B, 0x4E},
    /* 0xE9 */ {0xB3, 0x9B, 0x51},
    /* 0xE9 */ {0xB4, 0x9B, 0x58},
    /* 0xE9 */ {0xB5, 0x9B, 0x74},
    /* 0xE9 */ {0xB6, 0x9B, 0x93},
    /* 0xE9 */ {0xB7, 0x9B, 0x83},
    /* 0xE9 */ {0xB8, 0x9B, 0x91},
    /* 0xE9 */ {0xB9, 0x9B, 0x96},
    /* 0xE9 */ {0xBA, 0x9B, 0x97},
    /* 0xE9 */ {0xBB, 0x9B, 0x9F},
    /* 0xE9 */ {0xBC, 0x9B, 0xA0},
    /* 0xE9 */ {0xBD, 0x9B, 0xA8},
    /* 0xE9 */ {0xBE, 0x9B, 0xB4},
    /* 0xE9 */ {0xBF, 0x9B, 0xC0},
    /* 0xE9 */ {0xC0, 0x9B, 0xCA},
    /* 0xE9 */ {0xC1, 0x9B, 0xB9},
    /* 0xE9 */ {0xC2, 0x9B, 0xC6},
    /* 0xE9 */ {0xC3, 0x9B, 0xCF},
    /* 0xE9 */ {0xC4, 0x9B, 0xD1},
    /* 0xE9 */ {0xC5, 0x9B, 0xD2},
    /* 0xE9 */ {0xC6, 0x9B, 0xE3},
    /* 0xE9 */ {0xC7, 0x9B, 0xE2},
    /* 0xE9 */ {0xC8, 0x9B, 0xE4},
    /* 0xE9 */ {0xC9, 0x9B, 0xD4},
    /* 0xE9 */ {0xCA, 0x9B, 0xE1},
    /* 0xE9 */ {0xCB, 0x9C, 0x3A},
    /* 0xE9 */ {0xCC, 0x9B, 0xF2},
    /* 0xE9 */ {0xCD, 0x9B, 0xF1},
    /* 0xE9 */ {0xCE, 0x9B, 0xF0},
    /* 0xE9 */ {0xCF, 0x9C, 0x15},
    /* 0xE9 */ {0xD0, 0x9C, 0x14},
    /* 0xE9 */ {0xD1, 0x9C, 0x09},
    /* 0xE9 */ {0xD2, 0x9C, 0x13},
    /* 0xE9 */ {0xD3, 0x9C, 0x0C},
    /* 0xE9 */ {0xD4, 0x9C, 0x06},
    /* 0xE9 */ {0xD5, 0x9C, 0x08},
    /* 0xE9 */ {0xD6, 0x9C, 0x12},
    /* 0xE9 */ {0xD7, 0x9C, 0x0A},
    /* 0xE9 */ {0xD8, 0x9C, 0x04},
    /* 0xE9 */ {0xD9, 0x9C, 0x2E},
    /* 0xE9 */ {0xDA, 0x9C, 0x1B},
    /* 0xE9 */ {0xDB, 0x9C, 0x25},
    /* 0xE9 */ {0xDC, 0x9C, 0x24},
    /* 0xE9 */ {0xDD, 0x9C, 0x21},
    /* 0xE9 */ {0xDE, 0x9C, 0x30},
    /* 0xE9 */ {0xDF, 0x9C, 0x47},
    /* 0xE9 */ {0xE0, 0x9C, 0x32},
    /* 0xE9 */ {0xE1, 0x9C, 0x46},
    /* 0xE9 */ {0xE2, 0x9C, 0x3E},
    /* 0xE9 */ {0xE3, 0x9C, 0x5A},
    /* 0xE9 */ {0xE4, 0x9C, 0x60},
    /* 0xE9 */ {0xE5, 0x9C, 0x67},
    /* 0xE9 */ {0xE6, 0x9C, 0x76},
    /* 0xE9 */ {0xE7, 0x9C, 0x78},
    /* 0xE9 */ {0xE8, 0x9C, 0xE7},
    /* 0xE9 */ {0xE9, 0x9C, 0xEC},
    /* 0xE9 */ {0xEA, 0x9C, 0xF0},
    /* 0xE9 */ {0xEB, 0x9D, 0x09},
    /* 0xE9 */ {0xEC, 0x9D, 0x08},
    /* 0xE9 */ {0xED, 0x9C, 0xEB},
    /* 0xE9 */ {0xEE, 0x9D, 0x03},
    /* 0xE9 */ {0xEF, 0x9D, 0x06},
    /* 0xE9 */ {0xF0, 0x9D, 0x2A},
    /* 0xE9 */ {0xF1, 0x9D, 0x26},
    /* 0xE9 */ {0xF2, 0x9D, 0xAF},
    /* 0xE9 */ {0xF3, 0x9D, 0x23},
    /* 0xE9 */ {0xF4, 0x9D, 0x1F},
    /* 0xE9 */ {0xF5, 0x9D, 0x44},
    /* 0xE9 */ {0xF6, 0x9D, 0x15},
    /* 0xE9 */ {0xF7, 0x9D, 0x12},
    /* 0xE9 */ {0xF8, 0x9D, 0x41},
    /* 0xE9 */ {0xF9, 0x9D, 0x3F},
    /* 0xE9 */ {0xFA, 0x9D, 0x3E},
    /* 0xE9 */ {0xFB, 0x9D, 0x46},
    /* 0xE9 */ {0xFC, 0x9D, 0x48},
    /* 0xEA */ {0x40, 0x9D, 0x5D},
    /* 0xEA */ {0x41, 0x9D, 0x5E},
    /* 0xEA */ {0x42, 0x9D, 0x64},
    /* 0xEA */ {0x43, 0x9D, 0x51},
    /* 0xEA */ {0x44, 0x9D, 0x50},
    /* 0xEA */ {0x45, 0x9D, 0x59},
    /* 0xEA */ {0x46, 0x9D, 0x72},
    /* 0xEA */ {0x47, 0x9D, 0x89},
    /* 0xEA */ {0x48, 0x9D, 0x87},
    /* 0xEA */ {0x49, 0x9D, 0xAB},
    /* 0xEA */ {0x4A, 0x9D, 0x6F},
    /* 0xEA */ {0x4B, 0x9D, 0x7A},
    /* 0xEA */ {0x4C, 0x9D, 0x9A},
    /* 0xEA */ {0x4D, 0x9D, 0xA4},
    /* 0xEA */ {0x4E, 0x9D, 0xA9},
    /* 0xEA */ {0x4F, 0x9D, 0xB2},
    /* 0xEA */ {0x50, 0x9D, 0xC4},
    /* 0xEA */ {0x51, 0x9D, 0xC1},
    /* 0xEA */ {0x52, 0x9D, 0xBB},
    /* 0xEA */ {0x53, 0x9D, 0xB8},
    /* 0xEA */ {0x54, 0x9D, 0xBA},
    /* 0xEA */ {0x55, 0x9D, 0xC6},
    /* 0xEA */ {0x56, 0x9D, 0xCF},
    /* 0xEA */ {0x57, 0x9D, 0xC2},
    /* 0xEA */ {0x58, 0x9D, 0xD9},
    /* 0xEA */ {0x59, 0x9D, 0xD3},
    /* 0xEA */ {0x5A, 0x9D, 0xF8},
    /* 0xEA */ {0x5B, 0x9D, 0xE6},
    /* 0xEA */ {0x5C, 0x9D, 0xED},
    /* 0xEA */ {0x5D, 0x9D, 0xEF},
    /* 0xEA */ {0x5E, 0x9D, 0xFD},
    /* 0xEA */ {0x5F, 0x9E, 0x1A},
    /* 0xEA */ {0x60, 0x9E, 0x1B},
    /* 0xEA */ {0x61, 0x9E, 0x1E},
    /* 0xEA */ {0x62, 0x9E, 0x75},
    /* 0xEA */ {0x63, 0x9E, 0x79},
    /* 0xEA */ {0x64, 0x9E, 0x7D},
    /* 0xEA */ {0x65, 0x9E, 0x81},
    /* 0xEA */ {0x66, 0x9E, 0x88},
    /* 0xEA */ {0x67, 0x9E, 0x8B},
    /* 0xEA */ {0x68, 0x9E, 0x8C},
    /* 0xEA */ {0x69, 0x9E, 0x92},
    /* 0xEA */ {0x6A, 0x9E, 0x95},
    /* 0xEA */ {0x6B, 0x9E, 0x91},
    /* 0xEA */ {0x6C, 0x9E, 0x9D},
    /* 0xEA */ {0x6D, 0x9E, 0xA5},
    /* 0xEA */ {0x6E, 0x9E, 0xA9},
    /* 0xEA */ {0x6F, 0x9E, 0xB8},
    /* 0xEA */ {0x70, 0x9E, 0xAA},
    /* 0xEA */ {0x71, 0x9E, 0xAD},
    /* 0xEA */ {0x72, 0x97, 0x61},
    /* 0xEA */ {0x73, 0x9E, 0xCC},
    /* 0xEA */ {0x74, 0x9E, 0xCE},
    /* 0xEA */ {0x75, 0x9E, 0xCF},
    /* 0xEA */ {0x76, 0x9E, 0xD0},
    /* 0xEA */ {0x77, 0x9E, 0xD4},
    /* 0xEA */ {0x78, 0x9E, 0xDC},
    /* 0xEA */ {0x79, 0x9E, 0xDE},
    /* 0xEA */ {0x7A, 0x9E, 0xDD},
    /* 0xEA */ {0x7B, 0x9E, 0xE0},
    /* 0xEA */ {0x7C, 0x9E, 0xE5},
    /* 0xEA */ {0x7D, 0x9E, 0xE8},
    /* 0xEA */ {0x7E, 0x9E, 0xEF},
    /* 0xEA */ {0x80, 0x9E, 0xF4},
    /* 0xEA */ {0x81, 0x9E, 0xF6},
    /* 0xEA */ {0x82, 0x9E, 0xF7},
    /* 0xEA */ {0x83, 0x9E, 0xF9},
    /* 0xEA */ {0x84, 0x9E, 0xFB},
    /* 0xEA */ {0x85, 0x9E, 0xFC},
    /* 0xEA */ {0x86, 0x9E, 0xFD},
    /* 0xEA */ {0x87, 0x9F, 0x07},
    /* 0xEA */ {0x88, 0x9F, 0x08},
    /* 0xEA */ {0x89, 0x76, 0xB7},
    /* 0xEA */ {0x8A, 0x9F, 0x15},
    /* 0xEA */ {0x8B, 0x9F, 0x21},
    /* 0xEA */ {0x8C, 0x9F, 0x2C},
    /* 0xEA */ {0x8D, 0x9F, 0x3E},
    /* 0xEA */ {0x8E, 0x9F, 0x4A},
    /* 0xEA */ {0x8F, 0x9F, 0x52},
    /* 0xEA */ {0x90, 0x9F, 0x54},
    /* 0xEA */ {0x91, 0x9F, 0x63},
    /* 0xEA */ {0x92, 0x9F, 0x5F},
    /* 0xEA */ {0x93, 0x9F, 0x60},
    /* 0xEA */ {0x94, 0x9F, 0x61},
    /* 0xEA */ {0x95, 0x9F, 0x66},
    /* 0xEA */ {0x96, 0x9F, 0x67},
    /* 0xEA */ {0x97, 0x9F, 0x6C},
    /* 0xEA */ {0x98, 0x9F, 0x6A},
    /* 0xEA */ {0x99, 0x9F, 0x77},
    /* 0xEA */ {0x9A, 0x9F, 0x72},
    /* 0xEA */ {0x9B, 0x9F, 0x76},
    /* 0xEA */ {0x9C, 0x9F, 0x95},
    /* 0xEA */ {0x9D, 0x9F, 0x9C},
    /* 0xEA */ {0x9E, 0x9F, 0xA0},
    /* 0xEA */ {0x9F, 0x58, 0x2F},
    /* 0xEA */ {0xA0, 0x69, 0xC7},
    /* 0xEA */ {0xA1, 0x90, 0x59},
    /* 0xEA */ {0xA2, 0x74, 0x64},
    /* 0xEA */ {0xA3, 0x51, 0xDC},
    /* 0xEA */ {0xA4, 0x71, 0x99},
    /* 0xF0 */ {0x40, 0xE0, 0x00},
    /* 0xF0 */ {0x41, 0xE0, 0x01},
    /* 0xF0 */ {0x42, 0xE0, 0x02},
    /* 0xF0 */ {0x43, 0xE0, 0x03},
    /* 0xF0 */ {0x44, 0xE0, 0x04},
    /* 0xF0 */ {0x45, 0xE0, 0x05},
    /* 0xF0 */ {0x46, 0xE0, 0x06},
    /* 0xF0 */ {0x47, 0xE0, 0x07},
    /* 0xF0 */ {0x48, 0xE0, 0x08},
    /* 0xF0 */ {0x49, 0xE0, 0x09},
    /* 0xF0 */ {0x4A, 0xE0, 0x0A},
    /* 0xF0 */ {0x4B, 0xE0, 0x0B},
    /* 0xF0 */ {0x4C, 0xE0, 0x0C},
    /* 0xF0 */ {0x4D, 0xE0, 0x0D},
    /* 0xF0 */ {0x4E, 0xE0, 0x0E},
    /* 0xF0 */ {0x4F, 0xE0, 0x0F},
    /* 0xF0 */ {0x50, 0xE0, 0x10},
    /* 0xF0 */ {0x51, 0xE0, 0x11},
    /* 0xF0 */ {0x52, 0xE0, 0x12},
    /* 0xF0 */ {0x53, 0xE0, 0x13},
    /* 0xF0 */ {0x54, 0xE0, 0x14},
    /* 0xF0 */ {0x55, 0xE0, 0x15},
    /* 0xF0 */ {0x56, 0xE0, 0x16},
    /* 0xF0 */ {0x57, 0xE0, 0x17},
    /* 0xF0 */ {0x58, 0xE0, 0x18},
    /* 0xF0 */ {0x59, 0xE0, 0x19},
    /* 0xF0 */ {0x5A, 0xE0, 0x1A},
    /* 0xF0 */ {0x5B, 0xE0, 0x1B},
    /* 0xF0 */ {0x5C, 0xE0, 0x1C},
    /* 0xF0 */ {0x5D, 0xE0, 0x1D},
    /* 0xF0 */ {0x5E, 0xE0, 0x1E},
    /* 0xF0 */ {0x5F, 0xE0, 0x1F},
    /* 0xF0 */ {0x60, 0xE0, 0x20},
    /* 0xF0 */ {0x61, 0xE0, 0x21},
    /* 0xF0 */ {0x62, 0xE0, 0x22},
    /* 0xF0 */ {0x63, 0xE0, 0x23},
    /* 0xF0 */ {0x64, 0xE0, 0x24},
    /* 0xF0 */ {0x65, 0xE0, 0x25},
    /* 0xF0 */ {0x66, 0xE0, 0x26},
    /* 0xF0 */ {0x67, 0xE0, 0x27},
    /* 0xF0 */ {0x68, 0xE0, 0x28},
    /* 0xF0 */ {0x69, 0xE0, 0x29},
    /* 0xF0 */ {0x6A, 0xE0, 0x2A},
    /* 0xF0 */ {0x6B, 0xE0, 0x2B},
    /* 0xF0 */ {0x6C, 0xE0, 0x2C},
    /* 0xF0 */ {0x6D, 0xE0, 0x2D},
    /* 0xF0 */ {0x6E, 0xE0, 0x2E},
    /* 0xF0 */ {0x6F, 0xE0, 0x2F},
    /* 0xF0 */ {0x70, 0xE0, 0x30},
    /* 0xF0 */ {0x71, 0xE0, 0x31},
    /* 0xF0 */ {0x72, 0xE0, 0x32},
    /* 0xF0 */ {0x73, 0xE0, 0x33},
    /* 0xF0 */ {0x74, 0xE0, 0x34},
    /* 0xF0 */ {0x75, 0xE0, 0x35},
    /* 0xF0 */ {0x76, 0xE0, 0x36},
    /* 0xF0 */ {0x77, 0xE0, 0x37},
    /* 0xF0 */ {0x78, 0xE0, 0x38},
    /* 0xF0 */ {0x79, 0xE0, 0x39},
    /* 0xF0 */ {0x7A, 0xE0, 0x3A},
    /* 0xF0 */ {0x7B, 0xE0, 0x3B},
    /* 0xF0 */ {0x7C, 0xE0, 0x3C},
    /* 0xF0 */ {0x7D, 0xE0, 0x3D},
    /* 0xF0 */ {0x7E, 0xE0, 0x3E},
    /* 0xF0 */ {0x80, 0xE0, 0x3F},
    /* 0xF0 */ {0x81, 0xE0, 0x40},
    /* 0xF0 */ {0x82, 0xE0, 0x41},
    /* 0xF0 */ {0x83, 0xE0, 0x42},
    /* 0xF0 */ {0x84, 0xE0, 0x43},
    /* 0xF0 */ {0x85, 0xE0, 0x44},
    /* 0xF0 */ {0x86, 0xE0, 0x45},
    /* 0xF0 */ {0x87, 0xE0, 0x46},
    /* 0xF0 */ {0x88, 0xE0, 0x47},
    /* 0xF0 */ {0x89, 0xE0, 0x48},
    /* 0xF0 */ {0x8A, 0xE0, 0x49},
    /* 0xF0 */ {0x8B, 0xE0, 0x4A},
    /* 0xF0 */ {0x8C, 0xE0, 0x4B},
    /* 0xF0 */ {0x8D, 0xE0, 0x4C},
    /* 0xF0 */ {0x8E, 0xE0, 0x4D},
    /* 0xF0 */ {0x8F, 0xE0, 0x4E},
    /* 0xF0 */ {0x90, 0xE0, 0x4F},
    /* 0xF0 */ {0x91, 0xE0, 0x50},
    /* 0xF0 */ {0x92, 0xE0, 0x51},
    /* 0xF0 */ {0x93, 0xE0, 0x52},
    /* 0xF0 */ {0x94, 0xE0, 0x53},
    /* 0xF0 */ {0x95, 0xE0, 0x54},
    /* 0xF0 */ {0x96, 0xE0, 0x55},
    /* 0xF0 */ {0x97, 0xE0, 0x56},
    /* 0xF0 */ {0x98, 0xE0, 0x57},
    /* 0xF0 */ {0x99, 0xE0, 0x58},
    /* 0xF0 */ {0x9A, 0xE0, 0x59},
    /* 0xF0 */ {0x9B, 0xE0, 0x5A},
    /* 0xF0 */ {0x9C, 0xE0, 0x5B},
    /* 0xF0 */ {0x9D, 0xE0, 0x5C},
    /* 0xF0 */ {0x9E, 0xE0, 0x5D},
    /* 0xF0 */ {0x9F, 0xE0, 0x5E},
    /* 0xF0 */ {0xA0, 0xE0, 0x5F},
    /* 0xF0 */ {0xA1, 0xE0, 0x60},
    /* 0xF0 */ {0xA2, 0xE0, 0x61},
    /* 0xF0 */ {0xA3, 0xE0, 0x62},
    /* 0xF0 */ {0xA4, 0xE0, 0x63},
    /* 0xF0 */ {0xA5, 0xE0, 0x64},
    /* 0xF0 */ {0xA6, 0xE0, 0x65},
    /* 0xF0 */ {0xA7, 0xE0, 0x66},
    /* 0xF0 */ {0xA8, 0xE0, 0x67},
    /* 0xF0 */ {0xA9, 0xE0, 0x68},
    /* 0xF0 */ {0xAA, 0xE0, 0x69},
    /* 0xF0 */ {0xAB, 0xE0, 0x6A},
    /* 0xF0 */ {0xAC, 0xE0, 0x6B},
    /* 0xF0 */ {0xAD, 0xE0, 0x6C},
    /* 0xF0 */ {0xAE, 0xE0, 0x6D},
    /* 0xF0 */ {0xAF, 0xE0, 0x6E},
    /* 0xF0 */ {0xB0, 0xE0, 0x6F},
    /* 0xF0 */ {0xB1, 0xE0, 0x70},
    /* 0xF0 */ {0xB2, 0xE0, 0x71},
    /* 0xF0 */ {0xB3, 0xE0, 0x72},
    /* 0xF0 */ {0xB4, 0xE0, 0x73},
    /* 0xF0 */ {0xB5, 0xE0, 0x74},
    /* 0xF0 */ {0xB6, 0xE0, 0x75},
    /* 0xF0 */ {0xB7, 0xE0, 0x76},
    /* 0xF0 */ {0xB8, 0xE0, 0x77},
    /* 0xF0 */ {0xB9, 0xE0, 0x78},
    /* 0xF0 */ {0xBA, 0xE0, 0x79},
    /* 0xF0 */ {0xBB, 0xE0, 0x7A},
    /* 0xF0 */ {0xBC, 0xE0, 0x7B},
    /* 0xF0 */ {0xBD, 0xE0, 0x7C},
    /* 0xF0 */ {0xBE, 0xE0, 0x7D},
    /* 0xF0 */ {0xBF, 0xE0, 0x7E},
    /* 0xF0 */ {0xC0, 0xE0, 0x7F},
    /* 0xF0 */ {0xC1, 0xE0, 0x80},
    /* 0xF0 */ {0xC2, 0xE0, 0x81},
    /* 0xF0 */ {0xC3, 0xE0, 0x82},
    /* 0xF0 */ {0xC4, 0xE0, 0x83},
    /* 0xF0 */ {0xC5, 0xE0, 0x84},
    /* 0xF0 */ {0xC6, 0xE0, 0x85},
    /* 0xF0 */ {0xC7, 0xE0, 0x86},
    /* 0xF0 */ {0xC8, 0xE0, 0x87},
    /* 0xF0 */ {0xC9, 0xE0, 0x88},
    /* 0xF0 */ {0xCA, 0xE0, 0x89},
    /* 0xF0 */ {0xCB, 0xE0, 0x8A},
    /* 0xF0 */ {0xCC, 0xE0, 0x8B},
    /* 0xF0 */ {0xCD, 0xE0, 0x8C},
    /* 0xF0 */ {0xCE, 0xE0, 0x8D},
    /* 0xF0 */ {0xCF, 0xE0, 0x8E},
    /* 0xF0 */ {0xD0, 0xE0, 0x8F},
    /* 0xF0 */ {0xD1, 0xE0, 0x90},
    /* 0xF0 */ {0xD2, 0xE0, 0x91},
    /* 0xF0 */ {0xD3, 0xE0, 0x92},
    /* 0xF0 */ {0xD4, 0xE0, 0x93},
    /* 0xF0 */ {0xD5, 0xE0, 0x94},
    /* 0xF0 */ {0xD6, 0xE0, 0x95},
    /* 0xF0 */ {0xD7, 0xE0, 0x96},
    /* 0xF0 */ {0xD8, 0xE0, 0x97},
    /* 0xF0 */ {0xD9, 0xE0, 0x98},
    /* 0xF0 */ {0xDA, 0xE0, 0x99},
    /* 0xF0 */ {0xDB, 0xE0, 0x9A},
    /* 0xF0 */ {0xDC, 0xE0, 0x9B},
    /* 0xF0 */ {0xDD, 0xE0, 0x9C},
    /* 0xF0 */ {0xDE, 0xE0, 0x9D},
    /* 0xF0 */ {0xDF, 0xE0, 0x9E},
    /* 0xF0 */ {0xE0, 0xE0, 0x9F},
    /* 0xF0 */ {0xE1, 0xE0, 0xA0},
    /* 0xF0 */ {0xE2, 0xE0, 0xA1},
    /* 0xF0 */ {0xE3, 0xE0, 0xA2},
    /* 0xF0 */ {0xE4, 0xE0, 0xA3},
    /* 0xF0 */ {0xE5, 0xE0, 0xA4},
    /* 0xF0 */ {0xE6, 0xE0, 0xA5},
    /* 0xF0 */ {0xE7, 0xE0, 0xA6},
    /* 0xF0 */ {0xE8, 0xE0, 0xA7},
    /* 0xF0 */ {0xE9, 0xE0, 0xA8},
    /* 0xF0 */ {0xEA, 0xE0, 0xA9},
    /* 0xF0 */ {0xEB, 0xE0, 0xAA},
    /* 0xF0 */ {0xEC, 0xE0, 0xAB},
    /* 0xF0 */ {0xED, 0xE0, 0xAC},
    /* 0xF0 */ {0xEE, 0xE0, 0xAD},
    /* 0xF0 */ {0xEF, 0xE0, 0xAE},
    /* 0xF0 */ {0xF0, 0xE0, 0xAF},
    /* 0xF0 */ {0xF1, 0xE0, 0xB0},
    /* 0xF0 */ {0xF2, 0xE0, 0xB1},
    /* 0xF0 */ {0xF3, 0xE0, 0xB2},
    /* 0xF0 */ {0xF4, 0xE0, 0xB3},
    /* 0xF0 */ {0xF5, 0xE0, 0xB4},
    /* 0xF0 */ {0xF6, 0xE0, 0xB5},
    /* 0xF0 */ {0xF7, 0xE0, 0xB6},
    /* 0xF0 */ {0xF8, 0xE0, 0xB7},
    /* 0xF0 */ {0xF9, 0xE0, 0xB8},
    /* 0xF0 */ {0xFA, 0xE0, 0xB9},
    /* 0xF0 */ {0xFB, 0xE0, 0xBA},
    /* 0xF0 */ {0xFC, 0xE0, 0xBB},
    /* 0xF1 */ {0x40, 0xE0, 0xBC},
    /* 0xF1 */ {0x41, 0xE0, 0xBD},
    /* 0xF1 */ {0x42, 0xE0, 0xBE},
    /* 0xF1 */ {0x43, 0xE0, 0xBF},
    /* 0xF1 */ {0x44, 0xE0, 0xC0},
    /* 0xF1 */ {0x45, 0xE0, 0xC1},
    /* 0xF1 */ {0x46, 0xE0, 0xC2},
    /* 0xF1 */ {0x47, 0xE0, 0xC3},
    /* 0xF1 */ {0x48, 0xE0, 0xC4},
    /* 0xF1 */ {0x49, 0xE0, 0xC5},
    /* 0xF1 */ {0x4A, 0xE0, 0xC6},
    /* 0xF1 */ {0x4B, 0xE0, 0xC7},
    /* 0xF1 */ {0x4C, 0xE0, 0xC8},
    /* 0xF1 */ {0x4D, 0xE0, 0xC9},
    /* 0xF1 */ {0x4E, 0xE0, 0xCA},
    /* 0xF1 */ {0x4F, 0xE0, 0xCB},
    /* 0xF1 */ {0x50, 0xE0, 0xCC},
    /* 0xF1 */ {0x51, 0xE0, 0xCD},
    /* 0xF1 */ {0x52, 0xE0, 0xCE},
    /* 0xF1 */ {0x53, 0xE0, 0xCF},
    /* 0xF1 */ {0x54, 0xE0, 0xD0},
    /* 0xF1 */ {0x55, 0xE0, 0xD1},
    /* 0xF1 */ {0x56, 0xE0, 0xD2},
    /* 0xF1 */ {0x57, 0xE0, 0xD3},
    /* 0xF1 */ {0x58, 0xE0, 0xD4},
    /* 0xF1 */ {0x59, 0xE0, 0xD5},
    /* 0xF1 */ {0x5A, 0xE0, 0xD6},
    /* 0xF1 */ {0x5B, 0xE0, 0xD7},
    /* 0xF1 */ {0x5C, 0xE0, 0xD8},
    /* 0xF1 */ {0x5D, 0xE0, 0xD9},
    /* 0xF1 */ {0x5E, 0xE0, 0xDA},
    /* 0xF1 */ {0x5F, 0xE0, 0xDB},
    /* 0xF1 */ {0x60, 0xE0, 0xDC},
    /* 0xF1 */ {0x61, 0xE0, 0xDD},
    /* 0xF1 */ {0x62, 0xE0, 0xDE},
    /* 0xF1 */ {0x63, 0xE0, 0xDF},
    /* 0xF1 */ {0x64, 0xE0, 0xE0},
    /* 0xF1 */ {0x65, 0xE0, 0xE1},
    /* 0xF1 */ {0x66, 0xE0, 0xE2},
    /* 0xF1 */ {0x67, 0xE0, 0xE3},
    /* 0xF1 */ {0x68, 0xE0, 0xE4},
    /* 0xF1 */ {0x69, 0xE0, 0xE5},
    /* 0xF1 */ {0x6A, 0xE0, 0xE6},
    /* 0xF1 */ {0x6B, 0xE0, 0xE7},
    /* 0xF1 */ {0x6C, 0xE0, 0xE8},
    /* 0xF1 */ {0x6D, 0xE0, 0xE9},
    /* 0xF1 */ {0x6E, 0xE0, 0xEA},
    /* 0xF1 */ {0x6F, 0xE0, 0xEB},
    /* 0xF1 */ {0x70, 0xE0, 0xEC},
    /* 0xF1 */ {0x71, 0xE0, 0xED},
    /* 0xF1 */ {0x72, 0xE0, 0xEE},
    /* 0xF1 */ {0x73, 0xE0, 0xEF},
    /* 0xF1 */ {0x74, 0xE0, 0xF0},
    /* 0xF1 */ {0x75, 0xE0, 0xF1},
    /* 0xF1 */ {0x76, 0xE0, 0xF2},
    /* 0xF1 */ {0x77, 0xE0, 0xF3},
    /* 0xF1 */ {0x78, 0xE0, 0xF4},
    /* 0xF1 */ {0x79, 0xE0, 0xF5},
    /* 0xF1 */ {0x7A, 0xE0, 0xF6},
    /* 0xF1 */ {0x7B, 0xE0, 0xF7},
    /* 0xF1 */ {0x7C, 0xE0, 0xF8},
    /* 0xF1 */ {0x7D, 0xE0, 0xF9},
    /* 0xF1 */ {0x7E, 0xE0, 0xFA},
    /* 0xF1 */ {0x80, 0xE0, 0xFB},
    /* 0xF1 */ {0x81, 0xE0, 0xFC},
    /* 0xF1 */ {0x82, 0xE0, 0xFD},
    /* 0xF1 */ {0x83, 0xE0, 0xFE},
    /* 0xF1 */ {0x84, 0xE0, 0xFF},
    /* 0xF1 */ {0x85, 0xE1, 0x00},
    /* 0xF1 */ {0x86, 0xE1, 0x01},
    /* 0xF1 */ {0x87, 0xE1, 0x02},
    /* 0xF1 */ {0x88, 0xE1, 0x03},
    /* 0xF1 */ {0x89, 0xE1, 0x04},
    /* 0xF1 */ {0x8A, 0xE1, 0x05},
    /* 0xF1 */ {0x8B, 0xE1, 0x06},
    /* 0xF1 */ {0x8C, 0xE1, 0x07},
    /* 0xF1 */ {0x8D, 0xE1, 0x08},
    /* 0xF1 */ {0x8E, 0xE1, 0x09},
    /* 0xF1 */ {0x8F, 0xE1, 0x0A},
    /* 0xF1 */ {0x90, 0xE1, 0x0B},
    /* 0xF1 */ {0x91, 0xE1, 0x0C},
    /* 0xF1 */ {0x92, 0xE1, 0x0D},
    /* 0xF1 */ {0x93, 0xE1, 0x0E},
    /* 0xF1 */ {0x94, 0xE1, 0x0F},
    /* 0xF1 */ {0x95, 0xE1, 0x10},
    /* 0xF1 */ {0x96, 0xE1, 0x11},
    /* 0xF1 */ {0x97, 0xE1, 0x12},
    /* 0xF1 */ {0x98, 0xE1, 0x13},
    /* 0xF1 */ {0x99, 0xE1, 0x14},
    /* 0xF1 */ {0x9A, 0xE1, 0x15},
    /* 0xF1 */ {0x9B, 0xE1, 0x16},
    /* 0xF1 */ {0x9C, 0xE1, 0x17},
    /* 0xF1 */ {0x9D, 0xE1, 0x18},
    /* 0xF1 */ {0x9E, 0xE1, 0x19},
    /* 0xF1 */ {0x9F, 0xE1, 0x1A},
    /* 0xF1 */ {0xA0, 0xE1, 0x1B},
    /* 0xF1 */ {0xA1, 0xE1, 0x1C},
    /* 0xF1 */ {0xA2, 0xE1, 0x1D},
    /* 0xF1 */ {0xA3, 0xE1, 0x1E},
    /* 0xF1 */ {0xA4, 0xE1, 0x1F},
    /* 0xF1 */ {0xA5, 0xE1, 0x20},
    /* 0xF1 */ {0xA6, 0xE1, 0x21},
    /* 0xF1 */ {0xA7, 0xE1, 0x22},
    /* 0xF1 */ {0xA8, 0xE1, 0x23},
    /* 0xF1 */ {0xA9, 0xE1, 0x24},
    /* 0xF1 */ {0xAA, 0xE1, 0x25},
    /* 0xF1 */ {0xAB, 0xE1, 0x26},
    /* 0xF1 */ {0xAC, 0xE1, 0x27},
    /* 0xF1 */ {0xAD, 0xE1, 0x28},
    /* 0xF1 */ {0xAE, 0xE1, 0x29},
    /* 0xF1 */ {0xAF, 0xE1, 0x2A},
    /* 0xF1 */ {0xB0, 0xE1, 0x2B},
    /* 0xF1 */ {0xB1, 0xE1, 0x2C},
    /* 0xF1 */ {0xB2, 0xE1, 0x2D},
    /* 0xF1 */ {0xB3, 0xE1, 0x2E},
    /* 0xF1 */ {0xB4, 0xE1, 0x2F},
    /* 0xF1 */ {0xB5, 0xE1, 0x30},
    /* 0xF1 */ {0xB6, 0xE1, 0x31},
    /* 0xF1 */ {0xB7, 0xE1, 0x32},
    /* 0xF1 */ {0xB8, 0xE1, 0x33},
    /* 0xF1 */ {0xB9, 0xE1, 0x34},
    /* 0xF1 */ {0xBA, 0xE1, 0x35},
    /* 0xF1 */ {0xBB, 0xE1, 0x36},
    /* 0xF1 */ {0xBC, 0xE1, 0x37},
    /* 0xF1 */ {0xBD, 0xE1, 0x38},
    /* 0xF1 */ {0xBE, 0xE1, 0x39},
    /* 0xF1 */ {0xBF, 0xE1, 0x3A},
    /* 0xF1 */ {0xC0, 0xE1, 0x3B},
    /* 0xF1 */ {0xC1, 0xE1, 0x3C},
    /* 0xF1 */ {0xC2, 0xE1, 0x3D},
    /* 0xF1 */ {0xC3, 0xE1, 0x3E},
    /* 0xF1 */ {0xC4, 0xE1, 0x3F},
    /* 0xF1 */ {0xC5, 0xE1, 0x40},
    /* 0xF1 */ {0xC6, 0xE1, 0x41},
    /* 0xF1 */ {0xC7, 0xE1, 0x42},
    /* 0xF1 */ {0xC8, 0xE1, 0x43},
    /* 0xF1 */ {0xC9, 0xE1, 0x44},
    /* 0xF1 */ {0xCA, 0xE1, 0x45},
    /* 0xF1 */ {0xCB, 0xE1, 0x46},
    /* 0xF1 */ {0xCC, 0xE1, 0x47},
    /* 0xF1 */ {0xCD, 0xE1, 0x48},
    /* 0xF1 */ {0xCE, 0xE1, 0x49},
    /* 0xF1 */ {0xCF, 0xE1, 0x4A},
    /* 0xF1 */ {0xD0, 0xE1, 0x4B},
    /* 0xF1 */ {0xD1, 0xE1, 0x4C},
    /* 0xF1 */ {0xD2, 0xE1, 0x4D},
    /* 0xF1 */ {0xD3, 0xE1, 0x4E},
    /* 0xF1 */ {0xD4, 0xE1, 0x4F},
    /* 0xF1 */ {0xD5, 0xE1, 0x50},
    /* 0xF1 */ {0xD6, 0xE1, 0x51},
    /* 0xF1 */ {0xD7, 0xE1, 0x52},
    /* 0xF1 */ {0xD8, 0xE1, 0x53},
    /* 0xF1 */ {0xD9, 0xE1, 0x54},
    /* 0xF1 */ {0xDA, 0xE1, 0x55},
    /* 0xF1 */ {0xDB, 0xE1, 0x56},
    /* 0xF1 */ {0xDC, 0xE1, 0x57},
    /* 0xF1 */ {0xDD, 0xE1, 0x58},
    /* 0xF1 */ {0xDE, 0xE1, 0x59},
    /* 0xF1 */ {0xDF, 0xE1, 0x5A},
    /* 0xF1 */ {0xE0, 0xE1, 0x5B},
    /* 0xF1 */ {0xE1, 0xE1, 0x5C},
    /* 0xF1 */ {0xE2, 0xE1, 0x5D},
    /* 0xF1 */ {0xE3, 0xE1, 0x5E},
    /* 0xF1 */ {0xE4, 0xE1, 0x5F},
    /* 0xF1 */ {0xE5, 0xE1, 0x60},
    /* 0xF1 */ {0xE6, 0xE1, 0x61},
    /* 0xF1 */ {0xE7, 0xE1, 0x62},
    /* 0xF1 */ {0xE8, 0xE1, 0x63},
    /* 0xF1 */ {0xE9, 0xE1, 0x64},
    /* 0xF1 */ {0xEA, 0xE1, 0x65},
    /* 0xF1 */ {0xEB, 0xE1, 0x66},
    /* 0xF1 */ {0xEC, 0xE1, 0x67},
    /* 0xF1 */ {0xED, 0xE1, 0x68},
    /* 0xF1 */ {0xEE, 0xE1, 0x69},
    /* 0xF1 */ {0xEF, 0xE1, 0x6A},
    /* 0xF1 */ {0xF0, 0xE1, 0x6B},
    /* 0xF1 */ {0xF1, 0xE1, 0x6C},
    /* 0xF1 */ {0xF2, 0xE1, 0x6D},
    /* 0xF1 */ {0xF3, 0xE1, 0x6E},
    /* 0xF1 */ {0xF4, 0xE1, 0x6F},
    /* 0xF1 */ {0xF5, 0xE1, 0x70},
    /* 0xF1 */ {0xF6, 0xE1, 0x71},
    /* 0xF1 */ {0xF7, 0xE1, 0x72},
    /* 0xF1 */ {0xF8, 0xE1, 0x73},
    /* 0xF1 */ {0xF9, 0xE1, 0x74},
    /* 0xF1 */ {0xFA, 0xE1, 0x75},
    /* 0xF1 */ {0xFB, 0xE1, 0x76},
    /* 0xF1 */ {0xFC, 0xE1, 0x77},
    /* 0xF2 */ {0x40, 0xE1, 0x78},
    /* 0xF2 */ {0x41, 0xE1, 0x79},
    /* 0xF2 */ {0x42, 0xE1, 0x7A},
    /* 0xF2 */ {0x43, 0xE1, 0x7B},
    /* 0xF2 */ {0x44, 0xE1, 0x7C},
    /* 0xF2 */ {0x45, 0xE1, 0x7D},
    /* 0xF2 */ {0x46, 0xE1, 0x7E},
    /* 0xF2 */ {0x47, 0xE1, 0x7F},
    /* 0xF2 */ {0x48, 0xE1, 0x80},
    /* 0xF2 */ {0x49, 0xE1, 0x81},
    /* 0xF2 */ {0x4A, 0xE1, 0x82},
    /* 0xF2 */ {0x4B, 0xE1, 0x83},
    /* 0xF2 */ {0x4C, 0xE1, 0x84},
    /* 0xF2 */ {0x4D, 0xE1, 0x85},
    /* 0xF2 */ {0x4E, 0xE1, 0x86},
    /* 0xF2 */ {0x4F, 0xE1, 0x87},
    /* 0xF2 */ {0x50, 0xE1, 0x88},
    /* 0xF2 */ {0x51, 0xE1, 0x89},
    /* 0xF2 */ {0x52, 0xE1, 0x8A},
    /* 0xF2 */ {0x53, 0xE1, 0x8B},
    /* 0xF2 */ {0x54, 0xE1, 0x8C},
    /* 0xF2 */ {0x55, 0xE1, 0x8D},
    /* 0xF2 */ {0x56, 0xE1, 0x8E},
    /* 0xF2 */ {0x57, 0xE1, 0x8F},
    /* 0xF2 */ {0x58, 0xE1, 0x90},
    /* 0xF2 */ {0x59, 0xE1, 0x91},
    /* 0xF2 */ {0x5A, 0xE1, 0x92},
    /* 0xF2 */ {0x5B, 0xE1, 0x93},
    /* 0xF2 */ {0x5C, 0xE1, 0x94},
    /* 0xF2 */ {0x5D, 0xE1, 0x95},
    /* 0xF2 */ {0x5E, 0xE1, 0x96},
    /* 0xF2 */ {0x5F, 0xE1, 0x97},
    /* 0xF2 */ {0x60, 0xE1, 0x98},
    /* 0xF2 */ {0x61, 0xE1, 0x99},
    /* 0xF2 */ {0x62, 0xE1, 0x9A},
    /* 0xF2 */ {0x63, 0xE1, 0x9B},
    /* 0xF2 */ {0x64, 0xE1, 0x9C},
    /* 0xF2 */ {0x65, 0xE1, 0x9D},
    /* 0xF2 */ {0x66, 0xE1, 0x9E},
    /* 0xF2 */ {0x67, 0xE1, 0x9F},
    /* 0xF2 */ {0x68, 0xE1, 0xA0},
    /* 0xF2 */ {0x69, 0xE1, 0xA1},
    /* 0xF2 */ {0x6A, 0xE1, 0xA2},
    /* 0xF2 */ {0x6B, 0xE1, 0xA3},
    /* 0xF2 */ {0x6C, 0xE1, 0xA4},
    /* 0xF2 */ {0x6D, 0xE1, 0xA5},
    /* 0xF2 */ {0x6E, 0xE1, 0xA6},
    /* 0xF2 */ {0x6F, 0xE1, 0xA7},
    /* 0xF2 */ {0x70, 0xE1, 0xA8},
    /* 0xF2 */ {0x71, 0xE1, 0xA9},
    /* 0xF2 */ {0x72, 0xE1, 0xAA},
    /* 0xF2 */ {0x73, 0xE1, 0xAB},
    /* 0xF2 */ {0x74, 0xE1, 0xAC},
    /* 0xF2 */ {0x75, 0xE1, 0xAD},
    /* 0xF2 */ {0x76, 0xE1, 0xAE},
    /* 0xF2 */ {0x77, 0xE1, 0xAF},
    /* 0xF2 */ {0x78, 0xE1, 0xB0},
    /* 0xF2 */ {0x79, 0xE1, 0xB1},
    /* 0xF2 */ {0x7A, 0xE1, 0xB2},
    /* 0xF2 */ {0x7B, 0xE1, 0xB3},
    /* 0xF2 */ {0x7C, 0xE1, 0xB4},
    /* 0xF2 */ {0x7D, 0xE1, 0xB5},
    /* 0xF2 */ {0x7E, 0xE1, 0xB6},
    /* 0xF2 */ {0x80, 0xE1, 0xB7},
    /* 0xF2 */ {0x81, 0xE1, 0xB8},
    /* 0xF2 */ {0x82, 0xE1, 0xB9},
    /* 0xF2 */ {0x83, 0xE1, 0xBA},
    /* 0xF2 */ {0x84, 0xE1, 0xBB},
    /* 0xF2 */ {0x85, 0xE1, 0xBC},
    /* 0xF2 */ {0x86, 0xE1, 0xBD},
    /* 0xF2 */ {0x87, 0xE1, 0xBE},
    /* 0xF2 */ {0x88, 0xE1, 0xBF},
    /* 0xF2 */ {0x89, 0xE1, 0xC0},
    /* 0xF2 */ {0x8A, 0xE1, 0xC1},
    /* 0xF2 */ {0x8B, 0xE1, 0xC2},
    /* 0xF2 */ {0x8C, 0xE1, 0xC3},
    /* 0xF2 */ {0x8D, 0xE1, 0xC4},
    /* 0xF2 */ {0x8E, 0xE1, 0xC5},
    /* 0xF2 */ {0x8F, 0xE1, 0xC6},
    /* 0xF2 */ {0x90, 0xE1, 0xC7},
    /* 0xF2 */ {0x91, 0xE1, 0xC8},
    /* 0xF2 */ {0x92, 0xE1, 0xC9},
    /* 0xF2 */ {0x93, 0xE1, 0xCA},
    /* 0xF2 */ {0x94, 0xE1, 0xCB},
    /* 0xF2 */ {0x95, 0xE1, 0xCC},
    /* 0xF2 */ {0x96, 0xE1, 0xCD},
    /* 0xF2 */ {0x97, 0xE1, 0xCE},
    /* 0xF2 */ {0x98, 0xE1, 0xCF},
    /* 0xF2 */ {0x99, 0xE1, 0xD0},
    /* 0xF2 */ {0x9A, 0xE1, 0xD1},
    /* 0xF2 */ {0x9B, 0xE1, 0xD2},
    /* 0xF2 */ {0x9C, 0xE1, 0xD3},
    /* 0xF2 */ {0x9D, 0xE1, 0xD4},
    /* 0xF2 */ {0x9E, 0xE1, 0xD5},
    /* 0xF2 */ {0x9F, 0xE1, 0xD6},
    /* 0xF2 */ {0xA0, 0xE1, 0xD7},
    /* 0xF2 */ {0xA1, 0xE1, 0xD8},
    /* 0xF2 */ {0xA2, 0xE1, 0xD9},
    /* 0xF2 */ {0xA3, 0xE1, 0xDA},
    /* 0xF2 */ {0xA4, 0xE1, 0xDB},
    /* 0xF2 */ {0xA5, 0xE1, 0xDC},
    /* 0xF2 */ {0xA6, 0xE1, 0xDD},
    /* 0xF2 */ {0xA7, 0xE1, 0xDE},
    /* 0xF2 */ {0xA8, 0xE1, 0xDF},
    /* 0xF2 */ {0xA9, 0xE1, 0xE0},
    /* 0xF2 */ {0xAA, 0xE1, 0xE1},
    /* 0xF2 */ {0xAB, 0xE1, 0xE2},
    /* 0xF2 */ {0xAC, 0xE1, 0xE3},
    /* 0xF2 */ {0xAD, 0xE1, 0xE4},
    /* 0xF2 */ {0xAE, 0xE1, 0xE5},
    /* 0xF2 */ {0xAF, 0xE1, 0xE6},
    /* 0xF2 */ {0xB0, 0xE1, 0xE7},
    /* 0xF2 */ {0xB1, 0xE1, 0xE8},
    /* 0xF2 */ {0xB2, 0xE1, 0xE9},
    /* 0xF2 */ {0xB3, 0xE1, 0xEA},
    /* 0xF2 */ {0xB4, 0xE1, 0xEB},
    /* 0xF2 */ {0xB5, 0xE1, 0xEC},
    /* 0xF2 */ {0xB6, 0xE1, 0xED},
    /* 0xF2 */ {0xB7, 0xE1, 0xEE},
    /* 0xF2 */ {0xB8, 0xE1, 0xEF},
    /* 0xF2 */ {0xB9, 0xE1, 0xF0},
    /* 0xF2 */ {0xBA, 0xE1, 0xF1},
    /* 0xF2 */ {0xBB, 0xE1, 0xF2},
    /* 0xF2 */ {0xBC, 0xE1, 0xF3},
    /* 0xF2 */ {0xBD, 0xE1, 0xF4},
    /* 0xF2 */ {0xBE, 0xE1, 0xF5},
    /* 0xF2 */ {0xBF, 0xE1, 0xF6},
    /* 0xF2 */ {0xC0, 0xE1, 0xF7},
    /* 0xF2 */ {0xC1, 0xE1, 0xF8},
    /* 0xF2 */ {0xC2, 0xE1, 0xF9},
    /* 0xF2 */ {0xC3, 0xE1, 0xFA},
    /* 0xF2 */ {0xC4, 0xE1, 0xFB},
    /* 0xF2 */ {0xC5, 0xE1, 0xFC},
    /* 0xF2 */ {0xC6, 0xE1, 0xFD},
    /* 0xF2 */ {0xC7, 0xE1, 0xFE},
    /* 0xF2 */ {0xC8, 0xE1, 0xFF},
    /* 0xF2 */ {0xC9, 0xE2, 0x00},
    /* 0xF2 */ {0xCA, 0xE2, 0x01},
    /* 0xF2 */ {0xCB, 0xE2, 0x02},
    /* 0xF2 */ {0xCC, 0xE2, 0x03},
    /* 0xF2 */ {0xCD, 0xE2, 0x04},
    /* 0xF2 */ {0xCE, 0xE2, 0x05},
    /* 0xF2 */ {0xCF, 0xE2, 0x06},
    /* 0xF2 */ {0xD0, 0xE2, 0x07},
    /* 0xF2 */ {0xD1, 0xE2, 0x08},
    /* 0xF2 */ {0xD2, 0xE2, 0x09},
    /* 0xF2 */ {0xD3, 0xE2, 0x0A},
    /* 0xF2 */ {0xD4, 0xE2, 0x0B},
    /* 0xF2 */ {0xD5, 0xE2, 0x0C},
    /* 0xF2 */ {0xD6, 0xE2, 0x0D},
    /* 0xF2 */ {0xD7, 0xE2, 0x0E},
    /* 0xF2 */ {0xD8, 0xE2, 0x0F},
    /* 0xF2 */ {0xD9, 0xE2, 0x10},
    /* 0xF2 */ {0xDA, 0xE2, 0x11},
    /* 0xF2 */ {0xDB, 0xE2, 0x12},
    /* 0xF2 */ {0xDC, 0xE2, 0x13},
    /* 0xF2 */ {0xDD, 0xE2, 0x14},
    /* 0xF2 */ {0xDE, 0xE2, 0x15},
    /* 0xF2 */ {0xDF, 0xE2, 0x16},
    /* 0xF2 */ {0xE0, 0xE2, 0x17},
    /* 0xF2 */ {0xE1, 0xE2, 0x18},
    /* 0xF2 */ {0xE2, 0xE2, 0x19},
    /* 0xF2 */ {0xE3, 0xE2, 0x1A},
    /* 0xF2 */ {0xE4, 0xE2, 0x1B},
    /* 0xF2 */ {0xE5, 0xE2, 0x1C},
    /* 0xF2 */ {0xE6, 0xE2, 0x1D},
    /* 0xF2 */ {0xE7, 0xE2, 0x1E},
    /* 0xF2 */ {0xE8, 0xE2, 0x1F},
    /* 0xF2 */ {0xE9, 0xE2, 0x20},
    /* 0xF2 */ {0xEA, 0xE2, 0x21},
    /* 0xF2 */ {0xEB, 0xE2, 0x22},
    /* 0xF2 */ {0xEC, 0xE2, 0x23},
    /* 0xF2 */ {0xED, 0xE2, 0x24},
    /* 0xF2 */ {0xEE, 0xE2, 0x25},
    /* 0xF2 */ {0xEF, 0xE2, 0x26},
    /* 0xF2 */ {0xF0, 0xE2, 0x27},
    /* 0xF2 */ {0xF1, 0xE2, 0x28},
    /* 0xF2 */ {0xF2, 0xE2, 0x29},
    /* 0xF2 */ {0xF3, 0xE2, 0x2A},
    /* 0xF2 */ {0xF4, 0xE2, 0x2B},
    /* 0xF2 */ {0xF5, 0xE2, 0x2C},
    /* 0xF2 */ {0xF6, 0xE2, 0x2D},
    /* 0xF2 */ {0xF7, 0xE2, 0x2E},
    /* 0xF2 */ {0xF8, 0xE2, 0x2F},
    /* 0xF2 */ {0xF9, 0xE2, 0x30},
    /* 0xF2 */ {0xFA, 0xE2, 0x31},
    /* 0xF2 */ {0xFB, 0xE2, 0x32},
    /* 0xF2 */ {0xFC, 0xE2, 0x33},
    /* 0xF3 */ {0x40, 0xE2, 0x34},
    /* 0xF3 */ {0x41, 0xE2, 0x35},
    /* 0xF3 */ {0x42, 0xE2, 0x36},
    /* 0xF3 */ {0x43, 0xE2, 0x37},
    /* 0xF3 */ {0x44, 0xE2, 0x38},
    /* 0xF3 */ {0x45, 0xE2, 0x39},
    /* 0xF3 */ {0x46, 0xE2, 0x3A},
    /* 0xF3 */ {0x47, 0xE2, 0x3B},
    /* 0xF3 */ {0x48, 0xE2, 0x3C},
    /* 0xF3 */ {0x49, 0xE2, 0x3D},
    /* 0xF3 */ {0x4A, 0xE2, 0x3E},
    /* 0xF3 */ {0x4B, 0xE2, 0x3F},
    /* 0xF3 */ {0x4C, 0xE2, 0x40},
    /* 0xF3 */ {0x4D, 0xE2, 0x41},
    /* 0xF3 */ {0x4E, 0xE2, 0x42},
    /* 0xF3 */ {0x4F, 0xE2, 0x43},
    /* 0xF3 */ {0x50, 0xE2, 0x44},
    /* 0xF3 */ {0x51, 0xE2, 0x45},
    /* 0xF3 */ {0x52, 0xE2, 0x46},
    /* 0xF3 */ {0x53, 0xE2, 0x47},
    /* 0xF3 */ {0x54, 0xE2, 0x48},
    /* 0xF3 */ {0x55, 0xE2, 0x49},
    /* 0xF3 */ {0x56, 0xE2, 0x4A},
    /* 0xF3 */ {0x57, 0xE2, 0x4B},
    /* 0xF3 */ {0x58, 0xE2, 0x4C},
    /* 0xF3 */ {0x59, 0xE2, 0x4D},
    /* 0xF3 */ {0x5A, 0xE2, 0x4E},
    /* 0xF3 */ {0x5B, 0xE2, 0x4F},
    /* 0xF3 */ {0x5C, 0xE2, 0x50},
    /* 0xF3 */ {0x5D, 0xE2, 0x51},
    /* 0xF3 */ {0x5E, 0xE2, 0x52},
    /* 0xF3 */ {0x5F, 0xE2, 0x53},
    /* 0xF3 */ {0x60, 0xE2, 0x54},
    /* 0xF3 */ {0x61, 0xE2, 0x55},
    /* 0xF3 */ {0x62, 0xE2, 0x56},
    /* 0xF3 */ {0x63, 0xE2, 0x57},
    /* 0xF3 */ {0x64, 0xE2, 0x58},
    /* 0xF3 */ {0x65, 0xE2, 0x59},
    /* 0xF3 */ {0x66, 0xE2, 0x5A},
    /* 0xF3 */ {0x67, 0xE2, 0x5B},
    /* 0xF3 */ {0x68, 0xE2, 0x5C},
    /* 0xF3 */ {0x69, 0xE2, 0x5D},
    /* 0xF3 */ {0x6A, 0xE2, 0x5E},
    /* 0xF3 */ {0x6B, 0xE2, 0x5F},
    /* 0xF3 */ {0x6C, 0xE2, 0x60},
    /* 0xF3 */ {0x6D, 0xE2, 0x61},
    /* 0xF3 */ {0x6E, 0xE2, 0x62},
    /* 0xF3 */ {0x6F, 0xE2, 0x63},
    /* 0xF3 */ {0x70, 0xE2, 0x64},
    /* 0xF3 */ {0x71, 0xE2, 0x65},
    /* 0xF3 */ {0x72, 0xE2, 0x66},
    /* 0xF3 */ {0x73, 0xE2, 0x67},
    /* 0xF3 */ {0x74, 0xE2, 0x68},
    /* 0xF3 */ {0x75, 0xE2, 0x69},
    /* 0xF3 */ {0x76, 0xE2, 0x6A},
    /* 0xF3 */ {0x77, 0xE2, 0x6B},
    /* 0xF3 */ {0x78, 0xE2, 0x6C},
    /* 0xF3 */ {0x79, 0xE2, 0x6D},
    /* 0xF3 */ {0x7A, 0xE2, 0x6E},
    /* 0xF3 */ {0x7B, 0xE2, 0x6F},
    /* 0xF3 */ {0x7C, 0xE2, 0x70},
    /* 0xF3 */ {0x7D, 0xE2, 0x71},
    /* 0xF3 */ {0x7E, 0xE2, 0x72},
    /* 0xF3 */ {0x80, 0xE2, 0x73},
    /* 0xF3 */ {0x81, 0xE2, 0x74},
    /* 0xF3 */ {0x82, 0xE2, 0x75},
    /* 0xF3 */ {0x83, 0xE2, 0x76},
    /* 0xF3 */ {0x84, 0xE2, 0x77},
    /* 0xF3 */ {0x85, 0xE2, 0x78},
    /* 0xF3 */ {0x86, 0xE2, 0x79},
    /* 0xF3 */ {0x87, 0xE2, 0x7A},
    /* 0xF3 */ {0x88, 0xE2, 0x7B},
    /* 0xF3 */ {0x89, 0xE2, 0x7C},
    /* 0xF3 */ {0x8A, 0xE2, 0x7D},
    /* 0xF3 */ {0x8B, 0xE2, 0x7E},
    /* 0xF3 */ {0x8C, 0xE2, 0x7F},
    /* 0xF3 */ {0x8D, 0xE2, 0x80},
    /* 0xF3 */ {0x8E, 0xE2, 0x81},
    /* 0xF3 */ {0x8F, 0xE2, 0x82},
    /* 0xF3 */ {0x90, 0xE2, 0x83},
    /* 0xF3 */ {0x91, 0xE2, 0x84},
    /* 0xF3 */ {0x92, 0xE2, 0x85},
    /* 0xF3 */ {0x93, 0xE2, 0x86},
    /* 0xF3 */ {0x94, 0xE2, 0x87},
    /* 0xF3 */ {0x95, 0xE2, 0x88},
    /* 0xF3 */ {0x96, 0xE2, 0x89},
    /* 0xF3 */ {0x97, 0xE2, 0x8A},
    /* 0xF3 */ {0x98, 0xE2, 0x8B},
    /* 0xF3 */ {0x99, 0xE2, 0x8C},
    /* 0xF3 */ {0x9A, 0xE2, 0x8D},
    /* 0xF3 */ {0x9B, 0xE2, 0x8E},
    /* 0xF3 */ {0x9C, 0xE2, 0x8F},
    /* 0xF3 */ {0x9D, 0xE2, 0x90},
    /* 0xF3 */ {0x9E, 0xE2, 0x91},
    /* 0xF3 */ {0x9F, 0xE2, 0x92},
    /* 0xF3 */ {0xA0, 0xE2, 0x93},
    /* 0xF3 */ {0xA1, 0xE2, 0x94},
    /* 0xF3 */ {0xA2, 0xE2, 0x95},
    /* 0xF3 */ {0xA3, 0xE2, 0x96},
    /* 0xF3 */ {0xA4, 0xE2, 0x97},
    /* 0xF3 */ {0xA5, 0xE2, 0x98},
    /* 0xF3 */ {0xA6, 0xE2, 0x99},
    /* 0xF3 */ {0xA7, 0xE2, 0x9A},
    /* 0xF3 */ {0xA8, 0xE2, 0x9B},
    /* 0xF3 */ {0xA9, 0xE2, 0x9C},
    /* 0xF3 */ {0xAA, 0xE2, 0x9D},
    /* 0xF3 */ {0xAB, 0xE2, 0x9E},
    /* 0xF3 */ {0xAC, 0xE2, 0x9F},
    /* 0xF3 */ {0xAD, 0xE2, 0xA0},
    /* 0xF3 */ {0xAE, 0xE2, 0xA1},
    /* 0xF3 */ {0xAF, 0xE2, 0xA2},
    /* 0xF3 */ {0xB0, 0xE2, 0xA3},
    /* 0xF3 */ {0xB1, 0xE2, 0xA4},
    /* 0xF3 */ {0xB2, 0xE2, 0xA5},
    /* 0xF3 */ {0xB3, 0xE2, 0xA6},
    /* 0xF3 */ {0xB4, 0xE2, 0xA7},
    /* 0xF3 */ {0xB5, 0xE2, 0xA8},
    /* 0xF3 */ {0xB6, 0xE2, 0xA9},
    /* 0xF3 */ {0xB7, 0xE2, 0xAA},
    /* 0xF3 */ {0xB8, 0xE2, 0xAB},
    /* 0xF3 */ {0xB9, 0xE2, 0xAC},
    /* 0xF3 */ {0xBA, 0xE2, 0xAD},
    /* 0xF3 */ {0xBB, 0xE2, 0xAE},
    /* 0xF3 */ {0xBC, 0xE2, 0xAF},
    /* 0xF3 */ {0xBD, 0xE2, 0xB0},
    /* 0xF3 */ {0xBE, 0xE2, 0xB1},
    /* 0xF3 */ {0xBF, 0xE2, 0xB2},
    /* 0xF3 */ {0xC0, 0xE2, 0xB3},
    /* 0xF3 */ {0xC1, 0xE2, 0xB4},
    /* 0xF3 */ {0xC2, 0xE2, 0xB5},
    /* 0xF3 */ {0xC3, 0xE2, 0xB6},
    /* 0xF3 */ {0xC4, 0xE2, 0xB7},
    /* 0xF3 */ {0xC5, 0xE2, 0xB8},
    /* 0xF3 */ {0xC6, 0xE2, 0xB9},
    /* 0xF3 */ {0xC7, 0xE2, 0xBA},
    /* 0xF3 */ {0xC8, 0xE2, 0xBB},
    /* 0xF3 */ {0xC9, 0xE2, 0xBC},
    /* 0xF3 */ {0xCA, 0xE2, 0xBD},
    /* 0xF3 */ {0xCB, 0xE2, 0xBE},
    /* 0xF3 */ {0xCC, 0xE2, 0xBF},
    /* 0xF3 */ {0xCD, 0xE2, 0xC0},
    /* 0xF3 */ {0xCE, 0xE2, 0xC1},
    /* 0xF3 */ {0xCF, 0xE2, 0xC2},
    /* 0xF3 */ {0xD0, 0xE2, 0xC3},
    /* 0xF3 */ {0xD1, 0xE2, 0xC4},
    /* 0xF3 */ {0xD2, 0xE2, 0xC5},
    /* 0xF3 */ {0xD3, 0xE2, 0xC6},
    /* 0xF3 */ {0xD4, 0xE2, 0xC7},
    /* 0xF3 */ {0xD5, 0xE2, 0xC8},
    /* 0xF3 */ {0xD6, 0xE2, 0xC9},
    /* 0xF3 */ {0xD7, 0xE2, 0xCA},
    /* 0xF3 */ {0xD8, 0xE2, 0xCB},
    /* 0xF3 */ {0xD9, 0xE2, 0xCC},
    /* 0xF3 */ {0xDA, 0xE2, 0xCD},
    /* 0xF3 */ {0xDB, 0xE2, 0xCE},
    /* 0xF3 */ {0xDC, 0xE2, 0xCF},
    /* 0xF3 */ {0xDD, 0xE2, 0xD0},
    /* 0xF3 */ {0xDE, 0xE2, 0xD1},
    /* 0xF3 */ {0xDF, 0xE2, 0xD2},
    /* 0xF3 */ {0xE0, 0xE2, 0xD3},
    /* 0xF3 */ {0xE1, 0xE2, 0xD4},
    /* 0xF3 */ {0xE2, 0xE2, 0xD5},
    /* 0xF3 */ {0xE3, 0xE2, 0xD6},
    /* 0xF3 */ {0xE4, 0xE2, 0xD7},
    /* 0xF3 */ {0xE5, 0xE2, 0xD8},
    /* 0xF3 */ {0xE6, 0xE2, 0xD9},
    /* 0xF3 */ {0xE7, 0xE2, 0xDA},
    /* 0xF3 */ {0xE8, 0xE2, 0xDB},
    /* 0xF3 */ {0xE9, 0xE2, 0xDC},
    /* 0xF3 */ {0xEA, 0xE2, 0xDD},
    /* 0xF3 */ {0xEB, 0xE2, 0xDE},
    /* 0xF3 */ {0xEC, 0xE2, 0xDF},
    /* 0xF3 */ {0xED, 0xE2, 0xE0},
    /* 0xF3 */ {0xEE, 0xE2, 0xE1},
    /* 0xF3 */ {0xEF, 0xE2, 0xE2},
    /* 0xF3 */ {0xF0, 0xE2, 0xE3},
    /* 0xF3 */ {0xF1, 0xE2, 0xE4},
    /* 0xF3 */ {0xF2, 0xE2, 0xE5},
    /* 0xF3 */ {0xF3, 0xE2, 0xE6},
    /* 0xF3 */ {0xF4, 0xE2, 0xE7},
    /* 0xF3 */ {0xF5, 0xE2, 0xE8},
    /* 0xF3 */ {0xF6, 0xE2, 0xE9},
    /* 0xF3 */ {0xF7, 0xE2, 0xEA},
    /* 0xF3 */ {0xF8, 0xE2, 0xEB},
    /* 0xF3 */ {0xF9, 0xE2, 0xEC},
    /* 0xF3 */ {0xFA, 0xE2, 0xED},
    /* 0xF3 */ {0xFB, 0xE2, 0xEE},
    /* 0xF3 */ {0xFC, 0xE2, 0xEF},
    /* 0xF4 */ {0x40, 0xE2, 0xF0},
    /* 0xF4 */ {0x41, 0xE2, 0xF1},
    /* 0xF4 */ {0x42, 0xE2, 0xF2},
    /* 0xF4 */ {0x43, 0xE2, 0xF3},
    /* 0xF4 */ {0x44, 0xE2, 0xF4},
    /* 0xF4 */ {0x45, 0xE2, 0xF5},
    /* 0xF4 */ {0x46, 0xE2, 0xF6},
    /* 0xF4 */ {0x47, 0xE2, 0xF7},
    /* 0xF4 */ {0x48, 0xE2, 0xF8},
    /* 0xF4 */ {0x49, 0xE2, 0xF9},
    /* 0xF4 */ {0x4A, 0xE2, 0xFA},
    /* 0xF4 */ {0x4B, 0xE2, 0xFB},
    /* 0xF4 */ {0x4C, 0xE2, 0xFC},
    /* 0xF4 */ {0x4D, 0xE2, 0xFD},
    /* 0xF4 */ {0x4E, 0xE2, 0xFE},
    /* 0xF4 */ {0x4F, 0xE2, 0xFF},
    /* 0xF4 */ {0x50, 0xE3, 0x00},
    /* 0xF4 */ {0x51, 0xE3, 0x01},
    /* 0xF4 */ {0x52, 0xE3, 0x02},
    /* 0xF4 */ {0x53, 0xE3, 0x03},
    /* 0xF4 */ {0x54, 0xE3, 0x04},
    /* 0xF4 */ {0x55, 0xE3, 0x05},
    /* 0xF4 */ {0x56, 0xE3, 0x06},
    /* 0xF4 */ {0x57, 0xE3, 0x07},
    /* 0xF4 */ {0x58, 0xE3, 0x08},
    /* 0xF4 */ {0x59, 0xE3, 0x09},
    /* 0xF4 */ {0x5A, 0xE3, 0x0A},
    /* 0xF4 */ {0x5B, 0xE3, 0x0B},
    /* 0xF4 */ {0x5C, 0xE3, 0x0C},
    /* 0xF4 */ {0x5D, 0xE3, 0x0D},
    /* 0xF4 */ {0x5E, 0xE3, 0x0E},
    /* 0xF4 */ {0x5F, 0xE3, 0x0F},
    /* 0xF4 */ {0x60, 0xE3, 0x10},
    /* 0xF4 */ {0x61, 0xE3, 0x11},
    /* 0xF4 */ {0x62, 0xE3, 0x12},
    /* 0xF4 */ {0x63, 0xE3, 0x13},
    /* 0xF4 */ {0x64, 0xE3, 0x14},
    /* 0xF4 */ {0x65, 0xE3, 0x15},
    /* 0xF4 */ {0x66, 0xE3, 0x16},
    /* 0xF4 */ {0x67, 0xE3, 0x17},
    /* 0xF4 */ {0x68, 0xE3, 0x18},
    /* 0xF4 */ {0x69, 0xE3, 0x19},
    /* 0xF4 */ {0x6A, 0xE3, 0x1A},
    /* 0xF4 */ {0x6B, 0xE3, 0x1B},
    /* 0xF4 */ {0x6C, 0xE3, 0x1C},
    /* 0xF4 */ {0x6D, 0xE3, 0x1D},
    /* 0xF4 */ {0x6E, 0xE3, 0x1E},
    /* 0xF4 */ {0x6F, 0xE3, 0x1F},
    /* 0xF4 */ {0x70, 0xE3, 0x20},
    /* 0xF4 */ {0x71, 0xE3, 0x21},
    /* 0xF4 */ {0x72, 0xE3, 0x22},
    /* 0xF4 */ {0x73, 0xE3, 0x23},
    /* 0xF4 */ {0x74, 0xE3, 0x24},
    /* 0xF4 */ {0x75, 0xE3, 0x25},
    /* 0xF4 */ {0x76, 0xE3, 0x26},
    /* 0xF4 */ {0x77, 0xE3, 0x27},
    /* 0xF4 */ {0x78, 0xE3, 0x28},
    /* 0xF4 */ {0x79, 0xE3, 0x29},
    /* 0xF4 */ {0x7A, 0xE3, 0x2A},
    /* 0xF4 */ {0x7B, 0xE3, 0x2B},
    /* 0xF4 */ {0x7C, 0xE3, 0x2C},
    /* 0xF4 */ {0x7D, 0xE3, 0x2D},
    /* 0xF4 */ {0x7E, 0xE3, 0x2E},
    /* 0xF4 */ {0x80, 0xE3, 0x2F},
    /* 0xF4 */ {0x81, 0xE3, 0x30},
    /* 0xF4 */ {0x82, 0xE3, 0x31},
    /* 0xF4 */ {0x83, 0xE3, 0x32},
    /* 0xF4 */ {0x84, 0xE3, 0x33},
    /* 0xF4 */ {0x85, 0xE3, 0x34},
    /* 0xF4 */ {0x86, 0xE3, 0x35},
    /* 0xF4 */ {0x87, 0xE3, 0x36},
    /* 0xF4 */ {0x88, 0xE3, 0x37},
    /* 0xF4 */ {0x89, 0xE3, 0x38},
    /* 0xF4 */ {0x8A, 0xE3, 0x39},
    /* 0xF4 */ {0x8B, 0xE3, 0x3A},
    /* 0xF4 */ {0x8C, 0xE3, 0x3B},
    /* 0xF4 */ {0x8D, 0xE3, 0x3C},
    /* 0xF4 */ {0x8E, 0xE3, 0x3D},
    /* 0xF4 */ {0x8F, 0xE3, 0x3E},
    /* 0xF4 */ {0x90, 0xE3, 0x3F},
    /* 0xF4 */ {0x91, 0xE3, 0x40},
    /* 0xF4 */ {0x92, 0xE3, 0x41},
    /* 0xF4 */ {0x93, 0xE3, 0x42},
    /* 0xF4 */ {0x94, 0xE3, 0x43},
    /* 0xF4 */ {0x95, 0xE3, 0x44},
    /* 0xF4 */ {0x96, 0xE3, 0x45},
    /* 0xF4 */ {0x97, 0xE3, 0x46},
    /* 0xF4 */ {0x98, 0xE3, 0x47},
    /* 0xF4 */ {0x99, 0xE3, 0x48},
    /* 0xF4 */ {0x9A, 0xE3, 0x49},
    /* 0xF4 */ {0x9B, 0xE3, 0x4A},
    /* 0xF4 */ {0x9C, 0xE3, 0x4B},
    /* 0xF4 */ {0x9D, 0xE3, 0x4C},
    /* 0xF4 */ {0x9E, 0xE3, 0x4D},
    /* 0xF4 */ {0x9F, 0xE3, 0x4E},
    /* 0xF4 */ {0xA0, 0xE3, 0x4F},
    /* 0xF4 */ {0xA1, 0xE3, 0x50},
    /* 0xF4 */ {0xA2, 0xE3, 0x51},
    /* 0xF4 */ {0xA3, 0xE3, 0x52},
    /* 0xF4 */ {0xA4, 0xE3, 0x53},
    /* 0xF4 */ {0xA5, 0xE3, 0x54},
    /* 0xF4 */ {0xA6, 0xE3, 0x55},
    /* 0xF4 */ {0xA7, 0xE3, 0x56},
    /* 0xF4 */ {0xA8, 0xE3, 0x57},
    /* 0xF4 */ {0xA9, 0xE3, 0x58},
    /* 0xF4 */ {0xAA, 0xE3, 0x59},
    /* 0xF4 */ {0xAB, 0xE3, 0x5A},
    /* 0xF4 */ {0xAC, 0xE3, 0x5B},
    /* 0xF4 */ {0xAD, 0xE3, 0x5C},
    /* 0xF4 */ {0xAE, 0xE3, 0x5D},
    /* 0xF4 */ {0xAF, 0xE3, 0x5E},
    /* 0xF4 */ {0xB0, 0xE3, 0x5F},
    /* 0xF4 */ {0xB1, 0xE3, 0x60},
    /* 0xF4 */ {0xB2, 0xE3, 0x61},
    /* 0xF4 */ {0xB3, 0xE3, 0x62},
    /* 0xF4 */ {0xB4, 0xE3, 0x63},
    /* 0xF4 */ {0xB5, 0xE3, 0x64},
    /* 0xF4 */ {0xB6, 0xE3, 0x65},
    /* 0xF4 */ {0xB7, 0xE3, 0x66},
    /* 0xF4 */ {0xB8, 0xE3, 0x67},
    /* 0xF4 */ {0xB9, 0xE3, 0x68},
    /* 0xF4 */ {0xBA, 0xE3, 0x69},
    /* 0xF4 */ {0xBB, 0xE3, 0x6A},
    /* 0xF4 */ {0xBC, 0xE3, 0x6B},
    /* 0xF4 */ {0xBD, 0xE3, 0x6C},
    /* 0xF4 */ {0xBE, 0xE3, 0x6D},
    /* 0xF4 */ {0xBF, 0xE3, 0x6E},
    /* 0xF4 */ {0xC0, 0xE3, 0x6F},
    /* 0xF4 */ {0xC1, 0xE3, 0x70},
    /* 0xF4 */ {0xC2, 0xE3, 0x71},
    /* 0xF4 */ {0xC3, 0xE3, 0x72},
    /* 0xF4 */ {0xC4, 0xE3, 0x73},
    /* 0xF4 */ {0xC5, 0xE3, 0x74},
    /* 0xF4 */ {0xC6, 0xE3, 0x75},
    /* 0xF4 */ {0xC7, 0xE3, 0x76},
    /* 0xF4 */ {0xC8, 0xE3, 0x77},
    /* 0xF4 */ {0xC9, 0xE3, 0x78},
    /* 0xF4 */ {0xCA, 0xE3, 0x79},
    /* 0xF4 */ {0xCB, 0xE3, 0x7A},
    /* 0xF4 */ {0xCC, 0xE3, 0x7B},
    /* 0xF4 */ {0xCD, 0xE3, 0x7C},
    /* 0xF4 */ {0xCE, 0xE3, 0x7D},
    /* 0xF4 */ {0xCF, 0xE3, 0x7E},
    /* 0xF4 */ {0xD0, 0xE3, 0x7F},
    /* 0xF4 */ {0xD1, 0xE3, 0x80},
    /* 0xF4 */ {0xD2, 0xE3, 0x81},
    /* 0xF4 */ {0xD3, 0xE3, 0x82},
    /* 0xF4 */ {0xD4, 0xE3, 0x83},
    /* 0xF4 */ {0xD5, 0xE3, 0x84},
    /* 0xF4 */ {0xD6, 0xE3, 0x85},
    /* 0xF4 */ {0xD7, 0xE3, 0x86},
    /* 0xF4 */ {0xD8, 0xE3, 0x87},
    /* 0xF4 */ {0xD9, 0xE3, 0x88},
    /* 0xF4 */ {0xDA, 0xE3, 0x89},
    /* 0xF4 */ {0xDB, 0xE3, 0x8A},
    /* 0xF4 */ {0xDC, 0xE3, 0x8B},
    /* 0xF4 */ {0xDD, 0xE3, 0x8C},
    /* 0xF4 */ {0xDE, 0xE3, 0x8D},
    /* 0xF4 */ {0xDF, 0xE3, 0x8E},
    /* 0xF4 */ {0xE0, 0xE3, 0x8F},
    /* 0xF4 */ {0xE1, 0xE3, 0x90},
    /* 0xF4 */ {0xE2, 0xE3, 0x91},
    /* 0xF4 */ {0xE3, 0xE3, 0x92},
    /* 0xF4 */ {0xE4, 0xE3, 0x93},
    /* 0xF4 */ {0xE5, 0xE3, 0x94},
    /* 0xF4 */ {0xE6, 0xE3, 0x95},
    /* 0xF4 */ {0xE7, 0xE3, 0x96},
    /* 0xF4 */ {0xE8, 0xE3, 0x97},
    /* 0xF4 */ {0xE9, 0xE3, 0x98},
    /* 0xF4 */ {0xEA, 0xE3, 0x99},
    /* 0xF4 */ {0xEB, 0xE3, 0x9A},
    /* 0xF4 */ {0xEC, 0xE3, 0x9B},
    /* 0xF4 */ {0xED, 0xE3, 0x9C},
    /* 0xF4 */ {0xEE, 0xE3, 0x9D},
    /* 0xF4 */ {0xEF, 0xE3, 0x9E},
    /* 0xF4 */ {0xF0, 0xE3, 0x9F},
    /* 0xF4 */ {0xF1, 0xE3, 0xA0},
    /* 0xF4 */ {0xF2, 0xE3, 0xA1},
    /* 0xF4 */ {0xF3, 0xE3, 0xA2},
    /* 0xF4 */ {0xF4, 0xE3, 0xA3},
    /* 0xF4 */ {0xF5, 0xE3, 0xA4},
    /* 0xF4 */ {0xF6, 0xE3, 0xA5},
    /* 0xF4 */ {0xF7, 0xE3, 0xA6},
    /* 0xF4 */ {0xF8, 0xE3, 0xA7},
    /* 0xF4 */ {0xF9, 0xE3, 0xA8},
    /* 0xF4 */ {0xFA, 0xE3, 0xA9},
    /* 0xF4 */ {0xFB, 0xE3, 0xAA},
    /* 0xF4 */ {0xFC, 0xE3, 0xAB},
    /* 0xF5 */ {0x40, 0xE3, 0xAC},
    /* 0xF5 */ {0x41, 0xE3, 0xAD},
    /* 0xF5 */ {0x42, 0xE3, 0xAE},
    /* 0xF5 */ {0x43, 0xE3, 0xAF},
    /* 0xF5 */ {0x44, 0xE3, 0xB0},
    /* 0xF5 */ {0x45, 0xE3, 0xB1},
    /* 0xF5 */ {0x46, 0xE3, 0xB2},
    /* 0xF5 */ {0x47, 0xE3, 0xB3},
    /* 0xF5 */ {0x48, 0xE3, 0xB4},
    /* 0xF5 */ {0x49, 0xE3, 0xB5},
    /* 0xF5 */ {0x4A, 0xE3, 0xB6},
    /* 0xF5 */ {0x4B, 0xE3, 0xB7},
    /* 0xF5 */ {0x4C, 0xE3, 0xB8},
    /* 0xF5 */ {0x4D, 0xE3, 0xB9},
    /* 0xF5 */ {0x4E, 0xE3, 0xBA},
    /* 0xF5 */ {0x4F, 0xE3, 0xBB},
    /* 0xF5 */ {0x50, 0xE3, 0xBC},
    /* 0xF5 */ {0x51, 0xE3, 0xBD},
    /* 0xF5 */ {0x52, 0xE3, 0xBE},
    /* 0xF5 */ {0x53, 0xE3, 0xBF},
    /* 0xF5 */ {0x54, 0xE3, 0xC0},
    /* 0xF5 */ {0x55, 0xE3, 0xC1},
    /* 0xF5 */ {0x56, 0xE3, 0xC2},
    /* 0xF5 */ {0x57, 0xE3, 0xC3},
    /* 0xF5 */ {0x58, 0xE3, 0xC4},
    /* 0xF5 */ {0x59, 0xE3, 0xC5},
    /* 0xF5 */ {0x5A, 0xE3, 0xC6},
    /* 0xF5 */ {0x5B, 0xE3, 0xC7},
    /* 0xF5 */ {0x5C, 0xE3, 0xC8},
    /* 0xF5 */ {0x5D, 0xE3, 0xC9},
    /* 0xF5 */ {0x5E, 0xE3, 0xCA},
    /* 0xF5 */ {0x5F, 0xE3, 0xCB},
    /* 0xF5 */ {0x60, 0xE3, 0xCC},
    /* 0xF5 */ {0x61, 0xE3, 0xCD},
    /* 0xF5 */ {0x62, 0xE3, 0xCE},
    /* 0xF5 */ {0x63, 0xE3, 0xCF},
    /* 0xF5 */ {0x64, 0xE3, 0xD0},
    /* 0xF5 */ {0x65, 0xE3, 0xD1},
    /* 0xF5 */ {0x66, 0xE3, 0xD2},
    /* 0xF5 */ {0x67, 0xE3, 0xD3},
    /* 0xF5 */ {0x68, 0xE3, 0xD4},
    /* 0xF5 */ {0x69, 0xE3, 0xD5},
    /* 0xF5 */ {0x6A, 0xE3, 0xD6},
    /* 0xF5 */ {0x6B, 0xE3, 0xD7},
    /* 0xF5 */ {0x6C, 0xE3, 0xD8},
    /* 0xF5 */ {0x6D, 0xE3, 0xD9},
    /* 0xF5 */ {0x6E, 0xE3, 0xDA},
    /* 0xF5 */ {0x6F, 0xE3, 0xDB},
    /* 0xF5 */ {0x70, 0xE3, 0xDC},
    /* 0xF5 */ {0x71, 0xE3, 0xDD},
    /* 0xF5 */ {0x72, 0xE3, 0xDE},
    /* 0xF5 */ {0x73, 0xE3, 0xDF},
    /* 0xF5 */ {0x74, 0xE3, 0xE0},
    /* 0xF5 */ {0x75, 0xE3, 0xE1},
    /* 0xF5 */ {0x76, 0xE3, 0xE2},
    /* 0xF5 */ {0x77, 0xE3, 0xE3},
    /* 0xF5 */ {0x78, 0xE3, 0xE4},
    /* 0xF5 */ {0x79, 0xE3, 0xE5},
    /* 0xF5 */ {0x7A, 0xE3, 0xE6},
    /* 0xF5 */ {0x7B, 0xE3, 0xE7},
    /* 0xF5 */ {0x7C, 0xE3, 0xE8},
    /* 0xF5 */ {0x7D, 0xE3, 0xE9},
    /* 0xF5 */ {0x7E, 0xE3, 0xEA},
    /* 0xF5 */ {0x80, 0xE3, 0xEB},
    /* 0xF5 */ {0x81, 0xE3, 0xEC},
    /* 0xF5 */ {0x82, 0xE3, 0xED},
    /* 0xF5 */ {0x83, 0xE3, 0xEE},
    /* 0xF5 */ {0x84, 0xE3, 0xEF},
    /* 0xF5 */ {0x85, 0xE3, 0xF0},
    /* 0xF5 */ {0x86, 0xE3, 0xF1},
    /* 0xF5 */ {0x87, 0xE3, 0xF2},
    /* 0xF5 */ {0x88, 0xE3, 0xF3},
    /* 0xF5 */ {0x89, 0xE3, 0xF4},
    /* 0xF5 */ {0x8A, 0xE3, 0xF5},
    /* 0xF5 */ {0x8B, 0xE3, 0xF6},
    /* 0xF5 */ {0x8C, 0xE3, 0xF7},
    /* 0xF5 */ {0x8D, 0xE3, 0xF8},
    /* 0xF5 */ {0x8E, 0xE3, 0xF9},
    /* 0xF5 */ {0x8F, 0xE3, 0xFA},
    /* 0xF5 */ {0x90, 0xE3, 0xFB},
    /* 0xF5 */ {0x91, 0xE3, 0xFC},
    /* 0xF5 */ {0x92, 0xE3, 0xFD},
    /* 0xF5 */ {0x93, 0xE3, 0xFE},
    /* 0xF5 */ {0x94, 0xE3, 0xFF},
    /* 0xF5 */ {0x95, 0xE4, 0x00},
    /* 0xF5 */ {0x96, 0xE4, 0x01},
    /* 0xF5 */ {0x97, 0xE4, 0x02},
    /* 0xF5 */ {0x98, 0xE4, 0x03},
    /* 0xF5 */ {0x99, 0xE4, 0x04},
    /* 0xF5 */ {0x9A, 0xE4, 0x05},
    /* 0xF5 */ {0x9B, 0xE4, 0x06},
    /* 0xF5 */ {0x9C, 0xE4, 0x07},
    /* 0xF5 */ {0x9D, 0xE4, 0x08},
    /* 0xF5 */ {0x9E, 0xE4, 0x09},
    /* 0xF5 */ {0x9F, 0xE4, 0x0A},
    /* 0xF5 */ {0xA0, 0xE4, 0x0B},
    /* 0xF5 */ {0xA1, 0xE4, 0x0C},
    /* 0xF5 */ {0xA2, 0xE4, 0x0D},
    /* 0xF5 */ {0xA3, 0xE4, 0x0E},
    /* 0xF5 */ {0xA4, 0xE4, 0x0F},
    /* 0xF5 */ {0xA5, 0xE4, 0x10},
    /* 0xF5 */ {0xA6, 0xE4, 0x11},
    /* 0xF5 */ {0xA7, 0xE4, 0x12},
    /* 0xF5 */ {0xA8, 0xE4, 0x13},
    /* 0xF5 */ {0xA9, 0xE4, 0x14},
    /* 0xF5 */ {0xAA, 0xE4, 0x15},
    /* 0xF5 */ {0xAB, 0xE4, 0x16},
    /* 0xF5 */ {0xAC, 0xE4, 0x17},
    /* 0xF5 */ {0xAD, 0xE4, 0x18},
    /* 0xF5 */ {0xAE, 0xE4, 0x19},
    /* 0xF5 */ {0xAF, 0xE4, 0x1A},
    /* 0xF5 */ {0xB0, 0xE4, 0x1B},
    /* 0xF5 */ {0xB1, 0xE4, 0x1C},
    /* 0xF5 */ {0xB2, 0xE4, 0x1D},
    /* 0xF5 */ {0xB3, 0xE4, 0x1E},
    /* 0xF5 */ {0xB4, 0xE4, 0x1F},
    /* 0xF5 */ {0xB5, 0xE4, 0x20},
    /* 0xF5 */ {0xB6, 0xE4, 0x21},
    /* 0xF5 */ {0xB7, 0xE4, 0x22},
    /* 0xF5 */ {0xB8, 0xE4, 0x23},
    /* 0xF5 */ {0xB9, 0xE4, 0x24},
    /* 0xF5 */ {0xBA, 0xE4, 0x25},
    /* 0xF5 */ {0xBB, 0xE4, 0x26},
    /* 0xF5 */ {0xBC, 0xE4, 0x27},
    /* 0xF5 */ {0xBD, 0xE4, 0x28},
    /* 0xF5 */ {0xBE, 0xE4, 0x29},
    /* 0xF5 */ {0xBF, 0xE4, 0x2A},
    /* 0xF5 */ {0xC0, 0xE4, 0x2B},
    /* 0xF5 */ {0xC1, 0xE4, 0x2C},
    /* 0xF5 */ {0xC2, 0xE4, 0x2D},
    /* 0xF5 */ {0xC3, 0xE4, 0x2E},
    /* 0xF5 */ {0xC4, 0xE4, 0x2F},
    /* 0xF5 */ {0xC5, 0xE4, 0x30},
    /* 0xF5 */ {0xC6, 0xE4, 0x31},
    /* 0xF5 */ {0xC7, 0xE4, 0x32},
    /* 0xF5 */ {0xC8, 0xE4, 0x33},
    /* 0xF5 */ {0xC9, 0xE4, 0x34},
    /* 0xF5 */ {0xCA, 0xE4, 0x35},
    /* 0xF5 */ {0xCB, 0xE4, 0x36},
    /* 0xF5 */ {0xCC, 0xE4, 0x37},
    /* 0xF5 */ {0xCD, 0xE4, 0x38},
    /* 0xF5 */ {0xCE, 0xE4, 0x39},
    /* 0xF5 */ {0xCF, 0xE4, 0x3A},
    /* 0xF5 */ {0xD0, 0xE4, 0x3B},
    /* 0xF5 */ {0xD1, 0xE4, 0x3C},
    /* 0xF5 */ {0xD2, 0xE4, 0x3D},
    /* 0xF5 */ {0xD3, 0xE4, 0x3E},
    /* 0xF5 */ {0xD4, 0xE4, 0x3F},
    /* 0xF5 */ {0xD5, 0xE4, 0x40},
    /* 0xF5 */ {0xD6, 0xE4, 0x41},
    /* 0xF5 */ {0xD7, 0xE4, 0x42},
    /* 0xF5 */ {0xD8, 0xE4, 0x43},
    /* 0xF5 */ {0xD9, 0xE4, 0x44},
    /* 0xF5 */ {0xDA, 0xE4, 0x45},
    /* 0xF5 */ {0xDB, 0xE4, 0x46},
    /* 0xF5 */ {0xDC, 0xE4, 0x47},
    /* 0xF5 */ {0xDD, 0xE4, 0x48},
    /* 0xF5 */ {0xDE, 0xE4, 0x49},
    /* 0xF5 */ {0xDF, 0xE4, 0x4A},
    /* 0xF5 */ {0xE0, 0xE4, 0x4B},
    /* 0xF5 */ {0xE1, 0xE4, 0x4C},
    /* 0xF5 */ {0xE2, 0xE4, 0x4D},
    /* 0xF5 */ {0xE3, 0xE4, 0x4E},
    /* 0xF5 */ {0xE4, 0xE4, 0x4F},
    /* 0xF5 */ {0xE5, 0xE4, 0x50},
    /* 0xF5 */ {0xE6, 0xE4, 0x51},
    /* 0xF5 */ {0xE7, 0xE4, 0x52},
    /* 0xF5 */ {0xE8, 0xE4, 0x53},
    /* 0xF5 */ {0xE9, 0xE4, 0x54},
    /* 0xF5 */ {0xEA, 0xE4, 0x55},
    /* 0xF5 */ {0xEB, 0xE4, 0x56},
    /* 0xF5 */ {0xEC, 0xE4, 0x57},
    /* 0xF5 */ {0xED, 0xE4, 0x58},
    /* 0xF5 */ {0xEE, 0xE4, 0x59},
    /* 0xF5 */ {0xEF, 0xE4, 0x5A},
    /* 0xF5 */ {0xF0, 0xE4, 0x5B},
    /* 0xF5 */ {0xF1, 0xE4, 0x5C},
    /* 0xF5 */ {0xF2, 0xE4, 0x5D},
    /* 0xF5 */ {0xF3, 0xE4, 0x5E},
    /* 0xF5 */ {0xF4, 0xE4, 0x5F},
    /* 0xF5 */ {0xF5, 0xE4, 0x60},
    /* 0xF5 */ {0xF6, 0xE4, 0x61},
    /* 0xF5 */ {0xF7, 0xE4, 0x62},
    /* 0xF5 */ {0xF8, 0xE4, 0x63},
    /* 0xF5 */ {0xF9, 0xE4, 0x64},
    /* 0xF5 */ {0xFA, 0xE4, 0x65},
    /* 0xF5 */ {0xFB, 0xE4, 0x66},
    /* 0xF5 */ {0xFC, 0xE4, 0x67},
    /* 0xF6 */ {0x40, 0xE4, 0x68},
    /* 0xF6 */ {0x41, 0xE4, 0x69},
    /* 0xF6 */ {0x42, 0xE4, 0x6A},
    /* 0xF6 */ {0x43, 0xE4, 0x6B},
    /* 0xF6 */ {0x44, 0xE4, 0x6C},
    /* 0xF6 */ {0x45, 0xE4, 0x6D},
    /* 0xF6 */ {0x46, 0xE4, 0x6E},
    /* 0xF6 */ {0x47, 0xE4, 0x6F},
    /* 0xF6 */ {0x48, 0xE4, 0x70},
    /* 0xF6 */ {0x49, 0xE4, 0x71},
    /* 0xF6 */ {0x4A, 0xE4, 0x72},
    /* 0xF6 */ {0x4B, 0xE4, 0x73},
    /* 0xF6 */ {0x4C, 0xE4, 0x74},
    /* 0xF6 */ {0x4D, 0xE4, 0x75},
    /* 0xF6 */ {0x4E, 0xE4, 0x76},
    /* 0xF6 */ {0x4F, 0xE4, 0x77},
    /* 0xF6 */ {0x50, 0xE4, 0x78},
    /* 0xF6 */ {0x51, 0xE4, 0x79},
    /* 0xF6 */ {0x52, 0xE4, 0x7A},
    /* 0xF6 */ {0x53, 0xE4, 0x7B},
    /* 0xF6 */ {0x54, 0xE4, 0x7C},
    /* 0xF6 */ {0x55, 0xE4, 0x7D},
    /* 0xF6 */ {0x56, 0xE4, 0x7E},
    /* 0xF6 */ {0x57, 0xE4, 0x7F},
    /* 0xF6 */ {0x58, 0xE4, 0x80},
    /* 0xF6 */ {0x59, 0xE4, 0x81},
    /* 0xF6 */ {0x5A, 0xE4, 0x82},
    /* 0xF6 */ {0x5B, 0xE4, 0x83},
    /* 0xF6 */ {0x5C, 0xE4, 0x84},
    /* 0xF6 */ {0x5D, 0xE4, 0x85},
    /* 0xF6 */ {0x5E, 0xE4, 0x86},
    /* 0xF6 */ {0x5F, 0xE4, 0x87},
    /* 0xF6 */ {0x60, 0xE4, 0x88},
    /* 0xF6 */ {0x61, 0xE4, 0x89},
    /* 0xF6 */ {0x62, 0xE4, 0x8A},
    /* 0xF6 */ {0x63, 0xE4, 0x8B},
    /* 0xF6 */ {0x64, 0xE4, 0x8C},
    /* 0xF6 */ {0x65, 0xE4, 0x8D},
    /* 0xF6 */ {0x66, 0xE4, 0x8E},
    /* 0xF6 */ {0x67, 0xE4, 0x8F},
    /* 0xF6 */ {0x68, 0xE4, 0x90},
    /* 0xF6 */ {0x69, 0xE4, 0x91},
    /* 0xF6 */ {0x6A, 0xE4, 0x92},
    /* 0xF6 */ {0x6B, 0xE4, 0x93},
    /* 0xF6 */ {0x6C, 0xE4, 0x94},
    /* 0xF6 */ {0x6D, 0xE4, 0x95},
    /* 0xF6 */ {0x6E, 0xE4, 0x96},
    /* 0xF6 */ {0x6F, 0xE4, 0x97},
    /* 0xF6 */ {0x70, 0xE4, 0x98},
    /* 0xF6 */ {0x71, 0xE4, 0x99},
    /* 0xF6 */ {0x72, 0xE4, 0x9A},
    /* 0xF6 */ {0x73, 0xE4, 0x9B},
    /* 0xF6 */ {0x74, 0xE4, 0x9C},
    /* 0xF6 */ {0x75, 0xE4, 0x9D},
    /* 0xF6 */ {0x76, 0xE4, 0x9E},
    /* 0xF6 */ {0x77, 0xE4, 0x9F},
    /* 0xF6 */ {0x78, 0xE4, 0xA0},
    /* 0xF6 */ {0x79, 0xE4, 0xA1},
    /* 0xF6 */ {0x7A, 0xE4, 0xA2},
    /* 0xF6 */ {0x7B, 0xE4, 0xA3},
    /* 0xF6 */ {0x7C, 0xE4, 0xA4},
    /* 0xF6 */ {0x7D, 0xE4, 0xA5},
    /* 0xF6 */ {0x7E, 0xE4, 0xA6},
    /* 0xF6 */ {0x80, 0xE4, 0xA7},
    /* 0xF6 */ {0x81, 0xE4, 0xA8},
    /* 0xF6 */ {0x82, 0xE4, 0xA9},
    /* 0xF6 */ {0x83, 0xE4, 0xAA},
    /* 0xF6 */ {0x84, 0xE4, 0xAB},
    /* 0xF6 */ {0x85, 0xE4, 0xAC},
    /* 0xF6 */ {0x86, 0xE4, 0xAD},
    /* 0xF6 */ {0x87, 0xE4, 0xAE},
    /* 0xF6 */ {0x88, 0xE4, 0xAF},
    /* 0xF6 */ {0x89, 0xE4, 0xB0},
    /* 0xF6 */ {0x8A, 0xE4, 0xB1},
    /* 0xF6 */ {0x8B, 0xE4, 0xB2},
    /* 0xF6 */ {0x8C, 0xE4, 0xB3},
    /* 0xF6 */ {0x8D, 0xE4, 0xB4},
    /* 0xF6 */ {0x8E, 0xE4, 0xB5},
    /* 0xF6 */ {0x8F, 0xE4, 0xB6},
    /* 0xF6 */ {0x90, 0xE4, 0xB7},
    /* 0xF6 */ {0x91, 0xE4, 0xB8},
    /* 0xF6 */ {0x92, 0xE4, 0xB9},
    /* 0xF6 */ {0x93, 0xE4, 0xBA},
    /* 0xF6 */ {0x94, 0xE4, 0xBB},
    /* 0xF6 */ {0x95, 0xE4, 0xBC},
    /* 0xF6 */ {0x96, 0xE4, 0xBD},
    /* 0xF6 */ {0x97, 0xE4, 0xBE},
    /* 0xF6 */ {0x98, 0xE4, 0xBF},
    /* 0xF6 */ {0x99, 0xE4, 0xC0},
    /* 0xF6 */ {0x9A, 0xE4, 0xC1},
    /* 0xF6 */ {0x9B, 0xE4, 0xC2},
    /* 0xF6 */ {0x9C, 0xE4, 0xC3},
    /* 0xF6 */ {0x9D, 0xE4, 0xC4},
    /* 0xF6 */ {0x9E, 0xE4, 0xC5},
    /* 0xF6 */ {0x9F, 0xE4, 0xC6},
    /* 0xF6 */ {0xA0, 0xE4, 0xC7},
    /* 0xF6 */ {0xA1, 0xE4, 0xC8},
    /* 0xF6 */ {0xA2, 0xE4, 0xC9},
    /* 0xF6 */ {0xA3, 0xE4, 0xCA},
    /* 0xF6 */ {0xA4, 0xE4, 0xCB},
    /* 0xF6 */ {0xA5, 0xE4, 0xCC},
    /* 0xF6 */ {0xA6, 0xE4, 0xCD},
    /* 0xF6 */ {0xA7, 0xE4, 0xCE},
    /* 0xF6 */ {0xA8, 0xE4, 0xCF},
    /* 0xF6 */ {0xA9, 0xE4, 0xD0},
    /* 0xF6 */ {0xAA, 0xE4, 0xD1},
    /* 0xF6 */ {0xAB, 0xE4, 0xD2},
    /* 0xF6 */ {0xAC, 0xE4, 0xD3},
    /* 0xF6 */ {0xAD, 0xE4, 0xD4},
    /* 0xF6 */ {0xAE, 0xE4, 0xD5},
    /* 0xF6 */ {0xAF, 0xE4, 0xD6},
    /* 0xF6 */ {0xB0, 0xE4, 0xD7},
    /* 0xF6 */ {0xB1, 0xE4, 0xD8},
    /* 0xF6 */ {0xB2, 0xE4, 0xD9},
    /* 0xF6 */ {0xB3, 0xE4, 0xDA},
    /* 0xF6 */ {0xB4, 0xE4, 0xDB},
    /* 0xF6 */ {0xB5, 0xE4, 0xDC},
    /* 0xF6 */ {0xB6, 0xE4, 0xDD},
    /* 0xF6 */ {0xB7, 0xE4, 0xDE},
    /* 0xF6 */ {0xB8, 0xE4, 0xDF},
    /* 0xF6 */ {0xB9, 0xE4, 0xE0},
    /* 0xF6 */ {0xBA, 0xE4, 0xE1},
    /* 0xF6 */ {0xBB, 0xE4, 0xE2},
    /* 0xF6 */ {0xBC, 0xE4, 0xE3},
    /* 0xF6 */ {0xBD, 0xE4, 0xE4},
    /* 0xF6 */ {0xBE, 0xE4, 0xE5},
    /* 0xF6 */ {0xBF, 0xE4, 0xE6},
    /* 0xF6 */ {0xC0, 0xE4, 0xE7},
    /* 0xF6 */ {0xC1, 0xE4, 0xE8},
    /* 0xF6 */ {0xC2, 0xE4, 0xE9},
    /* 0xF6 */ {0xC3, 0xE4, 0xEA},
    /* 0xF6 */ {0xC4, 0xE4, 0xEB},
    /* 0xF6 */ {0xC5, 0xE4, 0xEC},
    /* 0xF6 */ {0xC6, 0xE4, 0xED},
    /* 0xF6 */ {0xC7, 0xE4, 0xEE},
    /* 0xF6 */ {0xC8, 0xE4, 0xEF},
    /* 0xF6 */ {0xC9, 0xE4, 0xF0},
    /* 0xF6 */ {0xCA, 0xE4, 0xF1},
    /* 0xF6 */ {0xCB, 0xE4, 0xF2},
    /* 0xF6 */ {0xCC, 0xE4, 0xF3},
    /* 0xF6 */ {0xCD, 0xE4, 0xF4},
    /* 0xF6 */ {0xCE, 0xE4, 0xF5},
    /* 0xF6 */ {0xCF, 0xE4, 0xF6},
    /* 0xF6 */ {0xD0, 0xE4, 0xF7},
    /* 0xF6 */ {0xD1, 0xE4, 0xF8},
    /* 0xF6 */ {0xD2, 0xE4, 0xF9},
    /* 0xF6 */ {0xD3, 0xE4, 0xFA},
    /* 0xF6 */ {0xD4, 0xE4, 0xFB},
    /* 0xF6 */ {0xD5, 0xE4, 0xFC},
    /* 0xF6 */ {0xD6, 0xE4, 0xFD},
    /* 0xF6 */ {0xD7, 0xE4, 0xFE},
    /* 0xF6 */ {0xD8, 0xE4, 0xFF},
    /* 0xF6 */ {0xD9, 0xE5, 0x00},
    /* 0xF6 */ {0xDA, 0xE5, 0x01},
    /* 0xF6 */ {0xDB, 0xE5, 0x02},
    /* 0xF6 */ {0xDC, 0xE5, 0x03},
    /* 0xF6 */ {0xDD, 0xE5, 0x04},
    /* 0xF6 */ {0xDE, 0xE5, 0x05},
    /* 0xF6 */ {0xDF, 0xE5, 0x06},
    /* 0xF6 */ {0xE0, 0xE5, 0x07},
    /* 0xF6 */ {0xE1, 0xE5, 0x08},
    /* 0xF6 */ {0xE2, 0xE5, 0x09},
    /* 0xF6 */ {0xE3, 0xE5, 0x0A},
    /* 0xF6 */ {0xE4, 0xE5, 0x0B},
    /* 0xF6 */ {0xE5, 0xE5, 0x0C},
    /* 0xF6 */ {0xE6, 0xE5, 0x0D},
    /* 0xF6 */ {0xE7, 0xE5, 0x0E},
    /* 0xF6 */ {0xE8, 0xE5, 0x0F},
    /* 0xF6 */ {0xE9, 0xE5, 0x10},
    /* 0xF6 */ {0xEA, 0xE5, 0x11},
    /* 0xF6 */ {0xEB, 0xE5, 0x12},
    /* 0xF6 */ {0xEC, 0xE5, 0x13},
    /* 0xF6 */ {0xED, 0xE5, 0x14},
    /* 0xF6 */ {0xEE, 0xE5, 0x15},
    /* 0xF6 */ {0xEF, 0xE5, 0x16},
    /* 0xF6 */ {0xF0, 0xE5, 0x17},
    /* 0xF6 */ {0xF1, 0xE5, 0x18},
    /* 0xF6 */ {0xF2, 0xE5, 0x19},
    /* 0xF6 */ {0xF3, 0xE5, 0x1A},
    /* 0xF6 */ {0xF4, 0xE5, 0x1B},
    /* 0xF6 */ {0xF5, 0xE5, 0x1C},
    /* 0xF6 */ {0xF6, 0xE5, 0x1D},
    /* 0xF6 */ {0xF7, 0xE5, 0x1E},
    /* 0xF6 */ {0xF8, 0xE5, 0x1F},
    /* 0xF6 */ {0xF9, 0xE5, 0x20},
    /* 0xF6 */ {0xFA, 0xE5, 0x21},
    /* 0xF6 */ {0xFB, 0xE5, 0x22},
    /* 0xF6 */ {0xFC, 0xE5, 0x23},
    /* 0xF7 */ {0x40, 0xE5, 0x24},
    /* 0xF7 */ {0x41, 0xE5, 0x25},
    /* 0xF7 */ {0x42, 0xE5, 0x26},
    /* 0xF7 */ {0x43, 0xE5, 0x27},
    /* 0xF7 */ {0x44, 0xE5, 0x28},
    /* 0xF7 */ {0x45, 0xE5, 0x29},
    /* 0xF7 */ {0x46, 0xE5, 0x2A},
    /* 0xF7 */ {0x47, 0xE5, 0x2B},
    /* 0xF7 */ {0x48, 0xE5, 0x2C},
    /* 0xF7 */ {0x49, 0xE5, 0x2D},
    /* 0xF7 */ {0x4A, 0xE5, 0x2E},
    /* 0xF7 */ {0x4B, 0xE5, 0x2F},
    /* 0xF7 */ {0x4C, 0xE5, 0x30},
    /* 0xF7 */ {0x4D, 0xE5, 0x31},
    /* 0xF7 */ {0x4E, 0xE5, 0x32},
    /* 0xF7 */ {0x4F, 0xE5, 0x33},
    /* 0xF7 */ {0x50, 0xE5, 0x34},
    /* 0xF7 */ {0x51, 0xE5, 0x35},
    /* 0xF7 */ {0x52, 0xE5, 0x36},
    /* 0xF7 */ {0x53, 0xE5, 0x37},
    /* 0xF7 */ {0x54, 0xE5, 0x38},
    /* 0xF7 */ {0x55, 0xE5, 0x39},
    /* 0xF7 */ {0x56, 0xE5, 0x3A},
    /* 0xF7 */ {0x57, 0xE5, 0x3B},
    /* 0xF7 */ {0x58, 0xE5, 0x3C},
    /* 0xF7 */ {0x59, 0xE5, 0x3D},
    /* 0xF7 */ {0x5A, 0xE5, 0x3E},
    /* 0xF7 */ {0x5B, 0xE5, 0x3F},
    /* 0xF7 */ {0x5C, 0xE5, 0x40},
    /* 0xF7 */ {0x5D, 0xE5, 0x41},
    /* 0xF7 */ {0x5E, 0xE5, 0x42},
    /* 0xF7 */ {0x5F, 0xE5, 0x43},
    /* 0xF7 */ {0x60, 0xE5, 0x44},
    /* 0xF7 */ {0x61, 0xE5, 0x45},
    /* 0xF7 */ {0x62, 0xE5, 0x46},
    /* 0xF7 */ {0x63, 0xE5, 0x47},
    /* 0xF7 */ {0x64, 0xE5, 0x48},
    /* 0xF7 */ {0x65, 0xE5, 0x49},
    /* 0xF7 */ {0x66, 0xE5, 0x4A},
    /* 0xF7 */ {0x67, 0xE5, 0x4B},
    /* 0xF7 */ {0x68, 0xE5, 0x4C},
    /* 0xF7 */ {0x69, 0xE5, 0x4D},
    /* 0xF7 */ {0x6A, 0xE5, 0x4E},
    /* 0xF7 */ {0x6B, 0xE5, 0x4F},
    /* 0xF7 */ {0x6C, 0xE5, 0x50},
    /* 0xF7 */ {0x6D, 0xE5, 0x51},
    /* 0xF7 */ {0x6E, 0xE5, 0x52},
    /* 0xF7 */ {0x6F, 0xE5, 0x53},
    /* 0xF7 */ {0x70, 0xE5, 0x54},
    /* 0xF7 */ {0x71, 0xE5, 0x55},
    /* 0xF7 */ {0x72, 0xE5, 0x56},
    /* 0xF7 */ {0x73, 0xE5, 0x57},
    /* 0xF7 */ {0x74, 0xE5, 0x58},
    /* 0xF7 */ {0x75, 0xE5, 0x59},
    /* 0xF7 */ {0x76, 0xE5, 0x5A},
    /* 0xF7 */ {0x77, 0xE5, 0x5B},
    /* 0xF7 */ {0x78, 0xE5, 0x5C},
    /* 0xF7 */ {0x79, 0xE5, 0x5D},
    /* 0xF7 */ {0x7A, 0xE5, 0x5E},
    /* 0xF7 */ {0x7B, 0xE5, 0x5F},
    /* 0xF7 */ {0x7C, 0xE5, 0x60},
    /* 0xF7 */ {0x7D, 0xE5, 0x61},
    /* 0xF7 */ {0x7E, 0xE5, 0x62},
    /* 0xF7 */ {0x80, 0xE5, 0x63},
    /* 0xF7 */ {0x81, 0xE5, 0x64},
    /* 0xF7 */ {0x82, 0xE5, 0x65},
    /* 0xF7 */ {0x83, 0xE5, 0x66},
    /* 0xF7 */ {0x84, 0xE5, 0x67},
    /* 0xF7 */ {0x85, 0xE5, 0x68},
    /* 0xF7 */ {0x86, 0xE5, 0x69},
    /* 0xF7 */ {0x87, 0xE5, 0x6A},
    /* 0xF7 */ {0x88, 0xE5, 0x6B},
    /* 0xF7 */ {0x89, 0xE5, 0x6C},
    /* 0xF7 */ {0x8A, 0xE5, 0x6D},
    /* 0xF7 */ {0x8B, 0xE5, 0x6E},
    /* 0xF7 */ {0x8C, 0xE5, 0x6F},
    /* 0xF7 */ {0x8D, 0xE5, 0x70},
    /* 0xF7 */ {0x8E, 0xE5, 0x71},
    /* 0xF7 */ {0x8F, 0xE5, 0x72},
    /* 0xF7 */ {0x90, 0xE5, 0x73},
    /* 0xF7 */ {0x91, 0xE5, 0x74},
    /* 0xF7 */ {0x92, 0xE5, 0x75},
    /* 0xF7 */ {0x93, 0xE5, 0x76},
    /* 0xF7 */ {0x94, 0xE5, 0x77},
    /* 0xF7 */ {0x95, 0xE5, 0x78},
    /* 0xF7 */ {0x96, 0xE5, 0x79},
    /* 0xF7 */ {0x97, 0xE5, 0x7A},
    /* 0xF7 */ {0x98, 0xE5, 0x7B},
    /* 0xF7 */ {0x99, 0xE5, 0x7C},
    /* 0xF7 */ {0x9A, 0xE5, 0x7D},
    /* 0xF7 */ {0x9B, 0xE5, 0x7E},
    /* 0xF7 */ {0x9C, 0xE5, 0x7F},
    /* 0xF7 */ {0x9D, 0xE5, 0x80},
    /* 0xF7 */ {0x9E, 0xE5, 0x81},
    /* 0xF7 */ {0x9F, 0xE5, 0x82},
    /* 0xF7 */ {0xA0, 0xE5, 0x83},
    /* 0xF7 */ {0xA1, 0xE5, 0x84},
    /* 0xF7 */ {0xA2, 0xE5, 0x85},
    /* 0xF7 */ {0xA3, 0xE5, 0x86},
    /* 0xF7 */ {0xA4, 0xE5, 0x87},
    /* 0xF7 */ {0xA5, 0xE5, 0x88},
    /* 0xF7 */ {0xA6, 0xE5, 0x89},
    /* 0xF7 */ {0xA7, 0xE5, 0x8A},
    /* 0xF7 */ {0xA8, 0xE5, 0x8B},
    /* 0xF7 */ {0xA9, 0xE5, 0x8C},
    /* 0xF7 */ {0xAA, 0xE5, 0x8D},
    /* 0xF7 */ {0xAB, 0xE5, 0x8E},
    /* 0xF7 */ {0xAC, 0xE5, 0x8F},
    /* 0xF7 */ {0xAD, 0xE5, 0x90},
    /* 0xF7 */ {0xAE, 0xE5, 0x91},
    /* 0xF7 */ {0xAF, 0xE5, 0x92},
    /* 0xF7 */ {0xB0, 0xE5, 0x93},
    /* 0xF7 */ {0xB1, 0xE5, 0x94},
    /* 0xF7 */ {0xB2, 0xE5, 0x95},
    /* 0xF7 */ {0xB3, 0xE5, 0x96},
    /* 0xF7 */ {0xB4, 0xE5, 0x97},
    /* 0xF7 */ {0xB5, 0xE5, 0x98},
    /* 0xF7 */ {0xB6, 0xE5, 0x99},
    /* 0xF7 */ {0xB7, 0xE5, 0x9A},
    /* 0xF7 */ {0xB8, 0xE5, 0x9B},
    /* 0xF7 */ {0xB9, 0xE5, 0x9C},
    /* 0xF7 */ {0xBA, 0xE5, 0x9D},
    /* 0xF7 */ {0xBB, 0xE5, 0x9E},
    /* 0xF7 */ {0xBC, 0xE5, 0x9F},
    /* 0xF7 */ {0xBD, 0xE5, 0xA0},
    /* 0xF7 */ {0xBE, 0xE5, 0xA1},
    /* 0xF7 */ {0xBF, 0xE5, 0xA2},
    /* 0xF7 */ {0xC0, 0xE5, 0xA3},
    /* 0xF7 */ {0xC1, 0xE5, 0xA4},
    /* 0xF7 */ {0xC2, 0xE5, 0xA5},
    /* 0xF7 */ {0xC3, 0xE5, 0xA6},
    /* 0xF7 */ {0xC4, 0xE5, 0xA7},
    /* 0xF7 */ {0xC5, 0xE5, 0xA8},
    /* 0xF7 */ {0xC6, 0xE5, 0xA9},
    /* 0xF7 */ {0xC7, 0xE5, 0xAA},
    /* 0xF7 */ {0xC8, 0xE5, 0xAB},
    /* 0xF7 */ {0xC9, 0xE5, 0xAC},
    /* 0xF7 */ {0xCA, 0xE5, 0xAD},
    /* 0xF7 */ {0xCB, 0xE5, 0xAE},
    /* 0xF7 */ {0xCC, 0xE5, 0xAF},
    /* 0xF7 */ {0xCD, 0xE5, 0xB0},
    /* 0xF7 */ {0xCE, 0xE5, 0xB1},
    /* 0xF7 */ {0xCF, 0xE5, 0xB2},
    /* 0xF7 */ {0xD0, 0xE5, 0xB3},
    /* 0xF7 */ {0xD1, 0xE5, 0xB4},
    /* 0xF7 */ {0xD2, 0xE5, 0xB5},
    /* 0xF7 */ {0xD3, 0xE5, 0xB6},
    /* 0xF7 */ {0xD4, 0xE5, 0xB7},
    /* 0xF7 */ {0xD5, 0xE5, 0xB8},
    /* 0xF7 */ {0xD6, 0xE5, 0xB9},
    /* 0xF7 */ {0xD7, 0xE5, 0xBA},
    /* 0xF7 */ {0xD8, 0xE5, 0xBB},
    /* 0xF7 */ {0xD9, 0xE5, 0xBC},
    /* 0xF7 */ {0xDA, 0xE5, 0xBD},
    /* 0xF7 */ {0xDB, 0xE5, 0xBE},
    /* 0xF7 */ {0xDC, 0xE5, 0xBF},
    /* 0xF7 */ {0xDD, 0xE5, 0xC0},
    /* 0xF7 */ {0xDE, 0xE5, 0xC1},
    /* 0xF7 */ {0xDF, 0xE5, 0xC2},
    /* 0xF7 */ {0xE0, 0xE5, 0xC3},
    /* 0xF7 */ {0xE1, 0xE5, 0xC4},
    /* 0xF7 */ {0xE2, 0xE5, 0xC5},
    /* 0xF7 */ {0xE3, 0xE5, 0xC6},
    /* 0xF7 */ {0xE4, 0xE5, 0xC7},
    /* 0xF7 */ {0xE5, 0xE5, 0xC8},
    /* 0xF7 */ {0xE6, 0xE5, 0xC9},
    /* 0xF7 */ {0xE7, 0xE5, 0xCA},
    /* 0xF7 */ {0xE8, 0xE5, 0xCB},
    /* 0xF7 */ {0xE9, 0xE5, 0xCC},
    /* 0xF7 */ {0xEA, 0xE5, 0xCD},
    /* 0xF7 */ {0xEB, 0xE5, 0xCE},
    /* 0xF7 */ {0xEC, 0xE5, 0xCF},
    /* 0xF7 */ {0xED, 0xE5, 0xD0},
    /* 0xF7 */ {0xEE, 0xE5, 0xD1},
    /* 0xF7 */ {0xEF, 0xE5, 0xD2},
    /* 0xF7 */ {0xF0, 0xE5, 0xD3},
    /* 0xF7 */ {0xF1, 0xE5, 0xD4},
    /* 0xF7 */ {0xF2, 0xE5, 0xD5},
    /* 0xF7 */ {0xF3, 0xE5, 0xD6},
    /* 0xF7 */ {0xF4, 0xE5, 0xD7},
    /* 0xF7 */ {0xF5, 0xE5, 0xD8},
    /* 0xF7 */ {0xF6, 0xE5, 0xD9},
    /* 0xF7 */ {0xF7, 0xE5, 0xDA},
    /* 0xF7 */ {0xF8, 0xE5, 0xDB},
    /* 0xF7 */ {0xF9, 0xE5, 0xDC},
    /* 0xF7 */ {0xFA, 0xE5, 0xDD},
    /* 0xF7 */ {0xFB, 0xE5, 0xDE},
    /* 0xF7 */ {0xFC, 0xE5, 0xDF},
    /* 0xF8 */ {0x40, 0xE5, 0xE0},
    /* 0xF8 */ {0x41, 0xE5, 0xE1},
    /* 0xF8 */ {0x42, 0xE5, 0xE2},
    /* 0xF8 */ {0x43, 0xE5, 0xE3},
    /* 0xF8 */ {0x44, 0xE5, 0xE4},
    /* 0xF8 */ {0x45, 0xE5, 0xE5},
    /* 0xF8 */ {0x46, 0xE5, 0xE6},
    /* 0xF8 */ {0x47, 0xE5, 0xE7},
    /* 0xF8 */ {0x48, 0xE5, 0xE8},
    /* 0xF8 */ {0x49, 0xE5, 0xE9},
    /* 0xF8 */ {0x4A, 0xE5, 0xEA},
    /* 0xF8 */ {0x4B, 0xE5, 0xEB},
    /* 0xF8 */ {0x4C, 0xE5, 0xEC},
    /* 0xF8 */ {0x4D, 0xE5, 0xED},
    /* 0xF8 */ {0x4E, 0xE5, 0xEE},
    /* 0xF8 */ {0x4F, 0xE5, 0xEF},
    /* 0xF8 */ {0x50, 0xE5, 0xF0},
    /* 0xF8 */ {0x51, 0xE5, 0xF1},
    /* 0xF8 */ {0x52, 0xE5, 0xF2},
    /* 0xF8 */ {0x53, 0xE5, 0xF3},
    /* 0xF8 */ {0x54, 0xE5, 0xF4},
    /* 0xF8 */ {0x55, 0xE5, 0xF5},
    /* 0xF8 */ {0x56, 0xE5, 0xF6},
    /* 0xF8 */ {0x57, 0xE5, 0xF7},
    /* 0xF8 */ {0x58, 0xE5, 0xF8},
    /* 0xF8 */ {0x59, 0xE5, 0xF9},
    /* 0xF8 */ {0x5A, 0xE5, 0xFA},
    /* 0xF8 */ {0x5B, 0xE5, 0xFB},
    /* 0xF8 */ {0x5C, 0xE5, 0xFC},
    /* 0xF8 */ {0x5D, 0xE5, 0xFD},
    /* 0xF8 */ {0x5E, 0xE5, 0xFE},
    /* 0xF8 */ {0x5F, 0xE5, 0xFF},
    /* 0xF8 */ {0x60, 0xE6, 0x00},
    /* 0xF8 */ {0x61, 0xE6, 0x01},
    /* 0xF8 */ {0x62, 0xE6, 0x02},
    /* 0xF8 */ {0x63, 0xE6, 0x03},
    /* 0xF8 */ {0x64, 0xE6, 0x04},
    /* 0xF8 */ {0x65, 0xE6, 0x05},
    /* 0xF8 */ {0x66, 0xE6, 0x06},
    /* 0xF8 */ {0x67, 0xE6, 0x07},
    /* 0xF8 */ {0x68, 0xE6, 0x08},
    /* 0xF8 */ {0x69, 0xE6, 0x09},
    /* 0xF8 */ {0x6A, 0xE6, 0x0A},
    /* 0xF8 */ {0x6B, 0xE6, 0x0B},
    /* 0xF8 */ {0x6C, 0xE6, 0x0C},
    /* 0xF8 */ {0x6D, 0xE6, 0x0D},
    /* 0xF8 */ {0x6E, 0xE6, 0x0E},
    /* 0xF8 */ {0x6F, 0xE6, 0x0F},
    /* 0xF8 */ {0x70, 0xE6, 0x10},
    /* 0xF8 */ {0x71, 0xE6, 0x11},
    /* 0xF8 */ {0x72, 0xE6, 0x12},
    /* 0xF8 */ {0x73, 0xE6, 0x13},
    /* 0xF8 */ {0x74, 0xE6, 0x14},
    /* 0xF8 */ {0x75, 0xE6, 0x15},
    /* 0xF8 */ {0x76, 0xE6, 0x16},
    /* 0xF8 */ {0x77, 0xE6, 0x17},
    /* 0xF8 */ {0x78, 0xE6, 0x18},
    /* 0xF8 */ {0x79, 0xE6, 0x19},
    /* 0xF8 */ {0x7A, 0xE6, 0x1A},
    /* 0xF8 */ {0x7B, 0xE6, 0x1B},
    /* 0xF8 */ {0x7C, 0xE6, 0x1C},
    /* 0xF8 */ {0x7D, 0xE6, 0x1D},
    /* 0xF8 */ {0x7E, 0xE6, 0x1E},
    /* 0xF8 */ {0x80, 0xE6, 0x1F},
    /* 0xF8 */ {0x81, 0xE6, 0x20},
    /* 0xF8 */ {0x82, 0xE6, 0x21},
    /* 0xF8 */ {0x83, 0xE6, 0x22},
    /* 0xF8 */ {0x84, 0xE6, 0x23},
    /* 0xF8 */ {0x85, 0xE6, 0x24},
    /* 0xF8 */ {0x86, 0xE6, 0x25},
    /* 0xF8 */ {0x87, 0xE6, 0x26},
    /* 0xF8 */ {0x88, 0xE6, 0x27},
    /* 0xF8 */ {0x89, 0xE6, 0x28},
    /* 0xF8 */ {0x8A, 0xE6, 0x29},
    /* 0xF8 */ {0x8B, 0xE6, 0x2A},
    /* 0xF8 */ {0x8C, 0xE6, 0x2B},
    /* 0xF8 */ {0x8D, 0xE6, 0x2C},
    /* 0xF8 */ {0x8E, 0xE6, 0x2D},
    /* 0xF8 */ {0x8F, 0xE6, 0x2E},
    /* 0xF8 */ {0x90, 0xE6, 0x2F},
    /* 0xF8 */ {0x91, 0xE6, 0x30},
    /* 0xF8 */ {0x92, 0xE6, 0x31},
    /* 0xF8 */ {0x93, 0xE6, 0x32},
    /* 0xF8 */ {0x94, 0xE6, 0x33},
    /* 0xF8 */ {0x95, 0xE6, 0x34},
    /* 0xF8 */ {0x96, 0xE6, 0x35},
    /* 0xF8 */ {0x97, 0xE6, 0x36},
    /* 0xF8 */ {0x98, 0xE6, 0x37},
    /* 0xF8 */ {0x99, 0xE6, 0x38},
    /* 0xF8 */ {0x9A, 0xE6, 0x39},
    /* 0xF8 */ {0x9B, 0xE6, 0x3A},
    /* 0xF8 */ {0x9C, 0xE6, 0x3B},
    /* 0xF8 */ {0x9D, 0xE6, 0x3C},
    /* 0xF8 */ {0x9E, 0xE6, 0x3D},
    /* 0xF8 */ {0x9F, 0xE6, 0x3E},
    /* 0xF8 */ {0xA0, 0xE6, 0x3F},
    /* 0xF8 */ {0xA1, 0xE6, 0x40},
    /* 0xF8 */ {0xA2, 0xE6, 0x41},
    /* 0xF8 */ {0xA3, 0xE6, 0x42},
    /* 0xF8 */ {0xA4, 0xE6, 0x43},
    /* 0xF8 */ {0xA5, 0xE6, 0x44},
    /* 0xF8 */ {0xA6, 0xE6, 0x45},
    /* 0xF8 */ {0xA7, 0xE6, 0x46},
    /* 0xF8 */ {0xA8, 0xE6, 0x47},
    /* 0xF8 */ {0xA9, 0xE6, 0x48},
    /* 0xF8 */ {0xAA, 0xE6, 0x49},
    /* 0xF8 */ {0xAB, 0xE6, 0x4A},
    /* 0xF8 */ {0xAC, 0xE6, 0x4B},
    /* 0xF8 */ {0xAD, 0xE6, 0x4C},
    /* 0xF8 */ {0xAE, 0xE6, 0x4D},
    /* 0xF8 */ {0xAF, 0xE6, 0x4E},
    /* 0xF8 */ {0xB0, 0xE6, 0x4F},
    /* 0xF8 */ {0xB1, 0xE6, 0x50},
    /* 0xF8 */ {0xB2, 0xE6, 0x51},
    /* 0xF8 */ {0xB3, 0xE6, 0x52},
    /* 0xF8 */ {0xB4, 0xE6, 0x53},
    /* 0xF8 */ {0xB5, 0xE6, 0x54},
    /* 0xF8 */ {0xB6, 0xE6, 0x55},
    /* 0xF8 */ {0xB7, 0xE6, 0x56},
    /* 0xF8 */ {0xB8, 0xE6, 0x57},
    /* 0xF8 */ {0xB9, 0xE6, 0x58},
    /* 0xF8 */ {0xBA, 0xE6, 0x59},
    /* 0xF8 */ {0xBB, 0xE6, 0x5A},
    /* 0xF8 */ {0xBC, 0xE6, 0x5B},
    /* 0xF8 */ {0xBD, 0xE6, 0x5C},
    /* 0xF8 */ {0xBE, 0xE6, 0x5D},
    /* 0xF8 */ {0xBF, 0xE6, 0x5E},
    /* 0xF8 */ {0xC0, 0xE6, 0x5F},
    /* 0xF8 */ {0xC1, 0xE6, 0x60},
    /* 0xF8 */ {0xC2, 0xE6, 0x61},
    /* 0xF8 */ {0xC3, 0xE6, 0x62},
    /* 0xF8 */ {0xC4, 0xE6, 0x63},
    /* 0xF8 */ {0xC5, 0xE6, 0x64},
    /* 0xF8 */ {0xC6, 0xE6, 0x65},
    /* 0xF8 */ {0xC7, 0xE6, 0x66},
    /* 0xF8 */ {0xC8, 0xE6, 0x67},
    /* 0xF8 */ {0xC9, 0xE6, 0x68},
    /* 0xF8 */ {0xCA, 0xE6, 0x69},
    /* 0xF8 */ {0xCB, 0xE6, 0x6A},
    /* 0xF8 */ {0xCC, 0xE6, 0x6B},
    /* 0xF8 */ {0xCD, 0xE6, 0x6C},
    /* 0xF8 */ {0xCE, 0xE6, 0x6D},
    /* 0xF8 */ {0xCF, 0xE6, 0x6E},
    /* 0xF8 */ {0xD0, 0xE6, 0x6F},
    /* 0xF8 */ {0xD1, 0xE6, 0x70},
    /* 0xF8 */ {0xD2, 0xE6, 0x71},
    /* 0xF8 */ {0xD3, 0xE6, 0x72},
    /* 0xF8 */ {0xD4, 0xE6, 0x73},
    /* 0xF8 */ {0xD5, 0xE6, 0x74},
    /* 0xF8 */ {0xD6, 0xE6, 0x75},
    /* 0xF8 */ {0xD7, 0xE6, 0x76},
    /* 0xF8 */ {0xD8, 0xE6, 0x77},
    /* 0xF8 */ {0xD9, 0xE6, 0x78},
    /* 0xF8 */ {0xDA, 0xE6, 0x79},
    /* 0xF8 */ {0xDB, 0xE6, 0x7A},
    /* 0xF8 */ {0xDC, 0xE6, 0x7B},
    /* 0xF8 */ {0xDD, 0xE6, 0x7C},
    /* 0xF8 */ {0xDE, 0xE6, 0x7D},
    /* 0xF8 */ {0xDF, 0xE6, 0x7E},
    /* 0xF8 */ {0xE0, 0xE6, 0x7F},
    /* 0xF8 */ {0xE1, 0xE6, 0x80},
    /* 0xF8 */ {0xE2, 0xE6, 0x81},
    /* 0xF8 */ {0xE3, 0xE6, 0x82},
    /* 0xF8 */ {0xE4, 0xE6, 0x83},
    /* 0xF8 */ {0xE5, 0xE6, 0x84},
    /* 0xF8 */ {0xE6, 0xE6, 0x85},
    /* 0xF8 */ {0xE7, 0xE6, 0x86},
    /* 0xF8 */ {0xE8, 0xE6, 0x87},
    /* 0xF8 */ {0xE9, 0xE6, 0x88},
    /* 0xF8 */ {0xEA, 0xE6, 0x89},
    /* 0xF8 */ {0xEB, 0xE6, 0x8A},
    /* 0xF8 */ {0xEC, 0xE6, 0x8B},
    /* 0xF8 */ {0xED, 0xE6, 0x8C},
    /* 0xF8 */ {0xEE, 0xE6, 0x8D},
    /* 0xF8 */ {0xEF, 0xE6, 0x8E},
    /* 0xF8 */ {0xF0, 0xE6, 0x8F},
    /* 0xF8 */ {0xF1, 0xE6, 0x90},
    /* 0xF8 */ {0xF2, 0xE6, 0x91},
    /* 0xF8 */ {0xF3, 0xE6, 0x92},
    /* 0xF8 */ {0xF4, 0xE6, 0x93},
    /* 0xF8 */ {0xF5, 0xE6, 0x94},
    /* 0xF8 */ {0xF6, 0xE6, 0x95},
    /* 0xF8 */ {0xF7, 0xE6, 0x96},
    /* 0xF8 */ {0xF8, 0xE6, 0x97},
    /* 0xF8 */ {0xF9, 0xE6, 0x98},
    /* 0xF8 */ {0xFA, 0xE6, 0x99},
    /* 0xF8 */ {0xFB, 0xE6, 0x9A},
    /* 0xF8 */ {0xFC, 0xE6, 0x9B},
    /* 0xF9 */ {0x40, 0xE6, 0x9C},
    /* 0xF9 */ {0x41, 0xE6, 0x9D},
    /* 0xF9 */ {0x42, 0xE6, 0x9E},
    /* 0xF9 */ {0x43, 0xE6, 0x9F},
    /* 0xF9 */ {0x44, 0xE6, 0xA0},
    /* 0xF9 */ {0x45, 0xE6, 0xA1},
    /* 0xF9 */ {0x46, 0xE6, 0xA2},
    /* 0xF9 */ {0x47, 0xE6, 0xA3},
    /* 0xF9 */ {0x48, 0xE6, 0xA4},
    /* 0xF9 */ {0x49, 0xE6, 0xA5},
    /* 0xF9 */ {0x4A, 0xE6, 0xA6},
    /* 0xF9 */ {0x4B, 0xE6, 0xA7},
    /* 0xF9 */ {0x4C, 0xE6, 0xA8},
    /* 0xF9 */ {0x4D, 0xE6, 0xA9},
    /* 0xF9 */ {0x4E, 0xE6, 0xAA},
    /* 0xF9 */ {0x4F, 0xE6, 0xAB},
    /* 0xF9 */ {0x50, 0xE6, 0xAC},
    /* 0xF9 */ {0x51, 0xE6, 0xAD},
    /* 0xF9 */ {0x52, 0xE6, 0xAE},
    /* 0xF9 */ {0x53, 0xE6, 0xAF},
    /* 0xF9 */ {0x54, 0xE6, 0xB0},
    /* 0xF9 */ {0x55, 0xE6, 0xB1},
    /* 0xF9 */ {0x56, 0xE6, 0xB2},
    /* 0xF9 */ {0x57, 0xE6, 0xB3},
    /* 0xF9 */ {0x58, 0xE6, 0xB4},
    /* 0xF9 */ {0x59, 0xE6, 0xB5},
    /* 0xF9 */ {0x5A, 0xE6, 0xB6},
    /* 0xF9 */ {0x5B, 0xE6, 0xB7},
    /* 0xF9 */ {0x5C, 0xE6, 0xB8},
    /* 0xF9 */ {0x5D, 0xE6, 0xB9},
    /* 0xF9 */ {0x5E, 0xE6, 0xBA},
    /* 0xF9 */ {0x5F, 0xE6, 0xBB},
    /* 0xF9 */ {0x60, 0xE6, 0xBC},
    /* 0xF9 */ {0x61, 0xE6, 0xBD},
    /* 0xF9 */ {0x62, 0xE6, 0xBE},
    /* 0xF9 */ {0x63, 0xE6, 0xBF},
    /* 0xF9 */ {0x64, 0xE6, 0xC0},
    /* 0xF9 */ {0x65, 0xE6, 0xC1},
    /* 0xF9 */ {0x66, 0xE6, 0xC2},
    /* 0xF9 */ {0x67, 0xE6, 0xC3},
    /* 0xF9 */ {0x68, 0xE6, 0xC4},
    /* 0xF9 */ {0x69, 0xE6, 0xC5},
    /* 0xF9 */ {0x6A, 0xE6, 0xC6},
    /* 0xF9 */ {0x6B, 0xE6, 0xC7},
    /* 0xF9 */ {0x6C, 0xE6, 0xC8},
    /* 0xF9 */ {0x6D, 0xE6, 0xC9},
    /* 0xF9 */ {0x6E, 0xE6, 0xCA},
    /* 0xF9 */ {0x6F, 0xE6, 0xCB},
    /* 0xF9 */ {0x70, 0xE6, 0xCC},
    /* 0xF9 */ {0x71, 0xE6, 0xCD},
    /* 0xF9 */ {0x72, 0xE6, 0xCE},
    /* 0xF9 */ {0x73, 0xE6, 0xCF},
    /* 0xF9 */ {0x74, 0xE6, 0xD0},
    /* 0xF9 */ {0x75, 0xE6, 0xD1},
    /* 0xF9 */ {0x76, 0xE6, 0xD2},
    /* 0xF9 */ {0x77, 0xE6, 0xD3},
    /* 0xF9 */ {0x78, 0xE6, 0xD4},
    /* 0xF9 */ {0x79, 0xE6, 0xD5},
    /* 0xF9 */ {0x7A, 0xE6, 0xD6},
    /* 0xF9 */ {0x7B, 0xE6, 0xD7},
    /* 0xF9 */ {0x7C, 0xE6, 0xD8},
    /* 0xF9 */ {0x7D, 0xE6, 0xD9},
    /* 0xF9 */ {0x7E, 0xE6, 0xDA},
    /* 0xF9 */ {0x80, 0xE6, 0xDB},
    /* 0xF9 */ {0x81, 0xE6, 0xDC},
    /* 0xF9 */ {0x82, 0xE6, 0xDD},
    /* 0xF9 */ {0x83, 0xE6, 0xDE},
    /* 0xF9 */ {0x84, 0xE6, 0xDF},
    /* 0xF9 */ {0x85, 0xE6, 0xE0},
    /* 0xF9 */ {0x86, 0xE6, 0xE1},
    /* 0xF9 */ {0x87, 0xE6, 0xE2},
    /* 0xF9 */ {0x88, 0xE6, 0xE3},
    /* 0xF9 */ {0x89, 0xE6, 0xE4},
    /* 0xF9 */ {0x8A, 0xE6, 0xE5},
    /* 0xF9 */ {0x8B, 0xE6, 0xE6},
    /* 0xF9 */ {0x8C, 0xE6, 0xE7},
    /* 0xF9 */ {0x8D, 0xE6, 0xE8},
    /* 0xF9 */ {0x8E, 0xE6, 0xE9},
    /* 0xF9 */ {0x8F, 0xE6, 0xEA},
    /* 0xF9 */ {0x90, 0xE6, 0xEB},
    /* 0xF9 */ {0x91, 0xE6, 0xEC},
    /* 0xF9 */ {0x92, 0xE6, 0xED},
    /* 0xF9 */ {0x93, 0xE6, 0xEE},
    /* 0xF9 */ {0x94, 0xE6, 0xEF},
    /* 0xF9 */ {0x95, 0xE6, 0xF0},
    /* 0xF9 */ {0x96, 0xE6, 0xF1},
    /* 0xF9 */ {0x97, 0xE6, 0xF2},
    /* 0xF9 */ {0x98, 0xE6, 0xF3},
    /* 0xF9 */ {0x99, 0xE6, 0xF4},
    /* 0xF9 */ {0x9A, 0xE6, 0xF5},
    /* 0xF9 */ {0x9B, 0xE6, 0xF6},
    /* 0xF9 */ {0x9C, 0xE6, 0xF7},
    /* 0xF9 */ {0x9D, 0xE6, 0xF8},
    /* 0xF9 */ {0x9E, 0xE6, 0xF9},
    /* 0xF9 */ {0x9F, 0xE6, 0xFA},
    /* 0xF9 */ {0xA0, 0xE6, 0xFB},
    /* 0xF9 */ {0xA1, 0xE6, 0xFC},
    /* 0xF9 */ {0xA2, 0xE6, 0xFD},
    /* 0xF9 */ {0xA3, 0xE6, 0xFE},
    /* 0xF9 */ {0xA4, 0xE6, 0xFF},
    /* 0xF9 */ {0xA5, 0xE7, 0x00},
    /* 0xF9 */ {0xA6, 0xE7, 0x01},
    /* 0xF9 */ {0xA7, 0xE7, 0x02},
    /* 0xF9 */ {0xA8, 0xE7, 0x03},
    /* 0xF9 */ {0xA9, 0xE7, 0x04},
    /* 0xF9 */ {0xAA, 0xE7, 0x05},
    /* 0xF9 */ {0xAB, 0xE7, 0x06},
    /* 0xF9 */ {0xAC, 0xE7, 0x07},
    /* 0xF9 */ {0xAD, 0xE7, 0x08},
    /* 0xF9 */ {0xAE, 0xE7, 0x09},
    /* 0xF9 */ {0xAF, 0xE7, 0x0A},
    /* 0xF9 */ {0xB0, 0xE7, 0x0B},
    /* 0xF9 */ {0xB1, 0xE7, 0x0C},
    /* 0xF9 */ {0xB2, 0xE7, 0x0D},
    /* 0xF9 */ {0xB3, 0xE7, 0x0E},
    /* 0xF9 */ {0xB4, 0xE7, 0x0F},
    /* 0xF9 */ {0xB5, 0xE7, 0x10},
    /* 0xF9 */ {0xB6, 0xE7, 0x11},
    /* 0xF9 */ {0xB7, 0xE7, 0x12},
    /* 0xF9 */ {0xB8, 0xE7, 0x13},
    /* 0xF9 */ {0xB9, 0xE7, 0x14},
    /* 0xF9 */ {0xBA, 0xE7, 0x15},
    /* 0xF9 */ {0xBB, 0xE7, 0x16},
    /* 0xF9 */ {0xBC, 0xE7, 0x17},
    /* 0xF9 */ {0xBD, 0xE7, 0x18},
    /* 0xF9 */ {0xBE, 0xE7, 0x19},
    /* 0xF9 */ {0xBF, 0xE7, 0x1A},
    /* 0xF9 */ {0xC0, 0xE7, 0x1B},
    /* 0xF9 */ {0xC1, 0xE7, 0x1C},
    /* 0xF9 */ {0xC2, 0xE7, 0x1D},
    /* 0xF9 */ {0xC3, 0xE7, 0x1E},
    /* 0xF9 */ {0xC4, 0xE7, 0x1F},
    /* 0xF9 */ {0xC5, 0xE7, 0x20},
    /* 0xF9 */ {0xC6, 0xE7, 0x21},
    /* 0xF9 */ {0xC7, 0xE7, 0x22},
    /* 0xF9 */ {0xC8, 0xE7, 0x23},
    /* 0xF9 */ {0xC9, 0xE7, 0x24},
    /* 0xF9 */ {0xCA, 0xE7, 0x25},
    /* 0xF9 */ {0xCB, 0xE7, 0x26},
    /* 0xF9 */ {0xCC, 0xE7, 0x27},
    /* 0xF9 */ {0xCD, 0xE7, 0x28},
    /* 0xF9 */ {0xCE, 0xE7, 0x29},
    /* 0xF9 */ {0xCF, 0xE7, 0x2A},
    /* 0xF9 */ {0xD0, 0xE7, 0x2B},
    /* 0xF9 */ {0xD1, 0xE7, 0x2C},
    /* 0xF9 */ {0xD2, 0xE7, 0x2D},
    /* 0xF9 */ {0xD3, 0xE7, 0x2E},
    /* 0xF9 */ {0xD4, 0xE7, 0x2F},
    /* 0xF9 */ {0xD5, 0xE7, 0x30},
    /* 0xF9 */ {0xD6, 0xE7, 0x31},
    /* 0xF9 */ {0xD7, 0xE7, 0x32},
    /* 0xF9 */ {0xD8, 0xE7, 0x33},
    /* 0xF9 */ {0xD9, 0xE7, 0x34},
    /* 0xF9 */ {0xDA, 0xE7, 0x35},
    /* 0xF9 */ {0xDB, 0xE7, 0x36},
    /* 0xF9 */ {0xDC, 0xE7, 0x37},
    /* 0xF9 */ {0xDD, 0xE7, 0x38},
    /* 0xF9 */ {0xDE, 0xE7, 0x39},
    /* 0xF9 */ {0xDF, 0xE7, 0x3A},
    /* 0xF9 */ {0xE0, 0xE7, 0x3B},
    /* 0xF9 */ {0xE1, 0xE7, 0x3C},
    /* 0xF9 */ {0xE2, 0xE7, 0x3D},
    /* 0xF9 */ {0xE3, 0xE7, 0x3E},
    /* 0xF9 */ {0xE4, 0xE7, 0x3F},
    /* 0xF9 */ {0xE5, 0xE7, 0x40},
    /* 0xF9 */ {0xE6, 0xE7, 0x41},
    /* 0xF9 */ {0xE7, 0xE7, 0x42},
    /* 0xF9 */ {0xE8, 0xE7, 0x43},
    /* 0xF9 */ {0xE9, 0xE7, 0x44},
    /* 0xF9 */ {0xEA, 0xE7, 0x45},
    /* 0xF9 */ {0xEB, 0xE7, 0x46},
    /* 0xF9 */ {0xEC, 0xE7, 0x47},
    /* 0xF9 */ {0xED, 0xE7, 0x48},
    /* 0xF9 */ {0xEE, 0xE7, 0x49},
    /* 0xF9 */ {0xEF, 0xE7, 0x4A},
    /* 0xF9 */ {0xF0, 0xE7, 0x4B},
    /* 0xF9 */ {0xF1, 0xE7, 0x4C},
    /* 0xF9 */ {0xF2, 0xE7, 0x4D},
    /* 0xF9 */ {0xF3, 0xE7, 0x4E},
    /* 0xF9 */ {0xF4, 0xE7, 0x4F},
    /* 0xF9 */ {0xF5, 0xE7, 0x50},
    /* 0xF9 */ {0xF6, 0xE7, 0x51},
    /* 0xF9 */ {0xF7, 0xE7, 0x52},
    /* 0xF9 */ {0xF8, 0xE7, 0x53},
    /* 0xF9 */ {0xF9, 0xE7, 0x54},
    /* 0xF9 */ {0xFA, 0xE7, 0x55},
    /* 0xF9 */ {0xFB, 0xE7, 0x56},
    /* 0xF9 */ {0xFC, 0xE7, 0x57},
    /* 0xFA */ {0x40, 0x21, 0x70},
    /* 0xFA */ {0x41, 0x21, 0x71},
    /* 0xFA */ {0x42, 0x21, 0x72},
    /* 0xFA */ {0x43, 0x21, 0x73},
    /* 0xFA */ {0x44, 0x21, 0x74},
    /* 0xFA */ {0x45, 0x21, 0x75},
    /* 0xFA */ {0x46, 0x21, 0x76},
    /* 0xFA */ {0x47, 0x21, 0x77},
    /* 0xFA */ {0x48, 0x21, 0x78},
    /* 0xFA */ {0x49, 0x21, 0x79},
    /* 0xFA */ {0x55, 0xFF, 0xE4},
    /* 0xFA */ {0x56, 0xFF, 0x07},
    /* 0xFA */ {0x57, 0xFF, 0x02},
    /* 0xFA */ {0x5C, 0x7E, 0x8A},
    /* 0xFA */ {0x5D, 0x89, 0x1C},
    /* 0xFA */ {0x5E, 0x93, 0x48},
    /* 0xFA */ {0x5F, 0x92, 0x88},
    /* 0xFA */ {0x60, 0x84, 0xDC},
    /* 0xFA */ {0x61, 0x4F, 0xC9},
    /* 0xFA */ {0x62, 0x70, 0xBB},
    /* 0xFA */ {0x63, 0x66, 0x31},
    /* 0xFA */ {0x64, 0x68, 0xC8},
    /* 0xFA */ {0x65, 0x92, 0xF9},
    /* 0xFA */ {0x66, 0x66, 0xFB},
    /* 0xFA */ {0x67, 0x5F, 0x45},
    /* 0xFA */ {0x68, 0x4E, 0x28},
    /* 0xFA */ {0x69, 0x4E, 0xE1},
    /* 0xFA */ {0x6A, 0x4E, 0xFC},
    /* 0xFA */ {0x6B, 0x4F, 0x00},
    /* 0xFA */ {0x6C, 0x4F, 0x03},
    /* 0xFA */ {0x6D, 0x4F, 0x39},
    /* 0xFA */ {0x6E, 0x4F, 0x56},
    /* 0xFA */ {0x6F, 0x4F, 0x92},
    /* 0xFA */ {0x70, 0x4F, 0x8A},
    /* 0xFA */ {0x71, 0x4F, 0x9A},
    /* 0xFA */ {0x72, 0x4F, 0x94},
    /* 0xFA */ {0x73, 0x4F, 0xCD},
    /* 0xFA */ {0x74, 0x50, 0x40},
    /* 0xFA */ {0x75, 0x50, 0x22},
    /* 0xFA */ {0x76, 0x4F, 0xFF},
    /* 0xFA */ {0x77, 0x50, 0x1E},
    /* 0xFA */ {0x78, 0x50, 0x46},
    /* 0xFA */ {0x79, 0x50, 0x70},
    /* 0xFA */ {0x7A, 0x50, 0x42},
    /* 0xFA */ {0x7B, 0x50, 0x94},
    /* 0xFA */ {0x7C, 0x50, 0xF4},
    /* 0xFA */ {0x7D, 0x50, 0xD8},
    /* 0xFA */ {0x7E, 0x51, 0x4A},
    /* 0xFA */ {0x80, 0x51, 0x64},
    /* 0xFA */ {0x81, 0x51, 0x9D},
    /* 0xFA */ {0x82, 0x51, 0xBE},
    /* 0xFA */ {0x83, 0x51, 0xEC},
    /* 0xFA */ {0x84, 0x52, 0x15},
    /* 0xFA */ {0x85, 0x52, 0x9C},
    /* 0xFA */ {0x86, 0x52, 0xA6},
    /* 0xFA */ {0x87, 0x52, 0xC0},
    /* 0xFA */ {0x88, 0x52, 0xDB},
    /* 0xFA */ {0x89, 0x53, 0x00},
    /* 0xFA */ {0x8A, 0x53, 0x07},
    /* 0xFA */ {0x8B, 0x53, 0x24},
    /* 0xFA */ {0x8C, 0x53, 0x72},
    /* 0xFA */ {0x8D, 0x53, 0x93},
    /* 0xFA */ {0x8E, 0x53, 0xB2},
    /* 0xFA */ {0x8F, 0x53, 0xDD},
    /* 0xFA */ {0x90, 0xFA, 0x0E},
    /* 0xFA */ {0x91, 0x54, 0x9C},
    /* 0xFA */ {0x92, 0x54, 0x8A},
    /* 0xFA */ {0x93, 0x54, 0xA9},
    /* 0xFA */ {0x94, 0x54, 0xFF},
    /* 0xFA */ {0x95, 0x55, 0x86},
    /* 0xFA */ {0x96, 0x57, 0x59},
    /* 0xFA */ {0x97, 0x57, 0x65},
    /* 0xFA */ {0x98, 0x57, 0xAC},
    /* 0xFA */ {0x99, 0x57, 0xC8},
    /* 0xFA */ {0x9A, 0x57, 0xC7},
    /* 0xFA */ {0x9B, 0xFA, 0x0F},
    /* 0xFA */ {0x9C, 0xFA, 0x10},
    /* 0xFA */ {0x9D, 0x58, 0x9E},
    /* 0xFA */ {0x9E, 0x58, 0xB2},
    /* 0xFA */ {0x9F, 0x59, 0x0B},
    /* 0xFA */ {0xA0, 0x59, 0x53},
    /* 0xFA */ {0xA1, 0x59, 0x5B},
    /* 0xFA */ {0xA2, 0x59, 0x5D},
    /* 0xFA */ {0xA3, 0x59, 0x63},
    /* 0xFA */ {0xA4, 0x59, 0xA4},
    /* 0xFA */ {0xA5, 0x59, 0xBA},
    /* 0xFA */ {0xA6, 0x5B, 0x56},
    /* 0xFA */ {0xA7, 0x5B, 0xC0},
    /* 0xFA */ {0xA8, 0x75, 0x2F},
    /* 0xFA */ {0xA9, 0x5B, 0xD8},
    /* 0xFA */ {0xAA, 0x5B, 0xEC},
    /* 0xFA */ {0xAB, 0x5C, 0x1E},
    /* 0xFA */ {0xAC, 0x5C, 0xA6},
    /* 0xFA */ {0xAD, 0x5C, 0xBA},
    /* 0xFA */ {0xAE, 0x5C, 0xF5},
    /* 0xFA */ {0xAF, 0x5D, 0x27},
    /* 0xFA */ {0xB0, 0x5D, 0x53},
    /* 0xFA */ {0xB1, 0xFA, 0x11},
    /* 0xFA */ {0xB2, 0x5D, 0x42},
    /* 0xFA */ {0xB3, 0x5D, 0x6D},
    /* 0xFA */ {0xB4, 0x5D, 0xB8},
    /* 0xFA */ {0xB5, 0x5D, 0xB9},
    /* 0xFA */ {0xB6, 0x5D, 0xD0},
    /* 0xFA */ {0xB7, 0x5F, 0x21},
    /* 0xFA */ {0xB8, 0x5F, 0x34},
    /* 0xFA */ {0xB9, 0x5F, 0x67},
    /* 0xFA */ {0xBA, 0x5F, 0xB7},
    /* 0xFA */ {0xBB, 0x5F, 0xDE},
    /* 0xFA */ {0xBC, 0x60, 0x5D},
    /* 0xFA */ {0xBD, 0x60, 0x85},
    /* 0xFA */ {0xBE, 0x60, 0x8A},
    /* 0xFA */ {0xBF, 0x60, 0xDE},
    /* 0xFA */ {0xC0, 0x60, 0xD5},
    /* 0xFA */ {0xC1, 0x61, 0x20},
    /* 0xFA */ {0xC2, 0x60, 0xF2},
    /* 0xFA */ {0xC3, 0x61, 0x11},
    /* 0xFA */ {0xC4, 0x61, 0x37},
    /* 0xFA */ {0xC5, 0x61, 0x30},
    /* 0xFA */ {0xC6, 0x61, 0x98},
    /* 0xFA */ {0xC7, 0x62, 0x13},
    /* 0xFA */ {0xC8, 0x62, 0xA6},
    /* 0xFA */ {0xC9, 0x63, 0xF5},
    /* 0xFA */ {0xCA, 0x64, 0x60},
    /* 0xFA */ {0xCB, 0x64, 0x9D},
    /* 0xFA */ {0xCC, 0x64, 0xCE},
    /* 0xFA */ {0xCD, 0x65, 0x4E},
    /* 0xFA */ {0xCE, 0x66, 0x00},
    /* 0xFA */ {0xCF, 0x66, 0x15},
    /* 0xFA */ {0xD0, 0x66, 0x3B},
    /* 0xFA */ {0xD1, 0x66, 0x09},
    /* 0xFA */ {0xD2, 0x66, 0x2E},
    /* 0xFA */ {0xD3, 0x66, 0x1E},
    /* 0xFA */ {0xD4, 0x66, 0x24},
    /* 0xFA */ {0xD5, 0x66, 0x65},
    /* 0xFA */ {0xD6, 0x66, 0x57},
    /* 0xFA */ {0xD7, 0x66, 0x59},
    /* 0xFA */ {0xD8, 0xFA, 0x12},
    /* 0xFA */ {0xD9, 0x66, 0x73},
    /* 0xFA */ {0xDA, 0x66, 0x99},
    /* 0xFA */ {0xDB, 0x66, 0xA0},
    /* 0xFA */ {0xDC, 0x66, 0xB2},
    /* 0xFA */ {0xDD, 0x66, 0xBF},
    /* 0xFA */ {0xDE, 0x66, 0xFA},
    /* 0xFA */ {0xDF, 0x67, 0x0E},
    /* 0xFA */ {0xE0, 0xF9, 0x29},
    /* 0xFA */ {0xE1, 0x67, 0x66},
    /* 0xFA */ {0xE2, 0x67, 0xBB},
    /* 0xFA */ {0xE3, 0x68, 0x52},
    /* 0xFA */ {0xE4, 0x67, 0xC0},
    /* 0xFA */ {0xE5, 0x68, 0x01},
    /* 0xFA */ {0xE6, 0x68, 0x44},
    /* 0xFA */ {0xE7, 0x68, 0xCF},
    /* 0xFA */ {0xE8, 0xFA, 0x13},
    /* 0xFA */ {0xE9, 0x69, 0x68},
    /* 0xFA */ {0xEA, 0xFA, 0x14},
    /* 0xFA */ {0xEB, 0x69, 0x98},
    /* 0xFA */ {0xEC, 0x69, 0xE2},
    /* 0xFA */ {0xED, 0x6A, 0x30},
    /* 0xFA */ {0xEE, 0x6A, 0x6B},
    /* 0xFA */ {0xEF, 0x6A, 0x46},
    /* 0xFA */ {0xF0, 0x6A, 0x73},
    /* 0xFA */ {0xF1, 0x6A, 0x7E},
    /* 0xFA */ {0xF2, 0x6A, 0xE2},
    /* 0xFA */ {0xF3, 0x6A, 0xE4},
    /* 0xFA */ {0xF4, 0x6B, 0xD6},
    /* 0xFA */ {0xF5, 0x6C, 0x3F},
    /* 0xFA */ {0xF6, 0x6C, 0x5C},
    /* 0xFA */ {0xF7, 0x6C, 0x86},
    /* 0xFA */ {0xF8, 0x6C, 0x6F},
    /* 0xFA */ {0xF9, 0x6C, 0xDA},
    /* 0xFA */ {0xFA, 0x6D, 0x04},
    /* 0xFA */ {0xFB, 0x6D, 0x87},
    /* 0xFA */ {0xFC, 0x6D, 0x6F},
    /* 0xFB */ {0x40, 0x6D, 0x96},
    /* 0xFB */ {0x41, 0x6D, 0xAC},
    /* 0xFB */ {0x42, 0x6D, 0xCF},
    /* 0xFB */ {0x43, 0x6D, 0xF8},
    /* 0xFB */ {0x44, 0x6D, 0xF2},
    /* 0xFB */ {0x45, 0x6D, 0xFC},
    /* 0xFB */ {0x46, 0x6E, 0x39},
    /* 0xFB */ {0x47, 0x6E, 0x5C},
    /* 0xFB */ {0x48, 0x6E, 0x27},
    /* 0xFB */ {0x49, 0x6E, 0x3C},
    /* 0xFB */ {0x4A, 0x6E, 0xBF},
    /* 0xFB */ {0x4B, 0x6F, 0x88},
    /* 0xFB */ {0x4C, 0x6F, 0xB5},
    /* 0xFB */ {0x4D, 0x6F, 0xF5},
    /* 0xFB */ {0x4E, 0x70, 0x05},
    /* 0xFB */ {0x4F, 0x70, 0x07},
    /* 0xFB */ {0x50, 0x70, 0x28},
    /* 0xFB */ {0x51, 0x70, 0x85},
    /* 0xFB */ {0x52, 0x70, 0xAB},
    /* 0xFB */ {0x53, 0x71, 0x0F},
    /* 0xFB */ {0x54, 0x71, 0x04},
    /* 0xFB */ {0x55, 0x71, 0x5C},
    /* 0xFB */ {0x56, 0x71, 0x46},
    /* 0xFB */ {0x57, 0x71, 0x47},
    /* 0xFB */ {0x58, 0xFA, 0x15},
    /* 0xFB */ {0x59, 0x71, 0xC1},
    /* 0xFB */ {0x5A, 0x71, 0xFE},
    /* 0xFB */ {0x5B, 0x72, 0xB1},
    /* 0xFB */ {0x5C, 0x72, 0xBE},
    /* 0xFB */ {0x5D, 0x73, 0x24},
    /* 0xFB */ {0x5E, 0xFA, 0x16},
    /* 0xFB */ {0x5F, 0x73, 0x77},
    /* 0xFB */ {0x60, 0x73, 0xBD},
    /* 0xFB */ {0x61, 0x73, 0xC9},
    /* 0xFB */ {0x62, 0x73, 0xD6},
    /* 0xFB */ {0x63, 0x73, 0xE3},
    /* 0xFB */ {0x64, 0x73, 0xD2},
    /* 0xFB */ {0x65, 0x74, 0x07},
    /* 0xFB */ {0x66, 0x73, 0xF5},
    /* 0xFB */ {0x67, 0x74, 0x26},
    /* 0xFB */ {0x68, 0x74, 0x2A},
    /* 0xFB */ {0x69, 0x74, 0x29},
    /* 0xFB */ {0x6A, 0x74, 0x2E},
    /* 0xFB */ {0x6B, 0x74, 0x62},
    /* 0xFB */ {0x6C, 0x74, 0x89},
    /* 0xFB */ {0x6D, 0x74, 0x9F},
    /* 0xFB */ {0x6E, 0x75, 0x01},
    /* 0xFB */ {0x6F, 0x75, 0x6F},
    /* 0xFB */ {0x70, 0x76, 0x82},
    /* 0xFB */ {0x71, 0x76, 0x9C},
    /* 0xFB */ {0x72, 0x76, 0x9E},
    /* 0xFB */ {0x73, 0x76, 0x9B},
    /* 0xFB */ {0x74, 0x76, 0xA6},
    /* 0xFB */ {0x75, 0xFA, 0x17},
    /* 0xFB */ {0x76, 0x77, 0x46},
    /* 0xFB */ {0x77, 0x52, 0xAF},
    /* 0xFB */ {0x78, 0x78, 0x21},
    /* 0xFB */ {0x79, 0x78, 0x4E},
    /* 0xFB */ {0x7A, 0x78, 0x64},
    /* 0xFB */ {0x7B, 0x78, 0x7A},
    /* 0xFB */ {0x7C, 0x79, 0x30},
    /* 0xFB */ {0x7D, 0xFA, 0x18},
    /* 0xFB */ {0x7E, 0xFA, 0x19},
    /* 0xFB */ {0x80, 0xFA, 0x1A},
    /* 0xFB */ {0x81, 0x79, 0x94},
    /* 0xFB */ {0x82, 0xFA, 0x1B},
    /* 0xFB */ {0x83, 0x79, 0x9B},
    /* 0xFB */ {0x84, 0x7A, 0xD1},
    /* 0xFB */ {0x85, 0x7A, 0xE7},
    /* 0xFB */ {0x86, 0xFA, 0x1C},
    /* 0xFB */ {0x87, 0x7A, 0xEB},
    /* 0xFB */ {0x88, 0x7B, 0x9E},
    /* 0xFB */ {0x89, 0xFA, 0x1D},
    /* 0xFB */ {0x8A, 0x7D, 0x48},
    /* 0xFB */ {0x8B, 0x7D, 0x5C},
    /* 0xFB */ {0x8C, 0x7D, 0xB7},
    /* 0xFB */ {0x8D, 0x7D, 0xA0},
    /* 0xFB */ {0x8E, 0x7D, 0xD6},
    /* 0xFB */ {0x8F, 0x7E, 0x52},
    /* 0xFB */ {0x90, 0x7F, 0x47},
    /* 0xFB */ {0x91, 0x7F, 0xA1},
    /* 0xFB */ {0x92, 0xFA, 0x1E},
    /* 0xFB */ {0x93, 0x83, 0x01},
    /* 0xFB */ {0x94, 0x83, 0x62},
    /* 0xFB */ {0x95, 0x83, 0x7F},
    /* 0xFB */ {0x96, 0x83, 0xC7},
    /* 0xFB */ {0x97, 0x83, 0xF6},
    /* 0xFB */ {0x98, 0x84, 0x48},
    /* 0xFB */ {0x99, 0x84, 0xB4},
    /* 0xFB */ {0x9A, 0x85, 0x53},
    /* 0xFB */ {0x9B, 0x85, 0x59},
    /* 0xFB */ {0x9C, 0x85, 0x6B},
    /* 0xFB */ {0x9D, 0xFA, 0x1F},
    /* 0xFB */ {0x9E, 0x85, 0xB0},
    /* 0xFB */ {0x9F, 0xFA, 0x20},
    /* 0xFB */ {0xA0, 0xFA, 0x21},
    /* 0xFB */ {0xA1, 0x88, 0x07},
    /* 0xFB */ {0xA2, 0x88, 0xF5},
    /* 0xFB */ {0xA3, 0x8A, 0x12},
    /* 0xFB */ {0xA4, 0x8A, 0x37},
    /* 0xFB */ {0xA5, 0x8A, 0x79},
    /* 0xFB */ {0xA6, 0x8A, 0xA7},
    /* 0xFB */ {0xA7, 0x8A, 0xBE},
    /* 0xFB */ {0xA8, 0x8A, 0xDF},
    /* 0xFB */ {0xA9, 0xFA, 0x22},
    /* 0xFB */ {0xAA, 0x8A, 0xF6},
    /* 0xFB */ {0xAB, 0x8B, 0x53},
    /* 0xFB */ {0xAC, 0x8B, 0x7F},
    /* 0xFB */ {0xAD, 0x8C, 0xF0},
    /* 0xFB */ {0xAE, 0x8C, 0xF4},
    /* 0xFB */ {0xAF, 0x8D, 0x12},
    /* 0xFB */ {0xB0, 0x8D, 0x76},
    /* 0xFB */ {0xB1, 0xFA, 0x23},
    /* 0xFB */ {0xB2, 0x8E, 0xCF},
    /* 0xFB */ {0xB3, 0xFA, 0x24},
    /* 0xFB */ {0xB4, 0xFA, 0x25},
    /* 0xFB */ {0xB5, 0x90, 0x67},
    /* 0xFB */ {0xB6, 0x90, 0xDE},
    /* 0xFB */ {0xB7, 0xFA, 0x26},
    /* 0xFB */ {0xB8, 0x91, 0x15},
    /* 0xFB */ {0xB9, 0x91, 0x27},
    /* 0xFB */ {0xBA, 0x91, 0xDA},
    /* 0xFB */ {0xBB, 0x91, 0xD7},
    /* 0xFB */ {0xBC, 0x91, 0xDE},
    /* 0xFB */ {0xBD, 0x91, 0xED},
    /* 0xFB */ {0xBE, 0x91, 0xEE},
    /* 0xFB */ {0xBF, 0x91, 0xE4},
    /* 0xFB */ {0xC0, 0x91, 0xE5},
    /* 0xFB */ {0xC1, 0x92, 0x06},
    /* 0xFB */ {0xC2, 0x92, 0x10},
    /* 0xFB */ {0xC3, 0x92, 0x0A},
    /* 0xFB */ {0xC4, 0x92, 0x3A},
    /* 0xFB */ {0xC5, 0x92, 0x40},
    /* 0xFB */ {0xC6, 0x92, 0x3C},
    /* 0xFB */ {0xC7, 0x92, 0x4E},
    /* 0xFB */ {0xC8, 0x92, 0x59},
    /* 0xFB */ {0xC9, 0x92, 0x51},
    /* 0xFB */ {0xCA, 0x92, 0x39},
    /* 0xFB */ {0xCB, 0x92, 0x67},
    /* 0xFB */ {0xCC, 0x92, 0xA7},
    /* 0xFB */ {0xCD, 0x92, 0x77},
    /* 0xFB */ {0xCE, 0x92, 0x78},
    /* 0xFB */ {0xCF, 0x92, 0xE7},
    /* 0xFB */ {0xD0, 0x92, 0xD7},
    /* 0xFB */ {0xD1, 0x92, 0xD9},
    /* 0xFB */ {0xD2, 0x92, 0xD0},
    /* 0xFB */ {0xD3, 0xFA, 0x27},
    /* 0xFB */ {0xD4, 0x92, 0xD5},
    /* 0xFB */ {0xD5, 0x92, 0xE0},
    /* 0xFB */ {0xD6, 0x92, 0xD3},
    /* 0xFB */ {0xD7, 0x93, 0x25},
    /* 0xFB */ {0xD8, 0x93, 0x21},
    /* 0xFB */ {0xD9, 0x92, 0xFB},
    /* 0xFB */ {0xDA, 0xFA, 0x28},
    /* 0xFB */ {0xDB, 0x93, 0x1E},
    /* 0xFB */ {0xDC, 0x92, 0xFF},
    /* 0xFB */ {0xDD, 0x93, 0x1D},
    /* 0xFB */ {0xDE, 0x93, 0x02},
    /* 0xFB */ {0xDF, 0x93, 0x70},
    /* 0xFB */ {0xE0, 0x93, 0x57},
    /* 0xFB */ {0xE1, 0x93, 0xA4},
    /* 0xFB */ {0xE2, 0x93, 0xC6},
    /* 0xFB */ {0xE3, 0x93, 0xDE},
    /* 0xFB */ {0xE4, 0x93, 0xF8},
    /* 0xFB */ {0xE5, 0x94, 0x31},
    /* 0xFB */ {0xE6, 0x94, 0x45},
    /* 0xFB */ {0xE7, 0x94, 0x48},
    /* 0xFB */ {0xE8, 0x95, 0x92},
    /* 0xFB */ {0xE9, 0xF9, 0xDC},
    /* 0xFB */ {0xEA, 0xFA, 0x29},
    /* 0xFB */ {0xEB, 0x96, 0x9D},
    /* 0xFB */ {0xEC, 0x96, 0xAF},
    /* 0xFB */ {0xED, 0x97, 0x33},
    /* 0xFB */ {0xEE, 0x97, 0x3B},
    /* 0xFB */ {0xEF, 0x97, 0x43},
    /* 0xFB */ {0xF0, 0x97, 0x4D},
    /* 0xFB */ {0xF1, 0x97, 0x4F},
    /* 0xFB */ {0xF2, 0x97, 0x51},
    /* 0xFB */ {0xF3, 0x97, 0x55},
    /* 0xFB */ {0xF4, 0x98, 0x57},
    /* 0xFB */ {0xF5, 0x98, 0x65},
    /* 0xFB */ {0xF6, 0xFA, 0x2A},
    /* 0xFB */ {0xF7, 0xFA, 0x2B},
    /* 0xFB */ {0xF8, 0x99, 0x27},
    /* 0xFB */ {0xF9, 0xFA, 0x2C},
    /* 0xFB */ {0xFA, 0x99, 0x9E},
    /* 0xFB */ {0xFB, 0x9A, 0x4E},
    /* 0xFB */ {0xFC, 0x9A, 0xD9},
    /* 0xFC */ {0x40, 0x9A, 0xDC},
    /* 0xFC */ {0x41, 0x9B, 0x75},
    /* 0xFC */ {0x42, 0x9B, 0x72},
    /* 0xFC */ {0x43, 0x9B, 0x8F},
    /* 0xFC */ {0x44, 0x9B, 0xB1},
    /* 0xFC */ {0x45, 0x9B, 0xBB},
    /* 0xFC */ {0x46, 0x9C, 0x00},
    /* 0xFC */ {0x47, 0x9D, 0x70},
    /* 0xFC */ {0x48, 0x9D, 0x6B},
    /* 0xFC */ {0x49, 0xFA, 0x2D},
    /* 0xFC */ {0x4A, 0x9E, 0x19},
    /* 0xFC */ {0x4B, 0x9E, 0xD1}
};


} // namespace apolloron
