/******************************************************************************/
/*! @file table_utf8_gb18030.cc
    @brief UTF-8/GB18030 table.
    @author Masashi Astro Tachibana, Apolloron Project.
 ******************************************************************************/

#include "table_utf8_gb18030.h"

namespace apolloron {

const T_UTF8_GB18030 utf8_gb18030[UTF8_GB18030_TABLE_MAX] ={
    {"\xC2\x80", "\x81\x30\x81\x30", 36},
    {"\xC2\xA5", "\x81\x30\x84\x36", 2},
    {"\xC2\xA9", "\x81\x30\x84\x38", 7},
    {"\xC2\xB2", "\x81\x30\x85\x35", 5},
    {"\xC2\xB8", "\x81\x30\x86\x30", 31},
    {"\xC3\x98", "\x81\x30\x89\x31", 8},
    {"\xC3\xA2", "\x81\x30\x89\x39", 6},
    {"\xC3\xAB", "\x81\x30\x8A\x35", 1},
    {"\xC3\xAE", "\x81\x30\x8A\x36", 4},
    {"\xC3\xB4", "\x81\x30\x8B\x30", 3},
    {"\xC3\xB8", "\x81\x30\x8B\x33", 1},
    {"\xC3\xBB", "\x81\x30\x8B\x34", 1},
    {"\xC3\xBD", "\x81\x30\x8B\x35", 4},
    {"\xC4\x82", "\x81\x30\x8B\x39", 17},
    {"\xC4\x94", "\x81\x30\x8D\x36", 7},
    {"\xC4\x9C", "\x81\x30\x8E\x33", 15},
    {"\xC4\xAC", "\x81\x30\x8F\x38", 24},
    {"\xC5\x85", "\x81\x30\x92\x32", 3},
    {"\xC5\x89", "\x81\x30\x92\x35", 4},
    {"\xC5\x8E", "\x81\x30\x92\x39", 29},
    {"\xC5\xAC", "\x81\x30\x95\x38", 98},
    {"\xC7\x8F", "\x81\x30\x9F\x36", 1},
    {"\xC7\x91", "\x81\x30\x9F\x37", 1},
    {"\xC7\x93", "\x81\x30\x9F\x38", 1},
    {"\xC7\x95", "\x81\x30\x9F\x39", 1},
    {"\xC7\x97", "\x81\x30\xA0\x30", 1},
    {"\xC7\x99", "\x81\x30\xA0\x31", 1},
    {"\xC7\x9B", "\x81\x30\xA0\x32", 1},
    {"\xC7\x9D", "\x81\x30\xA0\x33", 28},
    {"\xC7\xBA", "\x81\x30\xA3\x31", 87},
    {"\xC9\x92", "\x81\x30\xAB\x38", 15},
    {"\xC9\xA2", "\x81\x30\xAD\x33", 101},
    {"\xCB\x88", "\x81\x30\xB7\x34", 1},
    {"\xCB\x8C", "\x81\x30\xB7\x35", 13},
    {"\xCB\x9A", "\x81\x30\xB8\x38", 128},
    {"\xCD\x9A", "\x81\x30\xC5\x36", 55},
    {"\xCE\xA2", "\x81\x30\xCB\x31", 1},
    {"\xCE\xAA", "\x81\x30\xCB\x32", 7},
    {"\xCF\x82", "\x81\x30\xCB\x39", 1},
    {"\xCF\x8A", "\x81\x30\xCC\x30", 55},
    {"\xD0\x82", "\x81\x30\xD1\x35", 14},
    {"\xD1\x90", "\x81\x30\xD2\x39", 1},
    {"\xD1\x92", "\x81\x30\xD3\x30", 128},
    {"\xD3\x92", "\x81\x30\xDF\x38", 128},
    {"\xD5\x92", "\x81\x30\xEC\x36", 128},
    {"\xD7\x92", "\x81\x30\xF9\x34", 128},
    {"\xD9\x92", "\x81\x31\x88\x32", 128},
    {"\xDB\x92", "\x81\x31\x95\x30", 128},
    {"\xDD\x92", "\x81\x31\xA1\x38", 128},
    {"\xDF\x92", "\x81\x31\xAE\x36", 46},
    {"\xE0\xA0\x80", "\x81\x31\xB3\x32", 128},
    {"\xE0\xA2\x80", "\x81\x31\xC0\x30", 128},
    {"\xE0\xA4\x80", "\x81\x31\xCC\x38", 128},
    {"\xE0\xA6\x80", "\x81\x31\xD9\x36", 128},
    {"\xE0\xA8\x80", "\x81\x31\xE6\x34", 128},
    {"\xE0\xAA\x80", "\x81\x31\xF3\x32", 128},
    {"\xE0\xAC\x80", "\x81\x32\x82\x30", 128},
    {"\xE0\xAE\x80", "\x81\x32\x8E\x38", 128},
    {"\xE0\xB0\x80", "\x81\x32\x9B\x36", 128},
    {"\xE0\xB2\x80", "\x81\x32\xA8\x34", 128},
    {"\xE0\xB4\x80", "\x81\x32\xB5\x32", 128},
    {"\xE0\xB6\x80", "\x81\x32\xC2\x30", 128},
    {"\xE0\xB8\x80", "\x81\x32\xCE\x38", 128},
    {"\xE0\xBA\x80", "\x81\x32\xDB\x36", 128},
    {"\xE0\xBC\x80", "\x81\x32\xE8\x34", 128},
    {"\xE0\xBE\x80", "\x81\x32\xF5\x32", 128},
    {"\xE1\x80\x80", "\x81\x33\x84\x30", 128},
    {"\xE1\x82\x80", "\x81\x33\x90\x38", 128},
    {"\xE1\x84\x80", "\x81\x33\x9D\x36", 128},
    {"\xE1\x86\x80", "\x81\x33\xAA\x34", 128},
    {"\xE1\x88\x80", "\x81\x33\xB7\x32", 128},
    {"\xE1\x8A\x80", "\x81\x33\xC4\x30", 128},
    {"\xE1\x8C\x80", "\x81\x33\xD0\x38", 128},
    {"\xE1\x8E\x80", "\x81\x33\xDD\x36", 128},
    {"\xE1\x90\x80", "\x81\x33\xEA\x34", 128},
    {"\xE1\x92\x80", "\x81\x33\xF7\x32", 128},
    {"\xE1\x94\x80", "\x81\x34\x86\x30", 128},
    {"\xE1\x96\x80", "\x81\x34\x92\x38", 128},
    {"\xE1\x98\x80", "\x81\x34\x9F\x36", 128},
    {"\xE1\x9A\x80", "\x81\x34\xAC\x34", 128},
    {"\xE1\x9C\x80", "\x81\x34\xB9\x32", 128},
    {"\xE1\x9E\x80", "\x81\x34\xC6\x30", 128},
    {"\xE1\xA0\x80", "\x81\x34\xD2\x38", 128},
    {"\xE1\xA2\x80", "\x81\x34\xDF\x36", 128},
    {"\xE1\xA4\x80", "\x81\x34\xEC\x34", 128},
    {"\xE1\xA6\x80", "\x81\x34\xF9\x32", 128},
    {"\xE1\xA8\x80", "\x81\x35\x88\x30", 128},
    {"\xE1\xAA\x80", "\x81\x35\x94\x38", 128},
    {"\xE1\xAC\x80", "\x81\x35\xA1\x36", 128},
    {"\xE1\xAE\x80", "\x81\x35\xAE\x34", 128},
    {"\xE1\xB0\x80", "\x81\x35\xBB\x32", 128},
    {"\xE1\xB2\x80", "\x81\x35\xC8\x30", 128},
    {"\xE1\xB4\x80", "\x81\x35\xD4\x38", 128},
    {"\xE1\xB6\x80", "\x81\x35\xE1\x36", 128},
    {"\xE1\xB8\x80", "\x81\x35\xEE\x34", 63},
    {"\xE1\xB9\x80", "\x81\x35\xF4\x38", 128},
    {"\xE1\xBB\x80", "\x81\x36\x83\x36", 128},
    {"\xE1\xBD\x80", "\x81\x36\x90\x34", 128},
    {"\xE1\xBF\x80", "\x81\x36\x9D\x32", 64},
    {"\xE2\x80\x80", "\x81\x36\xA3\x36", 16},
    {"\xE2\x80\x91", "\x81\x36\xA5\x32", 2},
    {"\xE2\x80\x97", "\x81\x36\xA5\x34", 1},
    {"\xE2\x80\x9A", "\x81\x36\xA5\x35", 2},
    {"\xE2\x80\x9E", "\x81\x36\xA5\x37", 7},
    {"\xE2\x80\xA7", "\x81\x36\xA6\x34", 9},
    {"\xE2\x80\xB1", "\x81\x36\xA7\x33", 1},
    {"\xE2\x80\xB4", "\x81\x36\xA7\x34", 1},
    {"\xE2\x80\xB6", "\x81\x36\xA7\x35", 5},
    {"\xE2\x80\xBC", "\x81\x36\xA8\x30", 112},
    {"\xE2\x82\xAD", "\x81\x36\xB3\x32", 86},
    {"\xE2\x84\x84", "\x81\x36\xBB\x38", 1},
    {"\xE2\x84\x86", "\x81\x36\xBB\x39", 3},
    {"\xE2\x84\x8A", "\x81\x36\xBC\x32", 12},
    {"\xE2\x84\x97", "\x81\x36\xBD\x34", 10},
    {"\xE2\x84\xA2", "\x81\x36\xBE\x34", 62},
    {"\xE2\x85\xAC", "\x81\x36\xC4\x36", 4},
    {"\xE2\x85\xBA", "\x81\x36\xC5\x30", 22},
    {"\xE2\x86\x94", "\x81\x36\xC7\x32", 2},
    {"\xE2\x86\x9A", "\x81\x36\xC7\x34", 110},
    {"\xE2\x88\x89", "\x81\x36\xD2\x34", 6},
    {"\xE2\x88\x90", "\x81\x36\xD3\x30", 1},
    {"\xE2\x88\x92", "\x81\x36\xD3\x31", 3},
    {"\xE2\x88\x96", "\x81\x36\xD3\x34", 4},
    {"\xE2\x88\x9B", "\x81\x36\xD3\x38", 2},
    {"\xE2\x88\xA1", "\x81\x36\xD4\x30", 2},
    {"\xE2\x88\xA4", "\x81\x36\xD4\x32", 1},
    {"\xE2\x88\xA6", "\x81\x36\xD4\x33", 1},
    {"\xE2\x88\xAC", "\x81\x36\xD4\x34", 2},
    {"\xE2\x88\xAF", "\x81\x36\xD4\x36", 5},
    {"\xE2\x88\xB8", "\x81\x36\xD5\x31", 5},
    {"\xE2\x88\xBE", "\x81\x36\xD5\x36", 10},
    {"\xE2\x89\x89", "\x81\x36\xD6\x36", 3},
    {"\xE2\x89\x8D", "\x81\x36\xD6\x39", 5},
    {"\xE2\x89\x93", "\x81\x36\xD7\x34", 13},
    {"\xE2\x89\xA2", "\x81\x36\xD8\x37", 2},
    {"\xE2\x89\xA8", "\x81\x36\xD8\x39", 6},
    {"\xE2\x89\xB0", "\x81\x36\xD9\x35", 37},
    {"\xE2\x8A\x96", "\x81\x36\xDD\x32", 3},
    {"\xE2\x8A\x9A", "\x81\x36\xDD\x35", 11},
    {"\xE2\x8A\xA6", "\x81\x36\xDE\x36", 25},
    {"\xE2\x8B\x80", "\x81\x36\xE1\x31", 82},
    {"\xE2\x8C\x93", "\x81\x36\xE9\x33", 128},
    {"\xE2\x8E\x93", "\x81\x36\xF6\x31", 128},
    {"\xE2\x90\x93", "\x81\x37\x84\x39", 77},
    {"\xE2\x91\xAA", "\x81\x37\x8C\x36", 10},
    {"\xE2\x92\x9C", "\x81\x37\x8D\x36", 100},
    {"\xE2\x95\x8C", "\x81\x37\x97\x36", 4},
    {"\xE2\x95\xB4", "\x81\x37\x98\x30", 13},
    {"\xE2\x96\x90", "\x81\x37\x99\x33", 3},
    {"\xE2\x96\x96", "\x81\x37\x99\x36", 10},
    {"\xE2\x96\xA2", "\x81\x37\x9A\x36", 16},
    {"\xE2\x96\xB4", "\x81\x37\x9C\x32", 8},
    {"\xE2\x96\xBE", "\x81\x37\x9D\x30", 8},
    {"\xE2\x97\x88", "\x81\x37\x9D\x38", 3},
    {"\xE2\x97\x8C", "\x81\x37\x9E\x31", 2},
    {"\xE2\x97\x90", "\x81\x37\x9E\x33", 18},
    {"\xE2\x97\xA6", "\x81\x37\xA0\x31", 31},
    {"\xE2\x98\x87", "\x81\x37\xA3\x32", 2},
    {"\xE2\x98\x8A", "\x81\x37\xA3\x34", 54},
    {"\xE2\x99\x81", "\x81\x37\xA8\x38", 1},
    {"\xE2\x99\x83", "\x81\x37\xA8\x39", 128},
    {"\xE2\x9B\x83", "\x81\x37\xB5\x37", 128},
    {"\xE2\x9D\x83", "\x81\x37\xC2\x35", 128},
    {"\xE2\x9F\x83", "\x81\x37\xCF\x33", 128},
    {"\xE2\xA1\x83", "\x81\x37\xDC\x31", 128},
    {"\xE2\xA3\x83", "\x81\x37\xE8\x39", 128},
    {"\xE2\xA5\x83", "\x81\x37\xF5\x37", 128},
    {"\xE2\xA7\x83", "\x81\x38\x84\x35", 128},
    {"\xE2\xA9\x83", "\x81\x38\x91\x33", 128},
    {"\xE2\xAB\x83", "\x81\x38\x9E\x31", 128},
    {"\xE2\xAD\x83", "\x81\x38\xAA\x39", 128},
    {"\xE2\xAF\x83", "\x81\x38\xB7\x37", 128},
    {"\xE2\xB1\x83", "\x81\x38\xC4\x35", 128},
    {"\xE2\xB3\x83", "\x81\x38\xD1\x33", 128},
    {"\xE2\xB5\x83", "\x81\x38\xDE\x31", 128},
    {"\xE2\xB7\x83", "\x81\x38\xEA\x39", 128},
    {"\xE2\xB9\x83", "\x81\x38\xF7\x37", 62},
    {"\xE2\xBA\x82", "\x81\x38\xFD\x39", 2},
    {"\xE2\xBA\x85", "\x81\x38\xFE\x31", 3},
    {"\xE2\xBA\x89", "\x81\x38\xFE\x34", 2},
    {"\xE2\xBA\x8D", "\x81\x38\xFE\x36", 10},
    {"\xE2\xBA\x98", "\x81\x39\x81\x36", 15},
    {"\xE2\xBA\xA8", "\x81\x39\x83\x31", 2},
    {"\xE2\xBA\xAB", "\x81\x39\x83\x33", 3},
    {"\xE2\xBA\xAF", "\x81\x39\x83\x36", 4},
    {"\xE2\xBA\xB4", "\x81\x39\x84\x30", 2},
    {"\xE2\xBA\xB8", "\x81\x39\x84\x32", 3},
    {"\xE2\xBA\xBC", "\x81\x39\x84\x35", 14},
    {"\xE2\xBB\x8B", "\x81\x39\x85\x39", 128},
    {"\xE2\xBD\x8B", "\x81\x39\x92\x37", 128},
    {"\xE2\xBF\x8B", "\x81\x39\x9F\x35", 37},
    {"\xE2\xBF\xBC", "\x81\x39\xA3\x32", 4},
    {"\xE3\x80\x84", "\x81\x39\xA3\x36", 1},
    {"\xE3\x80\x98", "\x81\x39\xA3\x37", 5},
    {"\xE3\x80\x9F", "\x81\x39\xA4\x32", 2},
    {"\xE3\x80\xAA", "\x81\x39\xA4\x34", 20},
    {"\xE3\x80\xBF", "\x81\x39\xA6\x34", 2},
    {"\xE3\x82\x94", "\x81\x39\xA6\x36", 7},
    {"\xE3\x82\x9F", "\x81\x39\xA7\x33", 2},
    {"\xE3\x83\xB7", "\x81\x39\xA7\x35", 5},
    {"\xE3\x83\xBF", "\x81\x39\xA8\x30", 6},
    {"\xE3\x84\xAA", "\x81\x39\xA8\x36", 128},
    {"\xE3\x86\xAA", "\x81\x39\xB5\x34", 118},
    {"\xE3\x88\xAA", "\x81\x39\xC1\x32", 7},
    {"\xE3\x88\xB2", "\x81\x39\xC1\x39", 113},
    {"\xE3\x8A\xA4", "\x81\x39\xCD\x32", 128},
    {"\xE3\x8C\xA4", "\x81\x39\xDA\x30", 106},
    {"\xE3\x8E\x90", "\x81\x39\xE4\x36", 12},
    {"\xE3\x8E\x9F", "\x81\x39\xE5\x38", 2},
    {"\xE3\x8E\xA2", "\x81\x39\xE6\x30", 34},
    {"\xE3\x8F\x85", "\x81\x39\xE9\x34", 9},
    {"\xE3\x8F\x8F", "\x81\x39\xEA\x33", 2},
    {"\xE3\x8F\x93", "\x81\x39\xEA\x35", 2},
    {"\xE3\x8F\x96", "\x81\x39\xEA\x37", 113},
    {"\xE3\x91\x88", "\x81\x39\xF6\x30", 43},
    {"\xE3\x91\xB4", "\x81\x39\xFA\x33", 128},
    {"\xE3\x93\xB4", "\x82\x30\x89\x31", 128},
    {"\xE3\x95\xB4", "\x82\x30\x95\x39", 42},
    {"\xE3\x96\x9F", "\x82\x30\x9A\x31", 111},
    {"\xE3\x98\x8F", "\x82\x30\xA5\x32", 11},
    {"\xE3\x98\x9B", "\x82\x30\xA6\x33", 128},
    {"\xE3\x9A\x9B", "\x82\x30\xB3\x31", 128},
    {"\xE3\x9C\x9B", "\x82\x30\xBF\x39", 128},
    {"\xE3\x9E\x9B", "\x82\x30\xCC\x37", 128},
    {"\xE3\xA0\x9B", "\x82\x30\xD9\x35", 128},
    {"\xE3\xA2\x9B", "\x82\x30\xE6\x33", 125},
    {"\xE3\xA4\x99", "\x82\x30\xF2\x38", 85},
    {"\xE3\xA5\xAF", "\x82\x30\xFB\x33", 96},
    {"\xE3\xA7\x91", "\x82\x31\x86\x39", 14},
    {"\xE3\xA7\xA0", "\x82\x31\x88\x33", 128},
    {"\xE3\xA9\xA0", "\x82\x31\x95\x31", 19},
    {"\xE3\xA9\xB4", "\x82\x31\x97\x30", 128},
    {"\xE3\xAB\xB4", "\x82\x31\xA3\x38", 90},
    {"\xE3\xAD\x8F", "\x82\x31\xAC\x38", 128},
    {"\xE3\xAF\x8F", "\x82\x31\xB9\x36", 128},
    {"\xE3\xB1\x8F", "\x82\x31\xC6\x34", 31},
    {"\xE3\xB1\xAF", "\x82\x31\xC9\x35", 113},
    {"\xE3\xB3\xA1", "\x82\x31\xD4\x38", 128},
    {"\xE3\xB5\xA1", "\x82\x31\xE1\x36", 128},
    {"\xE3\xB7\xA1", "\x82\x31\xEE\x34", 128},
    {"\xE3\xB9\xA1", "\x82\x31\xFB\x32", 128},
    {"\xE3\xBB\xA1", "\x82\x32\x8A\x30", 128},
    {"\xE3\xBD\xA1", "\x82\x32\x96\x38", 128},
    {"\xE3\xBF\xA1", "\x82\x32\xA3\x36", 31},
    {"\xE4\x80\x80", "\x82\x32\xA6\x37", 86},
    {"\xE4\x81\x97", "\x82\x32\xAF\x33", 128},
    {"\xE4\x83\x97", "\x82\x32\xBC\x31", 128},
    {"\xE4\x85\x97", "\x82\x32\xC8\x39", 8},
    {"\xE4\x85\xA0", "\x82\x32\xC9\x37", 128},
    {"\xE4\x87\xA0", "\x82\x32\xD6\x35", 128},
    {"\xE4\x89\xA0", "\x82\x32\xE3\x33", 128},
    {"\xE4\x8B\xA0", "\x82\x32\xF0\x31", 87},
    {"\xE4\x8C\xB8", "\x82\x32\xF8\x38", 116},
    {"\xE4\x8E\xAD", "\x82\x33\x86\x34", 4},
    {"\xE4\x8E\xB2", "\x82\x33\x86\x38", 43},
    {"\xE4\x8F\x9E", "\x82\x33\x8B\x31", 128},
    {"\xE4\x91\x9E", "\x82\x33\x97\x39", 120},
    {"\xE4\x93\x97", "\x82\x33\xA3\x39", 128},
    {"\xE4\x95\x97", "\x82\x33\xB0\x37", 128},
    {"\xE4\x97\x97", "\x82\x33\xBD\x35", 117},
    {"\xE4\x99\x8D", "\x82\x33\xC9\x32", 20},
    {"\xE4\x99\xA2", "\x82\x33\xCB\x32", 128},
    {"\xE4\x9B\xA2", "\x82\x33\xD8\x30", 65},
    {"\xE4\x9C\xA4", "\x82\x33\xDE\x35", 5},
    {"\xE4\x9C\xAA", "\x82\x33\xDF\x30", 82},
    {"\xE4\x9D\xBD", "\x82\x33\xE7\x32", 16},
    {"\xE4\x9E\x8E", "\x82\x33\xE8\x38", 128},
    {"\xE4\xA0\x8E", "\x82\x33\xF5\x36", 128},
    {"\xE4\xA2\x8E", "\x82\x34\x84\x34", 128},
    {"\xE4\xA4\x8E", "\x82\x34\x91\x32", 57},
    {"\xE4\xA5\x88", "\x82\x34\x96\x39", 50},
    {"\xE4\xA5\xBB", "\x82\x34\x9B\x39", 2},
    {"\xE4\xA5\xBE", "\x82\x34\x9C\x31", 4},
    {"\xE4\xA6\x84", "\x82\x34\x9C\x35", 1},
    {"\xE4\xA6\x87", "\x82\x34\x9C\x36", 20},
    {"\xE4\xA6\x9C", "\x82\x34\x9E\x36", 3},
    {"\xE4\xA6\xA0", "\x82\x34\x9E\x39", 22},
    {"\xE4\xA6\xB8", "\x82\x34\xA1\x31", 128},
    {"\xE4\xA8\xB8", "\x82\x34\xAD\x39", 128},
    {"\xE4\xAA\xB8", "\x82\x34\xBA\x37", 128},
    {"\xE4\xAC\xB8", "\x82\x34\xC7\x35", 128},
    {"\xE4\xAE\xB8", "\x82\x34\xD4\x33", 128},
    {"\xE4\xB0\xB8", "\x82\x34\xE1\x31", 63},
    {"\xE4\xB1\xB8", "\x82\x34\xE7\x34", 39},
    {"\xE4\xB2\xA4", "\x82\x34\xEB\x33", 111},
    {"\xE4\xB4\x9A", "\x82\x34\xF6\x34", 128},
    {"\xE4\xB6\x9A", "\x82\x35\x85\x32", 20},
    {"\xE4\xB6\xAF", "\x82\x35\x87\x32", 81},
    {"\xE9\xBE\xA6", "\x82\x35\x8F\x33", 14},
    {"\xE9\xBE\xBC", "\x82\x35\x91\x35", 68},
    {"\xEA\x80\x80", "\x82\x35\x98\x33", 128},
    {"\xEA\x82\x80", "\x82\x35\xA5\x31", 128},
    {"\xEA\x84\x80", "\x82\x35\xB1\x39", 128},
    {"\xEA\x86\x80", "\x82\x35\xBE\x37", 128},
    {"\xEA\x88\x80", "\x82\x35\xCB\x35", 128},
    {"\xEA\x8A\x80", "\x82\x35\xD8\x33", 128},
    {"\xEA\x8C\x80", "\x82\x35\xE5\x31", 128},
    {"\xEA\x8E\x80", "\x82\x35\xF1\x39", 128},
    {"\xEA\x90\x80", "\x82\x35\xFE\x37", 128},
    {"\xEA\x92\x80", "\x82\x36\x8D\x35", 128},
    {"\xEA\x94\x80", "\x82\x36\x9A\x33", 128},
    {"\xEA\x96\x80", "\x82\x36\xA7\x31", 128},
    {"\xEA\x98\x80", "\x82\x36\xB3\x39", 128},
    {"\xEA\x9A\x80", "\x82\x36\xC0\x37", 128},
    {"\xEA\x9C\x80", "\x82\x36\xCD\x35", 128},
    {"\xEA\x9E\x80", "\x82\x36\xDA\x33", 128},
    {"\xEA\xA0\x80", "\x82\x36\xE7\x31", 128},
    {"\xEA\xA2\x80", "\x82\x36\xF3\x39", 128},
    {"\xEA\xA4\x80", "\x82\x37\x82\x37", 128},
    {"\xEA\xA6\x80", "\x82\x37\x8F\x35", 128},
    {"\xEA\xA8\x80", "\x82\x37\x9C\x33", 128},
    {"\xEA\xAA\x80", "\x82\x37\xA9\x31", 128},
    {"\xEA\xAC\x80", "\x82\x37\xB5\x39", 128},
    {"\xEA\xAE\x80", "\x82\x37\xC2\x37", 128},
    {"\xEA\xB0\x80", "\x82\x37\xCF\x35", 128},
    {"\xEA\xB2\x80", "\x82\x37\xDC\x33", 128},
    {"\xEA\xB4\x80", "\x82\x37\xE9\x31", 128},
    {"\xEA\xB6\x80", "\x82\x37\xF5\x39", 128},
    {"\xEA\xB8\x80", "\x82\x38\x84\x37", 128},
    {"\xEA\xBA\x80", "\x82\x38\x91\x35", 128},
    {"\xEA\xBC\x80", "\x82\x38\x9E\x33", 128},
    {"\xEA\xBE\x80", "\x82\x38\xAB\x31", 128},
    {"\xEB\x80\x80", "\x82\x38\xB7\x39", 128},
    {"\xEB\x82\x80", "\x82\x38\xC4\x37", 128},
    {"\xEB\x84\x80", "\x82\x38\xD1\x35", 128},
    {"\xEB\x86\x80", "\x82\x38\xDE\x33", 128},
    {"\xEB\x88\x80", "\x82\x38\xEB\x31", 128},
    {"\xEB\x8A\x80", "\x82\x38\xF7\x39", 128},
    {"\xEB\x8C\x80", "\x82\x39\x86\x37", 128},
    {"\xEB\x8E\x80", "\x82\x39\x93\x35", 128},
    {"\xEB\x90\x80", "\x82\x39\xA0\x33", 128},
    {"\xEB\x92\x80", "\x82\x39\xAD\x31", 128},
    {"\xEB\x94\x80", "\x82\x39\xB9\x39", 128},
    {"\xEB\x96\x80", "\x82\x39\xC6\x37", 128},
    {"\xEB\x98\x80", "\x82\x39\xD3\x35", 128},
    {"\xEB\x9A\x80", "\x82\x39\xE0\x33", 128},
    {"\xEB\x9C\x80", "\x82\x39\xED\x31", 128},
    {"\xEB\x9E\x80", "\x82\x39\xF9\x39", 128},
    {"\xEB\xA0\x80", "\x83\x30\x88\x37", 128},
    {"\xEB\xA2\x80", "\x83\x30\x95\x35", 128},
    {"\xEB\xA4\x80", "\x83\x30\xA2\x33", 128},
    {"\xEB\xA6\x80", "\x83\x30\xAF\x31", 128},
    {"\xEB\xA8\x80", "\x83\x30\xBB\x39", 128},
    {"\xEB\xAA\x80", "\x83\x30\xC8\x37", 128},
    {"\xEB\xAC\x80", "\x83\x30\xD5\x35", 128},
    {"\xEB\xAE\x80", "\x83\x30\xE2\x33", 128},
    {"\xEB\xB0\x80", "\x83\x30\xEF\x31", 128},
    {"\xEB\xB2\x80", "\x83\x30\xFB\x39", 128},
    {"\xEB\xB4\x80", "\x83\x31\x8A\x37", 128},
    {"\xEB\xB6\x80", "\x83\x31\x97\x35", 128},
    {"\xEB\xB8\x80", "\x83\x31\xA4\x33", 128},
    {"\xEB\xBA\x80", "\x83\x31\xB1\x31", 128},
    {"\xEB\xBC\x80", "\x83\x31\xBD\x39", 128},
    {"\xEB\xBE\x80", "\x83\x31\xCA\x37", 128},
    {"\xEC\x80\x80", "\x83\x31\xD7\x35", 128},
    {"\xEC\x82\x80", "\x83\x31\xE4\x33", 128},
    {"\xEC\x84\x80", "\x83\x31\xF1\x31", 128},
    {"\xEC\x86\x80", "\x83\x31\xFD\x39", 128},
    {"\xEC\x88\x80", "\x83\x32\x8C\x37", 128},
    {"\xEC\x8A\x80", "\x83\x32\x99\x35", 128},
    {"\xEC\x8C\x80", "\x83\x32\xA6\x33", 128},
    {"\xEC\x8E\x80", "\x83\x32\xB3\x31", 128},
    {"\xEC\x90\x80", "\x83\x32\xBF\x39", 128},
    {"\xEC\x92\x80", "\x83\x32\xCC\x37", 128},
    {"\xEC\x94\x80", "\x83\x32\xD9\x35", 128},
    {"\xEC\x96\x80", "\x83\x32\xE6\x33", 128},
    {"\xEC\x98\x80", "\x83\x32\xF3\x31", 128},
    {"\xEC\x9A\x80", "\x83\x33\x81\x39", 128},
    {"\xEC\x9C\x80", "\x83\x33\x8E\x37", 128},
    {"\xEC\x9E\x80", "\x83\x33\x9B\x35", 128},
    {"\xEC\xA0\x80", "\x83\x33\xA8\x33", 128},
    {"\xEC\xA2\x80", "\x83\x33\xB5\x31", 128},
    {"\xEC\xA4\x80", "\x83\x33\xC1\x39", 128},
    {"\xEC\xA6\x80", "\x83\x33\xCE\x37", 128},
    {"\xEC\xA8\x80", "\x83\x33\xDB\x35", 128},
    {"\xEC\xAA\x80", "\x83\x33\xE8\x33", 128},
    {"\xEC\xAC\x80", "\x83\x33\xF5\x31", 128},
    {"\xEC\xAE\x80", "\x83\x34\x83\x39", 128},
    {"\xEC\xB0\x80", "\x83\x34\x90\x37", 128},
    {"\xEC\xB2\x80", "\x83\x34\x9D\x35", 128},
    {"\xEC\xB4\x80", "\x83\x34\xAA\x33", 128},
    {"\xEC\xB6\x80", "\x83\x34\xB7\x31", 128},
    {"\xEC\xB8\x80", "\x83\x34\xC3\x39", 128},
    {"\xEC\xBA\x80", "\x83\x34\xD0\x37", 128},
    {"\xEC\xBC\x80", "\x83\x34\xDD\x35", 128},
    {"\xEC\xBE\x80", "\x83\x34\xEA\x33", 128},
    {"\xED\x80\x80", "\x83\x34\xF7\x31", 128},
    {"\xED\x82\x80", "\x83\x35\x85\x39", 128},
    {"\xED\x84\x80", "\x83\x35\x92\x37", 128},
    {"\xED\x86\x80", "\x83\x35\x9F\x35", 128},
    {"\xED\x88\x80", "\x83\x35\xAC\x33", 128},
    {"\xED\x8A\x80", "\x83\x35\xB9\x31", 128},
    {"\xED\x8C\x80", "\x83\x35\xC5\x39", 128},
    {"\xED\x8E\x80", "\x83\x35\xD2\x37", 128},
    {"\xED\x90\x80", "\x83\x35\xDF\x35", 128},
    {"\xED\x92\x80", "\x83\x35\xEC\x33", 128},
    {"\xED\x94\x80", "\x83\x35\xF9\x31", 128},
    {"\xED\x96\x80", "\x83\x36\x87\x39", 128},
    {"\xED\x98\x80", "\x83\x36\x94\x37", 128},
    {"\xED\x9A\x80", "\x83\x36\xA1\x35", 128},
    {"\xED\x9C\x80", "\x83\x36\xAE\x33", 128},
    {"\xED\x9E\x80", "\x83\x36\xBB\x31", 128},
    {"\xEE\x9D\xAC", "\x83\x36\xC7\x39", 1},
    {"\xEE\x9F\x87", "\x81\x35\xF4\x37", 1},
    {"\xEE\x9F\x88", "\x83\x36\xC8\x30", 1},
    {"\xEE\x9F\xA7", "\x83\x36\xC8\x31", 13},
    {"\xEE\xA0\x95", "\x83\x36\xC9\x34", 1},
    {"\xEE\xA0\x99", "\x83\x36\xC9\x35", 5},
    {"\xEE\xA0\x9F", "\x83\x36\xCA\x30", 7},
    {"\xEE\xA0\xA7", "\x83\x36\xCA\x37", 4},
    {"\xEE\xA0\xAD", "\x83\x36\xCB\x31", 4},
    {"\xEE\xA0\xB3", "\x83\x36\xCB\x35", 8},
    {"\xEE\xA0\xBC", "\x83\x36\xCC\x33", 7},
    {"\xEE\xA1\x84", "\x83\x36\xCD\x30", 16},
    {"\xEE\xA1\x96", "\x83\x36\xCE\x36", 14},
    {"\xEE\xA1\xA5", "\x83\x36\xD0\x30", 128},
    {"\xEE\xA3\xA5", "\x83\x36\xDC\x38", 128},
    {"\xEE\xA5\xA5", "\x83\x36\xE9\x36", 128},
    {"\xEE\xA7\xA5", "\x83\x36\xF6\x34", 128},
    {"\xEE\xA9\xA5", "\x83\x37\x85\x32", 128},
    {"\xEE\xAB\xA5", "\x83\x37\x92\x30", 128},
    {"\xEE\xAD\xA5", "\x83\x37\x9E\x38", 128},
    {"\xEE\xAF\xA5", "\x83\x37\xAB\x36", 128},
    {"\xEE\xB1\xA5", "\x83\x37\xB8\x34", 128},
    {"\xEE\xB3\xA5", "\x83\x37\xC5\x32", 128},
    {"\xEE\xB5\xA5", "\x83\x37\xD2\x30", 128},
    {"\xEE\xB7\xA5", "\x83\x37\xDE\x38", 128},
    {"\xEE\xB9\xA5", "\x83\x37\xEB\x36", 128},
    {"\xEE\xBB\xA5", "\x83\x37\xF8\x34", 128},
    {"\xEE\xBD\xA5", "\x83\x38\x87\x32", 128},
    {"\xEE\xBF\xA5", "\x83\x38\x94\x30", 27},
    {"\xEF\x80\x80", "\x83\x38\x96\x37", 128},
    {"\xEF\x82\x80", "\x83\x38\xA3\x35", 128},
    {"\xEF\x84\x80", "\x83\x38\xB0\x33", 128},
    {"\xEF\x86\x80", "\x83\x38\xBD\x31", 128},
    {"\xEF\x88\x80", "\x83\x38\xC9\x39", 128},
    {"\xEF\x8A\x80", "\x83\x38\xD6\x37", 128},
    {"\xEF\x8C\x80", "\x83\x38\xE3\x35", 128},
    {"\xEF\x8E\x80", "\x83\x38\xF0\x33", 128},
    {"\xEF\x90\x80", "\x83\x38\xFD\x31", 128},
    {"\xEF\x92\x80", "\x83\x39\x8B\x39", 128},
    {"\xEF\x94\x80", "\x83\x39\x98\x37", 128},
    {"\xEF\x96\x80", "\x83\x39\xA5\x35", 128},
    {"\xEF\x98\x80", "\x83\x39\xB2\x33", 128},
    {"\xEF\x9A\x80", "\x83\x39\xBF\x31", 128},
    {"\xEF\x9C\x80", "\x83\x39\xCB\x39", 128},
    {"\xEF\x9E\x80", "\x83\x39\xD8\x37", 128},
    {"\xEF\xA0\x80", "\x83\x39\xE5\x35", 128},
    {"\xEF\xA2\x80", "\x83\x39\xF2\x33", 128},
    {"\xEF\xA4\x80", "\x84\x30\x81\x31", 44},
    {"\xEF\xA4\xAD", "\x84\x30\x85\x35", 76},
    {"\xEF\xA5\xBA", "\x84\x30\x8D\x31", 27},
    {"\xEF\xA6\x96", "\x84\x30\x8F\x38", 81},
    {"\xEF\xA7\xA8", "\x84\x30\x97\x39", 9},
    {"\xEF\xA7\xB2", "\x84\x30\x98\x38", 26},
    {"\xEF\xA8\x90", "\x84\x30\x9B\x34", 1},
    {"\xEF\xA8\x92", "\x84\x30\x9B\x35", 1},
    {"\xEF\xA8\x95", "\x84\x30\x9B\x36", 3},
    {"\xEF\xA8\x99", "\x84\x30\x9B\x39", 6},
    {"\xEF\xA8\xA2", "\x84\x30\x9C\x35", 1},
    {"\xEF\xA8\xA5", "\x84\x30\x9C\x36", 2},
    {"\xEF\xA8\xAA", "\x84\x30\x9C\x38", 128},
    {"\xEF\xAA\xAA", "\x84\x30\xA9\x36", 128},
    {"\xEF\xAC\xAA", "\x84\x30\xB6\x34", 128},
    {"\xEF\xAE\xAA", "\x84\x30\xC3\x32", 128},
    {"\xEF\xB0\xAA", "\x84\x30\xD0\x30", 128},
    {"\xEF\xB2\xAA", "\x84\x30\xDC\x38", 128},
    {"\xEF\xB4\xAA", "\x84\x30\xE9\x36", 128},
    {"\xEF\xB6\xAA", "\x84\x30\xF6\x34", 102},
    {"\xEF\xB8\x9A", "\x84\x31\x83\x36", 22},
    {"\xEF\xB8\xB2", "\x84\x31\x85\x38", 1},
    {"\xEF\xB9\x85", "\x84\x31\x85\x39", 4},
    {"\xEF\xB9\x93", "\x84\x31\x86\x33", 1},
    {"\xEF\xB9\x98", "\x84\x31\x86\x34", 1},
    {"\xEF\xB9\xA7", "\x84\x31\x86\x35", 1},
    {"\xEF\xB9\xAC", "\x84\x31\x86\x36", 128},
    {"\xEF\xBB\xAC", "\x84\x31\x93\x34", 21},
    {"\xEF\xBD\x9F", "\x84\x31\x95\x35", 128},
    {"\xEF\xBF\x9F", "\x84\x31\xA2\x33", 1},
    {"\xEF\xBF\xA6", "\x84\x31\xA2\x34", 26},
    {"\xF0\x90\x80\x80", "\x90\x30\x81\x30", 128},
    {"\xF0\x90\x82\x80", "\x90\x30\x8D\x38", 128},
    {"\xF0\x90\x84\x80", "\x90\x30\x9A\x36", 128},
    {"\xF0\x90\x86\x80", "\x90\x30\xA7\x34", 128},
    {"\xF0\x90\x88\x80", "\x90\x30\xB4\x32", 128},
    {"\xF0\x90\x8A\x80", "\x90\x30\xC1\x30", 128},
    {"\xF0\x90\x8C\x80", "\x90\x30\xCD\x38", 128},
    {"\xF0\x90\x8E\x80", "\x90\x30\xDA\x36", 128},
    {"\xF0\x90\x90\x80", "\x90\x30\xE7\x34", 128},
    {"\xF0\x90\x92\x80", "\x90\x30\xF4\x32", 128},
    {"\xF0\x90\x94\x80", "\x90\x31\x83\x30", 128},
    {"\xF0\x90\x96\x80", "\x90\x31\x8F\x38", 128},
    {"\xF0\x90\x98\x80", "\x90\x31\x9C\x36", 128},
    {"\xF0\x90\x9A\x80", "\x90\x31\xA9\x34", 128},
    {"\xF0\x90\x9C\x80", "\x90\x31\xB6\x32", 128},
    {"\xF0\x90\x9E\x80", "\x90\x31\xC3\x30", 128},
    {"\xF0\x90\xA0\x80", "\x90\x31\xCF\x38", 128},
    {"\xF0\x90\xA2\x80", "\x90\x31\xDC\x36", 128},
    {"\xF0\x90\xA4\x80", "\x90\x31\xE9\x34", 128},
    {"\xF0\x90\xA6\x80", "\x90\x31\xF6\x32", 128},
    {"\xF0\x90\xA8\x80", "\x90\x32\x85\x30", 128},
    {"\xF0\x90\xAA\x80", "\x90\x32\x91\x38", 128},
    {"\xF0\x90\xAC\x80", "\x90\x32\x9E\x36", 128},
    {"\xF0\x90\xAE\x80", "\x90\x32\xAB\x34", 128},
    {"\xF0\x90\xB0\x80", "\x90\x32\xB8\x32", 128},
    {"\xF0\x90\xB2\x80", "\x90\x32\xC5\x30", 128},
    {"\xF0\x90\xB4\x80", "\x90\x32\xD1\x38", 128},
    {"\xF0\x90\xB6\x80", "\x90\x32\xDE\x36", 128},
    {"\xF0\x90\xB8\x80", "\x90\x32\xEB\x34", 128},
    {"\xF0\x90\xBA\x80", "\x90\x32\xF8\x32", 128},
    {"\xF0\x90\xBC\x80", "\x90\x33\x87\x30", 128},
    {"\xF0\x90\xBE\x80", "\x90\x33\x93\x38", 128},
    {"\xF0\x91\x80\x80", "\x90\x33\xA0\x36", 128},
    {"\xF0\x91\x82\x80", "\x90\x33\xAD\x34", 128},
    {"\xF0\x91\x84\x80", "\x90\x33\xBA\x32", 128},
    {"\xF0\x91\x86\x80", "\x90\x33\xC7\x30", 128},
    {"\xF0\x91\x88\x80", "\x90\x33\xD3\x38", 128},
    {"\xF0\x91\x8A\x80", "\x90\x33\xE0\x36", 128},
    {"\xF0\x91\x8C\x80", "\x90\x33\xED\x34", 128},
    {"\xF0\x91\x8E\x80", "\x90\x33\xFA\x32", 128},
    {"\xF0\x91\x90\x80", "\x90\x34\x89\x30", 128},
    {"\xF0\x91\x92\x80", "\x90\x34\x95\x38", 128},
    {"\xF0\x91\x94\x80", "\x90\x34\xA2\x36", 128},
    {"\xF0\x91\x96\x80", "\x90\x34\xAF\x34", 128},
    {"\xF0\x91\x98\x80", "\x90\x34\xBC\x32", 128},
    {"\xF0\x91\x9A\x80", "\x90\x34\xC9\x30", 128},
    {"\xF0\x91\x9C\x80", "\x90\x34\xD5\x38", 128},
    {"\xF0\x91\x9E\x80", "\x90\x34\xE2\x36", 128},
    {"\xF0\x91\xA0\x80", "\x90\x34\xEF\x34", 128},
    {"\xF0\x91\xA2\x80", "\x90\x34\xFC\x32", 128},
    {"\xF0\x91\xA4\x80", "\x90\x35\x8B\x30", 128},
    {"\xF0\x91\xA6\x80", "\x90\x35\x97\x38", 128},
    {"\xF0\x91\xA8\x80", "\x90\x35\xA4\x36", 128},
    {"\xF0\x91\xAA\x80", "\x90\x35\xB1\x34", 128},
    {"\xF0\x91\xAC\x80", "\x90\x35\xBE\x32", 128},
    {"\xF0\x91\xAE\x80", "\x90\x35\xCB\x30", 128},
    {"\xF0\x91\xB0\x80", "\x90\x35\xD7\x38", 128},
    {"\xF0\x91\xB2\x80", "\x90\x35\xE4\x36", 128},
    {"\xF0\x91\xB4\x80", "\x90\x35\xF1\x34", 128},
    {"\xF0\x91\xB6\x80", "\x90\x35\xFE\x32", 128},
    {"\xF0\x91\xB8\x80", "\x90\x36\x8D\x30", 128},
    {"\xF0\x91\xBA\x80", "\x90\x36\x99\x38", 128},
    {"\xF0\x91\xBC\x80", "\x90\x36\xA6\x36", 128},
    {"\xF0\x91\xBE\x80", "\x90\x36\xB3\x34", 128},
    {"\xF0\x92\x80\x80", "\x90\x36\xC0\x32", 128},
    {"\xF0\x92\x82\x80", "\x90\x36\xCD\x30", 128},
    {"\xF0\x92\x84\x80", "\x90\x36\xD9\x38", 128},
    {"\xF0\x92\x86\x80", "\x90\x36\xE6\x36", 128},
    {"\xF0\x92\x88\x80", "\x90\x36\xF3\x34", 128},
    {"\xF0\x92\x8A\x80", "\x90\x37\x82\x32", 128},
    {"\xF0\x92\x8C\x80", "\x90\x37\x8F\x30", 128},
    {"\xF0\x92\x8E\x80", "\x90\x37\x9B\x38", 128},
    {"\xF0\x92\x90\x80", "\x90\x37\xA8\x36", 128},
    {"\xF0\x92\x92\x80", "\x90\x37\xB5\x34", 128},
    {"\xF0\x92\x94\x80", "\x90\x37\xC2\x32", 128},
    {"\xF0\x92\x96\x80", "\x90\x37\xCF\x30", 128},
    {"\xF0\x92\x98\x80", "\x90\x37\xDB\x38", 128},
    {"\xF0\x92\x9A\x80", "\x90\x37\xE8\x36", 128},
    {"\xF0\x92\x9C\x80", "\x90\x37\xF5\x34", 128},
    {"\xF0\x92\x9E\x80", "\x90\x38\x84\x32", 128},
    {"\xF0\x92\xA0\x80", "\x90\x38\x91\x30", 128},
    {"\xF0\x92\xA2\x80", "\x90\x38\x9D\x38", 128},
    {"\xF0\x92\xA4\x80", "\x90\x38\xAA\x36", 128},
    {"\xF0\x92\xA6\x80", "\x90\x38\xB7\x34", 128},
    {"\xF0\x92\xA8\x80", "\x90\x38\xC4\x32", 128},
    {"\xF0\x92\xAA\x80", "\x90\x38\xD1\x30", 128},
    {"\xF0\x92\xAC\x80", "\x90\x38\xDD\x38", 128},
    {"\xF0\x92\xAE\x80", "\x90\x38\xEA\x36", 128},
    {"\xF0\x92\xB0\x80", "\x90\x38\xF7\x34", 128},
    {"\xF0\x92\xB2\x80", "\x90\x39\x86\x32", 128},
    {"\xF0\x92\xB4\x80", "\x90\x39\x93\x30", 128},
    {"\xF0\x92\xB6\x80", "\x90\x39\x9F\x38", 128},
    {"\xF0\x92\xB8\x80", "\x90\x39\xAC\x36", 128},
    {"\xF0\x92\xBA\x80", "\x90\x39\xB9\x34", 128},
    {"\xF0\x92\xBC\x80", "\x90\x39\xC6\x32", 128},
    {"\xF0\x92\xBE\x80", "\x90\x39\xD3\x30", 128},
    {"\xF0\x93\x80\x80", "\x90\x39\xDF\x38", 128},
    {"\xF0\x93\x82\x80", "\x90\x39\xEC\x36", 128},
    {"\xF0\x93\x84\x80", "\x90\x39\xF9\x34", 128},
    {"\xF0\x93\x86\x80", "\x91\x30\x88\x32", 128},
    {"\xF0\x93\x88\x80", "\x91\x30\x95\x30", 128},
    {"\xF0\x93\x8A\x80", "\x91\x30\xA1\x38", 128},
    {"\xF0\x93\x8C\x80", "\x91\x30\xAE\x36", 128},
    {"\xF0\x93\x8E\x80", "\x91\x30\xBB\x34", 128},
    {"\xF0\x93\x90\x80", "\x91\x30\xC8\x32", 128},
    {"\xF0\x93\x92\x80", "\x91\x30\xD5\x30", 128},
    {"\xF0\x93\x94\x80", "\x91\x30\xE1\x38", 128},
    {"\xF0\x93\x96\x80", "\x91\x30\xEE\x36", 128},
    {"\xF0\x93\x98\x80", "\x91\x30\xFB\x34", 128},
    {"\xF0\x93\x9A\x80", "\x91\x31\x8A\x32", 128},
    {"\xF0\x93\x9C\x80", "\x91\x31\x97\x30", 128},
    {"\xF0\x93\x9E\x80", "\x91\x31\xA3\x38", 128},
    {"\xF0\x93\xA0\x80", "\x91\x31\xB0\x36", 128},
    {"\xF0\x93\xA2\x80", "\x91\x31\xBD\x34", 128},
    {"\xF0\x93\xA4\x80", "\x91\x31\xCA\x32", 128},
    {"\xF0\x93\xA6\x80", "\x91\x31\xD7\x30", 128},
    {"\xF0\x93\xA8\x80", "\x91\x31\xE3\x38", 128},
    {"\xF0\x93\xAA\x80", "\x91\x31\xF0\x36", 128},
    {"\xF0\x93\xAC\x80", "\x91\x31\xFD\x34", 128},
    {"\xF0\x93\xAE\x80", "\x91\x32\x8C\x32", 128},
    {"\xF0\x93\xB0\x80", "\x91\x32\x99\x30", 128},
    {"\xF0\x93\xB2\x80", "\x91\x32\xA5\x38", 128},
    {"\xF0\x93\xB4\x80", "\x91\x32\xB2\x36", 128},
    {"\xF0\x93\xB6\x80", "\x91\x32\xBF\x34", 128},
    {"\xF0\x93\xB8\x80", "\x91\x32\xCC\x32", 128},
    {"\xF0\x93\xBA\x80", "\x91\x32\xD9\x30", 128},
    {"\xF0\x93\xBC\x80", "\x91\x32\xE5\x38", 128},
    {"\xF0\x93\xBE\x80", "\x91\x32\xF2\x36", 128},
    {"\xF0\x94\x80\x80", "\x91\x33\x81\x34", 128},
    {"\xF0\x94\x82\x80", "\x91\x33\x8E\x32", 128},
    {"\xF0\x94\x84\x80", "\x91\x33\x9B\x30", 128},
    {"\xF0\x94\x86\x80", "\x91\x33\xA7\x38", 128},
    {"\xF0\x94\x88\x80", "\x91\x33\xB4\x36", 128},
    {"\xF0\x94\x8A\x80", "\x91\x33\xC1\x34", 128},
    {"\xF0\x94\x8C\x80", "\x91\x33\xCE\x32", 128},
    {"\xF0\x94\x8E\x80", "\x91\x33\xDB\x30", 128},
    {"\xF0\x94\x90\x80", "\x91\x33\xE7\x38", 128},
    {"\xF0\x94\x92\x80", "\x91\x33\xF4\x36", 128},
    {"\xF0\x94\x94\x80", "\x91\x34\x83\x34", 128},
    {"\xF0\x94\x96\x80", "\x91\x34\x90\x32", 128},
    {"\xF0\x94\x98\x80", "\x91\x34\x9D\x30", 128},
    {"\xF0\x94\x9A\x80", "\x91\x34\xA9\x38", 128},
    {"\xF0\x94\x9C\x80", "\x91\x34\xB6\x36", 128},
    {"\xF0\x94\x9E\x80", "\x91\x34\xC3\x34", 128},
    {"\xF0\x94\xA0\x80", "\x91\x34\xD0\x32", 128},
    {"\xF0\x94\xA2\x80", "\x91\x34\xDD\x30", 128},
    {"\xF0\x94\xA4\x80", "\x91\x34\xE9\x38", 128},
    {"\xF0\x94\xA6\x80", "\x91\x34\xF6\x36", 128},
    {"\xF0\x94\xA8\x80", "\x91\x35\x85\x34", 128},
    {"\xF0\x94\xAA\x80", "\x91\x35\x92\x32", 128},
    {"\xF0\x94\xAC\x80", "\x91\x35\x9F\x30", 128},
    {"\xF0\x94\xAE\x80", "\x91\x35\xAB\x38", 128},
    {"\xF0\x94\xB0\x80", "\x91\x35\xB8\x36", 128},
    {"\xF0\x94\xB2\x80", "\x91\x35\xC5\x34", 128},
    {"\xF0\x94\xB4\x80", "\x91\x35\xD2\x32", 128},
    {"\xF0\x94\xB6\x80", "\x91\x35\xDF\x30", 128},
    {"\xF0\x94\xB8\x80", "\x91\x35\xEB\x38", 128},
    {"\xF0\x94\xBA\x80", "\x91\x35\xF8\x36", 128},
    {"\xF0\x94\xBC\x80", "\x91\x36\x87\x34", 128},
    {"\xF0\x94\xBE\x80", "\x91\x36\x94\x32", 128},
    {"\xF0\x95\x80\x80", "\x91\x36\xA1\x30", 128},
    {"\xF0\x95\x82\x80", "\x91\x36\xAD\x38", 128},
    {"\xF0\x95\x84\x80", "\x91\x36\xBA\x36", 128},
    {"\xF0\x95\x86\x80", "\x91\x36\xC7\x34", 128},
    {"\xF0\x95\x88\x80", "\x91\x36\xD4\x32", 128},
    {"\xF0\x95\x8A\x80", "\x91\x36\xE1\x30", 128},
    {"\xF0\x95\x8C\x80", "\x91\x36\xED\x38", 128},
    {"\xF0\x95\x8E\x80", "\x91\x36\xFA\x36", 128},
    {"\xF0\x95\x90\x80", "\x91\x37\x89\x34", 128},
    {"\xF0\x95\x92\x80", "\x91\x37\x96\x32", 128},
    {"\xF0\x95\x94\x80", "\x91\x37\xA3\x30", 128},
    {"\xF0\x95\x96\x80", "\x91\x37\xAF\x38", 128},
    {"\xF0\x95\x98\x80", "\x91\x37\xBC\x36", 128},
    {"\xF0\x95\x9A\x80", "\x91\x37\xC9\x34", 128},
    {"\xF0\x95\x9C\x80", "\x91\x37\xD6\x32", 128},
    {"\xF0\x95\x9E\x80", "\x91\x37\xE3\x30", 128},
    {"\xF0\x95\xA0\x80", "\x91\x37\xEF\x38", 128},
    {"\xF0\x95\xA2\x80", "\x91\x37\xFC\x36", 128},
    {"\xF0\x95\xA4\x80", "\x91\x38\x8B\x34", 128},
    {"\xF0\x95\xA6\x80", "\x91\x38\x98\x32", 128},
    {"\xF0\x95\xA8\x80", "\x91\x38\xA5\x30", 128},
    {"\xF0\x95\xAA\x80", "\x91\x38\xB1\x38", 128},
    {"\xF0\x95\xAC\x80", "\x91\x38\xBE\x36", 128},
    {"\xF0\x95\xAE\x80", "\x91\x38\xCB\x34", 128},
    {"\xF0\x95\xB0\x80", "\x91\x38\xD8\x32", 128},
    {"\xF0\x95\xB2\x80", "\x91\x38\xE5\x30", 128},
    {"\xF0\x95\xB4\x80", "\x91\x38\xF1\x38", 128},
    {"\xF0\x95\xB6\x80", "\x91\x38\xFE\x36", 128},
    {"\xF0\x95\xB8\x80", "\x91\x39\x8D\x34", 128},
    {"\xF0\x95\xBA\x80", "\x91\x39\x9A\x32", 128},
    {"\xF0\x95\xBC\x80", "\x91\x39\xA7\x30", 128},
    {"\xF0\x95\xBE\x80", "\x91\x39\xB3\x38", 128},
    {"\xF0\x96\x80\x80", "\x91\x39\xC0\x36", 128},
    {"\xF0\x96\x82\x80", "\x91\x39\xCD\x34", 128},
    {"\xF0\x96\x84\x80", "\x91\x39\xDA\x32", 128},
    {"\xF0\x96\x86\x80", "\x91\x39\xE7\x30", 128},
    {"\xF0\x96\x88\x80", "\x91\x39\xF3\x38", 128},
    {"\xF0\x96\x8A\x80", "\x92\x30\x82\x36", 128},
    {"\xF0\x96\x8C\x80", "\x92\x30\x8F\x34", 128},
    {"\xF0\x96\x8E\x80", "\x92\x30\x9C\x32", 128},
    {"\xF0\x96\x90\x80", "\x92\x30\xA9\x30", 128},
    {"\xF0\x96\x92\x80", "\x92\x30\xB5\x38", 128},
    {"\xF0\x96\x94\x80", "\x92\x30\xC2\x36", 128},
    {"\xF0\x96\x96\x80", "\x92\x30\xCF\x34", 128},
    {"\xF0\x96\x98\x80", "\x92\x30\xDC\x32", 128},
    {"\xF0\x96\x9A\x80", "\x92\x30\xE9\x30", 128},
    {"\xF0\x96\x9C\x80", "\x92\x30\xF5\x38", 128},
    {"\xF0\x96\x9E\x80", "\x92\x31\x84\x36", 128},
    {"\xF0\x96\xA0\x80", "\x92\x31\x91\x34", 128},
    {"\xF0\x96\xA2\x80", "\x92\x31\x9E\x32", 128},
    {"\xF0\x96\xA4\x80", "\x92\x31\xAB\x30", 128},
    {"\xF0\x96\xA6\x80", "\x92\x31\xB7\x38", 128},
    {"\xF0\x96\xA8\x80", "\x92\x31\xC4\x36", 128},
    {"\xF0\x96\xAA\x80", "\x92\x31\xD1\x34", 128},
    {"\xF0\x96\xAC\x80", "\x92\x31\xDE\x32", 128},
    {"\xF0\x96\xAE\x80", "\x92\x31\xEB\x30", 128},
    {"\xF0\x96\xB0\x80", "\x92\x31\xF7\x38", 128},
    {"\xF0\x96\xB2\x80", "\x92\x32\x86\x36", 128},
    {"\xF0\x96\xB4\x80", "\x92\x32\x93\x34", 128},
    {"\xF0\x96\xB6\x80", "\x92\x32\xA0\x32", 128},
    {"\xF0\x96\xB8\x80", "\x92\x32\xAD\x30", 128},
    {"\xF0\x96\xBA\x80", "\x92\x32\xB9\x38", 128},
    {"\xF0\x96\xBC\x80", "\x92\x32\xC6\x36", 128},
    {"\xF0\x96\xBE\x80", "\x92\x32\xD3\x34", 128},
    {"\xF0\x97\x80\x80", "\x92\x32\xE0\x32", 128},
    {"\xF0\x97\x82\x80", "\x92\x32\xED\x30", 128},
    {"\xF0\x97\x84\x80", "\x92\x32\xF9\x38", 128},
    {"\xF0\x97\x86\x80", "\x92\x33\x88\x36", 128},
    {"\xF0\x97\x88\x80", "\x92\x33\x95\x34", 128},
    {"\xF0\x97\x8A\x80", "\x92\x33\xA2\x32", 128},
    {"\xF0\x97\x8C\x80", "\x92\x33\xAF\x30", 128},
    {"\xF0\x97\x8E\x80", "\x92\x33\xBB\x38", 128},
    {"\xF0\x97\x90\x80", "\x92\x33\xC8\x36", 128},
    {"\xF0\x97\x92\x80", "\x92\x33\xD5\x34", 128},
    {"\xF0\x97\x94\x80", "\x92\x33\xE2\x32", 128},
    {"\xF0\x97\x96\x80", "\x92\x33\xEF\x30", 128},
    {"\xF0\x97\x98\x80", "\x92\x33\xFB\x38", 128},
    {"\xF0\x97\x9A\x80", "\x92\x34\x8A\x36", 128},
    {"\xF0\x97\x9C\x80", "\x92\x34\x97\x34", 128},
    {"\xF0\x97\x9E\x80", "\x92\x34\xA4\x32", 128},
    {"\xF0\x97\xA0\x80", "\x92\x34\xB1\x30", 128},
    {"\xF0\x97\xA2\x80", "\x92\x34\xBD\x38", 128},
    {"\xF0\x97\xA4\x80", "\x92\x34\xCA\x36", 128},
    {"\xF0\x97\xA6\x80", "\x92\x34\xD7\x34", 128},
    {"\xF0\x97\xA8\x80", "\x92\x34\xE4\x32", 128},
    {"\xF0\x97\xAA\x80", "\x92\x34\xF1\x30", 128},
    {"\xF0\x97\xAC\x80", "\x92\x34\xFD\x38", 128},
    {"\xF0\x97\xAE\x80", "\x92\x35\x8C\x36", 128},
    {"\xF0\x97\xB0\x80", "\x92\x35\x99\x34", 128},
    {"\xF0\x97\xB2\x80", "\x92\x35\xA6\x32", 128},
    {"\xF0\x97\xB4\x80", "\x92\x35\xB3\x30", 128},
    {"\xF0\x97\xB6\x80", "\x92\x35\xBF\x38", 128},
    {"\xF0\x97\xB8\x80", "\x92\x35\xCC\x36", 128},
    {"\xF0\x97\xBA\x80", "\x92\x35\xD9\x34", 128},
    {"\xF0\x97\xBC\x80", "\x92\x35\xE6\x32", 128},
    {"\xF0\x97\xBE\x80", "\x92\x35\xF3\x30", 128},
    {"\xF0\x98\x80\x80", "\x92\x36\x81\x38", 128},
    {"\xF0\x98\x82\x80", "\x92\x36\x8E\x36", 128},
    {"\xF0\x98\x84\x80", "\x92\x36\x9B\x34", 128},
    {"\xF0\x98\x86\x80", "\x92\x36\xA8\x32", 128},
    {"\xF0\x98\x88\x80", "\x92\x36\xB5\x30", 128},
    {"\xF0\x98\x8A\x80", "\x92\x36\xC1\x38", 128},
    {"\xF0\x98\x8C\x80", "\x92\x36\xCE\x36", 128},
    {"\xF0\x98\x8E\x80", "\x92\x36\xDB\x34", 128},
    {"\xF0\x98\x90\x80", "\x92\x36\xE8\x32", 128},
    {"\xF0\x98\x92\x80", "\x92\x36\xF5\x30", 128},
    {"\xF0\x98\x94\x80", "\x92\x37\x83\x38", 128},
    {"\xF0\x98\x96\x80", "\x92\x37\x90\x36", 128},
    {"\xF0\x98\x98\x80", "\x92\x37\x9D\x34", 128},
    {"\xF0\x98\x9A\x80", "\x92\x37\xAA\x32", 128},
    {"\xF0\x98\x9C\x80", "\x92\x37\xB7\x30", 128},
    {"\xF0\x98\x9E\x80", "\x92\x37\xC3\x38", 128},
    {"\xF0\x98\xA0\x80", "\x92\x37\xD0\x36", 128},
    {"\xF0\x98\xA2\x80", "\x92\x37\xDD\x34", 128},
    {"\xF0\x98\xA4\x80", "\x92\x37\xEA\x32", 128},
    {"\xF0\x98\xA6\x80", "\x92\x37\xF7\x30", 128},
    {"\xF0\x98\xA8\x80", "\x92\x38\x85\x38", 128},
    {"\xF0\x98\xAA\x80", "\x92\x38\x92\x36", 128},
    {"\xF0\x98\xAC\x80", "\x92\x38\x9F\x34", 128},
    {"\xF0\x98\xAE\x80", "\x92\x38\xAC\x32", 128},
    {"\xF0\x98\xB0\x80", "\x92\x38\xB9\x30", 128},
    {"\xF0\x98\xB2\x80", "\x92\x38\xC5\x38", 128},
    {"\xF0\x98\xB4\x80", "\x92\x38\xD2\x36", 128},
    {"\xF0\x98\xB6\x80", "\x92\x38\xDF\x34", 128},
    {"\xF0\x98\xB8\x80", "\x92\x38\xEC\x32", 128},
    {"\xF0\x98\xBA\x80", "\x92\x38\xF9\x30", 128},
    {"\xF0\x98\xBC\x80", "\x92\x39\x87\x38", 128},
    {"\xF0\x98\xBE\x80", "\x92\x39\x94\x36", 128},
    {"\xF0\x99\x80\x80", "\x92\x39\xA1\x34", 128},
    {"\xF0\x99\x82\x80", "\x92\x39\xAE\x32", 128},
    {"\xF0\x99\x84\x80", "\x92\x39\xBB\x30", 128},
    {"\xF0\x99\x86\x80", "\x92\x39\xC7\x38", 128},
    {"\xF0\x99\x88\x80", "\x92\x39\xD4\x36", 128},
    {"\xF0\x99\x8A\x80", "\x92\x39\xE1\x34", 128},
    {"\xF0\x99\x8C\x80", "\x92\x39\xEE\x32", 128},
    {"\xF0\x99\x8E\x80", "\x92\x39\xFB\x30", 128},
    {"\xF0\x99\x90\x80", "\x93\x30\x89\x38", 128},
    {"\xF0\x99\x92\x80", "\x93\x30\x96\x36", 128},
    {"\xF0\x99\x94\x80", "\x93\x30\xA3\x34", 128},
    {"\xF0\x99\x96\x80", "\x93\x30\xB0\x32", 128},
    {"\xF0\x99\x98\x80", "\x93\x30\xBD\x30", 128},
    {"\xF0\x99\x9A\x80", "\x93\x30\xC9\x38", 128},
    {"\xF0\x99\x9C\x80", "\x93\x30\xD6\x36", 128},
    {"\xF0\x99\x9E\x80", "\x93\x30\xE3\x34", 128},
    {"\xF0\x99\xA0\x80", "\x93\x30\xF0\x32", 128},
    {"\xF0\x99\xA2\x80", "\x93\x30\xFD\x30", 128},
    {"\xF0\x99\xA4\x80", "\x93\x31\x8B\x38", 128},
    {"\xF0\x99\xA6\x80", "\x93\x31\x98\x36", 128},
    {"\xF0\x99\xA8\x80", "\x93\x31\xA5\x34", 128},
    {"\xF0\x99\xAA\x80", "\x93\x31\xB2\x32", 128},
    {"\xF0\x99\xAC\x80", "\x93\x31\xBF\x30", 128},
    {"\xF0\x99\xAE\x80", "\x93\x31\xCB\x38", 128},
    {"\xF0\x99\xB0\x80", "\x93\x31\xD8\x36", 128},
    {"\xF0\x99\xB2\x80", "\x93\x31\xE5\x34", 128},
    {"\xF0\x99\xB4\x80", "\x93\x31\xF2\x32", 128},
    {"\xF0\x99\xB6\x80", "\x93\x32\x81\x30", 128},
    {"\xF0\x99\xB8\x80", "\x93\x32\x8D\x38", 128},
    {"\xF0\x99\xBA\x80", "\x93\x32\x9A\x36", 128},
    {"\xF0\x99\xBC\x80", "\x93\x32\xA7\x34", 128},
    {"\xF0\x99\xBE\x80", "\x93\x32\xB4\x32", 128},
    {"\xF0\x9A\x80\x80", "\x93\x32\xC1\x30", 128},
    {"\xF0\x9A\x82\x80", "\x93\x32\xCD\x38", 128},
    {"\xF0\x9A\x84\x80", "\x93\x32\xDA\x36", 128},
    {"\xF0\x9A\x86\x80", "\x93\x32\xE7\x34", 128},
    {"\xF0\x9A\x88\x80", "\x93\x32\xF4\x32", 128},
    {"\xF0\x9A\x8A\x80", "\x93\x33\x83\x30", 128},
    {"\xF0\x9A\x8C\x80", "\x93\x33\x8F\x38", 128},
    {"\xF0\x9A\x8E\x80", "\x93\x33\x9C\x36", 128},
    {"\xF0\x9A\x90\x80", "\x93\x33\xA9\x34", 128},
    {"\xF0\x9A\x92\x80", "\x93\x33\xB6\x32", 128},
    {"\xF0\x9A\x94\x80", "\x93\x33\xC3\x30", 128},
    {"\xF0\x9A\x96\x80", "\x93\x33\xCF\x38", 128},
    {"\xF0\x9A\x98\x80", "\x93\x33\xDC\x36", 128},
    {"\xF0\x9A\x9A\x80", "\x93\x33\xE9\x34", 128},
    {"\xF0\x9A\x9C\x80", "\x93\x33\xF6\x32", 128},
    {"\xF0\x9A\x9E\x80", "\x93\x34\x85\x30", 128},
    {"\xF0\x9A\xA0\x80", "\x93\x34\x91\x38", 128},
    {"\xF0\x9A\xA2\x80", "\x93\x34\x9E\x36", 128},
    {"\xF0\x9A\xA4\x80", "\x93\x34\xAB\x34", 128},
    {"\xF0\x9A\xA6\x80", "\x93\x34\xB8\x32", 128},
    {"\xF0\x9A\xA8\x80", "\x93\x34\xC5\x30", 128},
    {"\xF0\x9A\xAA\x80", "\x93\x34\xD1\x38", 128},
    {"\xF0\x9A\xAC\x80", "\x93\x34\xDE\x36", 128},
    {"\xF0\x9A\xAE\x80", "\x93\x34\xEB\x34", 128},
    {"\xF0\x9A\xB0\x80", "\x93\x34\xF8\x32", 128},
    {"\xF0\x9A\xB2\x80", "\x93\x35\x87\x30", 128},
    {"\xF0\x9A\xB4\x80", "\x93\x35\x93\x38", 128},
    {"\xF0\x9A\xB6\x80", "\x93\x35\xA0\x36", 128},
    {"\xF0\x9A\xB8\x80", "\x93\x35\xAD\x34", 128},
    {"\xF0\x9A\xBA\x80", "\x93\x35\xBA\x32", 128},
    {"\xF0\x9A\xBC\x80", "\x93\x35\xC7\x30", 128},
    {"\xF0\x9A\xBE\x80", "\x93\x35\xD3\x38", 128},
    {"\xF0\x9B\x80\x80", "\x93\x35\xE0\x36", 128},
    {"\xF0\x9B\x82\x80", "\x93\x35\xED\x34", 128},
    {"\xF0\x9B\x84\x80", "\x93\x35\xFA\x32", 128},
    {"\xF0\x9B\x86\x80", "\x93\x36\x89\x30", 128},
    {"\xF0\x9B\x88\x80", "\x93\x36\x95\x38", 128},
    {"\xF0\x9B\x8A\x80", "\x93\x36\xA2\x36", 128},
    {"\xF0\x9B\x8C\x80", "\x93\x36\xAF\x34", 128},
    {"\xF0\x9B\x8E\x80", "\x93\x36\xBC\x32", 128},
    {"\xF0\x9B\x90\x80", "\x93\x36\xC9\x30", 128},
    {"\xF0\x9B\x92\x80", "\x93\x36\xD5\x38", 128},
    {"\xF0\x9B\x94\x80", "\x93\x36\xE2\x36", 128},
    {"\xF0\x9B\x96\x80", "\x93\x36\xEF\x34", 128},
    {"\xF0\x9B\x98\x80", "\x93\x36\xFC\x32", 128},
    {"\xF0\x9B\x9A\x80", "\x93\x37\x8B\x30", 128},
    {"\xF0\x9B\x9C\x80", "\x93\x37\x97\x38", 128},
    {"\xF0\x9B\x9E\x80", "\x93\x37\xA4\x36", 128},
    {"\xF0\x9B\xA0\x80", "\x93\x37\xB1\x34", 128},
    {"\xF0\x9B\xA2\x80", "\x93\x37\xBE\x32", 128},
    {"\xF0\x9B\xA4\x80", "\x93\x37\xCB\x30", 128},
    {"\xF0\x9B\xA6\x80", "\x93\x37\xD7\x38", 128},
    {"\xF0\x9B\xA8\x80", "\x93\x37\xE4\x36", 128},
    {"\xF0\x9B\xAA\x80", "\x93\x37\xF1\x34", 128},
    {"\xF0\x9B\xAC\x80", "\x93\x37\xFE\x32", 128},
    {"\xF0\x9B\xAE\x80", "\x93\x38\x8D\x30", 128},
    {"\xF0\x9B\xB0\x80", "\x93\x38\x99\x38", 128},
    {"\xF0\x9B\xB2\x80", "\x93\x38\xA6\x36", 128},
    {"\xF0\x9B\xB4\x80", "\x93\x38\xB3\x34", 128},
    {"\xF0\x9B\xB6\x80", "\x93\x38\xC0\x32", 128},
    {"\xF0\x9B\xB8\x80", "\x93\x38\xCD\x30", 128},
    {"\xF0\x9B\xBA\x80", "\x93\x38\xD9\x38", 128},
    {"\xF0\x9B\xBC\x80", "\x93\x38\xE6\x36", 128},
    {"\xF0\x9B\xBE\x80", "\x93\x38\xF3\x34", 128},
    {"\xF0\x9C\x80\x80", "\x93\x39\x82\x32", 128},
    {"\xF0\x9C\x82\x80", "\x93\x39\x8F\x30", 128},
    {"\xF0\x9C\x84\x80", "\x93\x39\x9B\x38", 128},
    {"\xF0\x9C\x86\x80", "\x93\x39\xA8\x36", 128},
    {"\xF0\x9C\x88\x80", "\x93\x39\xB5\x34", 128},
    {"\xF0\x9C\x8A\x80", "\x93\x39\xC2\x32", 128},
    {"\xF0\x9C\x8C\x80", "\x93\x39\xCF\x30", 128},
    {"\xF0\x9C\x8E\x80", "\x93\x39\xDB\x38", 128},
    {"\xF0\x9C\x90\x80", "\x93\x39\xE8\x36", 128},
    {"\xF0\x9C\x92\x80", "\x93\x39\xF5\x34", 128},
    {"\xF0\x9C\x94\x80", "\x94\x30\x84\x32", 128},
    {"\xF0\x9C\x96\x80", "\x94\x30\x91\x30", 128},
    {"\xF0\x9C\x98\x80", "\x94\x30\x9D\x38", 128},
    {"\xF0\x9C\x9A\x80", "\x94\x30\xAA\x36", 128},
    {"\xF0\x9C\x9C\x80", "\x94\x30\xB7\x34", 128},
    {"\xF0\x9C\x9E\x80", "\x94\x30\xC4\x32", 128},
    {"\xF0\x9C\xA0\x80", "\x94\x30\xD1\x30", 128},
    {"\xF0\x9C\xA2\x80", "\x94\x30\xDD\x38", 128},
    {"\xF0\x9C\xA4\x80", "\x94\x30\xEA\x36", 128},
    {"\xF0\x9C\xA6\x80", "\x94\x30\xF7\x34", 128},
    {"\xF0\x9C\xA8\x80", "\x94\x31\x86\x32", 128},
    {"\xF0\x9C\xAA\x80", "\x94\x31\x93\x30", 128},
    {"\xF0\x9C\xAC\x80", "\x94\x31\x9F\x38", 128},
    {"\xF0\x9C\xAE\x80", "\x94\x31\xAC\x36", 128},
    {"\xF0\x9C\xB0\x80", "\x94\x31\xB9\x34", 128},
    {"\xF0\x9C\xB2\x80", "\x94\x31\xC6\x32", 128},
    {"\xF0\x9C\xB4\x80", "\x94\x31\xD3\x30", 128},
    {"\xF0\x9C\xB6\x80", "\x94\x31\xDF\x38", 128},
    {"\xF0\x9C\xB8\x80", "\x94\x31\xEC\x36", 128},
    {"\xF0\x9C\xBA\x80", "\x94\x31\xF9\x34", 128},
    {"\xF0\x9C\xBC\x80", "\x94\x32\x88\x32", 128},
    {"\xF0\x9C\xBE\x80", "\x94\x32\x95\x30", 128},
    {"\xF0\x9D\x80\x80", "\x94\x32\xA1\x38", 128},
    {"\xF0\x9D\x82\x80", "\x94\x32\xAE\x36", 128},
    {"\xF0\x9D\x84\x80", "\x94\x32\xBB\x34", 128},
    {"\xF0\x9D\x86\x80", "\x94\x32\xC8\x32", 128},
    {"\xF0\x9D\x88\x80", "\x94\x32\xD5\x30", 128},
    {"\xF0\x9D\x8A\x80", "\x94\x32\xE1\x38", 128},
    {"\xF0\x9D\x8C\x80", "\x94\x32\xEE\x36", 128},
    {"\xF0\x9D\x8E\x80", "\x94\x32\xFB\x34", 128},
    {"\xF0\x9D\x90\x80", "\x94\x33\x8A\x32", 128},
    {"\xF0\x9D\x92\x80", "\x94\x33\x97\x30", 128},
    {"\xF0\x9D\x94\x80", "\x94\x33\xA3\x38", 128},
    {"\xF0\x9D\x96\x80", "\x94\x33\xB0\x36", 128},
    {"\xF0\x9D\x98\x80", "\x94\x33\xBD\x34", 128},
    {"\xF0\x9D\x9A\x80", "\x94\x33\xCA\x32", 128},
    {"\xF0\x9D\x9C\x80", "\x94\x33\xD7\x30", 128},
    {"\xF0\x9D\x9E\x80", "\x94\x33\xE3\x38", 128},
    {"\xF0\x9D\xA0\x80", "\x94\x33\xF0\x36", 128},
    {"\xF0\x9D\xA2\x80", "\x94\x33\xFD\x34", 128},
    {"\xF0\x9D\xA4\x80", "\x94\x34\x8C\x32", 128},
    {"\xF0\x9D\xA6\x80", "\x94\x34\x99\x30", 128},
    {"\xF0\x9D\xA8\x80", "\x94\x34\xA5\x38", 128},
    {"\xF0\x9D\xAA\x80", "\x94\x34\xB2\x36", 128},
    {"\xF0\x9D\xAC\x80", "\x94\x34\xBF\x34", 128},
    {"\xF0\x9D\xAE\x80", "\x94\x34\xCC\x32", 128},
    {"\xF0\x9D\xB0\x80", "\x94\x34\xD9\x30", 128},
    {"\xF0\x9D\xB2\x80", "\x94\x34\xE5\x38", 128},
    {"\xF0\x9D\xB4\x80", "\x94\x34\xF2\x36", 128},
    {"\xF0\x9D\xB6\x80", "\x94\x35\x81\x34", 128},
    {"\xF0\x9D\xB8\x80", "\x94\x35\x8E\x32", 128},
    {"\xF0\x9D\xBA\x80", "\x94\x35\x9B\x30", 128},
    {"\xF0\x9D\xBC\x80", "\x94\x35\xA7\x38", 128},
    {"\xF0\x9D\xBE\x80", "\x94\x35\xB4\x36", 128},
    {"\xF0\x9E\x80\x80", "\x94\x35\xC1\x34", 128},
    {"\xF0\x9E\x82\x80", "\x94\x35\xCE\x32", 128},
    {"\xF0\x9E\x84\x80", "\x94\x35\xDB\x30", 128},
    {"\xF0\x9E\x86\x80", "\x94\x35\xE7\x38", 128},
    {"\xF0\x9E\x88\x80", "\x94\x35\xF4\x36", 128},
    {"\xF0\x9E\x8A\x80", "\x94\x36\x83\x34", 128},
    {"\xF0\x9E\x8C\x80", "\x94\x36\x90\x32", 128},
    {"\xF0\x9E\x8E\x80", "\x94\x36\x9D\x30", 128},
    {"\xF0\x9E\x90\x80", "\x94\x36\xA9\x38", 128},
    {"\xF0\x9E\x92\x80", "\x94\x36\xB6\x36", 128},
    {"\xF0\x9E\x94\x80", "\x94\x36\xC3\x34", 128},
    {"\xF0\x9E\x96\x80", "\x94\x36\xD0\x32", 128},
    {"\xF0\x9E\x98\x80", "\x94\x36\xDD\x30", 128},
    {"\xF0\x9E\x9A\x80", "\x94\x36\xE9\x38", 128},
    {"\xF0\x9E\x9C\x80", "\x94\x36\xF6\x36", 128},
    {"\xF0\x9E\x9E\x80", "\x94\x37\x85\x34", 128},
    {"\xF0\x9E\xA0\x80", "\x94\x37\x92\x32", 128},
    {"\xF0\x9E\xA2\x80", "\x94\x37\x9F\x30", 128},
    {"\xF0\x9E\xA4\x80", "\x94\x37\xAB\x38", 128},
    {"\xF0\x9E\xA6\x80", "\x94\x37\xB8\x36", 128},
    {"\xF0\x9E\xA8\x80", "\x94\x37\xC5\x34", 128},
    {"\xF0\x9E\xAA\x80", "\x94\x37\xD2\x32", 128},
    {"\xF0\x9E\xAC\x80", "\x94\x37\xDF\x30", 128},
    {"\xF0\x9E\xAE\x80", "\x94\x37\xEB\x38", 128},
    {"\xF0\x9E\xB0\x80", "\x94\x37\xF8\x36", 128},
    {"\xF0\x9E\xB2\x80", "\x94\x38\x87\x34", 128},
    {"\xF0\x9E\xB4\x80", "\x94\x38\x94\x32", 128},
    {"\xF0\x9E\xB6\x80", "\x94\x38\xA1\x30", 128},
    {"\xF0\x9E\xB8\x80", "\x94\x38\xAD\x38", 128},
    {"\xF0\x9E\xBA\x80", "\x94\x38\xBA\x36", 128},
    {"\xF0\x9E\xBC\x80", "\x94\x38\xC7\x34", 128},
    {"\xF0\x9E\xBE\x80", "\x94\x38\xD4\x32", 128},
    {"\xF0\x9F\x80\x80", "\x94\x38\xE1\x30", 128},
    {"\xF0\x9F\x82\x80", "\x94\x38\xED\x38", 128},
    {"\xF0\x9F\x84\x80", "\x94\x38\xFA\x36", 128},
    {"\xF0\x9F\x86\x80", "\x94\x39\x89\x34", 128},
    {"\xF0\x9F\x88\x80", "\x94\x39\x96\x32", 128},
    {"\xF0\x9F\x8A\x80", "\x94\x39\xA3\x30", 128},
    {"\xF0\x9F\x8C\x80", "\x94\x39\xAF\x38", 128},
    {"\xF0\x9F\x8E\x80", "\x94\x39\xBC\x36", 128},
    {"\xF0\x9F\x90\x80", "\x94\x39\xC9\x34", 128},
    {"\xF0\x9F\x92\x80", "\x94\x39\xD6\x32", 128},
    {"\xF0\x9F\x94\x80", "\x94\x39\xE3\x30", 128},
    {"\xF0\x9F\x96\x80", "\x94\x39\xEF\x38", 128},
    {"\xF0\x9F\x98\x80", "\x94\x39\xFC\x36", 128},
    {"\xF0\x9F\x9A\x80", "\x95\x30\x8B\x34", 128},
    {"\xF0\x9F\x9C\x80", "\x95\x30\x98\x32", 128},
    {"\xF0\x9F\x9E\x80", "\x95\x30\xA5\x30", 128},
    {"\xF0\x9F\xA0\x80", "\x95\x30\xB1\x38", 128},
    {"\xF0\x9F\xA2\x80", "\x95\x30\xBE\x36", 128},
    {"\xF0\x9F\xA4\x80", "\x95\x30\xCB\x34", 128},
    {"\xF0\x9F\xA6\x80", "\x95\x30\xD8\x32", 128},
    {"\xF0\x9F\xA8\x80", "\x95\x30\xE5\x30", 128},
    {"\xF0\x9F\xAA\x80", "\x95\x30\xF1\x38", 128},
    {"\xF0\x9F\xAC\x80", "\x95\x30\xFE\x36", 128},
    {"\xF0\x9F\xAE\x80", "\x95\x31\x8D\x34", 128},
    {"\xF0\x9F\xB0\x80", "\x95\x31\x9A\x32", 128},
    {"\xF0\x9F\xB2\x80", "\x95\x31\xA7\x30", 128},
    {"\xF0\x9F\xB4\x80", "\x95\x31\xB3\x38", 128},
    {"\xF0\x9F\xB6\x80", "\x95\x31\xC0\x36", 128},
    {"\xF0\x9F\xB8\x80", "\x95\x31\xCD\x34", 128},
    {"\xF0\x9F\xBA\x80", "\x95\x31\xDA\x32", 128},
    {"\xF0\x9F\xBC\x80", "\x95\x31\xE7\x30", 128},
    {"\xF0\x9F\xBE\x80", "\x95\x31\xF3\x38", 128},
    {"\xF0\xA0\x80\x80", "\x95\x32\x82\x36", 128},
    {"\xF0\xA0\x82\x80", "\x95\x32\x8F\x34", 7},
    {"\xF0\xA0\x82\x88", "\x95\x32\x90\x32", 1},
    {"\xF0\xA0\x82\x8A", "\x95\x32\x90\x34", 66},
    {"\xF0\xA0\x83\x8D", "\x95\x32\x97\x31", 128},
    {"\xF0\xA0\x85\x8D", "\x95\x32\xA3\x39", 128},
    {"\xF0\xA0\x87\x8D", "\x95\x32\xB0\x37", 128},
    {"\xF0\xA0\x89\x8D", "\x95\x32\xBD\x35", 128},
    {"\xF0\xA0\x8B\x8D", "\x95\x32\xCA\x33", 128},
    {"\xF0\xA0\x8D\x8D", "\x95\x32\xD7\x31", 128},
    {"\xF0\xA0\x8F\x8D", "\x95\x32\xE3\x39", 128},
    {"\xF0\xA0\x91\x8D", "\x95\x32\xF0\x37", 128},
    {"\xF0\xA0\x93\x8D", "\x95\x32\xFD\x35", 128},
    {"\xF0\xA0\x95\x8D", "\x95\x33\x8C\x33", 128},
    {"\xF0\xA0\x97\x8D", "\x95\x33\x99\x31", 128},
    {"\xF0\xA0\x99\x8D", "\x95\x33\xA5\x39", 128},
    {"\xF0\xA0\x9B\x8D", "\x95\x33\xB2\x37", 128},
    {"\xF0\xA0\x9D\x8D", "\x95\x33\xBF\x35", 128},
    {"\xF0\xA0\x9F\x8D", "\x95\x33\xCC\x33", 128},
    {"\xF0\xA0\xA1\x8D", "\x95\x33\xD9\x31", 128},
    {"\xF0\xA0\xA3\x8D", "\x95\x33\xE5\x39", 128},
    {"\xF0\xA0\xA5\x8D", "\x95\x33\xF2\x37", 128},
    {"\xF0\xA0\xA7\x8D", "\x95\x34\x81\x35", 128},
    {"\xF0\xA0\xA9\x8D", "\x95\x34\x8E\x33", 128},
    {"\xF0\xA0\xAB\x8D", "\x95\x34\x9B\x31", 128},
    {"\xF0\xA0\xAD\x8D", "\x95\x34\xA7\x39", 128},
    {"\xF0\xA0\xAF\x8D", "\x95\x34\xB4\x37", 128},
    {"\xF0\xA0\xB1\x8D", "\x95\x34\xC1\x35", 128},
    {"\xF0\xA0\xB3\x8D", "\x95\x34\xCE\x33", 128},
    {"\xF0\xA0\xB5\x8D", "\x95\x34\xDB\x31", 128},
    {"\xF0\xA0\xB7\x8D", "\x95\x34\xE7\x39", 128},
    {"\xF0\xA0\xB9\x8D", "\x95\x34\xF4\x37", 128},
    {"\xF0\xA0\xBB\x8D", "\x95\x35\x83\x35", 128},
    {"\xF0\xA0\xBD\x8D", "\x95\x35\x90\x33", 128},
    {"\xF0\xA0\xBF\x8D", "\x95\x35\x9D\x31", 128},
    {"\xF0\xA1\x81\x8D", "\x95\x35\xA9\x39", 128},
    {"\xF0\xA1\x83\x8D", "\x95\x35\xB6\x37", 128},
    {"\xF0\xA1\x85\x8D", "\x95\x35\xC3\x35", 128},
    {"\xF0\xA1\x87\x8D", "\x95\x35\xD0\x33", 128},
    {"\xF0\xA1\x89\x8D", "\x95\x35\xDD\x31", 128},
    {"\xF0\xA1\x8B\x8D", "\x95\x35\xE9\x39", 128},
    {"\xF0\xA1\x8D\x8D", "\x95\x35\xF6\x37", 128},
    {"\xF0\xA1\x8F\x8D", "\x95\x36\x85\x35", 128},
    {"\xF0\xA1\x91\x8D", "\x95\x36\x92\x33", 128},
    {"\xF0\xA1\x93\x8D", "\x95\x36\x9F\x31", 128},
    {"\xF0\xA1\x95\x8D", "\x95\x36\xAB\x39", 128},
    {"\xF0\xA1\x97\x8D", "\x95\x36\xB8\x37", 10},
    {"\xF0\xA1\x97\x98", "\x95\x36\xB9\x38", 128},
    {"\xF0\xA1\x99\x98", "\x95\x36\xC6\x36", 128},
    {"\xF0\xA1\x9B\x98", "\x95\x36\xD3\x34", 128},
    {"\xF0\xA1\x9D\x98", "\x95\x36\xE0\x32", 128},
    {"\xF0\xA1\x9F\x98", "\x95\x36\xED\x30", 128},
    {"\xF0\xA1\xA1\x98", "\x95\x36\xF9\x38", 128},
    {"\xF0\xA1\xA3\x98", "\x95\x37\x88\x36", 128},
    {"\xF0\xA1\xA5\x98", "\x95\x37\x95\x34", 128},
    {"\xF0\xA1\xA7\x98", "\x95\x37\xA2\x32", 128},
    {"\xF0\xA1\xA9\x98", "\x95\x37\xAF\x30", 128},
    {"\xF0\xA1\xAB\x98", "\x95\x37\xBB\x38", 128},
    {"\xF0\xA1\xAD\x98", "\x95\x37\xC8\x36", 128},
    {"\xF0\xA1\xAF\x98", "\x95\x37\xD5\x34", 128},
    {"\xF0\xA1\xB1\x98", "\x95\x37\xE2\x32", 128},
    {"\xF0\xA1\xB3\x98", "\x95\x37\xEF\x30", 128},
    {"\xF0\xA1\xB5\x98", "\x95\x37\xFB\x38", 128},
    {"\xF0\xA1\xB7\x98", "\x95\x38\x8A\x36", 128},
    {"\xF0\xA1\xB9\x98", "\x95\x38\x97\x34", 128},
    {"\xF0\xA1\xBB\x98", "\x95\x38\xA4\x32", 128},
    {"\xF0\xA1\xBD\x98", "\x95\x38\xB1\x30", 128},
    {"\xF0\xA1\xBF\x98", "\x95\x38\xBD\x38", 128},
    {"\xF0\xA2\x81\x98", "\x95\x38\xCA\x36", 128},
    {"\xF0\xA2\x83\x98", "\x95\x38\xD7\x34", 128},
    {"\xF0\xA2\x85\x98", "\x95\x38\xE4\x32", 128},
    {"\xF0\xA2\x87\x98", "\x95\x38\xF1\x30", 128},
    {"\xF0\xA2\x89\x98", "\x95\x38\xFD\x38", 128},
    {"\xF0\xA2\x8B\x98", "\x95\x39\x8C\x36", 128},
    {"\xF0\xA2\x8D\x98", "\x95\x39\x99\x34", 128},
    {"\xF0\xA2\x8F\x98", "\x95\x39\xA6\x32", 128},
    {"\xF0\xA2\x91\x98", "\x95\x39\xB3\x30", 128},
    {"\xF0\xA2\x93\x98", "\x95\x39\xBF\x38", 128},
    {"\xF0\xA2\x95\x98", "\x95\x39\xCC\x36", 128},
    {"\xF0\xA2\x97\x98", "\x95\x39\xD9\x34", 128},
    {"\xF0\xA2\x99\x98", "\x95\x39\xE6\x32", 128},
    {"\xF0\xA2\x9B\x98", "\x95\x39\xF3\x30", 128},
    {"\xF0\xA2\x9D\x98", "\x96\x30\x81\x38", 128},
    {"\xF0\xA2\x9F\x98", "\x96\x30\x8E\x36", 128},
    {"\xF0\xA2\xA1\x98", "\x96\x30\x9B\x34", 128},
    {"\xF0\xA2\xA3\x98", "\x96\x30\xA8\x32", 128},
    {"\xF0\xA2\xA5\x98", "\x96\x30\xB5\x30", 55},
    {"\xF0\xA2\xA6\x90", "\x96\x30\xBA\x36", 128},
    {"\xF0\xA2\xA8\x90", "\x96\x30\xC7\x34", 128},
    {"\xF0\xA2\xAA\x90", "\x96\x30\xD4\x32", 128},
    {"\xF0\xA2\xAC\x90", "\x96\x30\xE1\x30", 128},
    {"\xF0\xA2\xAE\x90", "\x96\x30\xED\x38", 128},
    {"\xF0\xA2\xB0\x90", "\x96\x30\xFA\x36", 128},
    {"\xF0\xA2\xB2\x90", "\x96\x31\x89\x34", 128},
    {"\xF0\xA2\xB4\x90", "\x96\x31\x96\x32", 128},
    {"\xF0\xA2\xB6\x90", "\x96\x31\xA3\x30", 128},
    {"\xF0\xA2\xB8\x90", "\x96\x31\xAF\x38", 128},
    {"\xF0\xA2\xBA\x90", "\x96\x31\xBC\x36", 128},
    {"\xF0\xA2\xBC\x90", "\x96\x31\xC9\x34", 128},
    {"\xF0\xA2\xBE\x90", "\x96\x31\xD6\x32", 128},
    {"\xF0\xA3\x80\x90", "\x96\x31\xE3\x30", 128},
    {"\xF0\xA3\x82\x90", "\x96\x31\xEF\x38", 128},
    {"\xF0\xA3\x84\x90", "\x96\x31\xFC\x36", 128},
    {"\xF0\xA3\x86\x90", "\x96\x32\x8B\x34", 128},
    {"\xF0\xA3\x88\x90", "\x96\x32\x98\x32", 128},
    {"\xF0\xA3\x8A\x90", "\x96\x32\xA5\x30", 128},
    {"\xF0\xA3\x8C\x90", "\x96\x32\xB1\x38", 128},
    {"\xF0\xA3\x8E\x90", "\x96\x32\xBE\x36", 128},
    {"\xF0\xA3\x90\x90", "\x96\x32\xCB\x34", 128},
    {"\xF0\xA3\x92\x90", "\x96\x32\xD8\x32", 128},
    {"\xF0\xA3\x94\x90", "\x96\x32\xE5\x30", 128},
    {"\xF0\xA3\x96\x90", "\x96\x32\xF1\x38", 128},
    {"\xF0\xA3\x98\x90", "\x96\x32\xFE\x36", 128},
    {"\xF0\xA3\x9A\x90", "\x96\x33\x8D\x34", 128},
    {"\xF0\xA3\x9C\x90", "\x96\x33\x9A\x32", 128},
    {"\xF0\xA3\x9E\x90", "\x96\x33\xA7\x30", 128},
    {"\xF0\xA3\xA0\x90", "\x96\x33\xB3\x38", 128},
    {"\xF0\xA3\xA2\x90", "\x96\x33\xC0\x36", 128},
    {"\xF0\xA3\xA4\x90", "\x96\x33\xCD\x34", 128},
    {"\xF0\xA3\xA6\x90", "\x96\x33\xDA\x32", 128},
    {"\xF0\xA3\xA8\x90", "\x96\x33\xE7\x30", 128},
    {"\xF0\xA3\xAA\x90", "\x96\x33\xF3\x38", 128},
    {"\xF0\xA3\xAC\x90", "\x96\x34\x82\x36", 128},
    {"\xF0\xA3\xAE\x90", "\x96\x34\x8F\x34", 128},
    {"\xF0\xA3\xB0\x90", "\x96\x34\x9C\x32", 128},
    {"\xF0\xA3\xB2\x90", "\x96\x34\xA9\x30", 128},
    {"\xF0\xA3\xB4\x90", "\x96\x34\xB5\x38", 128},
    {"\xF0\xA3\xB6\x90", "\x96\x34\xC2\x36", 128},
    {"\xF0\xA3\xB8\x90", "\x96\x34\xCF\x34", 128},
    {"\xF0\xA3\xBA\x90", "\x96\x34\xDC\x32", 128},
    {"\xF0\xA3\xBC\x90", "\x96\x34\xE9\x30", 128},
    {"\xF0\xA3\xBE\x90", "\x96\x34\xF5\x38", 128},
    {"\xF0\xA4\x80\x90", "\x96\x35\x84\x36", 128},
    {"\xF0\xA4\x82\x90", "\x96\x35\x91\x34", 128},
    {"\xF0\xA4\x84\x90", "\x96\x35\x9E\x32", 128},
    {"\xF0\xA4\x86\x90", "\x96\x35\xAB\x30", 110},
    {"\xF0\xA4\x87\xBF", "\x96\x35\xB6\x31", 128},
    {"\xF0\xA4\x89\xBF", "\x96\x35\xC2\x39", 128},
    {"\xF0\xA4\x8B\xBF", "\x96\x35\xCF\x37", 128},
    {"\xF0\xA4\x8D\xBF", "\x96\x35\xDC\x35", 128},
    {"\xF0\xA4\x8F\xBF", "\x96\x35\xE9\x33", 128},
    {"\xF0\xA4\x91\xBF", "\x96\x35\xF6\x31", 128},
    {"\xF0\xA4\x93\xBF", "\x96\x36\x84\x39", 128},
    {"\xF0\xA4\x95\xBF", "\x96\x36\x91\x37", 128},
    {"\xF0\xA4\x97\xBF", "\x96\x36\x9E\x35", 128},
    {"\xF0\xA4\x99\xBF", "\x96\x36\xAB\x33", 128},
    {"\xF0\xA4\x9B\xBF", "\x96\x36\xB8\x31", 128},
    {"\xF0\xA4\x9D\xBF", "\x96\x36\xC4\x39", 128},
    {"\xF0\xA4\x9F\xBF", "\x96\x36\xD1\x37", 128},
    {"\xF0\xA4\xA1\xBF", "\x96\x36\xDE\x35", 128},
    {"\xF0\xA4\xA3\xBF", "\x96\x36\xEB\x33", 128},
    {"\xF0\xA4\xA5\xBF", "\x96\x36\xF8\x31", 128},
    {"\xF0\xA4\xA7\xBF", "\x96\x37\x86\x39", 128},
    {"\xF0\xA4\xA9\xBF", "\x96\x37\x93\x37", 128},
    {"\xF0\xA4\xAB\xBF", "\x96\x37\xA0\x35", 128},
    {"\xF0\xA4\xAD\xBF", "\x96\x37\xAD\x33", 128},
    {"\xF0\xA4\xAF\xBF", "\x96\x37\xBA\x31", 128},
    {"\xF0\xA4\xB1\xBF", "\x96\x37\xC6\x39", 128},
    {"\xF0\xA4\xB3\xBF", "\x96\x37\xD3\x37", 128},
    {"\xF0\xA4\xB5\xBF", "\x96\x37\xE0\x35", 128},
    {"\xF0\xA4\xB7\xBF", "\x96\x37\xED\x33", 128},
    {"\xF0\xA4\xB9\xBF", "\x96\x37\xFA\x31", 128},
    {"\xF0\xA4\xBB\xBF", "\x96\x38\x88\x39", 128},
    {"\xF0\xA4\xBD\xBF", "\x96\x38\x95\x37", 128},
    {"\xF0\xA4\xBF\xBF", "\x96\x38\xA2\x35", 128},
    {"\xF0\xA5\x81\xBF", "\x96\x38\xAF\x33", 128},
    {"\xF0\xA5\x83\xBF", "\x96\x38\xBC\x31", 128},
    {"\xF0\xA5\x85\xBF", "\x96\x38\xC8\x39", 128},
    {"\xF0\xA5\x87\xBF", "\x96\x38\xD5\x37", 128},
    {"\xF0\xA5\x89\xBF", "\x96\x38\xE2\x35", 128},
    {"\xF0\xA5\x8B\xBF", "\x96\x38\xEF\x33", 128},
    {"\xF0\xA5\x8D\xBF", "\x96\x38\xFC\x31", 128},
    {"\xF0\xA5\x8F\xBF", "\x96\x39\x8A\x39", 128},
    {"\xF0\xA5\x91\xBF", "\x96\x39\x97\x37", 128},
    {"\xF0\xA5\x93\xBF", "\x96\x39\xA4\x35", 128},
    {"\xF0\xA5\x95\xBF", "\x96\x39\xB1\x33", 128},
    {"\xF0\xA5\x97\xBF", "\x96\x39\xBE\x31", 128},
    {"\xF0\xA5\x99\xBF", "\x96\x39\xCA\x39", 128},
    {"\xF0\xA5\x9B\xBF", "\x96\x39\xD7\x37", 128},
    {"\xF0\xA5\x9D\xBF", "\x96\x39\xE4\x35", 128},
    {"\xF0\xA5\x9F\xBF", "\x96\x39\xF1\x33", 128},
    {"\xF0\xA5\xA1\xBF", "\x96\x39\xFE\x31", 128},
    {"\xF0\xA5\xA3\xBF", "\x97\x30\x8C\x39", 128},
    {"\xF0\xA5\xA5\xBF", "\x97\x30\x99\x37", 128},
    {"\xF0\xA5\xA7\xBF", "\x97\x30\xA6\x35", 128},
    {"\xF0\xA5\xA9\xBF", "\x97\x30\xB3\x33", 128},
    {"\xF0\xA5\xAB\xBF", "\x97\x30\xC0\x31", 128},
    {"\xF0\xA5\xAD\xBF", "\x97\x30\xCC\x39", 128},
    {"\xF0\xA5\xAF\xBF", "\x97\x30\xD9\x37", 128},
    {"\xF0\xA5\xB1\xBF", "\x97\x30\xE6\x35", 128},
    {"\xF0\xA5\xB3\xBF", "\x97\x30\xF3\x33", 128},
    {"\xF0\xA5\xB5\xBF", "\x97\x31\x82\x31", 128},
    {"\xF0\xA5\xB7\xBF", "\x97\x31\x8E\x39", 128},
    {"\xF0\xA5\xB9\xBF", "\x97\x31\x9B\x37", 128},
    {"\xF0\xA5\xBB\xBF", "\x97\x31\xA8\x35", 128},
    {"\xF0\xA5\xBD\xBF", "\x97\x31\xB5\x33", 128},
    {"\xF0\xA5\xBF\xBF", "\x97\x31\xC2\x31", 128},
    {"\xF0\xA6\x81\xBF", "\x97\x31\xCE\x39", 128},
    {"\xF0\xA6\x83\xBF", "\x97\x31\xDB\x37", 128},
    {"\xF0\xA6\x85\xBF", "\x97\x31\xE8\x35", 128},
    {"\xF0\xA6\x87\xBF", "\x97\x31\xF5\x33", 128},
    {"\xF0\xA6\x89\xBF", "\x97\x32\x84\x31", 128},
    {"\xF0\xA6\x8B\xBF", "\x97\x32\x90\x39", 128},
    {"\xF0\xA6\x8D\xBF", "\x97\x32\x9D\x37", 128},
    {"\xF0\xA6\x8F\xBF", "\x97\x32\xAA\x35", 128},
    {"\xF0\xA6\x91\xBF", "\x97\x32\xB7\x33", 128},
    {"\xF0\xA6\x93\xBF", "\x97\x32\xC4\x31", 128},
    {"\xF0\xA6\x95\xBF", "\x97\x32\xD0\x39", 128},
    {"\xF0\xA6\x97\xBF", "\x97\x32\xDD\x37", 128},
    {"\xF0\xA6\x99\xBF", "\x97\x32\xEA\x35", 128},
    {"\xF0\xA6\x9B\xBF", "\x97\x32\xF7\x33", 128},
    {"\xF0\xA6\x9D\xBF", "\x97\x33\x86\x31", 128},
    {"\xF0\xA6\x9F\xBF", "\x97\x33\x92\x39", 128},
    {"\xF0\xA6\xA1\xBF", "\x97\x33\x9F\x37", 128},
    {"\xF0\xA6\xA3\xBF", "\x97\x33\xAC\x35", 128},
    {"\xF0\xA6\xA5\xBF", "\x97\x33\xB9\x33", 128},
    {"\xF0\xA6\xA7\xBF", "\x97\x33\xC6\x31", 128},
    {"\xF0\xA6\xA9\xBF", "\x97\x33\xD2\x39", 128},
    {"\xF0\xA6\xAB\xBF", "\x97\x33\xDF\x37", 128},
    {"\xF0\xA6\xAD\xBF", "\x97\x33\xEC\x35", 128},
    {"\xF0\xA6\xAF\xBF", "\x97\x33\xF9\x33", 128},
    {"\xF0\xA6\xB1\xBF", "\x97\x34\x88\x31", 128},
    {"\xF0\xA6\xB3\xBF", "\x97\x34\x94\x39", 128},
    {"\xF0\xA6\xB5\xBF", "\x97\x34\xA1\x37", 128},
    {"\xF0\xA6\xB7\xBF", "\x97\x34\xAE\x35", 128},
    {"\xF0\xA6\xB9\xBF", "\x97\x34\xBB\x33", 128},
    {"\xF0\xA6\xBB\xBF", "\x97\x34\xC8\x31", 128},
    {"\xF0\xA6\xBD\xBF", "\x97\x34\xD4\x39", 128},
    {"\xF0\xA6\xBF\xBF", "\x97\x34\xE1\x37", 128},
    {"\xF0\xA7\x81\xBF", "\x97\x34\xEE\x35", 128},
    {"\xF0\xA7\x83\xBF", "\x97\x34\xFB\x33", 128},
    {"\xF0\xA7\x85\xBF", "\x97\x35\x8A\x31", 128},
    {"\xF0\xA7\x87\xBF", "\x97\x35\x96\x39", 128},
    {"\xF0\xA7\x89\xBF", "\x97\x35\xA3\x37", 128},
    {"\xF0\xA7\x8B\xBF", "\x97\x35\xB0\x35", 128},
    {"\xF0\xA7\x8D\xBF", "\x97\x35\xBD\x33", 128},
    {"\xF0\xA7\x8F\xBF", "\x97\x35\xCA\x31", 128},
    {"\xF0\xA7\x91\xBF", "\x97\x35\xD6\x39", 128},
    {"\xF0\xA7\x93\xBF", "\x97\x35\xE3\x37", 128},
    {"\xF0\xA7\x95\xBF", "\x97\x35\xF0\x35", 128},
    {"\xF0\xA7\x97\xBF", "\x97\x35\xFD\x33", 128},
    {"\xF0\xA7\x99\xBF", "\x97\x36\x8C\x31", 128},
    {"\xF0\xA7\x9B\xBF", "\x97\x36\x98\x39", 128},
    {"\xF0\xA7\x9D\xBF", "\x97\x36\xA5\x37", 128},
    {"\xF0\xA7\x9F\xBF", "\x97\x36\xB2\x35", 128},
    {"\xF0\xA7\xA1\xBF", "\x97\x36\xBF\x33", 128},
    {"\xF0\xA7\xA3\xBF", "\x97\x36\xCC\x31", 128},
    {"\xF0\xA7\xA5\xBF", "\x97\x36\xD8\x39", 128},
    {"\xF0\xA7\xA7\xBF", "\x97\x36\xE5\x37", 128},
    {"\xF0\xA7\xA9\xBF", "\x97\x36\xF2\x35", 128},
    {"\xF0\xA7\xAB\xBF", "\x97\x37\x81\x33", 128},
    {"\xF0\xA7\xAD\xBF", "\x97\x37\x8E\x31", 128},
    {"\xF0\xA7\xAF\xBF", "\x97\x37\x9A\x39", 128},
    {"\xF0\xA7\xB1\xBF", "\x97\x37\xA7\x37", 128},
    {"\xF0\xA7\xB3\xBF", "\x97\x37\xB4\x35", 128},
    {"\xF0\xA7\xB5\xBF", "\x97\x37\xC1\x33", 128},
    {"\xF0\xA7\xB7\xBF", "\x97\x37\xCE\x31", 128},
    {"\xF0\xA7\xB9\xBF", "\x97\x37\xDA\x39", 128},
    {"\xF0\xA7\xBB\xBF", "\x97\x37\xE7\x37", 128},
    {"\xF0\xA7\xBD\xBF", "\x97\x37\xF4\x35", 128},
    {"\xF0\xA7\xBF\xBF", "\x97\x38\x83\x33", 128},
    {"\xF0\xA8\x81\xBF", "\x97\x38\x90\x31", 128},
    {"\xF0\xA8\x83\xBF", "\x97\x38\x9C\x39", 128},
    {"\xF0\xA8\x85\xBF", "\x97\x38\xA9\x37", 128},
    {"\xF0\xA8\x87\xBF", "\x97\x38\xB6\x35", 128},
    {"\xF0\xA8\x89\xBF", "\x97\x38\xC3\x33", 128},
    {"\xF0\xA8\x8B\xBF", "\x97\x38\xD0\x31", 128},
    {"\xF0\xA8\x8D\xBF", "\x97\x38\xDC\x39", 128},
    {"\xF0\xA8\x8F\xBF", "\x97\x38\xE9\x37", 128},
    {"\xF0\xA8\x91\xBF", "\x97\x38\xF6\x35", 128},
    {"\xF0\xA8\x93\xBF", "\x97\x39\x85\x33", 128},
    {"\xF0\xA8\x95\xBF", "\x97\x39\x92\x31", 128},
    {"\xF0\xA8\x97\xBF", "\x97\x39\x9E\x39", 128},
    {"\xF0\xA8\x99\xBF", "\x97\x39\xAB\x37", 128},
    {"\xF0\xA8\x9B\xBF", "\x97\x39\xB8\x35", 128},
    {"\xF0\xA8\x9D\xBF", "\x97\x39\xC5\x33", 128},
    {"\xF0\xA8\x9F\xBF", "\x97\x39\xD2\x31", 128},
    {"\xF0\xA8\xA1\xBF", "\x97\x39\xDE\x39", 128},
    {"\xF0\xA8\xA3\xBF", "\x97\x39\xEB\x37", 128},
    {"\xF0\xA8\xA5\xBF", "\x97\x39\xF8\x35", 128},
    {"\xF0\xA8\xA7\xBF", "\x98\x30\x87\x33", 128},
    {"\xF0\xA8\xA9\xBF", "\x98\x30\x94\x31", 128},
    {"\xF0\xA8\xAB\xBF", "\x98\x30\xA0\x39", 128},
    {"\xF0\xA8\xAD\xBF", "\x98\x30\xAD\x37", 128},
    {"\xF0\xA8\xAF\xBF", "\x98\x30\xBA\x35", 128},
    {"\xF0\xA8\xB1\xBF", "\x98\x30\xC7\x33", 128},
    {"\xF0\xA8\xB3\xBF", "\x98\x30\xD4\x31", 128},
    {"\xF0\xA8\xB5\xBF", "\x98\x30\xE0\x39", 128},
    {"\xF0\xA8\xB7\xBF", "\x98\x30\xED\x37", 128},
    {"\xF0\xA8\xB9\xBF", "\x98\x30\xFA\x35", 128},
    {"\xF0\xA8\xBB\xBF", "\x98\x31\x89\x33", 128},
    {"\xF0\xA8\xBD\xBF", "\x98\x31\x96\x31", 128},
    {"\xF0\xA8\xBF\xBF", "\x98\x31\xA2\x39", 128},
    {"\xF0\xA9\x81\xBF", "\x98\x31\xAF\x37", 128},
    {"\xF0\xA9\x83\xBF", "\x98\x31\xBC\x35", 128},
    {"\xF0\xA9\x85\xBF", "\x98\x31\xC9\x33", 128},
    {"\xF0\xA9\x87\xBF", "\x98\x31\xD6\x31", 128},
    {"\xF0\xA9\x89\xBF", "\x98\x31\xE2\x39", 128},
    {"\xF0\xA9\x8B\xBF", "\x98\x31\xEF\x37", 128},
    {"\xF0\xA9\x8D\xBF", "\x98\x31\xFC\x35", 128},
    {"\xF0\xA9\x8F\xBF", "\x98\x32\x8B\x33", 128},
    {"\xF0\xA9\x91\xBF", "\x98\x32\x98\x31", 128},
    {"\xF0\xA9\x93\xBF", "\x98\x32\xA4\x39", 128},
    {"\xF0\xA9\x95\xBF", "\x98\x32\xB1\x37", 128},
    {"\xF0\xA9\x97\xBF", "\x98\x32\xBE\x35", 128},
    {"\xF0\xA9\x99\xBF", "\x98\x32\xCB\x33", 128},
    {"\xF0\xA9\x9B\xBF", "\x98\x32\xD8\x31", 128},
    {"\xF0\xA9\x9D\xBF", "\x98\x32\xE4\x39", 128},
    {"\xF0\xA9\x9F\xBF", "\x98\x32\xF1\x37", 128},
    {"\xF0\xA9\xA1\xBF", "\x98\x32\xFE\x35", 128},
    {"\xF0\xA9\xA3\xBF", "\x98\x33\x8D\x33", 128},
    {"\xF0\xA9\xA5\xBF", "\x98\x33\x9A\x31", 128},
    {"\xF0\xA9\xA7\xBF", "\x98\x33\xA6\x39", 128},
    {"\xF0\xA9\xA9\xBF", "\x98\x33\xB3\x37", 128},
    {"\xF0\xA9\xAB\xBF", "\x98\x33\xC0\x35", 128},
    {"\xF0\xA9\xAD\xBF", "\x98\x33\xCD\x33", 128},
    {"\xF0\xA9\xAF\xBF", "\x98\x33\xDA\x31", 128},
    {"\xF0\xA9\xB1\xBF", "\x98\x33\xE6\x39", 128},
    {"\xF0\xA9\xB3\xBF", "\x98\x33\xF3\x37", 128},
    {"\xF0\xA9\xB5\xBF", "\x98\x34\x82\x35", 128},
    {"\xF0\xA9\xB7\xBF", "\x98\x34\x8F\x33", 128},
    {"\xF0\xA9\xB9\xBF", "\x98\x34\x9C\x31", 128},
    {"\xF0\xA9\xBB\xBF", "\x98\x34\xA8\x39", 128},
    {"\xF0\xA9\xBD\xBF", "\x98\x34\xB5\x37", 128},
    {"\xF0\xA9\xBF\xBF", "\x98\x34\xC2\x35", 128},
    {"\xF0\xAA\x81\xBF", "\x98\x34\xCF\x33", 128},
    {"\xF0\xAA\x83\xBF", "\x98\x34\xDC\x31", 128},
    {"\xF0\xAA\x85\xBF", "\x98\x34\xE8\x39", 128},
    {"\xF0\xAA\x87\xBF", "\x98\x34\xF5\x37", 128},
    {"\xF0\xAA\x89\xBF", "\x98\x35\x84\x35", 128},
    {"\xF0\xAA\x8B\xBF", "\x98\x35\x91\x33", 128},
    {"\xF0\xAA\x8D\xBF", "\x98\x35\x9E\x31", 128},
    {"\xF0\xAA\x8F\xBF", "\x98\x35\xAA\x39", 128},
    {"\xF0\xAA\x91\xBF", "\x98\x35\xB7\x37", 128},
    {"\xF0\xAA\x93\xBF", "\x98\x35\xC4\x35", 128},
    {"\xF0\xAA\x95\xBF", "\x98\x35\xD1\x33", 128},
    {"\xF0\xAA\x97\xBF", "\x98\x35\xDE\x31", 128},
    {"\xF0\xAA\x99\xBF", "\x98\x35\xEA\x39", 128},
    {"\xF0\xAA\x9B\xBF", "\x98\x35\xF7\x37", 128},
    {"\xF0\xAA\x9D\xBF", "\x98\x36\x86\x35", 128},
    {"\xF0\xAA\x9F\xBF", "\x98\x36\x93\x33", 128},
    {"\xF0\xAA\xA1\xBF", "\x98\x36\xA0\x31", 128},
    {"\xF0\xAA\xA3\xBF", "\x98\x36\xAC\x39", 128},
    {"\xF0\xAA\xA5\xBF", "\x98\x36\xB9\x37", 128},
    {"\xF0\xAA\xA7\xBF", "\x98\x36\xC6\x35", 128},
    {"\xF0\xAA\xA9\xBF", "\x98\x36\xD3\x33", 128},
    {"\xF0\xAA\xAB\xBF", "\x98\x36\xE0\x31", 128},
    {"\xF0\xAA\xAD\xBF", "\x98\x36\xEC\x39", 128},
    {"\xF0\xAA\xAF\xBF", "\x98\x36\xF9\x37", 128},
    {"\xF0\xAA\xB1\xBF", "\x98\x37\x88\x35", 128},
    {"\xF0\xAA\xB3\xBF", "\x98\x37\x95\x33", 128},
    {"\xF0\xAA\xB5\xBF", "\x98\x37\xA2\x31", 128},
    {"\xF0\xAA\xB7\xBF", "\x98\x37\xAE\x39", 128},
    {"\xF0\xAA\xB9\xBF", "\x98\x37\xBB\x37", 128},
    {"\xF0\xAA\xBB\xBF", "\x98\x37\xC8\x35", 128},
    {"\xF0\xAA\xBD\xBF", "\x98\x37\xD5\x33", 128},
    {"\xF0\xAA\xBF\xBF", "\x98\x37\xE2\x31", 128},
    {"\xF0\xAB\x81\xBF", "\x98\x37\xEE\x39", 128},
    {"\xF0\xAB\x83\xBF", "\x98\x37\xFB\x37", 128},
    {"\xF0\xAB\x85\xBF", "\x98\x38\x8A\x35", 128},
    {"\xF0\xAB\x87\xBF", "\x98\x38\x97\x33", 128},
    {"\xF0\xAB\x89\xBF", "\x98\x38\xA4\x31", 128},
    {"\xF0\xAB\x8B\xBF", "\x98\x38\xB0\x39", 128},
    {"\xF0\xAB\x8D\xBF", "\x98\x38\xBD\x37", 128},
    {"\xF0\xAB\x8F\xBF", "\x98\x38\xCA\x35", 128},
    {"\xF0\xAB\x91\xBF", "\x98\x38\xD7\x33", 128},
    {"\xF0\xAB\x93\xBF", "\x98\x38\xE4\x31", 128},
    {"\xF0\xAB\x95\xBF", "\x98\x38\xF0\x39", 128},
    {"\xF0\xAB\x97\xBF", "\x98\x38\xFD\x37", 128},
    {"\xF0\xAB\x99\xBF", "\x98\x39\x8C\x35", 128},
    {"\xF0\xAB\x9B\xBF", "\x98\x39\x99\x33", 128},
    {"\xF0\xAB\x9D\xBF", "\x98\x39\xA6\x31", 128},
    {"\xF0\xAB\x9F\xBF", "\x98\x39\xB2\x39", 128},
    {"\xF0\xAB\xA1\xBF", "\x98\x39\xBF\x37", 128},
    {"\xF0\xAB\xA3\xBF", "\x98\x39\xCC\x35", 128},
    {"\xF0\xAB\xA5\xBF", "\x98\x39\xD9\x33", 128},
    {"\xF0\xAB\xA7\xBF", "\x98\x39\xE6\x31", 128},
    {"\xF0\xAB\xA9\xBF", "\x98\x39\xF2\x39", 128},
    {"\xF0\xAB\xAB\xBF", "\x99\x30\x81\x37", 128},
    {"\xF0\xAB\xAD\xBF", "\x99\x30\x8E\x35", 128},
    {"\xF0\xAB\xAF\xBF", "\x99\x30\x9B\x33", 128},
    {"\xF0\xAB\xB1\xBF", "\x99\x30\xA8\x31", 128},
    {"\xF0\xAB\xB3\xBF", "\x99\x30\xB4\x39", 128},
    {"\xF0\xAB\xB5\xBF", "\x99\x30\xC1\x37", 128},
    {"\xF0\xAB\xB7\xBF", "\x99\x30\xCE\x35", 128},
    {"\xF0\xAB\xB9\xBF", "\x99\x30\xDB\x33", 128},
    {"\xF0\xAB\xBB\xBF", "\x99\x30\xE8\x31", 128},
    {"\xF0\xAB\xBD\xBF", "\x99\x30\xF4\x39", 128},
    {"\xF0\xAB\xBF\xBF", "\x99\x31\x83\x37", 128},
    {"\xF0\xAC\x81\xBF", "\x99\x31\x90\x35", 128},
    {"\xF0\xAC\x83\xBF", "\x99\x31\x9D\x33", 128},
    {"\xF0\xAC\x85\xBF", "\x99\x31\xAA\x31", 128},
    {"\xF0\xAC\x87\xBF", "\x99\x31\xB6\x39", 128},
    {"\xF0\xAC\x89\xBF", "\x99\x31\xC3\x37", 128},
    {"\xF0\xAC\x8B\xBF", "\x99\x31\xD0\x35", 128},
    {"\xF0\xAC\x8D\xBF", "\x99\x31\xDD\x33", 128},
    {"\xF0\xAC\x8F\xBF", "\x99\x31\xEA\x31", 128},
    {"\xF0\xAC\x91\xBF", "\x99\x31\xF6\x39", 128},
    {"\xF0\xAC\x93\xBF", "\x99\x32\x85\x37", 128},
    {"\xF0\xAC\x95\xBF", "\x99\x32\x92\x35", 128},
    {"\xF0\xAC\x97\xBF", "\x99\x32\x9F\x33", 128},
    {"\xF0\xAC\x99\xBF", "\x99\x32\xAC\x31", 128},
    {"\xF0\xAC\x9B\xBF", "\x99\x32\xB8\x39", 128},
    {"\xF0\xAC\x9D\xBF", "\x99\x32\xC5\x37", 128},
    {"\xF0\xAC\x9F\xBF", "\x99\x32\xD2\x35", 128},
    {"\xF0\xAC\xA1\xBF", "\x99\x32\xDF\x33", 128},
    {"\xF0\xAC\xA3\xBF", "\x99\x32\xEC\x31", 128},
    {"\xF0\xAC\xA5\xBF", "\x99\x32\xF8\x39", 128},
    {"\xF0\xAC\xA7\xBF", "\x99\x33\x87\x37", 128},
    {"\xF0\xAC\xA9\xBF", "\x99\x33\x94\x35", 128},
    {"\xF0\xAC\xAB\xBF", "\x99\x33\xA1\x33", 128},
    {"\xF0\xAC\xAD\xBF", "\x99\x33\xAE\x31", 128},
    {"\xF0\xAC\xAF\xBF", "\x99\x33\xBA\x39", 128},
    {"\xF0\xAC\xB1\xBF", "\x99\x33\xC7\x37", 128},
    {"\xF0\xAC\xB3\xBF", "\x99\x33\xD4\x35", 128},
    {"\xF0\xAC\xB5\xBF", "\x99\x33\xE1\x33", 128},
    {"\xF0\xAC\xB7\xBF", "\x99\x33\xEE\x31", 128},
    {"\xF0\xAC\xB9\xBF", "\x99\x33\xFA\x39", 128},
    {"\xF0\xAC\xBB\xBF", "\x99\x34\x89\x37", 128},
    {"\xF0\xAC\xBD\xBF", "\x99\x34\x96\x35", 128},
    {"\xF0\xAC\xBF\xBF", "\x99\x34\xA3\x33", 128},
    {"\xF0\xAD\x81\xBF", "\x99\x34\xB0\x31", 128},
    {"\xF0\xAD\x83\xBF", "\x99\x34\xBC\x39", 128},
    {"\xF0\xAD\x85\xBF", "\x99\x34\xC9\x37", 128},
    {"\xF0\xAD\x87\xBF", "\x99\x34\xD6\x35", 128},
    {"\xF0\xAD\x89\xBF", "\x99\x34\xE3\x33", 128},
    {"\xF0\xAD\x8B\xBF", "\x99\x34\xF0\x31", 128},
    {"\xF0\xAD\x8D\xBF", "\x99\x34\xFC\x39", 128},
    {"\xF0\xAD\x8F\xBF", "\x99\x35\x8B\x37", 128},
    {"\xF0\xAD\x91\xBF", "\x99\x35\x98\x35", 128},
    {"\xF0\xAD\x93\xBF", "\x99\x35\xA5\x33", 128},
    {"\xF0\xAD\x95\xBF", "\x99\x35\xB2\x31", 128},
    {"\xF0\xAD\x97\xBF", "\x99\x35\xBE\x39", 128},
    {"\xF0\xAD\x99\xBF", "\x99\x35\xCB\x37", 128},
    {"\xF0\xAD\x9B\xBF", "\x99\x35\xD8\x35", 128},
    {"\xF0\xAD\x9D\xBF", "\x99\x35\xE5\x33", 128},
    {"\xF0\xAD\x9F\xBF", "\x99\x35\xF2\x31", 128},
    {"\xF0\xAD\xA1\xBF", "\x99\x35\xFE\x39", 128},
    {"\xF0\xAD\xA3\xBF", "\x99\x36\x8D\x37", 128},
    {"\xF0\xAD\xA5\xBF", "\x99\x36\x9A\x35", 128},
    {"\xF0\xAD\xA7\xBF", "\x99\x36\xA7\x33", 128},
    {"\xF0\xAD\xA9\xBF", "\x99\x36\xB4\x31", 128},
    {"\xF0\xAD\xAB\xBF", "\x99\x36\xC0\x39", 128},
    {"\xF0\xAD\xAD\xBF", "\x99\x36\xCD\x37", 128},
    {"\xF0\xAD\xAF\xBF", "\x99\x36\xDA\x35", 128},
    {"\xF0\xAD\xB1\xBF", "\x99\x36\xE7\x33", 128},
    {"\xF0\xAD\xB3\xBF", "\x99\x36\xF4\x31", 128},
    {"\xF0\xAD\xB5\xBF", "\x99\x37\x82\x39", 128},
    {"\xF0\xAD\xB7\xBF", "\x99\x37\x8F\x37", 128},
    {"\xF0\xAD\xB9\xBF", "\x99\x37\x9C\x35", 128},
    {"\xF0\xAD\xBB\xBF", "\x99\x37\xA9\x33", 128},
    {"\xF0\xAD\xBD\xBF", "\x99\x37\xB6\x31", 128},
    {"\xF0\xAD\xBF\xBF", "\x99\x37\xC2\x39", 128},
    {"\xF0\xAE\x81\xBF", "\x99\x37\xCF\x37", 128},
    {"\xF0\xAE\x83\xBF", "\x99\x37\xDC\x35", 128},
    {"\xF0\xAE\x85\xBF", "\x99\x37\xE9\x33", 128},
    {"\xF0\xAE\x87\xBF", "\x99\x37\xF6\x31", 128},
    {"\xF0\xAE\x89\xBF", "\x99\x38\x84\x39", 128},
    {"\xF0\xAE\x8B\xBF", "\x99\x38\x91\x37", 128},
    {"\xF0\xAE\x8D\xBF", "\x99\x38\x9E\x35", 128},
    {"\xF0\xAE\x8F\xBF", "\x99\x38\xAB\x33", 128},
    {"\xF0\xAE\x91\xBF", "\x99\x38\xB8\x31", 128},
    {"\xF0\xAE\x93\xBF", "\x99\x38\xC4\x39", 128},
    {"\xF0\xAE\x95\xBF", "\x99\x38\xD1\x37", 128},
    {"\xF0\xAE\x97\xBF", "\x99\x38\xDE\x35", 128},
    {"\xF0\xAE\x99\xBF", "\x99\x38\xEB\x33", 128},
    {"\xF0\xAE\x9B\xBF", "\x99\x38\xF8\x31", 128},
    {"\xF0\xAE\x9D\xBF", "\x99\x39\x86\x39", 128},
    {"\xF0\xAE\x9F\xBF", "\x99\x39\x93\x37", 128},
    {"\xF0\xAE\xA1\xBF", "\x99\x39\xA0\x35", 128},
    {"\xF0\xAE\xA3\xBF", "\x99\x39\xAD\x33", 128},
    {"\xF0\xAE\xA5\xBF", "\x99\x39\xBA\x31", 128},
    {"\xF0\xAE\xA7\xBF", "\x99\x39\xC6\x39", 128},
    {"\xF0\xAE\xA9\xBF", "\x99\x39\xD3\x37", 128},
    {"\xF0\xAE\xAB\xBF", "\x99\x39\xE0\x35", 128},
    {"\xF0\xAE\xAD\xBF", "\x99\x39\xED\x33", 128},
    {"\xF0\xAE\xAF\xBF", "\x99\x39\xFA\x31", 128},
    {"\xF0\xAE\xB1\xBF", "\x9A\x30\x88\x39", 128},
    {"\xF0\xAE\xB3\xBF", "\x9A\x30\x95\x37", 128},
    {"\xF0\xAE\xB5\xBF", "\x9A\x30\xA2\x35", 128},
    {"\xF0\xAE\xB7\xBF", "\x9A\x30\xAF\x33", 128},
    {"\xF0\xAE\xB9\xBF", "\x9A\x30\xBC\x31", 128},
    {"\xF0\xAE\xBB\xBF", "\x9A\x30\xC8\x39", 128},
    {"\xF0\xAE\xBD\xBF", "\x9A\x30\xD5\x37", 128},
    {"\xF0\xAE\xBF\xBF", "\x9A\x30\xE2\x35", 128},
    {"\xF0\xAF\x81\xBF", "\x9A\x30\xEF\x33", 128},
    {"\xF0\xAF\x83\xBF", "\x9A\x30\xFC\x31", 128},
    {"\xF0\xAF\x85\xBF", "\x9A\x31\x8A\x39", 128},
    {"\xF0\xAF\x87\xBF", "\x9A\x31\x97\x37", 128},
    {"\xF0\xAF\x89\xBF", "\x9A\x31\xA4\x35", 128},
    {"\xF0\xAF\x8B\xBF", "\x9A\x31\xB1\x33", 128},
    {"\xF0\xAF\x8D\xBF", "\x9A\x31\xBE\x31", 128},
    {"\xF0\xAF\x8F\xBF", "\x9A\x31\xCA\x39", 128},
    {"\xF0\xAF\x91\xBF", "\x9A\x31\xD7\x37", 128},
    {"\xF0\xAF\x93\xBF", "\x9A\x31\xE4\x35", 128},
    {"\xF0\xAF\x95\xBF", "\x9A\x31\xF1\x33", 128},
    {"\xF0\xAF\x97\xBF", "\x9A\x31\xFE\x31", 128},
    {"\xF0\xAF\x99\xBF", "\x9A\x32\x8C\x39", 128},
    {"\xF0\xAF\x9B\xBF", "\x9A\x32\x99\x37", 128},
    {"\xF0\xAF\x9D\xBF", "\x9A\x32\xA6\x35", 128},
    {"\xF0\xAF\x9F\xBF", "\x9A\x32\xB3\x33", 128},
    {"\xF0\xAF\xA1\xBF", "\x9A\x32\xC0\x31", 128},
    {"\xF0\xAF\xA3\xBF", "\x9A\x32\xCC\x39", 128},
    {"\xF0\xAF\xA5\xBF", "\x9A\x32\xD9\x37", 128},
    {"\xF0\xAF\xA7\xBF", "\x9A\x32\xE6\x35", 128},
    {"\xF0\xAF\xA9\xBF", "\x9A\x32\xF3\x33", 128},
    {"\xF0\xAF\xAB\xBF", "\x9A\x33\x82\x31", 128},
    {"\xF0\xAF\xAD\xBF", "\x9A\x33\x8E\x39", 128},
    {"\xF0\xAF\xAF\xBF", "\x9A\x33\x9B\x37", 128},
    {"\xF0\xAF\xB1\xBF", "\x9A\x33\xA8\x35", 128},
    {"\xF0\xAF\xB3\xBF", "\x9A\x33\xB5\x33", 128},
    {"\xF0\xAF\xB5\xBF", "\x9A\x33\xC2\x31", 128},
    {"\xF0\xAF\xB7\xBF", "\x9A\x33\xCE\x39", 128},
    {"\xF0\xAF\xB9\xBF", "\x9A\x33\xDB\x37", 128},
    {"\xF0\xAF\xBB\xBF", "\x9A\x33\xE8\x35", 128},
    {"\xF0\xAF\xBD\xBF", "\x9A\x33\xF5\x33", 128},
    {"\xF0\xAF\xBF\xBF", "\x9A\x34\x84\x31", 128},
    {"\xF0\xB0\x81\xBF", "\x9A\x34\x90\x39", 128},
    {"\xF0\xB0\x83\xBF", "\x9A\x34\x9D\x37", 128},
    {"\xF0\xB0\x85\xBF", "\x9A\x34\xAA\x35", 128},
    {"\xF0\xB0\x87\xBF", "\x9A\x34\xB7\x33", 128},
    {"\xF0\xB0\x89\xBF", "\x9A\x34\xC4\x31", 128},
    {"\xF0\xB0\x8B\xBF", "\x9A\x34\xD0\x39", 128},
    {"\xF0\xB0\x8D\xBF", "\x9A\x34\xDD\x37", 128},
    {"\xF0\xB0\x8F\xBF", "\x9A\x34\xEA\x35", 128},
    {"\xF0\xB0\x91\xBF", "\x9A\x34\xF7\x33", 128},
    {"\xF0\xB0\x93\xBF", "\x9A\x35\x86\x31", 128},
    {"\xF0\xB0\x95\xBF", "\x9A\x35\x92\x39", 128},
    {"\xF0\xB0\x97\xBF", "\x9A\x35\x9F\x37", 128},
    {"\xF0\xB0\x99\xBF", "\x9A\x35\xAC\x35", 128},
    {"\xF0\xB0\x9B\xBF", "\x9A\x35\xB9\x33", 128},
    {"\xF0\xB0\x9D\xBF", "\x9A\x35\xC6\x31", 128},
    {"\xF0\xB0\x9F\xBF", "\x9A\x35\xD2\x39", 128},
    {"\xF0\xB0\xA1\xBF", "\x9A\x35\xDF\x37", 128},
    {"\xF0\xB0\xA3\xBF", "\x9A\x35\xEC\x35", 128},
    {"\xF0\xB0\xA5\xBF", "\x9A\x35\xF9\x33", 128},
    {"\xF0\xB0\xA7\xBF", "\x9A\x36\x88\x31", 128},
    {"\xF0\xB0\xA9\xBF", "\x9A\x36\x94\x39", 128},
    {"\xF0\xB0\xAB\xBF", "\x9A\x36\xA1\x37", 128},
    {"\xF0\xB0\xAD\xBF", "\x9A\x36\xAE\x35", 128},
    {"\xF0\xB0\xAF\xBF", "\x9A\x36\xBB\x33", 128},
    {"\xF0\xB0\xB1\xBF", "\x9A\x36\xC8\x31", 128},
    {"\xF0\xB0\xB3\xBF", "\x9A\x36\xD4\x39", 128},
    {"\xF0\xB0\xB5\xBF", "\x9A\x36\xE1\x37", 128},
    {"\xF0\xB0\xB7\xBF", "\x9A\x36\xEE\x35", 128},
    {"\xF0\xB0\xB9\xBF", "\x9A\x36\xFB\x33", 128},
    {"\xF0\xB0\xBB\xBF", "\x9A\x37\x8A\x31", 128},
    {"\xF0\xB0\xBD\xBF", "\x9A\x37\x96\x39", 128},
    {"\xF0\xB0\xBF\xBF", "\x9A\x37\xA3\x37", 128},
    {"\xF0\xB1\x81\xBF", "\x9A\x37\xB0\x35", 128},
    {"\xF0\xB1\x83\xBF", "\x9A\x37\xBD\x33", 128},
    {"\xF0\xB1\x85\xBF", "\x9A\x37\xCA\x31", 128},
    {"\xF0\xB1\x87\xBF", "\x9A\x37\xD6\x39", 128},
    {"\xF0\xB1\x89\xBF", "\x9A\x37\xE3\x37", 128},
    {"\xF0\xB1\x8B\xBF", "\x9A\x37\xF0\x35", 128},
    {"\xF0\xB1\x8D\xBF", "\x9A\x37\xFD\x33", 128},
    {"\xF0\xB1\x8F\xBF", "\x9A\x38\x8C\x31", 128},
    {"\xF0\xB1\x91\xBF", "\x9A\x38\x98\x39", 128},
    {"\xF0\xB1\x93\xBF", "\x9A\x38\xA5\x37", 128},
    {"\xF0\xB1\x95\xBF", "\x9A\x38\xB2\x35", 128},
    {"\xF0\xB1\x97\xBF", "\x9A\x38\xBF\x33", 128},
    {"\xF0\xB1\x99\xBF", "\x9A\x38\xCC\x31", 128},
    {"\xF0\xB1\x9B\xBF", "\x9A\x38\xD8\x39", 128},
    {"\xF0\xB1\x9D\xBF", "\x9A\x38\xE5\x37", 128},
    {"\xF0\xB1\x9F\xBF", "\x9A\x38\xF2\x35", 128},
    {"\xF0\xB1\xA1\xBF", "\x9A\x39\x81\x33", 128},
    {"\xF0\xB1\xA3\xBF", "\x9A\x39\x8E\x31", 128},
    {"\xF0\xB1\xA5\xBF", "\x9A\x39\x9A\x39", 128},
    {"\xF0\xB1\xA7\xBF", "\x9A\x39\xA7\x37", 128},
    {"\xF0\xB1\xA9\xBF", "\x9A\x39\xB4\x35", 128},
    {"\xF0\xB1\xAB\xBF", "\x9A\x39\xC1\x33", 128},
    {"\xF0\xB1\xAD\xBF", "\x9A\x39\xCE\x31", 128},
    {"\xF0\xB1\xAF\xBF", "\x9A\x39\xDA\x39", 128},
    {"\xF0\xB1\xB1\xBF", "\x9A\x39\xE7\x37", 128},
    {"\xF0\xB1\xB3\xBF", "\x9A\x39\xF4\x35", 128},
    {"\xF0\xB1\xB5\xBF", "\x9B\x30\x83\x33", 128},
    {"\xF0\xB1\xB7\xBF", "\x9B\x30\x90\x31", 128},
    {"\xF0\xB1\xB9\xBF", "\x9B\x30\x9C\x39", 128},
    {"\xF0\xB1\xBB\xBF", "\x9B\x30\xA9\x37", 128},
    {"\xF0\xB1\xBD\xBF", "\x9B\x30\xB6\x35", 128},
    {"\xF0\xB1\xBF\xBF", "\x9B\x30\xC3\x33", 128},
    {"\xF0\xB2\x81\xBF", "\x9B\x30\xD0\x31", 128},
    {"\xF0\xB2\x83\xBF", "\x9B\x30\xDC\x39", 128},
    {"\xF0\xB2\x85\xBF", "\x9B\x30\xE9\x37", 128},
    {"\xF0\xB2\x87\xBF", "\x9B\x30\xF6\x35", 128},
    {"\xF0\xB2\x89\xBF", "\x9B\x31\x85\x33", 128},
    {"\xF0\xB2\x8B\xBF", "\x9B\x31\x92\x31", 128},
    {"\xF0\xB2\x8D\xBF", "\x9B\x31\x9E\x39", 128},
    {"\xF0\xB2\x8F\xBF", "\x9B\x31\xAB\x37", 128},
    {"\xF0\xB2\x91\xBF", "\x9B\x31\xB8\x35", 128},
    {"\xF0\xB2\x93\xBF", "\x9B\x31\xC5\x33", 128},
    {"\xF0\xB2\x95\xBF", "\x9B\x31\xD2\x31", 128},
    {"\xF0\xB2\x97\xBF", "\x9B\x31\xDE\x39", 128},
    {"\xF0\xB2\x99\xBF", "\x9B\x31\xEB\x37", 128},
    {"\xF0\xB2\x9B\xBF", "\x9B\x31\xF8\x35", 128},
    {"\xF0\xB2\x9D\xBF", "\x9B\x32\x87\x33", 128},
    {"\xF0\xB2\x9F\xBF", "\x9B\x32\x94\x31", 128},
    {"\xF0\xB2\xA1\xBF", "\x9B\x32\xA0\x39", 128},
    {"\xF0\xB2\xA3\xBF", "\x9B\x32\xAD\x37", 128},
    {"\xF0\xB2\xA5\xBF", "\x9B\x32\xBA\x35", 128},
    {"\xF0\xB2\xA7\xBF", "\x9B\x32\xC7\x33", 128},
    {"\xF0\xB2\xA9\xBF", "\x9B\x32\xD4\x31", 128},
    {"\xF0\xB2\xAB\xBF", "\x9B\x32\xE0\x39", 128},
    {"\xF0\xB2\xAD\xBF", "\x9B\x32\xED\x37", 128},
    {"\xF0\xB2\xAF\xBF", "\x9B\x32\xFA\x35", 128},
    {"\xF0\xB2\xB1\xBF", "\x9B\x33\x89\x33", 128},
    {"\xF0\xB2\xB3\xBF", "\x9B\x33\x96\x31", 128},
    {"\xF0\xB2\xB5\xBF", "\x9B\x33\xA2\x39", 128},
    {"\xF0\xB2\xB7\xBF", "\x9B\x33\xAF\x37", 128},
    {"\xF0\xB2\xB9\xBF", "\x9B\x33\xBC\x35", 128},
    {"\xF0\xB2\xBB\xBF", "\x9B\x33\xC9\x33", 128},
    {"\xF0\xB2\xBD\xBF", "\x9B\x33\xD6\x31", 128},
    {"\xF0\xB2\xBF\xBF", "\x9B\x33\xE2\x39", 128},
    {"\xF0\xB3\x81\xBF", "\x9B\x33\xEF\x37", 128},
    {"\xF0\xB3\x83\xBF", "\x9B\x33\xFC\x35", 128},
    {"\xF0\xB3\x85\xBF", "\x9B\x34\x8B\x33", 128},
    {"\xF0\xB3\x87\xBF", "\x9B\x34\x98\x31", 128},
    {"\xF0\xB3\x89\xBF", "\x9B\x34\xA4\x39", 128},
    {"\xF0\xB3\x8B\xBF", "\x9B\x34\xB1\x37", 128},
    {"\xF0\xB3\x8D\xBF", "\x9B\x34\xBE\x35", 128},
    {"\xF0\xB3\x8F\xBF", "\x9B\x34\xCB\x33", 128},
    {"\xF0\xB3\x91\xBF", "\x9B\x34\xD8\x31", 128},
    {"\xF0\xB3\x93\xBF", "\x9B\x34\xE4\x39", 128},
    {"\xF0\xB3\x95\xBF", "\x9B\x34\xF1\x37", 128},
    {"\xF0\xB3\x97\xBF", "\x9B\x34\xFE\x35", 128},
    {"\xF0\xB3\x99\xBF", "\x9B\x35\x8D\x33", 128},
    {"\xF0\xB3\x9B\xBF", "\x9B\x35\x9A\x31", 128},
    {"\xF0\xB3\x9D\xBF", "\x9B\x35\xA6\x39", 128},
    {"\xF0\xB3\x9F\xBF", "\x9B\x35\xB3\x37", 128},
    {"\xF0\xB3\xA1\xBF", "\x9B\x35\xC0\x35", 128},
    {"\xF0\xB3\xA3\xBF", "\x9B\x35\xCD\x33", 128},
    {"\xF0\xB3\xA5\xBF", "\x9B\x35\xDA\x31", 128},
    {"\xF0\xB3\xA7\xBF", "\x9B\x35\xE6\x39", 128},
    {"\xF0\xB3\xA9\xBF", "\x9B\x35\xF3\x37", 128},
    {"\xF0\xB3\xAB\xBF", "\x9B\x36\x82\x35", 128},
    {"\xF0\xB3\xAD\xBF", "\x9B\x36\x8F\x33", 128},
    {"\xF0\xB3\xAF\xBF", "\x9B\x36\x9C\x31", 128},
    {"\xF0\xB3\xB1\xBF", "\x9B\x36\xA8\x39", 128},
    {"\xF0\xB3\xB3\xBF", "\x9B\x36\xB5\x37", 128},
    {"\xF0\xB3\xB5\xBF", "\x9B\x36\xC2\x35", 128},
    {"\xF0\xB3\xB7\xBF", "\x9B\x36\xCF\x33", 128},
    {"\xF0\xB3\xB9\xBF", "\x9B\x36\xDC\x31", 128},
    {"\xF0\xB3\xBB\xBF", "\x9B\x36\xE8\x39", 128},
    {"\xF0\xB3\xBD\xBF", "\x9B\x36\xF5\x37", 128},
    {"\xF0\xB3\xBF\xBF", "\x9B\x37\x84\x35", 128},
    {"\xF0\xB4\x81\xBF", "\x9B\x37\x91\x33", 128},
    {"\xF0\xB4\x83\xBF", "\x9B\x37\x9E\x31", 128},
    {"\xF0\xB4\x85\xBF", "\x9B\x37\xAA\x39", 128},
    {"\xF0\xB4\x87\xBF", "\x9B\x37\xB7\x37", 128},
    {"\xF0\xB4\x89\xBF", "\x9B\x37\xC4\x35", 128},
    {"\xF0\xB4\x8B\xBF", "\x9B\x37\xD1\x33", 128},
    {"\xF0\xB4\x8D\xBF", "\x9B\x37\xDE\x31", 128},
    {"\xF0\xB4\x8F\xBF", "\x9B\x37\xEA\x39", 128},
    {"\xF0\xB4\x91\xBF", "\x9B\x37\xF7\x37", 128},
    {"\xF0\xB4\x93\xBF", "\x9B\x38\x86\x35", 128},
    {"\xF0\xB4\x95\xBF", "\x9B\x38\x93\x33", 128},
    {"\xF0\xB4\x97\xBF", "\x9B\x38\xA0\x31", 128},
    {"\xF0\xB4\x99\xBF", "\x9B\x38\xAC\x39", 128},
    {"\xF0\xB4\x9B\xBF", "\x9B\x38\xB9\x37", 128},
    {"\xF0\xB4\x9D\xBF", "\x9B\x38\xC6\x35", 128},
    {"\xF0\xB4\x9F\xBF", "\x9B\x38\xD3\x33", 128},
    {"\xF0\xB4\xA1\xBF", "\x9B\x38\xE0\x31", 128},
    {"\xF0\xB4\xA3\xBF", "\x9B\x38\xEC\x39", 128},
    {"\xF0\xB4\xA5\xBF", "\x9B\x38\xF9\x37", 128},
    {"\xF0\xB4\xA7\xBF", "\x9B\x39\x88\x35", 128},
    {"\xF0\xB4\xA9\xBF", "\x9B\x39\x95\x33", 128},
    {"\xF0\xB4\xAB\xBF", "\x9B\x39\xA2\x31", 128},
    {"\xF0\xB4\xAD\xBF", "\x9B\x39\xAE\x39", 128},
    {"\xF0\xB4\xAF\xBF", "\x9B\x39\xBB\x37", 128},
    {"\xF0\xB4\xB1\xBF", "\x9B\x39\xC8\x35", 128},
    {"\xF0\xB4\xB3\xBF", "\x9B\x39\xD5\x33", 128},
    {"\xF0\xB4\xB5\xBF", "\x9B\x39\xE2\x31", 128},
    {"\xF0\xB4\xB7\xBF", "\x9B\x39\xEE\x39", 128},
    {"\xF0\xB4\xB9\xBF", "\x9B\x39\xFB\x37", 128},
    {"\xF0\xB4\xBB\xBF", "\x9C\x30\x8A\x35", 128},
    {"\xF0\xB4\xBD\xBF", "\x9C\x30\x97\x33", 128},
    {"\xF0\xB4\xBF\xBF", "\x9C\x30\xA4\x31", 128},
    {"\xF0\xB5\x81\xBF", "\x9C\x30\xB0\x39", 128},
    {"\xF0\xB5\x83\xBF", "\x9C\x30\xBD\x37", 128},
    {"\xF0\xB5\x85\xBF", "\x9C\x30\xCA\x35", 128},
    {"\xF0\xB5\x87\xBF", "\x9C\x30\xD7\x33", 128},
    {"\xF0\xB5\x89\xBF", "\x9C\x30\xE4\x31", 128},
    {"\xF0\xB5\x8B\xBF", "\x9C\x30\xF0\x39", 128},
    {"\xF0\xB5\x8D\xBF", "\x9C\x30\xFD\x37", 128},
    {"\xF0\xB5\x8F\xBF", "\x9C\x31\x8C\x35", 128},
    {"\xF0\xB5\x91\xBF", "\x9C\x31\x99\x33", 128},
    {"\xF0\xB5\x93\xBF", "\x9C\x31\xA6\x31", 128},
    {"\xF0\xB5\x95\xBF", "\x9C\x31\xB2\x39", 128},
    {"\xF0\xB5\x97\xBF", "\x9C\x31\xBF\x37", 128},
    {"\xF0\xB5\x99\xBF", "\x9C\x31\xCC\x35", 128},
    {"\xF0\xB5\x9B\xBF", "\x9C\x31\xD9\x33", 128},
    {"\xF0\xB5\x9D\xBF", "\x9C\x31\xE6\x31", 128},
    {"\xF0\xB5\x9F\xBF", "\x9C\x31\xF2\x39", 128},
    {"\xF0\xB5\xA1\xBF", "\x9C\x32\x81\x37", 128},
    {"\xF0\xB5\xA3\xBF", "\x9C\x32\x8E\x35", 128},
    {"\xF0\xB5\xA5\xBF", "\x9C\x32\x9B\x33", 128},
    {"\xF0\xB5\xA7\xBF", "\x9C\x32\xA8\x31", 128},
    {"\xF0\xB5\xA9\xBF", "\x9C\x32\xB4\x39", 128},
    {"\xF0\xB5\xAB\xBF", "\x9C\x32\xC1\x37", 128},
    {"\xF0\xB5\xAD\xBF", "\x9C\x32\xCE\x35", 128},
    {"\xF0\xB5\xAF\xBF", "\x9C\x32\xDB\x33", 128},
    {"\xF0\xB5\xB1\xBF", "\x9C\x32\xE8\x31", 128},
    {"\xF0\xB5\xB3\xBF", "\x9C\x32\xF4\x39", 128},
    {"\xF0\xB5\xB5\xBF", "\x9C\x33\x83\x37", 128},
    {"\xF0\xB5\xB7\xBF", "\x9C\x33\x90\x35", 128},
    {"\xF0\xB5\xB9\xBF", "\x9C\x33\x9D\x33", 128},
    {"\xF0\xB5\xBB\xBF", "\x9C\x33\xAA\x31", 128},
    {"\xF0\xB5\xBD\xBF", "\x9C\x33\xB6\x39", 128},
    {"\xF0\xB5\xBF\xBF", "\x9C\x33\xC3\x37", 128},
    {"\xF0\xB6\x81\xBF", "\x9C\x33\xD0\x35", 128},
    {"\xF0\xB6\x83\xBF", "\x9C\x33\xDD\x33", 128},
    {"\xF0\xB6\x85\xBF", "\x9C\x33\xEA\x31", 128},
    {"\xF0\xB6\x87\xBF", "\x9C\x33\xF6\x39", 128},
    {"\xF0\xB6\x89\xBF", "\x9C\x34\x85\x37", 128},
    {"\xF0\xB6\x8B\xBF", "\x9C\x34\x92\x35", 128},
    {"\xF0\xB6\x8D\xBF", "\x9C\x34\x9F\x33", 128},
    {"\xF0\xB6\x8F\xBF", "\x9C\x34\xAC\x31", 128},
    {"\xF0\xB6\x91\xBF", "\x9C\x34\xB8\x39", 128},
    {"\xF0\xB6\x93\xBF", "\x9C\x34\xC5\x37", 128},
    {"\xF0\xB6\x95\xBF", "\x9C\x34\xD2\x35", 128},
    {"\xF0\xB6\x97\xBF", "\x9C\x34\xDF\x33", 128},
    {"\xF0\xB6\x99\xBF", "\x9C\x34\xEC\x31", 128},
    {"\xF0\xB6\x9B\xBF", "\x9C\x34\xF8\x39", 128},
    {"\xF0\xB6\x9D\xBF", "\x9C\x35\x87\x37", 128},
    {"\xF0\xB6\x9F\xBF", "\x9C\x35\x94\x35", 128},
    {"\xF0\xB6\xA1\xBF", "\x9C\x35\xA1\x33", 128},
    {"\xF0\xB6\xA3\xBF", "\x9C\x35\xAE\x31", 128},
    {"\xF0\xB6\xA5\xBF", "\x9C\x35\xBA\x39", 128},
    {"\xF0\xB6\xA7\xBF", "\x9C\x35\xC7\x37", 128},
    {"\xF0\xB6\xA9\xBF", "\x9C\x35\xD4\x35", 128},
    {"\xF0\xB6\xAB\xBF", "\x9C\x35\xE1\x33", 128},
    {"\xF0\xB6\xAD\xBF", "\x9C\x35\xEE\x31", 128},
    {"\xF0\xB6\xAF\xBF", "\x9C\x35\xFA\x39", 128},
    {"\xF0\xB6\xB1\xBF", "\x9C\x36\x89\x37", 128},
    {"\xF0\xB6\xB3\xBF", "\x9C\x36\x96\x35", 128},
    {"\xF0\xB6\xB5\xBF", "\x9C\x36\xA3\x33", 128},
    {"\xF0\xB6\xB7\xBF", "\x9C\x36\xB0\x31", 128},
    {"\xF0\xB6\xB9\xBF", "\x9C\x36\xBC\x39", 128},
    {"\xF0\xB6\xBB\xBF", "\x9C\x36\xC9\x37", 128},
    {"\xF0\xB6\xBD\xBF", "\x9C\x36\xD6\x35", 128},
    {"\xF0\xB6\xBF\xBF", "\x9C\x36\xE3\x33", 128},
    {"\xF0\xB7\x81\xBF", "\x9C\x36\xF0\x31", 128},
    {"\xF0\xB7\x83\xBF", "\x9C\x36\xFC\x39", 128},
    {"\xF0\xB7\x85\xBF", "\x9C\x37\x8B\x37", 128},
    {"\xF0\xB7\x87\xBF", "\x9C\x37\x98\x35", 128},
    {"\xF0\xB7\x89\xBF", "\x9C\x37\xA5\x33", 128},
    {"\xF0\xB7\x8B\xBF", "\x9C\x37\xB2\x31", 128},
    {"\xF0\xB7\x8D\xBF", "\x9C\x37\xBE\x39", 128},
    {"\xF0\xB7\x8F\xBF", "\x9C\x37\xCB\x37", 128},
    {"\xF0\xB7\x91\xBF", "\x9C\x37\xD8\x35", 128},
    {"\xF0\xB7\x93\xBF", "\x9C\x37\xE5\x33", 128},
    {"\xF0\xB7\x95\xBF", "\x9C\x37\xF2\x31", 128},
    {"\xF0\xB7\x97\xBF", "\x9C\x37\xFE\x39", 128},
    {"\xF0\xB7\x99\xBF", "\x9C\x38\x8D\x37", 128},
    {"\xF0\xB7\x9B\xBF", "\x9C\x38\x9A\x35", 128},
    {"\xF0\xB7\x9D\xBF", "\x9C\x38\xA7\x33", 128},
    {"\xF0\xB7\x9F\xBF", "\x9C\x38\xB4\x31", 128},
    {"\xF0\xB7\xA1\xBF", "\x9C\x38\xC0\x39", 128},
    {"\xF0\xB7\xA3\xBF", "\x9C\x38\xCD\x37", 128},
    {"\xF0\xB7\xA5\xBF", "\x9C\x38\xDA\x35", 128},
    {"\xF0\xB7\xA7\xBF", "\x9C\x38\xE7\x33", 128},
    {"\xF0\xB7\xA9\xBF", "\x9C\x38\xF4\x31", 128},
    {"\xF0\xB7\xAB\xBF", "\x9C\x39\x82\x39", 128},
    {"\xF0\xB7\xAD\xBF", "\x9C\x39\x8F\x37", 128},
    {"\xF0\xB7\xAF\xBF", "\x9C\x39\x9C\x35", 128},
    {"\xF0\xB7\xB1\xBF", "\x9C\x39\xA9\x33", 128},
    {"\xF0\xB7\xB3\xBF", "\x9C\x39\xB6\x31", 128},
    {"\xF0\xB7\xB5\xBF", "\x9C\x39\xC2\x39", 128},
    {"\xF0\xB7\xB7\xBF", "\x9C\x39\xCF\x37", 128},
    {"\xF0\xB7\xB9\xBF", "\x9C\x39\xDC\x35", 128},
    {"\xF0\xB7\xBB\xBF", "\x9C\x39\xE9\x33", 128},
    {"\xF0\xB7\xBD\xBF", "\x9C\x39\xF6\x31", 128},
    {"\xF0\xB7\xBF\xBF", "\x9D\x30\x84\x39", 128},
    {"\xF0\xB8\x81\xBF", "\x9D\x30\x91\x37", 128},
    {"\xF0\xB8\x83\xBF", "\x9D\x30\x9E\x35", 128},
    {"\xF0\xB8\x85\xBF", "\x9D\x30\xAB\x33", 128},
    {"\xF0\xB8\x87\xBF", "\x9D\x30\xB8\x31", 128},
    {"\xF0\xB8\x89\xBF", "\x9D\x30\xC4\x39", 128},
    {"\xF0\xB8\x8B\xBF", "\x9D\x30\xD1\x37", 128},
    {"\xF0\xB8\x8D\xBF", "\x9D\x30\xDE\x35", 128},
    {"\xF0\xB8\x8F\xBF", "\x9D\x30\xEB\x33", 128},
    {"\xF0\xB8\x91\xBF", "\x9D\x30\xF8\x31", 128},
    {"\xF0\xB8\x93\xBF", "\x9D\x31\x86\x39", 128},
    {"\xF0\xB8\x95\xBF", "\x9D\x31\x93\x37", 128},
    {"\xF0\xB8\x97\xBF", "\x9D\x31\xA0\x35", 128},
    {"\xF0\xB8\x99\xBF", "\x9D\x31\xAD\x33", 128},
    {"\xF0\xB8\x9B\xBF", "\x9D\x31\xBA\x31", 128},
    {"\xF0\xB8\x9D\xBF", "\x9D\x31\xC6\x39", 128},
    {"\xF0\xB8\x9F\xBF", "\x9D\x31\xD3\x37", 128},
    {"\xF0\xB8\xA1\xBF", "\x9D\x31\xE0\x35", 128},
    {"\xF0\xB8\xA3\xBF", "\x9D\x31\xED\x33", 128},
    {"\xF0\xB8\xA5\xBF", "\x9D\x31\xFA\x31", 128},
    {"\xF0\xB8\xA7\xBF", "\x9D\x32\x88\x39", 128},
    {"\xF0\xB8\xA9\xBF", "\x9D\x32\x95\x37", 128},
    {"\xF0\xB8\xAB\xBF", "\x9D\x32\xA2\x35", 128},
    {"\xF0\xB8\xAD\xBF", "\x9D\x32\xAF\x33", 128},
    {"\xF0\xB8\xAF\xBF", "\x9D\x32\xBC\x31", 128},
    {"\xF0\xB8\xB1\xBF", "\x9D\x32\xC8\x39", 128},
    {"\xF0\xB8\xB3\xBF", "\x9D\x32\xD5\x37", 128},
    {"\xF0\xB8\xB5\xBF", "\x9D\x32\xE2\x35", 128},
    {"\xF0\xB8\xB7\xBF", "\x9D\x32\xEF\x33", 128},
    {"\xF0\xB8\xB9\xBF", "\x9D\x32\xFC\x31", 128},
    {"\xF0\xB8\xBB\xBF", "\x9D\x33\x8A\x39", 128},
    {"\xF0\xB8\xBD\xBF", "\x9D\x33\x97\x37", 128},
    {"\xF0\xB8\xBF\xBF", "\x9D\x33\xA4\x35", 128},
    {"\xF0\xB9\x81\xBF", "\x9D\x33\xB1\x33", 128},
    {"\xF0\xB9\x83\xBF", "\x9D\x33\xBE\x31", 128},
    {"\xF0\xB9\x85\xBF", "\x9D\x33\xCA\x39", 128},
    {"\xF0\xB9\x87\xBF", "\x9D\x33\xD7\x37", 128},
    {"\xF0\xB9\x89\xBF", "\x9D\x33\xE4\x35", 128},
    {"\xF0\xB9\x8B\xBF", "\x9D\x33\xF1\x33", 128},
    {"\xF0\xB9\x8D\xBF", "\x9D\x33\xFE\x31", 128},
    {"\xF0\xB9\x8F\xBF", "\x9D\x34\x8C\x39", 128},
    {"\xF0\xB9\x91\xBF", "\x9D\x34\x99\x37", 128},
    {"\xF0\xB9\x93\xBF", "\x9D\x34\xA6\x35", 128},
    {"\xF0\xB9\x95\xBF", "\x9D\x34\xB3\x33", 128},
    {"\xF0\xB9\x97\xBF", "\x9D\x34\xC0\x31", 128},
    {"\xF0\xB9\x99\xBF", "\x9D\x34\xCC\x39", 128},
    {"\xF0\xB9\x9B\xBF", "\x9D\x34\xD9\x37", 128},
    {"\xF0\xB9\x9D\xBF", "\x9D\x34\xE6\x35", 128},
    {"\xF0\xB9\x9F\xBF", "\x9D\x34\xF3\x33", 128},
    {"\xF0\xB9\xA1\xBF", "\x9D\x35\x82\x31", 128},
    {"\xF0\xB9\xA3\xBF", "\x9D\x35\x8E\x39", 128},
    {"\xF0\xB9\xA5\xBF", "\x9D\x35\x9B\x37", 128},
    {"\xF0\xB9\xA7\xBF", "\x9D\x35\xA8\x35", 128},
    {"\xF0\xB9\xA9\xBF", "\x9D\x35\xB5\x33", 128},
    {"\xF0\xB9\xAB\xBF", "\x9D\x35\xC2\x31", 128},
    {"\xF0\xB9\xAD\xBF", "\x9D\x35\xCE\x39", 128},
    {"\xF0\xB9\xAF\xBF", "\x9D\x35\xDB\x37", 128},
    {"\xF0\xB9\xB1\xBF", "\x9D\x35\xE8\x35", 128},
    {"\xF0\xB9\xB3\xBF", "\x9D\x35\xF5\x33", 128},
    {"\xF0\xB9\xB5\xBF", "\x9D\x36\x84\x31", 128},
    {"\xF0\xB9\xB7\xBF", "\x9D\x36\x90\x39", 128},
    {"\xF0\xB9\xB9\xBF", "\x9D\x36\x9D\x37", 128},
    {"\xF0\xB9\xBB\xBF", "\x9D\x36\xAA\x35", 128},
    {"\xF0\xB9\xBD\xBF", "\x9D\x36\xB7\x33", 128},
    {"\xF0\xB9\xBF\xBF", "\x9D\x36\xC4\x31", 128},
    {"\xF0\xBA\x81\xBF", "\x9D\x36\xD0\x39", 128},
    {"\xF0\xBA\x83\xBF", "\x9D\x36\xDD\x37", 128},
    {"\xF0\xBA\x85\xBF", "\x9D\x36\xEA\x35", 128},
    {"\xF0\xBA\x87\xBF", "\x9D\x36\xF7\x33", 128},
    {"\xF0\xBA\x89\xBF", "\x9D\x37\x86\x31", 128},
    {"\xF0\xBA\x8B\xBF", "\x9D\x37\x92\x39", 128},
    {"\xF0\xBA\x8D\xBF", "\x9D\x37\x9F\x37", 128},
    {"\xF0\xBA\x8F\xBF", "\x9D\x37\xAC\x35", 128},
    {"\xF0\xBA\x91\xBF", "\x9D\x37\xB9\x33", 128},
    {"\xF0\xBA\x93\xBF", "\x9D\x37\xC6\x31", 128},
    {"\xF0\xBA\x95\xBF", "\x9D\x37\xD2\x39", 128},
    {"\xF0\xBA\x97\xBF", "\x9D\x37\xDF\x37", 128},
    {"\xF0\xBA\x99\xBF", "\x9D\x37\xEC\x35", 128},
    {"\xF0\xBA\x9B\xBF", "\x9D\x37\xF9\x33", 128},
    {"\xF0\xBA\x9D\xBF", "\x9D\x38\x88\x31", 128},
    {"\xF0\xBA\x9F\xBF", "\x9D\x38\x94\x39", 128},
    {"\xF0\xBA\xA1\xBF", "\x9D\x38\xA1\x37", 128},
    {"\xF0\xBA\xA3\xBF", "\x9D\x38\xAE\x35", 128},
    {"\xF0\xBA\xA5\xBF", "\x9D\x38\xBB\x33", 128},
    {"\xF0\xBA\xA7\xBF", "\x9D\x38\xC8\x31", 128},
    {"\xF0\xBA\xA9\xBF", "\x9D\x38\xD4\x39", 128},
    {"\xF0\xBA\xAB\xBF", "\x9D\x38\xE1\x37", 128},
    {"\xF0\xBA\xAD\xBF", "\x9D\x38\xEE\x35", 128},
    {"\xF0\xBA\xAF\xBF", "\x9D\x38\xFB\x33", 128},
    {"\xF0\xBA\xB1\xBF", "\x9D\x39\x8A\x31", 128},
    {"\xF0\xBA\xB3\xBF", "\x9D\x39\x96\x39", 128},
    {"\xF0\xBA\xB5\xBF", "\x9D\x39\xA3\x37", 128},
    {"\xF0\xBA\xB7\xBF", "\x9D\x39\xB0\x35", 128},
    {"\xF0\xBA\xB9\xBF", "\x9D\x39\xBD\x33", 128},
    {"\xF0\xBA\xBB\xBF", "\x9D\x39\xCA\x31", 128},
    {"\xF0\xBA\xBD\xBF", "\x9D\x39\xD6\x39", 128},
    {"\xF0\xBA\xBF\xBF", "\x9D\x39\xE3\x37", 128},
    {"\xF0\xBB\x81\xBF", "\x9D\x39\xF0\x35", 128},
    {"\xF0\xBB\x83\xBF", "\x9D\x39\xFD\x33", 128},
    {"\xF0\xBB\x85\xBF", "\x9E\x30\x8C\x31", 128},
    {"\xF0\xBB\x87\xBF", "\x9E\x30\x98\x39", 128},
    {"\xF0\xBB\x89\xBF", "\x9E\x30\xA5\x37", 128},
    {"\xF0\xBB\x8B\xBF", "\x9E\x30\xB2\x35", 128},
    {"\xF0\xBB\x8D\xBF", "\x9E\x30\xBF\x33", 128},
    {"\xF0\xBB\x8F\xBF", "\x9E\x30\xCC\x31", 128},
    {"\xF0\xBB\x91\xBF", "\x9E\x30\xD8\x39", 128},
    {"\xF0\xBB\x93\xBF", "\x9E\x30\xE5\x37", 128},
    {"\xF0\xBB\x95\xBF", "\x9E\x30\xF2\x35", 128},
    {"\xF0\xBB\x97\xBF", "\x9E\x31\x81\x33", 128},
    {"\xF0\xBB\x99\xBF", "\x9E\x31\x8E\x31", 128},
    {"\xF0\xBB\x9B\xBF", "\x9E\x31\x9A\x39", 128},
    {"\xF0\xBB\x9D\xBF", "\x9E\x31\xA7\x37", 128},
    {"\xF0\xBB\x9F\xBF", "\x9E\x31\xB4\x35", 128},
    {"\xF0\xBB\xA1\xBF", "\x9E\x31\xC1\x33", 128},
    {"\xF0\xBB\xA3\xBF", "\x9E\x31\xCE\x31", 128},
    {"\xF0\xBB\xA5\xBF", "\x9E\x31\xDA\x39", 128},
    {"\xF0\xBB\xA7\xBF", "\x9E\x31\xE7\x37", 128},
    {"\xF0\xBB\xA9\xBF", "\x9E\x31\xF4\x35", 128},
    {"\xF0\xBB\xAB\xBF", "\x9E\x32\x83\x33", 128},
    {"\xF0\xBB\xAD\xBF", "\x9E\x32\x90\x31", 128},
    {"\xF0\xBB\xAF\xBF", "\x9E\x32\x9C\x39", 128},
    {"\xF0\xBB\xB1\xBF", "\x9E\x32\xA9\x37", 128},
    {"\xF0\xBB\xB3\xBF", "\x9E\x32\xB6\x35", 128},
    {"\xF0\xBB\xB5\xBF", "\x9E\x32\xC3\x33", 128},
    {"\xF0\xBB\xB7\xBF", "\x9E\x32\xD0\x31", 128},
    {"\xF0\xBB\xB9\xBF", "\x9E\x32\xDC\x39", 128},
    {"\xF0\xBB\xBB\xBF", "\x9E\x32\xE9\x37", 128},
    {"\xF0\xBB\xBD\xBF", "\x9E\x32\xF6\x35", 128},
    {"\xF0\xBB\xBF\xBF", "\x9E\x33\x85\x33", 128},
    {"\xF0\xBC\x81\xBF", "\x9E\x33\x92\x31", 128},
    {"\xF0\xBC\x83\xBF", "\x9E\x33\x9E\x39", 128},
    {"\xF0\xBC\x85\xBF", "\x9E\x33\xAB\x37", 128},
    {"\xF0\xBC\x87\xBF", "\x9E\x33\xB8\x35", 128},
    {"\xF0\xBC\x89\xBF", "\x9E\x33\xC5\x33", 128},
    {"\xF0\xBC\x8B\xBF", "\x9E\x33\xD2\x31", 128},
    {"\xF0\xBC\x8D\xBF", "\x9E\x33\xDE\x39", 128},
    {"\xF0\xBC\x8F\xBF", "\x9E\x33\xEB\x37", 128},
    {"\xF0\xBC\x91\xBF", "\x9E\x33\xF8\x35", 128},
    {"\xF0\xBC\x93\xBF", "\x9E\x34\x87\x33", 128},
    {"\xF0\xBC\x95\xBF", "\x9E\x34\x94\x31", 128},
    {"\xF0\xBC\x97\xBF", "\x9E\x34\xA0\x39", 128},
    {"\xF0\xBC\x99\xBF", "\x9E\x34\xAD\x37", 128},
    {"\xF0\xBC\x9B\xBF", "\x9E\x34\xBA\x35", 128},
    {"\xF0\xBC\x9D\xBF", "\x9E\x34\xC7\x33", 128},
    {"\xF0\xBC\x9F\xBF", "\x9E\x34\xD4\x31", 128},
    {"\xF0\xBC\xA1\xBF", "\x9E\x34\xE0\x39", 128},
    {"\xF0\xBC\xA3\xBF", "\x9E\x34\xED\x37", 128},
    {"\xF0\xBC\xA5\xBF", "\x9E\x34\xFA\x35", 128},
    {"\xF0\xBC\xA7\xBF", "\x9E\x35\x89\x33", 128},
    {"\xF0\xBC\xA9\xBF", "\x9E\x35\x96\x31", 128},
    {"\xF0\xBC\xAB\xBF", "\x9E\x35\xA2\x39", 128},
    {"\xF0\xBC\xAD\xBF", "\x9E\x35\xAF\x37", 128},
    {"\xF0\xBC\xAF\xBF", "\x9E\x35\xBC\x35", 128},
    {"\xF0\xBC\xB1\xBF", "\x9E\x35\xC9\x33", 128},
    {"\xF0\xBC\xB3\xBF", "\x9E\x35\xD6\x31", 128},
    {"\xF0\xBC\xB5\xBF", "\x9E\x35\xE2\x39", 128},
    {"\xF0\xBC\xB7\xBF", "\x9E\x35\xEF\x37", 128},
    {"\xF0\xBC\xB9\xBF", "\x9E\x35\xFC\x35", 128},
    {"\xF0\xBC\xBB\xBF", "\x9E\x36\x8B\x33", 128},
    {"\xF0\xBC\xBD\xBF", "\x9E\x36\x98\x31", 128},
    {"\xF0\xBC\xBF\xBF", "\x9E\x36\xA4\x39", 128},
    {"\xF0\xBD\x81\xBF", "\x9E\x36\xB1\x37", 128},
    {"\xF0\xBD\x83\xBF", "\x9E\x36\xBE\x35", 128},
    {"\xF0\xBD\x85\xBF", "\x9E\x36\xCB\x33", 128},
    {"\xF0\xBD\x87\xBF", "\x9E\x36\xD8\x31", 128},
    {"\xF0\xBD\x89\xBF", "\x9E\x36\xE4\x39", 128},
    {"\xF0\xBD\x8B\xBF", "\x9E\x36\xF1\x37", 128},
    {"\xF0\xBD\x8D\xBF", "\x9E\x36\xFE\x35", 128},
    {"\xF0\xBD\x8F\xBF", "\x9E\x37\x8D\x33", 128},
    {"\xF0\xBD\x91\xBF", "\x9E\x37\x9A\x31", 128},
    {"\xF0\xBD\x93\xBF", "\x9E\x37\xA6\x39", 128},
    {"\xF0\xBD\x95\xBF", "\x9E\x37\xB3\x37", 128},
    {"\xF0\xBD\x97\xBF", "\x9E\x37\xC0\x35", 128},
    {"\xF0\xBD\x99\xBF", "\x9E\x37\xCD\x33", 128},
    {"\xF0\xBD\x9B\xBF", "\x9E\x37\xDA\x31", 128},
    {"\xF0\xBD\x9D\xBF", "\x9E\x37\xE6\x39", 128},
    {"\xF0\xBD\x9F\xBF", "\x9E\x37\xF3\x37", 128},
    {"\xF0\xBD\xA1\xBF", "\x9E\x38\x82\x35", 128},
    {"\xF0\xBD\xA3\xBF", "\x9E\x38\x8F\x33", 128},
    {"\xF0\xBD\xA5\xBF", "\x9E\x38\x9C\x31", 128},
    {"\xF0\xBD\xA7\xBF", "\x9E\x38\xA8\x39", 128},
    {"\xF0\xBD\xA9\xBF", "\x9E\x38\xB5\x37", 128},
    {"\xF0\xBD\xAB\xBF", "\x9E\x38\xC2\x35", 128},
    {"\xF0\xBD\xAD\xBF", "\x9E\x38\xCF\x33", 128},
    {"\xF0\xBD\xAF\xBF", "\x9E\x38\xDC\x31", 128},
    {"\xF0\xBD\xB1\xBF", "\x9E\x38\xE8\x39", 128},
    {"\xF0\xBD\xB3\xBF", "\x9E\x38\xF5\x37", 128},
    {"\xF0\xBD\xB5\xBF", "\x9E\x39\x84\x35", 128},
    {"\xF0\xBD\xB7\xBF", "\x9E\x39\x91\x33", 128},
    {"\xF0\xBD\xB9\xBF", "\x9E\x39\x9E\x31", 128},
    {"\xF0\xBD\xBB\xBF", "\x9E\x39\xAA\x39", 128},
    {"\xF0\xBD\xBD\xBF", "\x9E\x39\xB7\x37", 128},
    {"\xF0\xBD\xBF\xBF", "\x9E\x39\xC4\x35", 128},
    {"\xF0\xBE\x81\xBF", "\x9E\x39\xD1\x33", 128},
    {"\xF0\xBE\x83\xBF", "\x9E\x39\xDE\x31", 128},
    {"\xF0\xBE\x85\xBF", "\x9E\x39\xEA\x39", 128},
    {"\xF0\xBE\x87\xBF", "\x9E\x39\xF7\x37", 128},
    {"\xF0\xBE\x89\xBF", "\x9F\x30\x86\x35", 128},
    {"\xF0\xBE\x8B\xBF", "\x9F\x30\x93\x33", 128},
    {"\xF0\xBE\x8D\xBF", "\x9F\x30\xA0\x31", 128},
    {"\xF0\xBE\x8F\xBF", "\x9F\x30\xAC\x39", 128},
    {"\xF0\xBE\x91\xBF", "\x9F\x30\xB9\x37", 128},
    {"\xF0\xBE\x93\xBF", "\x9F\x30\xC6\x35", 128},
    {"\xF0\xBE\x95\xBF", "\x9F\x30\xD3\x33", 128},
    {"\xF0\xBE\x97\xBF", "\x9F\x30\xE0\x31", 128},
    {"\xF0\xBE\x99\xBF", "\x9F\x30\xEC\x39", 128},
    {"\xF0\xBE\x9B\xBF", "\x9F\x30\xF9\x37", 128},
    {"\xF0\xBE\x9D\xBF", "\x9F\x31\x88\x35", 128},
    {"\xF0\xBE\x9F\xBF", "\x9F\x31\x95\x33", 128},
    {"\xF0\xBE\xA1\xBF", "\x9F\x31\xA2\x31", 128},
    {"\xF0\xBE\xA3\xBF", "\x9F\x31\xAE\x39", 128},
    {"\xF0\xBE\xA5\xBF", "\x9F\x31\xBB\x37", 128},
    {"\xF0\xBE\xA7\xBF", "\x9F\x31\xC8\x35", 128},
    {"\xF0\xBE\xA9\xBF", "\x9F\x31\xD5\x33", 128},
    {"\xF0\xBE\xAB\xBF", "\x9F\x31\xE2\x31", 128},
    {"\xF0\xBE\xAD\xBF", "\x9F\x31\xEE\x39", 128},
    {"\xF0\xBE\xAF\xBF", "\x9F\x31\xFB\x37", 128},
    {"\xF0\xBE\xB1\xBF", "\x9F\x32\x8A\x35", 128},
    {"\xF0\xBE\xB3\xBF", "\x9F\x32\x97\x33", 128},
    {"\xF0\xBE\xB5\xBF", "\x9F\x32\xA4\x31", 128},
    {"\xF0\xBE\xB7\xBF", "\x9F\x32\xB0\x39", 128},
    {"\xF0\xBE\xB9\xBF", "\x9F\x32\xBD\x37", 128},
    {"\xF0\xBE\xBB\xBF", "\x9F\x32\xCA\x35", 128},
    {"\xF0\xBE\xBD\xBF", "\x9F\x32\xD7\x33", 128},
    {"\xF0\xBE\xBF\xBF", "\x9F\x32\xE4\x31", 128},
    {"\xF0\xBF\x81\xBF", "\x9F\x32\xF0\x39", 128},
    {"\xF0\xBF\x83\xBF", "\x9F\x32\xFD\x37", 128},
    {"\xF0\xBF\x85\xBF", "\x9F\x33\x8C\x35", 128},
    {"\xF0\xBF\x87\xBF", "\x9F\x33\x99\x33", 128},
    {"\xF0\xBF\x89\xBF", "\x9F\x33\xA6\x31", 128},
    {"\xF0\xBF\x8B\xBF", "\x9F\x33\xB2\x39", 128},
    {"\xF0\xBF\x8D\xBF", "\x9F\x33\xBF\x37", 128},
    {"\xF0\xBF\x8F\xBF", "\x9F\x33\xCC\x35", 128},
    {"\xF0\xBF\x91\xBF", "\x9F\x33\xD9\x33", 128},
    {"\xF0\xBF\x93\xBF", "\x9F\x33\xE6\x31", 128},
    {"\xF0\xBF\x95\xBF", "\x9F\x33\xF2\x39", 128},
    {"\xF0\xBF\x97\xBF", "\x9F\x34\x81\x37", 128},
    {"\xF0\xBF\x99\xBF", "\x9F\x34\x8E\x35", 128},
    {"\xF0\xBF\x9B\xBF", "\x9F\x34\x9B\x33", 128},
    {"\xF0\xBF\x9D\xBF", "\x9F\x34\xA8\x31", 128},
    {"\xF0\xBF\x9F\xBF", "\x9F\x34\xB4\x39", 128},
    {"\xF0\xBF\xA1\xBF", "\x9F\x34\xC1\x37", 128},
    {"\xF0\xBF\xA3\xBF", "\x9F\x34\xCE\x35", 128},
    {"\xF0\xBF\xA5\xBF", "\x9F\x34\xDB\x33", 128},
    {"\xF0\xBF\xA7\xBF", "\x9F\x34\xE8\x31", 128},
    {"\xF0\xBF\xA9\xBF", "\x9F\x34\xF4\x39", 128},
    {"\xF0\xBF\xAB\xBF", "\x9F\x35\x83\x37", 128},
    {"\xF0\xBF\xAD\xBF", "\x9F\x35\x90\x35", 128},
    {"\xF0\xBF\xAF\xBF", "\x9F\x35\x9D\x33", 128},
    {"\xF0\xBF\xB1\xBF", "\x9F\x35\xAA\x31", 128},
    {"\xF0\xBF\xB3\xBF", "\x9F\x35\xB6\x39", 128},
    {"\xF0\xBF\xB5\xBF", "\x9F\x35\xC3\x37", 128},
    {"\xF0\xBF\xB7\xBF", "\x9F\x35\xD0\x35", 128},
    {"\xF0\xBF\xB9\xBF", "\x9F\x35\xDD\x33", 128},
    {"\xF0\xBF\xBB\xBF", "\x9F\x35\xEA\x31", 128},
    {"\xF0\xBF\xBD\xBF", "\x9F\x35\xF6\x39", 128},
    {"\xF0\xBF\xBF\xBF", "\x9F\x36\x85\x37", 1},
    {"\xF1\x80\x80\x80", "\x9F\x36\x85\x38", 128},
    {"\xF1\x80\x82\x80", "\x9F\x36\x92\x36", 128},
    {"\xF1\x80\x84\x80", "\x9F\x36\x9F\x34", 128},
    {"\xF1\x80\x86\x80", "\x9F\x36\xAC\x32", 128},
    {"\xF1\x80\x88\x80", "\x9F\x36\xB9\x30", 128},
    {"\xF1\x80\x8A\x80", "\x9F\x36\xC5\x38", 128},
    {"\xF1\x80\x8C\x80", "\x9F\x36\xD2\x36", 128},
    {"\xF1\x80\x8E\x80", "\x9F\x36\xDF\x34", 128},
    {"\xF1\x80\x90\x80", "\x9F\x36\xEC\x32", 128},
    {"\xF1\x80\x92\x80", "\x9F\x36\xF9\x30", 128},
    {"\xF1\x80\x94\x80", "\x9F\x37\x87\x38", 128},
    {"\xF1\x80\x96\x80", "\x9F\x37\x94\x36", 128},
    {"\xF1\x80\x98\x80", "\x9F\x37\xA1\x34", 128},
    {"\xF1\x80\x9A\x80", "\x9F\x37\xAE\x32", 128},
    {"\xF1\x80\x9C\x80", "\x9F\x37\xBB\x30", 128},
    {"\xF1\x80\x9E\x80", "\x9F\x37\xC7\x38", 128},
    {"\xF1\x80\xA0\x80", "\x9F\x37\xD4\x36", 128},
    {"\xF1\x80\xA2\x80", "\x9F\x37\xE1\x34", 128},
    {"\xF1\x80\xA4\x80", "\x9F\x37\xEE\x32", 128},
    {"\xF1\x80\xA6\x80", "\x9F\x37\xFB\x30", 128},
    {"\xF1\x80\xA8\x80", "\x9F\x38\x89\x38", 128},
    {"\xF1\x80\xAA\x80", "\x9F\x38\x96\x36", 128},
    {"\xF1\x80\xAC\x80", "\x9F\x38\xA3\x34", 128},
    {"\xF1\x80\xAE\x80", "\x9F\x38\xB0\x32", 128},
    {"\xF1\x80\xB0\x80", "\x9F\x38\xBD\x30", 128},
    {"\xF1\x80\xB2\x80", "\x9F\x38\xC9\x38", 128},
    {"\xF1\x80\xB4\x80", "\x9F\x38\xD6\x36", 128},
    {"\xF1\x80\xB6\x80", "\x9F\x38\xE3\x34", 128},
    {"\xF1\x80\xB8\x80", "\x9F\x38\xF0\x32", 128},
    {"\xF1\x80\xBA\x80", "\x9F\x38\xFD\x30", 128},
    {"\xF1\x80\xBC\x80", "\x9F\x39\x8B\x38", 128},
    {"\xF1\x80\xBE\x80", "\x9F\x39\x98\x36", 128},
    {"\xF1\x81\x80\x80", "\x9F\x39\xA5\x34", 128},
    {"\xF1\x81\x82\x80", "\x9F\x39\xB2\x32", 128},
    {"\xF1\x81\x84\x80", "\x9F\x39\xBF\x30", 128},
    {"\xF1\x81\x86\x80", "\x9F\x39\xCB\x38", 128},
    {"\xF1\x81\x88\x80", "\x9F\x39\xD8\x36", 128},
    {"\xF1\x81\x8A\x80", "\x9F\x39\xE5\x34", 128},
    {"\xF1\x81\x8C\x80", "\x9F\x39\xF2\x32", 128},
    {"\xF1\x81\x8E\x80", "\xA0\x30\x81\x30", 128},
    {"\xF1\x81\x90\x80", "\xA0\x30\x8D\x38", 128},
    {"\xF1\x81\x92\x80", "\xA0\x30\x9A\x36", 128},
    {"\xF1\x81\x94\x80", "\xA0\x30\xA7\x34", 128},
    {"\xF1\x81\x96\x80", "\xA0\x30\xB4\x32", 128},
    {"\xF1\x81\x98\x80", "\xA0\x30\xC1\x30", 128},
    {"\xF1\x81\x9A\x80", "\xA0\x30\xCD\x38", 128},
    {"\xF1\x81\x9C\x80", "\xA0\x30\xDA\x36", 128},
    {"\xF1\x81\x9E\x80", "\xA0\x30\xE7\x34", 128},
    {"\xF1\x81\xA0\x80", "\xA0\x30\xF4\x32", 128},
    {"\xF1\x81\xA2\x80", "\xA0\x31\x83\x30", 128},
    {"\xF1\x81\xA4\x80", "\xA0\x31\x8F\x38", 128},
    {"\xF1\x81\xA6\x80", "\xA0\x31\x9C\x36", 128},
    {"\xF1\x81\xA8\x80", "\xA0\x31\xA9\x34", 128},
    {"\xF1\x81\xAA\x80", "\xA0\x31\xB6\x32", 128},
    {"\xF1\x81\xAC\x80", "\xA0\x31\xC3\x30", 128},
    {"\xF1\x81\xAE\x80", "\xA0\x31\xCF\x38", 128},
    {"\xF1\x81\xB0\x80", "\xA0\x31\xDC\x36", 128},
    {"\xF1\x81\xB2\x80", "\xA0\x31\xE9\x34", 128},
    {"\xF1\x81\xB4\x80", "\xA0\x31\xF6\x32", 128},
    {"\xF1\x81\xB6\x80", "\xA0\x32\x85\x30", 128},
    {"\xF1\x81\xB8\x80", "\xA0\x32\x91\x38", 128},
    {"\xF1\x81\xBA\x80", "\xA0\x32\x9E\x36", 128},
    {"\xF1\x81\xBC\x80", "\xA0\x32\xAB\x34", 128},
    {"\xF1\x81\xBE\x80", "\xA0\x32\xB8\x32", 128},
    {"\xF1\x82\x80\x80", "\xA0\x32\xC5\x30", 128},
    {"\xF1\x82\x82\x80", "\xA0\x32\xD1\x38", 128},
    {"\xF1\x82\x84\x80", "\xA0\x32\xDE\x36", 128},
    {"\xF1\x82\x86\x80", "\xA0\x32\xEB\x34", 128},
    {"\xF1\x82\x88\x80", "\xA0\x32\xF8\x32", 128},
    {"\xF1\x82\x8A\x80", "\xA0\x33\x87\x30", 128},
    {"\xF1\x82\x8C\x80", "\xA0\x33\x93\x38", 128},
    {"\xF1\x82\x8E\x80", "\xA0\x33\xA0\x36", 128},
    {"\xF1\x82\x90\x80", "\xA0\x33\xAD\x34", 128},
    {"\xF1\x82\x92\x80", "\xA0\x33\xBA\x32", 128},
    {"\xF1\x82\x94\x80", "\xA0\x33\xC7\x30", 128},
    {"\xF1\x82\x96\x80", "\xA0\x33\xD3\x38", 128},
    {"\xF1\x82\x98\x80", "\xA0\x33\xE0\x36", 128},
    {"\xF1\x82\x9A\x80", "\xA0\x33\xED\x34", 128},
    {"\xF1\x82\x9C\x80", "\xA0\x33\xFA\x32", 128},
    {"\xF1\x82\x9E\x80", "\xA0\x34\x89\x30", 128},
    {"\xF1\x82\xA0\x80", "\xA0\x34\x95\x38", 128},
    {"\xF1\x82\xA2\x80", "\xA0\x34\xA2\x36", 128},
    {"\xF1\x82\xA4\x80", "\xA0\x34\xAF\x34", 128},
    {"\xF1\x82\xA6\x80", "\xA0\x34\xBC\x32", 128},
    {"\xF1\x82\xA8\x80", "\xA0\x34\xC9\x30", 128},
    {"\xF1\x82\xAA\x80", "\xA0\x34\xD5\x38", 128},
    {"\xF1\x82\xAC\x80", "\xA0\x34\xE2\x36", 128},
    {"\xF1\x82\xAE\x80", "\xA0\x34\xEF\x34", 128},
    {"\xF1\x82\xB0\x80", "\xA0\x34\xFC\x32", 128},
    {"\xF1\x82\xB2\x80", "\xA0\x35\x8B\x30", 128},
    {"\xF1\x82\xB4\x80", "\xA0\x35\x97\x38", 128},
    {"\xF1\x82\xB6\x80", "\xA0\x35\xA4\x36", 128},
    {"\xF1\x82\xB8\x80", "\xA0\x35\xB1\x34", 128},
    {"\xF1\x82\xBA\x80", "\xA0\x35\xBE\x32", 128},
    {"\xF1\x82\xBC\x80", "\xA0\x35\xCB\x30", 128},
    {"\xF1\x82\xBE\x80", "\xA0\x35\xD7\x38", 128},
    {"\xF1\x83\x80\x80", "\xA0\x35\xE4\x36", 128},
    {"\xF1\x83\x82\x80", "\xA0\x35\xF1\x34", 128},
    {"\xF1\x83\x84\x80", "\xA0\x35\xFE\x32", 128},
    {"\xF1\x83\x86\x80", "\xA0\x36\x8D\x30", 128},
    {"\xF1\x83\x88\x80", "\xA0\x36\x99\x38", 128},
    {"\xF1\x83\x8A\x80", "\xA0\x36\xA6\x36", 128},
    {"\xF1\x83\x8C\x80", "\xA0\x36\xB3\x34", 128},
    {"\xF1\x83\x8E\x80", "\xA0\x36\xC0\x32", 128},
    {"\xF1\x83\x90\x80", "\xA0\x36\xCD\x30", 128},
    {"\xF1\x83\x92\x80", "\xA0\x36\xD9\x38", 128},
    {"\xF1\x83\x94\x80", "\xA0\x36\xE6\x36", 128},
    {"\xF1\x83\x96\x80", "\xA0\x36\xF3\x34", 128},
    {"\xF1\x83\x98\x80", "\xA0\x37\x82\x32", 128},
    {"\xF1\x83\x9A\x80", "\xA0\x37\x8F\x30", 128},
    {"\xF1\x83\x9C\x80", "\xA0\x37\x9B\x38", 128},
    {"\xF1\x83\x9E\x80", "\xA0\x37\xA8\x36", 128},
    {"\xF1\x83\xA0\x80", "\xA0\x37\xB5\x34", 128},
    {"\xF1\x83\xA2\x80", "\xA0\x37\xC2\x32", 128},
    {"\xF1\x83\xA4\x80", "\xA0\x37\xCF\x30", 128},
    {"\xF1\x83\xA6\x80", "\xA0\x37\xDB\x38", 128},
    {"\xF1\x83\xA8\x80", "\xA0\x37\xE8\x36", 128},
    {"\xF1\x83\xAA\x80", "\xA0\x37\xF5\x34", 128},
    {"\xF1\x83\xAC\x80", "\xA0\x38\x84\x32", 128},
    {"\xF1\x83\xAE\x80", "\xA0\x38\x91\x30", 128},
    {"\xF1\x83\xB0\x80", "\xA0\x38\x9D\x38", 128},
    {"\xF1\x83\xB2\x80", "\xA0\x38\xAA\x36", 128},
    {"\xF1\x83\xB4\x80", "\xA0\x38\xB7\x34", 128},
    {"\xF1\x83\xB6\x80", "\xA0\x38\xC4\x32", 128},
    {"\xF1\x83\xB8\x80", "\xA0\x38\xD1\x30", 128},
    {"\xF1\x83\xBA\x80", "\xA0\x38\xDD\x38", 128},
    {"\xF1\x83\xBC\x80", "\xA0\x38\xEA\x36", 128},
    {"\xF1\x83\xBE\x80", "\xA0\x38\xF7\x34", 128},
    {"\xF1\x84\x80\x80", "\xA0\x39\x86\x32", 128},
    {"\xF1\x84\x82\x80", "\xA0\x39\x93\x30", 128},
    {"\xF1\x84\x84\x80", "\xA0\x39\x9F\x38", 128},
    {"\xF1\x84\x86\x80", "\xA0\x39\xAC\x36", 128},
    {"\xF1\x84\x88\x80", "\xA0\x39\xB9\x34", 128},
    {"\xF1\x84\x8A\x80", "\xA0\x39\xC6\x32", 128},
    {"\xF1\x84\x8C\x80", "\xA0\x39\xD3\x30", 128},
    {"\xF1\x84\x8E\x80", "\xA0\x39\xDF\x38", 128},
    {"\xF1\x84\x90\x80", "\xA0\x39\xEC\x36", 128},
    {"\xF1\x84\x92\x80", "\xA0\x39\xF9\x34", 128},
    {"\xF1\x84\x94\x80", "\xA1\x30\x88\x32", 128},
    {"\xF1\x84\x96\x80", "\xA1\x30\x95\x30", 128},
    {"\xF1\x84\x98\x80", "\xA1\x30\xA1\x38", 128},
    {"\xF1\x84\x9A\x80", "\xA1\x30\xAE\x36", 128},
    {"\xF1\x84\x9C\x80", "\xA1\x30\xBB\x34", 128},
    {"\xF1\x84\x9E\x80", "\xA1\x30\xC8\x32", 128},
    {"\xF1\x84\xA0\x80", "\xA1\x30\xD5\x30", 128},
    {"\xF1\x84\xA2\x80", "\xA1\x30\xE1\x38", 128},
    {"\xF1\x84\xA4\x80", "\xA1\x30\xEE\x36", 128},
    {"\xF1\x84\xA6\x80", "\xA1\x30\xFB\x34", 128},
    {"\xF1\x84\xA8\x80", "\xA1\x31\x8A\x32", 128},
    {"\xF1\x84\xAA\x80", "\xA1\x31\x97\x30", 128},
    {"\xF1\x84\xAC\x80", "\xA1\x31\xA3\x38", 128},
    {"\xF1\x84\xAE\x80", "\xA1\x31\xB0\x36", 128},
    {"\xF1\x84\xB0\x80", "\xA1\x31\xBD\x34", 128},
    {"\xF1\x84\xB2\x80", "\xA1\x31\xCA\x32", 128},
    {"\xF1\x84\xB4\x80", "\xA1\x31\xD7\x30", 128},
    {"\xF1\x84\xB6\x80", "\xA1\x31\xE3\x38", 128},
    {"\xF1\x84\xB8\x80", "\xA1\x31\xF0\x36", 128},
    {"\xF1\x84\xBA\x80", "\xA1\x31\xFD\x34", 128},
    {"\xF1\x84\xBC\x80", "\xA1\x32\x8C\x32", 128},
    {"\xF1\x84\xBE\x80", "\xA1\x32\x99\x30", 128},
    {"\xF1\x85\x80\x80", "\xA1\x32\xA5\x38", 128},
    {"\xF1\x85\x82\x80", "\xA1\x32\xB2\x36", 128},
    {"\xF1\x85\x84\x80", "\xA1\x32\xBF\x34", 128},
    {"\xF1\x85\x86\x80", "\xA1\x32\xCC\x32", 128},
    {"\xF1\x85\x88\x80", "\xA1\x32\xD9\x30", 128},
    {"\xF1\x85\x8A\x80", "\xA1\x32\xE5\x38", 128},
    {"\xF1\x85\x8C\x80", "\xA1\x32\xF2\x36", 128},
    {"\xF1\x85\x8E\x80", "\xA1\x33\x81\x34", 128},
    {"\xF1\x85\x90\x80", "\xA1\x33\x8E\x32", 128},
    {"\xF1\x85\x92\x80", "\xA1\x33\x9B\x30", 128},
    {"\xF1\x85\x94\x80", "\xA1\x33\xA7\x38", 128},
    {"\xF1\x85\x96\x80", "\xA1\x33\xB4\x36", 128},
    {"\xF1\x85\x98\x80", "\xA1\x33\xC1\x34", 128},
    {"\xF1\x85\x9A\x80", "\xA1\x33\xCE\x32", 128},
    {"\xF1\x85\x9C\x80", "\xA1\x33\xDB\x30", 128},
    {"\xF1\x85\x9E\x80", "\xA1\x33\xE7\x38", 128},
    {"\xF1\x85\xA0\x80", "\xA1\x33\xF4\x36", 128},
    {"\xF1\x85\xA2\x80", "\xA1\x34\x83\x34", 128},
    {"\xF1\x85\xA4\x80", "\xA1\x34\x90\x32", 128},
    {"\xF1\x85\xA6\x80", "\xA1\x34\x9D\x30", 128},
    {"\xF1\x85\xA8\x80", "\xA1\x34\xA9\x38", 128},
    {"\xF1\x85\xAA\x80", "\xA1\x34\xB6\x36", 128},
    {"\xF1\x85\xAC\x80", "\xA1\x34\xC3\x34", 128},
    {"\xF1\x85\xAE\x80", "\xA1\x34\xD0\x32", 128},
    {"\xF1\x85\xB0\x80", "\xA1\x34\xDD\x30", 128},
    {"\xF1\x85\xB2\x80", "\xA1\x34\xE9\x38", 128},
    {"\xF1\x85\xB4\x80", "\xA1\x34\xF6\x36", 128},
    {"\xF1\x85\xB6\x80", "\xA1\x35\x85\x34", 128},
    {"\xF1\x85\xB8\x80", "\xA1\x35\x92\x32", 128},
    {"\xF1\x85\xBA\x80", "\xA1\x35\x9F\x30", 128},
    {"\xF1\x85\xBC\x80", "\xA1\x35\xAB\x38", 128},
    {"\xF1\x85\xBE\x80", "\xA1\x35\xB8\x36", 128},
    {"\xF1\x86\x80\x80", "\xA1\x35\xC5\x34", 128},
    {"\xF1\x86\x82\x80", "\xA1\x35\xD2\x32", 128},
    {"\xF1\x86\x84\x80", "\xA1\x35\xDF\x30", 128},
    {"\xF1\x86\x86\x80", "\xA1\x35\xEB\x38", 128},
    {"\xF1\x86\x88\x80", "\xA1\x35\xF8\x36", 128},
    {"\xF1\x86\x8A\x80", "\xA1\x36\x87\x34", 128},
    {"\xF1\x86\x8C\x80", "\xA1\x36\x94\x32", 128},
    {"\xF1\x86\x8E\x80", "\xA1\x36\xA1\x30", 128},
    {"\xF1\x86\x90\x80", "\xA1\x36\xAD\x38", 128},
    {"\xF1\x86\x92\x80", "\xA1\x36\xBA\x36", 128},
    {"\xF1\x86\x94\x80", "\xA1\x36\xC7\x34", 128},
    {"\xF1\x86\x96\x80", "\xA1\x36\xD4\x32", 128},
    {"\xF1\x86\x98\x80", "\xA1\x36\xE1\x30", 128},
    {"\xF1\x86\x9A\x80", "\xA1\x36\xED\x38", 128},
    {"\xF1\x86\x9C\x80", "\xA1\x36\xFA\x36", 128},
    {"\xF1\x86\x9E\x80", "\xA1\x37\x89\x34", 128},
    {"\xF1\x86\xA0\x80", "\xA1\x37\x96\x32", 128},
    {"\xF1\x86\xA2\x80", "\xA1\x37\xA3\x30", 128},
    {"\xF1\x86\xA4\x80", "\xA1\x37\xAF\x38", 128},
    {"\xF1\x86\xA6\x80", "\xA1\x37\xBC\x36", 128},
    {"\xF1\x86\xA8\x80", "\xA1\x37\xC9\x34", 128},
    {"\xF1\x86\xAA\x80", "\xA1\x37\xD6\x32", 128},
    {"\xF1\x86\xAC\x80", "\xA1\x37\xE3\x30", 128},
    {"\xF1\x86\xAE\x80", "\xA1\x37\xEF\x38", 128},
    {"\xF1\x86\xB0\x80", "\xA1\x37\xFC\x36", 128},
    {"\xF1\x86\xB2\x80", "\xA1\x38\x8B\x34", 128},
    {"\xF1\x86\xB4\x80", "\xA1\x38\x98\x32", 128},
    {"\xF1\x86\xB6\x80", "\xA1\x38\xA5\x30", 128},
    {"\xF1\x86\xB8\x80", "\xA1\x38\xB1\x38", 128},
    {"\xF1\x86\xBA\x80", "\xA1\x38\xBE\x36", 128},
    {"\xF1\x86\xBC\x80", "\xA1\x38\xCB\x34", 128},
    {"\xF1\x86\xBE\x80", "\xA1\x38\xD8\x32", 128},
    {"\xF1\x87\x80\x80", "\xA1\x38\xE5\x30", 128},
    {"\xF1\x87\x82\x80", "\xA1\x38\xF1\x38", 128},
    {"\xF1\x87\x84\x80", "\xA1\x38\xFE\x36", 128},
    {"\xF1\x87\x86\x80", "\xA1\x39\x8D\x34", 128},
    {"\xF1\x87\x88\x80", "\xA1\x39\x9A\x32", 128},
    {"\xF1\x87\x8A\x80", "\xA1\x39\xA7\x30", 128},
    {"\xF1\x87\x8C\x80", "\xA1\x39\xB3\x38", 128},
    {"\xF1\x87\x8E\x80", "\xA1\x39\xC0\x36", 128},
    {"\xF1\x87\x90\x80", "\xA1\x39\xCD\x34", 128},
    {"\xF1\x87\x92\x80", "\xA1\x39\xDA\x32", 128},
    {"\xF1\x87\x94\x80", "\xA1\x39\xE7\x30", 128},
    {"\xF1\x87\x96\x80", "\xA1\x39\xF3\x38", 128},
    {"\xF1\x87\x98\x80", "\xA2\x30\x82\x36", 128},
    {"\xF1\x87\x9A\x80", "\xA2\x30\x8F\x34", 128},
    {"\xF1\x87\x9C\x80", "\xA2\x30\x9C\x32", 128},
    {"\xF1\x87\x9E\x80", "\xA2\x30\xA9\x30", 128},
    {"\xF1\x87\xA0\x80", "\xA2\x30\xB5\x38", 128},
    {"\xF1\x87\xA2\x80", "\xA2\x30\xC2\x36", 128},
    {"\xF1\x87\xA4\x80", "\xA2\x30\xCF\x34", 128},
    {"\xF1\x87\xA6\x80", "\xA2\x30\xDC\x32", 128},
    {"\xF1\x87\xA8\x80", "\xA2\x30\xE9\x30", 128},
    {"\xF1\x87\xAA\x80", "\xA2\x30\xF5\x38", 128},
    {"\xF1\x87\xAC\x80", "\xA2\x31\x84\x36", 128},
    {"\xF1\x87\xAE\x80", "\xA2\x31\x91\x34", 128},
    {"\xF1\x87\xB0\x80", "\xA2\x31\x9E\x32", 128},
    {"\xF1\x87\xB2\x80", "\xA2\x31\xAB\x30", 128},
    {"\xF1\x87\xB4\x80", "\xA2\x31\xB7\x38", 128},
    {"\xF1\x87\xB6\x80", "\xA2\x31\xC4\x36", 128},
    {"\xF1\x87\xB8\x80", "\xA2\x31\xD1\x34", 128},
    {"\xF1\x87\xBA\x80", "\xA2\x31\xDE\x32", 128},
    {"\xF1\x87\xBC\x80", "\xA2\x31\xEB\x30", 128},
    {"\xF1\x87\xBE\x80", "\xA2\x31\xF7\x38", 128},
    {"\xF1\x88\x80\x80", "\xA2\x32\x86\x36", 128},
    {"\xF1\x88\x82\x80", "\xA2\x32\x93\x34", 128},
    {"\xF1\x88\x84\x80", "\xA2\x32\xA0\x32", 128},
    {"\xF1\x88\x86\x80", "\xA2\x32\xAD\x30", 128},
    {"\xF1\x88\x88\x80", "\xA2\x32\xB9\x38", 128},
    {"\xF1\x88\x8A\x80", "\xA2\x32\xC6\x36", 128},
    {"\xF1\x88\x8C\x80", "\xA2\x32\xD3\x34", 128},
    {"\xF1\x88\x8E\x80", "\xA2\x32\xE0\x32", 128},
    {"\xF1\x88\x90\x80", "\xA2\x32\xED\x30", 128},
    {"\xF1\x88\x92\x80", "\xA2\x32\xF9\x38", 128},
    {"\xF1\x88\x94\x80", "\xA2\x33\x88\x36", 128},
    {"\xF1\x88\x96\x80", "\xA2\x33\x95\x34", 128},
    {"\xF1\x88\x98\x80", "\xA2\x33\xA2\x32", 128},
    {"\xF1\x88\x9A\x80", "\xA2\x33\xAF\x30", 128},
    {"\xF1\x88\x9C\x80", "\xA2\x33\xBB\x38", 128},
    {"\xF1\x88\x9E\x80", "\xA2\x33\xC8\x36", 128},
    {"\xF1\x88\xA0\x80", "\xA2\x33\xD5\x34", 128},
    {"\xF1\x88\xA2\x80", "\xA2\x33\xE2\x32", 128},
    {"\xF1\x88\xA4\x80", "\xA2\x33\xEF\x30", 128},
    {"\xF1\x88\xA6\x80", "\xA2\x33\xFB\x38", 128},
    {"\xF1\x88\xA8\x80", "\xA2\x34\x8A\x36", 128},
    {"\xF1\x88\xAA\x80", "\xA2\x34\x97\x34", 128},
    {"\xF1\x88\xAC\x80", "\xA2\x34\xA4\x32", 128},
    {"\xF1\x88\xAE\x80", "\xA2\x34\xB1\x30", 128},
    {"\xF1\x88\xB0\x80", "\xA2\x34\xBD\x38", 128},
    {"\xF1\x88\xB2\x80", "\xA2\x34\xCA\x36", 128},
    {"\xF1\x88\xB4\x80", "\xA2\x34\xD7\x34", 128},
    {"\xF1\x88\xB6\x80", "\xA2\x34\xE4\x32", 128},
    {"\xF1\x88\xB8\x80", "\xA2\x34\xF1\x30", 128},
    {"\xF1\x88\xBA\x80", "\xA2\x34\xFD\x38", 128},
    {"\xF1\x88\xBC\x80", "\xA2\x35\x8C\x36", 128},
    {"\xF1\x88\xBE\x80", "\xA2\x35\x99\x34", 128},
    {"\xF1\x89\x80\x80", "\xA2\x35\xA6\x32", 128},
    {"\xF1\x89\x82\x80", "\xA2\x35\xB3\x30", 128},
    {"\xF1\x89\x84\x80", "\xA2\x35\xBF\x38", 128},
    {"\xF1\x89\x86\x80", "\xA2\x35\xCC\x36", 128},
    {"\xF1\x89\x88\x80", "\xA2\x35\xD9\x34", 128},
    {"\xF1\x89\x8A\x80", "\xA2\x35\xE6\x32", 128},
    {"\xF1\x89\x8C\x80", "\xA2\x35\xF3\x30", 128},
    {"\xF1\x89\x8E\x80", "\xA2\x36\x81\x38", 128},
    {"\xF1\x89\x90\x80", "\xA2\x36\x8E\x36", 128},
    {"\xF1\x89\x92\x80", "\xA2\x36\x9B\x34", 128},
    {"\xF1\x89\x94\x80", "\xA2\x36\xA8\x32", 128},
    {"\xF1\x89\x96\x80", "\xA2\x36\xB5\x30", 128},
    {"\xF1\x89\x98\x80", "\xA2\x36\xC1\x38", 128},
    {"\xF1\x89\x9A\x80", "\xA2\x36\xCE\x36", 128},
    {"\xF1\x89\x9C\x80", "\xA2\x36\xDB\x34", 128},
    {"\xF1\x89\x9E\x80", "\xA2\x36\xE8\x32", 128},
    {"\xF1\x89\xA0\x80", "\xA2\x36\xF5\x30", 128},
    {"\xF1\x89\xA2\x80", "\xA2\x37\x83\x38", 128},
    {"\xF1\x89\xA4\x80", "\xA2\x37\x90\x36", 128},
    {"\xF1\x89\xA6\x80", "\xA2\x37\x9D\x34", 128},
    {"\xF1\x89\xA8\x80", "\xA2\x37\xAA\x32", 128},
    {"\xF1\x89\xAA\x80", "\xA2\x37\xB7\x30", 128},
    {"\xF1\x89\xAC\x80", "\xA2\x37\xC3\x38", 128},
    {"\xF1\x89\xAE\x80", "\xA2\x37\xD0\x36", 128},
    {"\xF1\x89\xB0\x80", "\xA2\x37\xDD\x34", 128},
    {"\xF1\x89\xB2\x80", "\xA2\x37\xEA\x32", 128},
    {"\xF1\x89\xB4\x80", "\xA2\x37\xF7\x30", 128},
    {"\xF1\x89\xB6\x80", "\xA2\x38\x85\x38", 128},
    {"\xF1\x89\xB8\x80", "\xA2\x38\x92\x36", 128},
    {"\xF1\x89\xBA\x80", "\xA2\x38\x9F\x34", 128},
    {"\xF1\x89\xBC\x80", "\xA2\x38\xAC\x32", 128},
    {"\xF1\x89\xBE\x80", "\xA2\x38\xB9\x30", 128},
    {"\xF1\x8A\x80\x80", "\xA2\x38\xC5\x38", 128},
    {"\xF1\x8A\x82\x80", "\xA2\x38\xD2\x36", 128},
    {"\xF1\x8A\x84\x80", "\xA2\x38\xDF\x34", 128},
    {"\xF1\x8A\x86\x80", "\xA2\x38\xEC\x32", 128},
    {"\xF1\x8A\x88\x80", "\xA2\x38\xF9\x30", 128},
    {"\xF1\x8A\x8A\x80", "\xA2\x39\x87\x38", 128},
    {"\xF1\x8A\x8C\x80", "\xA2\x39\x94\x36", 128},
    {"\xF1\x8A\x8E\x80", "\xA2\x39\xA1\x34", 128},
    {"\xF1\x8A\x90\x80", "\xA2\x39\xAE\x32", 128},
    {"\xF1\x8A\x92\x80", "\xA2\x39\xBB\x30", 128},
    {"\xF1\x8A\x94\x80", "\xA2\x39\xC7\x38", 128},
    {"\xF1\x8A\x96\x80", "\xA2\x39\xD4\x36", 128},
    {"\xF1\x8A\x98\x80", "\xA2\x39\xE1\x34", 128},
    {"\xF1\x8A\x9A\x80", "\xA2\x39\xEE\x32", 128},
    {"\xF1\x8A\x9C\x80", "\xA2\x39\xFB\x30", 128},
    {"\xF1\x8A\x9E\x80", "\xA3\x30\x89\x38", 128},
    {"\xF1\x8A\xA0\x80", "\xA3\x30\x96\x36", 128},
    {"\xF1\x8A\xA2\x80", "\xA3\x30\xA3\x34", 128},
    {"\xF1\x8A\xA4\x80", "\xA3\x30\xB0\x32", 128},
    {"\xF1\x8A\xA6\x80", "\xA3\x30\xBD\x30", 128},
    {"\xF1\x8A\xA8\x80", "\xA3\x30\xC9\x38", 128},
    {"\xF1\x8A\xAA\x80", "\xA3\x30\xD6\x36", 128},
    {"\xF1\x8A\xAC\x80", "\xA3\x30\xE3\x34", 128},
    {"\xF1\x8A\xAE\x80", "\xA3\x30\xF0\x32", 128},
    {"\xF1\x8A\xB0\x80", "\xA3\x30\xFD\x30", 128},
    {"\xF1\x8A\xB2\x80", "\xA3\x31\x8B\x38", 128},
    {"\xF1\x8A\xB4\x80", "\xA3\x31\x98\x36", 128},
    {"\xF1\x8A\xB6\x80", "\xA3\x31\xA5\x34", 128},
    {"\xF1\x8A\xB8\x80", "\xA3\x31\xB2\x32", 128},
    {"\xF1\x8A\xBA\x80", "\xA3\x31\xBF\x30", 128},
    {"\xF1\x8A\xBC\x80", "\xA3\x31\xCB\x38", 128},
    {"\xF1\x8A\xBE\x80", "\xA3\x31\xD8\x36", 128},
    {"\xF1\x8B\x80\x80", "\xA3\x31\xE5\x34", 128},
    {"\xF1\x8B\x82\x80", "\xA3\x31\xF2\x32", 128},
    {"\xF1\x8B\x84\x80", "\xA3\x32\x81\x30", 128},
    {"\xF1\x8B\x86\x80", "\xA3\x32\x8D\x38", 128},
    {"\xF1\x8B\x88\x80", "\xA3\x32\x9A\x36", 128},
    {"\xF1\x8B\x8A\x80", "\xA3\x32\xA7\x34", 128},
    {"\xF1\x8B\x8C\x80", "\xA3\x32\xB4\x32", 128},
    {"\xF1\x8B\x8E\x80", "\xA3\x32\xC1\x30", 128},
    {"\xF1\x8B\x90\x80", "\xA3\x32\xCD\x38", 128},
    {"\xF1\x8B\x92\x80", "\xA3\x32\xDA\x36", 128},
    {"\xF1\x8B\x94\x80", "\xA3\x32\xE7\x34", 128},
    {"\xF1\x8B\x96\x80", "\xA3\x32\xF4\x32", 128},
    {"\xF1\x8B\x98\x80", "\xA3\x33\x83\x30", 128},
    {"\xF1\x8B\x9A\x80", "\xA3\x33\x8F\x38", 128},
    {"\xF1\x8B\x9C\x80", "\xA3\x33\x9C\x36", 128},
    {"\xF1\x8B\x9E\x80", "\xA3\x33\xA9\x34", 128},
    {"\xF1\x8B\xA0\x80", "\xA3\x33\xB6\x32", 128},
    {"\xF1\x8B\xA2\x80", "\xA3\x33\xC3\x30", 128},
    {"\xF1\x8B\xA4\x80", "\xA3\x33\xCF\x38", 128},
    {"\xF1\x8B\xA6\x80", "\xA3\x33\xDC\x36", 128},
    {"\xF1\x8B\xA8\x80", "\xA3\x33\xE9\x34", 128},
    {"\xF1\x8B\xAA\x80", "\xA3\x33\xF6\x32", 128},
    {"\xF1\x8B\xAC\x80", "\xA3\x34\x85\x30", 128},
    {"\xF1\x8B\xAE\x80", "\xA3\x34\x91\x38", 128},
    {"\xF1\x8B\xB0\x80", "\xA3\x34\x9E\x36", 128},
    {"\xF1\x8B\xB2\x80", "\xA3\x34\xAB\x34", 128},
    {"\xF1\x8B\xB4\x80", "\xA3\x34\xB8\x32", 128},
    {"\xF1\x8B\xB6\x80", "\xA3\x34\xC5\x30", 128},
    {"\xF1\x8B\xB8\x80", "\xA3\x34\xD1\x38", 128},
    {"\xF1\x8B\xBA\x80", "\xA3\x34\xDE\x36", 128},
    {"\xF1\x8B\xBC\x80", "\xA3\x34\xEB\x34", 128},
    {"\xF1\x8B\xBE\x80", "\xA3\x34\xF8\x32", 128},
    {"\xF1\x8C\x80\x80", "\xA3\x35\x87\x30", 128},
    {"\xF1\x8C\x82\x80", "\xA3\x35\x93\x38", 128},
    {"\xF1\x8C\x84\x80", "\xA3\x35\xA0\x36", 128},
    {"\xF1\x8C\x86\x80", "\xA3\x35\xAD\x34", 128},
    {"\xF1\x8C\x88\x80", "\xA3\x35\xBA\x32", 128},
    {"\xF1\x8C\x8A\x80", "\xA3\x35\xC7\x30", 128},
    {"\xF1\x8C\x8C\x80", "\xA3\x35\xD3\x38", 128},
    {"\xF1\x8C\x8E\x80", "\xA3\x35\xE0\x36", 128},
    {"\xF1\x8C\x90\x80", "\xA3\x35\xED\x34", 128},
    {"\xF1\x8C\x92\x80", "\xA3\x35\xFA\x32", 128},
    {"\xF1\x8C\x94\x80", "\xA3\x36\x89\x30", 128},
    {"\xF1\x8C\x96\x80", "\xA3\x36\x95\x38", 128},
    {"\xF1\x8C\x98\x80", "\xA3\x36\xA2\x36", 128},
    {"\xF1\x8C\x9A\x80", "\xA3\x36\xAF\x34", 128},
    {"\xF1\x8C\x9C\x80", "\xA3\x36\xBC\x32", 128},
    {"\xF1\x8C\x9E\x80", "\xA3\x36\xC9\x30", 128},
    {"\xF1\x8C\xA0\x80", "\xA3\x36\xD5\x38", 128},
    {"\xF1\x8C\xA2\x80", "\xA3\x36\xE2\x36", 128},
    {"\xF1\x8C\xA4\x80", "\xA3\x36\xEF\x34", 128},
    {"\xF1\x8C\xA6\x80", "\xA3\x36\xFC\x32", 128},
    {"\xF1\x8C\xA8\x80", "\xA3\x37\x8B\x30", 128},
    {"\xF1\x8C\xAA\x80", "\xA3\x37\x97\x38", 128},
    {"\xF1\x8C\xAC\x80", "\xA3\x37\xA4\x36", 128},
    {"\xF1\x8C\xAE\x80", "\xA3\x37\xB1\x34", 128},
    {"\xF1\x8C\xB0\x80", "\xA3\x37\xBE\x32", 128},
    {"\xF1\x8C\xB2\x80", "\xA3\x37\xCB\x30", 128},
    {"\xF1\x8C\xB4\x80", "\xA3\x37\xD7\x38", 128},
    {"\xF1\x8C\xB6\x80", "\xA3\x37\xE4\x36", 128},
    {"\xF1\x8C\xB8\x80", "\xA3\x37\xF1\x34", 128},
    {"\xF1\x8C\xBA\x80", "\xA3\x37\xFE\x32", 128},
    {"\xF1\x8C\xBC\x80", "\xA3\x38\x8D\x30", 128},
    {"\xF1\x8C\xBE\x80", "\xA3\x38\x99\x38", 128},
    {"\xF1\x8D\x80\x80", "\xA3\x38\xA6\x36", 128},
    {"\xF1\x8D\x82\x80", "\xA3\x38\xB3\x34", 128},
    {"\xF1\x8D\x84\x80", "\xA3\x38\xC0\x32", 128},
    {"\xF1\x8D\x86\x80", "\xA3\x38\xCD\x30", 128},
    {"\xF1\x8D\x88\x80", "\xA3\x38\xD9\x38", 128},
    {"\xF1\x8D\x8A\x80", "\xA3\x38\xE6\x36", 128},
    {"\xF1\x8D\x8C\x80", "\xA3\x38\xF3\x34", 128},
    {"\xF1\x8D\x8E\x80", "\xA3\x39\x82\x32", 128},
    {"\xF1\x8D\x90\x80", "\xA3\x39\x8F\x30", 128},
    {"\xF1\x8D\x92\x80", "\xA3\x39\x9B\x38", 128},
    {"\xF1\x8D\x94\x80", "\xA3\x39\xA8\x36", 128},
    {"\xF1\x8D\x96\x80", "\xA3\x39\xB5\x34", 128},
    {"\xF1\x8D\x98\x80", "\xA3\x39\xC2\x32", 128},
    {"\xF1\x8D\x9A\x80", "\xA3\x39\xCF\x30", 128},
    {"\xF1\x8D\x9C\x80", "\xA3\x39\xDB\x38", 128},
    {"\xF1\x8D\x9E\x80", "\xA3\x39\xE8\x36", 128},
    {"\xF1\x8D\xA0\x80", "\xA3\x39\xF5\x34", 128},
    {"\xF1\x8D\xA2\x80", "\xA4\x30\x84\x32", 128},
    {"\xF1\x8D\xA4\x80", "\xA4\x30\x91\x30", 128},
    {"\xF1\x8D\xA6\x80", "\xA4\x30\x9D\x38", 128},
    {"\xF1\x8D\xA8\x80", "\xA4\x30\xAA\x36", 128},
    {"\xF1\x8D\xAA\x80", "\xA4\x30\xB7\x34", 128},
    {"\xF1\x8D\xAC\x80", "\xA4\x30\xC4\x32", 128},
    {"\xF1\x8D\xAE\x80", "\xA4\x30\xD1\x30", 128},
    {"\xF1\x8D\xB0\x80", "\xA4\x30\xDD\x38", 128},
    {"\xF1\x8D\xB2\x80", "\xA4\x30\xEA\x36", 128},
    {"\xF1\x8D\xB4\x80", "\xA4\x30\xF7\x34", 128},
    {"\xF1\x8D\xB6\x80", "\xA4\x31\x86\x32", 128},
    {"\xF1\x8D\xB8\x80", "\xA4\x31\x93\x30", 128},
    {"\xF1\x8D\xBA\x80", "\xA4\x31\x9F\x38", 128},
    {"\xF1\x8D\xBC\x80", "\xA4\x31\xAC\x36", 128},
    {"\xF1\x8D\xBE\x80", "\xA4\x31\xB9\x34", 128},
    {"\xF1\x8E\x80\x80", "\xA4\x31\xC6\x32", 128},
    {"\xF1\x8E\x82\x80", "\xA4\x31\xD3\x30", 128},
    {"\xF1\x8E\x84\x80", "\xA4\x31\xDF\x38", 128},
    {"\xF1\x8E\x86\x80", "\xA4\x31\xEC\x36", 128},
    {"\xF1\x8E\x88\x80", "\xA4\x31\xF9\x34", 128},
    {"\xF1\x8E\x8A\x80", "\xA4\x32\x88\x32", 128},
    {"\xF1\x8E\x8C\x80", "\xA4\x32\x95\x30", 128},
    {"\xF1\x8E\x8E\x80", "\xA4\x32\xA1\x38", 128},
    {"\xF1\x8E\x90\x80", "\xA4\x32\xAE\x36", 128},
    {"\xF1\x8E\x92\x80", "\xA4\x32\xBB\x34", 128},
    {"\xF1\x8E\x94\x80", "\xA4\x32\xC8\x32", 128},
    {"\xF1\x8E\x96\x80", "\xA4\x32\xD5\x30", 128},
    {"\xF1\x8E\x98\x80", "\xA4\x32\xE1\x38", 128},
    {"\xF1\x8E\x9A\x80", "\xA4\x32\xEE\x36", 128},
    {"\xF1\x8E\x9C\x80", "\xA4\x32\xFB\x34", 128},
    {"\xF1\x8E\x9E\x80", "\xA4\x33\x8A\x32", 128},
    {"\xF1\x8E\xA0\x80", "\xA4\x33\x97\x30", 128},
    {"\xF1\x8E\xA2\x80", "\xA4\x33\xA3\x38", 128},
    {"\xF1\x8E\xA4\x80", "\xA4\x33\xB0\x36", 128},
    {"\xF1\x8E\xA6\x80", "\xA4\x33\xBD\x34", 128},
    {"\xF1\x8E\xA8\x80", "\xA4\x33\xCA\x32", 128},
    {"\xF1\x8E\xAA\x80", "\xA4\x33\xD7\x30", 128},
    {"\xF1\x8E\xAC\x80", "\xA4\x33\xE3\x38", 128},
    {"\xF1\x8E\xAE\x80", "\xA4\x33\xF0\x36", 128},
    {"\xF1\x8E\xB0\x80", "\xA4\x33\xFD\x34", 128},
    {"\xF1\x8E\xB2\x80", "\xA4\x34\x8C\x32", 128},
    {"\xF1\x8E\xB4\x80", "\xA4\x34\x99\x30", 128},
    {"\xF1\x8E\xB6\x80", "\xA4\x34\xA5\x38", 128},
    {"\xF1\x8E\xB8\x80", "\xA4\x34\xB2\x36", 128},
    {"\xF1\x8E\xBA\x80", "\xA4\x34\xBF\x34", 128},
    {"\xF1\x8E\xBC\x80", "\xA4\x34\xCC\x32", 128},
    {"\xF1\x8E\xBE\x80", "\xA4\x34\xD9\x30", 128},
    {"\xF1\x8F\x80\x80", "\xA4\x34\xE5\x38", 128},
    {"\xF1\x8F\x82\x80", "\xA4\x34\xF2\x36", 128},
    {"\xF1\x8F\x84\x80", "\xA4\x35\x81\x34", 128},
    {"\xF1\x8F\x86\x80", "\xA4\x35\x8E\x32", 128},
    {"\xF1\x8F\x88\x80", "\xA4\x35\x9B\x30", 128},
    {"\xF1\x8F\x8A\x80", "\xA4\x35\xA7\x38", 128},
    {"\xF1\x8F\x8C\x80", "\xA4\x35\xB4\x36", 128},
    {"\xF1\x8F\x8E\x80", "\xA4\x35\xC1\x34", 128},
    {"\xF1\x8F\x90\x80", "\xA4\x35\xCE\x32", 128},
    {"\xF1\x8F\x92\x80", "\xA4\x35\xDB\x30", 128},
    {"\xF1\x8F\x94\x80", "\xA4\x35\xE7\x38", 128},
    {"\xF1\x8F\x96\x80", "\xA4\x35\xF4\x36", 128},
    {"\xF1\x8F\x98\x80", "\xA4\x36\x83\x34", 128},
    {"\xF1\x8F\x9A\x80", "\xA4\x36\x90\x32", 128},
    {"\xF1\x8F\x9C\x80", "\xA4\x36\x9D\x30", 128},
    {"\xF1\x8F\x9E\x80", "\xA4\x36\xA9\x38", 128},
    {"\xF1\x8F\xA0\x80", "\xA4\x36\xB6\x36", 128},
    {"\xF1\x8F\xA2\x80", "\xA4\x36\xC3\x34", 128},
    {"\xF1\x8F\xA4\x80", "\xA4\x36\xD0\x32", 128},
    {"\xF1\x8F\xA6\x80", "\xA4\x36\xDD\x30", 128},
    {"\xF1\x8F\xA8\x80", "\xA4\x36\xE9\x38", 128},
    {"\xF1\x8F\xAA\x80", "\xA4\x36\xF6\x36", 128},
    {"\xF1\x8F\xAC\x80", "\xA4\x37\x85\x34", 128},
    {"\xF1\x8F\xAE\x80", "\xA4\x37\x92\x32", 128},
    {"\xF1\x8F\xB0\x80", "\xA4\x37\x9F\x30", 128},
    {"\xF1\x8F\xB2\x80", "\xA4\x37\xAB\x38", 128},
    {"\xF1\x8F\xB4\x80", "\xA4\x37\xB8\x36", 128},
    {"\xF1\x8F\xB6\x80", "\xA4\x37\xC5\x34", 128},
    {"\xF1\x8F\xB8\x80", "\xA4\x37\xD2\x32", 128},
    {"\xF1\x8F\xBA\x80", "\xA4\x37\xDF\x30", 128},
    {"\xF1\x8F\xBC\x80", "\xA4\x37\xEB\x38", 128},
    {"\xF1\x8F\xBE\x80", "\xA4\x37\xF8\x36", 128},
    {"\xF1\x90\x80\x80", "\xA4\x38\x87\x34", 128},
    {"\xF1\x90\x82\x80", "\xA4\x38\x94\x32", 128},
    {"\xF1\x90\x84\x80", "\xA4\x38\xA1\x30", 128},
    {"\xF1\x90\x86\x80", "\xA4\x38\xAD\x38", 128},
    {"\xF1\x90\x88\x80", "\xA4\x38\xBA\x36", 128},
    {"\xF1\x90\x8A\x80", "\xA4\x38\xC7\x34", 128},
    {"\xF1\x90\x8C\x80", "\xA4\x38\xD4\x32", 128},
    {"\xF1\x90\x8E\x80", "\xA4\x38\xE1\x30", 128},
    {"\xF1\x90\x90\x80", "\xA4\x38\xED\x38", 128},
    {"\xF1\x90\x92\x80", "\xA4\x38\xFA\x36", 128},
    {"\xF1\x90\x94\x80", "\xA4\x39\x89\x34", 128},
    {"\xF1\x90\x96\x80", "\xA4\x39\x96\x32", 128},
    {"\xF1\x90\x98\x80", "\xA4\x39\xA3\x30", 128},
    {"\xF1\x90\x9A\x80", "\xA4\x39\xAF\x38", 128},
    {"\xF1\x90\x9C\x80", "\xA4\x39\xBC\x36", 128},
    {"\xF1\x90\x9E\x80", "\xA4\x39\xC9\x34", 128},
    {"\xF1\x90\xA0\x80", "\xA4\x39\xD6\x32", 128},
    {"\xF1\x90\xA2\x80", "\xA4\x39\xE3\x30", 128},
    {"\xF1\x90\xA4\x80", "\xA4\x39\xEF\x38", 128},
    {"\xF1\x90\xA6\x80", "\xA4\x39\xFC\x36", 128},
    {"\xF1\x90\xA8\x80", "\xA5\x30\x8B\x34", 128},
    {"\xF1\x90\xAA\x80", "\xA5\x30\x98\x32", 128},
    {"\xF1\x90\xAC\x80", "\xA5\x30\xA5\x30", 128},
    {"\xF1\x90\xAE\x80", "\xA5\x30\xB1\x38", 128},
    {"\xF1\x90\xB0\x80", "\xA5\x30\xBE\x36", 128},
    {"\xF1\x90\xB2\x80", "\xA5\x30\xCB\x34", 128},
    {"\xF1\x90\xB4\x80", "\xA5\x30\xD8\x32", 128},
    {"\xF1\x90\xB6\x80", "\xA5\x30\xE5\x30", 128},
    {"\xF1\x90\xB8\x80", "\xA5\x30\xF1\x38", 128},
    {"\xF1\x90\xBA\x80", "\xA5\x30\xFE\x36", 128},
    {"\xF1\x90\xBC\x80", "\xA5\x31\x8D\x34", 128},
    {"\xF1\x90\xBE\x80", "\xA5\x31\x9A\x32", 128},
    {"\xF1\x91\x80\x80", "\xA5\x31\xA7\x30", 128},
    {"\xF1\x91\x82\x80", "\xA5\x31\xB3\x38", 128},
    {"\xF1\x91\x84\x80", "\xA5\x31\xC0\x36", 128},
    {"\xF1\x91\x86\x80", "\xA5\x31\xCD\x34", 128},
    {"\xF1\x91\x88\x80", "\xA5\x31\xDA\x32", 128},
    {"\xF1\x91\x8A\x80", "\xA5\x31\xE7\x30", 128},
    {"\xF1\x91\x8C\x80", "\xA5\x31\xF3\x38", 128},
    {"\xF1\x91\x8E\x80", "\xA5\x32\x82\x36", 128},
    {"\xF1\x91\x90\x80", "\xA5\x32\x8F\x34", 128},
    {"\xF1\x91\x92\x80", "\xA5\x32\x9C\x32", 128},
    {"\xF1\x91\x94\x80", "\xA5\x32\xA9\x30", 128},
    {"\xF1\x91\x96\x80", "\xA5\x32\xB5\x38", 128},
    {"\xF1\x91\x98\x80", "\xA5\x32\xC2\x36", 128},
    {"\xF1\x91\x9A\x80", "\xA5\x32\xCF\x34", 128},
    {"\xF1\x91\x9C\x80", "\xA5\x32\xDC\x32", 128},
    {"\xF1\x91\x9E\x80", "\xA5\x32\xE9\x30", 128},
    {"\xF1\x91\xA0\x80", "\xA5\x32\xF5\x38", 128},
    {"\xF1\x91\xA2\x80", "\xA5\x33\x84\x36", 128},
    {"\xF1\x91\xA4\x80", "\xA5\x33\x91\x34", 128},
    {"\xF1\x91\xA6\x80", "\xA5\x33\x9E\x32", 128},
    {"\xF1\x91\xA8\x80", "\xA5\x33\xAB\x30", 128},
    {"\xF1\x91\xAA\x80", "\xA5\x33\xB7\x38", 128},
    {"\xF1\x91\xAC\x80", "\xA5\x33\xC4\x36", 128},
    {"\xF1\x91\xAE\x80", "\xA5\x33\xD1\x34", 128},
    {"\xF1\x91\xB0\x80", "\xA5\x33\xDE\x32", 128},
    {"\xF1\x91\xB2\x80", "\xA5\x33\xEB\x30", 128},
    {"\xF1\x91\xB4\x80", "\xA5\x33\xF7\x38", 128},
    {"\xF1\x91\xB6\x80", "\xA5\x34\x86\x36", 128},
    {"\xF1\x91\xB8\x80", "\xA5\x34\x93\x34", 128},
    {"\xF1\x91\xBA\x80", "\xA5\x34\xA0\x32", 128},
    {"\xF1\x91\xBC\x80", "\xA5\x34\xAD\x30", 128},
    {"\xF1\x91\xBE\x80", "\xA5\x34\xB9\x38", 128},
    {"\xF1\x92\x80\x80", "\xA5\x34\xC6\x36", 128},
    {"\xF1\x92\x82\x80", "\xA5\x34\xD3\x34", 128},
    {"\xF1\x92\x84\x80", "\xA5\x34\xE0\x32", 128},
    {"\xF1\x92\x86\x80", "\xA5\x34\xED\x30", 128},
    {"\xF1\x92\x88\x80", "\xA5\x34\xF9\x38", 128},
    {"\xF1\x92\x8A\x80", "\xA5\x35\x88\x36", 128},
    {"\xF1\x92\x8C\x80", "\xA5\x35\x95\x34", 128},
    {"\xF1\x92\x8E\x80", "\xA5\x35\xA2\x32", 128},
    {"\xF1\x92\x90\x80", "\xA5\x35\xAF\x30", 128},
    {"\xF1\x92\x92\x80", "\xA5\x35\xBB\x38", 128},
    {"\xF1\x92\x94\x80", "\xA5\x35\xC8\x36", 128},
    {"\xF1\x92\x96\x80", "\xA5\x35\xD5\x34", 128},
    {"\xF1\x92\x98\x80", "\xA5\x35\xE2\x32", 128},
    {"\xF1\x92\x9A\x80", "\xA5\x35\xEF\x30", 128},
    {"\xF1\x92\x9C\x80", "\xA5\x35\xFB\x38", 128},
    {"\xF1\x92\x9E\x80", "\xA5\x36\x8A\x36", 128},
    {"\xF1\x92\xA0\x80", "\xA5\x36\x97\x34", 128},
    {"\xF1\x92\xA2\x80", "\xA5\x36\xA4\x32", 128},
    {"\xF1\x92\xA4\x80", "\xA5\x36\xB1\x30", 128},
    {"\xF1\x92\xA6\x80", "\xA5\x36\xBD\x38", 128},
    {"\xF1\x92\xA8\x80", "\xA5\x36\xCA\x36", 128},
    {"\xF1\x92\xAA\x80", "\xA5\x36\xD7\x34", 128},
    {"\xF1\x92\xAC\x80", "\xA5\x36\xE4\x32", 128},
    {"\xF1\x92\xAE\x80", "\xA5\x36\xF1\x30", 128},
    {"\xF1\x92\xB0\x80", "\xA5\x36\xFD\x38", 128},
    {"\xF1\x92\xB2\x80", "\xA5\x37\x8C\x36", 128},
    {"\xF1\x92\xB4\x80", "\xA5\x37\x99\x34", 128},
    {"\xF1\x92\xB6\x80", "\xA5\x37\xA6\x32", 128},
    {"\xF1\x92\xB8\x80", "\xA5\x37\xB3\x30", 128},
    {"\xF1\x92\xBA\x80", "\xA5\x37\xBF\x38", 128},
    {"\xF1\x92\xBC\x80", "\xA5\x37\xCC\x36", 128},
    {"\xF1\x92\xBE\x80", "\xA5\x37\xD9\x34", 128},
    {"\xF1\x93\x80\x80", "\xA5\x37\xE6\x32", 128},
    {"\xF1\x93\x82\x80", "\xA5\x37\xF3\x30", 128},
    {"\xF1\x93\x84\x80", "\xA5\x38\x81\x38", 128},
    {"\xF1\x93\x86\x80", "\xA5\x38\x8E\x36", 128},
    {"\xF1\x93\x88\x80", "\xA5\x38\x9B\x34", 128},
    {"\xF1\x93\x8A\x80", "\xA5\x38\xA8\x32", 128},
    {"\xF1\x93\x8C\x80", "\xA5\x38\xB5\x30", 128},
    {"\xF1\x93\x8E\x80", "\xA5\x38\xC1\x38", 128},
    {"\xF1\x93\x90\x80", "\xA5\x38\xCE\x36", 128},
    {"\xF1\x93\x92\x80", "\xA5\x38\xDB\x34", 128},
    {"\xF1\x93\x94\x80", "\xA5\x38\xE8\x32", 128},
    {"\xF1\x93\x96\x80", "\xA5\x38\xF5\x30", 128},
    {"\xF1\x93\x98\x80", "\xA5\x39\x83\x38", 128},
    {"\xF1\x93\x9A\x80", "\xA5\x39\x90\x36", 128},
    {"\xF1\x93\x9C\x80", "\xA5\x39\x9D\x34", 128},
    {"\xF1\x93\x9E\x80", "\xA5\x39\xAA\x32", 128},
    {"\xF1\x93\xA0\x80", "\xA5\x39\xB7\x30", 128},
    {"\xF1\x93\xA2\x80", "\xA5\x39\xC3\x38", 128},
    {"\xF1\x93\xA4\x80", "\xA5\x39\xD0\x36", 128},
    {"\xF1\x93\xA6\x80", "\xA5\x39\xDD\x34", 128},
    {"\xF1\x93\xA8\x80", "\xA5\x39\xEA\x32", 128},
    {"\xF1\x93\xAA\x80", "\xA5\x39\xF7\x30", 128},
    {"\xF1\x93\xAC\x80", "\xA6\x30\x85\x38", 128},
    {"\xF1\x93\xAE\x80", "\xA6\x30\x92\x36", 128},
    {"\xF1\x93\xB0\x80", "\xA6\x30\x9F\x34", 128},
    {"\xF1\x93\xB2\x80", "\xA6\x30\xAC\x32", 128},
    {"\xF1\x93\xB4\x80", "\xA6\x30\xB9\x30", 128},
    {"\xF1\x93\xB6\x80", "\xA6\x30\xC5\x38", 128},
    {"\xF1\x93\xB8\x80", "\xA6\x30\xD2\x36", 128},
    {"\xF1\x93\xBA\x80", "\xA6\x30\xDF\x34", 128},
    {"\xF1\x93\xBC\x80", "\xA6\x30\xEC\x32", 128},
    {"\xF1\x93\xBE\x80", "\xA6\x30\xF9\x30", 128},
    {"\xF1\x94\x80\x80", "\xA6\x31\x87\x38", 128},
    {"\xF1\x94\x82\x80", "\xA6\x31\x94\x36", 128},
    {"\xF1\x94\x84\x80", "\xA6\x31\xA1\x34", 128},
    {"\xF1\x94\x86\x80", "\xA6\x31\xAE\x32", 128},
    {"\xF1\x94\x88\x80", "\xA6\x31\xBB\x30", 128},
    {"\xF1\x94\x8A\x80", "\xA6\x31\xC7\x38", 128},
    {"\xF1\x94\x8C\x80", "\xA6\x31\xD4\x36", 128},
    {"\xF1\x94\x8E\x80", "\xA6\x31\xE1\x34", 128},
    {"\xF1\x94\x90\x80", "\xA6\x31\xEE\x32", 128},
    {"\xF1\x94\x92\x80", "\xA6\x31\xFB\x30", 128},
    {"\xF1\x94\x94\x80", "\xA6\x32\x89\x38", 128},
    {"\xF1\x94\x96\x80", "\xA6\x32\x96\x36", 128},
    {"\xF1\x94\x98\x80", "\xA6\x32\xA3\x34", 128},
    {"\xF1\x94\x9A\x80", "\xA6\x32\xB0\x32", 128},
    {"\xF1\x94\x9C\x80", "\xA6\x32\xBD\x30", 128},
    {"\xF1\x94\x9E\x80", "\xA6\x32\xC9\x38", 128},
    {"\xF1\x94\xA0\x80", "\xA6\x32\xD6\x36", 128},
    {"\xF1\x94\xA2\x80", "\xA6\x32\xE3\x34", 128},
    {"\xF1\x94\xA4\x80", "\xA6\x32\xF0\x32", 128},
    {"\xF1\x94\xA6\x80", "\xA6\x32\xFD\x30", 128},
    {"\xF1\x94\xA8\x80", "\xA6\x33\x8B\x38", 128},
    {"\xF1\x94\xAA\x80", "\xA6\x33\x98\x36", 128},
    {"\xF1\x94\xAC\x80", "\xA6\x33\xA5\x34", 128},
    {"\xF1\x94\xAE\x80", "\xA6\x33\xB2\x32", 128},
    {"\xF1\x94\xB0\x80", "\xA6\x33\xBF\x30", 128},
    {"\xF1\x94\xB2\x80", "\xA6\x33\xCB\x38", 128},
    {"\xF1\x94\xB4\x80", "\xA6\x33\xD8\x36", 128},
    {"\xF1\x94\xB6\x80", "\xA6\x33\xE5\x34", 128},
    {"\xF1\x94\xB8\x80", "\xA6\x33\xF2\x32", 128},
    {"\xF1\x94\xBA\x80", "\xA6\x34\x81\x30", 128},
    {"\xF1\x94\xBC\x80", "\xA6\x34\x8D\x38", 128},
    {"\xF1\x94\xBE\x80", "\xA6\x34\x9A\x36", 128},
    {"\xF1\x95\x80\x80", "\xA6\x34\xA7\x34", 128},
    {"\xF1\x95\x82\x80", "\xA6\x34\xB4\x32", 128},
    {"\xF1\x95\x84\x80", "\xA6\x34\xC1\x30", 128},
    {"\xF1\x95\x86\x80", "\xA6\x34\xCD\x38", 128},
    {"\xF1\x95\x88\x80", "\xA6\x34\xDA\x36", 128},
    {"\xF1\x95\x8A\x80", "\xA6\x34\xE7\x34", 128},
    {"\xF1\x95\x8C\x80", "\xA6\x34\xF4\x32", 128},
    {"\xF1\x95\x8E\x80", "\xA6\x35\x83\x30", 128},
    {"\xF1\x95\x90\x80", "\xA6\x35\x8F\x38", 128},
    {"\xF1\x95\x92\x80", "\xA6\x35\x9C\x36", 128},
    {"\xF1\x95\x94\x80", "\xA6\x35\xA9\x34", 128},
    {"\xF1\x95\x96\x80", "\xA6\x35\xB6\x32", 128},
    {"\xF1\x95\x98\x80", "\xA6\x35\xC3\x30", 128},
    {"\xF1\x95\x9A\x80", "\xA6\x35\xCF\x38", 128},
    {"\xF1\x95\x9C\x80", "\xA6\x35\xDC\x36", 128},
    {"\xF1\x95\x9E\x80", "\xA6\x35\xE9\x34", 128},
    {"\xF1\x95\xA0\x80", "\xA6\x35\xF6\x32", 128},
    {"\xF1\x95\xA2\x80", "\xA6\x36\x85\x30", 128},
    {"\xF1\x95\xA4\x80", "\xA6\x36\x91\x38", 128},
    {"\xF1\x95\xA6\x80", "\xA6\x36\x9E\x36", 128},
    {"\xF1\x95\xA8\x80", "\xA6\x36\xAB\x34", 128},
    {"\xF1\x95\xAA\x80", "\xA6\x36\xB8\x32", 128},
    {"\xF1\x95\xAC\x80", "\xA6\x36\xC5\x30", 128},
    {"\xF1\x95\xAE\x80", "\xA6\x36\xD1\x38", 128},
    {"\xF1\x95\xB0\x80", "\xA6\x36\xDE\x36", 128},
    {"\xF1\x95\xB2\x80", "\xA6\x36\xEB\x34", 128},
    {"\xF1\x95\xB4\x80", "\xA6\x36\xF8\x32", 128},
    {"\xF1\x95\xB6\x80", "\xA6\x37\x87\x30", 128},
    {"\xF1\x95\xB8\x80", "\xA6\x37\x93\x38", 128},
    {"\xF1\x95\xBA\x80", "\xA6\x37\xA0\x36", 128},
    {"\xF1\x95\xBC\x80", "\xA6\x37\xAD\x34", 128},
    {"\xF1\x95\xBE\x80", "\xA6\x37\xBA\x32", 128},
    {"\xF1\x96\x80\x80", "\xA6\x37\xC7\x30", 128},
    {"\xF1\x96\x82\x80", "\xA6\x37\xD3\x38", 128},
    {"\xF1\x96\x84\x80", "\xA6\x37\xE0\x36", 128},
    {"\xF1\x96\x86\x80", "\xA6\x37\xED\x34", 128},
    {"\xF1\x96\x88\x80", "\xA6\x37\xFA\x32", 128},
    {"\xF1\x96\x8A\x80", "\xA6\x38\x89\x30", 128},
    {"\xF1\x96\x8C\x80", "\xA6\x38\x95\x38", 128},
    {"\xF1\x96\x8E\x80", "\xA6\x38\xA2\x36", 128},
    {"\xF1\x96\x90\x80", "\xA6\x38\xAF\x34", 128},
    {"\xF1\x96\x92\x80", "\xA6\x38\xBC\x32", 128},
    {"\xF1\x96\x94\x80", "\xA6\x38\xC9\x30", 128},
    {"\xF1\x96\x96\x80", "\xA6\x38\xD5\x38", 128},
    {"\xF1\x96\x98\x80", "\xA6\x38\xE2\x36", 128},
    {"\xF1\x96\x9A\x80", "\xA6\x38\xEF\x34", 128},
    {"\xF1\x96\x9C\x80", "\xA6\x38\xFC\x32", 128},
    {"\xF1\x96\x9E\x80", "\xA6\x39\x8B\x30", 128},
    {"\xF1\x96\xA0\x80", "\xA6\x39\x97\x38", 128},
    {"\xF1\x96\xA2\x80", "\xA6\x39\xA4\x36", 128},
    {"\xF1\x96\xA4\x80", "\xA6\x39\xB1\x34", 128},
    {"\xF1\x96\xA6\x80", "\xA6\x39\xBE\x32", 128},
    {"\xF1\x96\xA8\x80", "\xA6\x39\xCB\x30", 128},
    {"\xF1\x96\xAA\x80", "\xA6\x39\xD7\x38", 128},
    {"\xF1\x96\xAC\x80", "\xA6\x39\xE4\x36", 128},
    {"\xF1\x96\xAE\x80", "\xA6\x39\xF1\x34", 128},
    {"\xF1\x96\xB0\x80", "\xA6\x39\xFE\x32", 128},
    {"\xF1\x96\xB2\x80", "\xA7\x30\x8D\x30", 128},
    {"\xF1\x96\xB4\x80", "\xA7\x30\x99\x38", 128},
    {"\xF1\x96\xB6\x80", "\xA7\x30\xA6\x36", 128},
    {"\xF1\x96\xB8\x80", "\xA7\x30\xB3\x34", 128},
    {"\xF1\x96\xBA\x80", "\xA7\x30\xC0\x32", 128},
    {"\xF1\x96\xBC\x80", "\xA7\x30\xCD\x30", 128},
    {"\xF1\x96\xBE\x80", "\xA7\x30\xD9\x38", 128},
    {"\xF1\x97\x80\x80", "\xA7\x30\xE6\x36", 128},
    {"\xF1\x97\x82\x80", "\xA7\x30\xF3\x34", 128},
    {"\xF1\x97\x84\x80", "\xA7\x31\x82\x32", 128},
    {"\xF1\x97\x86\x80", "\xA7\x31\x8F\x30", 128},
    {"\xF1\x97\x88\x80", "\xA7\x31\x9B\x38", 128},
    {"\xF1\x97\x8A\x80", "\xA7\x31\xA8\x36", 128},
    {"\xF1\x97\x8C\x80", "\xA7\x31\xB5\x34", 128},
    {"\xF1\x97\x8E\x80", "\xA7\x31\xC2\x32", 128},
    {"\xF1\x97\x90\x80", "\xA7\x31\xCF\x30", 128},
    {"\xF1\x97\x92\x80", "\xA7\x31\xDB\x38", 128},
    {"\xF1\x97\x94\x80", "\xA7\x31\xE8\x36", 128},
    {"\xF1\x97\x96\x80", "\xA7\x31\xF5\x34", 128},
    {"\xF1\x97\x98\x80", "\xA7\x32\x84\x32", 128},
    {"\xF1\x97\x9A\x80", "\xA7\x32\x91\x30", 128},
    {"\xF1\x97\x9C\x80", "\xA7\x32\x9D\x38", 128},
    {"\xF1\x97\x9E\x80", "\xA7\x32\xAA\x36", 128},
    {"\xF1\x97\xA0\x80", "\xA7\x32\xB7\x34", 128},
    {"\xF1\x97\xA2\x80", "\xA7\x32\xC4\x32", 128},
    {"\xF1\x97\xA4\x80", "\xA7\x32\xD1\x30", 128},
    {"\xF1\x97\xA6\x80", "\xA7\x32\xDD\x38", 128},
    {"\xF1\x97\xA8\x80", "\xA7\x32\xEA\x36", 128},
    {"\xF1\x97\xAA\x80", "\xA7\x32\xF7\x34", 128},
    {"\xF1\x97\xAC\x80", "\xA7\x33\x86\x32", 128},
    {"\xF1\x97\xAE\x80", "\xA7\x33\x93\x30", 128},
    {"\xF1\x97\xB0\x80", "\xA7\x33\x9F\x38", 128},
    {"\xF1\x97\xB2\x80", "\xA7\x33\xAC\x36", 128},
    {"\xF1\x97\xB4\x80", "\xA7\x33\xB9\x34", 128},
    {"\xF1\x97\xB6\x80", "\xA7\x33\xC6\x32", 128},
    {"\xF1\x97\xB8\x80", "\xA7\x33\xD3\x30", 128},
    {"\xF1\x97\xBA\x80", "\xA7\x33\xDF\x38", 128},
    {"\xF1\x97\xBC\x80", "\xA7\x33\xEC\x36", 128},
    {"\xF1\x97\xBE\x80", "\xA7\x33\xF9\x34", 128},
    {"\xF1\x98\x80\x80", "\xA7\x34\x88\x32", 128},
    {"\xF1\x98\x82\x80", "\xA7\x34\x95\x30", 128},
    {"\xF1\x98\x84\x80", "\xA7\x34\xA1\x38", 128},
    {"\xF1\x98\x86\x80", "\xA7\x34\xAE\x36", 128},
    {"\xF1\x98\x88\x80", "\xA7\x34\xBB\x34", 128},
    {"\xF1\x98\x8A\x80", "\xA7\x34\xC8\x32", 128},
    {"\xF1\x98\x8C\x80", "\xA7\x34\xD5\x30", 128},
    {"\xF1\x98\x8E\x80", "\xA7\x34\xE1\x38", 128},
    {"\xF1\x98\x90\x80", "\xA7\x34\xEE\x36", 128},
    {"\xF1\x98\x92\x80", "\xA7\x34\xFB\x34", 128},
    {"\xF1\x98\x94\x80", "\xA7\x35\x8A\x32", 128},
    {"\xF1\x98\x96\x80", "\xA7\x35\x97\x30", 128},
    {"\xF1\x98\x98\x80", "\xA7\x35\xA3\x38", 128},
    {"\xF1\x98\x9A\x80", "\xA7\x35\xB0\x36", 128},
    {"\xF1\x98\x9C\x80", "\xA7\x35\xBD\x34", 128},
    {"\xF1\x98\x9E\x80", "\xA7\x35\xCA\x32", 128},
    {"\xF1\x98\xA0\x80", "\xA7\x35\xD7\x30", 128},
    {"\xF1\x98\xA2\x80", "\xA7\x35\xE3\x38", 128},
    {"\xF1\x98\xA4\x80", "\xA7\x35\xF0\x36", 128},
    {"\xF1\x98\xA6\x80", "\xA7\x35\xFD\x34", 128},
    {"\xF1\x98\xA8\x80", "\xA7\x36\x8C\x32", 128},
    {"\xF1\x98\xAA\x80", "\xA7\x36\x99\x30", 128},
    {"\xF1\x98\xAC\x80", "\xA7\x36\xA5\x38", 128},
    {"\xF1\x98\xAE\x80", "\xA7\x36\xB2\x36", 128},
    {"\xF1\x98\xB0\x80", "\xA7\x36\xBF\x34", 128},
    {"\xF1\x98\xB2\x80", "\xA7\x36\xCC\x32", 128},
    {"\xF1\x98\xB4\x80", "\xA7\x36\xD9\x30", 128},
    {"\xF1\x98\xB6\x80", "\xA7\x36\xE5\x38", 128},
    {"\xF1\x98\xB8\x80", "\xA7\x36\xF2\x36", 128},
    {"\xF1\x98\xBA\x80", "\xA7\x37\x81\x34", 128},
    {"\xF1\x98\xBC\x80", "\xA7\x37\x8E\x32", 128},
    {"\xF1\x98\xBE\x80", "\xA7\x37\x9B\x30", 128},
    {"\xF1\x99\x80\x80", "\xA7\x37\xA7\x38", 128},
    {"\xF1\x99\x82\x80", "\xA7\x37\xB4\x36", 128},
    {"\xF1\x99\x84\x80", "\xA7\x37\xC1\x34", 128},
    {"\xF1\x99\x86\x80", "\xA7\x37\xCE\x32", 128},
    {"\xF1\x99\x88\x80", "\xA7\x37\xDB\x30", 128},
    {"\xF1\x99\x8A\x80", "\xA7\x37\xE7\x38", 128},
    {"\xF1\x99\x8C\x80", "\xA7\x37\xF4\x36", 128},
    {"\xF1\x99\x8E\x80", "\xA7\x38\x83\x34", 128},
    {"\xF1\x99\x90\x80", "\xA7\x38\x90\x32", 128},
    {"\xF1\x99\x92\x80", "\xA7\x38\x9D\x30", 128},
    {"\xF1\x99\x94\x80", "\xA7\x38\xA9\x38", 128},
    {"\xF1\x99\x96\x80", "\xA7\x38\xB6\x36", 128},
    {"\xF1\x99\x98\x80", "\xA7\x38\xC3\x34", 128},
    {"\xF1\x99\x9A\x80", "\xA7\x38\xD0\x32", 128},
    {"\xF1\x99\x9C\x80", "\xA7\x38\xDD\x30", 128},
    {"\xF1\x99\x9E\x80", "\xA7\x38\xE9\x38", 128},
    {"\xF1\x99\xA0\x80", "\xA7\x38\xF6\x36", 128},
    {"\xF1\x99\xA2\x80", "\xA7\x39\x85\x34", 128},
    {"\xF1\x99\xA4\x80", "\xA7\x39\x92\x32", 128},
    {"\xF1\x99\xA6\x80", "\xA7\x39\x9F\x30", 128},
    {"\xF1\x99\xA8\x80", "\xA7\x39\xAB\x38", 128},
    {"\xF1\x99\xAA\x80", "\xA7\x39\xB8\x36", 128},
    {"\xF1\x99\xAC\x80", "\xA7\x39\xC5\x34", 128},
    {"\xF1\x99\xAE\x80", "\xA7\x39\xD2\x32", 128},
    {"\xF1\x99\xB0\x80", "\xA7\x39\xDF\x30", 128},
    {"\xF1\x99\xB2\x80", "\xA7\x39\xEB\x38", 128},
    {"\xF1\x99\xB4\x80", "\xA7\x39\xF8\x36", 128},
    {"\xF1\x99\xB6\x80", "\xA8\x30\x87\x34", 128},
    {"\xF1\x99\xB8\x80", "\xA8\x30\x94\x32", 128},
    {"\xF1\x99\xBA\x80", "\xA8\x30\xA1\x30", 128},
    {"\xF1\x99\xBC\x80", "\xA8\x30\xAD\x38", 128},
    {"\xF1\x99\xBE\x80", "\xA8\x30\xBA\x36", 128},
    {"\xF1\x9A\x80\x80", "\xA8\x30\xC7\x34", 128},
    {"\xF1\x9A\x82\x80", "\xA8\x30\xD4\x32", 128},
    {"\xF1\x9A\x84\x80", "\xA8\x30\xE1\x30", 128},
    {"\xF1\x9A\x86\x80", "\xA8\x30\xED\x38", 128},
    {"\xF1\x9A\x88\x80", "\xA8\x30\xFA\x36", 128},
    {"\xF1\x9A\x8A\x80", "\xA8\x31\x89\x34", 128},
    {"\xF1\x9A\x8C\x80", "\xA8\x31\x96\x32", 128},
    {"\xF1\x9A\x8E\x80", "\xA8\x31\xA3\x30", 128},
    {"\xF1\x9A\x90\x80", "\xA8\x31\xAF\x38", 128},
    {"\xF1\x9A\x92\x80", "\xA8\x31\xBC\x36", 128},
    {"\xF1\x9A\x94\x80", "\xA8\x31\xC9\x34", 128},
    {"\xF1\x9A\x96\x80", "\xA8\x31\xD6\x32", 128},
    {"\xF1\x9A\x98\x80", "\xA8\x31\xE3\x30", 128},
    {"\xF1\x9A\x9A\x80", "\xA8\x31\xEF\x38", 128},
    {"\xF1\x9A\x9C\x80", "\xA8\x31\xFC\x36", 128},
    {"\xF1\x9A\x9E\x80", "\xA8\x32\x8B\x34", 128},
    {"\xF1\x9A\xA0\x80", "\xA8\x32\x98\x32", 128},
    {"\xF1\x9A\xA2\x80", "\xA8\x32\xA5\x30", 128},
    {"\xF1\x9A\xA4\x80", "\xA8\x32\xB1\x38", 128},
    {"\xF1\x9A\xA6\x80", "\xA8\x32\xBE\x36", 128},
    {"\xF1\x9A\xA8\x80", "\xA8\x32\xCB\x34", 128},
    {"\xF1\x9A\xAA\x80", "\xA8\x32\xD8\x32", 128},
    {"\xF1\x9A\xAC\x80", "\xA8\x32\xE5\x30", 128},
    {"\xF1\x9A\xAE\x80", "\xA8\x32\xF1\x38", 128},
    {"\xF1\x9A\xB0\x80", "\xA8\x32\xFE\x36", 128},
    {"\xF1\x9A\xB2\x80", "\xA8\x33\x8D\x34", 128},
    {"\xF1\x9A\xB4\x80", "\xA8\x33\x9A\x32", 128},
    {"\xF1\x9A\xB6\x80", "\xA8\x33\xA7\x30", 128},
    {"\xF1\x9A\xB8\x80", "\xA8\x33\xB3\x38", 128},
    {"\xF1\x9A\xBA\x80", "\xA8\x33\xC0\x36", 128},
    {"\xF1\x9A\xBC\x80", "\xA8\x33\xCD\x34", 128},
    {"\xF1\x9A\xBE\x80", "\xA8\x33\xDA\x32", 128},
    {"\xF1\x9B\x80\x80", "\xA8\x33\xE7\x30", 128},
    {"\xF1\x9B\x82\x80", "\xA8\x33\xF3\x38", 128},
    {"\xF1\x9B\x84\x80", "\xA8\x34\x82\x36", 128},
    {"\xF1\x9B\x86\x80", "\xA8\x34\x8F\x34", 128},
    {"\xF1\x9B\x88\x80", "\xA8\x34\x9C\x32", 128},
    {"\xF1\x9B\x8A\x80", "\xA8\x34\xA9\x30", 128},
    {"\xF1\x9B\x8C\x80", "\xA8\x34\xB5\x38", 128},
    {"\xF1\x9B\x8E\x80", "\xA8\x34\xC2\x36", 128},
    {"\xF1\x9B\x90\x80", "\xA8\x34\xCF\x34", 128},
    {"\xF1\x9B\x92\x80", "\xA8\x34\xDC\x32", 128},
    {"\xF1\x9B\x94\x80", "\xA8\x34\xE9\x30", 128},
    {"\xF1\x9B\x96\x80", "\xA8\x34\xF5\x38", 128},
    {"\xF1\x9B\x98\x80", "\xA8\x35\x84\x36", 128},
    {"\xF1\x9B\x9A\x80", "\xA8\x35\x91\x34", 128},
    {"\xF1\x9B\x9C\x80", "\xA8\x35\x9E\x32", 128},
    {"\xF1\x9B\x9E\x80", "\xA8\x35\xAB\x30", 128},
    {"\xF1\x9B\xA0\x80", "\xA8\x35\xB7\x38", 128},
    {"\xF1\x9B\xA2\x80", "\xA8\x35\xC4\x36", 128},
    {"\xF1\x9B\xA4\x80", "\xA8\x35\xD1\x34", 128},
    {"\xF1\x9B\xA6\x80", "\xA8\x35\xDE\x32", 128},
    {"\xF1\x9B\xA8\x80", "\xA8\x35\xEB\x30", 128},
    {"\xF1\x9B\xAA\x80", "\xA8\x35\xF7\x38", 128},
    {"\xF1\x9B\xAC\x80", "\xA8\x36\x86\x36", 128},
    {"\xF1\x9B\xAE\x80", "\xA8\x36\x93\x34", 128},
    {"\xF1\x9B\xB0\x80", "\xA8\x36\xA0\x32", 128},
    {"\xF1\x9B\xB2\x80", "\xA8\x36\xAD\x30", 128},
    {"\xF1\x9B\xB4\x80", "\xA8\x36\xB9\x38", 128},
    {"\xF1\x9B\xB6\x80", "\xA8\x36\xC6\x36", 128},
    {"\xF1\x9B\xB8\x80", "\xA8\x36\xD3\x34", 128},
    {"\xF1\x9B\xBA\x80", "\xA8\x36\xE0\x32", 128},
    {"\xF1\x9B\xBC\x80", "\xA8\x36\xED\x30", 128},
    {"\xF1\x9B\xBE\x80", "\xA8\x36\xF9\x38", 128},
    {"\xF1\x9C\x80\x80", "\xA8\x37\x88\x36", 128},
    {"\xF1\x9C\x82\x80", "\xA8\x37\x95\x34", 128},
    {"\xF1\x9C\x84\x80", "\xA8\x37\xA2\x32", 128},
    {"\xF1\x9C\x86\x80", "\xA8\x37\xAF\x30", 128},
    {"\xF1\x9C\x88\x80", "\xA8\x37\xBB\x38", 128},
    {"\xF1\x9C\x8A\x80", "\xA8\x37\xC8\x36", 128},
    {"\xF1\x9C\x8C\x80", "\xA8\x37\xD5\x34", 128},
    {"\xF1\x9C\x8E\x80", "\xA8\x37\xE2\x32", 128},
    {"\xF1\x9C\x90\x80", "\xA8\x37\xEF\x30", 128},
    {"\xF1\x9C\x92\x80", "\xA8\x37\xFB\x38", 128},
    {"\xF1\x9C\x94\x80", "\xA8\x38\x8A\x36", 128},
    {"\xF1\x9C\x96\x80", "\xA8\x38\x97\x34", 128},
    {"\xF1\x9C\x98\x80", "\xA8\x38\xA4\x32", 128},
    {"\xF1\x9C\x9A\x80", "\xA8\x38\xB1\x30", 128},
    {"\xF1\x9C\x9C\x80", "\xA8\x38\xBD\x38", 128},
    {"\xF1\x9C\x9E\x80", "\xA8\x38\xCA\x36", 128},
    {"\xF1\x9C\xA0\x80", "\xA8\x38\xD7\x34", 128},
    {"\xF1\x9C\xA2\x80", "\xA8\x38\xE4\x32", 128},
    {"\xF1\x9C\xA4\x80", "\xA8\x38\xF1\x30", 128},
    {"\xF1\x9C\xA6\x80", "\xA8\x38\xFD\x38", 128},
    {"\xF1\x9C\xA8\x80", "\xA8\x39\x8C\x36", 128},
    {"\xF1\x9C\xAA\x80", "\xA8\x39\x99\x34", 128},
    {"\xF1\x9C\xAC\x80", "\xA8\x39\xA6\x32", 128},
    {"\xF1\x9C\xAE\x80", "\xA8\x39\xB3\x30", 128},
    {"\xF1\x9C\xB0\x80", "\xA8\x39\xBF\x38", 128},
    {"\xF1\x9C\xB2\x80", "\xA8\x39\xCC\x36", 128},
    {"\xF1\x9C\xB4\x80", "\xA8\x39\xD9\x34", 128},
    {"\xF1\x9C\xB6\x80", "\xA8\x39\xE6\x32", 128},
    {"\xF1\x9C\xB8\x80", "\xA8\x39\xF3\x30", 128},
    {"\xF1\x9C\xBA\x80", "\xA9\x30\x81\x38", 128},
    {"\xF1\x9C\xBC\x80", "\xA9\x30\x8E\x36", 128},
    {"\xF1\x9C\xBE\x80", "\xA9\x30\x9B\x34", 128},
    {"\xF1\x9D\x80\x80", "\xA9\x30\xA8\x32", 128},
    {"\xF1\x9D\x82\x80", "\xA9\x30\xB5\x30", 128},
    {"\xF1\x9D\x84\x80", "\xA9\x30\xC1\x38", 128},
    {"\xF1\x9D\x86\x80", "\xA9\x30\xCE\x36", 128},
    {"\xF1\x9D\x88\x80", "\xA9\x30\xDB\x34", 128},
    {"\xF1\x9D\x8A\x80", "\xA9\x30\xE8\x32", 128},
    {"\xF1\x9D\x8C\x80", "\xA9\x30\xF5\x30", 128},
    {"\xF1\x9D\x8E\x80", "\xA9\x31\x83\x38", 128},
    {"\xF1\x9D\x90\x80", "\xA9\x31\x90\x36", 128},
    {"\xF1\x9D\x92\x80", "\xA9\x31\x9D\x34", 128},
    {"\xF1\x9D\x94\x80", "\xA9\x31\xAA\x32", 128},
    {"\xF1\x9D\x96\x80", "\xA9\x31\xB7\x30", 128},
    {"\xF1\x9D\x98\x80", "\xA9\x31\xC3\x38", 128},
    {"\xF1\x9D\x9A\x80", "\xA9\x31\xD0\x36", 128},
    {"\xF1\x9D\x9C\x80", "\xA9\x31\xDD\x34", 128},
    {"\xF1\x9D\x9E\x80", "\xA9\x31\xEA\x32", 128},
    {"\xF1\x9D\xA0\x80", "\xA9\x31\xF7\x30", 128},
    {"\xF1\x9D\xA2\x80", "\xA9\x32\x85\x38", 128},
    {"\xF1\x9D\xA4\x80", "\xA9\x32\x92\x36", 128},
    {"\xF1\x9D\xA6\x80", "\xA9\x32\x9F\x34", 128},
    {"\xF1\x9D\xA8\x80", "\xA9\x32\xAC\x32", 128},
    {"\xF1\x9D\xAA\x80", "\xA9\x32\xB9\x30", 128},
    {"\xF1\x9D\xAC\x80", "\xA9\x32\xC5\x38", 128},
    {"\xF1\x9D\xAE\x80", "\xA9\x32\xD2\x36", 128},
    {"\xF1\x9D\xB0\x80", "\xA9\x32\xDF\x34", 128},
    {"\xF1\x9D\xB2\x80", "\xA9\x32\xEC\x32", 128},
    {"\xF1\x9D\xB4\x80", "\xA9\x32\xF9\x30", 128},
    {"\xF1\x9D\xB6\x80", "\xA9\x33\x87\x38", 128},
    {"\xF1\x9D\xB8\x80", "\xA9\x33\x94\x36", 128},
    {"\xF1\x9D\xBA\x80", "\xA9\x33\xA1\x34", 128},
    {"\xF1\x9D\xBC\x80", "\xA9\x33\xAE\x32", 128},
    {"\xF1\x9D\xBE\x80", "\xA9\x33\xBB\x30", 128},
    {"\xF1\x9E\x80\x80", "\xA9\x33\xC7\x38", 128},
    {"\xF1\x9E\x82\x80", "\xA9\x33\xD4\x36", 128},
    {"\xF1\x9E\x84\x80", "\xA9\x33\xE1\x34", 128},
    {"\xF1\x9E\x86\x80", "\xA9\x33\xEE\x32", 128},
    {"\xF1\x9E\x88\x80", "\xA9\x33\xFB\x30", 128},
    {"\xF1\x9E\x8A\x80", "\xA9\x34\x89\x38", 128},
    {"\xF1\x9E\x8C\x80", "\xA9\x34\x96\x36", 128},
    {"\xF1\x9E\x8E\x80", "\xA9\x34\xA3\x34", 128},
    {"\xF1\x9E\x90\x80", "\xA9\x34\xB0\x32", 128},
    {"\xF1\x9E\x92\x80", "\xA9\x34\xBD\x30", 128},
    {"\xF1\x9E\x94\x80", "\xA9\x34\xC9\x38", 128},
    {"\xF1\x9E\x96\x80", "\xA9\x34\xD6\x36", 128},
    {"\xF1\x9E\x98\x80", "\xA9\x34\xE3\x34", 128},
    {"\xF1\x9E\x9A\x80", "\xA9\x34\xF0\x32", 128},
    {"\xF1\x9E\x9C\x80", "\xA9\x34\xFD\x30", 128},
    {"\xF1\x9E\x9E\x80", "\xA9\x35\x8B\x38", 128},
    {"\xF1\x9E\xA0\x80", "\xA9\x35\x98\x36", 128},
    {"\xF1\x9E\xA2\x80", "\xA9\x35\xA5\x34", 128},
    {"\xF1\x9E\xA4\x80", "\xA9\x35\xB2\x32", 128},
    {"\xF1\x9E\xA6\x80", "\xA9\x35\xBF\x30", 128},
    {"\xF1\x9E\xA8\x80", "\xA9\x35\xCB\x38", 128},
    {"\xF1\x9E\xAA\x80", "\xA9\x35\xD8\x36", 128},
    {"\xF1\x9E\xAC\x80", "\xA9\x35\xE5\x34", 128},
    {"\xF1\x9E\xAE\x80", "\xA9\x35\xF2\x32", 128},
    {"\xF1\x9E\xB0\x80", "\xA9\x36\x81\x30", 128},
    {"\xF1\x9E\xB2\x80", "\xA9\x36\x8D\x38", 128},
    {"\xF1\x9E\xB4\x80", "\xA9\x36\x9A\x36", 128},
    {"\xF1\x9E\xB6\x80", "\xA9\x36\xA7\x34", 128},
    {"\xF1\x9E\xB8\x80", "\xA9\x36\xB4\x32", 128},
    {"\xF1\x9E\xBA\x80", "\xA9\x36\xC1\x30", 128},
    {"\xF1\x9E\xBC\x80", "\xA9\x36\xCD\x38", 128},
    {"\xF1\x9E\xBE\x80", "\xA9\x36\xDA\x36", 128},
    {"\xF1\x9F\x80\x80", "\xA9\x36\xE7\x34", 128},
    {"\xF1\x9F\x82\x80", "\xA9\x36\xF4\x32", 128},
    {"\xF1\x9F\x84\x80", "\xA9\x37\x83\x30", 128},
    {"\xF1\x9F\x86\x80", "\xA9\x37\x8F\x38", 128},
    {"\xF1\x9F\x88\x80", "\xA9\x37\x9C\x36", 128},
    {"\xF1\x9F\x8A\x80", "\xA9\x37\xA9\x34", 128},
    {"\xF1\x9F\x8C\x80", "\xA9\x37\xB6\x32", 128},
    {"\xF1\x9F\x8E\x80", "\xA9\x37\xC3\x30", 128},
    {"\xF1\x9F\x90\x80", "\xA9\x37\xCF\x38", 128},
    {"\xF1\x9F\x92\x80", "\xA9\x37\xDC\x36", 128},
    {"\xF1\x9F\x94\x80", "\xA9\x37\xE9\x34", 128},
    {"\xF1\x9F\x96\x80", "\xA9\x37\xF6\x32", 128},
    {"\xF1\x9F\x98\x80", "\xA9\x38\x85\x30", 128},
    {"\xF1\x9F\x9A\x80", "\xA9\x38\x91\x38", 128},
    {"\xF1\x9F\x9C\x80", "\xA9\x38\x9E\x36", 128},
    {"\xF1\x9F\x9E\x80", "\xA9\x38\xAB\x34", 128},
    {"\xF1\x9F\xA0\x80", "\xA9\x38\xB8\x32", 128},
    {"\xF1\x9F\xA2\x80", "\xA9\x38\xC5\x30", 128},
    {"\xF1\x9F\xA4\x80", "\xA9\x38\xD1\x38", 128},
    {"\xF1\x9F\xA6\x80", "\xA9\x38\xDE\x36", 128},
    {"\xF1\x9F\xA8\x80", "\xA9\x38\xEB\x34", 128},
    {"\xF1\x9F\xAA\x80", "\xA9\x38\xF8\x32", 128},
    {"\xF1\x9F\xAC\x80", "\xA9\x39\x87\x30", 128},
    {"\xF1\x9F\xAE\x80", "\xA9\x39\x93\x38", 128},
    {"\xF1\x9F\xB0\x80", "\xA9\x39\xA0\x36", 128},
    {"\xF1\x9F\xB2\x80", "\xA9\x39\xAD\x34", 128},
    {"\xF1\x9F\xB4\x80", "\xA9\x39\xBA\x32", 128},
    {"\xF1\x9F\xB6\x80", "\xA9\x39\xC7\x30", 128},
    {"\xF1\x9F\xB8\x80", "\xA9\x39\xD3\x38", 128},
    {"\xF1\x9F\xBA\x80", "\xA9\x39\xE0\x36", 128},
    {"\xF1\x9F\xBC\x80", "\xA9\x39\xED\x34", 128},
    {"\xF1\x9F\xBE\x80", "\xA9\x39\xFA\x32", 128},
    {"\xF1\xA0\x80\x80", "\xAA\x30\x89\x30", 128},
    {"\xF1\xA0\x82\x80", "\xAA\x30\x95\x38", 128},
    {"\xF1\xA0\x84\x80", "\xAA\x30\xA2\x36", 128},
    {"\xF1\xA0\x86\x80", "\xAA\x30\xAF\x34", 128},
    {"\xF1\xA0\x88\x80", "\xAA\x30\xBC\x32", 128},
    {"\xF1\xA0\x8A\x80", "\xAA\x30\xC9\x30", 128},
    {"\xF1\xA0\x8C\x80", "\xAA\x30\xD5\x38", 128},
    {"\xF1\xA0\x8E\x80", "\xAA\x30\xE2\x36", 128},
    {"\xF1\xA0\x90\x80", "\xAA\x30\xEF\x34", 128},
    {"\xF1\xA0\x92\x80", "\xAA\x30\xFC\x32", 128},
    {"\xF1\xA0\x94\x80", "\xAA\x31\x8B\x30", 128},
    {"\xF1\xA0\x96\x80", "\xAA\x31\x97\x38", 128},
    {"\xF1\xA0\x98\x80", "\xAA\x31\xA4\x36", 128},
    {"\xF1\xA0\x9A\x80", "\xAA\x31\xB1\x34", 128},
    {"\xF1\xA0\x9C\x80", "\xAA\x31\xBE\x32", 128},
    {"\xF1\xA0\x9E\x80", "\xAA\x31\xCB\x30", 128},
    {"\xF1\xA0\xA0\x80", "\xAA\x31\xD7\x38", 128},
    {"\xF1\xA0\xA2\x80", "\xAA\x31\xE4\x36", 128},
    {"\xF1\xA0\xA4\x80", "\xAA\x31\xF1\x34", 128},
    {"\xF1\xA0\xA6\x80", "\xAA\x31\xFE\x32", 128},
    {"\xF1\xA0\xA8\x80", "\xAA\x32\x8D\x30", 128},
    {"\xF1\xA0\xAA\x80", "\xAA\x32\x99\x38", 128},
    {"\xF1\xA0\xAC\x80", "\xAA\x32\xA6\x36", 128},
    {"\xF1\xA0\xAE\x80", "\xAA\x32\xB3\x34", 128},
    {"\xF1\xA0\xB0\x80", "\xAA\x32\xC0\x32", 128},
    {"\xF1\xA0\xB2\x80", "\xAA\x32\xCD\x30", 128},
    {"\xF1\xA0\xB4\x80", "\xAA\x32\xD9\x38", 128},
    {"\xF1\xA0\xB6\x80", "\xAA\x32\xE6\x36", 128},
    {"\xF1\xA0\xB8\x80", "\xAA\x32\xF3\x34", 128},
    {"\xF1\xA0\xBA\x80", "\xAA\x33\x82\x32", 128},
    {"\xF1\xA0\xBC\x80", "\xAA\x33\x8F\x30", 128},
    {"\xF1\xA0\xBE\x80", "\xAA\x33\x9B\x38", 128},
    {"\xF1\xA1\x80\x80", "\xAA\x33\xA8\x36", 128},
    {"\xF1\xA1\x82\x80", "\xAA\x33\xB5\x34", 128},
    {"\xF1\xA1\x84\x80", "\xAA\x33\xC2\x32", 128},
    {"\xF1\xA1\x86\x80", "\xAA\x33\xCF\x30", 128},
    {"\xF1\xA1\x88\x80", "\xAA\x33\xDB\x38", 128},
    {"\xF1\xA1\x8A\x80", "\xAA\x33\xE8\x36", 128},
    {"\xF1\xA1\x8C\x80", "\xAA\x33\xF5\x34", 128},
    {"\xF1\xA1\x8E\x80", "\xAA\x34\x84\x32", 128},
    {"\xF1\xA1\x90\x80", "\xAA\x34\x91\x30", 128},
    {"\xF1\xA1\x92\x80", "\xAA\x34\x9D\x38", 128},
    {"\xF1\xA1\x94\x80", "\xAA\x34\xAA\x36", 128},
    {"\xF1\xA1\x96\x80", "\xAA\x34\xB7\x34", 128},
    {"\xF1\xA1\x98\x80", "\xAA\x34\xC4\x32", 128},
    {"\xF1\xA1\x9A\x80", "\xAA\x34\xD1\x30", 128},
    {"\xF1\xA1\x9C\x80", "\xAA\x34\xDD\x38", 128},
    {"\xF1\xA1\x9E\x80", "\xAA\x34\xEA\x36", 128},
    {"\xF1\xA1\xA0\x80", "\xAA\x34\xF7\x34", 128},
    {"\xF1\xA1\xA2\x80", "\xAA\x35\x86\x32", 128},
    {"\xF1\xA1\xA4\x80", "\xAA\x35\x93\x30", 128},
    {"\xF1\xA1\xA6\x80", "\xAA\x35\x9F\x38", 128},
    {"\xF1\xA1\xA8\x80", "\xAA\x35\xAC\x36", 128},
    {"\xF1\xA1\xAA\x80", "\xAA\x35\xB9\x34", 128},
    {"\xF1\xA1\xAC\x80", "\xAA\x35\xC6\x32", 128},
    {"\xF1\xA1\xAE\x80", "\xAA\x35\xD3\x30", 128},
    {"\xF1\xA1\xB0\x80", "\xAA\x35\xDF\x38", 128},
    {"\xF1\xA1\xB2\x80", "\xAA\x35\xEC\x36", 128},
    {"\xF1\xA1\xB4\x80", "\xAA\x35\xF9\x34", 128},
    {"\xF1\xA1\xB6\x80", "\xAA\x36\x88\x32", 128},
    {"\xF1\xA1\xB8\x80", "\xAA\x36\x95\x30", 128},
    {"\xF1\xA1\xBA\x80", "\xAA\x36\xA1\x38", 128},
    {"\xF1\xA1\xBC\x80", "\xAA\x36\xAE\x36", 128},
    {"\xF1\xA1\xBE\x80", "\xAA\x36\xBB\x34", 128},
    {"\xF1\xA2\x80\x80", "\xAA\x36\xC8\x32", 128},
    {"\xF1\xA2\x82\x80", "\xAA\x36\xD5\x30", 128},
    {"\xF1\xA2\x84\x80", "\xAA\x36\xE1\x38", 128},
    {"\xF1\xA2\x86\x80", "\xAA\x36\xEE\x36", 128},
    {"\xF1\xA2\x88\x80", "\xAA\x36\xFB\x34", 128},
    {"\xF1\xA2\x8A\x80", "\xAA\x37\x8A\x32", 128},
    {"\xF1\xA2\x8C\x80", "\xAA\x37\x97\x30", 128},
    {"\xF1\xA2\x8E\x80", "\xAA\x37\xA3\x38", 128},
    {"\xF1\xA2\x90\x80", "\xAA\x37\xB0\x36", 128},
    {"\xF1\xA2\x92\x80", "\xAA\x37\xBD\x34", 128},
    {"\xF1\xA2\x94\x80", "\xAA\x37\xCA\x32", 128},
    {"\xF1\xA2\x96\x80", "\xAA\x37\xD7\x30", 128},
    {"\xF1\xA2\x98\x80", "\xAA\x37\xE3\x38", 128},
    {"\xF1\xA2\x9A\x80", "\xAA\x37\xF0\x36", 128},
    {"\xF1\xA2\x9C\x80", "\xAA\x37\xFD\x34", 128},
    {"\xF1\xA2\x9E\x80", "\xAA\x38\x8C\x32", 128},
    {"\xF1\xA2\xA0\x80", "\xAA\x38\x99\x30", 128},
    {"\xF1\xA2\xA2\x80", "\xAA\x38\xA5\x38", 128},
    {"\xF1\xA2\xA4\x80", "\xAA\x38\xB2\x36", 128},
    {"\xF1\xA2\xA6\x80", "\xAA\x38\xBF\x34", 128},
    {"\xF1\xA2\xA8\x80", "\xAA\x38\xCC\x32", 128},
    {"\xF1\xA2\xAA\x80", "\xAA\x38\xD9\x30", 128},
    {"\xF1\xA2\xAC\x80", "\xAA\x38\xE5\x38", 128},
    {"\xF1\xA2\xAE\x80", "\xAA\x38\xF2\x36", 128},
    {"\xF1\xA2\xB0\x80", "\xAA\x39\x81\x34", 128},
    {"\xF1\xA2\xB2\x80", "\xAA\x39\x8E\x32", 128},
    {"\xF1\xA2\xB4\x80", "\xAA\x39\x9B\x30", 128},
    {"\xF1\xA2\xB6\x80", "\xAA\x39\xA7\x38", 128},
    {"\xF1\xA2\xB8\x80", "\xAA\x39\xB4\x36", 128},
    {"\xF1\xA2\xBA\x80", "\xAA\x39\xC1\x34", 128},
    {"\xF1\xA2\xBC\x80", "\xAA\x39\xCE\x32", 128},
    {"\xF1\xA2\xBE\x80", "\xAA\x39\xDB\x30", 128},
    {"\xF1\xA3\x80\x80", "\xAA\x39\xE7\x38", 128},
    {"\xF1\xA3\x82\x80", "\xAA\x39\xF4\x36", 128},
    {"\xF1\xA3\x84\x80", "\xAB\x30\x83\x34", 128},
    {"\xF1\xA3\x86\x80", "\xAB\x30\x90\x32", 128},
    {"\xF1\xA3\x88\x80", "\xAB\x30\x9D\x30", 128},
    {"\xF1\xA3\x8A\x80", "\xAB\x30\xA9\x38", 128},
    {"\xF1\xA3\x8C\x80", "\xAB\x30\xB6\x36", 128},
    {"\xF1\xA3\x8E\x80", "\xAB\x30\xC3\x34", 128},
    {"\xF1\xA3\x90\x80", "\xAB\x30\xD0\x32", 128},
    {"\xF1\xA3\x92\x80", "\xAB\x30\xDD\x30", 128},
    {"\xF1\xA3\x94\x80", "\xAB\x30\xE9\x38", 128},
    {"\xF1\xA3\x96\x80", "\xAB\x30\xF6\x36", 128},
    {"\xF1\xA3\x98\x80", "\xAB\x31\x85\x34", 128},
    {"\xF1\xA3\x9A\x80", "\xAB\x31\x92\x32", 128},
    {"\xF1\xA3\x9C\x80", "\xAB\x31\x9F\x30", 128},
    {"\xF1\xA3\x9E\x80", "\xAB\x31\xAB\x38", 128},
    {"\xF1\xA3\xA0\x80", "\xAB\x31\xB8\x36", 128},
    {"\xF1\xA3\xA2\x80", "\xAB\x31\xC5\x34", 128},
    {"\xF1\xA3\xA4\x80", "\xAB\x31\xD2\x32", 128},
    {"\xF1\xA3\xA6\x80", "\xAB\x31\xDF\x30", 128},
    {"\xF1\xA3\xA8\x80", "\xAB\x31\xEB\x38", 128},
    {"\xF1\xA3\xAA\x80", "\xAB\x31\xF8\x36", 128},
    {"\xF1\xA3\xAC\x80", "\xAB\x32\x87\x34", 128},
    {"\xF1\xA3\xAE\x80", "\xAB\x32\x94\x32", 128},
    {"\xF1\xA3\xB0\x80", "\xAB\x32\xA1\x30", 128},
    {"\xF1\xA3\xB2\x80", "\xAB\x32\xAD\x38", 128},
    {"\xF1\xA3\xB4\x80", "\xAB\x32\xBA\x36", 128},
    {"\xF1\xA3\xB6\x80", "\xAB\x32\xC7\x34", 128},
    {"\xF1\xA3\xB8\x80", "\xAB\x32\xD4\x32", 128},
    {"\xF1\xA3\xBA\x80", "\xAB\x32\xE1\x30", 128},
    {"\xF1\xA3\xBC\x80", "\xAB\x32\xED\x38", 128},
    {"\xF1\xA3\xBE\x80", "\xAB\x32\xFA\x36", 128},
    {"\xF1\xA4\x80\x80", "\xAB\x33\x89\x34", 128},
    {"\xF1\xA4\x82\x80", "\xAB\x33\x96\x32", 128},
    {"\xF1\xA4\x84\x80", "\xAB\x33\xA3\x30", 128},
    {"\xF1\xA4\x86\x80", "\xAB\x33\xAF\x38", 128},
    {"\xF1\xA4\x88\x80", "\xAB\x33\xBC\x36", 128},
    {"\xF1\xA4\x8A\x80", "\xAB\x33\xC9\x34", 128},
    {"\xF1\xA4\x8C\x80", "\xAB\x33\xD6\x32", 128},
    {"\xF1\xA4\x8E\x80", "\xAB\x33\xE3\x30", 128},
    {"\xF1\xA4\x90\x80", "\xAB\x33\xEF\x38", 128},
    {"\xF1\xA4\x92\x80", "\xAB\x33\xFC\x36", 128},
    {"\xF1\xA4\x94\x80", "\xAB\x34\x8B\x34", 128},
    {"\xF1\xA4\x96\x80", "\xAB\x34\x98\x32", 128},
    {"\xF1\xA4\x98\x80", "\xAB\x34\xA5\x30", 128},
    {"\xF1\xA4\x9A\x80", "\xAB\x34\xB1\x38", 128},
    {"\xF1\xA4\x9C\x80", "\xAB\x34\xBE\x36", 128},
    {"\xF1\xA4\x9E\x80", "\xAB\x34\xCB\x34", 128},
    {"\xF1\xA4\xA0\x80", "\xAB\x34\xD8\x32", 128},
    {"\xF1\xA4\xA2\x80", "\xAB\x34\xE5\x30", 128},
    {"\xF1\xA4\xA4\x80", "\xAB\x34\xF1\x38", 128},
    {"\xF1\xA4\xA6\x80", "\xAB\x34\xFE\x36", 128},
    {"\xF1\xA4\xA8\x80", "\xAB\x35\x8D\x34", 128},
    {"\xF1\xA4\xAA\x80", "\xAB\x35\x9A\x32", 128},
    {"\xF1\xA4\xAC\x80", "\xAB\x35\xA7\x30", 128},
    {"\xF1\xA4\xAE\x80", "\xAB\x35\xB3\x38", 128},
    {"\xF1\xA4\xB0\x80", "\xAB\x35\xC0\x36", 128},
    {"\xF1\xA4\xB2\x80", "\xAB\x35\xCD\x34", 128},
    {"\xF1\xA4\xB4\x80", "\xAB\x35\xDA\x32", 128},
    {"\xF1\xA4\xB6\x80", "\xAB\x35\xE7\x30", 128},
    {"\xF1\xA4\xB8\x80", "\xAB\x35\xF3\x38", 128},
    {"\xF1\xA4\xBA\x80", "\xAB\x36\x82\x36", 128},
    {"\xF1\xA4\xBC\x80", "\xAB\x36\x8F\x34", 128},
    {"\xF1\xA4\xBE\x80", "\xAB\x36\x9C\x32", 128},
    {"\xF1\xA5\x80\x80", "\xAB\x36\xA9\x30", 128},
    {"\xF1\xA5\x82\x80", "\xAB\x36\xB5\x38", 128},
    {"\xF1\xA5\x84\x80", "\xAB\x36\xC2\x36", 128},
    {"\xF1\xA5\x86\x80", "\xAB\x36\xCF\x34", 128},
    {"\xF1\xA5\x88\x80", "\xAB\x36\xDC\x32", 128},
    {"\xF1\xA5\x8A\x80", "\xAB\x36\xE9\x30", 128},
    {"\xF1\xA5\x8C\x80", "\xAB\x36\xF5\x38", 128},
    {"\xF1\xA5\x8E\x80", "\xAB\x37\x84\x36", 128},
    {"\xF1\xA5\x90\x80", "\xAB\x37\x91\x34", 128},
    {"\xF1\xA5\x92\x80", "\xAB\x37\x9E\x32", 128},
    {"\xF1\xA5\x94\x80", "\xAB\x37\xAB\x30", 128},
    {"\xF1\xA5\x96\x80", "\xAB\x37\xB7\x38", 128},
    {"\xF1\xA5\x98\x80", "\xAB\x37\xC4\x36", 128},
    {"\xF1\xA5\x9A\x80", "\xAB\x37\xD1\x34", 128},
    {"\xF1\xA5\x9C\x80", "\xAB\x37\xDE\x32", 128},
    {"\xF1\xA5\x9E\x80", "\xAB\x37\xEB\x30", 128},
    {"\xF1\xA5\xA0\x80", "\xAB\x37\xF7\x38", 128},
    {"\xF1\xA5\xA2\x80", "\xAB\x38\x86\x36", 128},
    {"\xF1\xA5\xA4\x80", "\xAB\x38\x93\x34", 128},
    {"\xF1\xA5\xA6\x80", "\xAB\x38\xA0\x32", 128},
    {"\xF1\xA5\xA8\x80", "\xAB\x38\xAD\x30", 128},
    {"\xF1\xA5\xAA\x80", "\xAB\x38\xB9\x38", 128},
    {"\xF1\xA5\xAC\x80", "\xAB\x38\xC6\x36", 128},
    {"\xF1\xA5\xAE\x80", "\xAB\x38\xD3\x34", 128},
    {"\xF1\xA5\xB0\x80", "\xAB\x38\xE0\x32", 128},
    {"\xF1\xA5\xB2\x80", "\xAB\x38\xED\x30", 128},
    {"\xF1\xA5\xB4\x80", "\xAB\x38\xF9\x38", 128},
    {"\xF1\xA5\xB6\x80", "\xAB\x39\x88\x36", 128},
    {"\xF1\xA5\xB8\x80", "\xAB\x39\x95\x34", 128},
    {"\xF1\xA5\xBA\x80", "\xAB\x39\xA2\x32", 128},
    {"\xF1\xA5\xBC\x80", "\xAB\x39\xAF\x30", 128},
    {"\xF1\xA5\xBE\x80", "\xAB\x39\xBB\x38", 128},
    {"\xF1\xA6\x80\x80", "\xAB\x39\xC8\x36", 128},
    {"\xF1\xA6\x82\x80", "\xAB\x39\xD5\x34", 128},
    {"\xF1\xA6\x84\x80", "\xAB\x39\xE2\x32", 128},
    {"\xF1\xA6\x86\x80", "\xAB\x39\xEF\x30", 128},
    {"\xF1\xA6\x88\x80", "\xAB\x39\xFB\x38", 128},
    {"\xF1\xA6\x8A\x80", "\xAC\x30\x8A\x36", 128},
    {"\xF1\xA6\x8C\x80", "\xAC\x30\x97\x34", 128},
    {"\xF1\xA6\x8E\x80", "\xAC\x30\xA4\x32", 128},
    {"\xF1\xA6\x90\x80", "\xAC\x30\xB1\x30", 128},
    {"\xF1\xA6\x92\x80", "\xAC\x30\xBD\x38", 128},
    {"\xF1\xA6\x94\x80", "\xAC\x30\xCA\x36", 128},
    {"\xF1\xA6\x96\x80", "\xAC\x30\xD7\x34", 128},
    {"\xF1\xA6\x98\x80", "\xAC\x30\xE4\x32", 128},
    {"\xF1\xA6\x9A\x80", "\xAC\x30\xF1\x30", 128},
    {"\xF1\xA6\x9C\x80", "\xAC\x30\xFD\x38", 128},
    {"\xF1\xA6\x9E\x80", "\xAC\x31\x8C\x36", 128},
    {"\xF1\xA6\xA0\x80", "\xAC\x31\x99\x34", 128},
    {"\xF1\xA6\xA2\x80", "\xAC\x31\xA6\x32", 128},
    {"\xF1\xA6\xA4\x80", "\xAC\x31\xB3\x30", 128},
    {"\xF1\xA6\xA6\x80", "\xAC\x31\xBF\x38", 128},
    {"\xF1\xA6\xA8\x80", "\xAC\x31\xCC\x36", 128},
    {"\xF1\xA6\xAA\x80", "\xAC\x31\xD9\x34", 128},
    {"\xF1\xA6\xAC\x80", "\xAC\x31\xE6\x32", 128},
    {"\xF1\xA6\xAE\x80", "\xAC\x31\xF3\x30", 128},
    {"\xF1\xA6\xB0\x80", "\xAC\x32\x81\x38", 128},
    {"\xF1\xA6\xB2\x80", "\xAC\x32\x8E\x36", 128},
    {"\xF1\xA6\xB4\x80", "\xAC\x32\x9B\x34", 128},
    {"\xF1\xA6\xB6\x80", "\xAC\x32\xA8\x32", 128},
    {"\xF1\xA6\xB8\x80", "\xAC\x32\xB5\x30", 128},
    {"\xF1\xA6\xBA\x80", "\xAC\x32\xC1\x38", 128},
    {"\xF1\xA6\xBC\x80", "\xAC\x32\xCE\x36", 128},
    {"\xF1\xA6\xBE\x80", "\xAC\x32\xDB\x34", 128},
    {"\xF1\xA7\x80\x80", "\xAC\x32\xE8\x32", 128},
    {"\xF1\xA7\x82\x80", "\xAC\x32\xF5\x30", 128},
    {"\xF1\xA7\x84\x80", "\xAC\x33\x83\x38", 128},
    {"\xF1\xA7\x86\x80", "\xAC\x33\x90\x36", 128},
    {"\xF1\xA7\x88\x80", "\xAC\x33\x9D\x34", 128},
    {"\xF1\xA7\x8A\x80", "\xAC\x33\xAA\x32", 128},
    {"\xF1\xA7\x8C\x80", "\xAC\x33\xB7\x30", 128},
    {"\xF1\xA7\x8E\x80", "\xAC\x33\xC3\x38", 128},
    {"\xF1\xA7\x90\x80", "\xAC\x33\xD0\x36", 128},
    {"\xF1\xA7\x92\x80", "\xAC\x33\xDD\x34", 128},
    {"\xF1\xA7\x94\x80", "\xAC\x33\xEA\x32", 128},
    {"\xF1\xA7\x96\x80", "\xAC\x33\xF7\x30", 128},
    {"\xF1\xA7\x98\x80", "\xAC\x34\x85\x38", 128},
    {"\xF1\xA7\x9A\x80", "\xAC\x34\x92\x36", 128},
    {"\xF1\xA7\x9C\x80", "\xAC\x34\x9F\x34", 128},
    {"\xF1\xA7\x9E\x80", "\xAC\x34\xAC\x32", 128},
    {"\xF1\xA7\xA0\x80", "\xAC\x34\xB9\x30", 128},
    {"\xF1\xA7\xA2\x80", "\xAC\x34\xC5\x38", 128},
    {"\xF1\xA7\xA4\x80", "\xAC\x34\xD2\x36", 128},
    {"\xF1\xA7\xA6\x80", "\xAC\x34\xDF\x34", 128},
    {"\xF1\xA7\xA8\x80", "\xAC\x34\xEC\x32", 128},
    {"\xF1\xA7\xAA\x80", "\xAC\x34\xF9\x30", 128},
    {"\xF1\xA7\xAC\x80", "\xAC\x35\x87\x38", 128},
    {"\xF1\xA7\xAE\x80", "\xAC\x35\x94\x36", 128},
    {"\xF1\xA7\xB0\x80", "\xAC\x35\xA1\x34", 128},
    {"\xF1\xA7\xB2\x80", "\xAC\x35\xAE\x32", 128},
    {"\xF1\xA7\xB4\x80", "\xAC\x35\xBB\x30", 128},
    {"\xF1\xA7\xB6\x80", "\xAC\x35\xC7\x38", 128},
    {"\xF1\xA7\xB8\x80", "\xAC\x35\xD4\x36", 128},
    {"\xF1\xA7\xBA\x80", "\xAC\x35\xE1\x34", 128},
    {"\xF1\xA7\xBC\x80", "\xAC\x35\xEE\x32", 128},
    {"\xF1\xA7\xBE\x80", "\xAC\x35\xFB\x30", 128},
    {"\xF1\xA8\x80\x80", "\xAC\x36\x89\x38", 128},
    {"\xF1\xA8\x82\x80", "\xAC\x36\x96\x36", 128},
    {"\xF1\xA8\x84\x80", "\xAC\x36\xA3\x34", 128},
    {"\xF1\xA8\x86\x80", "\xAC\x36\xB0\x32", 128},
    {"\xF1\xA8\x88\x80", "\xAC\x36\xBD\x30", 128},
    {"\xF1\xA8\x8A\x80", "\xAC\x36\xC9\x38", 128},
    {"\xF1\xA8\x8C\x80", "\xAC\x36\xD6\x36", 128},
    {"\xF1\xA8\x8E\x80", "\xAC\x36\xE3\x34", 128},
    {"\xF1\xA8\x90\x80", "\xAC\x36\xF0\x32", 128},
    {"\xF1\xA8\x92\x80", "\xAC\x36\xFD\x30", 128},
    {"\xF1\xA8\x94\x80", "\xAC\x37\x8B\x38", 128},
    {"\xF1\xA8\x96\x80", "\xAC\x37\x98\x36", 128},
    {"\xF1\xA8\x98\x80", "\xAC\x37\xA5\x34", 128},
    {"\xF1\xA8\x9A\x80", "\xAC\x37\xB2\x32", 128},
    {"\xF1\xA8\x9C\x80", "\xAC\x37\xBF\x30", 128},
    {"\xF1\xA8\x9E\x80", "\xAC\x37\xCB\x38", 128},
    {"\xF1\xA8\xA0\x80", "\xAC\x37\xD8\x36", 128},
    {"\xF1\xA8\xA2\x80", "\xAC\x37\xE5\x34", 128},
    {"\xF1\xA8\xA4\x80", "\xAC\x37\xF2\x32", 128},
    {"\xF1\xA8\xA6\x80", "\xAC\x38\x81\x30", 128},
    {"\xF1\xA8\xA8\x80", "\xAC\x38\x8D\x38", 128},
    {"\xF1\xA8\xAA\x80", "\xAC\x38\x9A\x36", 128},
    {"\xF1\xA8\xAC\x80", "\xAC\x38\xA7\x34", 128},
    {"\xF1\xA8\xAE\x80", "\xAC\x38\xB4\x32", 128},
    {"\xF1\xA8\xB0\x80", "\xAC\x38\xC1\x30", 128},
    {"\xF1\xA8\xB2\x80", "\xAC\x38\xCD\x38", 128},
    {"\xF1\xA8\xB4\x80", "\xAC\x38\xDA\x36", 128},
    {"\xF1\xA8\xB6\x80", "\xAC\x38\xE7\x34", 128},
    {"\xF1\xA8\xB8\x80", "\xAC\x38\xF4\x32", 128},
    {"\xF1\xA8\xBA\x80", "\xAC\x39\x83\x30", 128},
    {"\xF1\xA8\xBC\x80", "\xAC\x39\x8F\x38", 128},
    {"\xF1\xA8\xBE\x80", "\xAC\x39\x9C\x36", 128},
    {"\xF1\xA9\x80\x80", "\xAC\x39\xA9\x34", 128},
    {"\xF1\xA9\x82\x80", "\xAC\x39\xB6\x32", 128},
    {"\xF1\xA9\x84\x80", "\xAC\x39\xC3\x30", 128},
    {"\xF1\xA9\x86\x80", "\xAC\x39\xCF\x38", 128},
    {"\xF1\xA9\x88\x80", "\xAC\x39\xDC\x36", 128},
    {"\xF1\xA9\x8A\x80", "\xAC\x39\xE9\x34", 128},
    {"\xF1\xA9\x8C\x80", "\xAC\x39\xF6\x32", 128},
    {"\xF1\xA9\x8E\x80", "\xAD\x30\x85\x30", 128},
    {"\xF1\xA9\x90\x80", "\xAD\x30\x91\x38", 128},
    {"\xF1\xA9\x92\x80", "\xAD\x30\x9E\x36", 128},
    {"\xF1\xA9\x94\x80", "\xAD\x30\xAB\x34", 128},
    {"\xF1\xA9\x96\x80", "\xAD\x30\xB8\x32", 128},
    {"\xF1\xA9\x98\x80", "\xAD\x30\xC5\x30", 128},
    {"\xF1\xA9\x9A\x80", "\xAD\x30\xD1\x38", 128},
    {"\xF1\xA9\x9C\x80", "\xAD\x30\xDE\x36", 128},
    {"\xF1\xA9\x9E\x80", "\xAD\x30\xEB\x34", 128},
    {"\xF1\xA9\xA0\x80", "\xAD\x30\xF8\x32", 128},
    {"\xF1\xA9\xA2\x80", "\xAD\x31\x87\x30", 128},
    {"\xF1\xA9\xA4\x80", "\xAD\x31\x93\x38", 128},
    {"\xF1\xA9\xA6\x80", "\xAD\x31\xA0\x36", 128},
    {"\xF1\xA9\xA8\x80", "\xAD\x31\xAD\x34", 128},
    {"\xF1\xA9\xAA\x80", "\xAD\x31\xBA\x32", 128},
    {"\xF1\xA9\xAC\x80", "\xAD\x31\xC7\x30", 128},
    {"\xF1\xA9\xAE\x80", "\xAD\x31\xD3\x38", 128},
    {"\xF1\xA9\xB0\x80", "\xAD\x31\xE0\x36", 128},
    {"\xF1\xA9\xB2\x80", "\xAD\x31\xED\x34", 128},
    {"\xF1\xA9\xB4\x80", "\xAD\x31\xFA\x32", 128},
    {"\xF1\xA9\xB6\x80", "\xAD\x32\x89\x30", 128},
    {"\xF1\xA9\xB8\x80", "\xAD\x32\x95\x38", 128},
    {"\xF1\xA9\xBA\x80", "\xAD\x32\xA2\x36", 128},
    {"\xF1\xA9\xBC\x80", "\xAD\x32\xAF\x34", 128},
    {"\xF1\xA9\xBE\x80", "\xAD\x32\xBC\x32", 128},
    {"\xF1\xAA\x80\x80", "\xAD\x32\xC9\x30", 128},
    {"\xF1\xAA\x82\x80", "\xAD\x32\xD5\x38", 128},
    {"\xF1\xAA\x84\x80", "\xAD\x32\xE2\x36", 128},
    {"\xF1\xAA\x86\x80", "\xAD\x32\xEF\x34", 128},
    {"\xF1\xAA\x88\x80", "\xAD\x32\xFC\x32", 128},
    {"\xF1\xAA\x8A\x80", "\xAD\x33\x8B\x30", 128},
    {"\xF1\xAA\x8C\x80", "\xAD\x33\x97\x38", 128},
    {"\xF1\xAA\x8E\x80", "\xAD\x33\xA4\x36", 128},
    {"\xF1\xAA\x90\x80", "\xAD\x33\xB1\x34", 128},
    {"\xF1\xAA\x92\x80", "\xAD\x33\xBE\x32", 128},
    {"\xF1\xAA\x94\x80", "\xAD\x33\xCB\x30", 128},
    {"\xF1\xAA\x96\x80", "\xAD\x33\xD7\x38", 128},
    {"\xF1\xAA\x98\x80", "\xAD\x33\xE4\x36", 128},
    {"\xF1\xAA\x9A\x80", "\xAD\x33\xF1\x34", 128},
    {"\xF1\xAA\x9C\x80", "\xAD\x33\xFE\x32", 128},
    {"\xF1\xAA\x9E\x80", "\xAD\x34\x8D\x30", 128},
    {"\xF1\xAA\xA0\x80", "\xAD\x34\x99\x38", 128},
    {"\xF1\xAA\xA2\x80", "\xAD\x34\xA6\x36", 128},
    {"\xF1\xAA\xA4\x80", "\xAD\x34\xB3\x34", 128},
    {"\xF1\xAA\xA6\x80", "\xAD\x34\xC0\x32", 128},
    {"\xF1\xAA\xA8\x80", "\xAD\x34\xCD\x30", 128},
    {"\xF1\xAA\xAA\x80", "\xAD\x34\xD9\x38", 128},
    {"\xF1\xAA\xAC\x80", "\xAD\x34\xE6\x36", 128},
    {"\xF1\xAA\xAE\x80", "\xAD\x34\xF3\x34", 128},
    {"\xF1\xAA\xB0\x80", "\xAD\x35\x82\x32", 128},
    {"\xF1\xAA\xB2\x80", "\xAD\x35\x8F\x30", 128},
    {"\xF1\xAA\xB4\x80", "\xAD\x35\x9B\x38", 128},
    {"\xF1\xAA\xB6\x80", "\xAD\x35\xA8\x36", 128},
    {"\xF1\xAA\xB8\x80", "\xAD\x35\xB5\x34", 128},
    {"\xF1\xAA\xBA\x80", "\xAD\x35\xC2\x32", 128},
    {"\xF1\xAA\xBC\x80", "\xAD\x35\xCF\x30", 128},
    {"\xF1\xAA\xBE\x80", "\xAD\x35\xDB\x38", 128},
    {"\xF1\xAB\x80\x80", "\xAD\x35\xE8\x36", 128},
    {"\xF1\xAB\x82\x80", "\xAD\x35\xF5\x34", 128},
    {"\xF1\xAB\x84\x80", "\xAD\x36\x84\x32", 128},
    {"\xF1\xAB\x86\x80", "\xAD\x36\x91\x30", 128},
    {"\xF1\xAB\x88\x80", "\xAD\x36\x9D\x38", 128},
    {"\xF1\xAB\x8A\x80", "\xAD\x36\xAA\x36", 128},
    {"\xF1\xAB\x8C\x80", "\xAD\x36\xB7\x34", 128},
    {"\xF1\xAB\x8E\x80", "\xAD\x36\xC4\x32", 128},
    {"\xF1\xAB\x90\x80", "\xAD\x36\xD1\x30", 128},
    {"\xF1\xAB\x92\x80", "\xAD\x36\xDD\x38", 128},
    {"\xF1\xAB\x94\x80", "\xAD\x36\xEA\x36", 128},
    {"\xF1\xAB\x96\x80", "\xAD\x36\xF7\x34", 128},
    {"\xF1\xAB\x98\x80", "\xAD\x37\x86\x32", 128},
    {"\xF1\xAB\x9A\x80", "\xAD\x37\x93\x30", 128},
    {"\xF1\xAB\x9C\x80", "\xAD\x37\x9F\x38", 128},
    {"\xF1\xAB\x9E\x80", "\xAD\x37\xAC\x36", 128},
    {"\xF1\xAB\xA0\x80", "\xAD\x37\xB9\x34", 128},
    {"\xF1\xAB\xA2\x80", "\xAD\x37\xC6\x32", 128},
    {"\xF1\xAB\xA4\x80", "\xAD\x37\xD3\x30", 128},
    {"\xF1\xAB\xA6\x80", "\xAD\x37\xDF\x38", 128},
    {"\xF1\xAB\xA8\x80", "\xAD\x37\xEC\x36", 128},
    {"\xF1\xAB\xAA\x80", "\xAD\x37\xF9\x34", 128},
    {"\xF1\xAB\xAC\x80", "\xAD\x38\x88\x32", 128},
    {"\xF1\xAB\xAE\x80", "\xAD\x38\x95\x30", 128},
    {"\xF1\xAB\xB0\x80", "\xAD\x38\xA1\x38", 128},
    {"\xF1\xAB\xB2\x80", "\xAD\x38\xAE\x36", 128},
    {"\xF1\xAB\xB4\x80", "\xAD\x38\xBB\x34", 128},
    {"\xF1\xAB\xB6\x80", "\xAD\x38\xC8\x32", 128},
    {"\xF1\xAB\xB8\x80", "\xAD\x38\xD5\x30", 128},
    {"\xF1\xAB\xBA\x80", "\xAD\x38\xE1\x38", 128},
    {"\xF1\xAB\xBC\x80", "\xAD\x38\xEE\x36", 128},
    {"\xF1\xAB\xBE\x80", "\xAD\x38\xFB\x34", 128},
    {"\xF1\xAC\x80\x80", "\xAD\x39\x8A\x32", 128},
    {"\xF1\xAC\x82\x80", "\xAD\x39\x97\x30", 128},
    {"\xF1\xAC\x84\x80", "\xAD\x39\xA3\x38", 128},
    {"\xF1\xAC\x86\x80", "\xAD\x39\xB0\x36", 128},
    {"\xF1\xAC\x88\x80", "\xAD\x39\xBD\x34", 128},
    {"\xF1\xAC\x8A\x80", "\xAD\x39\xCA\x32", 128},
    {"\xF1\xAC\x8C\x80", "\xAD\x39\xD7\x30", 128},
    {"\xF1\xAC\x8E\x80", "\xAD\x39\xE3\x38", 128},
    {"\xF1\xAC\x90\x80", "\xAD\x39\xF0\x36", 128},
    {"\xF1\xAC\x92\x80", "\xAD\x39\xFD\x34", 128},
    {"\xF1\xAC\x94\x80", "\xAE\x30\x8C\x32", 128},
    {"\xF1\xAC\x96\x80", "\xAE\x30\x99\x30", 128},
    {"\xF1\xAC\x98\x80", "\xAE\x30\xA5\x38", 128},
    {"\xF1\xAC\x9A\x80", "\xAE\x30\xB2\x36", 128},
    {"\xF1\xAC\x9C\x80", "\xAE\x30\xBF\x34", 128},
    {"\xF1\xAC\x9E\x80", "\xAE\x30\xCC\x32", 128},
    {"\xF1\xAC\xA0\x80", "\xAE\x30\xD9\x30", 128},
    {"\xF1\xAC\xA2\x80", "\xAE\x30\xE5\x38", 128},
    {"\xF1\xAC\xA4\x80", "\xAE\x30\xF2\x36", 128},
    {"\xF1\xAC\xA6\x80", "\xAE\x31\x81\x34", 128},
    {"\xF1\xAC\xA8\x80", "\xAE\x31\x8E\x32", 128},
    {"\xF1\xAC\xAA\x80", "\xAE\x31\x9B\x30", 128},
    {"\xF1\xAC\xAC\x80", "\xAE\x31\xA7\x38", 128},
    {"\xF1\xAC\xAE\x80", "\xAE\x31\xB4\x36", 128},
    {"\xF1\xAC\xB0\x80", "\xAE\x31\xC1\x34", 128},
    {"\xF1\xAC\xB2\x80", "\xAE\x31\xCE\x32", 128},
    {"\xF1\xAC\xB4\x80", "\xAE\x31\xDB\x30", 128},
    {"\xF1\xAC\xB6\x80", "\xAE\x31\xE7\x38", 128},
    {"\xF1\xAC\xB8\x80", "\xAE\x31\xF4\x36", 128},
    {"\xF1\xAC\xBA\x80", "\xAE\x32\x83\x34", 128},
    {"\xF1\xAC\xBC\x80", "\xAE\x32\x90\x32", 128},
    {"\xF1\xAC\xBE\x80", "\xAE\x32\x9D\x30", 128},
    {"\xF1\xAD\x80\x80", "\xAE\x32\xA9\x38", 128},
    {"\xF1\xAD\x82\x80", "\xAE\x32\xB6\x36", 128},
    {"\xF1\xAD\x84\x80", "\xAE\x32\xC3\x34", 128},
    {"\xF1\xAD\x86\x80", "\xAE\x32\xD0\x32", 128},
    {"\xF1\xAD\x88\x80", "\xAE\x32\xDD\x30", 128},
    {"\xF1\xAD\x8A\x80", "\xAE\x32\xE9\x38", 128},
    {"\xF1\xAD\x8C\x80", "\xAE\x32\xF6\x36", 128},
    {"\xF1\xAD\x8E\x80", "\xAE\x33\x85\x34", 128},
    {"\xF1\xAD\x90\x80", "\xAE\x33\x92\x32", 128},
    {"\xF1\xAD\x92\x80", "\xAE\x33\x9F\x30", 128},
    {"\xF1\xAD\x94\x80", "\xAE\x33\xAB\x38", 128},
    {"\xF1\xAD\x96\x80", "\xAE\x33\xB8\x36", 128},
    {"\xF1\xAD\x98\x80", "\xAE\x33\xC5\x34", 128},
    {"\xF1\xAD\x9A\x80", "\xAE\x33\xD2\x32", 128},
    {"\xF1\xAD\x9C\x80", "\xAE\x33\xDF\x30", 128},
    {"\xF1\xAD\x9E\x80", "\xAE\x33\xEB\x38", 128},
    {"\xF1\xAD\xA0\x80", "\xAE\x33\xF8\x36", 128},
    {"\xF1\xAD\xA2\x80", "\xAE\x34\x87\x34", 128},
    {"\xF1\xAD\xA4\x80", "\xAE\x34\x94\x32", 128},
    {"\xF1\xAD\xA6\x80", "\xAE\x34\xA1\x30", 128},
    {"\xF1\xAD\xA8\x80", "\xAE\x34\xAD\x38", 128},
    {"\xF1\xAD\xAA\x80", "\xAE\x34\xBA\x36", 128},
    {"\xF1\xAD\xAC\x80", "\xAE\x34\xC7\x34", 128},
    {"\xF1\xAD\xAE\x80", "\xAE\x34\xD4\x32", 128},
    {"\xF1\xAD\xB0\x80", "\xAE\x34\xE1\x30", 128},
    {"\xF1\xAD\xB2\x80", "\xAE\x34\xED\x38", 128},
    {"\xF1\xAD\xB4\x80", "\xAE\x34\xFA\x36", 128},
    {"\xF1\xAD\xB6\x80", "\xAE\x35\x89\x34", 128},
    {"\xF1\xAD\xB8\x80", "\xAE\x35\x96\x32", 128},
    {"\xF1\xAD\xBA\x80", "\xAE\x35\xA3\x30", 128},
    {"\xF1\xAD\xBC\x80", "\xAE\x35\xAF\x38", 128},
    {"\xF1\xAD\xBE\x80", "\xAE\x35\xBC\x36", 128},
    {"\xF1\xAE\x80\x80", "\xAE\x35\xC9\x34", 128},
    {"\xF1\xAE\x82\x80", "\xAE\x35\xD6\x32", 128},
    {"\xF1\xAE\x84\x80", "\xAE\x35\xE3\x30", 128},
    {"\xF1\xAE\x86\x80", "\xAE\x35\xEF\x38", 128},
    {"\xF1\xAE\x88\x80", "\xAE\x35\xFC\x36", 128},
    {"\xF1\xAE\x8A\x80", "\xAE\x36\x8B\x34", 128},
    {"\xF1\xAE\x8C\x80", "\xAE\x36\x98\x32", 128},
    {"\xF1\xAE\x8E\x80", "\xAE\x36\xA5\x30", 128},
    {"\xF1\xAE\x90\x80", "\xAE\x36\xB1\x38", 128},
    {"\xF1\xAE\x92\x80", "\xAE\x36\xBE\x36", 128},
    {"\xF1\xAE\x94\x80", "\xAE\x36\xCB\x34", 128},
    {"\xF1\xAE\x96\x80", "\xAE\x36\xD8\x32", 128},
    {"\xF1\xAE\x98\x80", "\xAE\x36\xE5\x30", 128},
    {"\xF1\xAE\x9A\x80", "\xAE\x36\xF1\x38", 128},
    {"\xF1\xAE\x9C\x80", "\xAE\x36\xFE\x36", 128},
    {"\xF1\xAE\x9E\x80", "\xAE\x37\x8D\x34", 128},
    {"\xF1\xAE\xA0\x80", "\xAE\x37\x9A\x32", 128},
    {"\xF1\xAE\xA2\x80", "\xAE\x37\xA7\x30", 128},
    {"\xF1\xAE\xA4\x80", "\xAE\x37\xB3\x38", 128},
    {"\xF1\xAE\xA6\x80", "\xAE\x37\xC0\x36", 128},
    {"\xF1\xAE\xA8\x80", "\xAE\x37\xCD\x34", 128},
    {"\xF1\xAE\xAA\x80", "\xAE\x37\xDA\x32", 128},
    {"\xF1\xAE\xAC\x80", "\xAE\x37\xE7\x30", 128},
    {"\xF1\xAE\xAE\x80", "\xAE\x37\xF3\x38", 128},
    {"\xF1\xAE\xB0\x80", "\xAE\x38\x82\x36", 128},
    {"\xF1\xAE\xB2\x80", "\xAE\x38\x8F\x34", 128},
    {"\xF1\xAE\xB4\x80", "\xAE\x38\x9C\x32", 128},
    {"\xF1\xAE\xB6\x80", "\xAE\x38\xA9\x30", 128},
    {"\xF1\xAE\xB8\x80", "\xAE\x38\xB5\x38", 128},
    {"\xF1\xAE\xBA\x80", "\xAE\x38\xC2\x36", 128},
    {"\xF1\xAE\xBC\x80", "\xAE\x38\xCF\x34", 128},
    {"\xF1\xAE\xBE\x80", "\xAE\x38\xDC\x32", 128},
    {"\xF1\xAF\x80\x80", "\xAE\x38\xE9\x30", 128},
    {"\xF1\xAF\x82\x80", "\xAE\x38\xF5\x38", 128},
    {"\xF1\xAF\x84\x80", "\xAE\x39\x84\x36", 128},
    {"\xF1\xAF\x86\x80", "\xAE\x39\x91\x34", 128},
    {"\xF1\xAF\x88\x80", "\xAE\x39\x9E\x32", 128},
    {"\xF1\xAF\x8A\x80", "\xAE\x39\xAB\x30", 128},
    {"\xF1\xAF\x8C\x80", "\xAE\x39\xB7\x38", 128},
    {"\xF1\xAF\x8E\x80", "\xAE\x39\xC4\x36", 128},
    {"\xF1\xAF\x90\x80", "\xAE\x39\xD1\x34", 128},
    {"\xF1\xAF\x92\x80", "\xAE\x39\xDE\x32", 128},
    {"\xF1\xAF\x94\x80", "\xAE\x39\xEB\x30", 128},
    {"\xF1\xAF\x96\x80", "\xAE\x39\xF7\x38", 128},
    {"\xF1\xAF\x98\x80", "\xAF\x30\x86\x36", 128},
    {"\xF1\xAF\x9A\x80", "\xAF\x30\x93\x34", 128},
    {"\xF1\xAF\x9C\x80", "\xAF\x30\xA0\x32", 128},
    {"\xF1\xAF\x9E\x80", "\xAF\x30\xAD\x30", 128},
    {"\xF1\xAF\xA0\x80", "\xAF\x30\xB9\x38", 128},
    {"\xF1\xAF\xA2\x80", "\xAF\x30\xC6\x36", 128},
    {"\xF1\xAF\xA4\x80", "\xAF\x30\xD3\x34", 128},
    {"\xF1\xAF\xA6\x80", "\xAF\x30\xE0\x32", 128},
    {"\xF1\xAF\xA8\x80", "\xAF\x30\xED\x30", 128},
    {"\xF1\xAF\xAA\x80", "\xAF\x30\xF9\x38", 128},
    {"\xF1\xAF\xAC\x80", "\xAF\x31\x88\x36", 128},
    {"\xF1\xAF\xAE\x80", "\xAF\x31\x95\x34", 128},
    {"\xF1\xAF\xB0\x80", "\xAF\x31\xA2\x32", 128},
    {"\xF1\xAF\xB2\x80", "\xAF\x31\xAF\x30", 128},
    {"\xF1\xAF\xB4\x80", "\xAF\x31\xBB\x38", 128},
    {"\xF1\xAF\xB6\x80", "\xAF\x31\xC8\x36", 128},
    {"\xF1\xAF\xB8\x80", "\xAF\x31\xD5\x34", 128},
    {"\xF1\xAF\xBA\x80", "\xAF\x31\xE2\x32", 128},
    {"\xF1\xAF\xBC\x80", "\xAF\x31\xEF\x30", 128},
    {"\xF1\xAF\xBE\x80", "\xAF\x31\xFB\x38", 128},
    {"\xF1\xB0\x80\x80", "\xAF\x32\x8A\x36", 128},
    {"\xF1\xB0\x82\x80", "\xAF\x32\x97\x34", 128},
    {"\xF1\xB0\x84\x80", "\xAF\x32\xA4\x32", 128},
    {"\xF1\xB0\x86\x80", "\xAF\x32\xB1\x30", 128},
    {"\xF1\xB0\x88\x80", "\xAF\x32\xBD\x38", 128},
    {"\xF1\xB0\x8A\x80", "\xAF\x32\xCA\x36", 128},
    {"\xF1\xB0\x8C\x80", "\xAF\x32\xD7\x34", 128},
    {"\xF1\xB0\x8E\x80", "\xAF\x32\xE4\x32", 128},
    {"\xF1\xB0\x90\x80", "\xAF\x32\xF1\x30", 128},
    {"\xF1\xB0\x92\x80", "\xAF\x32\xFD\x38", 128},
    {"\xF1\xB0\x94\x80", "\xAF\x33\x8C\x36", 128},
    {"\xF1\xB0\x96\x80", "\xAF\x33\x99\x34", 128},
    {"\xF1\xB0\x98\x80", "\xAF\x33\xA6\x32", 128},
    {"\xF1\xB0\x9A\x80", "\xAF\x33\xB3\x30", 128},
    {"\xF1\xB0\x9C\x80", "\xAF\x33\xBF\x38", 128},
    {"\xF1\xB0\x9E\x80", "\xAF\x33\xCC\x36", 128},
    {"\xF1\xB0\xA0\x80", "\xAF\x33\xD9\x34", 128},
    {"\xF1\xB0\xA2\x80", "\xAF\x33\xE6\x32", 128},
    {"\xF1\xB0\xA4\x80", "\xAF\x33\xF3\x30", 128},
    {"\xF1\xB0\xA6\x80", "\xAF\x34\x81\x38", 128},
    {"\xF1\xB0\xA8\x80", "\xAF\x34\x8E\x36", 128},
    {"\xF1\xB0\xAA\x80", "\xAF\x34\x9B\x34", 128},
    {"\xF1\xB0\xAC\x80", "\xAF\x34\xA8\x32", 128},
    {"\xF1\xB0\xAE\x80", "\xAF\x34\xB5\x30", 128},
    {"\xF1\xB0\xB0\x80", "\xAF\x34\xC1\x38", 128},
    {"\xF1\xB0\xB2\x80", "\xAF\x34\xCE\x36", 128},
    {"\xF1\xB0\xB4\x80", "\xAF\x34\xDB\x34", 128},
    {"\xF1\xB0\xB6\x80", "\xAF\x34\xE8\x32", 128},
    {"\xF1\xB0\xB8\x80", "\xAF\x34\xF5\x30", 128},
    {"\xF1\xB0\xBA\x80", "\xAF\x35\x83\x38", 128},
    {"\xF1\xB0\xBC\x80", "\xAF\x35\x90\x36", 128},
    {"\xF1\xB0\xBE\x80", "\xAF\x35\x9D\x34", 128},
    {"\xF1\xB1\x80\x80", "\xAF\x35\xAA\x32", 128},
    {"\xF1\xB1\x82\x80", "\xAF\x35\xB7\x30", 128},
    {"\xF1\xB1\x84\x80", "\xAF\x35\xC3\x38", 128},
    {"\xF1\xB1\x86\x80", "\xAF\x35\xD0\x36", 128},
    {"\xF1\xB1\x88\x80", "\xAF\x35\xDD\x34", 128},
    {"\xF1\xB1\x8A\x80", "\xAF\x35\xEA\x32", 128},
    {"\xF1\xB1\x8C\x80", "\xAF\x35\xF7\x30", 128},
    {"\xF1\xB1\x8E\x80", "\xAF\x36\x85\x38", 128},
    {"\xF1\xB1\x90\x80", "\xAF\x36\x92\x36", 128},
    {"\xF1\xB1\x92\x80", "\xAF\x36\x9F\x34", 128},
    {"\xF1\xB1\x94\x80", "\xAF\x36\xAC\x32", 128},
    {"\xF1\xB1\x96\x80", "\xAF\x36\xB9\x30", 128},
    {"\xF1\xB1\x98\x80", "\xAF\x36\xC5\x38", 128},
    {"\xF1\xB1\x9A\x80", "\xAF\x36\xD2\x36", 128},
    {"\xF1\xB1\x9C\x80", "\xAF\x36\xDF\x34", 128},
    {"\xF1\xB1\x9E\x80", "\xAF\x36\xEC\x32", 128},
    {"\xF1\xB1\xA0\x80", "\xAF\x36\xF9\x30", 128},
    {"\xF1\xB1\xA2\x80", "\xAF\x37\x87\x38", 128},
    {"\xF1\xB1\xA4\x80", "\xAF\x37\x94\x36", 128},
    {"\xF1\xB1\xA6\x80", "\xAF\x37\xA1\x34", 128},
    {"\xF1\xB1\xA8\x80", "\xAF\x37\xAE\x32", 128},
    {"\xF1\xB1\xAA\x80", "\xAF\x37\xBB\x30", 128},
    {"\xF1\xB1\xAC\x80", "\xAF\x37\xC7\x38", 128},
    {"\xF1\xB1\xAE\x80", "\xAF\x37\xD4\x36", 128},
    {"\xF1\xB1\xB0\x80", "\xAF\x37\xE1\x34", 128},
    {"\xF1\xB1\xB2\x80", "\xAF\x37\xEE\x32", 128},
    {"\xF1\xB1\xB4\x80", "\xAF\x37\xFB\x30", 128},
    {"\xF1\xB1\xB6\x80", "\xAF\x38\x89\x38", 128},
    {"\xF1\xB1\xB8\x80", "\xAF\x38\x96\x36", 128},
    {"\xF1\xB1\xBA\x80", "\xAF\x38\xA3\x34", 128},
    {"\xF1\xB1\xBC\x80", "\xAF\x38\xB0\x32", 128},
    {"\xF1\xB1\xBE\x80", "\xAF\x38\xBD\x30", 128},
    {"\xF1\xB2\x80\x80", "\xAF\x38\xC9\x38", 128},
    {"\xF1\xB2\x82\x80", "\xAF\x38\xD6\x36", 128},
    {"\xF1\xB2\x84\x80", "\xAF\x38\xE3\x34", 128},
    {"\xF1\xB2\x86\x80", "\xAF\x38\xF0\x32", 128},
    {"\xF1\xB2\x88\x80", "\xAF\x38\xFD\x30", 128},
    {"\xF1\xB2\x8A\x80", "\xAF\x39\x8B\x38", 128},
    {"\xF1\xB2\x8C\x80", "\xAF\x39\x98\x36", 128},
    {"\xF1\xB2\x8E\x80", "\xAF\x39\xA5\x34", 128},
    {"\xF1\xB2\x90\x80", "\xAF\x39\xB2\x32", 128},
    {"\xF1\xB2\x92\x80", "\xAF\x39\xBF\x30", 128},
    {"\xF1\xB2\x94\x80", "\xAF\x39\xCB\x38", 128},
    {"\xF1\xB2\x96\x80", "\xAF\x39\xD8\x36", 128},
    {"\xF1\xB2\x98\x80", "\xAF\x39\xE5\x34", 128},
    {"\xF1\xB2\x9A\x80", "\xAF\x39\xF2\x32", 128},
    {"\xF1\xB2\x9C\x80", "\xB0\x30\x81\x30", 128},
    {"\xF1\xB2\x9E\x80", "\xB0\x30\x8D\x38", 128},
    {"\xF1\xB2\xA0\x80", "\xB0\x30\x9A\x36", 128},
    {"\xF1\xB2\xA2\x80", "\xB0\x30\xA7\x34", 128},
    {"\xF1\xB2\xA4\x80", "\xB0\x30\xB4\x32", 128},
    {"\xF1\xB2\xA6\x80", "\xB0\x30\xC1\x30", 128},
    {"\xF1\xB2\xA8\x80", "\xB0\x30\xCD\x38", 128},
    {"\xF1\xB2\xAA\x80", "\xB0\x30\xDA\x36", 128},
    {"\xF1\xB2\xAC\x80", "\xB0\x30\xE7\x34", 128},
    {"\xF1\xB2\xAE\x80", "\xB0\x30\xF4\x32", 128},
    {"\xF1\xB2\xB0\x80", "\xB0\x31\x83\x30", 128},
    {"\xF1\xB2\xB2\x80", "\xB0\x31\x8F\x38", 128},
    {"\xF1\xB2\xB4\x80", "\xB0\x31\x9C\x36", 128},
    {"\xF1\xB2\xB6\x80", "\xB0\x31\xA9\x34", 128},
    {"\xF1\xB2\xB8\x80", "\xB0\x31\xB6\x32", 128},
    {"\xF1\xB2\xBA\x80", "\xB0\x31\xC3\x30", 128},
    {"\xF1\xB2\xBC\x80", "\xB0\x31\xCF\x38", 128},
    {"\xF1\xB2\xBE\x80", "\xB0\x31\xDC\x36", 128},
    {"\xF1\xB3\x80\x80", "\xB0\x31\xE9\x34", 128},
    {"\xF1\xB3\x82\x80", "\xB0\x31\xF6\x32", 128},
    {"\xF1\xB3\x84\x80", "\xB0\x32\x85\x30", 128},
    {"\xF1\xB3\x86\x80", "\xB0\x32\x91\x38", 128},
    {"\xF1\xB3\x88\x80", "\xB0\x32\x9E\x36", 128},
    {"\xF1\xB3\x8A\x80", "\xB0\x32\xAB\x34", 128},
    {"\xF1\xB3\x8C\x80", "\xB0\x32\xB8\x32", 128},
    {"\xF1\xB3\x8E\x80", "\xB0\x32\xC5\x30", 128},
    {"\xF1\xB3\x90\x80", "\xB0\x32\xD1\x38", 128},
    {"\xF1\xB3\x92\x80", "\xB0\x32\xDE\x36", 128},
    {"\xF1\xB3\x94\x80", "\xB0\x32\xEB\x34", 128},
    {"\xF1\xB3\x96\x80", "\xB0\x32\xF8\x32", 128},
    {"\xF1\xB3\x98\x80", "\xB0\x33\x87\x30", 128},
    {"\xF1\xB3\x9A\x80", "\xB0\x33\x93\x38", 128},
    {"\xF1\xB3\x9C\x80", "\xB0\x33\xA0\x36", 128},
    {"\xF1\xB3\x9E\x80", "\xB0\x33\xAD\x34", 128},
    {"\xF1\xB3\xA0\x80", "\xB0\x33\xBA\x32", 128},
    {"\xF1\xB3\xA2\x80", "\xB0\x33\xC7\x30", 128},
    {"\xF1\xB3\xA4\x80", "\xB0\x33\xD3\x38", 128},
    {"\xF1\xB3\xA6\x80", "\xB0\x33\xE0\x36", 128},
    {"\xF1\xB3\xA8\x80", "\xB0\x33\xED\x34", 128},
    {"\xF1\xB3\xAA\x80", "\xB0\x33\xFA\x32", 128},
    {"\xF1\xB3\xAC\x80", "\xB0\x34\x89\x30", 128},
    {"\xF1\xB3\xAE\x80", "\xB0\x34\x95\x38", 128},
    {"\xF1\xB3\xB0\x80", "\xB0\x34\xA2\x36", 128},
    {"\xF1\xB3\xB2\x80", "\xB0\x34\xAF\x34", 128},
    {"\xF1\xB3\xB4\x80", "\xB0\x34\xBC\x32", 128},
    {"\xF1\xB3\xB6\x80", "\xB0\x34\xC9\x30", 128},
    {"\xF1\xB3\xB8\x80", "\xB0\x34\xD5\x38", 128},
    {"\xF1\xB3\xBA\x80", "\xB0\x34\xE2\x36", 128},
    {"\xF1\xB3\xBC\x80", "\xB0\x34\xEF\x34", 128},
    {"\xF1\xB3\xBE\x80", "\xB0\x34\xFC\x32", 128},
    {"\xF1\xB4\x80\x80", "\xB0\x35\x8B\x30", 128},
    {"\xF1\xB4\x82\x80", "\xB0\x35\x97\x38", 128},
    {"\xF1\xB4\x84\x80", "\xB0\x35\xA4\x36", 128},
    {"\xF1\xB4\x86\x80", "\xB0\x35\xB1\x34", 128},
    {"\xF1\xB4\x88\x80", "\xB0\x35\xBE\x32", 128},
    {"\xF1\xB4\x8A\x80", "\xB0\x35\xCB\x30", 128},
    {"\xF1\xB4\x8C\x80", "\xB0\x35\xD7\x38", 128},
    {"\xF1\xB4\x8E\x80", "\xB0\x35\xE4\x36", 128},
    {"\xF1\xB4\x90\x80", "\xB0\x35\xF1\x34", 128},
    {"\xF1\xB4\x92\x80", "\xB0\x35\xFE\x32", 128},
    {"\xF1\xB4\x94\x80", "\xB0\x36\x8D\x30", 128},
    {"\xF1\xB4\x96\x80", "\xB0\x36\x99\x38", 128},
    {"\xF1\xB4\x98\x80", "\xB0\x36\xA6\x36", 128},
    {"\xF1\xB4\x9A\x80", "\xB0\x36\xB3\x34", 128},
    {"\xF1\xB4\x9C\x80", "\xB0\x36\xC0\x32", 128},
    {"\xF1\xB4\x9E\x80", "\xB0\x36\xCD\x30", 128},
    {"\xF1\xB4\xA0\x80", "\xB0\x36\xD9\x38", 128},
    {"\xF1\xB4\xA2\x80", "\xB0\x36\xE6\x36", 128},
    {"\xF1\xB4\xA4\x80", "\xB0\x36\xF3\x34", 128},
    {"\xF1\xB4\xA6\x80", "\xB0\x37\x82\x32", 128},
    {"\xF1\xB4\xA8\x80", "\xB0\x37\x8F\x30", 128},
    {"\xF1\xB4\xAA\x80", "\xB0\x37\x9B\x38", 128},
    {"\xF1\xB4\xAC\x80", "\xB0\x37\xA8\x36", 128},
    {"\xF1\xB4\xAE\x80", "\xB0\x37\xB5\x34", 128},
    {"\xF1\xB4\xB0\x80", "\xB0\x37\xC2\x32", 128},
    {"\xF1\xB4\xB2\x80", "\xB0\x37\xCF\x30", 128},
    {"\xF1\xB4\xB4\x80", "\xB0\x37\xDB\x38", 128},
    {"\xF1\xB4\xB6\x80", "\xB0\x37\xE8\x36", 128},
    {"\xF1\xB4\xB8\x80", "\xB0\x37\xF5\x34", 128},
    {"\xF1\xB4\xBA\x80", "\xB0\x38\x84\x32", 128},
    {"\xF1\xB4\xBC\x80", "\xB0\x38\x91\x30", 128},
    {"\xF1\xB4\xBE\x80", "\xB0\x38\x9D\x38", 128},
    {"\xF1\xB5\x80\x80", "\xB0\x38\xAA\x36", 128},
    {"\xF1\xB5\x82\x80", "\xB0\x38\xB7\x34", 128},
    {"\xF1\xB5\x84\x80", "\xB0\x38\xC4\x32", 128},
    {"\xF1\xB5\x86\x80", "\xB0\x38\xD1\x30", 128},
    {"\xF1\xB5\x88\x80", "\xB0\x38\xDD\x38", 128},
    {"\xF1\xB5\x8A\x80", "\xB0\x38\xEA\x36", 128},
    {"\xF1\xB5\x8C\x80", "\xB0\x38\xF7\x34", 128},
    {"\xF1\xB5\x8E\x80", "\xB0\x39\x86\x32", 128},
    {"\xF1\xB5\x90\x80", "\xB0\x39\x93\x30", 128},
    {"\xF1\xB5\x92\x80", "\xB0\x39\x9F\x38", 128},
    {"\xF1\xB5\x94\x80", "\xB0\x39\xAC\x36", 128},
    {"\xF1\xB5\x96\x80", "\xB0\x39\xB9\x34", 128},
    {"\xF1\xB5\x98\x80", "\xB0\x39\xC6\x32", 128},
    {"\xF1\xB5\x9A\x80", "\xB0\x39\xD3\x30", 128},
    {"\xF1\xB5\x9C\x80", "\xB0\x39\xDF\x38", 128},
    {"\xF1\xB5\x9E\x80", "\xB0\x39\xEC\x36", 128},
    {"\xF1\xB5\xA0\x80", "\xB0\x39\xF9\x34", 128},
    {"\xF1\xB5\xA2\x80", "\xB1\x30\x88\x32", 128},
    {"\xF1\xB5\xA4\x80", "\xB1\x30\x95\x30", 128},
    {"\xF1\xB5\xA6\x80", "\xB1\x30\xA1\x38", 128},
    {"\xF1\xB5\xA8\x80", "\xB1\x30\xAE\x36", 128},
    {"\xF1\xB5\xAA\x80", "\xB1\x30\xBB\x34", 128},
    {"\xF1\xB5\xAC\x80", "\xB1\x30\xC8\x32", 128},
    {"\xF1\xB5\xAE\x80", "\xB1\x30\xD5\x30", 128},
    {"\xF1\xB5\xB0\x80", "\xB1\x30\xE1\x38", 128},
    {"\xF1\xB5\xB2\x80", "\xB1\x30\xEE\x36", 128},
    {"\xF1\xB5\xB4\x80", "\xB1\x30\xFB\x34", 128},
    {"\xF1\xB5\xB6\x80", "\xB1\x31\x8A\x32", 128},
    {"\xF1\xB5\xB8\x80", "\xB1\x31\x97\x30", 128},
    {"\xF1\xB5\xBA\x80", "\xB1\x31\xA3\x38", 128},
    {"\xF1\xB5\xBC\x80", "\xB1\x31\xB0\x36", 128},
    {"\xF1\xB5\xBE\x80", "\xB1\x31\xBD\x34", 128},
    {"\xF1\xB6\x80\x80", "\xB1\x31\xCA\x32", 128},
    {"\xF1\xB6\x82\x80", "\xB1\x31\xD7\x30", 128},
    {"\xF1\xB6\x84\x80", "\xB1\x31\xE3\x38", 128},
    {"\xF1\xB6\x86\x80", "\xB1\x31\xF0\x36", 128},
    {"\xF1\xB6\x88\x80", "\xB1\x31\xFD\x34", 128},
    {"\xF1\xB6\x8A\x80", "\xB1\x32\x8C\x32", 128},
    {"\xF1\xB6\x8C\x80", "\xB1\x32\x99\x30", 128},
    {"\xF1\xB6\x8E\x80", "\xB1\x32\xA5\x38", 128},
    {"\xF1\xB6\x90\x80", "\xB1\x32\xB2\x36", 128},
    {"\xF1\xB6\x92\x80", "\xB1\x32\xBF\x34", 128},
    {"\xF1\xB6\x94\x80", "\xB1\x32\xCC\x32", 128},
    {"\xF1\xB6\x96\x80", "\xB1\x32\xD9\x30", 128},
    {"\xF1\xB6\x98\x80", "\xB1\x32\xE5\x38", 128},
    {"\xF1\xB6\x9A\x80", "\xB1\x32\xF2\x36", 128},
    {"\xF1\xB6\x9C\x80", "\xB1\x33\x81\x34", 128},
    {"\xF1\xB6\x9E\x80", "\xB1\x33\x8E\x32", 128},
    {"\xF1\xB6\xA0\x80", "\xB1\x33\x9B\x30", 128},
    {"\xF1\xB6\xA2\x80", "\xB1\x33\xA7\x38", 128},
    {"\xF1\xB6\xA4\x80", "\xB1\x33\xB4\x36", 128},
    {"\xF1\xB6\xA6\x80", "\xB1\x33\xC1\x34", 128},
    {"\xF1\xB6\xA8\x80", "\xB1\x33\xCE\x32", 128},
    {"\xF1\xB6\xAA\x80", "\xB1\x33\xDB\x30", 128},
    {"\xF1\xB6\xAC\x80", "\xB1\x33\xE7\x38", 128},
    {"\xF1\xB6\xAE\x80", "\xB1\x33\xF4\x36", 128},
    {"\xF1\xB6\xB0\x80", "\xB1\x34\x83\x34", 128},
    {"\xF1\xB6\xB2\x80", "\xB1\x34\x90\x32", 128},
    {"\xF1\xB6\xB4\x80", "\xB1\x34\x9D\x30", 128},
    {"\xF1\xB6\xB6\x80", "\xB1\x34\xA9\x38", 128},
    {"\xF1\xB6\xB8\x80", "\xB1\x34\xB6\x36", 128},
    {"\xF1\xB6\xBA\x80", "\xB1\x34\xC3\x34", 128},
    {"\xF1\xB6\xBC\x80", "\xB1\x34\xD0\x32", 128},
    {"\xF1\xB6\xBE\x80", "\xB1\x34\xDD\x30", 128},
    {"\xF1\xB7\x80\x80", "\xB1\x34\xE9\x38", 128},
    {"\xF1\xB7\x82\x80", "\xB1\x34\xF6\x36", 128},
    {"\xF1\xB7\x84\x80", "\xB1\x35\x85\x34", 128},
    {"\xF1\xB7\x86\x80", "\xB1\x35\x92\x32", 128},
    {"\xF1\xB7\x88\x80", "\xB1\x35\x9F\x30", 128},
    {"\xF1\xB7\x8A\x80", "\xB1\x35\xAB\x38", 128},
    {"\xF1\xB7\x8C\x80", "\xB1\x35\xB8\x36", 128},
    {"\xF1\xB7\x8E\x80", "\xB1\x35\xC5\x34", 128},
    {"\xF1\xB7\x90\x80", "\xB1\x35\xD2\x32", 128},
    {"\xF1\xB7\x92\x80", "\xB1\x35\xDF\x30", 128},
    {"\xF1\xB7\x94\x80", "\xB1\x35\xEB\x38", 128},
    {"\xF1\xB7\x96\x80", "\xB1\x35\xF8\x36", 128},
    {"\xF1\xB7\x98\x80", "\xB1\x36\x87\x34", 128},
    {"\xF1\xB7\x9A\x80", "\xB1\x36\x94\x32", 128},
    {"\xF1\xB7\x9C\x80", "\xB1\x36\xA1\x30", 128},
    {"\xF1\xB7\x9E\x80", "\xB1\x36\xAD\x38", 128},
    {"\xF1\xB7\xA0\x80", "\xB1\x36\xBA\x36", 128},
    {"\xF1\xB7\xA2\x80", "\xB1\x36\xC7\x34", 128},
    {"\xF1\xB7\xA4\x80", "\xB1\x36\xD4\x32", 128},
    {"\xF1\xB7\xA6\x80", "\xB1\x36\xE1\x30", 128},
    {"\xF1\xB7\xA8\x80", "\xB1\x36\xED\x38", 128},
    {"\xF1\xB7\xAA\x80", "\xB1\x36\xFA\x36", 128},
    {"\xF1\xB7\xAC\x80", "\xB1\x37\x89\x34", 128},
    {"\xF1\xB7\xAE\x80", "\xB1\x37\x96\x32", 128},
    {"\xF1\xB7\xB0\x80", "\xB1\x37\xA3\x30", 128},
    {"\xF1\xB7\xB2\x80", "\xB1\x37\xAF\x38", 128},
    {"\xF1\xB7\xB4\x80", "\xB1\x37\xBC\x36", 128},
    {"\xF1\xB7\xB6\x80", "\xB1\x37\xC9\x34", 128},
    {"\xF1\xB7\xB8\x80", "\xB1\x37\xD6\x32", 128},
    {"\xF1\xB7\xBA\x80", "\xB1\x37\xE3\x30", 128},
    {"\xF1\xB7\xBC\x80", "\xB1\x37\xEF\x38", 128},
    {"\xF1\xB7\xBE\x80", "\xB1\x37\xFC\x36", 128},
    {"\xF1\xB8\x80\x80", "\xB1\x38\x8B\x34", 128},
    {"\xF1\xB8\x82\x80", "\xB1\x38\x98\x32", 128},
    {"\xF1\xB8\x84\x80", "\xB1\x38\xA5\x30", 128},
    {"\xF1\xB8\x86\x80", "\xB1\x38\xB1\x38", 128},
    {"\xF1\xB8\x88\x80", "\xB1\x38\xBE\x36", 128},
    {"\xF1\xB8\x8A\x80", "\xB1\x38\xCB\x34", 128},
    {"\xF1\xB8\x8C\x80", "\xB1\x38\xD8\x32", 128},
    {"\xF1\xB8\x8E\x80", "\xB1\x38\xE5\x30", 128},
    {"\xF1\xB8\x90\x80", "\xB1\x38\xF1\x38", 128},
    {"\xF1\xB8\x92\x80", "\xB1\x38\xFE\x36", 128},
    {"\xF1\xB8\x94\x80", "\xB1\x39\x8D\x34", 128},
    {"\xF1\xB8\x96\x80", "\xB1\x39\x9A\x32", 128},
    {"\xF1\xB8\x98\x80", "\xB1\x39\xA7\x30", 128},
    {"\xF1\xB8\x9A\x80", "\xB1\x39\xB3\x38", 128},
    {"\xF1\xB8\x9C\x80", "\xB1\x39\xC0\x36", 128},
    {"\xF1\xB8\x9E\x80", "\xB1\x39\xCD\x34", 128},
    {"\xF1\xB8\xA0\x80", "\xB1\x39\xDA\x32", 128},
    {"\xF1\xB8\xA2\x80", "\xB1\x39\xE7\x30", 128},
    {"\xF1\xB8\xA4\x80", "\xB1\x39\xF3\x38", 128},
    {"\xF1\xB8\xA6\x80", "\xB2\x30\x82\x36", 128},
    {"\xF1\xB8\xA8\x80", "\xB2\x30\x8F\x34", 128},
    {"\xF1\xB8\xAA\x80", "\xB2\x30\x9C\x32", 128},
    {"\xF1\xB8\xAC\x80", "\xB2\x30\xA9\x30", 128},
    {"\xF1\xB8\xAE\x80", "\xB2\x30\xB5\x38", 128},
    {"\xF1\xB8\xB0\x80", "\xB2\x30\xC2\x36", 128},
    {"\xF1\xB8\xB2\x80", "\xB2\x30\xCF\x34", 128},
    {"\xF1\xB8\xB4\x80", "\xB2\x30\xDC\x32", 128},
    {"\xF1\xB8\xB6\x80", "\xB2\x30\xE9\x30", 128},
    {"\xF1\xB8\xB8\x80", "\xB2\x30\xF5\x38", 128},
    {"\xF1\xB8\xBA\x80", "\xB2\x31\x84\x36", 128},
    {"\xF1\xB8\xBC\x80", "\xB2\x31\x91\x34", 128},
    {"\xF1\xB8\xBE\x80", "\xB2\x31\x9E\x32", 128},
    {"\xF1\xB9\x80\x80", "\xB2\x31\xAB\x30", 128},
    {"\xF1\xB9\x82\x80", "\xB2\x31\xB7\x38", 128},
    {"\xF1\xB9\x84\x80", "\xB2\x31\xC4\x36", 128},
    {"\xF1\xB9\x86\x80", "\xB2\x31\xD1\x34", 128},
    {"\xF1\xB9\x88\x80", "\xB2\x31\xDE\x32", 128},
    {"\xF1\xB9\x8A\x80", "\xB2\x31\xEB\x30", 128},
    {"\xF1\xB9\x8C\x80", "\xB2\x31\xF7\x38", 128},
    {"\xF1\xB9\x8E\x80", "\xB2\x32\x86\x36", 128},
    {"\xF1\xB9\x90\x80", "\xB2\x32\x93\x34", 128},
    {"\xF1\xB9\x92\x80", "\xB2\x32\xA0\x32", 128},
    {"\xF1\xB9\x94\x80", "\xB2\x32\xAD\x30", 128},
    {"\xF1\xB9\x96\x80", "\xB2\x32\xB9\x38", 128},
    {"\xF1\xB9\x98\x80", "\xB2\x32\xC6\x36", 128},
    {"\xF1\xB9\x9A\x80", "\xB2\x32\xD3\x34", 128},
    {"\xF1\xB9\x9C\x80", "\xB2\x32\xE0\x32", 128},
    {"\xF1\xB9\x9E\x80", "\xB2\x32\xED\x30", 128},
    {"\xF1\xB9\xA0\x80", "\xB2\x32\xF9\x38", 128},
    {"\xF1\xB9\xA2\x80", "\xB2\x33\x88\x36", 128},
    {"\xF1\xB9\xA4\x80", "\xB2\x33\x95\x34", 128},
    {"\xF1\xB9\xA6\x80", "\xB2\x33\xA2\x32", 128},
    {"\xF1\xB9\xA8\x80", "\xB2\x33\xAF\x30", 128},
    {"\xF1\xB9\xAA\x80", "\xB2\x33\xBB\x38", 128},
    {"\xF1\xB9\xAC\x80", "\xB2\x33\xC8\x36", 128},
    {"\xF1\xB9\xAE\x80", "\xB2\x33\xD5\x34", 128},
    {"\xF1\xB9\xB0\x80", "\xB2\x33\xE2\x32", 128},
    {"\xF1\xB9\xB2\x80", "\xB2\x33\xEF\x30", 128},
    {"\xF1\xB9\xB4\x80", "\xB2\x33\xFB\x38", 128},
    {"\xF1\xB9\xB6\x80", "\xB2\x34\x8A\x36", 128},
    {"\xF1\xB9\xB8\x80", "\xB2\x34\x97\x34", 128},
    {"\xF1\xB9\xBA\x80", "\xB2\x34\xA4\x32", 128},
    {"\xF1\xB9\xBC\x80", "\xB2\x34\xB1\x30", 128},
    {"\xF1\xB9\xBE\x80", "\xB2\x34\xBD\x38", 128},
    {"\xF1\xBA\x80\x80", "\xB2\x34\xCA\x36", 128},
    {"\xF1\xBA\x82\x80", "\xB2\x34\xD7\x34", 128},
    {"\xF1\xBA\x84\x80", "\xB2\x34\xE4\x32", 128},
    {"\xF1\xBA\x86\x80", "\xB2\x34\xF1\x30", 128},
    {"\xF1\xBA\x88\x80", "\xB2\x34\xFD\x38", 128},
    {"\xF1\xBA\x8A\x80", "\xB2\x35\x8C\x36", 128},
    {"\xF1\xBA\x8C\x80", "\xB2\x35\x99\x34", 128},
    {"\xF1\xBA\x8E\x80", "\xB2\x35\xA6\x32", 128},
    {"\xF1\xBA\x90\x80", "\xB2\x35\xB3\x30", 128},
    {"\xF1\xBA\x92\x80", "\xB2\x35\xBF\x38", 128},
    {"\xF1\xBA\x94\x80", "\xB2\x35\xCC\x36", 128},
    {"\xF1\xBA\x96\x80", "\xB2\x35\xD9\x34", 128},
    {"\xF1\xBA\x98\x80", "\xB2\x35\xE6\x32", 128},
    {"\xF1\xBA\x9A\x80", "\xB2\x35\xF3\x30", 128},
    {"\xF1\xBA\x9C\x80", "\xB2\x36\x81\x38", 128},
    {"\xF1\xBA\x9E\x80", "\xB2\x36\x8E\x36", 128},
    {"\xF1\xBA\xA0\x80", "\xB2\x36\x9B\x34", 128},
    {"\xF1\xBA\xA2\x80", "\xB2\x36\xA8\x32", 128},
    {"\xF1\xBA\xA4\x80", "\xB2\x36\xB5\x30", 128},
    {"\xF1\xBA\xA6\x80", "\xB2\x36\xC1\x38", 128},
    {"\xF1\xBA\xA8\x80", "\xB2\x36\xCE\x36", 128},
    {"\xF1\xBA\xAA\x80", "\xB2\x36\xDB\x34", 128},
    {"\xF1\xBA\xAC\x80", "\xB2\x36\xE8\x32", 128},
    {"\xF1\xBA\xAE\x80", "\xB2\x36\xF5\x30", 128},
    {"\xF1\xBA\xB0\x80", "\xB2\x37\x83\x38", 128},
    {"\xF1\xBA\xB2\x80", "\xB2\x37\x90\x36", 128},
    {"\xF1\xBA\xB4\x80", "\xB2\x37\x9D\x34", 128},
    {"\xF1\xBA\xB6\x80", "\xB2\x37\xAA\x32", 128},
    {"\xF1\xBA\xB8\x80", "\xB2\x37\xB7\x30", 128},
    {"\xF1\xBA\xBA\x80", "\xB2\x37\xC3\x38", 128},
    {"\xF1\xBA\xBC\x80", "\xB2\x37\xD0\x36", 128},
    {"\xF1\xBA\xBE\x80", "\xB2\x37\xDD\x34", 128},
    {"\xF1\xBB\x80\x80", "\xB2\x37\xEA\x32", 128},
    {"\xF1\xBB\x82\x80", "\xB2\x37\xF7\x30", 128},
    {"\xF1\xBB\x84\x80", "\xB2\x38\x85\x38", 128},
    {"\xF1\xBB\x86\x80", "\xB2\x38\x92\x36", 128},
    {"\xF1\xBB\x88\x80", "\xB2\x38\x9F\x34", 128},
    {"\xF1\xBB\x8A\x80", "\xB2\x38\xAC\x32", 128},
    {"\xF1\xBB\x8C\x80", "\xB2\x38\xB9\x30", 128},
    {"\xF1\xBB\x8E\x80", "\xB2\x38\xC5\x38", 128},
    {"\xF1\xBB\x90\x80", "\xB2\x38\xD2\x36", 128},
    {"\xF1\xBB\x92\x80", "\xB2\x38\xDF\x34", 128},
    {"\xF1\xBB\x94\x80", "\xB2\x38\xEC\x32", 128},
    {"\xF1\xBB\x96\x80", "\xB2\x38\xF9\x30", 128},
    {"\xF1\xBB\x98\x80", "\xB2\x39\x87\x38", 128},
    {"\xF1\xBB\x9A\x80", "\xB2\x39\x94\x36", 128},
    {"\xF1\xBB\x9C\x80", "\xB2\x39\xA1\x34", 128},
    {"\xF1\xBB\x9E\x80", "\xB2\x39\xAE\x32", 128},
    {"\xF1\xBB\xA0\x80", "\xB2\x39\xBB\x30", 128},
    {"\xF1\xBB\xA2\x80", "\xB2\x39\xC7\x38", 128},
    {"\xF1\xBB\xA4\x80", "\xB2\x39\xD4\x36", 128},
    {"\xF1\xBB\xA6\x80", "\xB2\x39\xE1\x34", 128},
    {"\xF1\xBB\xA8\x80", "\xB2\x39\xEE\x32", 128},
    {"\xF1\xBB\xAA\x80", "\xB2\x39\xFB\x30", 128},
    {"\xF1\xBB\xAC\x80", "\xB3\x30\x89\x38", 128},
    {"\xF1\xBB\xAE\x80", "\xB3\x30\x96\x36", 128},
    {"\xF1\xBB\xB0\x80", "\xB3\x30\xA3\x34", 128},
    {"\xF1\xBB\xB2\x80", "\xB3\x30\xB0\x32", 128},
    {"\xF1\xBB\xB4\x80", "\xB3\x30\xBD\x30", 128},
    {"\xF1\xBB\xB6\x80", "\xB3\x30\xC9\x38", 128},
    {"\xF1\xBB\xB8\x80", "\xB3\x30\xD6\x36", 128},
    {"\xF1\xBB\xBA\x80", "\xB3\x30\xE3\x34", 128},
    {"\xF1\xBB\xBC\x80", "\xB3\x30\xF0\x32", 128},
    {"\xF1\xBB\xBE\x80", "\xB3\x30\xFD\x30", 128},
    {"\xF1\xBC\x80\x80", "\xB3\x31\x8B\x38", 128},
    {"\xF1\xBC\x82\x80", "\xB3\x31\x98\x36", 128},
    {"\xF1\xBC\x84\x80", "\xB3\x31\xA5\x34", 128},
    {"\xF1\xBC\x86\x80", "\xB3\x31\xB2\x32", 128},
    {"\xF1\xBC\x88\x80", "\xB3\x31\xBF\x30", 128},
    {"\xF1\xBC\x8A\x80", "\xB3\x31\xCB\x38", 128},
    {"\xF1\xBC\x8C\x80", "\xB3\x31\xD8\x36", 128},
    {"\xF1\xBC\x8E\x80", "\xB3\x31\xE5\x34", 128},
    {"\xF1\xBC\x90\x80", "\xB3\x31\xF2\x32", 128},
    {"\xF1\xBC\x92\x80", "\xB3\x32\x81\x30", 128},
    {"\xF1\xBC\x94\x80", "\xB3\x32\x8D\x38", 128},
    {"\xF1\xBC\x96\x80", "\xB3\x32\x9A\x36", 128},
    {"\xF1\xBC\x98\x80", "\xB3\x32\xA7\x34", 128},
    {"\xF1\xBC\x9A\x80", "\xB3\x32\xB4\x32", 128},
    {"\xF1\xBC\x9C\x80", "\xB3\x32\xC1\x30", 128},
    {"\xF1\xBC\x9E\x80", "\xB3\x32\xCD\x38", 128},
    {"\xF1\xBC\xA0\x80", "\xB3\x32\xDA\x36", 128},
    {"\xF1\xBC\xA2\x80", "\xB3\x32\xE7\x34", 128},
    {"\xF1\xBC\xA4\x80", "\xB3\x32\xF4\x32", 128},
    {"\xF1\xBC\xA6\x80", "\xB3\x33\x83\x30", 128},
    {"\xF1\xBC\xA8\x80", "\xB3\x33\x8F\x38", 128},
    {"\xF1\xBC\xAA\x80", "\xB3\x33\x9C\x36", 128},
    {"\xF1\xBC\xAC\x80", "\xB3\x33\xA9\x34", 128},
    {"\xF1\xBC\xAE\x80", "\xB3\x33\xB6\x32", 128},
    {"\xF1\xBC\xB0\x80", "\xB3\x33\xC3\x30", 128},
    {"\xF1\xBC\xB2\x80", "\xB3\x33\xCF\x38", 128},
    {"\xF1\xBC\xB4\x80", "\xB3\x33\xDC\x36", 128},
    {"\xF1\xBC\xB6\x80", "\xB3\x33\xE9\x34", 128},
    {"\xF1\xBC\xB8\x80", "\xB3\x33\xF6\x32", 128},
    {"\xF1\xBC\xBA\x80", "\xB3\x34\x85\x30", 128},
    {"\xF1\xBC\xBC\x80", "\xB3\x34\x91\x38", 128},
    {"\xF1\xBC\xBE\x80", "\xB3\x34\x9E\x36", 128},
    {"\xF1\xBD\x80\x80", "\xB3\x34\xAB\x34", 128},
    {"\xF1\xBD\x82\x80", "\xB3\x34\xB8\x32", 128},
    {"\xF1\xBD\x84\x80", "\xB3\x34\xC5\x30", 128},
    {"\xF1\xBD\x86\x80", "\xB3\x34\xD1\x38", 128},
    {"\xF1\xBD\x88\x80", "\xB3\x34\xDE\x36", 128},
    {"\xF1\xBD\x8A\x80", "\xB3\x34\xEB\x34", 128},
    {"\xF1\xBD\x8C\x80", "\xB3\x34\xF8\x32", 128},
    {"\xF1\xBD\x8E\x80", "\xB3\x35\x87\x30", 128},
    {"\xF1\xBD\x90\x80", "\xB3\x35\x93\x38", 128},
    {"\xF1\xBD\x92\x80", "\xB3\x35\xA0\x36", 128},
    {"\xF1\xBD\x94\x80", "\xB3\x35\xAD\x34", 128},
    {"\xF1\xBD\x96\x80", "\xB3\x35\xBA\x32", 128},
    {"\xF1\xBD\x98\x80", "\xB3\x35\xC7\x30", 128},
    {"\xF1\xBD\x9A\x80", "\xB3\x35\xD3\x38", 128},
    {"\xF1\xBD\x9C\x80", "\xB3\x35\xE0\x36", 128},
    {"\xF1\xBD\x9E\x80", "\xB3\x35\xED\x34", 128},
    {"\xF1\xBD\xA0\x80", "\xB3\x35\xFA\x32", 128},
    {"\xF1\xBD\xA2\x80", "\xB3\x36\x89\x30", 128},
    {"\xF1\xBD\xA4\x80", "\xB3\x36\x95\x38", 128},
    {"\xF1\xBD\xA6\x80", "\xB3\x36\xA2\x36", 128},
    {"\xF1\xBD\xA8\x80", "\xB3\x36\xAF\x34", 128},
    {"\xF1\xBD\xAA\x80", "\xB3\x36\xBC\x32", 128},
    {"\xF1\xBD\xAC\x80", "\xB3\x36\xC9\x30", 128},
    {"\xF1\xBD\xAE\x80", "\xB3\x36\xD5\x38", 128},
    {"\xF1\xBD\xB0\x80", "\xB3\x36\xE2\x36", 128},
    {"\xF1\xBD\xB2\x80", "\xB3\x36\xEF\x34", 128},
    {"\xF1\xBD\xB4\x80", "\xB3\x36\xFC\x32", 128},
    {"\xF1\xBD\xB6\x80", "\xB3\x37\x8B\x30", 128},
    {"\xF1\xBD\xB8\x80", "\xB3\x37\x97\x38", 128},
    {"\xF1\xBD\xBA\x80", "\xB3\x37\xA4\x36", 128},
    {"\xF1\xBD\xBC\x80", "\xB3\x37\xB1\x34", 128},
    {"\xF1\xBD\xBE\x80", "\xB3\x37\xBE\x32", 128},
    {"\xF1\xBE\x80\x80", "\xB3\x37\xCB\x30", 128},
    {"\xF1\xBE\x82\x80", "\xB3\x37\xD7\x38", 128},
    {"\xF1\xBE\x84\x80", "\xB3\x37\xE4\x36", 128},
    {"\xF1\xBE\x86\x80", "\xB3\x37\xF1\x34", 128},
    {"\xF1\xBE\x88\x80", "\xB3\x37\xFE\x32", 128},
    {"\xF1\xBE\x8A\x80", "\xB3\x38\x8D\x30", 128},
    {"\xF1\xBE\x8C\x80", "\xB3\x38\x99\x38", 128},
    {"\xF1\xBE\x8E\x80", "\xB3\x38\xA6\x36", 128},
    {"\xF1\xBE\x90\x80", "\xB3\x38\xB3\x34", 128},
    {"\xF1\xBE\x92\x80", "\xB3\x38\xC0\x32", 128},
    {"\xF1\xBE\x94\x80", "\xB3\x38\xCD\x30", 128},
    {"\xF1\xBE\x96\x80", "\xB3\x38\xD9\x38", 128},
    {"\xF1\xBE\x98\x80", "\xB3\x38\xE6\x36", 128},
    {"\xF1\xBE\x9A\x80", "\xB3\x38\xF3\x34", 128},
    {"\xF1\xBE\x9C\x80", "\xB3\x39\x82\x32", 128},
    {"\xF1\xBE\x9E\x80", "\xB3\x39\x8F\x30", 128},
    {"\xF1\xBE\xA0\x80", "\xB3\x39\x9B\x38", 128},
    {"\xF1\xBE\xA2\x80", "\xB3\x39\xA8\x36", 128},
    {"\xF1\xBE\xA4\x80", "\xB3\x39\xB5\x34", 128},
    {"\xF1\xBE\xA6\x80", "\xB3\x39\xC2\x32", 128},
    {"\xF1\xBE\xA8\x80", "\xB3\x39\xCF\x30", 128},
    {"\xF1\xBE\xAA\x80", "\xB3\x39\xDB\x38", 128},
    {"\xF1\xBE\xAC\x80", "\xB3\x39\xE8\x36", 128},
    {"\xF1\xBE\xAE\x80", "\xB3\x39\xF5\x34", 128},
    {"\xF1\xBE\xB0\x80", "\xB4\x30\x84\x32", 128},
    {"\xF1\xBE\xB2\x80", "\xB4\x30\x91\x30", 128},
    {"\xF1\xBE\xB4\x80", "\xB4\x30\x9D\x38", 128},
    {"\xF1\xBE\xB6\x80", "\xB4\x30\xAA\x36", 128},
    {"\xF1\xBE\xB8\x80", "\xB4\x30\xB7\x34", 128},
    {"\xF1\xBE\xBA\x80", "\xB4\x30\xC4\x32", 128},
    {"\xF1\xBE\xBC\x80", "\xB4\x30\xD1\x30", 128},
    {"\xF1\xBE\xBE\x80", "\xB4\x30\xDD\x38", 128},
    {"\xF1\xBF\x80\x80", "\xB4\x30\xEA\x36", 128},
    {"\xF1\xBF\x82\x80", "\xB4\x30\xF7\x34", 128},
    {"\xF1\xBF\x84\x80", "\xB4\x31\x86\x32", 128},
    {"\xF1\xBF\x86\x80", "\xB4\x31\x93\x30", 128},
    {"\xF1\xBF\x88\x80", "\xB4\x31\x9F\x38", 128},
    {"\xF1\xBF\x8A\x80", "\xB4\x31\xAC\x36", 128},
    {"\xF1\xBF\x8C\x80", "\xB4\x31\xB9\x34", 128},
    {"\xF1\xBF\x8E\x80", "\xB4\x31\xC6\x32", 128},
    {"\xF1\xBF\x90\x80", "\xB4\x31\xD3\x30", 128},
    {"\xF1\xBF\x92\x80", "\xB4\x31\xDF\x38", 128},
    {"\xF1\xBF\x94\x80", "\xB4\x31\xEC\x36", 128},
    {"\xF1\xBF\x96\x80", "\xB4\x31\xF9\x34", 128},
    {"\xF1\xBF\x98\x80", "\xB4\x32\x88\x32", 128},
    {"\xF1\xBF\x9A\x80", "\xB4\x32\x95\x30", 128},
    {"\xF1\xBF\x9C\x80", "\xB4\x32\xA1\x38", 128},
    {"\xF1\xBF\x9E\x80", "\xB4\x32\xAE\x36", 128},
    {"\xF1\xBF\xA0\x80", "\xB4\x32\xBB\x34", 128},
    {"\xF1\xBF\xA2\x80", "\xB4\x32\xC8\x32", 128},
    {"\xF1\xBF\xA4\x80", "\xB4\x32\xD5\x30", 128},
    {"\xF1\xBF\xA6\x80", "\xB4\x32\xE1\x38", 128},
    {"\xF1\xBF\xA8\x80", "\xB4\x32\xEE\x36", 128},
    {"\xF1\xBF\xAA\x80", "\xB4\x32\xFB\x34", 128},
    {"\xF1\xBF\xAC\x80", "\xB4\x33\x8A\x32", 128},
    {"\xF1\xBF\xAE\x80", "\xB4\x33\x97\x30", 128},
    {"\xF1\xBF\xB0\x80", "\xB4\x33\xA3\x38", 128},
    {"\xF1\xBF\xB2\x80", "\xB4\x33\xB0\x36", 128},
    {"\xF1\xBF\xB4\x80", "\xB4\x33\xBD\x34", 128},
    {"\xF1\xBF\xB6\x80", "\xB4\x33\xCA\x32", 128},
    {"\xF1\xBF\xB8\x80", "\xB4\x33\xD7\x30", 128},
    {"\xF1\xBF\xBA\x80", "\xB4\x33\xE3\x38", 128},
    {"\xF1\xBF\xBC\x80", "\xB4\x33\xF0\x36", 128},
    {"\xF1\xBF\xBE\x80", "\xB4\x33\xFD\x34", 128},
    {"\xF2\x80\x80\x80", "\xB4\x34\x8C\x32", 128},
    {"\xF2\x80\x82\x80", "\xB4\x34\x99\x30", 128},
    {"\xF2\x80\x84\x80", "\xB4\x34\xA5\x38", 128},
    {"\xF2\x80\x86\x80", "\xB4\x34\xB2\x36", 128},
    {"\xF2\x80\x88\x80", "\xB4\x34\xBF\x34", 128},
    {"\xF2\x80\x8A\x80", "\xB4\x34\xCC\x32", 128},
    {"\xF2\x80\x8C\x80", "\xB4\x34\xD9\x30", 128},
    {"\xF2\x80\x8E\x80", "\xB4\x34\xE5\x38", 128},
    {"\xF2\x80\x90\x80", "\xB4\x34\xF2\x36", 128},
    {"\xF2\x80\x92\x80", "\xB4\x35\x81\x34", 128},
    {"\xF2\x80\x94\x80", "\xB4\x35\x8E\x32", 128},
    {"\xF2\x80\x96\x80", "\xB4\x35\x9B\x30", 128},
    {"\xF2\x80\x98\x80", "\xB4\x35\xA7\x38", 128},
    {"\xF2\x80\x9A\x80", "\xB4\x35\xB4\x36", 128},
    {"\xF2\x80\x9C\x80", "\xB4\x35\xC1\x34", 128},
    {"\xF2\x80\x9E\x80", "\xB4\x35\xCE\x32", 128},
    {"\xF2\x80\xA0\x80", "\xB4\x35\xDB\x30", 128},
    {"\xF2\x80\xA2\x80", "\xB4\x35\xE7\x38", 128},
    {"\xF2\x80\xA4\x80", "\xB4\x35\xF4\x36", 128},
    {"\xF2\x80\xA6\x80", "\xB4\x36\x83\x34", 128},
    {"\xF2\x80\xA8\x80", "\xB4\x36\x90\x32", 128},
    {"\xF2\x80\xAA\x80", "\xB4\x36\x9D\x30", 128},
    {"\xF2\x80\xAC\x80", "\xB4\x36\xA9\x38", 128},
    {"\xF2\x80\xAE\x80", "\xB4\x36\xB6\x36", 128},
    {"\xF2\x80\xB0\x80", "\xB4\x36\xC3\x34", 128},
    {"\xF2\x80\xB2\x80", "\xB4\x36\xD0\x32", 128},
    {"\xF2\x80\xB4\x80", "\xB4\x36\xDD\x30", 128},
    {"\xF2\x80\xB6\x80", "\xB4\x36\xE9\x38", 128},
    {"\xF2\x80\xB8\x80", "\xB4\x36\xF6\x36", 128},
    {"\xF2\x80\xBA\x80", "\xB4\x37\x85\x34", 128},
    {"\xF2\x80\xBC\x80", "\xB4\x37\x92\x32", 128},
    {"\xF2\x80\xBE\x80", "\xB4\x37\x9F\x30", 128},
    {"\xF2\x81\x80\x80", "\xB4\x37\xAB\x38", 128},
    {"\xF2\x81\x82\x80", "\xB4\x37\xB8\x36", 128},
    {"\xF2\x81\x84\x80", "\xB4\x37\xC5\x34", 128},
    {"\xF2\x81\x86\x80", "\xB4\x37\xD2\x32", 128},
    {"\xF2\x81\x88\x80", "\xB4\x37\xDF\x30", 128},
    {"\xF2\x81\x8A\x80", "\xB4\x37\xEB\x38", 128},
    {"\xF2\x81\x8C\x80", "\xB4\x37\xF8\x36", 128},
    {"\xF2\x81\x8E\x80", "\xB4\x38\x87\x34", 128},
    {"\xF2\x81\x90\x80", "\xB4\x38\x94\x32", 128},
    {"\xF2\x81\x92\x80", "\xB4\x38\xA1\x30", 128},
    {"\xF2\x81\x94\x80", "\xB4\x38\xAD\x38", 128},
    {"\xF2\x81\x96\x80", "\xB4\x38\xBA\x36", 128},
    {"\xF2\x81\x98\x80", "\xB4\x38\xC7\x34", 128},
    {"\xF2\x81\x9A\x80", "\xB4\x38\xD4\x32", 128},
    {"\xF2\x81\x9C\x80", "\xB4\x38\xE1\x30", 128},
    {"\xF2\x81\x9E\x80", "\xB4\x38\xED\x38", 128},
    {"\xF2\x81\xA0\x80", "\xB4\x38\xFA\x36", 128},
    {"\xF2\x81\xA2\x80", "\xB4\x39\x89\x34", 128},
    {"\xF2\x81\xA4\x80", "\xB4\x39\x96\x32", 128},
    {"\xF2\x81\xA6\x80", "\xB4\x39\xA3\x30", 128},
    {"\xF2\x81\xA8\x80", "\xB4\x39\xAF\x38", 128},
    {"\xF2\x81\xAA\x80", "\xB4\x39\xBC\x36", 128},
    {"\xF2\x81\xAC\x80", "\xB4\x39\xC9\x34", 128},
    {"\xF2\x81\xAE\x80", "\xB4\x39\xD6\x32", 128},
    {"\xF2\x81\xB0\x80", "\xB4\x39\xE3\x30", 128},
    {"\xF2\x81\xB2\x80", "\xB4\x39\xEF\x38", 128},
    {"\xF2\x81\xB4\x80", "\xB4\x39\xFC\x36", 128},
    {"\xF2\x81\xB6\x80", "\xB5\x30\x8B\x34", 128},
    {"\xF2\x81\xB8\x80", "\xB5\x30\x98\x32", 128},
    {"\xF2\x81\xBA\x80", "\xB5\x30\xA5\x30", 128},
    {"\xF2\x81\xBC\x80", "\xB5\x30\xB1\x38", 128},
    {"\xF2\x81\xBE\x80", "\xB5\x30\xBE\x36", 128},
    {"\xF2\x82\x80\x80", "\xB5\x30\xCB\x34", 128},
    {"\xF2\x82\x82\x80", "\xB5\x30\xD8\x32", 128},
    {"\xF2\x82\x84\x80", "\xB5\x30\xE5\x30", 128},
    {"\xF2\x82\x86\x80", "\xB5\x30\xF1\x38", 128},
    {"\xF2\x82\x88\x80", "\xB5\x30\xFE\x36", 128},
    {"\xF2\x82\x8A\x80", "\xB5\x31\x8D\x34", 128},
    {"\xF2\x82\x8C\x80", "\xB5\x31\x9A\x32", 128},
    {"\xF2\x82\x8E\x80", "\xB5\x31\xA7\x30", 128},
    {"\xF2\x82\x90\x80", "\xB5\x31\xB3\x38", 128},
    {"\xF2\x82\x92\x80", "\xB5\x31\xC0\x36", 128},
    {"\xF2\x82\x94\x80", "\xB5\x31\xCD\x34", 128},
    {"\xF2\x82\x96\x80", "\xB5\x31\xDA\x32", 128},
    {"\xF2\x82\x98\x80", "\xB5\x31\xE7\x30", 128},
    {"\xF2\x82\x9A\x80", "\xB5\x31\xF3\x38", 128},
    {"\xF2\x82\x9C\x80", "\xB5\x32\x82\x36", 128},
    {"\xF2\x82\x9E\x80", "\xB5\x32\x8F\x34", 128},
    {"\xF2\x82\xA0\x80", "\xB5\x32\x9C\x32", 128},
    {"\xF2\x82\xA2\x80", "\xB5\x32\xA9\x30", 128},
    {"\xF2\x82\xA4\x80", "\xB5\x32\xB5\x38", 128},
    {"\xF2\x82\xA6\x80", "\xB5\x32\xC2\x36", 128},
    {"\xF2\x82\xA8\x80", "\xB5\x32\xCF\x34", 128},
    {"\xF2\x82\xAA\x80", "\xB5\x32\xDC\x32", 128},
    {"\xF2\x82\xAC\x80", "\xB5\x32\xE9\x30", 128},
    {"\xF2\x82\xAE\x80", "\xB5\x32\xF5\x38", 128},
    {"\xF2\x82\xB0\x80", "\xB5\x33\x84\x36", 128},
    {"\xF2\x82\xB2\x80", "\xB5\x33\x91\x34", 128},
    {"\xF2\x82\xB4\x80", "\xB5\x33\x9E\x32", 128},
    {"\xF2\x82\xB6\x80", "\xB5\x33\xAB\x30", 128},
    {"\xF2\x82\xB8\x80", "\xB5\x33\xB7\x38", 128},
    {"\xF2\x82\xBA\x80", "\xB5\x33\xC4\x36", 128},
    {"\xF2\x82\xBC\x80", "\xB5\x33\xD1\x34", 128},
    {"\xF2\x82\xBE\x80", "\xB5\x33\xDE\x32", 128},
    {"\xF2\x83\x80\x80", "\xB5\x33\xEB\x30", 128},
    {"\xF2\x83\x82\x80", "\xB5\x33\xF7\x38", 128},
    {"\xF2\x83\x84\x80", "\xB5\x34\x86\x36", 128},
    {"\xF2\x83\x86\x80", "\xB5\x34\x93\x34", 128},
    {"\xF2\x83\x88\x80", "\xB5\x34\xA0\x32", 128},
    {"\xF2\x83\x8A\x80", "\xB5\x34\xAD\x30", 128},
    {"\xF2\x83\x8C\x80", "\xB5\x34\xB9\x38", 128},
    {"\xF2\x83\x8E\x80", "\xB5\x34\xC6\x36", 128},
    {"\xF2\x83\x90\x80", "\xB5\x34\xD3\x34", 128},
    {"\xF2\x83\x92\x80", "\xB5\x34\xE0\x32", 128},
    {"\xF2\x83\x94\x80", "\xB5\x34\xED\x30", 128},
    {"\xF2\x83\x96\x80", "\xB5\x34\xF9\x38", 128},
    {"\xF2\x83\x98\x80", "\xB5\x35\x88\x36", 128},
    {"\xF2\x83\x9A\x80", "\xB5\x35\x95\x34", 128},
    {"\xF2\x83\x9C\x80", "\xB5\x35\xA2\x32", 128},
    {"\xF2\x83\x9E\x80", "\xB5\x35\xAF\x30", 128},
    {"\xF2\x83\xA0\x80", "\xB5\x35\xBB\x38", 128},
    {"\xF2\x83\xA2\x80", "\xB5\x35\xC8\x36", 128},
    {"\xF2\x83\xA4\x80", "\xB5\x35\xD5\x34", 128},
    {"\xF2\x83\xA6\x80", "\xB5\x35\xE2\x32", 128},
    {"\xF2\x83\xA8\x80", "\xB5\x35\xEF\x30", 128},
    {"\xF2\x83\xAA\x80", "\xB5\x35\xFB\x38", 128},
    {"\xF2\x83\xAC\x80", "\xB5\x36\x8A\x36", 128},
    {"\xF2\x83\xAE\x80", "\xB5\x36\x97\x34", 128},
    {"\xF2\x83\xB0\x80", "\xB5\x36\xA4\x32", 128},
    {"\xF2\x83\xB2\x80", "\xB5\x36\xB1\x30", 128},
    {"\xF2\x83\xB4\x80", "\xB5\x36\xBD\x38", 128},
    {"\xF2\x83\xB6\x80", "\xB5\x36\xCA\x36", 128},
    {"\xF2\x83\xB8\x80", "\xB5\x36\xD7\x34", 128},
    {"\xF2\x83\xBA\x80", "\xB5\x36\xE4\x32", 128},
    {"\xF2\x83\xBC\x80", "\xB5\x36\xF1\x30", 128},
    {"\xF2\x83\xBE\x80", "\xB5\x36\xFD\x38", 128},
    {"\xF2\x84\x80\x80", "\xB5\x37\x8C\x36", 128},
    {"\xF2\x84\x82\x80", "\xB5\x37\x99\x34", 128},
    {"\xF2\x84\x84\x80", "\xB5\x37\xA6\x32", 128},
    {"\xF2\x84\x86\x80", "\xB5\x37\xB3\x30", 128},
    {"\xF2\x84\x88\x80", "\xB5\x37\xBF\x38", 128},
    {"\xF2\x84\x8A\x80", "\xB5\x37\xCC\x36", 128},
    {"\xF2\x84\x8C\x80", "\xB5\x37\xD9\x34", 128},
    {"\xF2\x84\x8E\x80", "\xB5\x37\xE6\x32", 128},
    {"\xF2\x84\x90\x80", "\xB5\x37\xF3\x30", 128},
    {"\xF2\x84\x92\x80", "\xB5\x38\x81\x38", 128},
    {"\xF2\x84\x94\x80", "\xB5\x38\x8E\x36", 128},
    {"\xF2\x84\x96\x80", "\xB5\x38\x9B\x34", 128},
    {"\xF2\x84\x98\x80", "\xB5\x38\xA8\x32", 128},
    {"\xF2\x84\x9A\x80", "\xB5\x38\xB5\x30", 128},
    {"\xF2\x84\x9C\x80", "\xB5\x38\xC1\x38", 128},
    {"\xF2\x84\x9E\x80", "\xB5\x38\xCE\x36", 128},
    {"\xF2\x84\xA0\x80", "\xB5\x38\xDB\x34", 128},
    {"\xF2\x84\xA2\x80", "\xB5\x38\xE8\x32", 128},
    {"\xF2\x84\xA4\x80", "\xB5\x38\xF5\x30", 128},
    {"\xF2\x84\xA6\x80", "\xB5\x39\x83\x38", 128},
    {"\xF2\x84\xA8\x80", "\xB5\x39\x90\x36", 128},
    {"\xF2\x84\xAA\x80", "\xB5\x39\x9D\x34", 128},
    {"\xF2\x84\xAC\x80", "\xB5\x39\xAA\x32", 128},
    {"\xF2\x84\xAE\x80", "\xB5\x39\xB7\x30", 128},
    {"\xF2\x84\xB0\x80", "\xB5\x39\xC3\x38", 128},
    {"\xF2\x84\xB2\x80", "\xB5\x39\xD0\x36", 128},
    {"\xF2\x84\xB4\x80", "\xB5\x39\xDD\x34", 128},
    {"\xF2\x84\xB6\x80", "\xB5\x39\xEA\x32", 128},
    {"\xF2\x84\xB8\x80", "\xB5\x39\xF7\x30", 128},
    {"\xF2\x84\xBA\x80", "\xB6\x30\x85\x38", 128},
    {"\xF2\x84\xBC\x80", "\xB6\x30\x92\x36", 128},
    {"\xF2\x84\xBE\x80", "\xB6\x30\x9F\x34", 128},
    {"\xF2\x85\x80\x80", "\xB6\x30\xAC\x32", 128},
    {"\xF2\x85\x82\x80", "\xB6\x30\xB9\x30", 128},
    {"\xF2\x85\x84\x80", "\xB6\x30\xC5\x38", 128},
    {"\xF2\x85\x86\x80", "\xB6\x30\xD2\x36", 128},
    {"\xF2\x85\x88\x80", "\xB6\x30\xDF\x34", 128},
    {"\xF2\x85\x8A\x80", "\xB6\x30\xEC\x32", 128},
    {"\xF2\x85\x8C\x80", "\xB6\x30\xF9\x30", 128},
    {"\xF2\x85\x8E\x80", "\xB6\x31\x87\x38", 128},
    {"\xF2\x85\x90\x80", "\xB6\x31\x94\x36", 128},
    {"\xF2\x85\x92\x80", "\xB6\x31\xA1\x34", 128},
    {"\xF2\x85\x94\x80", "\xB6\x31\xAE\x32", 128},
    {"\xF2\x85\x96\x80", "\xB6\x31\xBB\x30", 128},
    {"\xF2\x85\x98\x80", "\xB6\x31\xC7\x38", 128},
    {"\xF2\x85\x9A\x80", "\xB6\x31\xD4\x36", 128},
    {"\xF2\x85\x9C\x80", "\xB6\x31\xE1\x34", 128},
    {"\xF2\x85\x9E\x80", "\xB6\x31\xEE\x32", 128},
    {"\xF2\x85\xA0\x80", "\xB6\x31\xFB\x30", 128},
    {"\xF2\x85\xA2\x80", "\xB6\x32\x89\x38", 128},
    {"\xF2\x85\xA4\x80", "\xB6\x32\x96\x36", 128},
    {"\xF2\x85\xA6\x80", "\xB6\x32\xA3\x34", 128},
    {"\xF2\x85\xA8\x80", "\xB6\x32\xB0\x32", 128},
    {"\xF2\x85\xAA\x80", "\xB6\x32\xBD\x30", 128},
    {"\xF2\x85\xAC\x80", "\xB6\x32\xC9\x38", 128},
    {"\xF2\x85\xAE\x80", "\xB6\x32\xD6\x36", 128},
    {"\xF2\x85\xB0\x80", "\xB6\x32\xE3\x34", 128},
    {"\xF2\x85\xB2\x80", "\xB6\x32\xF0\x32", 128},
    {"\xF2\x85\xB4\x80", "\xB6\x32\xFD\x30", 128},
    {"\xF2\x85\xB6\x80", "\xB6\x33\x8B\x38", 128},
    {"\xF2\x85\xB8\x80", "\xB6\x33\x98\x36", 128},
    {"\xF2\x85\xBA\x80", "\xB6\x33\xA5\x34", 128},
    {"\xF2\x85\xBC\x80", "\xB6\x33\xB2\x32", 128},
    {"\xF2\x85\xBE\x80", "\xB6\x33\xBF\x30", 128},
    {"\xF2\x86\x80\x80", "\xB6\x33\xCB\x38", 128},
    {"\xF2\x86\x82\x80", "\xB6\x33\xD8\x36", 128},
    {"\xF2\x86\x84\x80", "\xB6\x33\xE5\x34", 128},
    {"\xF2\x86\x86\x80", "\xB6\x33\xF2\x32", 128},
    {"\xF2\x86\x88\x80", "\xB6\x34\x81\x30", 128},
    {"\xF2\x86\x8A\x80", "\xB6\x34\x8D\x38", 128},
    {"\xF2\x86\x8C\x80", "\xB6\x34\x9A\x36", 128},
    {"\xF2\x86\x8E\x80", "\xB6\x34\xA7\x34", 128},
    {"\xF2\x86\x90\x80", "\xB6\x34\xB4\x32", 128},
    {"\xF2\x86\x92\x80", "\xB6\x34\xC1\x30", 128},
    {"\xF2\x86\x94\x80", "\xB6\x34\xCD\x38", 128},
    {"\xF2\x86\x96\x80", "\xB6\x34\xDA\x36", 128},
    {"\xF2\x86\x98\x80", "\xB6\x34\xE7\x34", 128},
    {"\xF2\x86\x9A\x80", "\xB6\x34\xF4\x32", 128},
    {"\xF2\x86\x9C\x80", "\xB6\x35\x83\x30", 128},
    {"\xF2\x86\x9E\x80", "\xB6\x35\x8F\x38", 128},
    {"\xF2\x86\xA0\x80", "\xB6\x35\x9C\x36", 128},
    {"\xF2\x86\xA2\x80", "\xB6\x35\xA9\x34", 128},
    {"\xF2\x86\xA4\x80", "\xB6\x35\xB6\x32", 128},
    {"\xF2\x86\xA6\x80", "\xB6\x35\xC3\x30", 128},
    {"\xF2\x86\xA8\x80", "\xB6\x35\xCF\x38", 128},
    {"\xF2\x86\xAA\x80", "\xB6\x35\xDC\x36", 128},
    {"\xF2\x86\xAC\x80", "\xB6\x35\xE9\x34", 128},
    {"\xF2\x86\xAE\x80", "\xB6\x35\xF6\x32", 128},
    {"\xF2\x86\xB0\x80", "\xB6\x36\x85\x30", 128},
    {"\xF2\x86\xB2\x80", "\xB6\x36\x91\x38", 128},
    {"\xF2\x86\xB4\x80", "\xB6\x36\x9E\x36", 128},
    {"\xF2\x86\xB6\x80", "\xB6\x36\xAB\x34", 128},
    {"\xF2\x86\xB8\x80", "\xB6\x36\xB8\x32", 128},
    {"\xF2\x86\xBA\x80", "\xB6\x36\xC5\x30", 128},
    {"\xF2\x86\xBC\x80", "\xB6\x36\xD1\x38", 128},
    {"\xF2\x86\xBE\x80", "\xB6\x36\xDE\x36", 128},
    {"\xF2\x87\x80\x80", "\xB6\x36\xEB\x34", 128},
    {"\xF2\x87\x82\x80", "\xB6\x36\xF8\x32", 128},
    {"\xF2\x87\x84\x80", "\xB6\x37\x87\x30", 128},
    {"\xF2\x87\x86\x80", "\xB6\x37\x93\x38", 128},
    {"\xF2\x87\x88\x80", "\xB6\x37\xA0\x36", 128},
    {"\xF2\x87\x8A\x80", "\xB6\x37\xAD\x34", 128},
    {"\xF2\x87\x8C\x80", "\xB6\x37\xBA\x32", 128},
    {"\xF2\x87\x8E\x80", "\xB6\x37\xC7\x30", 128},
    {"\xF2\x87\x90\x80", "\xB6\x37\xD3\x38", 128},
    {"\xF2\x87\x92\x80", "\xB6\x37\xE0\x36", 128},
    {"\xF2\x87\x94\x80", "\xB6\x37\xED\x34", 128},
    {"\xF2\x87\x96\x80", "\xB6\x37\xFA\x32", 128},
    {"\xF2\x87\x98\x80", "\xB6\x38\x89\x30", 128},
    {"\xF2\x87\x9A\x80", "\xB6\x38\x95\x38", 128},
    {"\xF2\x87\x9C\x80", "\xB6\x38\xA2\x36", 128},
    {"\xF2\x87\x9E\x80", "\xB6\x38\xAF\x34", 128},
    {"\xF2\x87\xA0\x80", "\xB6\x38\xBC\x32", 128},
    {"\xF2\x87\xA2\x80", "\xB6\x38\xC9\x30", 128},
    {"\xF2\x87\xA4\x80", "\xB6\x38\xD5\x38", 128},
    {"\xF2\x87\xA6\x80", "\xB6\x38\xE2\x36", 128},
    {"\xF2\x87\xA8\x80", "\xB6\x38\xEF\x34", 128},
    {"\xF2\x87\xAA\x80", "\xB6\x38\xFC\x32", 128},
    {"\xF2\x87\xAC\x80", "\xB6\x39\x8B\x30", 128},
    {"\xF2\x87\xAE\x80", "\xB6\x39\x97\x38", 128},
    {"\xF2\x87\xB0\x80", "\xB6\x39\xA4\x36", 128},
    {"\xF2\x87\xB2\x80", "\xB6\x39\xB1\x34", 128},
    {"\xF2\x87\xB4\x80", "\xB6\x39\xBE\x32", 128},
    {"\xF2\x87\xB6\x80", "\xB6\x39\xCB\x30", 128},
    {"\xF2\x87\xB8\x80", "\xB6\x39\xD7\x38", 128},
    {"\xF2\x87\xBA\x80", "\xB6\x39\xE4\x36", 128},
    {"\xF2\x87\xBC\x80", "\xB6\x39\xF1\x34", 128},
    {"\xF2\x87\xBE\x80", "\xB6\x39\xFE\x32", 128},
    {"\xF2\x88\x80\x80", "\xB7\x30\x8D\x30", 128},
    {"\xF2\x88\x82\x80", "\xB7\x30\x99\x38", 128},
    {"\xF2\x88\x84\x80", "\xB7\x30\xA6\x36", 128},
    {"\xF2\x88\x86\x80", "\xB7\x30\xB3\x34", 128},
    {"\xF2\x88\x88\x80", "\xB7\x30\xC0\x32", 128},
    {"\xF2\x88\x8A\x80", "\xB7\x30\xCD\x30", 128},
    {"\xF2\x88\x8C\x80", "\xB7\x30\xD9\x38", 128},
    {"\xF2\x88\x8E\x80", "\xB7\x30\xE6\x36", 128},
    {"\xF2\x88\x90\x80", "\xB7\x30\xF3\x34", 128},
    {"\xF2\x88\x92\x80", "\xB7\x31\x82\x32", 128},
    {"\xF2\x88\x94\x80", "\xB7\x31\x8F\x30", 128},
    {"\xF2\x88\x96\x80", "\xB7\x31\x9B\x38", 128},
    {"\xF2\x88\x98\x80", "\xB7\x31\xA8\x36", 128},
    {"\xF2\x88\x9A\x80", "\xB7\x31\xB5\x34", 128},
    {"\xF2\x88\x9C\x80", "\xB7\x31\xC2\x32", 128},
    {"\xF2\x88\x9E\x80", "\xB7\x31\xCF\x30", 128},
    {"\xF2\x88\xA0\x80", "\xB7\x31\xDB\x38", 128},
    {"\xF2\x88\xA2\x80", "\xB7\x31\xE8\x36", 128},
    {"\xF2\x88\xA4\x80", "\xB7\x31\xF5\x34", 128},
    {"\xF2\x88\xA6\x80", "\xB7\x32\x84\x32", 128},
    {"\xF2\x88\xA8\x80", "\xB7\x32\x91\x30", 128},
    {"\xF2\x88\xAA\x80", "\xB7\x32\x9D\x38", 128},
    {"\xF2\x88\xAC\x80", "\xB7\x32\xAA\x36", 128},
    {"\xF2\x88\xAE\x80", "\xB7\x32\xB7\x34", 128},
    {"\xF2\x88\xB0\x80", "\xB7\x32\xC4\x32", 128},
    {"\xF2\x88\xB2\x80", "\xB7\x32\xD1\x30", 128},
    {"\xF2\x88\xB4\x80", "\xB7\x32\xDD\x38", 128},
    {"\xF2\x88\xB6\x80", "\xB7\x32\xEA\x36", 128},
    {"\xF2\x88\xB8\x80", "\xB7\x32\xF7\x34", 128},
    {"\xF2\x88\xBA\x80", "\xB7\x33\x86\x32", 128},
    {"\xF2\x88\xBC\x80", "\xB7\x33\x93\x30", 128},
    {"\xF2\x88\xBE\x80", "\xB7\x33\x9F\x38", 128},
    {"\xF2\x89\x80\x80", "\xB7\x33\xAC\x36", 128},
    {"\xF2\x89\x82\x80", "\xB7\x33\xB9\x34", 128},
    {"\xF2\x89\x84\x80", "\xB7\x33\xC6\x32", 128},
    {"\xF2\x89\x86\x80", "\xB7\x33\xD3\x30", 128},
    {"\xF2\x89\x88\x80", "\xB7\x33\xDF\x38", 128},
    {"\xF2\x89\x8A\x80", "\xB7\x33\xEC\x36", 128},
    {"\xF2\x89\x8C\x80", "\xB7\x33\xF9\x34", 128},
    {"\xF2\x89\x8E\x80", "\xB7\x34\x88\x32", 128},
    {"\xF2\x89\x90\x80", "\xB7\x34\x95\x30", 128},
    {"\xF2\x89\x92\x80", "\xB7\x34\xA1\x38", 128},
    {"\xF2\x89\x94\x80", "\xB7\x34\xAE\x36", 128},
    {"\xF2\x89\x96\x80", "\xB7\x34\xBB\x34", 128},
    {"\xF2\x89\x98\x80", "\xB7\x34\xC8\x32", 128},
    {"\xF2\x89\x9A\x80", "\xB7\x34\xD5\x30", 128},
    {"\xF2\x89\x9C\x80", "\xB7\x34\xE1\x38", 128},
    {"\xF2\x89\x9E\x80", "\xB7\x34\xEE\x36", 128},
    {"\xF2\x89\xA0\x80", "\xB7\x34\xFB\x34", 128},
    {"\xF2\x89\xA2\x80", "\xB7\x35\x8A\x32", 128},
    {"\xF2\x89\xA4\x80", "\xB7\x35\x97\x30", 128},
    {"\xF2\x89\xA6\x80", "\xB7\x35\xA3\x38", 128},
    {"\xF2\x89\xA8\x80", "\xB7\x35\xB0\x36", 128},
    {"\xF2\x89\xAA\x80", "\xB7\x35\xBD\x34", 128},
    {"\xF2\x89\xAC\x80", "\xB7\x35\xCA\x32", 128},
    {"\xF2\x89\xAE\x80", "\xB7\x35\xD7\x30", 128},
    {"\xF2\x89\xB0\x80", "\xB7\x35\xE3\x38", 128},
    {"\xF2\x89\xB2\x80", "\xB7\x35\xF0\x36", 128},
    {"\xF2\x89\xB4\x80", "\xB7\x35\xFD\x34", 128},
    {"\xF2\x89\xB6\x80", "\xB7\x36\x8C\x32", 128},
    {"\xF2\x89\xB8\x80", "\xB7\x36\x99\x30", 128},
    {"\xF2\x89\xBA\x80", "\xB7\x36\xA5\x38", 128},
    {"\xF2\x89\xBC\x80", "\xB7\x36\xB2\x36", 128},
    {"\xF2\x89\xBE\x80", "\xB7\x36\xBF\x34", 128},
    {"\xF2\x8A\x80\x80", "\xB7\x36\xCC\x32", 128},
    {"\xF2\x8A\x82\x80", "\xB7\x36\xD9\x30", 128},
    {"\xF2\x8A\x84\x80", "\xB7\x36\xE5\x38", 128},
    {"\xF2\x8A\x86\x80", "\xB7\x36\xF2\x36", 128},
    {"\xF2\x8A\x88\x80", "\xB7\x37\x81\x34", 128},
    {"\xF2\x8A\x8A\x80", "\xB7\x37\x8E\x32", 128},
    {"\xF2\x8A\x8C\x80", "\xB7\x37\x9B\x30", 128},
    {"\xF2\x8A\x8E\x80", "\xB7\x37\xA7\x38", 128},
    {"\xF2\x8A\x90\x80", "\xB7\x37\xB4\x36", 128},
    {"\xF2\x8A\x92\x80", "\xB7\x37\xC1\x34", 128},
    {"\xF2\x8A\x94\x80", "\xB7\x37\xCE\x32", 128},
    {"\xF2\x8A\x96\x80", "\xB7\x37\xDB\x30", 128},
    {"\xF2\x8A\x98\x80", "\xB7\x37\xE7\x38", 128},
    {"\xF2\x8A\x9A\x80", "\xB7\x37\xF4\x36", 128},
    {"\xF2\x8A\x9C\x80", "\xB7\x38\x83\x34", 128},
    {"\xF2\x8A\x9E\x80", "\xB7\x38\x90\x32", 128},
    {"\xF2\x8A\xA0\x80", "\xB7\x38\x9D\x30", 128},
    {"\xF2\x8A\xA2\x80", "\xB7\x38\xA9\x38", 128},
    {"\xF2\x8A\xA4\x80", "\xB7\x38\xB6\x36", 128},
    {"\xF2\x8A\xA6\x80", "\xB7\x38\xC3\x34", 128},
    {"\xF2\x8A\xA8\x80", "\xB7\x38\xD0\x32", 128},
    {"\xF2\x8A\xAA\x80", "\xB7\x38\xDD\x30", 128},
    {"\xF2\x8A\xAC\x80", "\xB7\x38\xE9\x38", 128},
    {"\xF2\x8A\xAE\x80", "\xB7\x38\xF6\x36", 128},
    {"\xF2\x8A\xB0\x80", "\xB7\x39\x85\x34", 128},
    {"\xF2\x8A\xB2\x80", "\xB7\x39\x92\x32", 128},
    {"\xF2\x8A\xB4\x80", "\xB7\x39\x9F\x30", 128},
    {"\xF2\x8A\xB6\x80", "\xB7\x39\xAB\x38", 128},
    {"\xF2\x8A\xB8\x80", "\xB7\x39\xB8\x36", 128},
    {"\xF2\x8A\xBA\x80", "\xB7\x39\xC5\x34", 128},
    {"\xF2\x8A\xBC\x80", "\xB7\x39\xD2\x32", 128},
    {"\xF2\x8A\xBE\x80", "\xB7\x39\xDF\x30", 128},
    {"\xF2\x8B\x80\x80", "\xB7\x39\xEB\x38", 128},
    {"\xF2\x8B\x82\x80", "\xB7\x39\xF8\x36", 128},
    {"\xF2\x8B\x84\x80", "\xB8\x30\x87\x34", 128},
    {"\xF2\x8B\x86\x80", "\xB8\x30\x94\x32", 128},
    {"\xF2\x8B\x88\x80", "\xB8\x30\xA1\x30", 128},
    {"\xF2\x8B\x8A\x80", "\xB8\x30\xAD\x38", 128},
    {"\xF2\x8B\x8C\x80", "\xB8\x30\xBA\x36", 128},
    {"\xF2\x8B\x8E\x80", "\xB8\x30\xC7\x34", 128},
    {"\xF2\x8B\x90\x80", "\xB8\x30\xD4\x32", 128},
    {"\xF2\x8B\x92\x80", "\xB8\x30\xE1\x30", 128},
    {"\xF2\x8B\x94\x80", "\xB8\x30\xED\x38", 128},
    {"\xF2\x8B\x96\x80", "\xB8\x30\xFA\x36", 128},
    {"\xF2\x8B\x98\x80", "\xB8\x31\x89\x34", 128},
    {"\xF2\x8B\x9A\x80", "\xB8\x31\x96\x32", 128},
    {"\xF2\x8B\x9C\x80", "\xB8\x31\xA3\x30", 128},
    {"\xF2\x8B\x9E\x80", "\xB8\x31\xAF\x38", 128},
    {"\xF2\x8B\xA0\x80", "\xB8\x31\xBC\x36", 128},
    {"\xF2\x8B\xA2\x80", "\xB8\x31\xC9\x34", 128},
    {"\xF2\x8B\xA4\x80", "\xB8\x31\xD6\x32", 128},
    {"\xF2\x8B\xA6\x80", "\xB8\x31\xE3\x30", 128},
    {"\xF2\x8B\xA8\x80", "\xB8\x31\xEF\x38", 128},
    {"\xF2\x8B\xAA\x80", "\xB8\x31\xFC\x36", 128},
    {"\xF2\x8B\xAC\x80", "\xB8\x32\x8B\x34", 128},
    {"\xF2\x8B\xAE\x80", "\xB8\x32\x98\x32", 128},
    {"\xF2\x8B\xB0\x80", "\xB8\x32\xA5\x30", 128},
    {"\xF2\x8B\xB2\x80", "\xB8\x32\xB1\x38", 128},
    {"\xF2\x8B\xB4\x80", "\xB8\x32\xBE\x36", 128},
    {"\xF2\x8B\xB6\x80", "\xB8\x32\xCB\x34", 128},
    {"\xF2\x8B\xB8\x80", "\xB8\x32\xD8\x32", 128},
    {"\xF2\x8B\xBA\x80", "\xB8\x32\xE5\x30", 128},
    {"\xF2\x8B\xBC\x80", "\xB8\x32\xF1\x38", 128},
    {"\xF2\x8B\xBE\x80", "\xB8\x32\xFE\x36", 128},
    {"\xF2\x8C\x80\x80", "\xB8\x33\x8D\x34", 128},
    {"\xF2\x8C\x82\x80", "\xB8\x33\x9A\x32", 128},
    {"\xF2\x8C\x84\x80", "\xB8\x33\xA7\x30", 128},
    {"\xF2\x8C\x86\x80", "\xB8\x33\xB3\x38", 128},
    {"\xF2\x8C\x88\x80", "\xB8\x33\xC0\x36", 128},
    {"\xF2\x8C\x8A\x80", "\xB8\x33\xCD\x34", 128},
    {"\xF2\x8C\x8C\x80", "\xB8\x33\xDA\x32", 128},
    {"\xF2\x8C\x8E\x80", "\xB8\x33\xE7\x30", 128},
    {"\xF2\x8C\x90\x80", "\xB8\x33\xF3\x38", 128},
    {"\xF2\x8C\x92\x80", "\xB8\x34\x82\x36", 128},
    {"\xF2\x8C\x94\x80", "\xB8\x34\x8F\x34", 128},
    {"\xF2\x8C\x96\x80", "\xB8\x34\x9C\x32", 128},
    {"\xF2\x8C\x98\x80", "\xB8\x34\xA9\x30", 128},
    {"\xF2\x8C\x9A\x80", "\xB8\x34\xB5\x38", 128},
    {"\xF2\x8C\x9C\x80", "\xB8\x34\xC2\x36", 128},
    {"\xF2\x8C\x9E\x80", "\xB8\x34\xCF\x34", 128},
    {"\xF2\x8C\xA0\x80", "\xB8\x34\xDC\x32", 128},
    {"\xF2\x8C\xA2\x80", "\xB8\x34\xE9\x30", 128},
    {"\xF2\x8C\xA4\x80", "\xB8\x34\xF5\x38", 128},
    {"\xF2\x8C\xA6\x80", "\xB8\x35\x84\x36", 128},
    {"\xF2\x8C\xA8\x80", "\xB8\x35\x91\x34", 128},
    {"\xF2\x8C\xAA\x80", "\xB8\x35\x9E\x32", 128},
    {"\xF2\x8C\xAC\x80", "\xB8\x35\xAB\x30", 128},
    {"\xF2\x8C\xAE\x80", "\xB8\x35\xB7\x38", 128},
    {"\xF2\x8C\xB0\x80", "\xB8\x35\xC4\x36", 128},
    {"\xF2\x8C\xB2\x80", "\xB8\x35\xD1\x34", 128},
    {"\xF2\x8C\xB4\x80", "\xB8\x35\xDE\x32", 128},
    {"\xF2\x8C\xB6\x80", "\xB8\x35\xEB\x30", 128},
    {"\xF2\x8C\xB8\x80", "\xB8\x35\xF7\x38", 128},
    {"\xF2\x8C\xBA\x80", "\xB8\x36\x86\x36", 128},
    {"\xF2\x8C\xBC\x80", "\xB8\x36\x93\x34", 128},
    {"\xF2\x8C\xBE\x80", "\xB8\x36\xA0\x32", 128},
    {"\xF2\x8D\x80\x80", "\xB8\x36\xAD\x30", 128},
    {"\xF2\x8D\x82\x80", "\xB8\x36\xB9\x38", 128},
    {"\xF2\x8D\x84\x80", "\xB8\x36\xC6\x36", 128},
    {"\xF2\x8D\x86\x80", "\xB8\x36\xD3\x34", 128},
    {"\xF2\x8D\x88\x80", "\xB8\x36\xE0\x32", 128},
    {"\xF2\x8D\x8A\x80", "\xB8\x36\xED\x30", 128},
    {"\xF2\x8D\x8C\x80", "\xB8\x36\xF9\x38", 128},
    {"\xF2\x8D\x8E\x80", "\xB8\x37\x88\x36", 128},
    {"\xF2\x8D\x90\x80", "\xB8\x37\x95\x34", 128},
    {"\xF2\x8D\x92\x80", "\xB8\x37\xA2\x32", 128},
    {"\xF2\x8D\x94\x80", "\xB8\x37\xAF\x30", 128},
    {"\xF2\x8D\x96\x80", "\xB8\x37\xBB\x38", 128},
    {"\xF2\x8D\x98\x80", "\xB8\x37\xC8\x36", 128},
    {"\xF2\x8D\x9A\x80", "\xB8\x37\xD5\x34", 128},
    {"\xF2\x8D\x9C\x80", "\xB8\x37\xE2\x32", 128},
    {"\xF2\x8D\x9E\x80", "\xB8\x37\xEF\x30", 128},
    {"\xF2\x8D\xA0\x80", "\xB8\x37\xFB\x38", 128},
    {"\xF2\x8D\xA2\x80", "\xB8\x38\x8A\x36", 128},
    {"\xF2\x8D\xA4\x80", "\xB8\x38\x97\x34", 128},
    {"\xF2\x8D\xA6\x80", "\xB8\x38\xA4\x32", 128},
    {"\xF2\x8D\xA8\x80", "\xB8\x38\xB1\x30", 128},
    {"\xF2\x8D\xAA\x80", "\xB8\x38\xBD\x38", 128},
    {"\xF2\x8D\xAC\x80", "\xB8\x38\xCA\x36", 128},
    {"\xF2\x8D\xAE\x80", "\xB8\x38\xD7\x34", 128},
    {"\xF2\x8D\xB0\x80", "\xB8\x38\xE4\x32", 128},
    {"\xF2\x8D\xB2\x80", "\xB8\x38\xF1\x30", 128},
    {"\xF2\x8D\xB4\x80", "\xB8\x38\xFD\x38", 128},
    {"\xF2\x8D\xB6\x80", "\xB8\x39\x8C\x36", 128},
    {"\xF2\x8D\xB8\x80", "\xB8\x39\x99\x34", 128},
    {"\xF2\x8D\xBA\x80", "\xB8\x39\xA6\x32", 128},
    {"\xF2\x8D\xBC\x80", "\xB8\x39\xB3\x30", 128},
    {"\xF2\x8D\xBE\x80", "\xB8\x39\xBF\x38", 128},
    {"\xF2\x8E\x80\x80", "\xB8\x39\xCC\x36", 128},
    {"\xF2\x8E\x82\x80", "\xB8\x39\xD9\x34", 128},
    {"\xF2\x8E\x84\x80", "\xB8\x39\xE6\x32", 128},
    {"\xF2\x8E\x86\x80", "\xB8\x39\xF3\x30", 128},
    {"\xF2\x8E\x88\x80", "\xB9\x30\x81\x38", 128},
    {"\xF2\x8E\x8A\x80", "\xB9\x30\x8E\x36", 128},
    {"\xF2\x8E\x8C\x80", "\xB9\x30\x9B\x34", 128},
    {"\xF2\x8E\x8E\x80", "\xB9\x30\xA8\x32", 128},
    {"\xF2\x8E\x90\x80", "\xB9\x30\xB5\x30", 128},
    {"\xF2\x8E\x92\x80", "\xB9\x30\xC1\x38", 128},
    {"\xF2\x8E\x94\x80", "\xB9\x30\xCE\x36", 128},
    {"\xF2\x8E\x96\x80", "\xB9\x30\xDB\x34", 128},
    {"\xF2\x8E\x98\x80", "\xB9\x30\xE8\x32", 128},
    {"\xF2\x8E\x9A\x80", "\xB9\x30\xF5\x30", 128},
    {"\xF2\x8E\x9C\x80", "\xB9\x31\x83\x38", 128},
    {"\xF2\x8E\x9E\x80", "\xB9\x31\x90\x36", 128},
    {"\xF2\x8E\xA0\x80", "\xB9\x31\x9D\x34", 128},
    {"\xF2\x8E\xA2\x80", "\xB9\x31\xAA\x32", 128},
    {"\xF2\x8E\xA4\x80", "\xB9\x31\xB7\x30", 128},
    {"\xF2\x8E\xA6\x80", "\xB9\x31\xC3\x38", 128},
    {"\xF2\x8E\xA8\x80", "\xB9\x31\xD0\x36", 128},
    {"\xF2\x8E\xAA\x80", "\xB9\x31\xDD\x34", 128},
    {"\xF2\x8E\xAC\x80", "\xB9\x31\xEA\x32", 128},
    {"\xF2\x8E\xAE\x80", "\xB9\x31\xF7\x30", 128},
    {"\xF2\x8E\xB0\x80", "\xB9\x32\x85\x38", 128},
    {"\xF2\x8E\xB2\x80", "\xB9\x32\x92\x36", 128},
    {"\xF2\x8E\xB4\x80", "\xB9\x32\x9F\x34", 128},
    {"\xF2\x8E\xB6\x80", "\xB9\x32\xAC\x32", 128},
    {"\xF2\x8E\xB8\x80", "\xB9\x32\xB9\x30", 128},
    {"\xF2\x8E\xBA\x80", "\xB9\x32\xC5\x38", 128},
    {"\xF2\x8E\xBC\x80", "\xB9\x32\xD2\x36", 128},
    {"\xF2\x8E\xBE\x80", "\xB9\x32\xDF\x34", 128},
    {"\xF2\x8F\x80\x80", "\xB9\x32\xEC\x32", 128},
    {"\xF2\x8F\x82\x80", "\xB9\x32\xF9\x30", 128},
    {"\xF2\x8F\x84\x80", "\xB9\x33\x87\x38", 128},
    {"\xF2\x8F\x86\x80", "\xB9\x33\x94\x36", 128},
    {"\xF2\x8F\x88\x80", "\xB9\x33\xA1\x34", 128},
    {"\xF2\x8F\x8A\x80", "\xB9\x33\xAE\x32", 128},
    {"\xF2\x8F\x8C\x80", "\xB9\x33\xBB\x30", 128},
    {"\xF2\x8F\x8E\x80", "\xB9\x33\xC7\x38", 128},
    {"\xF2\x8F\x90\x80", "\xB9\x33\xD4\x36", 128},
    {"\xF2\x8F\x92\x80", "\xB9\x33\xE1\x34", 128},
    {"\xF2\x8F\x94\x80", "\xB9\x33\xEE\x32", 128},
    {"\xF2\x8F\x96\x80", "\xB9\x33\xFB\x30", 128},
    {"\xF2\x8F\x98\x80", "\xB9\x34\x89\x38", 128},
    {"\xF2\x8F\x9A\x80", "\xB9\x34\x96\x36", 128},
    {"\xF2\x8F\x9C\x80", "\xB9\x34\xA3\x34", 128},
    {"\xF2\x8F\x9E\x80", "\xB9\x34\xB0\x32", 128},
    {"\xF2\x8F\xA0\x80", "\xB9\x34\xBD\x30", 128},
    {"\xF2\x8F\xA2\x80", "\xB9\x34\xC9\x38", 128},
    {"\xF2\x8F\xA4\x80", "\xB9\x34\xD6\x36", 128},
    {"\xF2\x8F\xA6\x80", "\xB9\x34\xE3\x34", 128},
    {"\xF2\x8F\xA8\x80", "\xB9\x34\xF0\x32", 128},
    {"\xF2\x8F\xAA\x80", "\xB9\x34\xFD\x30", 128},
    {"\xF2\x8F\xAC\x80", "\xB9\x35\x8B\x38", 128},
    {"\xF2\x8F\xAE\x80", "\xB9\x35\x98\x36", 128},
    {"\xF2\x8F\xB0\x80", "\xB9\x35\xA5\x34", 128},
    {"\xF2\x8F\xB2\x80", "\xB9\x35\xB2\x32", 128},
    {"\xF2\x8F\xB4\x80", "\xB9\x35\xBF\x30", 128},
    {"\xF2\x8F\xB6\x80", "\xB9\x35\xCB\x38", 128},
    {"\xF2\x8F\xB8\x80", "\xB9\x35\xD8\x36", 128},
    {"\xF2\x8F\xBA\x80", "\xB9\x35\xE5\x34", 128},
    {"\xF2\x8F\xBC\x80", "\xB9\x35\xF2\x32", 128},
    {"\xF2\x8F\xBE\x80", "\xB9\x36\x81\x30", 128},
    {"\xF2\x90\x80\x80", "\xB9\x36\x8D\x38", 128},
    {"\xF2\x90\x82\x80", "\xB9\x36\x9A\x36", 128},
    {"\xF2\x90\x84\x80", "\xB9\x36\xA7\x34", 128},
    {"\xF2\x90\x86\x80", "\xB9\x36\xB4\x32", 128},
    {"\xF2\x90\x88\x80", "\xB9\x36\xC1\x30", 128},
    {"\xF2\x90\x8A\x80", "\xB9\x36\xCD\x38", 128},
    {"\xF2\x90\x8C\x80", "\xB9\x36\xDA\x36", 128},
    {"\xF2\x90\x8E\x80", "\xB9\x36\xE7\x34", 128},
    {"\xF2\x90\x90\x80", "\xB9\x36\xF4\x32", 128},
    {"\xF2\x90\x92\x80", "\xB9\x37\x83\x30", 128},
    {"\xF2\x90\x94\x80", "\xB9\x37\x8F\x38", 128},
    {"\xF2\x90\x96\x80", "\xB9\x37\x9C\x36", 128},
    {"\xF2\x90\x98\x80", "\xB9\x37\xA9\x34", 128},
    {"\xF2\x90\x9A\x80", "\xB9\x37\xB6\x32", 128},
    {"\xF2\x90\x9C\x80", "\xB9\x37\xC3\x30", 128},
    {"\xF2\x90\x9E\x80", "\xB9\x37\xCF\x38", 128},
    {"\xF2\x90\xA0\x80", "\xB9\x37\xDC\x36", 128},
    {"\xF2\x90\xA2\x80", "\xB9\x37\xE9\x34", 128},
    {"\xF2\x90\xA4\x80", "\xB9\x37\xF6\x32", 128},
    {"\xF2\x90\xA6\x80", "\xB9\x38\x85\x30", 128},
    {"\xF2\x90\xA8\x80", "\xB9\x38\x91\x38", 128},
    {"\xF2\x90\xAA\x80", "\xB9\x38\x9E\x36", 128},
    {"\xF2\x90\xAC\x80", "\xB9\x38\xAB\x34", 128},
    {"\xF2\x90\xAE\x80", "\xB9\x38\xB8\x32", 128},
    {"\xF2\x90\xB0\x80", "\xB9\x38\xC5\x30", 128},
    {"\xF2\x90\xB2\x80", "\xB9\x38\xD1\x38", 128},
    {"\xF2\x90\xB4\x80", "\xB9\x38\xDE\x36", 128},
    {"\xF2\x90\xB6\x80", "\xB9\x38\xEB\x34", 128},
    {"\xF2\x90\xB8\x80", "\xB9\x38\xF8\x32", 128},
    {"\xF2\x90\xBA\x80", "\xB9\x39\x87\x30", 128},
    {"\xF2\x90\xBC\x80", "\xB9\x39\x93\x38", 128},
    {"\xF2\x90\xBE\x80", "\xB9\x39\xA0\x36", 128},
    {"\xF2\x91\x80\x80", "\xB9\x39\xAD\x34", 128},
    {"\xF2\x91\x82\x80", "\xB9\x39\xBA\x32", 128},
    {"\xF2\x91\x84\x80", "\xB9\x39\xC7\x30", 128},
    {"\xF2\x91\x86\x80", "\xB9\x39\xD3\x38", 128},
    {"\xF2\x91\x88\x80", "\xB9\x39\xE0\x36", 128},
    {"\xF2\x91\x8A\x80", "\xB9\x39\xED\x34", 128},
    {"\xF2\x91\x8C\x80", "\xB9\x39\xFA\x32", 128},
    {"\xF2\x91\x8E\x80", "\xBA\x30\x89\x30", 128},
    {"\xF2\x91\x90\x80", "\xBA\x30\x95\x38", 128},
    {"\xF2\x91\x92\x80", "\xBA\x30\xA2\x36", 128},
    {"\xF2\x91\x94\x80", "\xBA\x30\xAF\x34", 128},
    {"\xF2\x91\x96\x80", "\xBA\x30\xBC\x32", 128},
    {"\xF2\x91\x98\x80", "\xBA\x30\xC9\x30", 128},
    {"\xF2\x91\x9A\x80", "\xBA\x30\xD5\x38", 128},
    {"\xF2\x91\x9C\x80", "\xBA\x30\xE2\x36", 128},
    {"\xF2\x91\x9E\x80", "\xBA\x30\xEF\x34", 128},
    {"\xF2\x91\xA0\x80", "\xBA\x30\xFC\x32", 128},
    {"\xF2\x91\xA2\x80", "\xBA\x31\x8B\x30", 128},
    {"\xF2\x91\xA4\x80", "\xBA\x31\x97\x38", 128},
    {"\xF2\x91\xA6\x80", "\xBA\x31\xA4\x36", 128},
    {"\xF2\x91\xA8\x80", "\xBA\x31\xB1\x34", 128},
    {"\xF2\x91\xAA\x80", "\xBA\x31\xBE\x32", 128},
    {"\xF2\x91\xAC\x80", "\xBA\x31\xCB\x30", 128},
    {"\xF2\x91\xAE\x80", "\xBA\x31\xD7\x38", 128},
    {"\xF2\x91\xB0\x80", "\xBA\x31\xE4\x36", 128},
    {"\xF2\x91\xB2\x80", "\xBA\x31\xF1\x34", 128},
    {"\xF2\x91\xB4\x80", "\xBA\x31\xFE\x32", 128},
    {"\xF2\x91\xB6\x80", "\xBA\x32\x8D\x30", 128},
    {"\xF2\x91\xB8\x80", "\xBA\x32\x99\x38", 128},
    {"\xF2\x91\xBA\x80", "\xBA\x32\xA6\x36", 128},
    {"\xF2\x91\xBC\x80", "\xBA\x32\xB3\x34", 128},
    {"\xF2\x91\xBE\x80", "\xBA\x32\xC0\x32", 128},
    {"\xF2\x92\x80\x80", "\xBA\x32\xCD\x30", 128},
    {"\xF2\x92\x82\x80", "\xBA\x32\xD9\x38", 128},
    {"\xF2\x92\x84\x80", "\xBA\x32\xE6\x36", 128},
    {"\xF2\x92\x86\x80", "\xBA\x32\xF3\x34", 128},
    {"\xF2\x92\x88\x80", "\xBA\x33\x82\x32", 128},
    {"\xF2\x92\x8A\x80", "\xBA\x33\x8F\x30", 128},
    {"\xF2\x92\x8C\x80", "\xBA\x33\x9B\x38", 128},
    {"\xF2\x92\x8E\x80", "\xBA\x33\xA8\x36", 128},
    {"\xF2\x92\x90\x80", "\xBA\x33\xB5\x34", 128},
    {"\xF2\x92\x92\x80", "\xBA\x33\xC2\x32", 128},
    {"\xF2\x92\x94\x80", "\xBA\x33\xCF\x30", 128},
    {"\xF2\x92\x96\x80", "\xBA\x33\xDB\x38", 128},
    {"\xF2\x92\x98\x80", "\xBA\x33\xE8\x36", 128},
    {"\xF2\x92\x9A\x80", "\xBA\x33\xF5\x34", 128},
    {"\xF2\x92\x9C\x80", "\xBA\x34\x84\x32", 128},
    {"\xF2\x92\x9E\x80", "\xBA\x34\x91\x30", 128},
    {"\xF2\x92\xA0\x80", "\xBA\x34\x9D\x38", 128},
    {"\xF2\x92\xA2\x80", "\xBA\x34\xAA\x36", 128},
    {"\xF2\x92\xA4\x80", "\xBA\x34\xB7\x34", 128},
    {"\xF2\x92\xA6\x80", "\xBA\x34\xC4\x32", 128},
    {"\xF2\x92\xA8\x80", "\xBA\x34\xD1\x30", 128},
    {"\xF2\x92\xAA\x80", "\xBA\x34\xDD\x38", 128},
    {"\xF2\x92\xAC\x80", "\xBA\x34\xEA\x36", 128},
    {"\xF2\x92\xAE\x80", "\xBA\x34\xF7\x34", 128},
    {"\xF2\x92\xB0\x80", "\xBA\x35\x86\x32", 128},
    {"\xF2\x92\xB2\x80", "\xBA\x35\x93\x30", 128},
    {"\xF2\x92\xB4\x80", "\xBA\x35\x9F\x38", 128},
    {"\xF2\x92\xB6\x80", "\xBA\x35\xAC\x36", 128},
    {"\xF2\x92\xB8\x80", "\xBA\x35\xB9\x34", 128},
    {"\xF2\x92\xBA\x80", "\xBA\x35\xC6\x32", 128},
    {"\xF2\x92\xBC\x80", "\xBA\x35\xD3\x30", 128},
    {"\xF2\x92\xBE\x80", "\xBA\x35\xDF\x38", 128},
    {"\xF2\x93\x80\x80", "\xBA\x35\xEC\x36", 128},
    {"\xF2\x93\x82\x80", "\xBA\x35\xF9\x34", 128},
    {"\xF2\x93\x84\x80", "\xBA\x36\x88\x32", 128},
    {"\xF2\x93\x86\x80", "\xBA\x36\x95\x30", 128},
    {"\xF2\x93\x88\x80", "\xBA\x36\xA1\x38", 128},
    {"\xF2\x93\x8A\x80", "\xBA\x36\xAE\x36", 128},
    {"\xF2\x93\x8C\x80", "\xBA\x36\xBB\x34", 128},
    {"\xF2\x93\x8E\x80", "\xBA\x36\xC8\x32", 128},
    {"\xF2\x93\x90\x80", "\xBA\x36\xD5\x30", 128},
    {"\xF2\x93\x92\x80", "\xBA\x36\xE1\x38", 128},
    {"\xF2\x93\x94\x80", "\xBA\x36\xEE\x36", 128},
    {"\xF2\x93\x96\x80", "\xBA\x36\xFB\x34", 128},
    {"\xF2\x93\x98\x80", "\xBA\x37\x8A\x32", 128},
    {"\xF2\x93\x9A\x80", "\xBA\x37\x97\x30", 128},
    {"\xF2\x93\x9C\x80", "\xBA\x37\xA3\x38", 128},
    {"\xF2\x93\x9E\x80", "\xBA\x37\xB0\x36", 128},
    {"\xF2\x93\xA0\x80", "\xBA\x37\xBD\x34", 128},
    {"\xF2\x93\xA2\x80", "\xBA\x37\xCA\x32", 128},
    {"\xF2\x93\xA4\x80", "\xBA\x37\xD7\x30", 128},
    {"\xF2\x93\xA6\x80", "\xBA\x37\xE3\x38", 128},
    {"\xF2\x93\xA8\x80", "\xBA\x37\xF0\x36", 128},
    {"\xF2\x93\xAA\x80", "\xBA\x37\xFD\x34", 128},
    {"\xF2\x93\xAC\x80", "\xBA\x38\x8C\x32", 128},
    {"\xF2\x93\xAE\x80", "\xBA\x38\x99\x30", 128},
    {"\xF2\x93\xB0\x80", "\xBA\x38\xA5\x38", 128},
    {"\xF2\x93\xB2\x80", "\xBA\x38\xB2\x36", 128},
    {"\xF2\x93\xB4\x80", "\xBA\x38\xBF\x34", 128},
    {"\xF2\x93\xB6\x80", "\xBA\x38\xCC\x32", 128},
    {"\xF2\x93\xB8\x80", "\xBA\x38\xD9\x30", 128},
    {"\xF2\x93\xBA\x80", "\xBA\x38\xE5\x38", 128},
    {"\xF2\x93\xBC\x80", "\xBA\x38\xF2\x36", 128},
    {"\xF2\x93\xBE\x80", "\xBA\x39\x81\x34", 128},
    {"\xF2\x94\x80\x80", "\xBA\x39\x8E\x32", 128},
    {"\xF2\x94\x82\x80", "\xBA\x39\x9B\x30", 128},
    {"\xF2\x94\x84\x80", "\xBA\x39\xA7\x38", 128},
    {"\xF2\x94\x86\x80", "\xBA\x39\xB4\x36", 128},
    {"\xF2\x94\x88\x80", "\xBA\x39\xC1\x34", 128},
    {"\xF2\x94\x8A\x80", "\xBA\x39\xCE\x32", 128},
    {"\xF2\x94\x8C\x80", "\xBA\x39\xDB\x30", 128},
    {"\xF2\x94\x8E\x80", "\xBA\x39\xE7\x38", 128},
    {"\xF2\x94\x90\x80", "\xBA\x39\xF4\x36", 128},
    {"\xF2\x94\x92\x80", "\xBB\x30\x83\x34", 128},
    {"\xF2\x94\x94\x80", "\xBB\x30\x90\x32", 128},
    {"\xF2\x94\x96\x80", "\xBB\x30\x9D\x30", 128},
    {"\xF2\x94\x98\x80", "\xBB\x30\xA9\x38", 128},
    {"\xF2\x94\x9A\x80", "\xBB\x30\xB6\x36", 128},
    {"\xF2\x94\x9C\x80", "\xBB\x30\xC3\x34", 128},
    {"\xF2\x94\x9E\x80", "\xBB\x30\xD0\x32", 128},
    {"\xF2\x94\xA0\x80", "\xBB\x30\xDD\x30", 128},
    {"\xF2\x94\xA2\x80", "\xBB\x30\xE9\x38", 128},
    {"\xF2\x94\xA4\x80", "\xBB\x30\xF6\x36", 128},
    {"\xF2\x94\xA6\x80", "\xBB\x31\x85\x34", 128},
    {"\xF2\x94\xA8\x80", "\xBB\x31\x92\x32", 128},
    {"\xF2\x94\xAA\x80", "\xBB\x31\x9F\x30", 128},
    {"\xF2\x94\xAC\x80", "\xBB\x31\xAB\x38", 128},
    {"\xF2\x94\xAE\x80", "\xBB\x31\xB8\x36", 128},
    {"\xF2\x94\xB0\x80", "\xBB\x31\xC5\x34", 128},
    {"\xF2\x94\xB2\x80", "\xBB\x31\xD2\x32", 128},
    {"\xF2\x94\xB4\x80", "\xBB\x31\xDF\x30", 128},
    {"\xF2\x94\xB6\x80", "\xBB\x31\xEB\x38", 128},
    {"\xF2\x94\xB8\x80", "\xBB\x31\xF8\x36", 128},
    {"\xF2\x94\xBA\x80", "\xBB\x32\x87\x34", 128},
    {"\xF2\x94\xBC\x80", "\xBB\x32\x94\x32", 128},
    {"\xF2\x94\xBE\x80", "\xBB\x32\xA1\x30", 128},
    {"\xF2\x95\x80\x80", "\xBB\x32\xAD\x38", 128},
    {"\xF2\x95\x82\x80", "\xBB\x32\xBA\x36", 128},
    {"\xF2\x95\x84\x80", "\xBB\x32\xC7\x34", 128},
    {"\xF2\x95\x86\x80", "\xBB\x32\xD4\x32", 128},
    {"\xF2\x95\x88\x80", "\xBB\x32\xE1\x30", 128},
    {"\xF2\x95\x8A\x80", "\xBB\x32\xED\x38", 128},
    {"\xF2\x95\x8C\x80", "\xBB\x32\xFA\x36", 128},
    {"\xF2\x95\x8E\x80", "\xBB\x33\x89\x34", 128},
    {"\xF2\x95\x90\x80", "\xBB\x33\x96\x32", 128},
    {"\xF2\x95\x92\x80", "\xBB\x33\xA3\x30", 128},
    {"\xF2\x95\x94\x80", "\xBB\x33\xAF\x38", 128},
    {"\xF2\x95\x96\x80", "\xBB\x33\xBC\x36", 128},
    {"\xF2\x95\x98\x80", "\xBB\x33\xC9\x34", 128},
    {"\xF2\x95\x9A\x80", "\xBB\x33\xD6\x32", 128},
    {"\xF2\x95\x9C\x80", "\xBB\x33\xE3\x30", 128},
    {"\xF2\x95\x9E\x80", "\xBB\x33\xEF\x38", 128},
    {"\xF2\x95\xA0\x80", "\xBB\x33\xFC\x36", 128},
    {"\xF2\x95\xA2\x80", "\xBB\x34\x8B\x34", 128},
    {"\xF2\x95\xA4\x80", "\xBB\x34\x98\x32", 128},
    {"\xF2\x95\xA6\x80", "\xBB\x34\xA5\x30", 128},
    {"\xF2\x95\xA8\x80", "\xBB\x34\xB1\x38", 128},
    {"\xF2\x95\xAA\x80", "\xBB\x34\xBE\x36", 128},
    {"\xF2\x95\xAC\x80", "\xBB\x34\xCB\x34", 128},
    {"\xF2\x95\xAE\x80", "\xBB\x34\xD8\x32", 128},
    {"\xF2\x95\xB0\x80", "\xBB\x34\xE5\x30", 128},
    {"\xF2\x95\xB2\x80", "\xBB\x34\xF1\x38", 128},
    {"\xF2\x95\xB4\x80", "\xBB\x34\xFE\x36", 128},
    {"\xF2\x95\xB6\x80", "\xBB\x35\x8D\x34", 128},
    {"\xF2\x95\xB8\x80", "\xBB\x35\x9A\x32", 128},
    {"\xF2\x95\xBA\x80", "\xBB\x35\xA7\x30", 128},
    {"\xF2\x95\xBC\x80", "\xBB\x35\xB3\x38", 128},
    {"\xF2\x95\xBE\x80", "\xBB\x35\xC0\x36", 128},
    {"\xF2\x96\x80\x80", "\xBB\x35\xCD\x34", 128},
    {"\xF2\x96\x82\x80", "\xBB\x35\xDA\x32", 128},
    {"\xF2\x96\x84\x80", "\xBB\x35\xE7\x30", 128},
    {"\xF2\x96\x86\x80", "\xBB\x35\xF3\x38", 128},
    {"\xF2\x96\x88\x80", "\xBB\x36\x82\x36", 128},
    {"\xF2\x96\x8A\x80", "\xBB\x36\x8F\x34", 128},
    {"\xF2\x96\x8C\x80", "\xBB\x36\x9C\x32", 128},
    {"\xF2\x96\x8E\x80", "\xBB\x36\xA9\x30", 128},
    {"\xF2\x96\x90\x80", "\xBB\x36\xB5\x38", 128},
    {"\xF2\x96\x92\x80", "\xBB\x36\xC2\x36", 128},
    {"\xF2\x96\x94\x80", "\xBB\x36\xCF\x34", 128},
    {"\xF2\x96\x96\x80", "\xBB\x36\xDC\x32", 128},
    {"\xF2\x96\x98\x80", "\xBB\x36\xE9\x30", 128},
    {"\xF2\x96\x9A\x80", "\xBB\x36\xF5\x38", 128},
    {"\xF2\x96\x9C\x80", "\xBB\x37\x84\x36", 128},
    {"\xF2\x96\x9E\x80", "\xBB\x37\x91\x34", 128},
    {"\xF2\x96\xA0\x80", "\xBB\x37\x9E\x32", 128},
    {"\xF2\x96\xA2\x80", "\xBB\x37\xAB\x30", 128},
    {"\xF2\x96\xA4\x80", "\xBB\x37\xB7\x38", 128},
    {"\xF2\x96\xA6\x80", "\xBB\x37\xC4\x36", 128},
    {"\xF2\x96\xA8\x80", "\xBB\x37\xD1\x34", 128},
    {"\xF2\x96\xAA\x80", "\xBB\x37\xDE\x32", 128},
    {"\xF2\x96\xAC\x80", "\xBB\x37\xEB\x30", 128},
    {"\xF2\x96\xAE\x80", "\xBB\x37\xF7\x38", 128},
    {"\xF2\x96\xB0\x80", "\xBB\x38\x86\x36", 128},
    {"\xF2\x96\xB2\x80", "\xBB\x38\x93\x34", 128},
    {"\xF2\x96\xB4\x80", "\xBB\x38\xA0\x32", 128},
    {"\xF2\x96\xB6\x80", "\xBB\x38\xAD\x30", 128},
    {"\xF2\x96\xB8\x80", "\xBB\x38\xB9\x38", 128},
    {"\xF2\x96\xBA\x80", "\xBB\x38\xC6\x36", 128},
    {"\xF2\x96\xBC\x80", "\xBB\x38\xD3\x34", 128},
    {"\xF2\x96\xBE\x80", "\xBB\x38\xE0\x32", 128},
    {"\xF2\x97\x80\x80", "\xBB\x38\xED\x30", 128},
    {"\xF2\x97\x82\x80", "\xBB\x38\xF9\x38", 128},
    {"\xF2\x97\x84\x80", "\xBB\x39\x88\x36", 128},
    {"\xF2\x97\x86\x80", "\xBB\x39\x95\x34", 128},
    {"\xF2\x97\x88\x80", "\xBB\x39\xA2\x32", 128},
    {"\xF2\x97\x8A\x80", "\xBB\x39\xAF\x30", 128},
    {"\xF2\x97\x8C\x80", "\xBB\x39\xBB\x38", 128},
    {"\xF2\x97\x8E\x80", "\xBB\x39\xC8\x36", 128},
    {"\xF2\x97\x90\x80", "\xBB\x39\xD5\x34", 128},
    {"\xF2\x97\x92\x80", "\xBB\x39\xE2\x32", 128},
    {"\xF2\x97\x94\x80", "\xBB\x39\xEF\x30", 128},
    {"\xF2\x97\x96\x80", "\xBB\x39\xFB\x38", 128},
    {"\xF2\x97\x98\x80", "\xBC\x30\x8A\x36", 128},
    {"\xF2\x97\x9A\x80", "\xBC\x30\x97\x34", 128},
    {"\xF2\x97\x9C\x80", "\xBC\x30\xA4\x32", 128},
    {"\xF2\x97\x9E\x80", "\xBC\x30\xB1\x30", 128},
    {"\xF2\x97\xA0\x80", "\xBC\x30\xBD\x38", 128},
    {"\xF2\x97\xA2\x80", "\xBC\x30\xCA\x36", 128},
    {"\xF2\x97\xA4\x80", "\xBC\x30\xD7\x34", 128},
    {"\xF2\x97\xA6\x80", "\xBC\x30\xE4\x32", 128},
    {"\xF2\x97\xA8\x80", "\xBC\x30\xF1\x30", 128},
    {"\xF2\x97\xAA\x80", "\xBC\x30\xFD\x38", 128},
    {"\xF2\x97\xAC\x80", "\xBC\x31\x8C\x36", 128},
    {"\xF2\x97\xAE\x80", "\xBC\x31\x99\x34", 128},
    {"\xF2\x97\xB0\x80", "\xBC\x31\xA6\x32", 128},
    {"\xF2\x97\xB2\x80", "\xBC\x31\xB3\x30", 128},
    {"\xF2\x97\xB4\x80", "\xBC\x31\xBF\x38", 128},
    {"\xF2\x97\xB6\x80", "\xBC\x31\xCC\x36", 128},
    {"\xF2\x97\xB8\x80", "\xBC\x31\xD9\x34", 128},
    {"\xF2\x97\xBA\x80", "\xBC\x31\xE6\x32", 128},
    {"\xF2\x97\xBC\x80", "\xBC\x31\xF3\x30", 128},
    {"\xF2\x97\xBE\x80", "\xBC\x32\x81\x38", 128},
    {"\xF2\x98\x80\x80", "\xBC\x32\x8E\x36", 128},
    {"\xF2\x98\x82\x80", "\xBC\x32\x9B\x34", 128},
    {"\xF2\x98\x84\x80", "\xBC\x32\xA8\x32", 128},
    {"\xF2\x98\x86\x80", "\xBC\x32\xB5\x30", 128},
    {"\xF2\x98\x88\x80", "\xBC\x32\xC1\x38", 128},
    {"\xF2\x98\x8A\x80", "\xBC\x32\xCE\x36", 128},
    {"\xF2\x98\x8C\x80", "\xBC\x32\xDB\x34", 128},
    {"\xF2\x98\x8E\x80", "\xBC\x32\xE8\x32", 128},
    {"\xF2\x98\x90\x80", "\xBC\x32\xF5\x30", 128},
    {"\xF2\x98\x92\x80", "\xBC\x33\x83\x38", 128},
    {"\xF2\x98\x94\x80", "\xBC\x33\x90\x36", 128},
    {"\xF2\x98\x96\x80", "\xBC\x33\x9D\x34", 128},
    {"\xF2\x98\x98\x80", "\xBC\x33\xAA\x32", 128},
    {"\xF2\x98\x9A\x80", "\xBC\x33\xB7\x30", 128},
    {"\xF2\x98\x9C\x80", "\xBC\x33\xC3\x38", 128},
    {"\xF2\x98\x9E\x80", "\xBC\x33\xD0\x36", 128},
    {"\xF2\x98\xA0\x80", "\xBC\x33\xDD\x34", 128},
    {"\xF2\x98\xA2\x80", "\xBC\x33\xEA\x32", 128},
    {"\xF2\x98\xA4\x80", "\xBC\x33\xF7\x30", 128},
    {"\xF2\x98\xA6\x80", "\xBC\x34\x85\x38", 128},
    {"\xF2\x98\xA8\x80", "\xBC\x34\x92\x36", 128},
    {"\xF2\x98\xAA\x80", "\xBC\x34\x9F\x34", 128},
    {"\xF2\x98\xAC\x80", "\xBC\x34\xAC\x32", 128},
    {"\xF2\x98\xAE\x80", "\xBC\x34\xB9\x30", 128},
    {"\xF2\x98\xB0\x80", "\xBC\x34\xC5\x38", 128},
    {"\xF2\x98\xB2\x80", "\xBC\x34\xD2\x36", 128},
    {"\xF2\x98\xB4\x80", "\xBC\x34\xDF\x34", 128},
    {"\xF2\x98\xB6\x80", "\xBC\x34\xEC\x32", 128},
    {"\xF2\x98\xB8\x80", "\xBC\x34\xF9\x30", 128},
    {"\xF2\x98\xBA\x80", "\xBC\x35\x87\x38", 128},
    {"\xF2\x98\xBC\x80", "\xBC\x35\x94\x36", 128},
    {"\xF2\x98\xBE\x80", "\xBC\x35\xA1\x34", 128},
    {"\xF2\x99\x80\x80", "\xBC\x35\xAE\x32", 128},
    {"\xF2\x99\x82\x80", "\xBC\x35\xBB\x30", 128},
    {"\xF2\x99\x84\x80", "\xBC\x35\xC7\x38", 128},
    {"\xF2\x99\x86\x80", "\xBC\x35\xD4\x36", 128},
    {"\xF2\x99\x88\x80", "\xBC\x35\xE1\x34", 128},
    {"\xF2\x99\x8A\x80", "\xBC\x35\xEE\x32", 128},
    {"\xF2\x99\x8C\x80", "\xBC\x35\xFB\x30", 128},
    {"\xF2\x99\x8E\x80", "\xBC\x36\x89\x38", 128},
    {"\xF2\x99\x90\x80", "\xBC\x36\x96\x36", 128},
    {"\xF2\x99\x92\x80", "\xBC\x36\xA3\x34", 128},
    {"\xF2\x99\x94\x80", "\xBC\x36\xB0\x32", 128},
    {"\xF2\x99\x96\x80", "\xBC\x36\xBD\x30", 128},
    {"\xF2\x99\x98\x80", "\xBC\x36\xC9\x38", 128},
    {"\xF2\x99\x9A\x80", "\xBC\x36\xD6\x36", 128},
    {"\xF2\x99\x9C\x80", "\xBC\x36\xE3\x34", 128},
    {"\xF2\x99\x9E\x80", "\xBC\x36\xF0\x32", 128},
    {"\xF2\x99\xA0\x80", "\xBC\x36\xFD\x30", 128},
    {"\xF2\x99\xA2\x80", "\xBC\x37\x8B\x38", 128},
    {"\xF2\x99\xA4\x80", "\xBC\x37\x98\x36", 128},
    {"\xF2\x99\xA6\x80", "\xBC\x37\xA5\x34", 128},
    {"\xF2\x99\xA8\x80", "\xBC\x37\xB2\x32", 128},
    {"\xF2\x99\xAA\x80", "\xBC\x37\xBF\x30", 128},
    {"\xF2\x99\xAC\x80", "\xBC\x37\xCB\x38", 128},
    {"\xF2\x99\xAE\x80", "\xBC\x37\xD8\x36", 128},
    {"\xF2\x99\xB0\x80", "\xBC\x37\xE5\x34", 128},
    {"\xF2\x99\xB2\x80", "\xBC\x37\xF2\x32", 128},
    {"\xF2\x99\xB4\x80", "\xBC\x38\x81\x30", 128},
    {"\xF2\x99\xB6\x80", "\xBC\x38\x8D\x38", 128},
    {"\xF2\x99\xB8\x80", "\xBC\x38\x9A\x36", 128},
    {"\xF2\x99\xBA\x80", "\xBC\x38\xA7\x34", 128},
    {"\xF2\x99\xBC\x80", "\xBC\x38\xB4\x32", 128},
    {"\xF2\x99\xBE\x80", "\xBC\x38\xC1\x30", 128},
    {"\xF2\x9A\x80\x80", "\xBC\x38\xCD\x38", 128},
    {"\xF2\x9A\x82\x80", "\xBC\x38\xDA\x36", 128},
    {"\xF2\x9A\x84\x80", "\xBC\x38\xE7\x34", 128},
    {"\xF2\x9A\x86\x80", "\xBC\x38\xF4\x32", 128},
    {"\xF2\x9A\x88\x80", "\xBC\x39\x83\x30", 128},
    {"\xF2\x9A\x8A\x80", "\xBC\x39\x8F\x38", 128},
    {"\xF2\x9A\x8C\x80", "\xBC\x39\x9C\x36", 128},
    {"\xF2\x9A\x8E\x80", "\xBC\x39\xA9\x34", 128},
    {"\xF2\x9A\x90\x80", "\xBC\x39\xB6\x32", 128},
    {"\xF2\x9A\x92\x80", "\xBC\x39\xC3\x30", 128},
    {"\xF2\x9A\x94\x80", "\xBC\x39\xCF\x38", 128},
    {"\xF2\x9A\x96\x80", "\xBC\x39\xDC\x36", 128},
    {"\xF2\x9A\x98\x80", "\xBC\x39\xE9\x34", 128},
    {"\xF2\x9A\x9A\x80", "\xBC\x39\xF6\x32", 128},
    {"\xF2\x9A\x9C\x80", "\xBD\x30\x85\x30", 128},
    {"\xF2\x9A\x9E\x80", "\xBD\x30\x91\x38", 128},
    {"\xF2\x9A\xA0\x80", "\xBD\x30\x9E\x36", 128},
    {"\xF2\x9A\xA2\x80", "\xBD\x30\xAB\x34", 128},
    {"\xF2\x9A\xA4\x80", "\xBD\x30\xB8\x32", 128},
    {"\xF2\x9A\xA6\x80", "\xBD\x30\xC5\x30", 128},
    {"\xF2\x9A\xA8\x80", "\xBD\x30\xD1\x38", 128},
    {"\xF2\x9A\xAA\x80", "\xBD\x30\xDE\x36", 128},
    {"\xF2\x9A\xAC\x80", "\xBD\x30\xEB\x34", 128},
    {"\xF2\x9A\xAE\x80", "\xBD\x30\xF8\x32", 128},
    {"\xF2\x9A\xB0\x80", "\xBD\x31\x87\x30", 128},
    {"\xF2\x9A\xB2\x80", "\xBD\x31\x93\x38", 128},
    {"\xF2\x9A\xB4\x80", "\xBD\x31\xA0\x36", 128},
    {"\xF2\x9A\xB6\x80", "\xBD\x31\xAD\x34", 128},
    {"\xF2\x9A\xB8\x80", "\xBD\x31\xBA\x32", 128},
    {"\xF2\x9A\xBA\x80", "\xBD\x31\xC7\x30", 128},
    {"\xF2\x9A\xBC\x80", "\xBD\x31\xD3\x38", 128},
    {"\xF2\x9A\xBE\x80", "\xBD\x31\xE0\x36", 128},
    {"\xF2\x9B\x80\x80", "\xBD\x31\xED\x34", 128},
    {"\xF2\x9B\x82\x80", "\xBD\x31\xFA\x32", 128},
    {"\xF2\x9B\x84\x80", "\xBD\x32\x89\x30", 128},
    {"\xF2\x9B\x86\x80", "\xBD\x32\x95\x38", 128},
    {"\xF2\x9B\x88\x80", "\xBD\x32\xA2\x36", 128},
    {"\xF2\x9B\x8A\x80", "\xBD\x32\xAF\x34", 128},
    {"\xF2\x9B\x8C\x80", "\xBD\x32\xBC\x32", 128},
    {"\xF2\x9B\x8E\x80", "\xBD\x32\xC9\x30", 128},
    {"\xF2\x9B\x90\x80", "\xBD\x32\xD5\x38", 128},
    {"\xF2\x9B\x92\x80", "\xBD\x32\xE2\x36", 128},
    {"\xF2\x9B\x94\x80", "\xBD\x32\xEF\x34", 128},
    {"\xF2\x9B\x96\x80", "\xBD\x32\xFC\x32", 128},
    {"\xF2\x9B\x98\x80", "\xBD\x33\x8B\x30", 128},
    {"\xF2\x9B\x9A\x80", "\xBD\x33\x97\x38", 128},
    {"\xF2\x9B\x9C\x80", "\xBD\x33\xA4\x36", 128},
    {"\xF2\x9B\x9E\x80", "\xBD\x33\xB1\x34", 128},
    {"\xF2\x9B\xA0\x80", "\xBD\x33\xBE\x32", 128},
    {"\xF2\x9B\xA2\x80", "\xBD\x33\xCB\x30", 128},
    {"\xF2\x9B\xA4\x80", "\xBD\x33\xD7\x38", 128},
    {"\xF2\x9B\xA6\x80", "\xBD\x33\xE4\x36", 128},
    {"\xF2\x9B\xA8\x80", "\xBD\x33\xF1\x34", 128},
    {"\xF2\x9B\xAA\x80", "\xBD\x33\xFE\x32", 128},
    {"\xF2\x9B\xAC\x80", "\xBD\x34\x8D\x30", 128},
    {"\xF2\x9B\xAE\x80", "\xBD\x34\x99\x38", 128},
    {"\xF2\x9B\xB0\x80", "\xBD\x34\xA6\x36", 128},
    {"\xF2\x9B\xB2\x80", "\xBD\x34\xB3\x34", 128},
    {"\xF2\x9B\xB4\x80", "\xBD\x34\xC0\x32", 128},
    {"\xF2\x9B\xB6\x80", "\xBD\x34\xCD\x30", 128},
    {"\xF2\x9B\xB8\x80", "\xBD\x34\xD9\x38", 128},
    {"\xF2\x9B\xBA\x80", "\xBD\x34\xE6\x36", 128},
    {"\xF2\x9B\xBC\x80", "\xBD\x34\xF3\x34", 128},
    {"\xF2\x9B\xBE\x80", "\xBD\x35\x82\x32", 128},
    {"\xF2\x9C\x80\x80", "\xBD\x35\x8F\x30", 128},
    {"\xF2\x9C\x82\x80", "\xBD\x35\x9B\x38", 128},
    {"\xF2\x9C\x84\x80", "\xBD\x35\xA8\x36", 128},
    {"\xF2\x9C\x86\x80", "\xBD\x35\xB5\x34", 128},
    {"\xF2\x9C\x88\x80", "\xBD\x35\xC2\x32", 128},
    {"\xF2\x9C\x8A\x80", "\xBD\x35\xCF\x30", 128},
    {"\xF2\x9C\x8C\x80", "\xBD\x35\xDB\x38", 128},
    {"\xF2\x9C\x8E\x80", "\xBD\x35\xE8\x36", 128},
    {"\xF2\x9C\x90\x80", "\xBD\x35\xF5\x34", 128},
    {"\xF2\x9C\x92\x80", "\xBD\x36\x84\x32", 128},
    {"\xF2\x9C\x94\x80", "\xBD\x36\x91\x30", 128},
    {"\xF2\x9C\x96\x80", "\xBD\x36\x9D\x38", 128},
    {"\xF2\x9C\x98\x80", "\xBD\x36\xAA\x36", 128},
    {"\xF2\x9C\x9A\x80", "\xBD\x36\xB7\x34", 128},
    {"\xF2\x9C\x9C\x80", "\xBD\x36\xC4\x32", 128},
    {"\xF2\x9C\x9E\x80", "\xBD\x36\xD1\x30", 128},
    {"\xF2\x9C\xA0\x80", "\xBD\x36\xDD\x38", 128},
    {"\xF2\x9C\xA2\x80", "\xBD\x36\xEA\x36", 128},
    {"\xF2\x9C\xA4\x80", "\xBD\x36\xF7\x34", 128},
    {"\xF2\x9C\xA6\x80", "\xBD\x37\x86\x32", 128},
    {"\xF2\x9C\xA8\x80", "\xBD\x37\x93\x30", 128},
    {"\xF2\x9C\xAA\x80", "\xBD\x37\x9F\x38", 128},
    {"\xF2\x9C\xAC\x80", "\xBD\x37\xAC\x36", 128},
    {"\xF2\x9C\xAE\x80", "\xBD\x37\xB9\x34", 128},
    {"\xF2\x9C\xB0\x80", "\xBD\x37\xC6\x32", 128},
    {"\xF2\x9C\xB2\x80", "\xBD\x37\xD3\x30", 128},
    {"\xF2\x9C\xB4\x80", "\xBD\x37\xDF\x38", 128},
    {"\xF2\x9C\xB6\x80", "\xBD\x37\xEC\x36", 128},
    {"\xF2\x9C\xB8\x80", "\xBD\x37\xF9\x34", 128},
    {"\xF2\x9C\xBA\x80", "\xBD\x38\x88\x32", 128},
    {"\xF2\x9C\xBC\x80", "\xBD\x38\x95\x30", 128},
    {"\xF2\x9C\xBE\x80", "\xBD\x38\xA1\x38", 128},
    {"\xF2\x9D\x80\x80", "\xBD\x38\xAE\x36", 128},
    {"\xF2\x9D\x82\x80", "\xBD\x38\xBB\x34", 128},
    {"\xF2\x9D\x84\x80", "\xBD\x38\xC8\x32", 128},
    {"\xF2\x9D\x86\x80", "\xBD\x38\xD5\x30", 128},
    {"\xF2\x9D\x88\x80", "\xBD\x38\xE1\x38", 128},
    {"\xF2\x9D\x8A\x80", "\xBD\x38\xEE\x36", 128},
    {"\xF2\x9D\x8C\x80", "\xBD\x38\xFB\x34", 128},
    {"\xF2\x9D\x8E\x80", "\xBD\x39\x8A\x32", 128},
    {"\xF2\x9D\x90\x80", "\xBD\x39\x97\x30", 128},
    {"\xF2\x9D\x92\x80", "\xBD\x39\xA3\x38", 128},
    {"\xF2\x9D\x94\x80", "\xBD\x39\xB0\x36", 128},
    {"\xF2\x9D\x96\x80", "\xBD\x39\xBD\x34", 128},
    {"\xF2\x9D\x98\x80", "\xBD\x39\xCA\x32", 128},
    {"\xF2\x9D\x9A\x80", "\xBD\x39\xD7\x30", 128},
    {"\xF2\x9D\x9C\x80", "\xBD\x39\xE3\x38", 128},
    {"\xF2\x9D\x9E\x80", "\xBD\x39\xF0\x36", 128},
    {"\xF2\x9D\xA0\x80", "\xBD\x39\xFD\x34", 128},
    {"\xF2\x9D\xA2\x80", "\xBE\x30\x8C\x32", 128},
    {"\xF2\x9D\xA4\x80", "\xBE\x30\x99\x30", 128},
    {"\xF2\x9D\xA6\x80", "\xBE\x30\xA5\x38", 128},
    {"\xF2\x9D\xA8\x80", "\xBE\x30\xB2\x36", 128},
    {"\xF2\x9D\xAA\x80", "\xBE\x30\xBF\x34", 128},
    {"\xF2\x9D\xAC\x80", "\xBE\x30\xCC\x32", 128},
    {"\xF2\x9D\xAE\x80", "\xBE\x30\xD9\x30", 128},
    {"\xF2\x9D\xB0\x80", "\xBE\x30\xE5\x38", 128},
    {"\xF2\x9D\xB2\x80", "\xBE\x30\xF2\x36", 128},
    {"\xF2\x9D\xB4\x80", "\xBE\x31\x81\x34", 128},
    {"\xF2\x9D\xB6\x80", "\xBE\x31\x8E\x32", 128},
    {"\xF2\x9D\xB8\x80", "\xBE\x31\x9B\x30", 128},
    {"\xF2\x9D\xBA\x80", "\xBE\x31\xA7\x38", 128},
    {"\xF2\x9D\xBC\x80", "\xBE\x31\xB4\x36", 128},
    {"\xF2\x9D\xBE\x80", "\xBE\x31\xC1\x34", 128},
    {"\xF2\x9E\x80\x80", "\xBE\x31\xCE\x32", 128},
    {"\xF2\x9E\x82\x80", "\xBE\x31\xDB\x30", 128},
    {"\xF2\x9E\x84\x80", "\xBE\x31\xE7\x38", 128},
    {"\xF2\x9E\x86\x80", "\xBE\x31\xF4\x36", 128},
    {"\xF2\x9E\x88\x80", "\xBE\x32\x83\x34", 128},
    {"\xF2\x9E\x8A\x80", "\xBE\x32\x90\x32", 128},
    {"\xF2\x9E\x8C\x80", "\xBE\x32\x9D\x30", 128},
    {"\xF2\x9E\x8E\x80", "\xBE\x32\xA9\x38", 128},
    {"\xF2\x9E\x90\x80", "\xBE\x32\xB6\x36", 128},
    {"\xF2\x9E\x92\x80", "\xBE\x32\xC3\x34", 128},
    {"\xF2\x9E\x94\x80", "\xBE\x32\xD0\x32", 128},
    {"\xF2\x9E\x96\x80", "\xBE\x32\xDD\x30", 128},
    {"\xF2\x9E\x98\x80", "\xBE\x32\xE9\x38", 128},
    {"\xF2\x9E\x9A\x80", "\xBE\x32\xF6\x36", 128},
    {"\xF2\x9E\x9C\x80", "\xBE\x33\x85\x34", 128},
    {"\xF2\x9E\x9E\x80", "\xBE\x33\x92\x32", 128},
    {"\xF2\x9E\xA0\x80", "\xBE\x33\x9F\x30", 128},
    {"\xF2\x9E\xA2\x80", "\xBE\x33\xAB\x38", 128},
    {"\xF2\x9E\xA4\x80", "\xBE\x33\xB8\x36", 128},
    {"\xF2\x9E\xA6\x80", "\xBE\x33\xC5\x34", 128},
    {"\xF2\x9E\xA8\x80", "\xBE\x33\xD2\x32", 128},
    {"\xF2\x9E\xAA\x80", "\xBE\x33\xDF\x30", 128},
    {"\xF2\x9E\xAC\x80", "\xBE\x33\xEB\x38", 128},
    {"\xF2\x9E\xAE\x80", "\xBE\x33\xF8\x36", 128},
    {"\xF2\x9E\xB0\x80", "\xBE\x34\x87\x34", 128},
    {"\xF2\x9E\xB2\x80", "\xBE\x34\x94\x32", 128},
    {"\xF2\x9E\xB4\x80", "\xBE\x34\xA1\x30", 128},
    {"\xF2\x9E\xB6\x80", "\xBE\x34\xAD\x38", 128},
    {"\xF2\x9E\xB8\x80", "\xBE\x34\xBA\x36", 128},
    {"\xF2\x9E\xBA\x80", "\xBE\x34\xC7\x34", 128},
    {"\xF2\x9E\xBC\x80", "\xBE\x34\xD4\x32", 128},
    {"\xF2\x9E\xBE\x80", "\xBE\x34\xE1\x30", 128},
    {"\xF2\x9F\x80\x80", "\xBE\x34\xED\x38", 128},
    {"\xF2\x9F\x82\x80", "\xBE\x34\xFA\x36", 128},
    {"\xF2\x9F\x84\x80", "\xBE\x35\x89\x34", 128},
    {"\xF2\x9F\x86\x80", "\xBE\x35\x96\x32", 128},
    {"\xF2\x9F\x88\x80", "\xBE\x35\xA3\x30", 128},
    {"\xF2\x9F\x8A\x80", "\xBE\x35\xAF\x38", 128},
    {"\xF2\x9F\x8C\x80", "\xBE\x35\xBC\x36", 128},
    {"\xF2\x9F\x8E\x80", "\xBE\x35\xC9\x34", 128},
    {"\xF2\x9F\x90\x80", "\xBE\x35\xD6\x32", 128},
    {"\xF2\x9F\x92\x80", "\xBE\x35\xE3\x30", 128},
    {"\xF2\x9F\x94\x80", "\xBE\x35\xEF\x38", 128},
    {"\xF2\x9F\x96\x80", "\xBE\x35\xFC\x36", 128},
    {"\xF2\x9F\x98\x80", "\xBE\x36\x8B\x34", 128},
    {"\xF2\x9F\x9A\x80", "\xBE\x36\x98\x32", 128},
    {"\xF2\x9F\x9C\x80", "\xBE\x36\xA5\x30", 128},
    {"\xF2\x9F\x9E\x80", "\xBE\x36\xB1\x38", 128},
    {"\xF2\x9F\xA0\x80", "\xBE\x36\xBE\x36", 128},
    {"\xF2\x9F\xA2\x80", "\xBE\x36\xCB\x34", 128},
    {"\xF2\x9F\xA4\x80", "\xBE\x36\xD8\x32", 128},
    {"\xF2\x9F\xA6\x80", "\xBE\x36\xE5\x30", 128},
    {"\xF2\x9F\xA8\x80", "\xBE\x36\xF1\x38", 128},
    {"\xF2\x9F\xAA\x80", "\xBE\x36\xFE\x36", 128},
    {"\xF2\x9F\xAC\x80", "\xBE\x37\x8D\x34", 128},
    {"\xF2\x9F\xAE\x80", "\xBE\x37\x9A\x32", 128},
    {"\xF2\x9F\xB0\x80", "\xBE\x37\xA7\x30", 128},
    {"\xF2\x9F\xB2\x80", "\xBE\x37\xB3\x38", 128},
    {"\xF2\x9F\xB4\x80", "\xBE\x37\xC0\x36", 128},
    {"\xF2\x9F\xB6\x80", "\xBE\x37\xCD\x34", 128},
    {"\xF2\x9F\xB8\x80", "\xBE\x37\xDA\x32", 128},
    {"\xF2\x9F\xBA\x80", "\xBE\x37\xE7\x30", 128},
    {"\xF2\x9F\xBC\x80", "\xBE\x37\xF3\x38", 128},
    {"\xF2\x9F\xBE\x80", "\xBE\x38\x82\x36", 128},
    {"\xF2\xA0\x80\x80", "\xBE\x38\x8F\x34", 128},
    {"\xF2\xA0\x82\x80", "\xBE\x38\x9C\x32", 128},
    {"\xF2\xA0\x84\x80", "\xBE\x38\xA9\x30", 128},
    {"\xF2\xA0\x86\x80", "\xBE\x38\xB5\x38", 128},
    {"\xF2\xA0\x88\x80", "\xBE\x38\xC2\x36", 128},
    {"\xF2\xA0\x8A\x80", "\xBE\x38\xCF\x34", 128},
    {"\xF2\xA0\x8C\x80", "\xBE\x38\xDC\x32", 128},
    {"\xF2\xA0\x8E\x80", "\xBE\x38\xE9\x30", 128},
    {"\xF2\xA0\x90\x80", "\xBE\x38\xF5\x38", 128},
    {"\xF2\xA0\x92\x80", "\xBE\x39\x84\x36", 128},
    {"\xF2\xA0\x94\x80", "\xBE\x39\x91\x34", 128},
    {"\xF2\xA0\x96\x80", "\xBE\x39\x9E\x32", 128},
    {"\xF2\xA0\x98\x80", "\xBE\x39\xAB\x30", 128},
    {"\xF2\xA0\x9A\x80", "\xBE\x39\xB7\x38", 128},
    {"\xF2\xA0\x9C\x80", "\xBE\x39\xC4\x36", 128},
    {"\xF2\xA0\x9E\x80", "\xBE\x39\xD1\x34", 128},
    {"\xF2\xA0\xA0\x80", "\xBE\x39\xDE\x32", 128},
    {"\xF2\xA0\xA2\x80", "\xBE\x39\xEB\x30", 128},
    {"\xF2\xA0\xA4\x80", "\xBE\x39\xF7\x38", 128},
    {"\xF2\xA0\xA6\x80", "\xBF\x30\x86\x36", 128},
    {"\xF2\xA0\xA8\x80", "\xBF\x30\x93\x34", 128},
    {"\xF2\xA0\xAA\x80", "\xBF\x30\xA0\x32", 128},
    {"\xF2\xA0\xAC\x80", "\xBF\x30\xAD\x30", 128},
    {"\xF2\xA0\xAE\x80", "\xBF\x30\xB9\x38", 128},
    {"\xF2\xA0\xB0\x80", "\xBF\x30\xC6\x36", 128},
    {"\xF2\xA0\xB2\x80", "\xBF\x30\xD3\x34", 128},
    {"\xF2\xA0\xB4\x80", "\xBF\x30\xE0\x32", 128},
    {"\xF2\xA0\xB6\x80", "\xBF\x30\xED\x30", 128},
    {"\xF2\xA0\xB8\x80", "\xBF\x30\xF9\x38", 128},
    {"\xF2\xA0\xBA\x80", "\xBF\x31\x88\x36", 128},
    {"\xF2\xA0\xBC\x80", "\xBF\x31\x95\x34", 128},
    {"\xF2\xA0\xBE\x80", "\xBF\x31\xA2\x32", 128},
    {"\xF2\xA1\x80\x80", "\xBF\x31\xAF\x30", 128},
    {"\xF2\xA1\x82\x80", "\xBF\x31\xBB\x38", 128},
    {"\xF2\xA1\x84\x80", "\xBF\x31\xC8\x36", 128},
    {"\xF2\xA1\x86\x80", "\xBF\x31\xD5\x34", 128},
    {"\xF2\xA1\x88\x80", "\xBF\x31\xE2\x32", 128},
    {"\xF2\xA1\x8A\x80", "\xBF\x31\xEF\x30", 128},
    {"\xF2\xA1\x8C\x80", "\xBF\x31\xFB\x38", 128},
    {"\xF2\xA1\x8E\x80", "\xBF\x32\x8A\x36", 128},
    {"\xF2\xA1\x90\x80", "\xBF\x32\x97\x34", 128},
    {"\xF2\xA1\x92\x80", "\xBF\x32\xA4\x32", 128},
    {"\xF2\xA1\x94\x80", "\xBF\x32\xB1\x30", 128},
    {"\xF2\xA1\x96\x80", "\xBF\x32\xBD\x38", 128},
    {"\xF2\xA1\x98\x80", "\xBF\x32\xCA\x36", 128},
    {"\xF2\xA1\x9A\x80", "\xBF\x32\xD7\x34", 128},
    {"\xF2\xA1\x9C\x80", "\xBF\x32\xE4\x32", 128},
    {"\xF2\xA1\x9E\x80", "\xBF\x32\xF1\x30", 128},
    {"\xF2\xA1\xA0\x80", "\xBF\x32\xFD\x38", 128},
    {"\xF2\xA1\xA2\x80", "\xBF\x33\x8C\x36", 128},
    {"\xF2\xA1\xA4\x80", "\xBF\x33\x99\x34", 128},
    {"\xF2\xA1\xA6\x80", "\xBF\x33\xA6\x32", 128},
    {"\xF2\xA1\xA8\x80", "\xBF\x33\xB3\x30", 128},
    {"\xF2\xA1\xAA\x80", "\xBF\x33\xBF\x38", 128},
    {"\xF2\xA1\xAC\x80", "\xBF\x33\xCC\x36", 128},
    {"\xF2\xA1\xAE\x80", "\xBF\x33\xD9\x34", 128},
    {"\xF2\xA1\xB0\x80", "\xBF\x33\xE6\x32", 128},
    {"\xF2\xA1\xB2\x80", "\xBF\x33\xF3\x30", 128},
    {"\xF2\xA1\xB4\x80", "\xBF\x34\x81\x38", 128},
    {"\xF2\xA1\xB6\x80", "\xBF\x34\x8E\x36", 128},
    {"\xF2\xA1\xB8\x80", "\xBF\x34\x9B\x34", 128},
    {"\xF2\xA1\xBA\x80", "\xBF\x34\xA8\x32", 128},
    {"\xF2\xA1\xBC\x80", "\xBF\x34\xB5\x30", 128},
    {"\xF2\xA1\xBE\x80", "\xBF\x34\xC1\x38", 128},
    {"\xF2\xA2\x80\x80", "\xBF\x34\xCE\x36", 128},
    {"\xF2\xA2\x82\x80", "\xBF\x34\xDB\x34", 128},
    {"\xF2\xA2\x84\x80", "\xBF\x34\xE8\x32", 128},
    {"\xF2\xA2\x86\x80", "\xBF\x34\xF5\x30", 128},
    {"\xF2\xA2\x88\x80", "\xBF\x35\x83\x38", 128},
    {"\xF2\xA2\x8A\x80", "\xBF\x35\x90\x36", 128},
    {"\xF2\xA2\x8C\x80", "\xBF\x35\x9D\x34", 128},
    {"\xF2\xA2\x8E\x80", "\xBF\x35\xAA\x32", 128},
    {"\xF2\xA2\x90\x80", "\xBF\x35\xB7\x30", 128},
    {"\xF2\xA2\x92\x80", "\xBF\x35\xC3\x38", 128},
    {"\xF2\xA2\x94\x80", "\xBF\x35\xD0\x36", 128},
    {"\xF2\xA2\x96\x80", "\xBF\x35\xDD\x34", 128},
    {"\xF2\xA2\x98\x80", "\xBF\x35\xEA\x32", 128},
    {"\xF2\xA2\x9A\x80", "\xBF\x35\xF7\x30", 128},
    {"\xF2\xA2\x9C\x80", "\xBF\x36\x85\x38", 128},
    {"\xF2\xA2\x9E\x80", "\xBF\x36\x92\x36", 128},
    {"\xF2\xA2\xA0\x80", "\xBF\x36\x9F\x34", 128},
    {"\xF2\xA2\xA2\x80", "\xBF\x36\xAC\x32", 128},
    {"\xF2\xA2\xA4\x80", "\xBF\x36\xB9\x30", 128},
    {"\xF2\xA2\xA6\x80", "\xBF\x36\xC5\x38", 128},
    {"\xF2\xA2\xA8\x80", "\xBF\x36\xD2\x36", 128},
    {"\xF2\xA2\xAA\x80", "\xBF\x36\xDF\x34", 128},
    {"\xF2\xA2\xAC\x80", "\xBF\x36\xEC\x32", 128},
    {"\xF2\xA2\xAE\x80", "\xBF\x36\xF9\x30", 128},
    {"\xF2\xA2\xB0\x80", "\xBF\x37\x87\x38", 128},
    {"\xF2\xA2\xB2\x80", "\xBF\x37\x94\x36", 128},
    {"\xF2\xA2\xB4\x80", "\xBF\x37\xA1\x34", 128},
    {"\xF2\xA2\xB6\x80", "\xBF\x37\xAE\x32", 128},
    {"\xF2\xA2\xB8\x80", "\xBF\x37\xBB\x30", 128},
    {"\xF2\xA2\xBA\x80", "\xBF\x37\xC7\x38", 128},
    {"\xF2\xA2\xBC\x80", "\xBF\x37\xD4\x36", 128},
    {"\xF2\xA2\xBE\x80", "\xBF\x37\xE1\x34", 128},
    {"\xF2\xA3\x80\x80", "\xBF\x37\xEE\x32", 128},
    {"\xF2\xA3\x82\x80", "\xBF\x37\xFB\x30", 128},
    {"\xF2\xA3\x84\x80", "\xBF\x38\x89\x38", 128},
    {"\xF2\xA3\x86\x80", "\xBF\x38\x96\x36", 128},
    {"\xF2\xA3\x88\x80", "\xBF\x38\xA3\x34", 128},
    {"\xF2\xA3\x8A\x80", "\xBF\x38\xB0\x32", 128},
    {"\xF2\xA3\x8C\x80", "\xBF\x38\xBD\x30", 128},
    {"\xF2\xA3\x8E\x80", "\xBF\x38\xC9\x38", 128},
    {"\xF2\xA3\x90\x80", "\xBF\x38\xD6\x36", 128},
    {"\xF2\xA3\x92\x80", "\xBF\x38\xE3\x34", 128},
    {"\xF2\xA3\x94\x80", "\xBF\x38\xF0\x32", 128},
    {"\xF2\xA3\x96\x80", "\xBF\x38\xFD\x30", 128},
    {"\xF2\xA3\x98\x80", "\xBF\x39\x8B\x38", 128},
    {"\xF2\xA3\x9A\x80", "\xBF\x39\x98\x36", 128},
    {"\xF2\xA3\x9C\x80", "\xBF\x39\xA5\x34", 128},
    {"\xF2\xA3\x9E\x80", "\xBF\x39\xB2\x32", 128},
    {"\xF2\xA3\xA0\x80", "\xBF\x39\xBF\x30", 128},
    {"\xF2\xA3\xA2\x80", "\xBF\x39\xCB\x38", 128},
    {"\xF2\xA3\xA4\x80", "\xBF\x39\xD8\x36", 128},
    {"\xF2\xA3\xA6\x80", "\xBF\x39\xE5\x34", 128},
    {"\xF2\xA3\xA8\x80", "\xBF\x39\xF2\x32", 128},
    {"\xF2\xA3\xAA\x80", "\xC0\x30\x81\x30", 128},
    {"\xF2\xA3\xAC\x80", "\xC0\x30\x8D\x38", 128},
    {"\xF2\xA3\xAE\x80", "\xC0\x30\x9A\x36", 128},
    {"\xF2\xA3\xB0\x80", "\xC0\x30\xA7\x34", 128},
    {"\xF2\xA3\xB2\x80", "\xC0\x30\xB4\x32", 128},
    {"\xF2\xA3\xB4\x80", "\xC0\x30\xC1\x30", 128},
    {"\xF2\xA3\xB6\x80", "\xC0\x30\xCD\x38", 128},
    {"\xF2\xA3\xB8\x80", "\xC0\x30\xDA\x36", 128},
    {"\xF2\xA3\xBA\x80", "\xC0\x30\xE7\x34", 128},
    {"\xF2\xA3\xBC\x80", "\xC0\x30\xF4\x32", 128},
    {"\xF2\xA3\xBE\x80", "\xC0\x31\x83\x30", 128},
    {"\xF2\xA4\x80\x80", "\xC0\x31\x8F\x38", 128},
    {"\xF2\xA4\x82\x80", "\xC0\x31\x9C\x36", 128},
    {"\xF2\xA4\x84\x80", "\xC0\x31\xA9\x34", 128},
    {"\xF2\xA4\x86\x80", "\xC0\x31\xB6\x32", 128},
    {"\xF2\xA4\x88\x80", "\xC0\x31\xC3\x30", 128},
    {"\xF2\xA4\x8A\x80", "\xC0\x31\xCF\x38", 128},
    {"\xF2\xA4\x8C\x80", "\xC0\x31\xDC\x36", 128},
    {"\xF2\xA4\x8E\x80", "\xC0\x31\xE9\x34", 128},
    {"\xF2\xA4\x90\x80", "\xC0\x31\xF6\x32", 128},
    {"\xF2\xA4\x92\x80", "\xC0\x32\x85\x30", 128},
    {"\xF2\xA4\x94\x80", "\xC0\x32\x91\x38", 128},
    {"\xF2\xA4\x96\x80", "\xC0\x32\x9E\x36", 128},
    {"\xF2\xA4\x98\x80", "\xC0\x32\xAB\x34", 128},
    {"\xF2\xA4\x9A\x80", "\xC0\x32\xB8\x32", 128},
    {"\xF2\xA4\x9C\x80", "\xC0\x32\xC5\x30", 128},
    {"\xF2\xA4\x9E\x80", "\xC0\x32\xD1\x38", 128},
    {"\xF2\xA4\xA0\x80", "\xC0\x32\xDE\x36", 128},
    {"\xF2\xA4\xA2\x80", "\xC0\x32\xEB\x34", 128},
    {"\xF2\xA4\xA4\x80", "\xC0\x32\xF8\x32", 128},
    {"\xF2\xA4\xA6\x80", "\xC0\x33\x87\x30", 128},
    {"\xF2\xA4\xA8\x80", "\xC0\x33\x93\x38", 128},
    {"\xF2\xA4\xAA\x80", "\xC0\x33\xA0\x36", 128},
    {"\xF2\xA4\xAC\x80", "\xC0\x33\xAD\x34", 128},
    {"\xF2\xA4\xAE\x80", "\xC0\x33\xBA\x32", 128},
    {"\xF2\xA4\xB0\x80", "\xC0\x33\xC7\x30", 128},
    {"\xF2\xA4\xB2\x80", "\xC0\x33\xD3\x38", 128},
    {"\xF2\xA4\xB4\x80", "\xC0\x33\xE0\x36", 128},
    {"\xF2\xA4\xB6\x80", "\xC0\x33\xED\x34", 128},
    {"\xF2\xA4\xB8\x80", "\xC0\x33\xFA\x32", 128},
    {"\xF2\xA4\xBA\x80", "\xC0\x34\x89\x30", 128},
    {"\xF2\xA4\xBC\x80", "\xC0\x34\x95\x38", 128},
    {"\xF2\xA4\xBE\x80", "\xC0\x34\xA2\x36", 128},
    {"\xF2\xA5\x80\x80", "\xC0\x34\xAF\x34", 128},
    {"\xF2\xA5\x82\x80", "\xC0\x34\xBC\x32", 128},
    {"\xF2\xA5\x84\x80", "\xC0\x34\xC9\x30", 128},
    {"\xF2\xA5\x86\x80", "\xC0\x34\xD5\x38", 128},
    {"\xF2\xA5\x88\x80", "\xC0\x34\xE2\x36", 128},
    {"\xF2\xA5\x8A\x80", "\xC0\x34\xEF\x34", 128},
    {"\xF2\xA5\x8C\x80", "\xC0\x34\xFC\x32", 128},
    {"\xF2\xA5\x8E\x80", "\xC0\x35\x8B\x30", 128},
    {"\xF2\xA5\x90\x80", "\xC0\x35\x97\x38", 128},
    {"\xF2\xA5\x92\x80", "\xC0\x35\xA4\x36", 128},
    {"\xF2\xA5\x94\x80", "\xC0\x35\xB1\x34", 128},
    {"\xF2\xA5\x96\x80", "\xC0\x35\xBE\x32", 128},
    {"\xF2\xA5\x98\x80", "\xC0\x35\xCB\x30", 128},
    {"\xF2\xA5\x9A\x80", "\xC0\x35\xD7\x38", 128},
    {"\xF2\xA5\x9C\x80", "\xC0\x35\xE4\x36", 128},
    {"\xF2\xA5\x9E\x80", "\xC0\x35\xF1\x34", 128},
    {"\xF2\xA5\xA0\x80", "\xC0\x35\xFE\x32", 128},
    {"\xF2\xA5\xA2\x80", "\xC0\x36\x8D\x30", 128},
    {"\xF2\xA5\xA4\x80", "\xC0\x36\x99\x38", 128},
    {"\xF2\xA5\xA6\x80", "\xC0\x36\xA6\x36", 128},
    {"\xF2\xA5\xA8\x80", "\xC0\x36\xB3\x34", 128},
    {"\xF2\xA5\xAA\x80", "\xC0\x36\xC0\x32", 128},
    {"\xF2\xA5\xAC\x80", "\xC0\x36\xCD\x30", 128},
    {"\xF2\xA5\xAE\x80", "\xC0\x36\xD9\x38", 128},
    {"\xF2\xA5\xB0\x80", "\xC0\x36\xE6\x36", 128},
    {"\xF2\xA5\xB2\x80", "\xC0\x36\xF3\x34", 128},
    {"\xF2\xA5\xB4\x80", "\xC0\x37\x82\x32", 128},
    {"\xF2\xA5\xB6\x80", "\xC0\x37\x8F\x30", 128},
    {"\xF2\xA5\xB8\x80", "\xC0\x37\x9B\x38", 128},
    {"\xF2\xA5\xBA\x80", "\xC0\x37\xA8\x36", 128},
    {"\xF2\xA5\xBC\x80", "\xC0\x37\xB5\x34", 128},
    {"\xF2\xA5\xBE\x80", "\xC0\x37\xC2\x32", 128},
    {"\xF2\xA6\x80\x80", "\xC0\x37\xCF\x30", 128},
    {"\xF2\xA6\x82\x80", "\xC0\x37\xDB\x38", 128},
    {"\xF2\xA6\x84\x80", "\xC0\x37\xE8\x36", 128},
    {"\xF2\xA6\x86\x80", "\xC0\x37\xF5\x34", 128},
    {"\xF2\xA6\x88\x80", "\xC0\x38\x84\x32", 128},
    {"\xF2\xA6\x8A\x80", "\xC0\x38\x91\x30", 128},
    {"\xF2\xA6\x8C\x80", "\xC0\x38\x9D\x38", 128},
    {"\xF2\xA6\x8E\x80", "\xC0\x38\xAA\x36", 128},
    {"\xF2\xA6\x90\x80", "\xC0\x38\xB7\x34", 128},
    {"\xF2\xA6\x92\x80", "\xC0\x38\xC4\x32", 128},
    {"\xF2\xA6\x94\x80", "\xC0\x38\xD1\x30", 128},
    {"\xF2\xA6\x96\x80", "\xC0\x38\xDD\x38", 128},
    {"\xF2\xA6\x98\x80", "\xC0\x38\xEA\x36", 128},
    {"\xF2\xA6\x9A\x80", "\xC0\x38\xF7\x34", 128},
    {"\xF2\xA6\x9C\x80", "\xC0\x39\x86\x32", 128},
    {"\xF2\xA6\x9E\x80", "\xC0\x39\x93\x30", 128},
    {"\xF2\xA6\xA0\x80", "\xC0\x39\x9F\x38", 128},
    {"\xF2\xA6\xA2\x80", "\xC0\x39\xAC\x36", 128},
    {"\xF2\xA6\xA4\x80", "\xC0\x39\xB9\x34", 128},
    {"\xF2\xA6\xA6\x80", "\xC0\x39\xC6\x32", 128},
    {"\xF2\xA6\xA8\x80", "\xC0\x39\xD3\x30", 128},
    {"\xF2\xA6\xAA\x80", "\xC0\x39\xDF\x38", 128},
    {"\xF2\xA6\xAC\x80", "\xC0\x39\xEC\x36", 128},
    {"\xF2\xA6\xAE\x80", "\xC0\x39\xF9\x34", 128},
    {"\xF2\xA6\xB0\x80", "\xC1\x30\x88\x32", 128},
    {"\xF2\xA6\xB2\x80", "\xC1\x30\x95\x30", 128},
    {"\xF2\xA6\xB4\x80", "\xC1\x30\xA1\x38", 128},
    {"\xF2\xA6\xB6\x80", "\xC1\x30\xAE\x36", 128},
    {"\xF2\xA6\xB8\x80", "\xC1\x30\xBB\x34", 128},
    {"\xF2\xA6\xBA\x80", "\xC1\x30\xC8\x32", 128},
    {"\xF2\xA6\xBC\x80", "\xC1\x30\xD5\x30", 128},
    {"\xF2\xA6\xBE\x80", "\xC1\x30\xE1\x38", 128},
    {"\xF2\xA7\x80\x80", "\xC1\x30\xEE\x36", 128},
    {"\xF2\xA7\x82\x80", "\xC1\x30\xFB\x34", 128},
    {"\xF2\xA7\x84\x80", "\xC1\x31\x8A\x32", 128},
    {"\xF2\xA7\x86\x80", "\xC1\x31\x97\x30", 128},
    {"\xF2\xA7\x88\x80", "\xC1\x31\xA3\x38", 128},
    {"\xF2\xA7\x8A\x80", "\xC1\x31\xB0\x36", 128},
    {"\xF2\xA7\x8C\x80", "\xC1\x31\xBD\x34", 128},
    {"\xF2\xA7\x8E\x80", "\xC1\x31\xCA\x32", 128},
    {"\xF2\xA7\x90\x80", "\xC1\x31\xD7\x30", 128},
    {"\xF2\xA7\x92\x80", "\xC1\x31\xE3\x38", 128},
    {"\xF2\xA7\x94\x80", "\xC1\x31\xF0\x36", 128},
    {"\xF2\xA7\x96\x80", "\xC1\x31\xFD\x34", 128},
    {"\xF2\xA7\x98\x80", "\xC1\x32\x8C\x32", 128},
    {"\xF2\xA7\x9A\x80", "\xC1\x32\x99\x30", 128},
    {"\xF2\xA7\x9C\x80", "\xC1\x32\xA5\x38", 128},
    {"\xF2\xA7\x9E\x80", "\xC1\x32\xB2\x36", 128},
    {"\xF2\xA7\xA0\x80", "\xC1\x32\xBF\x34", 128},
    {"\xF2\xA7\xA2\x80", "\xC1\x32\xCC\x32", 128},
    {"\xF2\xA7\xA4\x80", "\xC1\x32\xD9\x30", 128},
    {"\xF2\xA7\xA6\x80", "\xC1\x32\xE5\x38", 128},
    {"\xF2\xA7\xA8\x80", "\xC1\x32\xF2\x36", 128},
    {"\xF2\xA7\xAA\x80", "\xC1\x33\x81\x34", 128},
    {"\xF2\xA7\xAC\x80", "\xC1\x33\x8E\x32", 128},
    {"\xF2\xA7\xAE\x80", "\xC1\x33\x9B\x30", 128},
    {"\xF2\xA7\xB0\x80", "\xC1\x33\xA7\x38", 128},
    {"\xF2\xA7\xB2\x80", "\xC1\x33\xB4\x36", 128},
    {"\xF2\xA7\xB4\x80", "\xC1\x33\xC1\x34", 128},
    {"\xF2\xA7\xB6\x80", "\xC1\x33\xCE\x32", 128},
    {"\xF2\xA7\xB8\x80", "\xC1\x33\xDB\x30", 128},
    {"\xF2\xA7\xBA\x80", "\xC1\x33\xE7\x38", 128},
    {"\xF2\xA7\xBC\x80", "\xC1\x33\xF4\x36", 128},
    {"\xF2\xA7\xBE\x80", "\xC1\x34\x83\x34", 128},
    {"\xF2\xA8\x80\x80", "\xC1\x34\x90\x32", 128},
    {"\xF2\xA8\x82\x80", "\xC1\x34\x9D\x30", 128},
    {"\xF2\xA8\x84\x80", "\xC1\x34\xA9\x38", 128},
    {"\xF2\xA8\x86\x80", "\xC1\x34\xB6\x36", 128},
    {"\xF2\xA8\x88\x80", "\xC1\x34\xC3\x34", 128},
    {"\xF2\xA8\x8A\x80", "\xC1\x34\xD0\x32", 128},
    {"\xF2\xA8\x8C\x80", "\xC1\x34\xDD\x30", 128},
    {"\xF2\xA8\x8E\x80", "\xC1\x34\xE9\x38", 128},
    {"\xF2\xA8\x90\x80", "\xC1\x34\xF6\x36", 128},
    {"\xF2\xA8\x92\x80", "\xC1\x35\x85\x34", 128},
    {"\xF2\xA8\x94\x80", "\xC1\x35\x92\x32", 128},
    {"\xF2\xA8\x96\x80", "\xC1\x35\x9F\x30", 128},
    {"\xF2\xA8\x98\x80", "\xC1\x35\xAB\x38", 128},
    {"\xF2\xA8\x9A\x80", "\xC1\x35\xB8\x36", 128},
    {"\xF2\xA8\x9C\x80", "\xC1\x35\xC5\x34", 128},
    {"\xF2\xA8\x9E\x80", "\xC1\x35\xD2\x32", 128},
    {"\xF2\xA8\xA0\x80", "\xC1\x35\xDF\x30", 128},
    {"\xF2\xA8\xA2\x80", "\xC1\x35\xEB\x38", 128},
    {"\xF2\xA8\xA4\x80", "\xC1\x35\xF8\x36", 128},
    {"\xF2\xA8\xA6\x80", "\xC1\x36\x87\x34", 128},
    {"\xF2\xA8\xA8\x80", "\xC1\x36\x94\x32", 128},
    {"\xF2\xA8\xAA\x80", "\xC1\x36\xA1\x30", 128},
    {"\xF2\xA8\xAC\x80", "\xC1\x36\xAD\x38", 128},
    {"\xF2\xA8\xAE\x80", "\xC1\x36\xBA\x36", 128},
    {"\xF2\xA8\xB0\x80", "\xC1\x36\xC7\x34", 128},
    {"\xF2\xA8\xB2\x80", "\xC1\x36\xD4\x32", 128},
    {"\xF2\xA8\xB4\x80", "\xC1\x36\xE1\x30", 128},
    {"\xF2\xA8\xB6\x80", "\xC1\x36\xED\x38", 128},
    {"\xF2\xA8\xB8\x80", "\xC1\x36\xFA\x36", 128},
    {"\xF2\xA8\xBA\x80", "\xC1\x37\x89\x34", 128},
    {"\xF2\xA8\xBC\x80", "\xC1\x37\x96\x32", 128},
    {"\xF2\xA8\xBE\x80", "\xC1\x37\xA3\x30", 128},
    {"\xF2\xA9\x80\x80", "\xC1\x37\xAF\x38", 128},
    {"\xF2\xA9\x82\x80", "\xC1\x37\xBC\x36", 128},
    {"\xF2\xA9\x84\x80", "\xC1\x37\xC9\x34", 128},
    {"\xF2\xA9\x86\x80", "\xC1\x37\xD6\x32", 128},
    {"\xF2\xA9\x88\x80", "\xC1\x37\xE3\x30", 128},
    {"\xF2\xA9\x8A\x80", "\xC1\x37\xEF\x38", 128},
    {"\xF2\xA9\x8C\x80", "\xC1\x37\xFC\x36", 128},
    {"\xF2\xA9\x8E\x80", "\xC1\x38\x8B\x34", 128},
    {"\xF2\xA9\x90\x80", "\xC1\x38\x98\x32", 128},
    {"\xF2\xA9\x92\x80", "\xC1\x38\xA5\x30", 128},
    {"\xF2\xA9\x94\x80", "\xC1\x38\xB1\x38", 128},
    {"\xF2\xA9\x96\x80", "\xC1\x38\xBE\x36", 128},
    {"\xF2\xA9\x98\x80", "\xC1\x38\xCB\x34", 128},
    {"\xF2\xA9\x9A\x80", "\xC1\x38\xD8\x32", 128},
    {"\xF2\xA9\x9C\x80", "\xC1\x38\xE5\x30", 128},
    {"\xF2\xA9\x9E\x80", "\xC1\x38\xF1\x38", 128},
    {"\xF2\xA9\xA0\x80", "\xC1\x38\xFE\x36", 128},
    {"\xF2\xA9\xA2\x80", "\xC1\x39\x8D\x34", 128},
    {"\xF2\xA9\xA4\x80", "\xC1\x39\x9A\x32", 128},
    {"\xF2\xA9\xA6\x80", "\xC1\x39\xA7\x30", 128},
    {"\xF2\xA9\xA8\x80", "\xC1\x39\xB3\x38", 128},
    {"\xF2\xA9\xAA\x80", "\xC1\x39\xC0\x36", 128},
    {"\xF2\xA9\xAC\x80", "\xC1\x39\xCD\x34", 128},
    {"\xF2\xA9\xAE\x80", "\xC1\x39\xDA\x32", 128},
    {"\xF2\xA9\xB0\x80", "\xC1\x39\xE7\x30", 128},
    {"\xF2\xA9\xB2\x80", "\xC1\x39\xF3\x38", 128},
    {"\xF2\xA9\xB4\x80", "\xC2\x30\x82\x36", 128},
    {"\xF2\xA9\xB6\x80", "\xC2\x30\x8F\x34", 128},
    {"\xF2\xA9\xB8\x80", "\xC2\x30\x9C\x32", 128},
    {"\xF2\xA9\xBA\x80", "\xC2\x30\xA9\x30", 128},
    {"\xF2\xA9\xBC\x80", "\xC2\x30\xB5\x38", 128},
    {"\xF2\xA9\xBE\x80", "\xC2\x30\xC2\x36", 128},
    {"\xF2\xAA\x80\x80", "\xC2\x30\xCF\x34", 128},
    {"\xF2\xAA\x82\x80", "\xC2\x30\xDC\x32", 128},
    {"\xF2\xAA\x84\x80", "\xC2\x30\xE9\x30", 128},
    {"\xF2\xAA\x86\x80", "\xC2\x30\xF5\x38", 128},
    {"\xF2\xAA\x88\x80", "\xC2\x31\x84\x36", 128},
    {"\xF2\xAA\x8A\x80", "\xC2\x31\x91\x34", 128},
    {"\xF2\xAA\x8C\x80", "\xC2\x31\x9E\x32", 128},
    {"\xF2\xAA\x8E\x80", "\xC2\x31\xAB\x30", 128},
    {"\xF2\xAA\x90\x80", "\xC2\x31\xB7\x38", 128},
    {"\xF2\xAA\x92\x80", "\xC2\x31\xC4\x36", 128},
    {"\xF2\xAA\x94\x80", "\xC2\x31\xD1\x34", 128},
    {"\xF2\xAA\x96\x80", "\xC2\x31\xDE\x32", 128},
    {"\xF2\xAA\x98\x80", "\xC2\x31\xEB\x30", 128},
    {"\xF2\xAA\x9A\x80", "\xC2\x31\xF7\x38", 128},
    {"\xF2\xAA\x9C\x80", "\xC2\x32\x86\x36", 128},
    {"\xF2\xAA\x9E\x80", "\xC2\x32\x93\x34", 128},
    {"\xF2\xAA\xA0\x80", "\xC2\x32\xA0\x32", 128},
    {"\xF2\xAA\xA2\x80", "\xC2\x32\xAD\x30", 128},
    {"\xF2\xAA\xA4\x80", "\xC2\x32\xB9\x38", 128},
    {"\xF2\xAA\xA6\x80", "\xC2\x32\xC6\x36", 128},
    {"\xF2\xAA\xA8\x80", "\xC2\x32\xD3\x34", 128},
    {"\xF2\xAA\xAA\x80", "\xC2\x32\xE0\x32", 128},
    {"\xF2\xAA\xAC\x80", "\xC2\x32\xED\x30", 128},
    {"\xF2\xAA\xAE\x80", "\xC2\x32\xF9\x38", 128},
    {"\xF2\xAA\xB0\x80", "\xC2\x33\x88\x36", 128},
    {"\xF2\xAA\xB2\x80", "\xC2\x33\x95\x34", 128},
    {"\xF2\xAA\xB4\x80", "\xC2\x33\xA2\x32", 128},
    {"\xF2\xAA\xB6\x80", "\xC2\x33\xAF\x30", 128},
    {"\xF2\xAA\xB8\x80", "\xC2\x33\xBB\x38", 128},
    {"\xF2\xAA\xBA\x80", "\xC2\x33\xC8\x36", 128},
    {"\xF2\xAA\xBC\x80", "\xC2\x33\xD5\x34", 128},
    {"\xF2\xAA\xBE\x80", "\xC2\x33\xE2\x32", 128},
    {"\xF2\xAB\x80\x80", "\xC2\x33\xEF\x30", 128},
    {"\xF2\xAB\x82\x80", "\xC2\x33\xFB\x38", 128},
    {"\xF2\xAB\x84\x80", "\xC2\x34\x8A\x36", 128},
    {"\xF2\xAB\x86\x80", "\xC2\x34\x97\x34", 128},
    {"\xF2\xAB\x88\x80", "\xC2\x34\xA4\x32", 128},
    {"\xF2\xAB\x8A\x80", "\xC2\x34\xB1\x30", 128},
    {"\xF2\xAB\x8C\x80", "\xC2\x34\xBD\x38", 128},
    {"\xF2\xAB\x8E\x80", "\xC2\x34\xCA\x36", 128},
    {"\xF2\xAB\x90\x80", "\xC2\x34\xD7\x34", 128},
    {"\xF2\xAB\x92\x80", "\xC2\x34\xE4\x32", 128},
    {"\xF2\xAB\x94\x80", "\xC2\x34\xF1\x30", 128},
    {"\xF2\xAB\x96\x80", "\xC2\x34\xFD\x38", 128},
    {"\xF2\xAB\x98\x80", "\xC2\x35\x8C\x36", 128},
    {"\xF2\xAB\x9A\x80", "\xC2\x35\x99\x34", 128},
    {"\xF2\xAB\x9C\x80", "\xC2\x35\xA6\x32", 128},
    {"\xF2\xAB\x9E\x80", "\xC2\x35\xB3\x30", 128},
    {"\xF2\xAB\xA0\x80", "\xC2\x35\xBF\x38", 128},
    {"\xF2\xAB\xA2\x80", "\xC2\x35\xCC\x36", 128},
    {"\xF2\xAB\xA4\x80", "\xC2\x35\xD9\x34", 128},
    {"\xF2\xAB\xA6\x80", "\xC2\x35\xE6\x32", 128},
    {"\xF2\xAB\xA8\x80", "\xC2\x35\xF3\x30", 128},
    {"\xF2\xAB\xAA\x80", "\xC2\x36\x81\x38", 128},
    {"\xF2\xAB\xAC\x80", "\xC2\x36\x8E\x36", 128},
    {"\xF2\xAB\xAE\x80", "\xC2\x36\x9B\x34", 128},
    {"\xF2\xAB\xB0\x80", "\xC2\x36\xA8\x32", 128},
    {"\xF2\xAB\xB2\x80", "\xC2\x36\xB5\x30", 128},
    {"\xF2\xAB\xB4\x80", "\xC2\x36\xC1\x38", 128},
    {"\xF2\xAB\xB6\x80", "\xC2\x36\xCE\x36", 128},
    {"\xF2\xAB\xB8\x80", "\xC2\x36\xDB\x34", 128},
    {"\xF2\xAB\xBA\x80", "\xC2\x36\xE8\x32", 128},
    {"\xF2\xAB\xBC\x80", "\xC2\x36\xF5\x30", 128},
    {"\xF2\xAB\xBE\x80", "\xC2\x37\x83\x38", 128},
    {"\xF2\xAC\x80\x80", "\xC2\x37\x90\x36", 128},
    {"\xF2\xAC\x82\x80", "\xC2\x37\x9D\x34", 128},
    {"\xF2\xAC\x84\x80", "\xC2\x37\xAA\x32", 128},
    {"\xF2\xAC\x86\x80", "\xC2\x37\xB7\x30", 128},
    {"\xF2\xAC\x88\x80", "\xC2\x37\xC3\x38", 128},
    {"\xF2\xAC\x8A\x80", "\xC2\x37\xD0\x36", 128},
    {"\xF2\xAC\x8C\x80", "\xC2\x37\xDD\x34", 128},
    {"\xF2\xAC\x8E\x80", "\xC2\x37\xEA\x32", 128},
    {"\xF2\xAC\x90\x80", "\xC2\x37\xF7\x30", 128},
    {"\xF2\xAC\x92\x80", "\xC2\x38\x85\x38", 128},
    {"\xF2\xAC\x94\x80", "\xC2\x38\x92\x36", 128},
    {"\xF2\xAC\x96\x80", "\xC2\x38\x9F\x34", 128},
    {"\xF2\xAC\x98\x80", "\xC2\x38\xAC\x32", 128},
    {"\xF2\xAC\x9A\x80", "\xC2\x38\xB9\x30", 128},
    {"\xF2\xAC\x9C\x80", "\xC2\x38\xC5\x38", 128},
    {"\xF2\xAC\x9E\x80", "\xC2\x38\xD2\x36", 128},
    {"\xF2\xAC\xA0\x80", "\xC2\x38\xDF\x34", 128},
    {"\xF2\xAC\xA2\x80", "\xC2\x38\xEC\x32", 128},
    {"\xF2\xAC\xA4\x80", "\xC2\x38\xF9\x30", 128},
    {"\xF2\xAC\xA6\x80", "\xC2\x39\x87\x38", 128},
    {"\xF2\xAC\xA8\x80", "\xC2\x39\x94\x36", 128},
    {"\xF2\xAC\xAA\x80", "\xC2\x39\xA1\x34", 128},
    {"\xF2\xAC\xAC\x80", "\xC2\x39\xAE\x32", 128},
    {"\xF2\xAC\xAE\x80", "\xC2\x39\xBB\x30", 128},
    {"\xF2\xAC\xB0\x80", "\xC2\x39\xC7\x38", 128},
    {"\xF2\xAC\xB2\x80", "\xC2\x39\xD4\x36", 128},
    {"\xF2\xAC\xB4\x80", "\xC2\x39\xE1\x34", 128},
    {"\xF2\xAC\xB6\x80", "\xC2\x39\xEE\x32", 128},
    {"\xF2\xAC\xB8\x80", "\xC2\x39\xFB\x30", 128},
    {"\xF2\xAC\xBA\x80", "\xC3\x30\x89\x38", 128},
    {"\xF2\xAC\xBC\x80", "\xC3\x30\x96\x36", 128},
    {"\xF2\xAC\xBE\x80", "\xC3\x30\xA3\x34", 128},
    {"\xF2\xAD\x80\x80", "\xC3\x30\xB0\x32", 128},
    {"\xF2\xAD\x82\x80", "\xC3\x30\xBD\x30", 128},
    {"\xF2\xAD\x84\x80", "\xC3\x30\xC9\x38", 128},
    {"\xF2\xAD\x86\x80", "\xC3\x30\xD6\x36", 128},
    {"\xF2\xAD\x88\x80", "\xC3\x30\xE3\x34", 128},
    {"\xF2\xAD\x8A\x80", "\xC3\x30\xF0\x32", 128},
    {"\xF2\xAD\x8C\x80", "\xC3\x30\xFD\x30", 128},
    {"\xF2\xAD\x8E\x80", "\xC3\x31\x8B\x38", 128},
    {"\xF2\xAD\x90\x80", "\xC3\x31\x98\x36", 128},
    {"\xF2\xAD\x92\x80", "\xC3\x31\xA5\x34", 128},
    {"\xF2\xAD\x94\x80", "\xC3\x31\xB2\x32", 128},
    {"\xF2\xAD\x96\x80", "\xC3\x31\xBF\x30", 128},
    {"\xF2\xAD\x98\x80", "\xC3\x31\xCB\x38", 128},
    {"\xF2\xAD\x9A\x80", "\xC3\x31\xD8\x36", 128},
    {"\xF2\xAD\x9C\x80", "\xC3\x31\xE5\x34", 128},
    {"\xF2\xAD\x9E\x80", "\xC3\x31\xF2\x32", 128},
    {"\xF2\xAD\xA0\x80", "\xC3\x32\x81\x30", 128},
    {"\xF2\xAD\xA2\x80", "\xC3\x32\x8D\x38", 128},
    {"\xF2\xAD\xA4\x80", "\xC3\x32\x9A\x36", 128},
    {"\xF2\xAD\xA6\x80", "\xC3\x32\xA7\x34", 128},
    {"\xF2\xAD\xA8\x80", "\xC3\x32\xB4\x32", 128},
    {"\xF2\xAD\xAA\x80", "\xC3\x32\xC1\x30", 128},
    {"\xF2\xAD\xAC\x80", "\xC3\x32\xCD\x38", 128},
    {"\xF2\xAD\xAE\x80", "\xC3\x32\xDA\x36", 128},
    {"\xF2\xAD\xB0\x80", "\xC3\x32\xE7\x34", 128},
    {"\xF2\xAD\xB2\x80", "\xC3\x32\xF4\x32", 128},
    {"\xF2\xAD\xB4\x80", "\xC3\x33\x83\x30", 128},
    {"\xF2\xAD\xB6\x80", "\xC3\x33\x8F\x38", 128},
    {"\xF2\xAD\xB8\x80", "\xC3\x33\x9C\x36", 128},
    {"\xF2\xAD\xBA\x80", "\xC3\x33\xA9\x34", 128},
    {"\xF2\xAD\xBC\x80", "\xC3\x33\xB6\x32", 128},
    {"\xF2\xAD\xBE\x80", "\xC3\x33\xC3\x30", 128},
    {"\xF2\xAE\x80\x80", "\xC3\x33\xCF\x38", 128},
    {"\xF2\xAE\x82\x80", "\xC3\x33\xDC\x36", 128},
    {"\xF2\xAE\x84\x80", "\xC3\x33\xE9\x34", 128},
    {"\xF2\xAE\x86\x80", "\xC3\x33\xF6\x32", 128},
    {"\xF2\xAE\x88\x80", "\xC3\x34\x85\x30", 128},
    {"\xF2\xAE\x8A\x80", "\xC3\x34\x91\x38", 128},
    {"\xF2\xAE\x8C\x80", "\xC3\x34\x9E\x36", 128},
    {"\xF2\xAE\x8E\x80", "\xC3\x34\xAB\x34", 128},
    {"\xF2\xAE\x90\x80", "\xC3\x34\xB8\x32", 128},
    {"\xF2\xAE\x92\x80", "\xC3\x34\xC5\x30", 128},
    {"\xF2\xAE\x94\x80", "\xC3\x34\xD1\x38", 128},
    {"\xF2\xAE\x96\x80", "\xC3\x34\xDE\x36", 128},
    {"\xF2\xAE\x98\x80", "\xC3\x34\xEB\x34", 128},
    {"\xF2\xAE\x9A\x80", "\xC3\x34\xF8\x32", 128},
    {"\xF2\xAE\x9C\x80", "\xC3\x35\x87\x30", 128},
    {"\xF2\xAE\x9E\x80", "\xC3\x35\x93\x38", 128},
    {"\xF2\xAE\xA0\x80", "\xC3\x35\xA0\x36", 128},
    {"\xF2\xAE\xA2\x80", "\xC3\x35\xAD\x34", 128},
    {"\xF2\xAE\xA4\x80", "\xC3\x35\xBA\x32", 128},
    {"\xF2\xAE\xA6\x80", "\xC3\x35\xC7\x30", 128},
    {"\xF2\xAE\xA8\x80", "\xC3\x35\xD3\x38", 128},
    {"\xF2\xAE\xAA\x80", "\xC3\x35\xE0\x36", 128},
    {"\xF2\xAE\xAC\x80", "\xC3\x35\xED\x34", 128},
    {"\xF2\xAE\xAE\x80", "\xC3\x35\xFA\x32", 128},
    {"\xF2\xAE\xB0\x80", "\xC3\x36\x89\x30", 128},
    {"\xF2\xAE\xB2\x80", "\xC3\x36\x95\x38", 128},
    {"\xF2\xAE\xB4\x80", "\xC3\x36\xA2\x36", 128},
    {"\xF2\xAE\xB6\x80", "\xC3\x36\xAF\x34", 128},
    {"\xF2\xAE\xB8\x80", "\xC3\x36\xBC\x32", 128},
    {"\xF2\xAE\xBA\x80", "\xC3\x36\xC9\x30", 128},
    {"\xF2\xAE\xBC\x80", "\xC3\x36\xD5\x38", 128},
    {"\xF2\xAE\xBE\x80", "\xC3\x36\xE2\x36", 128},
    {"\xF2\xAF\x80\x80", "\xC3\x36\xEF\x34", 128},
    {"\xF2\xAF\x82\x80", "\xC3\x36\xFC\x32", 128},
    {"\xF2\xAF\x84\x80", "\xC3\x37\x8B\x30", 128},
    {"\xF2\xAF\x86\x80", "\xC3\x37\x97\x38", 128},
    {"\xF2\xAF\x88\x80", "\xC3\x37\xA4\x36", 128},
    {"\xF2\xAF\x8A\x80", "\xC3\x37\xB1\x34", 128},
    {"\xF2\xAF\x8C\x80", "\xC3\x37\xBE\x32", 128},
    {"\xF2\xAF\x8E\x80", "\xC3\x37\xCB\x30", 128},
    {"\xF2\xAF\x90\x80", "\xC3\x37\xD7\x38", 128},
    {"\xF2\xAF\x92\x80", "\xC3\x37\xE4\x36", 128},
    {"\xF2\xAF\x94\x80", "\xC3\x37\xF1\x34", 128},
    {"\xF2\xAF\x96\x80", "\xC3\x37\xFE\x32", 128},
    {"\xF2\xAF\x98\x80", "\xC3\x38\x8D\x30", 128},
    {"\xF2\xAF\x9A\x80", "\xC3\x38\x99\x38", 128},
    {"\xF2\xAF\x9C\x80", "\xC3\x38\xA6\x36", 128},
    {"\xF2\xAF\x9E\x80", "\xC3\x38\xB3\x34", 128},
    {"\xF2\xAF\xA0\x80", "\xC3\x38\xC0\x32", 128},
    {"\xF2\xAF\xA2\x80", "\xC3\x38\xCD\x30", 128},
    {"\xF2\xAF\xA4\x80", "\xC3\x38\xD9\x38", 128},
    {"\xF2\xAF\xA6\x80", "\xC3\x38\xE6\x36", 128},
    {"\xF2\xAF\xA8\x80", "\xC3\x38\xF3\x34", 128},
    {"\xF2\xAF\xAA\x80", "\xC3\x39\x82\x32", 128},
    {"\xF2\xAF\xAC\x80", "\xC3\x39\x8F\x30", 128},
    {"\xF2\xAF\xAE\x80", "\xC3\x39\x9B\x38", 128},
    {"\xF2\xAF\xB0\x80", "\xC3\x39\xA8\x36", 128},
    {"\xF2\xAF\xB2\x80", "\xC3\x39\xB5\x34", 128},
    {"\xF2\xAF\xB4\x80", "\xC3\x39\xC2\x32", 128},
    {"\xF2\xAF\xB6\x80", "\xC3\x39\xCF\x30", 128},
    {"\xF2\xAF\xB8\x80", "\xC3\x39\xDB\x38", 128},
    {"\xF2\xAF\xBA\x80", "\xC3\x39\xE8\x36", 128},
    {"\xF2\xAF\xBC\x80", "\xC3\x39\xF5\x34", 128},
    {"\xF2\xAF\xBE\x80", "\xC4\x30\x84\x32", 128},
    {"\xF2\xB0\x80\x80", "\xC4\x30\x91\x30", 128},
    {"\xF2\xB0\x82\x80", "\xC4\x30\x9D\x38", 128},
    {"\xF2\xB0\x84\x80", "\xC4\x30\xAA\x36", 128},
    {"\xF2\xB0\x86\x80", "\xC4\x30\xB7\x34", 128},
    {"\xF2\xB0\x88\x80", "\xC4\x30\xC4\x32", 128},
    {"\xF2\xB0\x8A\x80", "\xC4\x30\xD1\x30", 128},
    {"\xF2\xB0\x8C\x80", "\xC4\x30\xDD\x38", 128},
    {"\xF2\xB0\x8E\x80", "\xC4\x30\xEA\x36", 128},
    {"\xF2\xB0\x90\x80", "\xC4\x30\xF7\x34", 128},
    {"\xF2\xB0\x92\x80", "\xC4\x31\x86\x32", 128},
    {"\xF2\xB0\x94\x80", "\xC4\x31\x93\x30", 128},
    {"\xF2\xB0\x96\x80", "\xC4\x31\x9F\x38", 128},
    {"\xF2\xB0\x98\x80", "\xC4\x31\xAC\x36", 128},
    {"\xF2\xB0\x9A\x80", "\xC4\x31\xB9\x34", 128},
    {"\xF2\xB0\x9C\x80", "\xC4\x31\xC6\x32", 128},
    {"\xF2\xB0\x9E\x80", "\xC4\x31\xD3\x30", 128},
    {"\xF2\xB0\xA0\x80", "\xC4\x31\xDF\x38", 128},
    {"\xF2\xB0\xA2\x80", "\xC4\x31\xEC\x36", 128},
    {"\xF2\xB0\xA4\x80", "\xC4\x31\xF9\x34", 128},
    {"\xF2\xB0\xA6\x80", "\xC4\x32\x88\x32", 128},
    {"\xF2\xB0\xA8\x80", "\xC4\x32\x95\x30", 128},
    {"\xF2\xB0\xAA\x80", "\xC4\x32\xA1\x38", 128},
    {"\xF2\xB0\xAC\x80", "\xC4\x32\xAE\x36", 128},
    {"\xF2\xB0\xAE\x80", "\xC4\x32\xBB\x34", 128},
    {"\xF2\xB0\xB0\x80", "\xC4\x32\xC8\x32", 128},
    {"\xF2\xB0\xB2\x80", "\xC4\x32\xD5\x30", 128},
    {"\xF2\xB0\xB4\x80", "\xC4\x32\xE1\x38", 128},
    {"\xF2\xB0\xB6\x80", "\xC4\x32\xEE\x36", 128},
    {"\xF2\xB0\xB8\x80", "\xC4\x32\xFB\x34", 128},
    {"\xF2\xB0\xBA\x80", "\xC4\x33\x8A\x32", 128},
    {"\xF2\xB0\xBC\x80", "\xC4\x33\x97\x30", 128},
    {"\xF2\xB0\xBE\x80", "\xC4\x33\xA3\x38", 128},
    {"\xF2\xB1\x80\x80", "\xC4\x33\xB0\x36", 128},
    {"\xF2\xB1\x82\x80", "\xC4\x33\xBD\x34", 128},
    {"\xF2\xB1\x84\x80", "\xC4\x33\xCA\x32", 128},
    {"\xF2\xB1\x86\x80", "\xC4\x33\xD7\x30", 128},
    {"\xF2\xB1\x88\x80", "\xC4\x33\xE3\x38", 128},
    {"\xF2\xB1\x8A\x80", "\xC4\x33\xF0\x36", 128},
    {"\xF2\xB1\x8C\x80", "\xC4\x33\xFD\x34", 128},
    {"\xF2\xB1\x8E\x80", "\xC4\x34\x8C\x32", 128},
    {"\xF2\xB1\x90\x80", "\xC4\x34\x99\x30", 128},
    {"\xF2\xB1\x92\x80", "\xC4\x34\xA5\x38", 128},
    {"\xF2\xB1\x94\x80", "\xC4\x34\xB2\x36", 128},
    {"\xF2\xB1\x96\x80", "\xC4\x34\xBF\x34", 128},
    {"\xF2\xB1\x98\x80", "\xC4\x34\xCC\x32", 128},
    {"\xF2\xB1\x9A\x80", "\xC4\x34\xD9\x30", 128},
    {"\xF2\xB1\x9C\x80", "\xC4\x34\xE5\x38", 128},
    {"\xF2\xB1\x9E\x80", "\xC4\x34\xF2\x36", 128},
    {"\xF2\xB1\xA0\x80", "\xC4\x35\x81\x34", 128},
    {"\xF2\xB1\xA2\x80", "\xC4\x35\x8E\x32", 128},
    {"\xF2\xB1\xA4\x80", "\xC4\x35\x9B\x30", 128},
    {"\xF2\xB1\xA6\x80", "\xC4\x35\xA7\x38", 128},
    {"\xF2\xB1\xA8\x80", "\xC4\x35\xB4\x36", 128},
    {"\xF2\xB1\xAA\x80", "\xC4\x35\xC1\x34", 128},
    {"\xF2\xB1\xAC\x80", "\xC4\x35\xCE\x32", 128},
    {"\xF2\xB1\xAE\x80", "\xC4\x35\xDB\x30", 128},
    {"\xF2\xB1\xB0\x80", "\xC4\x35\xE7\x38", 128},
    {"\xF2\xB1\xB2\x80", "\xC4\x35\xF4\x36", 128},
    {"\xF2\xB1\xB4\x80", "\xC4\x36\x83\x34", 128},
    {"\xF2\xB1\xB6\x80", "\xC4\x36\x90\x32", 128},
    {"\xF2\xB1\xB8\x80", "\xC4\x36\x9D\x30", 128},
    {"\xF2\xB1\xBA\x80", "\xC4\x36\xA9\x38", 128},
    {"\xF2\xB1\xBC\x80", "\xC4\x36\xB6\x36", 128},
    {"\xF2\xB1\xBE\x80", "\xC4\x36\xC3\x34", 128},
    {"\xF2\xB2\x80\x80", "\xC4\x36\xD0\x32", 128},
    {"\xF2\xB2\x82\x80", "\xC4\x36\xDD\x30", 128},
    {"\xF2\xB2\x84\x80", "\xC4\x36\xE9\x38", 128},
    {"\xF2\xB2\x86\x80", "\xC4\x36\xF6\x36", 128},
    {"\xF2\xB2\x88\x80", "\xC4\x37\x85\x34", 128},
    {"\xF2\xB2\x8A\x80", "\xC4\x37\x92\x32", 128},
    {"\xF2\xB2\x8C\x80", "\xC4\x37\x9F\x30", 128},
    {"\xF2\xB2\x8E\x80", "\xC4\x37\xAB\x38", 128},
    {"\xF2\xB2\x90\x80", "\xC4\x37\xB8\x36", 128},
    {"\xF2\xB2\x92\x80", "\xC4\x37\xC5\x34", 128},
    {"\xF2\xB2\x94\x80", "\xC4\x37\xD2\x32", 128},
    {"\xF2\xB2\x96\x80", "\xC4\x37\xDF\x30", 128},
    {"\xF2\xB2\x98\x80", "\xC4\x37\xEB\x38", 128},
    {"\xF2\xB2\x9A\x80", "\xC4\x37\xF8\x36", 128},
    {"\xF2\xB2\x9C\x80", "\xC4\x38\x87\x34", 128},
    {"\xF2\xB2\x9E\x80", "\xC4\x38\x94\x32", 128},
    {"\xF2\xB2\xA0\x80", "\xC4\x38\xA1\x30", 128},
    {"\xF2\xB2\xA2\x80", "\xC4\x38\xAD\x38", 128},
    {"\xF2\xB2\xA4\x80", "\xC4\x38\xBA\x36", 128},
    {"\xF2\xB2\xA6\x80", "\xC4\x38\xC7\x34", 128},
    {"\xF2\xB2\xA8\x80", "\xC4\x38\xD4\x32", 128},
    {"\xF2\xB2\xAA\x80", "\xC4\x38\xE1\x30", 128},
    {"\xF2\xB2\xAC\x80", "\xC4\x38\xED\x38", 128},
    {"\xF2\xB2\xAE\x80", "\xC4\x38\xFA\x36", 128},
    {"\xF2\xB2\xB0\x80", "\xC4\x39\x89\x34", 128},
    {"\xF2\xB2\xB2\x80", "\xC4\x39\x96\x32", 128},
    {"\xF2\xB2\xB4\x80", "\xC4\x39\xA3\x30", 128},
    {"\xF2\xB2\xB6\x80", "\xC4\x39\xAF\x38", 128},
    {"\xF2\xB2\xB8\x80", "\xC4\x39\xBC\x36", 128},
    {"\xF2\xB2\xBA\x80", "\xC4\x39\xC9\x34", 128},
    {"\xF2\xB2\xBC\x80", "\xC4\x39\xD6\x32", 128},
    {"\xF2\xB2\xBE\x80", "\xC4\x39\xE3\x30", 128},
    {"\xF2\xB3\x80\x80", "\xC4\x39\xEF\x38", 128},
    {"\xF2\xB3\x82\x80", "\xC4\x39\xFC\x36", 128},
    {"\xF2\xB3\x84\x80", "\xC5\x30\x8B\x34", 128},
    {"\xF2\xB3\x86\x80", "\xC5\x30\x98\x32", 128},
    {"\xF2\xB3\x88\x80", "\xC5\x30\xA5\x30", 128},
    {"\xF2\xB3\x8A\x80", "\xC5\x30\xB1\x38", 128},
    {"\xF2\xB3\x8C\x80", "\xC5\x30\xBE\x36", 128},
    {"\xF2\xB3\x8E\x80", "\xC5\x30\xCB\x34", 128},
    {"\xF2\xB3\x90\x80", "\xC5\x30\xD8\x32", 128},
    {"\xF2\xB3\x92\x80", "\xC5\x30\xE5\x30", 128},
    {"\xF2\xB3\x94\x80", "\xC5\x30\xF1\x38", 128},
    {"\xF2\xB3\x96\x80", "\xC5\x30\xFE\x36", 128},
    {"\xF2\xB3\x98\x80", "\xC5\x31\x8D\x34", 128},
    {"\xF2\xB3\x9A\x80", "\xC5\x31\x9A\x32", 128},
    {"\xF2\xB3\x9C\x80", "\xC5\x31\xA7\x30", 128},
    {"\xF2\xB3\x9E\x80", "\xC5\x31\xB3\x38", 128},
    {"\xF2\xB3\xA0\x80", "\xC5\x31\xC0\x36", 128},
    {"\xF2\xB3\xA2\x80", "\xC5\x31\xCD\x34", 128},
    {"\xF2\xB3\xA4\x80", "\xC5\x31\xDA\x32", 128},
    {"\xF2\xB3\xA6\x80", "\xC5\x31\xE7\x30", 128},
    {"\xF2\xB3\xA8\x80", "\xC5\x31\xF3\x38", 128},
    {"\xF2\xB3\xAA\x80", "\xC5\x32\x82\x36", 128},
    {"\xF2\xB3\xAC\x80", "\xC5\x32\x8F\x34", 128},
    {"\xF2\xB3\xAE\x80", "\xC5\x32\x9C\x32", 128},
    {"\xF2\xB3\xB0\x80", "\xC5\x32\xA9\x30", 128},
    {"\xF2\xB3\xB2\x80", "\xC5\x32\xB5\x38", 128},
    {"\xF2\xB3\xB4\x80", "\xC5\x32\xC2\x36", 128},
    {"\xF2\xB3\xB6\x80", "\xC5\x32\xCF\x34", 128},
    {"\xF2\xB3\xB8\x80", "\xC5\x32\xDC\x32", 128},
    {"\xF2\xB3\xBA\x80", "\xC5\x32\xE9\x30", 128},
    {"\xF2\xB3\xBC\x80", "\xC5\x32\xF5\x38", 128},
    {"\xF2\xB3\xBE\x80", "\xC5\x33\x84\x36", 128},
    {"\xF2\xB4\x80\x80", "\xC5\x33\x91\x34", 128},
    {"\xF2\xB4\x82\x80", "\xC5\x33\x9E\x32", 128},
    {"\xF2\xB4\x84\x80", "\xC5\x33\xAB\x30", 128},
    {"\xF2\xB4\x86\x80", "\xC5\x33\xB7\x38", 128},
    {"\xF2\xB4\x88\x80", "\xC5\x33\xC4\x36", 128},
    {"\xF2\xB4\x8A\x80", "\xC5\x33\xD1\x34", 128},
    {"\xF2\xB4\x8C\x80", "\xC5\x33\xDE\x32", 128},
    {"\xF2\xB4\x8E\x80", "\xC5\x33\xEB\x30", 128},
    {"\xF2\xB4\x90\x80", "\xC5\x33\xF7\x38", 128},
    {"\xF2\xB4\x92\x80", "\xC5\x34\x86\x36", 128},
    {"\xF2\xB4\x94\x80", "\xC5\x34\x93\x34", 128},
    {"\xF2\xB4\x96\x80", "\xC5\x34\xA0\x32", 128},
    {"\xF2\xB4\x98\x80", "\xC5\x34\xAD\x30", 128},
    {"\xF2\xB4\x9A\x80", "\xC5\x34\xB9\x38", 128},
    {"\xF2\xB4\x9C\x80", "\xC5\x34\xC6\x36", 128},
    {"\xF2\xB4\x9E\x80", "\xC5\x34\xD3\x34", 128},
    {"\xF2\xB4\xA0\x80", "\xC5\x34\xE0\x32", 128},
    {"\xF2\xB4\xA2\x80", "\xC5\x34\xED\x30", 128},
    {"\xF2\xB4\xA4\x80", "\xC5\x34\xF9\x38", 128},
    {"\xF2\xB4\xA6\x80", "\xC5\x35\x88\x36", 128},
    {"\xF2\xB4\xA8\x80", "\xC5\x35\x95\x34", 128},
    {"\xF2\xB4\xAA\x80", "\xC5\x35\xA2\x32", 128},
    {"\xF2\xB4\xAC\x80", "\xC5\x35\xAF\x30", 128},
    {"\xF2\xB4\xAE\x80", "\xC5\x35\xBB\x38", 128},
    {"\xF2\xB4\xB0\x80", "\xC5\x35\xC8\x36", 128},
    {"\xF2\xB4\xB2\x80", "\xC5\x35\xD5\x34", 128},
    {"\xF2\xB4\xB4\x80", "\xC5\x35\xE2\x32", 128},
    {"\xF2\xB4\xB6\x80", "\xC5\x35\xEF\x30", 128},
    {"\xF2\xB4\xB8\x80", "\xC5\x35\xFB\x38", 128},
    {"\xF2\xB4\xBA\x80", "\xC5\x36\x8A\x36", 128},
    {"\xF2\xB4\xBC\x80", "\xC5\x36\x97\x34", 128},
    {"\xF2\xB4\xBE\x80", "\xC5\x36\xA4\x32", 128},
    {"\xF2\xB5\x80\x80", "\xC5\x36\xB1\x30", 128},
    {"\xF2\xB5\x82\x80", "\xC5\x36\xBD\x38", 128},
    {"\xF2\xB5\x84\x80", "\xC5\x36\xCA\x36", 128},
    {"\xF2\xB5\x86\x80", "\xC5\x36\xD7\x34", 128},
    {"\xF2\xB5\x88\x80", "\xC5\x36\xE4\x32", 128},
    {"\xF2\xB5\x8A\x80", "\xC5\x36\xF1\x30", 128},
    {"\xF2\xB5\x8C\x80", "\xC5\x36\xFD\x38", 128},
    {"\xF2\xB5\x8E\x80", "\xC5\x37\x8C\x36", 128},
    {"\xF2\xB5\x90\x80", "\xC5\x37\x99\x34", 128},
    {"\xF2\xB5\x92\x80", "\xC5\x37\xA6\x32", 128},
    {"\xF2\xB5\x94\x80", "\xC5\x37\xB3\x30", 128},
    {"\xF2\xB5\x96\x80", "\xC5\x37\xBF\x38", 128},
    {"\xF2\xB5\x98\x80", "\xC5\x37\xCC\x36", 128},
    {"\xF2\xB5\x9A\x80", "\xC5\x37\xD9\x34", 128},
    {"\xF2\xB5\x9C\x80", "\xC5\x37\xE6\x32", 128},
    {"\xF2\xB5\x9E\x80", "\xC5\x37\xF3\x30", 128},
    {"\xF2\xB5\xA0\x80", "\xC5\x38\x81\x38", 128},
    {"\xF2\xB5\xA2\x80", "\xC5\x38\x8E\x36", 128},
    {"\xF2\xB5\xA4\x80", "\xC5\x38\x9B\x34", 128},
    {"\xF2\xB5\xA6\x80", "\xC5\x38\xA8\x32", 128},
    {"\xF2\xB5\xA8\x80", "\xC5\x38\xB5\x30", 128},
    {"\xF2\xB5\xAA\x80", "\xC5\x38\xC1\x38", 128},
    {"\xF2\xB5\xAC\x80", "\xC5\x38\xCE\x36", 128},
    {"\xF2\xB5\xAE\x80", "\xC5\x38\xDB\x34", 128},
    {"\xF2\xB5\xB0\x80", "\xC5\x38\xE8\x32", 128},
    {"\xF2\xB5\xB2\x80", "\xC5\x38\xF5\x30", 128},
    {"\xF2\xB5\xB4\x80", "\xC5\x39\x83\x38", 128},
    {"\xF2\xB5\xB6\x80", "\xC5\x39\x90\x36", 128},
    {"\xF2\xB5\xB8\x80", "\xC5\x39\x9D\x34", 128},
    {"\xF2\xB5\xBA\x80", "\xC5\x39\xAA\x32", 128},
    {"\xF2\xB5\xBC\x80", "\xC5\x39\xB7\x30", 128},
    {"\xF2\xB5\xBE\x80", "\xC5\x39\xC3\x38", 128},
    {"\xF2\xB6\x80\x80", "\xC5\x39\xD0\x36", 128},
    {"\xF2\xB6\x82\x80", "\xC5\x39\xDD\x34", 128},
    {"\xF2\xB6\x84\x80", "\xC5\x39\xEA\x32", 128},
    {"\xF2\xB6\x86\x80", "\xC5\x39\xF7\x30", 128},
    {"\xF2\xB6\x88\x80", "\xC6\x30\x85\x38", 128},
    {"\xF2\xB6\x8A\x80", "\xC6\x30\x92\x36", 128},
    {"\xF2\xB6\x8C\x80", "\xC6\x30\x9F\x34", 128},
    {"\xF2\xB6\x8E\x80", "\xC6\x30\xAC\x32", 128},
    {"\xF2\xB6\x90\x80", "\xC6\x30\xB9\x30", 128},
    {"\xF2\xB6\x92\x80", "\xC6\x30\xC5\x38", 128},
    {"\xF2\xB6\x94\x80", "\xC6\x30\xD2\x36", 128},
    {"\xF2\xB6\x96\x80", "\xC6\x30\xDF\x34", 128},
    {"\xF2\xB6\x98\x80", "\xC6\x30\xEC\x32", 128},
    {"\xF2\xB6\x9A\x80", "\xC6\x30\xF9\x30", 128},
    {"\xF2\xB6\x9C\x80", "\xC6\x31\x87\x38", 128},
    {"\xF2\xB6\x9E\x80", "\xC6\x31\x94\x36", 128},
    {"\xF2\xB6\xA0\x80", "\xC6\x31\xA1\x34", 128},
    {"\xF2\xB6\xA2\x80", "\xC6\x31\xAE\x32", 128},
    {"\xF2\xB6\xA4\x80", "\xC6\x31\xBB\x30", 128},
    {"\xF2\xB6\xA6\x80", "\xC6\x31\xC7\x38", 128},
    {"\xF2\xB6\xA8\x80", "\xC6\x31\xD4\x36", 128},
    {"\xF2\xB6\xAA\x80", "\xC6\x31\xE1\x34", 128},
    {"\xF2\xB6\xAC\x80", "\xC6\x31\xEE\x32", 128},
    {"\xF2\xB6\xAE\x80", "\xC6\x31\xFB\x30", 128},
    {"\xF2\xB6\xB0\x80", "\xC6\x32\x89\x38", 128},
    {"\xF2\xB6\xB2\x80", "\xC6\x32\x96\x36", 128},
    {"\xF2\xB6\xB4\x80", "\xC6\x32\xA3\x34", 128},
    {"\xF2\xB6\xB6\x80", "\xC6\x32\xB0\x32", 128},
    {"\xF2\xB6\xB8\x80", "\xC6\x32\xBD\x30", 128},
    {"\xF2\xB6\xBA\x80", "\xC6\x32\xC9\x38", 128},
    {"\xF2\xB6\xBC\x80", "\xC6\x32\xD6\x36", 128},
    {"\xF2\xB6\xBE\x80", "\xC6\x32\xE3\x34", 128},
    {"\xF2\xB7\x80\x80", "\xC6\x32\xF0\x32", 128},
    {"\xF2\xB7\x82\x80", "\xC6\x32\xFD\x30", 128},
    {"\xF2\xB7\x84\x80", "\xC6\x33\x8B\x38", 128},
    {"\xF2\xB7\x86\x80", "\xC6\x33\x98\x36", 128},
    {"\xF2\xB7\x88\x80", "\xC6\x33\xA5\x34", 128},
    {"\xF2\xB7\x8A\x80", "\xC6\x33\xB2\x32", 128},
    {"\xF2\xB7\x8C\x80", "\xC6\x33\xBF\x30", 128},
    {"\xF2\xB7\x8E\x80", "\xC6\x33\xCB\x38", 128},
    {"\xF2\xB7\x90\x80", "\xC6\x33\xD8\x36", 128},
    {"\xF2\xB7\x92\x80", "\xC6\x33\xE5\x34", 128},
    {"\xF2\xB7\x94\x80", "\xC6\x33\xF2\x32", 128},
    {"\xF2\xB7\x96\x80", "\xC6\x34\x81\x30", 128},
    {"\xF2\xB7\x98\x80", "\xC6\x34\x8D\x38", 128},
    {"\xF2\xB7\x9A\x80", "\xC6\x34\x9A\x36", 128},
    {"\xF2\xB7\x9C\x80", "\xC6\x34\xA7\x34", 128},
    {"\xF2\xB7\x9E\x80", "\xC6\x34\xB4\x32", 128},
    {"\xF2\xB7\xA0\x80", "\xC6\x34\xC1\x30", 128},
    {"\xF2\xB7\xA2\x80", "\xC6\x34\xCD\x38", 128},
    {"\xF2\xB7\xA4\x80", "\xC6\x34\xDA\x36", 128},
    {"\xF2\xB7\xA6\x80", "\xC6\x34\xE7\x34", 128},
    {"\xF2\xB7\xA8\x80", "\xC6\x34\xF4\x32", 128},
    {"\xF2\xB7\xAA\x80", "\xC6\x35\x83\x30", 128},
    {"\xF2\xB7\xAC\x80", "\xC6\x35\x8F\x38", 128},
    {"\xF2\xB7\xAE\x80", "\xC6\x35\x9C\x36", 128},
    {"\xF2\xB7\xB0\x80", "\xC6\x35\xA9\x34", 128},
    {"\xF2\xB7\xB2\x80", "\xC6\x35\xB6\x32", 128},
    {"\xF2\xB7\xB4\x80", "\xC6\x35\xC3\x30", 128},
    {"\xF2\xB7\xB6\x80", "\xC6\x35\xCF\x38", 128},
    {"\xF2\xB7\xB8\x80", "\xC6\x35\xDC\x36", 128},
    {"\xF2\xB7\xBA\x80", "\xC6\x35\xE9\x34", 128},
    {"\xF2\xB7\xBC\x80", "\xC6\x35\xF6\x32", 128},
    {"\xF2\xB7\xBE\x80", "\xC6\x36\x85\x30", 128},
    {"\xF2\xB8\x80\x80", "\xC6\x36\x91\x38", 128},
    {"\xF2\xB8\x82\x80", "\xC6\x36\x9E\x36", 128},
    {"\xF2\xB8\x84\x80", "\xC6\x36\xAB\x34", 128},
    {"\xF2\xB8\x86\x80", "\xC6\x36\xB8\x32", 128},
    {"\xF2\xB8\x88\x80", "\xC6\x36\xC5\x30", 128},
    {"\xF2\xB8\x8A\x80", "\xC6\x36\xD1\x38", 128},
    {"\xF2\xB8\x8C\x80", "\xC6\x36\xDE\x36", 128},
    {"\xF2\xB8\x8E\x80", "\xC6\x36\xEB\x34", 128},
    {"\xF2\xB8\x90\x80", "\xC6\x36\xF8\x32", 128},
    {"\xF2\xB8\x92\x80", "\xC6\x37\x87\x30", 128},
    {"\xF2\xB8\x94\x80", "\xC6\x37\x93\x38", 128},
    {"\xF2\xB8\x96\x80", "\xC6\x37\xA0\x36", 128},
    {"\xF2\xB8\x98\x80", "\xC6\x37\xAD\x34", 128},
    {"\xF2\xB8\x9A\x80", "\xC6\x37\xBA\x32", 128},
    {"\xF2\xB8\x9C\x80", "\xC6\x37\xC7\x30", 128},
    {"\xF2\xB8\x9E\x80", "\xC6\x37\xD3\x38", 128},
    {"\xF2\xB8\xA0\x80", "\xC6\x37\xE0\x36", 128},
    {"\xF2\xB8\xA2\x80", "\xC6\x37\xED\x34", 128},
    {"\xF2\xB8\xA4\x80", "\xC6\x37\xFA\x32", 128},
    {"\xF2\xB8\xA6\x80", "\xC6\x38\x89\x30", 128},
    {"\xF2\xB8\xA8\x80", "\xC6\x38\x95\x38", 128},
    {"\xF2\xB8\xAA\x80", "\xC6\x38\xA2\x36", 128},
    {"\xF2\xB8\xAC\x80", "\xC6\x38\xAF\x34", 128},
    {"\xF2\xB8\xAE\x80", "\xC6\x38\xBC\x32", 128},
    {"\xF2\xB8\xB0\x80", "\xC6\x38\xC9\x30", 128},
    {"\xF2\xB8\xB2\x80", "\xC6\x38\xD5\x38", 128},
    {"\xF2\xB8\xB4\x80", "\xC6\x38\xE2\x36", 128},
    {"\xF2\xB8\xB6\x80", "\xC6\x38\xEF\x34", 128},
    {"\xF2\xB8\xB8\x80", "\xC6\x38\xFC\x32", 128},
    {"\xF2\xB8\xBA\x80", "\xC6\x39\x8B\x30", 128},
    {"\xF2\xB8\xBC\x80", "\xC6\x39\x97\x38", 128},
    {"\xF2\xB8\xBE\x80", "\xC6\x39\xA4\x36", 128},
    {"\xF2\xB9\x80\x80", "\xC6\x39\xB1\x34", 128},
    {"\xF2\xB9\x82\x80", "\xC6\x39\xBE\x32", 128},
    {"\xF2\xB9\x84\x80", "\xC6\x39\xCB\x30", 128},
    {"\xF2\xB9\x86\x80", "\xC6\x39\xD7\x38", 128},
    {"\xF2\xB9\x88\x80", "\xC6\x39\xE4\x36", 128},
    {"\xF2\xB9\x8A\x80", "\xC6\x39\xF1\x34", 128},
    {"\xF2\xB9\x8C\x80", "\xC6\x39\xFE\x32", 128},
    {"\xF2\xB9\x8E\x80", "\xC7\x30\x8D\x30", 128},
    {"\xF2\xB9\x90\x80", "\xC7\x30\x99\x38", 128},
    {"\xF2\xB9\x92\x80", "\xC7\x30\xA6\x36", 128},
    {"\xF2\xB9\x94\x80", "\xC7\x30\xB3\x34", 128},
    {"\xF2\xB9\x96\x80", "\xC7\x30\xC0\x32", 128},
    {"\xF2\xB9\x98\x80", "\xC7\x30\xCD\x30", 128},
    {"\xF2\xB9\x9A\x80", "\xC7\x30\xD9\x38", 128},
    {"\xF2\xB9\x9C\x80", "\xC7\x30\xE6\x36", 128},
    {"\xF2\xB9\x9E\x80", "\xC7\x30\xF3\x34", 128},
    {"\xF2\xB9\xA0\x80", "\xC7\x31\x82\x32", 128},
    {"\xF2\xB9\xA2\x80", "\xC7\x31\x8F\x30", 128},
    {"\xF2\xB9\xA4\x80", "\xC7\x31\x9B\x38", 128},
    {"\xF2\xB9\xA6\x80", "\xC7\x31\xA8\x36", 128},
    {"\xF2\xB9\xA8\x80", "\xC7\x31\xB5\x34", 128},
    {"\xF2\xB9\xAA\x80", "\xC7\x31\xC2\x32", 128},
    {"\xF2\xB9\xAC\x80", "\xC7\x31\xCF\x30", 128},
    {"\xF2\xB9\xAE\x80", "\xC7\x31\xDB\x38", 128},
    {"\xF2\xB9\xB0\x80", "\xC7\x31\xE8\x36", 128},
    {"\xF2\xB9\xB2\x80", "\xC7\x31\xF5\x34", 128},
    {"\xF2\xB9\xB4\x80", "\xC7\x32\x84\x32", 128},
    {"\xF2\xB9\xB6\x80", "\xC7\x32\x91\x30", 128},
    {"\xF2\xB9\xB8\x80", "\xC7\x32\x9D\x38", 128},
    {"\xF2\xB9\xBA\x80", "\xC7\x32\xAA\x36", 128},
    {"\xF2\xB9\xBC\x80", "\xC7\x32\xB7\x34", 128},
    {"\xF2\xB9\xBE\x80", "\xC7\x32\xC4\x32", 128},
    {"\xF2\xBA\x80\x80", "\xC7\x32\xD1\x30", 128},
    {"\xF2\xBA\x82\x80", "\xC7\x32\xDD\x38", 128},
    {"\xF2\xBA\x84\x80", "\xC7\x32\xEA\x36", 128},
    {"\xF2\xBA\x86\x80", "\xC7\x32\xF7\x34", 128},
    {"\xF2\xBA\x88\x80", "\xC7\x33\x86\x32", 128},
    {"\xF2\xBA\x8A\x80", "\xC7\x33\x93\x30", 128},
    {"\xF2\xBA\x8C\x80", "\xC7\x33\x9F\x38", 128},
    {"\xF2\xBA\x8E\x80", "\xC7\x33\xAC\x36", 128},
    {"\xF2\xBA\x90\x80", "\xC7\x33\xB9\x34", 128},
    {"\xF2\xBA\x92\x80", "\xC7\x33\xC6\x32", 128},
    {"\xF2\xBA\x94\x80", "\xC7\x33\xD3\x30", 128},
    {"\xF2\xBA\x96\x80", "\xC7\x33\xDF\x38", 128},
    {"\xF2\xBA\x98\x80", "\xC7\x33\xEC\x36", 128},
    {"\xF2\xBA\x9A\x80", "\xC7\x33\xF9\x34", 128},
    {"\xF2\xBA\x9C\x80", "\xC7\x34\x88\x32", 128},
    {"\xF2\xBA\x9E\x80", "\xC7\x34\x95\x30", 128},
    {"\xF2\xBA\xA0\x80", "\xC7\x34\xA1\x38", 128},
    {"\xF2\xBA\xA2\x80", "\xC7\x34\xAE\x36", 128},
    {"\xF2\xBA\xA4\x80", "\xC7\x34\xBB\x34", 128},
    {"\xF2\xBA\xA6\x80", "\xC7\x34\xC8\x32", 128},
    {"\xF2\xBA\xA8\x80", "\xC7\x34\xD5\x30", 128},
    {"\xF2\xBA\xAA\x80", "\xC7\x34\xE1\x38", 128},
    {"\xF2\xBA\xAC\x80", "\xC7\x34\xEE\x36", 128},
    {"\xF2\xBA\xAE\x80", "\xC7\x34\xFB\x34", 128},
    {"\xF2\xBA\xB0\x80", "\xC7\x35\x8A\x32", 128},
    {"\xF2\xBA\xB2\x80", "\xC7\x35\x97\x30", 128},
    {"\xF2\xBA\xB4\x80", "\xC7\x35\xA3\x38", 128},
    {"\xF2\xBA\xB6\x80", "\xC7\x35\xB0\x36", 128},
    {"\xF2\xBA\xB8\x80", "\xC7\x35\xBD\x34", 128},
    {"\xF2\xBA\xBA\x80", "\xC7\x35\xCA\x32", 128},
    {"\xF2\xBA\xBC\x80", "\xC7\x35\xD7\x30", 128},
    {"\xF2\xBA\xBE\x80", "\xC7\x35\xE3\x38", 128},
    {"\xF2\xBB\x80\x80", "\xC7\x35\xF0\x36", 128},
    {"\xF2\xBB\x82\x80", "\xC7\x35\xFD\x34", 128},
    {"\xF2\xBB\x84\x80", "\xC7\x36\x8C\x32", 128},
    {"\xF2\xBB\x86\x80", "\xC7\x36\x99\x30", 128},
    {"\xF2\xBB\x88\x80", "\xC7\x36\xA5\x38", 128},
    {"\xF2\xBB\x8A\x80", "\xC7\x36\xB2\x36", 128},
    {"\xF2\xBB\x8C\x80", "\xC7\x36\xBF\x34", 128},
    {"\xF2\xBB\x8E\x80", "\xC7\x36\xCC\x32", 128},
    {"\xF2\xBB\x90\x80", "\xC7\x36\xD9\x30", 128},
    {"\xF2\xBB\x92\x80", "\xC7\x36\xE5\x38", 128},
    {"\xF2\xBB\x94\x80", "\xC7\x36\xF2\x36", 128},
    {"\xF2\xBB\x96\x80", "\xC7\x37\x81\x34", 128},
    {"\xF2\xBB\x98\x80", "\xC7\x37\x8E\x32", 128},
    {"\xF2\xBB\x9A\x80", "\xC7\x37\x9B\x30", 128},
    {"\xF2\xBB\x9C\x80", "\xC7\x37\xA7\x38", 128},
    {"\xF2\xBB\x9E\x80", "\xC7\x37\xB4\x36", 128},
    {"\xF2\xBB\xA0\x80", "\xC7\x37\xC1\x34", 128},
    {"\xF2\xBB\xA2\x80", "\xC7\x37\xCE\x32", 128},
    {"\xF2\xBB\xA4\x80", "\xC7\x37\xDB\x30", 128},
    {"\xF2\xBB\xA6\x80", "\xC7\x37\xE7\x38", 128},
    {"\xF2\xBB\xA8\x80", "\xC7\x37\xF4\x36", 128},
    {"\xF2\xBB\xAA\x80", "\xC7\x38\x83\x34", 128},
    {"\xF2\xBB\xAC\x80", "\xC7\x38\x90\x32", 128},
    {"\xF2\xBB\xAE\x80", "\xC7\x38\x9D\x30", 128},
    {"\xF2\xBB\xB0\x80", "\xC7\x38\xA9\x38", 128},
    {"\xF2\xBB\xB2\x80", "\xC7\x38\xB6\x36", 128},
    {"\xF2\xBB\xB4\x80", "\xC7\x38\xC3\x34", 128},
    {"\xF2\xBB\xB6\x80", "\xC7\x38\xD0\x32", 128},
    {"\xF2\xBB\xB8\x80", "\xC7\x38\xDD\x30", 128},
    {"\xF2\xBB\xBA\x80", "\xC7\x38\xE9\x38", 128},
    {"\xF2\xBB\xBC\x80", "\xC7\x38\xF6\x36", 128},
    {"\xF2\xBB\xBE\x80", "\xC7\x39\x85\x34", 128},
    {"\xF2\xBC\x80\x80", "\xC7\x39\x92\x32", 128},
    {"\xF2\xBC\x82\x80", "\xC7\x39\x9F\x30", 128},
    {"\xF2\xBC\x84\x80", "\xC7\x39\xAB\x38", 128},
    {"\xF2\xBC\x86\x80", "\xC7\x39\xB8\x36", 128},
    {"\xF2\xBC\x88\x80", "\xC7\x39\xC5\x34", 128},
    {"\xF2\xBC\x8A\x80", "\xC7\x39\xD2\x32", 128},
    {"\xF2\xBC\x8C\x80", "\xC7\x39\xDF\x30", 128},
    {"\xF2\xBC\x8E\x80", "\xC7\x39\xEB\x38", 128},
    {"\xF2\xBC\x90\x80", "\xC7\x39\xF8\x36", 128},
    {"\xF2\xBC\x92\x80", "\xC8\x30\x87\x34", 128},
    {"\xF2\xBC\x94\x80", "\xC8\x30\x94\x32", 128},
    {"\xF2\xBC\x96\x80", "\xC8\x30\xA1\x30", 128},
    {"\xF2\xBC\x98\x80", "\xC8\x30\xAD\x38", 128},
    {"\xF2\xBC\x9A\x80", "\xC8\x30\xBA\x36", 128},
    {"\xF2\xBC\x9C\x80", "\xC8\x30\xC7\x34", 128},
    {"\xF2\xBC\x9E\x80", "\xC8\x30\xD4\x32", 128},
    {"\xF2\xBC\xA0\x80", "\xC8\x30\xE1\x30", 128},
    {"\xF2\xBC\xA2\x80", "\xC8\x30\xED\x38", 128},
    {"\xF2\xBC\xA4\x80", "\xC8\x30\xFA\x36", 128},
    {"\xF2\xBC\xA6\x80", "\xC8\x31\x89\x34", 128},
    {"\xF2\xBC\xA8\x80", "\xC8\x31\x96\x32", 128},
    {"\xF2\xBC\xAA\x80", "\xC8\x31\xA3\x30", 128},
    {"\xF2\xBC\xAC\x80", "\xC8\x31\xAF\x38", 128},
    {"\xF2\xBC\xAE\x80", "\xC8\x31\xBC\x36", 128},
    {"\xF2\xBC\xB0\x80", "\xC8\x31\xC9\x34", 128},
    {"\xF2\xBC\xB2\x80", "\xC8\x31\xD6\x32", 128},
    {"\xF2\xBC\xB4\x80", "\xC8\x31\xE3\x30", 128},
    {"\xF2\xBC\xB6\x80", "\xC8\x31\xEF\x38", 128},
    {"\xF2\xBC\xB8\x80", "\xC8\x31\xFC\x36", 128},
    {"\xF2\xBC\xBA\x80", "\xC8\x32\x8B\x34", 128},
    {"\xF2\xBC\xBC\x80", "\xC8\x32\x98\x32", 128},
    {"\xF2\xBC\xBE\x80", "\xC8\x32\xA5\x30", 128},
    {"\xF2\xBD\x80\x80", "\xC8\x32\xB1\x38", 128},
    {"\xF2\xBD\x82\x80", "\xC8\x32\xBE\x36", 128},
    {"\xF2\xBD\x84\x80", "\xC8\x32\xCB\x34", 128},
    {"\xF2\xBD\x86\x80", "\xC8\x32\xD8\x32", 128},
    {"\xF2\xBD\x88\x80", "\xC8\x32\xE5\x30", 128},
    {"\xF2\xBD\x8A\x80", "\xC8\x32\xF1\x38", 128},
    {"\xF2\xBD\x8C\x80", "\xC8\x32\xFE\x36", 128},
    {"\xF2\xBD\x8E\x80", "\xC8\x33\x8D\x34", 128},
    {"\xF2\xBD\x90\x80", "\xC8\x33\x9A\x32", 128},
    {"\xF2\xBD\x92\x80", "\xC8\x33\xA7\x30", 128},
    {"\xF2\xBD\x94\x80", "\xC8\x33\xB3\x38", 128},
    {"\xF2\xBD\x96\x80", "\xC8\x33\xC0\x36", 128},
    {"\xF2\xBD\x98\x80", "\xC8\x33\xCD\x34", 128},
    {"\xF2\xBD\x9A\x80", "\xC8\x33\xDA\x32", 128},
    {"\xF2\xBD\x9C\x80", "\xC8\x33\xE7\x30", 128},
    {"\xF2\xBD\x9E\x80", "\xC8\x33\xF3\x38", 128},
    {"\xF2\xBD\xA0\x80", "\xC8\x34\x82\x36", 128},
    {"\xF2\xBD\xA2\x80", "\xC8\x34\x8F\x34", 128},
    {"\xF2\xBD\xA4\x80", "\xC8\x34\x9C\x32", 128},
    {"\xF2\xBD\xA6\x80", "\xC8\x34\xA9\x30", 128},
    {"\xF2\xBD\xA8\x80", "\xC8\x34\xB5\x38", 128},
    {"\xF2\xBD\xAA\x80", "\xC8\x34\xC2\x36", 128},
    {"\xF2\xBD\xAC\x80", "\xC8\x34\xCF\x34", 128},
    {"\xF2\xBD\xAE\x80", "\xC8\x34\xDC\x32", 128},
    {"\xF2\xBD\xB0\x80", "\xC8\x34\xE9\x30", 128},
    {"\xF2\xBD\xB2\x80", "\xC8\x34\xF5\x38", 128},
    {"\xF2\xBD\xB4\x80", "\xC8\x35\x84\x36", 128},
    {"\xF2\xBD\xB6\x80", "\xC8\x35\x91\x34", 128},
    {"\xF2\xBD\xB8\x80", "\xC8\x35\x9E\x32", 128},
    {"\xF2\xBD\xBA\x80", "\xC8\x35\xAB\x30", 128},
    {"\xF2\xBD\xBC\x80", "\xC8\x35\xB7\x38", 128},
    {"\xF2\xBD\xBE\x80", "\xC8\x35\xC4\x36", 128},
    {"\xF2\xBE\x80\x80", "\xC8\x35\xD1\x34", 128},
    {"\xF2\xBE\x82\x80", "\xC8\x35\xDE\x32", 128},
    {"\xF2\xBE\x84\x80", "\xC8\x35\xEB\x30", 128},
    {"\xF2\xBE\x86\x80", "\xC8\x35\xF7\x38", 128},
    {"\xF2\xBE\x88\x80", "\xC8\x36\x86\x36", 128},
    {"\xF2\xBE\x8A\x80", "\xC8\x36\x93\x34", 128},
    {"\xF2\xBE\x8C\x80", "\xC8\x36\xA0\x32", 128},
    {"\xF2\xBE\x8E\x80", "\xC8\x36\xAD\x30", 128},
    {"\xF2\xBE\x90\x80", "\xC8\x36\xB9\x38", 128},
    {"\xF2\xBE\x92\x80", "\xC8\x36\xC6\x36", 128},
    {"\xF2\xBE\x94\x80", "\xC8\x36\xD3\x34", 128},
    {"\xF2\xBE\x96\x80", "\xC8\x36\xE0\x32", 128},
    {"\xF2\xBE\x98\x80", "\xC8\x36\xED\x30", 128},
    {"\xF2\xBE\x9A\x80", "\xC8\x36\xF9\x38", 128},
    {"\xF2\xBE\x9C\x80", "\xC8\x37\x88\x36", 128},
    {"\xF2\xBE\x9E\x80", "\xC8\x37\x95\x34", 128},
    {"\xF2\xBE\xA0\x80", "\xC8\x37\xA2\x32", 128},
    {"\xF2\xBE\xA2\x80", "\xC8\x37\xAF\x30", 128},
    {"\xF2\xBE\xA4\x80", "\xC8\x37\xBB\x38", 128},
    {"\xF2\xBE\xA6\x80", "\xC8\x37\xC8\x36", 128},
    {"\xF2\xBE\xA8\x80", "\xC8\x37\xD5\x34", 128},
    {"\xF2\xBE\xAA\x80", "\xC8\x37\xE2\x32", 128},
    {"\xF2\xBE\xAC\x80", "\xC8\x37\xEF\x30", 128},
    {"\xF2\xBE\xAE\x80", "\xC8\x37\xFB\x38", 128},
    {"\xF2\xBE\xB0\x80", "\xC8\x38\x8A\x36", 128},
    {"\xF2\xBE\xB2\x80", "\xC8\x38\x97\x34", 128},
    {"\xF2\xBE\xB4\x80", "\xC8\x38\xA4\x32", 128},
    {"\xF2\xBE\xB6\x80", "\xC8\x38\xB1\x30", 128},
    {"\xF2\xBE\xB8\x80", "\xC8\x38\xBD\x38", 128},
    {"\xF2\xBE\xBA\x80", "\xC8\x38\xCA\x36", 128},
    {"\xF2\xBE\xBC\x80", "\xC8\x38\xD7\x34", 128},
    {"\xF2\xBE\xBE\x80", "\xC8\x38\xE4\x32", 128},
    {"\xF2\xBF\x80\x80", "\xC8\x38\xF1\x30", 128},
    {"\xF2\xBF\x82\x80", "\xC8\x38\xFD\x38", 128},
    {"\xF2\xBF\x84\x80", "\xC8\x39\x8C\x36", 128},
    {"\xF2\xBF\x86\x80", "\xC8\x39\x99\x34", 128},
    {"\xF2\xBF\x88\x80", "\xC8\x39\xA6\x32", 128},
    {"\xF2\xBF\x8A\x80", "\xC8\x39\xB3\x30", 128},
    {"\xF2\xBF\x8C\x80", "\xC8\x39\xBF\x38", 128},
    {"\xF2\xBF\x8E\x80", "\xC8\x39\xCC\x36", 128},
    {"\xF2\xBF\x90\x80", "\xC8\x39\xD9\x34", 128},
    {"\xF2\xBF\x92\x80", "\xC8\x39\xE6\x32", 128},
    {"\xF2\xBF\x94\x80", "\xC8\x39\xF3\x30", 128},
    {"\xF2\xBF\x96\x80", "\xC9\x30\x81\x38", 128},
    {"\xF2\xBF\x98\x80", "\xC9\x30\x8E\x36", 128},
    {"\xF2\xBF\x9A\x80", "\xC9\x30\x9B\x34", 128},
    {"\xF2\xBF\x9C\x80", "\xC9\x30\xA8\x32", 128},
    {"\xF2\xBF\x9E\x80", "\xC9\x30\xB5\x30", 128},
    {"\xF2\xBF\xA0\x80", "\xC9\x30\xC1\x38", 128},
    {"\xF2\xBF\xA2\x80", "\xC9\x30\xCE\x36", 128},
    {"\xF2\xBF\xA4\x80", "\xC9\x30\xDB\x34", 128},
    {"\xF2\xBF\xA6\x80", "\xC9\x30\xE8\x32", 128},
    {"\xF2\xBF\xA8\x80", "\xC9\x30\xF5\x30", 128},
    {"\xF2\xBF\xAA\x80", "\xC9\x31\x83\x38", 128},
    {"\xF2\xBF\xAC\x80", "\xC9\x31\x90\x36", 128},
    {"\xF2\xBF\xAE\x80", "\xC9\x31\x9D\x34", 128},
    {"\xF2\xBF\xB0\x80", "\xC9\x31\xAA\x32", 128},
    {"\xF2\xBF\xB2\x80", "\xC9\x31\xB7\x30", 128},
    {"\xF2\xBF\xB4\x80", "\xC9\x31\xC3\x38", 128},
    {"\xF2\xBF\xB6\x80", "\xC9\x31\xD0\x36", 128},
    {"\xF2\xBF\xB8\x80", "\xC9\x31\xDD\x34", 128},
    {"\xF2\xBF\xBA\x80", "\xC9\x31\xEA\x32", 128},
    {"\xF2\xBF\xBC\x80", "\xC9\x31\xF7\x30", 128},
    {"\xF2\xBF\xBE\x80", "\xC9\x32\x85\x38", 128},
    {"\xF3\x80\x80\x80", "\xC9\x32\x92\x36", 128},
    {"\xF3\x80\x82\x80", "\xC9\x32\x9F\x34", 128},
    {"\xF3\x80\x84\x80", "\xC9\x32\xAC\x32", 128},
    {"\xF3\x80\x86\x80", "\xC9\x32\xB9\x30", 128},
    {"\xF3\x80\x88\x80", "\xC9\x32\xC5\x38", 128},
    {"\xF3\x80\x8A\x80", "\xC9\x32\xD2\x36", 128},
    {"\xF3\x80\x8C\x80", "\xC9\x32\xDF\x34", 128},
    {"\xF3\x80\x8E\x80", "\xC9\x32\xEC\x32", 128},
    {"\xF3\x80\x90\x80", "\xC9\x32\xF9\x30", 128},
    {"\xF3\x80\x92\x80", "\xC9\x33\x87\x38", 128},
    {"\xF3\x80\x94\x80", "\xC9\x33\x94\x36", 128},
    {"\xF3\x80\x96\x80", "\xC9\x33\xA1\x34", 128},
    {"\xF3\x80\x98\x80", "\xC9\x33\xAE\x32", 128},
    {"\xF3\x80\x9A\x80", "\xC9\x33\xBB\x30", 128},
    {"\xF3\x80\x9C\x80", "\xC9\x33\xC7\x38", 128},
    {"\xF3\x80\x9E\x80", "\xC9\x33\xD4\x36", 128},
    {"\xF3\x80\xA0\x80", "\xC9\x33\xE1\x34", 128},
    {"\xF3\x80\xA2\x80", "\xC9\x33\xEE\x32", 128},
    {"\xF3\x80\xA4\x80", "\xC9\x33\xFB\x30", 128},
    {"\xF3\x80\xA6\x80", "\xC9\x34\x89\x38", 128},
    {"\xF3\x80\xA8\x80", "\xC9\x34\x96\x36", 128},
    {"\xF3\x80\xAA\x80", "\xC9\x34\xA3\x34", 128},
    {"\xF3\x80\xAC\x80", "\xC9\x34\xB0\x32", 128},
    {"\xF3\x80\xAE\x80", "\xC9\x34\xBD\x30", 128},
    {"\xF3\x80\xB0\x80", "\xC9\x34\xC9\x38", 128},
    {"\xF3\x80\xB2\x80", "\xC9\x34\xD6\x36", 128},
    {"\xF3\x80\xB4\x80", "\xC9\x34\xE3\x34", 128},
    {"\xF3\x80\xB6\x80", "\xC9\x34\xF0\x32", 128},
    {"\xF3\x80\xB8\x80", "\xC9\x34\xFD\x30", 128},
    {"\xF3\x80\xBA\x80", "\xC9\x35\x8B\x38", 128},
    {"\xF3\x80\xBC\x80", "\xC9\x35\x98\x36", 128},
    {"\xF3\x80\xBE\x80", "\xC9\x35\xA5\x34", 128},
    {"\xF3\x81\x80\x80", "\xC9\x35\xB2\x32", 128},
    {"\xF3\x81\x82\x80", "\xC9\x35\xBF\x30", 128},
    {"\xF3\x81\x84\x80", "\xC9\x35\xCB\x38", 128},
    {"\xF3\x81\x86\x80", "\xC9\x35\xD8\x36", 128},
    {"\xF3\x81\x88\x80", "\xC9\x35\xE5\x34", 128},
    {"\xF3\x81\x8A\x80", "\xC9\x35\xF2\x32", 128},
    {"\xF3\x81\x8C\x80", "\xC9\x36\x81\x30", 128},
    {"\xF3\x81\x8E\x80", "\xC9\x36\x8D\x38", 128},
    {"\xF3\x81\x90\x80", "\xC9\x36\x9A\x36", 128},
    {"\xF3\x81\x92\x80", "\xC9\x36\xA7\x34", 128},
    {"\xF3\x81\x94\x80", "\xC9\x36\xB4\x32", 128},
    {"\xF3\x81\x96\x80", "\xC9\x36\xC1\x30", 128},
    {"\xF3\x81\x98\x80", "\xC9\x36\xCD\x38", 128},
    {"\xF3\x81\x9A\x80", "\xC9\x36\xDA\x36", 128},
    {"\xF3\x81\x9C\x80", "\xC9\x36\xE7\x34", 128},
    {"\xF3\x81\x9E\x80", "\xC9\x36\xF4\x32", 128},
    {"\xF3\x81\xA0\x80", "\xC9\x37\x83\x30", 128},
    {"\xF3\x81\xA2\x80", "\xC9\x37\x8F\x38", 128},
    {"\xF3\x81\xA4\x80", "\xC9\x37\x9C\x36", 128},
    {"\xF3\x81\xA6\x80", "\xC9\x37\xA9\x34", 128},
    {"\xF3\x81\xA8\x80", "\xC9\x37\xB6\x32", 128},
    {"\xF3\x81\xAA\x80", "\xC9\x37\xC3\x30", 128},
    {"\xF3\x81\xAC\x80", "\xC9\x37\xCF\x38", 128},
    {"\xF3\x81\xAE\x80", "\xC9\x37\xDC\x36", 128},
    {"\xF3\x81\xB0\x80", "\xC9\x37\xE9\x34", 128},
    {"\xF3\x81\xB2\x80", "\xC9\x37\xF6\x32", 128},
    {"\xF3\x81\xB4\x80", "\xC9\x38\x85\x30", 128},
    {"\xF3\x81\xB6\x80", "\xC9\x38\x91\x38", 128},
    {"\xF3\x81\xB8\x80", "\xC9\x38\x9E\x36", 128},
    {"\xF3\x81\xBA\x80", "\xC9\x38\xAB\x34", 128},
    {"\xF3\x81\xBC\x80", "\xC9\x38\xB8\x32", 128},
    {"\xF3\x81\xBE\x80", "\xC9\x38\xC5\x30", 128},
    {"\xF3\x82\x80\x80", "\xC9\x38\xD1\x38", 128},
    {"\xF3\x82\x82\x80", "\xC9\x38\xDE\x36", 128},
    {"\xF3\x82\x84\x80", "\xC9\x38\xEB\x34", 128},
    {"\xF3\x82\x86\x80", "\xC9\x38\xF8\x32", 128},
    {"\xF3\x82\x88\x80", "\xC9\x39\x87\x30", 128},
    {"\xF3\x82\x8A\x80", "\xC9\x39\x93\x38", 128},
    {"\xF3\x82\x8C\x80", "\xC9\x39\xA0\x36", 128},
    {"\xF3\x82\x8E\x80", "\xC9\x39\xAD\x34", 128},
    {"\xF3\x82\x90\x80", "\xC9\x39\xBA\x32", 128},
    {"\xF3\x82\x92\x80", "\xC9\x39\xC7\x30", 128},
    {"\xF3\x82\x94\x80", "\xC9\x39\xD3\x38", 128},
    {"\xF3\x82\x96\x80", "\xC9\x39\xE0\x36", 128},
    {"\xF3\x82\x98\x80", "\xC9\x39\xED\x34", 128},
    {"\xF3\x82\x9A\x80", "\xC9\x39\xFA\x32", 128},
    {"\xF3\x82\x9C\x80", "\xCA\x30\x89\x30", 128},
    {"\xF3\x82\x9E\x80", "\xCA\x30\x95\x38", 128},
    {"\xF3\x82\xA0\x80", "\xCA\x30\xA2\x36", 128},
    {"\xF3\x82\xA2\x80", "\xCA\x30\xAF\x34", 128},
    {"\xF3\x82\xA4\x80", "\xCA\x30\xBC\x32", 128},
    {"\xF3\x82\xA6\x80", "\xCA\x30\xC9\x30", 128},
    {"\xF3\x82\xA8\x80", "\xCA\x30\xD5\x38", 128},
    {"\xF3\x82\xAA\x80", "\xCA\x30\xE2\x36", 128},
    {"\xF3\x82\xAC\x80", "\xCA\x30\xEF\x34", 128},
    {"\xF3\x82\xAE\x80", "\xCA\x30\xFC\x32", 128},
    {"\xF3\x82\xB0\x80", "\xCA\x31\x8B\x30", 128},
    {"\xF3\x82\xB2\x80", "\xCA\x31\x97\x38", 128},
    {"\xF3\x82\xB4\x80", "\xCA\x31\xA4\x36", 128},
    {"\xF3\x82\xB6\x80", "\xCA\x31\xB1\x34", 128},
    {"\xF3\x82\xB8\x80", "\xCA\x31\xBE\x32", 128},
    {"\xF3\x82\xBA\x80", "\xCA\x31\xCB\x30", 128},
    {"\xF3\x82\xBC\x80", "\xCA\x31\xD7\x38", 128},
    {"\xF3\x82\xBE\x80", "\xCA\x31\xE4\x36", 128},
    {"\xF3\x83\x80\x80", "\xCA\x31\xF1\x34", 128},
    {"\xF3\x83\x82\x80", "\xCA\x31\xFE\x32", 128},
    {"\xF3\x83\x84\x80", "\xCA\x32\x8D\x30", 128},
    {"\xF3\x83\x86\x80", "\xCA\x32\x99\x38", 128},
    {"\xF3\x83\x88\x80", "\xCA\x32\xA6\x36", 128},
    {"\xF3\x83\x8A\x80", "\xCA\x32\xB3\x34", 128},
    {"\xF3\x83\x8C\x80", "\xCA\x32\xC0\x32", 128},
    {"\xF3\x83\x8E\x80", "\xCA\x32\xCD\x30", 128},
    {"\xF3\x83\x90\x80", "\xCA\x32\xD9\x38", 128},
    {"\xF3\x83\x92\x80", "\xCA\x32\xE6\x36", 128},
    {"\xF3\x83\x94\x80", "\xCA\x32\xF3\x34", 128},
    {"\xF3\x83\x96\x80", "\xCA\x33\x82\x32", 128},
    {"\xF3\x83\x98\x80", "\xCA\x33\x8F\x30", 128},
    {"\xF3\x83\x9A\x80", "\xCA\x33\x9B\x38", 128},
    {"\xF3\x83\x9C\x80", "\xCA\x33\xA8\x36", 128},
    {"\xF3\x83\x9E\x80", "\xCA\x33\xB5\x34", 128},
    {"\xF3\x83\xA0\x80", "\xCA\x33\xC2\x32", 128},
    {"\xF3\x83\xA2\x80", "\xCA\x33\xCF\x30", 128},
    {"\xF3\x83\xA4\x80", "\xCA\x33\xDB\x38", 128},
    {"\xF3\x83\xA6\x80", "\xCA\x33\xE8\x36", 128},
    {"\xF3\x83\xA8\x80", "\xCA\x33\xF5\x34", 128},
    {"\xF3\x83\xAA\x80", "\xCA\x34\x84\x32", 128},
    {"\xF3\x83\xAC\x80", "\xCA\x34\x91\x30", 128},
    {"\xF3\x83\xAE\x80", "\xCA\x34\x9D\x38", 128},
    {"\xF3\x83\xB0\x80", "\xCA\x34\xAA\x36", 128},
    {"\xF3\x83\xB2\x80", "\xCA\x34\xB7\x34", 128},
    {"\xF3\x83\xB4\x80", "\xCA\x34\xC4\x32", 128},
    {"\xF3\x83\xB6\x80", "\xCA\x34\xD1\x30", 128},
    {"\xF3\x83\xB8\x80", "\xCA\x34\xDD\x38", 128},
    {"\xF3\x83\xBA\x80", "\xCA\x34\xEA\x36", 128},
    {"\xF3\x83\xBC\x80", "\xCA\x34\xF7\x34", 128},
    {"\xF3\x83\xBE\x80", "\xCA\x35\x86\x32", 128},
    {"\xF3\x84\x80\x80", "\xCA\x35\x93\x30", 128},
    {"\xF3\x84\x82\x80", "\xCA\x35\x9F\x38", 128},
    {"\xF3\x84\x84\x80", "\xCA\x35\xAC\x36", 128},
    {"\xF3\x84\x86\x80", "\xCA\x35\xB9\x34", 128},
    {"\xF3\x84\x88\x80", "\xCA\x35\xC6\x32", 128},
    {"\xF3\x84\x8A\x80", "\xCA\x35\xD3\x30", 128},
    {"\xF3\x84\x8C\x80", "\xCA\x35\xDF\x38", 128},
    {"\xF3\x84\x8E\x80", "\xCA\x35\xEC\x36", 128},
    {"\xF3\x84\x90\x80", "\xCA\x35\xF9\x34", 128},
    {"\xF3\x84\x92\x80", "\xCA\x36\x88\x32", 128},
    {"\xF3\x84\x94\x80", "\xCA\x36\x95\x30", 128},
    {"\xF3\x84\x96\x80", "\xCA\x36\xA1\x38", 128},
    {"\xF3\x84\x98\x80", "\xCA\x36\xAE\x36", 128},
    {"\xF3\x84\x9A\x80", "\xCA\x36\xBB\x34", 128},
    {"\xF3\x84\x9C\x80", "\xCA\x36\xC8\x32", 128},
    {"\xF3\x84\x9E\x80", "\xCA\x36\xD5\x30", 128},
    {"\xF3\x84\xA0\x80", "\xCA\x36\xE1\x38", 128},
    {"\xF3\x84\xA2\x80", "\xCA\x36\xEE\x36", 128},
    {"\xF3\x84\xA4\x80", "\xCA\x36\xFB\x34", 128},
    {"\xF3\x84\xA6\x80", "\xCA\x37\x8A\x32", 128},
    {"\xF3\x84\xA8\x80", "\xCA\x37\x97\x30", 128},
    {"\xF3\x84\xAA\x80", "\xCA\x37\xA3\x38", 128},
    {"\xF3\x84\xAC\x80", "\xCA\x37\xB0\x36", 128},
    {"\xF3\x84\xAE\x80", "\xCA\x37\xBD\x34", 128},
    {"\xF3\x84\xB0\x80", "\xCA\x37\xCA\x32", 128},
    {"\xF3\x84\xB2\x80", "\xCA\x37\xD7\x30", 128},
    {"\xF3\x84\xB4\x80", "\xCA\x37\xE3\x38", 128},
    {"\xF3\x84\xB6\x80", "\xCA\x37\xF0\x36", 128},
    {"\xF3\x84\xB8\x80", "\xCA\x37\xFD\x34", 128},
    {"\xF3\x84\xBA\x80", "\xCA\x38\x8C\x32", 128},
    {"\xF3\x84\xBC\x80", "\xCA\x38\x99\x30", 128},
    {"\xF3\x84\xBE\x80", "\xCA\x38\xA5\x38", 128},
    {"\xF3\x85\x80\x80", "\xCA\x38\xB2\x36", 128},
    {"\xF3\x85\x82\x80", "\xCA\x38\xBF\x34", 128},
    {"\xF3\x85\x84\x80", "\xCA\x38\xCC\x32", 128},
    {"\xF3\x85\x86\x80", "\xCA\x38\xD9\x30", 128},
    {"\xF3\x85\x88\x80", "\xCA\x38\xE5\x38", 128},
    {"\xF3\x85\x8A\x80", "\xCA\x38\xF2\x36", 128},
    {"\xF3\x85\x8C\x80", "\xCA\x39\x81\x34", 128},
    {"\xF3\x85\x8E\x80", "\xCA\x39\x8E\x32", 128},
    {"\xF3\x85\x90\x80", "\xCA\x39\x9B\x30", 128},
    {"\xF3\x85\x92\x80", "\xCA\x39\xA7\x38", 128},
    {"\xF3\x85\x94\x80", "\xCA\x39\xB4\x36", 128},
    {"\xF3\x85\x96\x80", "\xCA\x39\xC1\x34", 128},
    {"\xF3\x85\x98\x80", "\xCA\x39\xCE\x32", 128},
    {"\xF3\x85\x9A\x80", "\xCA\x39\xDB\x30", 128},
    {"\xF3\x85\x9C\x80", "\xCA\x39\xE7\x38", 128},
    {"\xF3\x85\x9E\x80", "\xCA\x39\xF4\x36", 128},
    {"\xF3\x85\xA0\x80", "\xCB\x30\x83\x34", 128},
    {"\xF3\x85\xA2\x80", "\xCB\x30\x90\x32", 128},
    {"\xF3\x85\xA4\x80", "\xCB\x30\x9D\x30", 128},
    {"\xF3\x85\xA6\x80", "\xCB\x30\xA9\x38", 128},
    {"\xF3\x85\xA8\x80", "\xCB\x30\xB6\x36", 128},
    {"\xF3\x85\xAA\x80", "\xCB\x30\xC3\x34", 128},
    {"\xF3\x85\xAC\x80", "\xCB\x30\xD0\x32", 128},
    {"\xF3\x85\xAE\x80", "\xCB\x30\xDD\x30", 128},
    {"\xF3\x85\xB0\x80", "\xCB\x30\xE9\x38", 128},
    {"\xF3\x85\xB2\x80", "\xCB\x30\xF6\x36", 128},
    {"\xF3\x85\xB4\x80", "\xCB\x31\x85\x34", 128},
    {"\xF3\x85\xB6\x80", "\xCB\x31\x92\x32", 128},
    {"\xF3\x85\xB8\x80", "\xCB\x31\x9F\x30", 128},
    {"\xF3\x85\xBA\x80", "\xCB\x31\xAB\x38", 128},
    {"\xF3\x85\xBC\x80", "\xCB\x31\xB8\x36", 128},
    {"\xF3\x85\xBE\x80", "\xCB\x31\xC5\x34", 128},
    {"\xF3\x86\x80\x80", "\xCB\x31\xD2\x32", 128},
    {"\xF3\x86\x82\x80", "\xCB\x31\xDF\x30", 128},
    {"\xF3\x86\x84\x80", "\xCB\x31\xEB\x38", 128},
    {"\xF3\x86\x86\x80", "\xCB\x31\xF8\x36", 128},
    {"\xF3\x86\x88\x80", "\xCB\x32\x87\x34", 128},
    {"\xF3\x86\x8A\x80", "\xCB\x32\x94\x32", 128},
    {"\xF3\x86\x8C\x80", "\xCB\x32\xA1\x30", 128},
    {"\xF3\x86\x8E\x80", "\xCB\x32\xAD\x38", 128},
    {"\xF3\x86\x90\x80", "\xCB\x32\xBA\x36", 128},
    {"\xF3\x86\x92\x80", "\xCB\x32\xC7\x34", 128},
    {"\xF3\x86\x94\x80", "\xCB\x32\xD4\x32", 128},
    {"\xF3\x86\x96\x80", "\xCB\x32\xE1\x30", 128},
    {"\xF3\x86\x98\x80", "\xCB\x32\xED\x38", 128},
    {"\xF3\x86\x9A\x80", "\xCB\x32\xFA\x36", 128},
    {"\xF3\x86\x9C\x80", "\xCB\x33\x89\x34", 128},
    {"\xF3\x86\x9E\x80", "\xCB\x33\x96\x32", 128},
    {"\xF3\x86\xA0\x80", "\xCB\x33\xA3\x30", 128},
    {"\xF3\x86\xA2\x80", "\xCB\x33\xAF\x38", 128},
    {"\xF3\x86\xA4\x80", "\xCB\x33\xBC\x36", 128},
    {"\xF3\x86\xA6\x80", "\xCB\x33\xC9\x34", 128},
    {"\xF3\x86\xA8\x80", "\xCB\x33\xD6\x32", 128},
    {"\xF3\x86\xAA\x80", "\xCB\x33\xE3\x30", 128},
    {"\xF3\x86\xAC\x80", "\xCB\x33\xEF\x38", 128},
    {"\xF3\x86\xAE\x80", "\xCB\x33\xFC\x36", 128},
    {"\xF3\x86\xB0\x80", "\xCB\x34\x8B\x34", 128},
    {"\xF3\x86\xB2\x80", "\xCB\x34\x98\x32", 128},
    {"\xF3\x86\xB4\x80", "\xCB\x34\xA5\x30", 128},
    {"\xF3\x86\xB6\x80", "\xCB\x34\xB1\x38", 128},
    {"\xF3\x86\xB8\x80", "\xCB\x34\xBE\x36", 128},
    {"\xF3\x86\xBA\x80", "\xCB\x34\xCB\x34", 128},
    {"\xF3\x86\xBC\x80", "\xCB\x34\xD8\x32", 128},
    {"\xF3\x86\xBE\x80", "\xCB\x34\xE5\x30", 128},
    {"\xF3\x87\x80\x80", "\xCB\x34\xF1\x38", 128},
    {"\xF3\x87\x82\x80", "\xCB\x34\xFE\x36", 128},
    {"\xF3\x87\x84\x80", "\xCB\x35\x8D\x34", 128},
    {"\xF3\x87\x86\x80", "\xCB\x35\x9A\x32", 128},
    {"\xF3\x87\x88\x80", "\xCB\x35\xA7\x30", 128},
    {"\xF3\x87\x8A\x80", "\xCB\x35\xB3\x38", 128},
    {"\xF3\x87\x8C\x80", "\xCB\x35\xC0\x36", 128},
    {"\xF3\x87\x8E\x80", "\xCB\x35\xCD\x34", 128},
    {"\xF3\x87\x90\x80", "\xCB\x35\xDA\x32", 128},
    {"\xF3\x87\x92\x80", "\xCB\x35\xE7\x30", 128},
    {"\xF3\x87\x94\x80", "\xCB\x35\xF3\x38", 128},
    {"\xF3\x87\x96\x80", "\xCB\x36\x82\x36", 128},
    {"\xF3\x87\x98\x80", "\xCB\x36\x8F\x34", 128},
    {"\xF3\x87\x9A\x80", "\xCB\x36\x9C\x32", 128},
    {"\xF3\x87\x9C\x80", "\xCB\x36\xA9\x30", 128},
    {"\xF3\x87\x9E\x80", "\xCB\x36\xB5\x38", 128},
    {"\xF3\x87\xA0\x80", "\xCB\x36\xC2\x36", 128},
    {"\xF3\x87\xA2\x80", "\xCB\x36\xCF\x34", 128},
    {"\xF3\x87\xA4\x80", "\xCB\x36\xDC\x32", 128},
    {"\xF3\x87\xA6\x80", "\xCB\x36\xE9\x30", 128},
    {"\xF3\x87\xA8\x80", "\xCB\x36\xF5\x38", 128},
    {"\xF3\x87\xAA\x80", "\xCB\x37\x84\x36", 128},
    {"\xF3\x87\xAC\x80", "\xCB\x37\x91\x34", 128},
    {"\xF3\x87\xAE\x80", "\xCB\x37\x9E\x32", 128},
    {"\xF3\x87\xB0\x80", "\xCB\x37\xAB\x30", 128},
    {"\xF3\x87\xB2\x80", "\xCB\x37\xB7\x38", 128},
    {"\xF3\x87\xB4\x80", "\xCB\x37\xC4\x36", 128},
    {"\xF3\x87\xB6\x80", "\xCB\x37\xD1\x34", 128},
    {"\xF3\x87\xB8\x80", "\xCB\x37\xDE\x32", 128},
    {"\xF3\x87\xBA\x80", "\xCB\x37\xEB\x30", 128},
    {"\xF3\x87\xBC\x80", "\xCB\x37\xF7\x38", 128},
    {"\xF3\x87\xBE\x80", "\xCB\x38\x86\x36", 128},
    {"\xF3\x88\x80\x80", "\xCB\x38\x93\x34", 128},
    {"\xF3\x88\x82\x80", "\xCB\x38\xA0\x32", 128},
    {"\xF3\x88\x84\x80", "\xCB\x38\xAD\x30", 128},
    {"\xF3\x88\x86\x80", "\xCB\x38\xB9\x38", 128},
    {"\xF3\x88\x88\x80", "\xCB\x38\xC6\x36", 128},
    {"\xF3\x88\x8A\x80", "\xCB\x38\xD3\x34", 128},
    {"\xF3\x88\x8C\x80", "\xCB\x38\xE0\x32", 128},
    {"\xF3\x88\x8E\x80", "\xCB\x38\xED\x30", 128},
    {"\xF3\x88\x90\x80", "\xCB\x38\xF9\x38", 128},
    {"\xF3\x88\x92\x80", "\xCB\x39\x88\x36", 128},
    {"\xF3\x88\x94\x80", "\xCB\x39\x95\x34", 128},
    {"\xF3\x88\x96\x80", "\xCB\x39\xA2\x32", 128},
    {"\xF3\x88\x98\x80", "\xCB\x39\xAF\x30", 128},
    {"\xF3\x88\x9A\x80", "\xCB\x39\xBB\x38", 128},
    {"\xF3\x88\x9C\x80", "\xCB\x39\xC8\x36", 128},
    {"\xF3\x88\x9E\x80", "\xCB\x39\xD5\x34", 128},
    {"\xF3\x88\xA0\x80", "\xCB\x39\xE2\x32", 128},
    {"\xF3\x88\xA2\x80", "\xCB\x39\xEF\x30", 128},
    {"\xF3\x88\xA4\x80", "\xCB\x39\xFB\x38", 128},
    {"\xF3\x88\xA6\x80", "\xCC\x30\x8A\x36", 128},
    {"\xF3\x88\xA8\x80", "\xCC\x30\x97\x34", 128},
    {"\xF3\x88\xAA\x80", "\xCC\x30\xA4\x32", 128},
    {"\xF3\x88\xAC\x80", "\xCC\x30\xB1\x30", 128},
    {"\xF3\x88\xAE\x80", "\xCC\x30\xBD\x38", 128},
    {"\xF3\x88\xB0\x80", "\xCC\x30\xCA\x36", 128},
    {"\xF3\x88\xB2\x80", "\xCC\x30\xD7\x34", 128},
    {"\xF3\x88\xB4\x80", "\xCC\x30\xE4\x32", 128},
    {"\xF3\x88\xB6\x80", "\xCC\x30\xF1\x30", 128},
    {"\xF3\x88\xB8\x80", "\xCC\x30\xFD\x38", 128},
    {"\xF3\x88\xBA\x80", "\xCC\x31\x8C\x36", 128},
    {"\xF3\x88\xBC\x80", "\xCC\x31\x99\x34", 128},
    {"\xF3\x88\xBE\x80", "\xCC\x31\xA6\x32", 128},
    {"\xF3\x89\x80\x80", "\xCC\x31\xB3\x30", 128},
    {"\xF3\x89\x82\x80", "\xCC\x31\xBF\x38", 128},
    {"\xF3\x89\x84\x80", "\xCC\x31\xCC\x36", 128},
    {"\xF3\x89\x86\x80", "\xCC\x31\xD9\x34", 128},
    {"\xF3\x89\x88\x80", "\xCC\x31\xE6\x32", 128},
    {"\xF3\x89\x8A\x80", "\xCC\x31\xF3\x30", 128},
    {"\xF3\x89\x8C\x80", "\xCC\x32\x81\x38", 128},
    {"\xF3\x89\x8E\x80", "\xCC\x32\x8E\x36", 128},
    {"\xF3\x89\x90\x80", "\xCC\x32\x9B\x34", 128},
    {"\xF3\x89\x92\x80", "\xCC\x32\xA8\x32", 128},
    {"\xF3\x89\x94\x80", "\xCC\x32\xB5\x30", 128},
    {"\xF3\x89\x96\x80", "\xCC\x32\xC1\x38", 128},
    {"\xF3\x89\x98\x80", "\xCC\x32\xCE\x36", 128},
    {"\xF3\x89\x9A\x80", "\xCC\x32\xDB\x34", 128},
    {"\xF3\x89\x9C\x80", "\xCC\x32\xE8\x32", 128},
    {"\xF3\x89\x9E\x80", "\xCC\x32\xF5\x30", 128},
    {"\xF3\x89\xA0\x80", "\xCC\x33\x83\x38", 128},
    {"\xF3\x89\xA2\x80", "\xCC\x33\x90\x36", 128},
    {"\xF3\x89\xA4\x80", "\xCC\x33\x9D\x34", 128},
    {"\xF3\x89\xA6\x80", "\xCC\x33\xAA\x32", 128},
    {"\xF3\x89\xA8\x80", "\xCC\x33\xB7\x30", 128},
    {"\xF3\x89\xAA\x80", "\xCC\x33\xC3\x38", 128},
    {"\xF3\x89\xAC\x80", "\xCC\x33\xD0\x36", 128},
    {"\xF3\x89\xAE\x80", "\xCC\x33\xDD\x34", 128},
    {"\xF3\x89\xB0\x80", "\xCC\x33\xEA\x32", 128},
    {"\xF3\x89\xB2\x80", "\xCC\x33\xF7\x30", 128},
    {"\xF3\x89\xB4\x80", "\xCC\x34\x85\x38", 128},
    {"\xF3\x89\xB6\x80", "\xCC\x34\x92\x36", 128},
    {"\xF3\x89\xB8\x80", "\xCC\x34\x9F\x34", 128},
    {"\xF3\x89\xBA\x80", "\xCC\x34\xAC\x32", 128},
    {"\xF3\x89\xBC\x80", "\xCC\x34\xB9\x30", 128},
    {"\xF3\x89\xBE\x80", "\xCC\x34\xC5\x38", 128},
    {"\xF3\x8A\x80\x80", "\xCC\x34\xD2\x36", 128},
    {"\xF3\x8A\x82\x80", "\xCC\x34\xDF\x34", 128},
    {"\xF3\x8A\x84\x80", "\xCC\x34\xEC\x32", 128},
    {"\xF3\x8A\x86\x80", "\xCC\x34\xF9\x30", 128},
    {"\xF3\x8A\x88\x80", "\xCC\x35\x87\x38", 128},
    {"\xF3\x8A\x8A\x80", "\xCC\x35\x94\x36", 128},
    {"\xF3\x8A\x8C\x80", "\xCC\x35\xA1\x34", 128},
    {"\xF3\x8A\x8E\x80", "\xCC\x35\xAE\x32", 128},
    {"\xF3\x8A\x90\x80", "\xCC\x35\xBB\x30", 128},
    {"\xF3\x8A\x92\x80", "\xCC\x35\xC7\x38", 128},
    {"\xF3\x8A\x94\x80", "\xCC\x35\xD4\x36", 128},
    {"\xF3\x8A\x96\x80", "\xCC\x35\xE1\x34", 128},
    {"\xF3\x8A\x98\x80", "\xCC\x35\xEE\x32", 128},
    {"\xF3\x8A\x9A\x80", "\xCC\x35\xFB\x30", 128},
    {"\xF3\x8A\x9C\x80", "\xCC\x36\x89\x38", 128},
    {"\xF3\x8A\x9E\x80", "\xCC\x36\x96\x36", 128},
    {"\xF3\x8A\xA0\x80", "\xCC\x36\xA3\x34", 128},
    {"\xF3\x8A\xA2\x80", "\xCC\x36\xB0\x32", 128},
    {"\xF3\x8A\xA4\x80", "\xCC\x36\xBD\x30", 128},
    {"\xF3\x8A\xA6\x80", "\xCC\x36\xC9\x38", 128},
    {"\xF3\x8A\xA8\x80", "\xCC\x36\xD6\x36", 128},
    {"\xF3\x8A\xAA\x80", "\xCC\x36\xE3\x34", 128},
    {"\xF3\x8A\xAC\x80", "\xCC\x36\xF0\x32", 128},
    {"\xF3\x8A\xAE\x80", "\xCC\x36\xFD\x30", 128},
    {"\xF3\x8A\xB0\x80", "\xCC\x37\x8B\x38", 128},
    {"\xF3\x8A\xB2\x80", "\xCC\x37\x98\x36", 128},
    {"\xF3\x8A\xB4\x80", "\xCC\x37\xA5\x34", 128},
    {"\xF3\x8A\xB6\x80", "\xCC\x37\xB2\x32", 128},
    {"\xF3\x8A\xB8\x80", "\xCC\x37\xBF\x30", 128},
    {"\xF3\x8A\xBA\x80", "\xCC\x37\xCB\x38", 128},
    {"\xF3\x8A\xBC\x80", "\xCC\x37\xD8\x36", 128},
    {"\xF3\x8A\xBE\x80", "\xCC\x37\xE5\x34", 128},
    {"\xF3\x8B\x80\x80", "\xCC\x37\xF2\x32", 128},
    {"\xF3\x8B\x82\x80", "\xCC\x38\x81\x30", 128},
    {"\xF3\x8B\x84\x80", "\xCC\x38\x8D\x38", 128},
    {"\xF3\x8B\x86\x80", "\xCC\x38\x9A\x36", 128},
    {"\xF3\x8B\x88\x80", "\xCC\x38\xA7\x34", 128},
    {"\xF3\x8B\x8A\x80", "\xCC\x38\xB4\x32", 128},
    {"\xF3\x8B\x8C\x80", "\xCC\x38\xC1\x30", 128},
    {"\xF3\x8B\x8E\x80", "\xCC\x38\xCD\x38", 128},
    {"\xF3\x8B\x90\x80", "\xCC\x38\xDA\x36", 128},
    {"\xF3\x8B\x92\x80", "\xCC\x38\xE7\x34", 128},
    {"\xF3\x8B\x94\x80", "\xCC\x38\xF4\x32", 128},
    {"\xF3\x8B\x96\x80", "\xCC\x39\x83\x30", 128},
    {"\xF3\x8B\x98\x80", "\xCC\x39\x8F\x38", 128},
    {"\xF3\x8B\x9A\x80", "\xCC\x39\x9C\x36", 128},
    {"\xF3\x8B\x9C\x80", "\xCC\x39\xA9\x34", 128},
    {"\xF3\x8B\x9E\x80", "\xCC\x39\xB6\x32", 128},
    {"\xF3\x8B\xA0\x80", "\xCC\x39\xC3\x30", 128},
    {"\xF3\x8B\xA2\x80", "\xCC\x39\xCF\x38", 128},
    {"\xF3\x8B\xA4\x80", "\xCC\x39\xDC\x36", 128},
    {"\xF3\x8B\xA6\x80", "\xCC\x39\xE9\x34", 128},
    {"\xF3\x8B\xA8\x80", "\xCC\x39\xF6\x32", 128},
    {"\xF3\x8B\xAA\x80", "\xCD\x30\x85\x30", 128},
    {"\xF3\x8B\xAC\x80", "\xCD\x30\x91\x38", 128},
    {"\xF3\x8B\xAE\x80", "\xCD\x30\x9E\x36", 128},
    {"\xF3\x8B\xB0\x80", "\xCD\x30\xAB\x34", 128},
    {"\xF3\x8B\xB2\x80", "\xCD\x30\xB8\x32", 128},
    {"\xF3\x8B\xB4\x80", "\xCD\x30\xC5\x30", 128},
    {"\xF3\x8B\xB6\x80", "\xCD\x30\xD1\x38", 128},
    {"\xF3\x8B\xB8\x80", "\xCD\x30\xDE\x36", 128},
    {"\xF3\x8B\xBA\x80", "\xCD\x30\xEB\x34", 128},
    {"\xF3\x8B\xBC\x80", "\xCD\x30\xF8\x32", 128},
    {"\xF3\x8B\xBE\x80", "\xCD\x31\x87\x30", 128},
    {"\xF3\x8C\x80\x80", "\xCD\x31\x93\x38", 128},
    {"\xF3\x8C\x82\x80", "\xCD\x31\xA0\x36", 128},
    {"\xF3\x8C\x84\x80", "\xCD\x31\xAD\x34", 128},
    {"\xF3\x8C\x86\x80", "\xCD\x31\xBA\x32", 128},
    {"\xF3\x8C\x88\x80", "\xCD\x31\xC7\x30", 128},
    {"\xF3\x8C\x8A\x80", "\xCD\x31\xD3\x38", 128},
    {"\xF3\x8C\x8C\x80", "\xCD\x31\xE0\x36", 128},
    {"\xF3\x8C\x8E\x80", "\xCD\x31\xED\x34", 128},
    {"\xF3\x8C\x90\x80", "\xCD\x31\xFA\x32", 128},
    {"\xF3\x8C\x92\x80", "\xCD\x32\x89\x30", 128},
    {"\xF3\x8C\x94\x80", "\xCD\x32\x95\x38", 128},
    {"\xF3\x8C\x96\x80", "\xCD\x32\xA2\x36", 128},
    {"\xF3\x8C\x98\x80", "\xCD\x32\xAF\x34", 128},
    {"\xF3\x8C\x9A\x80", "\xCD\x32\xBC\x32", 128},
    {"\xF3\x8C\x9C\x80", "\xCD\x32\xC9\x30", 128},
    {"\xF3\x8C\x9E\x80", "\xCD\x32\xD5\x38", 128},
    {"\xF3\x8C\xA0\x80", "\xCD\x32\xE2\x36", 128},
    {"\xF3\x8C\xA2\x80", "\xCD\x32\xEF\x34", 128},
    {"\xF3\x8C\xA4\x80", "\xCD\x32\xFC\x32", 128},
    {"\xF3\x8C\xA6\x80", "\xCD\x33\x8B\x30", 128},
    {"\xF3\x8C\xA8\x80", "\xCD\x33\x97\x38", 128},
    {"\xF3\x8C\xAA\x80", "\xCD\x33\xA4\x36", 128},
    {"\xF3\x8C\xAC\x80", "\xCD\x33\xB1\x34", 128},
    {"\xF3\x8C\xAE\x80", "\xCD\x33\xBE\x32", 128},
    {"\xF3\x8C\xB0\x80", "\xCD\x33\xCB\x30", 128},
    {"\xF3\x8C\xB2\x80", "\xCD\x33\xD7\x38", 128},
    {"\xF3\x8C\xB4\x80", "\xCD\x33\xE4\x36", 128},
    {"\xF3\x8C\xB6\x80", "\xCD\x33\xF1\x34", 128},
    {"\xF3\x8C\xB8\x80", "\xCD\x33\xFE\x32", 128},
    {"\xF3\x8C\xBA\x80", "\xCD\x34\x8D\x30", 128},
    {"\xF3\x8C\xBC\x80", "\xCD\x34\x99\x38", 128},
    {"\xF3\x8C\xBE\x80", "\xCD\x34\xA6\x36", 128},
    {"\xF3\x8D\x80\x80", "\xCD\x34\xB3\x34", 128},
    {"\xF3\x8D\x82\x80", "\xCD\x34\xC0\x32", 128},
    {"\xF3\x8D\x84\x80", "\xCD\x34\xCD\x30", 128},
    {"\xF3\x8D\x86\x80", "\xCD\x34\xD9\x38", 128},
    {"\xF3\x8D\x88\x80", "\xCD\x34\xE6\x36", 128},
    {"\xF3\x8D\x8A\x80", "\xCD\x34\xF3\x34", 128},
    {"\xF3\x8D\x8C\x80", "\xCD\x35\x82\x32", 128},
    {"\xF3\x8D\x8E\x80", "\xCD\x35\x8F\x30", 128},
    {"\xF3\x8D\x90\x80", "\xCD\x35\x9B\x38", 128},
    {"\xF3\x8D\x92\x80", "\xCD\x35\xA8\x36", 128},
    {"\xF3\x8D\x94\x80", "\xCD\x35\xB5\x34", 128},
    {"\xF3\x8D\x96\x80", "\xCD\x35\xC2\x32", 128},
    {"\xF3\x8D\x98\x80", "\xCD\x35\xCF\x30", 128},
    {"\xF3\x8D\x9A\x80", "\xCD\x35\xDB\x38", 128},
    {"\xF3\x8D\x9C\x80", "\xCD\x35\xE8\x36", 128},
    {"\xF3\x8D\x9E\x80", "\xCD\x35\xF5\x34", 128},
    {"\xF3\x8D\xA0\x80", "\xCD\x36\x84\x32", 128},
    {"\xF3\x8D\xA2\x80", "\xCD\x36\x91\x30", 128},
    {"\xF3\x8D\xA4\x80", "\xCD\x36\x9D\x38", 128},
    {"\xF3\x8D\xA6\x80", "\xCD\x36\xAA\x36", 128},
    {"\xF3\x8D\xA8\x80", "\xCD\x36\xB7\x34", 128},
    {"\xF3\x8D\xAA\x80", "\xCD\x36\xC4\x32", 128},
    {"\xF3\x8D\xAC\x80", "\xCD\x36\xD1\x30", 128},
    {"\xF3\x8D\xAE\x80", "\xCD\x36\xDD\x38", 128},
    {"\xF3\x8D\xB0\x80", "\xCD\x36\xEA\x36", 128},
    {"\xF3\x8D\xB2\x80", "\xCD\x36\xF7\x34", 128},
    {"\xF3\x8D\xB4\x80", "\xCD\x37\x86\x32", 128},
    {"\xF3\x8D\xB6\x80", "\xCD\x37\x93\x30", 128},
    {"\xF3\x8D\xB8\x80", "\xCD\x37\x9F\x38", 128},
    {"\xF3\x8D\xBA\x80", "\xCD\x37\xAC\x36", 128},
    {"\xF3\x8D\xBC\x80", "\xCD\x37\xB9\x34", 128},
    {"\xF3\x8D\xBE\x80", "\xCD\x37\xC6\x32", 128},
    {"\xF3\x8E\x80\x80", "\xCD\x37\xD3\x30", 128},
    {"\xF3\x8E\x82\x80", "\xCD\x37\xDF\x38", 128},
    {"\xF3\x8E\x84\x80", "\xCD\x37\xEC\x36", 128},
    {"\xF3\x8E\x86\x80", "\xCD\x37\xF9\x34", 128},
    {"\xF3\x8E\x88\x80", "\xCD\x38\x88\x32", 128},
    {"\xF3\x8E\x8A\x80", "\xCD\x38\x95\x30", 128},
    {"\xF3\x8E\x8C\x80", "\xCD\x38\xA1\x38", 128},
    {"\xF3\x8E\x8E\x80", "\xCD\x38\xAE\x36", 128},
    {"\xF3\x8E\x90\x80", "\xCD\x38\xBB\x34", 128},
    {"\xF3\x8E\x92\x80", "\xCD\x38\xC8\x32", 128},
    {"\xF3\x8E\x94\x80", "\xCD\x38\xD5\x30", 128},
    {"\xF3\x8E\x96\x80", "\xCD\x38\xE1\x38", 128},
    {"\xF3\x8E\x98\x80", "\xCD\x38\xEE\x36", 128},
    {"\xF3\x8E\x9A\x80", "\xCD\x38\xFB\x34", 128},
    {"\xF3\x8E\x9C\x80", "\xCD\x39\x8A\x32", 128},
    {"\xF3\x8E\x9E\x80", "\xCD\x39\x97\x30", 128},
    {"\xF3\x8E\xA0\x80", "\xCD\x39\xA3\x38", 128},
    {"\xF3\x8E\xA2\x80", "\xCD\x39\xB0\x36", 128},
    {"\xF3\x8E\xA4\x80", "\xCD\x39\xBD\x34", 128},
    {"\xF3\x8E\xA6\x80", "\xCD\x39\xCA\x32", 128},
    {"\xF3\x8E\xA8\x80", "\xCD\x39\xD7\x30", 128},
    {"\xF3\x8E\xAA\x80", "\xCD\x39\xE3\x38", 128},
    {"\xF3\x8E\xAC\x80", "\xCD\x39\xF0\x36", 128},
    {"\xF3\x8E\xAE\x80", "\xCD\x39\xFD\x34", 128},
    {"\xF3\x8E\xB0\x80", "\xCE\x30\x8C\x32", 128},
    {"\xF3\x8E\xB2\x80", "\xCE\x30\x99\x30", 128},
    {"\xF3\x8E\xB4\x80", "\xCE\x30\xA5\x38", 128},
    {"\xF3\x8E\xB6\x80", "\xCE\x30\xB2\x36", 128},
    {"\xF3\x8E\xB8\x80", "\xCE\x30\xBF\x34", 128},
    {"\xF3\x8E\xBA\x80", "\xCE\x30\xCC\x32", 128},
    {"\xF3\x8E\xBC\x80", "\xCE\x30\xD9\x30", 128},
    {"\xF3\x8E\xBE\x80", "\xCE\x30\xE5\x38", 128},
    {"\xF3\x8F\x80\x80", "\xCE\x30\xF2\x36", 128},
    {"\xF3\x8F\x82\x80", "\xCE\x31\x81\x34", 128},
    {"\xF3\x8F\x84\x80", "\xCE\x31\x8E\x32", 128},
    {"\xF3\x8F\x86\x80", "\xCE\x31\x9B\x30", 128},
    {"\xF3\x8F\x88\x80", "\xCE\x31\xA7\x38", 128},
    {"\xF3\x8F\x8A\x80", "\xCE\x31\xB4\x36", 128},
    {"\xF3\x8F\x8C\x80", "\xCE\x31\xC1\x34", 128},
    {"\xF3\x8F\x8E\x80", "\xCE\x31\xCE\x32", 128},
    {"\xF3\x8F\x90\x80", "\xCE\x31\xDB\x30", 128},
    {"\xF3\x8F\x92\x80", "\xCE\x31\xE7\x38", 128},
    {"\xF3\x8F\x94\x80", "\xCE\x31\xF4\x36", 128},
    {"\xF3\x8F\x96\x80", "\xCE\x32\x83\x34", 128},
    {"\xF3\x8F\x98\x80", "\xCE\x32\x90\x32", 128},
    {"\xF3\x8F\x9A\x80", "\xCE\x32\x9D\x30", 128},
    {"\xF3\x8F\x9C\x80", "\xCE\x32\xA9\x38", 128},
    {"\xF3\x8F\x9E\x80", "\xCE\x32\xB6\x36", 128},
    {"\xF3\x8F\xA0\x80", "\xCE\x32\xC3\x34", 128},
    {"\xF3\x8F\xA2\x80", "\xCE\x32\xD0\x32", 128},
    {"\xF3\x8F\xA4\x80", "\xCE\x32\xDD\x30", 128},
    {"\xF3\x8F\xA6\x80", "\xCE\x32\xE9\x38", 128},
    {"\xF3\x8F\xA8\x80", "\xCE\x32\xF6\x36", 128},
    {"\xF3\x8F\xAA\x80", "\xCE\x33\x85\x34", 128},
    {"\xF3\x8F\xAC\x80", "\xCE\x33\x92\x32", 128},
    {"\xF3\x8F\xAE\x80", "\xCE\x33\x9F\x30", 128},
    {"\xF3\x8F\xB0\x80", "\xCE\x33\xAB\x38", 128},
    {"\xF3\x8F\xB2\x80", "\xCE\x33\xB8\x36", 128},
    {"\xF3\x8F\xB4\x80", "\xCE\x33\xC5\x34", 128},
    {"\xF3\x8F\xB6\x80", "\xCE\x33\xD2\x32", 128},
    {"\xF3\x8F\xB8\x80", "\xCE\x33\xDF\x30", 128},
    {"\xF3\x8F\xBA\x80", "\xCE\x33\xEB\x38", 128},
    {"\xF3\x8F\xBC\x80", "\xCE\x33\xF8\x36", 128},
    {"\xF3\x8F\xBE\x80", "\xCE\x34\x87\x34", 128},
    {"\xF3\x90\x80\x80", "\xCE\x34\x94\x32", 128},
    {"\xF3\x90\x82\x80", "\xCE\x34\xA1\x30", 128},
    {"\xF3\x90\x84\x80", "\xCE\x34\xAD\x38", 128},
    {"\xF3\x90\x86\x80", "\xCE\x34\xBA\x36", 128},
    {"\xF3\x90\x88\x80", "\xCE\x34\xC7\x34", 128},
    {"\xF3\x90\x8A\x80", "\xCE\x34\xD4\x32", 128},
    {"\xF3\x90\x8C\x80", "\xCE\x34\xE1\x30", 128},
    {"\xF3\x90\x8E\x80", "\xCE\x34\xED\x38", 128},
    {"\xF3\x90\x90\x80", "\xCE\x34\xFA\x36", 128},
    {"\xF3\x90\x92\x80", "\xCE\x35\x89\x34", 128},
    {"\xF3\x90\x94\x80", "\xCE\x35\x96\x32", 128},
    {"\xF3\x90\x96\x80", "\xCE\x35\xA3\x30", 128},
    {"\xF3\x90\x98\x80", "\xCE\x35\xAF\x38", 128},
    {"\xF3\x90\x9A\x80", "\xCE\x35\xBC\x36", 128},
    {"\xF3\x90\x9C\x80", "\xCE\x35\xC9\x34", 128},
    {"\xF3\x90\x9E\x80", "\xCE\x35\xD6\x32", 128},
    {"\xF3\x90\xA0\x80", "\xCE\x35\xE3\x30", 128},
    {"\xF3\x90\xA2\x80", "\xCE\x35\xEF\x38", 128},
    {"\xF3\x90\xA4\x80", "\xCE\x35\xFC\x36", 128},
    {"\xF3\x90\xA6\x80", "\xCE\x36\x8B\x34", 128},
    {"\xF3\x90\xA8\x80", "\xCE\x36\x98\x32", 128},
    {"\xF3\x90\xAA\x80", "\xCE\x36\xA5\x30", 128},
    {"\xF3\x90\xAC\x80", "\xCE\x36\xB1\x38", 128},
    {"\xF3\x90\xAE\x80", "\xCE\x36\xBE\x36", 128},
    {"\xF3\x90\xB0\x80", "\xCE\x36\xCB\x34", 128},
    {"\xF3\x90\xB2\x80", "\xCE\x36\xD8\x32", 128},
    {"\xF3\x90\xB4\x80", "\xCE\x36\xE5\x30", 128},
    {"\xF3\x90\xB6\x80", "\xCE\x36\xF1\x38", 128},
    {"\xF3\x90\xB8\x80", "\xCE\x36\xFE\x36", 128},
    {"\xF3\x90\xBA\x80", "\xCE\x37\x8D\x34", 128},
    {"\xF3\x90\xBC\x80", "\xCE\x37\x9A\x32", 128},
    {"\xF3\x90\xBE\x80", "\xCE\x37\xA7\x30", 128},
    {"\xF3\x91\x80\x80", "\xCE\x37\xB3\x38", 128},
    {"\xF3\x91\x82\x80", "\xCE\x37\xC0\x36", 128},
    {"\xF3\x91\x84\x80", "\xCE\x37\xCD\x34", 128},
    {"\xF3\x91\x86\x80", "\xCE\x37\xDA\x32", 128},
    {"\xF3\x91\x88\x80", "\xCE\x37\xE7\x30", 128},
    {"\xF3\x91\x8A\x80", "\xCE\x37\xF3\x38", 128},
    {"\xF3\x91\x8C\x80", "\xCE\x38\x82\x36", 128},
    {"\xF3\x91\x8E\x80", "\xCE\x38\x8F\x34", 128},
    {"\xF3\x91\x90\x80", "\xCE\x38\x9C\x32", 128},
    {"\xF3\x91\x92\x80", "\xCE\x38\xA9\x30", 128},
    {"\xF3\x91\x94\x80", "\xCE\x38\xB5\x38", 128},
    {"\xF3\x91\x96\x80", "\xCE\x38\xC2\x36", 128},
    {"\xF3\x91\x98\x80", "\xCE\x38\xCF\x34", 128},
    {"\xF3\x91\x9A\x80", "\xCE\x38\xDC\x32", 128},
    {"\xF3\x91\x9C\x80", "\xCE\x38\xE9\x30", 128},
    {"\xF3\x91\x9E\x80", "\xCE\x38\xF5\x38", 128},
    {"\xF3\x91\xA0\x80", "\xCE\x39\x84\x36", 128},
    {"\xF3\x91\xA2\x80", "\xCE\x39\x91\x34", 128},
    {"\xF3\x91\xA4\x80", "\xCE\x39\x9E\x32", 128},
    {"\xF3\x91\xA6\x80", "\xCE\x39\xAB\x30", 128},
    {"\xF3\x91\xA8\x80", "\xCE\x39\xB7\x38", 128},
    {"\xF3\x91\xAA\x80", "\xCE\x39\xC4\x36", 128},
    {"\xF3\x91\xAC\x80", "\xCE\x39\xD1\x34", 128},
    {"\xF3\x91\xAE\x80", "\xCE\x39\xDE\x32", 128},
    {"\xF3\x91\xB0\x80", "\xCE\x39\xEB\x30", 128},
    {"\xF3\x91\xB2\x80", "\xCE\x39\xF7\x38", 128},
    {"\xF3\x91\xB4\x80", "\xCF\x30\x86\x36", 128},
    {"\xF3\x91\xB6\x80", "\xCF\x30\x93\x34", 128},
    {"\xF3\x91\xB8\x80", "\xCF\x30\xA0\x32", 128},
    {"\xF3\x91\xBA\x80", "\xCF\x30\xAD\x30", 128},
    {"\xF3\x91\xBC\x80", "\xCF\x30\xB9\x38", 128},
    {"\xF3\x91\xBE\x80", "\xCF\x30\xC6\x36", 128},
    {"\xF3\x92\x80\x80", "\xCF\x30\xD3\x34", 128},
    {"\xF3\x92\x82\x80", "\xCF\x30\xE0\x32", 128},
    {"\xF3\x92\x84\x80", "\xCF\x30\xED\x30", 128},
    {"\xF3\x92\x86\x80", "\xCF\x30\xF9\x38", 128},
    {"\xF3\x92\x88\x80", "\xCF\x31\x88\x36", 128},
    {"\xF3\x92\x8A\x80", "\xCF\x31\x95\x34", 128},
    {"\xF3\x92\x8C\x80", "\xCF\x31\xA2\x32", 128},
    {"\xF3\x92\x8E\x80", "\xCF\x31\xAF\x30", 128},
    {"\xF3\x92\x90\x80", "\xCF\x31\xBB\x38", 128},
    {"\xF3\x92\x92\x80", "\xCF\x31\xC8\x36", 128},
    {"\xF3\x92\x94\x80", "\xCF\x31\xD5\x34", 128},
    {"\xF3\x92\x96\x80", "\xCF\x31\xE2\x32", 128},
    {"\xF3\x92\x98\x80", "\xCF\x31\xEF\x30", 128},
    {"\xF3\x92\x9A\x80", "\xCF\x31\xFB\x38", 128},
    {"\xF3\x92\x9C\x80", "\xCF\x32\x8A\x36", 128},
    {"\xF3\x92\x9E\x80", "\xCF\x32\x97\x34", 128},
    {"\xF3\x92\xA0\x80", "\xCF\x32\xA4\x32", 128},
    {"\xF3\x92\xA2\x80", "\xCF\x32\xB1\x30", 128},
    {"\xF3\x92\xA4\x80", "\xCF\x32\xBD\x38", 128},
    {"\xF3\x92\xA6\x80", "\xCF\x32\xCA\x36", 128},
    {"\xF3\x92\xA8\x80", "\xCF\x32\xD7\x34", 128},
    {"\xF3\x92\xAA\x80", "\xCF\x32\xE4\x32", 128},
    {"\xF3\x92\xAC\x80", "\xCF\x32\xF1\x30", 128},
    {"\xF3\x92\xAE\x80", "\xCF\x32\xFD\x38", 128},
    {"\xF3\x92\xB0\x80", "\xCF\x33\x8C\x36", 128},
    {"\xF3\x92\xB2\x80", "\xCF\x33\x99\x34", 128},
    {"\xF3\x92\xB4\x80", "\xCF\x33\xA6\x32", 128},
    {"\xF3\x92\xB6\x80", "\xCF\x33\xB3\x30", 128},
    {"\xF3\x92\xB8\x80", "\xCF\x33\xBF\x38", 128},
    {"\xF3\x92\xBA\x80", "\xCF\x33\xCC\x36", 128},
    {"\xF3\x92\xBC\x80", "\xCF\x33\xD9\x34", 128},
    {"\xF3\x92\xBE\x80", "\xCF\x33\xE6\x32", 128},
    {"\xF3\x93\x80\x80", "\xCF\x33\xF3\x30", 128},
    {"\xF3\x93\x82\x80", "\xCF\x34\x81\x38", 128},
    {"\xF3\x93\x84\x80", "\xCF\x34\x8E\x36", 128},
    {"\xF3\x93\x86\x80", "\xCF\x34\x9B\x34", 128},
    {"\xF3\x93\x88\x80", "\xCF\x34\xA8\x32", 128},
    {"\xF3\x93\x8A\x80", "\xCF\x34\xB5\x30", 128},
    {"\xF3\x93\x8C\x80", "\xCF\x34\xC1\x38", 128},
    {"\xF3\x93\x8E\x80", "\xCF\x34\xCE\x36", 128},
    {"\xF3\x93\x90\x80", "\xCF\x34\xDB\x34", 128},
    {"\xF3\x93\x92\x80", "\xCF\x34\xE8\x32", 128},
    {"\xF3\x93\x94\x80", "\xCF\x34\xF5\x30", 128},
    {"\xF3\x93\x96\x80", "\xCF\x35\x83\x38", 128},
    {"\xF3\x93\x98\x80", "\xCF\x35\x90\x36", 128},
    {"\xF3\x93\x9A\x80", "\xCF\x35\x9D\x34", 128},
    {"\xF3\x93\x9C\x80", "\xCF\x35\xAA\x32", 128},
    {"\xF3\x93\x9E\x80", "\xCF\x35\xB7\x30", 128},
    {"\xF3\x93\xA0\x80", "\xCF\x35\xC3\x38", 128},
    {"\xF3\x93\xA2\x80", "\xCF\x35\xD0\x36", 128},
    {"\xF3\x93\xA4\x80", "\xCF\x35\xDD\x34", 128},
    {"\xF3\x93\xA6\x80", "\xCF\x35\xEA\x32", 128},
    {"\xF3\x93\xA8\x80", "\xCF\x35\xF7\x30", 128},
    {"\xF3\x93\xAA\x80", "\xCF\x36\x85\x38", 128},
    {"\xF3\x93\xAC\x80", "\xCF\x36\x92\x36", 128},
    {"\xF3\x93\xAE\x80", "\xCF\x36\x9F\x34", 128},
    {"\xF3\x93\xB0\x80", "\xCF\x36\xAC\x32", 128},
    {"\xF3\x93\xB2\x80", "\xCF\x36\xB9\x30", 128},
    {"\xF3\x93\xB4\x80", "\xCF\x36\xC5\x38", 128},
    {"\xF3\x93\xB6\x80", "\xCF\x36\xD2\x36", 128},
    {"\xF3\x93\xB8\x80", "\xCF\x36\xDF\x34", 128},
    {"\xF3\x93\xBA\x80", "\xCF\x36\xEC\x32", 128},
    {"\xF3\x93\xBC\x80", "\xCF\x36\xF9\x30", 128},
    {"\xF3\x93\xBE\x80", "\xCF\x37\x87\x38", 128},
    {"\xF3\x94\x80\x80", "\xCF\x37\x94\x36", 128},
    {"\xF3\x94\x82\x80", "\xCF\x37\xA1\x34", 128},
    {"\xF3\x94\x84\x80", "\xCF\x37\xAE\x32", 128},
    {"\xF3\x94\x86\x80", "\xCF\x37\xBB\x30", 128},
    {"\xF3\x94\x88\x80", "\xCF\x37\xC7\x38", 128},
    {"\xF3\x94\x8A\x80", "\xCF\x37\xD4\x36", 128},
    {"\xF3\x94\x8C\x80", "\xCF\x37\xE1\x34", 128},
    {"\xF3\x94\x8E\x80", "\xCF\x37\xEE\x32", 128},
    {"\xF3\x94\x90\x80", "\xCF\x37\xFB\x30", 128},
    {"\xF3\x94\x92\x80", "\xCF\x38\x89\x38", 128},
    {"\xF3\x94\x94\x80", "\xCF\x38\x96\x36", 128},
    {"\xF3\x94\x96\x80", "\xCF\x38\xA3\x34", 128},
    {"\xF3\x94\x98\x80", "\xCF\x38\xB0\x32", 128},
    {"\xF3\x94\x9A\x80", "\xCF\x38\xBD\x30", 128},
    {"\xF3\x94\x9C\x80", "\xCF\x38\xC9\x38", 128},
    {"\xF3\x94\x9E\x80", "\xCF\x38\xD6\x36", 128},
    {"\xF3\x94\xA0\x80", "\xCF\x38\xE3\x34", 128},
    {"\xF3\x94\xA2\x80", "\xCF\x38\xF0\x32", 128},
    {"\xF3\x94\xA4\x80", "\xCF\x38\xFD\x30", 128},
    {"\xF3\x94\xA6\x80", "\xCF\x39\x8B\x38", 128},
    {"\xF3\x94\xA8\x80", "\xCF\x39\x98\x36", 128},
    {"\xF3\x94\xAA\x80", "\xCF\x39\xA5\x34", 128},
    {"\xF3\x94\xAC\x80", "\xCF\x39\xB2\x32", 128},
    {"\xF3\x94\xAE\x80", "\xCF\x39\xBF\x30", 128},
    {"\xF3\x94\xB0\x80", "\xCF\x39\xCB\x38", 128},
    {"\xF3\x94\xB2\x80", "\xCF\x39\xD8\x36", 128},
    {"\xF3\x94\xB4\x80", "\xCF\x39\xE5\x34", 128},
    {"\xF3\x94\xB6\x80", "\xCF\x39\xF2\x32", 128},
    {"\xF3\x94\xB8\x80", "\xD0\x30\x81\x30", 128},
    {"\xF3\x94\xBA\x80", "\xD0\x30\x8D\x38", 128},
    {"\xF3\x94\xBC\x80", "\xD0\x30\x9A\x36", 128},
    {"\xF3\x94\xBE\x80", "\xD0\x30\xA7\x34", 128},
    {"\xF3\x95\x80\x80", "\xD0\x30\xB4\x32", 128},
    {"\xF3\x95\x82\x80", "\xD0\x30\xC1\x30", 128},
    {"\xF3\x95\x84\x80", "\xD0\x30\xCD\x38", 128},
    {"\xF3\x95\x86\x80", "\xD0\x30\xDA\x36", 128},
    {"\xF3\x95\x88\x80", "\xD0\x30\xE7\x34", 128},
    {"\xF3\x95\x8A\x80", "\xD0\x30\xF4\x32", 128},
    {"\xF3\x95\x8C\x80", "\xD0\x31\x83\x30", 128},
    {"\xF3\x95\x8E\x80", "\xD0\x31\x8F\x38", 128},
    {"\xF3\x95\x90\x80", "\xD0\x31\x9C\x36", 128},
    {"\xF3\x95\x92\x80", "\xD0\x31\xA9\x34", 128},
    {"\xF3\x95\x94\x80", "\xD0\x31\xB6\x32", 128},
    {"\xF3\x95\x96\x80", "\xD0\x31\xC3\x30", 128},
    {"\xF3\x95\x98\x80", "\xD0\x31\xCF\x38", 128},
    {"\xF3\x95\x9A\x80", "\xD0\x31\xDC\x36", 128},
    {"\xF3\x95\x9C\x80", "\xD0\x31\xE9\x34", 128},
    {"\xF3\x95\x9E\x80", "\xD0\x31\xF6\x32", 128},
    {"\xF3\x95\xA0\x80", "\xD0\x32\x85\x30", 128},
    {"\xF3\x95\xA2\x80", "\xD0\x32\x91\x38", 128},
    {"\xF3\x95\xA4\x80", "\xD0\x32\x9E\x36", 128},
    {"\xF3\x95\xA6\x80", "\xD0\x32\xAB\x34", 128},
    {"\xF3\x95\xA8\x80", "\xD0\x32\xB8\x32", 128},
    {"\xF3\x95\xAA\x80", "\xD0\x32\xC5\x30", 128},
    {"\xF3\x95\xAC\x80", "\xD0\x32\xD1\x38", 128},
    {"\xF3\x95\xAE\x80", "\xD0\x32\xDE\x36", 128},
    {"\xF3\x95\xB0\x80", "\xD0\x32\xEB\x34", 128},
    {"\xF3\x95\xB2\x80", "\xD0\x32\xF8\x32", 128},
    {"\xF3\x95\xB4\x80", "\xD0\x33\x87\x30", 128},
    {"\xF3\x95\xB6\x80", "\xD0\x33\x93\x38", 128},
    {"\xF3\x95\xB8\x80", "\xD0\x33\xA0\x36", 128},
    {"\xF3\x95\xBA\x80", "\xD0\x33\xAD\x34", 128},
    {"\xF3\x95\xBC\x80", "\xD0\x33\xBA\x32", 128},
    {"\xF3\x95\xBE\x80", "\xD0\x33\xC7\x30", 128},
    {"\xF3\x96\x80\x80", "\xD0\x33\xD3\x38", 128},
    {"\xF3\x96\x82\x80", "\xD0\x33\xE0\x36", 128},
    {"\xF3\x96\x84\x80", "\xD0\x33\xED\x34", 128},
    {"\xF3\x96\x86\x80", "\xD0\x33\xFA\x32", 128},
    {"\xF3\x96\x88\x80", "\xD0\x34\x89\x30", 128},
    {"\xF3\x96\x8A\x80", "\xD0\x34\x95\x38", 128},
    {"\xF3\x96\x8C\x80", "\xD0\x34\xA2\x36", 128},
    {"\xF3\x96\x8E\x80", "\xD0\x34\xAF\x34", 128},
    {"\xF3\x96\x90\x80", "\xD0\x34\xBC\x32", 128},
    {"\xF3\x96\x92\x80", "\xD0\x34\xC9\x30", 128},
    {"\xF3\x96\x94\x80", "\xD0\x34\xD5\x38", 128},
    {"\xF3\x96\x96\x80", "\xD0\x34\xE2\x36", 128},
    {"\xF3\x96\x98\x80", "\xD0\x34\xEF\x34", 128},
    {"\xF3\x96\x9A\x80", "\xD0\x34\xFC\x32", 128},
    {"\xF3\x96\x9C\x80", "\xD0\x35\x8B\x30", 128},
    {"\xF3\x96\x9E\x80", "\xD0\x35\x97\x38", 128},
    {"\xF3\x96\xA0\x80", "\xD0\x35\xA4\x36", 128},
    {"\xF3\x96\xA2\x80", "\xD0\x35\xB1\x34", 128},
    {"\xF3\x96\xA4\x80", "\xD0\x35\xBE\x32", 128},
    {"\xF3\x96\xA6\x80", "\xD0\x35\xCB\x30", 128},
    {"\xF3\x96\xA8\x80", "\xD0\x35\xD7\x38", 128},
    {"\xF3\x96\xAA\x80", "\xD0\x35\xE4\x36", 128},
    {"\xF3\x96\xAC\x80", "\xD0\x35\xF1\x34", 128},
    {"\xF3\x96\xAE\x80", "\xD0\x35\xFE\x32", 128},
    {"\xF3\x96\xB0\x80", "\xD0\x36\x8D\x30", 128},
    {"\xF3\x96\xB2\x80", "\xD0\x36\x99\x38", 128},
    {"\xF3\x96\xB4\x80", "\xD0\x36\xA6\x36", 128},
    {"\xF3\x96\xB6\x80", "\xD0\x36\xB3\x34", 128},
    {"\xF3\x96\xB8\x80", "\xD0\x36\xC0\x32", 128},
    {"\xF3\x96\xBA\x80", "\xD0\x36\xCD\x30", 128},
    {"\xF3\x96\xBC\x80", "\xD0\x36\xD9\x38", 128},
    {"\xF3\x96\xBE\x80", "\xD0\x36\xE6\x36", 128},
    {"\xF3\x97\x80\x80", "\xD0\x36\xF3\x34", 128},
    {"\xF3\x97\x82\x80", "\xD0\x37\x82\x32", 128},
    {"\xF3\x97\x84\x80", "\xD0\x37\x8F\x30", 128},
    {"\xF3\x97\x86\x80", "\xD0\x37\x9B\x38", 128},
    {"\xF3\x97\x88\x80", "\xD0\x37\xA8\x36", 128},
    {"\xF3\x97\x8A\x80", "\xD0\x37\xB5\x34", 128},
    {"\xF3\x97\x8C\x80", "\xD0\x37\xC2\x32", 128},
    {"\xF3\x97\x8E\x80", "\xD0\x37\xCF\x30", 128},
    {"\xF3\x97\x90\x80", "\xD0\x37\xDB\x38", 128},
    {"\xF3\x97\x92\x80", "\xD0\x37\xE8\x36", 128},
    {"\xF3\x97\x94\x80", "\xD0\x37\xF5\x34", 128},
    {"\xF3\x97\x96\x80", "\xD0\x38\x84\x32", 128},
    {"\xF3\x97\x98\x80", "\xD0\x38\x91\x30", 128},
    {"\xF3\x97\x9A\x80", "\xD0\x38\x9D\x38", 128},
    {"\xF3\x97\x9C\x80", "\xD0\x38\xAA\x36", 128},
    {"\xF3\x97\x9E\x80", "\xD0\x38\xB7\x34", 128},
    {"\xF3\x97\xA0\x80", "\xD0\x38\xC4\x32", 128},
    {"\xF3\x97\xA2\x80", "\xD0\x38\xD1\x30", 128},
    {"\xF3\x97\xA4\x80", "\xD0\x38\xDD\x38", 128},
    {"\xF3\x97\xA6\x80", "\xD0\x38\xEA\x36", 128},
    {"\xF3\x97\xA8\x80", "\xD0\x38\xF7\x34", 128},
    {"\xF3\x97\xAA\x80", "\xD0\x39\x86\x32", 128},
    {"\xF3\x97\xAC\x80", "\xD0\x39\x93\x30", 128},
    {"\xF3\x97\xAE\x80", "\xD0\x39\x9F\x38", 128},
    {"\xF3\x97\xB0\x80", "\xD0\x39\xAC\x36", 128},
    {"\xF3\x97\xB2\x80", "\xD0\x39\xB9\x34", 128},
    {"\xF3\x97\xB4\x80", "\xD0\x39\xC6\x32", 128},
    {"\xF3\x97\xB6\x80", "\xD0\x39\xD3\x30", 128},
    {"\xF3\x97\xB8\x80", "\xD0\x39\xDF\x38", 128},
    {"\xF3\x97\xBA\x80", "\xD0\x39\xEC\x36", 128},
    {"\xF3\x97\xBC\x80", "\xD0\x39\xF9\x34", 128},
    {"\xF3\x97\xBE\x80", "\xD1\x30\x88\x32", 128},
    {"\xF3\x98\x80\x80", "\xD1\x30\x95\x30", 128},
    {"\xF3\x98\x82\x80", "\xD1\x30\xA1\x38", 128},
    {"\xF3\x98\x84\x80", "\xD1\x30\xAE\x36", 128},
    {"\xF3\x98\x86\x80", "\xD1\x30\xBB\x34", 128},
    {"\xF3\x98\x88\x80", "\xD1\x30\xC8\x32", 128},
    {"\xF3\x98\x8A\x80", "\xD1\x30\xD5\x30", 128},
    {"\xF3\x98\x8C\x80", "\xD1\x30\xE1\x38", 128},
    {"\xF3\x98\x8E\x80", "\xD1\x30\xEE\x36", 128},
    {"\xF3\x98\x90\x80", "\xD1\x30\xFB\x34", 128},
    {"\xF3\x98\x92\x80", "\xD1\x31\x8A\x32", 128},
    {"\xF3\x98\x94\x80", "\xD1\x31\x97\x30", 128},
    {"\xF3\x98\x96\x80", "\xD1\x31\xA3\x38", 128},
    {"\xF3\x98\x98\x80", "\xD1\x31\xB0\x36", 128},
    {"\xF3\x98\x9A\x80", "\xD1\x31\xBD\x34", 128},
    {"\xF3\x98\x9C\x80", "\xD1\x31\xCA\x32", 128},
    {"\xF3\x98\x9E\x80", "\xD1\x31\xD7\x30", 128},
    {"\xF3\x98\xA0\x80", "\xD1\x31\xE3\x38", 128},
    {"\xF3\x98\xA2\x80", "\xD1\x31\xF0\x36", 128},
    {"\xF3\x98\xA4\x80", "\xD1\x31\xFD\x34", 128},
    {"\xF3\x98\xA6\x80", "\xD1\x32\x8C\x32", 128},
    {"\xF3\x98\xA8\x80", "\xD1\x32\x99\x30", 128},
    {"\xF3\x98\xAA\x80", "\xD1\x32\xA5\x38", 128},
    {"\xF3\x98\xAC\x80", "\xD1\x32\xB2\x36", 128},
    {"\xF3\x98\xAE\x80", "\xD1\x32\xBF\x34", 128},
    {"\xF3\x98\xB0\x80", "\xD1\x32\xCC\x32", 128},
    {"\xF3\x98\xB2\x80", "\xD1\x32\xD9\x30", 128},
    {"\xF3\x98\xB4\x80", "\xD1\x32\xE5\x38", 128},
    {"\xF3\x98\xB6\x80", "\xD1\x32\xF2\x36", 128},
    {"\xF3\x98\xB8\x80", "\xD1\x33\x81\x34", 128},
    {"\xF3\x98\xBA\x80", "\xD1\x33\x8E\x32", 128},
    {"\xF3\x98\xBC\x80", "\xD1\x33\x9B\x30", 128},
    {"\xF3\x98\xBE\x80", "\xD1\x33\xA7\x38", 128},
    {"\xF3\x99\x80\x80", "\xD1\x33\xB4\x36", 128},
    {"\xF3\x99\x82\x80", "\xD1\x33\xC1\x34", 128},
    {"\xF3\x99\x84\x80", "\xD1\x33\xCE\x32", 128},
    {"\xF3\x99\x86\x80", "\xD1\x33\xDB\x30", 128},
    {"\xF3\x99\x88\x80", "\xD1\x33\xE7\x38", 128},
    {"\xF3\x99\x8A\x80", "\xD1\x33\xF4\x36", 128},
    {"\xF3\x99\x8C\x80", "\xD1\x34\x83\x34", 128},
    {"\xF3\x99\x8E\x80", "\xD1\x34\x90\x32", 128},
    {"\xF3\x99\x90\x80", "\xD1\x34\x9D\x30", 128},
    {"\xF3\x99\x92\x80", "\xD1\x34\xA9\x38", 128},
    {"\xF3\x99\x94\x80", "\xD1\x34\xB6\x36", 128},
    {"\xF3\x99\x96\x80", "\xD1\x34\xC3\x34", 128},
    {"\xF3\x99\x98\x80", "\xD1\x34\xD0\x32", 128},
    {"\xF3\x99\x9A\x80", "\xD1\x34\xDD\x30", 128},
    {"\xF3\x99\x9C\x80", "\xD1\x34\xE9\x38", 128},
    {"\xF3\x99\x9E\x80", "\xD1\x34\xF6\x36", 128},
    {"\xF3\x99\xA0\x80", "\xD1\x35\x85\x34", 128},
    {"\xF3\x99\xA2\x80", "\xD1\x35\x92\x32", 128},
    {"\xF3\x99\xA4\x80", "\xD1\x35\x9F\x30", 128},
    {"\xF3\x99\xA6\x80", "\xD1\x35\xAB\x38", 128},
    {"\xF3\x99\xA8\x80", "\xD1\x35\xB8\x36", 128},
    {"\xF3\x99\xAA\x80", "\xD1\x35\xC5\x34", 128},
    {"\xF3\x99\xAC\x80", "\xD1\x35\xD2\x32", 128},
    {"\xF3\x99\xAE\x80", "\xD1\x35\xDF\x30", 128},
    {"\xF3\x99\xB0\x80", "\xD1\x35\xEB\x38", 128},
    {"\xF3\x99\xB2\x80", "\xD1\x35\xF8\x36", 128},
    {"\xF3\x99\xB4\x80", "\xD1\x36\x87\x34", 128},
    {"\xF3\x99\xB6\x80", "\xD1\x36\x94\x32", 128},
    {"\xF3\x99\xB8\x80", "\xD1\x36\xA1\x30", 128},
    {"\xF3\x99\xBA\x80", "\xD1\x36\xAD\x38", 128},
    {"\xF3\x99\xBC\x80", "\xD1\x36\xBA\x36", 128},
    {"\xF3\x99\xBE\x80", "\xD1\x36\xC7\x34", 128},
    {"\xF3\x9A\x80\x80", "\xD1\x36\xD4\x32", 128},
    {"\xF3\x9A\x82\x80", "\xD1\x36\xE1\x30", 128},
    {"\xF3\x9A\x84\x80", "\xD1\x36\xED\x38", 128},
    {"\xF3\x9A\x86\x80", "\xD1\x36\xFA\x36", 128},
    {"\xF3\x9A\x88\x80", "\xD1\x37\x89\x34", 128},
    {"\xF3\x9A\x8A\x80", "\xD1\x37\x96\x32", 128},
    {"\xF3\x9A\x8C\x80", "\xD1\x37\xA3\x30", 128},
    {"\xF3\x9A\x8E\x80", "\xD1\x37\xAF\x38", 128},
    {"\xF3\x9A\x90\x80", "\xD1\x37\xBC\x36", 128},
    {"\xF3\x9A\x92\x80", "\xD1\x37\xC9\x34", 128},
    {"\xF3\x9A\x94\x80", "\xD1\x37\xD6\x32", 128},
    {"\xF3\x9A\x96\x80", "\xD1\x37\xE3\x30", 128},
    {"\xF3\x9A\x98\x80", "\xD1\x37\xEF\x38", 128},
    {"\xF3\x9A\x9A\x80", "\xD1\x37\xFC\x36", 128},
    {"\xF3\x9A\x9C\x80", "\xD1\x38\x8B\x34", 128},
    {"\xF3\x9A\x9E\x80", "\xD1\x38\x98\x32", 128},
    {"\xF3\x9A\xA0\x80", "\xD1\x38\xA5\x30", 128},
    {"\xF3\x9A\xA2\x80", "\xD1\x38\xB1\x38", 128},
    {"\xF3\x9A\xA4\x80", "\xD1\x38\xBE\x36", 128},
    {"\xF3\x9A\xA6\x80", "\xD1\x38\xCB\x34", 128},
    {"\xF3\x9A\xA8\x80", "\xD1\x38\xD8\x32", 128},
    {"\xF3\x9A\xAA\x80", "\xD1\x38\xE5\x30", 128},
    {"\xF3\x9A\xAC\x80", "\xD1\x38\xF1\x38", 128},
    {"\xF3\x9A\xAE\x80", "\xD1\x38\xFE\x36", 128},
    {"\xF3\x9A\xB0\x80", "\xD1\x39\x8D\x34", 128},
    {"\xF3\x9A\xB2\x80", "\xD1\x39\x9A\x32", 128},
    {"\xF3\x9A\xB4\x80", "\xD1\x39\xA7\x30", 128},
    {"\xF3\x9A\xB6\x80", "\xD1\x39\xB3\x38", 128},
    {"\xF3\x9A\xB8\x80", "\xD1\x39\xC0\x36", 128},
    {"\xF3\x9A\xBA\x80", "\xD1\x39\xCD\x34", 128},
    {"\xF3\x9A\xBC\x80", "\xD1\x39\xDA\x32", 128},
    {"\xF3\x9A\xBE\x80", "\xD1\x39\xE7\x30", 128},
    {"\xF3\x9B\x80\x80", "\xD1\x39\xF3\x38", 128},
    {"\xF3\x9B\x82\x80", "\xD2\x30\x82\x36", 128},
    {"\xF3\x9B\x84\x80", "\xD2\x30\x8F\x34", 128},
    {"\xF3\x9B\x86\x80", "\xD2\x30\x9C\x32", 128},
    {"\xF3\x9B\x88\x80", "\xD2\x30\xA9\x30", 128},
    {"\xF3\x9B\x8A\x80", "\xD2\x30\xB5\x38", 128},
    {"\xF3\x9B\x8C\x80", "\xD2\x30\xC2\x36", 128},
    {"\xF3\x9B\x8E\x80", "\xD2\x30\xCF\x34", 128},
    {"\xF3\x9B\x90\x80", "\xD2\x30\xDC\x32", 128},
    {"\xF3\x9B\x92\x80", "\xD2\x30\xE9\x30", 128},
    {"\xF3\x9B\x94\x80", "\xD2\x30\xF5\x38", 128},
    {"\xF3\x9B\x96\x80", "\xD2\x31\x84\x36", 128},
    {"\xF3\x9B\x98\x80", "\xD2\x31\x91\x34", 128},
    {"\xF3\x9B\x9A\x80", "\xD2\x31\x9E\x32", 128},
    {"\xF3\x9B\x9C\x80", "\xD2\x31\xAB\x30", 128},
    {"\xF3\x9B\x9E\x80", "\xD2\x31\xB7\x38", 128},
    {"\xF3\x9B\xA0\x80", "\xD2\x31\xC4\x36", 128},
    {"\xF3\x9B\xA2\x80", "\xD2\x31\xD1\x34", 128},
    {"\xF3\x9B\xA4\x80", "\xD2\x31\xDE\x32", 128},
    {"\xF3\x9B\xA6\x80", "\xD2\x31\xEB\x30", 128},
    {"\xF3\x9B\xA8\x80", "\xD2\x31\xF7\x38", 128},
    {"\xF3\x9B\xAA\x80", "\xD2\x32\x86\x36", 128},
    {"\xF3\x9B\xAC\x80", "\xD2\x32\x93\x34", 128},
    {"\xF3\x9B\xAE\x80", "\xD2\x32\xA0\x32", 128},
    {"\xF3\x9B\xB0\x80", "\xD2\x32\xAD\x30", 128},
    {"\xF3\x9B\xB2\x80", "\xD2\x32\xB9\x38", 128},
    {"\xF3\x9B\xB4\x80", "\xD2\x32\xC6\x36", 128},
    {"\xF3\x9B\xB6\x80", "\xD2\x32\xD3\x34", 128},
    {"\xF3\x9B\xB8\x80", "\xD2\x32\xE0\x32", 128},
    {"\xF3\x9B\xBA\x80", "\xD2\x32\xED\x30", 128},
    {"\xF3\x9B\xBC\x80", "\xD2\x32\xF9\x38", 128},
    {"\xF3\x9B\xBE\x80", "\xD2\x33\x88\x36", 128},
    {"\xF3\x9C\x80\x80", "\xD2\x33\x95\x34", 128},
    {"\xF3\x9C\x82\x80", "\xD2\x33\xA2\x32", 128},
    {"\xF3\x9C\x84\x80", "\xD2\x33\xAF\x30", 128},
    {"\xF3\x9C\x86\x80", "\xD2\x33\xBB\x38", 128},
    {"\xF3\x9C\x88\x80", "\xD2\x33\xC8\x36", 128},
    {"\xF3\x9C\x8A\x80", "\xD2\x33\xD5\x34", 128},
    {"\xF3\x9C\x8C\x80", "\xD2\x33\xE2\x32", 128},
    {"\xF3\x9C\x8E\x80", "\xD2\x33\xEF\x30", 128},
    {"\xF3\x9C\x90\x80", "\xD2\x33\xFB\x38", 128},
    {"\xF3\x9C\x92\x80", "\xD2\x34\x8A\x36", 128},
    {"\xF3\x9C\x94\x80", "\xD2\x34\x97\x34", 128},
    {"\xF3\x9C\x96\x80", "\xD2\x34\xA4\x32", 128},
    {"\xF3\x9C\x98\x80", "\xD2\x34\xB1\x30", 128},
    {"\xF3\x9C\x9A\x80", "\xD2\x34\xBD\x38", 128},
    {"\xF3\x9C\x9C\x80", "\xD2\x34\xCA\x36", 128},
    {"\xF3\x9C\x9E\x80", "\xD2\x34\xD7\x34", 128},
    {"\xF3\x9C\xA0\x80", "\xD2\x34\xE4\x32", 128},
    {"\xF3\x9C\xA2\x80", "\xD2\x34\xF1\x30", 128},
    {"\xF3\x9C\xA4\x80", "\xD2\x34\xFD\x38", 128},
    {"\xF3\x9C\xA6\x80", "\xD2\x35\x8C\x36", 128},
    {"\xF3\x9C\xA8\x80", "\xD2\x35\x99\x34", 128},
    {"\xF3\x9C\xAA\x80", "\xD2\x35\xA6\x32", 128},
    {"\xF3\x9C\xAC\x80", "\xD2\x35\xB3\x30", 128},
    {"\xF3\x9C\xAE\x80", "\xD2\x35\xBF\x38", 128},
    {"\xF3\x9C\xB0\x80", "\xD2\x35\xCC\x36", 128},
    {"\xF3\x9C\xB2\x80", "\xD2\x35\xD9\x34", 128},
    {"\xF3\x9C\xB4\x80", "\xD2\x35\xE6\x32", 128},
    {"\xF3\x9C\xB6\x80", "\xD2\x35\xF3\x30", 128},
    {"\xF3\x9C\xB8\x80", "\xD2\x36\x81\x38", 128},
    {"\xF3\x9C\xBA\x80", "\xD2\x36\x8E\x36", 128},
    {"\xF3\x9C\xBC\x80", "\xD2\x36\x9B\x34", 128},
    {"\xF3\x9C\xBE\x80", "\xD2\x36\xA8\x32", 128},
    {"\xF3\x9D\x80\x80", "\xD2\x36\xB5\x30", 128},
    {"\xF3\x9D\x82\x80", "\xD2\x36\xC1\x38", 128},
    {"\xF3\x9D\x84\x80", "\xD2\x36\xCE\x36", 128},
    {"\xF3\x9D\x86\x80", "\xD2\x36\xDB\x34", 128},
    {"\xF3\x9D\x88\x80", "\xD2\x36\xE8\x32", 128},
    {"\xF3\x9D\x8A\x80", "\xD2\x36\xF5\x30", 128},
    {"\xF3\x9D\x8C\x80", "\xD2\x37\x83\x38", 128},
    {"\xF3\x9D\x8E\x80", "\xD2\x37\x90\x36", 128},
    {"\xF3\x9D\x90\x80", "\xD2\x37\x9D\x34", 128},
    {"\xF3\x9D\x92\x80", "\xD2\x37\xAA\x32", 128},
    {"\xF3\x9D\x94\x80", "\xD2\x37\xB7\x30", 128},
    {"\xF3\x9D\x96\x80", "\xD2\x37\xC3\x38", 128},
    {"\xF3\x9D\x98\x80", "\xD2\x37\xD0\x36", 128},
    {"\xF3\x9D\x9A\x80", "\xD2\x37\xDD\x34", 128},
    {"\xF3\x9D\x9C\x80", "\xD2\x37\xEA\x32", 128},
    {"\xF3\x9D\x9E\x80", "\xD2\x37\xF7\x30", 128},
    {"\xF3\x9D\xA0\x80", "\xD2\x38\x85\x38", 128},
    {"\xF3\x9D\xA2\x80", "\xD2\x38\x92\x36", 128},
    {"\xF3\x9D\xA4\x80", "\xD2\x38\x9F\x34", 128},
    {"\xF3\x9D\xA6\x80", "\xD2\x38\xAC\x32", 128},
    {"\xF3\x9D\xA8\x80", "\xD2\x38\xB9\x30", 128},
    {"\xF3\x9D\xAA\x80", "\xD2\x38\xC5\x38", 128},
    {"\xF3\x9D\xAC\x80", "\xD2\x38\xD2\x36", 128},
    {"\xF3\x9D\xAE\x80", "\xD2\x38\xDF\x34", 128},
    {"\xF3\x9D\xB0\x80", "\xD2\x38\xEC\x32", 128},
    {"\xF3\x9D\xB2\x80", "\xD2\x38\xF9\x30", 128},
    {"\xF3\x9D\xB4\x80", "\xD2\x39\x87\x38", 128},
    {"\xF3\x9D\xB6\x80", "\xD2\x39\x94\x36", 128},
    {"\xF3\x9D\xB8\x80", "\xD2\x39\xA1\x34", 128},
    {"\xF3\x9D\xBA\x80", "\xD2\x39\xAE\x32", 128},
    {"\xF3\x9D\xBC\x80", "\xD2\x39\xBB\x30", 128},
    {"\xF3\x9D\xBE\x80", "\xD2\x39\xC7\x38", 128},
    {"\xF3\x9E\x80\x80", "\xD2\x39\xD4\x36", 128},
    {"\xF3\x9E\x82\x80", "\xD2\x39\xE1\x34", 128},
    {"\xF3\x9E\x84\x80", "\xD2\x39\xEE\x32", 128},
    {"\xF3\x9E\x86\x80", "\xD2\x39\xFB\x30", 128},
    {"\xF3\x9E\x88\x80", "\xD3\x30\x89\x38", 128},
    {"\xF3\x9E\x8A\x80", "\xD3\x30\x96\x36", 128},
    {"\xF3\x9E\x8C\x80", "\xD3\x30\xA3\x34", 128},
    {"\xF3\x9E\x8E\x80", "\xD3\x30\xB0\x32", 128},
    {"\xF3\x9E\x90\x80", "\xD3\x30\xBD\x30", 128},
    {"\xF3\x9E\x92\x80", "\xD3\x30\xC9\x38", 128},
    {"\xF3\x9E\x94\x80", "\xD3\x30\xD6\x36", 128},
    {"\xF3\x9E\x96\x80", "\xD3\x30\xE3\x34", 128},
    {"\xF3\x9E\x98\x80", "\xD3\x30\xF0\x32", 128},
    {"\xF3\x9E\x9A\x80", "\xD3\x30\xFD\x30", 128},
    {"\xF3\x9E\x9C\x80", "\xD3\x31\x8B\x38", 128},
    {"\xF3\x9E\x9E\x80", "\xD3\x31\x98\x36", 128},
    {"\xF3\x9E\xA0\x80", "\xD3\x31\xA5\x34", 128},
    {"\xF3\x9E\xA2\x80", "\xD3\x31\xB2\x32", 128},
    {"\xF3\x9E\xA4\x80", "\xD3\x31\xBF\x30", 128},
    {"\xF3\x9E\xA6\x80", "\xD3\x31\xCB\x38", 128},
    {"\xF3\x9E\xA8\x80", "\xD3\x31\xD8\x36", 128},
    {"\xF3\x9E\xAA\x80", "\xD3\x31\xE5\x34", 128},
    {"\xF3\x9E\xAC\x80", "\xD3\x31\xF2\x32", 128},
    {"\xF3\x9E\xAE\x80", "\xD3\x32\x81\x30", 128},
    {"\xF3\x9E\xB0\x80", "\xD3\x32\x8D\x38", 128},
    {"\xF3\x9E\xB2\x80", "\xD3\x32\x9A\x36", 128},
    {"\xF3\x9E\xB4\x80", "\xD3\x32\xA7\x34", 128},
    {"\xF3\x9E\xB6\x80", "\xD3\x32\xB4\x32", 128},
    {"\xF3\x9E\xB8\x80", "\xD3\x32\xC1\x30", 128},
    {"\xF3\x9E\xBA\x80", "\xD3\x32\xCD\x38", 128},
    {"\xF3\x9E\xBC\x80", "\xD3\x32\xDA\x36", 128},
    {"\xF3\x9E\xBE\x80", "\xD3\x32\xE7\x34", 128},
    {"\xF3\x9F\x80\x80", "\xD3\x32\xF4\x32", 128},
    {"\xF3\x9F\x82\x80", "\xD3\x33\x83\x30", 128},
    {"\xF3\x9F\x84\x80", "\xD3\x33\x8F\x38", 128},
    {"\xF3\x9F\x86\x80", "\xD3\x33\x9C\x36", 128},
    {"\xF3\x9F\x88\x80", "\xD3\x33\xA9\x34", 128},
    {"\xF3\x9F\x8A\x80", "\xD3\x33\xB6\x32", 128},
    {"\xF3\x9F\x8C\x80", "\xD3\x33\xC3\x30", 128},
    {"\xF3\x9F\x8E\x80", "\xD3\x33\xCF\x38", 128},
    {"\xF3\x9F\x90\x80", "\xD3\x33\xDC\x36", 128},
    {"\xF3\x9F\x92\x80", "\xD3\x33\xE9\x34", 128},
    {"\xF3\x9F\x94\x80", "\xD3\x33\xF6\x32", 128},
    {"\xF3\x9F\x96\x80", "\xD3\x34\x85\x30", 128},
    {"\xF3\x9F\x98\x80", "\xD3\x34\x91\x38", 128},
    {"\xF3\x9F\x9A\x80", "\xD3\x34\x9E\x36", 128},
    {"\xF3\x9F\x9C\x80", "\xD3\x34\xAB\x34", 128},
    {"\xF3\x9F\x9E\x80", "\xD3\x34\xB8\x32", 128},
    {"\xF3\x9F\xA0\x80", "\xD3\x34\xC5\x30", 128},
    {"\xF3\x9F\xA2\x80", "\xD3\x34\xD1\x38", 128},
    {"\xF3\x9F\xA4\x80", "\xD3\x34\xDE\x36", 128},
    {"\xF3\x9F\xA6\x80", "\xD3\x34\xEB\x34", 128},
    {"\xF3\x9F\xA8\x80", "\xD3\x34\xF8\x32", 128},
    {"\xF3\x9F\xAA\x80", "\xD3\x35\x87\x30", 128},
    {"\xF3\x9F\xAC\x80", "\xD3\x35\x93\x38", 128},
    {"\xF3\x9F\xAE\x80", "\xD3\x35\xA0\x36", 128},
    {"\xF3\x9F\xB0\x80", "\xD3\x35\xAD\x34", 128},
    {"\xF3\x9F\xB2\x80", "\xD3\x35\xBA\x32", 128},
    {"\xF3\x9F\xB4\x80", "\xD3\x35\xC7\x30", 128},
    {"\xF3\x9F\xB6\x80", "\xD3\x35\xD3\x38", 128},
    {"\xF3\x9F\xB8\x80", "\xD3\x35\xE0\x36", 128},
    {"\xF3\x9F\xBA\x80", "\xD3\x35\xED\x34", 128},
    {"\xF3\x9F\xBC\x80", "\xD3\x35\xFA\x32", 128},
    {"\xF3\x9F\xBE\x80", "\xD3\x36\x89\x30", 128},
    {"\xF3\xA0\x80\x80", "\xD3\x36\x95\x38", 128},
    {"\xF3\xA0\x82\x80", "\xD3\x36\xA2\x36", 128},
    {"\xF3\xA0\x84\x80", "\xD3\x36\xAF\x34", 128},
    {"\xF3\xA0\x86\x80", "\xD3\x36\xBC\x32", 128},
    {"\xF3\xA0\x88\x80", "\xD3\x36\xC9\x30", 128},
    {"\xF3\xA0\x8A\x80", "\xD3\x36\xD5\x38", 128},
    {"\xF3\xA0\x8C\x80", "\xD3\x36\xE2\x36", 128},
    {"\xF3\xA0\x8E\x80", "\xD3\x36\xEF\x34", 128},
    {"\xF3\xA0\x90\x80", "\xD3\x36\xFC\x32", 128},
    {"\xF3\xA0\x92\x80", "\xD3\x37\x8B\x30", 128},
    {"\xF3\xA0\x94\x80", "\xD3\x37\x97\x38", 128},
    {"\xF3\xA0\x96\x80", "\xD3\x37\xA4\x36", 128},
    {"\xF3\xA0\x98\x80", "\xD3\x37\xB1\x34", 128},
    {"\xF3\xA0\x9A\x80", "\xD3\x37\xBE\x32", 128},
    {"\xF3\xA0\x9C\x80", "\xD3\x37\xCB\x30", 128},
    {"\xF3\xA0\x9E\x80", "\xD3\x37\xD7\x38", 128},
    {"\xF3\xA0\xA0\x80", "\xD3\x37\xE4\x36", 128},
    {"\xF3\xA0\xA2\x80", "\xD3\x37\xF1\x34", 128},
    {"\xF3\xA0\xA4\x80", "\xD3\x37\xFE\x32", 128},
    {"\xF3\xA0\xA6\x80", "\xD3\x38\x8D\x30", 128},
    {"\xF3\xA0\xA8\x80", "\xD3\x38\x99\x38", 128},
    {"\xF3\xA0\xAA\x80", "\xD3\x38\xA6\x36", 128},
    {"\xF3\xA0\xAC\x80", "\xD3\x38\xB3\x34", 128},
    {"\xF3\xA0\xAE\x80", "\xD3\x38\xC0\x32", 128},
    {"\xF3\xA0\xB0\x80", "\xD3\x38\xCD\x30", 128},
    {"\xF3\xA0\xB2\x80", "\xD3\x38\xD9\x38", 128},
    {"\xF3\xA0\xB4\x80", "\xD3\x38\xE6\x36", 128},
    {"\xF3\xA0\xB6\x80", "\xD3\x38\xF3\x34", 128},
    {"\xF3\xA0\xB8\x80", "\xD3\x39\x82\x32", 128},
    {"\xF3\xA0\xBA\x80", "\xD3\x39\x8F\x30", 128},
    {"\xF3\xA0\xBC\x80", "\xD3\x39\x9B\x38", 128},
    {"\xF3\xA0\xBE\x80", "\xD3\x39\xA8\x36", 128},
    {"\xF3\xA1\x80\x80", "\xD3\x39\xB5\x34", 128},
    {"\xF3\xA1\x82\x80", "\xD3\x39\xC2\x32", 128},
    {"\xF3\xA1\x84\x80", "\xD3\x39\xCF\x30", 128},
    {"\xF3\xA1\x86\x80", "\xD3\x39\xDB\x38", 128},
    {"\xF3\xA1\x88\x80", "\xD3\x39\xE8\x36", 128},
    {"\xF3\xA1\x8A\x80", "\xD3\x39\xF5\x34", 128},
    {"\xF3\xA1\x8C\x80", "\xD4\x30\x84\x32", 128},
    {"\xF3\xA1\x8E\x80", "\xD4\x30\x91\x30", 128},
    {"\xF3\xA1\x90\x80", "\xD4\x30\x9D\x38", 128},
    {"\xF3\xA1\x92\x80", "\xD4\x30\xAA\x36", 128},
    {"\xF3\xA1\x94\x80", "\xD4\x30\xB7\x34", 128},
    {"\xF3\xA1\x96\x80", "\xD4\x30\xC4\x32", 128},
    {"\xF3\xA1\x98\x80", "\xD4\x30\xD1\x30", 128},
    {"\xF3\xA1\x9A\x80", "\xD4\x30\xDD\x38", 128},
    {"\xF3\xA1\x9C\x80", "\xD4\x30\xEA\x36", 128},
    {"\xF3\xA1\x9E\x80", "\xD4\x30\xF7\x34", 128},
    {"\xF3\xA1\xA0\x80", "\xD4\x31\x86\x32", 128},
    {"\xF3\xA1\xA2\x80", "\xD4\x31\x93\x30", 128},
    {"\xF3\xA1\xA4\x80", "\xD4\x31\x9F\x38", 128},
    {"\xF3\xA1\xA6\x80", "\xD4\x31\xAC\x36", 128},
    {"\xF3\xA1\xA8\x80", "\xD4\x31\xB9\x34", 128},
    {"\xF3\xA1\xAA\x80", "\xD4\x31\xC6\x32", 128},
    {"\xF3\xA1\xAC\x80", "\xD4\x31\xD3\x30", 128},
    {"\xF3\xA1\xAE\x80", "\xD4\x31\xDF\x38", 128},
    {"\xF3\xA1\xB0\x80", "\xD4\x31\xEC\x36", 128},
    {"\xF3\xA1\xB2\x80", "\xD4\x31\xF9\x34", 128},
    {"\xF3\xA1\xB4\x80", "\xD4\x32\x88\x32", 128},
    {"\xF3\xA1\xB6\x80", "\xD4\x32\x95\x30", 128},
    {"\xF3\xA1\xB8\x80", "\xD4\x32\xA1\x38", 128},
    {"\xF3\xA1\xBA\x80", "\xD4\x32\xAE\x36", 128},
    {"\xF3\xA1\xBC\x80", "\xD4\x32\xBB\x34", 128},
    {"\xF3\xA1\xBE\x80", "\xD4\x32\xC8\x32", 128},
    {"\xF3\xA2\x80\x80", "\xD4\x32\xD5\x30", 128},
    {"\xF3\xA2\x82\x80", "\xD4\x32\xE1\x38", 128},
    {"\xF3\xA2\x84\x80", "\xD4\x32\xEE\x36", 128},
    {"\xF3\xA2\x86\x80", "\xD4\x32\xFB\x34", 128},
    {"\xF3\xA2\x88\x80", "\xD4\x33\x8A\x32", 128},
    {"\xF3\xA2\x8A\x80", "\xD4\x33\x97\x30", 128},
    {"\xF3\xA2\x8C\x80", "\xD4\x33\xA3\x38", 128},
    {"\xF3\xA2\x8E\x80", "\xD4\x33\xB0\x36", 128},
    {"\xF3\xA2\x90\x80", "\xD4\x33\xBD\x34", 128},
    {"\xF3\xA2\x92\x80", "\xD4\x33\xCA\x32", 128},
    {"\xF3\xA2\x94\x80", "\xD4\x33\xD7\x30", 128},
    {"\xF3\xA2\x96\x80", "\xD4\x33\xE3\x38", 128},
    {"\xF3\xA2\x98\x80", "\xD4\x33\xF0\x36", 128},
    {"\xF3\xA2\x9A\x80", "\xD4\x33\xFD\x34", 128},
    {"\xF3\xA2\x9C\x80", "\xD4\x34\x8C\x32", 128},
    {"\xF3\xA2\x9E\x80", "\xD4\x34\x99\x30", 128},
    {"\xF3\xA2\xA0\x80", "\xD4\x34\xA5\x38", 128},
    {"\xF3\xA2\xA2\x80", "\xD4\x34\xB2\x36", 128},
    {"\xF3\xA2\xA4\x80", "\xD4\x34\xBF\x34", 128},
    {"\xF3\xA2\xA6\x80", "\xD4\x34\xCC\x32", 128},
    {"\xF3\xA2\xA8\x80", "\xD4\x34\xD9\x30", 128},
    {"\xF3\xA2\xAA\x80", "\xD4\x34\xE5\x38", 128},
    {"\xF3\xA2\xAC\x80", "\xD4\x34\xF2\x36", 128},
    {"\xF3\xA2\xAE\x80", "\xD4\x35\x81\x34", 128},
    {"\xF3\xA2\xB0\x80", "\xD4\x35\x8E\x32", 128},
    {"\xF3\xA2\xB2\x80", "\xD4\x35\x9B\x30", 128},
    {"\xF3\xA2\xB4\x80", "\xD4\x35\xA7\x38", 128},
    {"\xF3\xA2\xB6\x80", "\xD4\x35\xB4\x36", 128},
    {"\xF3\xA2\xB8\x80", "\xD4\x35\xC1\x34", 128},
    {"\xF3\xA2\xBA\x80", "\xD4\x35\xCE\x32", 128},
    {"\xF3\xA2\xBC\x80", "\xD4\x35\xDB\x30", 128},
    {"\xF3\xA2\xBE\x80", "\xD4\x35\xE7\x38", 128},
    {"\xF3\xA3\x80\x80", "\xD4\x35\xF4\x36", 128},
    {"\xF3\xA3\x82\x80", "\xD4\x36\x83\x34", 128},
    {"\xF3\xA3\x84\x80", "\xD4\x36\x90\x32", 128},
    {"\xF3\xA3\x86\x80", "\xD4\x36\x9D\x30", 128},
    {"\xF3\xA3\x88\x80", "\xD4\x36\xA9\x38", 128},
    {"\xF3\xA3\x8A\x80", "\xD4\x36\xB6\x36", 128},
    {"\xF3\xA3\x8C\x80", "\xD4\x36\xC3\x34", 128},
    {"\xF3\xA3\x8E\x80", "\xD4\x36\xD0\x32", 128},
    {"\xF3\xA3\x90\x80", "\xD4\x36\xDD\x30", 128},
    {"\xF3\xA3\x92\x80", "\xD4\x36\xE9\x38", 128},
    {"\xF3\xA3\x94\x80", "\xD4\x36\xF6\x36", 128},
    {"\xF3\xA3\x96\x80", "\xD4\x37\x85\x34", 128},
    {"\xF3\xA3\x98\x80", "\xD4\x37\x92\x32", 128},
    {"\xF3\xA3\x9A\x80", "\xD4\x37\x9F\x30", 128},
    {"\xF3\xA3\x9C\x80", "\xD4\x37\xAB\x38", 128},
    {"\xF3\xA3\x9E\x80", "\xD4\x37\xB8\x36", 128},
    {"\xF3\xA3\xA0\x80", "\xD4\x37\xC5\x34", 128},
    {"\xF3\xA3\xA2\x80", "\xD4\x37\xD2\x32", 128},
    {"\xF3\xA3\xA4\x80", "\xD4\x37\xDF\x30", 128},
    {"\xF3\xA3\xA6\x80", "\xD4\x37\xEB\x38", 128},
    {"\xF3\xA3\xA8\x80", "\xD4\x37\xF8\x36", 128},
    {"\xF3\xA3\xAA\x80", "\xD4\x38\x87\x34", 128},
    {"\xF3\xA3\xAC\x80", "\xD4\x38\x94\x32", 128},
    {"\xF3\xA3\xAE\x80", "\xD4\x38\xA1\x30", 128},
    {"\xF3\xA3\xB0\x80", "\xD4\x38\xAD\x38", 128},
    {"\xF3\xA3\xB2\x80", "\xD4\x38\xBA\x36", 128},
    {"\xF3\xA3\xB4\x80", "\xD4\x38\xC7\x34", 128},
    {"\xF3\xA3\xB6\x80", "\xD4\x38\xD4\x32", 128},
    {"\xF3\xA3\xB8\x80", "\xD4\x38\xE1\x30", 128},
    {"\xF3\xA3\xBA\x80", "\xD4\x38\xED\x38", 128},
    {"\xF3\xA3\xBC\x80", "\xD4\x38\xFA\x36", 128},
    {"\xF3\xA3\xBE\x80", "\xD4\x39\x89\x34", 128},
    {"\xF3\xA4\x80\x80", "\xD4\x39\x96\x32", 128},
    {"\xF3\xA4\x82\x80", "\xD4\x39\xA3\x30", 128},
    {"\xF3\xA4\x84\x80", "\xD4\x39\xAF\x38", 128},
    {"\xF3\xA4\x86\x80", "\xD4\x39\xBC\x36", 128},
    {"\xF3\xA4\x88\x80", "\xD4\x39\xC9\x34", 128},
    {"\xF3\xA4\x8A\x80", "\xD4\x39\xD6\x32", 128},
    {"\xF3\xA4\x8C\x80", "\xD4\x39\xE3\x30", 128},
    {"\xF3\xA4\x8E\x80", "\xD4\x39\xEF\x38", 128},
    {"\xF3\xA4\x90\x80", "\xD4\x39\xFC\x36", 128},
    {"\xF3\xA4\x92\x80", "\xD5\x30\x8B\x34", 128},
    {"\xF3\xA4\x94\x80", "\xD5\x30\x98\x32", 128},
    {"\xF3\xA4\x96\x80", "\xD5\x30\xA5\x30", 128},
    {"\xF3\xA4\x98\x80", "\xD5\x30\xB1\x38", 128},
    {"\xF3\xA4\x9A\x80", "\xD5\x30\xBE\x36", 128},
    {"\xF3\xA4\x9C\x80", "\xD5\x30\xCB\x34", 128},
    {"\xF3\xA4\x9E\x80", "\xD5\x30\xD8\x32", 128},
    {"\xF3\xA4\xA0\x80", "\xD5\x30\xE5\x30", 128},
    {"\xF3\xA4\xA2\x80", "\xD5\x30\xF1\x38", 128},
    {"\xF3\xA4\xA4\x80", "\xD5\x30\xFE\x36", 128},
    {"\xF3\xA4\xA6\x80", "\xD5\x31\x8D\x34", 128},
    {"\xF3\xA4\xA8\x80", "\xD5\x31\x9A\x32", 128},
    {"\xF3\xA4\xAA\x80", "\xD5\x31\xA7\x30", 128},
    {"\xF3\xA4\xAC\x80", "\xD5\x31\xB3\x38", 128},
    {"\xF3\xA4\xAE\x80", "\xD5\x31\xC0\x36", 128},
    {"\xF3\xA4\xB0\x80", "\xD5\x31\xCD\x34", 128},
    {"\xF3\xA4\xB2\x80", "\xD5\x31\xDA\x32", 128},
    {"\xF3\xA4\xB4\x80", "\xD5\x31\xE7\x30", 128},
    {"\xF3\xA4\xB6\x80", "\xD5\x31\xF3\x38", 128},
    {"\xF3\xA4\xB8\x80", "\xD5\x32\x82\x36", 128},
    {"\xF3\xA4\xBA\x80", "\xD5\x32\x8F\x34", 128},
    {"\xF3\xA4\xBC\x80", "\xD5\x32\x9C\x32", 128},
    {"\xF3\xA4\xBE\x80", "\xD5\x32\xA9\x30", 128},
    {"\xF3\xA5\x80\x80", "\xD5\x32\xB5\x38", 128},
    {"\xF3\xA5\x82\x80", "\xD5\x32\xC2\x36", 128},
    {"\xF3\xA5\x84\x80", "\xD5\x32\xCF\x34", 128},
    {"\xF3\xA5\x86\x80", "\xD5\x32\xDC\x32", 128},
    {"\xF3\xA5\x88\x80", "\xD5\x32\xE9\x30", 128},
    {"\xF3\xA5\x8A\x80", "\xD5\x32\xF5\x38", 128},
    {"\xF3\xA5\x8C\x80", "\xD5\x33\x84\x36", 128},
    {"\xF3\xA5\x8E\x80", "\xD5\x33\x91\x34", 128},
    {"\xF3\xA5\x90\x80", "\xD5\x33\x9E\x32", 128},
    {"\xF3\xA5\x92\x80", "\xD5\x33\xAB\x30", 128},
    {"\xF3\xA5\x94\x80", "\xD5\x33\xB7\x38", 128},
    {"\xF3\xA5\x96\x80", "\xD5\x33\xC4\x36", 128},
    {"\xF3\xA5\x98\x80", "\xD5\x33\xD1\x34", 128},
    {"\xF3\xA5\x9A\x80", "\xD5\x33\xDE\x32", 128},
    {"\xF3\xA5\x9C\x80", "\xD5\x33\xEB\x30", 128},
    {"\xF3\xA5\x9E\x80", "\xD5\x33\xF7\x38", 128},
    {"\xF3\xA5\xA0\x80", "\xD5\x34\x86\x36", 128},
    {"\xF3\xA5\xA2\x80", "\xD5\x34\x93\x34", 128},
    {"\xF3\xA5\xA4\x80", "\xD5\x34\xA0\x32", 128},
    {"\xF3\xA5\xA6\x80", "\xD5\x34\xAD\x30", 128},
    {"\xF3\xA5\xA8\x80", "\xD5\x34\xB9\x38", 128},
    {"\xF3\xA5\xAA\x80", "\xD5\x34\xC6\x36", 128},
    {"\xF3\xA5\xAC\x80", "\xD5\x34\xD3\x34", 128},
    {"\xF3\xA5\xAE\x80", "\xD5\x34\xE0\x32", 128},
    {"\xF3\xA5\xB0\x80", "\xD5\x34\xED\x30", 128},
    {"\xF3\xA5\xB2\x80", "\xD5\x34\xF9\x38", 128},
    {"\xF3\xA5\xB4\x80", "\xD5\x35\x88\x36", 128},
    {"\xF3\xA5\xB6\x80", "\xD5\x35\x95\x34", 128},
    {"\xF3\xA5\xB8\x80", "\xD5\x35\xA2\x32", 128},
    {"\xF3\xA5\xBA\x80", "\xD5\x35\xAF\x30", 128},
    {"\xF3\xA5\xBC\x80", "\xD5\x35\xBB\x38", 128},
    {"\xF3\xA5\xBE\x80", "\xD5\x35\xC8\x36", 128},
    {"\xF3\xA6\x80\x80", "\xD5\x35\xD5\x34", 128},
    {"\xF3\xA6\x82\x80", "\xD5\x35\xE2\x32", 128},
    {"\xF3\xA6\x84\x80", "\xD5\x35\xEF\x30", 128},
    {"\xF3\xA6\x86\x80", "\xD5\x35\xFB\x38", 128},
    {"\xF3\xA6\x88\x80", "\xD5\x36\x8A\x36", 128},
    {"\xF3\xA6\x8A\x80", "\xD5\x36\x97\x34", 128},
    {"\xF3\xA6\x8C\x80", "\xD5\x36\xA4\x32", 128},
    {"\xF3\xA6\x8E\x80", "\xD5\x36\xB1\x30", 128},
    {"\xF3\xA6\x90\x80", "\xD5\x36\xBD\x38", 128},
    {"\xF3\xA6\x92\x80", "\xD5\x36\xCA\x36", 128},
    {"\xF3\xA6\x94\x80", "\xD5\x36\xD7\x34", 128},
    {"\xF3\xA6\x96\x80", "\xD5\x36\xE4\x32", 128},
    {"\xF3\xA6\x98\x80", "\xD5\x36\xF1\x30", 128},
    {"\xF3\xA6\x9A\x80", "\xD5\x36\xFD\x38", 128},
    {"\xF3\xA6\x9C\x80", "\xD5\x37\x8C\x36", 128},
    {"\xF3\xA6\x9E\x80", "\xD5\x37\x99\x34", 128},
    {"\xF3\xA6\xA0\x80", "\xD5\x37\xA6\x32", 128},
    {"\xF3\xA6\xA2\x80", "\xD5\x37\xB3\x30", 128},
    {"\xF3\xA6\xA4\x80", "\xD5\x37\xBF\x38", 128},
    {"\xF3\xA6\xA6\x80", "\xD5\x37\xCC\x36", 128},
    {"\xF3\xA6\xA8\x80", "\xD5\x37\xD9\x34", 128},
    {"\xF3\xA6\xAA\x80", "\xD5\x37\xE6\x32", 128},
    {"\xF3\xA6\xAC\x80", "\xD5\x37\xF3\x30", 128},
    {"\xF3\xA6\xAE\x80", "\xD5\x38\x81\x38", 128},
    {"\xF3\xA6\xB0\x80", "\xD5\x38\x8E\x36", 128},
    {"\xF3\xA6\xB2\x80", "\xD5\x38\x9B\x34", 128},
    {"\xF3\xA6\xB4\x80", "\xD5\x38\xA8\x32", 128},
    {"\xF3\xA6\xB6\x80", "\xD5\x38\xB5\x30", 128},
    {"\xF3\xA6\xB8\x80", "\xD5\x38\xC1\x38", 128},
    {"\xF3\xA6\xBA\x80", "\xD5\x38\xCE\x36", 128},
    {"\xF3\xA6\xBC\x80", "\xD5\x38\xDB\x34", 128},
    {"\xF3\xA6\xBE\x80", "\xD5\x38\xE8\x32", 128},
    {"\xF3\xA7\x80\x80", "\xD5\x38\xF5\x30", 128},
    {"\xF3\xA7\x82\x80", "\xD5\x39\x83\x38", 128},
    {"\xF3\xA7\x84\x80", "\xD5\x39\x90\x36", 128},
    {"\xF3\xA7\x86\x80", "\xD5\x39\x9D\x34", 128},
    {"\xF3\xA7\x88\x80", "\xD5\x39\xAA\x32", 128},
    {"\xF3\xA7\x8A\x80", "\xD5\x39\xB7\x30", 128},
    {"\xF3\xA7\x8C\x80", "\xD5\x39\xC3\x38", 128},
    {"\xF3\xA7\x8E\x80", "\xD5\x39\xD0\x36", 128},
    {"\xF3\xA7\x90\x80", "\xD5\x39\xDD\x34", 128},
    {"\xF3\xA7\x92\x80", "\xD5\x39\xEA\x32", 128},
    {"\xF3\xA7\x94\x80", "\xD5\x39\xF7\x30", 128},
    {"\xF3\xA7\x96\x80", "\xD6\x30\x85\x38", 128},
    {"\xF3\xA7\x98\x80", "\xD6\x30\x92\x36", 128},
    {"\xF3\xA7\x9A\x80", "\xD6\x30\x9F\x34", 128},
    {"\xF3\xA7\x9C\x80", "\xD6\x30\xAC\x32", 128},
    {"\xF3\xA7\x9E\x80", "\xD6\x30\xB9\x30", 128},
    {"\xF3\xA7\xA0\x80", "\xD6\x30\xC5\x38", 128},
    {"\xF3\xA7\xA2\x80", "\xD6\x30\xD2\x36", 128},
    {"\xF3\xA7\xA4\x80", "\xD6\x30\xDF\x34", 128},
    {"\xF3\xA7\xA6\x80", "\xD6\x30\xEC\x32", 128},
    {"\xF3\xA7\xA8\x80", "\xD6\x30\xF9\x30", 128},
    {"\xF3\xA7\xAA\x80", "\xD6\x31\x87\x38", 128},
    {"\xF3\xA7\xAC\x80", "\xD6\x31\x94\x36", 128},
    {"\xF3\xA7\xAE\x80", "\xD6\x31\xA1\x34", 128},
    {"\xF3\xA7\xB0\x80", "\xD6\x31\xAE\x32", 128},
    {"\xF3\xA7\xB2\x80", "\xD6\x31\xBB\x30", 128},
    {"\xF3\xA7\xB4\x80", "\xD6\x31\xC7\x38", 128},
    {"\xF3\xA7\xB6\x80", "\xD6\x31\xD4\x36", 128},
    {"\xF3\xA7\xB8\x80", "\xD6\x31\xE1\x34", 128},
    {"\xF3\xA7\xBA\x80", "\xD6\x31\xEE\x32", 128},
    {"\xF3\xA7\xBC\x80", "\xD6\x31\xFB\x30", 128},
    {"\xF3\xA7\xBE\x80", "\xD6\x32\x89\x38", 128},
    {"\xF3\xA8\x80\x80", "\xD6\x32\x96\x36", 128},
    {"\xF3\xA8\x82\x80", "\xD6\x32\xA3\x34", 128},
    {"\xF3\xA8\x84\x80", "\xD6\x32\xB0\x32", 128},
    {"\xF3\xA8\x86\x80", "\xD6\x32\xBD\x30", 128},
    {"\xF3\xA8\x88\x80", "\xD6\x32\xC9\x38", 128},
    {"\xF3\xA8\x8A\x80", "\xD6\x32\xD6\x36", 128},
    {"\xF3\xA8\x8C\x80", "\xD6\x32\xE3\x34", 128},
    {"\xF3\xA8\x8E\x80", "\xD6\x32\xF0\x32", 128},
    {"\xF3\xA8\x90\x80", "\xD6\x32\xFD\x30", 128},
    {"\xF3\xA8\x92\x80", "\xD6\x33\x8B\x38", 128},
    {"\xF3\xA8\x94\x80", "\xD6\x33\x98\x36", 128},
    {"\xF3\xA8\x96\x80", "\xD6\x33\xA5\x34", 128},
    {"\xF3\xA8\x98\x80", "\xD6\x33\xB2\x32", 128},
    {"\xF3\xA8\x9A\x80", "\xD6\x33\xBF\x30", 128},
    {"\xF3\xA8\x9C\x80", "\xD6\x33\xCB\x38", 128},
    {"\xF3\xA8\x9E\x80", "\xD6\x33\xD8\x36", 128},
    {"\xF3\xA8\xA0\x80", "\xD6\x33\xE5\x34", 128},
    {"\xF3\xA8\xA2\x80", "\xD6\x33\xF2\x32", 128},
    {"\xF3\xA8\xA4\x80", "\xD6\x34\x81\x30", 128},
    {"\xF3\xA8\xA6\x80", "\xD6\x34\x8D\x38", 128},
    {"\xF3\xA8\xA8\x80", "\xD6\x34\x9A\x36", 128},
    {"\xF3\xA8\xAA\x80", "\xD6\x34\xA7\x34", 128},
    {"\xF3\xA8\xAC\x80", "\xD6\x34\xB4\x32", 128},
    {"\xF3\xA8\xAE\x80", "\xD6\x34\xC1\x30", 128},
    {"\xF3\xA8\xB0\x80", "\xD6\x34\xCD\x38", 128},
    {"\xF3\xA8\xB2\x80", "\xD6\x34\xDA\x36", 128},
    {"\xF3\xA8\xB4\x80", "\xD6\x34\xE7\x34", 128},
    {"\xF3\xA8\xB6\x80", "\xD6\x34\xF4\x32", 128},
    {"\xF3\xA8\xB8\x80", "\xD6\x35\x83\x30", 128},
    {"\xF3\xA8\xBA\x80", "\xD6\x35\x8F\x38", 128},
    {"\xF3\xA8\xBC\x80", "\xD6\x35\x9C\x36", 128},
    {"\xF3\xA8\xBE\x80", "\xD6\x35\xA9\x34", 128},
    {"\xF3\xA9\x80\x80", "\xD6\x35\xB6\x32", 128},
    {"\xF3\xA9\x82\x80", "\xD6\x35\xC3\x30", 128},
    {"\xF3\xA9\x84\x80", "\xD6\x35\xCF\x38", 128},
    {"\xF3\xA9\x86\x80", "\xD6\x35\xDC\x36", 128},
    {"\xF3\xA9\x88\x80", "\xD6\x35\xE9\x34", 128},
    {"\xF3\xA9\x8A\x80", "\xD6\x35\xF6\x32", 128},
    {"\xF3\xA9\x8C\x80", "\xD6\x36\x85\x30", 128},
    {"\xF3\xA9\x8E\x80", "\xD6\x36\x91\x38", 128},
    {"\xF3\xA9\x90\x80", "\xD6\x36\x9E\x36", 128},
    {"\xF3\xA9\x92\x80", "\xD6\x36\xAB\x34", 128},
    {"\xF3\xA9\x94\x80", "\xD6\x36\xB8\x32", 128},
    {"\xF3\xA9\x96\x80", "\xD6\x36\xC5\x30", 128},
    {"\xF3\xA9\x98\x80", "\xD6\x36\xD1\x38", 128},
    {"\xF3\xA9\x9A\x80", "\xD6\x36\xDE\x36", 128},
    {"\xF3\xA9\x9C\x80", "\xD6\x36\xEB\x34", 128},
    {"\xF3\xA9\x9E\x80", "\xD6\x36\xF8\x32", 128},
    {"\xF3\xA9\xA0\x80", "\xD6\x37\x87\x30", 128},
    {"\xF3\xA9\xA2\x80", "\xD6\x37\x93\x38", 128},
    {"\xF3\xA9\xA4\x80", "\xD6\x37\xA0\x36", 128},
    {"\xF3\xA9\xA6\x80", "\xD6\x37\xAD\x34", 128},
    {"\xF3\xA9\xA8\x80", "\xD6\x37\xBA\x32", 128},
    {"\xF3\xA9\xAA\x80", "\xD6\x37\xC7\x30", 128},
    {"\xF3\xA9\xAC\x80", "\xD6\x37\xD3\x38", 128},
    {"\xF3\xA9\xAE\x80", "\xD6\x37\xE0\x36", 128},
    {"\xF3\xA9\xB0\x80", "\xD6\x37\xED\x34", 128},
    {"\xF3\xA9\xB2\x80", "\xD6\x37\xFA\x32", 128},
    {"\xF3\xA9\xB4\x80", "\xD6\x38\x89\x30", 128},
    {"\xF3\xA9\xB6\x80", "\xD6\x38\x95\x38", 128},
    {"\xF3\xA9\xB8\x80", "\xD6\x38\xA2\x36", 128},
    {"\xF3\xA9\xBA\x80", "\xD6\x38\xAF\x34", 128},
    {"\xF3\xA9\xBC\x80", "\xD6\x38\xBC\x32", 128},
    {"\xF3\xA9\xBE\x80", "\xD6\x38\xC9\x30", 128},
    {"\xF3\xAA\x80\x80", "\xD6\x38\xD5\x38", 128},
    {"\xF3\xAA\x82\x80", "\xD6\x38\xE2\x36", 128},
    {"\xF3\xAA\x84\x80", "\xD6\x38\xEF\x34", 128},
    {"\xF3\xAA\x86\x80", "\xD6\x38\xFC\x32", 128},
    {"\xF3\xAA\x88\x80", "\xD6\x39\x8B\x30", 128},
    {"\xF3\xAA\x8A\x80", "\xD6\x39\x97\x38", 128},
    {"\xF3\xAA\x8C\x80", "\xD6\x39\xA4\x36", 128},
    {"\xF3\xAA\x8E\x80", "\xD6\x39\xB1\x34", 128},
    {"\xF3\xAA\x90\x80", "\xD6\x39\xBE\x32", 128},
    {"\xF3\xAA\x92\x80", "\xD6\x39\xCB\x30", 128},
    {"\xF3\xAA\x94\x80", "\xD6\x39\xD7\x38", 128},
    {"\xF3\xAA\x96\x80", "\xD6\x39\xE4\x36", 128},
    {"\xF3\xAA\x98\x80", "\xD6\x39\xF1\x34", 128},
    {"\xF3\xAA\x9A\x80", "\xD6\x39\xFE\x32", 128},
    {"\xF3\xAA\x9C\x80", "\xD7\x30\x8D\x30", 128},
    {"\xF3\xAA\x9E\x80", "\xD7\x30\x99\x38", 128},
    {"\xF3\xAA\xA0\x80", "\xD7\x30\xA6\x36", 128},
    {"\xF3\xAA\xA2\x80", "\xD7\x30\xB3\x34", 128},
    {"\xF3\xAA\xA4\x80", "\xD7\x30\xC0\x32", 128},
    {"\xF3\xAA\xA6\x80", "\xD7\x30\xCD\x30", 128},
    {"\xF3\xAA\xA8\x80", "\xD7\x30\xD9\x38", 128},
    {"\xF3\xAA\xAA\x80", "\xD7\x30\xE6\x36", 128},
    {"\xF3\xAA\xAC\x80", "\xD7\x30\xF3\x34", 128},
    {"\xF3\xAA\xAE\x80", "\xD7\x31\x82\x32", 128},
    {"\xF3\xAA\xB0\x80", "\xD7\x31\x8F\x30", 128},
    {"\xF3\xAA\xB2\x80", "\xD7\x31\x9B\x38", 128},
    {"\xF3\xAA\xB4\x80", "\xD7\x31\xA8\x36", 128},
    {"\xF3\xAA\xB6\x80", "\xD7\x31\xB5\x34", 128},
    {"\xF3\xAA\xB8\x80", "\xD7\x31\xC2\x32", 128},
    {"\xF3\xAA\xBA\x80", "\xD7\x31\xCF\x30", 128},
    {"\xF3\xAA\xBC\x80", "\xD7\x31\xDB\x38", 128},
    {"\xF3\xAA\xBE\x80", "\xD7\x31\xE8\x36", 128},
    {"\xF3\xAB\x80\x80", "\xD7\x31\xF5\x34", 128},
    {"\xF3\xAB\x82\x80", "\xD7\x32\x84\x32", 128},
    {"\xF3\xAB\x84\x80", "\xD7\x32\x91\x30", 128},
    {"\xF3\xAB\x86\x80", "\xD7\x32\x9D\x38", 128},
    {"\xF3\xAB\x88\x80", "\xD7\x32\xAA\x36", 128},
    {"\xF3\xAB\x8A\x80", "\xD7\x32\xB7\x34", 128},
    {"\xF3\xAB\x8C\x80", "\xD7\x32\xC4\x32", 128},
    {"\xF3\xAB\x8E\x80", "\xD7\x32\xD1\x30", 128},
    {"\xF3\xAB\x90\x80", "\xD7\x32\xDD\x38", 128},
    {"\xF3\xAB\x92\x80", "\xD7\x32\xEA\x36", 128},
    {"\xF3\xAB\x94\x80", "\xD7\x32\xF7\x34", 128},
    {"\xF3\xAB\x96\x80", "\xD7\x33\x86\x32", 128},
    {"\xF3\xAB\x98\x80", "\xD7\x33\x93\x30", 128},
    {"\xF3\xAB\x9A\x80", "\xD7\x33\x9F\x38", 128},
    {"\xF3\xAB\x9C\x80", "\xD7\x33\xAC\x36", 128},
    {"\xF3\xAB\x9E\x80", "\xD7\x33\xB9\x34", 128},
    {"\xF3\xAB\xA0\x80", "\xD7\x33\xC6\x32", 128},
    {"\xF3\xAB\xA2\x80", "\xD7\x33\xD3\x30", 128},
    {"\xF3\xAB\xA4\x80", "\xD7\x33\xDF\x38", 128},
    {"\xF3\xAB\xA6\x80", "\xD7\x33\xEC\x36", 128},
    {"\xF3\xAB\xA8\x80", "\xD7\x33\xF9\x34", 128},
    {"\xF3\xAB\xAA\x80", "\xD7\x34\x88\x32", 128},
    {"\xF3\xAB\xAC\x80", "\xD7\x34\x95\x30", 128},
    {"\xF3\xAB\xAE\x80", "\xD7\x34\xA1\x38", 128},
    {"\xF3\xAB\xB0\x80", "\xD7\x34\xAE\x36", 128},
    {"\xF3\xAB\xB2\x80", "\xD7\x34\xBB\x34", 128},
    {"\xF3\xAB\xB4\x80", "\xD7\x34\xC8\x32", 128},
    {"\xF3\xAB\xB6\x80", "\xD7\x34\xD5\x30", 128},
    {"\xF3\xAB\xB8\x80", "\xD7\x34\xE1\x38", 128},
    {"\xF3\xAB\xBA\x80", "\xD7\x34\xEE\x36", 128},
    {"\xF3\xAB\xBC\x80", "\xD7\x34\xFB\x34", 128},
    {"\xF3\xAB\xBE\x80", "\xD7\x35\x8A\x32", 128},
    {"\xF3\xAC\x80\x80", "\xD7\x35\x97\x30", 128},
    {"\xF3\xAC\x82\x80", "\xD7\x35\xA3\x38", 128},
    {"\xF3\xAC\x84\x80", "\xD7\x35\xB0\x36", 128},
    {"\xF3\xAC\x86\x80", "\xD7\x35\xBD\x34", 128},
    {"\xF3\xAC\x88\x80", "\xD7\x35\xCA\x32", 128},
    {"\xF3\xAC\x8A\x80", "\xD7\x35\xD7\x30", 128},
    {"\xF3\xAC\x8C\x80", "\xD7\x35\xE3\x38", 128},
    {"\xF3\xAC\x8E\x80", "\xD7\x35\xF0\x36", 128},
    {"\xF3\xAC\x90\x80", "\xD7\x35\xFD\x34", 128},
    {"\xF3\xAC\x92\x80", "\xD7\x36\x8C\x32", 128},
    {"\xF3\xAC\x94\x80", "\xD7\x36\x99\x30", 128},
    {"\xF3\xAC\x96\x80", "\xD7\x36\xA5\x38", 128},
    {"\xF3\xAC\x98\x80", "\xD7\x36\xB2\x36", 128},
    {"\xF3\xAC\x9A\x80", "\xD7\x36\xBF\x34", 128},
    {"\xF3\xAC\x9C\x80", "\xD7\x36\xCC\x32", 128},
    {"\xF3\xAC\x9E\x80", "\xD7\x36\xD9\x30", 128},
    {"\xF3\xAC\xA0\x80", "\xD7\x36\xE5\x38", 128},
    {"\xF3\xAC\xA2\x80", "\xD7\x36\xF2\x36", 128},
    {"\xF3\xAC\xA4\x80", "\xD7\x37\x81\x34", 128},
    {"\xF3\xAC\xA6\x80", "\xD7\x37\x8E\x32", 128},
    {"\xF3\xAC\xA8\x80", "\xD7\x37\x9B\x30", 128},
    {"\xF3\xAC\xAA\x80", "\xD7\x37\xA7\x38", 128},
    {"\xF3\xAC\xAC\x80", "\xD7\x37\xB4\x36", 128},
    {"\xF3\xAC\xAE\x80", "\xD7\x37\xC1\x34", 128},
    {"\xF3\xAC\xB0\x80", "\xD7\x37\xCE\x32", 128},
    {"\xF3\xAC\xB2\x80", "\xD7\x37\xDB\x30", 128},
    {"\xF3\xAC\xB4\x80", "\xD7\x37\xE7\x38", 128},
    {"\xF3\xAC\xB6\x80", "\xD7\x37\xF4\x36", 128},
    {"\xF3\xAC\xB8\x80", "\xD7\x38\x83\x34", 128},
    {"\xF3\xAC\xBA\x80", "\xD7\x38\x90\x32", 128},
    {"\xF3\xAC\xBC\x80", "\xD7\x38\x9D\x30", 128},
    {"\xF3\xAC\xBE\x80", "\xD7\x38\xA9\x38", 128},
    {"\xF3\xAD\x80\x80", "\xD7\x38\xB6\x36", 128},
    {"\xF3\xAD\x82\x80", "\xD7\x38\xC3\x34", 128},
    {"\xF3\xAD\x84\x80", "\xD7\x38\xD0\x32", 128},
    {"\xF3\xAD\x86\x80", "\xD7\x38\xDD\x30", 128},
    {"\xF3\xAD\x88\x80", "\xD7\x38\xE9\x38", 128},
    {"\xF3\xAD\x8A\x80", "\xD7\x38\xF6\x36", 128},
    {"\xF3\xAD\x8C\x80", "\xD7\x39\x85\x34", 128},
    {"\xF3\xAD\x8E\x80", "\xD7\x39\x92\x32", 128},
    {"\xF3\xAD\x90\x80", "\xD7\x39\x9F\x30", 128},
    {"\xF3\xAD\x92\x80", "\xD7\x39\xAB\x38", 128},
    {"\xF3\xAD\x94\x80", "\xD7\x39\xB8\x36", 128},
    {"\xF3\xAD\x96\x80", "\xD7\x39\xC5\x34", 128},
    {"\xF3\xAD\x98\x80", "\xD7\x39\xD2\x32", 128},
    {"\xF3\xAD\x9A\x80", "\xD7\x39\xDF\x30", 128},
    {"\xF3\xAD\x9C\x80", "\xD7\x39\xEB\x38", 128},
    {"\xF3\xAD\x9E\x80", "\xD7\x39\xF8\x36", 128},
    {"\xF3\xAD\xA0\x80", "\xD8\x30\x87\x34", 128},
    {"\xF3\xAD\xA2\x80", "\xD8\x30\x94\x32", 128},
    {"\xF3\xAD\xA4\x80", "\xD8\x30\xA1\x30", 128},
    {"\xF3\xAD\xA6\x80", "\xD8\x30\xAD\x38", 128},
    {"\xF3\xAD\xA8\x80", "\xD8\x30\xBA\x36", 128},
    {"\xF3\xAD\xAA\x80", "\xD8\x30\xC7\x34", 128},
    {"\xF3\xAD\xAC\x80", "\xD8\x30\xD4\x32", 128},
    {"\xF3\xAD\xAE\x80", "\xD8\x30\xE1\x30", 128},
    {"\xF3\xAD\xB0\x80", "\xD8\x30\xED\x38", 128},
    {"\xF3\xAD\xB2\x80", "\xD8\x30\xFA\x36", 128},
    {"\xF3\xAD\xB4\x80", "\xD8\x31\x89\x34", 128},
    {"\xF3\xAD\xB6\x80", "\xD8\x31\x96\x32", 128},
    {"\xF3\xAD\xB8\x80", "\xD8\x31\xA3\x30", 128},
    {"\xF3\xAD\xBA\x80", "\xD8\x31\xAF\x38", 128},
    {"\xF3\xAD\xBC\x80", "\xD8\x31\xBC\x36", 128},
    {"\xF3\xAD\xBE\x80", "\xD8\x31\xC9\x34", 128},
    {"\xF3\xAE\x80\x80", "\xD8\x31\xD6\x32", 128},
    {"\xF3\xAE\x82\x80", "\xD8\x31\xE3\x30", 128},
    {"\xF3\xAE\x84\x80", "\xD8\x31\xEF\x38", 128},
    {"\xF3\xAE\x86\x80", "\xD8\x31\xFC\x36", 128},
    {"\xF3\xAE\x88\x80", "\xD8\x32\x8B\x34", 128},
    {"\xF3\xAE\x8A\x80", "\xD8\x32\x98\x32", 128},
    {"\xF3\xAE\x8C\x80", "\xD8\x32\xA5\x30", 128},
    {"\xF3\xAE\x8E\x80", "\xD8\x32\xB1\x38", 128},
    {"\xF3\xAE\x90\x80", "\xD8\x32\xBE\x36", 128},
    {"\xF3\xAE\x92\x80", "\xD8\x32\xCB\x34", 128},
    {"\xF3\xAE\x94\x80", "\xD8\x32\xD8\x32", 128},
    {"\xF3\xAE\x96\x80", "\xD8\x32\xE5\x30", 128},
    {"\xF3\xAE\x98\x80", "\xD8\x32\xF1\x38", 128},
    {"\xF3\xAE\x9A\x80", "\xD8\x32\xFE\x36", 128},
    {"\xF3\xAE\x9C\x80", "\xD8\x33\x8D\x34", 128},
    {"\xF3\xAE\x9E\x80", "\xD8\x33\x9A\x32", 128},
    {"\xF3\xAE\xA0\x80", "\xD8\x33\xA7\x30", 128},
    {"\xF3\xAE\xA2\x80", "\xD8\x33\xB3\x38", 128},
    {"\xF3\xAE\xA4\x80", "\xD8\x33\xC0\x36", 128},
    {"\xF3\xAE\xA6\x80", "\xD8\x33\xCD\x34", 128},
    {"\xF3\xAE\xA8\x80", "\xD8\x33\xDA\x32", 128},
    {"\xF3\xAE\xAA\x80", "\xD8\x33\xE7\x30", 128},
    {"\xF3\xAE\xAC\x80", "\xD8\x33\xF3\x38", 128},
    {"\xF3\xAE\xAE\x80", "\xD8\x34\x82\x36", 128},
    {"\xF3\xAE\xB0\x80", "\xD8\x34\x8F\x34", 128},
    {"\xF3\xAE\xB2\x80", "\xD8\x34\x9C\x32", 128},
    {"\xF3\xAE\xB4\x80", "\xD8\x34\xA9\x30", 128},
    {"\xF3\xAE\xB6\x80", "\xD8\x34\xB5\x38", 128},
    {"\xF3\xAE\xB8\x80", "\xD8\x34\xC2\x36", 128},
    {"\xF3\xAE\xBA\x80", "\xD8\x34\xCF\x34", 128},
    {"\xF3\xAE\xBC\x80", "\xD8\x34\xDC\x32", 128},
    {"\xF3\xAE\xBE\x80", "\xD8\x34\xE9\x30", 128},
    {"\xF3\xAF\x80\x80", "\xD8\x34\xF5\x38", 128},
    {"\xF3\xAF\x82\x80", "\xD8\x35\x84\x36", 128},
    {"\xF3\xAF\x84\x80", "\xD8\x35\x91\x34", 128},
    {"\xF3\xAF\x86\x80", "\xD8\x35\x9E\x32", 128},
    {"\xF3\xAF\x88\x80", "\xD8\x35\xAB\x30", 128},
    {"\xF3\xAF\x8A\x80", "\xD8\x35\xB7\x38", 128},
    {"\xF3\xAF\x8C\x80", "\xD8\x35\xC4\x36", 128},
    {"\xF3\xAF\x8E\x80", "\xD8\x35\xD1\x34", 128},
    {"\xF3\xAF\x90\x80", "\xD8\x35\xDE\x32", 128},
    {"\xF3\xAF\x92\x80", "\xD8\x35\xEB\x30", 128},
    {"\xF3\xAF\x94\x80", "\xD8\x35\xF7\x38", 128},
    {"\xF3\xAF\x96\x80", "\xD8\x36\x86\x36", 128},
    {"\xF3\xAF\x98\x80", "\xD8\x36\x93\x34", 128},
    {"\xF3\xAF\x9A\x80", "\xD8\x36\xA0\x32", 128},
    {"\xF3\xAF\x9C\x80", "\xD8\x36\xAD\x30", 128},
    {"\xF3\xAF\x9E\x80", "\xD8\x36\xB9\x38", 128},
    {"\xF3\xAF\xA0\x80", "\xD8\x36\xC6\x36", 128},
    {"\xF3\xAF\xA2\x80", "\xD8\x36\xD3\x34", 128},
    {"\xF3\xAF\xA4\x80", "\xD8\x36\xE0\x32", 128},
    {"\xF3\xAF\xA6\x80", "\xD8\x36\xED\x30", 128},
    {"\xF3\xAF\xA8\x80", "\xD8\x36\xF9\x38", 128},
    {"\xF3\xAF\xAA\x80", "\xD8\x37\x88\x36", 128},
    {"\xF3\xAF\xAC\x80", "\xD8\x37\x95\x34", 128},
    {"\xF3\xAF\xAE\x80", "\xD8\x37\xA2\x32", 128},
    {"\xF3\xAF\xB0\x80", "\xD8\x37\xAF\x30", 128},
    {"\xF3\xAF\xB2\x80", "\xD8\x37\xBB\x38", 128},
    {"\xF3\xAF\xB4\x80", "\xD8\x37\xC8\x36", 128},
    {"\xF3\xAF\xB6\x80", "\xD8\x37\xD5\x34", 128},
    {"\xF3\xAF\xB8\x80", "\xD8\x37\xE2\x32", 128},
    {"\xF3\xAF\xBA\x80", "\xD8\x37\xEF\x30", 128},
    {"\xF3\xAF\xBC\x80", "\xD8\x37\xFB\x38", 128},
    {"\xF3\xAF\xBE\x80", "\xD8\x38\x8A\x36", 128},
    {"\xF3\xB0\x80\x80", "\xD8\x38\x97\x34", 128},
    {"\xF3\xB0\x82\x80", "\xD8\x38\xA4\x32", 128},
    {"\xF3\xB0\x84\x80", "\xD8\x38\xB1\x30", 128},
    {"\xF3\xB0\x86\x80", "\xD8\x38\xBD\x38", 128},
    {"\xF3\xB0\x88\x80", "\xD8\x38\xCA\x36", 128},
    {"\xF3\xB0\x8A\x80", "\xD8\x38\xD7\x34", 128},
    {"\xF3\xB0\x8C\x80", "\xD8\x38\xE4\x32", 128},
    {"\xF3\xB0\x8E\x80", "\xD8\x38\xF1\x30", 128},
    {"\xF3\xB0\x90\x80", "\xD8\x38\xFD\x38", 128},
    {"\xF3\xB0\x92\x80", "\xD8\x39\x8C\x36", 128},
    {"\xF3\xB0\x94\x80", "\xD8\x39\x99\x34", 128},
    {"\xF3\xB0\x96\x80", "\xD8\x39\xA6\x32", 128},
    {"\xF3\xB0\x98\x80", "\xD8\x39\xB3\x30", 128},
    {"\xF3\xB0\x9A\x80", "\xD8\x39\xBF\x38", 128},
    {"\xF3\xB0\x9C\x80", "\xD8\x39\xCC\x36", 128},
    {"\xF3\xB0\x9E\x80", "\xD8\x39\xD9\x34", 128},
    {"\xF3\xB0\xA0\x80", "\xD8\x39\xE6\x32", 128},
    {"\xF3\xB0\xA2\x80", "\xD8\x39\xF3\x30", 128},
    {"\xF3\xB0\xA4\x80", "\xD9\x30\x81\x38", 128},
    {"\xF3\xB0\xA6\x80", "\xD9\x30\x8E\x36", 128},
    {"\xF3\xB0\xA8\x80", "\xD9\x30\x9B\x34", 128},
    {"\xF3\xB0\xAA\x80", "\xD9\x30\xA8\x32", 128},
    {"\xF3\xB0\xAC\x80", "\xD9\x30\xB5\x30", 128},
    {"\xF3\xB0\xAE\x80", "\xD9\x30\xC1\x38", 128},
    {"\xF3\xB0\xB0\x80", "\xD9\x30\xCE\x36", 128},
    {"\xF3\xB0\xB2\x80", "\xD9\x30\xDB\x34", 128},
    {"\xF3\xB0\xB4\x80", "\xD9\x30\xE8\x32", 128},
    {"\xF3\xB0\xB6\x80", "\xD9\x30\xF5\x30", 128},
    {"\xF3\xB0\xB8\x80", "\xD9\x31\x83\x38", 128},
    {"\xF3\xB0\xBA\x80", "\xD9\x31\x90\x36", 128},
    {"\xF3\xB0\xBC\x80", "\xD9\x31\x9D\x34", 128},
    {"\xF3\xB0\xBE\x80", "\xD9\x31\xAA\x32", 128},
    {"\xF3\xB1\x80\x80", "\xD9\x31\xB7\x30", 128},
    {"\xF3\xB1\x82\x80", "\xD9\x31\xC3\x38", 128},
    {"\xF3\xB1\x84\x80", "\xD9\x31\xD0\x36", 128},
    {"\xF3\xB1\x86\x80", "\xD9\x31\xDD\x34", 128},
    {"\xF3\xB1\x88\x80", "\xD9\x31\xEA\x32", 128},
    {"\xF3\xB1\x8A\x80", "\xD9\x31\xF7\x30", 128},
    {"\xF3\xB1\x8C\x80", "\xD9\x32\x85\x38", 128},
    {"\xF3\xB1\x8E\x80", "\xD9\x32\x92\x36", 128},
    {"\xF3\xB1\x90\x80", "\xD9\x32\x9F\x34", 128},
    {"\xF3\xB1\x92\x80", "\xD9\x32\xAC\x32", 128},
    {"\xF3\xB1\x94\x80", "\xD9\x32\xB9\x30", 128},
    {"\xF3\xB1\x96\x80", "\xD9\x32\xC5\x38", 128},
    {"\xF3\xB1\x98\x80", "\xD9\x32\xD2\x36", 128},
    {"\xF3\xB1\x9A\x80", "\xD9\x32\xDF\x34", 128},
    {"\xF3\xB1\x9C\x80", "\xD9\x32\xEC\x32", 128},
    {"\xF3\xB1\x9E\x80", "\xD9\x32\xF9\x30", 128},
    {"\xF3\xB1\xA0\x80", "\xD9\x33\x87\x38", 128},
    {"\xF3\xB1\xA2\x80", "\xD9\x33\x94\x36", 128},
    {"\xF3\xB1\xA4\x80", "\xD9\x33\xA1\x34", 128},
    {"\xF3\xB1\xA6\x80", "\xD9\x33\xAE\x32", 128},
    {"\xF3\xB1\xA8\x80", "\xD9\x33\xBB\x30", 128},
    {"\xF3\xB1\xAA\x80", "\xD9\x33\xC7\x38", 128},
    {"\xF3\xB1\xAC\x80", "\xD9\x33\xD4\x36", 128},
    {"\xF3\xB1\xAE\x80", "\xD9\x33\xE1\x34", 128},
    {"\xF3\xB1\xB0\x80", "\xD9\x33\xEE\x32", 128},
    {"\xF3\xB1\xB2\x80", "\xD9\x33\xFB\x30", 128},
    {"\xF3\xB1\xB4\x80", "\xD9\x34\x89\x38", 128},
    {"\xF3\xB1\xB6\x80", "\xD9\x34\x96\x36", 128},
    {"\xF3\xB1\xB8\x80", "\xD9\x34\xA3\x34", 128},
    {"\xF3\xB1\xBA\x80", "\xD9\x34\xB0\x32", 128},
    {"\xF3\xB1\xBC\x80", "\xD9\x34\xBD\x30", 128},
    {"\xF3\xB1\xBE\x80", "\xD9\x34\xC9\x38", 128},
    {"\xF3\xB2\x80\x80", "\xD9\x34\xD6\x36", 128},
    {"\xF3\xB2\x82\x80", "\xD9\x34\xE3\x34", 128},
    {"\xF3\xB2\x84\x80", "\xD9\x34\xF0\x32", 128},
    {"\xF3\xB2\x86\x80", "\xD9\x34\xFD\x30", 128},
    {"\xF3\xB2\x88\x80", "\xD9\x35\x8B\x38", 128},
    {"\xF3\xB2\x8A\x80", "\xD9\x35\x98\x36", 128},
    {"\xF3\xB2\x8C\x80", "\xD9\x35\xA5\x34", 128},
    {"\xF3\xB2\x8E\x80", "\xD9\x35\xB2\x32", 128},
    {"\xF3\xB2\x90\x80", "\xD9\x35\xBF\x30", 128},
    {"\xF3\xB2\x92\x80", "\xD9\x35\xCB\x38", 128},
    {"\xF3\xB2\x94\x80", "\xD9\x35\xD8\x36", 128},
    {"\xF3\xB2\x96\x80", "\xD9\x35\xE5\x34", 128},
    {"\xF3\xB2\x98\x80", "\xD9\x35\xF2\x32", 128},
    {"\xF3\xB2\x9A\x80", "\xD9\x36\x81\x30", 128},
    {"\xF3\xB2\x9C\x80", "\xD9\x36\x8D\x38", 128},
    {"\xF3\xB2\x9E\x80", "\xD9\x36\x9A\x36", 128},
    {"\xF3\xB2\xA0\x80", "\xD9\x36\xA7\x34", 128},
    {"\xF3\xB2\xA2\x80", "\xD9\x36\xB4\x32", 128},
    {"\xF3\xB2\xA4\x80", "\xD9\x36\xC1\x30", 128},
    {"\xF3\xB2\xA6\x80", "\xD9\x36\xCD\x38", 128},
    {"\xF3\xB2\xA8\x80", "\xD9\x36\xDA\x36", 128},
    {"\xF3\xB2\xAA\x80", "\xD9\x36\xE7\x34", 128},
    {"\xF3\xB2\xAC\x80", "\xD9\x36\xF4\x32", 128},
    {"\xF3\xB2\xAE\x80", "\xD9\x37\x83\x30", 128},
    {"\xF3\xB2\xB0\x80", "\xD9\x37\x8F\x38", 128},
    {"\xF3\xB2\xB2\x80", "\xD9\x37\x9C\x36", 128},
    {"\xF3\xB2\xB4\x80", "\xD9\x37\xA9\x34", 128},
    {"\xF3\xB2\xB6\x80", "\xD9\x37\xB6\x32", 128},
    {"\xF3\xB2\xB8\x80", "\xD9\x37\xC3\x30", 128},
    {"\xF3\xB2\xBA\x80", "\xD9\x37\xCF\x38", 128},
    {"\xF3\xB2\xBC\x80", "\xD9\x37\xDC\x36", 128},
    {"\xF3\xB2\xBE\x80", "\xD9\x37\xE9\x34", 128},
    {"\xF3\xB3\x80\x80", "\xD9\x37\xF6\x32", 128},
    {"\xF3\xB3\x82\x80", "\xD9\x38\x85\x30", 128},
    {"\xF3\xB3\x84\x80", "\xD9\x38\x91\x38", 128},
    {"\xF3\xB3\x86\x80", "\xD9\x38\x9E\x36", 128},
    {"\xF3\xB3\x88\x80", "\xD9\x38\xAB\x34", 128},
    {"\xF3\xB3\x8A\x80", "\xD9\x38\xB8\x32", 128},
    {"\xF3\xB3\x8C\x80", "\xD9\x38\xC5\x30", 128},
    {"\xF3\xB3\x8E\x80", "\xD9\x38\xD1\x38", 128},
    {"\xF3\xB3\x90\x80", "\xD9\x38\xDE\x36", 128},
    {"\xF3\xB3\x92\x80", "\xD9\x38\xEB\x34", 128},
    {"\xF3\xB3\x94\x80", "\xD9\x38\xF8\x32", 128},
    {"\xF3\xB3\x96\x80", "\xD9\x39\x87\x30", 128},
    {"\xF3\xB3\x98\x80", "\xD9\x39\x93\x38", 128},
    {"\xF3\xB3\x9A\x80", "\xD9\x39\xA0\x36", 128},
    {"\xF3\xB3\x9C\x80", "\xD9\x39\xAD\x34", 128},
    {"\xF3\xB3\x9E\x80", "\xD9\x39\xBA\x32", 128},
    {"\xF3\xB3\xA0\x80", "\xD9\x39\xC7\x30", 128},
    {"\xF3\xB3\xA2\x80", "\xD9\x39\xD3\x38", 128},
    {"\xF3\xB3\xA4\x80", "\xD9\x39\xE0\x36", 128},
    {"\xF3\xB3\xA6\x80", "\xD9\x39\xED\x34", 128},
    {"\xF3\xB3\xA8\x80", "\xD9\x39\xFA\x32", 128},
    {"\xF3\xB3\xAA\x80", "\xDA\x30\x89\x30", 128},
    {"\xF3\xB3\xAC\x80", "\xDA\x30\x95\x38", 128},
    {"\xF3\xB3\xAE\x80", "\xDA\x30\xA2\x36", 128},
    {"\xF3\xB3\xB0\x80", "\xDA\x30\xAF\x34", 128},
    {"\xF3\xB3\xB2\x80", "\xDA\x30\xBC\x32", 128},
    {"\xF3\xB3\xB4\x80", "\xDA\x30\xC9\x30", 128},
    {"\xF3\xB3\xB6\x80", "\xDA\x30\xD5\x38", 128},
    {"\xF3\xB3\xB8\x80", "\xDA\x30\xE2\x36", 128},
    {"\xF3\xB3\xBA\x80", "\xDA\x30\xEF\x34", 128},
    {"\xF3\xB3\xBC\x80", "\xDA\x30\xFC\x32", 128},
    {"\xF3\xB3\xBE\x80", "\xDA\x31\x8B\x30", 128},
    {"\xF3\xB4\x80\x80", "\xDA\x31\x97\x38", 128},
    {"\xF3\xB4\x82\x80", "\xDA\x31\xA4\x36", 128},
    {"\xF3\xB4\x84\x80", "\xDA\x31\xB1\x34", 128},
    {"\xF3\xB4\x86\x80", "\xDA\x31\xBE\x32", 128},
    {"\xF3\xB4\x88\x80", "\xDA\x31\xCB\x30", 128},
    {"\xF3\xB4\x8A\x80", "\xDA\x31\xD7\x38", 128},
    {"\xF3\xB4\x8C\x80", "\xDA\x31\xE4\x36", 128},
    {"\xF3\xB4\x8E\x80", "\xDA\x31\xF1\x34", 128},
    {"\xF3\xB4\x90\x80", "\xDA\x31\xFE\x32", 128},
    {"\xF3\xB4\x92\x80", "\xDA\x32\x8D\x30", 128},
    {"\xF3\xB4\x94\x80", "\xDA\x32\x99\x38", 128},
    {"\xF3\xB4\x96\x80", "\xDA\x32\xA6\x36", 128},
    {"\xF3\xB4\x98\x80", "\xDA\x32\xB3\x34", 128},
    {"\xF3\xB4\x9A\x80", "\xDA\x32\xC0\x32", 128},
    {"\xF3\xB4\x9C\x80", "\xDA\x32\xCD\x30", 128},
    {"\xF3\xB4\x9E\x80", "\xDA\x32\xD9\x38", 128},
    {"\xF3\xB4\xA0\x80", "\xDA\x32\xE6\x36", 128},
    {"\xF3\xB4\xA2\x80", "\xDA\x32\xF3\x34", 128},
    {"\xF3\xB4\xA4\x80", "\xDA\x33\x82\x32", 128},
    {"\xF3\xB4\xA6\x80", "\xDA\x33\x8F\x30", 128},
    {"\xF3\xB4\xA8\x80", "\xDA\x33\x9B\x38", 128},
    {"\xF3\xB4\xAA\x80", "\xDA\x33\xA8\x36", 128},
    {"\xF3\xB4\xAC\x80", "\xDA\x33\xB5\x34", 128},
    {"\xF3\xB4\xAE\x80", "\xDA\x33\xC2\x32", 128},
    {"\xF3\xB4\xB0\x80", "\xDA\x33\xCF\x30", 128},
    {"\xF3\xB4\xB2\x80", "\xDA\x33\xDB\x38", 128},
    {"\xF3\xB4\xB4\x80", "\xDA\x33\xE8\x36", 128},
    {"\xF3\xB4\xB6\x80", "\xDA\x33\xF5\x34", 128},
    {"\xF3\xB4\xB8\x80", "\xDA\x34\x84\x32", 128},
    {"\xF3\xB4\xBA\x80", "\xDA\x34\x91\x30", 128},
    {"\xF3\xB4\xBC\x80", "\xDA\x34\x9D\x38", 128},
    {"\xF3\xB4\xBE\x80", "\xDA\x34\xAA\x36", 128},
    {"\xF3\xB5\x80\x80", "\xDA\x34\xB7\x34", 128},
    {"\xF3\xB5\x82\x80", "\xDA\x34\xC4\x32", 128},
    {"\xF3\xB5\x84\x80", "\xDA\x34\xD1\x30", 128},
    {"\xF3\xB5\x86\x80", "\xDA\x34\xDD\x38", 128},
    {"\xF3\xB5\x88\x80", "\xDA\x34\xEA\x36", 128},
    {"\xF3\xB5\x8A\x80", "\xDA\x34\xF7\x34", 128},
    {"\xF3\xB5\x8C\x80", "\xDA\x35\x86\x32", 128},
    {"\xF3\xB5\x8E\x80", "\xDA\x35\x93\x30", 128},
    {"\xF3\xB5\x90\x80", "\xDA\x35\x9F\x38", 128},
    {"\xF3\xB5\x92\x80", "\xDA\x35\xAC\x36", 128},
    {"\xF3\xB5\x94\x80", "\xDA\x35\xB9\x34", 128},
    {"\xF3\xB5\x96\x80", "\xDA\x35\xC6\x32", 128},
    {"\xF3\xB5\x98\x80", "\xDA\x35\xD3\x30", 128},
    {"\xF3\xB5\x9A\x80", "\xDA\x35\xDF\x38", 128},
    {"\xF3\xB5\x9C\x80", "\xDA\x35\xEC\x36", 128},
    {"\xF3\xB5\x9E\x80", "\xDA\x35\xF9\x34", 128},
    {"\xF3\xB5\xA0\x80", "\xDA\x36\x88\x32", 128},
    {"\xF3\xB5\xA2\x80", "\xDA\x36\x95\x30", 128},
    {"\xF3\xB5\xA4\x80", "\xDA\x36\xA1\x38", 128},
    {"\xF3\xB5\xA6\x80", "\xDA\x36\xAE\x36", 128},
    {"\xF3\xB5\xA8\x80", "\xDA\x36\xBB\x34", 128},
    {"\xF3\xB5\xAA\x80", "\xDA\x36\xC8\x32", 128},
    {"\xF3\xB5\xAC\x80", "\xDA\x36\xD5\x30", 128},
    {"\xF3\xB5\xAE\x80", "\xDA\x36\xE1\x38", 128},
    {"\xF3\xB5\xB0\x80", "\xDA\x36\xEE\x36", 128},
    {"\xF3\xB5\xB2\x80", "\xDA\x36\xFB\x34", 128},
    {"\xF3\xB5\xB4\x80", "\xDA\x37\x8A\x32", 128},
    {"\xF3\xB5\xB6\x80", "\xDA\x37\x97\x30", 128},
    {"\xF3\xB5\xB8\x80", "\xDA\x37\xA3\x38", 128},
    {"\xF3\xB5\xBA\x80", "\xDA\x37\xB0\x36", 128},
    {"\xF3\xB5\xBC\x80", "\xDA\x37\xBD\x34", 128},
    {"\xF3\xB5\xBE\x80", "\xDA\x37\xCA\x32", 128},
    {"\xF3\xB6\x80\x80", "\xDA\x37\xD7\x30", 128},
    {"\xF3\xB6\x82\x80", "\xDA\x37\xE3\x38", 128},
    {"\xF3\xB6\x84\x80", "\xDA\x37\xF0\x36", 128},
    {"\xF3\xB6\x86\x80", "\xDA\x37\xFD\x34", 128},
    {"\xF3\xB6\x88\x80", "\xDA\x38\x8C\x32", 128},
    {"\xF3\xB6\x8A\x80", "\xDA\x38\x99\x30", 128},
    {"\xF3\xB6\x8C\x80", "\xDA\x38\xA5\x38", 128},
    {"\xF3\xB6\x8E\x80", "\xDA\x38\xB2\x36", 128},
    {"\xF3\xB6\x90\x80", "\xDA\x38\xBF\x34", 128},
    {"\xF3\xB6\x92\x80", "\xDA\x38\xCC\x32", 128},
    {"\xF3\xB6\x94\x80", "\xDA\x38\xD9\x30", 128},
    {"\xF3\xB6\x96\x80", "\xDA\x38\xE5\x38", 128},
    {"\xF3\xB6\x98\x80", "\xDA\x38\xF2\x36", 128},
    {"\xF3\xB6\x9A\x80", "\xDA\x39\x81\x34", 128},
    {"\xF3\xB6\x9C\x80", "\xDA\x39\x8E\x32", 128},
    {"\xF3\xB6\x9E\x80", "\xDA\x39\x9B\x30", 128},
    {"\xF3\xB6\xA0\x80", "\xDA\x39\xA7\x38", 128},
    {"\xF3\xB6\xA2\x80", "\xDA\x39\xB4\x36", 128},
    {"\xF3\xB6\xA4\x80", "\xDA\x39\xC1\x34", 128},
    {"\xF3\xB6\xA6\x80", "\xDA\x39\xCE\x32", 128},
    {"\xF3\xB6\xA8\x80", "\xDA\x39\xDB\x30", 128},
    {"\xF3\xB6\xAA\x80", "\xDA\x39\xE7\x38", 128},
    {"\xF3\xB6\xAC\x80", "\xDA\x39\xF4\x36", 128},
    {"\xF3\xB6\xAE\x80", "\xDB\x30\x83\x34", 128},
    {"\xF3\xB6\xB0\x80", "\xDB\x30\x90\x32", 128},
    {"\xF3\xB6\xB2\x80", "\xDB\x30\x9D\x30", 128},
    {"\xF3\xB6\xB4\x80", "\xDB\x30\xA9\x38", 128},
    {"\xF3\xB6\xB6\x80", "\xDB\x30\xB6\x36", 128},
    {"\xF3\xB6\xB8\x80", "\xDB\x30\xC3\x34", 128},
    {"\xF3\xB6\xBA\x80", "\xDB\x30\xD0\x32", 128},
    {"\xF3\xB6\xBC\x80", "\xDB\x30\xDD\x30", 128},
    {"\xF3\xB6\xBE\x80", "\xDB\x30\xE9\x38", 128},
    {"\xF3\xB7\x80\x80", "\xDB\x30\xF6\x36", 128},
    {"\xF3\xB7\x82\x80", "\xDB\x31\x85\x34", 128},
    {"\xF3\xB7\x84\x80", "\xDB\x31\x92\x32", 128},
    {"\xF3\xB7\x86\x80", "\xDB\x31\x9F\x30", 128},
    {"\xF3\xB7\x88\x80", "\xDB\x31\xAB\x38", 128},
    {"\xF3\xB7\x8A\x80", "\xDB\x31\xB8\x36", 128},
    {"\xF3\xB7\x8C\x80", "\xDB\x31\xC5\x34", 128},
    {"\xF3\xB7\x8E\x80", "\xDB\x31\xD2\x32", 128},
    {"\xF3\xB7\x90\x80", "\xDB\x31\xDF\x30", 128},
    {"\xF3\xB7\x92\x80", "\xDB\x31\xEB\x38", 128},
    {"\xF3\xB7\x94\x80", "\xDB\x31\xF8\x36", 128},
    {"\xF3\xB7\x96\x80", "\xDB\x32\x87\x34", 128},
    {"\xF3\xB7\x98\x80", "\xDB\x32\x94\x32", 128},
    {"\xF3\xB7\x9A\x80", "\xDB\x32\xA1\x30", 128},
    {"\xF3\xB7\x9C\x80", "\xDB\x32\xAD\x38", 128},
    {"\xF3\xB7\x9E\x80", "\xDB\x32\xBA\x36", 128},
    {"\xF3\xB7\xA0\x80", "\xDB\x32\xC7\x34", 128},
    {"\xF3\xB7\xA2\x80", "\xDB\x32\xD4\x32", 128},
    {"\xF3\xB7\xA4\x80", "\xDB\x32\xE1\x30", 128},
    {"\xF3\xB7\xA6\x80", "\xDB\x32\xED\x38", 128},
    {"\xF3\xB7\xA8\x80", "\xDB\x32\xFA\x36", 128},
    {"\xF3\xB7\xAA\x80", "\xDB\x33\x89\x34", 128},
    {"\xF3\xB7\xAC\x80", "\xDB\x33\x96\x32", 128},
    {"\xF3\xB7\xAE\x80", "\xDB\x33\xA3\x30", 128},
    {"\xF3\xB7\xB0\x80", "\xDB\x33\xAF\x38", 128},
    {"\xF3\xB7\xB2\x80", "\xDB\x33\xBC\x36", 128},
    {"\xF3\xB7\xB4\x80", "\xDB\x33\xC9\x34", 128},
    {"\xF3\xB7\xB6\x80", "\xDB\x33\xD6\x32", 128},
    {"\xF3\xB7\xB8\x80", "\xDB\x33\xE3\x30", 128},
    {"\xF3\xB7\xBA\x80", "\xDB\x33\xEF\x38", 128},
    {"\xF3\xB7\xBC\x80", "\xDB\x33\xFC\x36", 128},
    {"\xF3\xB7\xBE\x80", "\xDB\x34\x8B\x34", 128},
    {"\xF3\xB8\x80\x80", "\xDB\x34\x98\x32", 128},
    {"\xF3\xB8\x82\x80", "\xDB\x34\xA5\x30", 128},
    {"\xF3\xB8\x84\x80", "\xDB\x34\xB1\x38", 128},
    {"\xF3\xB8\x86\x80", "\xDB\x34\xBE\x36", 128},
    {"\xF3\xB8\x88\x80", "\xDB\x34\xCB\x34", 128},
    {"\xF3\xB8\x8A\x80", "\xDB\x34\xD8\x32", 128},
    {"\xF3\xB8\x8C\x80", "\xDB\x34\xE5\x30", 128},
    {"\xF3\xB8\x8E\x80", "\xDB\x34\xF1\x38", 128},
    {"\xF3\xB8\x90\x80", "\xDB\x34\xFE\x36", 128},
    {"\xF3\xB8\x92\x80", "\xDB\x35\x8D\x34", 128},
    {"\xF3\xB8\x94\x80", "\xDB\x35\x9A\x32", 128},
    {"\xF3\xB8\x96\x80", "\xDB\x35\xA7\x30", 128},
    {"\xF3\xB8\x98\x80", "\xDB\x35\xB3\x38", 128},
    {"\xF3\xB8\x9A\x80", "\xDB\x35\xC0\x36", 128},
    {"\xF3\xB8\x9C\x80", "\xDB\x35\xCD\x34", 128},
    {"\xF3\xB8\x9E\x80", "\xDB\x35\xDA\x32", 128},
    {"\xF3\xB8\xA0\x80", "\xDB\x35\xE7\x30", 128},
    {"\xF3\xB8\xA2\x80", "\xDB\x35\xF3\x38", 128},
    {"\xF3\xB8\xA4\x80", "\xDB\x36\x82\x36", 128},
    {"\xF3\xB8\xA6\x80", "\xDB\x36\x8F\x34", 128},
    {"\xF3\xB8\xA8\x80", "\xDB\x36\x9C\x32", 128},
    {"\xF3\xB8\xAA\x80", "\xDB\x36\xA9\x30", 128},
    {"\xF3\xB8\xAC\x80", "\xDB\x36\xB5\x38", 128},
    {"\xF3\xB8\xAE\x80", "\xDB\x36\xC2\x36", 128},
    {"\xF3\xB8\xB0\x80", "\xDB\x36\xCF\x34", 128},
    {"\xF3\xB8\xB2\x80", "\xDB\x36\xDC\x32", 128},
    {"\xF3\xB8\xB4\x80", "\xDB\x36\xE9\x30", 128},
    {"\xF3\xB8\xB6\x80", "\xDB\x36\xF5\x38", 128},
    {"\xF3\xB8\xB8\x80", "\xDB\x37\x84\x36", 128},
    {"\xF3\xB8\xBA\x80", "\xDB\x37\x91\x34", 128},
    {"\xF3\xB8\xBC\x80", "\xDB\x37\x9E\x32", 128},
    {"\xF3\xB8\xBE\x80", "\xDB\x37\xAB\x30", 128},
    {"\xF3\xB9\x80\x80", "\xDB\x37\xB7\x38", 128},
    {"\xF3\xB9\x82\x80", "\xDB\x37\xC4\x36", 128},
    {"\xF3\xB9\x84\x80", "\xDB\x37\xD1\x34", 128},
    {"\xF3\xB9\x86\x80", "\xDB\x37\xDE\x32", 128},
    {"\xF3\xB9\x88\x80", "\xDB\x37\xEB\x30", 128},
    {"\xF3\xB9\x8A\x80", "\xDB\x37\xF7\x38", 128},
    {"\xF3\xB9\x8C\x80", "\xDB\x38\x86\x36", 128},
    {"\xF3\xB9\x8E\x80", "\xDB\x38\x93\x34", 128},
    {"\xF3\xB9\x90\x80", "\xDB\x38\xA0\x32", 128},
    {"\xF3\xB9\x92\x80", "\xDB\x38\xAD\x30", 128},
    {"\xF3\xB9\x94\x80", "\xDB\x38\xB9\x38", 128},
    {"\xF3\xB9\x96\x80", "\xDB\x38\xC6\x36", 128},
    {"\xF3\xB9\x98\x80", "\xDB\x38\xD3\x34", 128},
    {"\xF3\xB9\x9A\x80", "\xDB\x38\xE0\x32", 128},
    {"\xF3\xB9\x9C\x80", "\xDB\x38\xED\x30", 128},
    {"\xF3\xB9\x9E\x80", "\xDB\x38\xF9\x38", 128},
    {"\xF3\xB9\xA0\x80", "\xDB\x39\x88\x36", 128},
    {"\xF3\xB9\xA2\x80", "\xDB\x39\x95\x34", 128},
    {"\xF3\xB9\xA4\x80", "\xDB\x39\xA2\x32", 128},
    {"\xF3\xB9\xA6\x80", "\xDB\x39\xAF\x30", 128},
    {"\xF3\xB9\xA8\x80", "\xDB\x39\xBB\x38", 128},
    {"\xF3\xB9\xAA\x80", "\xDB\x39\xC8\x36", 128},
    {"\xF3\xB9\xAC\x80", "\xDB\x39\xD5\x34", 128},
    {"\xF3\xB9\xAE\x80", "\xDB\x39\xE2\x32", 128},
    {"\xF3\xB9\xB0\x80", "\xDB\x39\xEF\x30", 128},
    {"\xF3\xB9\xB2\x80", "\xDB\x39\xFB\x38", 128},
    {"\xF3\xB9\xB4\x80", "\xDC\x30\x8A\x36", 128},
    {"\xF3\xB9\xB6\x80", "\xDC\x30\x97\x34", 128},
    {"\xF3\xB9\xB8\x80", "\xDC\x30\xA4\x32", 128},
    {"\xF3\xB9\xBA\x80", "\xDC\x30\xB1\x30", 128},
    {"\xF3\xB9\xBC\x80", "\xDC\x30\xBD\x38", 128},
    {"\xF3\xB9\xBE\x80", "\xDC\x30\xCA\x36", 128},
    {"\xF3\xBA\x80\x80", "\xDC\x30\xD7\x34", 128},
    {"\xF3\xBA\x82\x80", "\xDC\x30\xE4\x32", 128},
    {"\xF3\xBA\x84\x80", "\xDC\x30\xF1\x30", 128},
    {"\xF3\xBA\x86\x80", "\xDC\x30\xFD\x38", 128},
    {"\xF3\xBA\x88\x80", "\xDC\x31\x8C\x36", 128},
    {"\xF3\xBA\x8A\x80", "\xDC\x31\x99\x34", 128},
    {"\xF3\xBA\x8C\x80", "\xDC\x31\xA6\x32", 128},
    {"\xF3\xBA\x8E\x80", "\xDC\x31\xB3\x30", 128},
    {"\xF3\xBA\x90\x80", "\xDC\x31\xBF\x38", 128},
    {"\xF3\xBA\x92\x80", "\xDC\x31\xCC\x36", 128},
    {"\xF3\xBA\x94\x80", "\xDC\x31\xD9\x34", 128},
    {"\xF3\xBA\x96\x80", "\xDC\x31\xE6\x32", 128},
    {"\xF3\xBA\x98\x80", "\xDC\x31\xF3\x30", 128},
    {"\xF3\xBA\x9A\x80", "\xDC\x32\x81\x38", 128},
    {"\xF3\xBA\x9C\x80", "\xDC\x32\x8E\x36", 128},
    {"\xF3\xBA\x9E\x80", "\xDC\x32\x9B\x34", 128},
    {"\xF3\xBA\xA0\x80", "\xDC\x32\xA8\x32", 128},
    {"\xF3\xBA\xA2\x80", "\xDC\x32\xB5\x30", 128},
    {"\xF3\xBA\xA4\x80", "\xDC\x32\xC1\x38", 128},
    {"\xF3\xBA\xA6\x80", "\xDC\x32\xCE\x36", 128},
    {"\xF3\xBA\xA8\x80", "\xDC\x32\xDB\x34", 128},
    {"\xF3\xBA\xAA\x80", "\xDC\x32\xE8\x32", 128},
    {"\xF3\xBA\xAC\x80", "\xDC\x32\xF5\x30", 128},
    {"\xF3\xBA\xAE\x80", "\xDC\x33\x83\x38", 128},
    {"\xF3\xBA\xB0\x80", "\xDC\x33\x90\x36", 128},
    {"\xF3\xBA\xB2\x80", "\xDC\x33\x9D\x34", 128},
    {"\xF3\xBA\xB4\x80", "\xDC\x33\xAA\x32", 128},
    {"\xF3\xBA\xB6\x80", "\xDC\x33\xB7\x30", 128},
    {"\xF3\xBA\xB8\x80", "\xDC\x33\xC3\x38", 128},
    {"\xF3\xBA\xBA\x80", "\xDC\x33\xD0\x36", 128},
    {"\xF3\xBA\xBC\x80", "\xDC\x33\xDD\x34", 128},
    {"\xF3\xBA\xBE\x80", "\xDC\x33\xEA\x32", 128},
    {"\xF3\xBB\x80\x80", "\xDC\x33\xF7\x30", 128},
    {"\xF3\xBB\x82\x80", "\xDC\x34\x85\x38", 128},
    {"\xF3\xBB\x84\x80", "\xDC\x34\x92\x36", 128},
    {"\xF3\xBB\x86\x80", "\xDC\x34\x9F\x34", 128},
    {"\xF3\xBB\x88\x80", "\xDC\x34\xAC\x32", 128},
    {"\xF3\xBB\x8A\x80", "\xDC\x34\xB9\x30", 128},
    {"\xF3\xBB\x8C\x80", "\xDC\x34\xC5\x38", 128},
    {"\xF3\xBB\x8E\x80", "\xDC\x34\xD2\x36", 128},
    {"\xF3\xBB\x90\x80", "\xDC\x34\xDF\x34", 128},
    {"\xF3\xBB\x92\x80", "\xDC\x34\xEC\x32", 128},
    {"\xF3\xBB\x94\x80", "\xDC\x34\xF9\x30", 128},
    {"\xF3\xBB\x96\x80", "\xDC\x35\x87\x38", 128},
    {"\xF3\xBB\x98\x80", "\xDC\x35\x94\x36", 128},
    {"\xF3\xBB\x9A\x80", "\xDC\x35\xA1\x34", 128},
    {"\xF3\xBB\x9C\x80", "\xDC\x35\xAE\x32", 128},
    {"\xF3\xBB\x9E\x80", "\xDC\x35\xBB\x30", 128},
    {"\xF3\xBB\xA0\x80", "\xDC\x35\xC7\x38", 128},
    {"\xF3\xBB\xA2\x80", "\xDC\x35\xD4\x36", 128},
    {"\xF3\xBB\xA4\x80", "\xDC\x35\xE1\x34", 128},
    {"\xF3\xBB\xA6\x80", "\xDC\x35\xEE\x32", 128},
    {"\xF3\xBB\xA8\x80", "\xDC\x35\xFB\x30", 128},
    {"\xF3\xBB\xAA\x80", "\xDC\x36\x89\x38", 128},
    {"\xF3\xBB\xAC\x80", "\xDC\x36\x96\x36", 128},
    {"\xF3\xBB\xAE\x80", "\xDC\x36\xA3\x34", 128},
    {"\xF3\xBB\xB0\x80", "\xDC\x36\xB0\x32", 128},
    {"\xF3\xBB\xB2\x80", "\xDC\x36\xBD\x30", 128},
    {"\xF3\xBB\xB4\x80", "\xDC\x36\xC9\x38", 128},
    {"\xF3\xBB\xB6\x80", "\xDC\x36\xD6\x36", 128},
    {"\xF3\xBB\xB8\x80", "\xDC\x36\xE3\x34", 128},
    {"\xF3\xBB\xBA\x80", "\xDC\x36\xF0\x32", 128},
    {"\xF3\xBB\xBC\x80", "\xDC\x36\xFD\x30", 128},
    {"\xF3\xBB\xBE\x80", "\xDC\x37\x8B\x38", 128},
    {"\xF3\xBC\x80\x80", "\xDC\x37\x98\x36", 128},
    {"\xF3\xBC\x82\x80", "\xDC\x37\xA5\x34", 128},
    {"\xF3\xBC\x84\x80", "\xDC\x37\xB2\x32", 128},
    {"\xF3\xBC\x86\x80", "\xDC\x37\xBF\x30", 128},
    {"\xF3\xBC\x88\x80", "\xDC\x37\xCB\x38", 128},
    {"\xF3\xBC\x8A\x80", "\xDC\x37\xD8\x36", 128},
    {"\xF3\xBC\x8C\x80", "\xDC\x37\xE5\x34", 128},
    {"\xF3\xBC\x8E\x80", "\xDC\x37\xF2\x32", 128},
    {"\xF3\xBC\x90\x80", "\xDC\x38\x81\x30", 128},
    {"\xF3\xBC\x92\x80", "\xDC\x38\x8D\x38", 128},
    {"\xF3\xBC\x94\x80", "\xDC\x38\x9A\x36", 128},
    {"\xF3\xBC\x96\x80", "\xDC\x38\xA7\x34", 128},
    {"\xF3\xBC\x98\x80", "\xDC\x38\xB4\x32", 128},
    {"\xF3\xBC\x9A\x80", "\xDC\x38\xC1\x30", 128},
    {"\xF3\xBC\x9C\x80", "\xDC\x38\xCD\x38", 128},
    {"\xF3\xBC\x9E\x80", "\xDC\x38\xDA\x36", 128},
    {"\xF3\xBC\xA0\x80", "\xDC\x38\xE7\x34", 128},
    {"\xF3\xBC\xA2\x80", "\xDC\x38\xF4\x32", 128},
    {"\xF3\xBC\xA4\x80", "\xDC\x39\x83\x30", 128},
    {"\xF3\xBC\xA6\x80", "\xDC\x39\x8F\x38", 128},
    {"\xF3\xBC\xA8\x80", "\xDC\x39\x9C\x36", 128},
    {"\xF3\xBC\xAA\x80", "\xDC\x39\xA9\x34", 128},
    {"\xF3\xBC\xAC\x80", "\xDC\x39\xB6\x32", 128},
    {"\xF3\xBC\xAE\x80", "\xDC\x39\xC3\x30", 128},
    {"\xF3\xBC\xB0\x80", "\xDC\x39\xCF\x38", 128},
    {"\xF3\xBC\xB2\x80", "\xDC\x39\xDC\x36", 128},
    {"\xF3\xBC\xB4\x80", "\xDC\x39\xE9\x34", 128},
    {"\xF3\xBC\xB6\x80", "\xDC\x39\xF6\x32", 128},
    {"\xF3\xBC\xB8\x80", "\xDD\x30\x85\x30", 128},
    {"\xF3\xBC\xBA\x80", "\xDD\x30\x91\x38", 128},
    {"\xF3\xBC\xBC\x80", "\xDD\x30\x9E\x36", 128},
    {"\xF3\xBC\xBE\x80", "\xDD\x30\xAB\x34", 128},
    {"\xF3\xBD\x80\x80", "\xDD\x30\xB8\x32", 128},
    {"\xF3\xBD\x82\x80", "\xDD\x30\xC5\x30", 128},
    {"\xF3\xBD\x84\x80", "\xDD\x30\xD1\x38", 128},
    {"\xF3\xBD\x86\x80", "\xDD\x30\xDE\x36", 128},
    {"\xF3\xBD\x88\x80", "\xDD\x30\xEB\x34", 128},
    {"\xF3\xBD\x8A\x80", "\xDD\x30\xF8\x32", 128},
    {"\xF3\xBD\x8C\x80", "\xDD\x31\x87\x30", 128},
    {"\xF3\xBD\x8E\x80", "\xDD\x31\x93\x38", 128},
    {"\xF3\xBD\x90\x80", "\xDD\x31\xA0\x36", 128},
    {"\xF3\xBD\x92\x80", "\xDD\x31\xAD\x34", 128},
    {"\xF3\xBD\x94\x80", "\xDD\x31\xBA\x32", 128},
    {"\xF3\xBD\x96\x80", "\xDD\x31\xC7\x30", 128},
    {"\xF3\xBD\x98\x80", "\xDD\x31\xD3\x38", 128},
    {"\xF3\xBD\x9A\x80", "\xDD\x31\xE0\x36", 128},
    {"\xF3\xBD\x9C\x80", "\xDD\x31\xED\x34", 128},
    {"\xF3\xBD\x9E\x80", "\xDD\x31\xFA\x32", 128},
    {"\xF3\xBD\xA0\x80", "\xDD\x32\x89\x30", 128},
    {"\xF3\xBD\xA2\x80", "\xDD\x32\x95\x38", 128},
    {"\xF3\xBD\xA4\x80", "\xDD\x32\xA2\x36", 128},
    {"\xF3\xBD\xA6\x80", "\xDD\x32\xAF\x34", 128},
    {"\xF3\xBD\xA8\x80", "\xDD\x32\xBC\x32", 128},
    {"\xF3\xBD\xAA\x80", "\xDD\x32\xC9\x30", 128},
    {"\xF3\xBD\xAC\x80", "\xDD\x32\xD5\x38", 128},
    {"\xF3\xBD\xAE\x80", "\xDD\x32\xE2\x36", 128},
    {"\xF3\xBD\xB0\x80", "\xDD\x32\xEF\x34", 128},
    {"\xF3\xBD\xB2\x80", "\xDD\x32\xFC\x32", 128},
    {"\xF3\xBD\xB4\x80", "\xDD\x33\x8B\x30", 128},
    {"\xF3\xBD\xB6\x80", "\xDD\x33\x97\x38", 128},
    {"\xF3\xBD\xB8\x80", "\xDD\x33\xA4\x36", 128},
    {"\xF3\xBD\xBA\x80", "\xDD\x33\xB1\x34", 128},
    {"\xF3\xBD\xBC\x80", "\xDD\x33\xBE\x32", 128},
    {"\xF3\xBD\xBE\x80", "\xDD\x33\xCB\x30", 128},
    {"\xF3\xBE\x80\x80", "\xDD\x33\xD7\x38", 128},
    {"\xF3\xBE\x82\x80", "\xDD\x33\xE4\x36", 128},
    {"\xF3\xBE\x84\x80", "\xDD\x33\xF1\x34", 128},
    {"\xF3\xBE\x86\x80", "\xDD\x33\xFE\x32", 128},
    {"\xF3\xBE\x88\x80", "\xDD\x34\x8D\x30", 128},
    {"\xF3\xBE\x8A\x80", "\xDD\x34\x99\x38", 128},
    {"\xF3\xBE\x8C\x80", "\xDD\x34\xA6\x36", 128},
    {"\xF3\xBE\x8E\x80", "\xDD\x34\xB3\x34", 128},
    {"\xF3\xBE\x90\x80", "\xDD\x34\xC0\x32", 128},
    {"\xF3\xBE\x92\x80", "\xDD\x34\xCD\x30", 128},
    {"\xF3\xBE\x94\x80", "\xDD\x34\xD9\x38", 128},
    {"\xF3\xBE\x96\x80", "\xDD\x34\xE6\x36", 128},
    {"\xF3\xBE\x98\x80", "\xDD\x34\xF3\x34", 128},
    {"\xF3\xBE\x9A\x80", "\xDD\x35\x82\x32", 128},
    {"\xF3\xBE\x9C\x80", "\xDD\x35\x8F\x30", 128},
    {"\xF3\xBE\x9E\x80", "\xDD\x35\x9B\x38", 128},
    {"\xF3\xBE\xA0\x80", "\xDD\x35\xA8\x36", 128},
    {"\xF3\xBE\xA2\x80", "\xDD\x35\xB5\x34", 128},
    {"\xF3\xBE\xA4\x80", "\xDD\x35\xC2\x32", 128},
    {"\xF3\xBE\xA6\x80", "\xDD\x35\xCF\x30", 128},
    {"\xF3\xBE\xA8\x80", "\xDD\x35\xDB\x38", 128},
    {"\xF3\xBE\xAA\x80", "\xDD\x35\xE8\x36", 128},
    {"\xF3\xBE\xAC\x80", "\xDD\x35\xF5\x34", 128},
    {"\xF3\xBE\xAE\x80", "\xDD\x36\x84\x32", 128},
    {"\xF3\xBE\xB0\x80", "\xDD\x36\x91\x30", 128},
    {"\xF3\xBE\xB2\x80", "\xDD\x36\x9D\x38", 128},
    {"\xF3\xBE\xB4\x80", "\xDD\x36\xAA\x36", 128},
    {"\xF3\xBE\xB6\x80", "\xDD\x36\xB7\x34", 128},
    {"\xF3\xBE\xB8\x80", "\xDD\x36\xC4\x32", 128},
    {"\xF3\xBE\xBA\x80", "\xDD\x36\xD1\x30", 128},
    {"\xF3\xBE\xBC\x80", "\xDD\x36\xDD\x38", 128},
    {"\xF3\xBE\xBE\x80", "\xDD\x36\xEA\x36", 128},
    {"\xF3\xBF\x80\x80", "\xDD\x36\xF7\x34", 128},
    {"\xF3\xBF\x82\x80", "\xDD\x37\x86\x32", 128},
    {"\xF3\xBF\x84\x80", "\xDD\x37\x93\x30", 128},
    {"\xF3\xBF\x86\x80", "\xDD\x37\x9F\x38", 128},
    {"\xF3\xBF\x88\x80", "\xDD\x37\xAC\x36", 128},
    {"\xF3\xBF\x8A\x80", "\xDD\x37\xB9\x34", 128},
    {"\xF3\xBF\x8C\x80", "\xDD\x37\xC6\x32", 128},
    {"\xF3\xBF\x8E\x80", "\xDD\x37\xD3\x30", 128},
    {"\xF3\xBF\x90\x80", "\xDD\x37\xDF\x38", 128},
    {"\xF3\xBF\x92\x80", "\xDD\x37\xEC\x36", 128},
    {"\xF3\xBF\x94\x80", "\xDD\x37\xF9\x34", 128},
    {"\xF3\xBF\x96\x80", "\xDD\x38\x88\x32", 128},
    {"\xF3\xBF\x98\x80", "\xDD\x38\x95\x30", 128},
    {"\xF3\xBF\x9A\x80", "\xDD\x38\xA1\x38", 128},
    {"\xF3\xBF\x9C\x80", "\xDD\x38\xAE\x36", 128},
    {"\xF3\xBF\x9E\x80", "\xDD\x38\xBB\x34", 128},
    {"\xF3\xBF\xA0\x80", "\xDD\x38\xC8\x32", 128},
    {"\xF3\xBF\xA2\x80", "\xDD\x38\xD5\x30", 128},
    {"\xF3\xBF\xA4\x80", "\xDD\x38\xE1\x38", 128},
    {"\xF3\xBF\xA6\x80", "\xDD\x38\xEE\x36", 128},
    {"\xF3\xBF\xA8\x80", "\xDD\x38\xFB\x34", 128},
    {"\xF3\xBF\xAA\x80", "\xDD\x39\x8A\x32", 128},
    {"\xF3\xBF\xAC\x80", "\xDD\x39\x97\x30", 128},
    {"\xF3\xBF\xAE\x80", "\xDD\x39\xA3\x38", 128},
    {"\xF3\xBF\xB0\x80", "\xDD\x39\xB0\x36", 128},
    {"\xF3\xBF\xB2\x80", "\xDD\x39\xBD\x34", 128},
    {"\xF3\xBF\xB4\x80", "\xDD\x39\xCA\x32", 128},
    {"\xF3\xBF\xB6\x80", "\xDD\x39\xD7\x30", 128},
    {"\xF3\xBF\xB8\x80", "\xDD\x39\xE3\x38", 128},
    {"\xF3\xBF\xBA\x80", "\xDD\x39\xF0\x36", 128},
    {"\xF3\xBF\xBC\x80", "\xDD\x39\xFD\x34", 128},
    {"\xF3\xBF\xBE\x80", "\xDE\x30\x8C\x32", 128},
    {"\xF4\x80\x80\x80", "\xDE\x30\x99\x30", 128},
    {"\xF4\x80\x82\x80", "\xDE\x30\xA5\x38", 128},
    {"\xF4\x80\x84\x80", "\xDE\x30\xB2\x36", 128},
    {"\xF4\x80\x86\x80", "\xDE\x30\xBF\x34", 128},
    {"\xF4\x80\x88\x80", "\xDE\x30\xCC\x32", 128},
    {"\xF4\x80\x8A\x80", "\xDE\x30\xD9\x30", 128},
    {"\xF4\x80\x8C\x80", "\xDE\x30\xE5\x38", 128},
    {"\xF4\x80\x8E\x80", "\xDE\x30\xF2\x36", 128},
    {"\xF4\x80\x90\x80", "\xDE\x31\x81\x34", 128},
    {"\xF4\x80\x92\x80", "\xDE\x31\x8E\x32", 128},
    {"\xF4\x80\x94\x80", "\xDE\x31\x9B\x30", 128},
    {"\xF4\x80\x96\x80", "\xDE\x31\xA7\x38", 128},
    {"\xF4\x80\x98\x80", "\xDE\x31\xB4\x36", 128},
    {"\xF4\x80\x9A\x80", "\xDE\x31\xC1\x34", 128},
    {"\xF4\x80\x9C\x80", "\xDE\x31\xCE\x32", 128},
    {"\xF4\x80\x9E\x80", "\xDE\x31\xDB\x30", 128},
    {"\xF4\x80\xA0\x80", "\xDE\x31\xE7\x38", 128},
    {"\xF4\x80\xA2\x80", "\xDE\x31\xF4\x36", 128},
    {"\xF4\x80\xA4\x80", "\xDE\x32\x83\x34", 128},
    {"\xF4\x80\xA6\x80", "\xDE\x32\x90\x32", 128},
    {"\xF4\x80\xA8\x80", "\xDE\x32\x9D\x30", 128},
    {"\xF4\x80\xAA\x80", "\xDE\x32\xA9\x38", 128},
    {"\xF4\x80\xAC\x80", "\xDE\x32\xB6\x36", 128},
    {"\xF4\x80\xAE\x80", "\xDE\x32\xC3\x34", 128},
    {"\xF4\x80\xB0\x80", "\xDE\x32\xD0\x32", 128},
    {"\xF4\x80\xB2\x80", "\xDE\x32\xDD\x30", 128},
    {"\xF4\x80\xB4\x80", "\xDE\x32\xE9\x38", 128},
    {"\xF4\x80\xB6\x80", "\xDE\x32\xF6\x36", 128},
    {"\xF4\x80\xB8\x80", "\xDE\x33\x85\x34", 128},
    {"\xF4\x80\xBA\x80", "\xDE\x33\x92\x32", 128},
    {"\xF4\x80\xBC\x80", "\xDE\x33\x9F\x30", 128},
    {"\xF4\x80\xBE\x80", "\xDE\x33\xAB\x38", 128},
    {"\xF4\x81\x80\x80", "\xDE\x33\xB8\x36", 128},
    {"\xF4\x81\x82\x80", "\xDE\x33\xC5\x34", 128},
    {"\xF4\x81\x84\x80", "\xDE\x33\xD2\x32", 128},
    {"\xF4\x81\x86\x80", "\xDE\x33\xDF\x30", 128},
    {"\xF4\x81\x88\x80", "\xDE\x33\xEB\x38", 128},
    {"\xF4\x81\x8A\x80", "\xDE\x33\xF8\x36", 128},
    {"\xF4\x81\x8C\x80", "\xDE\x34\x87\x34", 128},
    {"\xF4\x81\x8E\x80", "\xDE\x34\x94\x32", 128},
    {"\xF4\x81\x90\x80", "\xDE\x34\xA1\x30", 128},
    {"\xF4\x81\x92\x80", "\xDE\x34\xAD\x38", 128},
    {"\xF4\x81\x94\x80", "\xDE\x34\xBA\x36", 128},
    {"\xF4\x81\x96\x80", "\xDE\x34\xC7\x34", 128},
    {"\xF4\x81\x98\x80", "\xDE\x34\xD4\x32", 128},
    {"\xF4\x81\x9A\x80", "\xDE\x34\xE1\x30", 128},
    {"\xF4\x81\x9C\x80", "\xDE\x34\xED\x38", 128},
    {"\xF4\x81\x9E\x80", "\xDE\x34\xFA\x36", 128},
    {"\xF4\x81\xA0\x80", "\xDE\x35\x89\x34", 128},
    {"\xF4\x81\xA2\x80", "\xDE\x35\x96\x32", 128},
    {"\xF4\x81\xA4\x80", "\xDE\x35\xA3\x30", 128},
    {"\xF4\x81\xA6\x80", "\xDE\x35\xAF\x38", 128},
    {"\xF4\x81\xA8\x80", "\xDE\x35\xBC\x36", 128},
    {"\xF4\x81\xAA\x80", "\xDE\x35\xC9\x34", 128},
    {"\xF4\x81\xAC\x80", "\xDE\x35\xD6\x32", 128},
    {"\xF4\x81\xAE\x80", "\xDE\x35\xE3\x30", 128},
    {"\xF4\x81\xB0\x80", "\xDE\x35\xEF\x38", 128},
    {"\xF4\x81\xB2\x80", "\xDE\x35\xFC\x36", 128},
    {"\xF4\x81\xB4\x80", "\xDE\x36\x8B\x34", 128},
    {"\xF4\x81\xB6\x80", "\xDE\x36\x98\x32", 128},
    {"\xF4\x81\xB8\x80", "\xDE\x36\xA5\x30", 128},
    {"\xF4\x81\xBA\x80", "\xDE\x36\xB1\x38", 128},
    {"\xF4\x81\xBC\x80", "\xDE\x36\xBE\x36", 128},
    {"\xF4\x81\xBE\x80", "\xDE\x36\xCB\x34", 128},
    {"\xF4\x82\x80\x80", "\xDE\x36\xD8\x32", 128},
    {"\xF4\x82\x82\x80", "\xDE\x36\xE5\x30", 128},
    {"\xF4\x82\x84\x80", "\xDE\x36\xF1\x38", 128},
    {"\xF4\x82\x86\x80", "\xDE\x36\xFE\x36", 128},
    {"\xF4\x82\x88\x80", "\xDE\x37\x8D\x34", 128},
    {"\xF4\x82\x8A\x80", "\xDE\x37\x9A\x32", 128},
    {"\xF4\x82\x8C\x80", "\xDE\x37\xA7\x30", 128},
    {"\xF4\x82\x8E\x80", "\xDE\x37\xB3\x38", 128},
    {"\xF4\x82\x90\x80", "\xDE\x37\xC0\x36", 128},
    {"\xF4\x82\x92\x80", "\xDE\x37\xCD\x34", 128},
    {"\xF4\x82\x94\x80", "\xDE\x37\xDA\x32", 128},
    {"\xF4\x82\x96\x80", "\xDE\x37\xE7\x30", 128},
    {"\xF4\x82\x98\x80", "\xDE\x37\xF3\x38", 128},
    {"\xF4\x82\x9A\x80", "\xDE\x38\x82\x36", 128},
    {"\xF4\x82\x9C\x80", "\xDE\x38\x8F\x34", 128},
    {"\xF4\x82\x9E\x80", "\xDE\x38\x9C\x32", 128},
    {"\xF4\x82\xA0\x80", "\xDE\x38\xA9\x30", 128},
    {"\xF4\x82\xA2\x80", "\xDE\x38\xB5\x38", 128},
    {"\xF4\x82\xA4\x80", "\xDE\x38\xC2\x36", 128},
    {"\xF4\x82\xA6\x80", "\xDE\x38\xCF\x34", 128},
    {"\xF4\x82\xA8\x80", "\xDE\x38\xDC\x32", 128},
    {"\xF4\x82\xAA\x80", "\xDE\x38\xE9\x30", 128},
    {"\xF4\x82\xAC\x80", "\xDE\x38\xF5\x38", 128},
    {"\xF4\x82\xAE\x80", "\xDE\x39\x84\x36", 128},
    {"\xF4\x82\xB0\x80", "\xDE\x39\x91\x34", 128},
    {"\xF4\x82\xB2\x80", "\xDE\x39\x9E\x32", 128},
    {"\xF4\x82\xB4\x80", "\xDE\x39\xAB\x30", 128},
    {"\xF4\x82\xB6\x80", "\xDE\x39\xB7\x38", 128},
    {"\xF4\x82\xB8\x80", "\xDE\x39\xC4\x36", 128},
    {"\xF4\x82\xBA\x80", "\xDE\x39\xD1\x34", 128},
    {"\xF4\x82\xBC\x80", "\xDE\x39\xDE\x32", 128},
    {"\xF4\x82\xBE\x80", "\xDE\x39\xEB\x30", 128},
    {"\xF4\x83\x80\x80", "\xDE\x39\xF7\x38", 128},
    {"\xF4\x83\x82\x80", "\xDF\x30\x86\x36", 128},
    {"\xF4\x83\x84\x80", "\xDF\x30\x93\x34", 128},
    {"\xF4\x83\x86\x80", "\xDF\x30\xA0\x32", 128},
    {"\xF4\x83\x88\x80", "\xDF\x30\xAD\x30", 128},
    {"\xF4\x83\x8A\x80", "\xDF\x30\xB9\x38", 128},
    {"\xF4\x83\x8C\x80", "\xDF\x30\xC6\x36", 128},
    {"\xF4\x83\x8E\x80", "\xDF\x30\xD3\x34", 128},
    {"\xF4\x83\x90\x80", "\xDF\x30\xE0\x32", 128},
    {"\xF4\x83\x92\x80", "\xDF\x30\xED\x30", 128},
    {"\xF4\x83\x94\x80", "\xDF\x30\xF9\x38", 128},
    {"\xF4\x83\x96\x80", "\xDF\x31\x88\x36", 128},
    {"\xF4\x83\x98\x80", "\xDF\x31\x95\x34", 128},
    {"\xF4\x83\x9A\x80", "\xDF\x31\xA2\x32", 128},
    {"\xF4\x83\x9C\x80", "\xDF\x31\xAF\x30", 128},
    {"\xF4\x83\x9E\x80", "\xDF\x31\xBB\x38", 128},
    {"\xF4\x83\xA0\x80", "\xDF\x31\xC8\x36", 128},
    {"\xF4\x83\xA2\x80", "\xDF\x31\xD5\x34", 128},
    {"\xF4\x83\xA4\x80", "\xDF\x31\xE2\x32", 128},
    {"\xF4\x83\xA6\x80", "\xDF\x31\xEF\x30", 128},
    {"\xF4\x83\xA8\x80", "\xDF\x31\xFB\x38", 128},
    {"\xF4\x83\xAA\x80", "\xDF\x32\x8A\x36", 128},
    {"\xF4\x83\xAC\x80", "\xDF\x32\x97\x34", 128},
    {"\xF4\x83\xAE\x80", "\xDF\x32\xA4\x32", 128},
    {"\xF4\x83\xB0\x80", "\xDF\x32\xB1\x30", 128},
    {"\xF4\x83\xB2\x80", "\xDF\x32\xBD\x38", 128},
    {"\xF4\x83\xB4\x80", "\xDF\x32\xCA\x36", 128},
    {"\xF4\x83\xB6\x80", "\xDF\x32\xD7\x34", 128},
    {"\xF4\x83\xB8\x80", "\xDF\x32\xE4\x32", 128},
    {"\xF4\x83\xBA\x80", "\xDF\x32\xF1\x30", 128},
    {"\xF4\x83\xBC\x80", "\xDF\x32\xFD\x38", 128},
    {"\xF4\x83\xBE\x80", "\xDF\x33\x8C\x36", 128},
    {"\xF4\x84\x80\x80", "\xDF\x33\x99\x34", 128},
    {"\xF4\x84\x82\x80", "\xDF\x33\xA6\x32", 128},
    {"\xF4\x84\x84\x80", "\xDF\x33\xB3\x30", 128},
    {"\xF4\x84\x86\x80", "\xDF\x33\xBF\x38", 128},
    {"\xF4\x84\x88\x80", "\xDF\x33\xCC\x36", 128},
    {"\xF4\x84\x8A\x80", "\xDF\x33\xD9\x34", 128},
    {"\xF4\x84\x8C\x80", "\xDF\x33\xE6\x32", 128},
    {"\xF4\x84\x8E\x80", "\xDF\x33\xF3\x30", 128},
    {"\xF4\x84\x90\x80", "\xDF\x34\x81\x38", 128},
    {"\xF4\x84\x92\x80", "\xDF\x34\x8E\x36", 128},
    {"\xF4\x84\x94\x80", "\xDF\x34\x9B\x34", 128},
    {"\xF4\x84\x96\x80", "\xDF\x34\xA8\x32", 128},
    {"\xF4\x84\x98\x80", "\xDF\x34\xB5\x30", 128},
    {"\xF4\x84\x9A\x80", "\xDF\x34\xC1\x38", 128},
    {"\xF4\x84\x9C\x80", "\xDF\x34\xCE\x36", 128},
    {"\xF4\x84\x9E\x80", "\xDF\x34\xDB\x34", 128},
    {"\xF4\x84\xA0\x80", "\xDF\x34\xE8\x32", 128},
    {"\xF4\x84\xA2\x80", "\xDF\x34\xF5\x30", 128},
    {"\xF4\x84\xA4\x80", "\xDF\x35\x83\x38", 128},
    {"\xF4\x84\xA6\x80", "\xDF\x35\x90\x36", 128},
    {"\xF4\x84\xA8\x80", "\xDF\x35\x9D\x34", 128},
    {"\xF4\x84\xAA\x80", "\xDF\x35\xAA\x32", 128},
    {"\xF4\x84\xAC\x80", "\xDF\x35\xB7\x30", 128},
    {"\xF4\x84\xAE\x80", "\xDF\x35\xC3\x38", 128},
    {"\xF4\x84\xB0\x80", "\xDF\x35\xD0\x36", 128},
    {"\xF4\x84\xB2\x80", "\xDF\x35\xDD\x34", 128},
    {"\xF4\x84\xB4\x80", "\xDF\x35\xEA\x32", 128},
    {"\xF4\x84\xB6\x80", "\xDF\x35\xF7\x30", 128},
    {"\xF4\x84\xB8\x80", "\xDF\x36\x85\x38", 128},
    {"\xF4\x84\xBA\x80", "\xDF\x36\x92\x36", 128},
    {"\xF4\x84\xBC\x80", "\xDF\x36\x9F\x34", 128},
    {"\xF4\x84\xBE\x80", "\xDF\x36\xAC\x32", 128},
    {"\xF4\x85\x80\x80", "\xDF\x36\xB9\x30", 128},
    {"\xF4\x85\x82\x80", "\xDF\x36\xC5\x38", 128},
    {"\xF4\x85\x84\x80", "\xDF\x36\xD2\x36", 128},
    {"\xF4\x85\x86\x80", "\xDF\x36\xDF\x34", 128},
    {"\xF4\x85\x88\x80", "\xDF\x36\xEC\x32", 128},
    {"\xF4\x85\x8A\x80", "\xDF\x36\xF9\x30", 128},
    {"\xF4\x85\x8C\x80", "\xDF\x37\x87\x38", 128},
    {"\xF4\x85\x8E\x80", "\xDF\x37\x94\x36", 128},
    {"\xF4\x85\x90\x80", "\xDF\x37\xA1\x34", 128},
    {"\xF4\x85\x92\x80", "\xDF\x37\xAE\x32", 128},
    {"\xF4\x85\x94\x80", "\xDF\x37\xBB\x30", 128},
    {"\xF4\x85\x96\x80", "\xDF\x37\xC7\x38", 128},
    {"\xF4\x85\x98\x80", "\xDF\x37\xD4\x36", 128},
    {"\xF4\x85\x9A\x80", "\xDF\x37\xE1\x34", 128},
    {"\xF4\x85\x9C\x80", "\xDF\x37\xEE\x32", 128},
    {"\xF4\x85\x9E\x80", "\xDF\x37\xFB\x30", 128},
    {"\xF4\x85\xA0\x80", "\xDF\x38\x89\x38", 128},
    {"\xF4\x85\xA2\x80", "\xDF\x38\x96\x36", 128},
    {"\xF4\x85\xA4\x80", "\xDF\x38\xA3\x34", 128},
    {"\xF4\x85\xA6\x80", "\xDF\x38\xB0\x32", 128},
    {"\xF4\x85\xA8\x80", "\xDF\x38\xBD\x30", 128},
    {"\xF4\x85\xAA\x80", "\xDF\x38\xC9\x38", 128},
    {"\xF4\x85\xAC\x80", "\xDF\x38\xD6\x36", 128},
    {"\xF4\x85\xAE\x80", "\xDF\x38\xE3\x34", 128},
    {"\xF4\x85\xB0\x80", "\xDF\x38\xF0\x32", 128},
    {"\xF4\x85\xB2\x80", "\xDF\x38\xFD\x30", 128},
    {"\xF4\x85\xB4\x80", "\xDF\x39\x8B\x38", 128},
    {"\xF4\x85\xB6\x80", "\xDF\x39\x98\x36", 128},
    {"\xF4\x85\xB8\x80", "\xDF\x39\xA5\x34", 128},
    {"\xF4\x85\xBA\x80", "\xDF\x39\xB2\x32", 128},
    {"\xF4\x85\xBC\x80", "\xDF\x39\xBF\x30", 128},
    {"\xF4\x85\xBE\x80", "\xDF\x39\xCB\x38", 128},
    {"\xF4\x86\x80\x80", "\xDF\x39\xD8\x36", 128},
    {"\xF4\x86\x82\x80", "\xDF\x39\xE5\x34", 128},
    {"\xF4\x86\x84\x80", "\xDF\x39\xF2\x32", 128},
    {"\xF4\x86\x86\x80", "\xE0\x30\x81\x30", 128},
    {"\xF4\x86\x88\x80", "\xE0\x30\x8D\x38", 128},
    {"\xF4\x86\x8A\x80", "\xE0\x30\x9A\x36", 128},
    {"\xF4\x86\x8C\x80", "\xE0\x30\xA7\x34", 128},
    {"\xF4\x86\x8E\x80", "\xE0\x30\xB4\x32", 128},
    {"\xF4\x86\x90\x80", "\xE0\x30\xC1\x30", 128},
    {"\xF4\x86\x92\x80", "\xE0\x30\xCD\x38", 128},
    {"\xF4\x86\x94\x80", "\xE0\x30\xDA\x36", 128},
    {"\xF4\x86\x96\x80", "\xE0\x30\xE7\x34", 128},
    {"\xF4\x86\x98\x80", "\xE0\x30\xF4\x32", 128},
    {"\xF4\x86\x9A\x80", "\xE0\x31\x83\x30", 128},
    {"\xF4\x86\x9C\x80", "\xE0\x31\x8F\x38", 128},
    {"\xF4\x86\x9E\x80", "\xE0\x31\x9C\x36", 128},
    {"\xF4\x86\xA0\x80", "\xE0\x31\xA9\x34", 128},
    {"\xF4\x86\xA2\x80", "\xE0\x31\xB6\x32", 128},
    {"\xF4\x86\xA4\x80", "\xE0\x31\xC3\x30", 128},
    {"\xF4\x86\xA6\x80", "\xE0\x31\xCF\x38", 128},
    {"\xF4\x86\xA8\x80", "\xE0\x31\xDC\x36", 128},
    {"\xF4\x86\xAA\x80", "\xE0\x31\xE9\x34", 128},
    {"\xF4\x86\xAC\x80", "\xE0\x31\xF6\x32", 128},
    {"\xF4\x86\xAE\x80", "\xE0\x32\x85\x30", 128},
    {"\xF4\x86\xB0\x80", "\xE0\x32\x91\x38", 128},
    {"\xF4\x86\xB2\x80", "\xE0\x32\x9E\x36", 128},
    {"\xF4\x86\xB4\x80", "\xE0\x32\xAB\x34", 128},
    {"\xF4\x86\xB6\x80", "\xE0\x32\xB8\x32", 128},
    {"\xF4\x86\xB8\x80", "\xE0\x32\xC5\x30", 128},
    {"\xF4\x86\xBA\x80", "\xE0\x32\xD1\x38", 128},
    {"\xF4\x86\xBC\x80", "\xE0\x32\xDE\x36", 128},
    {"\xF4\x86\xBE\x80", "\xE0\x32\xEB\x34", 128},
    {"\xF4\x87\x80\x80", "\xE0\x32\xF8\x32", 128},
    {"\xF4\x87\x82\x80", "\xE0\x33\x87\x30", 128},
    {"\xF4\x87\x84\x80", "\xE0\x33\x93\x38", 128},
    {"\xF4\x87\x86\x80", "\xE0\x33\xA0\x36", 128},
    {"\xF4\x87\x88\x80", "\xE0\x33\xAD\x34", 128},
    {"\xF4\x87\x8A\x80", "\xE0\x33\xBA\x32", 128},
    {"\xF4\x87\x8C\x80", "\xE0\x33\xC7\x30", 128},
    {"\xF4\x87\x8E\x80", "\xE0\x33\xD3\x38", 128},
    {"\xF4\x87\x90\x80", "\xE0\x33\xE0\x36", 128},
    {"\xF4\x87\x92\x80", "\xE0\x33\xED\x34", 128},
    {"\xF4\x87\x94\x80", "\xE0\x33\xFA\x32", 128},
    {"\xF4\x87\x96\x80", "\xE0\x34\x89\x30", 128},
    {"\xF4\x87\x98\x80", "\xE0\x34\x95\x38", 128},
    {"\xF4\x87\x9A\x80", "\xE0\x34\xA2\x36", 128},
    {"\xF4\x87\x9C\x80", "\xE0\x34\xAF\x34", 128},
    {"\xF4\x87\x9E\x80", "\xE0\x34\xBC\x32", 128},
    {"\xF4\x87\xA0\x80", "\xE0\x34\xC9\x30", 128},
    {"\xF4\x87\xA2\x80", "\xE0\x34\xD5\x38", 128},
    {"\xF4\x87\xA4\x80", "\xE0\x34\xE2\x36", 128},
    {"\xF4\x87\xA6\x80", "\xE0\x34\xEF\x34", 128},
    {"\xF4\x87\xA8\x80", "\xE0\x34\xFC\x32", 128},
    {"\xF4\x87\xAA\x80", "\xE0\x35\x8B\x30", 128},
    {"\xF4\x87\xAC\x80", "\xE0\x35\x97\x38", 128},
    {"\xF4\x87\xAE\x80", "\xE0\x35\xA4\x36", 128},
    {"\xF4\x87\xB0\x80", "\xE0\x35\xB1\x34", 128},
    {"\xF4\x87\xB2\x80", "\xE0\x35\xBE\x32", 128},
    {"\xF4\x87\xB4\x80", "\xE0\x35\xCB\x30", 128},
    {"\xF4\x87\xB6\x80", "\xE0\x35\xD7\x38", 128},
    {"\xF4\x87\xB8\x80", "\xE0\x35\xE4\x36", 128},
    {"\xF4\x87\xBA\x80", "\xE0\x35\xF1\x34", 128},
    {"\xF4\x87\xBC\x80", "\xE0\x35\xFE\x32", 128},
    {"\xF4\x87\xBE\x80", "\xE0\x36\x8D\x30", 128},
    {"\xF4\x88\x80\x80", "\xE0\x36\x99\x38", 128},
    {"\xF4\x88\x82\x80", "\xE0\x36\xA6\x36", 128},
    {"\xF4\x88\x84\x80", "\xE0\x36\xB3\x34", 128},
    {"\xF4\x88\x86\x80", "\xE0\x36\xC0\x32", 128},
    {"\xF4\x88\x88\x80", "\xE0\x36\xCD\x30", 128},
    {"\xF4\x88\x8A\x80", "\xE0\x36\xD9\x38", 128},
    {"\xF4\x88\x8C\x80", "\xE0\x36\xE6\x36", 128},
    {"\xF4\x88\x8E\x80", "\xE0\x36\xF3\x34", 128},
    {"\xF4\x88\x90\x80", "\xE0\x37\x82\x32", 128},
    {"\xF4\x88\x92\x80", "\xE0\x37\x8F\x30", 128},
    {"\xF4\x88\x94\x80", "\xE0\x37\x9B\x38", 128},
    {"\xF4\x88\x96\x80", "\xE0\x37\xA8\x36", 128},
    {"\xF4\x88\x98\x80", "\xE0\x37\xB5\x34", 128},
    {"\xF4\x88\x9A\x80", "\xE0\x37\xC2\x32", 128},
    {"\xF4\x88\x9C\x80", "\xE0\x37\xCF\x30", 128},
    {"\xF4\x88\x9E\x80", "\xE0\x37\xDB\x38", 128},
    {"\xF4\x88\xA0\x80", "\xE0\x37\xE8\x36", 128},
    {"\xF4\x88\xA2\x80", "\xE0\x37\xF5\x34", 128},
    {"\xF4\x88\xA4\x80", "\xE0\x38\x84\x32", 128},
    {"\xF4\x88\xA6\x80", "\xE0\x38\x91\x30", 128},
    {"\xF4\x88\xA8\x80", "\xE0\x38\x9D\x38", 128},
    {"\xF4\x88\xAA\x80", "\xE0\x38\xAA\x36", 128},
    {"\xF4\x88\xAC\x80", "\xE0\x38\xB7\x34", 128},
    {"\xF4\x88\xAE\x80", "\xE0\x38\xC4\x32", 128},
    {"\xF4\x88\xB0\x80", "\xE0\x38\xD1\x30", 128},
    {"\xF4\x88\xB2\x80", "\xE0\x38\xDD\x38", 128},
    {"\xF4\x88\xB4\x80", "\xE0\x38\xEA\x36", 128},
    {"\xF4\x88\xB6\x80", "\xE0\x38\xF7\x34", 128},
    {"\xF4\x88\xB8\x80", "\xE0\x39\x86\x32", 128},
    {"\xF4\x88\xBA\x80", "\xE0\x39\x93\x30", 128},
    {"\xF4\x88\xBC\x80", "\xE0\x39\x9F\x38", 128},
    {"\xF4\x88\xBE\x80", "\xE0\x39\xAC\x36", 128},
    {"\xF4\x89\x80\x80", "\xE0\x39\xB9\x34", 128},
    {"\xF4\x89\x82\x80", "\xE0\x39\xC6\x32", 128},
    {"\xF4\x89\x84\x80", "\xE0\x39\xD3\x30", 128},
    {"\xF4\x89\x86\x80", "\xE0\x39\xDF\x38", 128},
    {"\xF4\x89\x88\x80", "\xE0\x39\xEC\x36", 128},
    {"\xF4\x89\x8A\x80", "\xE0\x39\xF9\x34", 128},
    {"\xF4\x89\x8C\x80", "\xE1\x30\x88\x32", 128},
    {"\xF4\x89\x8E\x80", "\xE1\x30\x95\x30", 128},
    {"\xF4\x89\x90\x80", "\xE1\x30\xA1\x38", 128},
    {"\xF4\x89\x92\x80", "\xE1\x30\xAE\x36", 128},
    {"\xF4\x89\x94\x80", "\xE1\x30\xBB\x34", 128},
    {"\xF4\x89\x96\x80", "\xE1\x30\xC8\x32", 128},
    {"\xF4\x89\x98\x80", "\xE1\x30\xD5\x30", 128},
    {"\xF4\x89\x9A\x80", "\xE1\x30\xE1\x38", 128},
    {"\xF4\x89\x9C\x80", "\xE1\x30\xEE\x36", 128},
    {"\xF4\x89\x9E\x80", "\xE1\x30\xFB\x34", 128},
    {"\xF4\x89\xA0\x80", "\xE1\x31\x8A\x32", 128},
    {"\xF4\x89\xA2\x80", "\xE1\x31\x97\x30", 128},
    {"\xF4\x89\xA4\x80", "\xE1\x31\xA3\x38", 128},
    {"\xF4\x89\xA6\x80", "\xE1\x31\xB0\x36", 128},
    {"\xF4\x89\xA8\x80", "\xE1\x31\xBD\x34", 128},
    {"\xF4\x89\xAA\x80", "\xE1\x31\xCA\x32", 128},
    {"\xF4\x89\xAC\x80", "\xE1\x31\xD7\x30", 128},
    {"\xF4\x89\xAE\x80", "\xE1\x31\xE3\x38", 128},
    {"\xF4\x89\xB0\x80", "\xE1\x31\xF0\x36", 128},
    {"\xF4\x89\xB2\x80", "\xE1\x31\xFD\x34", 128},
    {"\xF4\x89\xB4\x80", "\xE1\x32\x8C\x32", 128},
    {"\xF4\x89\xB6\x80", "\xE1\x32\x99\x30", 128},
    {"\xF4\x89\xB8\x80", "\xE1\x32\xA5\x38", 128},
    {"\xF4\x89\xBA\x80", "\xE1\x32\xB2\x36", 128},
    {"\xF4\x89\xBC\x80", "\xE1\x32\xBF\x34", 128},
    {"\xF4\x89\xBE\x80", "\xE1\x32\xCC\x32", 128},
    {"\xF4\x8A\x80\x80", "\xE1\x32\xD9\x30", 128},
    {"\xF4\x8A\x82\x80", "\xE1\x32\xE5\x38", 128},
    {"\xF4\x8A\x84\x80", "\xE1\x32\xF2\x36", 128},
    {"\xF4\x8A\x86\x80", "\xE1\x33\x81\x34", 128},
    {"\xF4\x8A\x88\x80", "\xE1\x33\x8E\x32", 128},
    {"\xF4\x8A\x8A\x80", "\xE1\x33\x9B\x30", 128},
    {"\xF4\x8A\x8C\x80", "\xE1\x33\xA7\x38", 128},
    {"\xF4\x8A\x8E\x80", "\xE1\x33\xB4\x36", 128},
    {"\xF4\x8A\x90\x80", "\xE1\x33\xC1\x34", 128},
    {"\xF4\x8A\x92\x80", "\xE1\x33\xCE\x32", 128},
    {"\xF4\x8A\x94\x80", "\xE1\x33\xDB\x30", 128},
    {"\xF4\x8A\x96\x80", "\xE1\x33\xE7\x38", 128},
    {"\xF4\x8A\x98\x80", "\xE1\x33\xF4\x36", 128},
    {"\xF4\x8A\x9A\x80", "\xE1\x34\x83\x34", 128},
    {"\xF4\x8A\x9C\x80", "\xE1\x34\x90\x32", 128},
    {"\xF4\x8A\x9E\x80", "\xE1\x34\x9D\x30", 128},
    {"\xF4\x8A\xA0\x80", "\xE1\x34\xA9\x38", 128},
    {"\xF4\x8A\xA2\x80", "\xE1\x34\xB6\x36", 128},
    {"\xF4\x8A\xA4\x80", "\xE1\x34\xC3\x34", 128},
    {"\xF4\x8A\xA6\x80", "\xE1\x34\xD0\x32", 128},
    {"\xF4\x8A\xA8\x80", "\xE1\x34\xDD\x30", 128},
    {"\xF4\x8A\xAA\x80", "\xE1\x34\xE9\x38", 128},
    {"\xF4\x8A\xAC\x80", "\xE1\x34\xF6\x36", 128},
    {"\xF4\x8A\xAE\x80", "\xE1\x35\x85\x34", 128},
    {"\xF4\x8A\xB0\x80", "\xE1\x35\x92\x32", 128},
    {"\xF4\x8A\xB2\x80", "\xE1\x35\x9F\x30", 128},
    {"\xF4\x8A\xB4\x80", "\xE1\x35\xAB\x38", 128},
    {"\xF4\x8A\xB6\x80", "\xE1\x35\xB8\x36", 128},
    {"\xF4\x8A\xB8\x80", "\xE1\x35\xC5\x34", 128},
    {"\xF4\x8A\xBA\x80", "\xE1\x35\xD2\x32", 128},
    {"\xF4\x8A\xBC\x80", "\xE1\x35\xDF\x30", 128},
    {"\xF4\x8A\xBE\x80", "\xE1\x35\xEB\x38", 128},
    {"\xF4\x8B\x80\x80", "\xE1\x35\xF8\x36", 128},
    {"\xF4\x8B\x82\x80", "\xE1\x36\x87\x34", 128},
    {"\xF4\x8B\x84\x80", "\xE1\x36\x94\x32", 128},
    {"\xF4\x8B\x86\x80", "\xE1\x36\xA1\x30", 128},
    {"\xF4\x8B\x88\x80", "\xE1\x36\xAD\x38", 128},
    {"\xF4\x8B\x8A\x80", "\xE1\x36\xBA\x36", 128},
    {"\xF4\x8B\x8C\x80", "\xE1\x36\xC7\x34", 128},
    {"\xF4\x8B\x8E\x80", "\xE1\x36\xD4\x32", 128},
    {"\xF4\x8B\x90\x80", "\xE1\x36\xE1\x30", 128},
    {"\xF4\x8B\x92\x80", "\xE1\x36\xED\x38", 128},
    {"\xF4\x8B\x94\x80", "\xE1\x36\xFA\x36", 128},
    {"\xF4\x8B\x96\x80", "\xE1\x37\x89\x34", 128},
    {"\xF4\x8B\x98\x80", "\xE1\x37\x96\x32", 128},
    {"\xF4\x8B\x9A\x80", "\xE1\x37\xA3\x30", 128},
    {"\xF4\x8B\x9C\x80", "\xE1\x37\xAF\x38", 128},
    {"\xF4\x8B\x9E\x80", "\xE1\x37\xBC\x36", 128},
    {"\xF4\x8B\xA0\x80", "\xE1\x37\xC9\x34", 128},
    {"\xF4\x8B\xA2\x80", "\xE1\x37\xD6\x32", 128},
    {"\xF4\x8B\xA4\x80", "\xE1\x37\xE3\x30", 128},
    {"\xF4\x8B\xA6\x80", "\xE1\x37\xEF\x38", 128},
    {"\xF4\x8B\xA8\x80", "\xE1\x37\xFC\x36", 128},
    {"\xF4\x8B\xAA\x80", "\xE1\x38\x8B\x34", 128},
    {"\xF4\x8B\xAC\x80", "\xE1\x38\x98\x32", 128},
    {"\xF4\x8B\xAE\x80", "\xE1\x38\xA5\x30", 128},
    {"\xF4\x8B\xB0\x80", "\xE1\x38\xB1\x38", 128},
    {"\xF4\x8B\xB2\x80", "\xE1\x38\xBE\x36", 128},
    {"\xF4\x8B\xB4\x80", "\xE1\x38\xCB\x34", 128},
    {"\xF4\x8B\xB6\x80", "\xE1\x38\xD8\x32", 128},
    {"\xF4\x8B\xB8\x80", "\xE1\x38\xE5\x30", 128},
    {"\xF4\x8B\xBA\x80", "\xE1\x38\xF1\x38", 128},
    {"\xF4\x8B\xBC\x80", "\xE1\x38\xFE\x36", 128},
    {"\xF4\x8B\xBE\x80", "\xE1\x39\x8D\x34", 128},
    {"\xF4\x8C\x80\x80", "\xE1\x39\x9A\x32", 128},
    {"\xF4\x8C\x82\x80", "\xE1\x39\xA7\x30", 128},
    {"\xF4\x8C\x84\x80", "\xE1\x39\xB3\x38", 128},
    {"\xF4\x8C\x86\x80", "\xE1\x39\xC0\x36", 128},
    {"\xF4\x8C\x88\x80", "\xE1\x39\xCD\x34", 128},
    {"\xF4\x8C\x8A\x80", "\xE1\x39\xDA\x32", 128},
    {"\xF4\x8C\x8C\x80", "\xE1\x39\xE7\x30", 128},
    {"\xF4\x8C\x8E\x80", "\xE1\x39\xF3\x38", 128},
    {"\xF4\x8C\x90\x80", "\xE2\x30\x82\x36", 128},
    {"\xF4\x8C\x92\x80", "\xE2\x30\x8F\x34", 128},
    {"\xF4\x8C\x94\x80", "\xE2\x30\x9C\x32", 128},
    {"\xF4\x8C\x96\x80", "\xE2\x30\xA9\x30", 128},
    {"\xF4\x8C\x98\x80", "\xE2\x30\xB5\x38", 128},
    {"\xF4\x8C\x9A\x80", "\xE2\x30\xC2\x36", 128},
    {"\xF4\x8C\x9C\x80", "\xE2\x30\xCF\x34", 128},
    {"\xF4\x8C\x9E\x80", "\xE2\x30\xDC\x32", 128},
    {"\xF4\x8C\xA0\x80", "\xE2\x30\xE9\x30", 128},
    {"\xF4\x8C\xA2\x80", "\xE2\x30\xF5\x38", 128},
    {"\xF4\x8C\xA4\x80", "\xE2\x31\x84\x36", 128},
    {"\xF4\x8C\xA6\x80", "\xE2\x31\x91\x34", 128},
    {"\xF4\x8C\xA8\x80", "\xE2\x31\x9E\x32", 128},
    {"\xF4\x8C\xAA\x80", "\xE2\x31\xAB\x30", 128},
    {"\xF4\x8C\xAC\x80", "\xE2\x31\xB7\x38", 128},
    {"\xF4\x8C\xAE\x80", "\xE2\x31\xC4\x36", 128},
    {"\xF4\x8C\xB0\x80", "\xE2\x31\xD1\x34", 128},
    {"\xF4\x8C\xB2\x80", "\xE2\x31\xDE\x32", 128},
    {"\xF4\x8C\xB4\x80", "\xE2\x31\xEB\x30", 128},
    {"\xF4\x8C\xB6\x80", "\xE2\x31\xF7\x38", 128},
    {"\xF4\x8C\xB8\x80", "\xE2\x32\x86\x36", 128},
    {"\xF4\x8C\xBA\x80", "\xE2\x32\x93\x34", 128},
    {"\xF4\x8C\xBC\x80", "\xE2\x32\xA0\x32", 128},
    {"\xF4\x8C\xBE\x80", "\xE2\x32\xAD\x30", 128},
    {"\xF4\x8D\x80\x80", "\xE2\x32\xB9\x38", 128},
    {"\xF4\x8D\x82\x80", "\xE2\x32\xC6\x36", 128},
    {"\xF4\x8D\x84\x80", "\xE2\x32\xD3\x34", 128},
    {"\xF4\x8D\x86\x80", "\xE2\x32\xE0\x32", 128},
    {"\xF4\x8D\x88\x80", "\xE2\x32\xED\x30", 128},
    {"\xF4\x8D\x8A\x80", "\xE2\x32\xF9\x38", 128},
    {"\xF4\x8D\x8C\x80", "\xE2\x33\x88\x36", 128},
    {"\xF4\x8D\x8E\x80", "\xE2\x33\x95\x34", 128},
    {"\xF4\x8D\x90\x80", "\xE2\x33\xA2\x32", 128},
    {"\xF4\x8D\x92\x80", "\xE2\x33\xAF\x30", 128},
    {"\xF4\x8D\x94\x80", "\xE2\x33\xBB\x38", 128},
    {"\xF4\x8D\x96\x80", "\xE2\x33\xC8\x36", 128},
    {"\xF4\x8D\x98\x80", "\xE2\x33\xD5\x34", 128},
    {"\xF4\x8D\x9A\x80", "\xE2\x33\xE2\x32", 128},
    {"\xF4\x8D\x9C\x80", "\xE2\x33\xEF\x30", 128},
    {"\xF4\x8D\x9E\x80", "\xE2\x33\xFB\x38", 128},
    {"\xF4\x8D\xA0\x80", "\xE2\x34\x8A\x36", 128},
    {"\xF4\x8D\xA2\x80", "\xE2\x34\x97\x34", 128},
    {"\xF4\x8D\xA4\x80", "\xE2\x34\xA4\x32", 128},
    {"\xF4\x8D\xA6\x80", "\xE2\x34\xB1\x30", 128},
    {"\xF4\x8D\xA8\x80", "\xE2\x34\xBD\x38", 128},
    {"\xF4\x8D\xAA\x80", "\xE2\x34\xCA\x36", 128},
    {"\xF4\x8D\xAC\x80", "\xE2\x34\xD7\x34", 128},
    {"\xF4\x8D\xAE\x80", "\xE2\x34\xE4\x32", 128},
    {"\xF4\x8D\xB0\x80", "\xE2\x34\xF1\x30", 128},
    {"\xF4\x8D\xB2\x80", "\xE2\x34\xFD\x38", 128},
    {"\xF4\x8D\xB4\x80", "\xE2\x35\x8C\x36", 128},
    {"\xF4\x8D\xB6\x80", "\xE2\x35\x99\x34", 128},
    {"\xF4\x8D\xB8\x80", "\xE2\x35\xA6\x32", 128},
    {"\xF4\x8D\xBA\x80", "\xE2\x35\xB3\x30", 128},
    {"\xF4\x8D\xBC\x80", "\xE2\x35\xBF\x38", 128},
    {"\xF4\x8D\xBE\x80", "\xE2\x35\xCC\x36", 128},
    {"\xF4\x8E\x80\x80", "\xE2\x35\xD9\x34", 128},
    {"\xF4\x8E\x82\x80", "\xE2\x35\xE6\x32", 128},
    {"\xF4\x8E\x84\x80", "\xE2\x35\xF3\x30", 128},
    {"\xF4\x8E\x86\x80", "\xE2\x36\x81\x38", 128},
    {"\xF4\x8E\x88\x80", "\xE2\x36\x8E\x36", 128},
    {"\xF4\x8E\x8A\x80", "\xE2\x36\x9B\x34", 128},
    {"\xF4\x8E\x8C\x80", "\xE2\x36\xA8\x32", 128},
    {"\xF4\x8E\x8E\x80", "\xE2\x36\xB5\x30", 128},
    {"\xF4\x8E\x90\x80", "\xE2\x36\xC1\x38", 128},
    {"\xF4\x8E\x92\x80", "\xE2\x36\xCE\x36", 128},
    {"\xF4\x8E\x94\x80", "\xE2\x36\xDB\x34", 128},
    {"\xF4\x8E\x96\x80", "\xE2\x36\xE8\x32", 128},
    {"\xF4\x8E\x98\x80", "\xE2\x36\xF5\x30", 128},
    {"\xF4\x8E\x9A\x80", "\xE2\x37\x83\x38", 128},
    {"\xF4\x8E\x9C\x80", "\xE2\x37\x90\x36", 128},
    {"\xF4\x8E\x9E\x80", "\xE2\x37\x9D\x34", 128},
    {"\xF4\x8E\xA0\x80", "\xE2\x37\xAA\x32", 128},
    {"\xF4\x8E\xA2\x80", "\xE2\x37\xB7\x30", 128},
    {"\xF4\x8E\xA4\x80", "\xE2\x37\xC3\x38", 128},
    {"\xF4\x8E\xA6\x80", "\xE2\x37\xD0\x36", 128},
    {"\xF4\x8E\xA8\x80", "\xE2\x37\xDD\x34", 128},
    {"\xF4\x8E\xAA\x80", "\xE2\x37\xEA\x32", 128},
    {"\xF4\x8E\xAC\x80", "\xE2\x37\xF7\x30", 128},
    {"\xF4\x8E\xAE\x80", "\xE2\x38\x85\x38", 128},
    {"\xF4\x8E\xB0\x80", "\xE2\x38\x92\x36", 128},
    {"\xF4\x8E\xB2\x80", "\xE2\x38\x9F\x34", 128},
    {"\xF4\x8E\xB4\x80", "\xE2\x38\xAC\x32", 128},
    {"\xF4\x8E\xB6\x80", "\xE2\x38\xB9\x30", 128},
    {"\xF4\x8E\xB8\x80", "\xE2\x38\xC5\x38", 128},
    {"\xF4\x8E\xBA\x80", "\xE2\x38\xD2\x36", 128},
    {"\xF4\x8E\xBC\x80", "\xE2\x38\xDF\x34", 128},
    {"\xF4\x8E\xBE\x80", "\xE2\x38\xEC\x32", 128},
    {"\xF4\x8F\x80\x80", "\xE2\x38\xF9\x30", 128},
    {"\xF4\x8F\x82\x80", "\xE2\x39\x87\x38", 128},
    {"\xF4\x8F\x84\x80", "\xE2\x39\x94\x36", 128},
    {"\xF4\x8F\x86\x80", "\xE2\x39\xA1\x34", 128},
    {"\xF4\x8F\x88\x80", "\xE2\x39\xAE\x32", 128},
    {"\xF4\x8F\x8A\x80", "\xE2\x39\xBB\x30", 128},
    {"\xF4\x8F\x8C\x80", "\xE2\x39\xC7\x38", 128},
    {"\xF4\x8F\x8E\x80", "\xE2\x39\xD4\x36", 128},
    {"\xF4\x8F\x90\x80", "\xE2\x39\xE1\x34", 128},
    {"\xF4\x8F\x92\x80", "\xE2\x39\xEE\x32", 128},
    {"\xF4\x8F\x94\x80", "\xE2\x39\xFB\x30", 128},
    {"\xF4\x8F\x96\x80", "\xE3\x30\x89\x38", 128},
    {"\xF4\x8F\x98\x80", "\xE3\x30\x96\x36", 128},
    {"\xF4\x8F\x9A\x80", "\xE3\x30\xA3\x34", 128},
    {"\xF4\x8F\x9C\x80", "\xE3\x30\xB0\x32", 128},
    {"\xF4\x8F\x9E\x80", "\xE3\x30\xBD\x30", 128},
    {"\xF4\x8F\xA0\x80", "\xE3\x30\xC9\x38", 128},
    {"\xF4\x8F\xA2\x80", "\xE3\x30\xD6\x36", 128},
    {"\xF4\x8F\xA4\x80", "\xE3\x30\xE3\x34", 128},
    {"\xF4\x8F\xA6\x80", "\xE3\x30\xF0\x32", 128},
    {"\xF4\x8F\xA8\x80", "\xE3\x30\xFD\x30", 128},
    {"\xF4\x8F\xAA\x80", "\xE3\x31\x8B\x38", 128},
    {"\xF4\x8F\xAC\x80", "\xE3\x31\x98\x36", 128},
    {"\xF4\x8F\xAE\x80", "\xE3\x31\xA5\x34", 128},
    {"\xF4\x8F\xB0\x80", "\xE3\x31\xB2\x32", 128},
    {"\xF4\x8F\xB2\x80", "\xE3\x31\xBF\x30", 128},
    {"\xF4\x8F\xB4\x80", "\xE3\x31\xCB\x38", 128},
    {"\xF4\x8F\xB6\x80", "\xE3\x31\xD8\x36", 128},
    {"\xF4\x8F\xB8\x80", "\xE3\x31\xE5\x34", 128},
    {"\xF4\x8F\xBA\x80", "\xE3\x31\xF2\x32", 128},
    {"\xF4\x8F\xBC\x80", "\xE3\x32\x81\x30", 128},
    {"\xF4\x8F\xBE\x80", "\xE3\x32\x8D\x38", 128},
    {"\xF7\xBF\xBF\xBF", "\xFE\x39\xFE\x39", 1}
};

} // namespace apolloron
