/******************************************************************************/
/*! @file msg_ko.cc
    @brief DateTime messages of Korean(generic).
    @author Tachibanamasashi, Apolloron Project.
 ******************************************************************************/

namespace apolloron {

/*
  Date and time messages in UTF-8
  %Y=year, %m=month, %d=day, %H=hour, %M=minute, %S=second,
  %y=year(range 00 to 99),
  %B=the full month name, %b=abbreviated month name,
  %A=the full weekday name, %a=abbreviated week
*/
const char *calendar_msg_ko[][2] = {
  {"YEAR",              "%Y년"},
  {"MONTH",             "%m월"},
  {"YEARMONTH",         "%Y년%m월"},
  {"DAY",               "%d일"},
  {"DATE",              "%Y년%m월%d일"},
  {"DATE_SHORT",        "%y/%m/%d"},
  {"DATE_WDAY",         "%Y년%m월%d일(%a)"},
  {"DATE_SHORT_WDAY",   "%y/%m/%d (%a)"},
  {"MONTHDAY",          "%m월%d일"},
  {"MONTHDAY_WDAY",     "%m월%d일 (%a)"},
  {"MONTHDAY_SHORT",    "%m/%d"},
  {"MONTHDAY_SHORT_WDAY","%m/%d (%a)"},
  {"HOUR",              "%H시"},
  {"MINUTE",            "%M분"},
  {"SECOND",            "%S초"},
  {"WDAY",              "%a"},
  {"WDAY_LONG",         "%A"},
  {"TIME",              "%H시%M분"},
  {"TIME_SEC",          "%H시%M분%S초"},
  {"DATETIME",          "%Y년%m월%d일 %H:%M"},
  {"DATETIME_SEC",      "%Y년%m월%d일 %H:%M:%S"},
  {"DATETIME_WDAY",     "%Y년%m월%d일(%a) %H:%M"},
  {"DATETIME_WDAY_SEC", "%Y년%m월%d일(%a) %H:%M:%S"},
  {"WDAY_SUN",          "일"},
  {"WDAY_MON",          "월"},
  {"WDAY_TUE",          "화"},
  {"WDAY_WED",          "수"},
  {"WDAY_THU",          "목"},
  {"WDAY_FRI",          "금"},
  {"WDAY_SAT",          "토"},
  {"WDAY_SUN_LONG",     "일요일"},
  {"WDAY_MON_LONG",     "월요일"},
  {"WDAY_TUE_LONG",     "화요일"},
  {"WDAY_WED_LONG",     "수요일"},
  {"WDAY_THU_LONG",     "목요일"},
  {"WDAY_FRI_LONG",     "금요일"},
  {"WDAY_SAT_LONG",     "토요일"},
  {"MONTH1",            "1월"},
  {"MONTH2",            "2월"},
  {"MONTH3",            "3월"},
  {"MONTH4",            "4월"},
  {"MONTH5",            "5월"},
  {"MONTH6",            "6월"},
  {"MONTH7",            "7월"},
  {"MONTH8",            "8월"},
  {"MONTH9",            "9월"},
  {"MONTH10",           "10월"},
  {"MONTH11",           "11월"},
  {"MONTH12",           "12월"},
  {"MONTH1_LONG",       "1월"},
  {"MONTH2_LONG",       "2월"},
  {"MONTH3_LONG",       "3월"},
  {"MONTH4_LONG",       "4월"},
  {"MONTH5_LONG",       "5월"},
  {"MONTH6_LONG",       "6월"},
  {"MONTH7_LONG",       "7월"},
  {"MONTH8_LONG",       "8월"},
  {"MONTH9_LONG",       "9월"},
  {"MONTH10_LONG",      "10월"},
  {"MONTH11_LONG",      "11월"},
  {"MONTH12_LONG",      "12월"},
  {(const char*)0,      (const char *)0}
};


} // namespace apolloron
