/******************************************************************************/
/*! @file apolloron_http_client.h
    @brief Header file of libapolloron_http_client.
    @author Tachibanamasashi, Apolloron Project.
    @date 2009-07-28
 ******************************************************************************/

#ifndef _APOLLORON_HTTP_CLIENT_H_
#define _APOLLORON_HTTP_CLIENT_H_

#include "apolloron.h"

namespace apolloron_http_client {

/*! @brief Version of libapolloron_http_client.
 */
#define LIBAPOLLORON_HTTP_CLIENT_VERSION "0.03.0"


/*----------------------------------------------------------------------------*/
/* HTTPClient class                                                           */
/*----------------------------------------------------------------------------*/
/*! @brief Class of HTTP client
 */ 
class HTTPClient {
protected:
  apolloron::String content;
  apolloron::String origCharset;
public:
  HTTPClient();
  virtual ~HTTPClient();

  // Deletion of String instance
  virtual bool clear();

  // get content specified by URL
  virtual apolloron::String& getURL(const apolloron::String &url, long timeout=5);

  // get content original charset 
  virtual apolloron::String& getOrigCharset();
};

} // namespace apolloron_http_client

#endif
