class HashWithIndifferentAccess
	def value_filter_deeply!(p)
		self.each {|key, val|
			if val.class == HashWithIndifferentAccess
				val.value_filter_deeply!(p)
			else
				self[key] = p.call(val)
			end
		}
	end
end

class MobileController < EntriesController
	layout "mobile/layout"

	prepend_before_filter :non_mobile_filter
	before_filter :param_filter

	after_filter :template_set_filter, :except => [:edit_form]
	after_filter :output_code_sjis_filter

	def edit_form
		@entry = Entry.find(@params['id'])
		render_action 'edit_form' # FAKE
	end

	protected
	# redirect to IndexController unless mobile
	def non_mobile_filter
		unless Mobile::is_mobile?(@request.env['HTTP_USER_AGENT'])
			redirect_to :controller => 'index'
		end
	end

	# output charset force convert to sjis
	def output_code_sjis_filter
		@response.body = NKF.nkf('-m0 -Ws', @response.body)
	end

	# convert @params's charset to utf-8
	def param_filter
		if Mobile::is_mobile?(@request.env['HTTP_USER_AGENT'])
			@params.value_filter_deeply!(Proc.new {|x| NKF.nkf('-m0 -Sw', x)})
		end
	end

	def template_set_filter
		unless @performed_redirect
			erase_render_results
			render_action 'index'
		end
	end
end
