require 'rss/maker'
require 'formatter'
require 'cgi'

class FeedController < ApplicationController
	caches_page :rss10
	include Formatter

	def rss10
		rss = RSS::Maker.make("1.0") do |maker|
			maker.channel.about = url_for(:controller => 'feed', :action => 'rss10')
			maker.channel.title = "inamode6 revenge" # FIXME: DRY!
			maker.channel.link = url_for(:controller => 'index', :action => 'index')
			maker.channel.description = "A BBS"

			Entry.find(:all, :limit => 15, :order => 'updated_on DESC').each { |entry|
				item = maker.items.new_item
				item.title = "[#{entry.id}]"
				item.description = entry.body
				item.content_encoded = format(entry.body, true)
				item.date = entry.updated_on
				item.link = url_for(:controller => 'index', :action => 'show', :id => entry.id)
			}

			maker.items.do_sort = true
			maker.items.max_size = 15
		end

		@headers["Content-Type"] = 'application/xml; charset=UTF-8'
		render :text => rss, :layout => false
	end
end

