class ClippingController < ApplicationController
	def clip
		url = @params['url']

		if url.include?(url_for(:controller => 'index', :action => 'index')) or url == 'about:blank'
			redirect_to :controller => 'index', :action => "index"
			return
		end

		body = "#{@params['title']}\n#{url}"
		body += "\n>>\n#{@params['body']}\n<<\n" if @params['body']
		@entry = Entry.new(
			'hostname'       => @request.remote_addr,
			'body'           => body
		)

		if @entry.save
			flash[:notice] = "Entry was successfully created"
			redirect_to :controller => 'index', :action => "index"
		else
			@entries = []
			render 'index/index'
		end
	end
end
