class AjaxController < ApplicationController
	def search
		@pages, @entries = paginate(:entry, :conditions => ['body LIKE CONCAT("%", ?, "%")', @params['keyword']], :per_page => 20, :order_by => 'id DESC')
		render 'index/_entries'
	end

	def random
		@entries = Entry.find(:all, :per_page => 20, :order => 'RAND()')
		render 'index/_entries'
	end

	def show
		# @params[:id] is comma separated numbers.
		@entries = Entry.find(@params[:id].split(',').select {|id| Entry.exists?(id)})
		render 'index/_entries'
	end
end
