/* created on 2007-03-05 by yuto
   sXgR[W̋ȂĐWinampvOC
 */
#define _WIN32_IE 0x0300 // gccł͒`ĂȂ
#include <windows.h>
#include <mmsystem.h>
#include <commctrl.h>
#include "IN2.H"
#include "pxtone.h"
#include "resource.h"

// ~ۂɑ郁bZ[W
#define WM_WA_MPEG_EOF WM_USER+2

#define PLUGIN_LABEL "Pxtone input plugin 0.1"
// init@C̃pX
#define INI_PATH     ".\\in_pxtone.ini"
// ZNVi[***]̕j
#define INI_GRP      "General"

// INI_***: L[
// DEF_***: L[ȂƂ̏l
// MIN_***: L[Ƃl̍ŏl
// MAX_***: L[Ƃl̍ől
#define INI_NCH "ChannelNum"
#define DEF_NCH 2

#define INI_SPS "SampleRate"
#define DEF_SPS 44100

#define INI_BPS "BitPerSample"
#define DEF_BPS 16

#define INI_DSOUND "DirectSound"
#define DEF_DSOUND FALSE

#define INI_BUFF_MSEC "BufferMSec" // INIt@CɂmsIO
#define DEF_BUFF_MSEC 100
#define MIN_BUFF_MSEC 10
#define MAX_BUFF_MSEC 2000

#define INI_FADEOUT "FadeoutTime"
#define DEF_FADEOUT 500
#define MIN_FADEOUT 100
#define MAX_FADEOUT 5000

#define INI_LOOPNUM "LoopNum"
#define DEF_LOOPNUM 0
#define MIN_LOOPNUM 0
#define MAX_LOOPNUM 10

// vg^Cv錾

void config(HWND);
void about(HWND);
void init(void);
void quit(void);
void getfileinfo(char *, char *, int *);
int infoDlg(char *, HWND);
int isourfile(char *);
int play(char *);
void pause(void);
void unpause(void);
int ispaused(void);
void stop(void);
int getlength(void);
int getoutputtime(void);
void setoutputtime(int);
void setvolume(int);
void setpan(int);
void eq_set(int, char *, int);
BOOL CALLBACK ConfigProc(HWND, UINT, WPARAM, LPARAM);
static BOOL InitConfigProc(HWND, HWND, DWORD);
static BOOL CmdConfigProc(HWND, WORD, WORD, HWND);
BOOL CALLBACK AboutProc(HWND, UINT, WPARAM, LPARAM);

// vpeB
BOOL ready;      // pxtoneĂ邩
BOOL played;     // ݍĐ
BOOL paused;     // ꎞ~Ă邩
int length;      // Ȃ̒(~b)
DWORD t_start;   // ĐJni~bj
DWORD t_pause;   // ꎞ~i~bj
long pos_decode; // ꎞ~̃TvOʒu

// [Uݒ\ȃvpeB
int nch;      // 1:m / 2:XeI
int sps;      // TvO[g(11025, 22050, or 44100)
int bps;      // 1Tṽrbg(8 or 16)
BOOL dsound;  // true: directsoundgp, false: wavemappergp
float buff_sec; // Tvobt@̃TCYibj
int fadeout;  // Ȃ̃tF[hAEg
int loopnum;  // 1Ȗ̃[v

// W[
In_Module mod = 
{
  IN_VER,
  PLUGIN_LABEL
#ifdef __alpha
    "(AXP)"
#else
    "(x86)"
#endif
      ,
  0,	// hMainWindow
  0,  // hDllInstance
  "PTCOP;PTTUNE\0pxtone file(*.ptcop;*.pttune)\0",
  
  1, // is_seekable
  0, // uses output
  config,
  about,
  init,
  quit,
  getfileinfo,
  infoDlg,
  isourfile,
  play,
  pause,
  unpause,
  ispaused,
  stop,
  
  getlength,
  getoutputtime,
  setoutputtime,

  setvolume,
  setpan,

  0,0,0,0,0,0,0,0,0, // vis stuff
  0,0, // dsp

  eq_set,

  NULL, // setinfo

  0 // out_mod
};

// Winamp{̂ɃW[n֐
__declspec(dllexport) In_Module *winampGetInModule2()
{
  return &mod;
}

// Gg|Cg(Jnŏ̊֐)
BOOL WINAPI _DllMainCRTStartup(HANDLE hInst, ULONG ul_reason_for_call,
                               LPVOID lpReserved)
{
  return TRUE;
}

void config(HWND hwndParent)
{
  MessageBox(hwndParent, "not yet...", "config", MB_OK);
/*
  HINSTANCE hInstance;
  hInstance = (HINSTANCE)GetWindowLong(hwndParent, GWL_HINSTANCE);
  
  if(DialogBox(hInstance, MAKEINTRESOURCE(IDD_CONFIG),
               hwndParent, (DLGPROC)ConfigProc) == IDOK){
    InvalidateRect(hwndParent, NULL, TRUE);
    UpdateWindow(hwndParent);
  }
//*/
}

void about(HWND hwndParent)
{
  MessageBox(hwndParent, PLUGIN_LABEL, "About", MB_OK);
/*
  INT_PTR ret;
  char msg[256];
  ret = DialogBox((HINSTANCE)GetWindowLong(hwndParent, GWL_HINSTANCE),
                  MAKEINTRESOURCE(10), hwndParent, (DLGPROC)AboutProc);
  
  sprintf(msg, "ret:%ld, error:%ld",
          ret, GetLastError());
  MessageBox(hwndParent, msg, "", MB_OK);
//*/
}

void init()
{
  INITCOMMONCONTROLSEX ic;
  int buff_ms;
  
  length = -1;
  played = FALSE;
  paused = FALSE;
  
  nch = GetPrivateProfileInt(INI_GRP, INI_NCH, DEF_NCH, INI_PATH);
  if(nch != 1 && nch != 2) nch = DEF_NCH;
  
  sps = GetPrivateProfileInt(INI_GRP, INI_SPS, DEF_SPS, INI_PATH);
  if(sps != 11025 && sps != 22050 && sps != 44100) sps = DEF_SPS;
  
  bps = GetPrivateProfileInt(INI_GRP, INI_BPS, DEF_BPS, INI_PATH);
  if(bps != 8 && bps != 16) bps = DEF_BPS;
  
  dsound = (BOOL)GetPrivateProfileInt(INI_GRP, INI_DSOUND,
                                      DEF_DSOUND, INI_PATH);
  
  buff_ms = GetPrivateProfileInt(INI_GRP, INI_BUFF_MSEC,
                                 DEF_BUFF_MSEC, INI_PATH);
  if(buff_ms < MIN_BUFF_MSEC || buff_ms > MAX_BUFF_MSEC){
    buff_ms = DEF_BUFF_MSEC;
  }
  buff_sec = buff_ms / 1000.0;
  
  fadeout = GetPrivateProfileInt(INI_GRP, INI_FADEOUT,
                                 DEF_FADEOUT, INI_PATH);
  if(fadeout < MIN_FADEOUT || fadeout > MAX_FADEOUT){
    fadeout = DEF_FADEOUT;
  }

  loopnum = GetPrivateProfileInt(INI_GRP, INI_LOOPNUM,
                                 DEF_LOOPNUM, INI_PATH);
  if(loopnum < MIN_LOOPNUM || loopnum > MAX_LOOPNUM){
    loopnum = DEF_LOOPNUM;
  }
  
  // pxtonȅ
  ready = pxtone_Ready(NULL, nch, sps, bps, buff_sec, FALSE, NULL);
  if(!ready){
    MessageBox(NULL,"sXgR[W̏s", "Error", MB_OK);
  }

  // gbNo[̗p
  ic.dwSize = sizeof(INITCOMMONCONTROLSEX);
  ic.dwICC = ICC_BAR_CLASSES;
  InitCommonControlsEx(&ic);
}

void quit()
{
  char str[64];

  if(played) pxtone_Tune_Stop();
  // pxtonẻ
  if(ready && !pxtone_Release()){
    MessageBox(NULL,"sXgR[W̉s", "Error", MB_OK);
  }
  ready = FALSE;
  
  sprintf(str, "%d", nch);
  WritePrivateProfileString(INI_GRP, INI_NCH, str, INI_PATH);
  sprintf(str, "%d", sps);
  WritePrivateProfileString(INI_GRP, INI_SPS, str, INI_PATH);
  sprintf(str, "%d", bps);
  WritePrivateProfileString(INI_GRP, INI_BPS, str, INI_PATH);
  sprintf(str, "%d", dsound);
  WritePrivateProfileString(INI_GRP, INI_DSOUND, str, INI_PATH);
  sprintf(str, "%d", (int)(buff_sec*1000));
  WritePrivateProfileString(INI_GRP, INI_BUFF_MSEC, str, INI_PATH);
  sprintf(str, "%d", fadeout);
  WritePrivateProfileString(INI_GRP, INI_FADEOUT, str, INI_PATH);
  sprintf(str, "%d", loopnum);
  WritePrivateProfileString(INI_GRP, INI_LOOPNUM, str, INI_PATH);
}

void getfileinfo(char *filename, char *title, int *length_in_ms)
{
  if (!filename || !*filename){
    // t@CpXȂȂ猻݂̋ȏ擾
    if(length_in_ms) *length_in_ms = getlength();
    if(title)        strcpy(title, pxtone_Tune_GetName());
    
  }else if(!played){
    // Ȃ炻̑̋ȁBݍĐłȂΎ擾
    if(!ready && pxtone_Ready(NULL, nch, sps, bps, 0, FALSE, NULL)){
      return;
    }
    // Ȃǂݍ
    if(!pxtone_Tune_Load(NULL, NULL, filename)) return;
    
    if(length_in_ms) *length_in_ms = getlength();
    if(title && pxtone_Tune_GetName()){
      strcpy(title, pxtone_Tune_GetName());
    }
    
    if(!ready) pxtone_Release();
  }
}

int infoDlg(char *fn, HWND hwnd)
{
  char msg[256] = "";
  
  // t@C
  char *p=fn+strlen(fn);
  while (*p != '\\' && p >= fn) p--;
  strcpy(msg,++p);
  
  if(!played){
    // ݍĐłȂΊeȏ擾
    long bn, bc, mn;
    float bt;
    
    if(!ready &&
       pxtone_Ready(NULL, nch, sps, bps, buff_sec, FALSE, NULL)){
      return 1;
    }
    if(!pxtone_Tune_Load(NULL, NULL, fn)) return 1;

    if(pxtone_Tune_GetName()){
      sprintf(msg, "%s\nname: %s", msg, pxtone_Tune_GetName());
    }
    if(pxtone_Tune_GetComment()){
      sprintf(msg, "%s\ncomment:\n%s", msg, pxtone_Tune_GetComment());
    }
    pxtone_Tune_GetInformation(&bn, &bt, &bc, &mn);
    sprintf(msg, "%s\n\n%.2f sec.\nbeat: %ld\ntempo: %.0f\nmeas: %ld\n",
            msg, bn*mn/bt*60, bn, bt, mn);
    
    if(!ready) pxtone_Release();
    
  }else{
    // ĐȂAiEX
    strcat(msg, "\n\nYou must stop music if you want more info.");
  }
  
  MessageBox(hwnd, msg, "Info.", MB_OK);
  return 0;
}

int isourfile(char *fn)
{
  return 0;
}

int play(char *fn)
{
  if(!ready){
    MessageBox(NULL, "sXgR[WĂ܂",
               "Error", MB_OK);
    return 1;
  }
  
  // Ȃ̓ǂݍ
  if(!pxtone_Tune_Load(NULL, NULL, fn)){
    MessageBox(NULL, "t@C[hł܂", "Error", MB_OK);
    return 1;
  }
  // [viloopnum==0łtF[hAEg߂j
  pxtone_Tune_SetLoop(TRUE);
  
  // Đ
  if(!pxtone_Tune_Start(0, 0)){
    MessageBox(NULL, "Đł܂", "Error", MB_OK);
    return 1;
  }
  t_start = timeGetTime(); // Đ̎擾 // ̂ăoJۂ
  length = -1;             // Ȃ̒
  played = TRUE;
  paused = FALSE;
  pos_decode = 0;

  // Ȃ̃TvO[g̏
  mod.SetInfo((sps*bps*nch)/1000, sps/1000, nch, 1);

  // VISsgpǏ
  mod.SAVSAInit(0, sps);
  mod.VSASetInfo(sps, nch);

  return 0;
}

void pause()
{
  pos_decode = pxtone_Tune_Stop(); // ꎞ~
  t_pause =timeGetTime();          // ꎞ~̎擾
  paused = TRUE;
}

void unpause()
{
  DWORD t_cur;
  
  pxtone_Tune_Start(pos_decode, 0); // ĊJ
  // ~ԂJnx点
  t_cur = timeGetTime();
  t_start += t_cur - t_pause;
  paused = FALSE;
}

int ispaused()
{
  return paused;
}

void stop()
{
  // ܂~ĂȂȂtF[hAEgŒ~
  if(played) pxtone_Tune_Fadeout(fadeout);
  played = FALSE;
  paused = FALSE;
}


int getlength()
{
  int len_local;
  long bnum, bclock, mnum, mlast, mrepeat;
  float btempo;
  
  // r[gAr[ge|Ar[gNbNAߐ̎擾
  pxtone_Tune_GetInformation(&bnum, &btempo, &bclock, &mnum);
  // P̋Ȃ̒(ms)
  len_local = (int)(bnum * mnum / btempo * 60000);
  
  if(loopnum == 0){
    // [vȂ
    length = len_local + fadeout;
    
  }else{
    // [v
    mlast = pxtone_Tune_GetPlayMeas();     // I
    mrepeat = pxtone_Tune_GetRepeatMeas(); // s[gJn
    length = len_local + len_local/mnum * (mlast-mrepeat+1) * loopnum
      + fadeout;
  }
  return length;
}

int getoutputtime()
{
  if(!paused){
    // Đ
    DWORD t_cur, t_o;
    t_cur = timeGetTime();
    t_o = t_cur - t_start;
    
    if(pos_decode >= 0 && t_o > length){
      // tF[hAEgȂȂI
      pos_decode = -1;
      PostMessage(mod.hMainWindow, WM_WA_MPEG_EOF,0,0);
      
    }else if(played && t_o >= length - fadeout){
      // IĂāA܂ĐłȂtF[hAEgJn
      played = FALSE;
      pos_decode = pxtone_Tune_Fadeout(fadeout);
    }
    
    return t_o;
    
  }else{
    // ꎞ~
    return (t_pause - t_start);
  }
}

void setoutputtime(int time_in_ms)
{
  DWORD t_cur;

  // Đʒu = (ms) ~ TvO[g(Hz) / 1000
  pos_decode = time_in_ms * sps / 1000;
  t_cur = timeGetTime();
  t_start = t_cur - time_in_ms;
  
  if(paused){
    // |[Y悤ɂ
    t_pause = t_cur;
    
  }else{
    // ~ĎwʒuĐ
    pxtone_Tune_Stop();
    pxtone_Tune_Start(pos_decode, 0);
  }
}

void setvolume(int volume)
{
  // volume0~255
  pxtone_Tune_SetVolume(volume/255.0);
}
void setpan(int pan)
{
  // p݂͌̕@ł͐łȂ
}

void eq_set(int on, char data[10], int preamp)
{
}

// ݒ_CAO
BOOL CALLBACK ConfigProc(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam)
{
/*
  WORD wID;
  int value;
  char label[64];

  switch(msg){
  case WM_INITDIALOG:
    return InitConfigProc(hwnd, (HWND)wparam, (DWORD)lparam);
    
  case WM_COMMAND:
    return  CmdConfigProc(hwnd, HIWORD(wparam), LOWORD(wparam), (HWND)lparam);
    
  case WM_HSCROLL:
    wID = LOWORD(wparam);
    value = SendMessage((HWND)lparam, TBM_GETPOS, 0L, 0L);

    if(wID == IDC_FADEOUT){
      sprintf(label, "fadeout time: %d", value);
      SetDlgItemText(hwnd, IDC_FADEOUT_LABEL, label);

    }else if(wID == IDC_LOOPNUM){
      sprintf(label, "loop: %d", value);
      SetDlgItemText(hwnd, IDC_LOOPNUM_LABEL, label);
    }
    
    return TRUE;
  }
//*/
  return  FALSE;
}

// ݒ_CAO - 
static BOOL InitConfigProc(HWND hwnd, HWND hwndFc, DWORD param)
{
/*
  int i;
  int quality = -1;
  char *dsound_str[] = {"WaveMapper", "DirectSound"};
  
  // QUALITY
  if(sps == 44100 && bps == 16)     quality = 0;
  else if(sps == 22050 && bps == 8) quality = 1;
  else if(sps == 11025 && bps == 8) quality = 2;
  SendMessage(GetDlgItem(hwnd, IDC_QUALITY0), BM_SETCHECK,
              (quality==0 ? 1L : 0L), 0L);
  SendMessage(GetDlgItem(hwnd, IDC_QUALITY1), BM_SETCHECK,
              (quality==1 ? 1L : 0L), 0L);
  SendMessage(GetDlgItem(hwnd, IDC_QUALITY2), BM_SETCHECK,
              (quality==2 ? 1L : 0L), 0L);
  
  // DSOUND
  for(i=0; i<=2; i++)
    SendMessage(GetDlgItem(hwnd, IDC_DSOUND), CB_INSERTSTRING,
                (WPARAM)i, (LPARAM)dsound_str[i]);
  SendMessage(GetDlgItem(hwnd, IDC_DSOUND), CB_SETCURSEL,
              (dsound ? 1L : 0L), 0L);

  // FADEOUT TIME
  SendMessage(GetDlgItem(hwnd, IDC_FADEOUT), TBM_SETRANGE, 0,
              MAKELPARAM(MIN_FADEOUT, MAX_FADEOUT));
  SendMessage(GetDlgItem(hwnd, IDC_FADEOUT), TBM_SETLINESIZE,
              0L, (LPARAM)100);
  SendMessage(GetDlgItem(hwnd, IDC_FADEOUT), TBM_SETPAGESIZE,
              0L, (LPARAM)500);
  SendMessage(GetDlgItem(hwnd, IDC_FADEOUT), TBM_SETPOS,
              1L, (LPARAM)fadeout);

  // LOOP NUM
  SendMessage(GetDlgItem(hwnd, IDC_LOOPNUM), TBM_SETRANGE, 0,
              MAKELPARAM(MIN_LOOPNUM, MAX_LOOPNUM));
  SendMessage(GetDlgItem(hwnd, IDC_LOOPNUM), TBM_SETLINESIZE,
              0L, (LPARAM)1);
  SendMessage(GetDlgItem(hwnd, IDC_LOOPNUM), TBM_SETPAGESIZE,
              0L, (LPARAM)2);
  SendMessage(GetDlgItem(hwnd, IDC_LOOPNUM), TBM_SETPOS,
              1L, (LPARAM)loopnum);
  
//*/
  return  TRUE;
}

// ݒ_CAO - R}h
static BOOL CmdConfigProc(HWND hwnd, WORD wNotifyCode, WORD wID, HWND hwndCt)
{
/*
  char str[64];
  
  switch(wID){
  case IDC_CONFIG_OK:
    // QUALITY
    if(SendMessage(GetDlgItem(hwnd, IDC_QUALITY0),
                   BM_GETCHECK, 0L, 0L)){
      sps == 44100;
      bps == 16;
      
    }else if(SendMessage(GetDlgItem(hwnd, IDC_QUALITY1),
                         BM_GETCHECK, 0L, 0L)){
      sps == 22050;
      bps == 8;
      
    }else if(SendMessage(GetDlgItem(hwnd, IDC_QUALITY2),
                         BM_GETCHECK, 0L, 0L)){
      sps == 11025;
      bps == 8;
    }
    
    // DSOUND
    int dsound_temp;
    dsound_temp = SendMessage(GetDlgItem(hwnd, IDC_DSOUND),
                              CB_GETCURSEL, 0, 0);
    if(dsound_temp != -1) dsound = dsound_temp;
    
    // FADEOUT TIME
    fadeout = SendMessage(GetDlgItem(hwnd, IDC_FADEOUT),
                          TBM_GETPOS, 0L, 0L);
    
    // LOOP NUM
    loopnum = SendMessage(GetDlgItem(hwnd, IDC_LOOPNUM),
                          TBM_GETPOS, 0L, 0L);
    
    sprintf(str, "%d", nch);
    WritePrivateProfileString(INI_GRP, INI_NCH, str, INI_PATH);
    sprintf(str, "%d", sps);
    WritePrivateProfileString(INI_GRP, INI_SPS, str, INI_PATH);
    sprintf(str, "%d", bps);
    WritePrivateProfileString(INI_GRP, INI_BPS, str, INI_PATH);
    sprintf(str, "%d", dsound);
    WritePrivateProfileString(INI_GRP, INI_DSOUND, str, INI_PATH);
    sprintf(str, "%d", (int)(buff_sec*1000));
    WritePrivateProfileString(INI_GRP, INI_BUFF_MSEC, str, INI_PATH);
    sprintf(str, "%d", fadeout);
    WritePrivateProfileString(INI_GRP, INI_FADEOUT, str, INI_PATH);
    sprintf(str, "%d", loopnum);
    WritePrivateProfileString(INI_GRP, INI_LOOPNUM, str, INI_PATH);
    
    EndDialog(hwnd, IDOK);
    break;
    
  case IDC_CONFIG_CANCEL:
    EndDialog(hwnd, IDCANCEL);
    break;
  }
  
//*/
  return  TRUE;
}

/* o[W_CAO */
BOOL CALLBACK AboutProc(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam)
{
/*
  static HBITMAP hBitmap;
  BITMAP bitmap;
  HDC hdc , hBuffer;
  PAINTSTRUCT ps;
  int w, h;
  char label[256];
  
  switch(msg){
  case WM_INITDIALOG:
    hBitmap = LoadBitmap((HINSTANCE)GetWindowLong(hwnd, GWL_HINSTANCE),
                         MAKEINTRESOURCE(IDI_PXTONE_LOGO));
    sprintf(label, "%s by yuto\npxtone.dll by pixel", PLUGIN_LABEL);
    SetWindowText(GetDlgItem(hwnd, IDC_ABOUT_LABEL), label);
    return TRUE;
    
  case WM_COMMAND:
    if(LOWORD(wparam) == IDC_ABOUT_OK) EndDialog(hwnd, IDOK);
    return  TRUE;
    
  case WM_PAINT:
    hdc = BeginPaint(hwnd , &ps);
    hBuffer = CreateCompatibleDC(hdc);
    SelectObject(hBuffer , hBitmap);
    GetObject(hBitmap, sizeof(BITMAP), &bitmap);
    w = (int)bitmap.bmWidth;
    h = (int)bitmap.bmHeight;
    
    BitBlt(hdc, 5, 44, w, h, hBuffer, 0, 0, SRCCOPY);
    DeleteDC(hBuffer);
    EndPaint(hwnd , &ps);
    return TRUE;
  }
//*/
  return  FALSE;
}
